/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmpp;

import java.io.IOException;
import java.util.Iterator;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.xmpp.XmppBinding;
import org.apache.camel.component.xmpp.XmppComponent;
import org.apache.camel.component.xmpp.XmppConsumer;
import org.apache.camel.component.xmpp.XmppGroupChatProducer;
import org.apache.camel.component.xmpp.XmppLogger;
import org.apache.camel.component.xmpp.XmppMessage;
import org.apache.camel.component.xmpp.XmppPrivateChatProducer;
import org.apache.camel.component.xmpp.XmppPubSubProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultHeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="xmpp", title="XMPP", syntax="xmpp:host:port/participant", consumerClass=XmppConsumer.class, label="chat,messaging")
public class XmppEndpoint
extends DefaultEndpoint
implements HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(XmppEndpoint.class);
    private XMPPConnection connection;
    private XmppBinding binding;
    private HeaderFilterStrategy headerFilterStrategy = new DefaultHeaderFilterStrategy();
    @UriPath
    @Metadata(required="true")
    private String host;
    @UriPath
    @Metadata(required="true")
    private int port;
    @UriPath
    private String participant;
    @UriParam
    private String user;
    @UriParam
    private String password;
    @UriParam(defaultValue="Camel")
    private String resource = "Camel";
    @UriParam(defaultValue="true")
    private boolean login = true;
    @UriParam
    private boolean createAccount;
    @UriParam
    private String room;
    @UriParam
    private String nickname;
    @UriParam
    private String serviceName;
    @UriParam
    private boolean pubsub;
    @UriParam
    private boolean doc;
    @UriParam(defaultValue="true")
    private boolean testConnectionOnStartup = true;
    @UriParam(defaultValue="10")
    private int connectionPollDelay = 10;

    public XmppEndpoint() {
    }

    public XmppEndpoint(String uri, XmppComponent component) {
        super(uri, (Component)component);
    }

    @Deprecated
    public XmppEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public Producer createProducer() throws Exception {
        if (this.room != null) {
            return this.createGroupChatProducer();
        }
        if (this.isPubsub()) {
            return this.createPubSubProducer();
        }
        if (this.getParticipant() == null) {
            throw new IllegalArgumentException("No room or participant configured on this endpoint: " + (Object)((Object)this));
        }
        return this.createPrivateChatProducer(this.getParticipant());
    }

    public Producer createGroupChatProducer() throws Exception {
        return new XmppGroupChatProducer(this);
    }

    public Producer createPrivateChatProducer(String participant) throws Exception {
        return new XmppPrivateChatProducer(this, participant);
    }

    public Producer createPubSubProducer() throws Exception {
        return new XmppPubSubProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        XmppConsumer answer = new XmppConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Exchange createExchange(ExchangePattern pattern) {
        return this.createExchange(pattern, null);
    }

    public Exchange createExchange(Packet packet) {
        return this.createExchange(this.getExchangePattern(), packet);
    }

    private Exchange createExchange(ExchangePattern pattern, Packet packet) {
        DefaultExchange exchange = new DefaultExchange((Endpoint)this, this.getExchangePattern());
        exchange.setProperty("CamelBinding", (Object)this.getBinding());
        exchange.setIn((Message)new XmppMessage(packet));
        return exchange;
    }

    protected String createEndpointUri() {
        return "xmpp://" + this.host + ":" + this.port + "/" + this.getParticipant() + "?serviceName=" + this.serviceName;
    }

    public boolean isSingleton() {
        return true;
    }

    public synchronized XMPPConnection createConnection() throws XMPPException, SmackException, IOException {
        if (this.connection != null && this.connection.isConnected()) {
            return this.connection;
        }
        if (this.connection == null) {
            this.connection = this.createConnectionInternal();
        }
        this.connection.connect();
        this.connection.addPacketListener((PacketListener)new XmppLogger("INBOUND"), new PacketFilter(){

            public boolean accept(Packet packet) {
                return true;
            }
        });
        this.connection.addPacketSendingListener((PacketListener)new XmppLogger("OUTBOUND"), new PacketFilter(){

            public boolean accept(Packet packet) {
                return true;
            }
        });
        if (!this.connection.isAuthenticated()) {
            if (this.user != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Logging in to XMPP as user: {} on connection: {}", (Object)this.user, (Object)XmppEndpoint.getConnectionMessage(this.connection));
                }
                if (this.password == null) {
                    LOG.warn("No password configured for user: {} on connection: {}", (Object)this.user, (Object)XmppEndpoint.getConnectionMessage(this.connection));
                }
                if (this.createAccount) {
                    AccountManager accountManager = AccountManager.getInstance((XMPPConnection)this.connection);
                    accountManager.createAccount(this.user, this.password);
                }
                if (this.login) {
                    if (this.resource != null) {
                        this.connection.login(this.user, this.password, this.resource);
                    } else {
                        this.connection.login(this.user, this.password);
                    }
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Logging in anonymously to XMPP on connection: {}", (Object)XmppEndpoint.getConnectionMessage(this.connection));
                }
                this.connection.loginAnonymously();
            }
        }
        return this.connection;
    }

    private XMPPTCPConnection createConnectionInternal() {
        if (this.port == 0) {
            this.port = 5222;
        }
        String sName = this.getServiceName() == null ? this.host : this.getServiceName();
        ConnectionConfiguration conf = new ConnectionConfiguration(this.host, this.port, sName);
        return new XMPPTCPConnection(conf);
    }

    public String resolveRoom(XMPPConnection connection) throws XMPPException, SmackException {
        ObjectHelper.notEmpty((String)this.room, (String)"room");
        if (this.room.indexOf(64, 0) != -1) {
            return this.room;
        }
        Iterator iterator = MultiUserChat.getServiceNames((XMPPConnection)connection).iterator();
        if (!iterator.hasNext()) {
            throw new XMPPException.XMPPErrorException("Cannot find Multi User Chat service", new XMPPError(new XMPPError.Condition("Cannot find Multi User Chat service on connection: " + XmppEndpoint.getConnectionMessage(connection))));
        }
        String chatServer = (String)iterator.next();
        LOG.debug("Detected chat server: {}", (Object)chatServer);
        return this.room + "@" + chatServer;
    }

    public String getConnectionDescription() {
        return this.host + ":" + this.port + "/" + this.serviceName;
    }

    public static String getConnectionMessage(XMPPConnection connection) {
        return connection.getHost() + ":" + connection.getPort() + "/" + connection.getServiceName();
    }

    public String getChatId() {
        return "Chat:" + this.getParticipant() + ":" + this.getUser();
    }

    public XmppBinding getBinding() {
        if (this.binding == null) {
            this.binding = new XmppBinding(this.headerFilterStrategy);
        }
        return this.binding;
    }

    public void setBinding(XmppBinding binding) {
        this.binding = binding;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public boolean isLogin() {
        return this.login;
    }

    public void setLogin(boolean login) {
        this.login = login;
    }

    public boolean isCreateAccount() {
        return this.createAccount;
    }

    public void setCreateAccount(boolean createAccount) {
        this.createAccount = createAccount;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public String getParticipant() {
        return this.participant != null ? this.participant : this.user;
    }

    public void setParticipant(String participant) {
        this.participant = participant;
    }

    public String getNickname() {
        return this.nickname != null ? this.nickname : this.getUser();
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public boolean isTestConnectionOnStartup() {
        return this.testConnectionOnStartup;
    }

    public void setTestConnectionOnStartup(boolean testConnectionOnStartup) {
        this.testConnectionOnStartup = testConnectionOnStartup;
    }

    public int getConnectionPollDelay() {
        return this.connectionPollDelay;
    }

    public void setConnectionPollDelay(int connectionPollDelay) {
        this.connectionPollDelay = connectionPollDelay;
    }

    public void setPubsub(boolean pubsub) {
        this.pubsub = pubsub;
        if (pubsub) {
            this.setDoc(true);
        }
    }

    public boolean isPubsub() {
        return this.pubsub;
    }

    public void setDoc(boolean doc) {
        this.doc = doc;
    }

    public boolean isDoc() {
        return this.doc;
    }

    protected void doStop() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
        this.connection = null;
        this.binding = null;
    }
}

