/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.camel.component.http.HttpConsumer;
import org.apache.camel.component.http.HttpServletResolveConsumerStrategy;

public class ServletRestServletResolveConsumerStrategy
extends HttpServletResolveConsumerStrategy {
    public HttpConsumer resolve(HttpServletRequest request, Map<String, HttpConsumer> consumers) {
        String consumerPath;
        HttpConsumer answer = null;
        String path = request.getPathInfo();
        if (path == null) {
            return null;
        }
        String method = request.getMethod();
        if (method == null) {
            return null;
        }
        ArrayList<HttpConsumer> candidates = new ArrayList<HttpConsumer>();
        for (Map.Entry<String, HttpConsumer> entry : consumers.entrySet()) {
            String restrict = entry.getValue().getEndpoint().getHttpMethodRestrict();
            if (!this.matchRestMethod(method, restrict)) continue;
            candidates.add(entry.getValue());
        }
        for (HttpConsumer consumer : candidates) {
            consumerPath = consumer.getPath();
            if (!this.matchRestPath(path, consumerPath, false)) continue;
            answer = consumer;
            break;
        }
        if (answer == null) {
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                HttpConsumer consumer;
                consumer = (HttpConsumer)it.next();
                consumerPath = consumer.getPath();
                if (this.matchRestPath(path, consumerPath, true)) continue;
                it.remove();
            }
            int bestWildcard = Integer.MAX_VALUE;
            HttpConsumer best = null;
            if (candidates.size() > 1) {
                for (HttpConsumer entry : candidates) {
                    String consumerPath2 = entry.getPath();
                    int wildcards = this.countWildcards(consumerPath2);
                    if (wildcards <= 0 || best != null && wildcards >= bestWildcard) continue;
                    best = entry;
                    bestWildcard = wildcards;
                }
                if (best != null) {
                    answer = best;
                }
            }
            if (answer == null && candidates.size() == 1) {
                answer = (HttpConsumer)candidates.get(0);
            }
        }
        if (answer == null) {
            answer = super.resolve(request, consumers);
        }
        return answer;
    }

    public boolean matchRestPath(String requestPath, String consumerPath, boolean wildcard) {
        String[] consumerPaths;
        String[] requestPaths;
        if (requestPath.startsWith("/")) {
            requestPath = requestPath.substring(1);
        }
        if (requestPath.endsWith("/")) {
            requestPath = requestPath.substring(0, requestPath.length() - 1);
        }
        if (consumerPath.startsWith("/")) {
            consumerPath = consumerPath.substring(1);
        }
        if (consumerPath.endsWith("/")) {
            consumerPath = consumerPath.substring(0, consumerPath.length() - 1);
        }
        if ((requestPaths = requestPath.split("/")).length != (consumerPaths = consumerPath.split("/")).length) {
            return false;
        }
        for (int i = 0; i < requestPaths.length; ++i) {
            String p1 = requestPaths[i];
            String p2 = consumerPaths[i];
            if (wildcard && p2.startsWith("{") && p2.endsWith("}") || p1.equals(p2)) continue;
            return false;
        }
        return true;
    }

    public int countWildcards(String consumerPath) {
        String[] consumerPaths;
        int wildcards = 0;
        if (consumerPath.startsWith("/")) {
            consumerPath = consumerPath.substring(1);
        }
        if (consumerPath.endsWith("/")) {
            consumerPath = consumerPath.substring(0, consumerPath.length() - 1);
        }
        for (String p2 : consumerPaths = consumerPath.split("/")) {
            if (!p2.startsWith("{") || !p2.endsWith("}")) continue;
            ++wildcards;
        }
        return wildcards;
    }

    public boolean matchRestMethod(String method, String restrict) {
        if (restrict == null) {
            return true;
        }
        if ("OPTIONS".equals(method)) {
            return true;
        }
        return restrict.toLowerCase(Locale.US).contains(method.toLowerCase(Locale.US));
    }
}

