/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty8;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeTimedOutException;
import org.apache.camel.component.jetty.JettyContentExchange;
import org.apache.camel.component.jetty.JettyHttpBinding;
import org.apache.camel.component.jetty8.CamelRedirectListener;
import org.apache.camel.util.IOHelper;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpEventListener;
import org.eclipse.jetty.client.HttpEventListenerWrapper;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyContentExchange8
implements JettyContentExchange {
    private static final Logger LOG = LoggerFactory.getLogger(JettyContentExchange8.class);
    private volatile Exchange exchange;
    private volatile AsyncCallback callback;
    private volatile JettyHttpBinding jettyBinding;
    private volatile HttpClient client;
    private final CountDownLatch done = new CountDownLatch(1);
    private final ContentExchange ce = new ContentExchange(true);

    public void init(Exchange exchange, JettyHttpBinding jettyBinding, HttpClient client, AsyncCallback callback) {
        this.exchange = exchange;
        this.jettyBinding = jettyBinding;
        this.client = client;
        this.callback = callback;
        HttpEventListener old = this.ce.getEventListener();
        this.ce.setEventListener((HttpEventListener)new HttpEventListenerWrapper(old, true){

            public void onRequestComplete() throws IOException {
                JettyContentExchange8.this.onRequestComplete();
                super.onRequestComplete();
            }

            public void onResponseComplete() throws IOException {
                super.onResponseComplete();
                JettyContentExchange8.this.onResponseComplete();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onConnectionFailed(Throwable ex) {
                try {
                    super.onConnectionFailed(ex);
                }
                finally {
                    JettyContentExchange8.this.onConnectionFailed(ex);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onException(Throwable ex) {
                try {
                    super.onException(ex);
                }
                finally {
                    JettyContentExchange8.this.onException(ex);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onExpire() {
                try {
                    super.onExpire();
                }
                finally {
                    JettyContentExchange8.this.onExpire();
                }
            }
        });
    }

    protected void onRequestComplete() throws IOException {
        LOG.trace("onRequestComplete");
        this.closeRequestContentSource();
    }

    protected void onResponseComplete() throws IOException {
        LOG.trace("onResponseComplete");
        this.doTaskCompleted();
    }

    protected void onExpire() {
        LOG.trace("onExpire");
        this.closeRequestContentSource();
        this.doTaskCompleted();
    }

    protected void onException(Throwable ex) {
        LOG.trace("onException {}", ex);
        this.closeRequestContentSource();
        this.doTaskCompleted(ex);
    }

    protected void onConnectionFailed(Throwable ex) {
        LOG.trace("onConnectionFailed {}", ex);
        this.closeRequestContentSource();
        this.doTaskCompleted(ex);
    }

    public byte[] getBody() {
        return this.ce.getResponseContentBytes();
    }

    public String getUrl() {
        String params = this.ce.getRequestFields().getStringField("Content-Encoding");
        return this.ce.getScheme() + "://" + this.ce.getAddress().toString() + this.ce.getRequestURI() + (params != null ? "?" + params : "");
    }

    protected void closeRequestContentSource() {
        InputStream is = this.ce.getRequestContentSource();
        if (is != null) {
            IOHelper.close((Closeable)is, (String)"RequestContentSource", (Logger)LOG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTaskCompleted() {
        this.done.countDown();
        if (this.callback == null) {
            return;
        }
        int exchangeState = this.ce.getStatus();
        if (LOG.isDebugEnabled()) {
            LOG.debug("TaskComplete with state {} for url: {}", (Object)exchangeState, (Object)this.getUrl());
        }
        try {
            if (exchangeState == 7) {
                try {
                    this.jettyBinding.populateResponse(this.exchange, (JettyContentExchange)this);
                }
                catch (Exception e) {
                    this.exchange.setException((Throwable)e);
                }
            } else if (exchangeState == 8) {
                this.exchange.setException((Throwable)new ExchangeTimedOutException(this.exchange, this.client.getTimeout()));
            } else if (this.exchange.getException() != null) {
                this.exchange.setException((Throwable)new CamelExchangeException("JettyClient failed with state " + exchangeState, this.exchange, (Throwable)this.exchange.getException()));
            }
        }
        finally {
            this.callback.done(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTaskCompleted(Throwable ex) {
        try {
            this.exchange.setException((Throwable)new CamelExchangeException("JettyClient failed cause by: " + ex.getMessage(), this.exchange, ex));
        }
        finally {
            this.done.countDown();
        }
        if (this.callback != null) {
            this.callback.done(false);
        }
    }

    public void setRequestContentType(String contentType) {
        this.ce.setRequestContentType(contentType);
    }

    public int getResponseStatus() {
        return this.ce.getResponseStatus();
    }

    public void setMethod(String method) {
        this.ce.setMethod(method);
    }

    public void setURL(String url) {
        this.ce.setURL(url);
    }

    public void setRequestContent(byte[] byteArray) {
        this.ce.setRequestContent((Buffer)new ByteArrayBuffer(byteArray));
    }

    public void setRequestContent(String data, String charset) throws UnsupportedEncodingException {
        if (charset == null) {
            this.ce.setRequestContent((Buffer)new ByteArrayBuffer(data));
        } else {
            this.ce.setRequestContent((Buffer)new ByteArrayBuffer(data, charset));
        }
    }

    public void setRequestContent(InputStream ins) {
        this.ce.setRequestContentSource(ins);
    }

    public void addRequestHeader(String key, String s) {
        this.ce.addRequestHeader(key, s);
    }

    public void send(HttpClient client) throws IOException {
        client.send((HttpExchange)this.ce);
    }

    public byte[] getResponseContentBytes() {
        return this.ce.getResponseContentBytes();
    }

    public Map<String, Collection<String>> getResponseHeaders() {
        HttpFields f = this.ce.getResponseFields();
        TreeMap<String, Collection<String>> ret = new TreeMap<String, Collection<String>>(String.CASE_INSENSITIVE_ORDER);
        for (String n : f.getFieldNamesCollection()) {
            ret.put(n, f.getValuesCollection(n));
        }
        return ret;
    }

    public void setTimeout(long timeout) {
        this.client.setTimeout(timeout);
        this.ce.setTimeout(timeout);
    }

    public void setSupportRedirect(boolean supportRedirect) {
        LinkedList listeners = this.client.getRegisteredListeners();
        if (listeners == null || !listeners.contains(CamelRedirectListener.class.getName())) {
            this.client.registerListener(CamelRedirectListener.class.getName());
        }
    }
}

