/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.linkedin;

import java.util.Arrays;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.linkedin.LinkedInComponent;
import org.apache.camel.component.linkedin.LinkedInConfiguration;
import org.apache.camel.component.linkedin.LinkedInConsumer;
import org.apache.camel.component.linkedin.LinkedInProducer;
import org.apache.camel.component.linkedin.api.CommentsResource;
import org.apache.camel.component.linkedin.api.CompaniesResource;
import org.apache.camel.component.linkedin.api.EnumQueryParamConverterProvider;
import org.apache.camel.component.linkedin.api.GroupsResource;
import org.apache.camel.component.linkedin.api.JobsResource;
import org.apache.camel.component.linkedin.api.LinkedInOAuthRequestFilter;
import org.apache.camel.component.linkedin.api.PeopleResource;
import org.apache.camel.component.linkedin.api.PostsResource;
import org.apache.camel.component.linkedin.api.SearchResource;
import org.apache.camel.component.linkedin.internal.LinkedInApiCollection;
import org.apache.camel.component.linkedin.internal.LinkedInApiName;
import org.apache.camel.component.linkedin.internal.LinkedInPropertiesHelper;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.component.AbstractApiEndpoint;
import org.apache.camel.util.component.ApiMethod;
import org.apache.camel.util.component.ApiMethodPropertiesHelper;
import org.apache.camel.util.component.ApiName;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.WebClient;

@UriEndpoint(scheme="linkedin", title="Linkedin", syntax="linkedin:apiName/methodName", label="api,cloud,social", consumerClass=LinkedInConsumer.class)
public class LinkedInEndpoint
extends AbstractApiEndpoint<LinkedInApiName, LinkedInConfiguration> {
    protected static final String FIELDS_OPTION = "fields";
    private static final String DEFAULT_FIELDS_SELECTOR = "";
    @UriPath
    @Metadata(required="true")
    private final LinkedInApiName apiName;
    @UriPath
    @Metadata(required="true")
    private final String methodName;
    @UriParam
    private final LinkedInConfiguration configuration;
    private LinkedInOAuthRequestFilter requestFilter;
    private Object resourceProxy;

    public LinkedInEndpoint(String uri, LinkedInComponent component, LinkedInApiName apiName, String methodName, LinkedInConfiguration endpointConfiguration) {
        super(uri, (Component)component, (ApiName)apiName, methodName, LinkedInApiCollection.getCollection().getHelper(apiName), (Object)endpointConfiguration);
        this.apiName = apiName;
        this.methodName = methodName;
        this.configuration = endpointConfiguration;
    }

    public Producer createProducer() throws Exception {
        return new LinkedInProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.inBody != null) {
            throw new IllegalArgumentException("Option inBody is not supported for consumer endpoint");
        }
        LinkedInConsumer consumer = new LinkedInConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected ApiMethodPropertiesHelper<LinkedInConfiguration> getPropertiesHelper() {
        return LinkedInPropertiesHelper.getHelper();
    }

    protected String getThreadProfileName() {
        return "CamelLinkedIn";
    }

    protected void afterConfigureProperties() {
        this.createProxy();
    }

    private void createProxy() {
        Class<CommentsResource> proxyClass;
        this.requestFilter = this.getComponent().getRequestFilter(this.configuration);
        switch (this.apiName) {
            case COMMENTS: {
                proxyClass = CommentsResource.class;
                break;
            }
            case COMPANIES: {
                proxyClass = CompaniesResource.class;
                break;
            }
            case GROUPS: {
                proxyClass = GroupsResource.class;
                break;
            }
            case JOBS: {
                proxyClass = JobsResource.class;
                break;
            }
            case PEOPLE: {
                proxyClass = PeopleResource.class;
                break;
            }
            case POSTS: {
                proxyClass = PostsResource.class;
                break;
            }
            case SEARCH: {
                proxyClass = SearchResource.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid API name " + (Object)((Object)this.apiName));
            }
        }
        this.resourceProxy = JAXRSClientFactory.create((String)"https://api.linkedin.com/v1", proxyClass, Arrays.asList(this.requestFilter, new EnumQueryParamConverterProvider()));
    }

    public Object getApiProxy(ApiMethod method, Map<String, Object> args) {
        return this.resourceProxy;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.resourceProxy == null) {
            this.createProxy();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.resourceProxy != null) {
            try {
                WebClient.client((Object)this.resourceProxy).close();
            }
            catch (Exception e) {
                this.log.warn("Error closing LinkedIn REST proxy: " + e.getMessage(), (Throwable)e);
            }
            this.resourceProxy = null;
        }
        if (this.requestFilter != null) {
            this.getComponent().closeRequestFilter(this.requestFilter);
            this.requestFilter = null;
        }
    }

    public LinkedInComponent getComponent() {
        return (LinkedInComponent)super.getComponent();
    }

    public void interceptProperties(Map<String, Object> properties) {
        if (!properties.containsKey(FIELDS_OPTION)) {
            properties.put(FIELDS_OPTION, DEFAULT_FIELDS_SELECTOR);
        }
    }
}

