/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.routebox.seda;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.component.routebox.RouteboxConsumer;
import org.apache.camel.component.routebox.RouteboxServiceSupport;
import org.apache.camel.component.routebox.seda.RouteboxSedaEndpoint;
import org.apache.camel.component.routebox.strategy.RouteboxDispatcher;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteboxSedaConsumer
extends RouteboxServiceSupport
implements RouteboxConsumer,
Runnable,
ShutdownAware {
    private static final Logger LOG = LoggerFactory.getLogger(RouteboxSedaConsumer.class);
    protected AsyncProcessor processor;
    protected ProducerTemplate producer;

    public RouteboxSedaConsumer(RouteboxSedaEndpoint endpoint, Processor processor) {
        super(endpoint);
        this.setProcessor(AsyncProcessorConverterHelper.convert((Processor)processor));
        this.producer = endpoint.getConfig().getInnerProducerTemplate();
    }

    protected void doStart() throws Exception {
        ((RouteboxSedaEndpoint)this.getRouteboxEndpoint()).onStarted(this);
        this.doStartInnerContext();
        int poolSize = this.getRouteboxEndpoint().getConfig().getThreads();
        this.setExecutor(this.getRouteboxEndpoint().getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, this.getRouteboxEndpoint().getEndpointUri(), poolSize));
        for (int i = 0; i < poolSize; ++i) {
            this.getExecutor().execute(this);
        }
    }

    protected void doStop() throws Exception {
        ((RouteboxSedaEndpoint)this.getRouteboxEndpoint()).onStopped(this);
        this.getRouteboxEndpoint().getCamelContext().getExecutorServiceManager().shutdown(this.getExecutor());
        this.setExecutor(null);
        this.doStopInnerContext();
    }

    @Override
    public void run() {
        BlockingQueue<Exchange> queue = ((RouteboxSedaEndpoint)this.getRouteboxEndpoint()).getQueue();
        while (queue != null && this.isRunAllowed()) {
            try {
                Exchange exchange = queue.poll(this.getRouteboxEndpoint().getConfig().getPollInterval(), TimeUnit.MILLISECONDS);
                this.dispatchToInnerRoute(queue, exchange);
            }
            catch (InterruptedException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Sleep interrupted, are we stopping? {}", (Object)(this.isStopping() || this.isStopped() ? 1 : 0));
            }
        }
    }

    private void dispatchToInnerRoute(BlockingQueue<Exchange> queue, Exchange exchange) throws InterruptedException {
        if (exchange != null) {
            if (this.isRunAllowed()) {
                try {
                    LOG.debug("Dispatching to inner route: {}", (Object)exchange);
                    RouteboxDispatcher dispatcher = new RouteboxDispatcher(this.producer);
                    Exchange result = dispatcher.dispatchAsync(this.getRouteboxEndpoint(), exchange);
                    this.processor.process(result, new AsyncCallback(){

                        public void done(boolean doneSync) {
                        }
                    });
                }
                catch (Exception e) {
                    this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)e);
                }
            } else {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("This consumer is stopped during polling an exchange, so putting it back on the seda queue: " + exchange);
                }
                queue.put(exchange);
            }
        }
    }

    public Endpoint getEndpoint() {
        return this.getRouteboxEndpoint();
    }

    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        return false;
    }

    public int getPendingExchangesSize() {
        return 0;
    }

    public void prepareShutdown(boolean forced) {
    }

    public void setProcessor(AsyncProcessor processor) {
        this.processor = processor;
    }

    public AsyncProcessor getProcessor() {
        return this.processor;
    }
}

