/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.RestError;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.AsyncReportResults;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.RecentReport;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportDescription;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportInstance;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.SyncReportResults;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.AbstractClientBase;
import org.apache.camel.component.salesforce.internal.client.AnalyticsApiClient;
import org.apache.camel.component.salesforce.internal.client.SalesforceExchange;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;

public class DefaultAnalyticsApiClient
extends AbstractClientBase
implements AnalyticsApiClient {
    private static final String TOKEN_PREFIX = "Bearer ";
    private static final String INCLUDE_DETAILS_QUERY_PARAM = "?includeDetails=";
    private ObjectMapper objectMapper = new ObjectMapper();

    public DefaultAnalyticsApiClient(String version, SalesforceSession session, HttpClient httpClient) throws SalesforceException {
        super(version, session, httpClient);
    }

    @Override
    public void getRecentReports(final AnalyticsApiClient.RecentReportsResponseCallback callback) {
        final SalesforceExchange contentExchange = this.getContentExchange("GET", this.reportsUrl());
        this.doHttpRequest(contentExchange, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException ex) {
                List recentReports = null;
                if (response != null) {
                    try {
                        recentReports = (List)DefaultAnalyticsApiClient.this.unmarshalResponse(response, contentExchange, (TypeReference)new TypeReference<List<RecentReport>>(){});
                    }
                    catch (SalesforceException e) {
                        ex = e;
                    }
                }
                callback.onResponse(recentReports, ex);
            }
        });
    }

    @Override
    public void getReportDescription(String reportId, final AnalyticsApiClient.ReportDescriptionResponseCallback callback) {
        final SalesforceExchange contentExchange = this.getContentExchange("GET", this.reportsDescribeUrl(reportId));
        this.doHttpRequest(contentExchange, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException ex) {
                ReportDescription reportDescription = null;
                try {
                    reportDescription = (ReportDescription)DefaultAnalyticsApiClient.this.unmarshalResponse(response, contentExchange, ReportDescription.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(reportDescription, ex);
            }
        });
    }

    @Override
    public void executeSyncReport(String reportId, Boolean includeDetails, ReportMetadata reportMetadata, final AnalyticsApiClient.ReportResultsResponseCallback callback) {
        boolean useGet = reportMetadata == null;
        final SalesforceExchange contentExchange = this.getContentExchange(useGet ? "GET" : "POST", this.reportsUrl(reportId, includeDetails));
        if (!useGet) {
            try {
                HashMap<String, ReportMetadata> request = new HashMap<String, ReportMetadata>();
                request.put("reportMetadata", reportMetadata);
                this.marshalRequest(request, contentExchange);
            }
            catch (SalesforceException e) {
                callback.onResponse(null, e);
                return;
            }
        }
        this.doHttpRequest(contentExchange, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException ex) {
                SyncReportResults reportResults = null;
                try {
                    reportResults = (SyncReportResults)DefaultAnalyticsApiClient.this.unmarshalResponse(response, contentExchange, SyncReportResults.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(reportResults, ex);
            }
        });
    }

    @Override
    public void executeAsyncReport(String reportId, Boolean includeDetails, ReportMetadata reportMetadata, final AnalyticsApiClient.ReportInstanceResponseCallback callback) {
        final SalesforceExchange contentExchange = this.getContentExchange("POST", this.reportInstancesUrl(reportId, includeDetails));
        if (reportMetadata != null) {
            try {
                HashMap<String, ReportMetadata> request = new HashMap<String, ReportMetadata>();
                request.put("reportMetadata", reportMetadata);
                this.marshalRequest(request, contentExchange);
            }
            catch (SalesforceException e) {
                callback.onResponse(null, e);
                return;
            }
        }
        this.doHttpRequest(contentExchange, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException ex) {
                ReportInstance reportInstance = null;
                try {
                    reportInstance = (ReportInstance)DefaultAnalyticsApiClient.this.unmarshalResponse(response, contentExchange, ReportInstance.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(reportInstance, ex);
            }
        });
    }

    @Override
    public void getReportInstances(String reportId, final AnalyticsApiClient.ReportInstanceListResponseCallback callback) {
        final SalesforceExchange contentExchange = this.getContentExchange("GET", this.reportInstancesUrl(reportId));
        this.doHttpRequest(contentExchange, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException ex) {
                List reportInstances = null;
                if (response != null) {
                    try {
                        reportInstances = (List)DefaultAnalyticsApiClient.this.unmarshalResponse(response, contentExchange, (TypeReference)new TypeReference<List<ReportInstance>>(){});
                    }
                    catch (SalesforceException e) {
                        ex = e;
                    }
                }
                callback.onResponse(reportInstances, ex);
            }
        });
    }

    @Override
    public void getReportResults(String reportId, String instanceId, final AnalyticsApiClient.ReportResultsResponseCallback callback) {
        final SalesforceExchange contentExchange = this.getContentExchange("GET", this.reportInstancesUrl(reportId, instanceId));
        this.doHttpRequest(contentExchange, new AbstractClientBase.ClientResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException ex) {
                AsyncReportResults reportResults = null;
                try {
                    reportResults = (AsyncReportResults)DefaultAnalyticsApiClient.this.unmarshalResponse(response, contentExchange, AsyncReportResults.class);
                }
                catch (SalesforceException e) {
                    ex = e;
                }
                callback.onResponse(reportResults, ex);
            }
        });
    }

    private String reportsUrl() {
        return this.instanceUrl + "/services/data/v" + this.version + "/analytics/reports";
    }

    private String reportsDescribeUrl(String reportId) {
        return this.reportsUrl(reportId) + "/describe";
    }

    private String reportsUrl(String reportId) {
        return this.reportsUrl() + "/" + reportId;
    }

    private String reportsUrl(String reportId, Boolean includeDetails) {
        return includeDetails == null ? this.reportsUrl(reportId) : this.reportsUrl(reportId) + INCLUDE_DETAILS_QUERY_PARAM + includeDetails;
    }

    private String reportInstancesUrl(String reportId) {
        return this.reportsUrl(reportId) + "/instances";
    }

    private String reportInstancesUrl(String reportId, Boolean includeDetails) {
        return includeDetails == null ? this.reportInstancesUrl(reportId) : this.reportInstancesUrl(reportId) + INCLUDE_DETAILS_QUERY_PARAM + includeDetails;
    }

    private String reportInstancesUrl(String reportId, String instanceId) {
        return this.reportInstancesUrl(reportId) + "/" + instanceId;
    }

    @Override
    protected void setAccessToken(HttpExchange httpExchange) {
        httpExchange.setRequestHeader("Authorization", TOKEN_PREFIX + this.accessToken);
    }

    @Override
    protected SalesforceException createRestException(ContentExchange httpExchange, String reason) {
        int statusCode = httpExchange.getResponseStatus();
        String responseContent = null;
        try {
            responseContent = httpExchange.getResponseContent();
            if (responseContent != null) {
                List errors = (List)this.objectMapper.readValue(responseContent, (TypeReference)new TypeReference<List<RestError>>(){});
                return new SalesforceException(errors, statusCode);
            }
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unexpected Error parsing JSON error response body + [" + responseContent + "] : " + e.getMessage();
            this.log.warn(msg, (Throwable)e);
        }
        catch (IOException e) {
            String msg = "Unexpected Error parsing JSON error response body + [" + responseContent + "] : " + e.getMessage();
            this.log.warn(msg, (Throwable)e);
        }
        return new SalesforceException("Unexpected error: " + reason + ", with content: " + responseContent, statusCode);
    }

    @Override
    protected void doHttpRequest(ContentExchange request, AbstractClientBase.ClientResponseCallback callback) {
        this.setAccessToken((HttpExchange)request);
        request.setRequestHeader("Content-Type", "application/json;charset=utf-8");
        request.setRequestHeader("Accept", "application/json;charset=utf-8");
        request.setRequestHeader("Accept-Charset", "UTF-8");
        super.doHttpRequest(request, callback);
    }

    private void marshalRequest(Object input, ContentExchange request) throws SalesforceException {
        try {
            request.setRequestContent((Buffer)new ByteArrayBuffer(this.objectMapper.writeValueAsBytes(input)));
        }
        catch (IOException e) {
            throw new SalesforceException(String.format("Error marshaling request for {%s:%s} : %s", request.getMethod(), request.getRequestURI(), e.getMessage()), e);
        }
    }

    private <T> T unmarshalResponse(InputStream response, ContentExchange request, TypeReference<T> responseTypeReference) throws SalesforceException {
        try {
            return (T)this.objectMapper.readValue(response, responseTypeReference);
        }
        catch (IOException e) {
            throw new SalesforceException(String.format("Error unmarshaling response {%s:%s} : %s", request.getMethod(), request.getRequestURI(), e.getMessage()), e);
        }
    }

    private <T> T unmarshalResponse(InputStream response, ContentExchange request, Class<T> responseClass) throws SalesforceException {
        if (response == null) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(response, responseClass);
        }
        catch (IOException e) {
            throw new SalesforceException(String.format("Error unmarshaling response {%s:%s} : %s", request.getMethod(), request.getRequestURI(), e.getMessage()), e);
        }
    }
}

