/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.seda;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToStartRouteException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

/**
 * @version
 */
public class SedaConcurrentConsumersNPEIssueTest extends ContextTestSupport {

    public void testSendToSeda() throws Exception {
        MockEndpoint mock = getMockEndpoint("mock:result");
        mock.expectedBodiesReceived("Hello World");

        template.sendBody("seda:foo", "Hello World");

        assertMockEndpointsSatisfied();

        try {
            context.startRoute("first");
            fail("Should have thrown exception");
        } catch (FailedToStartRouteException e) {
            assertEquals("Failed to start route first because of Multiple consumers for the same endpoint is not allowed:"
                    + " Endpoint[seda://foo?concurrentConsumers=5]", e.getMessage());
        }
    }

    public void testStartThird() throws Exception {
        MockEndpoint mock = getMockEndpoint("mock:result");
        mock.expectedBodiesReceived("Hello World");

        template.sendBody("seda:foo", "Hello World");

        assertMockEndpointsSatisfied();

        // this should be okay
        context.startRoute("third");

        try {
            context.startRoute("first");
            fail("Should have thrown exception");
        } catch (FailedToStartRouteException e) {
            assertEquals("Failed to start route first because of Multiple consumers for the same endpoint is not allowed:"
                    + " Endpoint[seda://foo?concurrentConsumers=5]", e.getMessage());
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder() {
            @Override
            public void configure() throws Exception {
                from("seda:foo?concurrentConsumers=5").routeId("first").noAutoStartup().to("mock:result");

                from("seda:foo?concurrentConsumers=5").routeId("second").to("mock:result");
                
                from("direct:foo").routeId("third").noAutoStartup().to("mock:result");
            }
        };
    }
}
