<?xml version="1.0" encoding="UTF-8"?>
<!--
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to you under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd">
  <modelVersion>4.0.0</modelVersion>
  <parent>
    <groupId>org.apache.calcite</groupId>
    <artifactId>calcite</artifactId>
    <version>1.16.0</version>
  </parent>

  <properties>
    <top.dir>${project.basedir}/..</top.dir>
  </properties>

  <artifactId>calcite-ubenchmark</artifactId>
  <name>Calcite Ubenchmark</name>
  <description>Microbenchmarks for Calcite</description>

  <dependencies>
    <!-- Sorted by groupId, artifactId; calcite dependencies first. Put versions
         in dependencyManagement in the root POM, not here. -->
    <dependency>
      <groupId>org.apache.calcite</groupId>
      <artifactId>calcite-core</artifactId>
    </dependency>

    <dependency>
      <groupId>org.openjdk.jmh</groupId>
      <artifactId>jmh-core</artifactId>
    </dependency>
    <dependency>
      <groupId>org.openjdk.jmh</groupId>
      <artifactId>jmh-generator-annprocess</artifactId>
      <scope>provided</scope>
    </dependency>
    <dependency>
      <groupId>com.google.guava</groupId>
      <artifactId>guava</artifactId>
    </dependency>
  </dependencies>

  <build>
    <plugins>
      <plugin>
        <!-- This workarounds Maven issue that tries to pass annotation-pre-processed sources
             when using incremental compilation.
             More details here: https://bugs.openjdk.java.net/browse/JDK-8067747?focusedCommentId=13872639&page=com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel#comment-13872639
             -->
        <artifactId>maven-clean-plugin</artifactId>
        <executions>
          <execution>
            <id>clean-on-validate</id>
            <goals>
              <goal>clean</goal>
            </goals>
            <phase>validate</phase>
          </execution>
        </executions>
      </plugin>
      <plugin>
        <artifactId>maven-compiler-plugin</artifactId>
        <configuration>
          <source>1.6</source>
          <target>1.6</target>
        </configuration>
      </plugin>
      <plugin>
        <groupId>org.apache.maven.plugins</groupId>
        <artifactId>maven-shade-plugin</artifactId>
        <executions>
          <execution>
            <phase>package</phase>
            <goals>
              <goal>shade</goal>
            </goals>
            <configuration>
              <finalName>ubenchmarks</finalName>
              <filters>
                  <filter>
                      <!--
                          Exclude files that sign a jar
                          (one or multiple of the dependencies).
                          One may not repack a signed jar without
                          this, or you will get a
                          SecurityException at program start.
                      -->
                      <artifact>*:*</artifact>
                      <excludes>
                          <exclude>META-INF/*.SF</exclude>
                          <exclude>META-INF/*.RSA</exclude>
                          <exclude>META-INF/*.INF</exclude> <!-- This one may not be required -->
                      </excludes>
                  </filter>
              </filters>
              <transformers>
                <transformer implementation="org.apache.maven.plugins.shade.resource.ManifestResourceTransformer">
                  <mainClass>org.openjdk.jmh.Main</mainClass>
                </transformer>
              </transformers>
            </configuration>
          </execution>
        </executions>
      </plugin>
      <plugin>
        <groupId>org.apache.maven.plugins</groupId>
        <artifactId>maven-dependency-plugin</artifactId>
        <version>${maven-dependency-plugin.version}</version>
        <!-- configurations do not cascade, so all of the definition from
             ../pom.xml:build:plugin-management:plugins:plugin must be repeated in child poms -->
        <executions>
          <execution>
            <id>analyze</id>
            <goals>
              <goal>analyze-only</goal>
            </goals>
            <configuration>
              <failOnWarning>true</failOnWarning>
              <!-- ignore "unused but declared" warnings -->
              <ignoredUnusedDeclaredDependencies>
                <ignoredUnusedDeclaredDependency>org.openjdk.jmh:jmh-generator-annprocess</ignoredUnusedDeclaredDependency>
              </ignoredUnusedDeclaredDependencies>
            </configuration>
          </execution>
        </executions>
      </plugin>
    </plugins>
  </build>
</project>
