// Code generated by protoc-gen-go. DO NOT EDIT.
// source: beam_fn_api.proto

package fnexecution_v1

import (
	context "context"
	fmt "fmt"
	pipeline_v1 "github.com/apache/beam/sdks/go/pkg/beam/model/pipeline_v1"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/golang/protobuf/protoc-gen-go/descriptor"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "github.com/golang/protobuf/ptypes/wrappers"
	grpc "google.golang.org/grpc"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type MonitoringInfo_MonitoringInfoLabels int32

const (
	MonitoringInfo_TRANSFORM          MonitoringInfo_MonitoringInfoLabels = 0
	MonitoringInfo_PCOLLECTION        MonitoringInfo_MonitoringInfoLabels = 1
	MonitoringInfo_WINDOWING_STRATEGY MonitoringInfo_MonitoringInfoLabels = 2
	MonitoringInfo_CODER              MonitoringInfo_MonitoringInfoLabels = 3
	MonitoringInfo_ENVIRONMENT        MonitoringInfo_MonitoringInfoLabels = 4
)

var MonitoringInfo_MonitoringInfoLabels_name = map[int32]string{
	0: "TRANSFORM",
	1: "PCOLLECTION",
	2: "WINDOWING_STRATEGY",
	3: "CODER",
	4: "ENVIRONMENT",
}

var MonitoringInfo_MonitoringInfoLabels_value = map[string]int32{
	"TRANSFORM":          0,
	"PCOLLECTION":        1,
	"WINDOWING_STRATEGY": 2,
	"CODER":              3,
	"ENVIRONMENT":        4,
}

func (x MonitoringInfo_MonitoringInfoLabels) String() string {
	return proto.EnumName(MonitoringInfo_MonitoringInfoLabels_name, int32(x))
}

func (MonitoringInfo_MonitoringInfoLabels) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{12, 0}
}

type MonitoringInfoUrns_Enum int32

const (
	MonitoringInfoUrns_USER_COUNTER_URN_PREFIX MonitoringInfoUrns_Enum = 0
	MonitoringInfoUrns_ELEMENT_COUNT           MonitoringInfoUrns_Enum = 1
	MonitoringInfoUrns_START_BUNDLE_MSECS      MonitoringInfoUrns_Enum = 2
	MonitoringInfoUrns_PROCESS_BUNDLE_MSECS    MonitoringInfoUrns_Enum = 3
	MonitoringInfoUrns_FINISH_BUNDLE_MSECS     MonitoringInfoUrns_Enum = 4
	MonitoringInfoUrns_TOTAL_MSECS             MonitoringInfoUrns_Enum = 5
)

var MonitoringInfoUrns_Enum_name = map[int32]string{
	0: "USER_COUNTER_URN_PREFIX",
	1: "ELEMENT_COUNT",
	2: "START_BUNDLE_MSECS",
	3: "PROCESS_BUNDLE_MSECS",
	4: "FINISH_BUNDLE_MSECS",
	5: "TOTAL_MSECS",
}

var MonitoringInfoUrns_Enum_value = map[string]int32{
	"USER_COUNTER_URN_PREFIX": 0,
	"ELEMENT_COUNT":           1,
	"START_BUNDLE_MSECS":      2,
	"PROCESS_BUNDLE_MSECS":    3,
	"FINISH_BUNDLE_MSECS":     4,
	"TOTAL_MSECS":             5,
}

func (x MonitoringInfoUrns_Enum) String() string {
	return proto.EnumName(MonitoringInfoUrns_Enum_name, int32(x))
}

func (MonitoringInfoUrns_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{13, 0}
}

type MonitoringInfoTypeUrns_Enum int32

const (
	MonitoringInfoTypeUrns_SUM_INT64_TYPE          MonitoringInfoTypeUrns_Enum = 0
	MonitoringInfoTypeUrns_DISTRIBUTION_INT64_TYPE MonitoringInfoTypeUrns_Enum = 1
	MonitoringInfoTypeUrns_LATEST_INT64_TYPE       MonitoringInfoTypeUrns_Enum = 2
)

var MonitoringInfoTypeUrns_Enum_name = map[int32]string{
	0: "SUM_INT64_TYPE",
	1: "DISTRIBUTION_INT64_TYPE",
	2: "LATEST_INT64_TYPE",
}

var MonitoringInfoTypeUrns_Enum_value = map[string]int32{
	"SUM_INT64_TYPE":          0,
	"DISTRIBUTION_INT64_TYPE": 1,
	"LATEST_INT64_TYPE":       2,
}

func (x MonitoringInfoTypeUrns_Enum) String() string {
	return proto.EnumName(MonitoringInfoTypeUrns_Enum_name, int32(x))
}

func (MonitoringInfoTypeUrns_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{14, 0}
}

type LogEntry_Severity_Enum int32

const (
	// Unspecified level information. Will be logged at the TRACE level.
	LogEntry_Severity_UNSPECIFIED LogEntry_Severity_Enum = 0
	LogEntry_Severity_TRACE       LogEntry_Severity_Enum = 1
	// Debugging information.
	LogEntry_Severity_DEBUG LogEntry_Severity_Enum = 2
	// Normal events.
	LogEntry_Severity_INFO LogEntry_Severity_Enum = 3
	// Normal but significant events, such as start up, shut down, or
	// configuration.
	LogEntry_Severity_NOTICE LogEntry_Severity_Enum = 4
	// Warning events might cause problems.
	LogEntry_Severity_WARN LogEntry_Severity_Enum = 5
	// Error events are likely to cause problems.
	LogEntry_Severity_ERROR LogEntry_Severity_Enum = 6
	// Critical events cause severe problems or brief outages and may
	// indicate that a person must take action.
	LogEntry_Severity_CRITICAL LogEntry_Severity_Enum = 7
)

var LogEntry_Severity_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "TRACE",
	2: "DEBUG",
	3: "INFO",
	4: "NOTICE",
	5: "WARN",
	6: "ERROR",
	7: "CRITICAL",
}

var LogEntry_Severity_Enum_value = map[string]int32{
	"UNSPECIFIED": 0,
	"TRACE":       1,
	"DEBUG":       2,
	"INFO":        3,
	"NOTICE":      4,
	"WARN":        5,
	"ERROR":       6,
	"CRITICAL":    7,
}

func (x LogEntry_Severity_Enum) String() string {
	return proto.EnumName(LogEntry_Severity_Enum_name, int32(x))
}

func (LogEntry_Severity_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{40, 1, 0}
}

// A representation of an input or output definition on a primitive transform.
// Stable
type Target struct {
	// (Required) The id of the PrimitiveTransform which is the target.
	PrimitiveTransformReference string `protobuf:"bytes,1,opt,name=primitive_transform_reference,json=primitiveTransformReference,proto3" json:"primitive_transform_reference,omitempty"`
	// (Required) The local name of an input or output defined on the primitive
	// transform.
	Name                 string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Target) Reset()         { *m = Target{} }
func (m *Target) String() string { return proto.CompactTextString(m) }
func (*Target) ProtoMessage()    {}
func (*Target) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{0}
}

func (m *Target) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Target.Unmarshal(m, b)
}
func (m *Target) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Target.Marshal(b, m, deterministic)
}
func (m *Target) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Target.Merge(m, src)
}
func (m *Target) XXX_Size() int {
	return xxx_messageInfo_Target.Size(m)
}
func (m *Target) XXX_DiscardUnknown() {
	xxx_messageInfo_Target.DiscardUnknown(m)
}

var xxx_messageInfo_Target proto.InternalMessageInfo

func (m *Target) GetPrimitiveTransformReference() string {
	if m != nil {
		return m.PrimitiveTransformReference
	}
	return ""
}

func (m *Target) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A repeated list of target definitions.
type Target_List struct {
	Target               []*Target `protobuf:"bytes,1,rep,name=target,proto3" json:"target,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Target_List) Reset()         { *m = Target_List{} }
func (m *Target_List) String() string { return proto.CompactTextString(m) }
func (*Target_List) ProtoMessage()    {}
func (*Target_List) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{0, 0}
}

func (m *Target_List) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Target_List.Unmarshal(m, b)
}
func (m *Target_List) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Target_List.Marshal(b, m, deterministic)
}
func (m *Target_List) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Target_List.Merge(m, src)
}
func (m *Target_List) XXX_Size() int {
	return xxx_messageInfo_Target_List.Size(m)
}
func (m *Target_List) XXX_DiscardUnknown() {
	xxx_messageInfo_Target_List.DiscardUnknown(m)
}

var xxx_messageInfo_Target_List proto.InternalMessageInfo

func (m *Target_List) GetTarget() []*Target {
	if m != nil {
		return m.Target
	}
	return nil
}

// A descriptor for connecting to a remote port using the Beam Fn Data API.
// Allows for communication between two environments (for example between the
// runner and the SDK).
// Stable
type RemoteGrpcPort struct {
	// (Required) An API descriptor which describes where to
	// connect to including any authentication that is required.
	ApiServiceDescriptor *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,1,opt,name=api_service_descriptor,json=apiServiceDescriptor,proto3" json:"api_service_descriptor,omitempty"`
	// (Required) The ID of the Coder that will be used to encode and decode data sent over this port.
	CoderId              string   `protobuf:"bytes,2,opt,name=coder_id,json=coderId,proto3" json:"coder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoteGrpcPort) Reset()         { *m = RemoteGrpcPort{} }
func (m *RemoteGrpcPort) String() string { return proto.CompactTextString(m) }
func (*RemoteGrpcPort) ProtoMessage()    {}
func (*RemoteGrpcPort) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{1}
}

func (m *RemoteGrpcPort) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoteGrpcPort.Unmarshal(m, b)
}
func (m *RemoteGrpcPort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoteGrpcPort.Marshal(b, m, deterministic)
}
func (m *RemoteGrpcPort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoteGrpcPort.Merge(m, src)
}
func (m *RemoteGrpcPort) XXX_Size() int {
	return xxx_messageInfo_RemoteGrpcPort.Size(m)
}
func (m *RemoteGrpcPort) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoteGrpcPort.DiscardUnknown(m)
}

var xxx_messageInfo_RemoteGrpcPort proto.InternalMessageInfo

func (m *RemoteGrpcPort) GetApiServiceDescriptor() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.ApiServiceDescriptor
	}
	return nil
}

func (m *RemoteGrpcPort) GetCoderId() string {
	if m != nil {
		return m.CoderId
	}
	return ""
}

// A request sent by a runner which the SDK is asked to fulfill.
// For any unsupported request type, an error should be returned with a
// matching instruction id.
// Stable
type InstructionRequest struct {
	// (Required) An unique identifier provided by the runner which represents
	// this requests execution. The InstructionResponse MUST have the matching id.
	InstructionId string `protobuf:"bytes,1,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	// (Required) A request that the SDK Harness needs to interpret.
	//
	// Types that are valid to be assigned to Request:
	//	*InstructionRequest_Register
	//	*InstructionRequest_ProcessBundle
	//	*InstructionRequest_ProcessBundleProgress
	//	*InstructionRequest_ProcessBundleSplit
	//	*InstructionRequest_FinalizeBundle
	Request              isInstructionRequest_Request `protobuf_oneof:"request"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *InstructionRequest) Reset()         { *m = InstructionRequest{} }
func (m *InstructionRequest) String() string { return proto.CompactTextString(m) }
func (*InstructionRequest) ProtoMessage()    {}
func (*InstructionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{2}
}

func (m *InstructionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstructionRequest.Unmarshal(m, b)
}
func (m *InstructionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstructionRequest.Marshal(b, m, deterministic)
}
func (m *InstructionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstructionRequest.Merge(m, src)
}
func (m *InstructionRequest) XXX_Size() int {
	return xxx_messageInfo_InstructionRequest.Size(m)
}
func (m *InstructionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InstructionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InstructionRequest proto.InternalMessageInfo

func (m *InstructionRequest) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

type isInstructionRequest_Request interface {
	isInstructionRequest_Request()
}

type InstructionRequest_Register struct {
	Register *RegisterRequest `protobuf:"bytes,1000,opt,name=register,proto3,oneof"`
}

type InstructionRequest_ProcessBundle struct {
	ProcessBundle *ProcessBundleRequest `protobuf:"bytes,1001,opt,name=process_bundle,json=processBundle,proto3,oneof"`
}

type InstructionRequest_ProcessBundleProgress struct {
	ProcessBundleProgress *ProcessBundleProgressRequest `protobuf:"bytes,1002,opt,name=process_bundle_progress,json=processBundleProgress,proto3,oneof"`
}

type InstructionRequest_ProcessBundleSplit struct {
	ProcessBundleSplit *ProcessBundleSplitRequest `protobuf:"bytes,1003,opt,name=process_bundle_split,json=processBundleSplit,proto3,oneof"`
}

type InstructionRequest_FinalizeBundle struct {
	FinalizeBundle *FinalizeBundleRequest `protobuf:"bytes,1004,opt,name=finalize_bundle,json=finalizeBundle,proto3,oneof"`
}

func (*InstructionRequest_Register) isInstructionRequest_Request() {}

func (*InstructionRequest_ProcessBundle) isInstructionRequest_Request() {}

func (*InstructionRequest_ProcessBundleProgress) isInstructionRequest_Request() {}

func (*InstructionRequest_ProcessBundleSplit) isInstructionRequest_Request() {}

func (*InstructionRequest_FinalizeBundle) isInstructionRequest_Request() {}

func (m *InstructionRequest) GetRequest() isInstructionRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *InstructionRequest) GetRegister() *RegisterRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_Register); ok {
		return x.Register
	}
	return nil
}

func (m *InstructionRequest) GetProcessBundle() *ProcessBundleRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_ProcessBundle); ok {
		return x.ProcessBundle
	}
	return nil
}

func (m *InstructionRequest) GetProcessBundleProgress() *ProcessBundleProgressRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_ProcessBundleProgress); ok {
		return x.ProcessBundleProgress
	}
	return nil
}

func (m *InstructionRequest) GetProcessBundleSplit() *ProcessBundleSplitRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_ProcessBundleSplit); ok {
		return x.ProcessBundleSplit
	}
	return nil
}

func (m *InstructionRequest) GetFinalizeBundle() *FinalizeBundleRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_FinalizeBundle); ok {
		return x.FinalizeBundle
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*InstructionRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _InstructionRequest_OneofMarshaler, _InstructionRequest_OneofUnmarshaler, _InstructionRequest_OneofSizer, []interface{}{
		(*InstructionRequest_Register)(nil),
		(*InstructionRequest_ProcessBundle)(nil),
		(*InstructionRequest_ProcessBundleProgress)(nil),
		(*InstructionRequest_ProcessBundleSplit)(nil),
		(*InstructionRequest_FinalizeBundle)(nil),
	}
}

func _InstructionRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*InstructionRequest)
	// request
	switch x := m.Request.(type) {
	case *InstructionRequest_Register:
		b.EncodeVarint(1000<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Register); err != nil {
			return err
		}
	case *InstructionRequest_ProcessBundle:
		b.EncodeVarint(1001<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProcessBundle); err != nil {
			return err
		}
	case *InstructionRequest_ProcessBundleProgress:
		b.EncodeVarint(1002<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProcessBundleProgress); err != nil {
			return err
		}
	case *InstructionRequest_ProcessBundleSplit:
		b.EncodeVarint(1003<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProcessBundleSplit); err != nil {
			return err
		}
	case *InstructionRequest_FinalizeBundle:
		b.EncodeVarint(1004<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.FinalizeBundle); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("InstructionRequest.Request has unexpected type %T", x)
	}
	return nil
}

func _InstructionRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*InstructionRequest)
	switch tag {
	case 1000: // request.register
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RegisterRequest)
		err := b.DecodeMessage(msg)
		m.Request = &InstructionRequest_Register{msg}
		return true, err
	case 1001: // request.process_bundle
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProcessBundleRequest)
		err := b.DecodeMessage(msg)
		m.Request = &InstructionRequest_ProcessBundle{msg}
		return true, err
	case 1002: // request.process_bundle_progress
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProcessBundleProgressRequest)
		err := b.DecodeMessage(msg)
		m.Request = &InstructionRequest_ProcessBundleProgress{msg}
		return true, err
	case 1003: // request.process_bundle_split
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProcessBundleSplitRequest)
		err := b.DecodeMessage(msg)
		m.Request = &InstructionRequest_ProcessBundleSplit{msg}
		return true, err
	case 1004: // request.finalize_bundle
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(FinalizeBundleRequest)
		err := b.DecodeMessage(msg)
		m.Request = &InstructionRequest_FinalizeBundle{msg}
		return true, err
	default:
		return false, nil
	}
}

func _InstructionRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*InstructionRequest)
	// request
	switch x := m.Request.(type) {
	case *InstructionRequest_Register:
		s := proto.Size(x.Register)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionRequest_ProcessBundle:
		s := proto.Size(x.ProcessBundle)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionRequest_ProcessBundleProgress:
		s := proto.Size(x.ProcessBundleProgress)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionRequest_ProcessBundleSplit:
		s := proto.Size(x.ProcessBundleSplit)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionRequest_FinalizeBundle:
		s := proto.Size(x.FinalizeBundle)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The response for an associated request the SDK had been asked to fulfill.
// Stable
type InstructionResponse struct {
	// (Required) A reference provided by the runner which represents a requests
	// execution. The InstructionResponse MUST have the matching id when
	// responding to the runner.
	InstructionId string `protobuf:"bytes,1,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	// If this is specified, then this instruction has failed.
	// A human readable string representing the reason as to why processing has
	// failed.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// If the instruction did not fail, it is required to return an equivalent
	// response type depending on the request this matches.
	//
	// Types that are valid to be assigned to Response:
	//	*InstructionResponse_Register
	//	*InstructionResponse_ProcessBundle
	//	*InstructionResponse_ProcessBundleProgress
	//	*InstructionResponse_ProcessBundleSplit
	//	*InstructionResponse_FinalizeBundle
	Response             isInstructionResponse_Response `protobuf_oneof:"response"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *InstructionResponse) Reset()         { *m = InstructionResponse{} }
func (m *InstructionResponse) String() string { return proto.CompactTextString(m) }
func (*InstructionResponse) ProtoMessage()    {}
func (*InstructionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{3}
}

func (m *InstructionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstructionResponse.Unmarshal(m, b)
}
func (m *InstructionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstructionResponse.Marshal(b, m, deterministic)
}
func (m *InstructionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstructionResponse.Merge(m, src)
}
func (m *InstructionResponse) XXX_Size() int {
	return xxx_messageInfo_InstructionResponse.Size(m)
}
func (m *InstructionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_InstructionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_InstructionResponse proto.InternalMessageInfo

func (m *InstructionResponse) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

func (m *InstructionResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type isInstructionResponse_Response interface {
	isInstructionResponse_Response()
}

type InstructionResponse_Register struct {
	Register *RegisterResponse `protobuf:"bytes,1000,opt,name=register,proto3,oneof"`
}

type InstructionResponse_ProcessBundle struct {
	ProcessBundle *ProcessBundleResponse `protobuf:"bytes,1001,opt,name=process_bundle,json=processBundle,proto3,oneof"`
}

type InstructionResponse_ProcessBundleProgress struct {
	ProcessBundleProgress *ProcessBundleProgressResponse `protobuf:"bytes,1002,opt,name=process_bundle_progress,json=processBundleProgress,proto3,oneof"`
}

type InstructionResponse_ProcessBundleSplit struct {
	ProcessBundleSplit *ProcessBundleSplitResponse `protobuf:"bytes,1003,opt,name=process_bundle_split,json=processBundleSplit,proto3,oneof"`
}

type InstructionResponse_FinalizeBundle struct {
	FinalizeBundle *FinalizeBundleResponse `protobuf:"bytes,1004,opt,name=finalize_bundle,json=finalizeBundle,proto3,oneof"`
}

func (*InstructionResponse_Register) isInstructionResponse_Response() {}

func (*InstructionResponse_ProcessBundle) isInstructionResponse_Response() {}

func (*InstructionResponse_ProcessBundleProgress) isInstructionResponse_Response() {}

func (*InstructionResponse_ProcessBundleSplit) isInstructionResponse_Response() {}

func (*InstructionResponse_FinalizeBundle) isInstructionResponse_Response() {}

func (m *InstructionResponse) GetResponse() isInstructionResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *InstructionResponse) GetRegister() *RegisterResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_Register); ok {
		return x.Register
	}
	return nil
}

func (m *InstructionResponse) GetProcessBundle() *ProcessBundleResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_ProcessBundle); ok {
		return x.ProcessBundle
	}
	return nil
}

func (m *InstructionResponse) GetProcessBundleProgress() *ProcessBundleProgressResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_ProcessBundleProgress); ok {
		return x.ProcessBundleProgress
	}
	return nil
}

func (m *InstructionResponse) GetProcessBundleSplit() *ProcessBundleSplitResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_ProcessBundleSplit); ok {
		return x.ProcessBundleSplit
	}
	return nil
}

func (m *InstructionResponse) GetFinalizeBundle() *FinalizeBundleResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_FinalizeBundle); ok {
		return x.FinalizeBundle
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*InstructionResponse) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _InstructionResponse_OneofMarshaler, _InstructionResponse_OneofUnmarshaler, _InstructionResponse_OneofSizer, []interface{}{
		(*InstructionResponse_Register)(nil),
		(*InstructionResponse_ProcessBundle)(nil),
		(*InstructionResponse_ProcessBundleProgress)(nil),
		(*InstructionResponse_ProcessBundleSplit)(nil),
		(*InstructionResponse_FinalizeBundle)(nil),
	}
}

func _InstructionResponse_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*InstructionResponse)
	// response
	switch x := m.Response.(type) {
	case *InstructionResponse_Register:
		b.EncodeVarint(1000<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Register); err != nil {
			return err
		}
	case *InstructionResponse_ProcessBundle:
		b.EncodeVarint(1001<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProcessBundle); err != nil {
			return err
		}
	case *InstructionResponse_ProcessBundleProgress:
		b.EncodeVarint(1002<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProcessBundleProgress); err != nil {
			return err
		}
	case *InstructionResponse_ProcessBundleSplit:
		b.EncodeVarint(1003<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProcessBundleSplit); err != nil {
			return err
		}
	case *InstructionResponse_FinalizeBundle:
		b.EncodeVarint(1004<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.FinalizeBundle); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("InstructionResponse.Response has unexpected type %T", x)
	}
	return nil
}

func _InstructionResponse_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*InstructionResponse)
	switch tag {
	case 1000: // response.register
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RegisterResponse)
		err := b.DecodeMessage(msg)
		m.Response = &InstructionResponse_Register{msg}
		return true, err
	case 1001: // response.process_bundle
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProcessBundleResponse)
		err := b.DecodeMessage(msg)
		m.Response = &InstructionResponse_ProcessBundle{msg}
		return true, err
	case 1002: // response.process_bundle_progress
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProcessBundleProgressResponse)
		err := b.DecodeMessage(msg)
		m.Response = &InstructionResponse_ProcessBundleProgress{msg}
		return true, err
	case 1003: // response.process_bundle_split
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProcessBundleSplitResponse)
		err := b.DecodeMessage(msg)
		m.Response = &InstructionResponse_ProcessBundleSplit{msg}
		return true, err
	case 1004: // response.finalize_bundle
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(FinalizeBundleResponse)
		err := b.DecodeMessage(msg)
		m.Response = &InstructionResponse_FinalizeBundle{msg}
		return true, err
	default:
		return false, nil
	}
}

func _InstructionResponse_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*InstructionResponse)
	// response
	switch x := m.Response.(type) {
	case *InstructionResponse_Register:
		s := proto.Size(x.Register)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionResponse_ProcessBundle:
		s := proto.Size(x.ProcessBundle)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionResponse_ProcessBundleProgress:
		s := proto.Size(x.ProcessBundleProgress)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionResponse_ProcessBundleSplit:
		s := proto.Size(x.ProcessBundleSplit)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionResponse_FinalizeBundle:
		s := proto.Size(x.FinalizeBundle)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A list of objects which can be referred to by the runner in
// future requests.
// Stable
type RegisterRequest struct {
	// (Optional) The set of descriptors used to process bundles.
	ProcessBundleDescriptor []*ProcessBundleDescriptor `protobuf:"bytes,1,rep,name=process_bundle_descriptor,json=processBundleDescriptor,proto3" json:"process_bundle_descriptor,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}                   `json:"-"`
	XXX_unrecognized        []byte                     `json:"-"`
	XXX_sizecache           int32                      `json:"-"`
}

func (m *RegisterRequest) Reset()         { *m = RegisterRequest{} }
func (m *RegisterRequest) String() string { return proto.CompactTextString(m) }
func (*RegisterRequest) ProtoMessage()    {}
func (*RegisterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{4}
}

func (m *RegisterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RegisterRequest.Unmarshal(m, b)
}
func (m *RegisterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RegisterRequest.Marshal(b, m, deterministic)
}
func (m *RegisterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterRequest.Merge(m, src)
}
func (m *RegisterRequest) XXX_Size() int {
	return xxx_messageInfo_RegisterRequest.Size(m)
}
func (m *RegisterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterRequest proto.InternalMessageInfo

func (m *RegisterRequest) GetProcessBundleDescriptor() []*ProcessBundleDescriptor {
	if m != nil {
		return m.ProcessBundleDescriptor
	}
	return nil
}

// Stable
type RegisterResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RegisterResponse) Reset()         { *m = RegisterResponse{} }
func (m *RegisterResponse) String() string { return proto.CompactTextString(m) }
func (*RegisterResponse) ProtoMessage()    {}
func (*RegisterResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{5}
}

func (m *RegisterResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RegisterResponse.Unmarshal(m, b)
}
func (m *RegisterResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RegisterResponse.Marshal(b, m, deterministic)
}
func (m *RegisterResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterResponse.Merge(m, src)
}
func (m *RegisterResponse) XXX_Size() int {
	return xxx_messageInfo_RegisterResponse.Size(m)
}
func (m *RegisterResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterResponse proto.InternalMessageInfo

// Definitions that should be used to construct the bundle processing graph.
type ProcessBundleDescriptor struct {
	// (Required) A pipeline level unique id which can be used as a reference to
	// refer to this.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// (Required) A map from pipeline-scoped id to PTransform.
	Transforms map[string]*pipeline_v1.PTransform `protobuf:"bytes,2,rep,name=transforms,proto3" json:"transforms,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to PCollection.
	Pcollections map[string]*pipeline_v1.PCollection `protobuf:"bytes,3,rep,name=pcollections,proto3" json:"pcollections,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to WindowingStrategy.
	WindowingStrategies map[string]*pipeline_v1.WindowingStrategy `protobuf:"bytes,4,rep,name=windowing_strategies,json=windowingStrategies,proto3" json:"windowing_strategies,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to Coder.
	Coders map[string]*pipeline_v1.Coder `protobuf:"bytes,5,rep,name=coders,proto3" json:"coders,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to Environment.
	Environments map[string]*pipeline_v1.Environment `protobuf:"bytes,6,rep,name=environments,proto3" json:"environments,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A descriptor describing the end point to use for State API
	// calls. Required if the Runner intends to send remote references over the
	// data plane or if any of the transforms rely on user state or side inputs.
	StateApiServiceDescriptor *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,7,opt,name=state_api_service_descriptor,json=stateApiServiceDescriptor,proto3" json:"state_api_service_descriptor,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}                          `json:"-"`
	XXX_unrecognized          []byte                            `json:"-"`
	XXX_sizecache             int32                             `json:"-"`
}

func (m *ProcessBundleDescriptor) Reset()         { *m = ProcessBundleDescriptor{} }
func (m *ProcessBundleDescriptor) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleDescriptor) ProtoMessage()    {}
func (*ProcessBundleDescriptor) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{6}
}

func (m *ProcessBundleDescriptor) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleDescriptor.Unmarshal(m, b)
}
func (m *ProcessBundleDescriptor) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleDescriptor.Marshal(b, m, deterministic)
}
func (m *ProcessBundleDescriptor) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleDescriptor.Merge(m, src)
}
func (m *ProcessBundleDescriptor) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleDescriptor.Size(m)
}
func (m *ProcessBundleDescriptor) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleDescriptor.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleDescriptor proto.InternalMessageInfo

func (m *ProcessBundleDescriptor) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ProcessBundleDescriptor) GetTransforms() map[string]*pipeline_v1.PTransform {
	if m != nil {
		return m.Transforms
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetPcollections() map[string]*pipeline_v1.PCollection {
	if m != nil {
		return m.Pcollections
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetWindowingStrategies() map[string]*pipeline_v1.WindowingStrategy {
	if m != nil {
		return m.WindowingStrategies
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetCoders() map[string]*pipeline_v1.Coder {
	if m != nil {
		return m.Coders
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetEnvironments() map[string]*pipeline_v1.Environment {
	if m != nil {
		return m.Environments
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetStateApiServiceDescriptor() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.StateApiServiceDescriptor
	}
	return nil
}

// One of the applications specifying the scope of work for a bundle.
// See https://docs.google.com/document/d/1tUDb45sStdR8u7-jBkGdw3OGFK7aa2-V7eo86zYSE_4/edit#heading=h.9g3g5weg2u9 for further details.
type BundleApplication struct {
	// (Required) The primitive transform to which to pass the element
	PtransformId string `protobuf:"bytes,1,opt,name=ptransform_id,json=ptransformId,proto3" json:"ptransform_id,omitempty"`
	// (Required) Name of the transform's input to which to pass the element.
	InputId string `protobuf:"bytes,2,opt,name=input_id,json=inputId,proto3" json:"input_id,omitempty"`
	// (Required) The encoded element to pass to the transform.
	Element []byte `protobuf:"bytes,3,opt,name=element,proto3" json:"element,omitempty"`
	// The map is keyed by the local output name of the PTransform. Each
	// value represents a lower bound on the timestamps of elements that
	// are produced by this PTransform into each of its output PCollections
	// when invoked with this application.
	OutputWatermarks map[string]*timestamp.Timestamp `protobuf:"bytes,4,rep,name=output_watermarks,json=outputWatermarks,proto3" json:"output_watermarks,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) An estimate for the amount outstanding work related to
	// this application.
	Backlog *BundleApplication_Backlog `protobuf:"bytes,5,opt,name=backlog,proto3" json:"backlog,omitempty"`
	// (Required) Whether this application potentially produces an unbounded
	// amount of data. Note that this should only be set to BOUNDED if and
	// only if the application is known to produce a finite amount of output.
	//
	// Note that this is different from the backlog as the backlog represents
	// how much work there is currently outstanding.
	IsBounded pipeline_v1.IsBounded_Enum `protobuf:"varint,6,opt,name=is_bounded,json=isBounded,proto3,enum=org.apache.beam.model.pipeline.v1.IsBounded_Enum" json:"is_bounded,omitempty"`
	// Contains additional monitoring information related to this application.
	//
	// Each application is able to report information that some runners
	// will use consume when providing a UI or for making scaling and performance
	// decisions. See https://s.apache.org/beam-bundles-backlog-splitting for
	// details about what types of signals may be useful to report.
	MonitoringInfos      []*MonitoringInfo `protobuf:"bytes,7,rep,name=monitoring_infos,json=monitoringInfos,proto3" json:"monitoring_infos,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *BundleApplication) Reset()         { *m = BundleApplication{} }
func (m *BundleApplication) String() string { return proto.CompactTextString(m) }
func (*BundleApplication) ProtoMessage()    {}
func (*BundleApplication) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{7}
}

func (m *BundleApplication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BundleApplication.Unmarshal(m, b)
}
func (m *BundleApplication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BundleApplication.Marshal(b, m, deterministic)
}
func (m *BundleApplication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BundleApplication.Merge(m, src)
}
func (m *BundleApplication) XXX_Size() int {
	return xxx_messageInfo_BundleApplication.Size(m)
}
func (m *BundleApplication) XXX_DiscardUnknown() {
	xxx_messageInfo_BundleApplication.DiscardUnknown(m)
}

var xxx_messageInfo_BundleApplication proto.InternalMessageInfo

func (m *BundleApplication) GetPtransformId() string {
	if m != nil {
		return m.PtransformId
	}
	return ""
}

func (m *BundleApplication) GetInputId() string {
	if m != nil {
		return m.InputId
	}
	return ""
}

func (m *BundleApplication) GetElement() []byte {
	if m != nil {
		return m.Element
	}
	return nil
}

func (m *BundleApplication) GetOutputWatermarks() map[string]*timestamp.Timestamp {
	if m != nil {
		return m.OutputWatermarks
	}
	return nil
}

func (m *BundleApplication) GetBacklog() *BundleApplication_Backlog {
	if m != nil {
		return m.Backlog
	}
	return nil
}

func (m *BundleApplication) GetIsBounded() pipeline_v1.IsBounded_Enum {
	if m != nil {
		return m.IsBounded
	}
	return pipeline_v1.IsBounded_UNSPECIFIED
}

func (m *BundleApplication) GetMonitoringInfos() []*MonitoringInfo {
	if m != nil {
		return m.MonitoringInfos
	}
	return nil
}

// Represents an estimate for the amount of currently outstanding work.
type BundleApplication_Backlog struct {
	// This informs Runners on how to aggregate the backlog
	// being reported across multiple active bundles. Backlogs
	// are aggregated using the set of partitions.
	//
	// For example SplittableDoFn's which consume elements from:
	//  * a globally shared resource such as a Pubsub queue should set this
	//    to “”.
	//  * a shared partitioned resource should use the partition identifier.
	//  * a uniquely partitioned resource such as a file range should set this to
	//    file name + start offset.
	Partition []byte `protobuf:"bytes,1,opt,name=partition,proto3" json:"partition,omitempty"`
	// The estimate for the backlog.
	//
	// Types that are valid to be assigned to Value:
	//	*BundleApplication_Backlog_Bytes
	//	*BundleApplication_Backlog_IsUnknown
	Value                isBundleApplication_Backlog_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *BundleApplication_Backlog) Reset()         { *m = BundleApplication_Backlog{} }
func (m *BundleApplication_Backlog) String() string { return proto.CompactTextString(m) }
func (*BundleApplication_Backlog) ProtoMessage()    {}
func (*BundleApplication_Backlog) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{7, 1}
}

func (m *BundleApplication_Backlog) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BundleApplication_Backlog.Unmarshal(m, b)
}
func (m *BundleApplication_Backlog) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BundleApplication_Backlog.Marshal(b, m, deterministic)
}
func (m *BundleApplication_Backlog) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BundleApplication_Backlog.Merge(m, src)
}
func (m *BundleApplication_Backlog) XXX_Size() int {
	return xxx_messageInfo_BundleApplication_Backlog.Size(m)
}
func (m *BundleApplication_Backlog) XXX_DiscardUnknown() {
	xxx_messageInfo_BundleApplication_Backlog.DiscardUnknown(m)
}

var xxx_messageInfo_BundleApplication_Backlog proto.InternalMessageInfo

func (m *BundleApplication_Backlog) GetPartition() []byte {
	if m != nil {
		return m.Partition
	}
	return nil
}

type isBundleApplication_Backlog_Value interface {
	isBundleApplication_Backlog_Value()
}

type BundleApplication_Backlog_Bytes struct {
	Bytes []byte `protobuf:"bytes,1000,opt,name=bytes,proto3,oneof"`
}

type BundleApplication_Backlog_IsUnknown struct {
	IsUnknown bool `protobuf:"varint,1001,opt,name=is_unknown,json=isUnknown,proto3,oneof"`
}

func (*BundleApplication_Backlog_Bytes) isBundleApplication_Backlog_Value() {}

func (*BundleApplication_Backlog_IsUnknown) isBundleApplication_Backlog_Value() {}

func (m *BundleApplication_Backlog) GetValue() isBundleApplication_Backlog_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *BundleApplication_Backlog) GetBytes() []byte {
	if x, ok := m.GetValue().(*BundleApplication_Backlog_Bytes); ok {
		return x.Bytes
	}
	return nil
}

func (m *BundleApplication_Backlog) GetIsUnknown() bool {
	if x, ok := m.GetValue().(*BundleApplication_Backlog_IsUnknown); ok {
		return x.IsUnknown
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*BundleApplication_Backlog) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _BundleApplication_Backlog_OneofMarshaler, _BundleApplication_Backlog_OneofUnmarshaler, _BundleApplication_Backlog_OneofSizer, []interface{}{
		(*BundleApplication_Backlog_Bytes)(nil),
		(*BundleApplication_Backlog_IsUnknown)(nil),
	}
}

func _BundleApplication_Backlog_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*BundleApplication_Backlog)
	// value
	switch x := m.Value.(type) {
	case *BundleApplication_Backlog_Bytes:
		b.EncodeVarint(1000<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Bytes)
	case *BundleApplication_Backlog_IsUnknown:
		t := uint64(0)
		if x.IsUnknown {
			t = 1
		}
		b.EncodeVarint(1001<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("BundleApplication_Backlog.Value has unexpected type %T", x)
	}
	return nil
}

func _BundleApplication_Backlog_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*BundleApplication_Backlog)
	switch tag {
	case 1000: // value.bytes
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Value = &BundleApplication_Backlog_Bytes{x}
		return true, err
	case 1001: // value.is_unknown
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &BundleApplication_Backlog_IsUnknown{x != 0}
		return true, err
	default:
		return false, nil
	}
}

func _BundleApplication_Backlog_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*BundleApplication_Backlog)
	// value
	switch x := m.Value.(type) {
	case *BundleApplication_Backlog_Bytes:
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Bytes)))
		n += len(x.Bytes)
	case *BundleApplication_Backlog_IsUnknown:
		n += 2 // tag and wire
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// An Application should be scheduled for execution after a delay.
type DelayedBundleApplication struct {
	// Recommended time at which the application should be scheduled to execute
	// by the runner. Times in the past may be scheduled to execute immediately.
	RequestedExecutionTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=requested_execution_time,json=requestedExecutionTime,proto3" json:"requested_execution_time,omitempty"`
	// (Required) The application that should be scheduled.
	Application          *BundleApplication `protobuf:"bytes,2,opt,name=application,proto3" json:"application,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *DelayedBundleApplication) Reset()         { *m = DelayedBundleApplication{} }
func (m *DelayedBundleApplication) String() string { return proto.CompactTextString(m) }
func (*DelayedBundleApplication) ProtoMessage()    {}
func (*DelayedBundleApplication) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{8}
}

func (m *DelayedBundleApplication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DelayedBundleApplication.Unmarshal(m, b)
}
func (m *DelayedBundleApplication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DelayedBundleApplication.Marshal(b, m, deterministic)
}
func (m *DelayedBundleApplication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DelayedBundleApplication.Merge(m, src)
}
func (m *DelayedBundleApplication) XXX_Size() int {
	return xxx_messageInfo_DelayedBundleApplication.Size(m)
}
func (m *DelayedBundleApplication) XXX_DiscardUnknown() {
	xxx_messageInfo_DelayedBundleApplication.DiscardUnknown(m)
}

var xxx_messageInfo_DelayedBundleApplication proto.InternalMessageInfo

func (m *DelayedBundleApplication) GetRequestedExecutionTime() *timestamp.Timestamp {
	if m != nil {
		return m.RequestedExecutionTime
	}
	return nil
}

func (m *DelayedBundleApplication) GetApplication() *BundleApplication {
	if m != nil {
		return m.Application
	}
	return nil
}

// A request to process a given bundle.
// Stable
type ProcessBundleRequest struct {
	// (Required) A reference to the process bundle descriptor that must be
	// instantiated and executed by the SDK harness.
	ProcessBundleDescriptorReference string `protobuf:"bytes,1,opt,name=process_bundle_descriptor_reference,json=processBundleDescriptorReference,proto3" json:"process_bundle_descriptor_reference,omitempty"`
	// (Optional) A list of cache tokens that can be used by an SDK to reuse
	// cached data returned by the State API across multiple bundles.
	CacheTokens          [][]byte `protobuf:"bytes,2,rep,name=cache_tokens,json=cacheTokens,proto3" json:"cache_tokens,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleRequest) Reset()         { *m = ProcessBundleRequest{} }
func (m *ProcessBundleRequest) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleRequest) ProtoMessage()    {}
func (*ProcessBundleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{9}
}

func (m *ProcessBundleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleRequest.Unmarshal(m, b)
}
func (m *ProcessBundleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleRequest.Marshal(b, m, deterministic)
}
func (m *ProcessBundleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleRequest.Merge(m, src)
}
func (m *ProcessBundleRequest) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleRequest.Size(m)
}
func (m *ProcessBundleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleRequest proto.InternalMessageInfo

func (m *ProcessBundleRequest) GetProcessBundleDescriptorReference() string {
	if m != nil {
		return m.ProcessBundleDescriptorReference
	}
	return ""
}

func (m *ProcessBundleRequest) GetCacheTokens() [][]byte {
	if m != nil {
		return m.CacheTokens
	}
	return nil
}

type ProcessBundleResponse struct {
	// (Optional) If metrics reporting is supported by the SDK, this represents
	// the final metrics to record for this bundle.
	// DEPRECATED
	Metrics *Metrics `protobuf:"bytes,1,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// (Optional) Specifies that the bundle has not been completed and the
	// following applications need to be scheduled and executed in the future.
	ResidualRoots []*DelayedBundleApplication `protobuf:"bytes,2,rep,name=residual_roots,json=residualRoots,proto3" json:"residual_roots,omitempty"`
	// (Required) The list of metrics or other MonitoredState
	// collected while processing this bundle.
	MonitoringInfos []*MonitoringInfo `protobuf:"bytes,3,rep,name=monitoring_infos,json=monitoringInfos,proto3" json:"monitoring_infos,omitempty"`
	// (Optional) Specifies that the runner must callback to this worker
	// once the output of the bundle is committed. The Runner must send a
	// FinalizeBundleRequest with the instruction id of the ProcessBundleRequest
	// that is related to this ProcessBundleResponse.
	RequiresFinalization bool     `protobuf:"varint,4,opt,name=requires_finalization,json=requiresFinalization,proto3" json:"requires_finalization,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleResponse) Reset()         { *m = ProcessBundleResponse{} }
func (m *ProcessBundleResponse) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleResponse) ProtoMessage()    {}
func (*ProcessBundleResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{10}
}

func (m *ProcessBundleResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleResponse.Unmarshal(m, b)
}
func (m *ProcessBundleResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleResponse.Marshal(b, m, deterministic)
}
func (m *ProcessBundleResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleResponse.Merge(m, src)
}
func (m *ProcessBundleResponse) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleResponse.Size(m)
}
func (m *ProcessBundleResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleResponse proto.InternalMessageInfo

func (m *ProcessBundleResponse) GetMetrics() *Metrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *ProcessBundleResponse) GetResidualRoots() []*DelayedBundleApplication {
	if m != nil {
		return m.ResidualRoots
	}
	return nil
}

func (m *ProcessBundleResponse) GetMonitoringInfos() []*MonitoringInfo {
	if m != nil {
		return m.MonitoringInfos
	}
	return nil
}

func (m *ProcessBundleResponse) GetRequiresFinalization() bool {
	if m != nil {
		return m.RequiresFinalization
	}
	return false
}

// A request to report progress information for a given bundle.
// This is an optional request to be handled and is used to support advanced
// SDK features such as SplittableDoFn, user level metrics etc.
type ProcessBundleProgressRequest struct {
	// (Required) A reference to an active process bundle request with the given
	// instruction id.
	InstructionReference string   `protobuf:"bytes,1,opt,name=instruction_reference,json=instructionReference,proto3" json:"instruction_reference,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleProgressRequest) Reset()         { *m = ProcessBundleProgressRequest{} }
func (m *ProcessBundleProgressRequest) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleProgressRequest) ProtoMessage()    {}
func (*ProcessBundleProgressRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{11}
}

func (m *ProcessBundleProgressRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleProgressRequest.Unmarshal(m, b)
}
func (m *ProcessBundleProgressRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleProgressRequest.Marshal(b, m, deterministic)
}
func (m *ProcessBundleProgressRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleProgressRequest.Merge(m, src)
}
func (m *ProcessBundleProgressRequest) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleProgressRequest.Size(m)
}
func (m *ProcessBundleProgressRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleProgressRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleProgressRequest proto.InternalMessageInfo

func (m *ProcessBundleProgressRequest) GetInstructionReference() string {
	if m != nil {
		return m.InstructionReference
	}
	return ""
}

type MonitoringInfo struct {
	// The name defining the metric or monitored state.
	Urn string `protobuf:"bytes,1,opt,name=urn,proto3" json:"urn,omitempty"`
	// This is specified as a URN that implies:
	// A message class: (Distribution, Counter, Extrema, MonitoringDataTable).
	// Sub types like field formats - int64, double, string.
	// Aggregation methods - SUM, LATEST, TOP-N, BOTTOM-N, DISTRIBUTION
	// valid values are:
	// beam:metrics:[sum_int_64|latest_int_64|top_n_int_64|bottom_n_int_64|
	//     sum_double|latest_double|top_n_double|bottom_n_double|
	//     distribution_int_64|distribution_double|monitoring_data_table
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// The Metric or monitored state.
	//
	// Types that are valid to be assigned to Data:
	//	*MonitoringInfo_MonitoringTableData
	//	*MonitoringInfo_Metric
	Data isMonitoringInfo_Data `protobuf_oneof:"data"`
	// A set of key+value labels which define the scope of the metric.
	// Either a well defined entity id for matching the enum names in
	// the MonitoringInfoLabels enum or any arbitrary label
	// set by a custom metric or user metric.
	// A monitoring system is expected to be able to aggregate the metrics together
	// for all updates having the same URN and labels.
	// Some systems such as Stackdriver will be able to aggregate the metrics
	// using a subset of the provided labels
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The walltime of the most recent update.
	// Useful for aggregation for latest types such as LatestInt64.
	Timestamp            *timestamp.Timestamp `protobuf:"bytes,6,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *MonitoringInfo) Reset()         { *m = MonitoringInfo{} }
func (m *MonitoringInfo) String() string { return proto.CompactTextString(m) }
func (*MonitoringInfo) ProtoMessage()    {}
func (*MonitoringInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{12}
}

func (m *MonitoringInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MonitoringInfo.Unmarshal(m, b)
}
func (m *MonitoringInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MonitoringInfo.Marshal(b, m, deterministic)
}
func (m *MonitoringInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MonitoringInfo.Merge(m, src)
}
func (m *MonitoringInfo) XXX_Size() int {
	return xxx_messageInfo_MonitoringInfo.Size(m)
}
func (m *MonitoringInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_MonitoringInfo.DiscardUnknown(m)
}

var xxx_messageInfo_MonitoringInfo proto.InternalMessageInfo

func (m *MonitoringInfo) GetUrn() string {
	if m != nil {
		return m.Urn
	}
	return ""
}

func (m *MonitoringInfo) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

type isMonitoringInfo_Data interface {
	isMonitoringInfo_Data()
}

type MonitoringInfo_MonitoringTableData struct {
	MonitoringTableData *MonitoringTableData `protobuf:"bytes,3,opt,name=monitoring_table_data,json=monitoringTableData,proto3,oneof"`
}

type MonitoringInfo_Metric struct {
	Metric *Metric `protobuf:"bytes,4,opt,name=metric,proto3,oneof"`
}

func (*MonitoringInfo_MonitoringTableData) isMonitoringInfo_Data() {}

func (*MonitoringInfo_Metric) isMonitoringInfo_Data() {}

func (m *MonitoringInfo) GetData() isMonitoringInfo_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *MonitoringInfo) GetMonitoringTableData() *MonitoringTableData {
	if x, ok := m.GetData().(*MonitoringInfo_MonitoringTableData); ok {
		return x.MonitoringTableData
	}
	return nil
}

func (m *MonitoringInfo) GetMetric() *Metric {
	if x, ok := m.GetData().(*MonitoringInfo_Metric); ok {
		return x.Metric
	}
	return nil
}

func (m *MonitoringInfo) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *MonitoringInfo) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*MonitoringInfo) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _MonitoringInfo_OneofMarshaler, _MonitoringInfo_OneofUnmarshaler, _MonitoringInfo_OneofSizer, []interface{}{
		(*MonitoringInfo_MonitoringTableData)(nil),
		(*MonitoringInfo_Metric)(nil),
	}
}

func _MonitoringInfo_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*MonitoringInfo)
	// data
	switch x := m.Data.(type) {
	case *MonitoringInfo_MonitoringTableData:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MonitoringTableData); err != nil {
			return err
		}
	case *MonitoringInfo_Metric:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Metric); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("MonitoringInfo.Data has unexpected type %T", x)
	}
	return nil
}

func _MonitoringInfo_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*MonitoringInfo)
	switch tag {
	case 3: // data.monitoring_table_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MonitoringTableData)
		err := b.DecodeMessage(msg)
		m.Data = &MonitoringInfo_MonitoringTableData{msg}
		return true, err
	case 4: // data.metric
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Metric)
		err := b.DecodeMessage(msg)
		m.Data = &MonitoringInfo_Metric{msg}
		return true, err
	default:
		return false, nil
	}
}

func _MonitoringInfo_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*MonitoringInfo)
	// data
	switch x := m.Data.(type) {
	case *MonitoringInfo_MonitoringTableData:
		s := proto.Size(x.MonitoringTableData)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MonitoringInfo_Metric:
		s := proto.Size(x.Metric)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type MonitoringInfoUrns struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MonitoringInfoUrns) Reset()         { *m = MonitoringInfoUrns{} }
func (m *MonitoringInfoUrns) String() string { return proto.CompactTextString(m) }
func (*MonitoringInfoUrns) ProtoMessage()    {}
func (*MonitoringInfoUrns) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{13}
}

func (m *MonitoringInfoUrns) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MonitoringInfoUrns.Unmarshal(m, b)
}
func (m *MonitoringInfoUrns) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MonitoringInfoUrns.Marshal(b, m, deterministic)
}
func (m *MonitoringInfoUrns) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MonitoringInfoUrns.Merge(m, src)
}
func (m *MonitoringInfoUrns) XXX_Size() int {
	return xxx_messageInfo_MonitoringInfoUrns.Size(m)
}
func (m *MonitoringInfoUrns) XXX_DiscardUnknown() {
	xxx_messageInfo_MonitoringInfoUrns.DiscardUnknown(m)
}

var xxx_messageInfo_MonitoringInfoUrns proto.InternalMessageInfo

type MonitoringInfoTypeUrns struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MonitoringInfoTypeUrns) Reset()         { *m = MonitoringInfoTypeUrns{} }
func (m *MonitoringInfoTypeUrns) String() string { return proto.CompactTextString(m) }
func (*MonitoringInfoTypeUrns) ProtoMessage()    {}
func (*MonitoringInfoTypeUrns) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{14}
}

func (m *MonitoringInfoTypeUrns) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MonitoringInfoTypeUrns.Unmarshal(m, b)
}
func (m *MonitoringInfoTypeUrns) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MonitoringInfoTypeUrns.Marshal(b, m, deterministic)
}
func (m *MonitoringInfoTypeUrns) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MonitoringInfoTypeUrns.Merge(m, src)
}
func (m *MonitoringInfoTypeUrns) XXX_Size() int {
	return xxx_messageInfo_MonitoringInfoTypeUrns.Size(m)
}
func (m *MonitoringInfoTypeUrns) XXX_DiscardUnknown() {
	xxx_messageInfo_MonitoringInfoTypeUrns.DiscardUnknown(m)
}

var xxx_messageInfo_MonitoringInfoTypeUrns proto.InternalMessageInfo

type Metric struct {
	// (Required) The data for this metric.
	//
	// Types that are valid to be assigned to Data:
	//	*Metric_CounterData
	//	*Metric_DistributionData
	//	*Metric_ExtremaData
	Data                 isMetric_Data `protobuf_oneof:"data"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Metric) Reset()         { *m = Metric{} }
func (m *Metric) String() string { return proto.CompactTextString(m) }
func (*Metric) ProtoMessage()    {}
func (*Metric) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{15}
}

func (m *Metric) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metric.Unmarshal(m, b)
}
func (m *Metric) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metric.Marshal(b, m, deterministic)
}
func (m *Metric) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metric.Merge(m, src)
}
func (m *Metric) XXX_Size() int {
	return xxx_messageInfo_Metric.Size(m)
}
func (m *Metric) XXX_DiscardUnknown() {
	xxx_messageInfo_Metric.DiscardUnknown(m)
}

var xxx_messageInfo_Metric proto.InternalMessageInfo

type isMetric_Data interface {
	isMetric_Data()
}

type Metric_CounterData struct {
	CounterData *CounterData `protobuf:"bytes,1,opt,name=counter_data,json=counterData,proto3,oneof"`
}

type Metric_DistributionData struct {
	DistributionData *DistributionData `protobuf:"bytes,2,opt,name=distribution_data,json=distributionData,proto3,oneof"`
}

type Metric_ExtremaData struct {
	ExtremaData *ExtremaData `protobuf:"bytes,3,opt,name=extrema_data,json=extremaData,proto3,oneof"`
}

func (*Metric_CounterData) isMetric_Data() {}

func (*Metric_DistributionData) isMetric_Data() {}

func (*Metric_ExtremaData) isMetric_Data() {}

func (m *Metric) GetData() isMetric_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Metric) GetCounterData() *CounterData {
	if x, ok := m.GetData().(*Metric_CounterData); ok {
		return x.CounterData
	}
	return nil
}

func (m *Metric) GetDistributionData() *DistributionData {
	if x, ok := m.GetData().(*Metric_DistributionData); ok {
		return x.DistributionData
	}
	return nil
}

func (m *Metric) GetExtremaData() *ExtremaData {
	if x, ok := m.GetData().(*Metric_ExtremaData); ok {
		return x.ExtremaData
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Metric) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Metric_OneofMarshaler, _Metric_OneofUnmarshaler, _Metric_OneofSizer, []interface{}{
		(*Metric_CounterData)(nil),
		(*Metric_DistributionData)(nil),
		(*Metric_ExtremaData)(nil),
	}
}

func _Metric_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Metric)
	// data
	switch x := m.Data.(type) {
	case *Metric_CounterData:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CounterData); err != nil {
			return err
		}
	case *Metric_DistributionData:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DistributionData); err != nil {
			return err
		}
	case *Metric_ExtremaData:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ExtremaData); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Metric.Data has unexpected type %T", x)
	}
	return nil
}

func _Metric_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Metric)
	switch tag {
	case 1: // data.counter_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CounterData)
		err := b.DecodeMessage(msg)
		m.Data = &Metric_CounterData{msg}
		return true, err
	case 2: // data.distribution_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DistributionData)
		err := b.DecodeMessage(msg)
		m.Data = &Metric_DistributionData{msg}
		return true, err
	case 3: // data.extrema_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ExtremaData)
		err := b.DecodeMessage(msg)
		m.Data = &Metric_ExtremaData{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Metric_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Metric)
	// data
	switch x := m.Data.(type) {
	case *Metric_CounterData:
		s := proto.Size(x.CounterData)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Metric_DistributionData:
		s := proto.Size(x.DistributionData)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Metric_ExtremaData:
		s := proto.Size(x.ExtremaData)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Data associated with a Counter or Gauge metric.
// This is designed to be compatible with metric collection
// systems such as DropWizard.
type CounterData struct {
	// Types that are valid to be assigned to Value:
	//	*CounterData_Int64Value
	//	*CounterData_DoubleValue
	//	*CounterData_StringValue
	Value                isCounterData_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *CounterData) Reset()         { *m = CounterData{} }
func (m *CounterData) String() string { return proto.CompactTextString(m) }
func (*CounterData) ProtoMessage()    {}
func (*CounterData) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{16}
}

func (m *CounterData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CounterData.Unmarshal(m, b)
}
func (m *CounterData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CounterData.Marshal(b, m, deterministic)
}
func (m *CounterData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CounterData.Merge(m, src)
}
func (m *CounterData) XXX_Size() int {
	return xxx_messageInfo_CounterData.Size(m)
}
func (m *CounterData) XXX_DiscardUnknown() {
	xxx_messageInfo_CounterData.DiscardUnknown(m)
}

var xxx_messageInfo_CounterData proto.InternalMessageInfo

type isCounterData_Value interface {
	isCounterData_Value()
}

type CounterData_Int64Value struct {
	Int64Value int64 `protobuf:"varint,1,opt,name=int64_value,json=int64Value,proto3,oneof"`
}

type CounterData_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,2,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

type CounterData_StringValue struct {
	StringValue string `protobuf:"bytes,3,opt,name=string_value,json=stringValue,proto3,oneof"`
}

func (*CounterData_Int64Value) isCounterData_Value() {}

func (*CounterData_DoubleValue) isCounterData_Value() {}

func (*CounterData_StringValue) isCounterData_Value() {}

func (m *CounterData) GetValue() isCounterData_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *CounterData) GetInt64Value() int64 {
	if x, ok := m.GetValue().(*CounterData_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (m *CounterData) GetDoubleValue() float64 {
	if x, ok := m.GetValue().(*CounterData_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *CounterData) GetStringValue() string {
	if x, ok := m.GetValue().(*CounterData_StringValue); ok {
		return x.StringValue
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CounterData) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CounterData_OneofMarshaler, _CounterData_OneofUnmarshaler, _CounterData_OneofSizer, []interface{}{
		(*CounterData_Int64Value)(nil),
		(*CounterData_DoubleValue)(nil),
		(*CounterData_StringValue)(nil),
	}
}

func _CounterData_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CounterData)
	// value
	switch x := m.Value.(type) {
	case *CounterData_Int64Value:
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Int64Value))
	case *CounterData_DoubleValue:
		b.EncodeVarint(2<<3 | proto.WireFixed64)
		b.EncodeFixed64(math.Float64bits(x.DoubleValue))
	case *CounterData_StringValue:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.StringValue)
	case nil:
	default:
		return fmt.Errorf("CounterData.Value has unexpected type %T", x)
	}
	return nil
}

func _CounterData_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CounterData)
	switch tag {
	case 1: // value.int64_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &CounterData_Int64Value{int64(x)}
		return true, err
	case 2: // value.double_value
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Value = &CounterData_DoubleValue{math.Float64frombits(x)}
		return true, err
	case 3: // value.string_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &CounterData_StringValue{x}
		return true, err
	default:
		return false, nil
	}
}

func _CounterData_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CounterData)
	// value
	switch x := m.Value.(type) {
	case *CounterData_Int64Value:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Int64Value))
	case *CounterData_DoubleValue:
		n += 1 // tag and wire
		n += 8
	case *CounterData_StringValue:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.StringValue)))
		n += len(x.StringValue)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Extrema messages are used for calculating
// Top-N/Bottom-N metrics.
type ExtremaData struct {
	// Types that are valid to be assigned to Extrema:
	//	*ExtremaData_IntExtremaData
	//	*ExtremaData_DoubleExtremaData
	Extrema              isExtremaData_Extrema `protobuf_oneof:"extrema"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExtremaData) Reset()         { *m = ExtremaData{} }
func (m *ExtremaData) String() string { return proto.CompactTextString(m) }
func (*ExtremaData) ProtoMessage()    {}
func (*ExtremaData) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{17}
}

func (m *ExtremaData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExtremaData.Unmarshal(m, b)
}
func (m *ExtremaData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExtremaData.Marshal(b, m, deterministic)
}
func (m *ExtremaData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExtremaData.Merge(m, src)
}
func (m *ExtremaData) XXX_Size() int {
	return xxx_messageInfo_ExtremaData.Size(m)
}
func (m *ExtremaData) XXX_DiscardUnknown() {
	xxx_messageInfo_ExtremaData.DiscardUnknown(m)
}

var xxx_messageInfo_ExtremaData proto.InternalMessageInfo

type isExtremaData_Extrema interface {
	isExtremaData_Extrema()
}

type ExtremaData_IntExtremaData struct {
	IntExtremaData *IntExtremaData `protobuf:"bytes,1,opt,name=int_extrema_data,json=intExtremaData,proto3,oneof"`
}

type ExtremaData_DoubleExtremaData struct {
	DoubleExtremaData *DoubleExtremaData `protobuf:"bytes,2,opt,name=double_extrema_data,json=doubleExtremaData,proto3,oneof"`
}

func (*ExtremaData_IntExtremaData) isExtremaData_Extrema() {}

func (*ExtremaData_DoubleExtremaData) isExtremaData_Extrema() {}

func (m *ExtremaData) GetExtrema() isExtremaData_Extrema {
	if m != nil {
		return m.Extrema
	}
	return nil
}

func (m *ExtremaData) GetIntExtremaData() *IntExtremaData {
	if x, ok := m.GetExtrema().(*ExtremaData_IntExtremaData); ok {
		return x.IntExtremaData
	}
	return nil
}

func (m *ExtremaData) GetDoubleExtremaData() *DoubleExtremaData {
	if x, ok := m.GetExtrema().(*ExtremaData_DoubleExtremaData); ok {
		return x.DoubleExtremaData
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ExtremaData) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ExtremaData_OneofMarshaler, _ExtremaData_OneofUnmarshaler, _ExtremaData_OneofSizer, []interface{}{
		(*ExtremaData_IntExtremaData)(nil),
		(*ExtremaData_DoubleExtremaData)(nil),
	}
}

func _ExtremaData_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ExtremaData)
	// extrema
	switch x := m.Extrema.(type) {
	case *ExtremaData_IntExtremaData:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.IntExtremaData); err != nil {
			return err
		}
	case *ExtremaData_DoubleExtremaData:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DoubleExtremaData); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ExtremaData.Extrema has unexpected type %T", x)
	}
	return nil
}

func _ExtremaData_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ExtremaData)
	switch tag {
	case 1: // extrema.int_extrema_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(IntExtremaData)
		err := b.DecodeMessage(msg)
		m.Extrema = &ExtremaData_IntExtremaData{msg}
		return true, err
	case 2: // extrema.double_extrema_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DoubleExtremaData)
		err := b.DecodeMessage(msg)
		m.Extrema = &ExtremaData_DoubleExtremaData{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ExtremaData_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ExtremaData)
	// extrema
	switch x := m.Extrema.(type) {
	case *ExtremaData_IntExtremaData:
		s := proto.Size(x.IntExtremaData)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ExtremaData_DoubleExtremaData:
		s := proto.Size(x.DoubleExtremaData)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type IntExtremaData struct {
	IntValues            []int64  `protobuf:"varint,1,rep,packed,name=int_values,json=intValues,proto3" json:"int_values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IntExtremaData) Reset()         { *m = IntExtremaData{} }
func (m *IntExtremaData) String() string { return proto.CompactTextString(m) }
func (*IntExtremaData) ProtoMessage()    {}
func (*IntExtremaData) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{18}
}

func (m *IntExtremaData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IntExtremaData.Unmarshal(m, b)
}
func (m *IntExtremaData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IntExtremaData.Marshal(b, m, deterministic)
}
func (m *IntExtremaData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntExtremaData.Merge(m, src)
}
func (m *IntExtremaData) XXX_Size() int {
	return xxx_messageInfo_IntExtremaData.Size(m)
}
func (m *IntExtremaData) XXX_DiscardUnknown() {
	xxx_messageInfo_IntExtremaData.DiscardUnknown(m)
}

var xxx_messageInfo_IntExtremaData proto.InternalMessageInfo

func (m *IntExtremaData) GetIntValues() []int64 {
	if m != nil {
		return m.IntValues
	}
	return nil
}

type DoubleExtremaData struct {
	DoubleValues         []float64 `protobuf:"fixed64,2,rep,packed,name=double_values,json=doubleValues,proto3" json:"double_values,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *DoubleExtremaData) Reset()         { *m = DoubleExtremaData{} }
func (m *DoubleExtremaData) String() string { return proto.CompactTextString(m) }
func (*DoubleExtremaData) ProtoMessage()    {}
func (*DoubleExtremaData) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{19}
}

func (m *DoubleExtremaData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DoubleExtremaData.Unmarshal(m, b)
}
func (m *DoubleExtremaData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DoubleExtremaData.Marshal(b, m, deterministic)
}
func (m *DoubleExtremaData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DoubleExtremaData.Merge(m, src)
}
func (m *DoubleExtremaData) XXX_Size() int {
	return xxx_messageInfo_DoubleExtremaData.Size(m)
}
func (m *DoubleExtremaData) XXX_DiscardUnknown() {
	xxx_messageInfo_DoubleExtremaData.DiscardUnknown(m)
}

var xxx_messageInfo_DoubleExtremaData proto.InternalMessageInfo

func (m *DoubleExtremaData) GetDoubleValues() []float64 {
	if m != nil {
		return m.DoubleValues
	}
	return nil
}

// Data associated with a distribution metric.
// This is based off of the current DistributionData metric.
// This is not a stackdriver or dropwizard compatible
// style of distribution metric.
type DistributionData struct {
	// Types that are valid to be assigned to Distribution:
	//	*DistributionData_IntDistributionData
	//	*DistributionData_DoubleDistributionData
	Distribution         isDistributionData_Distribution `protobuf_oneof:"distribution"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *DistributionData) Reset()         { *m = DistributionData{} }
func (m *DistributionData) String() string { return proto.CompactTextString(m) }
func (*DistributionData) ProtoMessage()    {}
func (*DistributionData) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{20}
}

func (m *DistributionData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DistributionData.Unmarshal(m, b)
}
func (m *DistributionData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DistributionData.Marshal(b, m, deterministic)
}
func (m *DistributionData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DistributionData.Merge(m, src)
}
func (m *DistributionData) XXX_Size() int {
	return xxx_messageInfo_DistributionData.Size(m)
}
func (m *DistributionData) XXX_DiscardUnknown() {
	xxx_messageInfo_DistributionData.DiscardUnknown(m)
}

var xxx_messageInfo_DistributionData proto.InternalMessageInfo

type isDistributionData_Distribution interface {
	isDistributionData_Distribution()
}

type DistributionData_IntDistributionData struct {
	IntDistributionData *IntDistributionData `protobuf:"bytes,1,opt,name=int_distribution_data,json=intDistributionData,proto3,oneof"`
}

type DistributionData_DoubleDistributionData struct {
	DoubleDistributionData *DoubleDistributionData `protobuf:"bytes,2,opt,name=double_distribution_data,json=doubleDistributionData,proto3,oneof"`
}

func (*DistributionData_IntDistributionData) isDistributionData_Distribution() {}

func (*DistributionData_DoubleDistributionData) isDistributionData_Distribution() {}

func (m *DistributionData) GetDistribution() isDistributionData_Distribution {
	if m != nil {
		return m.Distribution
	}
	return nil
}

func (m *DistributionData) GetIntDistributionData() *IntDistributionData {
	if x, ok := m.GetDistribution().(*DistributionData_IntDistributionData); ok {
		return x.IntDistributionData
	}
	return nil
}

func (m *DistributionData) GetDoubleDistributionData() *DoubleDistributionData {
	if x, ok := m.GetDistribution().(*DistributionData_DoubleDistributionData); ok {
		return x.DoubleDistributionData
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*DistributionData) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _DistributionData_OneofMarshaler, _DistributionData_OneofUnmarshaler, _DistributionData_OneofSizer, []interface{}{
		(*DistributionData_IntDistributionData)(nil),
		(*DistributionData_DoubleDistributionData)(nil),
	}
}

func _DistributionData_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*DistributionData)
	// distribution
	switch x := m.Distribution.(type) {
	case *DistributionData_IntDistributionData:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.IntDistributionData); err != nil {
			return err
		}
	case *DistributionData_DoubleDistributionData:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DoubleDistributionData); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("DistributionData.Distribution has unexpected type %T", x)
	}
	return nil
}

func _DistributionData_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*DistributionData)
	switch tag {
	case 1: // distribution.int_distribution_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(IntDistributionData)
		err := b.DecodeMessage(msg)
		m.Distribution = &DistributionData_IntDistributionData{msg}
		return true, err
	case 2: // distribution.double_distribution_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DoubleDistributionData)
		err := b.DecodeMessage(msg)
		m.Distribution = &DistributionData_DoubleDistributionData{msg}
		return true, err
	default:
		return false, nil
	}
}

func _DistributionData_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*DistributionData)
	// distribution
	switch x := m.Distribution.(type) {
	case *DistributionData_IntDistributionData:
		s := proto.Size(x.IntDistributionData)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *DistributionData_DoubleDistributionData:
		s := proto.Size(x.DoubleDistributionData)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type IntDistributionData struct {
	Count                int64    `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	Sum                  int64    `protobuf:"varint,2,opt,name=sum,proto3" json:"sum,omitempty"`
	Min                  int64    `protobuf:"varint,3,opt,name=min,proto3" json:"min,omitempty"`
	Max                  int64    `protobuf:"varint,4,opt,name=max,proto3" json:"max,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IntDistributionData) Reset()         { *m = IntDistributionData{} }
func (m *IntDistributionData) String() string { return proto.CompactTextString(m) }
func (*IntDistributionData) ProtoMessage()    {}
func (*IntDistributionData) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{21}
}

func (m *IntDistributionData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IntDistributionData.Unmarshal(m, b)
}
func (m *IntDistributionData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IntDistributionData.Marshal(b, m, deterministic)
}
func (m *IntDistributionData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntDistributionData.Merge(m, src)
}
func (m *IntDistributionData) XXX_Size() int {
	return xxx_messageInfo_IntDistributionData.Size(m)
}
func (m *IntDistributionData) XXX_DiscardUnknown() {
	xxx_messageInfo_IntDistributionData.DiscardUnknown(m)
}

var xxx_messageInfo_IntDistributionData proto.InternalMessageInfo

func (m *IntDistributionData) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *IntDistributionData) GetSum() int64 {
	if m != nil {
		return m.Sum
	}
	return 0
}

func (m *IntDistributionData) GetMin() int64 {
	if m != nil {
		return m.Min
	}
	return 0
}

func (m *IntDistributionData) GetMax() int64 {
	if m != nil {
		return m.Max
	}
	return 0
}

type DoubleDistributionData struct {
	Count                int64    `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	Sum                  float64  `protobuf:"fixed64,2,opt,name=sum,proto3" json:"sum,omitempty"`
	Min                  float64  `protobuf:"fixed64,3,opt,name=min,proto3" json:"min,omitempty"`
	Max                  float64  `protobuf:"fixed64,4,opt,name=max,proto3" json:"max,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DoubleDistributionData) Reset()         { *m = DoubleDistributionData{} }
func (m *DoubleDistributionData) String() string { return proto.CompactTextString(m) }
func (*DoubleDistributionData) ProtoMessage()    {}
func (*DoubleDistributionData) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{22}
}

func (m *DoubleDistributionData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DoubleDistributionData.Unmarshal(m, b)
}
func (m *DoubleDistributionData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DoubleDistributionData.Marshal(b, m, deterministic)
}
func (m *DoubleDistributionData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DoubleDistributionData.Merge(m, src)
}
func (m *DoubleDistributionData) XXX_Size() int {
	return xxx_messageInfo_DoubleDistributionData.Size(m)
}
func (m *DoubleDistributionData) XXX_DiscardUnknown() {
	xxx_messageInfo_DoubleDistributionData.DiscardUnknown(m)
}

var xxx_messageInfo_DoubleDistributionData proto.InternalMessageInfo

func (m *DoubleDistributionData) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *DoubleDistributionData) GetSum() float64 {
	if m != nil {
		return m.Sum
	}
	return 0
}

func (m *DoubleDistributionData) GetMin() float64 {
	if m != nil {
		return m.Min
	}
	return 0
}

func (m *DoubleDistributionData) GetMax() float64 {
	if m != nil {
		return m.Max
	}
	return 0
}

// General MonitoredState information which contains
// structured information which does not fit into a typical
// metric format. For example, a table of important files
// and metadata which an I/O source is reading.
// Note: Since MonitoredState is designed to be
// customizable, and allow engines to aggregate these
// metrics in custom ways.
// Engines can use custom aggregation functions for specific URNs
// by inspecting the column values.
// An SDK should always report its current state, that is all
// relevant MonitoredState for its PTransform at the current moment
// and this should be kept small.
// For example, an SDK can emit the oldest three files which
// have been waiting for data for over 1 hour.
// If an engine supports the URN with a custom aggregation then
// it can filter these and keep only the Top-3 rows based on
// how long the files have been waiting for data.
// Otherwise an engine can ignore the MonitoringTableData
// or union all the rows together into one large table and display
// them in a UI.
type MonitoringTableData struct {
	// The number of column names must match the
	// number of values in each MonitoringRow.
	ColumnNames          []string                             `protobuf:"bytes,1,rep,name=column_names,json=columnNames,proto3" json:"column_names,omitempty"`
	RowData              []*MonitoringTableData_MonitoringRow `protobuf:"bytes,2,rep,name=row_data,json=rowData,proto3" json:"row_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *MonitoringTableData) Reset()         { *m = MonitoringTableData{} }
func (m *MonitoringTableData) String() string { return proto.CompactTextString(m) }
func (*MonitoringTableData) ProtoMessage()    {}
func (*MonitoringTableData) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{23}
}

func (m *MonitoringTableData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MonitoringTableData.Unmarshal(m, b)
}
func (m *MonitoringTableData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MonitoringTableData.Marshal(b, m, deterministic)
}
func (m *MonitoringTableData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MonitoringTableData.Merge(m, src)
}
func (m *MonitoringTableData) XXX_Size() int {
	return xxx_messageInfo_MonitoringTableData.Size(m)
}
func (m *MonitoringTableData) XXX_DiscardUnknown() {
	xxx_messageInfo_MonitoringTableData.DiscardUnknown(m)
}

var xxx_messageInfo_MonitoringTableData proto.InternalMessageInfo

func (m *MonitoringTableData) GetColumnNames() []string {
	if m != nil {
		return m.ColumnNames
	}
	return nil
}

func (m *MonitoringTableData) GetRowData() []*MonitoringTableData_MonitoringRow {
	if m != nil {
		return m.RowData
	}
	return nil
}

type MonitoringTableData_MonitoringColumnValue struct {
	// Types that are valid to be assigned to Value:
	//	*MonitoringTableData_MonitoringColumnValue_Int64Value
	//	*MonitoringTableData_MonitoringColumnValue_DoubleValue
	//	*MonitoringTableData_MonitoringColumnValue_StringValue
	//	*MonitoringTableData_MonitoringColumnValue_Timestamp
	Value                isMonitoringTableData_MonitoringColumnValue_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}                                          `json:"-"`
	XXX_unrecognized     []byte                                            `json:"-"`
	XXX_sizecache        int32                                             `json:"-"`
}

func (m *MonitoringTableData_MonitoringColumnValue) Reset() {
	*m = MonitoringTableData_MonitoringColumnValue{}
}
func (m *MonitoringTableData_MonitoringColumnValue) String() string { return proto.CompactTextString(m) }
func (*MonitoringTableData_MonitoringColumnValue) ProtoMessage()    {}
func (*MonitoringTableData_MonitoringColumnValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{23, 0}
}

func (m *MonitoringTableData_MonitoringColumnValue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MonitoringTableData_MonitoringColumnValue.Unmarshal(m, b)
}
func (m *MonitoringTableData_MonitoringColumnValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MonitoringTableData_MonitoringColumnValue.Marshal(b, m, deterministic)
}
func (m *MonitoringTableData_MonitoringColumnValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MonitoringTableData_MonitoringColumnValue.Merge(m, src)
}
func (m *MonitoringTableData_MonitoringColumnValue) XXX_Size() int {
	return xxx_messageInfo_MonitoringTableData_MonitoringColumnValue.Size(m)
}
func (m *MonitoringTableData_MonitoringColumnValue) XXX_DiscardUnknown() {
	xxx_messageInfo_MonitoringTableData_MonitoringColumnValue.DiscardUnknown(m)
}

var xxx_messageInfo_MonitoringTableData_MonitoringColumnValue proto.InternalMessageInfo

type isMonitoringTableData_MonitoringColumnValue_Value interface {
	isMonitoringTableData_MonitoringColumnValue_Value()
}

type MonitoringTableData_MonitoringColumnValue_Int64Value struct {
	Int64Value int64 `protobuf:"varint,1,opt,name=int64_value,json=int64Value,proto3,oneof"`
}

type MonitoringTableData_MonitoringColumnValue_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,2,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

type MonitoringTableData_MonitoringColumnValue_StringValue struct {
	StringValue string `protobuf:"bytes,3,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type MonitoringTableData_MonitoringColumnValue_Timestamp struct {
	Timestamp *timestamp.Timestamp `protobuf:"bytes,4,opt,name=timestamp,proto3,oneof"`
}

func (*MonitoringTableData_MonitoringColumnValue_Int64Value) isMonitoringTableData_MonitoringColumnValue_Value() {
}

func (*MonitoringTableData_MonitoringColumnValue_DoubleValue) isMonitoringTableData_MonitoringColumnValue_Value() {
}

func (*MonitoringTableData_MonitoringColumnValue_StringValue) isMonitoringTableData_MonitoringColumnValue_Value() {
}

func (*MonitoringTableData_MonitoringColumnValue_Timestamp) isMonitoringTableData_MonitoringColumnValue_Value() {
}

func (m *MonitoringTableData_MonitoringColumnValue) GetValue() isMonitoringTableData_MonitoringColumnValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *MonitoringTableData_MonitoringColumnValue) GetInt64Value() int64 {
	if x, ok := m.GetValue().(*MonitoringTableData_MonitoringColumnValue_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (m *MonitoringTableData_MonitoringColumnValue) GetDoubleValue() float64 {
	if x, ok := m.GetValue().(*MonitoringTableData_MonitoringColumnValue_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *MonitoringTableData_MonitoringColumnValue) GetStringValue() string {
	if x, ok := m.GetValue().(*MonitoringTableData_MonitoringColumnValue_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (m *MonitoringTableData_MonitoringColumnValue) GetTimestamp() *timestamp.Timestamp {
	if x, ok := m.GetValue().(*MonitoringTableData_MonitoringColumnValue_Timestamp); ok {
		return x.Timestamp
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*MonitoringTableData_MonitoringColumnValue) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _MonitoringTableData_MonitoringColumnValue_OneofMarshaler, _MonitoringTableData_MonitoringColumnValue_OneofUnmarshaler, _MonitoringTableData_MonitoringColumnValue_OneofSizer, []interface{}{
		(*MonitoringTableData_MonitoringColumnValue_Int64Value)(nil),
		(*MonitoringTableData_MonitoringColumnValue_DoubleValue)(nil),
		(*MonitoringTableData_MonitoringColumnValue_StringValue)(nil),
		(*MonitoringTableData_MonitoringColumnValue_Timestamp)(nil),
	}
}

func _MonitoringTableData_MonitoringColumnValue_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*MonitoringTableData_MonitoringColumnValue)
	// value
	switch x := m.Value.(type) {
	case *MonitoringTableData_MonitoringColumnValue_Int64Value:
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Int64Value))
	case *MonitoringTableData_MonitoringColumnValue_DoubleValue:
		b.EncodeVarint(2<<3 | proto.WireFixed64)
		b.EncodeFixed64(math.Float64bits(x.DoubleValue))
	case *MonitoringTableData_MonitoringColumnValue_StringValue:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.StringValue)
	case *MonitoringTableData_MonitoringColumnValue_Timestamp:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Timestamp); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("MonitoringTableData_MonitoringColumnValue.Value has unexpected type %T", x)
	}
	return nil
}

func _MonitoringTableData_MonitoringColumnValue_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*MonitoringTableData_MonitoringColumnValue)
	switch tag {
	case 1: // value.int64_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &MonitoringTableData_MonitoringColumnValue_Int64Value{int64(x)}
		return true, err
	case 2: // value.double_value
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Value = &MonitoringTableData_MonitoringColumnValue_DoubleValue{math.Float64frombits(x)}
		return true, err
	case 3: // value.string_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &MonitoringTableData_MonitoringColumnValue_StringValue{x}
		return true, err
	case 4: // value.timestamp
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(timestamp.Timestamp)
		err := b.DecodeMessage(msg)
		m.Value = &MonitoringTableData_MonitoringColumnValue_Timestamp{msg}
		return true, err
	default:
		return false, nil
	}
}

func _MonitoringTableData_MonitoringColumnValue_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*MonitoringTableData_MonitoringColumnValue)
	// value
	switch x := m.Value.(type) {
	case *MonitoringTableData_MonitoringColumnValue_Int64Value:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Int64Value))
	case *MonitoringTableData_MonitoringColumnValue_DoubleValue:
		n += 1 // tag and wire
		n += 8
	case *MonitoringTableData_MonitoringColumnValue_StringValue:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.StringValue)))
		n += len(x.StringValue)
	case *MonitoringTableData_MonitoringColumnValue_Timestamp:
		s := proto.Size(x.Timestamp)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type MonitoringTableData_MonitoringRow struct {
	Values               []*MonitoringTableData_MonitoringColumnValue `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                     `json:"-"`
	XXX_unrecognized     []byte                                       `json:"-"`
	XXX_sizecache        int32                                        `json:"-"`
}

func (m *MonitoringTableData_MonitoringRow) Reset()         { *m = MonitoringTableData_MonitoringRow{} }
func (m *MonitoringTableData_MonitoringRow) String() string { return proto.CompactTextString(m) }
func (*MonitoringTableData_MonitoringRow) ProtoMessage()    {}
func (*MonitoringTableData_MonitoringRow) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{23, 1}
}

func (m *MonitoringTableData_MonitoringRow) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MonitoringTableData_MonitoringRow.Unmarshal(m, b)
}
func (m *MonitoringTableData_MonitoringRow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MonitoringTableData_MonitoringRow.Marshal(b, m, deterministic)
}
func (m *MonitoringTableData_MonitoringRow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MonitoringTableData_MonitoringRow.Merge(m, src)
}
func (m *MonitoringTableData_MonitoringRow) XXX_Size() int {
	return xxx_messageInfo_MonitoringTableData_MonitoringRow.Size(m)
}
func (m *MonitoringTableData_MonitoringRow) XXX_DiscardUnknown() {
	xxx_messageInfo_MonitoringTableData_MonitoringRow.DiscardUnknown(m)
}

var xxx_messageInfo_MonitoringTableData_MonitoringRow proto.InternalMessageInfo

func (m *MonitoringTableData_MonitoringRow) GetValues() []*MonitoringTableData_MonitoringColumnValue {
	if m != nil {
		return m.Values
	}
	return nil
}

// DEPRECATED
type Metrics struct {
	Ptransforms          map[string]*Metrics_PTransform `protobuf:"bytes,1,rep,name=ptransforms,proto3" json:"ptransforms,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *Metrics) Reset()         { *m = Metrics{} }
func (m *Metrics) String() string { return proto.CompactTextString(m) }
func (*Metrics) ProtoMessage()    {}
func (*Metrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{24}
}

func (m *Metrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics.Unmarshal(m, b)
}
func (m *Metrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics.Marshal(b, m, deterministic)
}
func (m *Metrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics.Merge(m, src)
}
func (m *Metrics) XXX_Size() int {
	return xxx_messageInfo_Metrics.Size(m)
}
func (m *Metrics) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics proto.InternalMessageInfo

func (m *Metrics) GetPtransforms() map[string]*Metrics_PTransform {
	if m != nil {
		return m.Ptransforms
	}
	return nil
}

// PTransform level metrics.
// These metrics are split into processed and active element groups for
// progress reporting purposes. This allows a Runner to see what is measured,
// what is estimated and what can be extrapolated to be able to accurately
// estimate the backlog of remaining work.
type Metrics_PTransform struct {
	// (Required): Metrics for processed elements.
	ProcessedElements *Metrics_PTransform_ProcessedElements `protobuf:"bytes,1,opt,name=processed_elements,json=processedElements,proto3" json:"processed_elements,omitempty"`
	// (Required): Metrics for active elements.
	ActiveElements *Metrics_PTransform_ActiveElements `protobuf:"bytes,2,opt,name=active_elements,json=activeElements,proto3" json:"active_elements,omitempty"`
	// (Optional): Map from local output name to its watermark.
	// The watermarks reported are tentative, to get a better sense of progress
	// while processing a bundle but before it is committed. At bundle commit
	// time, a Runner needs to also take into account the timers set to compute
	// the actual watermarks.
	Watermarks           map[string]int64 `protobuf:"bytes,3,rep,name=watermarks,proto3" json:"watermarks,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	User                 []*Metrics_User  `protobuf:"bytes,4,rep,name=user,proto3" json:"user,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Metrics_PTransform) Reset()         { *m = Metrics_PTransform{} }
func (m *Metrics_PTransform) String() string { return proto.CompactTextString(m) }
func (*Metrics_PTransform) ProtoMessage()    {}
func (*Metrics_PTransform) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{24, 0}
}

func (m *Metrics_PTransform) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_PTransform.Unmarshal(m, b)
}
func (m *Metrics_PTransform) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_PTransform.Marshal(b, m, deterministic)
}
func (m *Metrics_PTransform) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_PTransform.Merge(m, src)
}
func (m *Metrics_PTransform) XXX_Size() int {
	return xxx_messageInfo_Metrics_PTransform.Size(m)
}
func (m *Metrics_PTransform) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_PTransform.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_PTransform proto.InternalMessageInfo

func (m *Metrics_PTransform) GetProcessedElements() *Metrics_PTransform_ProcessedElements {
	if m != nil {
		return m.ProcessedElements
	}
	return nil
}

func (m *Metrics_PTransform) GetActiveElements() *Metrics_PTransform_ActiveElements {
	if m != nil {
		return m.ActiveElements
	}
	return nil
}

func (m *Metrics_PTransform) GetWatermarks() map[string]int64 {
	if m != nil {
		return m.Watermarks
	}
	return nil
}

func (m *Metrics_PTransform) GetUser() []*Metrics_User {
	if m != nil {
		return m.User
	}
	return nil
}

// Metrics that are measured for processed and active element groups.
type Metrics_PTransform_Measured struct {
	// (Optional) Map from local input name to number of elements processed
	// from this input.
	// If unset, assumed to be the sum of the outputs of all producers to
	// this transform (for ProcessedElements) and 0 (for ActiveElements).
	InputElementCounts map[string]int64 `protobuf:"bytes,1,rep,name=input_element_counts,json=inputElementCounts,proto3" json:"input_element_counts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// (Required) Map from local output name to number of elements produced
	// for this output.
	OutputElementCounts map[string]int64 `protobuf:"bytes,2,rep,name=output_element_counts,json=outputElementCounts,proto3" json:"output_element_counts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// (Optional) The total time spent so far in processing the elements in
	// this group, in seconds.
	TotalTimeSpent       float64  `protobuf:"fixed64,3,opt,name=total_time_spent,json=totalTimeSpent,proto3" json:"total_time_spent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Metrics_PTransform_Measured) Reset()         { *m = Metrics_PTransform_Measured{} }
func (m *Metrics_PTransform_Measured) String() string { return proto.CompactTextString(m) }
func (*Metrics_PTransform_Measured) ProtoMessage()    {}
func (*Metrics_PTransform_Measured) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{24, 0, 0}
}

func (m *Metrics_PTransform_Measured) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_PTransform_Measured.Unmarshal(m, b)
}
func (m *Metrics_PTransform_Measured) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_PTransform_Measured.Marshal(b, m, deterministic)
}
func (m *Metrics_PTransform_Measured) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_PTransform_Measured.Merge(m, src)
}
func (m *Metrics_PTransform_Measured) XXX_Size() int {
	return xxx_messageInfo_Metrics_PTransform_Measured.Size(m)
}
func (m *Metrics_PTransform_Measured) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_PTransform_Measured.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_PTransform_Measured proto.InternalMessageInfo

func (m *Metrics_PTransform_Measured) GetInputElementCounts() map[string]int64 {
	if m != nil {
		return m.InputElementCounts
	}
	return nil
}

func (m *Metrics_PTransform_Measured) GetOutputElementCounts() map[string]int64 {
	if m != nil {
		return m.OutputElementCounts
	}
	return nil
}

func (m *Metrics_PTransform_Measured) GetTotalTimeSpent() float64 {
	if m != nil {
		return m.TotalTimeSpent
	}
	return 0
}

// Metrics for fully processed elements.
type Metrics_PTransform_ProcessedElements struct {
	// (Required)
	Measured             *Metrics_PTransform_Measured `protobuf:"bytes,1,opt,name=measured,proto3" json:"measured,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *Metrics_PTransform_ProcessedElements) Reset()         { *m = Metrics_PTransform_ProcessedElements{} }
func (m *Metrics_PTransform_ProcessedElements) String() string { return proto.CompactTextString(m) }
func (*Metrics_PTransform_ProcessedElements) ProtoMessage()    {}
func (*Metrics_PTransform_ProcessedElements) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{24, 0, 1}
}

func (m *Metrics_PTransform_ProcessedElements) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_PTransform_ProcessedElements.Unmarshal(m, b)
}
func (m *Metrics_PTransform_ProcessedElements) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_PTransform_ProcessedElements.Marshal(b, m, deterministic)
}
func (m *Metrics_PTransform_ProcessedElements) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_PTransform_ProcessedElements.Merge(m, src)
}
func (m *Metrics_PTransform_ProcessedElements) XXX_Size() int {
	return xxx_messageInfo_Metrics_PTransform_ProcessedElements.Size(m)
}
func (m *Metrics_PTransform_ProcessedElements) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_PTransform_ProcessedElements.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_PTransform_ProcessedElements proto.InternalMessageInfo

func (m *Metrics_PTransform_ProcessedElements) GetMeasured() *Metrics_PTransform_Measured {
	if m != nil {
		return m.Measured
	}
	return nil
}

// Metrics for active elements.
// An element is considered active if the SDK has started but not finished
// processing it yet.
type Metrics_PTransform_ActiveElements struct {
	// (Required)
	Measured *Metrics_PTransform_Measured `protobuf:"bytes,1,opt,name=measured,proto3" json:"measured,omitempty"`
	// (Optional) Sum of estimated fraction of known work remaining for all
	// active elements, as reported by this transform.
	// If not reported, a Runner could extrapolate this from the processed
	// elements.
	// TODO: Handle the case when known work is infinite.
	FractionRemaining float64 `protobuf:"fixed64,2,opt,name=fraction_remaining,json=fractionRemaining,proto3" json:"fraction_remaining,omitempty"`
	// (Optional) Map from local output name to sum of estimated number
	// of elements remaining for this output from all active elements,
	// as reported by this transform.
	// If not reported, a Runner could extrapolate this from the processed
	// elements.
	OutputElementsRemaining map[string]int64 `protobuf:"bytes,3,rep,name=output_elements_remaining,json=outputElementsRemaining,proto3" json:"output_elements_remaining,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral    struct{}         `json:"-"`
	XXX_unrecognized        []byte           `json:"-"`
	XXX_sizecache           int32            `json:"-"`
}

func (m *Metrics_PTransform_ActiveElements) Reset()         { *m = Metrics_PTransform_ActiveElements{} }
func (m *Metrics_PTransform_ActiveElements) String() string { return proto.CompactTextString(m) }
func (*Metrics_PTransform_ActiveElements) ProtoMessage()    {}
func (*Metrics_PTransform_ActiveElements) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{24, 0, 2}
}

func (m *Metrics_PTransform_ActiveElements) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_PTransform_ActiveElements.Unmarshal(m, b)
}
func (m *Metrics_PTransform_ActiveElements) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_PTransform_ActiveElements.Marshal(b, m, deterministic)
}
func (m *Metrics_PTransform_ActiveElements) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_PTransform_ActiveElements.Merge(m, src)
}
func (m *Metrics_PTransform_ActiveElements) XXX_Size() int {
	return xxx_messageInfo_Metrics_PTransform_ActiveElements.Size(m)
}
func (m *Metrics_PTransform_ActiveElements) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_PTransform_ActiveElements.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_PTransform_ActiveElements proto.InternalMessageInfo

func (m *Metrics_PTransform_ActiveElements) GetMeasured() *Metrics_PTransform_Measured {
	if m != nil {
		return m.Measured
	}
	return nil
}

func (m *Metrics_PTransform_ActiveElements) GetFractionRemaining() float64 {
	if m != nil {
		return m.FractionRemaining
	}
	return 0
}

func (m *Metrics_PTransform_ActiveElements) GetOutputElementsRemaining() map[string]int64 {
	if m != nil {
		return m.OutputElementsRemaining
	}
	return nil
}

// User defined metrics
type Metrics_User struct {
	// (Required) The identifier for this metric.
	MetricName *Metrics_User_MetricName `protobuf:"bytes,1,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
	// (Required) The data for this metric.
	//
	// Types that are valid to be assigned to Data:
	//	*Metrics_User_CounterData_
	//	*Metrics_User_DistributionData_
	//	*Metrics_User_GaugeData_
	Data                 isMetrics_User_Data `protobuf_oneof:"data"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Metrics_User) Reset()         { *m = Metrics_User{} }
func (m *Metrics_User) String() string { return proto.CompactTextString(m) }
func (*Metrics_User) ProtoMessage()    {}
func (*Metrics_User) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{24, 1}
}

func (m *Metrics_User) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User.Unmarshal(m, b)
}
func (m *Metrics_User) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User.Marshal(b, m, deterministic)
}
func (m *Metrics_User) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User.Merge(m, src)
}
func (m *Metrics_User) XXX_Size() int {
	return xxx_messageInfo_Metrics_User.Size(m)
}
func (m *Metrics_User) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User proto.InternalMessageInfo

func (m *Metrics_User) GetMetricName() *Metrics_User_MetricName {
	if m != nil {
		return m.MetricName
	}
	return nil
}

type isMetrics_User_Data interface {
	isMetrics_User_Data()
}

type Metrics_User_CounterData_ struct {
	CounterData *Metrics_User_CounterData `protobuf:"bytes,1001,opt,name=counter_data,json=counterData,proto3,oneof"`
}

type Metrics_User_DistributionData_ struct {
	DistributionData *Metrics_User_DistributionData `protobuf:"bytes,1002,opt,name=distribution_data,json=distributionData,proto3,oneof"`
}

type Metrics_User_GaugeData_ struct {
	GaugeData *Metrics_User_GaugeData `protobuf:"bytes,1003,opt,name=gauge_data,json=gaugeData,proto3,oneof"`
}

func (*Metrics_User_CounterData_) isMetrics_User_Data() {}

func (*Metrics_User_DistributionData_) isMetrics_User_Data() {}

func (*Metrics_User_GaugeData_) isMetrics_User_Data() {}

func (m *Metrics_User) GetData() isMetrics_User_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Metrics_User) GetCounterData() *Metrics_User_CounterData {
	if x, ok := m.GetData().(*Metrics_User_CounterData_); ok {
		return x.CounterData
	}
	return nil
}

func (m *Metrics_User) GetDistributionData() *Metrics_User_DistributionData {
	if x, ok := m.GetData().(*Metrics_User_DistributionData_); ok {
		return x.DistributionData
	}
	return nil
}

func (m *Metrics_User) GetGaugeData() *Metrics_User_GaugeData {
	if x, ok := m.GetData().(*Metrics_User_GaugeData_); ok {
		return x.GaugeData
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Metrics_User) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Metrics_User_OneofMarshaler, _Metrics_User_OneofUnmarshaler, _Metrics_User_OneofSizer, []interface{}{
		(*Metrics_User_CounterData_)(nil),
		(*Metrics_User_DistributionData_)(nil),
		(*Metrics_User_GaugeData_)(nil),
	}
}

func _Metrics_User_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Metrics_User)
	// data
	switch x := m.Data.(type) {
	case *Metrics_User_CounterData_:
		b.EncodeVarint(1001<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CounterData); err != nil {
			return err
		}
	case *Metrics_User_DistributionData_:
		b.EncodeVarint(1002<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DistributionData); err != nil {
			return err
		}
	case *Metrics_User_GaugeData_:
		b.EncodeVarint(1003<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GaugeData); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Metrics_User.Data has unexpected type %T", x)
	}
	return nil
}

func _Metrics_User_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Metrics_User)
	switch tag {
	case 1001: // data.counter_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Metrics_User_CounterData)
		err := b.DecodeMessage(msg)
		m.Data = &Metrics_User_CounterData_{msg}
		return true, err
	case 1002: // data.distribution_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Metrics_User_DistributionData)
		err := b.DecodeMessage(msg)
		m.Data = &Metrics_User_DistributionData_{msg}
		return true, err
	case 1003: // data.gauge_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Metrics_User_GaugeData)
		err := b.DecodeMessage(msg)
		m.Data = &Metrics_User_GaugeData_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Metrics_User_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Metrics_User)
	// data
	switch x := m.Data.(type) {
	case *Metrics_User_CounterData_:
		s := proto.Size(x.CounterData)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Metrics_User_DistributionData_:
		s := proto.Size(x.DistributionData)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Metrics_User_GaugeData_:
		s := proto.Size(x.GaugeData)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A key for identifying a metric at the most granular level.
type Metrics_User_MetricName struct {
	// (Required): The namespace of this metric.
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// (Required): The name of this metric.
	Name                 string   `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Metrics_User_MetricName) Reset()         { *m = Metrics_User_MetricName{} }
func (m *Metrics_User_MetricName) String() string { return proto.CompactTextString(m) }
func (*Metrics_User_MetricName) ProtoMessage()    {}
func (*Metrics_User_MetricName) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{24, 1, 0}
}

func (m *Metrics_User_MetricName) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User_MetricName.Unmarshal(m, b)
}
func (m *Metrics_User_MetricName) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User_MetricName.Marshal(b, m, deterministic)
}
func (m *Metrics_User_MetricName) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User_MetricName.Merge(m, src)
}
func (m *Metrics_User_MetricName) XXX_Size() int {
	return xxx_messageInfo_Metrics_User_MetricName.Size(m)
}
func (m *Metrics_User_MetricName) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User_MetricName.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User_MetricName proto.InternalMessageInfo

func (m *Metrics_User_MetricName) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *Metrics_User_MetricName) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Data associated with a counter metric.
type Metrics_User_CounterData struct {
	Value                int64    `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Metrics_User_CounterData) Reset()         { *m = Metrics_User_CounterData{} }
func (m *Metrics_User_CounterData) String() string { return proto.CompactTextString(m) }
func (*Metrics_User_CounterData) ProtoMessage()    {}
func (*Metrics_User_CounterData) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{24, 1, 1}
}

func (m *Metrics_User_CounterData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User_CounterData.Unmarshal(m, b)
}
func (m *Metrics_User_CounterData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User_CounterData.Marshal(b, m, deterministic)
}
func (m *Metrics_User_CounterData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User_CounterData.Merge(m, src)
}
func (m *Metrics_User_CounterData) XXX_Size() int {
	return xxx_messageInfo_Metrics_User_CounterData.Size(m)
}
func (m *Metrics_User_CounterData) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User_CounterData.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User_CounterData proto.InternalMessageInfo

func (m *Metrics_User_CounterData) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

// Data associated with a distribution metric.
type Metrics_User_DistributionData struct {
	Count                int64    `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	Sum                  int64    `protobuf:"varint,2,opt,name=sum,proto3" json:"sum,omitempty"`
	Min                  int64    `protobuf:"varint,3,opt,name=min,proto3" json:"min,omitempty"`
	Max                  int64    `protobuf:"varint,4,opt,name=max,proto3" json:"max,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Metrics_User_DistributionData) Reset()         { *m = Metrics_User_DistributionData{} }
func (m *Metrics_User_DistributionData) String() string { return proto.CompactTextString(m) }
func (*Metrics_User_DistributionData) ProtoMessage()    {}
func (*Metrics_User_DistributionData) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{24, 1, 2}
}

func (m *Metrics_User_DistributionData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User_DistributionData.Unmarshal(m, b)
}
func (m *Metrics_User_DistributionData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User_DistributionData.Marshal(b, m, deterministic)
}
func (m *Metrics_User_DistributionData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User_DistributionData.Merge(m, src)
}
func (m *Metrics_User_DistributionData) XXX_Size() int {
	return xxx_messageInfo_Metrics_User_DistributionData.Size(m)
}
func (m *Metrics_User_DistributionData) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User_DistributionData.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User_DistributionData proto.InternalMessageInfo

func (m *Metrics_User_DistributionData) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *Metrics_User_DistributionData) GetSum() int64 {
	if m != nil {
		return m.Sum
	}
	return 0
}

func (m *Metrics_User_DistributionData) GetMin() int64 {
	if m != nil {
		return m.Min
	}
	return 0
}

func (m *Metrics_User_DistributionData) GetMax() int64 {
	if m != nil {
		return m.Max
	}
	return 0
}

// Data associated with a Gauge metric.
type Metrics_User_GaugeData struct {
	Value                int64                `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	Timestamp            *timestamp.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Metrics_User_GaugeData) Reset()         { *m = Metrics_User_GaugeData{} }
func (m *Metrics_User_GaugeData) String() string { return proto.CompactTextString(m) }
func (*Metrics_User_GaugeData) ProtoMessage()    {}
func (*Metrics_User_GaugeData) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{24, 1, 3}
}

func (m *Metrics_User_GaugeData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User_GaugeData.Unmarshal(m, b)
}
func (m *Metrics_User_GaugeData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User_GaugeData.Marshal(b, m, deterministic)
}
func (m *Metrics_User_GaugeData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User_GaugeData.Merge(m, src)
}
func (m *Metrics_User_GaugeData) XXX_Size() int {
	return xxx_messageInfo_Metrics_User_GaugeData.Size(m)
}
func (m *Metrics_User_GaugeData) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User_GaugeData.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User_GaugeData proto.InternalMessageInfo

func (m *Metrics_User_GaugeData) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

func (m *Metrics_User_GaugeData) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

type ProcessBundleProgressResponse struct {
	// DEPRECATED (Required)
	Metrics *Metrics `protobuf:"bytes,1,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// (Required) The list of metrics or other MonitoredState
	// collected while processing this bundle.
	MonitoringInfos []*MonitoringInfo `protobuf:"bytes,3,rep,name=monitoring_infos,json=monitoringInfos,proto3" json:"monitoring_infos,omitempty"`
	// The list of currently active primary roots that are being
	// executed. Required to be populated for PTransforms which can be split.
	PrimaryRoots         []*BundleApplication `protobuf:"bytes,4,rep,name=primary_roots,json=primaryRoots,proto3" json:"primary_roots,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ProcessBundleProgressResponse) Reset()         { *m = ProcessBundleProgressResponse{} }
func (m *ProcessBundleProgressResponse) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleProgressResponse) ProtoMessage()    {}
func (*ProcessBundleProgressResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{25}
}

func (m *ProcessBundleProgressResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleProgressResponse.Unmarshal(m, b)
}
func (m *ProcessBundleProgressResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleProgressResponse.Marshal(b, m, deterministic)
}
func (m *ProcessBundleProgressResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleProgressResponse.Merge(m, src)
}
func (m *ProcessBundleProgressResponse) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleProgressResponse.Size(m)
}
func (m *ProcessBundleProgressResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleProgressResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleProgressResponse proto.InternalMessageInfo

func (m *ProcessBundleProgressResponse) GetMetrics() *Metrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *ProcessBundleProgressResponse) GetMonitoringInfos() []*MonitoringInfo {
	if m != nil {
		return m.MonitoringInfos
	}
	return nil
}

func (m *ProcessBundleProgressResponse) GetPrimaryRoots() []*BundleApplication {
	if m != nil {
		return m.PrimaryRoots
	}
	return nil
}

// Represents a request to the SDK to split a currently active bundle.
type ProcessBundleSplitRequest struct {
	// (Required) A reference to an active process bundle request with the given
	// instruction id.
	InstructionReference string `protobuf:"bytes,1,opt,name=instruction_reference,json=instructionReference,proto3" json:"instruction_reference,omitempty"`
	// (Required) Specifies that the Runner would like the bundle to split itself
	// such that it performs no more work than the backlog specified for each
	// PTransform. The interpretation of how much work should be processed is up
	// to the PTransform.
	//
	// For example, A backlog of "" tells the SDK to perform as little work as
	// possible, effectively checkpointing when able. The remaining backlog
	// will be relative to the backlog reported during processing.
	//
	// If the backlog is unspecified for a PTransform, the runner would like
	// the SDK to process all data received for that PTransform.
	BacklogRemaining     map[string][]byte `protobuf:"bytes,2,rep,name=backlog_remaining,json=backlogRemaining,proto3" json:"backlog_remaining,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ProcessBundleSplitRequest) Reset()         { *m = ProcessBundleSplitRequest{} }
func (m *ProcessBundleSplitRequest) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleSplitRequest) ProtoMessage()    {}
func (*ProcessBundleSplitRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{26}
}

func (m *ProcessBundleSplitRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleSplitRequest.Unmarshal(m, b)
}
func (m *ProcessBundleSplitRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleSplitRequest.Marshal(b, m, deterministic)
}
func (m *ProcessBundleSplitRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleSplitRequest.Merge(m, src)
}
func (m *ProcessBundleSplitRequest) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleSplitRequest.Size(m)
}
func (m *ProcessBundleSplitRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleSplitRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleSplitRequest proto.InternalMessageInfo

func (m *ProcessBundleSplitRequest) GetInstructionReference() string {
	if m != nil {
		return m.InstructionReference
	}
	return ""
}

func (m *ProcessBundleSplitRequest) GetBacklogRemaining() map[string][]byte {
	if m != nil {
		return m.BacklogRemaining
	}
	return nil
}

// Represents a partition of the bundle: a "primary" and
// a "residual", with the following properties:
// - The work in primary and residual doesn't overlap, and combined, adds up
//   to the work in the current bundle if the split hadn't happened.
// - The current bundle, if it keeps executing, will have done none of the
//   work under residual_roots.
// - The current bundle, if no further splits happen, will have done exactly
//   the work under primary_roots.
// For more rigorous definitions see https://s.apache.org/beam-breaking-fusion
type ProcessBundleSplitResponse struct {
	// Root applications that should replace the current bundle.
	PrimaryRoots []*BundleApplication `protobuf:"bytes,1,rep,name=primary_roots,json=primaryRoots,proto3" json:"primary_roots,omitempty"`
	// Root applications that have been removed from the current bundle and
	// have to be executed in a separate bundle (e.g. in parallel on a different
	// worker, or after the current bundle completes, etc.)
	ResidualRoots        []*DelayedBundleApplication `protobuf:"bytes,2,rep,name=residual_roots,json=residualRoots,proto3" json:"residual_roots,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *ProcessBundleSplitResponse) Reset()         { *m = ProcessBundleSplitResponse{} }
func (m *ProcessBundleSplitResponse) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleSplitResponse) ProtoMessage()    {}
func (*ProcessBundleSplitResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{27}
}

func (m *ProcessBundleSplitResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleSplitResponse.Unmarshal(m, b)
}
func (m *ProcessBundleSplitResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleSplitResponse.Marshal(b, m, deterministic)
}
func (m *ProcessBundleSplitResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleSplitResponse.Merge(m, src)
}
func (m *ProcessBundleSplitResponse) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleSplitResponse.Size(m)
}
func (m *ProcessBundleSplitResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleSplitResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleSplitResponse proto.InternalMessageInfo

func (m *ProcessBundleSplitResponse) GetPrimaryRoots() []*BundleApplication {
	if m != nil {
		return m.PrimaryRoots
	}
	return nil
}

func (m *ProcessBundleSplitResponse) GetResidualRoots() []*DelayedBundleApplication {
	if m != nil {
		return m.ResidualRoots
	}
	return nil
}

type FinalizeBundleRequest struct {
	// (Required) A reference to a completed process bundle request with the given
	// instruction id.
	InstructionReference string   `protobuf:"bytes,1,opt,name=instruction_reference,json=instructionReference,proto3" json:"instruction_reference,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FinalizeBundleRequest) Reset()         { *m = FinalizeBundleRequest{} }
func (m *FinalizeBundleRequest) String() string { return proto.CompactTextString(m) }
func (*FinalizeBundleRequest) ProtoMessage()    {}
func (*FinalizeBundleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{28}
}

func (m *FinalizeBundleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinalizeBundleRequest.Unmarshal(m, b)
}
func (m *FinalizeBundleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinalizeBundleRequest.Marshal(b, m, deterministic)
}
func (m *FinalizeBundleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinalizeBundleRequest.Merge(m, src)
}
func (m *FinalizeBundleRequest) XXX_Size() int {
	return xxx_messageInfo_FinalizeBundleRequest.Size(m)
}
func (m *FinalizeBundleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FinalizeBundleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FinalizeBundleRequest proto.InternalMessageInfo

func (m *FinalizeBundleRequest) GetInstructionReference() string {
	if m != nil {
		return m.InstructionReference
	}
	return ""
}

type FinalizeBundleResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FinalizeBundleResponse) Reset()         { *m = FinalizeBundleResponse{} }
func (m *FinalizeBundleResponse) String() string { return proto.CompactTextString(m) }
func (*FinalizeBundleResponse) ProtoMessage()    {}
func (*FinalizeBundleResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{29}
}

func (m *FinalizeBundleResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinalizeBundleResponse.Unmarshal(m, b)
}
func (m *FinalizeBundleResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinalizeBundleResponse.Marshal(b, m, deterministic)
}
func (m *FinalizeBundleResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinalizeBundleResponse.Merge(m, src)
}
func (m *FinalizeBundleResponse) XXX_Size() int {
	return xxx_messageInfo_FinalizeBundleResponse.Size(m)
}
func (m *FinalizeBundleResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FinalizeBundleResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FinalizeBundleResponse proto.InternalMessageInfo

// Messages used to represent logical byte streams.
// Stable
type Elements struct {
	// (Required) A list containing parts of logical byte streams.
	Data                 []*Elements_Data `protobuf:"bytes,1,rep,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Elements) Reset()         { *m = Elements{} }
func (m *Elements) String() string { return proto.CompactTextString(m) }
func (*Elements) ProtoMessage()    {}
func (*Elements) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{30}
}

func (m *Elements) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Elements.Unmarshal(m, b)
}
func (m *Elements) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Elements.Marshal(b, m, deterministic)
}
func (m *Elements) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Elements.Merge(m, src)
}
func (m *Elements) XXX_Size() int {
	return xxx_messageInfo_Elements.Size(m)
}
func (m *Elements) XXX_DiscardUnknown() {
	xxx_messageInfo_Elements.DiscardUnknown(m)
}

var xxx_messageInfo_Elements proto.InternalMessageInfo

func (m *Elements) GetData() []*Elements_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

// Represents multiple encoded elements in nested context for a given named
// instruction and target.
type Elements_Data struct {
	// (Required) A reference to an active instruction request with the given
	// instruction id.
	InstructionReference string `protobuf:"bytes,1,opt,name=instruction_reference,json=instructionReference,proto3" json:"instruction_reference,omitempty"`
	// (Required) A definition representing a consumer or producer of this data.
	// If received by a harness, this represents the consumer within that
	// harness that should consume these bytes. If sent by a harness, this
	// represents the producer of these bytes.
	//
	// Note that a single element may span multiple Data messages.
	//
	// Note that a sending/receiving pair should share the same target
	// identifier.
	Target *Target `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
	// (Optional) Represents a part of a logical byte stream. Elements within
	// the logical byte stream are encoded in the nested context and
	// concatenated together.
	//
	// An empty data block represents the end of stream for the given
	// instruction and target.
	Data                 []byte   `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Elements_Data) Reset()         { *m = Elements_Data{} }
func (m *Elements_Data) String() string { return proto.CompactTextString(m) }
func (*Elements_Data) ProtoMessage()    {}
func (*Elements_Data) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{30, 0}
}

func (m *Elements_Data) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Elements_Data.Unmarshal(m, b)
}
func (m *Elements_Data) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Elements_Data.Marshal(b, m, deterministic)
}
func (m *Elements_Data) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Elements_Data.Merge(m, src)
}
func (m *Elements_Data) XXX_Size() int {
	return xxx_messageInfo_Elements_Data.Size(m)
}
func (m *Elements_Data) XXX_DiscardUnknown() {
	xxx_messageInfo_Elements_Data.DiscardUnknown(m)
}

var xxx_messageInfo_Elements_Data proto.InternalMessageInfo

func (m *Elements_Data) GetInstructionReference() string {
	if m != nil {
		return m.InstructionReference
	}
	return ""
}

func (m *Elements_Data) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *Elements_Data) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type StateRequest struct {
	// (Required) An unique identifier provided by the SDK which represents this
	// requests execution. The StateResponse corresponding with this request
	// will have the matching id.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// (Required) The associated instruction id of the work that is currently
	// being processed. This allows for the runner to associate any modifications
	// to state to be committed with the appropriate work execution.
	InstructionReference string `protobuf:"bytes,2,opt,name=instruction_reference,json=instructionReference,proto3" json:"instruction_reference,omitempty"`
	// (Required) The state key this request is for.
	StateKey *StateKey `protobuf:"bytes,3,opt,name=state_key,json=stateKey,proto3" json:"state_key,omitempty"`
	// (Required) The action to take on this request.
	//
	// Types that are valid to be assigned to Request:
	//	*StateRequest_Get
	//	*StateRequest_Append
	//	*StateRequest_Clear
	Request              isStateRequest_Request `protobuf_oneof:"request"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *StateRequest) Reset()         { *m = StateRequest{} }
func (m *StateRequest) String() string { return proto.CompactTextString(m) }
func (*StateRequest) ProtoMessage()    {}
func (*StateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{31}
}

func (m *StateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateRequest.Unmarshal(m, b)
}
func (m *StateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateRequest.Marshal(b, m, deterministic)
}
func (m *StateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateRequest.Merge(m, src)
}
func (m *StateRequest) XXX_Size() int {
	return xxx_messageInfo_StateRequest.Size(m)
}
func (m *StateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateRequest proto.InternalMessageInfo

func (m *StateRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *StateRequest) GetInstructionReference() string {
	if m != nil {
		return m.InstructionReference
	}
	return ""
}

func (m *StateRequest) GetStateKey() *StateKey {
	if m != nil {
		return m.StateKey
	}
	return nil
}

type isStateRequest_Request interface {
	isStateRequest_Request()
}

type StateRequest_Get struct {
	Get *StateGetRequest `protobuf:"bytes,1000,opt,name=get,proto3,oneof"`
}

type StateRequest_Append struct {
	Append *StateAppendRequest `protobuf:"bytes,1001,opt,name=append,proto3,oneof"`
}

type StateRequest_Clear struct {
	Clear *StateClearRequest `protobuf:"bytes,1002,opt,name=clear,proto3,oneof"`
}

func (*StateRequest_Get) isStateRequest_Request() {}

func (*StateRequest_Append) isStateRequest_Request() {}

func (*StateRequest_Clear) isStateRequest_Request() {}

func (m *StateRequest) GetRequest() isStateRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *StateRequest) GetGet() *StateGetRequest {
	if x, ok := m.GetRequest().(*StateRequest_Get); ok {
		return x.Get
	}
	return nil
}

func (m *StateRequest) GetAppend() *StateAppendRequest {
	if x, ok := m.GetRequest().(*StateRequest_Append); ok {
		return x.Append
	}
	return nil
}

func (m *StateRequest) GetClear() *StateClearRequest {
	if x, ok := m.GetRequest().(*StateRequest_Clear); ok {
		return x.Clear
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StateRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StateRequest_OneofMarshaler, _StateRequest_OneofUnmarshaler, _StateRequest_OneofSizer, []interface{}{
		(*StateRequest_Get)(nil),
		(*StateRequest_Append)(nil),
		(*StateRequest_Clear)(nil),
	}
}

func _StateRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StateRequest)
	// request
	switch x := m.Request.(type) {
	case *StateRequest_Get:
		b.EncodeVarint(1000<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Get); err != nil {
			return err
		}
	case *StateRequest_Append:
		b.EncodeVarint(1001<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Append); err != nil {
			return err
		}
	case *StateRequest_Clear:
		b.EncodeVarint(1002<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Clear); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StateRequest.Request has unexpected type %T", x)
	}
	return nil
}

func _StateRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StateRequest)
	switch tag {
	case 1000: // request.get
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateGetRequest)
		err := b.DecodeMessage(msg)
		m.Request = &StateRequest_Get{msg}
		return true, err
	case 1001: // request.append
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateAppendRequest)
		err := b.DecodeMessage(msg)
		m.Request = &StateRequest_Append{msg}
		return true, err
	case 1002: // request.clear
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateClearRequest)
		err := b.DecodeMessage(msg)
		m.Request = &StateRequest_Clear{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StateRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StateRequest)
	// request
	switch x := m.Request.(type) {
	case *StateRequest_Get:
		s := proto.Size(x.Get)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateRequest_Append:
		s := proto.Size(x.Append)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateRequest_Clear:
		s := proto.Size(x.Clear)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type StateResponse struct {
	// (Required) A reference provided by the SDK which represents a requests
	// execution. The StateResponse must have the matching id when responding
	// to the SDK.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// (Optional) If this is specified, then the state request has failed.
	// A human readable string representing the reason as to why the request
	// failed.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// (Optional) If this is specified, then the result of this state request
	// can be cached using the supplied token.
	CacheToken []byte `protobuf:"bytes,3,opt,name=cache_token,json=cacheToken,proto3" json:"cache_token,omitempty"`
	// A corresponding response matching the request will be populated.
	//
	// Types that are valid to be assigned to Response:
	//	*StateResponse_Get
	//	*StateResponse_Append
	//	*StateResponse_Clear
	Response             isStateResponse_Response `protobuf_oneof:"response"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *StateResponse) Reset()         { *m = StateResponse{} }
func (m *StateResponse) String() string { return proto.CompactTextString(m) }
func (*StateResponse) ProtoMessage()    {}
func (*StateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{32}
}

func (m *StateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateResponse.Unmarshal(m, b)
}
func (m *StateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateResponse.Marshal(b, m, deterministic)
}
func (m *StateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateResponse.Merge(m, src)
}
func (m *StateResponse) XXX_Size() int {
	return xxx_messageInfo_StateResponse.Size(m)
}
func (m *StateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateResponse proto.InternalMessageInfo

func (m *StateResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *StateResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *StateResponse) GetCacheToken() []byte {
	if m != nil {
		return m.CacheToken
	}
	return nil
}

type isStateResponse_Response interface {
	isStateResponse_Response()
}

type StateResponse_Get struct {
	Get *StateGetResponse `protobuf:"bytes,1000,opt,name=get,proto3,oneof"`
}

type StateResponse_Append struct {
	Append *StateAppendResponse `protobuf:"bytes,1001,opt,name=append,proto3,oneof"`
}

type StateResponse_Clear struct {
	Clear *StateClearResponse `protobuf:"bytes,1002,opt,name=clear,proto3,oneof"`
}

func (*StateResponse_Get) isStateResponse_Response() {}

func (*StateResponse_Append) isStateResponse_Response() {}

func (*StateResponse_Clear) isStateResponse_Response() {}

func (m *StateResponse) GetResponse() isStateResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *StateResponse) GetGet() *StateGetResponse {
	if x, ok := m.GetResponse().(*StateResponse_Get); ok {
		return x.Get
	}
	return nil
}

func (m *StateResponse) GetAppend() *StateAppendResponse {
	if x, ok := m.GetResponse().(*StateResponse_Append); ok {
		return x.Append
	}
	return nil
}

func (m *StateResponse) GetClear() *StateClearResponse {
	if x, ok := m.GetResponse().(*StateResponse_Clear); ok {
		return x.Clear
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StateResponse) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StateResponse_OneofMarshaler, _StateResponse_OneofUnmarshaler, _StateResponse_OneofSizer, []interface{}{
		(*StateResponse_Get)(nil),
		(*StateResponse_Append)(nil),
		(*StateResponse_Clear)(nil),
	}
}

func _StateResponse_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StateResponse)
	// response
	switch x := m.Response.(type) {
	case *StateResponse_Get:
		b.EncodeVarint(1000<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Get); err != nil {
			return err
		}
	case *StateResponse_Append:
		b.EncodeVarint(1001<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Append); err != nil {
			return err
		}
	case *StateResponse_Clear:
		b.EncodeVarint(1002<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Clear); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StateResponse.Response has unexpected type %T", x)
	}
	return nil
}

func _StateResponse_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StateResponse)
	switch tag {
	case 1000: // response.get
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateGetResponse)
		err := b.DecodeMessage(msg)
		m.Response = &StateResponse_Get{msg}
		return true, err
	case 1001: // response.append
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateAppendResponse)
		err := b.DecodeMessage(msg)
		m.Response = &StateResponse_Append{msg}
		return true, err
	case 1002: // response.clear
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateClearResponse)
		err := b.DecodeMessage(msg)
		m.Response = &StateResponse_Clear{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StateResponse_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StateResponse)
	// response
	switch x := m.Response.(type) {
	case *StateResponse_Get:
		s := proto.Size(x.Get)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateResponse_Append:
		s := proto.Size(x.Append)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateResponse_Clear:
		s := proto.Size(x.Clear)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type StateKey struct {
	// (Required) One of the following state keys must be set.
	//
	// Types that are valid to be assigned to Type:
	//	*StateKey_Runner_
	//	*StateKey_MultimapSideInput_
	//	*StateKey_BagUserState_
	Type                 isStateKey_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *StateKey) Reset()         { *m = StateKey{} }
func (m *StateKey) String() string { return proto.CompactTextString(m) }
func (*StateKey) ProtoMessage()    {}
func (*StateKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{33}
}

func (m *StateKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey.Unmarshal(m, b)
}
func (m *StateKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey.Marshal(b, m, deterministic)
}
func (m *StateKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey.Merge(m, src)
}
func (m *StateKey) XXX_Size() int {
	return xxx_messageInfo_StateKey.Size(m)
}
func (m *StateKey) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey proto.InternalMessageInfo

type isStateKey_Type interface {
	isStateKey_Type()
}

type StateKey_Runner_ struct {
	Runner *StateKey_Runner `protobuf:"bytes,1,opt,name=runner,proto3,oneof"`
}

type StateKey_MultimapSideInput_ struct {
	MultimapSideInput *StateKey_MultimapSideInput `protobuf:"bytes,2,opt,name=multimap_side_input,json=multimapSideInput,proto3,oneof"`
}

type StateKey_BagUserState_ struct {
	BagUserState *StateKey_BagUserState `protobuf:"bytes,3,opt,name=bag_user_state,json=bagUserState,proto3,oneof"`
}

func (*StateKey_Runner_) isStateKey_Type() {}

func (*StateKey_MultimapSideInput_) isStateKey_Type() {}

func (*StateKey_BagUserState_) isStateKey_Type() {}

func (m *StateKey) GetType() isStateKey_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *StateKey) GetRunner() *StateKey_Runner {
	if x, ok := m.GetType().(*StateKey_Runner_); ok {
		return x.Runner
	}
	return nil
}

func (m *StateKey) GetMultimapSideInput() *StateKey_MultimapSideInput {
	if x, ok := m.GetType().(*StateKey_MultimapSideInput_); ok {
		return x.MultimapSideInput
	}
	return nil
}

func (m *StateKey) GetBagUserState() *StateKey_BagUserState {
	if x, ok := m.GetType().(*StateKey_BagUserState_); ok {
		return x.BagUserState
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StateKey) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StateKey_OneofMarshaler, _StateKey_OneofUnmarshaler, _StateKey_OneofSizer, []interface{}{
		(*StateKey_Runner_)(nil),
		(*StateKey_MultimapSideInput_)(nil),
		(*StateKey_BagUserState_)(nil),
	}
}

func _StateKey_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StateKey)
	// type
	switch x := m.Type.(type) {
	case *StateKey_Runner_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Runner); err != nil {
			return err
		}
	case *StateKey_MultimapSideInput_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MultimapSideInput); err != nil {
			return err
		}
	case *StateKey_BagUserState_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BagUserState); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StateKey.Type has unexpected type %T", x)
	}
	return nil
}

func _StateKey_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StateKey)
	switch tag {
	case 1: // type.runner
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateKey_Runner)
		err := b.DecodeMessage(msg)
		m.Type = &StateKey_Runner_{msg}
		return true, err
	case 2: // type.multimap_side_input
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateKey_MultimapSideInput)
		err := b.DecodeMessage(msg)
		m.Type = &StateKey_MultimapSideInput_{msg}
		return true, err
	case 3: // type.bag_user_state
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateKey_BagUserState)
		err := b.DecodeMessage(msg)
		m.Type = &StateKey_BagUserState_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StateKey_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StateKey)
	// type
	switch x := m.Type.(type) {
	case *StateKey_Runner_:
		s := proto.Size(x.Runner)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateKey_MultimapSideInput_:
		s := proto.Size(x.MultimapSideInput)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateKey_BagUserState_:
		s := proto.Size(x.BagUserState)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type StateKey_Runner struct {
	// (Required) Opaque information supplied by the runner. Used to support
	// remote references.
	Key                  []byte   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateKey_Runner) Reset()         { *m = StateKey_Runner{} }
func (m *StateKey_Runner) String() string { return proto.CompactTextString(m) }
func (*StateKey_Runner) ProtoMessage()    {}
func (*StateKey_Runner) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{33, 0}
}

func (m *StateKey_Runner) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey_Runner.Unmarshal(m, b)
}
func (m *StateKey_Runner) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey_Runner.Marshal(b, m, deterministic)
}
func (m *StateKey_Runner) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey_Runner.Merge(m, src)
}
func (m *StateKey_Runner) XXX_Size() int {
	return xxx_messageInfo_StateKey_Runner.Size(m)
}
func (m *StateKey_Runner) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey_Runner.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey_Runner proto.InternalMessageInfo

func (m *StateKey_Runner) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

type StateKey_MultimapSideInput struct {
	// (Required) The id of the PTransform containing a side input.
	PtransformId string `protobuf:"bytes,1,opt,name=ptransform_id,json=ptransformId,proto3" json:"ptransform_id,omitempty"`
	// (Required) The id of the side input.
	SideInputId string `protobuf:"bytes,2,opt,name=side_input_id,json=sideInputId,proto3" json:"side_input_id,omitempty"`
	// (Required) The window (after mapping the currently executing elements
	// window into the side input windows domain) encoded in a nested context.
	Window []byte `protobuf:"bytes,3,opt,name=window,proto3" json:"window,omitempty"`
	// (Required) The key encoded in a nested context.
	Key                  []byte   `protobuf:"bytes,4,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateKey_MultimapSideInput) Reset()         { *m = StateKey_MultimapSideInput{} }
func (m *StateKey_MultimapSideInput) String() string { return proto.CompactTextString(m) }
func (*StateKey_MultimapSideInput) ProtoMessage()    {}
func (*StateKey_MultimapSideInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{33, 1}
}

func (m *StateKey_MultimapSideInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey_MultimapSideInput.Unmarshal(m, b)
}
func (m *StateKey_MultimapSideInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey_MultimapSideInput.Marshal(b, m, deterministic)
}
func (m *StateKey_MultimapSideInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey_MultimapSideInput.Merge(m, src)
}
func (m *StateKey_MultimapSideInput) XXX_Size() int {
	return xxx_messageInfo_StateKey_MultimapSideInput.Size(m)
}
func (m *StateKey_MultimapSideInput) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey_MultimapSideInput.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey_MultimapSideInput proto.InternalMessageInfo

func (m *StateKey_MultimapSideInput) GetPtransformId() string {
	if m != nil {
		return m.PtransformId
	}
	return ""
}

func (m *StateKey_MultimapSideInput) GetSideInputId() string {
	if m != nil {
		return m.SideInputId
	}
	return ""
}

func (m *StateKey_MultimapSideInput) GetWindow() []byte {
	if m != nil {
		return m.Window
	}
	return nil
}

func (m *StateKey_MultimapSideInput) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

type StateKey_BagUserState struct {
	// (Required) The id of the PTransform containing user state.
	PtransformId string `protobuf:"bytes,1,opt,name=ptransform_id,json=ptransformId,proto3" json:"ptransform_id,omitempty"`
	// (Required) The id of the user state.
	UserStateId string `protobuf:"bytes,2,opt,name=user_state_id,json=userStateId,proto3" json:"user_state_id,omitempty"`
	// (Required) The window encoded in a nested context.
	Window []byte `protobuf:"bytes,3,opt,name=window,proto3" json:"window,omitempty"`
	// (Required) The key of the currently executing element encoded in a
	// nested context.
	Key                  []byte   `protobuf:"bytes,4,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateKey_BagUserState) Reset()         { *m = StateKey_BagUserState{} }
func (m *StateKey_BagUserState) String() string { return proto.CompactTextString(m) }
func (*StateKey_BagUserState) ProtoMessage()    {}
func (*StateKey_BagUserState) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{33, 2}
}

func (m *StateKey_BagUserState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey_BagUserState.Unmarshal(m, b)
}
func (m *StateKey_BagUserState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey_BagUserState.Marshal(b, m, deterministic)
}
func (m *StateKey_BagUserState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey_BagUserState.Merge(m, src)
}
func (m *StateKey_BagUserState) XXX_Size() int {
	return xxx_messageInfo_StateKey_BagUserState.Size(m)
}
func (m *StateKey_BagUserState) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey_BagUserState.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey_BagUserState proto.InternalMessageInfo

func (m *StateKey_BagUserState) GetPtransformId() string {
	if m != nil {
		return m.PtransformId
	}
	return ""
}

func (m *StateKey_BagUserState) GetUserStateId() string {
	if m != nil {
		return m.UserStateId
	}
	return ""
}

func (m *StateKey_BagUserState) GetWindow() []byte {
	if m != nil {
		return m.Window
	}
	return nil
}

func (m *StateKey_BagUserState) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

// A request to get state.
type StateGetRequest struct {
	// (Optional) If specified, signals to the runner that the response
	// should resume from the following continuation token.
	//
	// If unspecified, signals to the runner that the response should start
	// from the beginning of the logical continuable stream.
	ContinuationToken    []byte   `protobuf:"bytes,1,opt,name=continuation_token,json=continuationToken,proto3" json:"continuation_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateGetRequest) Reset()         { *m = StateGetRequest{} }
func (m *StateGetRequest) String() string { return proto.CompactTextString(m) }
func (*StateGetRequest) ProtoMessage()    {}
func (*StateGetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{34}
}

func (m *StateGetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateGetRequest.Unmarshal(m, b)
}
func (m *StateGetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateGetRequest.Marshal(b, m, deterministic)
}
func (m *StateGetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateGetRequest.Merge(m, src)
}
func (m *StateGetRequest) XXX_Size() int {
	return xxx_messageInfo_StateGetRequest.Size(m)
}
func (m *StateGetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateGetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateGetRequest proto.InternalMessageInfo

func (m *StateGetRequest) GetContinuationToken() []byte {
	if m != nil {
		return m.ContinuationToken
	}
	return nil
}

// A response to get state representing a logical byte stream which can be
// continued using the state API.
type StateGetResponse struct {
	// (Optional) If specified, represents a token which can be used with the
	// state API to get the next chunk of this logical byte stream. The end of
	// the logical byte stream is signalled by this field being unset.
	ContinuationToken []byte `protobuf:"bytes,1,opt,name=continuation_token,json=continuationToken,proto3" json:"continuation_token,omitempty"`
	// Represents a part of a logical byte stream. Elements within
	// the logical byte stream are encoded in the nested context and
	// concatenated together.
	Data                 []byte   `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateGetResponse) Reset()         { *m = StateGetResponse{} }
func (m *StateGetResponse) String() string { return proto.CompactTextString(m) }
func (*StateGetResponse) ProtoMessage()    {}
func (*StateGetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{35}
}

func (m *StateGetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateGetResponse.Unmarshal(m, b)
}
func (m *StateGetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateGetResponse.Marshal(b, m, deterministic)
}
func (m *StateGetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateGetResponse.Merge(m, src)
}
func (m *StateGetResponse) XXX_Size() int {
	return xxx_messageInfo_StateGetResponse.Size(m)
}
func (m *StateGetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateGetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateGetResponse proto.InternalMessageInfo

func (m *StateGetResponse) GetContinuationToken() []byte {
	if m != nil {
		return m.ContinuationToken
	}
	return nil
}

func (m *StateGetResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// A request to append state.
type StateAppendRequest struct {
	// Represents a part of a logical byte stream. Elements within
	// the logical byte stream are encoded in the nested context and
	// multiple append requests are concatenated together.
	Data                 []byte   `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateAppendRequest) Reset()         { *m = StateAppendRequest{} }
func (m *StateAppendRequest) String() string { return proto.CompactTextString(m) }
func (*StateAppendRequest) ProtoMessage()    {}
func (*StateAppendRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{36}
}

func (m *StateAppendRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateAppendRequest.Unmarshal(m, b)
}
func (m *StateAppendRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateAppendRequest.Marshal(b, m, deterministic)
}
func (m *StateAppendRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateAppendRequest.Merge(m, src)
}
func (m *StateAppendRequest) XXX_Size() int {
	return xxx_messageInfo_StateAppendRequest.Size(m)
}
func (m *StateAppendRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateAppendRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateAppendRequest proto.InternalMessageInfo

func (m *StateAppendRequest) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// A response to append state.
type StateAppendResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateAppendResponse) Reset()         { *m = StateAppendResponse{} }
func (m *StateAppendResponse) String() string { return proto.CompactTextString(m) }
func (*StateAppendResponse) ProtoMessage()    {}
func (*StateAppendResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{37}
}

func (m *StateAppendResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateAppendResponse.Unmarshal(m, b)
}
func (m *StateAppendResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateAppendResponse.Marshal(b, m, deterministic)
}
func (m *StateAppendResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateAppendResponse.Merge(m, src)
}
func (m *StateAppendResponse) XXX_Size() int {
	return xxx_messageInfo_StateAppendResponse.Size(m)
}
func (m *StateAppendResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateAppendResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateAppendResponse proto.InternalMessageInfo

// A request to clear state.
type StateClearRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateClearRequest) Reset()         { *m = StateClearRequest{} }
func (m *StateClearRequest) String() string { return proto.CompactTextString(m) }
func (*StateClearRequest) ProtoMessage()    {}
func (*StateClearRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{38}
}

func (m *StateClearRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateClearRequest.Unmarshal(m, b)
}
func (m *StateClearRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateClearRequest.Marshal(b, m, deterministic)
}
func (m *StateClearRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateClearRequest.Merge(m, src)
}
func (m *StateClearRequest) XXX_Size() int {
	return xxx_messageInfo_StateClearRequest.Size(m)
}
func (m *StateClearRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateClearRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateClearRequest proto.InternalMessageInfo

// A response to clear state.
type StateClearResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateClearResponse) Reset()         { *m = StateClearResponse{} }
func (m *StateClearResponse) String() string { return proto.CompactTextString(m) }
func (*StateClearResponse) ProtoMessage()    {}
func (*StateClearResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{39}
}

func (m *StateClearResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateClearResponse.Unmarshal(m, b)
}
func (m *StateClearResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateClearResponse.Marshal(b, m, deterministic)
}
func (m *StateClearResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateClearResponse.Merge(m, src)
}
func (m *StateClearResponse) XXX_Size() int {
	return xxx_messageInfo_StateClearResponse.Size(m)
}
func (m *StateClearResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateClearResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateClearResponse proto.InternalMessageInfo

// A log entry
type LogEntry struct {
	// (Required) The severity of the log statement.
	Severity LogEntry_Severity_Enum `protobuf:"varint,1,opt,name=severity,proto3,enum=org.apache.beam.model.fn_execution.v1.LogEntry_Severity_Enum" json:"severity,omitempty"`
	// (Required) The time at which this log statement occurred.
	Timestamp *timestamp.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// (Required) A human readable message.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	// (Optional) An optional trace of the functions involved. For example, in
	// Java this can include multiple causes and multiple suppressed exceptions.
	Trace string `protobuf:"bytes,4,opt,name=trace,proto3" json:"trace,omitempty"`
	// (Optional) A reference to the instruction this log statement is associated
	// with.
	InstructionReference string `protobuf:"bytes,5,opt,name=instruction_reference,json=instructionReference,proto3" json:"instruction_reference,omitempty"`
	// (Optional) A reference to the primitive transform this log statement is
	// associated with.
	PrimitiveTransformReference string `protobuf:"bytes,6,opt,name=primitive_transform_reference,json=primitiveTransformReference,proto3" json:"primitive_transform_reference,omitempty"`
	// (Optional) Human-readable name of the function or method being invoked,
	// with optional context such as the class or package name. The format can
	// vary by language. For example:
	//   qual.if.ied.Class.method (Java)
	//   dir/package.func (Go)
	//   module.function (Python)
	//   file.cc:382 (C++)
	LogLocation string `protobuf:"bytes,7,opt,name=log_location,json=logLocation,proto3" json:"log_location,omitempty"`
	// (Optional) The name of the thread this log statement is associated with.
	Thread               string   `protobuf:"bytes,8,opt,name=thread,proto3" json:"thread,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogEntry) Reset()         { *m = LogEntry{} }
func (m *LogEntry) String() string { return proto.CompactTextString(m) }
func (*LogEntry) ProtoMessage()    {}
func (*LogEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{40}
}

func (m *LogEntry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogEntry.Unmarshal(m, b)
}
func (m *LogEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogEntry.Marshal(b, m, deterministic)
}
func (m *LogEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry.Merge(m, src)
}
func (m *LogEntry) XXX_Size() int {
	return xxx_messageInfo_LogEntry.Size(m)
}
func (m *LogEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry proto.InternalMessageInfo

func (m *LogEntry) GetSeverity() LogEntry_Severity_Enum {
	if m != nil {
		return m.Severity
	}
	return LogEntry_Severity_UNSPECIFIED
}

func (m *LogEntry) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *LogEntry) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *LogEntry) GetTrace() string {
	if m != nil {
		return m.Trace
	}
	return ""
}

func (m *LogEntry) GetInstructionReference() string {
	if m != nil {
		return m.InstructionReference
	}
	return ""
}

func (m *LogEntry) GetPrimitiveTransformReference() string {
	if m != nil {
		return m.PrimitiveTransformReference
	}
	return ""
}

func (m *LogEntry) GetLogLocation() string {
	if m != nil {
		return m.LogLocation
	}
	return ""
}

func (m *LogEntry) GetThread() string {
	if m != nil {
		return m.Thread
	}
	return ""
}

// A list of log entries, enables buffering and batching of multiple
// log messages using the logging API.
type LogEntry_List struct {
	// (Required) One or or more log messages.
	LogEntries           []*LogEntry `protobuf:"bytes,1,rep,name=log_entries,json=logEntries,proto3" json:"log_entries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *LogEntry_List) Reset()         { *m = LogEntry_List{} }
func (m *LogEntry_List) String() string { return proto.CompactTextString(m) }
func (*LogEntry_List) ProtoMessage()    {}
func (*LogEntry_List) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{40, 0}
}

func (m *LogEntry_List) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogEntry_List.Unmarshal(m, b)
}
func (m *LogEntry_List) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogEntry_List.Marshal(b, m, deterministic)
}
func (m *LogEntry_List) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry_List.Merge(m, src)
}
func (m *LogEntry_List) XXX_Size() int {
	return xxx_messageInfo_LogEntry_List.Size(m)
}
func (m *LogEntry_List) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry_List.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry_List proto.InternalMessageInfo

func (m *LogEntry_List) GetLogEntries() []*LogEntry {
	if m != nil {
		return m.LogEntries
	}
	return nil
}

// The severity of the event described in a log entry, expressed as one of the
// severity levels listed below. For your reference, the levels are
// assigned the listed numeric values. The effect of using numeric values
// other than those listed is undefined.
//
// If you are writing log entries, you should map other severity encodings to
// one of these standard levels. For example, you might map all of
// Java's FINE, FINER, and FINEST levels to `Severity.DEBUG`.
//
// This list is intentionally not comprehensive; the intent is to provide a
// common set of "good enough" severity levels so that logging front ends
// can provide filtering and searching across log types. Users of the API are
// free not to use all severity levels in their log messages.
type LogEntry_Severity struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogEntry_Severity) Reset()         { *m = LogEntry_Severity{} }
func (m *LogEntry_Severity) String() string { return proto.CompactTextString(m) }
func (*LogEntry_Severity) ProtoMessage()    {}
func (*LogEntry_Severity) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{40, 1}
}

func (m *LogEntry_Severity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogEntry_Severity.Unmarshal(m, b)
}
func (m *LogEntry_Severity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogEntry_Severity.Marshal(b, m, deterministic)
}
func (m *LogEntry_Severity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry_Severity.Merge(m, src)
}
func (m *LogEntry_Severity) XXX_Size() int {
	return xxx_messageInfo_LogEntry_Severity.Size(m)
}
func (m *LogEntry_Severity) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry_Severity.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry_Severity proto.InternalMessageInfo

type LogControl struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogControl) Reset()         { *m = LogControl{} }
func (m *LogControl) String() string { return proto.CompactTextString(m) }
func (*LogControl) ProtoMessage()    {}
func (*LogControl) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{41}
}

func (m *LogControl) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogControl.Unmarshal(m, b)
}
func (m *LogControl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogControl.Marshal(b, m, deterministic)
}
func (m *LogControl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogControl.Merge(m, src)
}
func (m *LogControl) XXX_Size() int {
	return xxx_messageInfo_LogControl.Size(m)
}
func (m *LogControl) XXX_DiscardUnknown() {
	xxx_messageInfo_LogControl.DiscardUnknown(m)
}

var xxx_messageInfo_LogControl proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("org.apache.beam.model.fn_execution.v1.MonitoringInfo_MonitoringInfoLabels", MonitoringInfo_MonitoringInfoLabels_name, MonitoringInfo_MonitoringInfoLabels_value)
	proto.RegisterEnum("org.apache.beam.model.fn_execution.v1.MonitoringInfoUrns_Enum", MonitoringInfoUrns_Enum_name, MonitoringInfoUrns_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.fn_execution.v1.MonitoringInfoTypeUrns_Enum", MonitoringInfoTypeUrns_Enum_name, MonitoringInfoTypeUrns_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.fn_execution.v1.LogEntry_Severity_Enum", LogEntry_Severity_Enum_name, LogEntry_Severity_Enum_value)
	proto.RegisterType((*Target)(nil), "org.apache.beam.model.fn_execution.v1.Target")
	proto.RegisterType((*Target_List)(nil), "org.apache.beam.model.fn_execution.v1.Target.List")
	proto.RegisterType((*RemoteGrpcPort)(nil), "org.apache.beam.model.fn_execution.v1.RemoteGrpcPort")
	proto.RegisterType((*InstructionRequest)(nil), "org.apache.beam.model.fn_execution.v1.InstructionRequest")
	proto.RegisterType((*InstructionResponse)(nil), "org.apache.beam.model.fn_execution.v1.InstructionResponse")
	proto.RegisterType((*RegisterRequest)(nil), "org.apache.beam.model.fn_execution.v1.RegisterRequest")
	proto.RegisterType((*RegisterResponse)(nil), "org.apache.beam.model.fn_execution.v1.RegisterResponse")
	proto.RegisterType((*ProcessBundleDescriptor)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor")
	proto.RegisterMapType((map[string]*pipeline_v1.Coder)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.CodersEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.Environment)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.EnvironmentsEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.PCollection)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.PcollectionsEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.PTransform)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.TransformsEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.WindowingStrategy)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.WindowingStrategiesEntry")
	proto.RegisterType((*BundleApplication)(nil), "org.apache.beam.model.fn_execution.v1.BundleApplication")
	proto.RegisterMapType((map[string]*timestamp.Timestamp)(nil), "org.apache.beam.model.fn_execution.v1.BundleApplication.OutputWatermarksEntry")
	proto.RegisterType((*BundleApplication_Backlog)(nil), "org.apache.beam.model.fn_execution.v1.BundleApplication.Backlog")
	proto.RegisterType((*DelayedBundleApplication)(nil), "org.apache.beam.model.fn_execution.v1.DelayedBundleApplication")
	proto.RegisterType((*ProcessBundleRequest)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleRequest")
	proto.RegisterType((*ProcessBundleResponse)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleResponse")
	proto.RegisterType((*ProcessBundleProgressRequest)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleProgressRequest")
	proto.RegisterType((*MonitoringInfo)(nil), "org.apache.beam.model.fn_execution.v1.MonitoringInfo")
	proto.RegisterMapType((map[string]string)(nil), "org.apache.beam.model.fn_execution.v1.MonitoringInfo.LabelsEntry")
	proto.RegisterType((*MonitoringInfoUrns)(nil), "org.apache.beam.model.fn_execution.v1.MonitoringInfoUrns")
	proto.RegisterType((*MonitoringInfoTypeUrns)(nil), "org.apache.beam.model.fn_execution.v1.MonitoringInfoTypeUrns")
	proto.RegisterType((*Metric)(nil), "org.apache.beam.model.fn_execution.v1.Metric")
	proto.RegisterType((*CounterData)(nil), "org.apache.beam.model.fn_execution.v1.CounterData")
	proto.RegisterType((*ExtremaData)(nil), "org.apache.beam.model.fn_execution.v1.ExtremaData")
	proto.RegisterType((*IntExtremaData)(nil), "org.apache.beam.model.fn_execution.v1.IntExtremaData")
	proto.RegisterType((*DoubleExtremaData)(nil), "org.apache.beam.model.fn_execution.v1.DoubleExtremaData")
	proto.RegisterType((*DistributionData)(nil), "org.apache.beam.model.fn_execution.v1.DistributionData")
	proto.RegisterType((*IntDistributionData)(nil), "org.apache.beam.model.fn_execution.v1.IntDistributionData")
	proto.RegisterType((*DoubleDistributionData)(nil), "org.apache.beam.model.fn_execution.v1.DoubleDistributionData")
	proto.RegisterType((*MonitoringTableData)(nil), "org.apache.beam.model.fn_execution.v1.MonitoringTableData")
	proto.RegisterType((*MonitoringTableData_MonitoringColumnValue)(nil), "org.apache.beam.model.fn_execution.v1.MonitoringTableData.MonitoringColumnValue")
	proto.RegisterType((*MonitoringTableData_MonitoringRow)(nil), "org.apache.beam.model.fn_execution.v1.MonitoringTableData.MonitoringRow")
	proto.RegisterType((*Metrics)(nil), "org.apache.beam.model.fn_execution.v1.Metrics")
	proto.RegisterMapType((map[string]*Metrics_PTransform)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PtransformsEntry")
	proto.RegisterType((*Metrics_PTransform)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform")
	proto.RegisterMapType((map[string]int64)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.WatermarksEntry")
	proto.RegisterType((*Metrics_PTransform_Measured)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.Measured")
	proto.RegisterMapType((map[string]int64)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.Measured.InputElementCountsEntry")
	proto.RegisterMapType((map[string]int64)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.Measured.OutputElementCountsEntry")
	proto.RegisterType((*Metrics_PTransform_ProcessedElements)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.ProcessedElements")
	proto.RegisterType((*Metrics_PTransform_ActiveElements)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.ActiveElements")
	proto.RegisterMapType((map[string]int64)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.ActiveElements.OutputElementsRemainingEntry")
	proto.RegisterType((*Metrics_User)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User")
	proto.RegisterType((*Metrics_User_MetricName)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User.MetricName")
	proto.RegisterType((*Metrics_User_CounterData)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User.CounterData")
	proto.RegisterType((*Metrics_User_DistributionData)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User.DistributionData")
	proto.RegisterType((*Metrics_User_GaugeData)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User.GaugeData")
	proto.RegisterType((*ProcessBundleProgressResponse)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleProgressResponse")
	proto.RegisterType((*ProcessBundleSplitRequest)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest")
	proto.RegisterMapType((map[string][]byte)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest.BacklogRemainingEntry")
	proto.RegisterType((*ProcessBundleSplitResponse)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse")
	proto.RegisterType((*FinalizeBundleRequest)(nil), "org.apache.beam.model.fn_execution.v1.FinalizeBundleRequest")
	proto.RegisterType((*FinalizeBundleResponse)(nil), "org.apache.beam.model.fn_execution.v1.FinalizeBundleResponse")
	proto.RegisterType((*Elements)(nil), "org.apache.beam.model.fn_execution.v1.Elements")
	proto.RegisterType((*Elements_Data)(nil), "org.apache.beam.model.fn_execution.v1.Elements.Data")
	proto.RegisterType((*StateRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateRequest")
	proto.RegisterType((*StateResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateResponse")
	proto.RegisterType((*StateKey)(nil), "org.apache.beam.model.fn_execution.v1.StateKey")
	proto.RegisterType((*StateKey_Runner)(nil), "org.apache.beam.model.fn_execution.v1.StateKey.Runner")
	proto.RegisterType((*StateKey_MultimapSideInput)(nil), "org.apache.beam.model.fn_execution.v1.StateKey.MultimapSideInput")
	proto.RegisterType((*StateKey_BagUserState)(nil), "org.apache.beam.model.fn_execution.v1.StateKey.BagUserState")
	proto.RegisterType((*StateGetRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateGetRequest")
	proto.RegisterType((*StateGetResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateGetResponse")
	proto.RegisterType((*StateAppendRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateAppendRequest")
	proto.RegisterType((*StateAppendResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateAppendResponse")
	proto.RegisterType((*StateClearRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateClearRequest")
	proto.RegisterType((*StateClearResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateClearResponse")
	proto.RegisterType((*LogEntry)(nil), "org.apache.beam.model.fn_execution.v1.LogEntry")
	proto.RegisterType((*LogEntry_List)(nil), "org.apache.beam.model.fn_execution.v1.LogEntry.List")
	proto.RegisterType((*LogEntry_Severity)(nil), "org.apache.beam.model.fn_execution.v1.LogEntry.Severity")
	proto.RegisterType((*LogControl)(nil), "org.apache.beam.model.fn_execution.v1.LogControl")
}

func init() { proto.RegisterFile("beam_fn_api.proto", fileDescriptor_6d954c03a4758710) }

var fileDescriptor_6d954c03a4758710 = []byte{
	// 3753 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x5b, 0xdb, 0x73, 0x23, 0xd9,
	0x59, 0x77, 0x4b, 0xb2, 0x64, 0x7d, 0x92, 0x65, 0xe9, 0xf8, 0xa6, 0x69, 0x66, 0x89, 0xb7, 0x97,
	0x50, 0xf3, 0x12, 0x4d, 0xe6, 0x92, 0xb9, 0x98, 0xdd, 0x49, 0x24, 0x59, 0x1e, 0x6b, 0x57, 0x96,
	0x4d, 0x4b, 0x9e, 0xd9, 0xdd, 0x14, 0x69, 0xda, 0xea, 0x63, 0x4d, 0x67, 0xa4, 0xee, 0x4e, 0x77,
	0xcb, 0x1e, 0x2f, 0x29, 0x28, 0x48, 0x55, 0xb8, 0x14, 0xd4, 0xbe, 0x51, 0x29, 0x78, 0x22, 0xbc,
	0xe5, 0x85, 0x17, 0x28, 0xde, 0x79, 0x01, 0xaa, 0xa8, 0xa2, 0xe0, 0x15, 0x8a, 0xa2, 0x8a, 0x50,
	0x04, 0x02, 0xff, 0x00, 0x4f, 0xa9, 0x73, 0xe9, 0xab, 0x24, 0x5b, 0x92, 0x27, 0xfb, 0xa6, 0x73,
	0xf9, 0x7e, 0xbf, 0xef, 0x7c, 0xe7, 0x3b, 0xdf, 0xf9, 0xce, 0xe9, 0x23, 0x28, 0x9d, 0x62, 0x75,
	0xa8, 0x9c, 0x19, 0x8a, 0x6a, 0xe9, 0x15, 0xcb, 0x36, 0x5d, 0x13, 0x7d, 0xd9, 0xb4, 0xfb, 0x15,
	0xd5, 0x52, 0x7b, 0xaf, 0x70, 0x85, 0xb4, 0x56, 0x86, 0xa6, 0x86, 0x07, 0x95, 0x33, 0x43, 0xc1,
	0x6f, 0x70, 0x6f, 0xe4, 0xea, 0xa6, 0x51, 0x39, 0xbf, 0x27, 0x6e, 0x52, 0x49, 0x7b, 0x64, 0x18,
	0xd8, 0x0e, 0xa4, 0xc5, 0x35, 0x6c, 0x68, 0x96, 0xa9, 0x1b, 0xae, 0xc3, 0x2b, 0x76, 0xfa, 0xa6,
	0xd9, 0x1f, 0xe0, 0xbb, 0xb4, 0x74, 0x3a, 0x3a, 0xbb, 0xab, 0x61, 0xa7, 0x67, 0xeb, 0x96, 0x6b,
	0xda, 0xbc, 0xc7, 0x97, 0xe2, 0x3d, 0x5c, 0x7d, 0x88, 0x1d, 0x57, 0x1d, 0x5a, 0xbc, 0xc3, 0x2f,
	0xc6, 0x3b, 0x5c, 0xd8, 0xaa, 0x65, 0x61, 0x9b, 0x53, 0x48, 0x7f, 0x21, 0x40, 0xba, 0xab, 0xda,
	0x7d, 0xec, 0xa2, 0x1a, 0xbc, 0x63, 0xd9, 0xfa, 0x50, 0x77, 0xf5, 0x73, 0xac, 0xb8, 0xb6, 0x6a,
	0x38, 0x67, 0xa6, 0x3d, 0x54, 0x6c, 0x7c, 0x86, 0x6d, 0x6c, 0xf4, 0x70, 0x59, 0xd8, 0x11, 0xee,
	0x64, 0xe5, 0x5f, 0xf0, 0x3b, 0x75, 0xbd, 0x3e, 0xb2, 0xd7, 0x05, 0x21, 0x48, 0x19, 0xea, 0x10,
	0x97, 0x13, 0xb4, 0x2b, 0xfd, 0x2d, 0x1e, 0x42, 0xaa, 0xa5, 0x3b, 0x2e, 0x6a, 0x40, 0xda, 0xa5,
	0x4c, 0x65, 0x61, 0x27, 0x79, 0x27, 0x77, 0xff, 0x2b, 0x95, 0x99, 0xac, 0x55, 0x61, 0xea, 0xc9,
	0x5c, 0x58, 0xfa, 0x13, 0x01, 0x0a, 0x32, 0x1e, 0x9a, 0x2e, 0x7e, 0x6e, 0x5b, 0xbd, 0x63, 0xd3,
	0x76, 0xd1, 0x10, 0xb6, 0x54, 0x4b, 0x57, 0x1c, 0x6c, 0x9f, 0xeb, 0x3d, 0xac, 0x04, 0x56, 0xa2,
	0x2a, 0xe7, 0xee, 0x3f, 0x9e, 0xc2, 0x64, 0xe9, 0x16, 0x1e, 0xe8, 0x06, 0x26, 0x2c, 0x55, 0x4b,
	0xef, 0x30, 0xf9, 0x3d, 0x5f, 0x5c, 0xde, 0x50, 0x27, 0xd4, 0xa2, 0x5b, 0xb0, 0xd2, 0x33, 0x35,
	0x6c, 0x2b, 0xba, 0xc6, 0x07, 0x9a, 0xa1, 0xe5, 0xa6, 0x26, 0xfd, 0x67, 0x0a, 0x50, 0xd3, 0x70,
	0x5c, 0x7b, 0xd4, 0x23, 0xea, 0xcb, 0xf8, 0x3b, 0x23, 0xec, 0xb8, 0xe8, 0xcb, 0x50, 0xd0, 0x83,
	0x5a, 0x22, 0xc7, 0x6c, 0xb9, 0x1a, 0xaa, 0x6d, 0x6a, 0xe8, 0x04, 0x56, 0x6c, 0xdc, 0xd7, 0x1d,
	0x17, 0xdb, 0xe5, 0x9f, 0x64, 0xa8, 0xea, 0x8f, 0x66, 0x34, 0x92, 0xcc, 0xe5, 0x38, 0xe3, 0xc1,
	0x92, 0xec, 0x43, 0x21, 0x0c, 0x05, 0xcb, 0x36, 0x7b, 0xd8, 0x71, 0x94, 0xd3, 0x91, 0xa1, 0x0d,
	0x70, 0xf9, 0xbf, 0x19, 0xf8, 0xaf, 0xcc, 0x08, 0x7e, 0xcc, 0xa4, 0x6b, 0x54, 0x38, 0x60, 0x58,
	0xb5, 0xc2, 0xf5, 0xe8, 0x37, 0x61, 0x3b, 0x4a, 0xa3, 0x58, 0xb6, 0xd9, 0xb7, 0xb1, 0xe3, 0x94,
	0xff, 0x87, 0xf1, 0xd5, 0x17, 0xe1, 0x3b, 0xe6, 0x20, 0x01, 0xef, 0xa6, 0x35, 0xa9, 0x1d, 0x8d,
	0x60, 0x23, 0xc6, 0xef, 0x58, 0x03, 0xdd, 0x2d, 0xff, 0x94, 0x91, 0x7f, 0x63, 0x11, 0xf2, 0x0e,
	0x41, 0x08, 0x98, 0x91, 0x35, 0xd6, 0x88, 0x5e, 0xc1, 0xda, 0x99, 0x6e, 0xa8, 0x03, 0xfd, 0x33,
	0xec, 0x99, 0xf7, 0x7f, 0x19, 0xe3, 0xfb, 0x33, 0x32, 0xee, 0x73, 0xf1, 0xb8, 0x7d, 0x0b, 0x67,
	0x91, 0x86, 0x5a, 0x16, 0x32, 0x36, 0x6b, 0x94, 0x7e, 0x67, 0x19, 0xd6, 0x23, 0x7e, 0xe6, 0x58,
	0xa6, 0xe1, 0xe0, 0x59, 0x1d, 0x6d, 0x03, 0x96, 0xb1, 0x6d, 0x9b, 0x36, 0x77, 0x5f, 0x56, 0x40,
	0x2f, 0xc6, 0xdd, 0xef, 0xf1, 0xdc, 0xee, 0xc7, 0x14, 0x89, 0xf8, 0xdf, 0xd9, 0x34, 0xff, 0x7b,
	0x7f, 0x31, 0xff, 0xf3, 0x29, 0x62, 0x0e, 0xf8, 0x5b, 0xd7, 0x3a, 0xe0, 0xde, 0xcd, 0x1c, 0xd0,
	0x27, 0x9e, 0xe2, 0x81, 0xe7, 0x57, 0x7b, 0x60, 0xf5, 0x06, 0x1e, 0xe8, 0x53, 0x4f, 0x72, 0x41,
	0x7d, 0xaa, 0x0b, 0x7e, 0xb0, 0xa0, 0x0b, 0xfa, 0x74, 0x71, 0x1f, 0x04, 0xe2, 0x23, 0xac, 0x55,
	0xfa, 0x23, 0x01, 0xd6, 0x62, 0x71, 0x07, 0x7d, 0x06, 0xb7, 0x62, 0x26, 0x88, 0x44, 0x63, 0x12,
	0xf7, 0x9f, 0x2d, 0x62, 0x86, 0x50, 0x50, 0xde, 0xb6, 0x26, 0x37, 0x48, 0x08, 0x8a, 0x71, 0x3f,
	0x94, 0xfe, 0x1c, 0x60, 0x7b, 0x0a, 0x10, 0x2a, 0x40, 0xc2, 0x5f, 0x20, 0x09, 0x5d, 0x43, 0x06,
	0x80, 0xbf, 0xed, 0x39, 0xe5, 0x04, 0x55, 0xb6, 0x7d, 0x33, 0x65, 0x2b, 0xfe, 0x1e, 0xe9, 0x34,
	0x0c, 0xd7, 0xbe, 0x94, 0x43, 0x0c, 0xc8, 0x85, 0xbc, 0xd5, 0x33, 0x07, 0x03, 0x4c, 0x97, 0xa5,
	0x53, 0x4e, 0x52, 0xc6, 0xe3, 0x1b, 0x32, 0x1e, 0x87, 0x20, 0x19, 0x67, 0x84, 0x05, 0xfd, 0x81,
	0x00, 0x1b, 0x17, 0xba, 0xa1, 0x99, 0x17, 0xba, 0xd1, 0x57, 0x1c, 0xd7, 0x56, 0x5d, 0xdc, 0xd7,
	0xb1, 0x53, 0x4e, 0x51, 0xfa, 0x97, 0x37, 0xa4, 0x7f, 0xe9, 0x41, 0x77, 0x7c, 0x64, 0xa6, 0xc5,
	0xfa, 0xc5, 0x78, 0x0b, 0x3a, 0x85, 0x34, 0xdd, 0x3a, 0x9d, 0xf2, 0x32, 0x65, 0xff, 0xf0, 0x86,
	0xec, 0x75, 0x0a, 0xc6, 0x08, 0x39, 0x32, 0x31, 0x33, 0x36, 0xce, 0x75, 0xdb, 0x34, 0x86, 0xd8,
	0x70, 0x9d, 0x72, 0xfa, 0xad, 0x98, 0xb9, 0x11, 0x82, 0xe4, 0x66, 0x0e, 0xb3, 0xa0, 0x37, 0x70,
	0xdb, 0x71, 0x55, 0x17, 0x2b, 0x53, 0x32, 0x93, 0xcc, 0xcd, 0x32, 0x93, 0x5b, 0x14, 0x7c, 0x52,
	0x93, 0x38, 0x80, 0xb5, 0x98, 0xd7, 0xa1, 0x22, 0x24, 0x5f, 0xe3, 0x4b, 0xee, 0xea, 0xe4, 0x27,
	0xaa, 0xc3, 0xf2, 0xb9, 0x3a, 0x18, 0xb1, 0x4c, 0x6d, 0x7a, 0x2e, 0x16, 0xd6, 0xe3, 0x38, 0xc8,
	0xf7, 0x98, 0xec, 0x6e, 0xe2, 0x89, 0x20, 0x9a, 0x50, 0x1a, 0xf3, 0xb8, 0x09, 0x7c, 0x7b, 0x51,
	0xbe, 0xca, 0x2c, 0x7c, 0x75, 0x1f, 0x36, 0x4c, 0xf8, 0x5d, 0x28, 0x4f, 0xf3, 0xb1, 0x09, 0xbc,
	0x1f, 0x46, 0x79, 0x1f, 0xce, 0xc0, 0x1b, 0x47, 0xbf, 0x0c, 0xb3, 0xf7, 0x20, 0x17, 0xf2, 0xb1,
	0x09, 0x84, 0xcf, 0xa2, 0x84, 0x77, 0x66, 0x20, 0xa4, 0x80, 0x31, 0x9b, 0x8e, 0xb9, 0xd7, 0xdb,
	0xb1, 0x69, 0x08, 0x36, 0x44, 0x28, 0xfd, 0xdd, 0x32, 0x94, 0x98, 0x87, 0x57, 0x2d, 0x6b, 0xa0,
	0xf7, 0x54, 0x62, 0x74, 0xf4, 0x1e, 0xac, 0x5a, 0xc1, 0x39, 0xc0, 0x0f, 0x95, 0xf9, 0xa0, 0xb2,
	0xa9, 0x91, 0x64, 0x58, 0x37, 0xac, 0x91, 0x1b, 0x4a, 0x86, 0x69, 0xb9, 0xa9, 0xa1, 0x32, 0x64,
	0xf0, 0x00, 0x13, 0xae, 0x72, 0x72, 0x47, 0xb8, 0x93, 0x97, 0xbd, 0x22, 0xfa, 0x0d, 0x28, 0x99,
	0x23, 0x97, 0x48, 0x5d, 0xa8, 0x2e, 0xb6, 0x87, 0xaa, 0xfd, 0xda, 0x8b, 0x3f, 0xb3, 0x06, 0xdc,
	0x31, 0x75, 0x2b, 0x47, 0x14, 0xf1, 0xa5, 0x0f, 0xc8, 0x56, 0x65, 0xd1, 0x8c, 0x55, 0xa3, 0x4f,
	0x21, 0x73, 0xaa, 0xf6, 0x5e, 0x0f, 0xcc, 0x7e, 0x79, 0x79, 0xae, 0xcc, 0x70, 0x9c, 0xb2, 0xc6,
	0x70, 0x64, 0x0f, 0x10, 0x1d, 0x03, 0xe8, 0x8e, 0x72, 0x6a, 0x8e, 0x0c, 0x0d, 0x6b, 0xe5, 0xf4,
	0x8e, 0x70, 0xa7, 0x70, 0xff, 0xde, 0x0c, 0xf3, 0xd2, 0x74, 0x6a, 0x4c, 0xa6, 0xd2, 0x30, 0x46,
	0x43, 0x39, 0xab, 0x7b, 0x65, 0xf4, 0xeb, 0x50, 0x1c, 0x9a, 0x86, 0xee, 0x9a, 0x36, 0x09, 0xd7,
	0xba, 0x71, 0x66, 0x3a, 0xe5, 0x0c, 0xb5, 0xd4, 0xd7, 0x66, 0x54, 0xfb, 0xd0, 0x17, 0x6f, 0x1a,
	0x67, 0xa6, 0xbc, 0x36, 0x8c, 0x94, 0x1d, 0x51, 0x81, 0xcd, 0x89, 0xa6, 0x9b, 0xe0, 0x71, 0x5f,
	0x8d, 0x7a, 0x9c, 0x58, 0x61, 0xa7, 0xcb, 0x8a, 0x77, 0xba, 0xac, 0x74, 0xbd, 0xe3, 0x67, 0xd8,
	0x9d, 0x5f, 0x43, 0x86, 0x1b, 0x0a, 0xdd, 0x86, 0xac, 0xa5, 0xda, 0xae, 0x4e, 0x74, 0xa3, 0xc0,
	0x79, 0x39, 0xa8, 0x40, 0xdb, 0xb0, 0x7c, 0x7a, 0xe9, 0x62, 0x87, 0x65, 0x9f, 0xf9, 0x83, 0x25,
	0x99, 0x95, 0xd1, 0x0e, 0x35, 0xeb, 0xc8, 0x78, 0x6d, 0x98, 0x17, 0x06, 0xcb, 0x1e, 0x57, 0x0e,
	0x96, 0x88, 0x99, 0x4e, 0x58, 0x5d, 0x2d, 0xc3, 0x35, 0x93, 0xfe, 0x41, 0x80, 0xf2, 0x1e, 0x1e,
	0xa8, 0x97, 0x58, 0x1b, 0xf7, 0xe8, 0x2e, 0x94, 0x79, 0x06, 0x8d, 0xb5, 0xc0, 0x48, 0x0a, 0x39,
	0x34, 0xf3, 0xa3, 0xe2, 0x55, 0x43, 0xda, 0xf2, 0x65, 0x1b, 0x9e, 0x28, 0x69, 0x44, 0x9f, 0x42,
	0x4e, 0x0d, 0x48, 0xb8, 0x6d, 0x9e, 0x2c, 0xea, 0x54, 0x72, 0x18, 0x4c, 0xfa, 0x3d, 0x01, 0x36,
	0x26, 0x1d, 0xbf, 0xd0, 0x21, 0xbc, 0x37, 0x35, 0xd1, 0x1a, 0x3b, 0xb3, 0xef, 0x4c, 0x49, 0x99,
	0x82, 0x83, 0xfb, 0xbb, 0x90, 0xef, 0x11, 0x55, 0x15, 0xd7, 0x7c, 0x8d, 0x0d, 0x96, 0xfd, 0xe4,
	0xe5, 0x1c, 0xad, 0xeb, 0xd2, 0x2a, 0xe9, 0xdf, 0x13, 0xb0, 0x39, 0x31, 0x13, 0x47, 0x07, 0x90,
	0x19, 0x62, 0xd7, 0xd6, 0x7b, 0x0e, 0xb7, 0x62, 0x65, 0x56, 0xd7, 0x64, 0x52, 0xb2, 0x27, 0x4e,
	0x8e, 0x0a, 0x36, 0x76, 0x74, 0x6d, 0xa4, 0x0e, 0x14, 0xdb, 0x34, 0x5d, 0x2f, 0x0d, 0xfb, 0xfa,
	0x8c, 0x80, 0xd3, 0x66, 0x5e, 0x5e, 0xf5, 0x60, 0x65, 0x82, 0x3a, 0x71, 0x55, 0x25, 0xdf, 0xe6,
	0xaa, 0x42, 0x0f, 0x60, 0x93, 0xb8, 0x8b, 0x6e, 0x63, 0x47, 0xe1, 0x39, 0x34, 0x73, 0x8f, 0x14,
	0x71, 0x5e, 0x79, 0xc3, 0x6b, 0xdc, 0x0f, 0xb5, 0x49, 0x1d, 0xb8, 0x7d, 0xd5, 0xd9, 0x97, 0x80,
	0x86, 0x8f, 0x77, 0xf1, 0x69, 0xde, 0xd0, 0xc3, 0x47, 0x42, 0xde, 0x26, 0xfd, 0x55, 0x0a, 0x0a,
	0x51, 0x6d, 0xc9, 0xca, 0x1e, 0xd9, 0x86, 0xb7, 0xb2, 0x47, 0xb6, 0x81, 0x10, 0xa4, 0xdc, 0x4b,
	0xcb, 0xbf, 0xb8, 0x21, 0xbf, 0x91, 0x05, 0x9b, 0x21, 0x23, 0xb9, 0xea, 0x29, 0x71, 0x32, 0xd5,
	0x55, 0x69, 0x34, 0xcf, 0xdd, 0xdf, 0x9d, 0xdb, 0x52, 0x5d, 0x02, 0xb1, 0xa7, 0xba, 0xea, 0xc1,
	0x92, 0xbc, 0x3e, 0x1c, 0xaf, 0x46, 0xcf, 0x21, 0xcd, 0x3c, 0x81, 0x5a, 0x69, 0xf6, 0x2b, 0x22,
	0xe6, 0x47, 0x07, 0x4b, 0x32, 0x17, 0x47, 0x9f, 0x40, 0x7a, 0xa0, 0x9e, 0xe2, 0x81, 0x97, 0x57,
	0x56, 0x17, 0x9a, 0xd5, 0x4a, 0x8b, 0x62, 0xf0, 0x74, 0x92, 0x01, 0xa2, 0x27, 0x90, 0xf5, 0x2f,
	0xd9, 0x68, 0x84, 0xbf, 0x3a, 0x68, 0x04, 0x9d, 0xc5, 0xa7, 0x90, 0x0b, 0x01, 0x4e, 0x08, 0xaf,
	0x1b, 0xe1, 0xf0, 0x9a, 0x0d, 0x6f, 0xd0, 0xdf, 0x86, 0x8d, 0xa8, 0x6a, 0x0c, 0x08, 0xad, 0x42,
	0xb6, 0x2b, 0x57, 0xdb, 0x9d, 0xfd, 0x23, 0xf9, 0xb0, 0xb8, 0x84, 0xd6, 0x20, 0x77, 0x5c, 0x3f,
	0x6a, 0xb5, 0x1a, 0xf5, 0x6e, 0xf3, 0xa8, 0x5d, 0x14, 0xd0, 0x16, 0xa0, 0x97, 0xcd, 0xf6, 0xde,
	0xd1, 0xcb, 0x66, 0xfb, 0xb9, 0xd2, 0xe9, 0xca, 0xd5, 0x6e, 0xe3, 0xf9, 0x27, 0xc5, 0x04, 0xca,
	0xc2, 0x72, 0xfd, 0x68, 0xaf, 0x21, 0x17, 0x93, 0x44, 0xa6, 0xd1, 0x7e, 0xd1, 0x94, 0x8f, 0xda,
	0x87, 0x8d, 0x76, 0xb7, 0x98, 0xaa, 0xa5, 0x21, 0x45, 0x66, 0x59, 0xfa, 0xb7, 0x24, 0xa0, 0x28,
	0xe9, 0x89, 0x6d, 0x38, 0xd2, 0xdf, 0x26, 0x21, 0x45, 0x36, 0x29, 0xf4, 0x00, 0xb6, 0x4f, 0x3a,
	0x0d, 0x59, 0xa9, 0x1f, 0x9d, 0xb4, 0xbb, 0x0d, 0x59, 0x39, 0x91, 0xdb, 0xca, 0xb1, 0xdc, 0xd8,
	0x6f, 0x7e, 0x5c, 0x5c, 0x12, 0xb7, 0x7e, 0xf8, 0x97, 0xff, 0xff, 0x37, 0xcb, 0x45, 0x62, 0xea,
	0x5d, 0x36, 0x27, 0xbb, 0x23, 0x07, 0xdb, 0xe8, 0x6b, 0xb0, 0xda, 0x68, 0x35, 0x08, 0x13, 0x93,
	0x2b, 0x0a, 0xa2, 0x44, 0xbb, 0xde, 0x0e, 0x77, 0xe5, 0x79, 0x82, 0xd2, 0x33, 0x47, 0x86, 0xbb,
	0x7b, 0x7e, 0x0f, 0x75, 0x01, 0x75, 0xba, 0x55, 0xb9, 0xab, 0xd4, 0x4e, 0xda, 0x7b, 0xad, 0x86,
	0x72, 0xd8, 0x69, 0xd4, 0x3b, 0xc5, 0x84, 0xf8, 0x3e, 0x95, 0x7d, 0x14, 0x96, 0xb5, 0x54, 0x5b,
	0x33, 0x63, 0xc1, 0x7d, 0xd7, 0x71, 0x55, 0xdb, 0xf5, 0x02, 0xe5, 0xd0, 0xc1, 0x3d, 0x87, 0xa0,
	0x7e, 0x0c, 0x1b, 0xc7, 0xf2, 0x51, 0xbd, 0xd1, 0xe9, 0x44, 0x71, 0x93, 0xe2, 0x33, 0x8a, 0xfb,
	0xe4, 0x5a, 0xdc, 0x58, 0x08, 0xf6, 0x91, 0x5f, 0xc0, 0xfa, 0x7e, 0xb3, 0xdd, 0xec, 0x1c, 0x44,
	0x81, 0x53, 0xe2, 0x07, 0x14, 0xf8, 0xf1, 0xb5, 0xc0, 0x67, 0xba, 0xa1, 0x3b, 0xaf, 0xc6, 0x70,
	0x3f, 0x82, 0x5c, 0xf7, 0xa8, 0x5b, 0x6d, 0x71, 0xbc, 0x65, 0x71, 0x97, 0xe2, 0x3d, 0x8c, 0xe0,
	0x05, 0x39, 0x5b, 0x0c, 0xd4, 0x35, 0x5d, 0x75, 0xe0, 0x83, 0x49, 0xff, 0x2c, 0xc0, 0x56, 0x74,
	0x82, 0xbb, 0x97, 0x16, 0xa6, 0x93, 0xfc, 0xd7, 0x02, 0x9f, 0xe4, 0x7b, 0x50, 0xe8, 0x9c, 0x1c,
	0x2a, 0xcd, 0x76, 0xf7, 0xd1, 0x43, 0xa5, 0xfb, 0xc9, 0x71, 0xa3, 0xb8, 0x24, 0xbe, 0x43, 0x39,
	0xb7, 0x43, 0x9c, 0xce, 0xae, 0x33, 0x1a, 0x2a, 0xba, 0xe1, 0x2a, 0x8f, 0x1e, 0xa2, 0x3a, 0x6c,
	0xef, 0x35, 0x3b, 0x5d, 0xb9, 0x59, 0x3b, 0x21, 0x5e, 0x18, 0x96, 0x15, 0xc4, 0x5f, 0xa6, 0xb2,
	0x3b, 0x11, 0x59, 0x4d, 0x77, 0x5c, 0x5b, 0x3f, 0x65, 0x8a, 0x72, 0x90, 0xc7, 0x50, 0x6a, 0x55,
	0xbb, 0x8d, 0x4e, 0x37, 0x2c, 0x9e, 0x10, 0x77, 0xa8, 0xb8, 0x18, 0x11, 0x1f, 0xa8, 0x2e, 0x76,
	0x5c, 0x2e, 0x28, 0xfd, 0x28, 0x01, 0x69, 0x16, 0x0e, 0xd0, 0x4b, 0xc8, 0x53, 0x07, 0xc2, 0x36,
	0x0b, 0x5b, 0x6c, 0x6f, 0xba, 0x3f, 0x63, 0x28, 0xa8, 0x33, 0x51, 0x1e, 0xae, 0x72, 0xbd, 0xa0,
	0x88, 0xce, 0xa0, 0x14, 0xd1, 0x99, 0xa2, 0x27, 0xe6, 0xba, 0x30, 0xdb, 0x0b, 0xc9, 0x73, 0x8a,
	0xa2, 0x16, 0xab, 0x23, 0x03, 0xc0, 0x6f, 0x5c, 0x1b, 0x0f, 0xd5, 0x70, 0xdc, 0x9d, 0x75, 0x00,
	0x0d, 0x26, 0xea, 0x0d, 0x00, 0x07, 0x45, 0x7f, 0x89, 0x7f, 0x4f, 0x20, 0xc7, 0x99, 0x60, 0x60,
	0xef, 0x42, 0x4e, 0x37, 0xdc, 0x47, 0x0f, 0x15, 0x16, 0x86, 0x88, 0xc1, 0x92, 0x07, 0x4b, 0x32,
	0xd0, 0xca, 0x17, 0xa4, 0x0e, 0xbd, 0x07, 0x79, 0xcd, 0x1c, 0x91, 0xad, 0x20, 0x08, 0x55, 0x02,
	0xc1, 0x67, 0xb5, 0x7e, 0x27, 0x32, 0x14, 0xa3, 0xcf, 0x3b, 0x11, 0xc5, 0xb3, 0xa4, 0x13, 0xab,
	0xa5, 0x9d, 0x82, 0x94, 0xed, 0xbf, 0x04, 0xc8, 0x85, 0x94, 0x45, 0x2a, 0x14, 0xc9, 0x64, 0x46,
	0x86, 0xce, 0xe6, 0x6e, 0xd6, 0xcd, 0xb9, 0x69, 0xb8, 0xd1, 0xd1, 0x17, 0xf4, 0x48, 0x0d, 0xfa,
	0x36, 0xac, 0xf3, 0x51, 0x44, 0x58, 0xe6, 0x4b, 0xdd, 0xf6, 0x28, 0x42, 0x94, 0xa8, 0xa4, 0xc5,
	0x2b, 0x6b, 0x59, 0xc8, 0x70, 0x12, 0xe9, 0x2e, 0x14, 0xa2, 0xaa, 0xa1, 0x77, 0x80, 0x18, 0x97,
	0x99, 0xc9, 0xa1, 0x17, 0x64, 0x49, 0x39, 0xab, 0x1b, 0x2e, 0x35, 0x91, 0x23, 0x3d, 0x81, 0xd2,
	0x18, 0x0b, 0x39, 0x97, 0x85, 0xa7, 0x80, 0xe5, 0x48, 0x82, 0x9c, 0x0f, 0xcd, 0x80, 0x23, 0x7d,
	0x9e, 0x80, 0x62, 0xdc, 0xc9, 0xc8, 0x8e, 0x4e, 0xd8, 0xc6, 0x9d, 0x57, 0x98, 0x6b, 0x47, 0x6f,
	0x1a, 0xee, 0x04, 0xff, 0x5d, 0xd7, 0xc7, 0xab, 0xd1, 0x25, 0x94, 0xb9, 0xae, 0xd3, 0x56, 0xcc,
	0x07, 0x73, 0x59, 0x7b, 0x02, 0xef, 0x96, 0x36, 0xb1, 0xa5, 0x56, 0x80, 0x7c, 0x98, 0x53, 0x52,
	0x61, 0x7d, 0x82, 0xe2, 0x64, 0xd3, 0xa5, 0x6b, 0x9b, 0x79, 0xbb, 0xcc, 0x0a, 0x64, 0x73, 0x76,
	0x46, 0x43, 0xaa, 0x62, 0x52, 0x26, 0x3f, 0x49, 0xcd, 0x50, 0x37, 0xa8, 0x2b, 0x27, 0x65, 0xf2,
	0x93, 0xd6, 0xa8, 0x6f, 0x68, 0xaa, 0x42, 0x6a, 0xd4, 0x37, 0x92, 0x06, 0x5b, 0x93, 0xd5, 0xbc,
	0x9e, 0x45, 0x18, 0x63, 0x11, 0xc6, 0x58, 0x04, 0xc6, 0xf2, 0xe3, 0x24, 0xac, 0x4f, 0x48, 0xaa,
	0x68, 0x0e, 0x6f, 0x0e, 0x46, 0x43, 0x43, 0x31, 0xd4, 0x21, 0xf7, 0xa6, 0x2c, 0x89, 0x5c, 0xa4,
	0xae, 0x4d, 0xaa, 0x50, 0x0f, 0x56, 0x6c, 0xf3, 0xc2, 0x33, 0x3f, 0xc9, 0x8c, 0x0e, 0x16, 0xcf,
	0xe2, 0x42, 0x75, 0xb2, 0x79, 0x21, 0x67, 0x6c, 0xf3, 0x82, 0x54, 0x8b, 0x7f, 0x2f, 0xc0, 0x66,
	0xd0, 0x54, 0xa7, 0xf4, 0x2c, 0x2e, 0x7c, 0x91, 0xf1, 0x05, 0xed, 0x86, 0x13, 0xb5, 0xd4, 0x75,
	0x89, 0x1a, 0x39, 0x4e, 0xfa, 0xdd, 0xfd, 0xd8, 0x24, 0x5e, 0xc2, 0x6a, 0x64, 0x94, 0xe8, 0x15,
	0xa4, 0x43, 0x8b, 0x75, 0xf6, 0x7b, 0xc4, 0xab, 0xed, 0x17, 0x32, 0x92, 0xcc, 0xf1, 0xa5, 0x1f,
	0xac, 0x43, 0x86, 0x1f, 0x90, 0x90, 0x0a, 0x39, 0x2b, 0x74, 0x37, 0x2d, 0xcc, 0x75, 0x28, 0xe2,
	0x20, 0x95, 0x63, 0x37, 0x76, 0x19, 0x1d, 0xc6, 0x14, 0xff, 0x35, 0x07, 0x10, 0x5c, 0xf1, 0xa1,
	0xcf, 0xc0, 0xfb, 0xd2, 0x40, 0x8e, 0xca, 0x2c, 0x1f, 0xf3, 0x8e, 0x77, 0x1f, 0xcd, 0x4b, 0xec,
	0xc3, 0x7a, 0xd7, 0xa9, 0x58, 0x6b, 0x70, 0x48, 0xb9, 0x64, 0xc5, 0xab, 0xd0, 0x77, 0x60, 0x4d,
	0xed, 0xd1, 0xcf, 0xd0, 0x3e, 0x31, 0x8b, 0x15, 0x07, 0x8b, 0x13, 0x57, 0x29, 0xa0, 0xcf, 0x5a,
	0x50, 0x23, 0x65, 0xa4, 0x03, 0x84, 0xae, 0xa2, 0xd8, 0x51, 0xb0, 0xb9, 0x38, 0x5b, 0xfc, 0x16,
	0x2a, 0x04, 0x8e, 0x9e, 0x43, 0x8a, 0xa4, 0xc2, 0xfc, 0xbe, 0xeb, 0xc1, 0x9c, 0x24, 0x27, 0x0e,
	0xb6, 0x65, 0x0a, 0x20, 0xfe, 0x38, 0x09, 0x2b, 0x87, 0x58, 0x75, 0x46, 0x36, 0xd6, 0xd0, 0x1f,
	0x0a, 0xb0, 0xc1, 0x2e, 0xe2, 0x22, 0xc9, 0xb3, 0xe7, 0x2b, 0x9f, 0x2e, 0x3e, 0x16, 0x8f, 0xa2,
	0xd2, 0x24, 0xf0, 0xdc, 0x62, 0x34, 0x6b, 0xe0, 0x83, 0x43, 0xfa, 0x58, 0x03, 0xfa, 0x5c, 0x80,
	0x4d, 0x7e, 0xc5, 0x17, 0xd3, 0x87, 0x85, 0x9d, 0x6f, 0xbe, 0x05, 0x7d, 0xd8, 0xad, 0xd5, 0x04,
	0x85, 0xd6, 0xcd, 0xf1, 0x16, 0x74, 0x07, 0x8a, 0x2c, 0xff, 0x25, 0xab, 0x5c, 0x71, 0x2c, 0xef,
	0x5a, 0x52, 0x90, 0x0b, 0xb4, 0x9e, 0x44, 0x82, 0x0e, 0xa9, 0x15, 0x1b, 0xb0, 0x3d, 0x65, 0xa8,
	0xd7, 0x9d, 0xd9, 0x92, 0xe1, 0x6b, 0xaf, 0x7d, 0x28, 0x4f, 0xd3, 0x70, 0x2e, 0x1c, 0x07, 0x4a,
	0x63, 0xab, 0x06, 0x7d, 0x0b, 0x56, 0x86, 0xdc, 0x0e, 0x7c, 0x51, 0xd6, 0x6e, 0x6e, 0x51, 0xd9,
	0xc7, 0x14, 0x3f, 0x4f, 0x42, 0x21, 0xba, 0x64, 0x7e, 0xde, 0x94, 0xe8, 0x2b, 0x80, 0xce, 0x6c,
	0xd5, 0xbb, 0xd9, 0x18, 0xaa, 0xba, 0xa1, 0x1b, 0x7d, 0xbe, 0x37, 0x96, 0xbc, 0x16, 0xd9, 0x6b,
	0x40, 0x7f, 0x26, 0xc0, 0xad, 0xa8, 0x87, 0x39, 0x21, 0x31, 0xb6, 0x82, 0xf1, 0xdb, 0x8a, 0x17,
	0x51, 0x5f, 0x73, 0x7c, 0x2d, 0x98, 0xbf, 0x6d, 0x9b, 0x93, 0x5b, 0xc5, 0x0f, 0xe1, 0xf6, 0x55,
	0x82, 0x73, 0xb9, 0xc1, 0x07, 0xb0, 0x76, 0xfd, 0x05, 0xed, 0x74, 0xf1, 0x7f, 0x5c, 0x86, 0x14,
	0x89, 0x1d, 0x48, 0x81, 0x1c, 0x3b, 0x39, 0xd1, 0x2c, 0x81, 0xcf, 0xe4, 0xb3, 0x05, 0xa2, 0x10,
	0x2f, 0x90, 0xc4, 0x42, 0x86, 0xa1, 0xff, 0x1b, 0xe1, 0xd8, 0xb1, 0x8b, 0x7f, 0xec, 0xff, 0xfa,
	0x22, 0x14, 0x57, 0x1c, 0xc2, 0xdc, 0x49, 0x87, 0xb0, 0x39, 0xbf, 0xf3, 0x47, 0xb8, 0x66, 0x3a,
	0x92, 0x29, 0x00, 0x7d, 0x75, 0xd4, 0xe7, 0x17, 0x61, 0x3f, 0x9d, 0xef, 0x2b, 0x7b, 0x84, 0xee,
	0x39, 0x81, 0xe1, 0x3c, 0xd9, 0xbe, 0x57, 0x10, 0x9f, 0x01, 0x04, 0x76, 0x45, 0xb7, 0x21, 0x4b,
	0x73, 0x39, 0x4b, 0xed, 0x79, 0xb7, 0x42, 0x41, 0x85, 0xff, 0xda, 0x2a, 0x19, 0x7a, 0x6d, 0xf5,
	0x5e, 0xf4, 0x44, 0xe7, 0x3b, 0x84, 0x10, 0x72, 0x08, 0xf1, 0x5b, 0x13, 0xce, 0x06, 0x6f, 0x31,
	0x0f, 0x16, 0xbf, 0x09, 0x59, 0x7f, 0x78, 0x93, 0x55, 0x88, 0x5e, 0xa3, 0x25, 0xe6, 0xb8, 0x46,
	0xf3, 0x0e, 0xaf, 0xe2, 0x25, 0x14, 0xe3, 0x19, 0xcd, 0x84, 0x15, 0x71, 0x14, 0xfd, 0x64, 0xf1,
	0x74, 0xe1, 0x88, 0x10, 0xbe, 0x8e, 0xfb, 0x51, 0x02, 0xde, 0xb9, 0xf2, 0x8d, 0xc8, 0x5b, 0xbc,
	0x12, 0xff, 0xf9, 0x5f, 0x55, 0xff, 0x1a, 0xac, 0x5a, 0xb6, 0x3e, 0x54, 0xed, 0x4b, 0x7e, 0xe7,
	0xce, 0x32, 0x93, 0xc5, 0xbf, 0x60, 0xe4, 0x39, 0x1c, 0xbd, 0x6b, 0x97, 0xfe, 0x34, 0x01, 0xb7,
	0xa6, 0x3e, 0xaa, 0x5a, 0xe8, 0x4a, 0x1b, 0x7d, 0x4f, 0x80, 0x12, 0xff, 0xe4, 0x16, 0xd9, 0x2a,
	0x88, 0xda, 0x2f, 0x6e, 0xfa, 0xce, 0xcb, 0xff, 0xaa, 0x17, 0x0d, 0xf2, 0xc5, 0xd3, 0x58, 0xb5,
	0x58, 0x87, 0xcd, 0x89, 0x5d, 0xaf, 0x8b, 0xcb, 0xf9, 0xb0, 0x2b, 0xfd, 0x87, 0x00, 0xe2, 0xf4,
	0x07, 0x3f, 0xe3, 0x73, 0x23, 0xbc, 0xcd, 0xb9, 0xf9, 0xa2, 0xbe, 0xb7, 0x48, 0x2d, 0xd8, 0x9c,
	0xf8, 0xca, 0x6d, 0xb1, 0x2f, 0x1a, 0x65, 0xd8, 0x9a, 0xfc, 0x60, 0x49, 0xfa, 0x3f, 0x01, 0x56,
	0xfc, 0x84, 0xe5, 0x80, 0x05, 0x0a, 0x6e, 0xb2, 0x87, 0xb3, 0x5e, 0x9b, 0x79, 0x5b, 0x3e, 0x09,
	0x5e, 0x32, 0x0b, 0x35, 0x7f, 0x2c, 0x40, 0x8a, 0xc6, 0xb2, 0x85, 0xbc, 0x35, 0x78, 0xf8, 0x9a,
	0x98, 0xeb, 0xab, 0x46, 0xf4, 0xe1, 0x2b, 0x89, 0xf6, 0xfe, 0x2d, 0x60, 0x9e, 0x29, 0x26, 0xfd,
	0x30, 0x09, 0xf9, 0x8e, 0xab, 0xba, 0xbe, 0x3d, 0xe3, 0x6f, 0x9a, 0xa6, 0x2a, 0x9c, 0xb8, 0x42,
	0xe1, 0x16, 0x64, 0xd9, 0xdb, 0x15, 0xe2, 0xc5, 0xec, 0xd2, 0xf1, 0xee, 0x8c, 0x3a, 0x53, 0x65,
	0x3e, 0xc2, 0x97, 0xf2, 0x8a, 0xc3, 0x7f, 0xa1, 0x8f, 0x20, 0x49, 0xc6, 0x3e, 0xe7, 0x83, 0x56,
	0x0a, 0xf4, 0x1c, 0x87, 0x1e, 0x5f, 0x12, 0x14, 0xd4, 0x85, 0xb4, 0x6a, 0x59, 0xd8, 0xd0, 0xbc,
	0xb4, 0xe2, 0xe9, 0x3c, 0x78, 0x55, 0x2a, 0x1a, 0x40, 0x72, 0x2c, 0xf4, 0xab, 0xb0, 0xdc, 0x1b,
	0x60, 0xd5, 0xf6, 0xf2, 0x87, 0x27, 0xf3, 0x80, 0xd6, 0x89, 0x64, 0x80, 0xc9, 0x90, 0xc2, 0x8f,
	0x35, 0xff, 0x25, 0x01, 0xab, 0x7c, 0x92, 0xf8, 0xaa, 0x8e, 0xcf, 0xd2, 0xe4, 0xf7, 0x98, 0x5f,
	0x82, 0x5c, 0xe8, 0x9b, 0x2c, 0x9f, 0x77, 0x08, 0x3e, 0xc9, 0xa2, 0x56, 0xc4, 0xb2, 0x8f, 0xe7,
	0xb6, 0xac, 0xff, 0xca, 0x8f, 0x9a, 0xf6, 0x24, 0x6e, 0xda, 0xdd, 0x45, 0x4c, 0xeb, 0x63, 0x7a,
	0xb6, 0x95, 0x63, 0xb6, 0x7d, 0xba, 0x80, 0x6d, 0x7d, 0x50, 0x6e, 0xdc, 0xf0, 0x2b, 0xc4, 0x9f,
	0xa4, 0x60, 0xc5, 0xf3, 0x3a, 0x74, 0x0c, 0x69, 0xf6, 0xac, 0x9e, 0xef, 0xba, 0x8f, 0xe6, 0x74,
	0xdb, 0x8a, 0x4c, 0xa5, 0x89, 0xfa, 0x0c, 0x07, 0x39, 0xb0, 0x3e, 0x1c, 0x0d, 0x5c, 0x7d, 0xa8,
	0x5a, 0x8a, 0xa3, 0x6b, 0x58, 0xa1, 0x87, 0x5d, 0xbe, 0x92, 0xab, 0xf3, 0xc2, 0x1f, 0x72, 0xa8,
	0x8e, 0xae, 0x61, 0x7a, 0xc6, 0x3c, 0x58, 0x92, 0x4b, 0xc3, 0x78, 0x25, 0xd2, 0xa0, 0x70, 0xaa,
	0xf6, 0x15, 0x72, 0xca, 0x57, 0xe8, 0x3a, 0xe2, 0xab, 0xf0, 0xfd, 0x79, 0xf9, 0x6a, 0x6a, 0x9f,
	0x24, 0x9b, 0xb4, 0x7c, 0xb0, 0x24, 0xe7, 0x4f, 0x43, 0x65, 0x51, 0x84, 0x34, 0x1b, 0x6e, 0x78,
	0xc3, 0xca, 0xd3, 0x0d, 0x4b, 0xfc, 0xbe, 0x00, 0xa5, 0x31, 0x65, 0x67, 0x7b, 0x11, 0x24, 0xc1,
	0x6a, 0x60, 0xa8, 0xe0, 0x59, 0x50, 0xce, 0xf1, 0x60, 0x9a, 0x1a, 0xda, 0x82, 0x34, 0x7b, 0x0e,
	0xc8, 0xbd, 0x9a, 0x97, 0x3c, 0x45, 0x52, 0x81, 0x22, 0xbf, 0x2d, 0x40, 0x3e, 0x3c, 0x8a, 0x99,
	0x75, 0x08, 0x8c, 0x17, 0xd2, 0x61, 0xe4, 0xc1, 0xcc, 0xa3, 0x03, 0xc9, 0x38, 0xdd, 0x4b, 0x0b,
	0x4b, 0xdf, 0x80, 0xb5, 0x58, 0x58, 0x22, 0x87, 0xd6, 0x9e, 0x69, 0xb8, 0xba, 0x31, 0x52, 0xd9,
	0x77, 0x36, 0xba, 0x54, 0x99, 0x21, 0x4b, 0xe1, 0x16, 0xba, 0x62, 0xa5, 0x13, 0x28, 0xc6, 0x97,
	0xdf, 0x9c, 0x10, 0xfe, 0x36, 0x90, 0x08, 0x6d, 0x03, 0x77, 0x00, 0x8d, 0xc7, 0x37, 0xbf, 0xa7,
	0x10, 0xea, 0xb9, 0x09, 0xeb, 0x13, 0x96, 0xab, 0xb4, 0x0e, 0xa5, 0xb1, 0x58, 0x26, 0x6d, 0x70,
	0xd4, 0xc8, 0x22, 0x94, 0xfe, 0x29, 0x05, 0x2b, 0x2d, 0x93, 0x67, 0x3a, 0x9f, 0xc0, 0x8a, 0x83,
	0xcf, 0xb1, 0xad, 0xbb, 0xcc, 0x7b, 0x0a, 0x33, 0x9f, 0x85, 0x3c, 0x88, 0x4a, 0x87, 0xcb, 0xb3,
	0x97, 0x4f, 0x3e, 0xdc, 0xe2, 0x07, 0x04, 0x54, 0x26, 0xb9, 0xb7, 0xe3, 0xa8, 0x7d, 0xef, 0x64,
	0xe4, 0x15, 0x49, 0x9c, 0x75, 0x6d, 0x72, 0x94, 0x4a, 0xb1, 0x38, 0x4b, 0x0b, 0xd3, 0xf7, 0xc8,
	0xe5, 0x2b, 0xf6, 0xc8, 0x6b, 0xff, 0x2d, 0x93, 0xbe, 0xfe, 0xdf, 0x32, 0xef, 0x42, 0x9e, 0x64,
	0xb0, 0x03, 0x93, 0xbf, 0x1c, 0xca, 0x30, 0x27, 0x1d, 0x98, 0xfd, 0x16, 0xaf, 0x22, 0x4e, 0xea,
	0xbe, 0xb2, 0xb1, 0xaa, 0x95, 0x57, 0x68, 0x23, 0x2f, 0x89, 0x1f, 0xf3, 0x3f, 0xd5, 0x1c, 0x03,
	0xe9, 0xae, 0x60, 0xc3, 0xb5, 0x75, 0xff, 0x4e, 0xfa, 0xee, 0x9c, 0x73, 0x20, 0xc3, 0x80, 0xfd,
	0xd2, 0xb1, 0x23, 0xda, 0xb0, 0xe2, 0x4d, 0x89, 0x74, 0xc6, 0xbf, 0x02, 0xaf, 0x41, 0xee, 0xa4,
	0xdd, 0x39, 0x6e, 0xd4, 0x9b, 0xfb, 0xcd, 0xc6, 0x5e, 0x71, 0x09, 0x65, 0x61, 0xb9, 0x2b, 0x57,
	0xeb, 0x8d, 0xa2, 0x40, 0x7e, 0xee, 0x35, 0x6a, 0x27, 0xcf, 0x8b, 0x09, 0xb4, 0x02, 0xa9, 0x66,
	0x7b, 0xff, 0xa8, 0x98, 0x44, 0x00, 0xe9, 0xf6, 0x51, 0xb7, 0x59, 0x6f, 0x14, 0x53, 0xa4, 0xf6,
	0x65, 0x55, 0x6e, 0x17, 0x97, 0x49, 0xd7, 0x86, 0x2c, 0x1f, 0xc9, 0xc5, 0x34, 0xca, 0xc3, 0x4a,
	0x5d, 0x6e, 0x76, 0x9b, 0xf5, 0x6a, 0xab, 0x98, 0x91, 0xf2, 0x00, 0x2d, 0xb3, 0x5f, 0x37, 0x0d,
	0xd7, 0x36, 0x07, 0xf7, 0x7f, 0x20, 0xc0, 0x6a, 0x0d, 0xab, 0xc3, 0x7d, 0x83, 0xd7, 0xa0, 0xef,
	0x0b, 0x90, 0xf1, 0x7e, 0xcf, 0xfe, 0x91, 0x6a, 0xec, 0xef, 0x11, 0xe2, 0xd3, 0x45, 0x64, 0xd9,
	0x62, 0x58, 0xba, 0x23, 0x7c, 0x55, 0xb8, 0xff, 0x5d, 0x00, 0xa6, 0x19, 0xcd, 0x06, 0x0d, 0x9e,
	0x15, 0xde, 0x9d, 0x33, 0xb5, 0x14, 0xe7, 0x15, 0xe0, 0xec, 0xbf, 0x2b, 0x40, 0x8e, 0xd1, 0xb3,
	0x50, 0xf8, 0x06, 0x96, 0xd9, 0x8f, 0x07, 0xf3, 0xec, 0x0b, 0x7c, 0x44, 0xe2, 0xc3, 0xf9, 0x84,
	0xf8, 0xf2, 0x67, 0x9a, 0xfc, 0xbe, 0x3f, 0x45, 0x2d, 0xb3, 0xdf, 0xd7, 0x8d, 0x3e, 0x7a, 0x03,
	0x19, 0xef, 0xe7, 0xc3, 0x79, 0x43, 0x00, 0xf1, 0x64, 0xf1, 0xde, 0xec, 0x52, 0xdc, 0x15, 0x98,
	0x2e, 0xb5, 0x2a, 0xfc, 0xd2, 0x34, 0xc9, 0xb0, 0x60, 0x2d, 0xcb, 0x14, 0xae, 0x5a, 0xfa, 0xa7,
	0x85, 0x50, 0x93, 0x72, 0x7e, 0xef, 0x34, 0x4d, 0x03, 0xca, 0x83, 0x9f, 0x05, 0x00, 0x00, 0xff,
	0xff, 0x9e, 0x30, 0x1a, 0x49, 0xd3, 0x37, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// BeamFnControlClient is the client API for BeamFnControl service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnControlClient interface {
	// Instructions sent by the runner to the SDK requesting different types
	// of work.
	Control(ctx context.Context, opts ...grpc.CallOption) (BeamFnControl_ControlClient, error)
}

type beamFnControlClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnControlClient(cc *grpc.ClientConn) BeamFnControlClient {
	return &beamFnControlClient{cc}
}

func (c *beamFnControlClient) Control(ctx context.Context, opts ...grpc.CallOption) (BeamFnControl_ControlClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnControl_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnControl/Control", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnControlControlClient{stream}
	return x, nil
}

type BeamFnControl_ControlClient interface {
	Send(*InstructionResponse) error
	Recv() (*InstructionRequest, error)
	grpc.ClientStream
}

type beamFnControlControlClient struct {
	grpc.ClientStream
}

func (x *beamFnControlControlClient) Send(m *InstructionResponse) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnControlControlClient) Recv() (*InstructionRequest, error) {
	m := new(InstructionRequest)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnControlServer is the server API for BeamFnControl service.
type BeamFnControlServer interface {
	// Instructions sent by the runner to the SDK requesting different types
	// of work.
	Control(BeamFnControl_ControlServer) error
}

func RegisterBeamFnControlServer(s *grpc.Server, srv BeamFnControlServer) {
	s.RegisterService(&_BeamFnControl_serviceDesc, srv)
}

func _BeamFnControl_Control_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnControlServer).Control(&beamFnControlControlServer{stream})
}

type BeamFnControl_ControlServer interface {
	Send(*InstructionRequest) error
	Recv() (*InstructionResponse, error)
	grpc.ServerStream
}

type beamFnControlControlServer struct {
	grpc.ServerStream
}

func (x *beamFnControlControlServer) Send(m *InstructionRequest) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnControlControlServer) Recv() (*InstructionResponse, error) {
	m := new(InstructionResponse)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnControl_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnControl",
	HandlerType: (*BeamFnControlServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Control",
			Handler:       _BeamFnControl_Control_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}

// BeamFnDataClient is the client API for BeamFnData service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnDataClient interface {
	// Used to send data between harnesses.
	Data(ctx context.Context, opts ...grpc.CallOption) (BeamFnData_DataClient, error)
}

type beamFnDataClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnDataClient(cc *grpc.ClientConn) BeamFnDataClient {
	return &beamFnDataClient{cc}
}

func (c *beamFnDataClient) Data(ctx context.Context, opts ...grpc.CallOption) (BeamFnData_DataClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnData_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnData/Data", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnDataDataClient{stream}
	return x, nil
}

type BeamFnData_DataClient interface {
	Send(*Elements) error
	Recv() (*Elements, error)
	grpc.ClientStream
}

type beamFnDataDataClient struct {
	grpc.ClientStream
}

func (x *beamFnDataDataClient) Send(m *Elements) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnDataDataClient) Recv() (*Elements, error) {
	m := new(Elements)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnDataServer is the server API for BeamFnData service.
type BeamFnDataServer interface {
	// Used to send data between harnesses.
	Data(BeamFnData_DataServer) error
}

func RegisterBeamFnDataServer(s *grpc.Server, srv BeamFnDataServer) {
	s.RegisterService(&_BeamFnData_serviceDesc, srv)
}

func _BeamFnData_Data_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnDataServer).Data(&beamFnDataDataServer{stream})
}

type BeamFnData_DataServer interface {
	Send(*Elements) error
	Recv() (*Elements, error)
	grpc.ServerStream
}

type beamFnDataDataServer struct {
	grpc.ServerStream
}

func (x *beamFnDataDataServer) Send(m *Elements) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnDataDataServer) Recv() (*Elements, error) {
	m := new(Elements)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnData_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnData",
	HandlerType: (*BeamFnDataServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Data",
			Handler:       _BeamFnData_Data_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}

// BeamFnStateClient is the client API for BeamFnState service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnStateClient interface {
	// Used to get/append/clear state stored by the runner on behalf of the SDK.
	State(ctx context.Context, opts ...grpc.CallOption) (BeamFnState_StateClient, error)
}

type beamFnStateClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnStateClient(cc *grpc.ClientConn) BeamFnStateClient {
	return &beamFnStateClient{cc}
}

func (c *beamFnStateClient) State(ctx context.Context, opts ...grpc.CallOption) (BeamFnState_StateClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnState_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnState/State", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnStateStateClient{stream}
	return x, nil
}

type BeamFnState_StateClient interface {
	Send(*StateRequest) error
	Recv() (*StateResponse, error)
	grpc.ClientStream
}

type beamFnStateStateClient struct {
	grpc.ClientStream
}

func (x *beamFnStateStateClient) Send(m *StateRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnStateStateClient) Recv() (*StateResponse, error) {
	m := new(StateResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnStateServer is the server API for BeamFnState service.
type BeamFnStateServer interface {
	// Used to get/append/clear state stored by the runner on behalf of the SDK.
	State(BeamFnState_StateServer) error
}

func RegisterBeamFnStateServer(s *grpc.Server, srv BeamFnStateServer) {
	s.RegisterService(&_BeamFnState_serviceDesc, srv)
}

func _BeamFnState_State_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnStateServer).State(&beamFnStateStateServer{stream})
}

type BeamFnState_StateServer interface {
	Send(*StateResponse) error
	Recv() (*StateRequest, error)
	grpc.ServerStream
}

type beamFnStateStateServer struct {
	grpc.ServerStream
}

func (x *beamFnStateStateServer) Send(m *StateResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnStateStateServer) Recv() (*StateRequest, error) {
	m := new(StateRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnState_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnState",
	HandlerType: (*BeamFnStateServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "State",
			Handler:       _BeamFnState_State_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}

// BeamFnLoggingClient is the client API for BeamFnLogging service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnLoggingClient interface {
	// Allows for the SDK to emit log entries which the runner can
	// associate with the active job.
	Logging(ctx context.Context, opts ...grpc.CallOption) (BeamFnLogging_LoggingClient, error)
}

type beamFnLoggingClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnLoggingClient(cc *grpc.ClientConn) BeamFnLoggingClient {
	return &beamFnLoggingClient{cc}
}

func (c *beamFnLoggingClient) Logging(ctx context.Context, opts ...grpc.CallOption) (BeamFnLogging_LoggingClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnLogging_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnLogging/Logging", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnLoggingLoggingClient{stream}
	return x, nil
}

type BeamFnLogging_LoggingClient interface {
	Send(*LogEntry_List) error
	Recv() (*LogControl, error)
	grpc.ClientStream
}

type beamFnLoggingLoggingClient struct {
	grpc.ClientStream
}

func (x *beamFnLoggingLoggingClient) Send(m *LogEntry_List) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnLoggingLoggingClient) Recv() (*LogControl, error) {
	m := new(LogControl)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnLoggingServer is the server API for BeamFnLogging service.
type BeamFnLoggingServer interface {
	// Allows for the SDK to emit log entries which the runner can
	// associate with the active job.
	Logging(BeamFnLogging_LoggingServer) error
}

func RegisterBeamFnLoggingServer(s *grpc.Server, srv BeamFnLoggingServer) {
	s.RegisterService(&_BeamFnLogging_serviceDesc, srv)
}

func _BeamFnLogging_Logging_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnLoggingServer).Logging(&beamFnLoggingLoggingServer{stream})
}

type BeamFnLogging_LoggingServer interface {
	Send(*LogControl) error
	Recv() (*LogEntry_List, error)
	grpc.ServerStream
}

type beamFnLoggingLoggingServer struct {
	grpc.ServerStream
}

func (x *beamFnLoggingLoggingServer) Send(m *LogControl) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnLoggingLoggingServer) Recv() (*LogEntry_List, error) {
	m := new(LogEntry_List)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnLogging_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnLogging",
	HandlerType: (*BeamFnLoggingServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Logging",
			Handler:       _BeamFnLogging_Logging_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}
