// Code generated by protoc-gen-go. DO NOT EDIT.
// source: beam_job_api.proto

package jobmanagement_v1

import (
	fmt "fmt"
	pipeline_v1 "github.com/apache/beam/sdks/go/pkg/beam/model/pipeline_v1"
	proto "github.com/golang/protobuf/proto"
	_struct "github.com/golang/protobuf/ptypes/struct"
	math "math"
)

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type JobMessage_MessageImportance int32

const (
	JobMessage_MESSAGE_IMPORTANCE_UNSPECIFIED JobMessage_MessageImportance = 0
	JobMessage_JOB_MESSAGE_DEBUG              JobMessage_MessageImportance = 1
	JobMessage_JOB_MESSAGE_DETAILED           JobMessage_MessageImportance = 2
	JobMessage_JOB_MESSAGE_BASIC              JobMessage_MessageImportance = 3
	JobMessage_JOB_MESSAGE_WARNING            JobMessage_MessageImportance = 4
	JobMessage_JOB_MESSAGE_ERROR              JobMessage_MessageImportance = 5
)

var JobMessage_MessageImportance_name = map[int32]string{
	0: "MESSAGE_IMPORTANCE_UNSPECIFIED",
	1: "JOB_MESSAGE_DEBUG",
	2: "JOB_MESSAGE_DETAILED",
	3: "JOB_MESSAGE_BASIC",
	4: "JOB_MESSAGE_WARNING",
	5: "JOB_MESSAGE_ERROR",
}

var JobMessage_MessageImportance_value = map[string]int32{
	"MESSAGE_IMPORTANCE_UNSPECIFIED": 0,
	"JOB_MESSAGE_DEBUG":              1,
	"JOB_MESSAGE_DETAILED":           2,
	"JOB_MESSAGE_BASIC":              3,
	"JOB_MESSAGE_WARNING":            4,
	"JOB_MESSAGE_ERROR":              5,
}

func (x JobMessage_MessageImportance) String() string {
	return proto.EnumName(JobMessage_MessageImportance_name, int32(x))
}

func (JobMessage_MessageImportance) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{9, 0}
}

type JobState_Enum int32

const (
	JobState_UNSPECIFIED JobState_Enum = 0
	JobState_STOPPED     JobState_Enum = 1
	JobState_RUNNING     JobState_Enum = 2
	JobState_DONE        JobState_Enum = 3
	JobState_FAILED      JobState_Enum = 4
	JobState_CANCELLED   JobState_Enum = 5
	JobState_UPDATED     JobState_Enum = 6
	JobState_DRAINING    JobState_Enum = 7
	JobState_DRAINED     JobState_Enum = 8
	JobState_STARTING    JobState_Enum = 9
	JobState_CANCELLING  JobState_Enum = 10
)

var JobState_Enum_name = map[int32]string{
	0:  "UNSPECIFIED",
	1:  "STOPPED",
	2:  "RUNNING",
	3:  "DONE",
	4:  "FAILED",
	5:  "CANCELLED",
	6:  "UPDATED",
	7:  "DRAINING",
	8:  "DRAINED",
	9:  "STARTING",
	10: "CANCELLING",
}

var JobState_Enum_value = map[string]int32{
	"UNSPECIFIED": 0,
	"STOPPED":     1,
	"RUNNING":     2,
	"DONE":        3,
	"FAILED":      4,
	"CANCELLED":   5,
	"UPDATED":     6,
	"DRAINING":    7,
	"DRAINED":     8,
	"STARTING":    9,
	"CANCELLING":  10,
}

func (x JobState_Enum) String() string {
	return proto.EnumName(JobState_Enum_name, int32(x))
}

func (JobState_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{11, 0}
}

// Prepare is a synchronous request that returns a preparationId back
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
// Throws error ALREADY_EXISTS if the jobName is reused. Runners are permitted to deduplicate based on the name of the job.
// Throws error UNKNOWN for all other issues
type PrepareJobRequest struct {
	Pipeline             *pipeline_v1.Pipeline `protobuf:"bytes,1,opt,name=pipeline,proto3" json:"pipeline,omitempty"`
	PipelineOptions      *_struct.Struct       `protobuf:"bytes,2,opt,name=pipeline_options,json=pipelineOptions,proto3" json:"pipeline_options,omitempty"`
	JobName              string                `protobuf:"bytes,3,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *PrepareJobRequest) Reset()         { *m = PrepareJobRequest{} }
func (m *PrepareJobRequest) String() string { return proto.CompactTextString(m) }
func (*PrepareJobRequest) ProtoMessage()    {}
func (*PrepareJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{0}
}
func (m *PrepareJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrepareJobRequest.Unmarshal(m, b)
}
func (m *PrepareJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrepareJobRequest.Marshal(b, m, deterministic)
}
func (m *PrepareJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrepareJobRequest.Merge(m, src)
}
func (m *PrepareJobRequest) XXX_Size() int {
	return xxx_messageInfo_PrepareJobRequest.Size(m)
}
func (m *PrepareJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PrepareJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PrepareJobRequest proto.InternalMessageInfo

func (m *PrepareJobRequest) GetPipeline() *pipeline_v1.Pipeline {
	if m != nil {
		return m.Pipeline
	}
	return nil
}

func (m *PrepareJobRequest) GetPipelineOptions() *_struct.Struct {
	if m != nil {
		return m.PipelineOptions
	}
	return nil
}

func (m *PrepareJobRequest) GetJobName() string {
	if m != nil {
		return m.JobName
	}
	return ""
}

type PrepareJobResponse struct {
	// (required) The ID used to associate calls made while preparing the job. preparationId is used
	// to run the job.
	PreparationId string `protobuf:"bytes,1,opt,name=preparation_id,json=preparationId,proto3" json:"preparation_id,omitempty"`
	// An endpoint which exposes the Beam Artifact Staging API. Artifacts used by the job should be
	// staged to this endpoint, and will be available during job execution.
	ArtifactStagingEndpoint *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,2,opt,name=artifact_staging_endpoint,json=artifactStagingEndpoint,proto3" json:"artifact_staging_endpoint,omitempty"`
	// (required) Token for the artifact staging. This token also represent an artifact
	// staging session with the artifact staging service.
	StagingSessionToken  string   `protobuf:"bytes,3,opt,name=staging_session_token,json=stagingSessionToken,proto3" json:"staging_session_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PrepareJobResponse) Reset()         { *m = PrepareJobResponse{} }
func (m *PrepareJobResponse) String() string { return proto.CompactTextString(m) }
func (*PrepareJobResponse) ProtoMessage()    {}
func (*PrepareJobResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{1}
}
func (m *PrepareJobResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrepareJobResponse.Unmarshal(m, b)
}
func (m *PrepareJobResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrepareJobResponse.Marshal(b, m, deterministic)
}
func (m *PrepareJobResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrepareJobResponse.Merge(m, src)
}
func (m *PrepareJobResponse) XXX_Size() int {
	return xxx_messageInfo_PrepareJobResponse.Size(m)
}
func (m *PrepareJobResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PrepareJobResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PrepareJobResponse proto.InternalMessageInfo

func (m *PrepareJobResponse) GetPreparationId() string {
	if m != nil {
		return m.PreparationId
	}
	return ""
}

func (m *PrepareJobResponse) GetArtifactStagingEndpoint() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.ArtifactStagingEndpoint
	}
	return nil
}

func (m *PrepareJobResponse) GetStagingSessionToken() string {
	if m != nil {
		return m.StagingSessionToken
	}
	return ""
}

// Run is a synchronous request that returns a jobId back.
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
// Throws error NOT_FOUND if the preparation ID does not exist
// Throws error UNKNOWN for all other issues
type RunJobRequest struct {
	// (required) The ID provided by an earlier call to prepare. Runs the job. All prerequisite tasks
	// must have been completed.
	PreparationId string `protobuf:"bytes,1,opt,name=preparation_id,json=preparationId,proto3" json:"preparation_id,omitempty"`
	// (optional) If any artifacts have been staged for this job, contains the retrieval_token returned
	// from the CommitManifestResponse.
	RetrievalToken       string   `protobuf:"bytes,2,opt,name=retrieval_token,json=retrievalToken,proto3" json:"retrieval_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RunJobRequest) Reset()         { *m = RunJobRequest{} }
func (m *RunJobRequest) String() string { return proto.CompactTextString(m) }
func (*RunJobRequest) ProtoMessage()    {}
func (*RunJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{2}
}
func (m *RunJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RunJobRequest.Unmarshal(m, b)
}
func (m *RunJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RunJobRequest.Marshal(b, m, deterministic)
}
func (m *RunJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunJobRequest.Merge(m, src)
}
func (m *RunJobRequest) XXX_Size() int {
	return xxx_messageInfo_RunJobRequest.Size(m)
}
func (m *RunJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RunJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RunJobRequest proto.InternalMessageInfo

func (m *RunJobRequest) GetPreparationId() string {
	if m != nil {
		return m.PreparationId
	}
	return ""
}

func (m *RunJobRequest) GetRetrievalToken() string {
	if m != nil {
		return m.RetrievalToken
	}
	return ""
}

type RunJobResponse struct {
	JobId                string   `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RunJobResponse) Reset()         { *m = RunJobResponse{} }
func (m *RunJobResponse) String() string { return proto.CompactTextString(m) }
func (*RunJobResponse) ProtoMessage()    {}
func (*RunJobResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{3}
}
func (m *RunJobResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RunJobResponse.Unmarshal(m, b)
}
func (m *RunJobResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RunJobResponse.Marshal(b, m, deterministic)
}
func (m *RunJobResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunJobResponse.Merge(m, src)
}
func (m *RunJobResponse) XXX_Size() int {
	return xxx_messageInfo_RunJobResponse.Size(m)
}
func (m *RunJobResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RunJobResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RunJobResponse proto.InternalMessageInfo

func (m *RunJobResponse) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

// Cancel is a synchronus request that returns a job state back
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
// Throws error NOT_FOUND if the jobId is not found
type CancelJobRequest struct {
	JobId                string   `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CancelJobRequest) Reset()         { *m = CancelJobRequest{} }
func (m *CancelJobRequest) String() string { return proto.CompactTextString(m) }
func (*CancelJobRequest) ProtoMessage()    {}
func (*CancelJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{4}
}
func (m *CancelJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CancelJobRequest.Unmarshal(m, b)
}
func (m *CancelJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CancelJobRequest.Marshal(b, m, deterministic)
}
func (m *CancelJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CancelJobRequest.Merge(m, src)
}
func (m *CancelJobRequest) XXX_Size() int {
	return xxx_messageInfo_CancelJobRequest.Size(m)
}
func (m *CancelJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CancelJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CancelJobRequest proto.InternalMessageInfo

func (m *CancelJobRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

// Valid responses include any terminal state or CANCELLING
type CancelJobResponse struct {
	State                JobState_Enum `protobuf:"varint,1,opt,name=state,proto3,enum=org.apache.beam.model.job_management.v1.JobState_Enum" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CancelJobResponse) Reset()         { *m = CancelJobResponse{} }
func (m *CancelJobResponse) String() string { return proto.CompactTextString(m) }
func (*CancelJobResponse) ProtoMessage()    {}
func (*CancelJobResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{5}
}
func (m *CancelJobResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CancelJobResponse.Unmarshal(m, b)
}
func (m *CancelJobResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CancelJobResponse.Marshal(b, m, deterministic)
}
func (m *CancelJobResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CancelJobResponse.Merge(m, src)
}
func (m *CancelJobResponse) XXX_Size() int {
	return xxx_messageInfo_CancelJobResponse.Size(m)
}
func (m *CancelJobResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CancelJobResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CancelJobResponse proto.InternalMessageInfo

func (m *CancelJobResponse) GetState() JobState_Enum {
	if m != nil {
		return m.State
	}
	return JobState_UNSPECIFIED
}

// GetState is a synchronus request that returns a job state back
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
// Throws error NOT_FOUND if the jobId is not found
type GetJobStateRequest struct {
	JobId                string   `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetJobStateRequest) Reset()         { *m = GetJobStateRequest{} }
func (m *GetJobStateRequest) String() string { return proto.CompactTextString(m) }
func (*GetJobStateRequest) ProtoMessage()    {}
func (*GetJobStateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{6}
}
func (m *GetJobStateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobStateRequest.Unmarshal(m, b)
}
func (m *GetJobStateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobStateRequest.Marshal(b, m, deterministic)
}
func (m *GetJobStateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobStateRequest.Merge(m, src)
}
func (m *GetJobStateRequest) XXX_Size() int {
	return xxx_messageInfo_GetJobStateRequest.Size(m)
}
func (m *GetJobStateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobStateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobStateRequest proto.InternalMessageInfo

func (m *GetJobStateRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

type GetJobStateResponse struct {
	State                JobState_Enum `protobuf:"varint,1,opt,name=state,proto3,enum=org.apache.beam.model.job_management.v1.JobState_Enum" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *GetJobStateResponse) Reset()         { *m = GetJobStateResponse{} }
func (m *GetJobStateResponse) String() string { return proto.CompactTextString(m) }
func (*GetJobStateResponse) ProtoMessage()    {}
func (*GetJobStateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{7}
}
func (m *GetJobStateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobStateResponse.Unmarshal(m, b)
}
func (m *GetJobStateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobStateResponse.Marshal(b, m, deterministic)
}
func (m *GetJobStateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobStateResponse.Merge(m, src)
}
func (m *GetJobStateResponse) XXX_Size() int {
	return xxx_messageInfo_GetJobStateResponse.Size(m)
}
func (m *GetJobStateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobStateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobStateResponse proto.InternalMessageInfo

func (m *GetJobStateResponse) GetState() JobState_Enum {
	if m != nil {
		return m.State
	}
	return JobState_UNSPECIFIED
}

// GetJobMessages is a streaming api for streaming job messages from the service
// One request will connect you to the job and you'll get a stream of job state
// and job messages back; one is used for logging and the other for detecting
// the job ended.
type JobMessagesRequest struct {
	JobId                string   `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobMessagesRequest) Reset()         { *m = JobMessagesRequest{} }
func (m *JobMessagesRequest) String() string { return proto.CompactTextString(m) }
func (*JobMessagesRequest) ProtoMessage()    {}
func (*JobMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{8}
}
func (m *JobMessagesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobMessagesRequest.Unmarshal(m, b)
}
func (m *JobMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobMessagesRequest.Marshal(b, m, deterministic)
}
func (m *JobMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobMessagesRequest.Merge(m, src)
}
func (m *JobMessagesRequest) XXX_Size() int {
	return xxx_messageInfo_JobMessagesRequest.Size(m)
}
func (m *JobMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_JobMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_JobMessagesRequest proto.InternalMessageInfo

func (m *JobMessagesRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

type JobMessage struct {
	MessageId            string                       `protobuf:"bytes,1,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	Time                 string                       `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	Importance           JobMessage_MessageImportance `protobuf:"varint,3,opt,name=importance,proto3,enum=org.apache.beam.model.job_management.v1.JobMessage_MessageImportance" json:"importance,omitempty"`
	MessageText          string                       `protobuf:"bytes,4,opt,name=message_text,json=messageText,proto3" json:"message_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *JobMessage) Reset()         { *m = JobMessage{} }
func (m *JobMessage) String() string { return proto.CompactTextString(m) }
func (*JobMessage) ProtoMessage()    {}
func (*JobMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{9}
}
func (m *JobMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobMessage.Unmarshal(m, b)
}
func (m *JobMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobMessage.Marshal(b, m, deterministic)
}
func (m *JobMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobMessage.Merge(m, src)
}
func (m *JobMessage) XXX_Size() int {
	return xxx_messageInfo_JobMessage.Size(m)
}
func (m *JobMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_JobMessage.DiscardUnknown(m)
}

var xxx_messageInfo_JobMessage proto.InternalMessageInfo

func (m *JobMessage) GetMessageId() string {
	if m != nil {
		return m.MessageId
	}
	return ""
}

func (m *JobMessage) GetTime() string {
	if m != nil {
		return m.Time
	}
	return ""
}

func (m *JobMessage) GetImportance() JobMessage_MessageImportance {
	if m != nil {
		return m.Importance
	}
	return JobMessage_MESSAGE_IMPORTANCE_UNSPECIFIED
}

func (m *JobMessage) GetMessageText() string {
	if m != nil {
		return m.MessageText
	}
	return ""
}

type JobMessagesResponse struct {
	// Types that are valid to be assigned to Response:
	//	*JobMessagesResponse_MessageResponse
	//	*JobMessagesResponse_StateResponse
	Response             isJobMessagesResponse_Response `protobuf_oneof:"response"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *JobMessagesResponse) Reset()         { *m = JobMessagesResponse{} }
func (m *JobMessagesResponse) String() string { return proto.CompactTextString(m) }
func (*JobMessagesResponse) ProtoMessage()    {}
func (*JobMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{10}
}
func (m *JobMessagesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobMessagesResponse.Unmarshal(m, b)
}
func (m *JobMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobMessagesResponse.Marshal(b, m, deterministic)
}
func (m *JobMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobMessagesResponse.Merge(m, src)
}
func (m *JobMessagesResponse) XXX_Size() int {
	return xxx_messageInfo_JobMessagesResponse.Size(m)
}
func (m *JobMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_JobMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_JobMessagesResponse proto.InternalMessageInfo

type isJobMessagesResponse_Response interface {
	isJobMessagesResponse_Response()
}

type JobMessagesResponse_MessageResponse struct {
	MessageResponse *JobMessage `protobuf:"bytes,1,opt,name=message_response,json=messageResponse,proto3,oneof"`
}

type JobMessagesResponse_StateResponse struct {
	StateResponse *GetJobStateResponse `protobuf:"bytes,2,opt,name=state_response,json=stateResponse,proto3,oneof"`
}

func (*JobMessagesResponse_MessageResponse) isJobMessagesResponse_Response() {}

func (*JobMessagesResponse_StateResponse) isJobMessagesResponse_Response() {}

func (m *JobMessagesResponse) GetResponse() isJobMessagesResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *JobMessagesResponse) GetMessageResponse() *JobMessage {
	if x, ok := m.GetResponse().(*JobMessagesResponse_MessageResponse); ok {
		return x.MessageResponse
	}
	return nil
}

func (m *JobMessagesResponse) GetStateResponse() *GetJobStateResponse {
	if x, ok := m.GetResponse().(*JobMessagesResponse_StateResponse); ok {
		return x.StateResponse
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*JobMessagesResponse) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _JobMessagesResponse_OneofMarshaler, _JobMessagesResponse_OneofUnmarshaler, _JobMessagesResponse_OneofSizer, []interface{}{
		(*JobMessagesResponse_MessageResponse)(nil),
		(*JobMessagesResponse_StateResponse)(nil),
	}
}

func _JobMessagesResponse_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*JobMessagesResponse)
	// response
	switch x := m.Response.(type) {
	case *JobMessagesResponse_MessageResponse:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MessageResponse); err != nil {
			return err
		}
	case *JobMessagesResponse_StateResponse:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StateResponse); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("JobMessagesResponse.Response has unexpected type %T", x)
	}
	return nil
}

func _JobMessagesResponse_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*JobMessagesResponse)
	switch tag {
	case 1: // response.message_response
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(JobMessage)
		err := b.DecodeMessage(msg)
		m.Response = &JobMessagesResponse_MessageResponse{msg}
		return true, err
	case 2: // response.state_response
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GetJobStateResponse)
		err := b.DecodeMessage(msg)
		m.Response = &JobMessagesResponse_StateResponse{msg}
		return true, err
	default:
		return false, nil
	}
}

func _JobMessagesResponse_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*JobMessagesResponse)
	// response
	switch x := m.Response.(type) {
	case *JobMessagesResponse_MessageResponse:
		s := proto.Size(x.MessageResponse)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *JobMessagesResponse_StateResponse:
		s := proto.Size(x.StateResponse)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Enumeration of all JobStates
type JobState struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobState) Reset()         { *m = JobState{} }
func (m *JobState) String() string { return proto.CompactTextString(m) }
func (*JobState) ProtoMessage()    {}
func (*JobState) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{11}
}
func (m *JobState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobState.Unmarshal(m, b)
}
func (m *JobState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobState.Marshal(b, m, deterministic)
}
func (m *JobState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobState.Merge(m, src)
}
func (m *JobState) XXX_Size() int {
	return xxx_messageInfo_JobState.Size(m)
}
func (m *JobState) XXX_DiscardUnknown() {
	xxx_messageInfo_JobState.DiscardUnknown(m)
}

var xxx_messageInfo_JobState proto.InternalMessageInfo

func init() {
	proto.RegisterType((*PrepareJobRequest)(nil), "org.apache.beam.model.job_management.v1.PrepareJobRequest")
	proto.RegisterType((*PrepareJobResponse)(nil), "org.apache.beam.model.job_management.v1.PrepareJobResponse")
	proto.RegisterType((*RunJobRequest)(nil), "org.apache.beam.model.job_management.v1.RunJobRequest")
	proto.RegisterType((*RunJobResponse)(nil), "org.apache.beam.model.job_management.v1.RunJobResponse")
	proto.RegisterType((*CancelJobRequest)(nil), "org.apache.beam.model.job_management.v1.CancelJobRequest")
	proto.RegisterType((*CancelJobResponse)(nil), "org.apache.beam.model.job_management.v1.CancelJobResponse")
	proto.RegisterType((*GetJobStateRequest)(nil), "org.apache.beam.model.job_management.v1.GetJobStateRequest")
	proto.RegisterType((*GetJobStateResponse)(nil), "org.apache.beam.model.job_management.v1.GetJobStateResponse")
	proto.RegisterType((*JobMessagesRequest)(nil), "org.apache.beam.model.job_management.v1.JobMessagesRequest")
	proto.RegisterType((*JobMessage)(nil), "org.apache.beam.model.job_management.v1.JobMessage")
	proto.RegisterType((*JobMessagesResponse)(nil), "org.apache.beam.model.job_management.v1.JobMessagesResponse")
	proto.RegisterType((*JobState)(nil), "org.apache.beam.model.job_management.v1.JobState")
	proto.RegisterEnum("org.apache.beam.model.job_management.v1.JobMessage_MessageImportance", JobMessage_MessageImportance_name, JobMessage_MessageImportance_value)
	proto.RegisterEnum("org.apache.beam.model.job_management.v1.JobState_Enum", JobState_Enum_name, JobState_Enum_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// JobServiceClient is the client API for JobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type JobServiceClient interface {
	// Prepare a job for execution. The job will not be executed until a call is made to run with the
	// returned preparationId.
	Prepare(ctx context.Context, in *PrepareJobRequest, opts ...grpc.CallOption) (*PrepareJobResponse, error)
	// Submit the job for execution
	Run(ctx context.Context, in *RunJobRequest, opts ...grpc.CallOption) (*RunJobResponse, error)
	// Get the current state of the job
	GetState(ctx context.Context, in *GetJobStateRequest, opts ...grpc.CallOption) (*GetJobStateResponse, error)
	// Cancel the job
	Cancel(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*CancelJobResponse, error)
	// Subscribe to a stream of state changes of the job, will immediately return the current state of the job as the first response.
	GetStateStream(ctx context.Context, in *GetJobStateRequest, opts ...grpc.CallOption) (JobService_GetStateStreamClient, error)
	// Subscribe to a stream of state changes and messages from the job
	GetMessageStream(ctx context.Context, in *JobMessagesRequest, opts ...grpc.CallOption) (JobService_GetMessageStreamClient, error)
}

type jobServiceClient struct {
	cc *grpc.ClientConn
}

func NewJobServiceClient(cc *grpc.ClientConn) JobServiceClient {
	return &jobServiceClient{cc}
}

func (c *jobServiceClient) Prepare(ctx context.Context, in *PrepareJobRequest, opts ...grpc.CallOption) (*PrepareJobResponse, error) {
	out := new(PrepareJobResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/Prepare", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) Run(ctx context.Context, in *RunJobRequest, opts ...grpc.CallOption) (*RunJobResponse, error) {
	out := new(RunJobResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/Run", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetState(ctx context.Context, in *GetJobStateRequest, opts ...grpc.CallOption) (*GetJobStateResponse, error) {
	out := new(GetJobStateResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/GetState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) Cancel(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*CancelJobResponse, error) {
	out := new(CancelJobResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/Cancel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetStateStream(ctx context.Context, in *GetJobStateRequest, opts ...grpc.CallOption) (JobService_GetStateStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_JobService_serviceDesc.Streams[0], "/org.apache.beam.model.job_management.v1.JobService/GetStateStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &jobServiceGetStateStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type JobService_GetStateStreamClient interface {
	Recv() (*GetJobStateResponse, error)
	grpc.ClientStream
}

type jobServiceGetStateStreamClient struct {
	grpc.ClientStream
}

func (x *jobServiceGetStateStreamClient) Recv() (*GetJobStateResponse, error) {
	m := new(GetJobStateResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *jobServiceClient) GetMessageStream(ctx context.Context, in *JobMessagesRequest, opts ...grpc.CallOption) (JobService_GetMessageStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_JobService_serviceDesc.Streams[1], "/org.apache.beam.model.job_management.v1.JobService/GetMessageStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &jobServiceGetMessageStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type JobService_GetMessageStreamClient interface {
	Recv() (*JobMessagesResponse, error)
	grpc.ClientStream
}

type jobServiceGetMessageStreamClient struct {
	grpc.ClientStream
}

func (x *jobServiceGetMessageStreamClient) Recv() (*JobMessagesResponse, error) {
	m := new(JobMessagesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// JobServiceServer is the server API for JobService service.
type JobServiceServer interface {
	// Prepare a job for execution. The job will not be executed until a call is made to run with the
	// returned preparationId.
	Prepare(context.Context, *PrepareJobRequest) (*PrepareJobResponse, error)
	// Submit the job for execution
	Run(context.Context, *RunJobRequest) (*RunJobResponse, error)
	// Get the current state of the job
	GetState(context.Context, *GetJobStateRequest) (*GetJobStateResponse, error)
	// Cancel the job
	Cancel(context.Context, *CancelJobRequest) (*CancelJobResponse, error)
	// Subscribe to a stream of state changes of the job, will immediately return the current state of the job as the first response.
	GetStateStream(*GetJobStateRequest, JobService_GetStateStreamServer) error
	// Subscribe to a stream of state changes and messages from the job
	GetMessageStream(*JobMessagesRequest, JobService_GetMessageStreamServer) error
}

func RegisterJobServiceServer(s *grpc.Server, srv JobServiceServer) {
	s.RegisterService(&_JobService_serviceDesc, srv)
}

func _JobService_Prepare_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PrepareJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).Prepare(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/Prepare",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).Prepare(ctx, req.(*PrepareJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_Run_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).Run(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/Run",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).Run(ctx, req.(*RunJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/GetState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetState(ctx, req.(*GetJobStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_Cancel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).Cancel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/Cancel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).Cancel(ctx, req.(*CancelJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetStateStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetJobStateRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(JobServiceServer).GetStateStream(m, &jobServiceGetStateStreamServer{stream})
}

type JobService_GetStateStreamServer interface {
	Send(*GetJobStateResponse) error
	grpc.ServerStream
}

type jobServiceGetStateStreamServer struct {
	grpc.ServerStream
}

func (x *jobServiceGetStateStreamServer) Send(m *GetJobStateResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _JobService_GetMessageStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(JobMessagesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(JobServiceServer).GetMessageStream(m, &jobServiceGetMessageStreamServer{stream})
}

type JobService_GetMessageStreamServer interface {
	Send(*JobMessagesResponse) error
	grpc.ServerStream
}

type jobServiceGetMessageStreamServer struct {
	grpc.ServerStream
}

func (x *jobServiceGetMessageStreamServer) Send(m *JobMessagesResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _JobService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.job_management.v1.JobService",
	HandlerType: (*JobServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Prepare",
			Handler:    _JobService_Prepare_Handler,
		},
		{
			MethodName: "Run",
			Handler:    _JobService_Run_Handler,
		},
		{
			MethodName: "GetState",
			Handler:    _JobService_GetState_Handler,
		},
		{
			MethodName: "Cancel",
			Handler:    _JobService_Cancel_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetStateStream",
			Handler:       _JobService_GetStateStream_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetMessageStream",
			Handler:       _JobService_GetMessageStream_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "beam_job_api.proto",
}

func init() { proto.RegisterFile("beam_job_api.proto", fileDescriptor_97c7b84f742157ae) }

var fileDescriptor_97c7b84f742157ae = []byte{
	// 954 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x56, 0x4f, 0x6f, 0xe3, 0x44,
	0x14, 0xaf, 0xd3, 0x34, 0x4d, 0x5e, 0xb7, 0x89, 0x3b, 0xa5, 0x6a, 0x36, 0x02, 0xb4, 0x58, 0x82,
	0x2e, 0x5a, 0xc9, 0xbb, 0xcd, 0x4a, 0xac, 0xd8, 0xe5, 0xe2, 0xc4, 0xde, 0xac, 0xa3, 0x36, 0x89,
	0xc6, 0xa9, 0x90, 0xb8, 0x98, 0x71, 0x32, 0x1b, 0x5c, 0x62, 0x8f, 0xb1, 0x27, 0xd1, 0xde, 0x90,
	0x90, 0x38, 0x22, 0xbe, 0x00, 0x5f, 0x80, 0x13, 0x17, 0x6e, 0x7c, 0x1d, 0x4e, 0x7c, 0x05, 0x2e,
	0x68, 0xec, 0x71, 0x9a, 0xb4, 0x5d, 0x6d, 0x1a, 0x84, 0x38, 0x65, 0xe6, 0xfd, 0xf9, 0xbd, 0xdf,
	0xfb, 0xe3, 0x37, 0x01, 0xe4, 0x51, 0x12, 0xb8, 0x97, 0xcc, 0x73, 0x49, 0xe4, 0xeb, 0x51, 0xcc,
	0x38, 0x43, 0x27, 0x2c, 0x9e, 0xe8, 0x24, 0x22, 0xa3, 0x6f, 0xa8, 0x2e, 0xd4, 0x7a, 0xc0, 0xc6,
	0x74, 0xaa, 0x0b, 0xa3, 0x80, 0x84, 0x64, 0x42, 0x03, 0x1a, 0x72, 0x7d, 0x7e, 0xda, 0x38, 0x4a,
	0x9d, 0xe3, 0x59, 0x18, 0xd2, 0xf8, 0xca, 0xbf, 0x51, 0xa3, 0xe1, 0x38, 0x62, 0x7e, 0xc8, 0x13,
	0x29, 0x78, 0x7f, 0xc2, 0xd8, 0x64, 0x4a, 0x1f, 0xa7, 0x37, 0x6f, 0xf6, 0xfa, 0x71, 0xc2, 0xe3,
	0xd9, 0x88, 0x67, 0x5a, 0xed, 0x0f, 0x05, 0x0e, 0x06, 0x31, 0x8d, 0x48, 0x4c, 0xbb, 0xcc, 0xc3,
	0xf4, 0xbb, 0x19, 0x4d, 0x38, 0xea, 0x40, 0x39, 0xf2, 0x23, 0x3a, 0xf5, 0x43, 0x5a, 0x57, 0x1e,
	0x28, 0x0f, 0xf7, 0x9a, 0x8f, 0xf4, 0xdb, 0x79, 0xe5, 0x66, 0xfa, 0xfc, 0x54, 0x1f, 0xc8, 0x33,
	0x5e, 0x38, 0xa3, 0x16, 0xa8, 0xf9, 0xd9, 0x65, 0x11, 0xf7, 0x59, 0x98, 0xd4, 0x0b, 0x29, 0xe0,
	0xb1, 0x9e, 0xf1, 0xd2, 0x73, 0x5e, 0xba, 0x93, 0xf2, 0xc2, 0xb5, 0xdc, 0xa1, 0x9f, 0xd9, 0xa3,
	0xfb, 0x50, 0x16, 0xd9, 0x87, 0x24, 0xa0, 0xf5, 0xed, 0x07, 0xca, 0xc3, 0x0a, 0xde, 0xbd, 0x64,
	0x5e, 0x8f, 0x04, 0x54, 0xfb, 0x53, 0x01, 0xb4, 0xcc, 0x3e, 0x89, 0x58, 0x98, 0x50, 0xf4, 0x31,
	0x54, 0xa3, 0x54, 0x4a, 0x04, 0x82, 0xeb, 0x8f, 0xd3, 0x24, 0x2a, 0x78, 0x7f, 0x49, 0x6a, 0x8f,
	0x51, 0x02, 0xf7, 0x49, 0xcc, 0xfd, 0xd7, 0x64, 0xc4, 0xdd, 0x84, 0x93, 0x89, 0x1f, 0x4e, 0xdc,
	0xbc, 0x7a, 0x92, 0xe5, 0xb3, 0x35, 0xd2, 0x36, 0x22, 0xdf, 0xa1, 0xf1, 0xdc, 0x1f, 0x51, 0x93,
	0x26, 0xa3, 0xd8, 0x8f, 0x38, 0x8b, 0xf1, 0x71, 0x8e, 0xec, 0x64, 0xc0, 0x96, 0xc4, 0x45, 0x4d,
	0x38, 0xca, 0x63, 0x25, 0x34, 0x49, 0x04, 0x3f, 0xce, 0xbe, 0xa5, 0xa1, 0x4c, 0xed, 0x50, 0x2a,
	0x9d, 0x4c, 0x37, 0x14, 0x2a, 0xcd, 0x85, 0x7d, 0x3c, 0x0b, 0x97, 0xfa, 0xb3, 0x66, 0x82, 0x27,
	0x50, 0x8b, 0x29, 0x8f, 0x7d, 0x3a, 0x27, 0x53, 0x19, 0xa5, 0x90, 0xda, 0x55, 0x17, 0xe2, 0x2c,
	0xc0, 0x09, 0x54, 0xf3, 0x00, 0xb2, 0x84, 0x47, 0x50, 0x12, 0x45, 0x5f, 0x20, 0xef, 0x5c, 0x32,
	0xcf, 0x1e, 0x6b, 0x9f, 0x82, 0xda, 0x26, 0xe1, 0x88, 0x4e, 0x97, 0xc8, 0xbc, 0xc5, 0x94, 0xc0,
	0xc1, 0x92, 0xa9, 0x84, 0x3d, 0x83, 0x9d, 0x84, 0x13, 0x9e, 0x4d, 0x55, 0xb5, 0xf9, 0x99, 0xbe,
	0xe6, 0xb4, 0xeb, 0x5d, 0xe6, 0x39, 0xc2, 0x51, 0xb7, 0xc2, 0x59, 0x80, 0x33, 0x10, 0xed, 0x11,
	0xa0, 0x0e, 0xe5, 0xb9, 0xea, 0x1d, 0x7c, 0x46, 0x70, 0xb8, 0x62, 0xfc, 0x5f, 0x31, 0xea, 0x32,
	0xef, 0x9c, 0x26, 0x09, 0x99, 0xd0, 0xe4, 0x1d, 0x8c, 0xfe, 0x2e, 0x00, 0x5c, 0x59, 0xa3, 0x0f,
	0x00, 0x82, 0xec, 0x78, 0x65, 0x59, 0x91, 0x12, 0x7b, 0x8c, 0x10, 0x14, 0xb9, 0x1f, 0x50, 0xd9,
	0xc1, 0xf4, 0x8c, 0x28, 0x80, 0x1f, 0x44, 0x2c, 0xe6, 0xa2, 0xd0, 0xe9, 0x04, 0x55, 0x9b, 0xd6,
	0x5d, 0x32, 0x90, 0xb1, 0x75, 0xf9, 0x6b, 0x2f, 0xc0, 0xf0, 0x12, 0x30, 0xfa, 0x08, 0xee, 0xe5,
	0xcc, 0x38, 0x7d, 0xc3, 0xeb, 0xc5, 0x94, 0xc2, 0x9e, 0x94, 0x0d, 0xe9, 0x1b, 0xae, 0xfd, 0xa6,
	0xc0, 0xc1, 0x0d, 0x10, 0xa4, 0xc1, 0x87, 0xe7, 0x96, 0xe3, 0x18, 0x1d, 0xcb, 0xb5, 0xcf, 0x07,
	0x7d, 0x3c, 0x34, 0x7a, 0x6d, 0xcb, 0xbd, 0xe8, 0x39, 0x03, 0xab, 0x6d, 0xbf, 0xb4, 0x2d, 0x53,
	0xdd, 0x42, 0x47, 0x70, 0xd0, 0xed, 0xb7, 0xdc, 0xdc, 0xce, 0xb4, 0x5a, 0x17, 0x1d, 0x55, 0x41,
	0x75, 0x78, 0x6f, 0x55, 0x3c, 0x34, 0xec, 0x33, 0xcb, 0x54, 0x0b, 0xd7, 0x1d, 0x5a, 0x86, 0x63,
	0xb7, 0xd5, 0x6d, 0x74, 0x0c, 0x87, 0xcb, 0xe2, 0x2f, 0x0d, 0xdc, 0xb3, 0x7b, 0x1d, 0xb5, 0x78,
	0xdd, 0xde, 0xc2, 0xb8, 0x8f, 0xd5, 0x1d, 0xed, 0x2f, 0x05, 0x0e, 0x57, 0x7a, 0x25, 0x07, 0xe2,
	0x6b, 0x50, 0xf3, 0x64, 0x63, 0x29, 0x93, 0x3b, 0xf0, 0xe9, 0x06, 0x95, 0x7d, 0xb5, 0x85, 0x6b,
	0x12, 0x6e, 0x11, 0x81, 0x42, 0x35, 0x9d, 0x96, 0x2b, 0xfc, 0x6c, 0xd9, 0x7c, 0xb1, 0x36, 0xfe,
	0x2d, 0x83, 0xfc, 0x6a, 0x0b, 0xef, 0x27, 0xcb, 0x82, 0x16, 0x40, 0x39, 0x0f, 0xa0, 0xfd, 0xaa,
	0x40, 0x39, 0xf7, 0xd0, 0x7e, 0x51, 0xa0, 0x28, 0x86, 0x16, 0xd5, 0x60, 0x6f, 0xb5, 0x17, 0x7b,
	0xb0, 0xeb, 0x0c, 0xfb, 0x83, 0x81, 0x65, 0xaa, 0x8a, 0xb8, 0xe0, 0x8b, 0x5e, 0x5a, 0xc4, 0x02,
	0x2a, 0x43, 0xd1, 0xec, 0xf7, 0x2c, 0x75, 0x1b, 0x01, 0x94, 0x5e, 0x66, 0xad, 0x28, 0xa2, 0x7d,
	0xa8, 0xb4, 0x45, 0x4b, 0xcf, 0xc4, 0x75, 0x47, 0x78, 0x5c, 0x0c, 0x4c, 0x63, 0x68, 0x99, 0x6a,
	0x09, 0xdd, 0x83, 0xb2, 0x89, 0x0d, 0x3b, 0xf5, 0xdf, 0x15, 0xaa, 0xf4, 0x66, 0x99, 0x6a, 0x59,
	0xa8, 0x9c, 0xa1, 0x81, 0x87, 0x42, 0x55, 0x41, 0x55, 0x00, 0x09, 0x22, 0xee, 0xd0, 0xfc, 0xbd,
	0x94, 0x7e, 0x16, 0x72, 0xa7, 0xa2, 0x1f, 0x14, 0xd8, 0x95, 0x3b, 0x1e, 0x3d, 0x5f, 0xbb, 0x42,
	0x37, 0xde, 0xb4, 0xc6, 0x8b, 0x8d, 0x7c, 0x65, 0xcb, 0xe6, 0xb0, 0x8d, 0x67, 0x21, 0x5a, 0x7f,
	0x3b, 0xac, 0xec, 0xeb, 0xc6, 0xb3, 0x3b, 0xfb, 0xc9, 0xb8, 0x3f, 0x2a, 0x50, 0xee, 0x50, 0x9e,
	0xf6, 0x0d, 0xbd, 0xd8, 0x6c, 0x3e, 0x32, 0x0a, 0xff, 0x6a, 0xb8, 0xd0, 0xf7, 0x50, 0xca, 0x96,
	0x39, 0xfa, 0x7c, 0x6d, 0x9c, 0xeb, 0x0f, 0x45, 0xe3, 0xf9, 0x26, 0xae, 0x92, 0xc0, 0x4f, 0x0a,
	0x54, 0xf3, 0x42, 0x38, 0x3c, 0xa6, 0x24, 0xf8, 0x1f, 0xcb, 0xf1, 0x44, 0x41, 0x3f, 0x2b, 0xa0,
	0x76, 0x28, 0x97, 0x5f, 0xf9, 0x9d, 0x19, 0xdd, 0x7c, 0x24, 0xee, 0xc0, 0xe8, 0x96, 0xad, 0xf5,
	0x44, 0x69, 0xb5, 0xe0, 0x93, 0xb7, 0x02, 0xac, 0xf8, 0xb7, 0x4a, 0x5d, 0xe6, 0x19, 0x91, 0xff,
	0x95, 0xba, 0xa2, 0x71, 0xe7, 0xa7, 0x5e, 0x29, 0xfd, 0x33, 0xf6, 0xf4, 0x9f, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x49, 0x0e, 0xe5, 0x24, 0x99, 0x0a, 0x00, 0x00,
}
