---
layout: section
title: "Beam Website Contributions"
permalink: /contribute/website-contributions/
section_menu: section-menu/contribute.html
---
<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# Website Contributions

Contributions to the website require the same steps as contributions to the
main repository, so start with the instructions for [Contributing
Code]({{ site.baseurl }}/contribute/contribution-guide).

The Beam website is in the [Beam Site GitHub
mirror](https://github.com/apache/beam-site) repository in the `asf-site`
branch (_not_ `master`).

Issues are tracked in the
[website](https://issues.apache.org/jira/issues/?jql=project%20%3D%20BEAM%20AND%20component%20%3D%20website)
component in JIRA.

## One-time Setup

The [README file](https://github.com/apache/beam-site/blob/asf-site/README.md)
in the website repository has more information on how to set up the required
dependencies for your development environment.

The general guidelines for cloning a repository can be adjusted to use the
`asf-site` branch of `beam-site`:

	$ git clone -b asf-site https://github.com/apache/beam-site.git
	$ cd beam-site
	$ git remote add <GitHub_user> git@github.com:<GitHub_user>/beam-site.git
	$ git fetch --all
	$ git checkout -b <my-branch> origin/asf-site

## Working on your change

While you are working on your pull request, you can test and develop live by
running the following command in the root folder of the website:

	$ bundle exec jekyll serve --incremental

Jekyll will start a webserver on port 4000. As you make changes to the content,
Jekyll will rebuild it automatically.

In addition, you can run the tests to valid your links using:

	$ bundle exec rake test

Both of these commands will cause the `content/` directory to be generated.
Merging autogenerated content can get tricky, so please leave this directory
out of your commits and pull request by doing:

	$ git checkout -- content

When you are ready, submit a pull request using the [Beam Site GitHub
mirror](https://github.com/apache/beam-site), including the JIRA issue as
usual.

During review, committers will patch in your PR, generate the static
`content/`, and review the changes.

## Committing website changes (committers only)

We have a bot that runs tests and merges changes to the website.
When the pull request is fully ready to be merged, a committer
can comment

    @asfgit merge

