// Code generated by protoc-gen-go. DO NOT EDIT.
// source: beam_fn_api.proto

package fnexecution_v1

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import pipeline_v1 "github.com/apache/beam/sdks/go/pkg/beam/model/pipeline_v1"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type MonitoringInfo_MonitoringInfoLabels int32

const (
	MonitoringInfo_TRANSFORM          MonitoringInfo_MonitoringInfoLabels = 0
	MonitoringInfo_PCOLLECTION        MonitoringInfo_MonitoringInfoLabels = 1
	MonitoringInfo_WINDOWING_STRATEGY MonitoringInfo_MonitoringInfoLabels = 2
	MonitoringInfo_CODER              MonitoringInfo_MonitoringInfoLabels = 3
	MonitoringInfo_ENVIRONMENT        MonitoringInfo_MonitoringInfoLabels = 4
)

var MonitoringInfo_MonitoringInfoLabels_name = map[int32]string{
	0: "TRANSFORM",
	1: "PCOLLECTION",
	2: "WINDOWING_STRATEGY",
	3: "CODER",
	4: "ENVIRONMENT",
}
var MonitoringInfo_MonitoringInfoLabels_value = map[string]int32{
	"TRANSFORM":          0,
	"PCOLLECTION":        1,
	"WINDOWING_STRATEGY": 2,
	"CODER":              3,
	"ENVIRONMENT":        4,
}

func (x MonitoringInfo_MonitoringInfoLabels) String() string {
	return proto.EnumName(MonitoringInfo_MonitoringInfoLabels_name, int32(x))
}
func (MonitoringInfo_MonitoringInfoLabels) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{11, 0}
}

type LogEntry_Severity_Enum int32

const (
	// Unspecified level information. Will be logged at the TRACE level.
	LogEntry_Severity_UNSPECIFIED LogEntry_Severity_Enum = 0
	// Trace level information.
	LogEntry_Severity_TRACE LogEntry_Severity_Enum = 1
	// Debugging information.
	LogEntry_Severity_DEBUG LogEntry_Severity_Enum = 2
	// Normal events.
	LogEntry_Severity_INFO LogEntry_Severity_Enum = 3
	// Normal but significant events, such as start up, shut down, or
	// configuration.
	LogEntry_Severity_NOTICE LogEntry_Severity_Enum = 4
	// Warning events might cause problems.
	LogEntry_Severity_WARN LogEntry_Severity_Enum = 5
	// Error events are likely to cause problems.
	LogEntry_Severity_ERROR LogEntry_Severity_Enum = 6
	// Critical events cause severe problems or brief outages and may
	// indicate that a person must take action.
	LogEntry_Severity_CRITICAL LogEntry_Severity_Enum = 7
)

var LogEntry_Severity_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "TRACE",
	2: "DEBUG",
	3: "INFO",
	4: "NOTICE",
	5: "WARN",
	6: "ERROR",
	7: "CRITICAL",
}
var LogEntry_Severity_Enum_value = map[string]int32{
	"UNSPECIFIED": 0,
	"TRACE":       1,
	"DEBUG":       2,
	"INFO":        3,
	"NOTICE":      4,
	"WARN":        5,
	"ERROR":       6,
	"CRITICAL":    7,
}

func (x LogEntry_Severity_Enum) String() string {
	return proto.EnumName(LogEntry_Severity_Enum_name, int32(x))
}
func (LogEntry_Severity_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{35, 1, 0}
}

// A representation of an input or output definition on a primitive transform.
// Stable
type Target struct {
	// (Required) The id of the PrimitiveTransform which is the target.
	PrimitiveTransformReference string `protobuf:"bytes,1,opt,name=primitive_transform_reference,json=primitiveTransformReference,proto3" json:"primitive_transform_reference,omitempty"`
	// (Required) The local name of an input or output defined on the primitive
	// transform.
	Name                 string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Target) Reset()         { *m = Target{} }
func (m *Target) String() string { return proto.CompactTextString(m) }
func (*Target) ProtoMessage()    {}
func (*Target) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{0}
}
func (m *Target) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Target.Unmarshal(m, b)
}
func (m *Target) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Target.Marshal(b, m, deterministic)
}
func (dst *Target) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Target.Merge(dst, src)
}
func (m *Target) XXX_Size() int {
	return xxx_messageInfo_Target.Size(m)
}
func (m *Target) XXX_DiscardUnknown() {
	xxx_messageInfo_Target.DiscardUnknown(m)
}

var xxx_messageInfo_Target proto.InternalMessageInfo

func (m *Target) GetPrimitiveTransformReference() string {
	if m != nil {
		return m.PrimitiveTransformReference
	}
	return ""
}

func (m *Target) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A repeated list of target definitions.
type Target_List struct {
	Target               []*Target `protobuf:"bytes,1,rep,name=target,proto3" json:"target,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *Target_List) Reset()         { *m = Target_List{} }
func (m *Target_List) String() string { return proto.CompactTextString(m) }
func (*Target_List) ProtoMessage()    {}
func (*Target_List) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{0, 0}
}
func (m *Target_List) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Target_List.Unmarshal(m, b)
}
func (m *Target_List) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Target_List.Marshal(b, m, deterministic)
}
func (dst *Target_List) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Target_List.Merge(dst, src)
}
func (m *Target_List) XXX_Size() int {
	return xxx_messageInfo_Target_List.Size(m)
}
func (m *Target_List) XXX_DiscardUnknown() {
	xxx_messageInfo_Target_List.DiscardUnknown(m)
}

var xxx_messageInfo_Target_List proto.InternalMessageInfo

func (m *Target_List) GetTarget() []*Target {
	if m != nil {
		return m.Target
	}
	return nil
}

// A descriptor for connecting to a remote port using the Beam Fn Data API.
// Allows for communication between two environments (for example between the
// runner and the SDK).
// Stable
type RemoteGrpcPort struct {
	// (Required) An API descriptor which describes where to
	// connect to including any authentication that is required.
	ApiServiceDescriptor *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,1,opt,name=api_service_descriptor,json=apiServiceDescriptor,proto3" json:"api_service_descriptor,omitempty"`
	// (Required) The ID of the Coder that will be used to encode and decode data sent over this port.
	CoderId              string   `protobuf:"bytes,2,opt,name=coder_id,json=coderId,proto3" json:"coder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoteGrpcPort) Reset()         { *m = RemoteGrpcPort{} }
func (m *RemoteGrpcPort) String() string { return proto.CompactTextString(m) }
func (*RemoteGrpcPort) ProtoMessage()    {}
func (*RemoteGrpcPort) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{1}
}
func (m *RemoteGrpcPort) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoteGrpcPort.Unmarshal(m, b)
}
func (m *RemoteGrpcPort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoteGrpcPort.Marshal(b, m, deterministic)
}
func (dst *RemoteGrpcPort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoteGrpcPort.Merge(dst, src)
}
func (m *RemoteGrpcPort) XXX_Size() int {
	return xxx_messageInfo_RemoteGrpcPort.Size(m)
}
func (m *RemoteGrpcPort) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoteGrpcPort.DiscardUnknown(m)
}

var xxx_messageInfo_RemoteGrpcPort proto.InternalMessageInfo

func (m *RemoteGrpcPort) GetApiServiceDescriptor() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.ApiServiceDescriptor
	}
	return nil
}

func (m *RemoteGrpcPort) GetCoderId() string {
	if m != nil {
		return m.CoderId
	}
	return ""
}

// A request sent by a runner which the SDK is asked to fulfill.
// For any unsupported request type, an error should be returned with a
// matching instruction id.
// Stable
type InstructionRequest struct {
	// (Required) An unique identifier provided by the runner which represents
	// this requests execution. The InstructionResponse MUST have the matching id.
	InstructionId string `protobuf:"bytes,1,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	// (Required) A request that the SDK Harness needs to interpret.
	//
	// Types that are valid to be assigned to Request:
	//	*InstructionRequest_Register
	//	*InstructionRequest_ProcessBundle
	//	*InstructionRequest_ProcessBundleProgress
	//	*InstructionRequest_ProcessBundleSplit
	Request              isInstructionRequest_Request `protobuf_oneof:"request"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *InstructionRequest) Reset()         { *m = InstructionRequest{} }
func (m *InstructionRequest) String() string { return proto.CompactTextString(m) }
func (*InstructionRequest) ProtoMessage()    {}
func (*InstructionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{2}
}
func (m *InstructionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstructionRequest.Unmarshal(m, b)
}
func (m *InstructionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstructionRequest.Marshal(b, m, deterministic)
}
func (dst *InstructionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstructionRequest.Merge(dst, src)
}
func (m *InstructionRequest) XXX_Size() int {
	return xxx_messageInfo_InstructionRequest.Size(m)
}
func (m *InstructionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InstructionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InstructionRequest proto.InternalMessageInfo

type isInstructionRequest_Request interface {
	isInstructionRequest_Request()
}

type InstructionRequest_Register struct {
	Register *RegisterRequest `protobuf:"bytes,1000,opt,name=register,proto3,oneof"`
}
type InstructionRequest_ProcessBundle struct {
	ProcessBundle *ProcessBundleRequest `protobuf:"bytes,1001,opt,name=process_bundle,json=processBundle,proto3,oneof"`
}
type InstructionRequest_ProcessBundleProgress struct {
	ProcessBundleProgress *ProcessBundleProgressRequest `protobuf:"bytes,1002,opt,name=process_bundle_progress,json=processBundleProgress,proto3,oneof"`
}
type InstructionRequest_ProcessBundleSplit struct {
	ProcessBundleSplit *ProcessBundleSplitRequest `protobuf:"bytes,1003,opt,name=process_bundle_split,json=processBundleSplit,proto3,oneof"`
}

func (*InstructionRequest_Register) isInstructionRequest_Request()              {}
func (*InstructionRequest_ProcessBundle) isInstructionRequest_Request()         {}
func (*InstructionRequest_ProcessBundleProgress) isInstructionRequest_Request() {}
func (*InstructionRequest_ProcessBundleSplit) isInstructionRequest_Request()    {}

func (m *InstructionRequest) GetRequest() isInstructionRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *InstructionRequest) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

func (m *InstructionRequest) GetRegister() *RegisterRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_Register); ok {
		return x.Register
	}
	return nil
}

func (m *InstructionRequest) GetProcessBundle() *ProcessBundleRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_ProcessBundle); ok {
		return x.ProcessBundle
	}
	return nil
}

func (m *InstructionRequest) GetProcessBundleProgress() *ProcessBundleProgressRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_ProcessBundleProgress); ok {
		return x.ProcessBundleProgress
	}
	return nil
}

func (m *InstructionRequest) GetProcessBundleSplit() *ProcessBundleSplitRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_ProcessBundleSplit); ok {
		return x.ProcessBundleSplit
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*InstructionRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _InstructionRequest_OneofMarshaler, _InstructionRequest_OneofUnmarshaler, _InstructionRequest_OneofSizer, []interface{}{
		(*InstructionRequest_Register)(nil),
		(*InstructionRequest_ProcessBundle)(nil),
		(*InstructionRequest_ProcessBundleProgress)(nil),
		(*InstructionRequest_ProcessBundleSplit)(nil),
	}
}

func _InstructionRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*InstructionRequest)
	// request
	switch x := m.Request.(type) {
	case *InstructionRequest_Register:
		b.EncodeVarint(1000<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Register); err != nil {
			return err
		}
	case *InstructionRequest_ProcessBundle:
		b.EncodeVarint(1001<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProcessBundle); err != nil {
			return err
		}
	case *InstructionRequest_ProcessBundleProgress:
		b.EncodeVarint(1002<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProcessBundleProgress); err != nil {
			return err
		}
	case *InstructionRequest_ProcessBundleSplit:
		b.EncodeVarint(1003<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProcessBundleSplit); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("InstructionRequest.Request has unexpected type %T", x)
	}
	return nil
}

func _InstructionRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*InstructionRequest)
	switch tag {
	case 1000: // request.register
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RegisterRequest)
		err := b.DecodeMessage(msg)
		m.Request = &InstructionRequest_Register{msg}
		return true, err
	case 1001: // request.process_bundle
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProcessBundleRequest)
		err := b.DecodeMessage(msg)
		m.Request = &InstructionRequest_ProcessBundle{msg}
		return true, err
	case 1002: // request.process_bundle_progress
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProcessBundleProgressRequest)
		err := b.DecodeMessage(msg)
		m.Request = &InstructionRequest_ProcessBundleProgress{msg}
		return true, err
	case 1003: // request.process_bundle_split
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProcessBundleSplitRequest)
		err := b.DecodeMessage(msg)
		m.Request = &InstructionRequest_ProcessBundleSplit{msg}
		return true, err
	default:
		return false, nil
	}
}

func _InstructionRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*InstructionRequest)
	// request
	switch x := m.Request.(type) {
	case *InstructionRequest_Register:
		s := proto.Size(x.Register)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionRequest_ProcessBundle:
		s := proto.Size(x.ProcessBundle)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionRequest_ProcessBundleProgress:
		s := proto.Size(x.ProcessBundleProgress)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionRequest_ProcessBundleSplit:
		s := proto.Size(x.ProcessBundleSplit)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The response for an associated request the SDK had been asked to fulfill.
// Stable
type InstructionResponse struct {
	// (Required) A reference provided by the runner which represents a requests
	// execution. The InstructionResponse MUST have the matching id when
	// responding to the runner.
	InstructionId string `protobuf:"bytes,1,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	// If this is specified, then this instruction has failed.
	// A human readable string representing the reason as to why processing has
	// failed.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// If the instruction did not fail, it is required to return an equivalent
	// response type depending on the request this matches.
	//
	// Types that are valid to be assigned to Response:
	//	*InstructionResponse_Register
	//	*InstructionResponse_ProcessBundle
	//	*InstructionResponse_ProcessBundleProgress
	//	*InstructionResponse_ProcessBundleSplit
	Response             isInstructionResponse_Response `protobuf_oneof:"response"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *InstructionResponse) Reset()         { *m = InstructionResponse{} }
func (m *InstructionResponse) String() string { return proto.CompactTextString(m) }
func (*InstructionResponse) ProtoMessage()    {}
func (*InstructionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{3}
}
func (m *InstructionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstructionResponse.Unmarshal(m, b)
}
func (m *InstructionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstructionResponse.Marshal(b, m, deterministic)
}
func (dst *InstructionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstructionResponse.Merge(dst, src)
}
func (m *InstructionResponse) XXX_Size() int {
	return xxx_messageInfo_InstructionResponse.Size(m)
}
func (m *InstructionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_InstructionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_InstructionResponse proto.InternalMessageInfo

type isInstructionResponse_Response interface {
	isInstructionResponse_Response()
}

type InstructionResponse_Register struct {
	Register *RegisterResponse `protobuf:"bytes,1000,opt,name=register,proto3,oneof"`
}
type InstructionResponse_ProcessBundle struct {
	ProcessBundle *ProcessBundleResponse `protobuf:"bytes,1001,opt,name=process_bundle,json=processBundle,proto3,oneof"`
}
type InstructionResponse_ProcessBundleProgress struct {
	ProcessBundleProgress *ProcessBundleProgressResponse `protobuf:"bytes,1002,opt,name=process_bundle_progress,json=processBundleProgress,proto3,oneof"`
}
type InstructionResponse_ProcessBundleSplit struct {
	ProcessBundleSplit *ProcessBundleSplitResponse `protobuf:"bytes,1003,opt,name=process_bundle_split,json=processBundleSplit,proto3,oneof"`
}

func (*InstructionResponse_Register) isInstructionResponse_Response()              {}
func (*InstructionResponse_ProcessBundle) isInstructionResponse_Response()         {}
func (*InstructionResponse_ProcessBundleProgress) isInstructionResponse_Response() {}
func (*InstructionResponse_ProcessBundleSplit) isInstructionResponse_Response()    {}

func (m *InstructionResponse) GetResponse() isInstructionResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *InstructionResponse) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

func (m *InstructionResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *InstructionResponse) GetRegister() *RegisterResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_Register); ok {
		return x.Register
	}
	return nil
}

func (m *InstructionResponse) GetProcessBundle() *ProcessBundleResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_ProcessBundle); ok {
		return x.ProcessBundle
	}
	return nil
}

func (m *InstructionResponse) GetProcessBundleProgress() *ProcessBundleProgressResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_ProcessBundleProgress); ok {
		return x.ProcessBundleProgress
	}
	return nil
}

func (m *InstructionResponse) GetProcessBundleSplit() *ProcessBundleSplitResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_ProcessBundleSplit); ok {
		return x.ProcessBundleSplit
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*InstructionResponse) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _InstructionResponse_OneofMarshaler, _InstructionResponse_OneofUnmarshaler, _InstructionResponse_OneofSizer, []interface{}{
		(*InstructionResponse_Register)(nil),
		(*InstructionResponse_ProcessBundle)(nil),
		(*InstructionResponse_ProcessBundleProgress)(nil),
		(*InstructionResponse_ProcessBundleSplit)(nil),
	}
}

func _InstructionResponse_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*InstructionResponse)
	// response
	switch x := m.Response.(type) {
	case *InstructionResponse_Register:
		b.EncodeVarint(1000<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Register); err != nil {
			return err
		}
	case *InstructionResponse_ProcessBundle:
		b.EncodeVarint(1001<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProcessBundle); err != nil {
			return err
		}
	case *InstructionResponse_ProcessBundleProgress:
		b.EncodeVarint(1002<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProcessBundleProgress); err != nil {
			return err
		}
	case *InstructionResponse_ProcessBundleSplit:
		b.EncodeVarint(1003<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProcessBundleSplit); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("InstructionResponse.Response has unexpected type %T", x)
	}
	return nil
}

func _InstructionResponse_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*InstructionResponse)
	switch tag {
	case 1000: // response.register
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RegisterResponse)
		err := b.DecodeMessage(msg)
		m.Response = &InstructionResponse_Register{msg}
		return true, err
	case 1001: // response.process_bundle
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProcessBundleResponse)
		err := b.DecodeMessage(msg)
		m.Response = &InstructionResponse_ProcessBundle{msg}
		return true, err
	case 1002: // response.process_bundle_progress
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProcessBundleProgressResponse)
		err := b.DecodeMessage(msg)
		m.Response = &InstructionResponse_ProcessBundleProgress{msg}
		return true, err
	case 1003: // response.process_bundle_split
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProcessBundleSplitResponse)
		err := b.DecodeMessage(msg)
		m.Response = &InstructionResponse_ProcessBundleSplit{msg}
		return true, err
	default:
		return false, nil
	}
}

func _InstructionResponse_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*InstructionResponse)
	// response
	switch x := m.Response.(type) {
	case *InstructionResponse_Register:
		s := proto.Size(x.Register)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionResponse_ProcessBundle:
		s := proto.Size(x.ProcessBundle)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionResponse_ProcessBundleProgress:
		s := proto.Size(x.ProcessBundleProgress)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionResponse_ProcessBundleSplit:
		s := proto.Size(x.ProcessBundleSplit)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A list of objects which can be referred to by the runner in
// future requests.
// Stable
type RegisterRequest struct {
	// (Optional) The set of descriptors used to process bundles.
	ProcessBundleDescriptor []*ProcessBundleDescriptor `protobuf:"bytes,1,rep,name=process_bundle_descriptor,json=processBundleDescriptor,proto3" json:"process_bundle_descriptor,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}                   `json:"-"`
	XXX_unrecognized        []byte                     `json:"-"`
	XXX_sizecache           int32                      `json:"-"`
}

func (m *RegisterRequest) Reset()         { *m = RegisterRequest{} }
func (m *RegisterRequest) String() string { return proto.CompactTextString(m) }
func (*RegisterRequest) ProtoMessage()    {}
func (*RegisterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{4}
}
func (m *RegisterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RegisterRequest.Unmarshal(m, b)
}
func (m *RegisterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RegisterRequest.Marshal(b, m, deterministic)
}
func (dst *RegisterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterRequest.Merge(dst, src)
}
func (m *RegisterRequest) XXX_Size() int {
	return xxx_messageInfo_RegisterRequest.Size(m)
}
func (m *RegisterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterRequest proto.InternalMessageInfo

func (m *RegisterRequest) GetProcessBundleDescriptor() []*ProcessBundleDescriptor {
	if m != nil {
		return m.ProcessBundleDescriptor
	}
	return nil
}

// Stable
type RegisterResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RegisterResponse) Reset()         { *m = RegisterResponse{} }
func (m *RegisterResponse) String() string { return proto.CompactTextString(m) }
func (*RegisterResponse) ProtoMessage()    {}
func (*RegisterResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{5}
}
func (m *RegisterResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RegisterResponse.Unmarshal(m, b)
}
func (m *RegisterResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RegisterResponse.Marshal(b, m, deterministic)
}
func (dst *RegisterResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterResponse.Merge(dst, src)
}
func (m *RegisterResponse) XXX_Size() int {
	return xxx_messageInfo_RegisterResponse.Size(m)
}
func (m *RegisterResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterResponse proto.InternalMessageInfo

// Definitions that should be used to construct the bundle processing graph.
type ProcessBundleDescriptor struct {
	// (Required) A pipeline level unique id which can be used as a reference to
	// refer to this.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// (Required) A map from pipeline-scoped id to PTransform.
	Transforms map[string]*pipeline_v1.PTransform `protobuf:"bytes,2,rep,name=transforms,proto3" json:"transforms,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to PCollection.
	Pcollections map[string]*pipeline_v1.PCollection `protobuf:"bytes,3,rep,name=pcollections,proto3" json:"pcollections,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to WindowingStrategy.
	WindowingStrategies map[string]*pipeline_v1.WindowingStrategy `protobuf:"bytes,4,rep,name=windowing_strategies,json=windowingStrategies,proto3" json:"windowing_strategies,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to Coder.
	Coders map[string]*pipeline_v1.Coder `protobuf:"bytes,5,rep,name=coders,proto3" json:"coders,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to Environment.
	Environments map[string]*pipeline_v1.Environment `protobuf:"bytes,6,rep,name=environments,proto3" json:"environments,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A descriptor describing the end point to use for State API
	// calls. Required if the Runner intends to send remote references over the
	// data plane or if any of the transforms rely on user state or side inputs.
	StateApiServiceDescriptor *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,7,opt,name=state_api_service_descriptor,json=stateApiServiceDescriptor,proto3" json:"state_api_service_descriptor,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}                          `json:"-"`
	XXX_unrecognized          []byte                            `json:"-"`
	XXX_sizecache             int32                             `json:"-"`
}

func (m *ProcessBundleDescriptor) Reset()         { *m = ProcessBundleDescriptor{} }
func (m *ProcessBundleDescriptor) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleDescriptor) ProtoMessage()    {}
func (*ProcessBundleDescriptor) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{6}
}
func (m *ProcessBundleDescriptor) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleDescriptor.Unmarshal(m, b)
}
func (m *ProcessBundleDescriptor) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleDescriptor.Marshal(b, m, deterministic)
}
func (dst *ProcessBundleDescriptor) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleDescriptor.Merge(dst, src)
}
func (m *ProcessBundleDescriptor) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleDescriptor.Size(m)
}
func (m *ProcessBundleDescriptor) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleDescriptor.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleDescriptor proto.InternalMessageInfo

func (m *ProcessBundleDescriptor) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ProcessBundleDescriptor) GetTransforms() map[string]*pipeline_v1.PTransform {
	if m != nil {
		return m.Transforms
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetPcollections() map[string]*pipeline_v1.PCollection {
	if m != nil {
		return m.Pcollections
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetWindowingStrategies() map[string]*pipeline_v1.WindowingStrategy {
	if m != nil {
		return m.WindowingStrategies
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetCoders() map[string]*pipeline_v1.Coder {
	if m != nil {
		return m.Coders
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetEnvironments() map[string]*pipeline_v1.Environment {
	if m != nil {
		return m.Environments
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetStateApiServiceDescriptor() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.StateApiServiceDescriptor
	}
	return nil
}

// Represents a partition of the bundle into two bundles: a "primary" and
// a "residual", with the following properties:
// - The work in primary and residual doesn't overlap, and combined, adds up
//   to the work in the current bundle if the split hadn't happened.
// - The current bundle, if it keeps executing, will have done none of the
//   work under residual roots.
// - The current bundle, if no further splits happen, will have done exactly
//   the work under primary_roots.
// For more rigorous definitions see https://s.apache.org/beam-breaking-fusion
type BundleSplit struct {
	// Root applications that should replace the current bundle.
	PrimaryRoots []*BundleSplit_Application `protobuf:"bytes,1,rep,name=primary_roots,json=primaryRoots,proto3" json:"primary_roots,omitempty"`
	// Root applications that have been removed from the current bundle and
	// have to be executed in a separate bundle (e.g. in parallel on a different
	// worker, or after the current bundle completes, etc.)
	ResidualRoots        []*BundleSplit_Application `protobuf:"bytes,2,rep,name=residual_roots,json=residualRoots,proto3" json:"residual_roots,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *BundleSplit) Reset()         { *m = BundleSplit{} }
func (m *BundleSplit) String() string { return proto.CompactTextString(m) }
func (*BundleSplit) ProtoMessage()    {}
func (*BundleSplit) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{7}
}
func (m *BundleSplit) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BundleSplit.Unmarshal(m, b)
}
func (m *BundleSplit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BundleSplit.Marshal(b, m, deterministic)
}
func (dst *BundleSplit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BundleSplit.Merge(dst, src)
}
func (m *BundleSplit) XXX_Size() int {
	return xxx_messageInfo_BundleSplit.Size(m)
}
func (m *BundleSplit) XXX_DiscardUnknown() {
	xxx_messageInfo_BundleSplit.DiscardUnknown(m)
}

var xxx_messageInfo_BundleSplit proto.InternalMessageInfo

func (m *BundleSplit) GetPrimaryRoots() []*BundleSplit_Application {
	if m != nil {
		return m.PrimaryRoots
	}
	return nil
}

func (m *BundleSplit) GetResidualRoots() []*BundleSplit_Application {
	if m != nil {
		return m.ResidualRoots
	}
	return nil
}

// One of the root applications specifying the scope of work for a bundle.
type BundleSplit_Application struct {
	// (Required) The primitive transform to which to pass the element
	PtransformId string `protobuf:"bytes,1,opt,name=ptransform_id,json=ptransformId,proto3" json:"ptransform_id,omitempty"`
	// (Required) Name of the transform's input to which to pass the element.
	InputId string `protobuf:"bytes,2,opt,name=input_id,json=inputId,proto3" json:"input_id,omitempty"`
	// (Required) The encoded element to pass to the transform.
	Element []byte `protobuf:"bytes,3,opt,name=element,proto3" json:"element,omitempty"`
	// Approximate lower bounds on timestamps of elements that this PTransform
	// will produce into each of its output PCollections, when invoked on this
	// element. Keyed by the transform's local output name.
	OutputWatermarks map[string]int64 `protobuf:"bytes,4,rep,name=output_watermarks,json=outputWatermarks,proto3" json:"output_watermarks,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// Approximate fraction of all work of the current bundle (before split)
	// represented by invoking this Application and its downstream applications.
	// The sum of fraction_of_work between all primary_roots and residual_roots
	// must add up to approximately 1.0.
	FractionOfWork       *wrappers.DoubleValue `protobuf:"bytes,5,opt,name=fraction_of_work,json=fractionOfWork,proto3" json:"fraction_of_work,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *BundleSplit_Application) Reset()         { *m = BundleSplit_Application{} }
func (m *BundleSplit_Application) String() string { return proto.CompactTextString(m) }
func (*BundleSplit_Application) ProtoMessage()    {}
func (*BundleSplit_Application) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{7, 0}
}
func (m *BundleSplit_Application) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BundleSplit_Application.Unmarshal(m, b)
}
func (m *BundleSplit_Application) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BundleSplit_Application.Marshal(b, m, deterministic)
}
func (dst *BundleSplit_Application) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BundleSplit_Application.Merge(dst, src)
}
func (m *BundleSplit_Application) XXX_Size() int {
	return xxx_messageInfo_BundleSplit_Application.Size(m)
}
func (m *BundleSplit_Application) XXX_DiscardUnknown() {
	xxx_messageInfo_BundleSplit_Application.DiscardUnknown(m)
}

var xxx_messageInfo_BundleSplit_Application proto.InternalMessageInfo

func (m *BundleSplit_Application) GetPtransformId() string {
	if m != nil {
		return m.PtransformId
	}
	return ""
}

func (m *BundleSplit_Application) GetInputId() string {
	if m != nil {
		return m.InputId
	}
	return ""
}

func (m *BundleSplit_Application) GetElement() []byte {
	if m != nil {
		return m.Element
	}
	return nil
}

func (m *BundleSplit_Application) GetOutputWatermarks() map[string]int64 {
	if m != nil {
		return m.OutputWatermarks
	}
	return nil
}

func (m *BundleSplit_Application) GetFractionOfWork() *wrappers.DoubleValue {
	if m != nil {
		return m.FractionOfWork
	}
	return nil
}

// A request to process a given bundle.
// Stable
type ProcessBundleRequest struct {
	// (Required) A reference to the process bundle descriptor that must be
	// instantiated and executed by the SDK harness.
	ProcessBundleDescriptorReference string `protobuf:"bytes,1,opt,name=process_bundle_descriptor_reference,json=processBundleDescriptorReference,proto3" json:"process_bundle_descriptor_reference,omitempty"`
	// (Optional) A list of cache tokens that can be used by an SDK to reuse
	// cached data returned by the State API across multiple bundles.
	CacheTokens          [][]byte `protobuf:"bytes,2,rep,name=cache_tokens,json=cacheTokens,proto3" json:"cache_tokens,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleRequest) Reset()         { *m = ProcessBundleRequest{} }
func (m *ProcessBundleRequest) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleRequest) ProtoMessage()    {}
func (*ProcessBundleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{8}
}
func (m *ProcessBundleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleRequest.Unmarshal(m, b)
}
func (m *ProcessBundleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleRequest.Marshal(b, m, deterministic)
}
func (dst *ProcessBundleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleRequest.Merge(dst, src)
}
func (m *ProcessBundleRequest) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleRequest.Size(m)
}
func (m *ProcessBundleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleRequest proto.InternalMessageInfo

func (m *ProcessBundleRequest) GetProcessBundleDescriptorReference() string {
	if m != nil {
		return m.ProcessBundleDescriptorReference
	}
	return ""
}

func (m *ProcessBundleRequest) GetCacheTokens() [][]byte {
	if m != nil {
		return m.CacheTokens
	}
	return nil
}

// Stable
type ProcessBundleResponse struct {
	// (Optional) If metrics reporting is supported by the SDK, this represents
	// the final metrics to record for this bundle.
	Metrics *Metrics `protobuf:"bytes,1,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// (Optional) Specifies that the bundle has been split since the last
	// ProcessBundleProgressResponse was sent.
	Split                *BundleSplit `protobuf:"bytes,2,opt,name=split,proto3" json:"split,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ProcessBundleResponse) Reset()         { *m = ProcessBundleResponse{} }
func (m *ProcessBundleResponse) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleResponse) ProtoMessage()    {}
func (*ProcessBundleResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{9}
}
func (m *ProcessBundleResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleResponse.Unmarshal(m, b)
}
func (m *ProcessBundleResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleResponse.Marshal(b, m, deterministic)
}
func (dst *ProcessBundleResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleResponse.Merge(dst, src)
}
func (m *ProcessBundleResponse) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleResponse.Size(m)
}
func (m *ProcessBundleResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleResponse proto.InternalMessageInfo

func (m *ProcessBundleResponse) GetMetrics() *Metrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *ProcessBundleResponse) GetSplit() *BundleSplit {
	if m != nil {
		return m.Split
	}
	return nil
}

// A request to report progress information for a given bundle.
// This is an optional request to be handled and is used to support advanced
// SDK features such as SplittableDoFn, user level metrics etc.
type ProcessBundleProgressRequest struct {
	// (Required) A reference to an active process bundle request with the given
	// instruction id.
	InstructionReference string   `protobuf:"bytes,1,opt,name=instruction_reference,json=instructionReference,proto3" json:"instruction_reference,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleProgressRequest) Reset()         { *m = ProcessBundleProgressRequest{} }
func (m *ProcessBundleProgressRequest) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleProgressRequest) ProtoMessage()    {}
func (*ProcessBundleProgressRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{10}
}
func (m *ProcessBundleProgressRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleProgressRequest.Unmarshal(m, b)
}
func (m *ProcessBundleProgressRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleProgressRequest.Marshal(b, m, deterministic)
}
func (dst *ProcessBundleProgressRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleProgressRequest.Merge(dst, src)
}
func (m *ProcessBundleProgressRequest) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleProgressRequest.Size(m)
}
func (m *ProcessBundleProgressRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleProgressRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleProgressRequest proto.InternalMessageInfo

func (m *ProcessBundleProgressRequest) GetInstructionReference() string {
	if m != nil {
		return m.InstructionReference
	}
	return ""
}

type MonitoringInfo struct {
	// The name defining the metric or monitored state.
	Urn string `protobuf:"bytes,1,opt,name=urn,proto3" json:"urn,omitempty"`
	// This is specified as a URN that implies:
	// A message class: (Distribution, Counter, Extrema, MonitoringDataTable).
	// Sub types like field formats - int64, double, string.
	// Aggregation methods - SUM, LATEST, TOP-N, BOTTOM-N, DISTRIBUTION
	// valid values are:
	// beam:metrics:[SumInt64|LatestInt64|Top-NInt64|Bottom-NInt64|
	//     SumDouble|LatestDouble|Top-NDouble|Bottom-NDouble|DistributionInt64|
	//     DistributionDouble|MonitoringDataTable]
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// The Metric or monitored state.
	//
	// Types that are valid to be assigned to Data:
	//	*MonitoringInfo_MonitoringTableData
	//	*MonitoringInfo_Metric
	Data isMonitoringInfo_Data `protobuf_oneof:"data"`
	// A set of key+value labels which define the scope of the metric.
	// Either a well defined entity id for matching the enum names in
	// the MonitoringInfoLabels enum or any arbitrary label
	// set by a custom metric or user metric.
	// A monitoring system is expected to be able to aggregate the metrics together
	// for all updates having the same URN and labels.
	// Some systems such as Stackdriver will be able to aggregate the metrics
	// using a subset of the provided labels
	Labels               map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *MonitoringInfo) Reset()         { *m = MonitoringInfo{} }
func (m *MonitoringInfo) String() string { return proto.CompactTextString(m) }
func (*MonitoringInfo) ProtoMessage()    {}
func (*MonitoringInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{11}
}
func (m *MonitoringInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MonitoringInfo.Unmarshal(m, b)
}
func (m *MonitoringInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MonitoringInfo.Marshal(b, m, deterministic)
}
func (dst *MonitoringInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MonitoringInfo.Merge(dst, src)
}
func (m *MonitoringInfo) XXX_Size() int {
	return xxx_messageInfo_MonitoringInfo.Size(m)
}
func (m *MonitoringInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_MonitoringInfo.DiscardUnknown(m)
}

var xxx_messageInfo_MonitoringInfo proto.InternalMessageInfo

type isMonitoringInfo_Data interface {
	isMonitoringInfo_Data()
}

type MonitoringInfo_MonitoringTableData struct {
	MonitoringTableData *MonitoringTableData `protobuf:"bytes,3,opt,name=monitoring_table_data,json=monitoringTableData,proto3,oneof"`
}
type MonitoringInfo_Metric struct {
	Metric *Metric `protobuf:"bytes,4,opt,name=metric,proto3,oneof"`
}

func (*MonitoringInfo_MonitoringTableData) isMonitoringInfo_Data() {}
func (*MonitoringInfo_Metric) isMonitoringInfo_Data()              {}

func (m *MonitoringInfo) GetData() isMonitoringInfo_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *MonitoringInfo) GetUrn() string {
	if m != nil {
		return m.Urn
	}
	return ""
}

func (m *MonitoringInfo) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *MonitoringInfo) GetMonitoringTableData() *MonitoringTableData {
	if x, ok := m.GetData().(*MonitoringInfo_MonitoringTableData); ok {
		return x.MonitoringTableData
	}
	return nil
}

func (m *MonitoringInfo) GetMetric() *Metric {
	if x, ok := m.GetData().(*MonitoringInfo_Metric); ok {
		return x.Metric
	}
	return nil
}

func (m *MonitoringInfo) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*MonitoringInfo) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _MonitoringInfo_OneofMarshaler, _MonitoringInfo_OneofUnmarshaler, _MonitoringInfo_OneofSizer, []interface{}{
		(*MonitoringInfo_MonitoringTableData)(nil),
		(*MonitoringInfo_Metric)(nil),
	}
}

func _MonitoringInfo_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*MonitoringInfo)
	// data
	switch x := m.Data.(type) {
	case *MonitoringInfo_MonitoringTableData:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MonitoringTableData); err != nil {
			return err
		}
	case *MonitoringInfo_Metric:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Metric); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("MonitoringInfo.Data has unexpected type %T", x)
	}
	return nil
}

func _MonitoringInfo_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*MonitoringInfo)
	switch tag {
	case 3: // data.monitoring_table_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MonitoringTableData)
		err := b.DecodeMessage(msg)
		m.Data = &MonitoringInfo_MonitoringTableData{msg}
		return true, err
	case 4: // data.metric
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Metric)
		err := b.DecodeMessage(msg)
		m.Data = &MonitoringInfo_Metric{msg}
		return true, err
	default:
		return false, nil
	}
}

func _MonitoringInfo_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*MonitoringInfo)
	// data
	switch x := m.Data.(type) {
	case *MonitoringInfo_MonitoringTableData:
		s := proto.Size(x.MonitoringTableData)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MonitoringInfo_Metric:
		s := proto.Size(x.Metric)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type Metric struct {
	// (Required) The data for this metric.
	//
	// Types that are valid to be assigned to Data:
	//	*Metric_CounterData
	//	*Metric_DistributionData
	//	*Metric_ExtremaData
	Data                 isMetric_Data `protobuf_oneof:"data"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Metric) Reset()         { *m = Metric{} }
func (m *Metric) String() string { return proto.CompactTextString(m) }
func (*Metric) ProtoMessage()    {}
func (*Metric) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{12}
}
func (m *Metric) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metric.Unmarshal(m, b)
}
func (m *Metric) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metric.Marshal(b, m, deterministic)
}
func (dst *Metric) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metric.Merge(dst, src)
}
func (m *Metric) XXX_Size() int {
	return xxx_messageInfo_Metric.Size(m)
}
func (m *Metric) XXX_DiscardUnknown() {
	xxx_messageInfo_Metric.DiscardUnknown(m)
}

var xxx_messageInfo_Metric proto.InternalMessageInfo

type isMetric_Data interface {
	isMetric_Data()
}

type Metric_CounterData struct {
	CounterData *CounterData `protobuf:"bytes,1,opt,name=counter_data,json=counterData,proto3,oneof"`
}
type Metric_DistributionData struct {
	DistributionData *DistributionData `protobuf:"bytes,2,opt,name=distribution_data,json=distributionData,proto3,oneof"`
}
type Metric_ExtremaData struct {
	ExtremaData *ExtremaData `protobuf:"bytes,3,opt,name=extrema_data,json=extremaData,proto3,oneof"`
}

func (*Metric_CounterData) isMetric_Data()      {}
func (*Metric_DistributionData) isMetric_Data() {}
func (*Metric_ExtremaData) isMetric_Data()      {}

func (m *Metric) GetData() isMetric_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Metric) GetCounterData() *CounterData {
	if x, ok := m.GetData().(*Metric_CounterData); ok {
		return x.CounterData
	}
	return nil
}

func (m *Metric) GetDistributionData() *DistributionData {
	if x, ok := m.GetData().(*Metric_DistributionData); ok {
		return x.DistributionData
	}
	return nil
}

func (m *Metric) GetExtremaData() *ExtremaData {
	if x, ok := m.GetData().(*Metric_ExtremaData); ok {
		return x.ExtremaData
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Metric) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Metric_OneofMarshaler, _Metric_OneofUnmarshaler, _Metric_OneofSizer, []interface{}{
		(*Metric_CounterData)(nil),
		(*Metric_DistributionData)(nil),
		(*Metric_ExtremaData)(nil),
	}
}

func _Metric_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Metric)
	// data
	switch x := m.Data.(type) {
	case *Metric_CounterData:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CounterData); err != nil {
			return err
		}
	case *Metric_DistributionData:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DistributionData); err != nil {
			return err
		}
	case *Metric_ExtremaData:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ExtremaData); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Metric.Data has unexpected type %T", x)
	}
	return nil
}

func _Metric_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Metric)
	switch tag {
	case 1: // data.counter_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CounterData)
		err := b.DecodeMessage(msg)
		m.Data = &Metric_CounterData{msg}
		return true, err
	case 2: // data.distribution_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DistributionData)
		err := b.DecodeMessage(msg)
		m.Data = &Metric_DistributionData{msg}
		return true, err
	case 3: // data.extrema_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ExtremaData)
		err := b.DecodeMessage(msg)
		m.Data = &Metric_ExtremaData{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Metric_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Metric)
	// data
	switch x := m.Data.(type) {
	case *Metric_CounterData:
		s := proto.Size(x.CounterData)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Metric_DistributionData:
		s := proto.Size(x.DistributionData)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Metric_ExtremaData:
		s := proto.Size(x.ExtremaData)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Data associated with a Counter or Gauge metric.
// This is designed to be compatible with metric collection
// systems such as DropWizard.
type CounterData struct {
	// Types that are valid to be assigned to Value:
	//	*CounterData_Int64Value
	//	*CounterData_DoubleValue
	//	*CounterData_StringValue
	Value                isCounterData_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *CounterData) Reset()         { *m = CounterData{} }
func (m *CounterData) String() string { return proto.CompactTextString(m) }
func (*CounterData) ProtoMessage()    {}
func (*CounterData) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{13}
}
func (m *CounterData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CounterData.Unmarshal(m, b)
}
func (m *CounterData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CounterData.Marshal(b, m, deterministic)
}
func (dst *CounterData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CounterData.Merge(dst, src)
}
func (m *CounterData) XXX_Size() int {
	return xxx_messageInfo_CounterData.Size(m)
}
func (m *CounterData) XXX_DiscardUnknown() {
	xxx_messageInfo_CounterData.DiscardUnknown(m)
}

var xxx_messageInfo_CounterData proto.InternalMessageInfo

type isCounterData_Value interface {
	isCounterData_Value()
}

type CounterData_Int64Value struct {
	Int64Value int64 `protobuf:"varint,1,opt,name=int64_value,json=int64Value,proto3,oneof"`
}
type CounterData_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,2,opt,name=double_value,json=doubleValue,proto3,oneof"`
}
type CounterData_StringValue struct {
	StringValue string `protobuf:"bytes,3,opt,name=string_value,json=stringValue,proto3,oneof"`
}

func (*CounterData_Int64Value) isCounterData_Value()  {}
func (*CounterData_DoubleValue) isCounterData_Value() {}
func (*CounterData_StringValue) isCounterData_Value() {}

func (m *CounterData) GetValue() isCounterData_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *CounterData) GetInt64Value() int64 {
	if x, ok := m.GetValue().(*CounterData_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (m *CounterData) GetDoubleValue() float64 {
	if x, ok := m.GetValue().(*CounterData_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *CounterData) GetStringValue() string {
	if x, ok := m.GetValue().(*CounterData_StringValue); ok {
		return x.StringValue
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CounterData) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CounterData_OneofMarshaler, _CounterData_OneofUnmarshaler, _CounterData_OneofSizer, []interface{}{
		(*CounterData_Int64Value)(nil),
		(*CounterData_DoubleValue)(nil),
		(*CounterData_StringValue)(nil),
	}
}

func _CounterData_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CounterData)
	// value
	switch x := m.Value.(type) {
	case *CounterData_Int64Value:
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Int64Value))
	case *CounterData_DoubleValue:
		b.EncodeVarint(2<<3 | proto.WireFixed64)
		b.EncodeFixed64(math.Float64bits(x.DoubleValue))
	case *CounterData_StringValue:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.StringValue)
	case nil:
	default:
		return fmt.Errorf("CounterData.Value has unexpected type %T", x)
	}
	return nil
}

func _CounterData_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CounterData)
	switch tag {
	case 1: // value.int64_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &CounterData_Int64Value{int64(x)}
		return true, err
	case 2: // value.double_value
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Value = &CounterData_DoubleValue{math.Float64frombits(x)}
		return true, err
	case 3: // value.string_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &CounterData_StringValue{x}
		return true, err
	default:
		return false, nil
	}
}

func _CounterData_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CounterData)
	// value
	switch x := m.Value.(type) {
	case *CounterData_Int64Value:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Int64Value))
	case *CounterData_DoubleValue:
		n += 1 // tag and wire
		n += 8
	case *CounterData_StringValue:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.StringValue)))
		n += len(x.StringValue)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Extrema messages are used for calculating
// Top-N/Bottom-N metrics.
type ExtremaData struct {
	// Types that are valid to be assigned to Extrema:
	//	*ExtremaData_IntExtremaData
	//	*ExtremaData_DoubleExtremaData
	Extrema              isExtremaData_Extrema `protobuf_oneof:"extrema"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExtremaData) Reset()         { *m = ExtremaData{} }
func (m *ExtremaData) String() string { return proto.CompactTextString(m) }
func (*ExtremaData) ProtoMessage()    {}
func (*ExtremaData) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{14}
}
func (m *ExtremaData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExtremaData.Unmarshal(m, b)
}
func (m *ExtremaData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExtremaData.Marshal(b, m, deterministic)
}
func (dst *ExtremaData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExtremaData.Merge(dst, src)
}
func (m *ExtremaData) XXX_Size() int {
	return xxx_messageInfo_ExtremaData.Size(m)
}
func (m *ExtremaData) XXX_DiscardUnknown() {
	xxx_messageInfo_ExtremaData.DiscardUnknown(m)
}

var xxx_messageInfo_ExtremaData proto.InternalMessageInfo

type isExtremaData_Extrema interface {
	isExtremaData_Extrema()
}

type ExtremaData_IntExtremaData struct {
	IntExtremaData *IntExtremaData `protobuf:"bytes,1,opt,name=int_extrema_data,json=intExtremaData,proto3,oneof"`
}
type ExtremaData_DoubleExtremaData struct {
	DoubleExtremaData *DoubleExtremaData `protobuf:"bytes,2,opt,name=double_extrema_data,json=doubleExtremaData,proto3,oneof"`
}

func (*ExtremaData_IntExtremaData) isExtremaData_Extrema()    {}
func (*ExtremaData_DoubleExtremaData) isExtremaData_Extrema() {}

func (m *ExtremaData) GetExtrema() isExtremaData_Extrema {
	if m != nil {
		return m.Extrema
	}
	return nil
}

func (m *ExtremaData) GetIntExtremaData() *IntExtremaData {
	if x, ok := m.GetExtrema().(*ExtremaData_IntExtremaData); ok {
		return x.IntExtremaData
	}
	return nil
}

func (m *ExtremaData) GetDoubleExtremaData() *DoubleExtremaData {
	if x, ok := m.GetExtrema().(*ExtremaData_DoubleExtremaData); ok {
		return x.DoubleExtremaData
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ExtremaData) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ExtremaData_OneofMarshaler, _ExtremaData_OneofUnmarshaler, _ExtremaData_OneofSizer, []interface{}{
		(*ExtremaData_IntExtremaData)(nil),
		(*ExtremaData_DoubleExtremaData)(nil),
	}
}

func _ExtremaData_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ExtremaData)
	// extrema
	switch x := m.Extrema.(type) {
	case *ExtremaData_IntExtremaData:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.IntExtremaData); err != nil {
			return err
		}
	case *ExtremaData_DoubleExtremaData:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DoubleExtremaData); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ExtremaData.Extrema has unexpected type %T", x)
	}
	return nil
}

func _ExtremaData_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ExtremaData)
	switch tag {
	case 1: // extrema.int_extrema_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(IntExtremaData)
		err := b.DecodeMessage(msg)
		m.Extrema = &ExtremaData_IntExtremaData{msg}
		return true, err
	case 2: // extrema.double_extrema_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DoubleExtremaData)
		err := b.DecodeMessage(msg)
		m.Extrema = &ExtremaData_DoubleExtremaData{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ExtremaData_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ExtremaData)
	// extrema
	switch x := m.Extrema.(type) {
	case *ExtremaData_IntExtremaData:
		s := proto.Size(x.IntExtremaData)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ExtremaData_DoubleExtremaData:
		s := proto.Size(x.DoubleExtremaData)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type IntExtremaData struct {
	IntValues            []int64  `protobuf:"varint,1,rep,packed,name=int_values,json=intValues,proto3" json:"int_values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IntExtremaData) Reset()         { *m = IntExtremaData{} }
func (m *IntExtremaData) String() string { return proto.CompactTextString(m) }
func (*IntExtremaData) ProtoMessage()    {}
func (*IntExtremaData) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{15}
}
func (m *IntExtremaData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IntExtremaData.Unmarshal(m, b)
}
func (m *IntExtremaData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IntExtremaData.Marshal(b, m, deterministic)
}
func (dst *IntExtremaData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntExtremaData.Merge(dst, src)
}
func (m *IntExtremaData) XXX_Size() int {
	return xxx_messageInfo_IntExtremaData.Size(m)
}
func (m *IntExtremaData) XXX_DiscardUnknown() {
	xxx_messageInfo_IntExtremaData.DiscardUnknown(m)
}

var xxx_messageInfo_IntExtremaData proto.InternalMessageInfo

func (m *IntExtremaData) GetIntValues() []int64 {
	if m != nil {
		return m.IntValues
	}
	return nil
}

type DoubleExtremaData struct {
	DoubleValues         []float64 `protobuf:"fixed64,2,rep,packed,name=double_values,json=doubleValues,proto3" json:"double_values,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *DoubleExtremaData) Reset()         { *m = DoubleExtremaData{} }
func (m *DoubleExtremaData) String() string { return proto.CompactTextString(m) }
func (*DoubleExtremaData) ProtoMessage()    {}
func (*DoubleExtremaData) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{16}
}
func (m *DoubleExtremaData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DoubleExtremaData.Unmarshal(m, b)
}
func (m *DoubleExtremaData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DoubleExtremaData.Marshal(b, m, deterministic)
}
func (dst *DoubleExtremaData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DoubleExtremaData.Merge(dst, src)
}
func (m *DoubleExtremaData) XXX_Size() int {
	return xxx_messageInfo_DoubleExtremaData.Size(m)
}
func (m *DoubleExtremaData) XXX_DiscardUnknown() {
	xxx_messageInfo_DoubleExtremaData.DiscardUnknown(m)
}

var xxx_messageInfo_DoubleExtremaData proto.InternalMessageInfo

func (m *DoubleExtremaData) GetDoubleValues() []float64 {
	if m != nil {
		return m.DoubleValues
	}
	return nil
}

// Data associated with a distribution metric.
// This is based off of the current DistributionData metric.
// This is not a stackdriver or dropwizard compatible
// style of distribution metric.
type DistributionData struct {
	// Types that are valid to be assigned to Distribution:
	//	*DistributionData_IntDistributionData
	//	*DistributionData_DoubleDistributionData
	Distribution         isDistributionData_Distribution `protobuf_oneof:"distribution"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *DistributionData) Reset()         { *m = DistributionData{} }
func (m *DistributionData) String() string { return proto.CompactTextString(m) }
func (*DistributionData) ProtoMessage()    {}
func (*DistributionData) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{17}
}
func (m *DistributionData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DistributionData.Unmarshal(m, b)
}
func (m *DistributionData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DistributionData.Marshal(b, m, deterministic)
}
func (dst *DistributionData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DistributionData.Merge(dst, src)
}
func (m *DistributionData) XXX_Size() int {
	return xxx_messageInfo_DistributionData.Size(m)
}
func (m *DistributionData) XXX_DiscardUnknown() {
	xxx_messageInfo_DistributionData.DiscardUnknown(m)
}

var xxx_messageInfo_DistributionData proto.InternalMessageInfo

type isDistributionData_Distribution interface {
	isDistributionData_Distribution()
}

type DistributionData_IntDistributionData struct {
	IntDistributionData *IntDistributionData `protobuf:"bytes,1,opt,name=int_distribution_data,json=intDistributionData,proto3,oneof"`
}
type DistributionData_DoubleDistributionData struct {
	DoubleDistributionData *DoubleDistributionData `protobuf:"bytes,2,opt,name=double_distribution_data,json=doubleDistributionData,proto3,oneof"`
}

func (*DistributionData_IntDistributionData) isDistributionData_Distribution()    {}
func (*DistributionData_DoubleDistributionData) isDistributionData_Distribution() {}

func (m *DistributionData) GetDistribution() isDistributionData_Distribution {
	if m != nil {
		return m.Distribution
	}
	return nil
}

func (m *DistributionData) GetIntDistributionData() *IntDistributionData {
	if x, ok := m.GetDistribution().(*DistributionData_IntDistributionData); ok {
		return x.IntDistributionData
	}
	return nil
}

func (m *DistributionData) GetDoubleDistributionData() *DoubleDistributionData {
	if x, ok := m.GetDistribution().(*DistributionData_DoubleDistributionData); ok {
		return x.DoubleDistributionData
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*DistributionData) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _DistributionData_OneofMarshaler, _DistributionData_OneofUnmarshaler, _DistributionData_OneofSizer, []interface{}{
		(*DistributionData_IntDistributionData)(nil),
		(*DistributionData_DoubleDistributionData)(nil),
	}
}

func _DistributionData_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*DistributionData)
	// distribution
	switch x := m.Distribution.(type) {
	case *DistributionData_IntDistributionData:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.IntDistributionData); err != nil {
			return err
		}
	case *DistributionData_DoubleDistributionData:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DoubleDistributionData); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("DistributionData.Distribution has unexpected type %T", x)
	}
	return nil
}

func _DistributionData_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*DistributionData)
	switch tag {
	case 1: // distribution.int_distribution_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(IntDistributionData)
		err := b.DecodeMessage(msg)
		m.Distribution = &DistributionData_IntDistributionData{msg}
		return true, err
	case 2: // distribution.double_distribution_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DoubleDistributionData)
		err := b.DecodeMessage(msg)
		m.Distribution = &DistributionData_DoubleDistributionData{msg}
		return true, err
	default:
		return false, nil
	}
}

func _DistributionData_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*DistributionData)
	// distribution
	switch x := m.Distribution.(type) {
	case *DistributionData_IntDistributionData:
		s := proto.Size(x.IntDistributionData)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *DistributionData_DoubleDistributionData:
		s := proto.Size(x.DoubleDistributionData)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type IntDistributionData struct {
	Count                int64    `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	Sum                  int64    `protobuf:"varint,2,opt,name=sum,proto3" json:"sum,omitempty"`
	Min                  int64    `protobuf:"varint,3,opt,name=min,proto3" json:"min,omitempty"`
	Max                  int64    `protobuf:"varint,4,opt,name=max,proto3" json:"max,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IntDistributionData) Reset()         { *m = IntDistributionData{} }
func (m *IntDistributionData) String() string { return proto.CompactTextString(m) }
func (*IntDistributionData) ProtoMessage()    {}
func (*IntDistributionData) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{18}
}
func (m *IntDistributionData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IntDistributionData.Unmarshal(m, b)
}
func (m *IntDistributionData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IntDistributionData.Marshal(b, m, deterministic)
}
func (dst *IntDistributionData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntDistributionData.Merge(dst, src)
}
func (m *IntDistributionData) XXX_Size() int {
	return xxx_messageInfo_IntDistributionData.Size(m)
}
func (m *IntDistributionData) XXX_DiscardUnknown() {
	xxx_messageInfo_IntDistributionData.DiscardUnknown(m)
}

var xxx_messageInfo_IntDistributionData proto.InternalMessageInfo

func (m *IntDistributionData) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *IntDistributionData) GetSum() int64 {
	if m != nil {
		return m.Sum
	}
	return 0
}

func (m *IntDistributionData) GetMin() int64 {
	if m != nil {
		return m.Min
	}
	return 0
}

func (m *IntDistributionData) GetMax() int64 {
	if m != nil {
		return m.Max
	}
	return 0
}

type DoubleDistributionData struct {
	Count                int64    `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	Sum                  float64  `protobuf:"fixed64,2,opt,name=sum,proto3" json:"sum,omitempty"`
	Min                  float64  `protobuf:"fixed64,3,opt,name=min,proto3" json:"min,omitempty"`
	Max                  float64  `protobuf:"fixed64,4,opt,name=max,proto3" json:"max,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DoubleDistributionData) Reset()         { *m = DoubleDistributionData{} }
func (m *DoubleDistributionData) String() string { return proto.CompactTextString(m) }
func (*DoubleDistributionData) ProtoMessage()    {}
func (*DoubleDistributionData) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{19}
}
func (m *DoubleDistributionData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DoubleDistributionData.Unmarshal(m, b)
}
func (m *DoubleDistributionData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DoubleDistributionData.Marshal(b, m, deterministic)
}
func (dst *DoubleDistributionData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DoubleDistributionData.Merge(dst, src)
}
func (m *DoubleDistributionData) XXX_Size() int {
	return xxx_messageInfo_DoubleDistributionData.Size(m)
}
func (m *DoubleDistributionData) XXX_DiscardUnknown() {
	xxx_messageInfo_DoubleDistributionData.DiscardUnknown(m)
}

var xxx_messageInfo_DoubleDistributionData proto.InternalMessageInfo

func (m *DoubleDistributionData) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *DoubleDistributionData) GetSum() float64 {
	if m != nil {
		return m.Sum
	}
	return 0
}

func (m *DoubleDistributionData) GetMin() float64 {
	if m != nil {
		return m.Min
	}
	return 0
}

func (m *DoubleDistributionData) GetMax() float64 {
	if m != nil {
		return m.Max
	}
	return 0
}

// General MonitoredState information which contains
// structured information which does not fit into a typical
// metric format. For example, a table of important files
// and metadata which an I/O source is reading.
// Note: Since MonitoredState is designed to be
// customizable, and allow engines to aggregate these
// metrics in custom ways.
// Engines can use custom aggregation functions for specific URNs
// by inspecting the column values.
// An SDK should always report its current state, that is all
// relevant MonitoredState for its PTransform at the current moment
// and this should be kept small.
// For example, an SDK can emit the oldest three files which
// have been waiting for data for over 1 hour.
// If an engine supports the URN with a custom aggregation then
// it can filter these and keep only the Top-3 rows based on
// how long the files have been waiting for data.
// Otherwise an engine can ignore the MonitoringTableData
// or union all the rows together into one large table and display
// them in a UI.
type MonitoringTableData struct {
	// The number of column names must match the
	// number of values in each MonitoringRow.
	ColumnNames          []string                             `protobuf:"bytes,1,rep,name=column_names,json=columnNames,proto3" json:"column_names,omitempty"`
	RowData              []*MonitoringTableData_MonitoringRow `protobuf:"bytes,2,rep,name=row_data,json=rowData,proto3" json:"row_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *MonitoringTableData) Reset()         { *m = MonitoringTableData{} }
func (m *MonitoringTableData) String() string { return proto.CompactTextString(m) }
func (*MonitoringTableData) ProtoMessage()    {}
func (*MonitoringTableData) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{20}
}
func (m *MonitoringTableData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MonitoringTableData.Unmarshal(m, b)
}
func (m *MonitoringTableData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MonitoringTableData.Marshal(b, m, deterministic)
}
func (dst *MonitoringTableData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MonitoringTableData.Merge(dst, src)
}
func (m *MonitoringTableData) XXX_Size() int {
	return xxx_messageInfo_MonitoringTableData.Size(m)
}
func (m *MonitoringTableData) XXX_DiscardUnknown() {
	xxx_messageInfo_MonitoringTableData.DiscardUnknown(m)
}

var xxx_messageInfo_MonitoringTableData proto.InternalMessageInfo

func (m *MonitoringTableData) GetColumnNames() []string {
	if m != nil {
		return m.ColumnNames
	}
	return nil
}

func (m *MonitoringTableData) GetRowData() []*MonitoringTableData_MonitoringRow {
	if m != nil {
		return m.RowData
	}
	return nil
}

type MonitoringTableData_MonitoringColumnValue struct {
	// Types that are valid to be assigned to Value:
	//	*MonitoringTableData_MonitoringColumnValue_Int64Value
	//	*MonitoringTableData_MonitoringColumnValue_DoubleValue
	//	*MonitoringTableData_MonitoringColumnValue_StringValue
	//	*MonitoringTableData_MonitoringColumnValue_Timestamp
	Value                isMonitoringTableData_MonitoringColumnValue_Value `protobuf_oneof:"value"`
	XXX_NoUnkeyedLiteral struct{}                                          `json:"-"`
	XXX_unrecognized     []byte                                            `json:"-"`
	XXX_sizecache        int32                                             `json:"-"`
}

func (m *MonitoringTableData_MonitoringColumnValue) Reset() {
	*m = MonitoringTableData_MonitoringColumnValue{}
}
func (m *MonitoringTableData_MonitoringColumnValue) String() string { return proto.CompactTextString(m) }
func (*MonitoringTableData_MonitoringColumnValue) ProtoMessage()    {}
func (*MonitoringTableData_MonitoringColumnValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{20, 0}
}
func (m *MonitoringTableData_MonitoringColumnValue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MonitoringTableData_MonitoringColumnValue.Unmarshal(m, b)
}
func (m *MonitoringTableData_MonitoringColumnValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MonitoringTableData_MonitoringColumnValue.Marshal(b, m, deterministic)
}
func (dst *MonitoringTableData_MonitoringColumnValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MonitoringTableData_MonitoringColumnValue.Merge(dst, src)
}
func (m *MonitoringTableData_MonitoringColumnValue) XXX_Size() int {
	return xxx_messageInfo_MonitoringTableData_MonitoringColumnValue.Size(m)
}
func (m *MonitoringTableData_MonitoringColumnValue) XXX_DiscardUnknown() {
	xxx_messageInfo_MonitoringTableData_MonitoringColumnValue.DiscardUnknown(m)
}

var xxx_messageInfo_MonitoringTableData_MonitoringColumnValue proto.InternalMessageInfo

type isMonitoringTableData_MonitoringColumnValue_Value interface {
	isMonitoringTableData_MonitoringColumnValue_Value()
}

type MonitoringTableData_MonitoringColumnValue_Int64Value struct {
	Int64Value int64 `protobuf:"varint,1,opt,name=int64_value,json=int64Value,proto3,oneof"`
}
type MonitoringTableData_MonitoringColumnValue_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,2,opt,name=double_value,json=doubleValue,proto3,oneof"`
}
type MonitoringTableData_MonitoringColumnValue_StringValue struct {
	StringValue string `protobuf:"bytes,3,opt,name=string_value,json=stringValue,proto3,oneof"`
}
type MonitoringTableData_MonitoringColumnValue_Timestamp struct {
	Timestamp *timestamp.Timestamp `protobuf:"bytes,4,opt,name=timestamp,proto3,oneof"`
}

func (*MonitoringTableData_MonitoringColumnValue_Int64Value) isMonitoringTableData_MonitoringColumnValue_Value() {
}
func (*MonitoringTableData_MonitoringColumnValue_DoubleValue) isMonitoringTableData_MonitoringColumnValue_Value() {
}
func (*MonitoringTableData_MonitoringColumnValue_StringValue) isMonitoringTableData_MonitoringColumnValue_Value() {
}
func (*MonitoringTableData_MonitoringColumnValue_Timestamp) isMonitoringTableData_MonitoringColumnValue_Value() {
}

func (m *MonitoringTableData_MonitoringColumnValue) GetValue() isMonitoringTableData_MonitoringColumnValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *MonitoringTableData_MonitoringColumnValue) GetInt64Value() int64 {
	if x, ok := m.GetValue().(*MonitoringTableData_MonitoringColumnValue_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (m *MonitoringTableData_MonitoringColumnValue) GetDoubleValue() float64 {
	if x, ok := m.GetValue().(*MonitoringTableData_MonitoringColumnValue_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *MonitoringTableData_MonitoringColumnValue) GetStringValue() string {
	if x, ok := m.GetValue().(*MonitoringTableData_MonitoringColumnValue_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (m *MonitoringTableData_MonitoringColumnValue) GetTimestamp() *timestamp.Timestamp {
	if x, ok := m.GetValue().(*MonitoringTableData_MonitoringColumnValue_Timestamp); ok {
		return x.Timestamp
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*MonitoringTableData_MonitoringColumnValue) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _MonitoringTableData_MonitoringColumnValue_OneofMarshaler, _MonitoringTableData_MonitoringColumnValue_OneofUnmarshaler, _MonitoringTableData_MonitoringColumnValue_OneofSizer, []interface{}{
		(*MonitoringTableData_MonitoringColumnValue_Int64Value)(nil),
		(*MonitoringTableData_MonitoringColumnValue_DoubleValue)(nil),
		(*MonitoringTableData_MonitoringColumnValue_StringValue)(nil),
		(*MonitoringTableData_MonitoringColumnValue_Timestamp)(nil),
	}
}

func _MonitoringTableData_MonitoringColumnValue_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*MonitoringTableData_MonitoringColumnValue)
	// value
	switch x := m.Value.(type) {
	case *MonitoringTableData_MonitoringColumnValue_Int64Value:
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Int64Value))
	case *MonitoringTableData_MonitoringColumnValue_DoubleValue:
		b.EncodeVarint(2<<3 | proto.WireFixed64)
		b.EncodeFixed64(math.Float64bits(x.DoubleValue))
	case *MonitoringTableData_MonitoringColumnValue_StringValue:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.StringValue)
	case *MonitoringTableData_MonitoringColumnValue_Timestamp:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Timestamp); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("MonitoringTableData_MonitoringColumnValue.Value has unexpected type %T", x)
	}
	return nil
}

func _MonitoringTableData_MonitoringColumnValue_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*MonitoringTableData_MonitoringColumnValue)
	switch tag {
	case 1: // value.int64_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &MonitoringTableData_MonitoringColumnValue_Int64Value{int64(x)}
		return true, err
	case 2: // value.double_value
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Value = &MonitoringTableData_MonitoringColumnValue_DoubleValue{math.Float64frombits(x)}
		return true, err
	case 3: // value.string_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &MonitoringTableData_MonitoringColumnValue_StringValue{x}
		return true, err
	case 4: // value.timestamp
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(timestamp.Timestamp)
		err := b.DecodeMessage(msg)
		m.Value = &MonitoringTableData_MonitoringColumnValue_Timestamp{msg}
		return true, err
	default:
		return false, nil
	}
}

func _MonitoringTableData_MonitoringColumnValue_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*MonitoringTableData_MonitoringColumnValue)
	// value
	switch x := m.Value.(type) {
	case *MonitoringTableData_MonitoringColumnValue_Int64Value:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Int64Value))
	case *MonitoringTableData_MonitoringColumnValue_DoubleValue:
		n += 1 // tag and wire
		n += 8
	case *MonitoringTableData_MonitoringColumnValue_StringValue:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.StringValue)))
		n += len(x.StringValue)
	case *MonitoringTableData_MonitoringColumnValue_Timestamp:
		s := proto.Size(x.Timestamp)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type MonitoringTableData_MonitoringRow struct {
	Values               []*MonitoringTableData_MonitoringColumnValue `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                     `json:"-"`
	XXX_unrecognized     []byte                                       `json:"-"`
	XXX_sizecache        int32                                        `json:"-"`
}

func (m *MonitoringTableData_MonitoringRow) Reset()         { *m = MonitoringTableData_MonitoringRow{} }
func (m *MonitoringTableData_MonitoringRow) String() string { return proto.CompactTextString(m) }
func (*MonitoringTableData_MonitoringRow) ProtoMessage()    {}
func (*MonitoringTableData_MonitoringRow) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{20, 1}
}
func (m *MonitoringTableData_MonitoringRow) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MonitoringTableData_MonitoringRow.Unmarshal(m, b)
}
func (m *MonitoringTableData_MonitoringRow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MonitoringTableData_MonitoringRow.Marshal(b, m, deterministic)
}
func (dst *MonitoringTableData_MonitoringRow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MonitoringTableData_MonitoringRow.Merge(dst, src)
}
func (m *MonitoringTableData_MonitoringRow) XXX_Size() int {
	return xxx_messageInfo_MonitoringTableData_MonitoringRow.Size(m)
}
func (m *MonitoringTableData_MonitoringRow) XXX_DiscardUnknown() {
	xxx_messageInfo_MonitoringTableData_MonitoringRow.DiscardUnknown(m)
}

var xxx_messageInfo_MonitoringTableData_MonitoringRow proto.InternalMessageInfo

func (m *MonitoringTableData_MonitoringRow) GetValues() []*MonitoringTableData_MonitoringColumnValue {
	if m != nil {
		return m.Values
	}
	return nil
}

// DEPRECATED
type Metrics struct {
	Ptransforms          map[string]*Metrics_PTransform `protobuf:"bytes,1,rep,name=ptransforms,proto3" json:"ptransforms,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *Metrics) Reset()         { *m = Metrics{} }
func (m *Metrics) String() string { return proto.CompactTextString(m) }
func (*Metrics) ProtoMessage()    {}
func (*Metrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{21}
}
func (m *Metrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics.Unmarshal(m, b)
}
func (m *Metrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics.Marshal(b, m, deterministic)
}
func (dst *Metrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics.Merge(dst, src)
}
func (m *Metrics) XXX_Size() int {
	return xxx_messageInfo_Metrics.Size(m)
}
func (m *Metrics) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics proto.InternalMessageInfo

func (m *Metrics) GetPtransforms() map[string]*Metrics_PTransform {
	if m != nil {
		return m.Ptransforms
	}
	return nil
}

// PTransform level metrics.
// These metrics are split into processed and active element groups for
// progress reporting purposes. This allows a Runner to see what is measured,
// what is estimated and what can be extrapolated to be able to accurately
// estimate the backlog of remaining work.
type Metrics_PTransform struct {
	// (Required): Metrics for processed elements.
	ProcessedElements *Metrics_PTransform_ProcessedElements `protobuf:"bytes,1,opt,name=processed_elements,json=processedElements,proto3" json:"processed_elements,omitempty"`
	// (Required): Metrics for active elements.
	ActiveElements *Metrics_PTransform_ActiveElements `protobuf:"bytes,2,opt,name=active_elements,json=activeElements,proto3" json:"active_elements,omitempty"`
	// (Optional): Map from local output name to its watermark.
	// The watermarks reported are tentative, to get a better sense of progress
	// while processing a bundle but before it is committed. At bundle commit
	// time, a Runner needs to also take into account the timers set to compute
	// the actual watermarks.
	Watermarks           map[string]int64 `protobuf:"bytes,3,rep,name=watermarks,proto3" json:"watermarks,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	User                 []*Metrics_User  `protobuf:"bytes,4,rep,name=user,proto3" json:"user,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Metrics_PTransform) Reset()         { *m = Metrics_PTransform{} }
func (m *Metrics_PTransform) String() string { return proto.CompactTextString(m) }
func (*Metrics_PTransform) ProtoMessage()    {}
func (*Metrics_PTransform) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{21, 0}
}
func (m *Metrics_PTransform) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_PTransform.Unmarshal(m, b)
}
func (m *Metrics_PTransform) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_PTransform.Marshal(b, m, deterministic)
}
func (dst *Metrics_PTransform) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_PTransform.Merge(dst, src)
}
func (m *Metrics_PTransform) XXX_Size() int {
	return xxx_messageInfo_Metrics_PTransform.Size(m)
}
func (m *Metrics_PTransform) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_PTransform.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_PTransform proto.InternalMessageInfo

func (m *Metrics_PTransform) GetProcessedElements() *Metrics_PTransform_ProcessedElements {
	if m != nil {
		return m.ProcessedElements
	}
	return nil
}

func (m *Metrics_PTransform) GetActiveElements() *Metrics_PTransform_ActiveElements {
	if m != nil {
		return m.ActiveElements
	}
	return nil
}

func (m *Metrics_PTransform) GetWatermarks() map[string]int64 {
	if m != nil {
		return m.Watermarks
	}
	return nil
}

func (m *Metrics_PTransform) GetUser() []*Metrics_User {
	if m != nil {
		return m.User
	}
	return nil
}

// Metrics that are measured for processed and active element groups.
type Metrics_PTransform_Measured struct {
	// (Optional) Map from local input name to number of elements processed
	// from this input.
	// If unset, assumed to be the sum of the outputs of all producers to
	// this transform (for ProcessedElements) and 0 (for ActiveElements).
	InputElementCounts map[string]int64 `protobuf:"bytes,1,rep,name=input_element_counts,json=inputElementCounts,proto3" json:"input_element_counts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// (Required) Map from local output name to number of elements produced
	// for this output.
	OutputElementCounts map[string]int64 `protobuf:"bytes,2,rep,name=output_element_counts,json=outputElementCounts,proto3" json:"output_element_counts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// (Optional) The total time spent so far in processing the elements in
	// this group, in seconds.
	TotalTimeSpent       float64  `protobuf:"fixed64,3,opt,name=total_time_spent,json=totalTimeSpent,proto3" json:"total_time_spent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Metrics_PTransform_Measured) Reset()         { *m = Metrics_PTransform_Measured{} }
func (m *Metrics_PTransform_Measured) String() string { return proto.CompactTextString(m) }
func (*Metrics_PTransform_Measured) ProtoMessage()    {}
func (*Metrics_PTransform_Measured) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{21, 0, 0}
}
func (m *Metrics_PTransform_Measured) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_PTransform_Measured.Unmarshal(m, b)
}
func (m *Metrics_PTransform_Measured) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_PTransform_Measured.Marshal(b, m, deterministic)
}
func (dst *Metrics_PTransform_Measured) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_PTransform_Measured.Merge(dst, src)
}
func (m *Metrics_PTransform_Measured) XXX_Size() int {
	return xxx_messageInfo_Metrics_PTransform_Measured.Size(m)
}
func (m *Metrics_PTransform_Measured) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_PTransform_Measured.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_PTransform_Measured proto.InternalMessageInfo

func (m *Metrics_PTransform_Measured) GetInputElementCounts() map[string]int64 {
	if m != nil {
		return m.InputElementCounts
	}
	return nil
}

func (m *Metrics_PTransform_Measured) GetOutputElementCounts() map[string]int64 {
	if m != nil {
		return m.OutputElementCounts
	}
	return nil
}

func (m *Metrics_PTransform_Measured) GetTotalTimeSpent() float64 {
	if m != nil {
		return m.TotalTimeSpent
	}
	return 0
}

// Metrics for fully processed elements.
type Metrics_PTransform_ProcessedElements struct {
	// (Required)
	Measured             *Metrics_PTransform_Measured `protobuf:"bytes,1,opt,name=measured,proto3" json:"measured,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *Metrics_PTransform_ProcessedElements) Reset()         { *m = Metrics_PTransform_ProcessedElements{} }
func (m *Metrics_PTransform_ProcessedElements) String() string { return proto.CompactTextString(m) }
func (*Metrics_PTransform_ProcessedElements) ProtoMessage()    {}
func (*Metrics_PTransform_ProcessedElements) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{21, 0, 1}
}
func (m *Metrics_PTransform_ProcessedElements) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_PTransform_ProcessedElements.Unmarshal(m, b)
}
func (m *Metrics_PTransform_ProcessedElements) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_PTransform_ProcessedElements.Marshal(b, m, deterministic)
}
func (dst *Metrics_PTransform_ProcessedElements) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_PTransform_ProcessedElements.Merge(dst, src)
}
func (m *Metrics_PTransform_ProcessedElements) XXX_Size() int {
	return xxx_messageInfo_Metrics_PTransform_ProcessedElements.Size(m)
}
func (m *Metrics_PTransform_ProcessedElements) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_PTransform_ProcessedElements.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_PTransform_ProcessedElements proto.InternalMessageInfo

func (m *Metrics_PTransform_ProcessedElements) GetMeasured() *Metrics_PTransform_Measured {
	if m != nil {
		return m.Measured
	}
	return nil
}

// Metrics for active elements.
// An element is considered active if the SDK has started but not finished
// processing it yet.
type Metrics_PTransform_ActiveElements struct {
	// (Required)
	Measured *Metrics_PTransform_Measured `protobuf:"bytes,1,opt,name=measured,proto3" json:"measured,omitempty"`
	// (Optional) Sum of estimated fraction of known work remaining for all
	// active elements, as reported by this transform.
	// If not reported, a Runner could extrapolate this from the processed
	// elements.
	// TODO: Handle the case when known work is infinite.
	FractionRemaining float64 `protobuf:"fixed64,2,opt,name=fraction_remaining,json=fractionRemaining,proto3" json:"fraction_remaining,omitempty"`
	// (Optional) Map from local output name to sum of estimated number
	// of elements remaining for this output from all active elements,
	// as reported by this transform.
	// If not reported, a Runner could extrapolate this from the processed
	// elements.
	OutputElementsRemaining map[string]int64 `protobuf:"bytes,3,rep,name=output_elements_remaining,json=outputElementsRemaining,proto3" json:"output_elements_remaining,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral    struct{}         `json:"-"`
	XXX_unrecognized        []byte           `json:"-"`
	XXX_sizecache           int32            `json:"-"`
}

func (m *Metrics_PTransform_ActiveElements) Reset()         { *m = Metrics_PTransform_ActiveElements{} }
func (m *Metrics_PTransform_ActiveElements) String() string { return proto.CompactTextString(m) }
func (*Metrics_PTransform_ActiveElements) ProtoMessage()    {}
func (*Metrics_PTransform_ActiveElements) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{21, 0, 2}
}
func (m *Metrics_PTransform_ActiveElements) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_PTransform_ActiveElements.Unmarshal(m, b)
}
func (m *Metrics_PTransform_ActiveElements) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_PTransform_ActiveElements.Marshal(b, m, deterministic)
}
func (dst *Metrics_PTransform_ActiveElements) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_PTransform_ActiveElements.Merge(dst, src)
}
func (m *Metrics_PTransform_ActiveElements) XXX_Size() int {
	return xxx_messageInfo_Metrics_PTransform_ActiveElements.Size(m)
}
func (m *Metrics_PTransform_ActiveElements) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_PTransform_ActiveElements.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_PTransform_ActiveElements proto.InternalMessageInfo

func (m *Metrics_PTransform_ActiveElements) GetMeasured() *Metrics_PTransform_Measured {
	if m != nil {
		return m.Measured
	}
	return nil
}

func (m *Metrics_PTransform_ActiveElements) GetFractionRemaining() float64 {
	if m != nil {
		return m.FractionRemaining
	}
	return 0
}

func (m *Metrics_PTransform_ActiveElements) GetOutputElementsRemaining() map[string]int64 {
	if m != nil {
		return m.OutputElementsRemaining
	}
	return nil
}

// User defined metrics
type Metrics_User struct {
	// (Required) The identifier for this metric.
	MetricName *Metrics_User_MetricName `protobuf:"bytes,1,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
	// (Required) The data for this metric.
	//
	// Types that are valid to be assigned to Data:
	//	*Metrics_User_CounterData_
	//	*Metrics_User_DistributionData_
	//	*Metrics_User_GaugeData_
	Data                 isMetrics_User_Data `protobuf_oneof:"data"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Metrics_User) Reset()         { *m = Metrics_User{} }
func (m *Metrics_User) String() string { return proto.CompactTextString(m) }
func (*Metrics_User) ProtoMessage()    {}
func (*Metrics_User) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{21, 1}
}
func (m *Metrics_User) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User.Unmarshal(m, b)
}
func (m *Metrics_User) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User.Marshal(b, m, deterministic)
}
func (dst *Metrics_User) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User.Merge(dst, src)
}
func (m *Metrics_User) XXX_Size() int {
	return xxx_messageInfo_Metrics_User.Size(m)
}
func (m *Metrics_User) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User proto.InternalMessageInfo

type isMetrics_User_Data interface {
	isMetrics_User_Data()
}

type Metrics_User_CounterData_ struct {
	CounterData *Metrics_User_CounterData `protobuf:"bytes,1001,opt,name=counter_data,json=counterData,proto3,oneof"`
}
type Metrics_User_DistributionData_ struct {
	DistributionData *Metrics_User_DistributionData `protobuf:"bytes,1002,opt,name=distribution_data,json=distributionData,proto3,oneof"`
}
type Metrics_User_GaugeData_ struct {
	GaugeData *Metrics_User_GaugeData `protobuf:"bytes,1003,opt,name=gauge_data,json=gaugeData,proto3,oneof"`
}

func (*Metrics_User_CounterData_) isMetrics_User_Data()      {}
func (*Metrics_User_DistributionData_) isMetrics_User_Data() {}
func (*Metrics_User_GaugeData_) isMetrics_User_Data()        {}

func (m *Metrics_User) GetData() isMetrics_User_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Metrics_User) GetMetricName() *Metrics_User_MetricName {
	if m != nil {
		return m.MetricName
	}
	return nil
}

func (m *Metrics_User) GetCounterData() *Metrics_User_CounterData {
	if x, ok := m.GetData().(*Metrics_User_CounterData_); ok {
		return x.CounterData
	}
	return nil
}

func (m *Metrics_User) GetDistributionData() *Metrics_User_DistributionData {
	if x, ok := m.GetData().(*Metrics_User_DistributionData_); ok {
		return x.DistributionData
	}
	return nil
}

func (m *Metrics_User) GetGaugeData() *Metrics_User_GaugeData {
	if x, ok := m.GetData().(*Metrics_User_GaugeData_); ok {
		return x.GaugeData
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Metrics_User) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Metrics_User_OneofMarshaler, _Metrics_User_OneofUnmarshaler, _Metrics_User_OneofSizer, []interface{}{
		(*Metrics_User_CounterData_)(nil),
		(*Metrics_User_DistributionData_)(nil),
		(*Metrics_User_GaugeData_)(nil),
	}
}

func _Metrics_User_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Metrics_User)
	// data
	switch x := m.Data.(type) {
	case *Metrics_User_CounterData_:
		b.EncodeVarint(1001<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CounterData); err != nil {
			return err
		}
	case *Metrics_User_DistributionData_:
		b.EncodeVarint(1002<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DistributionData); err != nil {
			return err
		}
	case *Metrics_User_GaugeData_:
		b.EncodeVarint(1003<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GaugeData); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Metrics_User.Data has unexpected type %T", x)
	}
	return nil
}

func _Metrics_User_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Metrics_User)
	switch tag {
	case 1001: // data.counter_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Metrics_User_CounterData)
		err := b.DecodeMessage(msg)
		m.Data = &Metrics_User_CounterData_{msg}
		return true, err
	case 1002: // data.distribution_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Metrics_User_DistributionData)
		err := b.DecodeMessage(msg)
		m.Data = &Metrics_User_DistributionData_{msg}
		return true, err
	case 1003: // data.gauge_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Metrics_User_GaugeData)
		err := b.DecodeMessage(msg)
		m.Data = &Metrics_User_GaugeData_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Metrics_User_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Metrics_User)
	// data
	switch x := m.Data.(type) {
	case *Metrics_User_CounterData_:
		s := proto.Size(x.CounterData)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Metrics_User_DistributionData_:
		s := proto.Size(x.DistributionData)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Metrics_User_GaugeData_:
		s := proto.Size(x.GaugeData)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A key for identifying a metric at the most granular level.
type Metrics_User_MetricName struct {
	// (Required): The namespace of this metric.
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// (Required): The name of this metric.
	Name                 string   `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Metrics_User_MetricName) Reset()         { *m = Metrics_User_MetricName{} }
func (m *Metrics_User_MetricName) String() string { return proto.CompactTextString(m) }
func (*Metrics_User_MetricName) ProtoMessage()    {}
func (*Metrics_User_MetricName) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{21, 1, 0}
}
func (m *Metrics_User_MetricName) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User_MetricName.Unmarshal(m, b)
}
func (m *Metrics_User_MetricName) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User_MetricName.Marshal(b, m, deterministic)
}
func (dst *Metrics_User_MetricName) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User_MetricName.Merge(dst, src)
}
func (m *Metrics_User_MetricName) XXX_Size() int {
	return xxx_messageInfo_Metrics_User_MetricName.Size(m)
}
func (m *Metrics_User_MetricName) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User_MetricName.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User_MetricName proto.InternalMessageInfo

func (m *Metrics_User_MetricName) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *Metrics_User_MetricName) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Data associated with a counter metric.
type Metrics_User_CounterData struct {
	Value                int64    `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Metrics_User_CounterData) Reset()         { *m = Metrics_User_CounterData{} }
func (m *Metrics_User_CounterData) String() string { return proto.CompactTextString(m) }
func (*Metrics_User_CounterData) ProtoMessage()    {}
func (*Metrics_User_CounterData) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{21, 1, 1}
}
func (m *Metrics_User_CounterData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User_CounterData.Unmarshal(m, b)
}
func (m *Metrics_User_CounterData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User_CounterData.Marshal(b, m, deterministic)
}
func (dst *Metrics_User_CounterData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User_CounterData.Merge(dst, src)
}
func (m *Metrics_User_CounterData) XXX_Size() int {
	return xxx_messageInfo_Metrics_User_CounterData.Size(m)
}
func (m *Metrics_User_CounterData) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User_CounterData.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User_CounterData proto.InternalMessageInfo

func (m *Metrics_User_CounterData) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

// Data associated with a distribution metric.
type Metrics_User_DistributionData struct {
	Count                int64    `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	Sum                  int64    `protobuf:"varint,2,opt,name=sum,proto3" json:"sum,omitempty"`
	Min                  int64    `protobuf:"varint,3,opt,name=min,proto3" json:"min,omitempty"`
	Max                  int64    `protobuf:"varint,4,opt,name=max,proto3" json:"max,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Metrics_User_DistributionData) Reset()         { *m = Metrics_User_DistributionData{} }
func (m *Metrics_User_DistributionData) String() string { return proto.CompactTextString(m) }
func (*Metrics_User_DistributionData) ProtoMessage()    {}
func (*Metrics_User_DistributionData) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{21, 1, 2}
}
func (m *Metrics_User_DistributionData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User_DistributionData.Unmarshal(m, b)
}
func (m *Metrics_User_DistributionData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User_DistributionData.Marshal(b, m, deterministic)
}
func (dst *Metrics_User_DistributionData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User_DistributionData.Merge(dst, src)
}
func (m *Metrics_User_DistributionData) XXX_Size() int {
	return xxx_messageInfo_Metrics_User_DistributionData.Size(m)
}
func (m *Metrics_User_DistributionData) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User_DistributionData.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User_DistributionData proto.InternalMessageInfo

func (m *Metrics_User_DistributionData) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *Metrics_User_DistributionData) GetSum() int64 {
	if m != nil {
		return m.Sum
	}
	return 0
}

func (m *Metrics_User_DistributionData) GetMin() int64 {
	if m != nil {
		return m.Min
	}
	return 0
}

func (m *Metrics_User_DistributionData) GetMax() int64 {
	if m != nil {
		return m.Max
	}
	return 0
}

// Data associated with a Gauge metric.
type Metrics_User_GaugeData struct {
	Value                int64                `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	Timestamp            *timestamp.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Metrics_User_GaugeData) Reset()         { *m = Metrics_User_GaugeData{} }
func (m *Metrics_User_GaugeData) String() string { return proto.CompactTextString(m) }
func (*Metrics_User_GaugeData) ProtoMessage()    {}
func (*Metrics_User_GaugeData) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{21, 1, 3}
}
func (m *Metrics_User_GaugeData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User_GaugeData.Unmarshal(m, b)
}
func (m *Metrics_User_GaugeData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User_GaugeData.Marshal(b, m, deterministic)
}
func (dst *Metrics_User_GaugeData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User_GaugeData.Merge(dst, src)
}
func (m *Metrics_User_GaugeData) XXX_Size() int {
	return xxx_messageInfo_Metrics_User_GaugeData.Size(m)
}
func (m *Metrics_User_GaugeData) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User_GaugeData.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User_GaugeData proto.InternalMessageInfo

func (m *Metrics_User_GaugeData) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

func (m *Metrics_User_GaugeData) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

type ProcessBundleProgressResponse struct {
	// (Required)
	Metrics *Metrics `protobuf:"bytes,1,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// (Optional) Specifies that the bundle has been split since the last
	// ProcessBundleProgressResponse was sent.
	Split                *BundleSplit `protobuf:"bytes,2,opt,name=split,proto3" json:"split,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ProcessBundleProgressResponse) Reset()         { *m = ProcessBundleProgressResponse{} }
func (m *ProcessBundleProgressResponse) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleProgressResponse) ProtoMessage()    {}
func (*ProcessBundleProgressResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{22}
}
func (m *ProcessBundleProgressResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleProgressResponse.Unmarshal(m, b)
}
func (m *ProcessBundleProgressResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleProgressResponse.Marshal(b, m, deterministic)
}
func (dst *ProcessBundleProgressResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleProgressResponse.Merge(dst, src)
}
func (m *ProcessBundleProgressResponse) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleProgressResponse.Size(m)
}
func (m *ProcessBundleProgressResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleProgressResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleProgressResponse proto.InternalMessageInfo

func (m *ProcessBundleProgressResponse) GetMetrics() *Metrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *ProcessBundleProgressResponse) GetSplit() *BundleSplit {
	if m != nil {
		return m.Split
	}
	return nil
}

type ProcessBundleSplitRequest struct {
	// (Required) A reference to an active process bundle request with the given
	// instruction id.
	InstructionReference string `protobuf:"bytes,1,opt,name=instruction_reference,json=instructionReference,proto3" json:"instruction_reference,omitempty"`
	// Specifies that the runner would like the bundle to split itself using
	// BundleSplit, and give up some of the work that the bundle hasn't started
	// doing yet, so that it can be done in a separate bundle (perhaps in
	// parallel with the current bundle).
	//
	// The value is the fraction of unstarted work to keep. E.g. 0 means give up
	// as much as possible of unstarted work (e.g. checkpoint), 0.5 means give
	// up about half of the unstarted work, etc.
	// This is a hint and the value is approximate.
	//
	// The value is relative to the current scope of work of the bundle.
	FractionOfRemainder  *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=fraction_of_remainder,json=fractionOfRemainder,proto3" json:"fraction_of_remainder,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ProcessBundleSplitRequest) Reset()         { *m = ProcessBundleSplitRequest{} }
func (m *ProcessBundleSplitRequest) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleSplitRequest) ProtoMessage()    {}
func (*ProcessBundleSplitRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{23}
}
func (m *ProcessBundleSplitRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleSplitRequest.Unmarshal(m, b)
}
func (m *ProcessBundleSplitRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleSplitRequest.Marshal(b, m, deterministic)
}
func (dst *ProcessBundleSplitRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleSplitRequest.Merge(dst, src)
}
func (m *ProcessBundleSplitRequest) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleSplitRequest.Size(m)
}
func (m *ProcessBundleSplitRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleSplitRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleSplitRequest proto.InternalMessageInfo

func (m *ProcessBundleSplitRequest) GetInstructionReference() string {
	if m != nil {
		return m.InstructionReference
	}
	return ""
}

func (m *ProcessBundleSplitRequest) GetFractionOfRemainder() *wrappers.DoubleValue {
	if m != nil {
		return m.FractionOfRemainder
	}
	return nil
}

type ProcessBundleSplitResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleSplitResponse) Reset()         { *m = ProcessBundleSplitResponse{} }
func (m *ProcessBundleSplitResponse) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleSplitResponse) ProtoMessage()    {}
func (*ProcessBundleSplitResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{24}
}
func (m *ProcessBundleSplitResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleSplitResponse.Unmarshal(m, b)
}
func (m *ProcessBundleSplitResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleSplitResponse.Marshal(b, m, deterministic)
}
func (dst *ProcessBundleSplitResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleSplitResponse.Merge(dst, src)
}
func (m *ProcessBundleSplitResponse) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleSplitResponse.Size(m)
}
func (m *ProcessBundleSplitResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleSplitResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleSplitResponse proto.InternalMessageInfo

// Messages used to represent logical byte streams.
// Stable
type Elements struct {
	// (Required) A list containing parts of logical byte streams.
	Data                 []*Elements_Data `protobuf:"bytes,1,rep,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Elements) Reset()         { *m = Elements{} }
func (m *Elements) String() string { return proto.CompactTextString(m) }
func (*Elements) ProtoMessage()    {}
func (*Elements) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{25}
}
func (m *Elements) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Elements.Unmarshal(m, b)
}
func (m *Elements) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Elements.Marshal(b, m, deterministic)
}
func (dst *Elements) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Elements.Merge(dst, src)
}
func (m *Elements) XXX_Size() int {
	return xxx_messageInfo_Elements.Size(m)
}
func (m *Elements) XXX_DiscardUnknown() {
	xxx_messageInfo_Elements.DiscardUnknown(m)
}

var xxx_messageInfo_Elements proto.InternalMessageInfo

func (m *Elements) GetData() []*Elements_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

// Represents multiple encoded elements in nested context for a given named
// instruction and target.
type Elements_Data struct {
	// (Required) A reference to an active instruction request with the given
	// instruction id.
	InstructionReference string `protobuf:"bytes,1,opt,name=instruction_reference,json=instructionReference,proto3" json:"instruction_reference,omitempty"`
	// (Required) A definition representing a consumer or producer of this data.
	// If received by a harness, this represents the consumer within that
	// harness that should consume these bytes. If sent by a harness, this
	// represents the producer of these bytes.
	//
	// Note that a single element may span multiple Data messages.
	//
	// Note that a sending/receiving pair should share the same target
	// identifier.
	Target *Target `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
	// (Optional) Represents a part of a logical byte stream. Elements within
	// the logical byte stream are encoded in the nested context and
	// concatenated together.
	//
	// An empty data block represents the end of stream for the given
	// instruction and target.
	Data                 []byte   `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Elements_Data) Reset()         { *m = Elements_Data{} }
func (m *Elements_Data) String() string { return proto.CompactTextString(m) }
func (*Elements_Data) ProtoMessage()    {}
func (*Elements_Data) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{25, 0}
}
func (m *Elements_Data) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Elements_Data.Unmarshal(m, b)
}
func (m *Elements_Data) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Elements_Data.Marshal(b, m, deterministic)
}
func (dst *Elements_Data) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Elements_Data.Merge(dst, src)
}
func (m *Elements_Data) XXX_Size() int {
	return xxx_messageInfo_Elements_Data.Size(m)
}
func (m *Elements_Data) XXX_DiscardUnknown() {
	xxx_messageInfo_Elements_Data.DiscardUnknown(m)
}

var xxx_messageInfo_Elements_Data proto.InternalMessageInfo

func (m *Elements_Data) GetInstructionReference() string {
	if m != nil {
		return m.InstructionReference
	}
	return ""
}

func (m *Elements_Data) GetTarget() *Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *Elements_Data) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type StateRequest struct {
	// (Required) An unique identifier provided by the SDK which represents this
	// requests execution. The StateResponse corresponding with this request
	// will have the matching id.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// (Required) The associated instruction id of the work that is currently
	// being processed. This allows for the runner to associate any modifications
	// to state to be committed with the appropriate work execution.
	InstructionReference string `protobuf:"bytes,2,opt,name=instruction_reference,json=instructionReference,proto3" json:"instruction_reference,omitempty"`
	// (Required) The state key this request is for.
	StateKey *StateKey `protobuf:"bytes,3,opt,name=state_key,json=stateKey,proto3" json:"state_key,omitempty"`
	// (Required) The action to take on this request.
	//
	// Types that are valid to be assigned to Request:
	//	*StateRequest_Get
	//	*StateRequest_Append
	//	*StateRequest_Clear
	Request              isStateRequest_Request `protobuf_oneof:"request"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *StateRequest) Reset()         { *m = StateRequest{} }
func (m *StateRequest) String() string { return proto.CompactTextString(m) }
func (*StateRequest) ProtoMessage()    {}
func (*StateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{26}
}
func (m *StateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateRequest.Unmarshal(m, b)
}
func (m *StateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateRequest.Marshal(b, m, deterministic)
}
func (dst *StateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateRequest.Merge(dst, src)
}
func (m *StateRequest) XXX_Size() int {
	return xxx_messageInfo_StateRequest.Size(m)
}
func (m *StateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateRequest proto.InternalMessageInfo

type isStateRequest_Request interface {
	isStateRequest_Request()
}

type StateRequest_Get struct {
	Get *StateGetRequest `protobuf:"bytes,1000,opt,name=get,proto3,oneof"`
}
type StateRequest_Append struct {
	Append *StateAppendRequest `protobuf:"bytes,1001,opt,name=append,proto3,oneof"`
}
type StateRequest_Clear struct {
	Clear *StateClearRequest `protobuf:"bytes,1002,opt,name=clear,proto3,oneof"`
}

func (*StateRequest_Get) isStateRequest_Request()    {}
func (*StateRequest_Append) isStateRequest_Request() {}
func (*StateRequest_Clear) isStateRequest_Request()  {}

func (m *StateRequest) GetRequest() isStateRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *StateRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *StateRequest) GetInstructionReference() string {
	if m != nil {
		return m.InstructionReference
	}
	return ""
}

func (m *StateRequest) GetStateKey() *StateKey {
	if m != nil {
		return m.StateKey
	}
	return nil
}

func (m *StateRequest) GetGet() *StateGetRequest {
	if x, ok := m.GetRequest().(*StateRequest_Get); ok {
		return x.Get
	}
	return nil
}

func (m *StateRequest) GetAppend() *StateAppendRequest {
	if x, ok := m.GetRequest().(*StateRequest_Append); ok {
		return x.Append
	}
	return nil
}

func (m *StateRequest) GetClear() *StateClearRequest {
	if x, ok := m.GetRequest().(*StateRequest_Clear); ok {
		return x.Clear
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StateRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StateRequest_OneofMarshaler, _StateRequest_OneofUnmarshaler, _StateRequest_OneofSizer, []interface{}{
		(*StateRequest_Get)(nil),
		(*StateRequest_Append)(nil),
		(*StateRequest_Clear)(nil),
	}
}

func _StateRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StateRequest)
	// request
	switch x := m.Request.(type) {
	case *StateRequest_Get:
		b.EncodeVarint(1000<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Get); err != nil {
			return err
		}
	case *StateRequest_Append:
		b.EncodeVarint(1001<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Append); err != nil {
			return err
		}
	case *StateRequest_Clear:
		b.EncodeVarint(1002<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Clear); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StateRequest.Request has unexpected type %T", x)
	}
	return nil
}

func _StateRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StateRequest)
	switch tag {
	case 1000: // request.get
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateGetRequest)
		err := b.DecodeMessage(msg)
		m.Request = &StateRequest_Get{msg}
		return true, err
	case 1001: // request.append
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateAppendRequest)
		err := b.DecodeMessage(msg)
		m.Request = &StateRequest_Append{msg}
		return true, err
	case 1002: // request.clear
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateClearRequest)
		err := b.DecodeMessage(msg)
		m.Request = &StateRequest_Clear{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StateRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StateRequest)
	// request
	switch x := m.Request.(type) {
	case *StateRequest_Get:
		s := proto.Size(x.Get)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateRequest_Append:
		s := proto.Size(x.Append)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateRequest_Clear:
		s := proto.Size(x.Clear)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type StateResponse struct {
	// (Required) A reference provided by the SDK which represents a requests
	// execution. The StateResponse must have the matching id when responding
	// to the SDK.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// (Optional) If this is specified, then the state request has failed.
	// A human readable string representing the reason as to why the request
	// failed.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// (Optional) If this is specified, then the result of this state request
	// can be cached using the supplied token.
	CacheToken []byte `protobuf:"bytes,3,opt,name=cache_token,json=cacheToken,proto3" json:"cache_token,omitempty"`
	// A corresponding response matching the request will be populated.
	//
	// Types that are valid to be assigned to Response:
	//	*StateResponse_Get
	//	*StateResponse_Append
	//	*StateResponse_Clear
	Response             isStateResponse_Response `protobuf_oneof:"response"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *StateResponse) Reset()         { *m = StateResponse{} }
func (m *StateResponse) String() string { return proto.CompactTextString(m) }
func (*StateResponse) ProtoMessage()    {}
func (*StateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{27}
}
func (m *StateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateResponse.Unmarshal(m, b)
}
func (m *StateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateResponse.Marshal(b, m, deterministic)
}
func (dst *StateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateResponse.Merge(dst, src)
}
func (m *StateResponse) XXX_Size() int {
	return xxx_messageInfo_StateResponse.Size(m)
}
func (m *StateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateResponse proto.InternalMessageInfo

type isStateResponse_Response interface {
	isStateResponse_Response()
}

type StateResponse_Get struct {
	Get *StateGetResponse `protobuf:"bytes,1000,opt,name=get,proto3,oneof"`
}
type StateResponse_Append struct {
	Append *StateAppendResponse `protobuf:"bytes,1001,opt,name=append,proto3,oneof"`
}
type StateResponse_Clear struct {
	Clear *StateClearResponse `protobuf:"bytes,1002,opt,name=clear,proto3,oneof"`
}

func (*StateResponse_Get) isStateResponse_Response()    {}
func (*StateResponse_Append) isStateResponse_Response() {}
func (*StateResponse_Clear) isStateResponse_Response()  {}

func (m *StateResponse) GetResponse() isStateResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *StateResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *StateResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *StateResponse) GetCacheToken() []byte {
	if m != nil {
		return m.CacheToken
	}
	return nil
}

func (m *StateResponse) GetGet() *StateGetResponse {
	if x, ok := m.GetResponse().(*StateResponse_Get); ok {
		return x.Get
	}
	return nil
}

func (m *StateResponse) GetAppend() *StateAppendResponse {
	if x, ok := m.GetResponse().(*StateResponse_Append); ok {
		return x.Append
	}
	return nil
}

func (m *StateResponse) GetClear() *StateClearResponse {
	if x, ok := m.GetResponse().(*StateResponse_Clear); ok {
		return x.Clear
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StateResponse) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StateResponse_OneofMarshaler, _StateResponse_OneofUnmarshaler, _StateResponse_OneofSizer, []interface{}{
		(*StateResponse_Get)(nil),
		(*StateResponse_Append)(nil),
		(*StateResponse_Clear)(nil),
	}
}

func _StateResponse_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StateResponse)
	// response
	switch x := m.Response.(type) {
	case *StateResponse_Get:
		b.EncodeVarint(1000<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Get); err != nil {
			return err
		}
	case *StateResponse_Append:
		b.EncodeVarint(1001<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Append); err != nil {
			return err
		}
	case *StateResponse_Clear:
		b.EncodeVarint(1002<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Clear); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StateResponse.Response has unexpected type %T", x)
	}
	return nil
}

func _StateResponse_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StateResponse)
	switch tag {
	case 1000: // response.get
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateGetResponse)
		err := b.DecodeMessage(msg)
		m.Response = &StateResponse_Get{msg}
		return true, err
	case 1001: // response.append
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateAppendResponse)
		err := b.DecodeMessage(msg)
		m.Response = &StateResponse_Append{msg}
		return true, err
	case 1002: // response.clear
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateClearResponse)
		err := b.DecodeMessage(msg)
		m.Response = &StateResponse_Clear{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StateResponse_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StateResponse)
	// response
	switch x := m.Response.(type) {
	case *StateResponse_Get:
		s := proto.Size(x.Get)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateResponse_Append:
		s := proto.Size(x.Append)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateResponse_Clear:
		s := proto.Size(x.Clear)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type StateKey struct {
	// (Required) One of the following state keys must be set.
	//
	// Types that are valid to be assigned to Type:
	//	*StateKey_Runner_
	//	*StateKey_MultimapSideInput_
	//	*StateKey_BagUserState_
	Type                 isStateKey_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *StateKey) Reset()         { *m = StateKey{} }
func (m *StateKey) String() string { return proto.CompactTextString(m) }
func (*StateKey) ProtoMessage()    {}
func (*StateKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{28}
}
func (m *StateKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey.Unmarshal(m, b)
}
func (m *StateKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey.Marshal(b, m, deterministic)
}
func (dst *StateKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey.Merge(dst, src)
}
func (m *StateKey) XXX_Size() int {
	return xxx_messageInfo_StateKey.Size(m)
}
func (m *StateKey) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey proto.InternalMessageInfo

type isStateKey_Type interface {
	isStateKey_Type()
}

type StateKey_Runner_ struct {
	Runner *StateKey_Runner `protobuf:"bytes,1,opt,name=runner,proto3,oneof"`
}
type StateKey_MultimapSideInput_ struct {
	MultimapSideInput *StateKey_MultimapSideInput `protobuf:"bytes,2,opt,name=multimap_side_input,json=multimapSideInput,proto3,oneof"`
}
type StateKey_BagUserState_ struct {
	BagUserState *StateKey_BagUserState `protobuf:"bytes,3,opt,name=bag_user_state,json=bagUserState,proto3,oneof"`
}

func (*StateKey_Runner_) isStateKey_Type()            {}
func (*StateKey_MultimapSideInput_) isStateKey_Type() {}
func (*StateKey_BagUserState_) isStateKey_Type()      {}

func (m *StateKey) GetType() isStateKey_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *StateKey) GetRunner() *StateKey_Runner {
	if x, ok := m.GetType().(*StateKey_Runner_); ok {
		return x.Runner
	}
	return nil
}

func (m *StateKey) GetMultimapSideInput() *StateKey_MultimapSideInput {
	if x, ok := m.GetType().(*StateKey_MultimapSideInput_); ok {
		return x.MultimapSideInput
	}
	return nil
}

func (m *StateKey) GetBagUserState() *StateKey_BagUserState {
	if x, ok := m.GetType().(*StateKey_BagUserState_); ok {
		return x.BagUserState
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StateKey) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StateKey_OneofMarshaler, _StateKey_OneofUnmarshaler, _StateKey_OneofSizer, []interface{}{
		(*StateKey_Runner_)(nil),
		(*StateKey_MultimapSideInput_)(nil),
		(*StateKey_BagUserState_)(nil),
	}
}

func _StateKey_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StateKey)
	// type
	switch x := m.Type.(type) {
	case *StateKey_Runner_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Runner); err != nil {
			return err
		}
	case *StateKey_MultimapSideInput_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MultimapSideInput); err != nil {
			return err
		}
	case *StateKey_BagUserState_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BagUserState); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StateKey.Type has unexpected type %T", x)
	}
	return nil
}

func _StateKey_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StateKey)
	switch tag {
	case 1: // type.runner
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateKey_Runner)
		err := b.DecodeMessage(msg)
		m.Type = &StateKey_Runner_{msg}
		return true, err
	case 2: // type.multimap_side_input
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateKey_MultimapSideInput)
		err := b.DecodeMessage(msg)
		m.Type = &StateKey_MultimapSideInput_{msg}
		return true, err
	case 3: // type.bag_user_state
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateKey_BagUserState)
		err := b.DecodeMessage(msg)
		m.Type = &StateKey_BagUserState_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StateKey_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StateKey)
	// type
	switch x := m.Type.(type) {
	case *StateKey_Runner_:
		s := proto.Size(x.Runner)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateKey_MultimapSideInput_:
		s := proto.Size(x.MultimapSideInput)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateKey_BagUserState_:
		s := proto.Size(x.BagUserState)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type StateKey_Runner struct {
	// (Required) Opaque information supplied by the runner. Used to support
	// remote references.
	Key                  []byte   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateKey_Runner) Reset()         { *m = StateKey_Runner{} }
func (m *StateKey_Runner) String() string { return proto.CompactTextString(m) }
func (*StateKey_Runner) ProtoMessage()    {}
func (*StateKey_Runner) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{28, 0}
}
func (m *StateKey_Runner) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey_Runner.Unmarshal(m, b)
}
func (m *StateKey_Runner) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey_Runner.Marshal(b, m, deterministic)
}
func (dst *StateKey_Runner) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey_Runner.Merge(dst, src)
}
func (m *StateKey_Runner) XXX_Size() int {
	return xxx_messageInfo_StateKey_Runner.Size(m)
}
func (m *StateKey_Runner) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey_Runner.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey_Runner proto.InternalMessageInfo

func (m *StateKey_Runner) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

type StateKey_MultimapSideInput struct {
	// (Required) The id of the PTransform containing a side input.
	PtransformId string `protobuf:"bytes,1,opt,name=ptransform_id,json=ptransformId,proto3" json:"ptransform_id,omitempty"`
	// (Required) The id of the side input.
	SideInputId string `protobuf:"bytes,2,opt,name=side_input_id,json=sideInputId,proto3" json:"side_input_id,omitempty"`
	// (Required) The window (after mapping the currently executing elements
	// window into the side input windows domain) encoded in a nested context.
	Window []byte `protobuf:"bytes,3,opt,name=window,proto3" json:"window,omitempty"`
	// (Required) The key encoded in a nested context.
	Key                  []byte   `protobuf:"bytes,4,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateKey_MultimapSideInput) Reset()         { *m = StateKey_MultimapSideInput{} }
func (m *StateKey_MultimapSideInput) String() string { return proto.CompactTextString(m) }
func (*StateKey_MultimapSideInput) ProtoMessage()    {}
func (*StateKey_MultimapSideInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{28, 1}
}
func (m *StateKey_MultimapSideInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey_MultimapSideInput.Unmarshal(m, b)
}
func (m *StateKey_MultimapSideInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey_MultimapSideInput.Marshal(b, m, deterministic)
}
func (dst *StateKey_MultimapSideInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey_MultimapSideInput.Merge(dst, src)
}
func (m *StateKey_MultimapSideInput) XXX_Size() int {
	return xxx_messageInfo_StateKey_MultimapSideInput.Size(m)
}
func (m *StateKey_MultimapSideInput) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey_MultimapSideInput.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey_MultimapSideInput proto.InternalMessageInfo

func (m *StateKey_MultimapSideInput) GetPtransformId() string {
	if m != nil {
		return m.PtransformId
	}
	return ""
}

func (m *StateKey_MultimapSideInput) GetSideInputId() string {
	if m != nil {
		return m.SideInputId
	}
	return ""
}

func (m *StateKey_MultimapSideInput) GetWindow() []byte {
	if m != nil {
		return m.Window
	}
	return nil
}

func (m *StateKey_MultimapSideInput) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

type StateKey_BagUserState struct {
	// (Required) The id of the PTransform containing user state.
	PtransformId string `protobuf:"bytes,1,opt,name=ptransform_id,json=ptransformId,proto3" json:"ptransform_id,omitempty"`
	// (Required) The id of the user state.
	UserStateId string `protobuf:"bytes,2,opt,name=user_state_id,json=userStateId,proto3" json:"user_state_id,omitempty"`
	// (Required) The window encoded in a nested context.
	Window []byte `protobuf:"bytes,3,opt,name=window,proto3" json:"window,omitempty"`
	// (Required) The key of the currently executing element encoded in a
	// nested context.
	Key                  []byte   `protobuf:"bytes,4,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateKey_BagUserState) Reset()         { *m = StateKey_BagUserState{} }
func (m *StateKey_BagUserState) String() string { return proto.CompactTextString(m) }
func (*StateKey_BagUserState) ProtoMessage()    {}
func (*StateKey_BagUserState) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{28, 2}
}
func (m *StateKey_BagUserState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey_BagUserState.Unmarshal(m, b)
}
func (m *StateKey_BagUserState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey_BagUserState.Marshal(b, m, deterministic)
}
func (dst *StateKey_BagUserState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey_BagUserState.Merge(dst, src)
}
func (m *StateKey_BagUserState) XXX_Size() int {
	return xxx_messageInfo_StateKey_BagUserState.Size(m)
}
func (m *StateKey_BagUserState) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey_BagUserState.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey_BagUserState proto.InternalMessageInfo

func (m *StateKey_BagUserState) GetPtransformId() string {
	if m != nil {
		return m.PtransformId
	}
	return ""
}

func (m *StateKey_BagUserState) GetUserStateId() string {
	if m != nil {
		return m.UserStateId
	}
	return ""
}

func (m *StateKey_BagUserState) GetWindow() []byte {
	if m != nil {
		return m.Window
	}
	return nil
}

func (m *StateKey_BagUserState) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

// A request to get state.
type StateGetRequest struct {
	// (Optional) If specified, signals to the runner that the response
	// should resume from the following continuation token.
	//
	// If unspecified, signals to the runner that the response should start
	// from the beginning of the logical continuable stream.
	ContinuationToken    []byte   `protobuf:"bytes,1,opt,name=continuation_token,json=continuationToken,proto3" json:"continuation_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateGetRequest) Reset()         { *m = StateGetRequest{} }
func (m *StateGetRequest) String() string { return proto.CompactTextString(m) }
func (*StateGetRequest) ProtoMessage()    {}
func (*StateGetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{29}
}
func (m *StateGetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateGetRequest.Unmarshal(m, b)
}
func (m *StateGetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateGetRequest.Marshal(b, m, deterministic)
}
func (dst *StateGetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateGetRequest.Merge(dst, src)
}
func (m *StateGetRequest) XXX_Size() int {
	return xxx_messageInfo_StateGetRequest.Size(m)
}
func (m *StateGetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateGetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateGetRequest proto.InternalMessageInfo

func (m *StateGetRequest) GetContinuationToken() []byte {
	if m != nil {
		return m.ContinuationToken
	}
	return nil
}

// A response to get state representing a logical byte stream which can be
// continued using the state API.
type StateGetResponse struct {
	// (Optional) If specified, represents a token which can be used with the
	// state API to get the next chunk of this logical byte stream. The end of
	// the logical byte stream is signalled by this field being unset.
	ContinuationToken []byte `protobuf:"bytes,1,opt,name=continuation_token,json=continuationToken,proto3" json:"continuation_token,omitempty"`
	// Represents a part of a logical byte stream. Elements within
	// the logical byte stream are encoded in the nested context and
	// concatenated together.
	Data                 []byte   `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateGetResponse) Reset()         { *m = StateGetResponse{} }
func (m *StateGetResponse) String() string { return proto.CompactTextString(m) }
func (*StateGetResponse) ProtoMessage()    {}
func (*StateGetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{30}
}
func (m *StateGetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateGetResponse.Unmarshal(m, b)
}
func (m *StateGetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateGetResponse.Marshal(b, m, deterministic)
}
func (dst *StateGetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateGetResponse.Merge(dst, src)
}
func (m *StateGetResponse) XXX_Size() int {
	return xxx_messageInfo_StateGetResponse.Size(m)
}
func (m *StateGetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateGetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateGetResponse proto.InternalMessageInfo

func (m *StateGetResponse) GetContinuationToken() []byte {
	if m != nil {
		return m.ContinuationToken
	}
	return nil
}

func (m *StateGetResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// A request to append state.
type StateAppendRequest struct {
	// Represents a part of a logical byte stream. Elements within
	// the logical byte stream are encoded in the nested context and
	// multiple append requests are concatenated together.
	Data                 []byte   `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateAppendRequest) Reset()         { *m = StateAppendRequest{} }
func (m *StateAppendRequest) String() string { return proto.CompactTextString(m) }
func (*StateAppendRequest) ProtoMessage()    {}
func (*StateAppendRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{31}
}
func (m *StateAppendRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateAppendRequest.Unmarshal(m, b)
}
func (m *StateAppendRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateAppendRequest.Marshal(b, m, deterministic)
}
func (dst *StateAppendRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateAppendRequest.Merge(dst, src)
}
func (m *StateAppendRequest) XXX_Size() int {
	return xxx_messageInfo_StateAppendRequest.Size(m)
}
func (m *StateAppendRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateAppendRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateAppendRequest proto.InternalMessageInfo

func (m *StateAppendRequest) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// A response to append state.
type StateAppendResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateAppendResponse) Reset()         { *m = StateAppendResponse{} }
func (m *StateAppendResponse) String() string { return proto.CompactTextString(m) }
func (*StateAppendResponse) ProtoMessage()    {}
func (*StateAppendResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{32}
}
func (m *StateAppendResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateAppendResponse.Unmarshal(m, b)
}
func (m *StateAppendResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateAppendResponse.Marshal(b, m, deterministic)
}
func (dst *StateAppendResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateAppendResponse.Merge(dst, src)
}
func (m *StateAppendResponse) XXX_Size() int {
	return xxx_messageInfo_StateAppendResponse.Size(m)
}
func (m *StateAppendResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateAppendResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateAppendResponse proto.InternalMessageInfo

// A request to clear state.
type StateClearRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateClearRequest) Reset()         { *m = StateClearRequest{} }
func (m *StateClearRequest) String() string { return proto.CompactTextString(m) }
func (*StateClearRequest) ProtoMessage()    {}
func (*StateClearRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{33}
}
func (m *StateClearRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateClearRequest.Unmarshal(m, b)
}
func (m *StateClearRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateClearRequest.Marshal(b, m, deterministic)
}
func (dst *StateClearRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateClearRequest.Merge(dst, src)
}
func (m *StateClearRequest) XXX_Size() int {
	return xxx_messageInfo_StateClearRequest.Size(m)
}
func (m *StateClearRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateClearRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateClearRequest proto.InternalMessageInfo

// A response to clear state.
type StateClearResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateClearResponse) Reset()         { *m = StateClearResponse{} }
func (m *StateClearResponse) String() string { return proto.CompactTextString(m) }
func (*StateClearResponse) ProtoMessage()    {}
func (*StateClearResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{34}
}
func (m *StateClearResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateClearResponse.Unmarshal(m, b)
}
func (m *StateClearResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateClearResponse.Marshal(b, m, deterministic)
}
func (dst *StateClearResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateClearResponse.Merge(dst, src)
}
func (m *StateClearResponse) XXX_Size() int {
	return xxx_messageInfo_StateClearResponse.Size(m)
}
func (m *StateClearResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateClearResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateClearResponse proto.InternalMessageInfo

// A log entry
type LogEntry struct {
	// (Required) The severity of the log statement.
	Severity LogEntry_Severity_Enum `protobuf:"varint,1,opt,name=severity,proto3,enum=org.apache.beam.model.fn_execution.v1.LogEntry_Severity_Enum" json:"severity,omitempty"`
	// (Required) The time at which this log statement occurred.
	Timestamp *timestamp.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// (Required) A human readable message.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	// (Optional) An optional trace of the functions involved. For example, in
	// Java this can include multiple causes and multiple suppressed exceptions.
	Trace string `protobuf:"bytes,4,opt,name=trace,proto3" json:"trace,omitempty"`
	// (Optional) A reference to the instruction this log statement is associated
	// with.
	InstructionReference string `protobuf:"bytes,5,opt,name=instruction_reference,json=instructionReference,proto3" json:"instruction_reference,omitempty"`
	// (Optional) A reference to the primitive transform this log statement is
	// associated with.
	PrimitiveTransformReference string `protobuf:"bytes,6,opt,name=primitive_transform_reference,json=primitiveTransformReference,proto3" json:"primitive_transform_reference,omitempty"`
	// (Optional) Human-readable name of the function or method being invoked,
	// with optional context such as the class or package name. The format can
	// vary by language. For example:
	//   qual.if.ied.Class.method (Java)
	//   dir/package.func (Go)
	//   module.function (Python)
	//   file.cc:382 (C++)
	LogLocation string `protobuf:"bytes,7,opt,name=log_location,json=logLocation,proto3" json:"log_location,omitempty"`
	// (Optional) The name of the thread this log statement is associated with.
	Thread               string   `protobuf:"bytes,8,opt,name=thread,proto3" json:"thread,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogEntry) Reset()         { *m = LogEntry{} }
func (m *LogEntry) String() string { return proto.CompactTextString(m) }
func (*LogEntry) ProtoMessage()    {}
func (*LogEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{35}
}
func (m *LogEntry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogEntry.Unmarshal(m, b)
}
func (m *LogEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogEntry.Marshal(b, m, deterministic)
}
func (dst *LogEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry.Merge(dst, src)
}
func (m *LogEntry) XXX_Size() int {
	return xxx_messageInfo_LogEntry.Size(m)
}
func (m *LogEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry proto.InternalMessageInfo

func (m *LogEntry) GetSeverity() LogEntry_Severity_Enum {
	if m != nil {
		return m.Severity
	}
	return LogEntry_Severity_UNSPECIFIED
}

func (m *LogEntry) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *LogEntry) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *LogEntry) GetTrace() string {
	if m != nil {
		return m.Trace
	}
	return ""
}

func (m *LogEntry) GetInstructionReference() string {
	if m != nil {
		return m.InstructionReference
	}
	return ""
}

func (m *LogEntry) GetPrimitiveTransformReference() string {
	if m != nil {
		return m.PrimitiveTransformReference
	}
	return ""
}

func (m *LogEntry) GetLogLocation() string {
	if m != nil {
		return m.LogLocation
	}
	return ""
}

func (m *LogEntry) GetThread() string {
	if m != nil {
		return m.Thread
	}
	return ""
}

// A list of log entries, enables buffering and batching of multiple
// log messages using the logging API.
type LogEntry_List struct {
	// (Required) One or or more log messages.
	LogEntries           []*LogEntry `protobuf:"bytes,1,rep,name=log_entries,json=logEntries,proto3" json:"log_entries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *LogEntry_List) Reset()         { *m = LogEntry_List{} }
func (m *LogEntry_List) String() string { return proto.CompactTextString(m) }
func (*LogEntry_List) ProtoMessage()    {}
func (*LogEntry_List) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{35, 0}
}
func (m *LogEntry_List) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogEntry_List.Unmarshal(m, b)
}
func (m *LogEntry_List) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogEntry_List.Marshal(b, m, deterministic)
}
func (dst *LogEntry_List) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry_List.Merge(dst, src)
}
func (m *LogEntry_List) XXX_Size() int {
	return xxx_messageInfo_LogEntry_List.Size(m)
}
func (m *LogEntry_List) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry_List.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry_List proto.InternalMessageInfo

func (m *LogEntry_List) GetLogEntries() []*LogEntry {
	if m != nil {
		return m.LogEntries
	}
	return nil
}

// The severity of the event described in a log entry, expressed as one of the
// severity levels listed below. For your reference, the levels are
// assigned the listed numeric values. The effect of using numeric values
// other than those listed is undefined.
//
// If you are writing log entries, you should map other severity encodings to
// one of these standard levels. For example, you might map all of
// Java's FINE, FINER, and FINEST levels to `Severity.DEBUG`.
//
// This list is intentionally not comprehensive; the intent is to provide a
// common set of "good enough" severity levels so that logging front ends
// can provide filtering and searching across log types. Users of the API are
// free not to use all severity levels in their log messages.
type LogEntry_Severity struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogEntry_Severity) Reset()         { *m = LogEntry_Severity{} }
func (m *LogEntry_Severity) String() string { return proto.CompactTextString(m) }
func (*LogEntry_Severity) ProtoMessage()    {}
func (*LogEntry_Severity) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{35, 1}
}
func (m *LogEntry_Severity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogEntry_Severity.Unmarshal(m, b)
}
func (m *LogEntry_Severity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogEntry_Severity.Marshal(b, m, deterministic)
}
func (dst *LogEntry_Severity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry_Severity.Merge(dst, src)
}
func (m *LogEntry_Severity) XXX_Size() int {
	return xxx_messageInfo_LogEntry_Severity.Size(m)
}
func (m *LogEntry_Severity) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry_Severity.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry_Severity proto.InternalMessageInfo

type LogControl struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogControl) Reset()         { *m = LogControl{} }
func (m *LogControl) String() string { return proto.CompactTextString(m) }
func (*LogControl) ProtoMessage()    {}
func (*LogControl) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_6ff4efbe085bd72e, []int{36}
}
func (m *LogControl) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogControl.Unmarshal(m, b)
}
func (m *LogControl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogControl.Marshal(b, m, deterministic)
}
func (dst *LogControl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogControl.Merge(dst, src)
}
func (m *LogControl) XXX_Size() int {
	return xxx_messageInfo_LogControl.Size(m)
}
func (m *LogControl) XXX_DiscardUnknown() {
	xxx_messageInfo_LogControl.DiscardUnknown(m)
}

var xxx_messageInfo_LogControl proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Target)(nil), "org.apache.beam.model.fn_execution.v1.Target")
	proto.RegisterType((*Target_List)(nil), "org.apache.beam.model.fn_execution.v1.Target.List")
	proto.RegisterType((*RemoteGrpcPort)(nil), "org.apache.beam.model.fn_execution.v1.RemoteGrpcPort")
	proto.RegisterType((*InstructionRequest)(nil), "org.apache.beam.model.fn_execution.v1.InstructionRequest")
	proto.RegisterType((*InstructionResponse)(nil), "org.apache.beam.model.fn_execution.v1.InstructionResponse")
	proto.RegisterType((*RegisterRequest)(nil), "org.apache.beam.model.fn_execution.v1.RegisterRequest")
	proto.RegisterType((*RegisterResponse)(nil), "org.apache.beam.model.fn_execution.v1.RegisterResponse")
	proto.RegisterType((*ProcessBundleDescriptor)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor")
	proto.RegisterMapType((map[string]*pipeline_v1.Coder)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.CodersEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.Environment)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.EnvironmentsEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.PCollection)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.PcollectionsEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.PTransform)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.TransformsEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.WindowingStrategy)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.WindowingStrategiesEntry")
	proto.RegisterType((*BundleSplit)(nil), "org.apache.beam.model.fn_execution.v1.BundleSplit")
	proto.RegisterType((*BundleSplit_Application)(nil), "org.apache.beam.model.fn_execution.v1.BundleSplit.Application")
	proto.RegisterMapType((map[string]int64)(nil), "org.apache.beam.model.fn_execution.v1.BundleSplit.Application.OutputWatermarksEntry")
	proto.RegisterType((*ProcessBundleRequest)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleRequest")
	proto.RegisterType((*ProcessBundleResponse)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleResponse")
	proto.RegisterType((*ProcessBundleProgressRequest)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleProgressRequest")
	proto.RegisterType((*MonitoringInfo)(nil), "org.apache.beam.model.fn_execution.v1.MonitoringInfo")
	proto.RegisterMapType((map[string]string)(nil), "org.apache.beam.model.fn_execution.v1.MonitoringInfo.LabelsEntry")
	proto.RegisterType((*Metric)(nil), "org.apache.beam.model.fn_execution.v1.Metric")
	proto.RegisterType((*CounterData)(nil), "org.apache.beam.model.fn_execution.v1.CounterData")
	proto.RegisterType((*ExtremaData)(nil), "org.apache.beam.model.fn_execution.v1.ExtremaData")
	proto.RegisterType((*IntExtremaData)(nil), "org.apache.beam.model.fn_execution.v1.IntExtremaData")
	proto.RegisterType((*DoubleExtremaData)(nil), "org.apache.beam.model.fn_execution.v1.DoubleExtremaData")
	proto.RegisterType((*DistributionData)(nil), "org.apache.beam.model.fn_execution.v1.DistributionData")
	proto.RegisterType((*IntDistributionData)(nil), "org.apache.beam.model.fn_execution.v1.IntDistributionData")
	proto.RegisterType((*DoubleDistributionData)(nil), "org.apache.beam.model.fn_execution.v1.DoubleDistributionData")
	proto.RegisterType((*MonitoringTableData)(nil), "org.apache.beam.model.fn_execution.v1.MonitoringTableData")
	proto.RegisterType((*MonitoringTableData_MonitoringColumnValue)(nil), "org.apache.beam.model.fn_execution.v1.MonitoringTableData.MonitoringColumnValue")
	proto.RegisterType((*MonitoringTableData_MonitoringRow)(nil), "org.apache.beam.model.fn_execution.v1.MonitoringTableData.MonitoringRow")
	proto.RegisterType((*Metrics)(nil), "org.apache.beam.model.fn_execution.v1.Metrics")
	proto.RegisterMapType((map[string]*Metrics_PTransform)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PtransformsEntry")
	proto.RegisterType((*Metrics_PTransform)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform")
	proto.RegisterMapType((map[string]int64)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.WatermarksEntry")
	proto.RegisterType((*Metrics_PTransform_Measured)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.Measured")
	proto.RegisterMapType((map[string]int64)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.Measured.InputElementCountsEntry")
	proto.RegisterMapType((map[string]int64)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.Measured.OutputElementCountsEntry")
	proto.RegisterType((*Metrics_PTransform_ProcessedElements)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.ProcessedElements")
	proto.RegisterType((*Metrics_PTransform_ActiveElements)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.ActiveElements")
	proto.RegisterMapType((map[string]int64)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.ActiveElements.OutputElementsRemainingEntry")
	proto.RegisterType((*Metrics_User)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User")
	proto.RegisterType((*Metrics_User_MetricName)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User.MetricName")
	proto.RegisterType((*Metrics_User_CounterData)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User.CounterData")
	proto.RegisterType((*Metrics_User_DistributionData)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User.DistributionData")
	proto.RegisterType((*Metrics_User_GaugeData)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User.GaugeData")
	proto.RegisterType((*ProcessBundleProgressResponse)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleProgressResponse")
	proto.RegisterType((*ProcessBundleSplitRequest)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest")
	proto.RegisterType((*ProcessBundleSplitResponse)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse")
	proto.RegisterType((*Elements)(nil), "org.apache.beam.model.fn_execution.v1.Elements")
	proto.RegisterType((*Elements_Data)(nil), "org.apache.beam.model.fn_execution.v1.Elements.Data")
	proto.RegisterType((*StateRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateRequest")
	proto.RegisterType((*StateResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateResponse")
	proto.RegisterType((*StateKey)(nil), "org.apache.beam.model.fn_execution.v1.StateKey")
	proto.RegisterType((*StateKey_Runner)(nil), "org.apache.beam.model.fn_execution.v1.StateKey.Runner")
	proto.RegisterType((*StateKey_MultimapSideInput)(nil), "org.apache.beam.model.fn_execution.v1.StateKey.MultimapSideInput")
	proto.RegisterType((*StateKey_BagUserState)(nil), "org.apache.beam.model.fn_execution.v1.StateKey.BagUserState")
	proto.RegisterType((*StateGetRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateGetRequest")
	proto.RegisterType((*StateGetResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateGetResponse")
	proto.RegisterType((*StateAppendRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateAppendRequest")
	proto.RegisterType((*StateAppendResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateAppendResponse")
	proto.RegisterType((*StateClearRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateClearRequest")
	proto.RegisterType((*StateClearResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateClearResponse")
	proto.RegisterType((*LogEntry)(nil), "org.apache.beam.model.fn_execution.v1.LogEntry")
	proto.RegisterType((*LogEntry_List)(nil), "org.apache.beam.model.fn_execution.v1.LogEntry.List")
	proto.RegisterType((*LogEntry_Severity)(nil), "org.apache.beam.model.fn_execution.v1.LogEntry.Severity")
	proto.RegisterType((*LogControl)(nil), "org.apache.beam.model.fn_execution.v1.LogControl")
	proto.RegisterEnum("org.apache.beam.model.fn_execution.v1.MonitoringInfo_MonitoringInfoLabels", MonitoringInfo_MonitoringInfoLabels_name, MonitoringInfo_MonitoringInfoLabels_value)
	proto.RegisterEnum("org.apache.beam.model.fn_execution.v1.LogEntry_Severity_Enum", LogEntry_Severity_Enum_name, LogEntry_Severity_Enum_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// BeamFnControlClient is the client API for BeamFnControl service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnControlClient interface {
	// Instructions sent by the runner to the SDK requesting different types
	// of work.
	Control(ctx context.Context, opts ...grpc.CallOption) (BeamFnControl_ControlClient, error)
}

type beamFnControlClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnControlClient(cc *grpc.ClientConn) BeamFnControlClient {
	return &beamFnControlClient{cc}
}

func (c *beamFnControlClient) Control(ctx context.Context, opts ...grpc.CallOption) (BeamFnControl_ControlClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnControl_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnControl/Control", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnControlControlClient{stream}
	return x, nil
}

type BeamFnControl_ControlClient interface {
	Send(*InstructionResponse) error
	Recv() (*InstructionRequest, error)
	grpc.ClientStream
}

type beamFnControlControlClient struct {
	grpc.ClientStream
}

func (x *beamFnControlControlClient) Send(m *InstructionResponse) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnControlControlClient) Recv() (*InstructionRequest, error) {
	m := new(InstructionRequest)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnControlServer is the server API for BeamFnControl service.
type BeamFnControlServer interface {
	// Instructions sent by the runner to the SDK requesting different types
	// of work.
	Control(BeamFnControl_ControlServer) error
}

func RegisterBeamFnControlServer(s *grpc.Server, srv BeamFnControlServer) {
	s.RegisterService(&_BeamFnControl_serviceDesc, srv)
}

func _BeamFnControl_Control_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnControlServer).Control(&beamFnControlControlServer{stream})
}

type BeamFnControl_ControlServer interface {
	Send(*InstructionRequest) error
	Recv() (*InstructionResponse, error)
	grpc.ServerStream
}

type beamFnControlControlServer struct {
	grpc.ServerStream
}

func (x *beamFnControlControlServer) Send(m *InstructionRequest) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnControlControlServer) Recv() (*InstructionResponse, error) {
	m := new(InstructionResponse)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnControl_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnControl",
	HandlerType: (*BeamFnControlServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Control",
			Handler:       _BeamFnControl_Control_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}

// BeamFnDataClient is the client API for BeamFnData service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnDataClient interface {
	// Used to send data between harnesses.
	Data(ctx context.Context, opts ...grpc.CallOption) (BeamFnData_DataClient, error)
}

type beamFnDataClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnDataClient(cc *grpc.ClientConn) BeamFnDataClient {
	return &beamFnDataClient{cc}
}

func (c *beamFnDataClient) Data(ctx context.Context, opts ...grpc.CallOption) (BeamFnData_DataClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnData_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnData/Data", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnDataDataClient{stream}
	return x, nil
}

type BeamFnData_DataClient interface {
	Send(*Elements) error
	Recv() (*Elements, error)
	grpc.ClientStream
}

type beamFnDataDataClient struct {
	grpc.ClientStream
}

func (x *beamFnDataDataClient) Send(m *Elements) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnDataDataClient) Recv() (*Elements, error) {
	m := new(Elements)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnDataServer is the server API for BeamFnData service.
type BeamFnDataServer interface {
	// Used to send data between harnesses.
	Data(BeamFnData_DataServer) error
}

func RegisterBeamFnDataServer(s *grpc.Server, srv BeamFnDataServer) {
	s.RegisterService(&_BeamFnData_serviceDesc, srv)
}

func _BeamFnData_Data_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnDataServer).Data(&beamFnDataDataServer{stream})
}

type BeamFnData_DataServer interface {
	Send(*Elements) error
	Recv() (*Elements, error)
	grpc.ServerStream
}

type beamFnDataDataServer struct {
	grpc.ServerStream
}

func (x *beamFnDataDataServer) Send(m *Elements) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnDataDataServer) Recv() (*Elements, error) {
	m := new(Elements)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnData_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnData",
	HandlerType: (*BeamFnDataServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Data",
			Handler:       _BeamFnData_Data_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}

// BeamFnStateClient is the client API for BeamFnState service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnStateClient interface {
	// Used to get/append/clear state stored by the runner on behalf of the SDK.
	State(ctx context.Context, opts ...grpc.CallOption) (BeamFnState_StateClient, error)
}

type beamFnStateClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnStateClient(cc *grpc.ClientConn) BeamFnStateClient {
	return &beamFnStateClient{cc}
}

func (c *beamFnStateClient) State(ctx context.Context, opts ...grpc.CallOption) (BeamFnState_StateClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnState_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnState/State", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnStateStateClient{stream}
	return x, nil
}

type BeamFnState_StateClient interface {
	Send(*StateRequest) error
	Recv() (*StateResponse, error)
	grpc.ClientStream
}

type beamFnStateStateClient struct {
	grpc.ClientStream
}

func (x *beamFnStateStateClient) Send(m *StateRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnStateStateClient) Recv() (*StateResponse, error) {
	m := new(StateResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnStateServer is the server API for BeamFnState service.
type BeamFnStateServer interface {
	// Used to get/append/clear state stored by the runner on behalf of the SDK.
	State(BeamFnState_StateServer) error
}

func RegisterBeamFnStateServer(s *grpc.Server, srv BeamFnStateServer) {
	s.RegisterService(&_BeamFnState_serviceDesc, srv)
}

func _BeamFnState_State_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnStateServer).State(&beamFnStateStateServer{stream})
}

type BeamFnState_StateServer interface {
	Send(*StateResponse) error
	Recv() (*StateRequest, error)
	grpc.ServerStream
}

type beamFnStateStateServer struct {
	grpc.ServerStream
}

func (x *beamFnStateStateServer) Send(m *StateResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnStateStateServer) Recv() (*StateRequest, error) {
	m := new(StateRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnState_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnState",
	HandlerType: (*BeamFnStateServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "State",
			Handler:       _BeamFnState_State_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}

// BeamFnLoggingClient is the client API for BeamFnLogging service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnLoggingClient interface {
	// Allows for the SDK to emit log entries which the runner can
	// associate with the active job.
	Logging(ctx context.Context, opts ...grpc.CallOption) (BeamFnLogging_LoggingClient, error)
}

type beamFnLoggingClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnLoggingClient(cc *grpc.ClientConn) BeamFnLoggingClient {
	return &beamFnLoggingClient{cc}
}

func (c *beamFnLoggingClient) Logging(ctx context.Context, opts ...grpc.CallOption) (BeamFnLogging_LoggingClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnLogging_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnLogging/Logging", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnLoggingLoggingClient{stream}
	return x, nil
}

type BeamFnLogging_LoggingClient interface {
	Send(*LogEntry_List) error
	Recv() (*LogControl, error)
	grpc.ClientStream
}

type beamFnLoggingLoggingClient struct {
	grpc.ClientStream
}

func (x *beamFnLoggingLoggingClient) Send(m *LogEntry_List) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnLoggingLoggingClient) Recv() (*LogControl, error) {
	m := new(LogControl)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnLoggingServer is the server API for BeamFnLogging service.
type BeamFnLoggingServer interface {
	// Allows for the SDK to emit log entries which the runner can
	// associate with the active job.
	Logging(BeamFnLogging_LoggingServer) error
}

func RegisterBeamFnLoggingServer(s *grpc.Server, srv BeamFnLoggingServer) {
	s.RegisterService(&_BeamFnLogging_serviceDesc, srv)
}

func _BeamFnLogging_Logging_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnLoggingServer).Logging(&beamFnLoggingLoggingServer{stream})
}

type BeamFnLogging_LoggingServer interface {
	Send(*LogControl) error
	Recv() (*LogEntry_List, error)
	grpc.ServerStream
}

type beamFnLoggingLoggingServer struct {
	grpc.ServerStream
}

func (x *beamFnLoggingLoggingServer) Send(m *LogControl) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnLoggingLoggingServer) Recv() (*LogEntry_List, error) {
	m := new(LogEntry_List)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnLogging_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnLogging",
	HandlerType: (*BeamFnLoggingServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Logging",
			Handler:       _BeamFnLogging_Logging_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}

func init() { proto.RegisterFile("beam_fn_api.proto", fileDescriptor_beam_fn_api_6ff4efbe085bd72e) }

var fileDescriptor_beam_fn_api_6ff4efbe085bd72e = []byte{
	// 3170 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5a, 0xcb, 0x6f, 0x23, 0xc7,
	0xd1, 0xd7, 0x90, 0x14, 0x25, 0x16, 0x29, 0x8a, 0x6a, 0x49, 0xbb, 0xdc, 0xf9, 0xd6, 0x9f, 0xd7,
	0xb3, 0x31, 0xb0, 0x17, 0x73, 0xe3, 0xdd, 0x8d, 0xbd, 0xbb, 0xb1, 0xd7, 0xa6, 0x28, 0xae, 0x44,
	0x5b, 0xaf, 0x8c, 0xb8, 0x56, 0x6c, 0x03, 0x1e, 0x8c, 0x38, 0x2d, 0x7a, 0xbc, 0xe4, 0xcc, 0xb8,
	0xa7, 0xa9, 0x87, 0x61, 0x24, 0x30, 0x02, 0x38, 0x0f, 0x24, 0xf0, 0x2d, 0x31, 0x72, 0x8b, 0x73,
	0x4b, 0x0e, 0x39, 0xe4, 0xaf, 0xc8, 0x29, 0x08, 0x90, 0x5b, 0x72, 0x34, 0x10, 0x27, 0x41, 0xee,
	0x01, 0x72, 0x09, 0xfa, 0x31, 0x0f, 0xbe, 0xb4, 0x1c, 0x6a, 0x13, 0xe4, 0x36, 0x5d, 0xdd, 0x55,
	0xbf, 0xea, 0xea, 0xea, 0xea, 0xaa, 0x9e, 0x86, 0xa5, 0x43, 0x6c, 0x76, 0x8d, 0x23, 0xc7, 0x30,
	0x3d, 0xbb, 0xe2, 0x11, 0x97, 0xba, 0xe8, 0x79, 0x97, 0xb4, 0x2b, 0xa6, 0x67, 0xb6, 0xde, 0xc7,
	0x15, 0xd6, 0x5b, 0xe9, 0xba, 0x16, 0xee, 0x54, 0x8e, 0x1c, 0x03, 0x9f, 0xe2, 0x56, 0x8f, 0xda,
	0xae, 0x53, 0x39, 0x7e, 0x51, 0x5d, 0xe5, 0x9c, 0xa4, 0xe7, 0x38, 0x98, 0x44, 0xdc, 0xea, 0x22,
	0x76, 0x2c, 0xcf, 0xb5, 0x1d, 0xea, 0x4b, 0xc2, 0xb3, 0x6d, 0xd7, 0x6d, 0x77, 0xf0, 0x4d, 0xde,
	0x3a, 0xec, 0x1d, 0xdd, 0xa4, 0x76, 0x17, 0xfb, 0xd4, 0xec, 0x7a, 0x72, 0xc0, 0xff, 0x0f, 0x0e,
	0x38, 0x21, 0xa6, 0xe7, 0x61, 0x22, 0x05, 0x68, 0xbf, 0x51, 0x20, 0xdb, 0x34, 0x49, 0x1b, 0x53,
	0xb4, 0x06, 0xcf, 0x78, 0xc4, 0xee, 0xda, 0xd4, 0x3e, 0xc6, 0x06, 0x25, 0xa6, 0xe3, 0x1f, 0xb9,
	0xa4, 0x6b, 0x10, 0x7c, 0x84, 0x09, 0x76, 0x5a, 0xb8, 0xac, 0x5c, 0x53, 0x6e, 0xe4, 0xf4, 0xff,
	0x0b, 0x07, 0x35, 0x83, 0x31, 0x7a, 0x30, 0x04, 0x21, 0xc8, 0x38, 0x66, 0x17, 0x97, 0x53, 0x7c,
	0x28, 0xff, 0x56, 0xb7, 0x21, 0xb3, 0x65, 0xfb, 0x14, 0xd5, 0x21, 0x4b, 0x39, 0x52, 0x59, 0xb9,
	0x96, 0xbe, 0x91, 0xbf, 0xf5, 0x42, 0x65, 0x22, 0x5b, 0x54, 0x84, 0x7a, 0xba, 0x64, 0xd6, 0x7e,
	0xae, 0x40, 0x51, 0xc7, 0x5d, 0x97, 0xe2, 0x0d, 0xe2, 0xb5, 0xf6, 0x5c, 0x42, 0x51, 0x17, 0x2e,
	0x99, 0x9e, 0x6d, 0xf8, 0x98, 0x1c, 0xdb, 0x2d, 0x6c, 0x58, 0xd8, 0x6f, 0x11, 0xdb, 0xa3, 0x2e,
	0xe1, 0x2a, 0xe7, 0x6f, 0xbd, 0x3c, 0x06, 0xc9, 0xb3, 0x3d, 0xdc, 0xb1, 0x1d, 0xcc, 0x50, 0xaa,
	0x9e, 0xbd, 0x2f, 0xf8, 0xd7, 0x43, 0x76, 0x7d, 0xc5, 0x1c, 0x41, 0x45, 0x57, 0x60, 0xbe, 0xe5,
	0x5a, 0x98, 0x18, 0xb6, 0x25, 0x27, 0x3a, 0xc7, 0xdb, 0x0d, 0x4b, 0xfb, 0x57, 0x1a, 0x50, 0xc3,
	0xf1, 0x29, 0xe9, 0xb5, 0x98, 0xfa, 0x3a, 0xfe, 0xb0, 0x87, 0x7d, 0x8a, 0x9e, 0x87, 0xa2, 0x1d,
	0x51, 0x19, 0x9f, 0xb0, 0xe5, 0x42, 0x8c, 0xda, 0xb0, 0xd0, 0x23, 0x98, 0x27, 0xb8, 0x6d, 0xfb,
	0x14, 0x93, 0xf2, 0x57, 0x73, 0x5c, 0xf5, 0x97, 0x26, 0x34, 0x92, 0x2e, 0xf9, 0x24, 0xe2, 0xe6,
	0x8c, 0x1e, 0x8a, 0x42, 0x18, 0x8a, 0x1e, 0x71, 0x5b, 0xd8, 0xf7, 0x8d, 0xc3, 0x9e, 0x63, 0x75,
	0x70, 0xf9, 0xaf, 0x42, 0xf8, 0x37, 0x27, 0x14, 0xbe, 0x27, 0xb8, 0xd7, 0x38, 0x73, 0x84, 0xb0,
	0xe0, 0xc5, 0xe9, 0xe8, 0x3b, 0x70, 0xb9, 0x1f, 0xc6, 0xf0, 0x88, 0xdb, 0x26, 0xd8, 0xf7, 0xcb,
	0x7f, 0x13, 0x78, 0xb5, 0x69, 0xf0, 0xf6, 0xa4, 0x90, 0x08, 0x77, 0xd5, 0x1b, 0xd5, 0x8f, 0x7a,
	0xb0, 0x32, 0x80, 0xef, 0x7b, 0x1d, 0x9b, 0x96, 0xff, 0x2e, 0xc0, 0x5f, 0x9f, 0x06, 0x7c, 0x9f,
	0x49, 0x88, 0x90, 0x91, 0x37, 0xd4, 0xb9, 0x96, 0x83, 0x39, 0x22, 0x06, 0x68, 0x3f, 0xcb, 0xc0,
	0x72, 0xdf, 0xea, 0xfb, 0x9e, 0xeb, 0xf8, 0x78, 0xd2, 0xe5, 0x5f, 0x81, 0x59, 0x4c, 0x88, 0x4b,
	0xa4, 0x53, 0x89, 0x06, 0x7a, 0x6b, 0xd8, 0x29, 0x5e, 0x4e, 0xec, 0x14, 0x42, 0x91, 0x3e, 0xaf,
	0x38, 0x1a, 0xe7, 0x15, 0xaf, 0x4c, 0xe7, 0x15, 0x21, 0xc4, 0x80, 0x5b, 0x7c, 0xf7, 0x89, 0x6e,
	0xb1, 0x7e, 0x31, 0xb7, 0x08, 0x81, 0xc7, 0xf8, 0xc5, 0xf1, 0xf9, 0x7e, 0x51, 0xbd, 0x80, 0x5f,
	0x84, 0xd0, 0xa3, 0x1c, 0x03, 0xd8, 0xc2, 0x89, 0x11, 0xda, 0x4f, 0x14, 0x58, 0x1c, 0xd8, 0xa2,
	0xe8, 0x23, 0xb8, 0x32, 0xa0, 0x57, 0x5f, 0xe0, 0x62, 0x21, 0xf2, 0xc1, 0x34, 0xba, 0xc5, 0xe2,
	0xd7, 0x65, 0x6f, 0x74, 0x87, 0x86, 0xa0, 0x34, 0xe8, 0x1c, 0xda, 0x2f, 0x01, 0x2e, 0x8f, 0x11,
	0x84, 0x8a, 0x90, 0x0a, 0xbd, 0x36, 0x65, 0x5b, 0xc8, 0x01, 0x08, 0x4f, 0x08, 0xbf, 0x9c, 0xe2,
	0xca, 0xee, 0x5c, 0x4c, 0xd9, 0x4a, 0x78, 0x9c, 0xf8, 0x75, 0x87, 0x92, 0x33, 0x3d, 0x86, 0x80,
	0x28, 0x14, 0xbc, 0x96, 0xdb, 0xe9, 0x60, 0xbe, 0x57, 0xfc, 0x72, 0x9a, 0x23, 0xee, 0x5d, 0x10,
	0x71, 0x2f, 0x26, 0x52, 0x60, 0xf6, 0xa1, 0xa0, 0x1f, 0x29, 0xb0, 0x72, 0x62, 0x3b, 0x96, 0x7b,
	0x62, 0x3b, 0x6d, 0xc3, 0xa7, 0xc4, 0xa4, 0xb8, 0x6d, 0x63, 0xbf, 0x9c, 0xe1, 0xf0, 0x07, 0x17,
	0x84, 0x3f, 0x08, 0x44, 0xef, 0x87, 0x92, 0x85, 0x16, 0xcb, 0x27, 0xc3, 0x3d, 0xe8, 0x10, 0xb2,
	0xfc, 0x94, 0xf1, 0xcb, 0xb3, 0x1c, 0xfd, 0x8d, 0x0b, 0xa2, 0xd7, 0xb8, 0x30, 0x01, 0x28, 0x25,
	0x33, 0x33, 0x63, 0xe7, 0xd8, 0x26, 0xae, 0xd3, 0xc5, 0x0e, 0xf5, 0xcb, 0xd9, 0xa7, 0x62, 0xe6,
	0x7a, 0x4c, 0xa4, 0x34, 0x73, 0x1c, 0x05, 0x9d, 0xc2, 0x55, 0x9f, 0x9a, 0x14, 0x1b, 0x63, 0x0e,
	0xf1, 0xb9, 0x8b, 0x1d, 0xe2, 0x57, 0xb8, 0xf0, 0x51, 0x5d, 0x6a, 0x07, 0x16, 0x07, 0xbc, 0x0e,
	0x95, 0x20, 0xfd, 0x18, 0x9f, 0x49, 0x57, 0x67, 0x9f, 0xa8, 0x06, 0xb3, 0xc7, 0x66, 0xa7, 0x27,
	0x92, 0x9a, 0xf1, 0x69, 0x4b, 0x5c, 0x8f, 0xbd, 0x28, 0x35, 0x12, 0xbc, 0xf7, 0x53, 0x77, 0x15,
	0xd5, 0x85, 0xa5, 0x21, 0x8f, 0x1b, 0x81, 0xb7, 0xde, 0x8f, 0x57, 0x99, 0x04, 0xaf, 0x16, 0x8a,
	0x8d, 0x03, 0x7e, 0x0c, 0xe5, 0x71, 0x3e, 0x36, 0x02, 0xf7, 0x8d, 0x7e, 0xdc, 0x3b, 0x13, 0xe0,
	0x0e, 0x4a, 0x3f, 0x8b, 0xa3, 0xb7, 0x20, 0x1f, 0xf3, 0xb1, 0x11, 0x80, 0x0f, 0xfa, 0x01, 0x6f,
	0x4c, 0x00, 0xc8, 0x05, 0x0e, 0xd8, 0x74, 0xc8, 0xbd, 0x9e, 0x8e, 0x4d, 0x63, 0x62, 0x63, 0x80,
	0xda, 0x1f, 0x33, 0x90, 0x8f, 0x45, 0x79, 0xd4, 0x82, 0x05, 0x96, 0x10, 0x9b, 0xe4, 0xcc, 0x20,
	0xae, 0x4b, 0xfd, 0x84, 0x91, 0x3b, 0x26, 0xaa, 0x52, 0xf5, 0xbc, 0x8e, 0xdd, 0x32, 0xf9, 0x2a,
	0x16, 0xa4, 0x50, 0x9d, 0xc9, 0x64, 0x19, 0x1c, 0xc1, 0xbe, 0x6d, 0xf5, 0xcc, 0x8e, 0x44, 0x49,
	0x3d, 0x15, 0x94, 0x85, 0x40, 0x2a, 0x87, 0x51, 0xff, 0x99, 0x82, 0x7c, 0xac, 0x1b, 0x5d, 0x87,
	0x05, 0x2f, 0x2a, 0x04, 0xc2, 0x03, 0xa0, 0x10, 0x11, 0x1b, 0x16, 0xcb, 0x86, 0x6d, 0xc7, 0xeb,
	0xd1, 0x58, 0x36, 0xcc, 0xdb, 0x0d, 0x0b, 0x95, 0x61, 0x0e, 0x77, 0x30, 0xb3, 0x60, 0x39, 0x7d,
	0x4d, 0xb9, 0x51, 0xd0, 0x83, 0x26, 0xfa, 0x44, 0x81, 0x25, 0xb7, 0x47, 0x19, 0xdb, 0x89, 0x49,
	0x31, 0xe9, 0x9a, 0xe4, 0x71, 0x10, 0x56, 0x9b, 0x17, 0x9b, 0x54, 0x65, 0x97, 0xcb, 0x3d, 0x08,
	0xc5, 0x8a, 0x90, 0x53, 0x72, 0x07, 0xc8, 0xe8, 0x21, 0x94, 0x8e, 0x88, 0x29, 0x52, 0x32, 0xf7,
	0xc8, 0x38, 0x71, 0xc9, 0xe3, 0xf2, 0x2c, 0x77, 0x8f, 0xab, 0x15, 0x51, 0x35, 0x55, 0x82, 0xaa,
	0xa9, 0xb2, 0xee, 0xf6, 0x0e, 0x3b, 0xf8, 0x2d, 0xe6, 0x05, 0x7a, 0x31, 0xe0, 0xda, 0x3d, 0x3a,
	0x70, 0xc9, 0x63, 0xb5, 0x06, 0xab, 0x23, 0x21, 0x47, 0xb8, 0xe1, 0x4a, 0xdc, 0x0d, 0xd3, 0x71,
	0xb7, 0xfa, 0x81, 0x02, 0x2b, 0xa3, 0xd2, 0x6c, 0xb4, 0x0d, 0xd7, 0xc7, 0x66, 0x09, 0x43, 0xb5,
	0xd9, 0xb5, 0x31, 0xe7, 0x7d, 0x54, 0xa0, 0x3d, 0x07, 0x85, 0x16, 0x33, 0xac, 0x41, 0xdd, 0xc7,
	0xd8, 0x11, 0x7e, 0x54, 0xd0, 0xf3, 0x9c, 0xd6, 0xe4, 0x24, 0xed, 0xd7, 0x0a, 0xac, 0x8e, 0xcc,
	0xed, 0xd0, 0x26, 0xcc, 0x75, 0x31, 0x25, 0x76, 0xcb, 0x97, 0x85, 0x55, 0x65, 0xc2, 0xa5, 0xda,
	0x16, 0x5c, 0x7a, 0xc0, 0x8e, 0x36, 0x61, 0x56, 0x24, 0x61, 0x62, 0x3f, 0xde, 0x4a, 0xbe, 0xe4,
	0xba, 0x10, 0xa0, 0xed, 0xc3, 0xd5, 0xf3, 0xca, 0x05, 0x74, 0x1b, 0x56, 0xe3, 0xb9, 0xf7, 0xa0,
	0xc5, 0x56, 0xec, 0x78, 0xbe, 0x2e, 0xfb, 0x58, 0x19, 0x57, 0xdc, 0x76, 0x1d, 0x9b, 0xba, 0xc4,
	0x76, 0xda, 0x0d, 0xe7, 0xc8, 0x65, 0x8b, 0xd9, 0x23, 0x4e, 0xb0, 0x98, 0x3d, 0xe2, 0xb0, 0x5a,
	0x97, 0x9e, 0x79, 0x61, 0xad, 0xcb, 0xbe, 0x91, 0x07, 0xab, 0xdd, 0x90, 0xcf, 0xa0, 0xe6, 0x21,
	0x5b, 0x2f, 0x93, 0x9a, 0xdc, 0xff, 0xf3, 0xb7, 0xee, 0x4f, 0x6a, 0xaf, 0x50, 0x46, 0x93, 0x89,
	0x58, 0x37, 0xa9, 0xb9, 0x39, 0xa3, 0x2f, 0x77, 0x87, 0xc9, 0x68, 0x03, 0xb2, 0xc2, 0xa8, 0xe5,
	0xcc, 0xb9, 0xc7, 0xd3, 0xe8, 0x25, 0xd9, 0x9c, 0xd1, 0x25, 0x3b, 0x7a, 0x1b, 0xb2, 0x1d, 0xf3,
	0x10, 0x77, 0x82, 0xfc, 0xa2, 0x9a, 0x58, 0x57, 0x66, 0xa7, 0xca, 0x16, 0x97, 0x21, 0xd3, 0x0a,
	0x21, 0x50, 0xbd, 0x07, 0xf9, 0x18, 0xf9, 0x49, 0xfb, 0x22, 0x17, 0xdf, 0x17, 0x1f, 0xc0, 0x4a,
	0x3f, 0x80, 0x10, 0x84, 0x16, 0x20, 0xd7, 0xd4, 0xab, 0x3b, 0xfb, 0x0f, 0x77, 0xf5, 0xed, 0xd2,
	0x0c, 0x5a, 0x84, 0xfc, 0x5e, 0x6d, 0x77, 0x6b, 0xab, 0x5e, 0x6b, 0x36, 0x76, 0x77, 0x4a, 0x0a,
	0xba, 0x04, 0xe8, 0xa0, 0xb1, 0xb3, 0xbe, 0x7b, 0xd0, 0xd8, 0xd9, 0x30, 0xf6, 0x9b, 0x7a, 0xb5,
	0x59, 0xdf, 0x78, 0xbb, 0x94, 0x42, 0x39, 0x98, 0xad, 0xed, 0xae, 0xd7, 0xf5, 0x52, 0x9a, 0xf1,
	0xd4, 0x77, 0xde, 0x6a, 0xe8, 0xbb, 0x3b, 0xdb, 0xf5, 0x9d, 0x66, 0x29, 0xb3, 0x96, 0x85, 0x0c,
	0x5b, 0x2b, 0xed, 0x57, 0x29, 0xc8, 0x0a, 0xf3, 0xa0, 0x03, 0x28, 0xb4, 0xdc, 0x9e, 0x43, 0x31,
	0x11, 0xcb, 0xa8, 0x24, 0x72, 0xd7, 0x9a, 0x60, 0x95, 0xcb, 0x97, 0x6f, 0x45, 0x4d, 0x74, 0x04,
	0x4b, 0x96, 0xed, 0x53, 0x62, 0x1f, 0xf2, 0xd1, 0x42, 0x7a, 0x2a, 0x51, 0x75, 0xb7, 0x1e, 0xe3,
	0x97, 0x10, 0x25, 0x6b, 0x80, 0xc6, 0x26, 0x80, 0x4f, 0x29, 0xc1, 0x5d, 0x33, 0xee, 0x87, 0x93,
	0x4e, 0xa0, 0x2e, 0x58, 0x83, 0x09, 0xe0, 0xa8, 0x19, 0x1a, 0xeb, 0x7b, 0x0a, 0x3b, 0xe6, 0xa3,
	0x89, 0x3d, 0x07, 0x79, 0xdb, 0xa1, 0x2f, 0xdd, 0x31, 0xc4, 0x82, 0x32, 0x83, 0xa5, 0x37, 0x67,
	0x74, 0xe0, 0x44, 0x1e, 0x40, 0xd1, 0x75, 0x28, 0x58, 0x3c, 0x9e, 0x1a, 0xd1, 0xa2, 0x2b, 0x4c,
	0xbe, 0x15, 0x45, 0x59, 0x36, 0x88, 0x4d, 0xc5, 0x69, 0xcb, 0x41, 0x4c, 0xf1, 0x1c, 0x1b, 0x24,
	0xa8, 0x7c, 0xd0, 0xda, 0x9c, 0xf4, 0x1b, 0xed, 0x2f, 0x0a, 0xe4, 0x63, 0xca, 0x22, 0x13, 0x4a,
	0xb6, 0x43, 0x8d, 0xbe, 0xa9, 0x8b, 0xb5, 0xfb, 0xc6, 0x84, 0x53, 0x6f, 0x38, 0xb4, 0x7f, 0xf6,
	0x45, 0xbb, 0x8f, 0x82, 0x3e, 0x80, 0x65, 0x39, 0x8b, 0x3e, 0x14, 0xb1, 0x86, 0x77, 0x27, 0x5d,
	0x43, 0x2e, 0xa1, 0x1f, 0x68, 0xc9, 0x1a, 0x24, 0xae, 0xe5, 0x60, 0x4e, 0x82, 0x68, 0x37, 0xa1,
	0xd8, 0xaf, 0x1a, 0x7a, 0x06, 0x98, 0x71, 0x85, 0x99, 0x44, 0xfa, 0x91, 0xd6, 0x73, 0xb6, 0x43,
	0xb9, 0x89, 0x7c, 0xed, 0x2e, 0x2c, 0x0d, 0xa1, 0xb0, 0x93, 0x3d, 0xbe, 0x04, 0xe2, 0x1c, 0x50,
	0xf4, 0x42, 0x6c, 0x05, 0x7c, 0xed, 0xb3, 0x14, 0x94, 0x06, 0x9d, 0x8c, 0x45, 0x38, 0x86, 0x36,
	0xec, 0xbc, 0x4a, 0xa2, 0x08, 0xd7, 0x70, 0xe8, 0x08, 0xff, 0x5d, 0xb6, 0x87, 0xc9, 0xe8, 0x0c,
	0xca, 0x52, 0xd7, 0x71, 0x3b, 0xe6, 0xd5, 0x44, 0xd6, 0x1e, 0x81, 0x7b, 0xc9, 0x1a, 0xd9, 0xb3,
	0x56, 0x84, 0x42, 0x1c, 0x53, 0x33, 0x61, 0x79, 0x84, 0xe2, 0x2c, 0x7c, 0xf1, 0xbd, 0x2d, 0xbc,
	0x5d, 0x17, 0x0d, 0x16, 0xe6, 0xfc, 0x5e, 0x57, 0x1e, 0xf5, 0xec, 0x93, 0x51, 0xba, 0xb6, 0xc3,
	0x5d, 0x39, 0xad, 0xb3, 0x4f, 0x4e, 0x31, 0x4f, 0x79, 0xe8, 0x66, 0x14, 0xf3, 0x54, 0xb3, 0xe0,
	0xd2, 0x68, 0x35, 0x9f, 0x8c, 0xa2, 0x0c, 0xa1, 0x28, 0x43, 0x28, 0x8a, 0x40, 0xf9, 0x32, 0x0d,
	0xcb, 0x23, 0x0e, 0x19, 0x9e, 0x1e, 0xb8, 0x9d, 0x5e, 0xd7, 0x31, 0x1c, 0xb3, 0x2b, 0xbd, 0x29,
	0xc7, 0x22, 0x17, 0xa3, 0xed, 0x30, 0x12, 0x6a, 0xc1, 0x3c, 0x71, 0x4f, 0x02, 0xf3, 0xb3, 0x93,
	0x62, 0x73, 0xfa, 0x53, 0x2d, 0x46, 0xd3, 0xdd, 0x13, 0x7d, 0x8e, 0xb8, 0x27, 0x8c, 0xac, 0xfe,
	0x4e, 0x81, 0xd5, 0xa8, 0xab, 0xc6, 0xe1, 0x45, 0x5c, 0xf8, 0x6f, 0xc6, 0x17, 0x74, 0x1f, 0x72,
	0xe1, 0x85, 0xba, 0x3c, 0x5f, 0xd5, 0xa1, 0xdc, 0xb0, 0x19, 0x8c, 0xd8, 0x9c, 0xd1, 0xa3, 0xe1,
	0x61, 0x6c, 0x52, 0xcf, 0x60, 0xa1, 0x6f, 0x96, 0xe8, 0x7d, 0xc8, 0xc6, 0x36, 0xeb, 0xe4, 0xf5,
	0xf5, 0xf9, 0xf6, 0x8b, 0x19, 0x49, 0x97, 0xf2, 0xb5, 0xcf, 0x97, 0x61, 0x4e, 0xe6, 0x5e, 0xc8,
	0x84, 0xbc, 0x17, 0xbb, 0xb3, 0x11, 0xd0, 0xaf, 0x25, 0x4b, 0xe0, 0x2a, 0x7b, 0x74, 0xe0, 0x92,
	0x26, 0x2e, 0x53, 0xfd, 0x73, 0x1e, 0x20, 0x2a, 0x7d, 0xd1, 0x47, 0x10, 0x5c, 0x8b, 0x61, 0xcb,
	0x90, 0x99, 0x7f, 0x90, 0x39, 0xbe, 0x99, 0x14, 0x38, 0x14, 0x1b, 0x5c, 0x33, 0x60, 0xab, 0x2e,
	0x45, 0xea, 0x4b, 0xde, 0x20, 0x09, 0x7d, 0x08, 0x8b, 0x2c, 0x49, 0x3f, 0xc6, 0x11, 0xb0, 0x88,
	0x15, 0x9b, 0xd3, 0x03, 0x57, 0xb9, 0xc0, 0x10, 0xb5, 0x68, 0xf6, 0xb5, 0x91, 0x0d, 0x10, 0xab,
	0x65, 0xc4, 0x0d, 0x55, 0x63, 0x7a, 0xb4, 0xc1, 0x02, 0x26, 0x26, 0x1c, 0x6d, 0x40, 0xa6, 0xe7,
	0x63, 0x22, 0x0b, 0xa6, 0xdb, 0x09, 0x41, 0x1e, 0xf9, 0x98, 0xe8, 0x5c, 0x80, 0xfa, 0x65, 0x1a,
	0xe6, 0xb7, 0xb1, 0xe9, 0xf7, 0x08, 0xb6, 0xd0, 0x8f, 0x15, 0x58, 0x11, 0xa5, 0x9c, 0xb4, 0x99,
	0xc1, 0x43, 0x4c, 0xe0, 0x2b, 0xef, 0x4c, 0x3f, 0x97, 0x00, 0xa2, 0xd2, 0x60, 0xe2, 0xa5, 0xc5,
	0x78, 0xd6, 0x20, 0x27, 0x87, 0xec, 0xa1, 0x0e, 0xf4, 0x99, 0x02, 0xab, 0xb2, 0x46, 0x1c, 0xd0,
	0x47, 0x84, 0x9d, 0x77, 0x9f, 0x82, 0x3e, 0xa2, 0x70, 0x1b, 0xa1, 0xd0, 0xb2, 0x3b, 0xdc, 0x83,
	0x6e, 0x40, 0x89, 0xba, 0xd4, 0xec, 0x18, 0x6c, 0x97, 0x1b, 0xbe, 0x17, 0x14, 0xb6, 0x8a, 0x5e,
	0xe4, 0x74, 0x16, 0x09, 0xf6, 0x19, 0x55, 0xad, 0xc3, 0xe5, 0x31, 0x53, 0x4d, 0x52, 0x15, 0xaa,
	0x0f, 0xa1, 0x3c, 0x4e, 0xc3, 0x44, 0x72, 0x7c, 0x58, 0x1a, 0xda, 0x35, 0xe8, 0x3d, 0x98, 0xef,
	0x4a, 0x3b, 0xc8, 0x4d, 0xb9, 0x76, 0x71, 0x8b, 0xea, 0xa1, 0x4c, 0xf5, 0xb3, 0x34, 0x14, 0xfb,
	0xb7, 0xcc, 0x7f, 0x1a, 0x12, 0xbd, 0x00, 0x28, 0x2c, 0xe9, 0x59, 0xae, 0x63, 0x3b, 0xb6, 0xd3,
	0x96, 0x67, 0xe3, 0x52, 0xd0, 0xa3, 0x07, 0x1d, 0xe8, 0x17, 0x0a, 0x5c, 0xe9, 0xf7, 0x30, 0x3f,
	0xc6, 0x26, 0x76, 0x30, 0x7e, 0x5a, 0xf1, 0xa2, 0xdf, 0xd7, 0xfc, 0x50, 0x0b, 0xe1, 0x6f, 0x97,
	0xdd, 0xd1, 0xbd, 0xea, 0x1b, 0x70, 0xf5, 0x3c, 0xc6, 0x44, 0x6e, 0xf0, 0x2a, 0x2c, 0x5e, 0xe0,
	0x8e, 0x42, 0xfd, 0xfd, 0x2c, 0x64, 0x58, 0xec, 0x40, 0x06, 0xe4, 0x45, 0xd1, 0xc8, 0xb3, 0x04,
	0xb9, 0x92, 0x0f, 0xa6, 0x88, 0x42, 0xb2, 0xc1, 0x12, 0x0b, 0x1d, 0xba, 0xe1, 0x37, 0xc2, 0x03,
	0x65, 0x97, 0xfc, 0x33, 0xf5, 0xda, 0x34, 0x10, 0xe7, 0x14, 0x61, 0x74, 0x54, 0x11, 0x96, 0xf0,
	0xa7, 0x54, 0x1f, 0xd6, 0x44, 0x25, 0x99, 0x01, 0xd0, 0x36, 0x7b, 0x6d, 0x79, 0x31, 0x20, 0xff,
	0x42, 0xbd, 0x3a, 0x0d, 0xdc, 0x06, 0x13, 0x23, 0x71, 0x72, 0xed, 0xa0, 0xa1, 0x3e, 0x00, 0x88,
	0xec, 0x8a, 0xae, 0x42, 0x8e, 0xe7, 0x72, 0x9e, 0xd9, 0x0a, 0xea, 0xeb, 0x88, 0x10, 0xfe, 0xb0,
	0x4f, 0xc7, 0x7e, 0xd8, 0x5f, 0xef, 0xaf, 0xe8, 0x42, 0x87, 0x50, 0x62, 0x0e, 0xa1, 0xbe, 0x37,
	0xa2, 0x36, 0x78, 0x8a, 0x79, 0xb0, 0xfa, 0x2e, 0xe4, 0xc2, 0xe9, 0x8d, 0x56, 0x01, 0xdd, 0x8d,
	0x67, 0x67, 0xa9, 0x27, 0x65, 0x67, 0xf1, 0xdc, 0x4c, 0x16, 0xaf, 0xea, 0x19, 0x94, 0x06, 0x33,
	0x9a, 0x11, 0x3b, 0x62, 0xb7, 0xff, 0xf2, 0xf8, 0xde, 0xd4, 0x11, 0x21, 0x7e, 0xb1, 0xf1, 0x5b,
	0x05, 0x9e, 0x39, 0xf7, 0x87, 0xe6, 0xff, 0xe4, 0x6d, 0xdb, 0x17, 0x0a, 0x5c, 0x19, 0xfb, 0x83,
	0x7c, 0xaa, 0xbb, 0x36, 0xb4, 0x07, 0xab, 0xf1, 0x6b, 0x58, 0x11, 0x7f, 0x2d, 0x4c, 0xa4, 0xb2,
	0xe7, 0xdf, 0xc5, 0x2e, 0x47, 0x77, 0xb1, 0x7a, 0xc0, 0xa8, 0x5d, 0x05, 0x75, 0xfc, 0xcf, 0x5a,
	0xed, 0x1f, 0x0a, 0xcc, 0x87, 0x07, 0xd2, 0xa6, 0x70, 0x04, 0x99, 0xe1, 0xdc, 0x99, 0xf4, 0x5a,
	0x24, 0x08, 0xe9, 0xcc, 0x39, 0x75, 0xe1, 0x4a, 0x3f, 0x55, 0x20, 0xc3, 0x7d, 0x75, 0x2a, 0x23,
	0x44, 0x6f, 0x63, 0x52, 0x89, 0x6e, 0xf1, 0xfa, 0xdf, 0xc6, 0xb0, 0xdd, 0x1c, 0xde, 0xf2, 0x14,
	0x84, 0x62, 0xda, 0x17, 0x69, 0x28, 0xec, 0x53, 0x93, 0x86, 0x37, 0xca, 0x83, 0xff, 0x72, 0xc7,
	0x2a, 0x9c, 0x3a, 0x47, 0xe1, 0x2d, 0xc8, 0x89, 0x7f, 0x76, 0x6c, 0xaf, 0x88, 0x4b, 0xa5, 0x9b,
	0x13, 0xea, 0xcc, 0x95, 0x79, 0x13, 0x9f, 0xe9, 0xf3, 0xbe, 0xfc, 0x42, 0x6f, 0x42, 0x9a, 0xcd,
	0x3d, 0xe1, 0x9b, 0x17, 0x2e, 0x68, 0x03, 0xc7, 0xde, 0x67, 0x30, 0x29, 0xa8, 0x09, 0x59, 0xd3,
	0xf3, 0xb0, 0x63, 0x05, 0xc7, 0xc6, 0xbd, 0x24, 0xf2, 0xaa, 0x9c, 0x35, 0x12, 0x29, 0x65, 0xa1,
	0x6f, 0xc1, 0x6c, 0xab, 0x83, 0x4d, 0x12, 0x9c, 0x0f, 0x77, 0x93, 0x08, 0xad, 0x31, 0xce, 0x48,
	0xa6, 0x90, 0x14, 0x7f, 0x39, 0xf2, 0xa7, 0x14, 0x2c, 0xc8, 0x45, 0x92, 0xbb, 0x7f, 0x70, 0x95,
	0x46, 0x3f, 0x0e, 0x79, 0x16, 0xf2, 0xb1, 0xeb, 0x7c, 0xb9, 0xee, 0x10, 0xdd, 0xe6, 0xa3, 0xad,
	0x3e, 0xcb, 0xbe, 0x9c, 0xd8, 0xb2, 0xe1, 0x0b, 0x07, 0x6e, 0xda, 0x47, 0x83, 0xa6, 0xbd, 0x3f,
	0x8d, 0x69, 0x43, 0x99, 0x81, 0x6d, 0xf5, 0x01, 0xdb, 0xde, 0x9b, 0xc2, 0xb6, 0xa1, 0x50, 0x69,
	0xdc, 0xf8, 0xeb, 0x8b, 0xaf, 0x32, 0x30, 0x1f, 0x78, 0x1d, 0xda, 0x83, 0xac, 0x78, 0x57, 0x27,
	0xa3, 0xea, 0x4b, 0x09, 0xdd, 0xb6, 0xa2, 0x73, 0x6e, 0xa6, 0xbe, 0x90, 0x83, 0x7c, 0x58, 0xee,
	0xf6, 0x3a, 0xd4, 0xee, 0x9a, 0x9e, 0xe1, 0xdb, 0x16, 0x36, 0x78, 0x31, 0x23, 0x77, 0x72, 0x35,
	0xa9, 0xf8, 0x6d, 0x29, 0x6a, 0xdf, 0xb6, 0x30, 0xaf, 0x21, 0x36, 0x67, 0xf4, 0xa5, 0xee, 0x20,
	0x11, 0x59, 0x50, 0x3c, 0x34, 0xdb, 0x06, 0xab, 0xe2, 0x0c, 0xbe, 0x8f, 0xe4, 0x2e, 0x7c, 0x25,
	0x29, 0xde, 0x9a, 0xd9, 0x66, 0xc9, 0x04, 0x6f, 0x6f, 0xce, 0xe8, 0x85, 0xc3, 0x58, 0x5b, 0x55,
	0x21, 0x2b, 0xa6, 0x1b, 0x3f, 0x16, 0x0b, 0xfc, 0x58, 0x54, 0x3f, 0x55, 0x60, 0x69, 0x48, 0xd9,
	0xc9, 0xfe, 0x19, 0x6a, 0xb0, 0x10, 0x19, 0x2a, 0xfa, 0x71, 0x98, 0xf7, 0x03, 0x31, 0x0d, 0x0b,
	0x5d, 0x82, 0xac, 0x78, 0x06, 0x21, 0xbd, 0x5a, 0xb6, 0x02, 0x45, 0x32, 0x91, 0x22, 0x9f, 0x28,
	0x50, 0x88, 0xcf, 0x62, 0x62, 0x1d, 0x22, 0xe3, 0xc5, 0x74, 0xe8, 0x05, 0x62, 0x92, 0xe8, 0xc0,
	0x32, 0x0a, 0x7a, 0xe6, 0x61, 0xed, 0x75, 0x58, 0x1c, 0x08, 0x4b, 0xac, 0x28, 0x69, 0xb9, 0x0e,
	0xb5, 0x9d, 0x1e, 0xff, 0x3f, 0x29, 0xb7, 0xaa, 0x30, 0xe4, 0x52, 0xbc, 0x87, 0xef, 0x58, 0xed,
	0x11, 0x94, 0x06, 0xb7, 0x5f, 0x42, 0x11, 0xe1, 0x31, 0x90, 0x8a, 0x1d, 0x03, 0x37, 0x00, 0x0d,
	0xc7, 0xb7, 0x70, 0xa4, 0x12, 0x1b, 0xb9, 0x0a, 0xcb, 0x23, 0xb6, 0xab, 0xb6, 0x0c, 0x4b, 0x43,
	0xb1, 0x4c, 0x5b, 0x91, 0x52, 0xfb, 0x36, 0xa1, 0xf6, 0x87, 0x0c, 0xcc, 0x6f, 0xb9, 0xb2, 0x40,
	0x79, 0x1b, 0xe6, 0x7d, 0x7c, 0x8c, 0x89, 0x4d, 0x85, 0xf7, 0x14, 0x27, 0xce, 0x75, 0x03, 0x11,
	0x95, 0x7d, 0xc9, 0x5f, 0xa9, 0x3b, 0xbd, 0xae, 0x1e, 0x8a, 0x9b, 0x3e, 0x01, 0x44, 0x65, 0x96,
	0x5b, 0xf9, 0xbe, 0xd9, 0x0e, 0x32, 0xdf, 0xa0, 0xc9, 0xe2, 0x2c, 0x25, 0x2c, 0x55, 0xce, 0x88,
	0x38, 0xcb, 0x1b, 0xe3, 0xcf, 0xc8, 0xd9, 0x73, 0xce, 0xc8, 0x27, 0x3e, 0xa8, 0xcd, 0x3e, 0xf9,
	0x41, 0xed, 0x73, 0x50, 0xe8, 0xb8, 0x6d, 0xa3, 0xe3, 0x8a, 0x9f, 0xdb, 0xfc, 0x2d, 0x4c, 0x4e,
	0xcf, 0x77, 0xdc, 0xf6, 0x96, 0x24, 0x31, 0x27, 0xa5, 0xef, 0x13, 0x6c, 0x5a, 0xe5, 0x79, 0xde,
	0x29, 0x5b, 0xea, 0xb7, 0xe5, 0xbb, 0xdb, 0x3d, 0x60, 0xc3, 0x0d, 0xec, 0x50, 0x62, 0x87, 0x77,
	0x8e, 0x37, 0x13, 0xae, 0x81, 0x0e, 0x1d, 0xf1, 0x65, 0x63, 0x5f, 0x25, 0x30, 0x1f, 0x2c, 0x89,
	0x76, 0x04, 0x19, 0xb6, 0x2a, 0x68, 0x11, 0xf2, 0x8f, 0x76, 0xf6, 0xf7, 0xea, 0xb5, 0xc6, 0xc3,
	0x46, 0x7d, 0xbd, 0x34, 0x83, 0x72, 0x30, 0xdb, 0xd4, 0xab, 0xb5, 0x7a, 0x49, 0x61, 0x9f, 0xeb,
	0xf5, 0xb5, 0x47, 0x1b, 0xa5, 0x14, 0x9a, 0x87, 0x4c, 0x63, 0xe7, 0xe1, 0x6e, 0x29, 0x8d, 0x00,
	0xb2, 0x3b, 0xbb, 0xcd, 0x46, 0xad, 0x5e, 0xca, 0x30, 0xea, 0x41, 0x55, 0xdf, 0x29, 0xcd, 0xb2,
	0xa1, 0x75, 0x5d, 0xdf, 0xd5, 0x4b, 0x59, 0x54, 0x80, 0xf9, 0x9a, 0xde, 0x68, 0x36, 0x6a, 0xd5,
	0xad, 0xd2, 0x9c, 0x56, 0x00, 0xd8, 0x72, 0xdb, 0x35, 0xd7, 0xa1, 0xc4, 0xed, 0xdc, 0xfa, 0x5c,
	0x81, 0x85, 0x35, 0x6c, 0x76, 0x1f, 0x3a, 0x92, 0x82, 0x3e, 0x55, 0x60, 0x2e, 0xf8, 0x9e, 0xfc,
	0x27, 0xc4, 0xd0, 0x5b, 0x4d, 0xf5, 0xde, 0x34, 0xbc, 0x62, 0x33, 0xcc, 0xdc, 0x50, 0xbe, 0xae,
	0xdc, 0xfa, 0x18, 0x40, 0x68, 0xc6, 0xb3, 0x41, 0x47, 0x66, 0x85, 0x37, 0x13, 0xa6, 0x96, 0x6a,
	0x52, 0x06, 0x89, 0xfe, 0x7d, 0x05, 0xf2, 0x02, 0x5e, 0x84, 0xc2, 0x53, 0x98, 0x15, 0x1f, 0xb7,
	0x93, 0x9c, 0x0b, 0x72, 0x46, 0xea, 0x9d, 0x64, 0x4c, 0x72, 0xfb, 0x0b, 0x4d, 0x7e, 0x18, 0x2e,
	0xd1, 0x96, 0xdb, 0x6e, 0xdb, 0x4e, 0x1b, 0x9d, 0xc2, 0x5c, 0xf0, 0x79, 0x27, 0x69, 0x08, 0x60,
	0x9e, 0xac, 0xbe, 0x38, 0x39, 0x97, 0x74, 0x05, 0xa1, 0xcb, 0x5a, 0x15, 0xbe, 0x36, 0x8e, 0x33,
	0xce, 0xb8, 0x96, 0x13, 0x0a, 0x57, 0x3d, 0xfb, 0x9d, 0x62, 0xac, 0xcb, 0x38, 0x7e, 0xf1, 0x30,
	0xcb, 0x03, 0xca, 0xed, 0x7f, 0x07, 0x00, 0x00, 0xff, 0xff, 0x46, 0x47, 0xa1, 0x3b, 0xd4, 0x2f,
	0x00, 0x00,
}
