/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp.bigquery;

import com.google.api.services.bigquery.model.ExternalCatalogTableOptions;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.BaseMetastoreTableOperations;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.gcp.bigquery.BigQueryClient;
import org.apache.iceberg.gcp.bigquery.BigQueryMetastoreUtils;
import org.apache.iceberg.io.FileIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BigQueryTableOperations
extends BaseMetastoreTableOperations {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryTableOperations.class);
    public static final String TABLE_PROPERTIES_BQ_CONNECTION = "bq_connection";
    private final BigQueryClient client;
    private final FileIO fileIO;
    private final TableReference tableReference;

    BigQueryTableOperations(BigQueryClient client, FileIO fileIO, String project, String dataset, String table) {
        this.client = client;
        this.fileIO = fileIO;
        this.tableReference = new TableReference().setProjectId(project).setDatasetId(dataset).setTableId(table);
    }

    public void doRefresh() {
        String metadataLocation;
        block2: {
            metadataLocation = null;
            try {
                metadataLocation = this.getMetadataLocationOrThrow(this.client.getTable(this.tableReference).getExternalCatalogTableOptions());
            }
            catch (NoSuchTableException e) {
                if (this.currentMetadataLocation() == null) break block2;
                throw e;
            }
        }
        this.refreshFromMetadataLocation(metadataLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCommit(TableMetadata base, TableMetadata metadata) {
        String newMetadataLocation = base == null && metadata.metadataFileLocation() != null ? metadata.metadataFileLocation() : this.writeNewMetadata(metadata, this.currentVersion() + 1);
        BaseMetastoreTableOperations.CommitStatus commitStatus = BaseMetastoreTableOperations.CommitStatus.FAILURE;
        try {
            if (base == null) {
                this.createTable(newMetadataLocation, metadata);
            } else {
                this.updateTable(base.metadataFileLocation(), newMetadataLocation, metadata);
            }
            commitStatus = BaseMetastoreTableOperations.CommitStatus.SUCCESS;
        }
        catch (CommitFailedException | CommitStateUnknownException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error("Exception thrown on commit: ", e);
            commitStatus = this.checkCommitStatus(newMetadataLocation, metadata);
            if (commitStatus == BaseMetastoreTableOperations.CommitStatus.FAILURE) {
                throw new CommitFailedException(e, "Failed to commit", new Object[0]);
            }
            if (commitStatus == BaseMetastoreTableOperations.CommitStatus.UNKNOWN) {
                throw new CommitStateUnknownException(e);
            }
        }
        finally {
            try {
                if (commitStatus == BaseMetastoreTableOperations.CommitStatus.FAILURE) {
                    LOG.warn("Failed to commit updates to table {}", (Object)this.tableName());
                    this.io().deleteFile(newMetadataLocation);
                }
            }
            catch (RuntimeException e) {
                LOG.error("Failed to cleanup metadata file at {} for table {}", (Object)newMetadataLocation, (Object)e);
            }
        }
    }

    public String tableName() {
        return String.format("%s.%s", this.tableReference.getDatasetId(), this.tableReference.getTableId());
    }

    public FileIO io() {
        return this.fileIO;
    }

    private void createTable(String newMetadataLocation, TableMetadata metadata) {
        LOG.debug("Creating a new Iceberg table: {}", (Object)this.tableName());
        Table tableBuilder = this.makeNewTable(metadata, newMetadataLocation);
        tableBuilder.setTableReference(this.tableReference);
        this.addConnectionIfProvided(tableBuilder, metadata.properties());
        this.client.createTable(tableBuilder);
    }

    private void addConnectionIfProvided(Table tableBuilder, Map<String, String> metadataProperties) {
        if (metadataProperties.containsKey(TABLE_PROPERTIES_BQ_CONNECTION)) {
            tableBuilder.getExternalCatalogTableOptions().setConnectionId(metadataProperties.get(TABLE_PROPERTIES_BQ_CONNECTION));
        }
    }

    private void updateTable(String oldMetadataLocation, String newMetadataLocation, TableMetadata metadata) {
        Table table = this.client.getTable(this.tableReference);
        if (table.getEtag().isEmpty()) {
            throw new ValidationException("Etag of legacy table %s is empty, manually update the table via the BigQuery API or recreate and retry", new Object[]{this.tableName()});
        }
        ExternalCatalogTableOptions options = table.getExternalCatalogTableOptions();
        this.addConnectionIfProvided(table, metadata.properties());
        String metadataLocationFromMetastore = options.getParameters().getOrDefault("metadata_location", "");
        if (!metadataLocationFromMetastore.isEmpty() && !metadataLocationFromMetastore.equals(oldMetadataLocation)) {
            throw new CommitFailedException("Base metadata location '%s' is not same as the current table metadata location '%s' for %s.%s", new Object[]{oldMetadataLocation, metadataLocationFromMetastore, this.tableReference.getDatasetId(), this.tableReference.getTableId()});
        }
        options.setParameters(this.buildTableParameters(newMetadataLocation, metadata));
        try {
            this.client.patchTable(this.tableReference, table);
        }
        catch (ValidationException e) {
            if (e.getMessage().toLowerCase().contains("etag mismatch")) {
                throw new CommitFailedException("Updating table failed due to conflict updates (etag mismatch). Retry the update", new Object[0]);
            }
            throw e;
        }
    }

    private Table makeNewTable(TableMetadata metadata, String metadataFileLocation) {
        return new Table().setExternalCatalogTableOptions(BigQueryMetastoreUtils.createExternalCatalogTableOptions(metadata.location(), this.buildTableParameters(metadataFileLocation, metadata)));
    }

    private Map<String, String> buildTableParameters(String metadataFileLocation, TableMetadata metadata) {
        HashMap<String, String> parameters = new HashMap<String, String>(metadata.properties());
        if (metadata.uuid() != null) {
            parameters.put("uuid", metadata.uuid());
        }
        if (this.currentMetadataLocation() != null && !this.currentMetadataLocation().isEmpty()) {
            parameters.put("previous_metadata_location", this.currentMetadataLocation());
        }
        parameters.put("metadata_location", metadataFileLocation);
        parameters.put("table_type", "iceberg");
        parameters.put("EXTERNAL", "TRUE");
        BigQueryTableOperations.updateParametersWithSnapshotMetadata(metadata, parameters);
        return parameters;
    }

    private static void updateParametersWithSnapshotMetadata(TableMetadata metadata, Map<String, String> parameters) {
        if (metadata.currentSnapshot() == null) {
            return;
        }
        Map summary = metadata.currentSnapshot().summary();
        if (summary.get("total-data-files") != null) {
            parameters.put("numFiles", (String)summary.get("total-data-files"));
        }
        if (summary.get("total-records") != null) {
            parameters.put("numRows", (String)summary.get("total-records"));
        }
        if (summary.get("total-files-size") != null) {
            parameters.put("totalSize", (String)summary.get("total-files-size"));
        }
    }

    private String getMetadataLocationOrThrow(ExternalCatalogTableOptions tableOptions) {
        if (tableOptions == null || !tableOptions.getParameters().containsKey("metadata_location")) {
            throw new ValidationException("Table %s is not a valid BigQuery Metastore Iceberg table, metadata location not found", new Object[]{this.tableName()});
        }
        return tableOptions.getParameters().get("metadata_location");
    }
}

