/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.beam.sdk.util.construction;

import java.util.function.Predicate;

/** A utility class to interact with synthetic pipeline components. */
public class SyntheticComponents {
  private SyntheticComponents() {}

  /**
   * Generate an ID which does not collide with any existing ID, as determined by the input
   * predicate.
   *
   * <p>The returned ID will be in the form "${baseName}:${number}".
   */
  public static String uniqueId(String baseName, Predicate<String> existingIds) {
    int i = 0;
    String name;
    do {
      name = String.format("%s:%s", baseName, i);
      i++;
    } while (existingIds.test(name));
    return name;
  }
}
