<!--
    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.
-->

> **PLEASE update this file if you add new job or change name/trigger phrase in groovy files.**

## Beam Jenkins

Beam Jenkins overview page: [link](https://ci-beam.apache.org/)

### PreCommit Jobs

| Name | Link | PR Trigger Phrase | Cron Status |
|------|------|-------------------|-------------|
| beam_PreCommit_CommunityMetrics | [commit](https://ci-beam.apache.org/job/beam_PreCommit_CommunityMetrics_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_CommunityMetrics_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_CommunityMetrics_Phrase/) | `Run CommunityMetrics PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_CommunityMetrics_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_CommunityMetrics_Cron) |
| beam_PreCommit_Go | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Go_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Go_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Go_Phrase/) | `Run Go PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Go_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Go_Cron) |
| beam_PreCommit_Java | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Phrase/) | `Run Java PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Cron) |
| beam_PreCommit_Java_Examples_Dataflow | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Examples_Dataflow_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Examples_Dataflow_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Examples_Dataflow_Phrase/) | `Run Java_Examples_Dataflow PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Examples_Dataflow_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Examples_Dataflow_Cron) |
| beam_PreCommit_Java_Examples_Dataflow_Java11 | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Examples_Dataflow_Java11_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Examples_Dataflow_Java11_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Examples_Dataflow_Java11_Phrase/) | `Run Java_Examples_Dataflow_Java11 PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Examples_Dataflow_Java11_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Examples_Dataflow_Java11_Cron/) |
| beam_PreCommit_Java_Amazon-Web-Services_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Amazon-Web-Services_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Amazon-Web-Services_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Amazon-Web-Services_IO_Direct_Phrase/) | `Run Java_Amazon-Web-Services_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Amazon-Web-Services_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Amazon-Web-Services_IO_Direct_Cron/) |
| beam_PreCommit_Java_Amazon-Web-Services2_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Amazon-Web-Services2_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Amazon-Web-Services2_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Amazon-Web-Services2_IO_Direct_Phrase/) | `Run Java_Amazon-Web-Services2_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Amazon-Web-Services2_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Amazon-Web-Services2_IO_Direct_Cron/) |
| beam_PreCommit_Java_Amqp_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Amqp_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Amqp_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Amqp_IO_Direct_Phrase/) | `Run Java_Amqp_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Amqp_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Amqp_IO_Direct_Cron/) |
| beam_PreCommit_Java_Azure_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Azure_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Azure_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Azure_IO_Direct_Phrase/) | `Run Java_Azure_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Azure_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Azure_IO_Direct_Cron/) |
| beam_PreCommit_Java_Cassandra_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Cassandra_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Cassandra_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Cassandra_IO_Direct_Phrase/) | `Run Java_Cassandra_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Cassandra_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Cassandra_IO_Direct_Cron/) |
| beam_PreCommit_Java_Cdap_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Cdap_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Cdap_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Cdap_IO_Direct_Phrase/) | `Run Java_Cdap_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Cdap_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Cdap_IO_Direct_Cron/) |
| beam_PreCommit_Java_Clickhouse_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Clickhouse_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Clickhouse_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Clickhouse_IO_Direct_Phrase/) | `Run Java_Clickhouse_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Clickhouse_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Clickhouse_IO_Direct_Cron/) |
| beam_PreCommit_Java_Csv_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Csv_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Csv_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Csv_IO_Direct_Phrase/) | `Run Java_Csv_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Csv_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Csv_IO_Direct_Cron/) |
| beam_PreCommit_Java_Debezium_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Debezium_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Debezium_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Debezium_IO_Direct_Phrase/) | `Run Java_Debezium_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Debezium_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Debezium_IO_Direct_Cron/) |
| beam_PreCommit_Java_ElasticSearch_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_ElasticSearch_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_ElasticSearch_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_ElasticSearch_IO_Direct_Phrase/) | `Run Java_ElasticSearch_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_ElasticSearch_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_ElasticSearch_IO_Direct_Cron/) |
| beam_PreCommit_Java_File-schema-transform_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_File-schema-transform_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_File-schema-transform_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_File-schema-transform_IO_Direct_Phrase/) | `Run Java_File-schema-transform_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_File-schema-transform_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_File-schema-transform_IO_Direct_Cron/) |
| beam_PreCommit_Java_GCP_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_GCP_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_GCP_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_GCP_IO_Direct_Phrase/) | `Run Java_GCP_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_GCP_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_GCP_IO_Direct_Cron/) |
| beam_PreCommit_Java_Hadoop_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Hadoop_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Hadoop_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Hadoop_IO_Direct_Phrase/) | `Run Java_Hadoop_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Hadoop_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Hadoop_IO_Direct_Cron/) |
| beam_PreCommit_Java_HBase_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_HBase_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_HBase_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_HBase_IO_Direct_Phrase/) | `Run Java_HBase_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_HBase_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_HBase_IO_Direct_Cron/) |
| beam_PreCommit_Java_HCatalog_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_HCatalog_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_HCatalog_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_HCatalog_IO_Direct_Phrase/) | `Run Java_HCatalog_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_HCatalog_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_HCatalog_IO_Direct_Cron/) |
| beam_PreCommit_Java_InfluxDb_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_InfluxDb_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_InfluxDb_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_InfluxDb_IO_Direct_Phrase/) | `Run Java_InfluxDb_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_InfluxDb_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_InfluxDb_IO_Direct_Cron/) |
| beam_PreCommit_Java_JDBC_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_JDBC_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_JDBC_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_JDBC_IO_Direct_Phrase/) | `Run Java_JDBC_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_JDBC_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_JDBC_IO_Direct_Cron/) |
| beam_PreCommit_Java_Jms_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Jms_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Jms_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Jms_IO_Direct_Phrase/) | `Run Java_Jms_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Jms_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Jms_IO_Direct_Cron/) |
| beam_PreCommit_Java_Kafka_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Kafka_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Kafka_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Kafka_IO_Direct_Phrase/) | `Run Java_Kafka_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Kafka_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Kafka_IO_Direct_Cron/) |
| beam_PreCommit_Java_Kinesis_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Kinesis_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Kinesis_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Kinesis_IO_Direct_Phrase/) | `Run Java_Kinesis_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Kinesis_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Kinesis_IO_Direct_Cron/) |
| beam_PreCommit_Java_Kudu_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Kudu_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Kudu_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Kudu_IO_Direct_Phrase/) | `Run Java__Kudu_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Kudu_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Kudu_IO_Direct_Cron/) |
| beam_PreCommit_Java_MongoDb_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_MongoDb_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_MongoDb_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_MongoDb_IO_Direct_Phrase/) | `Run Java_MongoDb_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_MongoDb_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_MongoDb_IO_Direct_Cron/) |
| beam_PreCommit_Java_Mqtt_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Mqtt_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Mqtt_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Mqtt_IO_Direct_Phrase/) | `Run Java_Mqtt_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Mqtt_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Mqtt_IO_Direct_Cron/) |
| beam_PreCommit_Java_Neo4j_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Neo4j_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Neo4j_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Neo4j_IO_Direct_Phrase/) | `Run Java_Neo4j_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Neo4j_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Neo4j_IO_Direct_Cron/) |
| beam_PreCommit_Java_Parquet_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Parquet_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Parquet_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Parquet_IO_Direct_Phrase/) | `Run Java_Parquet_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Parquet_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Parquet_IO_Direct_Cron/) |
| beam_PreCommit_Java_Pulsar_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Pulsar_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Pulsar_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Pulsar_IO_Direct_Phrase/) | `Run Java_Pulsar_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Pulsar_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Pulsar_IO_Direct_Cron/) |
| beam_PreCommit_Java_RabbitMq_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_RabbitMq_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_RabbitMq_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_RabbitMq_IO_Direct_Phrase/) | `Run Java_RabbitMq_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_RabbitMq_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_RabbitMq_IO_Direct_Cron/) |
| beam_PreCommit_Java_Redis_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Redis_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Redis_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Redis_IO_Direct_Phrase/) | `Run Java_Redis_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Redis_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Redis_IO_Direct_Cron/) |
| beam_PreCommit_Java_SingleStore_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_SingleStore_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_SingleStore_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_SingleStore_IO_Direct_Phrase/) | `Run Java_SingleStore_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_SingleStore_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_SingleStore_IO_Direct_Cron/) |
| beam_PreCommit_Java_Snowflake_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Snowflake_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Snowflake_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Snowflake_IO_Direct_Phrase/) | `Run Java_Snowflake_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Snowflake_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Snowflake_IO_Direct_Cron/) |
| beam_PreCommit_Java_Solr_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Solr_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Solr_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Solr_IO_Direct_Phrase/) | `Run Java_Solr_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Solr_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Solr_IO_Direct_Cron/) |
| beam_PreCommit_Java_Splunk_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Splunk_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Splunk_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Splunk_IO_Direct_Phrase/) | `Run Java_Splunk_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Splunk_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Splunk_IO_Direct_Cron/) |
| beam_PreCommit_Java_Thrift_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Thrift_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Thrift_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Thrift_IO_Direct_Phrase/) | `Run Java_Thrift_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Thrift_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Thrift_IO_Direct_Cron/) |
| beam_PreCommit_Java_Tika_IO_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_Tika_IO_Direct_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Java_Tika_IO_Direct_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_Tika_IO_Direct_Phrase/) | `Run Java_Tika_IO_Direct PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Java_Tika_IO_Direct_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Java_Tika_IO_Direct_Cron/) |
| beam_PreCommit_Java_IOs_Direct | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Java_IOs_Direct_Commit/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Java_IOs_Direct_Phrase/) | `Run Java_IOs_Direct PreCommit` | |
| beam_PreCommit_Portable_Python | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Portable_Python_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Portable_Python_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Portable_Python_Phrase/) | `Run Portable_Python PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Portable_Python_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Portable_Python_Cron) |
| beam_PreCommit_PythonLint | [commit](https://ci-beam.apache.org/job/beam_PreCommit_PythonLint_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_PythonLint_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_PythonLint_Phrase/) | `Run PythonLint PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_PythonLint_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_PythonLint_Cron) |
| beam_PreCommit_Python | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Python_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Python_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Python_Phrase/) | `Run Python PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Python_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Python_Cron) |
| beam_PreCommit_Python_Integration | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Python_Integration_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Python_Integration_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Python_Integration_Phrase/) | `Run Python_Integration PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Python_Integration_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Python_Integration_Cron) |
| beam_PreCommit_Python_Dataframes | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Python_Dataframes_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Python_Dataframes_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Python_Dataframes_Phrase/) | `Run Python_Dataframes PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Python_Dataframes_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Python_Dataframes_Cron) |
| beam_PreCommit_Python_Examples | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Python_Examples_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Python_Examples_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Python_Examples_Phrase/) | `Run Python_Examples PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Python_Examples_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Python_Examples_Cron) |
| beam_PreCommit_Python_Runners | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Python_Runners_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Python_Runners_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Python_Runners_Phrase/) | `Run Python_Runners PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Python_Runners_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Python_Runners_Cron) |
| beam_PreCommit_Python_Transforms | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Python_Transforms_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Python_Transforms_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Python_Transforms_Phrase/) | `Run Python_Transforms PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Python_Transforms_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Python_Transforms_Cron) |
| beam_PreCommit_Python_Coverage | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Python_Coverage_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Python_Coverage_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Python_Coverage_Phrase/) | `Run Python_Coverage PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Python_Coverage_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Python_Coverage_Cron) |
| beam_PreCommit_PythonDocker | [commit](https://ci-beam.apache.org/job/beam_PreCommit_PythonDocker_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_PythonDocker_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_PythonDocker_Phrase/) | `Run PythonDocker PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_PythonDocker_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_PythonDocker_Cron/) |
| beam_PreCommit_PythonDocs| [commit](https://ci-beam.apache.org/job/beam_PreCommit_PythonDocs_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_PythonDocs_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_PythonDocs_Phrase/) | `Run PythonDocs PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_PythonDocs_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_PythonDocs_Cron/) |
| beam_PreCommit_Python_PVR_Flink | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Python_PVR_Flink_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Python_PVR_Flink_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Python_PVR_Flink_Phrase/) | `Run Python_PVR_Flink PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Python_PVR_Flink_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Python_PVR_Flink_Cron) |
| beam_PreCommit_PythonFormatter | [commit](https://ci-beam.apache.org/job/beam_PreCommit_PythonFormatter_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_PythonFormatter_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_PythonFormatter_Phrase/) | `Run PythonFormatter PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_PythonFormatter_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_PythonFormatter_Cron/) |
| beam_PreCommit_RAT (checks for valid Apache license headers) | [commit](https://ci-beam.apache.org/job/beam_PreCommit_RAT_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_RAT_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_RAT_Phrase/) | `Run RAT PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_RAT_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_RAT_Cron) |
| beam_PreCommit_Spotless | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Spotless_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Spotless_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Spotless_Phrase/) | `Run Spotless PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Spotless_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Spotless_Cron) |
| beam_PreCommit_SQL | [commit](https://ci-beam.apache.org/job/beam_PreCommit_SQL_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_SQL_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_SQL_Phrase/) | `Run SQL PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_SQL_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_SQL_Cron/) |
| beam_PreCommit_SQL_Java11 | [commit](https://ci-beam.apache.org/job/beam_PreCommit_SQL_Java11_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_SQL_Java11_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_SQL_Java11_Phrase/) | `Run SQL_Java11 PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_SQL_Java11_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_SQL_Java11_Cron/) |
| beam_PreCommit_Website | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Website_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Website_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Website_Phrase/) | `Run Website PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Website_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Website_Cron) |
| beam_PreCommit_Website_Stage_GCS | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Website_Stage_GCS_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Website_Stage_GCS_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Website_Stage_GCS_Phrase/) | `Run Website_Stage_GCS PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Website_Stage_GCS_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Website_Stage_GCS_Cron) |
| beam_PreCommit_Whitespace | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Whitespace_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Whitespace_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Whitespace_Phrase/) | `Run Whitespace PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Whitespace_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Whitespace_Cron) |
| beam_PreCommit_Typescript | [commit](https://ci-beam.apache.org/job/beam_PreCommit_Typescript_Commit/), [cron](https://ci-beam.apache.org/job/beam_PreCommit_Typescript_Cron/), [phrase](https://ci-beam.apache.org/job/beam_PreCommit_Typescript_Phrase/) | `Run Typescript PreCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PreCommit_Typescript_Cron/badge/icon)](https://ci-beam.apache.org/job/beam_PreCommit_Typescript_Cron) |

### PostCommit Jobs

| Name | Link | PR Trigger Phrase | Cron Status |
|------|------|-------------------|-------------|
| beam_PostCommit_BeamMetrics_Publish | [cron](https://ci-beam.apache.org/job/beam_PostCommit_BeamMetrics_Publish/) | N/A | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_BeamMetrics_Publish/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_BeamMetrics_Publish) |
| beam_PostCommit_XVR_Flink | [cron](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Flink/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Flink_PR/) | `Run XVR_Flink PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Flink/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Flink) |
| beam_PostCommit_XVR_Samza | [cron](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Samza/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Samza_PR/) | `Run XVR_Samza PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Samza/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Samza) |
| beam_PostCommit_XVR_Spark | [cron](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Spark/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Spark_PR/) | `Run XVR_Spark PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Spark/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Spark) |
| beam_PostCommit_XVR_Spark3 | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_XVR_Spark3/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_XVR_Spark3_PR) | `Run XVR_Spark3 PostCommit` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_XVR_Spark3/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_XVR_Spark3/) |
| beam_PostCommit_XVR_Direct | [cron](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Direct/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Direct_PR/) | `Run XVR_Direct PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Direct/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_XVR_Direct) |
| beam_PostCommit_XVR_Dataflow | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_XVR_Dataflow/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_XVR_Dataflow_PR/) | `Run XVR_Dataflow PostCommit` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_XVR_Dataflow/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_XVR_Dataflow/) |
| beam_PostCommit_Go | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Go/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Go_PR/) | `Run Go PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Go/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Go) |
| beam_PostCommit_Go_VR_Flink | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Flink/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Flink_PR/) | `Run Go Flink ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Flink/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Flink/) |
| beam_PostCommit_Go_VR_Samza | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Samza/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Samza_PR/) | `Run Go Samza ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Samza/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Samza/) |
| beam_PostCommit_Go_VR_Spark | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Spark/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Spark_PR/) | `Run Go Spark ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Spark/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Go_VR_Spark/) |
| beam_PostCommit_Java_Hadoop_Versions | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Hadoop_Versions/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Hadoop_Versions_PR/) | `Run PostCommit_Java_Hadoop_Versions` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Hadoop_Versions/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Hadoop_Versions/) |
| beam_PostCommit_Java | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_PR/) | `Run Java PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java) |
| beam_PostCommit_Java_DataflowV1 | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_DataflowV1/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_DataflowV1_PR/) | `Run PostCommit_Java_Dataflow` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_DataflowV1/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_DataflowV1/) |
| beam_PostCommit_Java_DataflowV2 | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_DataflowV2/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_DataflowV2_PR/) | `Run PostCommit_Java_DataflowV2` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_DataflowV2/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_DataflowV2/) |
| beam_PostCommit_Java_InfluxDbIO_IT | [cron](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PostCommit_Java_InfluxDbIO_IT/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_SingleStoreIO_IT_PR/) | `Run Java InfluxDbIO_IT` | [![Build Status](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PostCommit_Java_InfluxDbIO_IT/badge/icon)](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PostCommit_Java_InfluxDbIO_IT/) |
| beam_PostCommit_Java_Nexmark_Dataflow | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Dataflow/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Dataflow_PR/) | `Dataflow Runner Nexmark Tests` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Dataflow/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Dataflow) |
| beam_PostCommit_Java_Nexmark_Dataflow_V2 | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Nexmark_Dataflow_V2/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Nexmark_DataflowV2_PR/) | `Run Dataflow Runner V2 Nexmark Tests` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Nexmark_Dataflow_V2/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Nexmark_Dataflow_V2/) |
| beam_PostCommit_Java_Nexmark_Dataflow_V2_Java11 | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Nexmark_Dataflow_V2_Java11/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Nexmark_Dataflow_V2_Java11/badge/icon) | `Dataflow Runner V2 Java 11 Nexmark Tests` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Nexmark_Dataflow_V2_Java11/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Nexmark_Dataflow_V2_Java11/) |
| beam_PostCommit_Java_Nexmark_Direct | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Direct/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Direct_PR/) | `Direct Runner Nexmark Tests` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Direct/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Direct) |
| beam_PostCommit_Java_Nexmark_Flink | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Flink/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Flink_PR/) | `Flink Runner Nexmark Tests` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Flink/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Flink) |
| beam_PostCommit_Java_Nexmark_Spark | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Spark/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Spark_PR/) | `Spark Runner Nexmark Tests` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Spark/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Nexmark_Spark) |
| beam_PostCommit_Java_PVR_Flink_Batch | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Flink_Batch/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Flink_Batch_PR/) | `Run Java Flink PortableValidatesRunner Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Flink_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Flink_Batch) |
| beam_PostCommit_Java_PVR_Flink_Streaming | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Flink_Streaming/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Flink_Streaming_PR/) | `Run Java Flink PortableValidatesRunner Streaming` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Flink_Streaming/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Flink_Streaming) |
| beam_PostCommit_Java_PVR_Samza | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Samza/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Samza_PR/) | `Run Java Samza PortableValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Samza/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Samza) |
| beam_PostCommit_Java_PVR_Spark_Batch | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Spark_Batch/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Spark_Batch_PR/) | `Run Java Spark PortableValidatesRunner Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Spark_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_PVR_Spark_Batch) |
| beam_PostCommit_Java_PVR_Spark2_Streaming | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_PVR_Spark2_Streaming/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_PVR_Spark2_Streaming_PR/) | `Run Java Spark v2 PortableValidatesRunner Streaming` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_PVR_Spark2_Streaming/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_PVR_Spark2_Streaming/) |
| beam_PostCommit_Java_PVR_Spark3_Streaming | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_PVR_Spark3_Streaming/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_PVR_Spark3_Streaming_PR/) | `Run Java Spark v3 PortableValidatesRunner Streaming` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_PVR_Spark3_Streaming/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_PVR_Spark3_Streaming/) |
| beam_PostCommit_Java_SingleStoreIO_IT | [cron](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PostCommit_Java_SingleStoreIO_IT/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_SingleStoreIO_IT_PR/) | `Run Java SingleStoreIO_IT` | [![Build Status](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PostCommit_Java_SingleStoreIO_IT/badge/icon)](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PostCommit_Java_SingleStoreIO_IT/) |
| beam_PostCommit_Java_Dataflow_Examples_Java11 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_Java11/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_Java11_PR/) | `Run Java examples on Dataflow Java 11` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_Java11) |
| beam_PostCommit_Java_Examples_Dataflow_V2 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_V2/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_V2/) | `Run Java Examples on Dataflow Runner V2` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_V2/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_V2) |
| beam_PostCommit_Java_Examples_Dataflow_V2_Java11 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples__Dataflow_V2_Java11/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples__Dataflow_V2_Java11/) | `Run Java 11 Examples on Dataflow Runner V2` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_V2_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Examples_Dataflow_V2_Java11) |
| beam_PostCommit_Java_Jpms_Dataflow_Java11 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Dataflow_Java11/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Dataflow_Java11_PR/) | `Run Jpms Dataflow Java 11 PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Dataflow_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Dataflow_Java11/) |
| beam_PostCommit_Java_Jpms_Direct_Java11 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Direct_Java11/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Direct_Java11_PR/) | `Run Jpms Direct Java 11 PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Direct_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Direct_Java11/) |
| beam_PostCommit_Java_Jpms_Flink_Java11 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Flink_Java11/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Flink_Java11_PR/) | `Run Jpms Flink Java 11 PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Flink_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_Jpms_Flink_Java11/) |
| beam_PostCommit_Java_Jpms_Spark_Java11 | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Jpms_Spark_Java11/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Jpms_Spark_Java11_PR/) | `Run Jpms Spark Java 11 PostCommit` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Jpms_Spark_Java11/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Jpms_Spark_Java11/badge/icon) |
| beam_PostCommit_Java_ValidatesRunner_Dataflow_Java11 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow_Java11/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow_Java11_PR/) | `Run Dataflow ValidatesRunner Java 11` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow_Java11) |
| beam_PostCommit_Java_ValidatesRunner_Direct | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Direct/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Direct_PR/) | `Run Direct ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Direct/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Direct/) |
| beam_PostCommit_Java_ValidatesRunner_Direct_Java11 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Direct_Java11), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Direct_Java11_PR) | `Run Direct ValidatesRunner Java 11` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Direct_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Direct_Java11) |
| beam_PostCommit_Java_ValidatesRunner_Dataflow | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow_PR/) | `Run Dataflow ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow) |
| beam_PostCommit_Java_ValidatesRunner_Dataflow_Streaming | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Dataflow_Streaming/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Dataflow_Streaming_PR/) | `Run Dataflow Streaming ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Dataflow_Streaming/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Dataflow_Streaming/) |
| beam_PostCommit_Java_ValidatesRunner_Flink | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Flink/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Flink_PR/) | `Run Flink ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Flink/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Flink) |
| beam_PostCommit_Java_ValidatesRunner_Flink_Java11 | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Flink_Java11/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Flink_Java11_PR/) | `Run Flink ValidatesRunner Java 11` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Flink_Java11/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Flink_Java11/) |
| beam_PostCommit_Java_ValidatesRunner_Samza | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Samza/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Samza_PR/) | `Run Samza ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Samza/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Samza) |
| beam_PostCommit_Java_ValidatesRunner_Twister2 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Twister2/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Twister2_PR/) | `Run Twister2 ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Twister2/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Twister2) |
| beam_PostCommit_Java_ValidatesRunner_Spark | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Spark/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Spark_PR/) | `Run Spark ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Spark/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Spark) |
| beam_PostCommit_Java_ValidatesRunner_Spark_Java11 | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Spark_Java11/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Spark_Java11_PR) | `Run Spark ValidatesRunner Java 11` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Spark_Java11/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_Spark_Java11/) |
| beam_PostCommit_Java_ValidatesRunner_ULR | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_ULR/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_ULR_PR) | `Run ULR Loopback ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_ULR/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_ValidatesRunner_ULR/) |
| beam_PostCommit_Java_VR_Dataflow_V2 | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_VR_Dataflow_V2/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_VR_Dataflow_V2_PR/) | `Run Java Dataflow V2 ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_VR_Dataflow_V2/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_VR_Dataflow_V2/) |
| beam_PostCommit_Java_VR_Dataflow_V2_Streaming | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_VR_Dataflow_V2_Streaming/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_VR_Dataflow_V2_Streaming_PR/) | `Run Java Dataflow V2 ValidatesRunner Streaming` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_VR_Dataflow_V2_Streaming/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_VR_Dataflow_V2_Streaming/) |
| beam_PostCommit_Javadoc | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Javadoc/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Javadoc_PR/) | `Run Javadoc PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Javadoc/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Javadoc) |
| beam_PostCommit_PortableJar_Flink | [cron](https://ci-beam.apache.org/job/beam_PostCommit_PortableJar_Flink/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_PortableJar_Flink_PR/) | `Run PortableJar_Flink PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_PortableJar_Flink/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_PortableJar_Flink) |
| beam_PostCommit_PortableJar_Spark | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_PortableJar_Spark/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_PortableJar_Spark_PR/) | `Run PortableJar_Spark PostCommit` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_PortableJar_Spark/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_PortableJar_Spark/) |
| beam_PostCommit_Java_Sickbay | [cron](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Sickbay/), [phrase](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Sickbay_PR/) | `Run Java Sickbay` | [![Build Status](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Sickbay/badge/icon)](https://ci-beam.apache.org/view/PostCommit/job/beam_PostCommit_Java_Sickbay/) |
| beam_PostCommit_Py_VR_Dataflow | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Py_VR_Dataflow/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Py_VR_Dataflow_PR/) | `Run Python Dataflow ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Py_VR_Dataflow/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Py_VR_Dataflow) |
| beam_PostCommit_Py_ValCont | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Py_ValCont/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Py_ValCont_PR/) | `Run Python Dataflow ValidatesContainer` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Py_ValCont/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Py_ValCont) |
| beam_PostCommit_Python_VR_Flink | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Flink/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Flink_PR/) | `Run Python Flink ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Flink/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Flink) |
| beam_PostCommit_Python_VR_Samza | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Samza/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Samza_PR/) | `Run Python Samza ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Samza/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Samza) |
| beam_PostCommit_Py_ValCont_with_RC | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Py_ValCont_with_RC/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Py_ValCont_with_RC_PR/) | `Run Python RC Dataflow ValidatesContainer` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Py_ValCont_with_RC/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Py_ValCont_with_RC) |
| beam_PostCommit_Python_Examples_Direct | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Direct/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Direct_PR/) | `Run Python Examples_Direct` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Direct/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Direct/) |
| beam_PostCommit_Python_Examples_Dataflow | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Dataflow/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Dataflow_PR/) | `Run Python Examples_Dataflow` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Dataflow/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Dataflow/) |
| beam_PostCommit_Python_Examples_Flink | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Flink/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Flink_PR/) | `Run Python Examples_Flink` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Flink/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Flink/) |
| beam_PostCommit_Python_Examples_Spark | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Spark/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Spark_PR/) | `Run Python Examples_Spark` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Spark/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_Examples_Spark/) |
| beam_PostCommit_Python_Chicago_Taxi_Example_Dataflow | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_Chicago_Taxi_Dataflow/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_Chicago_Taxi_Dataflow_PR/) | `Run Chicago Taxi on Dataflow` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_Chicago_Taxi_Dataflow/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_Chicago_Taxi_Dataflow) |
| beam_PostCommit_Python_Chicago_Taxi_Example_Flink | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_Chicago_Taxi_Flink/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_Chicago_Taxi_Flink_PR/) | `Run Chicago Taxi on Flink` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_Chicago_Taxi_Flink/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_Chicago_Taxi_Flink) |
| beam_PostCommit_Python_MongoDBIO_IT | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_MongoDBIO_IT), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_MongoDBIO_IT_PR/) | `Run Python MongoDBIO_IT` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_MongoDBIO_IT/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_MongoDBIO_IT) |
| beam_PostCommit_Python_VR_Spark | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Spark/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Spark/) | `Run Python Spark ValidatesRunner` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Spark/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_VR_Spark) |
| beam_PostCommit_Python_Xlang_Gcp_Direct | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_Gcp_Direct/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_Gcp_Direct_PR/) | `Run Python_Xlang_Gcp_Direct PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_Gcp_Direct/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_Gcp_Direct/) |
| beam_PostCommit_Python_Xlang_Gcp_Dataflow | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_Gcp_Dataflow/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_Gcp_Dataflow_PR/) | `Run Python_Xlang_Gcp_Dataflow PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_Gcp_Dataflow/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_Gcp_Dataflow/) |
| beam_PostCommit_Python_Xlang_IO_Dataflow | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_IO_Dataflow/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_IO_Dataflow_PR/) | `Run Python_Xlang_IO_Dataflow PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_IO_Dataflow/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python_Xlang_IO_Dataflow/|
| beam_PostCommit_Python38 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python38), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python38_PR/) | `Run Python 3.8 PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python38/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python38) |
| beam_PostCommit_Python39 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python39), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python39_PR/) | `Run Python 3.9 PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python39/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python39) |
| beam_PostCommit_Python310 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python310), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python310_PR/) | `Run Python 3.10 PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python310/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python310) |
| beam_PostCommit_Python311 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Python311), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_Python311_PR/) | `Run Python 3.11 PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Python311/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Python311) |
| beam_PostCommit_Sickbay_Python38 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python38), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_SickBay_Python38_PR/) | `Run Python 3.8 PostCommit Sickbay tests` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python38/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python38) |
| beam_PostCommit_Sickbay_Python39 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python39), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_SickBay_Python39_PR/) | `Run Python 3.9 PostCommit Sickbay tests` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python39/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python39) |
| beam_PostCommit_Sickbay_Python310 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python310), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_SickBay_Python310_PR/) | `Run Python 3.10 PostCommit Sickbay tests` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python310/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python310) |
| beam_PostCommit_Sickbay_Python311 | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python311), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_SickBay_Python311_PR/) | `Run Python 3.11 PostCommit Sickbay tests` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python311/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Sickbay_Python311) |
| beam_PostCommit_SQL | [cron](https://ci-beam.apache.org/job/beam_PostCommit_SQL/), [phrase](https://ci-beam.apache.org/job/beam_PostCommit_SQL_PR/) | `Run SQL PostCommit` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_SQL/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_SQL) |
| beam_PostCommit_Website_Publish | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Website_Publish/) | N/A | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Website_Publish/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Website_Publish) |
| beam_PostCommit_Website_Test | [cron](https://ci-beam.apache.org/job/beam_PostCommit_Website_Test/) | `Run Full Website Test` | [![Build Status](https://ci-beam.apache.org/job/beam_PostCommit_Website_Test/badge/icon)](https://ci-beam.apache.org/job/beam_PostCommit_Website_Test) |

### Performance Jobs

| Name | Link | PR Trigger Phrase | Cron Status |
|------|------|-------------------|-------------|
| beam_PerformanceTests_AvroIOIT | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_AvroIOIT/), [hdfs_cron](https://ci-beam.apache.org/job/beam_PerformanceTests_AvroIOIT_HDFS/) | `Run Java AvroIO Performance Test` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_AvroIOIT/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_AvroIOIT) [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_AvroIOIT_HDFS/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_AvroIOIT_HDFS) |
| beam_PerformanceTests_BiqQueryIO_Read_Python | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_BiqQueryIO_Read_Python/), [phrase](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PerformanceTests_BiqQueryIO_Read_Python_PR/) | `Run BigQueryIO Read Performance Test Python` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_BiqQueryIO_Read_Python/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_BiqQueryIO_Read_Python) |
| beam_PerformanceTests_BiqQueryIO_Write_Python_Batch | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_BiqQueryIO_Write_Python_Batch/), [phrase](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PerformanceTests_BiqQueryIO_Write_Python_Batch_PR/) | `Run BigQueryIO Write Performance Test Python Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_BiqQueryIO_Write_Python_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_BiqQueryIO_Write_Python_Batch) |
| beam_PerformanceTests_BiqQueryIO_Batch_Java_Avro | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_BiqQueryIO_Batch_Java_Avro/) | `Run BigQueryIO Batch Performance Test Java Avro` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_BiqQueryIO_Batch_Java_Avro/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_BiqQueryIO_Batch_Java_Avro/) |
| beam_PerformanceTests_BiqQueryIO_Batch_Java_Json | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_BiqQueryIO_Batch_Java_Json/) | `Run BigQueryIO Batch Performance Test Java Json` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_BiqQueryIO_Batch_Java_Json/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_BiqQueryIO_Batch_Java_Json/) |
| beam_PerformanceTests_BiqQueryIO_Streaming_Java | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_BiqQueryIO_Streaming_Java/) | `Run BigQueryIO Streaming Performance Test Java` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_BiqQueryIO_Streaming_Java/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_BiqQueryIO_Streaming_Java/) |
| beam_PerformanceTests_Cdap | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_Cdap/) | `Run Java CdapIO Performance Test` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_Cdap/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_Cdap) |
| beam_PerformanceTests_Compressed_TextIOIT | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_Compressed_TextIOIT/), [hdfs_cron](https://ci-beam.apache.org/job/beam_PerformanceTests_Compressed_TextIOIT_HDFS/) | `Run Java CompressedTextIO Performance Test` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_Compressed_TextIOIT/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_Compressed_TextIOIT) [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_Compressed_TextIOIT_HDFS/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_Compressed_TextIOIT_HDFS) |
| beam_PerformanceTests_HadoopFormat | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_HadoopFormat/) | `Run Java HadoopFormatIO Performance Test` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_HadoopFormat/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_HadoopFormat) |
| beam_PerformanceTests_JDBC | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_JDBC/) | `Run Java JdbcIO Performance Test` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_JDBC/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_JDBC) |
| beam_PerformanceTests_KafkaIOIT | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_Kafka_IO/) | `Run Java KafkaIO Performance Test` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_Kafka_IO/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_Kafka_IO) |
| beam_PerformanceTests_ManyFiles_TextIOIT | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_ManyFiles_TextIOIT/), [hdfs_cron](https://ci-beam.apache.org/job/beam_PerformanceTests_ManyFiles_TextIOIT_HDFS/) | `Run Java ManyFilesTextIO Performance Test` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_ManyFiles_TextIOIT/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_ManyFiles_TextIOIT) [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_ManyFiles_TextIOIT_HDFS/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_ManyFiles_TextIOIT_HDFS) |
| beam_PerformanceTests_MongoDBIOIT | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_MongoDBIO_IT/) | `Run Java MongoDBIO Performance Test` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_MongoDBIO_IT/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_MongoDBIO_IT) |
| beam_PerformanceTests_ParquetIOIT | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_ParquetIOIT/), [hdfs_cron](https://ci-beam.apache.org/job/beam_PerformanceTests_ParquetIOIT_HDFS/) | `Run Java ParquetIO Performance Test` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_ParquetIOIT/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_ParquetIOIT) [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_ParquetIOIT_HDFS/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_ParquetIOIT_HDFS) |
| beam_PerformanceTests_PubsubIOIT_Python_Streaming | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_PubsubIOIT_Python_Streaming/), [phrase](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PerformanceTests_PubsubIOIT_Python_Streaming_PR/) | `Run PubsubIO Performance Test Python` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_PubsubIOIT_Python_Streaming/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_PubsubIOIT_Python_Streaming) |
| beam_PerformanceTests_SingleStoreIO | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_SingleStoreIO/) | `Run Java SingleStoreIO Performance Test` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_SingleStoreIO/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_SingleStoreIO) |
| beam_PerformanceTests_SpannerIO_Read_2GB_Python | [cron](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PerformanceTests_SpannerIO_Read_2GB_Python/), [phrase](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PerformanceTests_SpannerIO_Read_2GB_Python_PR/) | `Run SpannerIO Read 2GB Performance Test Python Batch` | [![Build Status](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PerformanceTests_SpannerIO_Read_2GB_Python/badge/icon)](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PerformanceTests_SpannerIO_Read_2GB_Python/) |
| beam_PerformanceTests_SpannerIO_Write_2GB_Python_Batch | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_SpannerIO_Write_2GB_Python_Batch/), [phrase](https://ci-beam.apache.org/view/PerformanceTests/job/beam_PerformanceTests_SpannerIO_Write_2GB_Python_Batch_PR/) | `Run SpannerIO Write 2GB Performance Test Python Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_SpannerIO_Write_2GB_Python_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_SpannerIO_Write_2GB_Python_Batch) |
| beam_PerformanceTests_SparkReceiver_IO | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_SparkReceiver_IO/) | `Run Java SparkReceiverIO Performance Test` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_SparkReceiver_IO/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_SparkReceiver_IO) |
| beam_PerformanceTests_TFRecordIOIT | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_TFRecordIOIT/) | `Run Java TFRecordIO Performance Test` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_TFRecordIOIT/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_TFRecordIOIT) |
| beam_PerformanceTests_TextIOIT | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_TextIOIT/), [hdfs_cron](https://ci-beam.apache.org/job/beam_PerformanceTests_TextIOIT_HDFS/) | `Run Java TextIO Performance Test` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_TextIOIT/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_TextIOIT) [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_TextIOIT_HDFS/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_TextIOIT_HDFS) |
| beam_PerformanceTests_WordCountIT_Py38 | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_WordCountIT_Py38/) | `Run Python38 WordCountIT Performance Test` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_WordCountIT_Py38/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_WordCountIT_Py38) |
| beam_PerformanceTests_XmlIOIT | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_XmlIOIT/), [hdfs_cron](https://ci-beam.apache.org/job/beam_PerformanceTests_XmlIOIT_HDFS/) | `Run Java XmlIO Performance Test` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_XmlIOIT/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_XmlIOIT) [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_XmlIOIT_HDFS/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_XmlIOIT_HDFS) |
| beam_PerformanceTests_SQLBigQueryIO_Batch_Java | [cron](https://ci-beam.apache.org/job/beam_PerformanceTests_SQLBigQueryIO_Batch_Java/) | `Run SQLBigQueryIO Batch Performance Test Java` | [![Build Status](https://ci-beam.apache.org/job/beam_PerformanceTests_SQLBigQueryIO_Batch_Java/badge/icon)](https://ci-beam.apache.org/job/beam_PerformanceTests_SQLBigQueryIO_Batch_Java/) |
| beam_Java_JMH | [cron](https://ci-beam.apache.org/job/beam_Java_JMH/) |  | [![Build Status](https://ci-beam.apache.org/job/beam_Java_JMH/badge/icon)](https://ci-beam.apache.org/job/beam_Java_JMH/) |

### Load test Jobs

| Name | Link | PR Trigger Phrase | Cron Status |
|------|------|-------------------|-------------|
| beam_LoadTests_Go_CoGBK_Dataflow_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Go_CoGBK_Dataflow_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Go_CoGBK_Dataflow_Batch_PR/) | `Run Load Tests Go CoGBK Dataflow Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Go_CoGBK_Dataflow_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Go_CoGBK_Dataflow_Batch/) |
| beam_LoadTests_Go_CoGBK_Flink_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Go_CoGBK_Flink_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Go_CoGBK_Flink_Batch_PR/) | `Run Load Tests Go CoGBK Flink Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Go_CoGBK_Flink_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Go_CoGBK_Flink_Batch/) |
| beam_LoadTests_Go_Combine_Dataflow_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Go_Combine_Dataflow_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Go_Combine_Dataflow_Batch_PR/) | `Run Load Tests Go Combine Dataflow Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Go_Combine_Dataflow_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Go_Combine_Dataflow_Batch/) |
| beam_LoadTests_Go_Combine_Flink_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Go_Combine_Flink_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Go_Combine_Flink_Batch_PR/) | `Run Load Tests Go Combine Flink Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Go_Combine_Flink_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Go_Combine_Flink_Batch/) |
| beam_LoadTests_Go_GBK_Dataflow_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Go_GBK_Dataflow_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Go_GBK_Dataflow_Batch_PR/) | `Run Load Tests Go GBK Dataflow Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Go_GBK_Dataflow_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Go_GBK_Dataflow_Batch/) |
| beam_LoadTests_Go_GBK_Flink_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Go_GBK_Flink_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Go_GBK_Flink_Batch_PR/) | `Run Load Tests Go GBK Flink Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Go_GBK_Flink_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Go_GBK_Flink_Batch/) |
| beam_LoadTests_Go_ParDo_Dataflow_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Go_ParDo_Dataflow_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Go_ParDo_Dataflow_Batch_PR/) | `Run Load Tests Go ParDo Dataflow Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Go_ParDo_Dataflow_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Go_ParDo_Dataflow_Batch/) |
| beam_LoadTests_Go_ParDo_Flink_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Go_ParDo_Flink_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Go_ParDo_Flink_Batch_PR/) | `Run Load Tests Go ParDo Flink Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Go_ParDo_Flink_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Go_ParDo_Flink_Batch/) |
| beam_LoadTests_Go_SideInput_Dataflow_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Go_SideInput_Dataflow_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Go_SideInput_Dataflow_Batch_PR/) | `Run Load Tests Go SideInput Dataflow Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Go_SideInput_Dataflow_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Go_SideInput_Dataflow_Batch/) |
| beam_LoadTests_Go_SideInput_Flink_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Go_SideInput_Flink_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Go_SideInput_Flink_Batch_PR/) | `Run Load Tests Go SideInput Flink Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Go_SideInput_Flink_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Go_SideInput_Flink_Batch/) |
| beam_Java_LoadTests_Smoke | [phrase](https://ci-beam.apache.org/job/beam_Java_LoadTests_Smoke_PR/) | `Run Java Load Tests Smoke` |  |
| beam_LoadTests_Java_CoGBK_Dataflow_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_Dataflow_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_Dataflow_Batch_PR/) | `Run Load Tests Java CoGBK Dataflow Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_Dataflow_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_Dataflow_Batch/) |
| beam_LoadTests_Java_CoGBK_Dataflow_Streaming | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_Dataflow_Streaming/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_Dataflow_Streaming_PR/) | `Run Load Tests Java CoGBK Dataflow Streaming` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_Dataflow_Streaming/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_Dataflow_Streaming/) |
| beam_LoadTests_Java_CoGBK_Dataflow_V2_Batch_Java11 | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_Dataflow_V2_Batch_Java11/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_Dataflow_V2_Batch_Java11_PR/) | `Run Load Tests Java 11 CoGBK Dataflow V2 Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_Dataflow_V2_Batch_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_Dataflow_V2_Batch_Java11/) |
| beam_LoadTests_Java_CoGBK_Dataflow_V2_Streaming_Java11 | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_Dataflow_V2_Streaming_Java11/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_Dataflow_V2_Streaming_Java11_PR/) | `Run Load Tests Java 11 CoGBK Dataflow V2 Streaming` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_Dataflow_V2_Streaming_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_Dataflow_V2_Streaming_Java11/) |
| beam_LoadTests_Java_CoGBK_SparkStructuredStreaming_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_SparkStructuredStreaming_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_SparkStructuredStreaming_Batch_PR/) | `Run Load Tests Java CoGBK SparkStructuredStreaming Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_SparkStructuredStreaming_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Java_CoGBK_SparkStructuredStreaming_Batch/) |
| beam_LoadTests_Java_Combine_Dataflow_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Java_Combine_Dataflow_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Java_Combine_Dataflow_Batch_PR/) | `Run Load Tests Java Combine Dataflow Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Java_Combine_Dataflow_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Java_Combine_Dataflow_Batch/) |
| beam_LoadTests_Java_Combine_SparkStructuredStreaming_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Java_Combine_SparkStructuredStreaming_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Java_Combine_SparkStructuredStreaming_Batch_PR/) | `Run Load Tests Java Combine SparkStructuredStreaming Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Java_Combine_SparkStructuredStreaming_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Java_Combine_SparkStructuredStreaming_Batch/) |
| beam_LoadTests_Java_Combine_Dataflow_Streaming | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Java_Combine_Dataflow_Streaming/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Java_Combine_Dataflow_Streaming_PR/) | `Run Load Tests Java Combine Dataflow Streaming` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Java_Combine_Dataflow_Streaming/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Java_Combine_Dataflow_Streaming/) |
| beam_LoadTests_Java_GBK_Dataflow_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_Dataflow_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_Dataflow_Batch_PR/) | `Run Load Tests Java GBK Dataflow Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_Dataflow_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_Dataflow_Batch/) |
| beam_LoadTests_Java_GBK_Dataflow_V2_Batch_Java11 | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_Dataflow_V2_Batch_Java11/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_Dataflow_V2_Batch_Java11_PR/) | `Run Load Tests Java 11 GBK Dataflow V2 Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_Dataflow_V2_Batch_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_Dataflow_V2_Batch_Java11/) |
| beam_LoadTests_Java_GBK_Dataflow_Streaming | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_Dataflow_Streaming/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_Dataflow_Streaming_PR/) | `Run Load Tests Java GBK Dataflow Streaming` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_Dataflow_Streaming/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_Dataflow_Streaming/) |
| beam_LoadTests_Java_GBK_Dataflow_V2_Streaming_Java11 | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_Dataflow_V2_Streaming_Java11/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_Dataflow_V2_Streaming_Java11_PR/) | `Run Load Tests Java 11 GBK Dataflow V2 Streaming` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_Dataflow_V2_Streaming_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_Dataflow_V2_Streaming_Java11/) |
| beam_LoadTests_Java_GBK_SparkStructuredStreaming_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_SparkStructuredStreaming_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_SparkStructuredStreaming_Batch_PR/) | `Run Load Tests Java GBK SparkStructuredStreaming Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_SparkStructuredStreaming_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Java_GBK_SparkStructuredStreaming_Batch/) |
| beam_LoadTests_Java_ParDo_Dataflow_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_Dataflow_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_Dataflow_Batch_PR/) | `Run Load Tests Java ParDo Dataflow Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_Dataflow_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_Dataflow_Batch/) |
| beam_LoadTests_Java_ParDo_Dataflow_Streaming | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_Dataflow_Streaming/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_Dataflow_Streaming_PR/) | `Run Load Tests Java ParDo Dataflow Streaming` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_Dataflow_Streaming/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_Dataflow_Streaming/) |
| beam_LoadTests_Java_ParDo_Dataflow_V2_Batch_Java11 | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_Dataflow_V2_Batch_Java11/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_Dataflow_V2_Batch_Java11_PR/) | `Run Load Tests Java 11 ParDo Dataflow V2 Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_Dataflow_V2_Batch_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_Dataflow_V2_Batch_Java11/) |
| beam_LoadTests_Java_ParDo_Dataflow_V2_Streaming_Java11 | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_Dataflow_V2_Streaming_Java11/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_Dataflow_V2_Streaming_Java11_PR/) | `Run Load Tests Java 11 ParDo Dataflow V2 Streaming` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_Dataflow_V2_Streaming_Java11/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_Dataflow_V2_Streaming_Java11/) |
| beam_LoadTests_Java_ParDo_SparkStructuredStreaming_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_SparkStructuredStreaming_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_SparkStructuredStreaming_Batch_PR/) | `Run Load Tests Java ParDo SparkStructuredStreaming Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_SparkStructuredStreaming_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Java_ParDo_SparkStructuredStreaming_Batch/) |
| beam_LoadTests_Python_CoGBK_Dataflow_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Python_CoGBK_Dataflow_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Python_CoGBK_Dataflow_Batch_PR/) | `Run Load Tests Python CoGBK Dataflow Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Python_CoGBK_Dataflow_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Python_CoGBK_Dataflow_Batch/) |
| beam_LoadTests_Python_CoGBK_Dataflow_Streaming | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Python_CoGBK_Dataflow_Streaming/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Python_CoGBK_Dataflow_Batch_PR/) | `Run Load Tests Python CoGBK Dataflow Streaming` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Python_CoGBK_Dataflow_Streaming/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Python_CoGBK_Dataflow_Streaming/) |
| beam_LoadTests_Python_CoGBK_Flink_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Python_CoGBK_Flink_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Python_CoGBK_Flink_Batch_PR/) | `Run Load Tests Python CoGBK Flink Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Python_CoGBK_Flink_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Python_coGBK_Flink_Batch/) |
| beam_LoadTests_Python_Combine_Dataflow_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Python_Combine_Dataflow_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Python_Combine_Dataflow_Batch_PR/) | `Run Load Tests Python Combine Dataflow Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Python_Combine_Dataflow_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Python_Combine_Dataflow_Batch/) |
| beam_LoadTests_Python_Combine_Dataflow_Streaming | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Python_Combine_Dataflow_Streaming/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Python_Combine_Dataflow_Streaming_PR/) | `Run Load Tests Python Combine Dataflow Streaming` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Python_Combine_Dataflow_Streaming/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Python_Combine_Dataflow_Streaming/) |
| beam_LoadTests_Python_Combine_Flink_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Python_Combine_Flink_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Python_Combine_Flink_Batch_PR/) | `Run Load Tests Python Combine Flink Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Python_Combine_Flink_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Python_Combine_Flink_Batch/) |
| beam_LoadTests_Python_Combine_Flink_Streaming | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Python_Combine_Flink_Streaming/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Python_Combine_Flink_Streaming_PR/) | `Run Load Tests Python Combine Flink Streaming` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Python_Combine_Flink_Streaming/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Python_Combine_Flink_Streaming/) |
| beam_LoadTests_Python_GBK_Dataflow_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_Dataflow_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_Dataflow_Batch_PR/) | `Run Load Tests Python GBK Dataflow Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_Dataflow_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_Dataflow_Batch/) |
| beam_LoadTests_Python_GBK_Dataflow_Streaming | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_Dataflow_Streaming/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_Dataflow_Streaming_PR/) | `Run Load Tests Python GBK Dataflow Streaming` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_Dataflow_Streaming/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_Dataflow_Streaming/) |
| beam_LoadTests_Python_GBK_Flink_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_Flink_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_Flink_Batch_PR/) | `Run Load Tests Python GBK Flink Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_Flink_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_Flink_Batch/) |
| beam_LoadTests_Python_GBK_reiterate_Dataflow_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_reiterate_Dataflow_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_reiterate_Dataflow_Batch_PR/) | `Run Load Tests Python GBK reiterate Dataflow Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_reiterate_Dataflow_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_reiterate_Dataflow_Batch/) |
| beam_LoadTests_Python_GBK_reiterate_Dataflow_Streaming | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_reiterate_Dataflow_Streaming/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_reiterate_Dataflow_Streaming_PR/) | `Run Load Tests Python GBK reiterate Dataflow Streaming` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_reiterate_Dataflow_Streaming/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Python_GBK_reiterate_Dataflow_Streaming/) |
| beam_LoadTests_Python_ParDo_Dataflow_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Python_ParDo_Dataflow_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Python_ParDo_Dataflow_Batch_PR/) | `Run Load Tests Python ParDo Dataflow Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Python_ParDo_Dataflow_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Python_ParDo_Dataflow_Batch/) |
| beam_LoadTests_Python_ParDo_Dataflow_Streaming | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Python_ParDo_Dataflow_Streaming/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Python_ParDo_Dataflow_Streaming_PR/) | `Run Python Load Tests ParDo Dataflow Streaming` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Python_ParDo_Dataflow_Streaming/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Python_ParDo_Dataflow_Streaming/) |
| beam_LoadTests_Python_ParDo_Flink_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Python_ParDo_Flink_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Python_ParDo_Flink_Batch_PR/) | `Run Load Tests Python ParDo Flink Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Python_ParDo_Flink_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Python_ParDo_Flink_Batch/) |
| beam_LoadTests_Python_ParDo_Flink_Streaming | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Python_ParDo_Flink_Streaming/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Python_ParDo_Flink_Streaming_PR/) | `Run Load Tests Python ParDo Flink Streaming` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Python_ParDo_Flink_Streaming/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Python_ParDo_Flink_Streaming/) |
| beam_LoadTests_Python_SideInput_Dataflow_Batch | [cron](https://ci-beam.apache.org/job/beam_LoadTests_Python_SideInput_Dataflow_Batch/), [phrase](https://ci-beam.apache.org/job/beam_LoadTests_Python_SideInput_Dataflow_Batch_PR/) | `Run Load Tests Python SideInput Dataflow Batch` | [![Build Status](https://ci-beam.apache.org/job/beam_LoadTests_Python_SideInput_Dataflow_Batch/badge/icon)](https://ci-beam.apache.org/job/beam_LoadTests_Python_SideInput_Dataflow_Batch/) |
| beam_Python_LoadTests_FnApiRunner_Microbenchmark | [cron](https://ci-beam.apache.org/job/beam_Python_LoadTests_FnApiRunner_Microbenchmark/), [phrase](https://ci-beam.apache.org/job/beam_Python_LoadTests_FnApiRunner_Microbenchmark_PR/) | `Run Python Load Tests FnApiRunner Microbenchmark` | [![Build Status](https://ci-beam.apache.org/job/beam_Python_LoadTests_FnApiRunner_Microbenchmark/badge/icon)](https://ci-beam.apache.org/job/beam_Python_LoadTests_FnApiRunner_Microbenchmark/) |
| beam_Python_LoadTests_Smoke | [phrase](https://ci-beam.apache.org/job/beam_Python_LoadTests_Smoke_PR/) | `Run Python Load Tests Smoke` |  |

### Inventory Jobs

| Name | Link | PR Trigger Phrase | Cron Status |
|------|------|-------------------|-------------|
| beam_Inventory_apache-beam-jenkins-1 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-1/) | `Run inventory apache-beam-jenkins-1` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-1/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-1) |
| beam_Inventory_apache-beam-jenkins-2 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-2/) | `Run inventory apache-beam-jenkins-2` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-2/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-2) |
| beam_Inventory_apache-beam-jenkins-3 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-3/) | `Run inventory apache-beam-jenkins-3` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-3/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-3) |
| beam_Inventory_apache-beam-jenkins-4 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-4/) | `Run inventory apache-beam-jenkins-4` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-4/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-4) |
| beam_Inventory_apache-beam-jenkins-5 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-5/) | `Run inventory apache-beam-jenkins-5` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-5/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-5) |
| beam_Inventory_apache-beam-jenkins-6 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-6/) | `Run inventory apache-beam-jenkins-6` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-6/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-6) |
| beam_Inventory_apache-beam-jenkins-7 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-7/) | `Run inventory apache-beam-jenkins-7` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-7/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-7) |
| beam_Inventory_apache-beam-jenkins-8 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-8/) | `Run inventory apache-beam-jenkins-8` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-8/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-8) |
| beam_Inventory_apache-beam-jenkins-9 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-9/) | `Run inventory apache-beam-jenkins-9` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-9/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-9) |
| beam_Inventory_apache-beam-jenkins-10 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-10/) | `Run inventory apache-beam-jenkins-10` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-10/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-10) |
| beam_Inventory_apache-beam-jenkins-11 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-11/) | `Run inventory apache-beam-jenkins-11` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-11/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-11) |
| beam_Inventory_apache-beam-jenkins-12 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-12/) | `Run inventory apache-beam-jenkins-12` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-12/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-12) |
| beam_Inventory_apache-beam-jenkins-13 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-13/) | `Run inventory apache-beam-jenkins-13` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-13/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-13) |
| beam_Inventory_apache-beam-jenkins-14 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-14/) | `Run inventory apache-beam-jenkins-14` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-14/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-14) |
| beam_Inventory_apache-beam-jenkins-15 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-15/) | `Run inventory apache-beam-jenkins-15` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-15/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-15) |
| beam_Inventory_apache-beam-jenkins-16 | [cron](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-16/) | `Run inventory apache-beam-jenkins-16` | [![Build Status](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-16/badge/icon)](https://ci-beam.apache.org/job/beam_Inventory_apache-beam-jenkins-16) |

### Other Jobs

| Name | Link | PR Trigger Phrase | Cron Status |
|------|------|-------------------|-------------|
| beam_Metrics_Report | [cron](https://ci-beam.apache.org/job/beam_Metrics_Report/) | `Run Metrics Report` | [![Build Status](https://ci-beam.apache.org/job/beam_Metrics_Report/badge/icon)](https://ci-beam.apache.org/job/beam_Metrics_Report) |
| beam_Release_NightlySnapshot | [cron](https://ci-beam.apache.org/job/beam_Release_NightlySnapshot/) | `Run Gradle Publish` | [![Build Status](https://ci-beam.apache.org/job/beam_Release_NightlySnapshot/badge/icon)](https://ci-beam.apache.org/job/beam_Release_NightlySnapshot) |
| beam_Release_Python_NightlySnapshot | [cron](https://ci-beam.apache.org/job/beam_Release_Python_NightlySnapshot/) | `Run Python Publish` | [![Build Status](https://ci-beam.apache.org/job/beam_Release_Python_NightlySnapshot/badge/icon)](https://ci-beam.apache.org/job/beam_Release_Python_NightlySnapshot) |
| beam_PostRelease_NightlySnapshot | [cron](https://ci-beam.apache.org/job/beam_PostRelease_NightlySnapshot/) | `Run Dataflow PostRelease` | [![Build Status](https://ci-beam.apache.org/job/beam_PostRelease_NightlySnapshot/badge/icon)](https://ci-beam.apache.org/job/beam_PostRelease_NightlySnapshot) |
| beam_Prober_CommunityMetrics | [cron](https://ci-beam.apache.org/job/beam_Prober_CommunityMetrics/) | `Run Community Metrics Prober` | [![Build Status](https://ci-beam.apache.org/job/beam_Prober_CommunityMetrics/badge/icon)](https://ci-beam.apache.org/job/beam_Prober_CommunityMetrics) |
| beam_SeedJob | [cron](https://ci-beam.apache.org/job/beam_SeedJob/), [standalone](https://ci-beam.apache.org/job/beam_SeedJob_Standalone/) | `Run Seed Job` | [![Build Status](https://ci-beam.apache.org/job/beam_SeedJob/badge/icon)](https://ci-beam.apache.org/job/beam_SeedJob) |
| beam_sonarqube_report | [cron](https://ci-beam.apache.org/job/beam_sonarqube_report/)| N/A | [![Build Status](https://ci-beam.apache.org/job/beam_sonarqube_report/badge/icon)](https://ci-beam.apache.org/job/beam_sonarqube_report/) |
| beam_CancelStaleDataflowJobs | [cron](https://ci-beam.apache.org/job/beam_CancelStaleDataflowJobs/)| `Run Cancel Stale Dataflow Jobs` | [![Build Status](https://ci-beam.apache.org/job/beam_CancelStaleDataflowJobs/badge/icon)](https://ci-beam.apache.org/job/beam_CancelStaleDataflowJobs/) |
| beam_CleanUpGCPResources | [cron](https://ci-beam.apache.org/job/beam_CleanUpGCPResources/)| `Run Clean GCP Resources` | [![Build Status](https://ci-beam.apache.org/job/beam_CleanUpGCPResources/badge/icon)](https://ci-beam.apache.org/job/beam_CleanUpGCPResources/) |
| beam_Clean_tmp_directory | [cron](https://ci-beam.apache.org/job/beam_Clean_tmp_directory/)| N/A | [![Build Status](https://ci-beam.apache.org/job/beam_Clean_tmp_directory/badge/icon)](https://ci-beam.apache.org/job/beam_Clean_tmp_directory/) |
| beam_Publish_Beam_SDK_Snapshots | [cron](https://ci-beam.apache.org/job/beam_Publish_Beam_SDK_Snapshots/)| N/A | [![Build Status](https://ci-beam.apache.org/job/beam_Publish_Beam_SDK_Snapshots/badge/icon)](https://ci-beam.apache.org/job/beam_Publish_Beam_SDK_Snapshots/) |
| beam_Publish_Docker_Snapshots | [cron](https://ci-beam.apache.org/job/beam_Publish_Docker_Snapshots/)| N/A | [![Build Status](https://ci-beam.apache.org/job/beam_Publish_Docker_Snapshots/badge/icon)](https://ci-beam.apache.org/job/beam_Publish_Docker_Snapshots/) |
| beam_PostRelease_Python_Candidate | [cron](https://ci-beam.apache.org/job/beam_PostRelease_Python_Candidate/)| `Run Python ReleaseCandidate` | [![Build Status](https://ci-beam.apache.org/job/beam_PostRelease_Python_Candidate/badge/icon)](https://ci-beam.apache.org/job/beam_PostRelease_Python_Candidate/) |

### Notes:

* To rerun full set of PreCommit jobs in PR, comment following trigger phrase:

```
retest this please
```

* Last update (mm/dd/yyyy): 06/20/2022
