//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//
// Protocol Buffers for metrics classes, used in the Fn API, Job API, and by SDKs.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v4.24.0--rc1
// source: org/apache/beam/model/pipeline/v1/metrics.proto

package pipeline_v1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	descriptorpb "google.golang.org/protobuf/types/descriptorpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type MonitoringInfoSpecs_Enum int32

const (
	// Represents an integer counter where values are summed across bundles.
	MonitoringInfoSpecs_USER_SUM_INT64 MonitoringInfoSpecs_Enum = 0
	// Represents a double counter where values are summed across bundles.
	MonitoringInfoSpecs_USER_SUM_DOUBLE MonitoringInfoSpecs_Enum = 1
	// Represents a distribution of an integer value where:
	//   - count: represents the number of values seen across all bundles
	//   - sum: represents the total of the value across all bundles
	//   - min: represents the smallest value seen across all bundles
	//   - max: represents the largest value seen across all bundles
	MonitoringInfoSpecs_USER_DISTRIBUTION_INT64 MonitoringInfoSpecs_Enum = 2
	// Represents a distribution of a double value where:
	//   - count: represents the number of values seen across all bundles
	//   - sum: represents the total of the value across all bundles
	//   - min: represents the smallest value seen across all bundles
	//   - max: represents the largest value seen across all bundles
	MonitoringInfoSpecs_USER_DISTRIBUTION_DOUBLE MonitoringInfoSpecs_Enum = 3
	// Represents the latest seen integer value. The timestamp is used to
	// provide an "ordering" over multiple values to determine which is the
	// latest.
	MonitoringInfoSpecs_USER_LATEST_INT64 MonitoringInfoSpecs_Enum = 4
	// Represents the latest seen double value. The timestamp is used to
	// provide an "ordering" over multiple values to determine which is the
	// latest.
	MonitoringInfoSpecs_USER_LATEST_DOUBLE MonitoringInfoSpecs_Enum = 5
	// Represents the largest set of integer values seen across bundles.
	MonitoringInfoSpecs_USER_TOP_N_INT64 MonitoringInfoSpecs_Enum = 6
	// Represents the largest set of double values seen across bundles.
	MonitoringInfoSpecs_USER_TOP_N_DOUBLE MonitoringInfoSpecs_Enum = 7
	// Represents the smallest set of integer values seen across bundles.
	MonitoringInfoSpecs_USER_BOTTOM_N_INT64 MonitoringInfoSpecs_Enum = 8
	// Represents the smallest set of double values seen across bundles.
	MonitoringInfoSpecs_USER_BOTTOM_N_DOUBLE MonitoringInfoSpecs_Enum = 9
	MonitoringInfoSpecs_ELEMENT_COUNT        MonitoringInfoSpecs_Enum = 10
	MonitoringInfoSpecs_SAMPLED_BYTE_SIZE    MonitoringInfoSpecs_Enum = 11
	MonitoringInfoSpecs_START_BUNDLE_MSECS   MonitoringInfoSpecs_Enum = 12
	MonitoringInfoSpecs_PROCESS_BUNDLE_MSECS MonitoringInfoSpecs_Enum = 13
	MonitoringInfoSpecs_FINISH_BUNDLE_MSECS  MonitoringInfoSpecs_Enum = 14
	MonitoringInfoSpecs_TOTAL_MSECS          MonitoringInfoSpecs_Enum = 15
	// All values reported across all beam:metric:ptransform_progress:.*:v1
	// metrics are of the same magnitude.
	MonitoringInfoSpecs_WORK_REMAINING MonitoringInfoSpecs_Enum = 16
	// All values reported across all beam:metric:ptransform_progress:.*:v1
	// metrics are of the same magnitude.
	MonitoringInfoSpecs_WORK_COMPLETED MonitoringInfoSpecs_Enum = 17
	// The (0-based) index of the latest item processed from the data channel.
	// This gives an indication of the SDKs progress through the data channel,
	// and is a lower bound on where it is able to split.
	// For an SDK that processes items sequentially, this is equivalently the
	// number of items fully processed (or -1 if processing has not yet started).
	MonitoringInfoSpecs_DATA_CHANNEL_READ_INDEX MonitoringInfoSpecs_Enum = 18
	MonitoringInfoSpecs_API_REQUEST_COUNT       MonitoringInfoSpecs_Enum = 19
	MonitoringInfoSpecs_API_REQUEST_LATENCIES   MonitoringInfoSpecs_Enum = 20
)

// Enum value maps for MonitoringInfoSpecs_Enum.
var (
	MonitoringInfoSpecs_Enum_name = map[int32]string{
		0:  "USER_SUM_INT64",
		1:  "USER_SUM_DOUBLE",
		2:  "USER_DISTRIBUTION_INT64",
		3:  "USER_DISTRIBUTION_DOUBLE",
		4:  "USER_LATEST_INT64",
		5:  "USER_LATEST_DOUBLE",
		6:  "USER_TOP_N_INT64",
		7:  "USER_TOP_N_DOUBLE",
		8:  "USER_BOTTOM_N_INT64",
		9:  "USER_BOTTOM_N_DOUBLE",
		10: "ELEMENT_COUNT",
		11: "SAMPLED_BYTE_SIZE",
		12: "START_BUNDLE_MSECS",
		13: "PROCESS_BUNDLE_MSECS",
		14: "FINISH_BUNDLE_MSECS",
		15: "TOTAL_MSECS",
		16: "WORK_REMAINING",
		17: "WORK_COMPLETED",
		18: "DATA_CHANNEL_READ_INDEX",
		19: "API_REQUEST_COUNT",
		20: "API_REQUEST_LATENCIES",
	}
	MonitoringInfoSpecs_Enum_value = map[string]int32{
		"USER_SUM_INT64":           0,
		"USER_SUM_DOUBLE":          1,
		"USER_DISTRIBUTION_INT64":  2,
		"USER_DISTRIBUTION_DOUBLE": 3,
		"USER_LATEST_INT64":        4,
		"USER_LATEST_DOUBLE":       5,
		"USER_TOP_N_INT64":         6,
		"USER_TOP_N_DOUBLE":        7,
		"USER_BOTTOM_N_INT64":      8,
		"USER_BOTTOM_N_DOUBLE":     9,
		"ELEMENT_COUNT":            10,
		"SAMPLED_BYTE_SIZE":        11,
		"START_BUNDLE_MSECS":       12,
		"PROCESS_BUNDLE_MSECS":     13,
		"FINISH_BUNDLE_MSECS":      14,
		"TOTAL_MSECS":              15,
		"WORK_REMAINING":           16,
		"WORK_COMPLETED":           17,
		"DATA_CHANNEL_READ_INDEX":  18,
		"API_REQUEST_COUNT":        19,
		"API_REQUEST_LATENCIES":    20,
	}
)

func (x MonitoringInfoSpecs_Enum) Enum() *MonitoringInfoSpecs_Enum {
	p := new(MonitoringInfoSpecs_Enum)
	*p = x
	return p
}

func (x MonitoringInfoSpecs_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MonitoringInfoSpecs_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_org_apache_beam_model_pipeline_v1_metrics_proto_enumTypes[0].Descriptor()
}

func (MonitoringInfoSpecs_Enum) Type() protoreflect.EnumType {
	return &file_org_apache_beam_model_pipeline_v1_metrics_proto_enumTypes[0]
}

func (x MonitoringInfoSpecs_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MonitoringInfoSpecs_Enum.Descriptor instead.
func (MonitoringInfoSpecs_Enum) EnumDescriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDescGZIP(), []int{2, 0}
}

type MonitoringInfo_MonitoringInfoLabels int32

const (
	// The values used for TRANSFORM, PCOLLECTION, WINDOWING_STRATEGY
	// CODER, ENVIRONMENT, etc. must always match the keys used to
	// refer to them. For actively processed bundles, these should match the
	// values within the ProcessBundleDescriptor. For job management APIs,
	// these should match values within the original pipeline representation.
	MonitoringInfo_TRANSFORM           MonitoringInfo_MonitoringInfoLabels = 0
	MonitoringInfo_PCOLLECTION         MonitoringInfo_MonitoringInfoLabels = 1
	MonitoringInfo_WINDOWING_STRATEGY  MonitoringInfo_MonitoringInfoLabels = 2
	MonitoringInfo_CODER               MonitoringInfo_MonitoringInfoLabels = 3
	MonitoringInfo_ENVIRONMENT         MonitoringInfo_MonitoringInfoLabels = 4
	MonitoringInfo_NAMESPACE           MonitoringInfo_MonitoringInfoLabels = 5
	MonitoringInfo_NAME                MonitoringInfo_MonitoringInfoLabels = 6
	MonitoringInfo_SERVICE             MonitoringInfo_MonitoringInfoLabels = 7
	MonitoringInfo_METHOD              MonitoringInfo_MonitoringInfoLabels = 8
	MonitoringInfo_RESOURCE            MonitoringInfo_MonitoringInfoLabels = 9
	MonitoringInfo_STATUS              MonitoringInfo_MonitoringInfoLabels = 10
	MonitoringInfo_BIGQUERY_PROJECT_ID MonitoringInfo_MonitoringInfoLabels = 11
	MonitoringInfo_BIGQUERY_DATASET    MonitoringInfo_MonitoringInfoLabels = 12
	MonitoringInfo_BIGQUERY_TABLE      MonitoringInfo_MonitoringInfoLabels = 13
	MonitoringInfo_BIGQUERY_VIEW       MonitoringInfo_MonitoringInfoLabels = 14
	MonitoringInfo_BIGQUERY_QUERY_NAME MonitoringInfo_MonitoringInfoLabels = 15
	MonitoringInfo_GCS_BUCKET          MonitoringInfo_MonitoringInfoLabels = 16
	MonitoringInfo_GCS_PROJECT_ID      MonitoringInfo_MonitoringInfoLabels = 17
	MonitoringInfo_DATASTORE_PROJECT   MonitoringInfo_MonitoringInfoLabels = 18
	MonitoringInfo_DATASTORE_NAMESPACE MonitoringInfo_MonitoringInfoLabels = 19
	MonitoringInfo_BIGTABLE_PROJECT_ID MonitoringInfo_MonitoringInfoLabels = 20
	MonitoringInfo_INSTANCE_ID         MonitoringInfo_MonitoringInfoLabels = 21
	MonitoringInfo_TABLE_ID            MonitoringInfo_MonitoringInfoLabels = 22
	MonitoringInfo_SPANNER_PROJECT_ID  MonitoringInfo_MonitoringInfoLabels = 23
	MonitoringInfo_SPANNER_DATABASE_ID MonitoringInfo_MonitoringInfoLabels = 24
	MonitoringInfo_SPANNER_TABLE_ID    MonitoringInfo_MonitoringInfoLabels = 25
	MonitoringInfo_SPANNER_INSTANCE_ID MonitoringInfo_MonitoringInfoLabels = 26
	MonitoringInfo_SPANNER_QUERY_NAME  MonitoringInfo_MonitoringInfoLabels = 27
)

// Enum value maps for MonitoringInfo_MonitoringInfoLabels.
var (
	MonitoringInfo_MonitoringInfoLabels_name = map[int32]string{
		0:  "TRANSFORM",
		1:  "PCOLLECTION",
		2:  "WINDOWING_STRATEGY",
		3:  "CODER",
		4:  "ENVIRONMENT",
		5:  "NAMESPACE",
		6:  "NAME",
		7:  "SERVICE",
		8:  "METHOD",
		9:  "RESOURCE",
		10: "STATUS",
		11: "BIGQUERY_PROJECT_ID",
		12: "BIGQUERY_DATASET",
		13: "BIGQUERY_TABLE",
		14: "BIGQUERY_VIEW",
		15: "BIGQUERY_QUERY_NAME",
		16: "GCS_BUCKET",
		17: "GCS_PROJECT_ID",
		18: "DATASTORE_PROJECT",
		19: "DATASTORE_NAMESPACE",
		20: "BIGTABLE_PROJECT_ID",
		21: "INSTANCE_ID",
		22: "TABLE_ID",
		23: "SPANNER_PROJECT_ID",
		24: "SPANNER_DATABASE_ID",
		25: "SPANNER_TABLE_ID",
		26: "SPANNER_INSTANCE_ID",
		27: "SPANNER_QUERY_NAME",
	}
	MonitoringInfo_MonitoringInfoLabels_value = map[string]int32{
		"TRANSFORM":           0,
		"PCOLLECTION":         1,
		"WINDOWING_STRATEGY":  2,
		"CODER":               3,
		"ENVIRONMENT":         4,
		"NAMESPACE":           5,
		"NAME":                6,
		"SERVICE":             7,
		"METHOD":              8,
		"RESOURCE":            9,
		"STATUS":              10,
		"BIGQUERY_PROJECT_ID": 11,
		"BIGQUERY_DATASET":    12,
		"BIGQUERY_TABLE":      13,
		"BIGQUERY_VIEW":       14,
		"BIGQUERY_QUERY_NAME": 15,
		"GCS_BUCKET":          16,
		"GCS_PROJECT_ID":      17,
		"DATASTORE_PROJECT":   18,
		"DATASTORE_NAMESPACE": 19,
		"BIGTABLE_PROJECT_ID": 20,
		"INSTANCE_ID":         21,
		"TABLE_ID":            22,
		"SPANNER_PROJECT_ID":  23,
		"SPANNER_DATABASE_ID": 24,
		"SPANNER_TABLE_ID":    25,
		"SPANNER_INSTANCE_ID": 26,
		"SPANNER_QUERY_NAME":  27,
	}
)

func (x MonitoringInfo_MonitoringInfoLabels) Enum() *MonitoringInfo_MonitoringInfoLabels {
	p := new(MonitoringInfo_MonitoringInfoLabels)
	*p = x
	return p
}

func (x MonitoringInfo_MonitoringInfoLabels) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MonitoringInfo_MonitoringInfoLabels) Descriptor() protoreflect.EnumDescriptor {
	return file_org_apache_beam_model_pipeline_v1_metrics_proto_enumTypes[1].Descriptor()
}

func (MonitoringInfo_MonitoringInfoLabels) Type() protoreflect.EnumType {
	return &file_org_apache_beam_model_pipeline_v1_metrics_proto_enumTypes[1]
}

func (x MonitoringInfo_MonitoringInfoLabels) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MonitoringInfo_MonitoringInfoLabels.Descriptor instead.
func (MonitoringInfo_MonitoringInfoLabels) EnumDescriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDescGZIP(), []int{4, 0}
}

type MonitoringInfoTypeUrns_Enum int32

const (
	// Represents an integer counter where values are summed across bundles.
	//
	// Encoding: <value>
	//   - value: beam:coder:varint:v1
	MonitoringInfoTypeUrns_SUM_INT64_TYPE MonitoringInfoTypeUrns_Enum = 0
	// Represents a double counter where values are summed across bundles.
	//
	// Encoding: <value>
	//
	//	value: beam:coder:double:v1
	MonitoringInfoTypeUrns_SUM_DOUBLE_TYPE MonitoringInfoTypeUrns_Enum = 1
	// Represents a distribution of an integer value where:
	//   - count: represents the number of values seen across all bundles
	//   - sum: represents the total of the value across all bundles
	//   - min: represents the smallest value seen across all bundles
	//   - max: represents the largest value seen across all bundles
	//
	// Encoding: <count><sum><min><max>
	//   - count: beam:coder:varint:v1
	//   - sum:   beam:coder:varint:v1
	//   - min:   beam:coder:varint:v1
	//   - max:   beam:coder:varint:v1
	MonitoringInfoTypeUrns_DISTRIBUTION_INT64_TYPE MonitoringInfoTypeUrns_Enum = 2
	// Represents a distribution of a double value where:
	//   - count: represents the number of values seen across all bundles
	//   - sum: represents the total of the value across all bundles
	//   - min: represents the smallest value seen across all bundles
	//   - max: represents the largest value seen across all bundles
	//
	// Encoding: <count><sum><min><max>
	//   - count: beam:coder:varint:v1
	//   - sum:   beam:coder:double:v1
	//   - min:   beam:coder:double:v1
	//   - max:   beam:coder:double:v1
	MonitoringInfoTypeUrns_DISTRIBUTION_DOUBLE_TYPE MonitoringInfoTypeUrns_Enum = 3
	// Represents the latest seen integer value. The timestamp is used to
	// provide an "ordering" over multiple values to determine which is the
	// latest.
	//
	// Encoding: <timestamp><value>
	//   - timestamp: beam:coder:varint:v1     (milliseconds since epoch)
	//   - value:     beam:coder:varint:v1
	MonitoringInfoTypeUrns_LATEST_INT64_TYPE MonitoringInfoTypeUrns_Enum = 4
	// Represents the latest seen double value. The timestamp is used to
	// provide an "ordering" over multiple values to determine which is the
	// latest.
	//
	// Encoding: <timestamp><value>
	//   - timestamp: beam:coder:varint:v1     (milliseconds since epoch)
	//   - value:     beam:coder:double:v1
	MonitoringInfoTypeUrns_LATEST_DOUBLE_TYPE MonitoringInfoTypeUrns_Enum = 5
	// Represents the largest set of integer values seen across bundles.
	//
	// Encoding: <iter><value1><value2>...<valueN></iter>
	//   - iter:   beam:coder:iterable:v1
	//   - valueX: beam:coder:varint:v1
	MonitoringInfoTypeUrns_TOP_N_INT64_TYPE MonitoringInfoTypeUrns_Enum = 6
	// Represents the largest set of double values seen across bundles.
	//
	// Encoding: <iter><value1><value2>...<valueN></iter>
	//   - iter:   beam:coder:iterable:v1
	//   - valueX: beam:coder<beam:coder:double:v1
	MonitoringInfoTypeUrns_TOP_N_DOUBLE_TYPE MonitoringInfoTypeUrns_Enum = 7
	// Represents the smallest set of integer values seen across bundles.
	//
	// Encoding: <iter><value1><value2>...<valueN></iter>
	//   - iter:   beam:coder:iterable:v1
	//   - valueX: beam:coder:varint:v1
	MonitoringInfoTypeUrns_BOTTOM_N_INT64_TYPE MonitoringInfoTypeUrns_Enum = 8
	// Represents the smallest set of double values seen across bundles.
	//
	// Encoding: <iter><value1><value2>...<valueN></iter>
	//   - iter:   beam:coder:iterable:v1
	//   - valueX: beam:coder:double:v1
	MonitoringInfoTypeUrns_BOTTOM_N_DOUBLE_TYPE MonitoringInfoTypeUrns_Enum = 9
	// Encoding: <iter><value1><value2>...<valueN></iter>
	//   - iter:   beam:coder:iterable:v1
	//   - valueX: beam:coder:double:v1
	MonitoringInfoTypeUrns_PROGRESS_TYPE MonitoringInfoTypeUrns_Enum = 10
)

// Enum value maps for MonitoringInfoTypeUrns_Enum.
var (
	MonitoringInfoTypeUrns_Enum_name = map[int32]string{
		0:  "SUM_INT64_TYPE",
		1:  "SUM_DOUBLE_TYPE",
		2:  "DISTRIBUTION_INT64_TYPE",
		3:  "DISTRIBUTION_DOUBLE_TYPE",
		4:  "LATEST_INT64_TYPE",
		5:  "LATEST_DOUBLE_TYPE",
		6:  "TOP_N_INT64_TYPE",
		7:  "TOP_N_DOUBLE_TYPE",
		8:  "BOTTOM_N_INT64_TYPE",
		9:  "BOTTOM_N_DOUBLE_TYPE",
		10: "PROGRESS_TYPE",
	}
	MonitoringInfoTypeUrns_Enum_value = map[string]int32{
		"SUM_INT64_TYPE":           0,
		"SUM_DOUBLE_TYPE":          1,
		"DISTRIBUTION_INT64_TYPE":  2,
		"DISTRIBUTION_DOUBLE_TYPE": 3,
		"LATEST_INT64_TYPE":        4,
		"LATEST_DOUBLE_TYPE":       5,
		"TOP_N_INT64_TYPE":         6,
		"TOP_N_DOUBLE_TYPE":        7,
		"BOTTOM_N_INT64_TYPE":      8,
		"BOTTOM_N_DOUBLE_TYPE":     9,
		"PROGRESS_TYPE":            10,
	}
)

func (x MonitoringInfoTypeUrns_Enum) Enum() *MonitoringInfoTypeUrns_Enum {
	p := new(MonitoringInfoTypeUrns_Enum)
	*p = x
	return p
}

func (x MonitoringInfoTypeUrns_Enum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MonitoringInfoTypeUrns_Enum) Descriptor() protoreflect.EnumDescriptor {
	return file_org_apache_beam_model_pipeline_v1_metrics_proto_enumTypes[2].Descriptor()
}

func (MonitoringInfoTypeUrns_Enum) Type() protoreflect.EnumType {
	return &file_org_apache_beam_model_pipeline_v1_metrics_proto_enumTypes[2]
}

func (x MonitoringInfoTypeUrns_Enum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MonitoringInfoTypeUrns_Enum.Descriptor instead.
func (MonitoringInfoTypeUrns_Enum) EnumDescriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDescGZIP(), []int{5, 0}
}

// A specification for describing a well known MonitoringInfo.
//
// All specifications are uniquely identified by the urn.
type MonitoringInfoSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines the semantic meaning of the metric or monitored state.
	//
	// See MonitoringInfoSpecs.Enum for the set of well known metrics/monitored
	// state.
	Urn string `protobuf:"bytes,1,opt,name=urn,proto3" json:"urn,omitempty"`
	// Defines the required encoding and aggregation method for the payload.
	//
	// See MonitoringInfoTypeUrns.Enum for the set of well known types.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// The list of required labels for the specified urn and type.
	RequiredLabels []string `protobuf:"bytes,3,rep,name=required_labels,json=requiredLabels,proto3" json:"required_labels,omitempty"`
	// Extra non functional parts of the spec for descriptive purposes.
	// i.e. description, units, etc.
	Annotations []*Annotation `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty"`
}

func (x *MonitoringInfoSpec) Reset() {
	*x = MonitoringInfoSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MonitoringInfoSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonitoringInfoSpec) ProtoMessage() {}

func (x *MonitoringInfoSpec) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MonitoringInfoSpec.ProtoReflect.Descriptor instead.
func (*MonitoringInfoSpec) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDescGZIP(), []int{0}
}

func (x *MonitoringInfoSpec) GetUrn() string {
	if x != nil {
		return x.Urn
	}
	return ""
}

func (x *MonitoringInfoSpec) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *MonitoringInfoSpec) GetRequiredLabels() []string {
	if x != nil {
		return x.RequiredLabels
	}
	return nil
}

func (x *MonitoringInfoSpec) GetAnnotations() []*Annotation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

// The key name and value string of MonitoringInfo annotations.
type Annotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Key   string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Annotation) Reset() {
	*x = Annotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Annotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Annotation) ProtoMessage() {}

func (x *Annotation) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Annotation.ProtoReflect.Descriptor instead.
func (*Annotation) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDescGZIP(), []int{1}
}

func (x *Annotation) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *Annotation) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// A set of well known MonitoringInfo specifications.
type MonitoringInfoSpecs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MonitoringInfoSpecs) Reset() {
	*x = MonitoringInfoSpecs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MonitoringInfoSpecs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonitoringInfoSpecs) ProtoMessage() {}

func (x *MonitoringInfoSpecs) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MonitoringInfoSpecs.ProtoReflect.Descriptor instead.
func (*MonitoringInfoSpecs) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDescGZIP(), []int{2}
}

// A set of properties for the MonitoringInfoLabel, this is useful to obtain
// the proper label string for the MonitoringInfoLabel.
type MonitoringInfoLabelProps struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The label key to use in the MonitoringInfo labels map.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *MonitoringInfoLabelProps) Reset() {
	*x = MonitoringInfoLabelProps{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MonitoringInfoLabelProps) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonitoringInfoLabelProps) ProtoMessage() {}

func (x *MonitoringInfoLabelProps) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MonitoringInfoLabelProps.ProtoReflect.Descriptor instead.
func (*MonitoringInfoLabelProps) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDescGZIP(), []int{3}
}

func (x *MonitoringInfoLabelProps) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type MonitoringInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) Defines the semantic meaning of the metric or monitored state.
	//
	// See MonitoringInfoSpecs.Enum for the set of well known metrics/monitored
	// state.
	Urn string `protobuf:"bytes,1,opt,name=urn,proto3" json:"urn,omitempty"`
	// (Required) Defines the encoding and aggregation method for the payload.
	//
	// See MonitoringInfoTypeUrns.Enum for the set of well known types.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// (Required) The metric or monitored state encoded as per the specification
	// defined by the type.
	Payload []byte `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	// A set of key and value labels which define the scope of the metric. For
	// well known URNs, the set of required labels is provided by the associated
	// MonitoringInfoSpec.
	//
	// Either a well defined entity id for matching the enum names in
	// the MonitoringInfoLabels enum or any arbitrary label
	// set by a custom metric or user metric.
	//
	// A monitoring system is expected to be able to aggregate the metrics
	// together for all updates having the same URN and labels. Some systems such
	// as Stackdriver will be able to aggregate the metrics using a subset of the
	// provided labels
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// This indicates the start of the time range over which this value was
	// measured.
	// This is needed by some external metric aggregation services
	// to indicate when the reporter of the metric first began collecting the
	// cumulative value for the timeseries.
	// If the SDK Harness restarts, it should reset the start_time, and reset
	// the collection of cumulative metrics (i.e. start to count again from 0).
	// HarnessMonitoringInfos should set this start_time once, when the
	// MonitoringInfo is first reported.
	// ProcessBundle MonitoringInfos should set a start_time for each bundle.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
}

func (x *MonitoringInfo) Reset() {
	*x = MonitoringInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MonitoringInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonitoringInfo) ProtoMessage() {}

func (x *MonitoringInfo) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MonitoringInfo.ProtoReflect.Descriptor instead.
func (*MonitoringInfo) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDescGZIP(), []int{4}
}

func (x *MonitoringInfo) GetUrn() string {
	if x != nil {
		return x.Urn
	}
	return ""
}

func (x *MonitoringInfo) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *MonitoringInfo) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *MonitoringInfo) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *MonitoringInfo) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

// A set of well known URNs that specify the encoding and aggregation method.
type MonitoringInfoTypeUrns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MonitoringInfoTypeUrns) Reset() {
	*x = MonitoringInfoTypeUrns{}
	if protoimpl.UnsafeEnabled {
		mi := &file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MonitoringInfoTypeUrns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MonitoringInfoTypeUrns) ProtoMessage() {}

func (x *MonitoringInfoTypeUrns) ProtoReflect() protoreflect.Message {
	mi := &file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MonitoringInfoTypeUrns.ProtoReflect.Descriptor instead.
func (*MonitoringInfoTypeUrns) Descriptor() ([]byte, []int) {
	return file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDescGZIP(), []int{5}
}

var file_org_apache_beam_model_pipeline_v1_metrics_proto_extTypes = []protoimpl.ExtensionInfo{
	{
		ExtendedType:  (*descriptorpb.EnumValueOptions)(nil),
		ExtensionType: (*MonitoringInfoLabelProps)(nil),
		Field:         127337796,
		Name:          "org.apache.beam.model.pipeline.v1.label_props",
		Tag:           "bytes,127337796,opt,name=label_props",
		Filename:      "org/apache/beam/model/pipeline/v1/metrics.proto",
	},
	{
		ExtendedType:  (*descriptorpb.EnumValueOptions)(nil),
		ExtensionType: (*MonitoringInfoSpec)(nil),
		Field:         207174266,
		Name:          "org.apache.beam.model.pipeline.v1.monitoring_info_spec",
		Tag:           "bytes,207174266,opt,name=monitoring_info_spec",
		Filename:      "org/apache/beam/model/pipeline/v1/metrics.proto",
	},
}

// Extension fields to descriptorpb.EnumValueOptions.
var (
	// optional org.apache.beam.model.pipeline.v1.MonitoringInfoLabelProps label_props = 127337796;
	E_LabelProps = &file_org_apache_beam_model_pipeline_v1_metrics_proto_extTypes[0] // From: commit 0x7970544.
	// Enum extension to store the MonitoringInfoSpecs.
	//
	// optional org.apache.beam.model.pipeline.v1.MonitoringInfoSpec monitoring_info_spec = 207174266;
	E_MonitoringInfoSpec = &file_org_apache_beam_model_pipeline_v1_metrics_proto_extTypes[1]
)

var File_org_apache_beam_model_pipeline_v1_metrics_proto protoreflect.FileDescriptor

var file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x6f, 0x72, 0x67, 0x2f, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2f, 0x62, 0x65, 0x61,
	0x6d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x21, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65,
	0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x1a, 0x37, 0x6f, 0x72, 0x67, 0x2f, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2f, 0x62, 0x65, 0x61, 0x6d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x70, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x65, 0x61, 0x6d, 0x5f, 0x72, 0x75, 0x6e,
	0x6e, 0x65, 0x72, 0x5f, 0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xb4, 0x01, 0x0a, 0x12, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x49,
	0x6e, 0x66, 0x6f, 0x53, 0x70, 0x65, 0x63, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x27, 0x0a,
	0x0f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x4f, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x6f, 0x72,
	0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x34, 0x0a, 0x0a, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xd1, 0x23,
	0x0a, 0x13, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f,
	0x53, 0x70, 0x65, 0x63, 0x73, 0x22, 0xb9, 0x23, 0x0a, 0x04, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0xa7,
	0x01, 0x0a, 0x0e, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x53, 0x55, 0x4d, 0x5f, 0x49, 0x4e, 0x54, 0x36,
	0x34, 0x10, 0x00, 0x1a, 0x92, 0x01, 0xd2, 0xa7, 0xa7, 0x96, 0x06, 0x8b, 0x01, 0x0a, 0x1d, 0x62,
	0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x3a, 0x75, 0x73, 0x65, 0x72, 0x3a,
	0x73, 0x75, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x12, 0x19, 0x62, 0x65,
	0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x73, 0x75, 0x6d, 0x5f, 0x69,
	0x6e, 0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x1a, 0x0a, 0x50, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46,
	0x4f, 0x52, 0x4d, 0x1a, 0x09, 0x4e, 0x41, 0x4d, 0x45, 0x53, 0x50, 0x41, 0x43, 0x45, 0x1a, 0x04,
	0x4e, 0x41, 0x4d, 0x45, 0x22, 0x32, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x23, 0x55, 0x52, 0x4e, 0x20, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x65,
	0x64, 0x20, 0x74, 0x6f, 0x20, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x75, 0x73, 0x65, 0x72,
	0x20, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x12, 0xaa, 0x01, 0x0a, 0x0f, 0x55, 0x53, 0x45,
	0x52, 0x5f, 0x53, 0x55, 0x4d, 0x5f, 0x44, 0x4f, 0x55, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x1a, 0x94,
	0x01, 0xd2, 0xa7, 0xa7, 0x96, 0x06, 0x8d, 0x01, 0x0a, 0x1e, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x3a, 0x75, 0x73, 0x65, 0x72, 0x3a, 0x73, 0x75, 0x6d, 0x5f, 0x64,
	0x6f, 0x75, 0x62, 0x6c, 0x65, 0x3a, 0x76, 0x31, 0x12, 0x1a, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x73, 0x75, 0x6d, 0x5f, 0x64, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x3a, 0x76, 0x31, 0x1a, 0x0a, 0x50, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x4f, 0x52, 0x4d,
	0x1a, 0x09, 0x4e, 0x41, 0x4d, 0x45, 0x53, 0x50, 0x41, 0x43, 0x45, 0x1a, 0x04, 0x4e, 0x41, 0x4d,
	0x45, 0x22, 0x32, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x23, 0x55, 0x52, 0x4e, 0x20, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x20, 0x74,
	0x6f, 0x20, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x75, 0x73, 0x65, 0x72, 0x20, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x2e, 0x12, 0xc2, 0x01, 0x0a, 0x17, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x44,
	0x49, 0x53, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x4e, 0x54, 0x36,
	0x34, 0x10, 0x02, 0x1a, 0xa4, 0x01, 0xd2, 0xa7, 0xa7, 0x96, 0x06, 0x9d, 0x01, 0x0a, 0x26, 0x62,
	0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x3a, 0x75, 0x73, 0x65, 0x72, 0x3a,
	0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x74,
	0x36, 0x34, 0x3a, 0x76, 0x31, 0x12, 0x22, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x3a, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x1a, 0x0a, 0x50, 0x54, 0x52, 0x41, 0x4e,
	0x53, 0x46, 0x4f, 0x52, 0x4d, 0x1a, 0x09, 0x4e, 0x41, 0x4d, 0x45, 0x53, 0x50, 0x41, 0x43, 0x45,
	0x1a, 0x04, 0x4e, 0x41, 0x4d, 0x45, 0x22, 0x32, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x55, 0x52, 0x4e, 0x20, 0x75, 0x74, 0x69, 0x6c, 0x69,
	0x7a, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x75, 0x73,
	0x65, 0x72, 0x20, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x12, 0xc5, 0x01, 0x0a, 0x18, 0x55,
	0x53, 0x45, 0x52, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x44, 0x4f, 0x55, 0x42, 0x4c, 0x45, 0x10, 0x03, 0x1a, 0xa6, 0x01, 0xd2, 0xa7, 0xa7, 0x96,
	0x06, 0x9f, 0x01, 0x0a, 0x27, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x3a, 0x75, 0x73, 0x65, 0x72, 0x3a, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x3a, 0x76, 0x31, 0x12, 0x23, 0x62, 0x65,
	0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x64, 0x69, 0x73, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x3a, 0x76,
	0x31, 0x1a, 0x0a, 0x50, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x4f, 0x52, 0x4d, 0x1a, 0x09, 0x4e,
	0x41, 0x4d, 0x45, 0x53, 0x50, 0x41, 0x43, 0x45, 0x1a, 0x04, 0x4e, 0x41, 0x4d, 0x45, 0x22, 0x32,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x55,
	0x52, 0x4e, 0x20, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x75, 0x73, 0x65, 0x72, 0x20, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x2e, 0x12, 0xb0, 0x01, 0x0a, 0x11, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x4c, 0x41, 0x54, 0x45,
	0x53, 0x54, 0x5f, 0x49, 0x4e, 0x54, 0x36, 0x34, 0x10, 0x04, 0x1a, 0x98, 0x01, 0xd2, 0xa7, 0xa7,
	0x96, 0x06, 0x91, 0x01, 0x0a, 0x20, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x3a, 0x75, 0x73, 0x65, 0x72, 0x3a, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x6e,
	0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x12, 0x1c, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x3a, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x6e, 0x74, 0x36,
	0x34, 0x3a, 0x76, 0x31, 0x1a, 0x0a, 0x50, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x4f, 0x52, 0x4d,
	0x1a, 0x09, 0x4e, 0x41, 0x4d, 0x45, 0x53, 0x50, 0x41, 0x43, 0x45, 0x1a, 0x04, 0x4e, 0x41, 0x4d,
	0x45, 0x22, 0x32, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x23, 0x55, 0x52, 0x4e, 0x20, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x20, 0x74,
	0x6f, 0x20, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x75, 0x73, 0x65, 0x72, 0x20, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x2e, 0x12, 0xb3, 0x01, 0x0a, 0x12, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x4c,
	0x41, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x44, 0x4f, 0x55, 0x42, 0x4c, 0x45, 0x10, 0x05, 0x1a, 0x9a,
	0x01, 0xd2, 0xa7, 0xa7, 0x96, 0x06, 0x93, 0x01, 0x0a, 0x21, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x3a, 0x75, 0x73, 0x65, 0x72, 0x3a, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x3a, 0x76, 0x31, 0x12, 0x1d, 0x62, 0x65, 0x61,
	0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74,
	0x5f, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x3a, 0x76, 0x31, 0x1a, 0x0a, 0x50, 0x54, 0x52, 0x41,
	0x4e, 0x53, 0x46, 0x4f, 0x52, 0x4d, 0x1a, 0x09, 0x4e, 0x41, 0x4d, 0x45, 0x53, 0x50, 0x41, 0x43,
	0x45, 0x1a, 0x04, 0x4e, 0x41, 0x4d, 0x45, 0x22, 0x32, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x55, 0x52, 0x4e, 0x20, 0x75, 0x74, 0x69, 0x6c,
	0x69, 0x7a, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x75,
	0x73, 0x65, 0x72, 0x20, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x12, 0xad, 0x01, 0x0a, 0x10,
	0x55, 0x53, 0x45, 0x52, 0x5f, 0x54, 0x4f, 0x50, 0x5f, 0x4e, 0x5f, 0x49, 0x4e, 0x54, 0x36, 0x34,
	0x10, 0x06, 0x1a, 0x96, 0x01, 0xd2, 0xa7, 0xa7, 0x96, 0x06, 0x8f, 0x01, 0x0a, 0x1f, 0x62, 0x65,
	0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x3a, 0x75, 0x73, 0x65, 0x72, 0x3a, 0x74,
	0x6f, 0x70, 0x5f, 0x6e, 0x5f, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x12, 0x1b, 0x62,
	0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x74, 0x6f, 0x70, 0x5f,
	0x6e, 0x5f, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x1a, 0x0a, 0x50, 0x54, 0x52, 0x41,
	0x4e, 0x53, 0x46, 0x4f, 0x52, 0x4d, 0x1a, 0x09, 0x4e, 0x41, 0x4d, 0x45, 0x53, 0x50, 0x41, 0x43,
	0x45, 0x1a, 0x04, 0x4e, 0x41, 0x4d, 0x45, 0x22, 0x32, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x55, 0x52, 0x4e, 0x20, 0x75, 0x74, 0x69, 0x6c,
	0x69, 0x7a, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x75,
	0x73, 0x65, 0x72, 0x20, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x12, 0xb0, 0x01, 0x0a, 0x11,
	0x55, 0x53, 0x45, 0x52, 0x5f, 0x54, 0x4f, 0x50, 0x5f, 0x4e, 0x5f, 0x44, 0x4f, 0x55, 0x42, 0x4c,
	0x45, 0x10, 0x07, 0x1a, 0x98, 0x01, 0xd2, 0xa7, 0xa7, 0x96, 0x06, 0x91, 0x01, 0x0a, 0x20, 0x62,
	0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x3a, 0x75, 0x73, 0x65, 0x72, 0x3a,
	0x74, 0x6f, 0x70, 0x5f, 0x6e, 0x5f, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x3a, 0x76, 0x31, 0x12,
	0x1c, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x74, 0x6f,
	0x70, 0x5f, 0x6e, 0x5f, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x3a, 0x76, 0x31, 0x1a, 0x0a, 0x50,
	0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x4f, 0x52, 0x4d, 0x1a, 0x09, 0x4e, 0x41, 0x4d, 0x45, 0x53,
	0x50, 0x41, 0x43, 0x45, 0x1a, 0x04, 0x4e, 0x41, 0x4d, 0x45, 0x22, 0x32, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x55, 0x52, 0x4e, 0x20, 0x75,
	0x74, 0x69, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x20, 0x75, 0x73, 0x65, 0x72, 0x20, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x12, 0xb6,
	0x01, 0x0a, 0x13, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x42, 0x4f, 0x54, 0x54, 0x4f, 0x4d, 0x5f, 0x4e,
	0x5f, 0x49, 0x4e, 0x54, 0x36, 0x34, 0x10, 0x08, 0x1a, 0x9c, 0x01, 0xd2, 0xa7, 0xa7, 0x96, 0x06,
	0x95, 0x01, 0x0a, 0x22, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x3a,
	0x75, 0x73, 0x65, 0x72, 0x3a, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x5f, 0x6e, 0x5f, 0x69, 0x6e,
	0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x12, 0x1e, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x3a, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x5f, 0x6e, 0x5f, 0x69, 0x6e,
	0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x1a, 0x0a, 0x50, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x4f,
	0x52, 0x4d, 0x1a, 0x09, 0x4e, 0x41, 0x4d, 0x45, 0x53, 0x50, 0x41, 0x43, 0x45, 0x1a, 0x04, 0x4e,
	0x41, 0x4d, 0x45, 0x22, 0x32, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x23, 0x55, 0x52, 0x4e, 0x20, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x65, 0x64,
	0x20, 0x74, 0x6f, 0x20, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x75, 0x73, 0x65, 0x72, 0x20,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x12, 0xb9, 0x01, 0x0a, 0x14, 0x55, 0x53, 0x45, 0x52,
	0x5f, 0x42, 0x4f, 0x54, 0x54, 0x4f, 0x4d, 0x5f, 0x4e, 0x5f, 0x44, 0x4f, 0x55, 0x42, 0x4c, 0x45,
	0x10, 0x09, 0x1a, 0x9e, 0x01, 0xd2, 0xa7, 0xa7, 0x96, 0x06, 0x97, 0x01, 0x0a, 0x23, 0x62, 0x65,
	0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x3a, 0x75, 0x73, 0x65, 0x72, 0x3a, 0x62,
	0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x5f, 0x6e, 0x5f, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x3a, 0x76,
	0x31, 0x12, 0x1f, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a,
	0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x5f, 0x6e, 0x5f, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x3a,
	0x76, 0x31, 0x1a, 0x0a, 0x50, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x4f, 0x52, 0x4d, 0x1a, 0x09,
	0x4e, 0x41, 0x4d, 0x45, 0x53, 0x50, 0x41, 0x43, 0x45, 0x1a, 0x04, 0x4e, 0x41, 0x4d, 0x45, 0x22,
	0x32, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23,
	0x55, 0x52, 0x4e, 0x20, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20,
	0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x75, 0x73, 0x65, 0x72, 0x20, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x2e, 0x12, 0xad, 0x01, 0x0a, 0x0d, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f,
	0x43, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x0a, 0x1a, 0x99, 0x01, 0xd2, 0xa7, 0xa7, 0x96, 0x06, 0x92,
	0x01, 0x0a, 0x1c, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x3a, 0x65,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x3a, 0x76, 0x31, 0x12,
	0x19, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x73, 0x75,
	0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x1a, 0x0b, 0x50, 0x43, 0x4f, 0x4c,
	0x4c, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x22, 0x4a, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x54, 0x68, 0x65, 0x20, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x20, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x20, 0x50, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x20, 0x62, 0x79, 0x20, 0x61, 0x20, 0x50, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x12, 0xcd, 0x02, 0x0a, 0x11, 0x53, 0x41, 0x4d, 0x50, 0x4c, 0x45, 0x44, 0x5f,
	0x42, 0x59, 0x54, 0x45, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x10, 0x0b, 0x1a, 0xb5, 0x02, 0xd2, 0xa7,
	0xa7, 0x96, 0x06, 0xae, 0x02, 0x0a, 0x20, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x3a, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x3a, 0x76, 0x31, 0x12, 0x22, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x1a, 0x0b, 0x50, 0x43, 0x4f,
	0x4c, 0x4c, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x22, 0xd8, 0x01, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xc8, 0x01, 0x54, 0x68, 0x65, 0x20, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x20, 0x62, 0x79, 0x74, 0x65, 0x20, 0x73, 0x69, 0x7a, 0x65, 0x20, 0x61,
	0x6e, 0x64, 0x20, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x20, 0x73, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x64, 0x20, 0x20, 0x73, 0x65, 0x74, 0x20, 0x28, 0x6f, 0x72, 0x20, 0x61,
	0x6c, 0x6c, 0x29, 0x20, 0x6f, 0x66, 0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x20,
	0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x20, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x69, 0x73, 0x20,
	0x75, 0x73, 0x65, 0x64, 0x20, 0x20, 0x62, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x63, 0x61,
	0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 0x79,
	0x74, 0x65, 0x20, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x20, 0x69, 0x6e, 0x76, 0x6f, 0x6c, 0x76, 0x65,
	0x73, 0x20, 0x73, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x20, 0x77, 0x68, 0x69, 0x63,
	0x68, 0x20, 0x69, 0x73, 0x20, 0x43, 0x50, 0x55, 0x20, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x76, 0x65, 0x2e, 0x12, 0xd9, 0x01, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x42, 0x55,
	0x4e, 0x44, 0x4c, 0x45, 0x5f, 0x4d, 0x53, 0x45, 0x43, 0x53, 0x10, 0x0c, 0x1a, 0xc0, 0x01, 0xd2,
	0xa7, 0xa7, 0x96, 0x06, 0xb9, 0x01, 0x0a, 0x36, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x3a, 0x70, 0x61, 0x72, 0x64, 0x6f, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x3a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x62,
	0x75, 0x6e, 0x64, 0x6c, 0x65, 0x5f, 0x6d, 0x73, 0x65, 0x63, 0x73, 0x3a, 0x76, 0x31, 0x12, 0x19,
	0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x73, 0x75, 0x6d,
	0x5f, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x1a, 0x0a, 0x50, 0x54, 0x52, 0x41, 0x4e,
	0x53, 0x46, 0x4f, 0x52, 0x4d, 0x22, 0x58, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x54, 0x68, 0x65, 0x20, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x20,
	0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x20, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x20, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69, 0x6e, 0x20, 0x61, 0x20, 0x70, 0x61, 0x72, 0x64, 0x6f, 0x12,
	0xdf, 0x01, 0x0a, 0x14, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x42, 0x55, 0x4e, 0x44,
	0x4c, 0x45, 0x5f, 0x4d, 0x53, 0x45, 0x43, 0x53, 0x10, 0x0d, 0x1a, 0xc4, 0x01, 0xd2, 0xa7, 0xa7,
	0x96, 0x06, 0xbd, 0x01, 0x0a, 0x38, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x3a, 0x70, 0x61, 0x72, 0x64, 0x6f, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x3a, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62,
	0x75, 0x6e, 0x64, 0x6c, 0x65, 0x5f, 0x6d, 0x73, 0x65, 0x63, 0x73, 0x3a, 0x76, 0x31, 0x12, 0x19,
	0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x73, 0x75, 0x6d,
	0x5f, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x1a, 0x0a, 0x50, 0x54, 0x52, 0x41, 0x4e,
	0x53, 0x46, 0x4f, 0x52, 0x4d, 0x22, 0x5a, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x54, 0x68, 0x65, 0x20, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x20,
	0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x20, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x20, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x66, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69, 0x6e, 0x20, 0x61, 0x20, 0x70, 0x61, 0x72, 0x64,
	0x6f, 0x12, 0xdd, 0x01, 0x0a, 0x13, 0x46, 0x49, 0x4e, 0x49, 0x53, 0x48, 0x5f, 0x42, 0x55, 0x4e,
	0x44, 0x4c, 0x45, 0x5f, 0x4d, 0x53, 0x45, 0x43, 0x53, 0x10, 0x0e, 0x1a, 0xc3, 0x01, 0xd2, 0xa7,
	0xa7, 0x96, 0x06, 0xbc, 0x01, 0x0a, 0x37, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x3a, 0x70, 0x61, 0x72, 0x64, 0x6f, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x3a, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x5f, 0x62,
	0x75, 0x6e, 0x64, 0x6c, 0x65, 0x5f, 0x6d, 0x73, 0x65, 0x63, 0x73, 0x3a, 0x76, 0x31, 0x12, 0x19,
	0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x73, 0x75, 0x6d,
	0x5f, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x1a, 0x0a, 0x50, 0x54, 0x52, 0x41, 0x4e,
	0x53, 0x46, 0x4f, 0x52, 0x4d, 0x22, 0x5a, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x54, 0x68, 0x65, 0x20, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x20,
	0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x20, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x20, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x20, 0x66, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69, 0x6e, 0x20, 0x61, 0x20, 0x70, 0x61, 0x72, 0x64,
	0x6f, 0x12, 0xbb, 0x01, 0x0a, 0x0b, 0x54, 0x4f, 0x54, 0x41, 0x4c, 0x5f, 0x4d, 0x53, 0x45, 0x43,
	0x53, 0x10, 0x0f, 0x1a, 0xa9, 0x01, 0xd2, 0xa7, 0xa7, 0x96, 0x06, 0xa2, 0x01, 0x0a, 0x34, 0x62,
	0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x3a, 0x70, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x3a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x6d, 0x73, 0x65, 0x63, 0x73,
	0x3a, 0x76, 0x31, 0x12, 0x19, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x3a, 0x73, 0x75, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x1a, 0x0a,
	0x50, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x4f, 0x52, 0x4d, 0x22, 0x43, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x54, 0x68, 0x65, 0x20, 0x74,
	0x6f, 0x74, 0x61, 0x6c, 0x20, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x20, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x20, 0x6f, 0x66,
	0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x12,
	0x9f, 0x02, 0x0a, 0x0e, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x52, 0x45, 0x4d, 0x41, 0x49, 0x4e, 0x49,
	0x4e, 0x47, 0x10, 0x10, 0x1a, 0x8a, 0x02, 0xd2, 0xa7, 0xa7, 0x96, 0x06, 0x83, 0x02, 0x0a, 0x2c,
	0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x3a, 0x70, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x3a,
	0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x3a, 0x76, 0x31, 0x12, 0x18, 0x62, 0x65,
	0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x70, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x3a, 0x76, 0x31, 0x1a, 0x0a, 0x50, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x4f,
	0x52, 0x4d, 0x22, 0xac, 0x01, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x9c, 0x01, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x20, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x77, 0x6f, 0x72,
	0x6b, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x65, 0x61, 0x63, 0x68, 0x20, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x20, 0x45, 0x61, 0x63, 0x68, 0x20,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x72,
	0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x73, 0x20, 0x61, 0x6e, 0x20, 0x69, 0x6e, 0x64,
	0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x74, 0x20, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x20,
	0x6f, 0x66, 0x20, 0x77, 0x6f, 0x72, 0x6b, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x73, 0x68, 0x61, 0x72,
	0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x61, 0x6e, 0x79, 0x20, 0x6f, 0x74, 0x68, 0x65,
	0x72, 0x20, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x12, 0x9f, 0x02, 0x0a, 0x0e, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c,
	0x45, 0x54, 0x45, 0x44, 0x10, 0x11, 0x1a, 0x8a, 0x02, 0xd2, 0xa7, 0xa7, 0x96, 0x06, 0x83, 0x02,
	0x0a, 0x2c, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x3a, 0x70, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x3a, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x3a, 0x76, 0x31, 0x12, 0x18,
	0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x3a, 0x76, 0x31, 0x1a, 0x0a, 0x50, 0x54, 0x52, 0x41, 0x4e, 0x53,
	0x46, 0x4f, 0x52, 0x4d, 0x22, 0xac, 0x01, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x9c, 0x01, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x6d, 0x61, 0x69,
	0x6e, 0x69, 0x6e, 0x67, 0x20, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x77,
	0x6f, 0x72, 0x6b, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x65, 0x61, 0x63, 0x68, 0x20, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x20, 0x45, 0x61, 0x63,
	0x68, 0x20, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x20, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x73, 0x20, 0x61, 0x6e, 0x20, 0x69,
	0x6e, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x74, 0x20, 0x61, 0x6d, 0x6f, 0x75, 0x6e,
	0x74, 0x20, 0x6f, 0x66, 0x20, 0x77, 0x6f, 0x72, 0x6b, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x61, 0x6e, 0x79, 0x20, 0x6f, 0x74,
	0x68, 0x65, 0x72, 0x20, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x12, 0xa8, 0x01, 0x0a, 0x17, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x43, 0x48, 0x41,
	0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x49, 0x4e, 0x44, 0x45, 0x58, 0x10,
	0x12, 0x1a, 0x8a, 0x01, 0xd2, 0xa7, 0xa7, 0x96, 0x06, 0x83, 0x01, 0x0a, 0x26, 0x62, 0x65, 0x61,
	0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x3a, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x3a, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x3a, 0x76, 0x31, 0x12, 0x19, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x3a, 0x73, 0x75, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x1a, 0x0a,
	0x50, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x4f, 0x52, 0x4d, 0x22, 0x32, 0x0a, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x54, 0x68, 0x65, 0x20, 0x72,
	0x65, 0x61, 0x64, 0x20, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x64, 0x61, 0x74, 0x61, 0x20, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x12, 0x8a,
	0x02, 0x0a, 0x11, 0x41, 0x50, 0x49, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x43,
	0x4f, 0x55, 0x4e, 0x54, 0x10, 0x13, 0x1a, 0xf2, 0x01, 0xd2, 0xa7, 0xa7, 0x96, 0x06, 0xeb, 0x01,
	0x0a, 0x23, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x3a, 0x69, 0x6f,
	0x3a, 0x61, 0x70, 0x69, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x3a, 0x76, 0x31, 0x12, 0x19, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x3a, 0x73, 0x75, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x3a, 0x76, 0x31,
	0x1a, 0x07, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x1a, 0x06, 0x4d, 0x45, 0x54, 0x48, 0x4f,
	0x44, 0x1a, 0x08, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x1a, 0x0a, 0x50, 0x54, 0x52,
	0x41, 0x4e, 0x53, 0x46, 0x4f, 0x52, 0x4d, 0x1a, 0x06, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x22,
	0x62, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x20, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x20, 0x77,
	0x69, 0x74, 0x68, 0x20, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x20, 0x6d, 0x61, 0x64, 0x65, 0x20,
	0x74, 0x6f, 0x20, 0x49, 0x4f, 0x20, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x20, 0x41, 0x50,
	0x49, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x61, 0x74, 0x63, 0x68, 0x20, 0x72, 0x65, 0x61, 0x64,
	0x20, 0x6f, 0x72, 0x20, 0x77, 0x72, 0x69, 0x74, 0x65, 0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x2e, 0x22, 0x16, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x04, 0x74, 0x72, 0x75, 0x65, 0x12, 0xb3, 0x02, 0x0a, 0x15,
	0x41, 0x50, 0x49, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x4c, 0x41, 0x54, 0x45,
	0x4e, 0x43, 0x49, 0x45, 0x53, 0x10, 0x14, 0x1a, 0x97, 0x02, 0xd2, 0xa7, 0xa7, 0x96, 0x06, 0x90,
	0x02, 0x0a, 0x27, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x3a, 0x69,
	0x6f, 0x3a, 0x61, 0x70, 0x69, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6c, 0x61,
	0x74, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x3a, 0x76, 0x31, 0x12, 0x1f, 0x62, 0x65, 0x61, 0x6d,
	0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72,
	0x61, 0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x1a, 0x07, 0x53, 0x45, 0x52,
	0x56, 0x49, 0x43, 0x45, 0x1a, 0x06, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x1a, 0x08, 0x52, 0x45,
	0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x1a, 0x0a, 0x50, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x4f,
	0x52, 0x4d, 0x22, 0x6e, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x5f, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x20, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x20,
	0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x20, 0x6d, 0x61, 0x64, 0x65, 0x20, 0x74,
	0x6f, 0x20, 0x49, 0x4f, 0x20, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x20, 0x41, 0x50, 0x49,
	0x73, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x61, 0x74, 0x63, 0x68, 0x20, 0x72, 0x65, 0x61, 0x64, 0x20,
	0x6f, 0x72, 0x20, 0x77, 0x72, 0x69, 0x74, 0x65, 0x20, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2e, 0x22, 0x15, 0x0a, 0x05, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x12, 0x0c, 0x4d, 0x69, 0x6c,
	0x6c, 0x69, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x22, 0x16, 0x0a, 0x0e, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x04, 0x74, 0x72, 0x75,
	0x65, 0x22, 0x2e, 0x0a, 0x18, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x49,
	0x6e, 0x66, 0x6f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x50, 0x72, 0x6f, 0x70, 0x73, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xcd, 0x0b, 0x0a, 0x0e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x75, 0x72, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x70, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x12, 0x55, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0xad, 0x09, 0x0a, 0x14, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x49, 0x6e, 0x66, 0x6f, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x21, 0x0a, 0x09, 0x54, 0x52,
	0x41, 0x4e, 0x53, 0x46, 0x4f, 0x52, 0x4d, 0x10, 0x00, 0x1a, 0x12, 0xa2, 0xd4, 0xe0, 0xe5, 0x03,
	0x0c, 0x0a, 0x0a, 0x50, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x4f, 0x52, 0x4d, 0x12, 0x24, 0x0a,
	0x0b, 0x50, 0x43, 0x4f, 0x4c, 0x4c, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x1a, 0x13,
	0xa2, 0xd4, 0xe0, 0xe5, 0x03, 0x0d, 0x0a, 0x0b, 0x50, 0x43, 0x4f, 0x4c, 0x4c, 0x45, 0x43, 0x54,
	0x49, 0x4f, 0x4e, 0x12, 0x32, 0x0a, 0x12, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x49, 0x4e, 0x47,
	0x5f, 0x53, 0x54, 0x52, 0x41, 0x54, 0x45, 0x47, 0x59, 0x10, 0x02, 0x1a, 0x1a, 0xa2, 0xd4, 0xe0,
	0xe5, 0x03, 0x14, 0x0a, 0x12, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x49, 0x4e, 0x47, 0x5f, 0x53,
	0x54, 0x52, 0x41, 0x54, 0x45, 0x47, 0x59, 0x12, 0x18, 0x0a, 0x05, 0x43, 0x4f, 0x44, 0x45, 0x52,
	0x10, 0x03, 0x1a, 0x0d, 0xa2, 0xd4, 0xe0, 0xe5, 0x03, 0x07, 0x0a, 0x05, 0x43, 0x4f, 0x44, 0x45,
	0x52, 0x12, 0x24, 0x0a, 0x0b, 0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54,
	0x10, 0x04, 0x1a, 0x13, 0xa2, 0xd4, 0xe0, 0xe5, 0x03, 0x0d, 0x0a, 0x0b, 0x45, 0x4e, 0x56, 0x49,
	0x52, 0x4f, 0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x12, 0x20, 0x0a, 0x09, 0x4e, 0x41, 0x4d, 0x45, 0x53,
	0x50, 0x41, 0x43, 0x45, 0x10, 0x05, 0x1a, 0x11, 0xa2, 0xd4, 0xe0, 0xe5, 0x03, 0x0b, 0x0a, 0x09,
	0x4e, 0x41, 0x4d, 0x45, 0x53, 0x50, 0x41, 0x43, 0x45, 0x12, 0x16, 0x0a, 0x04, 0x4e, 0x41, 0x4d,
	0x45, 0x10, 0x06, 0x1a, 0x0c, 0xa2, 0xd4, 0xe0, 0xe5, 0x03, 0x06, 0x0a, 0x04, 0x4e, 0x41, 0x4d,
	0x45, 0x12, 0x1c, 0x0a, 0x07, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x07, 0x1a, 0x0f,
	0xa2, 0xd4, 0xe0, 0xe5, 0x03, 0x09, 0x0a, 0x07, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x12,
	0x1a, 0x0a, 0x06, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x10, 0x08, 0x1a, 0x0e, 0xa2, 0xd4, 0xe0,
	0xe5, 0x03, 0x08, 0x0a, 0x06, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x12, 0x1e, 0x0a, 0x08, 0x52,
	0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x10, 0x09, 0x1a, 0x10, 0xa2, 0xd4, 0xe0, 0xe5, 0x03,
	0x0a, 0x0a, 0x08, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x12, 0x1a, 0x0a, 0x06, 0x53,
	0x54, 0x41, 0x54, 0x55, 0x53, 0x10, 0x0a, 0x1a, 0x0e, 0xa2, 0xd4, 0xe0, 0xe5, 0x03, 0x08, 0x0a,
	0x06, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x12, 0x34, 0x0a, 0x13, 0x42, 0x49, 0x47, 0x51, 0x55,
	0x45, 0x52, 0x59, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x49, 0x44, 0x10, 0x0b,
	0x1a, 0x1b, 0xa2, 0xd4, 0xe0, 0xe5, 0x03, 0x15, 0x0a, 0x13, 0x42, 0x49, 0x47, 0x51, 0x55, 0x45,
	0x52, 0x59, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x49, 0x44, 0x12, 0x2e, 0x0a,
	0x10, 0x42, 0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x53, 0x45,
	0x54, 0x10, 0x0c, 0x1a, 0x18, 0xa2, 0xd4, 0xe0, 0xe5, 0x03, 0x12, 0x0a, 0x10, 0x42, 0x49, 0x47,
	0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x53, 0x45, 0x54, 0x12, 0x2a, 0x0a,
	0x0e, 0x42, 0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10,
	0x0d, 0x1a, 0x16, 0xa2, 0xd4, 0xe0, 0xe5, 0x03, 0x10, 0x0a, 0x0e, 0x42, 0x49, 0x47, 0x51, 0x55,
	0x45, 0x52, 0x59, 0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x12, 0x28, 0x0a, 0x0d, 0x42, 0x49, 0x47,
	0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x10, 0x0e, 0x1a, 0x15, 0xa2, 0xd4,
	0xe0, 0xe5, 0x03, 0x0f, 0x0a, 0x0d, 0x42, 0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x56,
	0x49, 0x45, 0x57, 0x12, 0x34, 0x0a, 0x13, 0x42, 0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f,
	0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x10, 0x0f, 0x1a, 0x1b, 0xa2, 0xd4,
	0xe0, 0xe5, 0x03, 0x15, 0x0a, 0x13, 0x42, 0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x51,
	0x55, 0x45, 0x52, 0x59, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x12, 0x22, 0x0a, 0x0a, 0x47, 0x43, 0x53,
	0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x10, 0x10, 0x1a, 0x12, 0xa2, 0xd4, 0xe0, 0xe5, 0x03,
	0x0c, 0x0a, 0x0a, 0x47, 0x43, 0x53, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x12, 0x2a, 0x0a,
	0x0e, 0x47, 0x43, 0x53, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x49, 0x44, 0x10,
	0x11, 0x1a, 0x16, 0xa2, 0xd4, 0xe0, 0xe5, 0x03, 0x10, 0x0a, 0x0e, 0x47, 0x43, 0x53, 0x5f, 0x50,
	0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x49, 0x44, 0x12, 0x30, 0x0a, 0x11, 0x44, 0x41, 0x54,
	0x41, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x10, 0x12,
	0x1a, 0x19, 0xa2, 0xd4, 0xe0, 0xe5, 0x03, 0x13, 0x0a, 0x11, 0x44, 0x41, 0x54, 0x41, 0x53, 0x54,
	0x4f, 0x52, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x12, 0x34, 0x0a, 0x13, 0x44,
	0x41, 0x54, 0x41, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x53, 0x50, 0x41,
	0x43, 0x45, 0x10, 0x13, 0x1a, 0x1b, 0xa2, 0xd4, 0xe0, 0xe5, 0x03, 0x15, 0x0a, 0x13, 0x44, 0x41,
	0x54, 0x41, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x53, 0x50, 0x41, 0x43,
	0x45, 0x12, 0x34, 0x0a, 0x13, 0x42, 0x49, 0x47, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x50, 0x52,
	0x4f, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x49, 0x44, 0x10, 0x14, 0x1a, 0x1b, 0xa2, 0xd4, 0xe0, 0xe5,
	0x03, 0x15, 0x0a, 0x13, 0x42, 0x49, 0x47, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x50, 0x52, 0x4f,
	0x4a, 0x45, 0x43, 0x54, 0x5f, 0x49, 0x44, 0x12, 0x24, 0x0a, 0x0b, 0x49, 0x4e, 0x53, 0x54, 0x41,
	0x4e, 0x43, 0x45, 0x5f, 0x49, 0x44, 0x10, 0x15, 0x1a, 0x13, 0xa2, 0xd4, 0xe0, 0xe5, 0x03, 0x0d,
	0x0a, 0x0b, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x49, 0x44, 0x12, 0x1e, 0x0a,
	0x08, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x49, 0x44, 0x10, 0x16, 0x1a, 0x10, 0xa2, 0xd4, 0xe0,
	0xe5, 0x03, 0x0a, 0x0a, 0x08, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x49, 0x44, 0x12, 0x32, 0x0a,
	0x12, 0x53, 0x50, 0x41, 0x4e, 0x4e, 0x45, 0x52, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54,
	0x5f, 0x49, 0x44, 0x10, 0x17, 0x1a, 0x1a, 0xa2, 0xd4, 0xe0, 0xe5, 0x03, 0x14, 0x0a, 0x12, 0x53,
	0x50, 0x41, 0x4e, 0x4e, 0x45, 0x52, 0x5f, 0x50, 0x52, 0x4f, 0x4a, 0x45, 0x43, 0x54, 0x5f, 0x49,
	0x44, 0x12, 0x34, 0x0a, 0x13, 0x53, 0x50, 0x41, 0x4e, 0x4e, 0x45, 0x52, 0x5f, 0x44, 0x41, 0x54,
	0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x49, 0x44, 0x10, 0x18, 0x1a, 0x1b, 0xa2, 0xd4, 0xe0, 0xe5,
	0x03, 0x15, 0x0a, 0x13, 0x53, 0x50, 0x41, 0x4e, 0x4e, 0x45, 0x52, 0x5f, 0x44, 0x41, 0x54, 0x41,
	0x42, 0x41, 0x53, 0x45, 0x5f, 0x49, 0x44, 0x12, 0x2e, 0x0a, 0x10, 0x53, 0x50, 0x41, 0x4e, 0x4e,
	0x45, 0x52, 0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x49, 0x44, 0x10, 0x19, 0x1a, 0x18, 0xa2,
	0xd4, 0xe0, 0xe5, 0x03, 0x12, 0x0a, 0x10, 0x53, 0x50, 0x41, 0x4e, 0x4e, 0x45, 0x52, 0x5f, 0x54,
	0x41, 0x42, 0x4c, 0x45, 0x5f, 0x49, 0x44, 0x12, 0x34, 0x0a, 0x13, 0x53, 0x50, 0x41, 0x4e, 0x4e,
	0x45, 0x52, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x49, 0x44, 0x10, 0x1a,
	0x1a, 0x1b, 0xa2, 0xd4, 0xe0, 0xe5, 0x03, 0x15, 0x0a, 0x13, 0x53, 0x50, 0x41, 0x4e, 0x4e, 0x45,
	0x52, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x49, 0x44, 0x12, 0x32, 0x0a,
	0x12, 0x53, 0x50, 0x41, 0x4e, 0x4e, 0x45, 0x52, 0x5f, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x4e,
	0x41, 0x4d, 0x45, 0x10, 0x1b, 0x1a, 0x1a, 0xa2, 0xd4, 0xe0, 0xe5, 0x03, 0x14, 0x0a, 0x12, 0x53,
	0x50, 0x41, 0x4e, 0x4e, 0x45, 0x52, 0x5f, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x4e, 0x41, 0x4d,
	0x45, 0x22, 0xbc, 0x05, 0x0a, 0x16, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x49, 0x6e, 0x66, 0x6f, 0x54, 0x79, 0x70, 0x65, 0x55, 0x72, 0x6e, 0x73, 0x22, 0xa1, 0x05, 0x0a,
	0x04, 0x45, 0x6e, 0x75, 0x6d, 0x12, 0x33, 0x0a, 0x0e, 0x53, 0x55, 0x4d, 0x5f, 0x49, 0x4e, 0x54,
	0x36, 0x34, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x00, 0x1a, 0x1f, 0xa2, 0xb4, 0xfa, 0xc2, 0x05,
	0x19, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x73, 0x75,
	0x6d, 0x5f, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x12, 0x35, 0x0a, 0x0f, 0x53, 0x55,
	0x4d, 0x5f, 0x44, 0x4f, 0x55, 0x42, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x01, 0x1a,
	0x20, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1a, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x3a, 0x73, 0x75, 0x6d, 0x5f, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x3a, 0x76,
	0x31, 0x12, 0x45, 0x0a, 0x17, 0x44, 0x49, 0x53, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x49, 0x4e, 0x54, 0x36, 0x34, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x02, 0x1a, 0x28,
	0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x22, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x3a, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x6e, 0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x12, 0x47, 0x0a, 0x18, 0x44, 0x49, 0x53, 0x54,
	0x52, 0x49, 0x42, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x4f, 0x55, 0x42, 0x4c, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x10, 0x03, 0x1a, 0x29, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x23, 0x62, 0x65,
	0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x64, 0x69, 0x73, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x3a, 0x76,
	0x31, 0x12, 0x39, 0x0a, 0x11, 0x4c, 0x41, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x49, 0x4e, 0x54, 0x36,
	0x34, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x04, 0x1a, 0x22, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1c,
	0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x74, 0x5f, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x12, 0x3b, 0x0a, 0x12,
	0x4c, 0x41, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x44, 0x4f, 0x55, 0x42, 0x4c, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x10, 0x05, 0x1a, 0x23, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1d, 0x62, 0x65, 0x61, 0x6d,
	0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f,
	0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x3a, 0x76, 0x31, 0x12, 0x37, 0x0a, 0x10, 0x54, 0x4f, 0x50,
	0x5f, 0x4e, 0x5f, 0x49, 0x4e, 0x54, 0x36, 0x34, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x06, 0x1a,
	0x21, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1b, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x3a, 0x74, 0x6f, 0x70, 0x5f, 0x6e, 0x5f, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x3a,
	0x76, 0x31, 0x12, 0x39, 0x0a, 0x11, 0x54, 0x4f, 0x50, 0x5f, 0x4e, 0x5f, 0x44, 0x4f, 0x55, 0x42,
	0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x07, 0x1a, 0x22, 0xa2, 0xb4, 0xfa, 0xc2, 0x05,
	0x1c, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x74, 0x6f,
	0x70, 0x5f, 0x6e, 0x5f, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x3a, 0x76, 0x31, 0x12, 0x3d, 0x0a,
	0x13, 0x42, 0x4f, 0x54, 0x54, 0x4f, 0x4d, 0x5f, 0x4e, 0x5f, 0x49, 0x4e, 0x54, 0x36, 0x34, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x10, 0x08, 0x1a, 0x24, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1e, 0x62, 0x65,
	0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x62, 0x6f, 0x74, 0x74, 0x6f,
	0x6d, 0x5f, 0x6e, 0x5f, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x3a, 0x76, 0x31, 0x12, 0x3f, 0x0a, 0x14,
	0x42, 0x4f, 0x54, 0x54, 0x4f, 0x4d, 0x5f, 0x4e, 0x5f, 0x44, 0x4f, 0x55, 0x42, 0x4c, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x10, 0x09, 0x1a, 0x25, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x1f, 0x62, 0x65,
	0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x62, 0x6f, 0x74, 0x74, 0x6f,
	0x6d, 0x5f, 0x6e, 0x5f, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x3a, 0x76, 0x31, 0x12, 0x31, 0x0a,
	0x0d, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x0a,
	0x1a, 0x1e, 0xa2, 0xb4, 0xfa, 0xc2, 0x05, 0x18, 0x62, 0x65, 0x61, 0x6d, 0x3a, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x3a, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x3a, 0x76, 0x31,
	0x3a, 0x82, 0x01, 0x0a, 0x0b, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x73,
	0x12, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0xc4, 0x8a, 0xdc, 0x3c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x6f,
	0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x50, 0x72, 0x6f, 0x70, 0x73, 0x52, 0x0a, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x50, 0x72, 0x6f, 0x70, 0x73, 0x3a, 0x8d, 0x01, 0x0a, 0x14, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x12, 0x21,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0xfa, 0xf4, 0xe4, 0x62, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x53, 0x70, 0x65,
	0x63, 0x52, 0x12, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66,
	0x6f, 0x53, 0x70, 0x65, 0x63, 0x42, 0x79, 0x0a, 0x21, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x0a, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x41, 0x70, 0x69, 0x5a, 0x48, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2f, 0x62, 0x65, 0x61, 0x6d, 0x2f, 0x73,
	0x64, 0x6b, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x67, 0x6f, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x62, 0x65,
	0x61, 0x6d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x76, 0x31, 0x3b, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x76, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDescOnce sync.Once
	file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDescData = file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDesc
)

func file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDescGZIP() []byte {
	file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDescOnce.Do(func() {
		file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDescData = protoimpl.X.CompressGZIP(file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDescData)
	})
	return file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDescData
}

var file_org_apache_beam_model_pipeline_v1_metrics_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_org_apache_beam_model_pipeline_v1_metrics_proto_goTypes = []interface{}{
	(MonitoringInfoSpecs_Enum)(0),            // 0: org.apache.beam.model.pipeline.v1.MonitoringInfoSpecs.Enum
	(MonitoringInfo_MonitoringInfoLabels)(0), // 1: org.apache.beam.model.pipeline.v1.MonitoringInfo.MonitoringInfoLabels
	(MonitoringInfoTypeUrns_Enum)(0),         // 2: org.apache.beam.model.pipeline.v1.MonitoringInfoTypeUrns.Enum
	(*MonitoringInfoSpec)(nil),               // 3: org.apache.beam.model.pipeline.v1.MonitoringInfoSpec
	(*Annotation)(nil),                       // 4: org.apache.beam.model.pipeline.v1.Annotation
	(*MonitoringInfoSpecs)(nil),              // 5: org.apache.beam.model.pipeline.v1.MonitoringInfoSpecs
	(*MonitoringInfoLabelProps)(nil),         // 6: org.apache.beam.model.pipeline.v1.MonitoringInfoLabelProps
	(*MonitoringInfo)(nil),                   // 7: org.apache.beam.model.pipeline.v1.MonitoringInfo
	(*MonitoringInfoTypeUrns)(nil),           // 8: org.apache.beam.model.pipeline.v1.MonitoringInfoTypeUrns
	nil,                                      // 9: org.apache.beam.model.pipeline.v1.MonitoringInfo.LabelsEntry
	(*timestamppb.Timestamp)(nil),            // 10: google.protobuf.Timestamp
	(*descriptorpb.EnumValueOptions)(nil),    // 11: google.protobuf.EnumValueOptions
}
var file_org_apache_beam_model_pipeline_v1_metrics_proto_depIdxs = []int32{
	4,  // 0: org.apache.beam.model.pipeline.v1.MonitoringInfoSpec.annotations:type_name -> org.apache.beam.model.pipeline.v1.Annotation
	9,  // 1: org.apache.beam.model.pipeline.v1.MonitoringInfo.labels:type_name -> org.apache.beam.model.pipeline.v1.MonitoringInfo.LabelsEntry
	10, // 2: org.apache.beam.model.pipeline.v1.MonitoringInfo.start_time:type_name -> google.protobuf.Timestamp
	11, // 3: org.apache.beam.model.pipeline.v1.label_props:extendee -> google.protobuf.EnumValueOptions
	11, // 4: org.apache.beam.model.pipeline.v1.monitoring_info_spec:extendee -> google.protobuf.EnumValueOptions
	6,  // 5: org.apache.beam.model.pipeline.v1.label_props:type_name -> org.apache.beam.model.pipeline.v1.MonitoringInfoLabelProps
	3,  // 6: org.apache.beam.model.pipeline.v1.monitoring_info_spec:type_name -> org.apache.beam.model.pipeline.v1.MonitoringInfoSpec
	7,  // [7:7] is the sub-list for method output_type
	7,  // [7:7] is the sub-list for method input_type
	5,  // [5:7] is the sub-list for extension type_name
	3,  // [3:5] is the sub-list for extension extendee
	0,  // [0:3] is the sub-list for field type_name
}

func init() { file_org_apache_beam_model_pipeline_v1_metrics_proto_init() }
func file_org_apache_beam_model_pipeline_v1_metrics_proto_init() {
	if File_org_apache_beam_model_pipeline_v1_metrics_proto != nil {
		return
	}
	file_org_apache_beam_model_pipeline_v1_beam_runner_api_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MonitoringInfoSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Annotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MonitoringInfoSpecs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MonitoringInfoLabelProps); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MonitoringInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MonitoringInfoTypeUrns); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   7,
			NumExtensions: 2,
			NumServices:   0,
		},
		GoTypes:           file_org_apache_beam_model_pipeline_v1_metrics_proto_goTypes,
		DependencyIndexes: file_org_apache_beam_model_pipeline_v1_metrics_proto_depIdxs,
		EnumInfos:         file_org_apache_beam_model_pipeline_v1_metrics_proto_enumTypes,
		MessageInfos:      file_org_apache_beam_model_pipeline_v1_metrics_proto_msgTypes,
		ExtensionInfos:    file_org_apache_beam_model_pipeline_v1_metrics_proto_extTypes,
	}.Build()
	File_org_apache_beam_model_pipeline_v1_metrics_proto = out.File
	file_org_apache_beam_model_pipeline_v1_metrics_proto_rawDesc = nil
	file_org_apache_beam_model_pipeline_v1_metrics_proto_goTypes = nil
	file_org_apache_beam_model_pipeline_v1_metrics_proto_depIdxs = nil
}
