#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

"""Generated message classes for storage version v1.

Stores and retrieves potentially large, immutable data objects.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import message_types as _message_types
from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types

package = 'storage'


class Bucket(_messages.Message):
  """A bucket.

  Messages:
    CorsValueListEntry: A CorsValueListEntry object.
    LifecycleValue: The bucket's lifecycle configuration. See lifecycle
      management for more information.
    LoggingValue: The bucket's logging configuration, which defines the
      destination bucket and optional name prefix for the current bucket's
      logs.
    OwnerValue: The owner of the bucket. This is always the project team's
      owner group.
    VersioningValue: The bucket's versioning configuration.
    WebsiteValue: The bucket's website configuration.

  Fields:
    acl: Access controls on the bucket.
    cors: The bucket's Cross-Origin Resource Sharing (CORS) configuration.
    defaultObjectAcl: Default access controls to apply to new objects when no
      ACL is provided.
    etag: HTTP 1.1 Entity tag for the bucket.
    id: The ID of the bucket.
    kind: The kind of item this is. For buckets, this is always
      storage#bucket.
    lifecycle: The bucket's lifecycle configuration. See lifecycle management
      for more information.
    location: The location of the bucket. Object data for objects in the
      bucket resides in physical storage within this region. Defaults to US.
      See the developer's guide for the authoritative list.
    logging: The bucket's logging configuration, which defines the destination
      bucket and optional name prefix for the current bucket's logs.
    metageneration: The metadata generation of this bucket.
    name: The name of the bucket.
    owner: The owner of the bucket. This is always the project team's owner
      group.
    projectNumber: The project number of the project the bucket belongs to.
    selfLink: The URI of this bucket.
    storageClass: The bucket's storage class. This defines how objects in the
      bucket are stored and determines the SLA and the cost of storage. Values
      include STANDARD, NEARLINE and DURABLE_REDUCED_AVAILABILITY. Defaults to
      STANDARD. For more information, see storage classes.
    timeCreated: The creation time of the bucket in RFC 3339 format.
    updated: The modification time of the bucket in RFC 3339 format.
    versioning: The bucket's versioning configuration.
    website: The bucket's website configuration.
  """

  class CorsValueListEntry(_messages.Message):
    """A CorsValueListEntry object.

    Fields:
      maxAgeSeconds: The value, in seconds, to return in the  Access-Control-
        Max-Age header used in preflight responses.
      method: The list of HTTP methods on which to include CORS response
        headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list
        of methods, and means "any method".
      origin: The list of Origins eligible to receive CORS response headers.
        Note: "*" is permitted in the list of origins, and means "any Origin".
      responseHeader: The list of HTTP headers other than the simple response
        headers to give permission for the user-agent to share across domains.
    """

    maxAgeSeconds = _messages.IntegerField(1, variant=_messages.Variant.INT32)
    method = _messages.StringField(2, repeated=True)
    origin = _messages.StringField(3, repeated=True)
    responseHeader = _messages.StringField(4, repeated=True)

  class LifecycleValue(_messages.Message):
    """The bucket's lifecycle configuration. See lifecycle management for more
    information.

    Messages:
      RuleValueListEntry: A RuleValueListEntry object.

    Fields:
      rule: A lifecycle management rule, which is made of an action to take
        and the condition(s) under which the action will be taken.
    """

    class RuleValueListEntry(_messages.Message):
      """A RuleValueListEntry object.

      Messages:
        ActionValue: The action to take.
        ConditionValue: The condition(s) under which the action will be taken.

      Fields:
        action: The action to take.
        condition: The condition(s) under which the action will be taken.
      """

      class ActionValue(_messages.Message):
        """The action to take.

        Fields:
          type: Type of the action. Currently, only Delete is supported.
        """

        type = _messages.StringField(1)

      class ConditionValue(_messages.Message):
        """The condition(s) under which the action will be taken.

        Fields:
          age: Age of an object (in days). This condition is satisfied when an
            object reaches the specified age.
          createdBefore: A date in RFC 3339 format with only the date part
            (for instance, "2013-01-15"). This condition is satisfied when an
            object is created before midnight of the specified date in UTC.
          isLive: Relevant only for versioned objects. If the value is true,
            this condition matches live objects; if the value is false, it
            matches archived objects.
          numNewerVersions: Relevant only for versioned objects. If the value
            is N, this condition is satisfied when there are at least N
            versions (including the live version) newer than this version of
            the object.
        """

        age = _messages.IntegerField(1, variant=_messages.Variant.INT32)
        createdBefore = extra_types.DateField(2)
        isLive = _messages.BooleanField(3)
        numNewerVersions = _messages.IntegerField(4, variant=_messages.Variant.INT32)

      action = _messages.MessageField('ActionValue', 1)
      condition = _messages.MessageField('ConditionValue', 2)

    rule = _messages.MessageField('RuleValueListEntry', 1, repeated=True)

  class LoggingValue(_messages.Message):
    """The bucket's logging configuration, which defines the destination
    bucket and optional name prefix for the current bucket's logs.

    Fields:
      logBucket: The destination bucket where the current bucket's logs should
        be placed.
      logObjectPrefix: A prefix for log object names.
    """

    logBucket = _messages.StringField(1)
    logObjectPrefix = _messages.StringField(2)

  class OwnerValue(_messages.Message):
    """The owner of the bucket. This is always the project team's owner group.

    Fields:
      entity: The entity, in the form project-owner-projectId.
      entityId: The ID for the entity.
    """

    entity = _messages.StringField(1)
    entityId = _messages.StringField(2)

  class VersioningValue(_messages.Message):
    """The bucket's versioning configuration.

    Fields:
      enabled: While set to true, versioning is fully enabled for this bucket.
    """

    enabled = _messages.BooleanField(1)

  class WebsiteValue(_messages.Message):
    """The bucket's website configuration.

    Fields:
      mainPageSuffix: Behaves as the bucket's directory index where missing
        objects are treated as potential directories.
      notFoundPage: The custom object to return when a requested resource is
        not found.
    """

    mainPageSuffix = _messages.StringField(1)
    notFoundPage = _messages.StringField(2)

  acl = _messages.MessageField('BucketAccessControl', 1, repeated=True)
  cors = _messages.MessageField('CorsValueListEntry', 2, repeated=True)
  defaultObjectAcl = _messages.MessageField('ObjectAccessControl', 3, repeated=True)
  etag = _messages.StringField(4)
  id = _messages.StringField(5)
  kind = _messages.StringField(6, default=u'storage#bucket')
  lifecycle = _messages.MessageField('LifecycleValue', 7)
  location = _messages.StringField(8)
  logging = _messages.MessageField('LoggingValue', 9)
  metageneration = _messages.IntegerField(10)
  name = _messages.StringField(11)
  owner = _messages.MessageField('OwnerValue', 12)
  projectNumber = _messages.IntegerField(13, variant=_messages.Variant.UINT64)
  selfLink = _messages.StringField(14)
  storageClass = _messages.StringField(15)
  timeCreated = _message_types.DateTimeField(16)
  updated = _message_types.DateTimeField(17)
  versioning = _messages.MessageField('VersioningValue', 18)
  website = _messages.MessageField('WebsiteValue', 19)


class BucketAccessControl(_messages.Message):
  """An access-control entry.

  Messages:
    ProjectTeamValue: The project team associated with the entity, if any.

  Fields:
    bucket: The name of the bucket.
    domain: The domain associated with the entity, if any.
    email: The email address associated with the entity, if any.
    entity: The entity holding the permission, in one of the following forms:
      - user-userId  - user-email  - group-groupId  - group-email  - domain-
      domain  - project-team-projectId  - allUsers  - allAuthenticatedUsers
      Examples:  - The user liz@example.com would be user-liz@example.com.  -
      The group example@googlegroups.com would be group-
      example@googlegroups.com.  - To refer to all members of the Google Apps
      for Business domain example.com, the entity would be domain-example.com.
    entityId: The ID for the entity, if any.
    etag: HTTP 1.1 Entity tag for the access-control entry.
    id: The ID of the access-control entry.
    kind: The kind of item this is. For bucket access control entries, this is
      always storage#bucketAccessControl.
    projectTeam: The project team associated with the entity, if any.
    role: The access permission for the entity. Can be READER, WRITER, or
      OWNER.
    selfLink: The link to this access-control entry.
  """

  class ProjectTeamValue(_messages.Message):
    """The project team associated with the entity, if any.

    Fields:
      projectNumber: The project number.
      team: The team. Can be owners, editors, or viewers.
    """

    projectNumber = _messages.StringField(1)
    team = _messages.StringField(2)

  bucket = _messages.StringField(1)
  domain = _messages.StringField(2)
  email = _messages.StringField(3)
  entity = _messages.StringField(4)
  entityId = _messages.StringField(5)
  etag = _messages.StringField(6)
  id = _messages.StringField(7)
  kind = _messages.StringField(8, default=u'storage#bucketAccessControl')
  projectTeam = _messages.MessageField('ProjectTeamValue', 9)
  role = _messages.StringField(10)
  selfLink = _messages.StringField(11)


class BucketAccessControls(_messages.Message):
  """An access-control list.

  Fields:
    items: The list of items.
    kind: The kind of item this is. For lists of bucket access control
      entries, this is always storage#bucketAccessControls.
  """

  items = _messages.MessageField('BucketAccessControl', 1, repeated=True)
  kind = _messages.StringField(2, default=u'storage#bucketAccessControls')


class Buckets(_messages.Message):
  """A list of buckets.

  Fields:
    items: The list of items.
    kind: The kind of item this is. For lists of buckets, this is always
      storage#buckets.
    nextPageToken: The continuation token, used to page through large result
      sets. Provide this value in a subsequent request to return the next page
      of results.
  """

  items = _messages.MessageField('Bucket', 1, repeated=True)
  kind = _messages.StringField(2, default=u'storage#buckets')
  nextPageToken = _messages.StringField(3)


class Channel(_messages.Message):
  """An notification channel used to watch for resource changes.

  Messages:
    ParamsValue: Additional parameters controlling delivery channel behavior.
      Optional.

  Fields:
    address: The address where notifications are delivered for this channel.
    expiration: Date and time of notification channel expiration, expressed as
      a Unix timestamp, in milliseconds. Optional.
    id: A UUID or similar unique string that identifies this channel.
    kind: Identifies this as a notification channel used to watch for changes
      to a resource. Value: the fixed string "api#channel".
    params: Additional parameters controlling delivery channel behavior.
      Optional.
    payload: A Boolean value to indicate whether payload is wanted. Optional.
    resourceId: An opaque ID that identifies the resource being watched on
      this channel. Stable across different API versions.
    resourceUri: A version-specific identifier for the watched resource.
    token: An arbitrary string delivered to the target address with each
      notification delivered over this channel. Optional.
    type: The type of delivery mechanism used for this channel.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParamsValue(_messages.Message):
    """Additional parameters controlling delivery channel behavior. Optional.

    Messages:
      AdditionalProperty: An additional property for a ParamsValue object.

    Fields:
      additionalProperties: Declares a new parameter by name.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ParamsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  address = _messages.StringField(1)
  expiration = _messages.IntegerField(2)
  id = _messages.StringField(3)
  kind = _messages.StringField(4, default=u'api#channel')
  params = _messages.MessageField('ParamsValue', 5)
  payload = _messages.BooleanField(6)
  resourceId = _messages.StringField(7)
  resourceUri = _messages.StringField(8)
  token = _messages.StringField(9)
  type = _messages.StringField(10)


class ComposeRequest(_messages.Message):
  """A Compose request.

  Messages:
    SourceObjectsValueListEntry: A SourceObjectsValueListEntry object.

  Fields:
    destination: Properties of the resulting object.
    kind: The kind of item this is.
    sourceObjects: The list of source objects that will be concatenated into a
      single object.
  """

  class SourceObjectsValueListEntry(_messages.Message):
    """A SourceObjectsValueListEntry object.

    Messages:
      ObjectPreconditionsValue: Conditions that must be met for this operation
        to execute.

    Fields:
      generation: The generation of this object to use as the source.
      name: The source object's name. The source object's bucket is implicitly
        the destination bucket.
      objectPreconditions: Conditions that must be met for this operation to
        execute.
    """

    class ObjectPreconditionsValue(_messages.Message):
      """Conditions that must be met for this operation to execute.

      Fields:
        ifGenerationMatch: Only perform the composition if the generation of
          the source object that would be used matches this value. If this
          value and a generation are both specified, they must be the same
          value or the call will fail.
      """

      ifGenerationMatch = _messages.IntegerField(1)

    generation = _messages.IntegerField(1)
    name = _messages.StringField(2)
    objectPreconditions = _messages.MessageField('ObjectPreconditionsValue', 3)

  destination = _messages.MessageField('Object', 1)
  kind = _messages.StringField(2, default=u'storage#composeRequest')
  sourceObjects = _messages.MessageField('SourceObjectsValueListEntry', 3, repeated=True)


class Object(_messages.Message):
  """An object.

  Messages:
    CustomerEncryptionValue: Metadata of customer-supplied encryption key, if
      the object is encrypted by such a key.
    MetadataValue: User-provided metadata, in key/value pairs.
    OwnerValue: The owner of the object. This will always be the uploader of
      the object.

  Fields:
    acl: Access controls on the object.
    bucket: The name of the bucket containing this object.
    cacheControl: Cache-Control directive for the object data.
    componentCount: Number of underlying components that make up this object.
      Components are accumulated by compose operations.
    contentDisposition: Content-Disposition of the object data.
    contentEncoding: Content-Encoding of the object data.
    contentLanguage: Content-Language of the object data.
    contentType: Content-Type of the object data.
    crc32c: CRC32c checksum, as described in RFC 4960, Appendix B; encoded
      using base64 in big-endian byte order. For more information about using
      the CRC32c checksum, see Hashes and ETags: Best Practices.
    customerEncryption: Metadata of customer-supplied encryption key, if the
      object is encrypted by such a key.
    etag: HTTP 1.1 Entity tag for the object.
    generation: The content generation of this object. Used for object
      versioning.
    id: The ID of the object.
    kind: The kind of item this is. For objects, this is always
      storage#object.
    md5Hash: MD5 hash of the data; encoded using base64. For more information
      about using the MD5 hash, see Hashes and ETags: Best Practices.
    mediaLink: Media download link.
    metadata: User-provided metadata, in key/value pairs.
    metageneration: The version of the metadata for this object at this
      generation. Used for preconditions and for detecting changes in
      metadata. A metageneration number is only meaningful in the context of a
      particular generation of a particular object.
    name: The name of this object. Required if not specified by URL parameter.
    owner: The owner of the object. This will always be the uploader of the
      object.
    selfLink: The link to this object.
    size: Content-Length of the data in bytes.
    storageClass: Storage class of the object.
    timeCreated: The creation time of the object in RFC 3339 format.
    timeDeleted: The deletion time of the object in RFC 3339 format. Will be
      returned if and only if this version of the object has been deleted.
    updated: The modification time of the object metadata in RFC 3339 format.
  """

  class CustomerEncryptionValue(_messages.Message):
    """Metadata of customer-supplied encryption key, if the object is
    encrypted by such a key.

    Fields:
      encryptionAlgorithm: The encryption algorithm.
      keySha256: SHA256 hash value of the encryption key.
    """

    encryptionAlgorithm = _messages.StringField(1)
    keySha256 = _messages.StringField(2)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    """User-provided metadata, in key/value pairs.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: An individual metadata entry.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  class OwnerValue(_messages.Message):
    """The owner of the object. This will always be the uploader of the
    object.

    Fields:
      entity: The entity, in the form user-userId.
      entityId: The ID for the entity.
    """

    entity = _messages.StringField(1)
    entityId = _messages.StringField(2)

  acl = _messages.MessageField('ObjectAccessControl', 1, repeated=True)
  bucket = _messages.StringField(2)
  cacheControl = _messages.StringField(3)
  componentCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  contentDisposition = _messages.StringField(5)
  contentEncoding = _messages.StringField(6)
  contentLanguage = _messages.StringField(7)
  contentType = _messages.StringField(8)
  crc32c = _messages.StringField(9)
  customerEncryption = _messages.MessageField('CustomerEncryptionValue', 10)
  etag = _messages.StringField(11)
  generation = _messages.IntegerField(12)
  id = _messages.StringField(13)
  kind = _messages.StringField(14, default=u'storage#object')
  md5Hash = _messages.StringField(15)
  mediaLink = _messages.StringField(16)
  metadata = _messages.MessageField('MetadataValue', 17)
  metageneration = _messages.IntegerField(18)
  name = _messages.StringField(19)
  owner = _messages.MessageField('OwnerValue', 20)
  selfLink = _messages.StringField(21)
  size = _messages.IntegerField(22, variant=_messages.Variant.UINT64)
  storageClass = _messages.StringField(23)
  timeCreated = _message_types.DateTimeField(24)
  timeDeleted = _message_types.DateTimeField(25)
  updated = _message_types.DateTimeField(26)


class ObjectAccessControl(_messages.Message):
  """An access-control entry.

  Messages:
    ProjectTeamValue: The project team associated with the entity, if any.

  Fields:
    bucket: The name of the bucket.
    domain: The domain associated with the entity, if any.
    email: The email address associated with the entity, if any.
    entity: The entity holding the permission, in one of the following forms:
      - user-userId  - user-email  - group-groupId  - group-email  - domain-
      domain  - project-team-projectId  - allUsers  - allAuthenticatedUsers
      Examples:  - The user liz@example.com would be user-liz@example.com.  -
      The group example@googlegroups.com would be group-
      example@googlegroups.com.  - To refer to all members of the Google Apps
      for Business domain example.com, the entity would be domain-example.com.
    entityId: The ID for the entity, if any.
    etag: HTTP 1.1 Entity tag for the access-control entry.
    generation: The content generation of the object.
    id: The ID of the access-control entry.
    kind: The kind of item this is. For object access control entries, this is
      always storage#objectAccessControl.
    object: The name of the object.
    projectTeam: The project team associated with the entity, if any.
    role: The access permission for the entity. Can be READER or OWNER.
    selfLink: The link to this access-control entry.
  """

  class ProjectTeamValue(_messages.Message):
    """The project team associated with the entity, if any.

    Fields:
      projectNumber: The project number.
      team: The team. Can be owners, editors, or viewers.
    """

    projectNumber = _messages.StringField(1)
    team = _messages.StringField(2)

  bucket = _messages.StringField(1)
  domain = _messages.StringField(2)
  email = _messages.StringField(3)
  entity = _messages.StringField(4)
  entityId = _messages.StringField(5)
  etag = _messages.StringField(6)
  generation = _messages.IntegerField(7)
  id = _messages.StringField(8)
  kind = _messages.StringField(9, default=u'storage#objectAccessControl')
  object = _messages.StringField(10)
  projectTeam = _messages.MessageField('ProjectTeamValue', 11)
  role = _messages.StringField(12)
  selfLink = _messages.StringField(13)


class ObjectAccessControls(_messages.Message):
  """An access-control list.

  Fields:
    items: The list of items.
    kind: The kind of item this is. For lists of object access control
      entries, this is always storage#objectAccessControls.
  """

  items = _messages.MessageField('extra_types.JsonValue', 1, repeated=True)
  kind = _messages.StringField(2, default=u'storage#objectAccessControls')


class Objects(_messages.Message):
  """A list of objects.

  Fields:
    items: The list of items.
    kind: The kind of item this is. For lists of objects, this is always
      storage#objects.
    nextPageToken: The continuation token, used to page through large result
      sets. Provide this value in a subsequent request to return the next page
      of results.
    prefixes: The list of prefixes of objects matching-but-not-listed up to
      and including the requested delimiter.
  """

  items = _messages.MessageField('Object', 1, repeated=True)
  kind = _messages.StringField(2, default=u'storage#objects')
  nextPageToken = _messages.StringField(3)
  prefixes = _messages.StringField(4, repeated=True)


class RewriteResponse(_messages.Message):
  """A rewrite response.

  Fields:
    done: true if the copy is finished; otherwise, false if the copy is in
      progress. This property is always present in the response.
    kind: The kind of item this is.
    objectSize: The total size of the object being copied in bytes. This
      property is always present in the response.
    resource: A resource containing the metadata for the copied-to object.
      This property is present in the response only when copying completes.
    rewriteToken: A token to use in subsequent requests to continue copying
      data. This token is present in the response only when there is more data
      to copy.
    totalBytesRewritten: The total bytes written so far, which can be used to
      provide a waiting user with a progress indicator. This property is
      always present in the response.
  """

  done = _messages.BooleanField(1)
  kind = _messages.StringField(2, default=u'storage#rewriteResponse')
  objectSize = _messages.IntegerField(3, variant=_messages.Variant.UINT64)
  resource = _messages.MessageField('Object', 4)
  rewriteToken = _messages.StringField(5)
  totalBytesRewritten = _messages.IntegerField(6, variant=_messages.Variant.UINT64)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    AltValueValuesEnum: Data format for the response.

  Fields:
    alt: Data format for the response.
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters. Overrides userIp if both are provided.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    userIp: IP address of the site where the request originates. Use this if
      you want to enforce per-user limits.
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for the response.

    Values:
      json: Responses with Content-Type of application/json
    """
    json = 0

  alt = _messages.EnumField('AltValueValuesEnum', 1, default=u'json')
  fields = _messages.StringField(2)
  key = _messages.StringField(3)
  oauth_token = _messages.StringField(4)
  prettyPrint = _messages.BooleanField(5, default=True)
  quotaUser = _messages.StringField(6)
  trace = _messages.StringField(7)
  userIp = _messages.StringField(8)


class StorageBucketAccessControlsDeleteRequest(_messages.Message):
  """A StorageBucketAccessControlsDeleteRequest object.

  Fields:
    bucket: Name of a bucket.
    entity: The entity holding the permission. Can be user-userId, user-
      emailAddress, group-groupId, group-emailAddress, allUsers, or
      allAuthenticatedUsers.
  """

  bucket = _messages.StringField(1, required=True)
  entity = _messages.StringField(2, required=True)


class StorageBucketAccessControlsDeleteResponse(_messages.Message):
  """An empty StorageBucketAccessControlsDelete response."""


class StorageBucketAccessControlsGetRequest(_messages.Message):
  """A StorageBucketAccessControlsGetRequest object.

  Fields:
    bucket: Name of a bucket.
    entity: The entity holding the permission. Can be user-userId, user-
      emailAddress, group-groupId, group-emailAddress, allUsers, or
      allAuthenticatedUsers.
  """

  bucket = _messages.StringField(1, required=True)
  entity = _messages.StringField(2, required=True)


class StorageBucketAccessControlsListRequest(_messages.Message):
  """A StorageBucketAccessControlsListRequest object.

  Fields:
    bucket: Name of a bucket.
  """

  bucket = _messages.StringField(1, required=True)


class StorageBucketsDeleteRequest(_messages.Message):
  """A StorageBucketsDeleteRequest object.

  Fields:
    bucket: Name of a bucket.
    ifMetagenerationMatch: If set, only deletes the bucket if its
      metageneration matches this value.
    ifMetagenerationNotMatch: If set, only deletes the bucket if its
      metageneration does not match this value.
  """

  bucket = _messages.StringField(1, required=True)
  ifMetagenerationMatch = _messages.IntegerField(2)
  ifMetagenerationNotMatch = _messages.IntegerField(3)


class StorageBucketsDeleteResponse(_messages.Message):
  """An empty StorageBucketsDelete response."""


class StorageBucketsGetRequest(_messages.Message):
  """A StorageBucketsGetRequest object.

  Enums:
    ProjectionValueValuesEnum: Set of properties to return. Defaults to noAcl.

  Fields:
    bucket: Name of a bucket.
    ifMetagenerationMatch: Makes the return of the bucket metadata conditional
      on whether the bucket's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the return of the bucket metadata
      conditional on whether the bucket's current metageneration does not
      match the given value.
    projection: Set of properties to return. Defaults to noAcl.
  """

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to noAcl.

    Values:
      full: Include all properties.
      noAcl: Omit acl and defaultObjectAcl properties.
    """
    full = 0
    noAcl = 1

  bucket = _messages.StringField(1, required=True)
  ifMetagenerationMatch = _messages.IntegerField(2)
  ifMetagenerationNotMatch = _messages.IntegerField(3)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 4)


class StorageBucketsInsertRequest(_messages.Message):
  """A StorageBucketsInsertRequest object.

  Enums:
    PredefinedAclValueValuesEnum: Apply a predefined set of access controls to
      this bucket.
    PredefinedDefaultObjectAclValueValuesEnum: Apply a predefined set of
      default object access controls to this bucket.
    ProjectionValueValuesEnum: Set of properties to return. Defaults to noAcl,
      unless the bucket resource specifies acl or defaultObjectAcl properties,
      when it defaults to full.

  Fields:
    bucket: A Bucket resource to be passed as the request body.
    predefinedAcl: Apply a predefined set of access controls to this bucket.
    predefinedDefaultObjectAcl: Apply a predefined set of default object
      access controls to this bucket.
    project: A valid API project identifier.
    projection: Set of properties to return. Defaults to noAcl, unless the
      bucket resource specifies acl or defaultObjectAcl properties, when it
      defaults to full.
  """

  class PredefinedAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of access controls to this bucket.

    Values:
      authenticatedRead: Project team owners get OWNER access, and
        allAuthenticatedUsers get READER access.
      private: Project team owners get OWNER access.
      projectPrivate: Project team members get access according to their
        roles.
      publicRead: Project team owners get OWNER access, and allUsers get
        READER access.
      publicReadWrite: Project team owners get OWNER access, and allUsers get
        WRITER access.
    """
    authenticatedRead = 0
    private = 1
    projectPrivate = 2
    publicRead = 3
    publicReadWrite = 4

  class PredefinedDefaultObjectAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of default object access controls to this
    bucket.

    Values:
      authenticatedRead: Object owner gets OWNER access, and
        allAuthenticatedUsers get READER access.
      bucketOwnerFullControl: Object owner gets OWNER access, and project team
        owners get OWNER access.
      bucketOwnerRead: Object owner gets OWNER access, and project team owners
        get READER access.
      private: Object owner gets OWNER access.
      projectPrivate: Object owner gets OWNER access, and project team members
        get access according to their roles.
      publicRead: Object owner gets OWNER access, and allUsers get READER
        access.
    """
    authenticatedRead = 0
    bucketOwnerFullControl = 1
    bucketOwnerRead = 2
    private = 3
    projectPrivate = 4
    publicRead = 5

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to noAcl, unless the bucket
    resource specifies acl or defaultObjectAcl properties, when it defaults to
    full.

    Values:
      full: Include all properties.
      noAcl: Omit acl and defaultObjectAcl properties.
    """
    full = 0
    noAcl = 1

  bucket = _messages.MessageField('Bucket', 1)
  predefinedAcl = _messages.EnumField('PredefinedAclValueValuesEnum', 2)
  predefinedDefaultObjectAcl = _messages.EnumField('PredefinedDefaultObjectAclValueValuesEnum', 3)
  project = _messages.StringField(4, required=True)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 5)


class StorageBucketsListRequest(_messages.Message):
  """A StorageBucketsListRequest object.

  Enums:
    ProjectionValueValuesEnum: Set of properties to return. Defaults to noAcl.

  Fields:
    maxResults: Maximum number of buckets to return.
    pageToken: A previously-returned page token representing part of the
      larger set of results to view.
    prefix: Filter results to buckets whose names begin with this prefix.
    project: A valid API project identifier.
    projection: Set of properties to return. Defaults to noAcl.
  """

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to noAcl.

    Values:
      full: Include all properties.
      noAcl: Omit acl and defaultObjectAcl properties.
    """
    full = 0
    noAcl = 1

  maxResults = _messages.IntegerField(1, variant=_messages.Variant.UINT32)
  pageToken = _messages.StringField(2)
  prefix = _messages.StringField(3)
  project = _messages.StringField(4, required=True)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 5)


class StorageBucketsPatchRequest(_messages.Message):
  """A StorageBucketsPatchRequest object.

  Enums:
    PredefinedAclValueValuesEnum: Apply a predefined set of access controls to
      this bucket.
    PredefinedDefaultObjectAclValueValuesEnum: Apply a predefined set of
      default object access controls to this bucket.
    ProjectionValueValuesEnum: Set of properties to return. Defaults to full.

  Fields:
    bucket: Name of a bucket.
    bucketResource: A Bucket resource to be passed as the request body.
    ifMetagenerationMatch: Makes the return of the bucket metadata conditional
      on whether the bucket's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the return of the bucket metadata
      conditional on whether the bucket's current metageneration does not
      match the given value.
    predefinedAcl: Apply a predefined set of access controls to this bucket.
    predefinedDefaultObjectAcl: Apply a predefined set of default object
      access controls to this bucket.
    projection: Set of properties to return. Defaults to full.
  """

  class PredefinedAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of access controls to this bucket.

    Values:
      authenticatedRead: Project team owners get OWNER access, and
        allAuthenticatedUsers get READER access.
      private: Project team owners get OWNER access.
      projectPrivate: Project team members get access according to their
        roles.
      publicRead: Project team owners get OWNER access, and allUsers get
        READER access.
      publicReadWrite: Project team owners get OWNER access, and allUsers get
        WRITER access.
    """
    authenticatedRead = 0
    private = 1
    projectPrivate = 2
    publicRead = 3
    publicReadWrite = 4

  class PredefinedDefaultObjectAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of default object access controls to this
    bucket.

    Values:
      authenticatedRead: Object owner gets OWNER access, and
        allAuthenticatedUsers get READER access.
      bucketOwnerFullControl: Object owner gets OWNER access, and project team
        owners get OWNER access.
      bucketOwnerRead: Object owner gets OWNER access, and project team owners
        get READER access.
      private: Object owner gets OWNER access.
      projectPrivate: Object owner gets OWNER access, and project team members
        get access according to their roles.
      publicRead: Object owner gets OWNER access, and allUsers get READER
        access.
    """
    authenticatedRead = 0
    bucketOwnerFullControl = 1
    bucketOwnerRead = 2
    private = 3
    projectPrivate = 4
    publicRead = 5

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to full.

    Values:
      full: Include all properties.
      noAcl: Omit acl and defaultObjectAcl properties.
    """
    full = 0
    noAcl = 1

  bucket = _messages.StringField(1, required=True)
  bucketResource = _messages.MessageField('Bucket', 2)
  ifMetagenerationMatch = _messages.IntegerField(3)
  ifMetagenerationNotMatch = _messages.IntegerField(4)
  predefinedAcl = _messages.EnumField('PredefinedAclValueValuesEnum', 5)
  predefinedDefaultObjectAcl = _messages.EnumField('PredefinedDefaultObjectAclValueValuesEnum', 6)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 7)


class StorageBucketsUpdateRequest(_messages.Message):
  """A StorageBucketsUpdateRequest object.

  Enums:
    PredefinedAclValueValuesEnum: Apply a predefined set of access controls to
      this bucket.
    PredefinedDefaultObjectAclValueValuesEnum: Apply a predefined set of
      default object access controls to this bucket.
    ProjectionValueValuesEnum: Set of properties to return. Defaults to full.

  Fields:
    bucket: Name of a bucket.
    bucketResource: A Bucket resource to be passed as the request body.
    ifMetagenerationMatch: Makes the return of the bucket metadata conditional
      on whether the bucket's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the return of the bucket metadata
      conditional on whether the bucket's current metageneration does not
      match the given value.
    predefinedAcl: Apply a predefined set of access controls to this bucket.
    predefinedDefaultObjectAcl: Apply a predefined set of default object
      access controls to this bucket.
    projection: Set of properties to return. Defaults to full.
  """

  class PredefinedAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of access controls to this bucket.

    Values:
      authenticatedRead: Project team owners get OWNER access, and
        allAuthenticatedUsers get READER access.
      private: Project team owners get OWNER access.
      projectPrivate: Project team members get access according to their
        roles.
      publicRead: Project team owners get OWNER access, and allUsers get
        READER access.
      publicReadWrite: Project team owners get OWNER access, and allUsers get
        WRITER access.
    """
    authenticatedRead = 0
    private = 1
    projectPrivate = 2
    publicRead = 3
    publicReadWrite = 4

  class PredefinedDefaultObjectAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of default object access controls to this
    bucket.

    Values:
      authenticatedRead: Object owner gets OWNER access, and
        allAuthenticatedUsers get READER access.
      bucketOwnerFullControl: Object owner gets OWNER access, and project team
        owners get OWNER access.
      bucketOwnerRead: Object owner gets OWNER access, and project team owners
        get READER access.
      private: Object owner gets OWNER access.
      projectPrivate: Object owner gets OWNER access, and project team members
        get access according to their roles.
      publicRead: Object owner gets OWNER access, and allUsers get READER
        access.
    """
    authenticatedRead = 0
    bucketOwnerFullControl = 1
    bucketOwnerRead = 2
    private = 3
    projectPrivate = 4
    publicRead = 5

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to full.

    Values:
      full: Include all properties.
      noAcl: Omit acl and defaultObjectAcl properties.
    """
    full = 0
    noAcl = 1

  bucket = _messages.StringField(1, required=True)
  bucketResource = _messages.MessageField('Bucket', 2)
  ifMetagenerationMatch = _messages.IntegerField(3)
  ifMetagenerationNotMatch = _messages.IntegerField(4)
  predefinedAcl = _messages.EnumField('PredefinedAclValueValuesEnum', 5)
  predefinedDefaultObjectAcl = _messages.EnumField('PredefinedDefaultObjectAclValueValuesEnum', 6)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 7)


class StorageChannelsStopResponse(_messages.Message):
  """An empty StorageChannelsStop response."""


class StorageDefaultObjectAccessControlsDeleteRequest(_messages.Message):
  """A StorageDefaultObjectAccessControlsDeleteRequest object.

  Fields:
    bucket: Name of a bucket.
    entity: The entity holding the permission. Can be user-userId, user-
      emailAddress, group-groupId, group-emailAddress, allUsers, or
      allAuthenticatedUsers.
  """

  bucket = _messages.StringField(1, required=True)
  entity = _messages.StringField(2, required=True)


class StorageDefaultObjectAccessControlsDeleteResponse(_messages.Message):
  """An empty StorageDefaultObjectAccessControlsDelete response."""


class StorageDefaultObjectAccessControlsGetRequest(_messages.Message):
  """A StorageDefaultObjectAccessControlsGetRequest object.

  Fields:
    bucket: Name of a bucket.
    entity: The entity holding the permission. Can be user-userId, user-
      emailAddress, group-groupId, group-emailAddress, allUsers, or
      allAuthenticatedUsers.
  """

  bucket = _messages.StringField(1, required=True)
  entity = _messages.StringField(2, required=True)


class StorageDefaultObjectAccessControlsListRequest(_messages.Message):
  """A StorageDefaultObjectAccessControlsListRequest object.

  Fields:
    bucket: Name of a bucket.
    ifMetagenerationMatch: If present, only return default ACL listing if the
      bucket's current metageneration matches this value.
    ifMetagenerationNotMatch: If present, only return default ACL listing if
      the bucket's current metageneration does not match the given value.
  """

  bucket = _messages.StringField(1, required=True)
  ifMetagenerationMatch = _messages.IntegerField(2)
  ifMetagenerationNotMatch = _messages.IntegerField(3)


class StorageObjectAccessControlsDeleteRequest(_messages.Message):
  """A StorageObjectAccessControlsDeleteRequest object.

  Fields:
    bucket: Name of a bucket.
    entity: The entity holding the permission. Can be user-userId, user-
      emailAddress, group-groupId, group-emailAddress, allUsers, or
      allAuthenticatedUsers.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
  """

  bucket = _messages.StringField(1, required=True)
  entity = _messages.StringField(2, required=True)
  generation = _messages.IntegerField(3)
  object = _messages.StringField(4, required=True)


class StorageObjectAccessControlsDeleteResponse(_messages.Message):
  """An empty StorageObjectAccessControlsDelete response."""


class StorageObjectAccessControlsGetRequest(_messages.Message):
  """A StorageObjectAccessControlsGetRequest object.

  Fields:
    bucket: Name of a bucket.
    entity: The entity holding the permission. Can be user-userId, user-
      emailAddress, group-groupId, group-emailAddress, allUsers, or
      allAuthenticatedUsers.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
  """

  bucket = _messages.StringField(1, required=True)
  entity = _messages.StringField(2, required=True)
  generation = _messages.IntegerField(3)
  object = _messages.StringField(4, required=True)


class StorageObjectAccessControlsInsertRequest(_messages.Message):
  """A StorageObjectAccessControlsInsertRequest object.

  Fields:
    bucket: Name of a bucket.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
    objectAccessControl: A ObjectAccessControl resource to be passed as the
      request body.
  """

  bucket = _messages.StringField(1, required=True)
  generation = _messages.IntegerField(2)
  object = _messages.StringField(3, required=True)
  objectAccessControl = _messages.MessageField('ObjectAccessControl', 4)


class StorageObjectAccessControlsListRequest(_messages.Message):
  """A StorageObjectAccessControlsListRequest object.

  Fields:
    bucket: Name of a bucket.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
  """

  bucket = _messages.StringField(1, required=True)
  generation = _messages.IntegerField(2)
  object = _messages.StringField(3, required=True)


class StorageObjectAccessControlsPatchRequest(_messages.Message):
  """A StorageObjectAccessControlsPatchRequest object.

  Fields:
    bucket: Name of a bucket.
    entity: The entity holding the permission. Can be user-userId, user-
      emailAddress, group-groupId, group-emailAddress, allUsers, or
      allAuthenticatedUsers.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
    objectAccessControl: A ObjectAccessControl resource to be passed as the
      request body.
  """

  bucket = _messages.StringField(1, required=True)
  entity = _messages.StringField(2, required=True)
  generation = _messages.IntegerField(3)
  object = _messages.StringField(4, required=True)
  objectAccessControl = _messages.MessageField('ObjectAccessControl', 5)


class StorageObjectAccessControlsUpdateRequest(_messages.Message):
  """A StorageObjectAccessControlsUpdateRequest object.

  Fields:
    bucket: Name of a bucket.
    entity: The entity holding the permission. Can be user-userId, user-
      emailAddress, group-groupId, group-emailAddress, allUsers, or
      allAuthenticatedUsers.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
    objectAccessControl: A ObjectAccessControl resource to be passed as the
      request body.
  """

  bucket = _messages.StringField(1, required=True)
  entity = _messages.StringField(2, required=True)
  generation = _messages.IntegerField(3)
  object = _messages.StringField(4, required=True)
  objectAccessControl = _messages.MessageField('ObjectAccessControl', 5)


class StorageObjectsComposeRequest(_messages.Message):
  """A StorageObjectsComposeRequest object.

  Enums:
    DestinationPredefinedAclValueValuesEnum: Apply a predefined set of access
      controls to the destination object.

  Fields:
    composeRequest: A ComposeRequest resource to be passed as the request
      body.
    destinationBucket: Name of the bucket in which to store the new object.
    destinationObject: Name of the new object. For information about how to
      URL encode object names to be path safe, see Encoding URI Path Parts.
    destinationPredefinedAcl: Apply a predefined set of access controls to the
      destination object.
    ifGenerationMatch: Makes the operation conditional on whether the object's
      current generation matches the given value.
    ifMetagenerationMatch: Makes the operation conditional on whether the
      object's current metageneration matches the given value.
  """

  class DestinationPredefinedAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of access controls to the destination object.

    Values:
      authenticatedRead: Object owner gets OWNER access, and
        allAuthenticatedUsers get READER access.
      bucketOwnerFullControl: Object owner gets OWNER access, and project team
        owners get OWNER access.
      bucketOwnerRead: Object owner gets OWNER access, and project team owners
        get READER access.
      private: Object owner gets OWNER access.
      projectPrivate: Object owner gets OWNER access, and project team members
        get access according to their roles.
      publicRead: Object owner gets OWNER access, and allUsers get READER
        access.
    """
    authenticatedRead = 0
    bucketOwnerFullControl = 1
    bucketOwnerRead = 2
    private = 3
    projectPrivate = 4
    publicRead = 5

  composeRequest = _messages.MessageField('ComposeRequest', 1)
  destinationBucket = _messages.StringField(2, required=True)
  destinationObject = _messages.StringField(3, required=True)
  destinationPredefinedAcl = _messages.EnumField('DestinationPredefinedAclValueValuesEnum', 4)
  ifGenerationMatch = _messages.IntegerField(5)
  ifMetagenerationMatch = _messages.IntegerField(6)


class StorageObjectsCopyRequest(_messages.Message):
  """A StorageObjectsCopyRequest object.

  Enums:
    DestinationPredefinedAclValueValuesEnum: Apply a predefined set of access
      controls to the destination object.
    ProjectionValueValuesEnum: Set of properties to return. Defaults to noAcl,
      unless the object resource specifies the acl property, when it defaults
      to full.

  Fields:
    destinationBucket: Name of the bucket in which to store the new object.
      Overrides the provided object metadata's bucket value, if any.For
      information about how to URL encode object names to be path safe, see
      Encoding URI Path Parts.
    destinationObject: Name of the new object. Required when the object
      metadata is not otherwise provided. Overrides the object metadata's name
      value, if any.
    destinationPredefinedAcl: Apply a predefined set of access controls to the
      destination object.
    ifGenerationMatch: Makes the operation conditional on whether the
      destination object's current generation matches the given value.
    ifGenerationNotMatch: Makes the operation conditional on whether the
      destination object's current generation does not match the given value.
    ifMetagenerationMatch: Makes the operation conditional on whether the
      destination object's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the operation conditional on whether the
      destination object's current metageneration does not match the given
      value.
    ifSourceGenerationMatch: Makes the operation conditional on whether the
      source object's generation matches the given value.
    ifSourceGenerationNotMatch: Makes the operation conditional on whether the
      source object's generation does not match the given value.
    ifSourceMetagenerationMatch: Makes the operation conditional on whether
      the source object's current metageneration matches the given value.
    ifSourceMetagenerationNotMatch: Makes the operation conditional on whether
      the source object's current metageneration does not match the given
      value.
    object: A Object resource to be passed as the request body.
    projection: Set of properties to return. Defaults to noAcl, unless the
      object resource specifies the acl property, when it defaults to full.
    sourceBucket: Name of the bucket in which to find the source object.
    sourceGeneration: If present, selects a specific revision of the source
      object (as opposed to the latest version, the default).
    sourceObject: Name of the source object. For information about how to URL
      encode object names to be path safe, see Encoding URI Path Parts.
  """

  class DestinationPredefinedAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of access controls to the destination object.

    Values:
      authenticatedRead: Object owner gets OWNER access, and
        allAuthenticatedUsers get READER access.
      bucketOwnerFullControl: Object owner gets OWNER access, and project team
        owners get OWNER access.
      bucketOwnerRead: Object owner gets OWNER access, and project team owners
        get READER access.
      private: Object owner gets OWNER access.
      projectPrivate: Object owner gets OWNER access, and project team members
        get access according to their roles.
      publicRead: Object owner gets OWNER access, and allUsers get READER
        access.
    """
    authenticatedRead = 0
    bucketOwnerFullControl = 1
    bucketOwnerRead = 2
    private = 3
    projectPrivate = 4
    publicRead = 5

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to noAcl, unless the object
    resource specifies the acl property, when it defaults to full.

    Values:
      full: Include all properties.
      noAcl: Omit the acl property.
    """
    full = 0
    noAcl = 1

  destinationBucket = _messages.StringField(1, required=True)
  destinationObject = _messages.StringField(2, required=True)
  destinationPredefinedAcl = _messages.EnumField('DestinationPredefinedAclValueValuesEnum', 3)
  ifGenerationMatch = _messages.IntegerField(4)
  ifGenerationNotMatch = _messages.IntegerField(5)
  ifMetagenerationMatch = _messages.IntegerField(6)
  ifMetagenerationNotMatch = _messages.IntegerField(7)
  ifSourceGenerationMatch = _messages.IntegerField(8)
  ifSourceGenerationNotMatch = _messages.IntegerField(9)
  ifSourceMetagenerationMatch = _messages.IntegerField(10)
  ifSourceMetagenerationNotMatch = _messages.IntegerField(11)
  object = _messages.MessageField('Object', 12)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 13)
  sourceBucket = _messages.StringField(14, required=True)
  sourceGeneration = _messages.IntegerField(15)
  sourceObject = _messages.StringField(16, required=True)


class StorageObjectsDeleteRequest(_messages.Message):
  """A StorageObjectsDeleteRequest object.

  Fields:
    bucket: Name of the bucket in which the object resides.
    generation: If present, permanently deletes a specific revision of this
      object (as opposed to the latest version, the default).
    ifGenerationMatch: Makes the operation conditional on whether the object's
      current generation matches the given value.
    ifGenerationNotMatch: Makes the operation conditional on whether the
      object's current generation does not match the given value.
    ifMetagenerationMatch: Makes the operation conditional on whether the
      object's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the operation conditional on whether the
      object's current metageneration does not match the given value.
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
  """

  bucket = _messages.StringField(1, required=True)
  generation = _messages.IntegerField(2)
  ifGenerationMatch = _messages.IntegerField(3)
  ifGenerationNotMatch = _messages.IntegerField(4)
  ifMetagenerationMatch = _messages.IntegerField(5)
  ifMetagenerationNotMatch = _messages.IntegerField(6)
  object = _messages.StringField(7, required=True)


class StorageObjectsDeleteResponse(_messages.Message):
  """An empty StorageObjectsDelete response."""


class StorageObjectsGetRequest(_messages.Message):
  """A StorageObjectsGetRequest object.

  Enums:
    ProjectionValueValuesEnum: Set of properties to return. Defaults to noAcl.

  Fields:
    bucket: Name of the bucket in which the object resides.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    ifGenerationMatch: Makes the operation conditional on whether the object's
      generation matches the given value.
    ifGenerationNotMatch: Makes the operation conditional on whether the
      object's generation does not match the given value.
    ifMetagenerationMatch: Makes the operation conditional on whether the
      object's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the operation conditional on whether the
      object's current metageneration does not match the given value.
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
    projection: Set of properties to return. Defaults to noAcl.
  """

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to noAcl.

    Values:
      full: Include all properties.
      noAcl: Omit the acl property.
    """
    full = 0
    noAcl = 1

  bucket = _messages.StringField(1, required=True)
  generation = _messages.IntegerField(2)
  ifGenerationMatch = _messages.IntegerField(3)
  ifGenerationNotMatch = _messages.IntegerField(4)
  ifMetagenerationMatch = _messages.IntegerField(5)
  ifMetagenerationNotMatch = _messages.IntegerField(6)
  object = _messages.StringField(7, required=True)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 8)


class StorageObjectsInsertRequest(_messages.Message):
  """A StorageObjectsInsertRequest object.

  Enums:
    PredefinedAclValueValuesEnum: Apply a predefined set of access controls to
      this object.
    ProjectionValueValuesEnum: Set of properties to return. Defaults to noAcl,
      unless the object resource specifies the acl property, when it defaults
      to full.

  Fields:
    bucket: Name of the bucket in which to store the new object. Overrides the
      provided object metadata's bucket value, if any.
    contentEncoding: If set, sets the contentEncoding property of the final
      object to this value. Setting this parameter is equivalent to setting
      the contentEncoding metadata property. This can be useful when uploading
      an object with uploadType=media to indicate the encoding of the content
      being uploaded.
    ifGenerationMatch: Makes the operation conditional on whether the object's
      current generation matches the given value.
    ifGenerationNotMatch: Makes the operation conditional on whether the
      object's current generation does not match the given value.
    ifMetagenerationMatch: Makes the operation conditional on whether the
      object's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the operation conditional on whether the
      object's current metageneration does not match the given value.
    name: Name of the object. Required when the object metadata is not
      otherwise provided. Overrides the object metadata's name value, if any.
      For information about how to URL encode object names to be path safe,
      see Encoding URI Path Parts.
    object: A Object resource to be passed as the request body.
    predefinedAcl: Apply a predefined set of access controls to this object.
    projection: Set of properties to return. Defaults to noAcl, unless the
      object resource specifies the acl property, when it defaults to full.
  """

  class PredefinedAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of access controls to this object.

    Values:
      authenticatedRead: Object owner gets OWNER access, and
        allAuthenticatedUsers get READER access.
      bucketOwnerFullControl: Object owner gets OWNER access, and project team
        owners get OWNER access.
      bucketOwnerRead: Object owner gets OWNER access, and project team owners
        get READER access.
      private: Object owner gets OWNER access.
      projectPrivate: Object owner gets OWNER access, and project team members
        get access according to their roles.
      publicRead: Object owner gets OWNER access, and allUsers get READER
        access.
    """
    authenticatedRead = 0
    bucketOwnerFullControl = 1
    bucketOwnerRead = 2
    private = 3
    projectPrivate = 4
    publicRead = 5

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to noAcl, unless the object
    resource specifies the acl property, when it defaults to full.

    Values:
      full: Include all properties.
      noAcl: Omit the acl property.
    """
    full = 0
    noAcl = 1

  bucket = _messages.StringField(1, required=True)
  contentEncoding = _messages.StringField(2)
  ifGenerationMatch = _messages.IntegerField(3)
  ifGenerationNotMatch = _messages.IntegerField(4)
  ifMetagenerationMatch = _messages.IntegerField(5)
  ifMetagenerationNotMatch = _messages.IntegerField(6)
  name = _messages.StringField(7)
  object = _messages.MessageField('Object', 8)
  predefinedAcl = _messages.EnumField('PredefinedAclValueValuesEnum', 9)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 10)


class StorageObjectsListRequest(_messages.Message):
  """A StorageObjectsListRequest object.

  Enums:
    ProjectionValueValuesEnum: Set of properties to return. Defaults to noAcl.

  Fields:
    bucket: Name of the bucket in which to look for objects.
    delimiter: Returns results in a directory-like mode. items will contain
      only objects whose names, aside from the prefix, do not contain
      delimiter. Objects whose names, aside from the prefix, contain delimiter
      will have their name, truncated after the delimiter, returned in
      prefixes. Duplicate prefixes are omitted.
    maxResults: Maximum number of items plus prefixes to return. As duplicate
      prefixes are omitted, fewer total results may be returned than
      requested. The default value of this parameter is 1,000 items.
    pageToken: A previously-returned page token representing part of the
      larger set of results to view.
    prefix: Filter results to objects whose names begin with this prefix.
    projection: Set of properties to return. Defaults to noAcl.
    versions: If true, lists all versions of an object as distinct results.
      The default is false. For more information, see Object Versioning.
  """

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to noAcl.

    Values:
      full: Include all properties.
      noAcl: Omit the acl property.
    """
    full = 0
    noAcl = 1

  bucket = _messages.StringField(1, required=True)
  delimiter = _messages.StringField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32)
  pageToken = _messages.StringField(4)
  prefix = _messages.StringField(5)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 6)
  versions = _messages.BooleanField(7)


class StorageObjectsPatchRequest(_messages.Message):
  """A StorageObjectsPatchRequest object.

  Enums:
    PredefinedAclValueValuesEnum: Apply a predefined set of access controls to
      this object.
    ProjectionValueValuesEnum: Set of properties to return. Defaults to full.

  Fields:
    bucket: Name of the bucket in which the object resides.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    ifGenerationMatch: Makes the operation conditional on whether the object's
      current generation matches the given value.
    ifGenerationNotMatch: Makes the operation conditional on whether the
      object's current generation does not match the given value.
    ifMetagenerationMatch: Makes the operation conditional on whether the
      object's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the operation conditional on whether the
      object's current metageneration does not match the given value.
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
    objectResource: A Object resource to be passed as the request body.
    predefinedAcl: Apply a predefined set of access controls to this object.
    projection: Set of properties to return. Defaults to full.
  """

  class PredefinedAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of access controls to this object.

    Values:
      authenticatedRead: Object owner gets OWNER access, and
        allAuthenticatedUsers get READER access.
      bucketOwnerFullControl: Object owner gets OWNER access, and project team
        owners get OWNER access.
      bucketOwnerRead: Object owner gets OWNER access, and project team owners
        get READER access.
      private: Object owner gets OWNER access.
      projectPrivate: Object owner gets OWNER access, and project team members
        get access according to their roles.
      publicRead: Object owner gets OWNER access, and allUsers get READER
        access.
    """
    authenticatedRead = 0
    bucketOwnerFullControl = 1
    bucketOwnerRead = 2
    private = 3
    projectPrivate = 4
    publicRead = 5

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to full.

    Values:
      full: Include all properties.
      noAcl: Omit the acl property.
    """
    full = 0
    noAcl = 1

  bucket = _messages.StringField(1, required=True)
  generation = _messages.IntegerField(2)
  ifGenerationMatch = _messages.IntegerField(3)
  ifGenerationNotMatch = _messages.IntegerField(4)
  ifMetagenerationMatch = _messages.IntegerField(5)
  ifMetagenerationNotMatch = _messages.IntegerField(6)
  object = _messages.StringField(7, required=True)
  objectResource = _messages.MessageField('Object', 8)
  predefinedAcl = _messages.EnumField('PredefinedAclValueValuesEnum', 9)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 10)


class StorageObjectsRewriteRequest(_messages.Message):
  """A StorageObjectsRewriteRequest object.

  Enums:
    DestinationPredefinedAclValueValuesEnum: Apply a predefined set of access
      controls to the destination object.
    ProjectionValueValuesEnum: Set of properties to return. Defaults to noAcl,
      unless the object resource specifies the acl property, when it defaults
      to full.

  Fields:
    destinationBucket: Name of the bucket in which to store the new object.
      Overrides the provided object metadata's bucket value, if any.
    destinationObject: Name of the new object. Required when the object
      metadata is not otherwise provided. Overrides the object metadata's name
      value, if any. For information about how to URL encode object names to
      be path safe, see Encoding URI Path Parts.
    destinationPredefinedAcl: Apply a predefined set of access controls to the
      destination object.
    ifGenerationMatch: Makes the operation conditional on whether the
      destination object's current generation matches the given value.
    ifGenerationNotMatch: Makes the operation conditional on whether the
      destination object's current generation does not match the given value.
    ifMetagenerationMatch: Makes the operation conditional on whether the
      destination object's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the operation conditional on whether the
      destination object's current metageneration does not match the given
      value.
    ifSourceGenerationMatch: Makes the operation conditional on whether the
      source object's generation matches the given value.
    ifSourceGenerationNotMatch: Makes the operation conditional on whether the
      source object's generation does not match the given value.
    ifSourceMetagenerationMatch: Makes the operation conditional on whether
      the source object's current metageneration matches the given value.
    ifSourceMetagenerationNotMatch: Makes the operation conditional on whether
      the source object's current metageneration does not match the given
      value.
    maxBytesRewrittenPerCall: The maximum number of bytes that will be
      rewritten per rewrite request. Most callers shouldn't need to specify
      this parameter - it is primarily in place to support testing. If
      specified the value must be an integral multiple of 1 MiB (1048576).
      Also, this only applies to requests where the source and destination
      span locations and/or storage classes. Finally, this value must not
      change across rewrite calls else you'll get an error that the
      rewriteToken is invalid.
    object: A Object resource to be passed as the request body.
    projection: Set of properties to return. Defaults to noAcl, unless the
      object resource specifies the acl property, when it defaults to full.
    rewriteToken: Include this field (from the previous rewrite response) on
      each rewrite request after the first one, until the rewrite response
      'done' flag is true. Calls that provide a rewriteToken can omit all
      other request fields, but if included those fields must match the values
      provided in the first rewrite request.
    sourceBucket: Name of the bucket in which to find the source object.
    sourceGeneration: If present, selects a specific revision of the source
      object (as opposed to the latest version, the default).
    sourceObject: Name of the source object. For information about how to URL
      encode object names to be path safe, see Encoding URI Path Parts.
  """

  class DestinationPredefinedAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of access controls to the destination object.

    Values:
      authenticatedRead: Object owner gets OWNER access, and
        allAuthenticatedUsers get READER access.
      bucketOwnerFullControl: Object owner gets OWNER access, and project team
        owners get OWNER access.
      bucketOwnerRead: Object owner gets OWNER access, and project team owners
        get READER access.
      private: Object owner gets OWNER access.
      projectPrivate: Object owner gets OWNER access, and project team members
        get access according to their roles.
      publicRead: Object owner gets OWNER access, and allUsers get READER
        access.
    """
    authenticatedRead = 0
    bucketOwnerFullControl = 1
    bucketOwnerRead = 2
    private = 3
    projectPrivate = 4
    publicRead = 5

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to noAcl, unless the object
    resource specifies the acl property, when it defaults to full.

    Values:
      full: Include all properties.
      noAcl: Omit the acl property.
    """
    full = 0
    noAcl = 1

  destinationBucket = _messages.StringField(1, required=True)
  destinationObject = _messages.StringField(2, required=True)
  destinationPredefinedAcl = _messages.EnumField('DestinationPredefinedAclValueValuesEnum', 3)
  ifGenerationMatch = _messages.IntegerField(4)
  ifGenerationNotMatch = _messages.IntegerField(5)
  ifMetagenerationMatch = _messages.IntegerField(6)
  ifMetagenerationNotMatch = _messages.IntegerField(7)
  ifSourceGenerationMatch = _messages.IntegerField(8)
  ifSourceGenerationNotMatch = _messages.IntegerField(9)
  ifSourceMetagenerationMatch = _messages.IntegerField(10)
  ifSourceMetagenerationNotMatch = _messages.IntegerField(11)
  maxBytesRewrittenPerCall = _messages.IntegerField(12)
  object = _messages.MessageField('Object', 13)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 14)
  rewriteToken = _messages.StringField(15)
  sourceBucket = _messages.StringField(16, required=True)
  sourceGeneration = _messages.IntegerField(17)
  sourceObject = _messages.StringField(18, required=True)


class StorageObjectsUpdateRequest(_messages.Message):
  """A StorageObjectsUpdateRequest object.

  Enums:
    PredefinedAclValueValuesEnum: Apply a predefined set of access controls to
      this object.
    ProjectionValueValuesEnum: Set of properties to return. Defaults to full.

  Fields:
    bucket: Name of the bucket in which the object resides.
    generation: If present, selects a specific revision of this object (as
      opposed to the latest version, the default).
    ifGenerationMatch: Makes the operation conditional on whether the object's
      current generation matches the given value.
    ifGenerationNotMatch: Makes the operation conditional on whether the
      object's current generation does not match the given value.
    ifMetagenerationMatch: Makes the operation conditional on whether the
      object's current metageneration matches the given value.
    ifMetagenerationNotMatch: Makes the operation conditional on whether the
      object's current metageneration does not match the given value.
    object: Name of the object. For information about how to URL encode object
      names to be path safe, see Encoding URI Path Parts.
    objectResource: A Object resource to be passed as the request body.
    predefinedAcl: Apply a predefined set of access controls to this object.
    projection: Set of properties to return. Defaults to full.
  """

  class PredefinedAclValueValuesEnum(_messages.Enum):
    """Apply a predefined set of access controls to this object.

    Values:
      authenticatedRead: Object owner gets OWNER access, and
        allAuthenticatedUsers get READER access.
      bucketOwnerFullControl: Object owner gets OWNER access, and project team
        owners get OWNER access.
      bucketOwnerRead: Object owner gets OWNER access, and project team owners
        get READER access.
      private: Object owner gets OWNER access.
      projectPrivate: Object owner gets OWNER access, and project team members
        get access according to their roles.
      publicRead: Object owner gets OWNER access, and allUsers get READER
        access.
    """
    authenticatedRead = 0
    bucketOwnerFullControl = 1
    bucketOwnerRead = 2
    private = 3
    projectPrivate = 4
    publicRead = 5

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to full.

    Values:
      full: Include all properties.
      noAcl: Omit the acl property.
    """
    full = 0
    noAcl = 1

  bucket = _messages.StringField(1, required=True)
  generation = _messages.IntegerField(2)
  ifGenerationMatch = _messages.IntegerField(3)
  ifGenerationNotMatch = _messages.IntegerField(4)
  ifMetagenerationMatch = _messages.IntegerField(5)
  ifMetagenerationNotMatch = _messages.IntegerField(6)
  object = _messages.StringField(7, required=True)
  objectResource = _messages.MessageField('Object', 8)
  predefinedAcl = _messages.EnumField('PredefinedAclValueValuesEnum', 9)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 10)


class StorageObjectsWatchAllRequest(_messages.Message):
  """A StorageObjectsWatchAllRequest object.

  Enums:
    ProjectionValueValuesEnum: Set of properties to return. Defaults to noAcl.

  Fields:
    bucket: Name of the bucket in which to look for objects.
    channel: A Channel resource to be passed as the request body.
    delimiter: Returns results in a directory-like mode. items will contain
      only objects whose names, aside from the prefix, do not contain
      delimiter. Objects whose names, aside from the prefix, contain delimiter
      will have their name, truncated after the delimiter, returned in
      prefixes. Duplicate prefixes are omitted.
    maxResults: Maximum number of items plus prefixes to return. As duplicate
      prefixes are omitted, fewer total results may be returned than
      requested. The default value of this parameter is 1,000 items.
    pageToken: A previously-returned page token representing part of the
      larger set of results to view.
    prefix: Filter results to objects whose names begin with this prefix.
    projection: Set of properties to return. Defaults to noAcl.
    versions: If true, lists all versions of an object as distinct results.
      The default is false. For more information, see Object Versioning.
  """

  class ProjectionValueValuesEnum(_messages.Enum):
    """Set of properties to return. Defaults to noAcl.

    Values:
      full: Include all properties.
      noAcl: Omit the acl property.
    """
    full = 0
    noAcl = 1

  bucket = _messages.StringField(1, required=True)
  channel = _messages.MessageField('Channel', 2)
  delimiter = _messages.StringField(3)
  maxResults = _messages.IntegerField(4, variant=_messages.Variant.UINT32)
  pageToken = _messages.StringField(5)
  prefix = _messages.StringField(6)
  projection = _messages.EnumField('ProjectionValueValuesEnum', 7)
  versions = _messages.BooleanField(8)
