# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# Taken from output of SETUP module
variable "service_account_id" {
  description = "The name of Service Account to run Cloud Function"
}

# Required for environment variables inside of cloud functions
# Generated by command (gcloud config get-value project) in Kotlin Gradle script
variable "project_id" {
  description = "The GCP Project ID of function"
}

# GCP region
variable "region" {
  description = "The GCP Region where cloud functions will be created"
}

# Source code bucket name, used for cloud functions
# Taken from output of FUNCTIONS_BUCKETS module
variable "source_archive_bucket" {
  description = "The GCS bucket containing the zip archive which contains the function"
}

# Source code objects name, used for cloud functions
# Taken from output of FUNCTIONS_BUCKETS module
variable "source_archive_object" {
  description = "The source archive object (file) in archive bucket"
}

# Constant. Will be served as cloud functions URLs/endpoints
variable "entry_point_names" {
  type = list
  default = ["getSdkList", "getContentTree", "getUnitContent", "getUserProgress", "postUnitComplete", "postUserCode", "postDeleteProgress"]
}

# Existing Playground environment's router hostname:port details
# Variable assigned using "kubectl" command
variable "pg_router_host" {
  description = "Hostname:port of Playground GKE cluster's router grpc workload"
}

# To support multi environment architecture
# Env name (e.g. test, prod, dev)
variable "environment" {
  description = "The name of the environment for deployment of cloud functions. Will be appended to the name of cloud functions"
}

variable "datastore_namespace" {
  description = "The name of datastore namespace"
}