//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.1.0
// - protoc             v3.21.6
// source: org/apache/beam/model/job_management/v1/beam_expansion_api.proto

package jobmanagement_v1

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// ExpansionServiceClient is the client API for ExpansionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ExpansionServiceClient interface {
	Expand(ctx context.Context, in *ExpansionRequest, opts ...grpc.CallOption) (*ExpansionResponse, error)
}

type expansionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewExpansionServiceClient(cc grpc.ClientConnInterface) ExpansionServiceClient {
	return &expansionServiceClient{cc}
}

func (c *expansionServiceClient) Expand(ctx context.Context, in *ExpansionRequest, opts ...grpc.CallOption) (*ExpansionResponse, error) {
	out := new(ExpansionResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.expansion.v1.ExpansionService/Expand", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ExpansionServiceServer is the server API for ExpansionService service.
// All implementations must embed UnimplementedExpansionServiceServer
// for forward compatibility
type ExpansionServiceServer interface {
	Expand(context.Context, *ExpansionRequest) (*ExpansionResponse, error)
	mustEmbedUnimplementedExpansionServiceServer()
}

// UnimplementedExpansionServiceServer must be embedded to have forward compatible implementations.
type UnimplementedExpansionServiceServer struct {
}

func (UnimplementedExpansionServiceServer) Expand(context.Context, *ExpansionRequest) (*ExpansionResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Expand not implemented")
}
func (UnimplementedExpansionServiceServer) mustEmbedUnimplementedExpansionServiceServer() {}

// UnsafeExpansionServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ExpansionServiceServer will
// result in compilation errors.
type UnsafeExpansionServiceServer interface {
	mustEmbedUnimplementedExpansionServiceServer()
}

func RegisterExpansionServiceServer(s grpc.ServiceRegistrar, srv ExpansionServiceServer) {
	s.RegisterService(&ExpansionService_ServiceDesc, srv)
}

func _ExpansionService_Expand_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExpansionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExpansionServiceServer).Expand(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.expansion.v1.ExpansionService/Expand",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExpansionServiceServer).Expand(ctx, req.(*ExpansionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ExpansionService_ServiceDesc is the grpc.ServiceDesc for ExpansionService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ExpansionService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.expansion.v1.ExpansionService",
	HandlerType: (*ExpansionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Expand",
			Handler:    _ExpansionService_Expand_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "org/apache/beam/model/job_management/v1/beam_expansion_api.proto",
}
