//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.1.0
// - protoc             v3.21.6
// source: org/apache/beam/model/fn_execution/v1/beam_fn_api.proto

package fnexecution_v1

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// BeamFnControlClient is the client API for BeamFnControl service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BeamFnControlClient interface {
	// Instructions sent by the runner to the SDK requesting different types
	// of work.
	Control(ctx context.Context, opts ...grpc.CallOption) (BeamFnControl_ControlClient, error)
	// Used to get the full process bundle descriptors for bundles one
	// is asked to process.
	GetProcessBundleDescriptor(ctx context.Context, in *GetProcessBundleDescriptorRequest, opts ...grpc.CallOption) (*ProcessBundleDescriptor, error)
}

type beamFnControlClient struct {
	cc grpc.ClientConnInterface
}

func NewBeamFnControlClient(cc grpc.ClientConnInterface) BeamFnControlClient {
	return &beamFnControlClient{cc}
}

func (c *beamFnControlClient) Control(ctx context.Context, opts ...grpc.CallOption) (BeamFnControl_ControlClient, error) {
	stream, err := c.cc.NewStream(ctx, &BeamFnControl_ServiceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnControl/Control", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnControlControlClient{stream}
	return x, nil
}

type BeamFnControl_ControlClient interface {
	Send(*InstructionResponse) error
	Recv() (*InstructionRequest, error)
	grpc.ClientStream
}

type beamFnControlControlClient struct {
	grpc.ClientStream
}

func (x *beamFnControlControlClient) Send(m *InstructionResponse) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnControlControlClient) Recv() (*InstructionRequest, error) {
	m := new(InstructionRequest)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *beamFnControlClient) GetProcessBundleDescriptor(ctx context.Context, in *GetProcessBundleDescriptorRequest, opts ...grpc.CallOption) (*ProcessBundleDescriptor, error) {
	out := new(ProcessBundleDescriptor)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.fn_execution.v1.BeamFnControl/GetProcessBundleDescriptor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BeamFnControlServer is the server API for BeamFnControl service.
// All implementations must embed UnimplementedBeamFnControlServer
// for forward compatibility
type BeamFnControlServer interface {
	// Instructions sent by the runner to the SDK requesting different types
	// of work.
	Control(BeamFnControl_ControlServer) error
	// Used to get the full process bundle descriptors for bundles one
	// is asked to process.
	GetProcessBundleDescriptor(context.Context, *GetProcessBundleDescriptorRequest) (*ProcessBundleDescriptor, error)
	mustEmbedUnimplementedBeamFnControlServer()
}

// UnimplementedBeamFnControlServer must be embedded to have forward compatible implementations.
type UnimplementedBeamFnControlServer struct {
}

func (UnimplementedBeamFnControlServer) Control(BeamFnControl_ControlServer) error {
	return status.Errorf(codes.Unimplemented, "method Control not implemented")
}
func (UnimplementedBeamFnControlServer) GetProcessBundleDescriptor(context.Context, *GetProcessBundleDescriptorRequest) (*ProcessBundleDescriptor, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProcessBundleDescriptor not implemented")
}
func (UnimplementedBeamFnControlServer) mustEmbedUnimplementedBeamFnControlServer() {}

// UnsafeBeamFnControlServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BeamFnControlServer will
// result in compilation errors.
type UnsafeBeamFnControlServer interface {
	mustEmbedUnimplementedBeamFnControlServer()
}

func RegisterBeamFnControlServer(s grpc.ServiceRegistrar, srv BeamFnControlServer) {
	s.RegisterService(&BeamFnControl_ServiceDesc, srv)
}

func _BeamFnControl_Control_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnControlServer).Control(&beamFnControlControlServer{stream})
}

type BeamFnControl_ControlServer interface {
	Send(*InstructionRequest) error
	Recv() (*InstructionResponse, error)
	grpc.ServerStream
}

type beamFnControlControlServer struct {
	grpc.ServerStream
}

func (x *beamFnControlControlServer) Send(m *InstructionRequest) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnControlControlServer) Recv() (*InstructionResponse, error) {
	m := new(InstructionResponse)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _BeamFnControl_GetProcessBundleDescriptor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProcessBundleDescriptorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BeamFnControlServer).GetProcessBundleDescriptor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.fn_execution.v1.BeamFnControl/GetProcessBundleDescriptor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BeamFnControlServer).GetProcessBundleDescriptor(ctx, req.(*GetProcessBundleDescriptorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// BeamFnControl_ServiceDesc is the grpc.ServiceDesc for BeamFnControl service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BeamFnControl_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnControl",
	HandlerType: (*BeamFnControlServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetProcessBundleDescriptor",
			Handler:    _BeamFnControl_GetProcessBundleDescriptor_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Control",
			Handler:       _BeamFnControl_Control_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "org/apache/beam/model/fn_execution/v1/beam_fn_api.proto",
}

// BeamFnDataClient is the client API for BeamFnData service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BeamFnDataClient interface {
	// Used to send data between harnesses.
	Data(ctx context.Context, opts ...grpc.CallOption) (BeamFnData_DataClient, error)
}

type beamFnDataClient struct {
	cc grpc.ClientConnInterface
}

func NewBeamFnDataClient(cc grpc.ClientConnInterface) BeamFnDataClient {
	return &beamFnDataClient{cc}
}

func (c *beamFnDataClient) Data(ctx context.Context, opts ...grpc.CallOption) (BeamFnData_DataClient, error) {
	stream, err := c.cc.NewStream(ctx, &BeamFnData_ServiceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnData/Data", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnDataDataClient{stream}
	return x, nil
}

type BeamFnData_DataClient interface {
	Send(*Elements) error
	Recv() (*Elements, error)
	grpc.ClientStream
}

type beamFnDataDataClient struct {
	grpc.ClientStream
}

func (x *beamFnDataDataClient) Send(m *Elements) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnDataDataClient) Recv() (*Elements, error) {
	m := new(Elements)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnDataServer is the server API for BeamFnData service.
// All implementations must embed UnimplementedBeamFnDataServer
// for forward compatibility
type BeamFnDataServer interface {
	// Used to send data between harnesses.
	Data(BeamFnData_DataServer) error
	mustEmbedUnimplementedBeamFnDataServer()
}

// UnimplementedBeamFnDataServer must be embedded to have forward compatible implementations.
type UnimplementedBeamFnDataServer struct {
}

func (UnimplementedBeamFnDataServer) Data(BeamFnData_DataServer) error {
	return status.Errorf(codes.Unimplemented, "method Data not implemented")
}
func (UnimplementedBeamFnDataServer) mustEmbedUnimplementedBeamFnDataServer() {}

// UnsafeBeamFnDataServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BeamFnDataServer will
// result in compilation errors.
type UnsafeBeamFnDataServer interface {
	mustEmbedUnimplementedBeamFnDataServer()
}

func RegisterBeamFnDataServer(s grpc.ServiceRegistrar, srv BeamFnDataServer) {
	s.RegisterService(&BeamFnData_ServiceDesc, srv)
}

func _BeamFnData_Data_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnDataServer).Data(&beamFnDataDataServer{stream})
}

type BeamFnData_DataServer interface {
	Send(*Elements) error
	Recv() (*Elements, error)
	grpc.ServerStream
}

type beamFnDataDataServer struct {
	grpc.ServerStream
}

func (x *beamFnDataDataServer) Send(m *Elements) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnDataDataServer) Recv() (*Elements, error) {
	m := new(Elements)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnData_ServiceDesc is the grpc.ServiceDesc for BeamFnData service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BeamFnData_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnData",
	HandlerType: (*BeamFnDataServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Data",
			Handler:       _BeamFnData_Data_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "org/apache/beam/model/fn_execution/v1/beam_fn_api.proto",
}

// BeamFnStateClient is the client API for BeamFnState service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BeamFnStateClient interface {
	// Used to get/append/clear state stored by the runner on behalf of the SDK.
	State(ctx context.Context, opts ...grpc.CallOption) (BeamFnState_StateClient, error)
}

type beamFnStateClient struct {
	cc grpc.ClientConnInterface
}

func NewBeamFnStateClient(cc grpc.ClientConnInterface) BeamFnStateClient {
	return &beamFnStateClient{cc}
}

func (c *beamFnStateClient) State(ctx context.Context, opts ...grpc.CallOption) (BeamFnState_StateClient, error) {
	stream, err := c.cc.NewStream(ctx, &BeamFnState_ServiceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnState/State", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnStateStateClient{stream}
	return x, nil
}

type BeamFnState_StateClient interface {
	Send(*StateRequest) error
	Recv() (*StateResponse, error)
	grpc.ClientStream
}

type beamFnStateStateClient struct {
	grpc.ClientStream
}

func (x *beamFnStateStateClient) Send(m *StateRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnStateStateClient) Recv() (*StateResponse, error) {
	m := new(StateResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnStateServer is the server API for BeamFnState service.
// All implementations must embed UnimplementedBeamFnStateServer
// for forward compatibility
type BeamFnStateServer interface {
	// Used to get/append/clear state stored by the runner on behalf of the SDK.
	State(BeamFnState_StateServer) error
	mustEmbedUnimplementedBeamFnStateServer()
}

// UnimplementedBeamFnStateServer must be embedded to have forward compatible implementations.
type UnimplementedBeamFnStateServer struct {
}

func (UnimplementedBeamFnStateServer) State(BeamFnState_StateServer) error {
	return status.Errorf(codes.Unimplemented, "method State not implemented")
}
func (UnimplementedBeamFnStateServer) mustEmbedUnimplementedBeamFnStateServer() {}

// UnsafeBeamFnStateServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BeamFnStateServer will
// result in compilation errors.
type UnsafeBeamFnStateServer interface {
	mustEmbedUnimplementedBeamFnStateServer()
}

func RegisterBeamFnStateServer(s grpc.ServiceRegistrar, srv BeamFnStateServer) {
	s.RegisterService(&BeamFnState_ServiceDesc, srv)
}

func _BeamFnState_State_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnStateServer).State(&beamFnStateStateServer{stream})
}

type BeamFnState_StateServer interface {
	Send(*StateResponse) error
	Recv() (*StateRequest, error)
	grpc.ServerStream
}

type beamFnStateStateServer struct {
	grpc.ServerStream
}

func (x *beamFnStateStateServer) Send(m *StateResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnStateStateServer) Recv() (*StateRequest, error) {
	m := new(StateRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnState_ServiceDesc is the grpc.ServiceDesc for BeamFnState service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BeamFnState_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnState",
	HandlerType: (*BeamFnStateServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "State",
			Handler:       _BeamFnState_State_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "org/apache/beam/model/fn_execution/v1/beam_fn_api.proto",
}

// BeamFnLoggingClient is the client API for BeamFnLogging service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BeamFnLoggingClient interface {
	// Allows for the SDK to emit log entries which the runner can
	// associate with the active job.
	Logging(ctx context.Context, opts ...grpc.CallOption) (BeamFnLogging_LoggingClient, error)
}

type beamFnLoggingClient struct {
	cc grpc.ClientConnInterface
}

func NewBeamFnLoggingClient(cc grpc.ClientConnInterface) BeamFnLoggingClient {
	return &beamFnLoggingClient{cc}
}

func (c *beamFnLoggingClient) Logging(ctx context.Context, opts ...grpc.CallOption) (BeamFnLogging_LoggingClient, error) {
	stream, err := c.cc.NewStream(ctx, &BeamFnLogging_ServiceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnLogging/Logging", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnLoggingLoggingClient{stream}
	return x, nil
}

type BeamFnLogging_LoggingClient interface {
	Send(*LogEntry_List) error
	Recv() (*LogControl, error)
	grpc.ClientStream
}

type beamFnLoggingLoggingClient struct {
	grpc.ClientStream
}

func (x *beamFnLoggingLoggingClient) Send(m *LogEntry_List) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnLoggingLoggingClient) Recv() (*LogControl, error) {
	m := new(LogControl)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnLoggingServer is the server API for BeamFnLogging service.
// All implementations must embed UnimplementedBeamFnLoggingServer
// for forward compatibility
type BeamFnLoggingServer interface {
	// Allows for the SDK to emit log entries which the runner can
	// associate with the active job.
	Logging(BeamFnLogging_LoggingServer) error
	mustEmbedUnimplementedBeamFnLoggingServer()
}

// UnimplementedBeamFnLoggingServer must be embedded to have forward compatible implementations.
type UnimplementedBeamFnLoggingServer struct {
}

func (UnimplementedBeamFnLoggingServer) Logging(BeamFnLogging_LoggingServer) error {
	return status.Errorf(codes.Unimplemented, "method Logging not implemented")
}
func (UnimplementedBeamFnLoggingServer) mustEmbedUnimplementedBeamFnLoggingServer() {}

// UnsafeBeamFnLoggingServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BeamFnLoggingServer will
// result in compilation errors.
type UnsafeBeamFnLoggingServer interface {
	mustEmbedUnimplementedBeamFnLoggingServer()
}

func RegisterBeamFnLoggingServer(s grpc.ServiceRegistrar, srv BeamFnLoggingServer) {
	s.RegisterService(&BeamFnLogging_ServiceDesc, srv)
}

func _BeamFnLogging_Logging_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnLoggingServer).Logging(&beamFnLoggingLoggingServer{stream})
}

type BeamFnLogging_LoggingServer interface {
	Send(*LogControl) error
	Recv() (*LogEntry_List, error)
	grpc.ServerStream
}

type beamFnLoggingLoggingServer struct {
	grpc.ServerStream
}

func (x *beamFnLoggingLoggingServer) Send(m *LogControl) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnLoggingLoggingServer) Recv() (*LogEntry_List, error) {
	m := new(LogEntry_List)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnLogging_ServiceDesc is the grpc.ServiceDesc for BeamFnLogging service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BeamFnLogging_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnLogging",
	HandlerType: (*BeamFnLoggingServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Logging",
			Handler:       _BeamFnLogging_Logging_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "org/apache/beam/model/fn_execution/v1/beam_fn_api.proto",
}

// BeamFnExternalWorkerPoolClient is the client API for BeamFnExternalWorkerPool service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BeamFnExternalWorkerPoolClient interface {
	// Start the SDK worker with the given ID.
	StartWorker(ctx context.Context, in *StartWorkerRequest, opts ...grpc.CallOption) (*StartWorkerResponse, error)
	// Stop the SDK worker.
	StopWorker(ctx context.Context, in *StopWorkerRequest, opts ...grpc.CallOption) (*StopWorkerResponse, error)
}

type beamFnExternalWorkerPoolClient struct {
	cc grpc.ClientConnInterface
}

func NewBeamFnExternalWorkerPoolClient(cc grpc.ClientConnInterface) BeamFnExternalWorkerPoolClient {
	return &beamFnExternalWorkerPoolClient{cc}
}

func (c *beamFnExternalWorkerPoolClient) StartWorker(ctx context.Context, in *StartWorkerRequest, opts ...grpc.CallOption) (*StartWorkerResponse, error) {
	out := new(StartWorkerResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool/StartWorker", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beamFnExternalWorkerPoolClient) StopWorker(ctx context.Context, in *StopWorkerRequest, opts ...grpc.CallOption) (*StopWorkerResponse, error) {
	out := new(StopWorkerResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool/StopWorker", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BeamFnExternalWorkerPoolServer is the server API for BeamFnExternalWorkerPool service.
// All implementations must embed UnimplementedBeamFnExternalWorkerPoolServer
// for forward compatibility
type BeamFnExternalWorkerPoolServer interface {
	// Start the SDK worker with the given ID.
	StartWorker(context.Context, *StartWorkerRequest) (*StartWorkerResponse, error)
	// Stop the SDK worker.
	StopWorker(context.Context, *StopWorkerRequest) (*StopWorkerResponse, error)
	mustEmbedUnimplementedBeamFnExternalWorkerPoolServer()
}

// UnimplementedBeamFnExternalWorkerPoolServer must be embedded to have forward compatible implementations.
type UnimplementedBeamFnExternalWorkerPoolServer struct {
}

func (UnimplementedBeamFnExternalWorkerPoolServer) StartWorker(context.Context, *StartWorkerRequest) (*StartWorkerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartWorker not implemented")
}
func (UnimplementedBeamFnExternalWorkerPoolServer) StopWorker(context.Context, *StopWorkerRequest) (*StopWorkerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopWorker not implemented")
}
func (UnimplementedBeamFnExternalWorkerPoolServer) mustEmbedUnimplementedBeamFnExternalWorkerPoolServer() {
}

// UnsafeBeamFnExternalWorkerPoolServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BeamFnExternalWorkerPoolServer will
// result in compilation errors.
type UnsafeBeamFnExternalWorkerPoolServer interface {
	mustEmbedUnimplementedBeamFnExternalWorkerPoolServer()
}

func RegisterBeamFnExternalWorkerPoolServer(s grpc.ServiceRegistrar, srv BeamFnExternalWorkerPoolServer) {
	s.RegisterService(&BeamFnExternalWorkerPool_ServiceDesc, srv)
}

func _BeamFnExternalWorkerPool_StartWorker_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartWorkerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BeamFnExternalWorkerPoolServer).StartWorker(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool/StartWorker",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BeamFnExternalWorkerPoolServer).StartWorker(ctx, req.(*StartWorkerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BeamFnExternalWorkerPool_StopWorker_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopWorkerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BeamFnExternalWorkerPoolServer).StopWorker(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool/StopWorker",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BeamFnExternalWorkerPoolServer).StopWorker(ctx, req.(*StopWorkerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// BeamFnExternalWorkerPool_ServiceDesc is the grpc.ServiceDesc for BeamFnExternalWorkerPool service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BeamFnExternalWorkerPool_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool",
	HandlerType: (*BeamFnExternalWorkerPoolServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "StartWorker",
			Handler:    _BeamFnExternalWorkerPool_StartWorker_Handler,
		},
		{
			MethodName: "StopWorker",
			Handler:    _BeamFnExternalWorkerPool_StopWorker_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "org/apache/beam/model/fn_execution/v1/beam_fn_api.proto",
}

// BeamFnWorkerStatusClient is the client API for BeamFnWorkerStatus service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BeamFnWorkerStatusClient interface {
	WorkerStatus(ctx context.Context, opts ...grpc.CallOption) (BeamFnWorkerStatus_WorkerStatusClient, error)
}

type beamFnWorkerStatusClient struct {
	cc grpc.ClientConnInterface
}

func NewBeamFnWorkerStatusClient(cc grpc.ClientConnInterface) BeamFnWorkerStatusClient {
	return &beamFnWorkerStatusClient{cc}
}

func (c *beamFnWorkerStatusClient) WorkerStatus(ctx context.Context, opts ...grpc.CallOption) (BeamFnWorkerStatus_WorkerStatusClient, error) {
	stream, err := c.cc.NewStream(ctx, &BeamFnWorkerStatus_ServiceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnWorkerStatus/WorkerStatus", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnWorkerStatusWorkerStatusClient{stream}
	return x, nil
}

type BeamFnWorkerStatus_WorkerStatusClient interface {
	Send(*WorkerStatusResponse) error
	Recv() (*WorkerStatusRequest, error)
	grpc.ClientStream
}

type beamFnWorkerStatusWorkerStatusClient struct {
	grpc.ClientStream
}

func (x *beamFnWorkerStatusWorkerStatusClient) Send(m *WorkerStatusResponse) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnWorkerStatusWorkerStatusClient) Recv() (*WorkerStatusRequest, error) {
	m := new(WorkerStatusRequest)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnWorkerStatusServer is the server API for BeamFnWorkerStatus service.
// All implementations must embed UnimplementedBeamFnWorkerStatusServer
// for forward compatibility
type BeamFnWorkerStatusServer interface {
	WorkerStatus(BeamFnWorkerStatus_WorkerStatusServer) error
	mustEmbedUnimplementedBeamFnWorkerStatusServer()
}

// UnimplementedBeamFnWorkerStatusServer must be embedded to have forward compatible implementations.
type UnimplementedBeamFnWorkerStatusServer struct {
}

func (UnimplementedBeamFnWorkerStatusServer) WorkerStatus(BeamFnWorkerStatus_WorkerStatusServer) error {
	return status.Errorf(codes.Unimplemented, "method WorkerStatus not implemented")
}
func (UnimplementedBeamFnWorkerStatusServer) mustEmbedUnimplementedBeamFnWorkerStatusServer() {}

// UnsafeBeamFnWorkerStatusServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BeamFnWorkerStatusServer will
// result in compilation errors.
type UnsafeBeamFnWorkerStatusServer interface {
	mustEmbedUnimplementedBeamFnWorkerStatusServer()
}

func RegisterBeamFnWorkerStatusServer(s grpc.ServiceRegistrar, srv BeamFnWorkerStatusServer) {
	s.RegisterService(&BeamFnWorkerStatus_ServiceDesc, srv)
}

func _BeamFnWorkerStatus_WorkerStatus_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnWorkerStatusServer).WorkerStatus(&beamFnWorkerStatusWorkerStatusServer{stream})
}

type BeamFnWorkerStatus_WorkerStatusServer interface {
	Send(*WorkerStatusRequest) error
	Recv() (*WorkerStatusResponse, error)
	grpc.ServerStream
}

type beamFnWorkerStatusWorkerStatusServer struct {
	grpc.ServerStream
}

func (x *beamFnWorkerStatusWorkerStatusServer) Send(m *WorkerStatusRequest) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnWorkerStatusWorkerStatusServer) Recv() (*WorkerStatusResponse, error) {
	m := new(WorkerStatusResponse)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnWorkerStatus_ServiceDesc is the grpc.ServiceDesc for BeamFnWorkerStatus service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BeamFnWorkerStatus_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnWorkerStatus",
	HandlerType: (*BeamFnWorkerStatusServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "WorkerStatus",
			Handler:       _BeamFnWorkerStatus_WorkerStatus_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "org/apache/beam/model/fn_execution/v1/beam_fn_api.proto",
}
