//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//
// Protocol Buffers describing graph serialization (v1)
//
// We need to serialize types and function symbols to be able to recreate
// UserFns on the worker side, in particular. We use protos for compactness.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.14.0
// source: go/pkg/beam/core/runtime/graphx/v1/v1.proto

package v1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Kind is mostly identical to reflect.TypeKind, expect we handle certain
// types specially, such as "error".
type Type_Kind int32

const (
	Type_INVALID Type_Kind = 0
	// Primitive.
	Type_BOOL    Type_Kind = 1
	Type_INT     Type_Kind = 2
	Type_INT8    Type_Kind = 3
	Type_INT16   Type_Kind = 4
	Type_INT32   Type_Kind = 5
	Type_INT64   Type_Kind = 6
	Type_UINT    Type_Kind = 7
	Type_UINT8   Type_Kind = 8
	Type_UINT16  Type_Kind = 9
	Type_UINT32  Type_Kind = 10
	Type_UINT64  Type_Kind = 11
	Type_STRING  Type_Kind = 12
	Type_FLOAT32 Type_Kind = 13
	Type_FLOAT64 Type_Kind = 14
	// Non-primitive types.
	Type_SLICE    Type_Kind = 20
	Type_STRUCT   Type_Kind = 21
	Type_FUNC     Type_Kind = 22
	Type_CHAN     Type_Kind = 23
	Type_PTR      Type_Kind = 24
	Type_SPECIAL  Type_Kind = 25
	Type_EXTERNAL Type_Kind = 26
)

// Enum value maps for Type_Kind.
var (
	Type_Kind_name = map[int32]string{
		0:  "INVALID",
		1:  "BOOL",
		2:  "INT",
		3:  "INT8",
		4:  "INT16",
		5:  "INT32",
		6:  "INT64",
		7:  "UINT",
		8:  "UINT8",
		9:  "UINT16",
		10: "UINT32",
		11: "UINT64",
		12: "STRING",
		13: "FLOAT32",
		14: "FLOAT64",
		20: "SLICE",
		21: "STRUCT",
		22: "FUNC",
		23: "CHAN",
		24: "PTR",
		25: "SPECIAL",
		26: "EXTERNAL",
	}
	Type_Kind_value = map[string]int32{
		"INVALID":  0,
		"BOOL":     1,
		"INT":      2,
		"INT8":     3,
		"INT16":    4,
		"INT32":    5,
		"INT64":    6,
		"UINT":     7,
		"UINT8":    8,
		"UINT16":   9,
		"UINT32":   10,
		"UINT64":   11,
		"STRING":   12,
		"FLOAT32":  13,
		"FLOAT64":  14,
		"SLICE":    20,
		"STRUCT":   21,
		"FUNC":     22,
		"CHAN":     23,
		"PTR":      24,
		"SPECIAL":  25,
		"EXTERNAL": 26,
	}
)

func (x Type_Kind) Enum() *Type_Kind {
	p := new(Type_Kind)
	*p = x
	return p
}

func (x Type_Kind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Type_Kind) Descriptor() protoreflect.EnumDescriptor {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_enumTypes[0].Descriptor()
}

func (Type_Kind) Type() protoreflect.EnumType {
	return &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_enumTypes[0]
}

func (x Type_Kind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Type_Kind.Descriptor instead.
func (Type_Kind) EnumDescriptor() ([]byte, []int) {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescGZIP(), []int{0, 0}
}

// ChanDir matches reflect.ChanDir.
type Type_ChanDir int32

const (
	Type_RECV Type_ChanDir = 0
	Type_SEND Type_ChanDir = 1
	Type_BOTH Type_ChanDir = 2
)

// Enum value maps for Type_ChanDir.
var (
	Type_ChanDir_name = map[int32]string{
		0: "RECV",
		1: "SEND",
		2: "BOTH",
	}
	Type_ChanDir_value = map[string]int32{
		"RECV": 0,
		"SEND": 1,
		"BOTH": 2,
	}
)

func (x Type_ChanDir) Enum() *Type_ChanDir {
	p := new(Type_ChanDir)
	*p = x
	return p
}

func (x Type_ChanDir) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Type_ChanDir) Descriptor() protoreflect.EnumDescriptor {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_enumTypes[1].Descriptor()
}

func (Type_ChanDir) Type() protoreflect.EnumType {
	return &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_enumTypes[1]
}

func (x Type_ChanDir) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Type_ChanDir.Descriptor instead.
func (Type_ChanDir) EnumDescriptor() ([]byte, []int) {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescGZIP(), []int{0, 1}
}

type Type_Special int32

const (
	Type_ILLEGAL Type_Special = 0
	// Go
	Type_ERROR   Type_Special = 1
	Type_CONTEXT Type_Special = 2
	Type_TYPE    Type_Special = 3
	// Beam
	Type_EVENTTIME          Type_Special = 10
	Type_WINDOW             Type_Special = 22
	Type_KV                 Type_Special = 11
	Type_COGBK              Type_Special = 13
	Type_WINDOWEDVALUE      Type_Special = 14
	Type_BUNDLEFINALIZATION Type_Special = 23
	Type_STATEPROVIDER      Type_Special = 24
	Type_T                  Type_Special = 15
	Type_U                  Type_Special = 16
	Type_V                  Type_Special = 17
	Type_W                  Type_Special = 18
	Type_X                  Type_Special = 19
	Type_Y                  Type_Special = 20
	Type_Z                  Type_Special = 21
)

// Enum value maps for Type_Special.
var (
	Type_Special_name = map[int32]string{
		0:  "ILLEGAL",
		1:  "ERROR",
		2:  "CONTEXT",
		3:  "TYPE",
		10: "EVENTTIME",
		22: "WINDOW",
		11: "KV",
		13: "COGBK",
		14: "WINDOWEDVALUE",
		23: "BUNDLEFINALIZATION",
		24: "STATEPROVIDER",
		15: "T",
		16: "U",
		17: "V",
		18: "W",
		19: "X",
		20: "Y",
		21: "Z",
	}
	Type_Special_value = map[string]int32{
		"ILLEGAL":            0,
		"ERROR":              1,
		"CONTEXT":            2,
		"TYPE":               3,
		"EVENTTIME":          10,
		"WINDOW":             22,
		"KV":                 11,
		"COGBK":              13,
		"WINDOWEDVALUE":      14,
		"BUNDLEFINALIZATION": 23,
		"STATEPROVIDER":      24,
		"T":                  15,
		"U":                  16,
		"V":                  17,
		"W":                  18,
		"X":                  19,
		"Y":                  20,
		"Z":                  21,
	}
)

func (x Type_Special) Enum() *Type_Special {
	p := new(Type_Special)
	*p = x
	return p
}

func (x Type_Special) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Type_Special) Descriptor() protoreflect.EnumDescriptor {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_enumTypes[2].Descriptor()
}

func (Type_Special) Type() protoreflect.EnumType {
	return &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_enumTypes[2]
}

func (x Type_Special) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Type_Special.Descriptor instead.
func (Type_Special) EnumDescriptor() ([]byte, []int) {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescGZIP(), []int{0, 2}
}

type MultiEdge_Inbound_InputKind int32

const (
	MultiEdge_Inbound_INVALID   MultiEdge_Inbound_InputKind = 0
	MultiEdge_Inbound_MAIN      MultiEdge_Inbound_InputKind = 1
	MultiEdge_Inbound_SINGLETON MultiEdge_Inbound_InputKind = 2
	MultiEdge_Inbound_SLICE     MultiEdge_Inbound_InputKind = 3
	MultiEdge_Inbound_MAP       MultiEdge_Inbound_InputKind = 4
	MultiEdge_Inbound_MULTIMAP  MultiEdge_Inbound_InputKind = 5
	MultiEdge_Inbound_ITER      MultiEdge_Inbound_InputKind = 6
	MultiEdge_Inbound_REITER    MultiEdge_Inbound_InputKind = 7
)

// Enum value maps for MultiEdge_Inbound_InputKind.
var (
	MultiEdge_Inbound_InputKind_name = map[int32]string{
		0: "INVALID",
		1: "MAIN",
		2: "SINGLETON",
		3: "SLICE",
		4: "MAP",
		5: "MULTIMAP",
		6: "ITER",
		7: "REITER",
	}
	MultiEdge_Inbound_InputKind_value = map[string]int32{
		"INVALID":   0,
		"MAIN":      1,
		"SINGLETON": 2,
		"SLICE":     3,
		"MAP":       4,
		"MULTIMAP":  5,
		"ITER":      6,
		"REITER":    7,
	}
)

func (x MultiEdge_Inbound_InputKind) Enum() *MultiEdge_Inbound_InputKind {
	p := new(MultiEdge_Inbound_InputKind)
	*p = x
	return p
}

func (x MultiEdge_Inbound_InputKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MultiEdge_Inbound_InputKind) Descriptor() protoreflect.EnumDescriptor {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_enumTypes[3].Descriptor()
}

func (MultiEdge_Inbound_InputKind) Type() protoreflect.EnumType {
	return &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_enumTypes[3]
}

func (x MultiEdge_Inbound_InputKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MultiEdge_Inbound_InputKind.Descriptor instead.
func (MultiEdge_Inbound_InputKind) EnumDescriptor() ([]byte, []int) {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescGZIP(), []int{7, 0, 0}
}

// Type represents a serializable reflect.Type.
type Type struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) Type kind.
	Kind Type_Kind `protobuf:"varint,1,opt,name=kind,proto3,enum=org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type_Kind" json:"kind,omitempty"`
	// (Optional) Element type (if SLICE, PTR or CHAN)
	Element *Type `protobuf:"bytes,2,opt,name=element,proto3" json:"element,omitempty"`
	// (Optional) Fields (if STRUCT).
	Fields []*Type_StructField `protobuf:"bytes,3,rep,name=fields,proto3" json:"fields,omitempty"`
	// (Optional) Parameter types (if FUNC).
	ParameterTypes []*Type `protobuf:"bytes,4,rep,name=parameter_types,json=parameterTypes,proto3" json:"parameter_types,omitempty"`
	// (Optional) Return types (if FUNC).
	ReturnTypes []*Type `protobuf:"bytes,5,rep,name=return_types,json=returnTypes,proto3" json:"return_types,omitempty"`
	// (Optional) Is variadic (if FUNC).
	IsVariadic bool `protobuf:"varint,6,opt,name=is_variadic,json=isVariadic,proto3" json:"is_variadic,omitempty"`
	// (Optional) Channel direction (if CHAN).
	ChanDir Type_ChanDir `protobuf:"varint,7,opt,name=chan_dir,json=chanDir,proto3,enum=org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type_ChanDir" json:"chan_dir,omitempty"`
	// (Optional) Special type (if SPECIAL)
	Special Type_Special `protobuf:"varint,8,opt,name=special,proto3,enum=org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type_Special" json:"special,omitempty"`
	// (Optional) Key for external types.
	// External types are types that are not directly serialized using
	// the types above, but rather indirectly serialized.  The wire format
	// holds a lookup key into a registry to reify the types in a worker from a
	// registry. The main usage of external serialization is to preserve
	// methods attached to types.
	ExternalKey string `protobuf:"bytes,9,opt,name=external_key,json=externalKey,proto3" json:"external_key,omitempty"`
}

func (x *Type) Reset() {
	*x = Type{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Type) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type) ProtoMessage() {}

func (x *Type) ProtoReflect() protoreflect.Message {
	mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type.ProtoReflect.Descriptor instead.
func (*Type) Descriptor() ([]byte, []int) {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescGZIP(), []int{0}
}

func (x *Type) GetKind() Type_Kind {
	if x != nil {
		return x.Kind
	}
	return Type_INVALID
}

func (x *Type) GetElement() *Type {
	if x != nil {
		return x.Element
	}
	return nil
}

func (x *Type) GetFields() []*Type_StructField {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *Type) GetParameterTypes() []*Type {
	if x != nil {
		return x.ParameterTypes
	}
	return nil
}

func (x *Type) GetReturnTypes() []*Type {
	if x != nil {
		return x.ReturnTypes
	}
	return nil
}

func (x *Type) GetIsVariadic() bool {
	if x != nil {
		return x.IsVariadic
	}
	return false
}

func (x *Type) GetChanDir() Type_ChanDir {
	if x != nil {
		return x.ChanDir
	}
	return Type_RECV
}

func (x *Type) GetSpecial() Type_Special {
	if x != nil {
		return x.Special
	}
	return Type_ILLEGAL
}

func (x *Type) GetExternalKey() string {
	if x != nil {
		return x.ExternalKey
	}
	return ""
}

// FullType represents a serialized typex.FullType
type FullType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type       *Type       `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Components []*FullType `protobuf:"bytes,2,rep,name=components,proto3" json:"components,omitempty"`
}

func (x *FullType) Reset() {
	*x = FullType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FullType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FullType) ProtoMessage() {}

func (x *FullType) ProtoReflect() protoreflect.Message {
	mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FullType.ProtoReflect.Descriptor instead.
func (*FullType) Descriptor() ([]byte, []int) {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescGZIP(), []int{1}
}

func (x *FullType) GetType() *Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *FullType) GetComponents() []*FullType {
	if x != nil {
		return x.Components
	}
	return nil
}

// UserFn represents a serialized function reference. The
// implementation is notably not serialized and must be present (and
// somehow discoverable from the symbol name) on the decoding side.
type UserFn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) Symbol name of function.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// (Required) Function type.
	Type *Type `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *UserFn) Reset() {
	*x = UserFn{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UserFn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserFn) ProtoMessage() {}

func (x *UserFn) ProtoReflect() protoreflect.Message {
	mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserFn.ProtoReflect.Descriptor instead.
func (*UserFn) Descriptor() ([]byte, []int) {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescGZIP(), []int{2}
}

func (x *UserFn) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UserFn) GetType() *Type {
	if x != nil {
		return x.Type
	}
	return nil
}

// DynFn represents a serialized function generator.
type DynFn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) Name of the generated function.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// (Required) Type of the generated function.
	Type *Type `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// (Required) Input to generator.
	Data []byte `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	// (Required) Symbol name of generator (of type []byte ->
	// []reflect.Value -> []reflect.Value).
	Gen string `protobuf:"bytes,4,opt,name=gen,proto3" json:"gen,omitempty"`
}

func (x *DynFn) Reset() {
	*x = DynFn{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DynFn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DynFn) ProtoMessage() {}

func (x *DynFn) ProtoReflect() protoreflect.Message {
	mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DynFn.ProtoReflect.Descriptor instead.
func (*DynFn) Descriptor() ([]byte, []int) {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescGZIP(), []int{3}
}

func (x *DynFn) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DynFn) GetType() *Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *DynFn) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *DynFn) GetGen() string {
	if x != nil {
		return x.Gen
	}
	return ""
}

// Fn represents a serialized function reference or struct.
type Fn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Optional) Function reference.
	Fn *UserFn `protobuf:"bytes,1,opt,name=fn,proto3" json:"fn,omitempty"`
	// (Optional) Struct type.
	Type *Type `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// (Optional) JSON-serialized value, if struct.
	Opt string `protobuf:"bytes,3,opt,name=opt,proto3" json:"opt,omitempty"`
	// (Optional) Function generator, if dynamic function.
	Dynfn *DynFn `protobuf:"bytes,4,opt,name=dynfn,proto3" json:"dynfn,omitempty"`
}

func (x *Fn) Reset() {
	*x = Fn{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Fn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Fn) ProtoMessage() {}

func (x *Fn) ProtoReflect() protoreflect.Message {
	mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Fn.ProtoReflect.Descriptor instead.
func (*Fn) Descriptor() ([]byte, []int) {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescGZIP(), []int{4}
}

func (x *Fn) GetFn() *UserFn {
	if x != nil {
		return x.Fn
	}
	return nil
}

func (x *Fn) GetType() *Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Fn) GetOpt() string {
	if x != nil {
		return x.Opt
	}
	return ""
}

func (x *Fn) GetDynfn() *DynFn {
	if x != nil {
		return x.Dynfn
	}
	return nil
}

// WindowFn represents a window fn.
type WindowFn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Kind     string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	SizeMs   int64  `protobuf:"varint,2,opt,name=size_ms,json=sizeMs,proto3" json:"size_ms,omitempty"`
	PeriodMs int64  `protobuf:"varint,3,opt,name=period_ms,json=periodMs,proto3" json:"period_ms,omitempty"`
	GapMs    int64  `protobuf:"varint,4,opt,name=gap_ms,json=gapMs,proto3" json:"gap_ms,omitempty"`
}

func (x *WindowFn) Reset() {
	*x = WindowFn{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WindowFn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowFn) ProtoMessage() {}

func (x *WindowFn) ProtoReflect() protoreflect.Message {
	mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowFn.ProtoReflect.Descriptor instead.
func (*WindowFn) Descriptor() ([]byte, []int) {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescGZIP(), []int{5}
}

func (x *WindowFn) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *WindowFn) GetSizeMs() int64 {
	if x != nil {
		return x.SizeMs
	}
	return 0
}

func (x *WindowFn) GetPeriodMs() int64 {
	if x != nil {
		return x.PeriodMs
	}
	return 0
}

func (x *WindowFn) GetGapMs() int64 {
	if x != nil {
		return x.GapMs
	}
	return 0
}

// CustomCoder
type CustomCoder struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// (Required) Name of the coder. For informational purposes only.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// (Required) Concrete type being coded.
	Type *Type `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// (Required) Encoding function.
	Enc *UserFn `protobuf:"bytes,3,opt,name=enc,proto3" json:"enc,omitempty"`
	// (Required) Decoding function.
	Dec *UserFn `protobuf:"bytes,4,opt,name=dec,proto3" json:"dec,omitempty"`
}

func (x *CustomCoder) Reset() {
	*x = CustomCoder{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CustomCoder) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomCoder) ProtoMessage() {}

func (x *CustomCoder) ProtoReflect() protoreflect.Message {
	mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomCoder.ProtoReflect.Descriptor instead.
func (*CustomCoder) Descriptor() ([]byte, []int) {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescGZIP(), []int{6}
}

func (x *CustomCoder) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CustomCoder) GetType() *Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *CustomCoder) GetEnc() *UserFn {
	if x != nil {
		return x.Enc
	}
	return nil
}

func (x *CustomCoder) GetDec() *UserFn {
	if x != nil {
		return x.Dec
	}
	return nil
}

// MultiEdge represents a partly-serialized MultiEdge. It does not include
// node information, because runners manipulate the graph structure.
type MultiEdge struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Fn       *Fn                   `protobuf:"bytes,1,opt,name=fn,proto3" json:"fn,omitempty"`
	Opcode   string                `protobuf:"bytes,4,opt,name=opcode,proto3" json:"opcode,omitempty"`
	WindowFn *WindowFn             `protobuf:"bytes,5,opt,name=window_fn,json=windowFn,proto3" json:"window_fn,omitempty"`
	Inbound  []*MultiEdge_Inbound  `protobuf:"bytes,2,rep,name=inbound,proto3" json:"inbound,omitempty"`
	Outbound []*MultiEdge_Outbound `protobuf:"bytes,3,rep,name=outbound,proto3" json:"outbound,omitempty"`
}

func (x *MultiEdge) Reset() {
	*x = MultiEdge{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MultiEdge) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MultiEdge) ProtoMessage() {}

func (x *MultiEdge) ProtoReflect() protoreflect.Message {
	mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MultiEdge.ProtoReflect.Descriptor instead.
func (*MultiEdge) Descriptor() ([]byte, []int) {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescGZIP(), []int{7}
}

func (x *MultiEdge) GetFn() *Fn {
	if x != nil {
		return x.Fn
	}
	return nil
}

func (x *MultiEdge) GetOpcode() string {
	if x != nil {
		return x.Opcode
	}
	return ""
}

func (x *MultiEdge) GetWindowFn() *WindowFn {
	if x != nil {
		return x.WindowFn
	}
	return nil
}

func (x *MultiEdge) GetInbound() []*MultiEdge_Inbound {
	if x != nil {
		return x.Inbound
	}
	return nil
}

func (x *MultiEdge) GetOutbound() []*MultiEdge_Outbound {
	if x != nil {
		return x.Outbound
	}
	return nil
}

// InjectPayload is the payload for the built-in Inject function.
type InjectPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	N int32 `protobuf:"varint,1,opt,name=n,proto3" json:"n,omitempty"`
}

func (x *InjectPayload) Reset() {
	*x = InjectPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InjectPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InjectPayload) ProtoMessage() {}

func (x *InjectPayload) ProtoReflect() protoreflect.Message {
	mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InjectPayload.ProtoReflect.Descriptor instead.
func (*InjectPayload) Descriptor() ([]byte, []int) {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescGZIP(), []int{8}
}

func (x *InjectPayload) GetN() int32 {
	if x != nil {
		return x.N
	}
	return 0
}

// ReshufflePayload is the payload for the built-in reshuffle function.
type ReshufflePayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the root coder id for the reshuffle element
	CoderId string `protobuf:"bytes,1,opt,name=coder_id,json=coderId,proto3" json:"coder_id,omitempty"`
	// local coder ids to their serialized pipeline_v1.Coder messages.
	CoderPayloads map[string][]byte `protobuf:"bytes,2,rep,name=coder_payloads,json=coderPayloads,proto3" json:"coder_payloads,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ReshufflePayload) Reset() {
	*x = ReshufflePayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReshufflePayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReshufflePayload) ProtoMessage() {}

func (x *ReshufflePayload) ProtoReflect() protoreflect.Message {
	mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReshufflePayload.ProtoReflect.Descriptor instead.
func (*ReshufflePayload) Descriptor() ([]byte, []int) {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescGZIP(), []int{9}
}

func (x *ReshufflePayload) GetCoderId() string {
	if x != nil {
		return x.CoderId
	}
	return ""
}

func (x *ReshufflePayload) GetCoderPayloads() map[string][]byte {
	if x != nil {
		return x.CoderPayloads
	}
	return nil
}

// TransformPayload represents the full payload for transforms, both
// user defined and built-in.
type TransformPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// urn is included here. It is also present in the model pipeline, but
	// not when submitting through Dataflow yet.
	Urn       string            `protobuf:"bytes,1,opt,name=urn,proto3" json:"urn,omitempty"`
	Edge      *MultiEdge        `protobuf:"bytes,2,opt,name=edge,proto3" json:"edge,omitempty"`
	Inject    *InjectPayload    `protobuf:"bytes,3,opt,name=inject,proto3" json:"inject,omitempty"`
	Reshuffle *ReshufflePayload `protobuf:"bytes,4,opt,name=reshuffle,proto3" json:"reshuffle,omitempty"`
}

func (x *TransformPayload) Reset() {
	*x = TransformPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransformPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransformPayload) ProtoMessage() {}

func (x *TransformPayload) ProtoReflect() protoreflect.Message {
	mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransformPayload.ProtoReflect.Descriptor instead.
func (*TransformPayload) Descriptor() ([]byte, []int) {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescGZIP(), []int{10}
}

func (x *TransformPayload) GetUrn() string {
	if x != nil {
		return x.Urn
	}
	return ""
}

func (x *TransformPayload) GetEdge() *MultiEdge {
	if x != nil {
		return x.Edge
	}
	return nil
}

func (x *TransformPayload) GetInject() *InjectPayload {
	if x != nil {
		return x.Inject
	}
	return nil
}

func (x *TransformPayload) GetReshuffle() *ReshufflePayload {
	if x != nil {
		return x.Reshuffle
	}
	return nil
}

// StructField matches reflect.StructField.
type Type_StructField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name      string  `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	PkgPath   string  `protobuf:"bytes,2,opt,name=pkg_path,json=pkgPath,proto3" json:"pkg_path,omitempty"`
	Type      *Type   `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	Tag       string  `protobuf:"bytes,4,opt,name=tag,proto3" json:"tag,omitempty"`
	Offset    int64   `protobuf:"varint,5,opt,name=offset,proto3" json:"offset,omitempty"`
	Index     []int32 `protobuf:"varint,6,rep,packed,name=index,proto3" json:"index,omitempty"`
	Anonymous bool    `protobuf:"varint,7,opt,name=anonymous,proto3" json:"anonymous,omitempty"`
}

func (x *Type_StructField) Reset() {
	*x = Type_StructField{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Type_StructField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_StructField) ProtoMessage() {}

func (x *Type_StructField) ProtoReflect() protoreflect.Message {
	mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_StructField.ProtoReflect.Descriptor instead.
func (*Type_StructField) Descriptor() ([]byte, []int) {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Type_StructField) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Type_StructField) GetPkgPath() string {
	if x != nil {
		return x.PkgPath
	}
	return ""
}

func (x *Type_StructField) GetType() *Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Type_StructField) GetTag() string {
	if x != nil {
		return x.Tag
	}
	return ""
}

func (x *Type_StructField) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *Type_StructField) GetIndex() []int32 {
	if x != nil {
		return x.Index
	}
	return nil
}

func (x *Type_StructField) GetAnonymous() bool {
	if x != nil {
		return x.Anonymous
	}
	return false
}

type MultiEdge_Inbound struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Kind MultiEdge_Inbound_InputKind `protobuf:"varint,1,opt,name=kind,proto3,enum=org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.MultiEdge_Inbound_InputKind" json:"kind,omitempty"`
	Type *FullType                   `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *MultiEdge_Inbound) Reset() {
	*x = MultiEdge_Inbound{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MultiEdge_Inbound) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MultiEdge_Inbound) ProtoMessage() {}

func (x *MultiEdge_Inbound) ProtoReflect() protoreflect.Message {
	mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MultiEdge_Inbound.ProtoReflect.Descriptor instead.
func (*MultiEdge_Inbound) Descriptor() ([]byte, []int) {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescGZIP(), []int{7, 0}
}

func (x *MultiEdge_Inbound) GetKind() MultiEdge_Inbound_InputKind {
	if x != nil {
		return x.Kind
	}
	return MultiEdge_Inbound_INVALID
}

func (x *MultiEdge_Inbound) GetType() *FullType {
	if x != nil {
		return x.Type
	}
	return nil
}

type MultiEdge_Outbound struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Type *FullType `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *MultiEdge_Outbound) Reset() {
	*x = MultiEdge_Outbound{}
	if protoimpl.UnsafeEnabled {
		mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MultiEdge_Outbound) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MultiEdge_Outbound) ProtoMessage() {}

func (x *MultiEdge_Outbound) ProtoReflect() protoreflect.Message {
	mi := &file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MultiEdge_Outbound.ProtoReflect.Descriptor instead.
func (*MultiEdge_Outbound) Descriptor() ([]byte, []int) {
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescGZIP(), []int{7, 1}
}

func (x *MultiEdge_Outbound) GetType() *FullType {
	if x != nil {
		return x.Type
	}
	return nil
}

var File_go_pkg_beam_core_runtime_graphx_v1_v1_proto protoreflect.FileDescriptor

var file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x62, 0x65, 0x61, 0x6d, 0x2f, 0x63, 0x6f,
	0x72, 0x65, 0x2f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2f, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x78, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x31, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x37, 0x6f,
	0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73,
	0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e,
	0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61,
	0x70, 0x68, 0x78, 0x2e, 0x76, 0x31, 0x22, 0xde, 0x0b, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x56, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e,
	0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e,
	0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d,
	0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72,
	0x61, 0x70, 0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x4b, 0x69, 0x6e,
	0x64, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x57, 0x0a, 0x07, 0x65, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e,
	0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x61, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x49, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65,
	0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62,
	0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x06, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x73, 0x12, 0x66, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x6f,
	0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73,
	0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e,
	0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61,
	0x70, 0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0e, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x60, 0x0a, 0x0c, 0x72,
	0x65, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3d, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62,
	0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0b, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x1f, 0x0a,
	0x0b, 0x69, 0x73, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x64, 0x69, 0x63, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0a, 0x69, 0x73, 0x56, 0x61, 0x72, 0x69, 0x61, 0x64, 0x69, 0x63, 0x12, 0x60,
	0x0a, 0x08, 0x63, 0x68, 0x61, 0x6e, 0x5f, 0x64, 0x69, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x45, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65,
	0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62,
	0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x2e,
	0x43, 0x68, 0x61, 0x6e, 0x44, 0x69, 0x72, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x44, 0x69, 0x72,
	0x12, 0x5f, 0x0a, 0x07, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x45, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62,
	0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x2e, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x52, 0x07, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61,
	0x6c, 0x12, 0x21, 0x0a, 0x0c, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x6b, 0x65,
	0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x4b, 0x65, 0x79, 0x1a, 0xed, 0x01, 0x0a, 0x0b, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x70, 0x6b, 0x67, 0x5f,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x6b, 0x67, 0x50,
	0x61, 0x74, 0x68, 0x12, 0x51, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3d, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62,
	0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x74, 0x61, 0x67, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74,
	0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x06, 0x20, 0x03, 0x28, 0x05, 0x52,
	0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x6e, 0x6f, 0x6e, 0x79, 0x6d,
	0x6f, 0x75, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x61, 0x6e, 0x6f, 0x6e, 0x79,
	0x6d, 0x6f, 0x75, 0x73, 0x22, 0xff, 0x01, 0x0a, 0x04, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x0b, 0x0a,
	0x07, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x4f,
	0x4f, 0x4c, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x49, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x08, 0x0a,
	0x04, 0x49, 0x4e, 0x54, 0x38, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4e, 0x54, 0x31, 0x36,
	0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4e, 0x54, 0x33, 0x32, 0x10, 0x05, 0x12, 0x09, 0x0a,
	0x05, 0x49, 0x4e, 0x54, 0x36, 0x34, 0x10, 0x06, 0x12, 0x08, 0x0a, 0x04, 0x55, 0x49, 0x4e, 0x54,
	0x10, 0x07, 0x12, 0x09, 0x0a, 0x05, 0x55, 0x49, 0x4e, 0x54, 0x38, 0x10, 0x08, 0x12, 0x0a, 0x0a,
	0x06, 0x55, 0x49, 0x4e, 0x54, 0x31, 0x36, 0x10, 0x09, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x49, 0x4e,
	0x54, 0x33, 0x32, 0x10, 0x0a, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x49, 0x4e, 0x54, 0x36, 0x34, 0x10,
	0x0b, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x0c, 0x12, 0x0b, 0x0a,
	0x07, 0x46, 0x4c, 0x4f, 0x41, 0x54, 0x33, 0x32, 0x10, 0x0d, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x4c,
	0x4f, 0x41, 0x54, 0x36, 0x34, 0x10, 0x0e, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x4c, 0x49, 0x43, 0x45,
	0x10, 0x14, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x55, 0x43, 0x54, 0x10, 0x15, 0x12, 0x08,
	0x0a, 0x04, 0x46, 0x55, 0x4e, 0x43, 0x10, 0x16, 0x12, 0x08, 0x0a, 0x04, 0x43, 0x48, 0x41, 0x4e,
	0x10, 0x17, 0x12, 0x07, 0x0a, 0x03, 0x50, 0x54, 0x52, 0x10, 0x18, 0x12, 0x0b, 0x0a, 0x07, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x41, 0x4c, 0x10, 0x19, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x58, 0x54, 0x45,
	0x52, 0x4e, 0x41, 0x4c, 0x10, 0x1a, 0x22, 0x27, 0x0a, 0x07, 0x43, 0x68, 0x61, 0x6e, 0x44, 0x69,
	0x72, 0x12, 0x08, 0x0a, 0x04, 0x52, 0x45, 0x43, 0x56, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x53,
	0x45, 0x4e, 0x44, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x4f, 0x54, 0x48, 0x10, 0x02, 0x22,
	0xd5, 0x01, 0x0a, 0x07, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x12, 0x0b, 0x0a, 0x07, 0x49,
	0x4c, 0x4c, 0x45, 0x47, 0x41, 0x4c, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f,
	0x52, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x58, 0x54, 0x10, 0x02,
	0x12, 0x08, 0x0a, 0x04, 0x54, 0x59, 0x50, 0x45, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x56,
	0x45, 0x4e, 0x54, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x0a, 0x12, 0x0a, 0x0a, 0x06, 0x57, 0x49, 0x4e,
	0x44, 0x4f, 0x57, 0x10, 0x16, 0x12, 0x06, 0x0a, 0x02, 0x4b, 0x56, 0x10, 0x0b, 0x12, 0x09, 0x0a,
	0x05, 0x43, 0x4f, 0x47, 0x42, 0x4b, 0x10, 0x0d, 0x12, 0x11, 0x0a, 0x0d, 0x57, 0x49, 0x4e, 0x44,
	0x4f, 0x57, 0x45, 0x44, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x10, 0x0e, 0x12, 0x16, 0x0a, 0x12, 0x42,
	0x55, 0x4e, 0x44, 0x4c, 0x45, 0x46, 0x49, 0x4e, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x17, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x54, 0x41, 0x54, 0x45, 0x50, 0x52, 0x4f, 0x56,
	0x49, 0x44, 0x45, 0x52, 0x10, 0x18, 0x12, 0x05, 0x0a, 0x01, 0x54, 0x10, 0x0f, 0x12, 0x05, 0x0a,
	0x01, 0x55, 0x10, 0x10, 0x12, 0x05, 0x0a, 0x01, 0x56, 0x10, 0x11, 0x12, 0x05, 0x0a, 0x01, 0x57,
	0x10, 0x12, 0x12, 0x05, 0x0a, 0x01, 0x58, 0x10, 0x13, 0x12, 0x05, 0x0a, 0x01, 0x59, 0x10, 0x14,
	0x12, 0x05, 0x0a, 0x01, 0x5a, 0x10, 0x15, 0x22, 0xc0, 0x01, 0x0a, 0x08, 0x46, 0x75, 0x6c, 0x6c,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x51, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67,
	0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x61, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x6f, 0x72,
	0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64,
	0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63,
	0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70,
	0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x75, 0x6c, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a,
	0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x6f, 0x0a, 0x06, 0x55, 0x73,
	0x65, 0x72, 0x46, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f,
	0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x94, 0x01, 0x0a, 0x05,
	0x44, 0x79, 0x6e, 0x46, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70,
	0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67,
	0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x10, 0x0a, 0x03, 0x67, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x67,
	0x65, 0x6e, 0x22, 0x90, 0x02, 0x0a, 0x02, 0x46, 0x6e, 0x12, 0x4f, 0x0a, 0x02, 0x66, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e,
	0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x46, 0x6e, 0x52, 0x02, 0x66, 0x6e, 0x12, 0x51, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e,
	0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a,
	0x03, 0x6f, 0x70, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6f, 0x70, 0x74, 0x12,
	0x54, 0x0a, 0x05, 0x64, 0x79, 0x6e, 0x66, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e,
	0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d,
	0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61,
	0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67,
	0x72, 0x61, 0x70, 0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x79, 0x6e, 0x46, 0x6e, 0x52, 0x05,
	0x64, 0x79, 0x6e, 0x66, 0x6e, 0x22, 0x6b, 0x0a, 0x08, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x46,
	0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x6d, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x73, 0x69, 0x7a, 0x65, 0x4d, 0x73, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x5f, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x08, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x4d, 0x73, 0x12, 0x15, 0x0a, 0x06, 0x67,
	0x61, 0x70, 0x5f, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x67, 0x61, 0x70,
	0x4d, 0x73, 0x22, 0x9a, 0x02, 0x0a, 0x0b, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x64,
	0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70,
	0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x51, 0x0a, 0x03, 0x65, 0x6e, 0x63,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61,
	0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f,
	0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x73, 0x65, 0x72, 0x46, 0x6e, 0x52, 0x03, 0x65, 0x6e, 0x63, 0x12, 0x51, 0x0a, 0x03,
	0x64, 0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73,
	0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72,
	0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x46, 0x6e, 0x52, 0x03, 0x64, 0x65, 0x63, 0x22,
	0xba, 0x06, 0x0a, 0x09, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x45, 0x64, 0x67, 0x65, 0x12, 0x4b, 0x0a,
	0x02, 0x66, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x6f, 0x72, 0x67, 0x2e,
	0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73,
	0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72,
	0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x6e, 0x52, 0x02, 0x66, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x70,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6f, 0x70, 0x63, 0x6f,
	0x64, 0x65, 0x12, 0x5e, 0x0a, 0x09, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x66, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e,
	0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x46, 0x6e, 0x52, 0x08, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x46, 0x6e, 0x12, 0x64, 0x0a, 0x07, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b,
	0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75,
	0x6c, 0x74, 0x69, 0x45, 0x64, 0x67, 0x65, 0x2e, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x52,
	0x07, 0x69, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x67, 0x0a, 0x08, 0x6f, 0x75, 0x74, 0x62,
	0x6f, 0x75, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x6f, 0x72, 0x67,
	0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b,
	0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f,
	0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x45, 0x64, 0x67, 0x65, 0x2e, 0x4f,
	0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x52, 0x08, 0x6f, 0x75, 0x74, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x1a, 0xb5, 0x02, 0x0a, 0x07, 0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x68, 0x0a,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x54, 0x2e, 0x6f, 0x72,
	0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64,
	0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63,
	0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70,
	0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x45, 0x64, 0x67, 0x65, 0x2e,
	0x49, 0x6e, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x4b, 0x69, 0x6e,
	0x64, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x55, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e,
	0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x75, 0x6c, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x69,
	0x0a, 0x09, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x0b, 0x0a, 0x07, 0x49,
	0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4d, 0x41, 0x49, 0x4e,
	0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x54, 0x4f, 0x4e, 0x10,
	0x02, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x4c, 0x49, 0x43, 0x45, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03,
	0x4d, 0x41, 0x50, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x4d, 0x41,
	0x50, 0x10, 0x05, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x54, 0x45, 0x52, 0x10, 0x06, 0x12, 0x0a, 0x0a,
	0x06, 0x52, 0x45, 0x49, 0x54, 0x45, 0x52, 0x10, 0x07, 0x1a, 0x61, 0x0a, 0x08, 0x4f, 0x75, 0x74,
	0x62, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x55, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b,
	0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x75,
	0x6c, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x1d, 0x0a, 0x0d,
	0x49, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x0c, 0x0a,
	0x01, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x01, 0x6e, 0x22, 0xf5, 0x01, 0x0a, 0x10,
	0x52, 0x65, 0x73, 0x68, 0x75, 0x66, 0x66, 0x6c, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x12, 0x19, 0x0a, 0x08, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x83, 0x01, 0x0a, 0x0e,
	0x63, 0x6f, 0x64, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x5c, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68,
	0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70,
	0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x68, 0x75, 0x66, 0x66, 0x6c, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e,
	0x43, 0x6f, 0x64, 0x65, 0x72, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x0d, 0x63, 0x6f, 0x64, 0x65, 0x72, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x73, 0x1a, 0x40, 0x0a, 0x12, 0x43, 0x6f, 0x64, 0x65, 0x72, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0xc5, 0x02, 0x0a, 0x10, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6e, 0x12, 0x56, 0x0a, 0x04, 0x65, 0x64,
	0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61,
	0x70, 0x61, 0x63, 0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e,
	0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65,
	0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x45, 0x64, 0x67, 0x65, 0x52, 0x04, 0x65, 0x64,
	0x67, 0x65, 0x12, 0x5e, 0x0a, 0x06, 0x69, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x46, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65, 0x2e,
	0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e, 0x70, 0x6b, 0x67,
	0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x6a,
	0x65, 0x63, 0x74, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x06, 0x69, 0x6e, 0x6a, 0x65,
	0x63, 0x74, 0x12, 0x67, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x68, 0x75, 0x66, 0x66, 0x6c, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x6f, 0x72, 0x67, 0x2e, 0x61, 0x70, 0x61, 0x63,
	0x68, 0x65, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x73, 0x64, 0x6b, 0x73, 0x2e, 0x67, 0x6f, 0x2e,
	0x70, 0x6b, 0x67, 0x2e, 0x62, 0x65, 0x61, 0x6d, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x72, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x68, 0x75, 0x66, 0x66, 0x6c, 0x65, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x52, 0x09, 0x72, 0x65, 0x73, 0x68, 0x75, 0x66, 0x66, 0x6c, 0x65, 0x42, 0x46, 0x5a, 0x44, 0x67,
	0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x70, 0x61, 0x63, 0x68, 0x65,
	0x2f, 0x62, 0x65, 0x61, 0x6d, 0x2f, 0x73, 0x64, 0x6b, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x67, 0x6f,
	0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x62, 0x65, 0x61, 0x6d, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x72,
	0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x78, 0x2f, 0x76, 0x31,
	0x3b, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescOnce sync.Once
	file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescData = file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDesc
)

func file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescGZIP() []byte {
	file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescOnce.Do(func() {
		file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescData = protoimpl.X.CompressGZIP(file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescData)
	})
	return file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDescData
}

var file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_goTypes = []interface{}{
	(Type_Kind)(0),                   // 0: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type.Kind
	(Type_ChanDir)(0),                // 1: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type.ChanDir
	(Type_Special)(0),                // 2: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type.Special
	(MultiEdge_Inbound_InputKind)(0), // 3: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.MultiEdge.Inbound.InputKind
	(*Type)(nil),                     // 4: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type
	(*FullType)(nil),                 // 5: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.FullType
	(*UserFn)(nil),                   // 6: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.UserFn
	(*DynFn)(nil),                    // 7: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.DynFn
	(*Fn)(nil),                       // 8: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Fn
	(*WindowFn)(nil),                 // 9: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.WindowFn
	(*CustomCoder)(nil),              // 10: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.CustomCoder
	(*MultiEdge)(nil),                // 11: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.MultiEdge
	(*InjectPayload)(nil),            // 12: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.InjectPayload
	(*ReshufflePayload)(nil),         // 13: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.ReshufflePayload
	(*TransformPayload)(nil),         // 14: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.TransformPayload
	(*Type_StructField)(nil),         // 15: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type.StructField
	(*MultiEdge_Inbound)(nil),        // 16: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.MultiEdge.Inbound
	(*MultiEdge_Outbound)(nil),       // 17: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.MultiEdge.Outbound
	nil,                              // 18: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.ReshufflePayload.CoderPayloadsEntry
}
var file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_depIdxs = []int32{
	0,  // 0: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type.kind:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type.Kind
	4,  // 1: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type.element:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type
	15, // 2: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type.fields:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type.StructField
	4,  // 3: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type.parameter_types:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type
	4,  // 4: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type.return_types:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type
	1,  // 5: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type.chan_dir:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type.ChanDir
	2,  // 6: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type.special:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type.Special
	4,  // 7: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.FullType.type:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type
	5,  // 8: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.FullType.components:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.FullType
	4,  // 9: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.UserFn.type:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type
	4,  // 10: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.DynFn.type:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type
	6,  // 11: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Fn.fn:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.UserFn
	4,  // 12: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Fn.type:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type
	7,  // 13: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Fn.dynfn:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.DynFn
	4,  // 14: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.CustomCoder.type:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type
	6,  // 15: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.CustomCoder.enc:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.UserFn
	6,  // 16: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.CustomCoder.dec:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.UserFn
	8,  // 17: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.MultiEdge.fn:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Fn
	9,  // 18: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.MultiEdge.window_fn:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.WindowFn
	16, // 19: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.MultiEdge.inbound:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.MultiEdge.Inbound
	17, // 20: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.MultiEdge.outbound:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.MultiEdge.Outbound
	18, // 21: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.ReshufflePayload.coder_payloads:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.ReshufflePayload.CoderPayloadsEntry
	11, // 22: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.TransformPayload.edge:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.MultiEdge
	12, // 23: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.TransformPayload.inject:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.InjectPayload
	13, // 24: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.TransformPayload.reshuffle:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.ReshufflePayload
	4,  // 25: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type.StructField.type:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.Type
	3,  // 26: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.MultiEdge.Inbound.kind:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.MultiEdge.Inbound.InputKind
	5,  // 27: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.MultiEdge.Inbound.type:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.FullType
	5,  // 28: org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.MultiEdge.Outbound.type:type_name -> org.apache.beam.sdks.go.pkg.beam.core.runtime.graphx.v1.FullType
	29, // [29:29] is the sub-list for method output_type
	29, // [29:29] is the sub-list for method input_type
	29, // [29:29] is the sub-list for extension type_name
	29, // [29:29] is the sub-list for extension extendee
	0,  // [0:29] is the sub-list for field type_name
}

func init() { file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_init() }
func file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_init() {
	if File_go_pkg_beam_core_runtime_graphx_v1_v1_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Type); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FullType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UserFn); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DynFn); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Fn); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WindowFn); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CustomCoder); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MultiEdge); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InjectPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReshufflePayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransformPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Type_StructField); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MultiEdge_Inbound); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MultiEdge_Outbound); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_goTypes,
		DependencyIndexes: file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_depIdxs,
		EnumInfos:         file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_enumTypes,
		MessageInfos:      file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_msgTypes,
	}.Build()
	File_go_pkg_beam_core_runtime_graphx_v1_v1_proto = out.File
	file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_rawDesc = nil
	file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_goTypes = nil
	file_go_pkg_beam_core_runtime_graphx_v1_v1_proto_depIdxs = nil
}
