/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import 'package:playground/modules/examples/models/example_loading_descriptors/catalog_default_example_loading_descriptor.dart';
import 'package:playground/modules/examples/models/example_model.dart';
import 'package:playground/pages/playground/states/example_loaders/example_loader.dart';
import 'package:playground/pages/playground/states/examples_state.dart';

class CatalogDefaultExampleLoader extends ExampleLoader {
  final CatalogDefaultExampleLoadingDescriptor descriptor;
  final ExampleState exampleState;

  const CatalogDefaultExampleLoader({
    required this.descriptor,
    required this.exampleState,
  });

  @override
  Future<ExampleModel> get future async {
    if (!exampleState.hasExampleCatalog) {
      throw Exception('Default example requires a catalog in ExampleState');
    }

    await exampleState.loadDefaultExamplesIfNot();
    final result = exampleState.defaultExamplesMap[descriptor.sdk];

    if (result == null) {
      throw Exception('Default example not found for $descriptor');
    }

    return result;
  }
}
