/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import 'package:flutter/material.dart';

class TobColors {
  static const white = Colors.white;
  static const black = Colors.black;
  static const grey1 = Color(0xffDFE1E3);
  static const grey2 = Color(0xffCBCBCB);
  static const grey3 = Color(0xffA0A4AB);
  static const grey4 = Color(0x30808080);

  static const green = Color(0xff37AC66);
  static const orange = Color(0xffEEAB00);
  static const red = Color(0xffE54545);
}

class TobLightThemeColors {
  static const primaryBackground = Colors.white;
  static const secondaryBackground = Color(0xffFEFDFD);
  static const grey = Color(0xffE5E5E5);
  static const text = Color(0xff242639);
  static const primary = Color(0xffE74D1A);
}

class TobDarkThemeColors {
  static const primaryBackground = Color(0xff18181B);
  static const secondaryBackground = Color(0xff2E2E34);
  static const grey = Color(0xff3F3F46);
  static const text = Color(0xffFFFFFF);
  static const primary = Color(0xffF26628);
}
