// @generated by protobuf-ts 2.1.0 with parameter client_grpc1,server_grpc1,generate_dependencies
// @generated from protobuf file "beam_runner_api.proto" (package "org.apache.beam.model.pipeline.v1", syntax proto3)
// tslint:disable
//
//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//
//
// Protocol Buffers describing the Runner API, which is the runner-independent,
// SDK-independent definition of the Beam model.
//
import { ServiceType } from "@protobuf-ts/runtime-rpc";
import { WireType } from "@protobuf-ts/runtime";
import type { BinaryWriteOptions } from "@protobuf-ts/runtime";
import type { IBinaryWriter } from "@protobuf-ts/runtime";
import { UnknownFieldHandler } from "@protobuf-ts/runtime";
import type { BinaryReadOptions } from "@protobuf-ts/runtime";
import type { IBinaryReader } from "@protobuf-ts/runtime";
import type { PartialMessage } from "@protobuf-ts/runtime";
import { reflectionMergePartial } from "@protobuf-ts/runtime";
import { MESSAGE_TYPE } from "@protobuf-ts/runtime";
import { MessageType } from "@protobuf-ts/runtime";
import { ApiServiceDescriptor } from "./endpoints";
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.BeamConstants
 */
export interface BeamConstants {
}
/**
 * All timestamps in milliseconds since Jan 1, 1970.
 *
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.BeamConstants.Constants
 */
export enum BeamConstants_Constants {
    /**
     * All timestamps of elements or window boundaries must be within
     * the interval [MIN_TIMESTAMP_MILLIS, MAX_TIMESTAMP_MILLIS].
     * The smallest representable timestamp of an element or a window boundary.
     *
     * @generated from protobuf enum value: MIN_TIMESTAMP_MILLIS = 0;
     */
    MIN_TIMESTAMP_MILLIS = 0,
    /**
     * The largest representable timestamp of an element or a window boundary.
     *
     * @generated from protobuf enum value: MAX_TIMESTAMP_MILLIS = 1;
     */
    MAX_TIMESTAMP_MILLIS = 1,
    /**
     * The maximum timestamp for the global window.
     * Triggers use max timestamp to set timers' timestamp. Timers fire when
     * the watermark passes their timestamps. So, the timestamp needs to be
     * smaller than the MAX_TIMESTAMP_MILLIS.
     * One standard day is subtracted from MAX_TIMESTAMP_MILLIS to make sure
     * the max timestamp is smaller than MAX_TIMESTAMP_MILLIS even after rounding up
     * to seconds or minutes.
     *
     * @generated from protobuf enum value: GLOBAL_WINDOW_MAX_TIMESTAMP_MILLIS = 2;
     */
    GLOBAL_WINDOW_MAX_TIMESTAMP_MILLIS = 2
}
/**
 * A set of mappings from id to message. This is included as an optional field
 * on any proto message that may contain references needing resolution.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Components
 */
export interface Components {
    /**
     * (Required) A map from pipeline-scoped id to PTransform.
     *
     * Keys of the transforms map may be used by runners to identify pipeline
     * steps. Hence it's recommended to use strings that are not too long that
     * match regex '[A-Za-z0-9-_]+'.
     *
     * @generated from protobuf field: map<string, org.apache.beam.model.pipeline.v1.PTransform> transforms = 1;
     */
    transforms: {
        [key: string]: PTransform;
    };
    /**
     * (Required) A map from pipeline-scoped id to PCollection.
     *
     * @generated from protobuf field: map<string, org.apache.beam.model.pipeline.v1.PCollection> pcollections = 2;
     */
    pcollections: {
        [key: string]: PCollection;
    };
    /**
     * (Required) A map from pipeline-scoped id to WindowingStrategy.
     *
     * @generated from protobuf field: map<string, org.apache.beam.model.pipeline.v1.WindowingStrategy> windowing_strategies = 3;
     */
    windowingStrategies: {
        [key: string]: WindowingStrategy;
    };
    /**
     * (Required) A map from pipeline-scoped id to Coder.
     *
     * @generated from protobuf field: map<string, org.apache.beam.model.pipeline.v1.Coder> coders = 4;
     */
    coders: {
        [key: string]: Coder;
    };
    /**
     * (Required) A map from pipeline-scoped id to Environment.
     *
     * @generated from protobuf field: map<string, org.apache.beam.model.pipeline.v1.Environment> environments = 5;
     */
    environments: {
        [key: string]: Environment;
    };
}
/**
 * A Pipeline is a hierarchical graph of PTransforms, linked
 * by PCollections. A typical graph may look like:
 *
 *   Impulse -> PCollection -> ParDo -> PCollection -> GroupByKey -> ...
 *                                   \> PCollection -> ParDo      -> ...
 *                                                  \> ParDo      -> ...
 *   Impulse -> PCollection -> ParDo -> PCollection -> ...
 *
 * This is represented by a number of by-reference maps to transforms,
 * PCollections, SDK environments, coders, etc., for
 * supporting compact reuse and arbitrary graph structure.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Pipeline
 */
export interface Pipeline {
    /**
     * (Required) The coders, UDFs, graph nodes, etc, that make up
     * this pipeline.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Components components = 1;
     */
    components?: Components;
    /**
     * (Required) The ids of all PTransforms that are not contained within another
     * PTransform. These must be in shallow topological order, so that traversing
     * them recursively in this order yields a recursively topological traversal.
     *
     * @generated from protobuf field: repeated string root_transform_ids = 2;
     */
    rootTransformIds: string[];
    /**
     * (Optional) Static display data for the pipeline. If there is none,
     * it may be omitted.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.DisplayData display_data = 3;
     */
    displayData: DisplayData[];
    /**
     * (Optional) A set of requirements that the runner MUST understand and be
     * able to faithfully provide in order to execute this pipeline. These
     * may indicate that a runner must inspect new fields on a component or
     * provide additional guarantees when processing specific transforms.
     * A runner should reject any pipelines with unknown requirements.
     *
     * @generated from protobuf field: repeated string requirements = 4;
     */
    requirements: string[];
}
/**
 * Transforms are the operations in your pipeline, and provide a generic
 * processing framework. You provide processing logic in the form of a function
 * object (colloquially referred to as “user code”), and your user code is
 * applied to each element of an input PCollection (or more than one
 * PCollection). Depending on the pipeline runner and back-end that you choose,
 * many different workers across a cluster may execute instances of your user
 * code in parallel. The user code running on each worker generates the output
 * elements that are ultimately added to the final output PCollection that the
 * transform produces.
 *
 * The Beam SDKs contain a number of different transforms that you can apply to
 * your pipeline’s PCollections. These include general-purpose core transforms,
 * such as ParDo or Combine. There are also pre-written composite transforms
 * included in the SDKs, which combine one or more of the core transforms in a
 * useful processing pattern, such as counting or combining elements in a
 * collection. You can also define your own more complex composite transforms to
 * fit your pipeline’s exact use case.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.PTransform
 */
export interface PTransform {
    /**
     * (Required) A unique name for the application node.
     *
     * Ideally, this should be stable over multiple evolutions of a pipeline
     * for the purposes of logging and associating pipeline state with a node,
     * etc.
     *
     * If it is not stable, then the runner decides what will happen. But, most
     * importantly, it must always be here and be unique, even if it is
     * autogenerated.
     *
     * @generated from protobuf field: string unique_name = 5;
     */
    uniqueName: string;
    /**
     * (Optional) A URN and payload that, together, fully defined the semantics
     * of this transform.
     *
     * If absent, this must be an "anonymous" composite transform.
     *
     * For primitive transform in the Runner API, this is required, and the
     * payloads are well-defined messages. When the URN indicates ParDo it
     * is a ParDoPayload, and so on. For some special composite transforms,
     * the payload is also officially defined. See StandardPTransforms for
     * details.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FunctionSpec spec = 1;
     */
    spec?: FunctionSpec;
    /**
     * (Optional) A list of the ids of transforms that it contains.
     *
     * Primitive transforms (see StandardPTransforms.Primitives) are not allowed
     * to specify subtransforms.
     *
     * Note that a composite transform may have zero subtransforms as long as it
     * only outputs PCollections that are in its inputs.
     *
     * @generated from protobuf field: repeated string subtransforms = 2;
     */
    subtransforms: string[];
    /**
     * (Required) A map from local names of inputs (unique only with this map, and
     * likely embedded in the transform payload and serialized user code) to
     * PCollection ids.
     *
     * The payload for this transform may clarify the relationship of these
     * inputs. For example:
     *
     *  - for a Flatten transform they are merged
     *  - for a ParDo transform, some may be side inputs
     *
     * All inputs are recorded here so that the topological ordering of
     * the graph is consistent whether or not the payload is understood.
     *
     * @generated from protobuf field: map<string, string> inputs = 3;
     */
    inputs: {
        [key: string]: string;
    };
    /**
     * (Required) A map from local names of outputs (unique only within this map,
     * and likely embedded in the transform payload and serialized user code)
     * to PCollection ids.
     *
     * The URN or payload for this transform node may clarify the type and
     * relationship of these outputs. For example:
     *
     *  - for a ParDo transform, these are tags on PCollections, which will be
     *    embedded in the DoFn.
     *
     * @generated from protobuf field: map<string, string> outputs = 4;
     */
    outputs: {
        [key: string]: string;
    };
    /**
     * (Optional) Static display data for this PTransform application. If
     * there is none, it may be omitted.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.DisplayData display_data = 6;
     */
    displayData: DisplayData[];
    /**
     * Environment where the current PTransform should be executed in.
     *
     * Transforms that are required to be implemented by a runner must omit this.
     * All other transforms are required to specify this.
     *
     * @generated from protobuf field: string environment_id = 7;
     */
    environmentId: string;
    /**
     * (Optional) A map from URNs designating a type of annotation, to the
     * annotation in binary format. For example, an annotation could indicate
     * that this PTransform has specific privacy properties.
     *
     * A runner MAY ignore types of annotations it doesn't understand. Therefore
     * annotations MUST NOT be used for metadata that can affect correct
     * execution of the transform.
     *
     * @generated from protobuf field: map<string, bytes> annotations = 8;
     */
    annotations: {
        [key: string]: Uint8Array;
    };
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.StandardPTransforms
 */
export interface StandardPTransforms {
}
/**
 * Primitive transforms may not specify composite sub-transforms.
 *
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.StandardPTransforms.Primitives
 */
export enum StandardPTransforms_Primitives {
    /**
     * ParDo is a Beam transform for generic parallel processing. The ParDo
     * processing paradigm is similar to the “Map” phase of a
     * Map/Shuffle/Reduce-style algorithm: a ParDo transform considers each
     * element in the input PCollection, performs some processing function
     * (your user code) on that element, and emits zero, one, or multiple
     * elements to an output PCollection.
     *
     * See https://beam.apache.org/documentation/programming-guide/#pardo
     * for additional details.
     *
     * Payload: ParDoPayload
     *
     * @generated from protobuf enum value: PAR_DO = 0;
     */
    PAR_DO = 0,
    /**
     * Flatten is a Beam transform for PCollection objects that store the same
     * data type. Flatten merges multiple PCollection objects into a single
     * logical PCollection.
     *
     * See https://beam.apache.org/documentation/programming-guide/#flatten
     * for additional details.
     *
     * Payload: None
     *
     * @generated from protobuf enum value: FLATTEN = 1;
     */
    FLATTEN = 1,
    /**
     * GroupByKey is a Beam transform for processing collections of key/value
     * pairs. It’s a parallel reduction operation, analogous to the Shuffle
     * phase of a Map/Shuffle/Reduce-style algorithm. The input to GroupByKey is
     * a collection of key/value pairs that represents a multimap, where the
     * collection contains multiple pairs that have the same key, but different
     * values. Given such a collection, you use GroupByKey to collect all of the
     * values associated with each unique key.
     *
     * See https://beam.apache.org/documentation/programming-guide/#groupbykey
     * for additional details.
     *
     * Never defines an environment as the runner is required to implement this
     * transform.
     *
     * Payload: None
     *
     * @generated from protobuf enum value: GROUP_BY_KEY = 2;
     */
    GROUP_BY_KEY = 2,
    /**
     * A transform which produces a single empty byte array at the minimum
     * timestamp in the GlobalWindow.
     *
     * Never defines an environment as the runner is required to implement this
     * transform.
     *
     * Payload: None
     *
     * @generated from protobuf enum value: IMPULSE = 3;
     */
    IMPULSE = 3,
    /**
     * Windowing subdivides a PCollection according to the timestamps of its
     * individual elements. Transforms that aggregate multiple elements, such as
     * GroupByKey and Combine, work implicitly on a per-window basis — they
     * process each PCollection as a succession of multiple, finite windows,
     * though the entire collection itself may be of unbounded size.
     *
     * See https://beam.apache.org/documentation/programming-guide/#windowing
     * for additional details.
     *
     * Payload: WindowIntoPayload
     *
     * @generated from protobuf enum value: ASSIGN_WINDOWS = 4;
     */
    ASSIGN_WINDOWS = 4,
    /**
     * A testing input that generates an unbounded {@link PCollection} of
     * elements, advancing the watermark and processing time as elements are
     * emitted. After all of the specified elements are emitted, ceases to
     * produce output.
     *
     * See https://beam.apache.org/blog/2016/10/20/test-stream.html
     * for additional details.
     *
     * Payload: TestStreamPayload
     *
     * @generated from protobuf enum value: TEST_STREAM = 5;
     */
    TEST_STREAM = 5,
    /**
     * Represents mapping of main input window onto side input window.
     *
     * Side input window mapping function:
     * Input: KV<nonce, MainInputWindow>
     * Output: KV<nonce, SideInputWindow>
     *
     * For each main input window, the side input window is returned. The
     * nonce is used by a runner to associate each input with its output.
     * The nonce is represented as an opaque set of bytes.
     *
     * Payload: SideInput#window_mapping_fn FunctionSpec
     *
     * @generated from protobuf enum value: MAP_WINDOWS = 6;
     */
    MAP_WINDOWS = 6,
    /**
     * Used to merge windows during a GroupByKey.
     *
     * Window merging function:
     * Input: KV<nonce, iterable<OriginalWindow>>
     * Output: KV<nonce, KV<iterable<UnmergedOriginalWindow>, iterable<KV<MergedWindow, iterable<ConsumedOriginalWindow>>>>
     *
     * For each set of original windows, a list of all unmerged windows is
     * output alongside a map of merged window to set of consumed windows.
     * All original windows must be contained in either the unmerged original
     * window set or one of the consumed original window sets. Each original
     * window can only be part of one output set. The nonce is used by a runner
     * to associate each input with its output. The nonce is represented as an
     * opaque set of bytes.
     *
     * Payload: WindowingStrategy#window_fn FunctionSpec
     *
     * @generated from protobuf enum value: MERGE_WINDOWS = 7;
     */
    MERGE_WINDOWS = 7,
    /**
     * A transform that translates a given element to its human-readable
     * representation.
     *
     * Input: KV<nonce, element>
     * Output: KV<nonce, string>
     *
     * For each given element, the implementation returns the best-effort
     * human-readable representation. When possible, the implementation could
     * call a user-overridable method on the type. For example, Java could
     * call `toString()`, Python could call `str()`, Golang could call
     * `String()`.  The nonce is used by a runner to associate each input with
     * its output. The nonce is represented as an opaque set of bytes.
     *
     * Payload: none
     *
     * @generated from protobuf enum value: TO_STRING = 8;
     */
    TO_STRING = 8
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.StandardPTransforms.DeprecatedPrimitives
 */
export enum StandardPTransforms_DeprecatedPrimitives {
    /**
     * Represents the operation to read a Bounded or Unbounded source.
     * Payload: ReadPayload.
     *
     * @generated from protobuf enum value: READ = 0;
     */
    READ = 0,
    /**
     * Runners should move away from translating `CreatePCollectionView` and treat this as
     * part of the translation for a `ParDo` side input.
     *
     * @generated from protobuf enum value: CREATE_VIEW = 1;
     */
    CREATE_VIEW = 1
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.StandardPTransforms.Composites
 */
export enum StandardPTransforms_Composites {
    /**
     * Represents the Combine.perKey() operation.
     * If this is produced by an SDK, it is assumed that the SDK understands
     * each of CombineComponents.
     * Payload: CombinePayload
     *
     * @generated from protobuf enum value: COMBINE_PER_KEY = 0;
     */
    COMBINE_PER_KEY = 0,
    /**
     * Represents the Combine.globally() operation.
     * If this is produced by an SDK, it is assumed that the SDK understands
     * each of CombineComponents.
     * Payload: CombinePayload
     *
     * @generated from protobuf enum value: COMBINE_GLOBALLY = 1;
     */
    COMBINE_GLOBALLY = 1,
    /**
     * Represents the Reshuffle operation.
     *
     * @generated from protobuf enum value: RESHUFFLE = 2;
     */
    RESHUFFLE = 2,
    /**
     * Less well-known. Payload: WriteFilesPayload.
     *
     * @generated from protobuf enum value: WRITE_FILES = 3;
     */
    WRITE_FILES = 3,
    /**
     * Payload: PubSubReadPayload.
     *
     * @generated from protobuf enum value: PUBSUB_READ = 4;
     */
    PUBSUB_READ = 4,
    /**
     * Payload: PubSubWritePayload.
     *
     * @generated from protobuf enum value: PUBSUB_WRITE = 5;
     */
    PUBSUB_WRITE = 5,
    /**
     * Represents the GroupIntoBatches.WithShardedKey operation.
     * Payload: GroupIntoBatchesPayload
     *
     * @generated from protobuf enum value: GROUP_INTO_BATCHES_WITH_SHARDED_KEY = 6;
     */
    GROUP_INTO_BATCHES_WITH_SHARDED_KEY = 6
}
/**
 * Payload for all of these: CombinePayload
 *
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.StandardPTransforms.CombineComponents
 */
export enum StandardPTransforms_CombineComponents {
    /**
     * Represents the Pre-Combine part of a lifted Combine Per Key, as described
     * in the following document:
     * https://s.apache.org/beam-runner-api-combine-model#heading=h.ta0g6ase8z07
     * Payload: CombinePayload
     *
     * @generated from protobuf enum value: COMBINE_PER_KEY_PRECOMBINE = 0;
     */
    COMBINE_PER_KEY_PRECOMBINE = 0,
    /**
     * Represents the Merge Accumulators part of a lifted Combine Per Key, as
     * described in the following document:
     * https://s.apache.org/beam-runner-api-combine-model#heading=h.jco9rvatld5m
     * Payload: CombinePayload
     *
     * @generated from protobuf enum value: COMBINE_PER_KEY_MERGE_ACCUMULATORS = 1;
     */
    COMBINE_PER_KEY_MERGE_ACCUMULATORS = 1,
    /**
     * Represents the Extract Outputs part of a lifted Combine Per Key, as
     * described in the following document:
     * https://s.apache.org/beam-runner-api-combine-model#heading=h.i9i6p8gtl6ku
     * Payload: CombinePayload
     *
     * @generated from protobuf enum value: COMBINE_PER_KEY_EXTRACT_OUTPUTS = 2;
     */
    COMBINE_PER_KEY_EXTRACT_OUTPUTS = 2,
    /**
     * Represents the Combine Grouped Values transform, as described in the
     * following document:
     * https://s.apache.org/beam-runner-api-combine-model#heading=h.aj86ew4v1wk
     * Payload: CombinePayload
     *
     * @generated from protobuf enum value: COMBINE_GROUPED_VALUES = 3;
     */
    COMBINE_GROUPED_VALUES = 3,
    /**
     * Represents the Convert To Accumulators transform, as described in the
     * following document:
     * https://s.apache.org/beam-runner-api-combine-model#heading=h.h5697l1scd9x
     * Payload: CombinePayload
     *
     * @generated from protobuf enum value: COMBINE_PER_KEY_CONVERT_TO_ACCUMULATORS = 4;
     */
    COMBINE_PER_KEY_CONVERT_TO_ACCUMULATORS = 4
}
/**
 * Payload for all of these: ParDoPayload containing the user's SDF
 *
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.StandardPTransforms.SplittableParDoComponents
 */
export enum StandardPTransforms_SplittableParDoComponents {
    /**
     * Pairs the input element with its initial restriction.
     * Input: element; output: KV(element, restriction).
     *
     * @generated from protobuf enum value: PAIR_WITH_RESTRICTION = 0;
     */
    PAIR_WITH_RESTRICTION = 0,
    /**
     * Splits the restriction of each element/restriction pair and returns the
     * resulting splits, with a corresponding floating point size estimation
     * for each.
     *
     * A reasonable value for size is the number of bytes expected to be
     * produced by this (element, restriction) pair.
     *
     * Input: KV(element, restriction)
     * Output: KV(KV(element, restriction), size))
     *
     * @generated from protobuf enum value: SPLIT_AND_SIZE_RESTRICTIONS = 1;
     */
    SPLIT_AND_SIZE_RESTRICTIONS = 1,
    /**
     * Applies the DoFn to every element and restriction.
     *
     * All primary and residuals returned from checkpointing or splitting must
     * have the same type as the input to this transform.
     *
     * Input: KV(KV(element, restriction), size); output: DoFn's output.
     *
     * @generated from protobuf enum value: PROCESS_SIZED_ELEMENTS_AND_RESTRICTIONS = 2;
     */
    PROCESS_SIZED_ELEMENTS_AND_RESTRICTIONS = 2,
    /**
     * Truncates the restriction of each element/restriction pair and returns
     * the finite restriction which will be processed when a pipeline is
     * drained. See
     * https://docs.google.com/document/d/1NExwHlj-2q2WUGhSO4jTu8XGhDPmm3cllSN8IMmWci8/edit#.
     * for additional details about drain.
     *
     * Input: KV(KV(element, restriction), size);
     * Output: KV(KV(element, restriction), size).
     *
     * @generated from protobuf enum value: TRUNCATE_SIZED_RESTRICTION = 3;
     */
    TRUNCATE_SIZED_RESTRICTION = 3
}
/**
 * Payload for all of these: GroupIntoBatchesPayload
 *
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.StandardPTransforms.GroupIntoBatchesComponents
 */
export enum StandardPTransforms_GroupIntoBatchesComponents {
    /**
     * @generated from protobuf enum value: GROUP_INTO_BATCHES = 0;
     */
    GROUP_INTO_BATCHES = 0
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.StandardSideInputTypes
 */
export interface StandardSideInputTypes {
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.StandardSideInputTypes.Enum
 */
export enum StandardSideInputTypes_Enum {
    /**
     * Represents a view over a PCollection<V>.
     *
     * StateGetRequests performed on this side input must use
     * StateKey.IterableSideInput.
     *
     * @generated from protobuf enum value: ITERABLE = 0;
     */
    ITERABLE = 0,
    /**
     * Represents a view over a PCollection<KV<K, V>>.
     *
     * StateGetRequests performed on this side input must use
     * StateKey.IterableSideInput or StateKey.MultimapSideInput.
     *
     * @generated from protobuf enum value: MULTIMAP = 1;
     */
    MULTIMAP = 1
}
/**
 * A PCollection!
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.PCollection
 */
export interface PCollection {
    /**
     * (Required) A unique name for the PCollection.
     *
     * Ideally, this should be stable over multiple evolutions of a pipeline
     * for the purposes of logging and associating pipeline state with a node,
     * etc.
     *
     * If it is not stable, then the runner decides what will happen. But, most
     * importantly, it must always be here, even if it is autogenerated.
     *
     * @generated from protobuf field: string unique_name = 1;
     */
    uniqueName: string;
    /**
     * (Required) The id of the Coder for this PCollection.
     *
     * @generated from protobuf field: string coder_id = 2;
     */
    coderId: string;
    /**
     * (Required) Whether this PCollection is bounded or unbounded
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.IsBounded.Enum is_bounded = 3;
     */
    isBounded: IsBounded_Enum;
    /**
     * (Required) The id of the windowing strategy for this PCollection.
     *
     * @generated from protobuf field: string windowing_strategy_id = 4;
     */
    windowingStrategyId: string;
    /**
     * (Optional) Static display data for the PCollection. If there is none,
     * it may be omitted.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.DisplayData display_data = 5;
     */
    displayData: DisplayData[];
}
/**
 * The payload for the primitive ParDo transform.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.ParDoPayload
 */
export interface ParDoPayload {
    /**
     * (Required) The FunctionSpec of the DoFn.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FunctionSpec do_fn = 1;
     */
    doFn?: FunctionSpec;
    /**
     * (Optional) A mapping of local input names to side inputs, describing
     * the expected access pattern.
     *
     * @generated from protobuf field: map<string, org.apache.beam.model.pipeline.v1.SideInput> side_inputs = 3;
     */
    sideInputs: {
        [key: string]: SideInput;
    };
    /**
     * (Optional) A mapping of local state names to state specifications.
     * If this is set, the stateful processing requirement should also
     * be placed in the pipeline requirements.
     *
     * @generated from protobuf field: map<string, org.apache.beam.model.pipeline.v1.StateSpec> state_specs = 4;
     */
    stateSpecs: {
        [key: string]: StateSpec;
    };
    /**
     * (Optional) A mapping of local timer family names to timer family
     * specifications. If this is set, the stateful processing requirement should
     * also be placed in the pipeline requirements.
     *
     * @generated from protobuf field: map<string, org.apache.beam.model.pipeline.v1.TimerFamilySpec> timer_family_specs = 9;
     */
    timerFamilySpecs: {
        [key: string]: TimerFamilySpec;
    };
    /**
     * (Optional) Only set when this ParDo contains a splittable DoFn.
     * If this is set, the corresponding standard requirement should also
     * be placed in the pipeline requirements.
     *
     * @generated from protobuf field: string restriction_coder_id = 7;
     */
    restrictionCoderId: string;
    /**
     * (Optional) Only set when this ParDo can request bundle finalization.
     * If this is set, the corresponding standard requirement should also
     * be placed in the pipeline requirements.
     *
     * @generated from protobuf field: bool requests_finalization = 8;
     */
    requestsFinalization: boolean;
    /**
     * Whether this stage requires time sorted input.
     * If this is set, the corresponding standard requirement should also
     * be placed in the pipeline requirements.
     *
     * @generated from protobuf field: bool requires_time_sorted_input = 10;
     */
    requiresTimeSortedInput: boolean;
    /**
     * Whether this stage requires stable input.
     * If this is set, the corresponding standard requirement should also
     * be placed in the pipeline requirements.
     *
     * @generated from protobuf field: bool requires_stable_input = 11;
     */
    requiresStableInput: boolean;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.StateSpec
 */
export interface StateSpec {
    /**
     * @generated from protobuf oneof: spec
     */
    spec: {
        oneofKind: "readModifyWriteSpec";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.ReadModifyWriteStateSpec read_modify_write_spec = 1;
         */
        readModifyWriteSpec: ReadModifyWriteStateSpec;
    } | {
        oneofKind: "bagSpec";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.BagStateSpec bag_spec = 2;
         */
        bagSpec: BagStateSpec;
    } | {
        oneofKind: "combiningSpec";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.CombiningStateSpec combining_spec = 3;
         */
        combiningSpec: CombiningStateSpec;
    } | {
        oneofKind: "mapSpec";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.MapStateSpec map_spec = 4;
         */
        mapSpec: MapStateSpec;
    } | {
        oneofKind: "setSpec";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.SetStateSpec set_spec = 5;
         */
        setSpec: SetStateSpec;
    } | {
        oneofKind: "orderedListSpec";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.OrderedListStateSpec ordered_list_spec = 6;
         */
        orderedListSpec: OrderedListStateSpec;
    } | {
        oneofKind: undefined;
    };
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.ReadModifyWriteStateSpec
 */
export interface ReadModifyWriteStateSpec {
    /**
     * @generated from protobuf field: string coder_id = 1;
     */
    coderId: string;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.BagStateSpec
 */
export interface BagStateSpec {
    /**
     * @generated from protobuf field: string element_coder_id = 1;
     */
    elementCoderId: string;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.OrderedListStateSpec
 */
export interface OrderedListStateSpec {
    /**
     * @generated from protobuf field: string element_coder_id = 1;
     */
    elementCoderId: string;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.CombiningStateSpec
 */
export interface CombiningStateSpec {
    /**
     * @generated from protobuf field: string accumulator_coder_id = 1;
     */
    accumulatorCoderId: string;
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FunctionSpec combine_fn = 2;
     */
    combineFn?: FunctionSpec;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.MapStateSpec
 */
export interface MapStateSpec {
    /**
     * @generated from protobuf field: string key_coder_id = 1;
     */
    keyCoderId: string;
    /**
     * @generated from protobuf field: string value_coder_id = 2;
     */
    valueCoderId: string;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.SetStateSpec
 */
export interface SetStateSpec {
    /**
     * @generated from protobuf field: string element_coder_id = 1;
     */
    elementCoderId: string;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.TimerFamilySpec
 */
export interface TimerFamilySpec {
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.TimeDomain.Enum time_domain = 1;
     */
    timeDomain: TimeDomain_Enum;
    /**
     * @generated from protobuf field: string timer_family_coder_id = 2;
     */
    timerFamilyCoderId: string;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.IsBounded
 */
export interface IsBounded {
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.IsBounded.Enum
 */
export enum IsBounded_Enum {
    /**
     * @generated from protobuf enum value: UNSPECIFIED = 0;
     */
    UNSPECIFIED = 0,
    /**
     * @generated from protobuf enum value: UNBOUNDED = 1;
     */
    UNBOUNDED = 1,
    /**
     * @generated from protobuf enum value: BOUNDED = 2;
     */
    BOUNDED = 2
}
/**
 * The payload for the primitive Read transform.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.ReadPayload
 */
export interface ReadPayload {
    /**
     * (Required) The FunctionSpec of the source for this Read.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FunctionSpec source = 1;
     */
    source?: FunctionSpec;
    /**
     * (Required) Whether the source is bounded or unbounded
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.IsBounded.Enum is_bounded = 2;
     */
    isBounded: IsBounded_Enum;
}
/**
 * The payload for the WindowInto transform.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.WindowIntoPayload
 */
export interface WindowIntoPayload {
    /**
     * (Required) The FunctionSpec of the WindowFn.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FunctionSpec window_fn = 1;
     */
    windowFn?: FunctionSpec;
}
/**
 * The payload for the special-but-not-primitive Combine transform.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.CombinePayload
 */
export interface CombinePayload {
    /**
     * (Required) The FunctionSpec of the CombineFn.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FunctionSpec combine_fn = 1;
     */
    combineFn?: FunctionSpec;
    /**
     * (Required) A reference to the Coder to use for accumulators of the CombineFn
     *
     * @generated from protobuf field: string accumulator_coder_id = 2;
     */
    accumulatorCoderId: string;
}
/**
 * The payload for the test-only primitive TestStream
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.TestStreamPayload
 */
export interface TestStreamPayload {
    /**
     * (Required) the coder for elements in the TestStream events
     *
     * @generated from protobuf field: string coder_id = 1;
     */
    coderId: string;
    /**
     * (Optional) If specified, the TestStream will replay these events.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.TestStreamPayload.Event events = 2;
     */
    events: TestStreamPayload_Event[];
    /**
     * (Optional) If specified, points to a TestStreamService to be
     * used to retrieve events.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.ApiServiceDescriptor endpoint = 3;
     */
    endpoint?: ApiServiceDescriptor;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.TestStreamPayload.Event
 */
export interface TestStreamPayload_Event {
    /**
     * @generated from protobuf oneof: event
     */
    event: {
        oneofKind: "watermarkEvent";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceWatermark watermark_event = 1;
         */
        watermarkEvent: TestStreamPayload_Event_AdvanceWatermark;
    } | {
        oneofKind: "processingTimeEvent";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceProcessingTime processing_time_event = 2;
         */
        processingTimeEvent: TestStreamPayload_Event_AdvanceProcessingTime;
    } | {
        oneofKind: "elementEvent";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AddElements element_event = 3;
         */
        elementEvent: TestStreamPayload_Event_AddElements;
    } | {
        oneofKind: undefined;
    };
}
/**
 * Advances the watermark to the specified timestamp.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceWatermark
 */
export interface TestStreamPayload_Event_AdvanceWatermark {
    /**
     * (Required) The watermark in millisecond to advance to.
     *
     * @generated from protobuf field: int64 new_watermark = 1;
     */
    newWatermark: bigint;
    /**
     * (Optional) The output watermark tag for a PCollection. If unspecified
     * or with an empty string, this will default to the Main PCollection
     * Output
     *
     * @generated from protobuf field: string tag = 2;
     */
    tag: string;
}
/**
 * Advances the processing time clock by the specified amount.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceProcessingTime
 */
export interface TestStreamPayload_Event_AdvanceProcessingTime {
    /**
     * (Required) The duration in millisecond to advance by.
     *
     * @generated from protobuf field: int64 advance_duration = 1;
     */
    advanceDuration: bigint;
}
/**
 * Adds elements to the stream to be emitted.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AddElements
 */
export interface TestStreamPayload_Event_AddElements {
    /**
     * (Required) The elements to add to the TestStream.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.TestStreamPayload.TimestampedElement elements = 1;
     */
    elements: TestStreamPayload_TimestampedElement[];
    /**
     * (Optional) The output PCollection tag to add these elements to. If
     * unspecified or with an empty string, this will default to the Main
     * PCollection Output.
     *
     * @generated from protobuf field: string tag = 3;
     */
    tag: string;
}
/**
 * A single element inside of the TestStream.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.TestStreamPayload.TimestampedElement
 */
export interface TestStreamPayload_TimestampedElement {
    /**
     * (Required) The element encoded. Currently the TestStream only supports
     * encoding primitives.
     *
     * @generated from protobuf field: bytes encoded_element = 1;
     */
    encodedElement: Uint8Array;
    /**
     * (Required) The event timestamp in millisecond of this element.
     *
     * @generated from protobuf field: int64 timestamp = 2;
     */
    timestamp: bigint;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.EventsRequest
 */
export interface EventsRequest {
    /**
     * The set of PCollections to read from. These are the PTransform outputs
     * local names. These are a subset of the TestStream's outputs. This allows
     * Interactive Beam to cache many PCollections from a pipeline then replay a
     * subset of them.
     *
     * @generated from protobuf field: repeated string output_ids = 1;
     */
    outputIds: string[];
}
/**
 * The payload for the special-but-not-primitive WriteFiles transform.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.WriteFilesPayload
 */
export interface WriteFilesPayload {
    /**
     * (Required) The FunctionSpec of the FileBasedSink.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FunctionSpec sink = 1;
     */
    sink?: FunctionSpec;
    /**
     * (Required) The format function.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FunctionSpec format_function = 2;
     */
    formatFunction?: FunctionSpec;
    /**
     * @generated from protobuf field: bool windowed_writes = 3;
     */
    windowedWrites: boolean;
    /**
     * @generated from protobuf field: bool runner_determined_sharding = 4;
     */
    runnerDeterminedSharding: boolean;
    /**
     * @generated from protobuf field: map<string, org.apache.beam.model.pipeline.v1.SideInput> side_inputs = 5;
     */
    sideInputs: {
        [key: string]: SideInput;
    };
}
/**
 * Payload used by Google Cloud Pub/Sub read transform.
 * This can be used by runners that wish to override Beam Pub/Sub read transform
 * with a native implementation.
 * The SDK should guarantee that only one of topic, subscription,
 * topic_runtime_overridden and subscription_runtime_overridden is set.
 * The output of PubSubReadPayload should be bytes of serialized PubsubMessage
 * proto if with_attributes == true. Otherwise, the bytes is the raw payload.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.PubSubReadPayload
 */
export interface PubSubReadPayload {
    /**
     * Topic to read from. Exactly one of topic or subscription should be set.
     * Topic format is: /topics/project_id/subscription_name
     *
     * @generated from protobuf field: string topic = 1;
     */
    topic: string;
    /**
     * Subscription to read from. Exactly one of topic or subscription should be set.
     * Subscription format is: /subscriptions/project_id/subscription_name
     *
     * @generated from protobuf field: string subscription = 2;
     */
    subscription: string;
    /**
     * Attribute that provides element timestamps.
     *
     * @generated from protobuf field: string timestamp_attribute = 3;
     */
    timestampAttribute: string;
    /**
     * Attribute to be used for uniquely identifying messages.
     *
     * @generated from protobuf field: string id_attribute = 4;
     */
    idAttribute: string;
    /**
     * If true, reads Pub/Sub payload as well as attributes. If false, reads only the payload.
     *
     * @generated from protobuf field: bool with_attributes = 5;
     */
    withAttributes: boolean;
    /**
     * If set, the topic is expected to be provided during runtime.
     *
     * @generated from protobuf field: string topic_runtime_overridden = 6;
     */
    topicRuntimeOverridden: string;
    /**
     * If set, the subscription that is expected to be provided during runtime.
     *
     * @generated from protobuf field: string subscription_runtime_overridden = 7;
     */
    subscriptionRuntimeOverridden: string;
}
/**
 * Payload used by Google Cloud Pub/Sub write transform.
 * This can be used by runners that wish to override Beam Pub/Sub write transform
 * with a native implementation.
 * The SDK should guarantee that only one of topic and topic_runtime_overridden
 * is set.
 * The output of PubSubWritePayload should be bytes if serialized PubsubMessage
 * proto.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.PubSubWritePayload
 */
export interface PubSubWritePayload {
    /**
     * Topic to write to.
     * Topic format is: /topics/project_id/subscription_name
     *
     * @generated from protobuf field: string topic = 1;
     */
    topic: string;
    /**
     * Attribute that provides element timestamps.
     *
     * @generated from protobuf field: string timestamp_attribute = 2;
     */
    timestampAttribute: string;
    /**
     * Attribute that uniquely identify messages.
     *
     * @generated from protobuf field: string id_attribute = 3;
     */
    idAttribute: string;
    /**
     * If set, the topic is expected to be provided during runtime.
     *
     * @generated from protobuf field: string topic_runtime_overridden = 4;
     */
    topicRuntimeOverridden: string;
}
/**
 * Payload for GroupIntoBatches composite transform.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.GroupIntoBatchesPayload
 */
export interface GroupIntoBatchesPayload {
    /**
     * Max size of a batch.
     *
     * @generated from protobuf field: int64 batch_size = 1;
     */
    batchSize: bigint;
    /**
     * Max byte size of a batch in element.
     *
     * @generated from protobuf field: int64 batch_size_bytes = 3;
     */
    batchSizeBytes: bigint;
    /**
     * (Optional) Max duration a batch is allowed to be cached in states.
     *
     * @generated from protobuf field: int64 max_buffering_duration_millis = 2;
     */
    maxBufferingDurationMillis: bigint;
}
/**
 * A coder, the binary format for serialization and deserialization of data in
 * a pipeline.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Coder
 */
export interface Coder {
    /**
     * (Required) A specification for the coder, as a URN plus parameters. This
     * may be a cross-language agreed-upon format, or it may be a "custom coder"
     * that can only be used by a particular SDK. It does not include component
     * coders, as it is beneficial for these to be comprehensible to a runner
     * regardless of whether the binary format is agreed-upon.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FunctionSpec spec = 1;
     */
    spec?: FunctionSpec;
    /**
     * (Optional) If this coder is parametric, such as ListCoder(VarIntCoder),
     * this is a list of the components. In order for encodings to be identical,
     * the FunctionSpec and all components must be identical, recursively.
     *
     * @generated from protobuf field: repeated string component_coder_ids = 2;
     */
    componentCoderIds: string[];
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.StandardCoders
 */
export interface StandardCoders {
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.StandardCoders.Enum
 */
export enum StandardCoders_Enum {
    /**
     * Components: None
     *
     * @generated from protobuf enum value: BYTES = 0;
     */
    BYTES = 0,
    /**
     * Components: None
     *
     * @generated from protobuf enum value: STRING_UTF8 = 10;
     */
    STRING_UTF8 = 10,
    /**
     * Components: The key and value coder, in that order.
     *
     * @generated from protobuf enum value: KV = 1;
     */
    KV = 1,
    /**
     * Components: None
     *
     * @generated from protobuf enum value: BOOL = 12;
     */
    BOOL = 12,
    /**
     * Variable length Encodes a 64-bit integer.
     * Components: None
     *
     * @generated from protobuf enum value: VARINT = 2;
     */
    VARINT = 2,
    /**
     * Encodes the floating point value as a big-endian 64-bit integer
     * according to the IEEE 754 double format bit layout.
     * Components: None
     *
     * @generated from protobuf enum value: DOUBLE = 11;
     */
    DOUBLE = 11,
    /**
     * Encodes an iterable of elements.
     *
     * The encoding for an iterable [e1...eN] of known length N is
     *
     *    fixed32(N)
     *    encode(e1) encode(e2) encode(e3) ... encode(eN)
     *
     * If the length is unknown, it is batched up into groups of size b1..bM
     * and encoded as
     *
     *     fixed32(-1)
     *     varInt64(b1) encode(e1) encode(e2) ... encode(e_b1)
     *     varInt64(b2) encode(e_(b1+1)) encode(e_(b1+2)) ... encode(e_(b1+b2))
     *     ...
     *     varInt64(bM) encode(e_(N-bM+1)) encode(e_(N-bM+2)) ... encode(eN)
     *     varInt64(0)
     *
     * Components: Coder for a single element.
     *
     * @generated from protobuf enum value: ITERABLE = 3;
     */
    ITERABLE = 3,
    /**
     * Encodes a timer containing a user key, a dynamic timer tag, a clear bit,
     * a fire timestamp, a hold timestamp, the windows and the paneinfo.
     * The encoding is represented as:
     *   user key - user defined key, uses the component coder.
     *   dynamic timer tag - a string which identifies a timer.
     *   windows - uses component coders.
     *   clear bit - a boolean set for clearing the timer.
     *   fire timestamp - a big endian 8 byte integer representing millis-since-epoch.
     *     The encoded representation is shifted so that the byte representation of
     *     negative values are lexicographically ordered before the byte representation
     *     of positive values. This is typically done by subtracting -9223372036854775808
     *     from the value and encoding it as a signed big endian integer. Example values:
     *
     *     -9223372036854775808: 00 00 00 00 00 00 00 00
     *                     -255: 7F FF FF FF FF FF FF 01
     *                       -1: 7F FF FF FF FF FF FF FF
     *                        0: 80 00 00 00 00 00 00 00
     *                        1: 80 00 00 00 00 00 00 01
     *                      256: 80 00 00 00 00 00 01 00
     *      9223372036854775807: FF FF FF FF FF FF FF FF
     *   hold timestamp - similar to the fire timestamp.
     *   paneinfo - similar to the paneinfo of the windowed_value.
     * Components: Coder for the key and windows.
     *
     * @generated from protobuf enum value: TIMER = 4;
     */
    TIMER = 4,
    /**
     * Components: None
     *
     * @generated from protobuf enum value: INTERVAL_WINDOW = 5;
     */
    INTERVAL_WINDOW = 5,
    /**
     * Components: The coder to attach a length prefix to
     *
     * @generated from protobuf enum value: LENGTH_PREFIX = 6;
     */
    LENGTH_PREFIX = 6,
    /**
     * Components: None
     *
     * @generated from protobuf enum value: GLOBAL_WINDOW = 7;
     */
    GLOBAL_WINDOW = 7,
    /**
     * Encodes an element, the windows it is in, the timestamp of the element,
     * and the pane of the element. The encoding is represented as:
     * timestamp windows pane element
     *   timestamp - A big endian 8 byte integer representing millis-since-epoch.
     *     The encoded representation is shifted so that the byte representation
     *     of negative values are lexicographically ordered before the byte
     *     representation of positive values. This is typically done by
     *     subtracting -9223372036854775808 from the value and encoding it as a
     *     signed big endian integer. Example values:
     *
     *     -9223372036854775808: 00 00 00 00 00 00 00 00
     *                     -255: 7F FF FF FF FF FF FF 01
     *                       -1: 7F FF FF FF FF FF FF FF
     *                        0: 80 00 00 00 00 00 00 00
     *                        1: 80 00 00 00 00 00 00 01
     *                      256: 80 00 00 00 00 00 01 00
     *      9223372036854775807: FF FF FF FF FF FF FF FF
     *
     *   windows - The windows are encoded using the beam:coder:iterable:v1
     *     format, where the windows are encoded using the supplied window
     *     coder.
     *
     *   pane - The first byte of the pane info determines which type of
     *     encoding is used, as well as the is_first, is_last, and timing
     *     fields. If this byte is bits [0 1 2 3 4 5 6 7], then:
     *     * bits [0 1 2 3] determine the encoding as follows:
     *         0000 - The entire pane info is encoded as a single byte.
     *                The is_first, is_last, and timing fields are encoded
     *                as below, and the index and non-speculative index are
     *                both zero (and hence are not encoded here).
     *         0001 - The pane info is encoded as this byte plus a single
     *                VarInt encoed integer representing the pane index. The
     *                non-speculative index can be derived as follows:
     *                  -1 if the pane is early, otherwise equal to index.
     *         0010 - The pane info is encoded as this byte plus two VarInt
     *                encoded integers representing the pane index and
     *                non-speculative index respectively.
     *     * bits [4 5] encode the timing as follows:
     *         00 - early
     *         01 - on time
     *         10 - late
     *         11 - unknown
     *     * bit 6 is 1 if this is the first pane, 0 otherwise.
     *     * bit 7 is 1 if this is the last pane, 0 otherwise.
     *
     *   element - The element incoded using the supplied element coder.
     *
     * Components: The element coder and the window coder, in that order.
     *
     * @generated from protobuf enum value: WINDOWED_VALUE = 8;
     */
    WINDOWED_VALUE = 8,
    /**
     * A windowed value coder with parameterized timestamp, windows and pane info.
     * Encodes an element with only the value of the windowed value.
     * Decodes the value and assigns the parameterized timestamp, windows and pane info to the
     * windowed value.
     * Components: The element coder and the window coder, in that order
     * The payload of this coder is an encoded windowed value using the
     * beam:coder:windowed_value:v1 coder parameterized by a beam:coder:bytes:v1
     * element coder and the window coder that this param_windowed_value coder uses.
     *
     * @generated from protobuf enum value: PARAM_WINDOWED_VALUE = 14;
     */
    PARAM_WINDOWED_VALUE = 14,
    /**
     * Encodes an iterable of elements, some of which may be stored elsewhere.
     *
     * The encoding for a state-backed iterable is the same as that for
     * an iterable, but the final varInt64(0) terminating the set of batches
     * may instead be replaced by
     *
     *     varInt64(-1)
     *     varInt64(len(token))
     *     token
     *
     * where token is an opaque byte string that can be used to fetch the
     * remainder of the iterable (e.g. over the state API).
     *
     * Components: Coder for a single element.
     * Experimental.
     *
     * @generated from protobuf enum value: STATE_BACKED_ITERABLE = 9;
     */
    STATE_BACKED_ITERABLE = 9,
    /**
     * Encodes an arbitrary user defined window and its max timestamp (inclusive).
     * The encoding format is:
     *   maxTimestamp window
     *
     *   maxTimestamp - A big endian 8 byte integer representing millis-since-epoch.
     *     The encoded representation is shifted so that the byte representation
     *     of negative values are lexicographically ordered before the byte
     *     representation of positive values. This is typically done by
     *     subtracting -9223372036854775808 from the value and encoding it as a
     *     signed big endian integer. Example values:
     *
     *     -9223372036854775808: 00 00 00 00 00 00 00 00
     *                     -255: 7F FF FF FF FF FF FF 01
     *                       -1: 7F FF FF FF FF FF FF FF
     *                        0: 80 00 00 00 00 00 00 00
     *                        1: 80 00 00 00 00 00 00 01
     *                      256: 80 00 00 00 00 00 01 00
     *      9223372036854775807: FF FF FF FF FF FF FF FF
     *
     *   window - the window is encoded using the supplied window coder.
     *
     * Components: Coder for the custom window type.
     *
     * @generated from protobuf enum value: CUSTOM_WINDOW = 16;
     */
    CUSTOM_WINDOW = 16,
    /**
     * Encodes a "row", an element with a known schema, defined by an
     * instance of Schema from schema.proto.
     *
     * A row is encoded as the concatenation of:
     *   - The number of attributes in the schema, encoded with
     *     beam:coder:varint:v1. This makes it possible to detect certain
     *     allowed schema changes (appending or removing columns) in
     *     long-running streaming pipelines.
     *   - A byte array representing a packed bitset indicating null fields (a
     *     1 indicating a null) encoded with beam:coder:bytes:v1. The unused
     *     bits in the last byte must be set to 0. If there are no nulls an
     *     empty byte array is encoded.
     *     The two-byte bitset (not including the lenghth-prefix) for the row
     *     [NULL, 0, 0, 0, NULL, 0, 0, NULL, 0, NULL] would be
     *     [0b10010001, 0b00000010]
     *   - An encoding for each non-null field, concatenated together.
     *
     * Schema types are mapped to coders as follows:
     *   AtomicType:
     *     BYTE:      not yet a standard coder (BEAM-7996)
     *     INT16:     not yet a standard coder (BEAM-7996)
     *     INT32:     beam:coder:varint:v1
     *     INT64:     beam:coder:varint:v1
     *     FLOAT:     not yet a standard coder (BEAM-7996)
     *     DOUBLE:    beam:coder:double:v1
     *     STRING:    beam:coder:string_utf8:v1
     *     BOOLEAN:   beam:coder:bool:v1
     *     BYTES:     beam:coder:bytes:v1
     *   ArrayType:   beam:coder:iterable:v1 (always has a known length)
     *   MapType:     not a standard coder, specification defined below.
     *   RowType:     beam:coder:row:v1
     *   LogicalType: Uses the coder for its representation.
     *
     * The MapType is encoded by:
     *   - An INT32 representing the size of the map (N)
     *   - Followed by N interleaved keys and values, encoded with their
     *     corresponding coder.
     *
     * Nullable types in container types (ArrayType, MapType) are encoded by:
     *   - A one byte null indicator, 0x00 for null values, or 0x01 for present
     *     values.
     *   - For present values the null indicator is followed by the value
     *     encoded with it's corresponding coder.
     *
     * Well known logical types:
     *   beam:logical_type:micros_instant:v1
     *   - Representation type: ROW<seconds: INT64, micros: INT64>
     *   - A timestamp without a timezone where seconds + micros represents the
     *     amount of time since the epoch.
     *
     * The payload for RowCoder is an instance of Schema.
     * Components: None
     * Experimental.
     *
     * @generated from protobuf enum value: ROW = 13;
     */
    ROW = 13,
    /**
     * Encodes a user key and a shard id which is an opaque byte string.
     *
     * The encoding for a sharded key consists of a shard id byte string and the
     * encoded user key in the following order:
     *
     *     - shard id using beam:coder:bytes:v1
     *     - encoded user key
     *
     * Examples:
     * user key with an empty shard id
     *     0x00
     *     encode(user_key)
     *
     * user key with a shard id taking up two bytes.
     *     0x02
     *     0x11 0x22
     *     encode(user_key)
     *
     * Components: the user key coder.
     * Experimental.
     *
     * @generated from protobuf enum value: SHARDED_KEY = 15;
     */
    SHARDED_KEY = 15
}
/**
 * A windowing strategy describes the window function, triggering, allowed
 * lateness, and accumulation mode for a PCollection.
 *
 * TODO: consider inlining field on PCollection
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.WindowingStrategy
 */
export interface WindowingStrategy {
    /**
     * (Required) The FunctionSpec of the UDF that assigns windows,
     * merges windows, and shifts timestamps before they are
     * combined according to the OutputTime.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FunctionSpec window_fn = 1;
     */
    windowFn?: FunctionSpec;
    /**
     * (Required) Whether or not the window fn is merging.
     *
     * This knowledge is required for many optimizations.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.MergeStatus.Enum merge_status = 2;
     */
    mergeStatus: MergeStatus_Enum;
    /**
     * (Required) The coder for the windows of this PCollection.
     *
     * @generated from protobuf field: string window_coder_id = 3;
     */
    windowCoderId: string;
    /**
     * (Required) The trigger to use when grouping this PCollection.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Trigger trigger = 4;
     */
    trigger?: Trigger;
    /**
     * (Required) The accumulation mode indicates whether new panes are a full
     * replacement for prior panes or whether they are deltas to be combined
     * with other panes (the combine should correspond to whatever the upstream
     * grouping transform is).
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.AccumulationMode.Enum accumulation_mode = 5;
     */
    accumulationMode: AccumulationMode_Enum;
    /**
     * (Required) The OutputTime specifies, for a grouping transform, how to
     * compute the aggregate timestamp. The window_fn will first possibly shift
     * it later, then the OutputTime takes the max, min, or ignores it and takes
     * the end of window.
     *
     * This is actually only for input to grouping transforms, but since they
     * may be introduced in runner-specific ways, it is carried along with the
     * windowing strategy.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.OutputTime.Enum output_time = 6;
     */
    outputTime: OutputTime_Enum;
    /**
     * (Required) Indicate when output should be omitted upon window expiration.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.ClosingBehavior.Enum closing_behavior = 7;
     */
    closingBehavior: ClosingBehavior_Enum;
    /**
     * (Required) The duration, in milliseconds, beyond the end of a window at
     * which the window becomes droppable.
     *
     * @generated from protobuf field: int64 allowed_lateness = 8;
     */
    allowedLateness: bigint;
    /**
     * (Required) Indicate whether empty on-time panes should be omitted.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.OnTimeBehavior.Enum on_time_behavior = 9;
     */
    onTimeBehavior: OnTimeBehavior_Enum;
    /**
     * (Required) Whether or not the window fn assigns inputs to exactly one window
     *
     * This knowledge is required for some optimizations
     *
     * @generated from protobuf field: bool assigns_to_one_window = 10;
     */
    assignsToOneWindow: boolean;
    /**
     * (Optional) Environment where the current window_fn should be applied in.
     * Runner that executes the pipeline may choose to override this if needed.
     * If not specified, environment will be decided by the runner.
     *
     * @generated from protobuf field: string environment_id = 11;
     */
    environmentId: string;
}
/**
 * Whether or not a PCollection's WindowFn is non-merging, merging, or
 * merging-but-already-merged, in which case a subsequent GroupByKey is almost
 * always going to do something the user does not want
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.MergeStatus
 */
export interface MergeStatus {
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.MergeStatus.Enum
 */
export enum MergeStatus_Enum {
    /**
     * @generated from protobuf enum value: UNSPECIFIED = 0;
     */
    UNSPECIFIED = 0,
    /**
     * The WindowFn does not require merging.
     * Examples: global window, FixedWindows, SlidingWindows
     *
     * @generated from protobuf enum value: NON_MERGING = 1;
     */
    NON_MERGING = 1,
    /**
     * The WindowFn is merging and the PCollection has not had merging
     * performed.
     * Example: Sessions prior to a GroupByKey
     *
     * @generated from protobuf enum value: NEEDS_MERGE = 2;
     */
    NEEDS_MERGE = 2,
    /**
     * The WindowFn is merging and the PCollection has had merging occur
     * already.
     * Example: Sessions after a GroupByKey
     *
     * @generated from protobuf enum value: ALREADY_MERGED = 3;
     */
    ALREADY_MERGED = 3
}
/**
 * Whether or not subsequent outputs of aggregations should be entire
 * replacement values or just the aggregation of inputs received since
 * the prior output.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.AccumulationMode
 */
export interface AccumulationMode {
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.AccumulationMode.Enum
 */
export enum AccumulationMode_Enum {
    /**
     * @generated from protobuf enum value: UNSPECIFIED = 0;
     */
    UNSPECIFIED = 0,
    /**
     * The aggregation is discarded when it is output
     *
     * @generated from protobuf enum value: DISCARDING = 1;
     */
    DISCARDING = 1,
    /**
     * The aggregation is accumulated across outputs
     *
     * @generated from protobuf enum value: ACCUMULATING = 2;
     */
    ACCUMULATING = 2,
    /**
     * The aggregation emits retractions when it is output
     *
     * @generated from protobuf enum value: RETRACTING = 3;
     */
    RETRACTING = 3
}
/**
 * Controls whether or not an aggregating transform should output data
 * when a window expires.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.ClosingBehavior
 */
export interface ClosingBehavior {
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.ClosingBehavior.Enum
 */
export enum ClosingBehavior_Enum {
    /**
     * @generated from protobuf enum value: UNSPECIFIED = 0;
     */
    UNSPECIFIED = 0,
    /**
     * Emit output when a window expires, whether or not there has been
     * any new data since the last output.
     *
     * @generated from protobuf enum value: EMIT_ALWAYS = 1;
     */
    EMIT_ALWAYS = 1,
    /**
     * Only emit output when new data has arrives since the last output
     *
     * @generated from protobuf enum value: EMIT_IF_NONEMPTY = 2;
     */
    EMIT_IF_NONEMPTY = 2
}
/**
 * Controls whether or not an aggregating transform should output data
 * when an on-time pane is empty.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.OnTimeBehavior
 */
export interface OnTimeBehavior {
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.OnTimeBehavior.Enum
 */
export enum OnTimeBehavior_Enum {
    /**
     * @generated from protobuf enum value: UNSPECIFIED = 0;
     */
    UNSPECIFIED = 0,
    /**
     * Always fire the on-time pane. Even if there is no new data since
     * the previous firing, an element will be produced.
     *
     * @generated from protobuf enum value: FIRE_ALWAYS = 1;
     */
    FIRE_ALWAYS = 1,
    /**
     * Only fire the on-time pane if there is new data since the previous firing.
     *
     * @generated from protobuf enum value: FIRE_IF_NONEMPTY = 2;
     */
    FIRE_IF_NONEMPTY = 2
}
/**
 * When a number of windowed, timestamped inputs are aggregated, the timestamp
 * for the resulting output.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.OutputTime
 */
export interface OutputTime {
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.OutputTime.Enum
 */
export enum OutputTime_Enum {
    /**
     * @generated from protobuf enum value: UNSPECIFIED = 0;
     */
    UNSPECIFIED = 0,
    /**
     * The output has the timestamp of the end of the window.
     *
     * @generated from protobuf enum value: END_OF_WINDOW = 1;
     */
    END_OF_WINDOW = 1,
    /**
     * The output has the latest timestamp of the input elements since
     * the last output.
     *
     * @generated from protobuf enum value: LATEST_IN_PANE = 2;
     */
    LATEST_IN_PANE = 2,
    /**
     * The output has the earliest timestamp of the input elements since
     * the last output.
     *
     * @generated from protobuf enum value: EARLIEST_IN_PANE = 3;
     */
    EARLIEST_IN_PANE = 3
}
/**
 * The different time domains in the Beam model.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.TimeDomain
 */
export interface TimeDomain {
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.TimeDomain.Enum
 */
export enum TimeDomain_Enum {
    /**
     * @generated from protobuf enum value: UNSPECIFIED = 0;
     */
    UNSPECIFIED = 0,
    /**
     * Event time is time from the perspective of the data
     *
     * @generated from protobuf enum value: EVENT_TIME = 1;
     */
    EVENT_TIME = 1,
    /**
     * Processing time is time from the perspective of the
     * execution of your pipeline
     *
     * @generated from protobuf enum value: PROCESSING_TIME = 2;
     */
    PROCESSING_TIME = 2
}
/**
 * A small DSL for expressing when to emit new aggregations
 * from a GroupByKey or CombinePerKey
 *
 * A trigger is described in terms of when it is _ready_ to permit output.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Trigger
 */
export interface Trigger {
    /**
     * @generated from protobuf oneof: trigger
     */
    trigger: {
        oneofKind: "afterAll";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Trigger.AfterAll after_all = 1;
         */
        afterAll: Trigger_AfterAll;
    } | {
        oneofKind: "afterAny";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Trigger.AfterAny after_any = 2;
         */
        afterAny: Trigger_AfterAny;
    } | {
        oneofKind: "afterEach";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Trigger.AfterEach after_each = 3;
         */
        afterEach: Trigger_AfterEach;
    } | {
        oneofKind: "afterEndOfWindow";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Trigger.AfterEndOfWindow after_end_of_window = 4;
         */
        afterEndOfWindow: Trigger_AfterEndOfWindow;
    } | {
        oneofKind: "afterProcessingTime";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Trigger.AfterProcessingTime after_processing_time = 5;
         */
        afterProcessingTime: Trigger_AfterProcessingTime;
    } | {
        oneofKind: "afterSynchronizedProcessingTime";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Trigger.AfterSynchronizedProcessingTime after_synchronized_processing_time = 6;
         */
        afterSynchronizedProcessingTime: Trigger_AfterSynchronizedProcessingTime;
    } | {
        oneofKind: "always";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Trigger.Always always = 12;
         */
        always: Trigger_Always;
    } | {
        oneofKind: "default";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Trigger.Default default = 7;
         */
        default: Trigger_Default;
    } | {
        oneofKind: "elementCount";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Trigger.ElementCount element_count = 8;
         */
        elementCount: Trigger_ElementCount;
    } | {
        oneofKind: "never";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Trigger.Never never = 9;
         */
        never: Trigger_Never;
    } | {
        oneofKind: "orFinally";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Trigger.OrFinally or_finally = 10;
         */
        orFinally: Trigger_OrFinally;
    } | {
        oneofKind: "repeat";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Trigger.Repeat repeat = 11;
         */
        repeat: Trigger_Repeat;
    } | {
        oneofKind: undefined;
    };
}
/**
 * Ready when all subtriggers are ready.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Trigger.AfterAll
 */
export interface Trigger_AfterAll {
    /**
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.Trigger subtriggers = 1;
     */
    subtriggers: Trigger[];
}
/**
 * Ready when any subtrigger is ready.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Trigger.AfterAny
 */
export interface Trigger_AfterAny {
    /**
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.Trigger subtriggers = 1;
     */
    subtriggers: Trigger[];
}
/**
 * Starting with the first subtrigger, ready when the _current_ subtrigger
 * is ready. After output, advances the current trigger by one.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Trigger.AfterEach
 */
export interface Trigger_AfterEach {
    /**
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.Trigger subtriggers = 1;
     */
    subtriggers: Trigger[];
}
/**
 * Ready after the input watermark is past the end of the window.
 *
 * May have implicitly-repeated subtriggers for early and late firings.
 * When the end of the window is reached, the trigger transitions between
 * the subtriggers.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Trigger.AfterEndOfWindow
 */
export interface Trigger_AfterEndOfWindow {
    /**
     * (Optional) A trigger governing output prior to the end of the window.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Trigger early_firings = 1;
     */
    earlyFirings?: Trigger;
    /**
     * (Optional) A trigger governing output after the end of the window.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Trigger late_firings = 2;
     */
    lateFirings?: Trigger;
}
/**
 * After input arrives, ready when the specified delay has passed.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Trigger.AfterProcessingTime
 */
export interface Trigger_AfterProcessingTime {
    /**
     * (Required) The transforms to apply to an arriving element's timestamp,
     * in order
     *
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.TimestampTransform timestamp_transforms = 1;
     */
    timestampTransforms: TimestampTransform[];
}
/**
 * Ready whenever upstream processing time has all caught up with
 * the arrival time of an input element
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Trigger.AfterSynchronizedProcessingTime
 */
export interface Trigger_AfterSynchronizedProcessingTime {
}
/**
 * The default trigger. Equivalent to Repeat { AfterEndOfWindow } but
 * specially denoted to indicate the user did not alter the triggering.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Trigger.Default
 */
export interface Trigger_Default {
}
/**
 * Ready whenever the requisite number of input elements have arrived
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Trigger.ElementCount
 */
export interface Trigger_ElementCount {
    /**
     * @generated from protobuf field: int32 element_count = 1;
     */
    elementCount: number;
}
/**
 * Never ready. There will only be an ON_TIME output and a final
 * output at window expiration.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Trigger.Never
 */
export interface Trigger_Never {
}
/**
 * Always ready. This can also be expressed as ElementCount(1) but
 * is more explicit.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Trigger.Always
 */
export interface Trigger_Always {
}
/**
 * Ready whenever either of its subtriggers are ready, but finishes output
 * when the finally subtrigger fires.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Trigger.OrFinally
 */
export interface Trigger_OrFinally {
    /**
     * (Required) Trigger governing main output; may fire repeatedly.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Trigger main = 1;
     */
    main?: Trigger;
    /**
     * (Required) Trigger governing termination of output.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Trigger finally = 2;
     */
    finally?: Trigger;
}
/**
 * Ready whenever the subtrigger is ready; resets state when the subtrigger
 * completes.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Trigger.Repeat
 */
export interface Trigger_Repeat {
    /**
     * (Require) Trigger that is run repeatedly.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Trigger subtrigger = 1;
     */
    subtrigger?: Trigger;
}
/**
 * A specification for a transformation on a timestamp.
 *
 * Primarily used by AfterProcessingTime triggers to transform
 * the arrival time of input to a target time for firing.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.TimestampTransform
 */
export interface TimestampTransform {
    /**
     * @generated from protobuf oneof: timestamp_transform
     */
    timestampTransform: {
        oneofKind: "delay";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.TimestampTransform.Delay delay = 1;
         */
        delay: TimestampTransform_Delay;
    } | {
        oneofKind: "alignTo";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.TimestampTransform.AlignTo align_to = 2;
         */
        alignTo: TimestampTransform_AlignTo;
    } | {
        oneofKind: undefined;
    };
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.TimestampTransform.Delay
 */
export interface TimestampTransform_Delay {
    /**
     * (Required) The delay, in milliseconds.
     *
     * @generated from protobuf field: int64 delay_millis = 1;
     */
    delayMillis: bigint;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.TimestampTransform.AlignTo
 */
export interface TimestampTransform_AlignTo {
    /**
     * (Required) A duration to which delays should be quantized
     * in milliseconds.
     *
     * @generated from protobuf field: int64 period = 3;
     */
    period: bigint;
    /**
     * (Required) An offset from 0 for the quantization specified by
     * alignment_size, in milliseconds
     *
     * @generated from protobuf field: int64 offset = 4;
     */
    offset: bigint;
}
/**
 * A specification for how to "side input" a PCollection.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.SideInput
 */
export interface SideInput {
    /**
     * (Required) URN of the access pattern required by the `view_fn` to present
     * the desired SDK-specific interface to a UDF.
     *
     * This access pattern defines the SDK harness <-> Runner Harness RPC
     * interface for accessing a side input.
     *
     * The only access pattern intended for Beam, because of its superior
     * performance possibilities, is "beam:sideinput:multimap" (or some such
     * URN)
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FunctionSpec access_pattern = 1;
     */
    accessPattern?: FunctionSpec;
    /**
     * (Required) The FunctionSpec of the UDF that adapts a particular
     * access_pattern to a user-facing view type.
     *
     * For example, View.asSingleton() may include a `view_fn` that adapts a
     * specially-designed multimap to a single value per window.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FunctionSpec view_fn = 2;
     */
    viewFn?: FunctionSpec;
    /**
     * (Required) The FunctionSpec of the UDF that maps a main input window
     * to a side input window.
     *
     * For example, when the main input is in fixed windows of one hour, this
     * can specify that the side input should be accessed according to the day
     * in which that hour falls.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FunctionSpec window_mapping_fn = 3;
     */
    windowMappingFn?: FunctionSpec;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.StandardArtifacts
 */
export interface StandardArtifacts {
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.StandardArtifacts.Types
 */
export enum StandardArtifacts_Types {
    /**
     * A URN for locally-accessible artifact files.
     * payload: ArtifactFilePayload
     *
     * @generated from protobuf enum value: FILE = 0;
     */
    FILE = 0,
    /**
     * A URN for artifacts described by URLs.
     * payload: ArtifactUrlPayload
     *
     * @generated from protobuf enum value: URL = 1;
     */
    URL = 1,
    /**
     * A URN for artifacts embedded in ArtifactInformation proto.
     * payload: EmbeddedFilePayload.
     *
     * @generated from protobuf enum value: EMBEDDED = 2;
     */
    EMBEDDED = 2,
    /**
     * A URN for Python artifacts hosted on PYPI.
     * payload: PypiPayload
     *
     * @generated from protobuf enum value: PYPI = 3;
     */
    PYPI = 3,
    /**
     * A URN for Java artifacts hosted on a Maven repository.
     * payload: MavenPayload
     *
     * @generated from protobuf enum value: MAVEN = 4;
     */
    MAVEN = 4,
    /**
     * A URN for deferred artifacts.
     * payload: DeferredArtifactPayload
     *
     * @generated from protobuf enum value: DEFERRED = 5;
     */
    DEFERRED = 5
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.StandardArtifacts.Roles
 */
export enum StandardArtifacts_Roles {
    /**
     * A URN for staging-to role.
     * payload: ArtifactStagingToRolePayload
     *
     * @generated from protobuf enum value: STAGING_TO = 0;
     */
    STAGING_TO = 0,
    /**
     * A URN for pip-requirements-file role.
     * payload: None
     *
     * @generated from protobuf enum value: PIP_REQUIREMENTS_FILE = 1;
     */
    PIP_REQUIREMENTS_FILE = 1
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.ArtifactFilePayload
 */
export interface ArtifactFilePayload {
    /**
     * a string for an artifact file path e.g. "/tmp/foo.jar"
     *
     * @generated from protobuf field: string path = 1;
     */
    path: string;
    /**
     * The hex-encoded sha256 checksum of the artifact.
     *
     * @generated from protobuf field: string sha256 = 2;
     */
    sha256: string;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.ArtifactUrlPayload
 */
export interface ArtifactUrlPayload {
    /**
     * a string for an artifact URL e.g. "https://.../foo.jar" or "gs://tmp/foo.jar"
     *
     * @generated from protobuf field: string url = 1;
     */
    url: string;
    /**
     * (Optional) The hex-encoded sha256 checksum of the artifact if available.
     *
     * @generated from protobuf field: string sha256 = 2;
     */
    sha256: string;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.EmbeddedFilePayload
 */
export interface EmbeddedFilePayload {
    /**
     * raw data bytes for an embedded artifact
     *
     * @generated from protobuf field: bytes data = 1;
     */
    data: Uint8Array;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.PyPIPayload
 */
export interface PyPIPayload {
    /**
     * Pypi compatible artifact id e.g. "apache-beam"
     *
     * @generated from protobuf field: string artifact_id = 1;
     */
    artifactId: string;
    /**
     * Pypi compatible version string.
     *
     * @generated from protobuf field: string version = 2;
     */
    version: string;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.MavenPayload
 */
export interface MavenPayload {
    /**
     * A string specifying Maven artifact.
     * The standard format is "groupId:artifactId:version[:packaging[:classifier]]"
     *
     * @generated from protobuf field: string artifact = 1;
     */
    artifact: string;
    /**
     * (Optional) Repository URL. If not specified, Maven central is used by default.
     *
     * @generated from protobuf field: string repository_url = 2;
     */
    repositoryUrl: string;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.DeferredArtifactPayload
 */
export interface DeferredArtifactPayload {
    /**
     * A unique string identifier assigned by the creator of this payload. The creator may use this key to confirm
     * whether they can parse the data.
     *
     * @generated from protobuf field: string key = 1;
     */
    key: string;
    /**
     * Data for deferred artifacts. Interpretation of bytes is delegated to the creator of this payload.
     *
     * @generated from protobuf field: bytes data = 2;
     */
    data: Uint8Array;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.ArtifactStagingToRolePayload
 */
export interface ArtifactStagingToRolePayload {
    /**
     * A generated staged name (relative path under staging directory).
     *
     * @generated from protobuf field: string staged_name = 1;
     */
    stagedName: string;
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.ArtifactInformation
 */
export interface ArtifactInformation {
    /**
     * A URN that describes the type of artifact
     *
     * @generated from protobuf field: string type_urn = 1;
     */
    typeUrn: string;
    /**
     * @generated from protobuf field: bytes type_payload = 2;
     */
    typePayload: Uint8Array;
    /**
     * A URN that describes the role of artifact
     *
     * @generated from protobuf field: string role_urn = 3;
     */
    roleUrn: string;
    /**
     * @generated from protobuf field: bytes role_payload = 4;
     */
    rolePayload: Uint8Array;
}
/**
 * An environment for executing UDFs. By default, an SDK container URL, but
 * can also be a process forked by a command, or an externally managed process.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.Environment
 */
export interface Environment {
    /**
     * (Required) The URN of the payload
     *
     * @generated from protobuf field: string urn = 2;
     */
    urn: string;
    /**
     * (Optional) The data specifying any parameters to the URN. If
     * the URN does not require any arguments, this may be omitted.
     *
     * @generated from protobuf field: bytes payload = 3;
     */
    payload: Uint8Array;
    /**
     * (Optional) Static display data for the environment. If there is none,
     * it may be omitted.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.DisplayData display_data = 4;
     */
    displayData: DisplayData[];
    /**
     * (Optional) A set of capabilities this environment supports. This is
     * typically a list of common URNs designating coders, transforms, etc. that
     * this environment understands (and a runner MAY use) despite not
     * appearing in the pipeline proto. This may also be used to indicate
     * support of optional protocols not tied to a concrete component.
     *
     * @generated from protobuf field: repeated string capabilities = 5;
     */
    capabilities: string[];
    /**
     * (Optional) artifact dependency information used for executing UDFs in this environment.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.ArtifactInformation dependencies = 6;
     */
    dependencies: ArtifactInformation[];
    /**
     * (Optional) A mapping of resource URNs to requested values.  The encoding
     * of the values is specified by the URN.  Resource hints are advisory;
     * a runner is free to ignore resource hints that it does not understand.
     *
     * @generated from protobuf field: map<string, bytes> resource_hints = 7;
     */
    resourceHints: {
        [key: string]: Uint8Array;
    };
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.StandardEnvironments
 */
export interface StandardEnvironments {
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.StandardEnvironments.Environments
 */
export enum StandardEnvironments_Environments {
    /**
     * A managed docker container to run user code.
     *
     * @generated from protobuf enum value: DOCKER = 0;
     */
    DOCKER = 0,
    /**
     * A managed native process to run user code.
     *
     * @generated from protobuf enum value: PROCESS = 1;
     */
    PROCESS = 1,
    /**
     * An external non managed process to run user code.
     *
     * @generated from protobuf enum value: EXTERNAL = 2;
     */
    EXTERNAL = 2,
    /**
     * Used as a stub when context is missing a runner-provided default environment.
     *
     * @generated from protobuf enum value: DEFAULT = 3;
     */
    DEFAULT = 3
}
/**
 * The payload of a Docker image
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.DockerPayload
 */
export interface DockerPayload {
    /**
     * @generated from protobuf field: string container_image = 1;
     */
    containerImage: string; // implicitly linux_amd64.
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.ProcessPayload
 */
export interface ProcessPayload {
    /**
     * @generated from protobuf field: string os = 1;
     */
    os: string; // "linux", "darwin", ..
    /**
     * @generated from protobuf field: string arch = 2;
     */
    arch: string; // "amd64", ..
    /**
     * @generated from protobuf field: string command = 3;
     */
    command: string; // process to execute
    /**
     * @generated from protobuf field: map<string, string> env = 4;
     */
    env: {
        [key: string]: string;
    }; // Environment variables
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.ExternalPayload
 */
export interface ExternalPayload {
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.ApiServiceDescriptor endpoint = 1;
     */
    endpoint?: ApiServiceDescriptor;
    /**
     * @generated from protobuf field: map<string, string> params = 2;
     */
    params: {
        [key: string]: string;
    }; // Arbitrary extra parameters to pass
}
/**
 * These URNs are used to indicate capabilities of environments that cannot
 * simply be expressed as a component (such as a Coder or PTransform) that this
 * environment understands.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.StandardProtocols
 */
export interface StandardProtocols {
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.StandardProtocols.Enum
 */
export enum StandardProtocols_Enum {
    /**
     * Indicates suport for progress reporting via the legacy Metrics proto.
     *
     * @generated from protobuf enum value: LEGACY_PROGRESS_REPORTING = 0;
     */
    LEGACY_PROGRESS_REPORTING = 0,
    /**
     * Indicates suport for progress reporting via the new MonitoringInfo proto.
     *
     * @generated from protobuf enum value: PROGRESS_REPORTING = 1;
     */
    PROGRESS_REPORTING = 1,
    /**
     * Indicates suport for worker status protocol defined at
     * https://s.apache.org/beam-fn-api-harness-status.
     *
     * @generated from protobuf enum value: WORKER_STATUS = 2;
     */
    WORKER_STATUS = 2,
    /**
     * Indicates this SDK can take advantage of multiple cores when processing
     * concurrent process bundle requests. (Note that all SDKs must process
     * an unbounded number of concurrent process bundle requests; this capability
     * simply indicates this SDK can actually parallelize the work across multiple
     * cores.
     *
     * @generated from protobuf enum value: MULTI_CORE_BUNDLE_PROCESSING = 3;
     */
    MULTI_CORE_BUNDLE_PROCESSING = 3,
    /**
     * Indicates this SDK can cheaply spawn sibling workers (e.g. within the
     * same container) to work around the fact that it cannot take advantage
     * of multiple cores (i.e. MULTI_CORE_BUNDLE_PROCESSING is not set).
     *
     * @generated from protobuf enum value: SIBLING_WORKERS = 5;
     */
    SIBLING_WORKERS = 5,
    /**
     * Indicates that this SDK handles the InstructionRequest of type
     * HarnessMonitoringInfosRequest.
     * A request to provide full MonitoringInfo data associated with
     * the entire SDK harness process, not specific to a bundle.
     *
     * @generated from protobuf enum value: HARNESS_MONITORING_INFOS = 4;
     */
    HARNESS_MONITORING_INFOS = 4,
    /**
     * Indicates that this SDK can process elements embedded in the
     * ProcessBundleRequest. See more about the protocol at
     * https://s.apache.org/beam-fn-api-control-data-embedding
     *
     * @generated from protobuf enum value: CONTROL_REQUEST_ELEMENTS_EMBEDDING = 6;
     */
    CONTROL_REQUEST_ELEMENTS_EMBEDDING = 6
}
/**
 * These URNs are used to indicate capabilities of runner that an environment
 * may take advantage of when interacting with this runner.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.StandardRunnerProtocols
 */
export interface StandardRunnerProtocols {
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.StandardRunnerProtocols.Enum
 */
export enum StandardRunnerProtocols_Enum {
    /**
     * Indicates suport the MonitoringInfo short id protocol.
     *
     * @generated from protobuf enum value: MONITORING_INFO_SHORT_IDS = 0;
     */
    MONITORING_INFO_SHORT_IDS = 0,
    /**
     * Indicates that this runner can process elements embedded in the
     * ProcessBundleResponse. See more about the protocol at
     * https://s.apache.org/beam-fn-api-control-data-embedding
     *
     * @generated from protobuf enum value: CONTROL_RESPONSE_ELEMENTS_EMBEDDING = 6;
     */
    CONTROL_RESPONSE_ELEMENTS_EMBEDDING = 6
}
/**
 * These URNs are used to indicate requirements of a pipeline that cannot
 * simply be expressed as a component (such as a Coder or PTransform) that the
 * runner must understand. In many cases, this indicates a particular field
 * of a transform must be inspected and respected (which allows new fields
 * to be added in a forwards-compatible way).
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.StandardRequirements
 */
export interface StandardRequirements {
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.StandardRequirements.Enum
 */
export enum StandardRequirements_Enum {
    /**
     * This requirement indicates the state_spec and time_spec fields of ParDo
     * transform payloads must be inspected.
     *
     * @generated from protobuf enum value: REQUIRES_STATEFUL_PROCESSING = 0;
     */
    REQUIRES_STATEFUL_PROCESSING = 0,
    /**
     * This requirement indicates the requests_finalization field of ParDo
     * transform payloads must be inspected.
     *
     * @generated from protobuf enum value: REQUIRES_BUNDLE_FINALIZATION = 1;
     */
    REQUIRES_BUNDLE_FINALIZATION = 1,
    /**
     * This requirement indicates the requires_stable_input field of ParDo
     * transform payloads must be inspected.
     *
     * @generated from protobuf enum value: REQUIRES_STABLE_INPUT = 2;
     */
    REQUIRES_STABLE_INPUT = 2,
    /**
     * This requirement indicates the requires_time_sorted_input field of ParDo
     * transform payloads must be inspected.
     *
     * @generated from protobuf enum value: REQUIRES_TIME_SORTED_INPUT = 3;
     */
    REQUIRES_TIME_SORTED_INPUT = 3,
    /**
     * This requirement indicates the restriction_coder_id field of ParDo
     * transform payloads must be inspected.
     *
     * @generated from protobuf enum value: REQUIRES_SPLITTABLE_DOFN = 4;
     */
    REQUIRES_SPLITTABLE_DOFN = 4
}
/**
 * A URN along with a parameter object whose schema is determined by the
 * URN.
 *
 * This structure is reused in two distinct, but compatible, ways:
 *
 * 1. This can be a specification of the function over PCollections
 *    that a PTransform computes.
 * 2. This can be a specification of a user-defined function, possibly
 *    SDK-specific. (external to this message must be adequate context
 *    to indicate the environment in which the UDF can be understood).
 *
 * Though not explicit in this proto, there are two possibilities
 * for the relationship of a runner to this specification that
 * one should bear in mind:
 *
 * 1. The runner understands the URN. For example, it might be
 *    a well-known URN like "beam:transform:Top" or
 *    "beam:window_fn:FixedWindows" with
 *    an agreed-upon payload (e.g. a number or duration,
 *    respectively).
 * 2. The runner does not understand the URN. It might be an
 *    SDK specific URN such as "beam:dofn:javasdk:1.0"
 *    that indicates to the SDK what the payload is,
 *    such as a serialized Java DoFn from a particular
 *    version of the Beam Java SDK. The payload will often
 *    then be an opaque message such as bytes in a
 *    language-specific serialization format.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.FunctionSpec
 */
export interface FunctionSpec {
    /**
     * (Required) A URN that describes the accompanying payload.
     * For any URN that is not recognized (by whomever is inspecting
     * it) the parameter payload should be treated as opaque and
     * passed as-is.
     *
     * @generated from protobuf field: string urn = 1;
     */
    urn: string;
    /**
     * (Optional) The data specifying any parameters to the URN. If
     * the URN does not require any arguments, this may be omitted.
     *
     * @generated from protobuf field: bytes payload = 3;
     */
    payload: Uint8Array;
}
/**
 * A set of well known URNs describing display data.
 *
 * All descriptions must contain how the value should be classified and how it
 * is encoded. Note that some types are logical types which convey contextual
 * information about the pipeline in addition to an encoding while others only
 * specify the encoding itself.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.StandardDisplayData
 */
export interface StandardDisplayData {
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.StandardDisplayData.DisplayData
 */
export enum StandardDisplayData_DisplayData {
    /**
     * A string label and value. Has a payload containing an encoded
     * LabelledPayload.
     *
     * @generated from protobuf enum value: LABELLED = 0;
     */
    LABELLED = 0
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.LabelledPayload
 */
export interface LabelledPayload {
    /**
     * (Required) A human readable label for the value.
     *
     * @generated from protobuf field: string label = 1;
     */
    label: string;
    /**
     * @generated from protobuf oneof: value
     */
    value: {
        oneofKind: "stringValue";
        /**
         * @generated from protobuf field: string string_value = 2;
         */
        stringValue: string;
    } | {
        oneofKind: "boolValue";
        /**
         * @generated from protobuf field: bool bool_value = 3;
         */
        boolValue: boolean;
    } | {
        oneofKind: "doubleValue";
        /**
         * @generated from protobuf field: double double_value = 4;
         */
        doubleValue: number;
    } | {
        oneofKind: "intValue";
        /**
         * @generated from protobuf field: int64 int_value = 5;
         */
        intValue: bigint;
    } | {
        oneofKind: undefined;
    };
    /**
     * (Required) The key identifies the actual content of the metadata.
     *
     * @generated from protobuf field: string key = 6;
     */
    key: string;
    /**
     * (Required) The namespace describes the context that specified the key.
     *
     * @generated from protobuf field: string namespace = 7;
     */
    namespace: string;
}
/**
 * Static display data associated with a pipeline component. Display data is
 * useful for pipeline runners IOs and diagnostic dashboards to display details
 * about annotated components.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.DisplayData
 */
export interface DisplayData {
    /**
     * A key used to describe the type of display data. See StandardDisplayData
     * for the set of well known urns describing how the payload is meant to be
     * interpreted.
     *
     * @generated from protobuf field: string urn = 1;
     */
    urn: string;
    /**
     * (Optional) The data specifying any parameters to the URN. If
     * the URN does not require any arguments, this may be omitted.
     *
     * @generated from protobuf field: bytes payload = 2;
     */
    payload: Uint8Array;
}
// The following transforms are not part of the RunnerApi specification,
// but may be useful for graph construction and manipulation.

/**
 * A disjoint union of all the things that may contain references
 * that require Components to resolve.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.MessageWithComponents
 */
export interface MessageWithComponents {
    /**
     * (Optional) The by-reference components of the root message,
     * enabling a standalone message.
     *
     * If this is absent, it is expected that there are no
     * references.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Components components = 1;
     */
    components?: Components;
    /**
     * @generated from protobuf oneof: root
     */
    root: {
        oneofKind: "coder";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Coder coder = 2;
         */
        coder: Coder;
    } | {
        oneofKind: "combinePayload";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.CombinePayload combine_payload = 3;
         */
        combinePayload: CombinePayload;
    } | {
        oneofKind: "functionSpec";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.FunctionSpec function_spec = 4;
         */
        functionSpec: FunctionSpec;
    } | {
        oneofKind: "parDoPayload";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.ParDoPayload par_do_payload = 6;
         */
        parDoPayload: ParDoPayload;
    } | {
        oneofKind: "ptransform";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.PTransform ptransform = 7;
         */
        ptransform: PTransform;
    } | {
        oneofKind: "pcollection";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.PCollection pcollection = 8;
         */
        pcollection: PCollection;
    } | {
        oneofKind: "readPayload";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.ReadPayload read_payload = 9;
         */
        readPayload: ReadPayload;
    } | {
        oneofKind: "sideInput";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.SideInput side_input = 11;
         */
        sideInput: SideInput;
    } | {
        oneofKind: "windowIntoPayload";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.WindowIntoPayload window_into_payload = 12;
         */
        windowIntoPayload: WindowIntoPayload;
    } | {
        oneofKind: "windowingStrategy";
        /**
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.WindowingStrategy windowing_strategy = 13;
         */
        windowingStrategy: WindowingStrategy;
    } | {
        oneofKind: undefined;
    };
}
/**
 * The payload for an executable stage. This will eventually be passed to an SDK in the form of a
 * ProcessBundleDescriptor.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.ExecutableStagePayload
 */
export interface ExecutableStagePayload {
    /**
     * (Required) Environment in which this stage executes.
     *
     * We use an environment rather than environment id
     * because ExecutableStages use environments directly. This may change in the future.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Environment environment = 1;
     */
    environment?: Environment;
    /**
     * The wire coder settings of this executable stage
     *
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.ExecutableStagePayload.WireCoderSetting wire_coder_settings = 9;
     */
    wireCoderSettings: ExecutableStagePayload_WireCoderSetting[];
    /**
     * (Required) Input PCollection id. This must be present as a value in the inputs of any
     * PTransform the ExecutableStagePayload is the payload of.
     *
     * @generated from protobuf field: string input = 2;
     */
    input: string;
    /**
     * The side inputs required for this executable stage. Each side input of each PTransform within
     * this ExecutableStagePayload must be represented within this field.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.ExecutableStagePayload.SideInputId side_inputs = 3;
     */
    sideInputs: ExecutableStagePayload_SideInputId[];
    /**
     * PTransform ids contained within this executable stage. This must contain at least one
     * PTransform id.
     *
     * @generated from protobuf field: repeated string transforms = 4;
     */
    transforms: string[];
    /**
     * Output PCollection ids. This must be equal to the values of the outputs of any
     * PTransform the ExecutableStagePayload is the payload of.
     *
     * @generated from protobuf field: repeated string outputs = 5;
     */
    outputs: string[];
    /**
     * (Required) The components for the Executable Stage. This must contain all of the Transforms
     * in transforms, and the closure of all of the components they recognize.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.Components components = 6;
     */
    components?: Components;
    /**
     * The user states required for this executable stage. Each user state of each PTransform within
     * this ExecutableStagePayload must be represented within this field.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.ExecutableStagePayload.UserStateId user_states = 7;
     */
    userStates: ExecutableStagePayload_UserStateId[];
    /**
     * The timers required for this executable stage. Each timer of each PTransform within
     * this ExecutableStagePayload must be represented within this field.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerId timers = 8;
     */
    timers: ExecutableStagePayload_TimerId[];
    /**
     * The timerfamilies required for this executable stage. Each timer familyof each PTransform within
     * this ExecutableStagePayload must be represented within this field.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerFamilyId timerFamilies = 10;
     */
    timerFamilies: ExecutableStagePayload_TimerFamilyId[];
}
/**
 * A reference to a side input. Side inputs are uniquely identified by PTransform id and
 * local name.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.ExecutableStagePayload.SideInputId
 */
export interface ExecutableStagePayload_SideInputId {
    /**
     * (Required) The id of the PTransform that references this side input.
     *
     * @generated from protobuf field: string transform_id = 1;
     */
    transformId: string;
    /**
     * (Required) The local name of this side input from the PTransform that references it.
     *
     * @generated from protobuf field: string local_name = 2;
     */
    localName: string;
}
/**
 * A reference to user state. User states are uniquely identified by PTransform id and
 * local name.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.ExecutableStagePayload.UserStateId
 */
export interface ExecutableStagePayload_UserStateId {
    /**
     * (Required) The id of the PTransform that references this user state.
     *
     * @generated from protobuf field: string transform_id = 1;
     */
    transformId: string;
    /**
     * (Required) The local name of this user state for the PTransform that references it.
     *
     * @generated from protobuf field: string local_name = 2;
     */
    localName: string;
}
/**
 * A reference to a timer. Timers are uniquely identified by PTransform id and
 * local name.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerId
 */
export interface ExecutableStagePayload_TimerId {
    /**
     * (Required) The id of the PTransform that references this timer.
     *
     * @generated from protobuf field: string transform_id = 1;
     */
    transformId: string;
    /**
     * (Required) The local name of this timer for the PTransform that references it.
     *
     * @generated from protobuf field: string local_name = 2;
     */
    localName: string;
}
/**
 * A reference to a timer. Timers are uniquely identified by PTransform id and
 * local name.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerFamilyId
 */
export interface ExecutableStagePayload_TimerFamilyId {
    /**
     * (Required) The id of the PTransform that references this timer family.
     *
     * @generated from protobuf field: string transform_id = 1;
     */
    transformId: string;
    /**
     * (Required) The local name of this timer family for the PTransform that references it.
     *
     * @generated from protobuf field: string local_name = 2;
     */
    localName: string;
}
/**
 * Settings that decide the coder type of wire coder.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.ExecutableStagePayload.WireCoderSetting
 */
export interface ExecutableStagePayload_WireCoderSetting {
    /**
     * (Required) The URN of the wire coder.
     * Note that only windowed value coder or parameterized windowed value coder are supported.
     *
     * @generated from protobuf field: string urn = 1;
     */
    urn: string;
    /**
     * (Optional) The data specifying any parameters to the URN. If
     * the URN is beam:coder:windowed_value:v1, this may be omitted. If the URN is
     * beam:coder:param_windowed_value:v1, the payload is an encoded windowed
     * value using the beam:coder:windowed_value:v1 coder parameterized by
     * a beam:coder:bytes:v1 element coder and the window coder that this
     * param_windowed_value coder uses.
     *
     * @generated from protobuf field: bytes payload = 2;
     */
    payload: Uint8Array;
    /**
     * @generated from protobuf oneof: target
     */
    target: {
        oneofKind: "inputOrOutputId";
        /**
         * The input or output PCollection id this setting applies to.
         *
         * @generated from protobuf field: string input_or_output_id = 3;
         */
        inputOrOutputId: string;
    } | {
        oneofKind: "timer";
        /**
         * The timer id this setting applies to.
         *
         * @generated from protobuf field: org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerId timer = 4;
         */
        timer: ExecutableStagePayload_TimerId;
    } | {
        oneofKind: undefined;
    };
}
/**
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.StandardResourceHints
 */
export interface StandardResourceHints {
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.StandardResourceHints.Enum
 */
export enum StandardResourceHints_Enum {
    /**
     * Describes hardware accelerators that are desired to have in the execution environment.
     *
     * @generated from protobuf enum value: ACCELERATOR = 0;
     */
    ACCELERATOR = 0,
    /**
     * Describes desired minimal available RAM size in transform's execution environment.
     * SDKs should convert the size to bytes, but can allow users to specify human-friendly units (e.g. GiB).
     *
     * @generated from protobuf enum value: MIN_RAM_BYTES = 1;
     */
    MIN_RAM_BYTES = 1
}
// @generated message type with reflection information, may provide speed optimized methods
class BeamConstants$Type extends MessageType<BeamConstants> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.BeamConstants", []);
    }
    create(value?: PartialMessage<BeamConstants>): BeamConstants {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<BeamConstants>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: BeamConstants): BeamConstants {
        return target ?? this.create();
    }
    internalBinaryWrite(message: BeamConstants, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.BeamConstants
 */
export const BeamConstants = new BeamConstants$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Components$Type extends MessageType<Components> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Components", [
            { no: 1, name: "transforms", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "message", T: () => PTransform } },
            { no: 2, name: "pcollections", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "message", T: () => PCollection } },
            { no: 3, name: "windowing_strategies", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "message", T: () => WindowingStrategy } },
            { no: 4, name: "coders", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "message", T: () => Coder } },
            { no: 5, name: "environments", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "message", T: () => Environment } }
        ]);
    }
    create(value?: PartialMessage<Components>): Components {
        const message = { transforms: {}, pcollections: {}, windowingStrategies: {}, coders: {}, environments: {} };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Components>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Components): Components {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* map<string, org.apache.beam.model.pipeline.v1.PTransform> transforms */ 1:
                    this.binaryReadMap1(message.transforms, reader, options);
                    break;
                case /* map<string, org.apache.beam.model.pipeline.v1.PCollection> pcollections */ 2:
                    this.binaryReadMap2(message.pcollections, reader, options);
                    break;
                case /* map<string, org.apache.beam.model.pipeline.v1.WindowingStrategy> windowing_strategies */ 3:
                    this.binaryReadMap3(message.windowingStrategies, reader, options);
                    break;
                case /* map<string, org.apache.beam.model.pipeline.v1.Coder> coders */ 4:
                    this.binaryReadMap4(message.coders, reader, options);
                    break;
                case /* map<string, org.apache.beam.model.pipeline.v1.Environment> environments */ 5:
                    this.binaryReadMap5(message.environments, reader, options);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    private binaryReadMap1(map: Components["transforms"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof Components["transforms"] | undefined, val: Components["transforms"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = PTransform.internalBinaryRead(reader, reader.uint32(), options);
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.pipeline.v1.Components.transforms");
            }
        }
        map[key ?? ""] = val ?? PTransform.create();
    }
    private binaryReadMap2(map: Components["pcollections"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof Components["pcollections"] | undefined, val: Components["pcollections"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = PCollection.internalBinaryRead(reader, reader.uint32(), options);
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.pipeline.v1.Components.pcollections");
            }
        }
        map[key ?? ""] = val ?? PCollection.create();
    }
    private binaryReadMap3(map: Components["windowingStrategies"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof Components["windowingStrategies"] | undefined, val: Components["windowingStrategies"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = WindowingStrategy.internalBinaryRead(reader, reader.uint32(), options);
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.pipeline.v1.Components.windowing_strategies");
            }
        }
        map[key ?? ""] = val ?? WindowingStrategy.create();
    }
    private binaryReadMap4(map: Components["coders"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof Components["coders"] | undefined, val: Components["coders"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = Coder.internalBinaryRead(reader, reader.uint32(), options);
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.pipeline.v1.Components.coders");
            }
        }
        map[key ?? ""] = val ?? Coder.create();
    }
    private binaryReadMap5(map: Components["environments"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof Components["environments"] | undefined, val: Components["environments"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = Environment.internalBinaryRead(reader, reader.uint32(), options);
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.pipeline.v1.Components.environments");
            }
        }
        map[key ?? ""] = val ?? Environment.create();
    }
    internalBinaryWrite(message: Components, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* map<string, org.apache.beam.model.pipeline.v1.PTransform> transforms = 1; */
        for (let k of Object.keys(message.transforms)) {
            writer.tag(1, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k);
            writer.tag(2, WireType.LengthDelimited).fork();
            PTransform.internalBinaryWrite(message.transforms[k], writer, options);
            writer.join().join();
        }
        /* map<string, org.apache.beam.model.pipeline.v1.PCollection> pcollections = 2; */
        for (let k of Object.keys(message.pcollections)) {
            writer.tag(2, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k);
            writer.tag(2, WireType.LengthDelimited).fork();
            PCollection.internalBinaryWrite(message.pcollections[k], writer, options);
            writer.join().join();
        }
        /* map<string, org.apache.beam.model.pipeline.v1.WindowingStrategy> windowing_strategies = 3; */
        for (let k of Object.keys(message.windowingStrategies)) {
            writer.tag(3, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k);
            writer.tag(2, WireType.LengthDelimited).fork();
            WindowingStrategy.internalBinaryWrite(message.windowingStrategies[k], writer, options);
            writer.join().join();
        }
        /* map<string, org.apache.beam.model.pipeline.v1.Coder> coders = 4; */
        for (let k of Object.keys(message.coders)) {
            writer.tag(4, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k);
            writer.tag(2, WireType.LengthDelimited).fork();
            Coder.internalBinaryWrite(message.coders[k], writer, options);
            writer.join().join();
        }
        /* map<string, org.apache.beam.model.pipeline.v1.Environment> environments = 5; */
        for (let k of Object.keys(message.environments)) {
            writer.tag(5, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k);
            writer.tag(2, WireType.LengthDelimited).fork();
            Environment.internalBinaryWrite(message.environments[k], writer, options);
            writer.join().join();
        }
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Components
 */
export const Components = new Components$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Pipeline$Type extends MessageType<Pipeline> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Pipeline", [
            { no: 1, name: "components", kind: "message", T: () => Components },
            { no: 2, name: "root_transform_ids", kind: "scalar", repeat: 2 /*RepeatType.UNPACKED*/, T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "display_data", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => DisplayData },
            { no: 4, name: "requirements", kind: "scalar", repeat: 2 /*RepeatType.UNPACKED*/, T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<Pipeline>): Pipeline {
        const message = { rootTransformIds: [], displayData: [], requirements: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Pipeline>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Pipeline): Pipeline {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.Components components */ 1:
                    message.components = Components.internalBinaryRead(reader, reader.uint32(), options, message.components);
                    break;
                case /* repeated string root_transform_ids */ 2:
                    message.rootTransformIds.push(reader.string());
                    break;
                case /* repeated org.apache.beam.model.pipeline.v1.DisplayData display_data */ 3:
                    message.displayData.push(DisplayData.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* repeated string requirements */ 4:
                    message.requirements.push(reader.string());
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: Pipeline, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.Components components = 1; */
        if (message.components)
            Components.internalBinaryWrite(message.components, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* repeated string root_transform_ids = 2; */
        for (let i = 0; i < message.rootTransformIds.length; i++)
            writer.tag(2, WireType.LengthDelimited).string(message.rootTransformIds[i]);
        /* repeated org.apache.beam.model.pipeline.v1.DisplayData display_data = 3; */
        for (let i = 0; i < message.displayData.length; i++)
            DisplayData.internalBinaryWrite(message.displayData[i], writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        /* repeated string requirements = 4; */
        for (let i = 0; i < message.requirements.length; i++)
            writer.tag(4, WireType.LengthDelimited).string(message.requirements[i]);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Pipeline
 */
export const Pipeline = new Pipeline$Type();
// @generated message type with reflection information, may provide speed optimized methods
class PTransform$Type extends MessageType<PTransform> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.PTransform", [
            { no: 5, name: "unique_name", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 1, name: "spec", kind: "message", T: () => FunctionSpec },
            { no: 2, name: "subtransforms", kind: "scalar", repeat: 2 /*RepeatType.UNPACKED*/, T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "inputs", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "scalar", T: 9 /*ScalarType.STRING*/ } },
            { no: 4, name: "outputs", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "scalar", T: 9 /*ScalarType.STRING*/ } },
            { no: 6, name: "display_data", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => DisplayData },
            { no: 7, name: "environment_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 8, name: "annotations", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "scalar", T: 12 /*ScalarType.BYTES*/ } }
        ]);
    }
    create(value?: PartialMessage<PTransform>): PTransform {
        const message = { uniqueName: "", subtransforms: [], inputs: {}, outputs: {}, displayData: [], environmentId: "", annotations: {} };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<PTransform>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: PTransform): PTransform {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string unique_name */ 5:
                    message.uniqueName = reader.string();
                    break;
                case /* org.apache.beam.model.pipeline.v1.FunctionSpec spec */ 1:
                    message.spec = FunctionSpec.internalBinaryRead(reader, reader.uint32(), options, message.spec);
                    break;
                case /* repeated string subtransforms */ 2:
                    message.subtransforms.push(reader.string());
                    break;
                case /* map<string, string> inputs */ 3:
                    this.binaryReadMap3(message.inputs, reader, options);
                    break;
                case /* map<string, string> outputs */ 4:
                    this.binaryReadMap4(message.outputs, reader, options);
                    break;
                case /* repeated org.apache.beam.model.pipeline.v1.DisplayData display_data */ 6:
                    message.displayData.push(DisplayData.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* string environment_id */ 7:
                    message.environmentId = reader.string();
                    break;
                case /* map<string, bytes> annotations */ 8:
                    this.binaryReadMap8(message.annotations, reader, options);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    private binaryReadMap3(map: PTransform["inputs"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof PTransform["inputs"] | undefined, val: PTransform["inputs"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = reader.string();
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.pipeline.v1.PTransform.inputs");
            }
        }
        map[key ?? ""] = val ?? "";
    }
    private binaryReadMap4(map: PTransform["outputs"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof PTransform["outputs"] | undefined, val: PTransform["outputs"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = reader.string();
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.pipeline.v1.PTransform.outputs");
            }
        }
        map[key ?? ""] = val ?? "";
    }
    private binaryReadMap8(map: PTransform["annotations"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof PTransform["annotations"] | undefined, val: PTransform["annotations"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = reader.bytes();
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.pipeline.v1.PTransform.annotations");
            }
        }
        map[key ?? ""] = val ?? new Uint8Array(0);
    }
    internalBinaryWrite(message: PTransform, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string unique_name = 5; */
        if (message.uniqueName !== "")
            writer.tag(5, WireType.LengthDelimited).string(message.uniqueName);
        /* org.apache.beam.model.pipeline.v1.FunctionSpec spec = 1; */
        if (message.spec)
            FunctionSpec.internalBinaryWrite(message.spec, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* repeated string subtransforms = 2; */
        for (let i = 0; i < message.subtransforms.length; i++)
            writer.tag(2, WireType.LengthDelimited).string(message.subtransforms[i]);
        /* map<string, string> inputs = 3; */
        for (let k of Object.keys(message.inputs))
            writer.tag(3, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k).tag(2, WireType.LengthDelimited).string(message.inputs[k]).join();
        /* map<string, string> outputs = 4; */
        for (let k of Object.keys(message.outputs))
            writer.tag(4, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k).tag(2, WireType.LengthDelimited).string(message.outputs[k]).join();
        /* repeated org.apache.beam.model.pipeline.v1.DisplayData display_data = 6; */
        for (let i = 0; i < message.displayData.length; i++)
            DisplayData.internalBinaryWrite(message.displayData[i], writer.tag(6, WireType.LengthDelimited).fork(), options).join();
        /* string environment_id = 7; */
        if (message.environmentId !== "")
            writer.tag(7, WireType.LengthDelimited).string(message.environmentId);
        /* map<string, bytes> annotations = 8; */
        for (let k of Object.keys(message.annotations))
            writer.tag(8, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k).tag(2, WireType.LengthDelimited).bytes(message.annotations[k]).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.PTransform
 */
export const PTransform = new PTransform$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StandardPTransforms$Type extends MessageType<StandardPTransforms> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.StandardPTransforms", []);
    }
    create(value?: PartialMessage<StandardPTransforms>): StandardPTransforms {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StandardPTransforms>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StandardPTransforms): StandardPTransforms {
        return target ?? this.create();
    }
    internalBinaryWrite(message: StandardPTransforms, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.StandardPTransforms
 */
export const StandardPTransforms = new StandardPTransforms$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StandardSideInputTypes$Type extends MessageType<StandardSideInputTypes> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.StandardSideInputTypes", []);
    }
    create(value?: PartialMessage<StandardSideInputTypes>): StandardSideInputTypes {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StandardSideInputTypes>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StandardSideInputTypes): StandardSideInputTypes {
        return target ?? this.create();
    }
    internalBinaryWrite(message: StandardSideInputTypes, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.StandardSideInputTypes
 */
export const StandardSideInputTypes = new StandardSideInputTypes$Type();
// @generated message type with reflection information, may provide speed optimized methods
class PCollection$Type extends MessageType<PCollection> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.PCollection", [
            { no: 1, name: "unique_name", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "coder_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "is_bounded", kind: "enum", T: () => ["org.apache.beam.model.pipeline.v1.IsBounded.Enum", IsBounded_Enum] },
            { no: 4, name: "windowing_strategy_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 5, name: "display_data", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => DisplayData }
        ]);
    }
    create(value?: PartialMessage<PCollection>): PCollection {
        const message = { uniqueName: "", coderId: "", isBounded: 0, windowingStrategyId: "", displayData: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<PCollection>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: PCollection): PCollection {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string unique_name */ 1:
                    message.uniqueName = reader.string();
                    break;
                case /* string coder_id */ 2:
                    message.coderId = reader.string();
                    break;
                case /* org.apache.beam.model.pipeline.v1.IsBounded.Enum is_bounded */ 3:
                    message.isBounded = reader.int32();
                    break;
                case /* string windowing_strategy_id */ 4:
                    message.windowingStrategyId = reader.string();
                    break;
                case /* repeated org.apache.beam.model.pipeline.v1.DisplayData display_data */ 5:
                    message.displayData.push(DisplayData.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: PCollection, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string unique_name = 1; */
        if (message.uniqueName !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.uniqueName);
        /* string coder_id = 2; */
        if (message.coderId !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.coderId);
        /* org.apache.beam.model.pipeline.v1.IsBounded.Enum is_bounded = 3; */
        if (message.isBounded !== 0)
            writer.tag(3, WireType.Varint).int32(message.isBounded);
        /* string windowing_strategy_id = 4; */
        if (message.windowingStrategyId !== "")
            writer.tag(4, WireType.LengthDelimited).string(message.windowingStrategyId);
        /* repeated org.apache.beam.model.pipeline.v1.DisplayData display_data = 5; */
        for (let i = 0; i < message.displayData.length; i++)
            DisplayData.internalBinaryWrite(message.displayData[i], writer.tag(5, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.PCollection
 */
export const PCollection = new PCollection$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ParDoPayload$Type extends MessageType<ParDoPayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.ParDoPayload", [
            { no: 1, name: "do_fn", kind: "message", T: () => FunctionSpec },
            { no: 3, name: "side_inputs", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "message", T: () => SideInput } },
            { no: 4, name: "state_specs", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "message", T: () => StateSpec } },
            { no: 9, name: "timer_family_specs", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "message", T: () => TimerFamilySpec } },
            { no: 7, name: "restriction_coder_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 8, name: "requests_finalization", kind: "scalar", T: 8 /*ScalarType.BOOL*/ },
            { no: 10, name: "requires_time_sorted_input", kind: "scalar", T: 8 /*ScalarType.BOOL*/ },
            { no: 11, name: "requires_stable_input", kind: "scalar", T: 8 /*ScalarType.BOOL*/ }
        ]);
    }
    create(value?: PartialMessage<ParDoPayload>): ParDoPayload {
        const message = { sideInputs: {}, stateSpecs: {}, timerFamilySpecs: {}, restrictionCoderId: "", requestsFinalization: false, requiresTimeSortedInput: false, requiresStableInput: false };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ParDoPayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ParDoPayload): ParDoPayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.FunctionSpec do_fn */ 1:
                    message.doFn = FunctionSpec.internalBinaryRead(reader, reader.uint32(), options, message.doFn);
                    break;
                case /* map<string, org.apache.beam.model.pipeline.v1.SideInput> side_inputs */ 3:
                    this.binaryReadMap3(message.sideInputs, reader, options);
                    break;
                case /* map<string, org.apache.beam.model.pipeline.v1.StateSpec> state_specs */ 4:
                    this.binaryReadMap4(message.stateSpecs, reader, options);
                    break;
                case /* map<string, org.apache.beam.model.pipeline.v1.TimerFamilySpec> timer_family_specs */ 9:
                    this.binaryReadMap9(message.timerFamilySpecs, reader, options);
                    break;
                case /* string restriction_coder_id */ 7:
                    message.restrictionCoderId = reader.string();
                    break;
                case /* bool requests_finalization */ 8:
                    message.requestsFinalization = reader.bool();
                    break;
                case /* bool requires_time_sorted_input */ 10:
                    message.requiresTimeSortedInput = reader.bool();
                    break;
                case /* bool requires_stable_input */ 11:
                    message.requiresStableInput = reader.bool();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    private binaryReadMap3(map: ParDoPayload["sideInputs"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof ParDoPayload["sideInputs"] | undefined, val: ParDoPayload["sideInputs"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = SideInput.internalBinaryRead(reader, reader.uint32(), options);
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.pipeline.v1.ParDoPayload.side_inputs");
            }
        }
        map[key ?? ""] = val ?? SideInput.create();
    }
    private binaryReadMap4(map: ParDoPayload["stateSpecs"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof ParDoPayload["stateSpecs"] | undefined, val: ParDoPayload["stateSpecs"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = StateSpec.internalBinaryRead(reader, reader.uint32(), options);
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.pipeline.v1.ParDoPayload.state_specs");
            }
        }
        map[key ?? ""] = val ?? StateSpec.create();
    }
    private binaryReadMap9(map: ParDoPayload["timerFamilySpecs"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof ParDoPayload["timerFamilySpecs"] | undefined, val: ParDoPayload["timerFamilySpecs"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = TimerFamilySpec.internalBinaryRead(reader, reader.uint32(), options);
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.pipeline.v1.ParDoPayload.timer_family_specs");
            }
        }
        map[key ?? ""] = val ?? TimerFamilySpec.create();
    }
    internalBinaryWrite(message: ParDoPayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.FunctionSpec do_fn = 1; */
        if (message.doFn)
            FunctionSpec.internalBinaryWrite(message.doFn, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* map<string, org.apache.beam.model.pipeline.v1.SideInput> side_inputs = 3; */
        for (let k of Object.keys(message.sideInputs)) {
            writer.tag(3, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k);
            writer.tag(2, WireType.LengthDelimited).fork();
            SideInput.internalBinaryWrite(message.sideInputs[k], writer, options);
            writer.join().join();
        }
        /* map<string, org.apache.beam.model.pipeline.v1.StateSpec> state_specs = 4; */
        for (let k of Object.keys(message.stateSpecs)) {
            writer.tag(4, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k);
            writer.tag(2, WireType.LengthDelimited).fork();
            StateSpec.internalBinaryWrite(message.stateSpecs[k], writer, options);
            writer.join().join();
        }
        /* map<string, org.apache.beam.model.pipeline.v1.TimerFamilySpec> timer_family_specs = 9; */
        for (let k of Object.keys(message.timerFamilySpecs)) {
            writer.tag(9, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k);
            writer.tag(2, WireType.LengthDelimited).fork();
            TimerFamilySpec.internalBinaryWrite(message.timerFamilySpecs[k], writer, options);
            writer.join().join();
        }
        /* string restriction_coder_id = 7; */
        if (message.restrictionCoderId !== "")
            writer.tag(7, WireType.LengthDelimited).string(message.restrictionCoderId);
        /* bool requests_finalization = 8; */
        if (message.requestsFinalization !== false)
            writer.tag(8, WireType.Varint).bool(message.requestsFinalization);
        /* bool requires_time_sorted_input = 10; */
        if (message.requiresTimeSortedInput !== false)
            writer.tag(10, WireType.Varint).bool(message.requiresTimeSortedInput);
        /* bool requires_stable_input = 11; */
        if (message.requiresStableInput !== false)
            writer.tag(11, WireType.Varint).bool(message.requiresStableInput);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.ParDoPayload
 */
export const ParDoPayload = new ParDoPayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StateSpec$Type extends MessageType<StateSpec> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.StateSpec", [
            { no: 1, name: "read_modify_write_spec", kind: "message", oneof: "spec", T: () => ReadModifyWriteStateSpec },
            { no: 2, name: "bag_spec", kind: "message", oneof: "spec", T: () => BagStateSpec },
            { no: 3, name: "combining_spec", kind: "message", oneof: "spec", T: () => CombiningStateSpec },
            { no: 4, name: "map_spec", kind: "message", oneof: "spec", T: () => MapStateSpec },
            { no: 5, name: "set_spec", kind: "message", oneof: "spec", T: () => SetStateSpec },
            { no: 6, name: "ordered_list_spec", kind: "message", oneof: "spec", T: () => OrderedListStateSpec }
        ]);
    }
    create(value?: PartialMessage<StateSpec>): StateSpec {
        const message = { spec: { oneofKind: undefined } };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StateSpec>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StateSpec): StateSpec {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.ReadModifyWriteStateSpec read_modify_write_spec */ 1:
                    message.spec = {
                        oneofKind: "readModifyWriteSpec",
                        readModifyWriteSpec: ReadModifyWriteStateSpec.internalBinaryRead(reader, reader.uint32(), options, (message.spec as any).readModifyWriteSpec)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.BagStateSpec bag_spec */ 2:
                    message.spec = {
                        oneofKind: "bagSpec",
                        bagSpec: BagStateSpec.internalBinaryRead(reader, reader.uint32(), options, (message.spec as any).bagSpec)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.CombiningStateSpec combining_spec */ 3:
                    message.spec = {
                        oneofKind: "combiningSpec",
                        combiningSpec: CombiningStateSpec.internalBinaryRead(reader, reader.uint32(), options, (message.spec as any).combiningSpec)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.MapStateSpec map_spec */ 4:
                    message.spec = {
                        oneofKind: "mapSpec",
                        mapSpec: MapStateSpec.internalBinaryRead(reader, reader.uint32(), options, (message.spec as any).mapSpec)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.SetStateSpec set_spec */ 5:
                    message.spec = {
                        oneofKind: "setSpec",
                        setSpec: SetStateSpec.internalBinaryRead(reader, reader.uint32(), options, (message.spec as any).setSpec)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.OrderedListStateSpec ordered_list_spec */ 6:
                    message.spec = {
                        oneofKind: "orderedListSpec",
                        orderedListSpec: OrderedListStateSpec.internalBinaryRead(reader, reader.uint32(), options, (message.spec as any).orderedListSpec)
                    };
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: StateSpec, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.ReadModifyWriteStateSpec read_modify_write_spec = 1; */
        if (message.spec.oneofKind === "readModifyWriteSpec")
            ReadModifyWriteStateSpec.internalBinaryWrite(message.spec.readModifyWriteSpec, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.BagStateSpec bag_spec = 2; */
        if (message.spec.oneofKind === "bagSpec")
            BagStateSpec.internalBinaryWrite(message.spec.bagSpec, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.CombiningStateSpec combining_spec = 3; */
        if (message.spec.oneofKind === "combiningSpec")
            CombiningStateSpec.internalBinaryWrite(message.spec.combiningSpec, writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.MapStateSpec map_spec = 4; */
        if (message.spec.oneofKind === "mapSpec")
            MapStateSpec.internalBinaryWrite(message.spec.mapSpec, writer.tag(4, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.SetStateSpec set_spec = 5; */
        if (message.spec.oneofKind === "setSpec")
            SetStateSpec.internalBinaryWrite(message.spec.setSpec, writer.tag(5, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.OrderedListStateSpec ordered_list_spec = 6; */
        if (message.spec.oneofKind === "orderedListSpec")
            OrderedListStateSpec.internalBinaryWrite(message.spec.orderedListSpec, writer.tag(6, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.StateSpec
 */
export const StateSpec = new StateSpec$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ReadModifyWriteStateSpec$Type extends MessageType<ReadModifyWriteStateSpec> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.ReadModifyWriteStateSpec", [
            { no: 1, name: "coder_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<ReadModifyWriteStateSpec>): ReadModifyWriteStateSpec {
        const message = { coderId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ReadModifyWriteStateSpec>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ReadModifyWriteStateSpec): ReadModifyWriteStateSpec {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string coder_id */ 1:
                    message.coderId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ReadModifyWriteStateSpec, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string coder_id = 1; */
        if (message.coderId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.coderId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.ReadModifyWriteStateSpec
 */
export const ReadModifyWriteStateSpec = new ReadModifyWriteStateSpec$Type();
// @generated message type with reflection information, may provide speed optimized methods
class BagStateSpec$Type extends MessageType<BagStateSpec> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.BagStateSpec", [
            { no: 1, name: "element_coder_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<BagStateSpec>): BagStateSpec {
        const message = { elementCoderId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<BagStateSpec>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: BagStateSpec): BagStateSpec {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string element_coder_id */ 1:
                    message.elementCoderId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: BagStateSpec, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string element_coder_id = 1; */
        if (message.elementCoderId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.elementCoderId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.BagStateSpec
 */
export const BagStateSpec = new BagStateSpec$Type();
// @generated message type with reflection information, may provide speed optimized methods
class OrderedListStateSpec$Type extends MessageType<OrderedListStateSpec> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.OrderedListStateSpec", [
            { no: 1, name: "element_coder_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<OrderedListStateSpec>): OrderedListStateSpec {
        const message = { elementCoderId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<OrderedListStateSpec>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: OrderedListStateSpec): OrderedListStateSpec {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string element_coder_id */ 1:
                    message.elementCoderId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: OrderedListStateSpec, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string element_coder_id = 1; */
        if (message.elementCoderId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.elementCoderId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.OrderedListStateSpec
 */
export const OrderedListStateSpec = new OrderedListStateSpec$Type();
// @generated message type with reflection information, may provide speed optimized methods
class CombiningStateSpec$Type extends MessageType<CombiningStateSpec> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.CombiningStateSpec", [
            { no: 1, name: "accumulator_coder_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "combine_fn", kind: "message", T: () => FunctionSpec }
        ]);
    }
    create(value?: PartialMessage<CombiningStateSpec>): CombiningStateSpec {
        const message = { accumulatorCoderId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<CombiningStateSpec>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: CombiningStateSpec): CombiningStateSpec {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string accumulator_coder_id */ 1:
                    message.accumulatorCoderId = reader.string();
                    break;
                case /* org.apache.beam.model.pipeline.v1.FunctionSpec combine_fn */ 2:
                    message.combineFn = FunctionSpec.internalBinaryRead(reader, reader.uint32(), options, message.combineFn);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: CombiningStateSpec, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string accumulator_coder_id = 1; */
        if (message.accumulatorCoderId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.accumulatorCoderId);
        /* org.apache.beam.model.pipeline.v1.FunctionSpec combine_fn = 2; */
        if (message.combineFn)
            FunctionSpec.internalBinaryWrite(message.combineFn, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.CombiningStateSpec
 */
export const CombiningStateSpec = new CombiningStateSpec$Type();
// @generated message type with reflection information, may provide speed optimized methods
class MapStateSpec$Type extends MessageType<MapStateSpec> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.MapStateSpec", [
            { no: 1, name: "key_coder_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "value_coder_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<MapStateSpec>): MapStateSpec {
        const message = { keyCoderId: "", valueCoderId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<MapStateSpec>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: MapStateSpec): MapStateSpec {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string key_coder_id */ 1:
                    message.keyCoderId = reader.string();
                    break;
                case /* string value_coder_id */ 2:
                    message.valueCoderId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: MapStateSpec, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string key_coder_id = 1; */
        if (message.keyCoderId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.keyCoderId);
        /* string value_coder_id = 2; */
        if (message.valueCoderId !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.valueCoderId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.MapStateSpec
 */
export const MapStateSpec = new MapStateSpec$Type();
// @generated message type with reflection information, may provide speed optimized methods
class SetStateSpec$Type extends MessageType<SetStateSpec> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.SetStateSpec", [
            { no: 1, name: "element_coder_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<SetStateSpec>): SetStateSpec {
        const message = { elementCoderId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<SetStateSpec>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: SetStateSpec): SetStateSpec {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string element_coder_id */ 1:
                    message.elementCoderId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: SetStateSpec, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string element_coder_id = 1; */
        if (message.elementCoderId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.elementCoderId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.SetStateSpec
 */
export const SetStateSpec = new SetStateSpec$Type();
// @generated message type with reflection information, may provide speed optimized methods
class TimerFamilySpec$Type extends MessageType<TimerFamilySpec> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.TimerFamilySpec", [
            { no: 1, name: "time_domain", kind: "enum", T: () => ["org.apache.beam.model.pipeline.v1.TimeDomain.Enum", TimeDomain_Enum] },
            { no: 2, name: "timer_family_coder_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<TimerFamilySpec>): TimerFamilySpec {
        const message = { timeDomain: 0, timerFamilyCoderId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<TimerFamilySpec>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: TimerFamilySpec): TimerFamilySpec {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.TimeDomain.Enum time_domain */ 1:
                    message.timeDomain = reader.int32();
                    break;
                case /* string timer_family_coder_id */ 2:
                    message.timerFamilyCoderId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: TimerFamilySpec, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.TimeDomain.Enum time_domain = 1; */
        if (message.timeDomain !== 0)
            writer.tag(1, WireType.Varint).int32(message.timeDomain);
        /* string timer_family_coder_id = 2; */
        if (message.timerFamilyCoderId !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.timerFamilyCoderId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.TimerFamilySpec
 */
export const TimerFamilySpec = new TimerFamilySpec$Type();
// @generated message type with reflection information, may provide speed optimized methods
class IsBounded$Type extends MessageType<IsBounded> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.IsBounded", []);
    }
    create(value?: PartialMessage<IsBounded>): IsBounded {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<IsBounded>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: IsBounded): IsBounded {
        return target ?? this.create();
    }
    internalBinaryWrite(message: IsBounded, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.IsBounded
 */
export const IsBounded = new IsBounded$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ReadPayload$Type extends MessageType<ReadPayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.ReadPayload", [
            { no: 1, name: "source", kind: "message", T: () => FunctionSpec },
            { no: 2, name: "is_bounded", kind: "enum", T: () => ["org.apache.beam.model.pipeline.v1.IsBounded.Enum", IsBounded_Enum] }
        ]);
    }
    create(value?: PartialMessage<ReadPayload>): ReadPayload {
        const message = { isBounded: 0 };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ReadPayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ReadPayload): ReadPayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.FunctionSpec source */ 1:
                    message.source = FunctionSpec.internalBinaryRead(reader, reader.uint32(), options, message.source);
                    break;
                case /* org.apache.beam.model.pipeline.v1.IsBounded.Enum is_bounded */ 2:
                    message.isBounded = reader.int32();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ReadPayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.FunctionSpec source = 1; */
        if (message.source)
            FunctionSpec.internalBinaryWrite(message.source, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.IsBounded.Enum is_bounded = 2; */
        if (message.isBounded !== 0)
            writer.tag(2, WireType.Varint).int32(message.isBounded);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.ReadPayload
 */
export const ReadPayload = new ReadPayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class WindowIntoPayload$Type extends MessageType<WindowIntoPayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.WindowIntoPayload", [
            { no: 1, name: "window_fn", kind: "message", T: () => FunctionSpec }
        ]);
    }
    create(value?: PartialMessage<WindowIntoPayload>): WindowIntoPayload {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<WindowIntoPayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: WindowIntoPayload): WindowIntoPayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.FunctionSpec window_fn */ 1:
                    message.windowFn = FunctionSpec.internalBinaryRead(reader, reader.uint32(), options, message.windowFn);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: WindowIntoPayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.FunctionSpec window_fn = 1; */
        if (message.windowFn)
            FunctionSpec.internalBinaryWrite(message.windowFn, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.WindowIntoPayload
 */
export const WindowIntoPayload = new WindowIntoPayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class CombinePayload$Type extends MessageType<CombinePayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.CombinePayload", [
            { no: 1, name: "combine_fn", kind: "message", T: () => FunctionSpec },
            { no: 2, name: "accumulator_coder_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<CombinePayload>): CombinePayload {
        const message = { accumulatorCoderId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<CombinePayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: CombinePayload): CombinePayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.FunctionSpec combine_fn */ 1:
                    message.combineFn = FunctionSpec.internalBinaryRead(reader, reader.uint32(), options, message.combineFn);
                    break;
                case /* string accumulator_coder_id */ 2:
                    message.accumulatorCoderId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: CombinePayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.FunctionSpec combine_fn = 1; */
        if (message.combineFn)
            FunctionSpec.internalBinaryWrite(message.combineFn, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* string accumulator_coder_id = 2; */
        if (message.accumulatorCoderId !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.accumulatorCoderId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.CombinePayload
 */
export const CombinePayload = new CombinePayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class TestStreamPayload$Type extends MessageType<TestStreamPayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.TestStreamPayload", [
            { no: 1, name: "coder_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "events", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => TestStreamPayload_Event },
            { no: 3, name: "endpoint", kind: "message", T: () => ApiServiceDescriptor }
        ]);
    }
    create(value?: PartialMessage<TestStreamPayload>): TestStreamPayload {
        const message = { coderId: "", events: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<TestStreamPayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: TestStreamPayload): TestStreamPayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string coder_id */ 1:
                    message.coderId = reader.string();
                    break;
                case /* repeated org.apache.beam.model.pipeline.v1.TestStreamPayload.Event events */ 2:
                    message.events.push(TestStreamPayload_Event.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor endpoint */ 3:
                    message.endpoint = ApiServiceDescriptor.internalBinaryRead(reader, reader.uint32(), options, message.endpoint);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: TestStreamPayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string coder_id = 1; */
        if (message.coderId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.coderId);
        /* repeated org.apache.beam.model.pipeline.v1.TestStreamPayload.Event events = 2; */
        for (let i = 0; i < message.events.length; i++)
            TestStreamPayload_Event.internalBinaryWrite(message.events[i], writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor endpoint = 3; */
        if (message.endpoint)
            ApiServiceDescriptor.internalBinaryWrite(message.endpoint, writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.TestStreamPayload
 */
export const TestStreamPayload = new TestStreamPayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class TestStreamPayload_Event$Type extends MessageType<TestStreamPayload_Event> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.TestStreamPayload.Event", [
            { no: 1, name: "watermark_event", kind: "message", oneof: "event", T: () => TestStreamPayload_Event_AdvanceWatermark },
            { no: 2, name: "processing_time_event", kind: "message", oneof: "event", T: () => TestStreamPayload_Event_AdvanceProcessingTime },
            { no: 3, name: "element_event", kind: "message", oneof: "event", T: () => TestStreamPayload_Event_AddElements }
        ]);
    }
    create(value?: PartialMessage<TestStreamPayload_Event>): TestStreamPayload_Event {
        const message = { event: { oneofKind: undefined } };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<TestStreamPayload_Event>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: TestStreamPayload_Event): TestStreamPayload_Event {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceWatermark watermark_event */ 1:
                    message.event = {
                        oneofKind: "watermarkEvent",
                        watermarkEvent: TestStreamPayload_Event_AdvanceWatermark.internalBinaryRead(reader, reader.uint32(), options, (message.event as any).watermarkEvent)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceProcessingTime processing_time_event */ 2:
                    message.event = {
                        oneofKind: "processingTimeEvent",
                        processingTimeEvent: TestStreamPayload_Event_AdvanceProcessingTime.internalBinaryRead(reader, reader.uint32(), options, (message.event as any).processingTimeEvent)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AddElements element_event */ 3:
                    message.event = {
                        oneofKind: "elementEvent",
                        elementEvent: TestStreamPayload_Event_AddElements.internalBinaryRead(reader, reader.uint32(), options, (message.event as any).elementEvent)
                    };
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: TestStreamPayload_Event, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceWatermark watermark_event = 1; */
        if (message.event.oneofKind === "watermarkEvent")
            TestStreamPayload_Event_AdvanceWatermark.internalBinaryWrite(message.event.watermarkEvent, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceProcessingTime processing_time_event = 2; */
        if (message.event.oneofKind === "processingTimeEvent")
            TestStreamPayload_Event_AdvanceProcessingTime.internalBinaryWrite(message.event.processingTimeEvent, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AddElements element_event = 3; */
        if (message.event.oneofKind === "elementEvent")
            TestStreamPayload_Event_AddElements.internalBinaryWrite(message.event.elementEvent, writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.TestStreamPayload.Event
 */
export const TestStreamPayload_Event = new TestStreamPayload_Event$Type();
// @generated message type with reflection information, may provide speed optimized methods
class TestStreamPayload_Event_AdvanceWatermark$Type extends MessageType<TestStreamPayload_Event_AdvanceWatermark> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceWatermark", [
            { no: 1, name: "new_watermark", kind: "scalar", T: 3 /*ScalarType.INT64*/, L: 0 /*LongType.BIGINT*/ },
            { no: 2, name: "tag", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<TestStreamPayload_Event_AdvanceWatermark>): TestStreamPayload_Event_AdvanceWatermark {
        const message = { newWatermark: 0n, tag: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<TestStreamPayload_Event_AdvanceWatermark>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: TestStreamPayload_Event_AdvanceWatermark): TestStreamPayload_Event_AdvanceWatermark {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* int64 new_watermark */ 1:
                    message.newWatermark = reader.int64().toBigInt();
                    break;
                case /* string tag */ 2:
                    message.tag = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: TestStreamPayload_Event_AdvanceWatermark, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* int64 new_watermark = 1; */
        if (message.newWatermark !== 0n)
            writer.tag(1, WireType.Varint).int64(message.newWatermark);
        /* string tag = 2; */
        if (message.tag !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.tag);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceWatermark
 */
export const TestStreamPayload_Event_AdvanceWatermark = new TestStreamPayload_Event_AdvanceWatermark$Type();
// @generated message type with reflection information, may provide speed optimized methods
class TestStreamPayload_Event_AdvanceProcessingTime$Type extends MessageType<TestStreamPayload_Event_AdvanceProcessingTime> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceProcessingTime", [
            { no: 1, name: "advance_duration", kind: "scalar", T: 3 /*ScalarType.INT64*/, L: 0 /*LongType.BIGINT*/ }
        ]);
    }
    create(value?: PartialMessage<TestStreamPayload_Event_AdvanceProcessingTime>): TestStreamPayload_Event_AdvanceProcessingTime {
        const message = { advanceDuration: 0n };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<TestStreamPayload_Event_AdvanceProcessingTime>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: TestStreamPayload_Event_AdvanceProcessingTime): TestStreamPayload_Event_AdvanceProcessingTime {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* int64 advance_duration */ 1:
                    message.advanceDuration = reader.int64().toBigInt();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: TestStreamPayload_Event_AdvanceProcessingTime, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* int64 advance_duration = 1; */
        if (message.advanceDuration !== 0n)
            writer.tag(1, WireType.Varint).int64(message.advanceDuration);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceProcessingTime
 */
export const TestStreamPayload_Event_AdvanceProcessingTime = new TestStreamPayload_Event_AdvanceProcessingTime$Type();
// @generated message type with reflection information, may provide speed optimized methods
class TestStreamPayload_Event_AddElements$Type extends MessageType<TestStreamPayload_Event_AddElements> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AddElements", [
            { no: 1, name: "elements", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => TestStreamPayload_TimestampedElement },
            { no: 3, name: "tag", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<TestStreamPayload_Event_AddElements>): TestStreamPayload_Event_AddElements {
        const message = { elements: [], tag: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<TestStreamPayload_Event_AddElements>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: TestStreamPayload_Event_AddElements): TestStreamPayload_Event_AddElements {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated org.apache.beam.model.pipeline.v1.TestStreamPayload.TimestampedElement elements */ 1:
                    message.elements.push(TestStreamPayload_TimestampedElement.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* string tag */ 3:
                    message.tag = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: TestStreamPayload_Event_AddElements, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated org.apache.beam.model.pipeline.v1.TestStreamPayload.TimestampedElement elements = 1; */
        for (let i = 0; i < message.elements.length; i++)
            TestStreamPayload_TimestampedElement.internalBinaryWrite(message.elements[i], writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* string tag = 3; */
        if (message.tag !== "")
            writer.tag(3, WireType.LengthDelimited).string(message.tag);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AddElements
 */
export const TestStreamPayload_Event_AddElements = new TestStreamPayload_Event_AddElements$Type();
// @generated message type with reflection information, may provide speed optimized methods
class TestStreamPayload_TimestampedElement$Type extends MessageType<TestStreamPayload_TimestampedElement> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.TestStreamPayload.TimestampedElement", [
            { no: 1, name: "encoded_element", kind: "scalar", T: 12 /*ScalarType.BYTES*/ },
            { no: 2, name: "timestamp", kind: "scalar", T: 3 /*ScalarType.INT64*/, L: 0 /*LongType.BIGINT*/ }
        ]);
    }
    create(value?: PartialMessage<TestStreamPayload_TimestampedElement>): TestStreamPayload_TimestampedElement {
        const message = { encodedElement: new Uint8Array(0), timestamp: 0n };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<TestStreamPayload_TimestampedElement>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: TestStreamPayload_TimestampedElement): TestStreamPayload_TimestampedElement {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* bytes encoded_element */ 1:
                    message.encodedElement = reader.bytes();
                    break;
                case /* int64 timestamp */ 2:
                    message.timestamp = reader.int64().toBigInt();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: TestStreamPayload_TimestampedElement, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* bytes encoded_element = 1; */
        if (message.encodedElement.length)
            writer.tag(1, WireType.LengthDelimited).bytes(message.encodedElement);
        /* int64 timestamp = 2; */
        if (message.timestamp !== 0n)
            writer.tag(2, WireType.Varint).int64(message.timestamp);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.TestStreamPayload.TimestampedElement
 */
export const TestStreamPayload_TimestampedElement = new TestStreamPayload_TimestampedElement$Type();
// @generated message type with reflection information, may provide speed optimized methods
class EventsRequest$Type extends MessageType<EventsRequest> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.EventsRequest", [
            { no: 1, name: "output_ids", kind: "scalar", repeat: 2 /*RepeatType.UNPACKED*/, T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<EventsRequest>): EventsRequest {
        const message = { outputIds: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<EventsRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: EventsRequest): EventsRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated string output_ids */ 1:
                    message.outputIds.push(reader.string());
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: EventsRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated string output_ids = 1; */
        for (let i = 0; i < message.outputIds.length; i++)
            writer.tag(1, WireType.LengthDelimited).string(message.outputIds[i]);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.EventsRequest
 */
export const EventsRequest = new EventsRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class WriteFilesPayload$Type extends MessageType<WriteFilesPayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.WriteFilesPayload", [
            { no: 1, name: "sink", kind: "message", T: () => FunctionSpec },
            { no: 2, name: "format_function", kind: "message", T: () => FunctionSpec },
            { no: 3, name: "windowed_writes", kind: "scalar", T: 8 /*ScalarType.BOOL*/ },
            { no: 4, name: "runner_determined_sharding", kind: "scalar", T: 8 /*ScalarType.BOOL*/ },
            { no: 5, name: "side_inputs", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "message", T: () => SideInput } }
        ]);
    }
    create(value?: PartialMessage<WriteFilesPayload>): WriteFilesPayload {
        const message = { windowedWrites: false, runnerDeterminedSharding: false, sideInputs: {} };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<WriteFilesPayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: WriteFilesPayload): WriteFilesPayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.FunctionSpec sink */ 1:
                    message.sink = FunctionSpec.internalBinaryRead(reader, reader.uint32(), options, message.sink);
                    break;
                case /* org.apache.beam.model.pipeline.v1.FunctionSpec format_function */ 2:
                    message.formatFunction = FunctionSpec.internalBinaryRead(reader, reader.uint32(), options, message.formatFunction);
                    break;
                case /* bool windowed_writes */ 3:
                    message.windowedWrites = reader.bool();
                    break;
                case /* bool runner_determined_sharding */ 4:
                    message.runnerDeterminedSharding = reader.bool();
                    break;
                case /* map<string, org.apache.beam.model.pipeline.v1.SideInput> side_inputs */ 5:
                    this.binaryReadMap5(message.sideInputs, reader, options);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    private binaryReadMap5(map: WriteFilesPayload["sideInputs"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof WriteFilesPayload["sideInputs"] | undefined, val: WriteFilesPayload["sideInputs"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = SideInput.internalBinaryRead(reader, reader.uint32(), options);
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.pipeline.v1.WriteFilesPayload.side_inputs");
            }
        }
        map[key ?? ""] = val ?? SideInput.create();
    }
    internalBinaryWrite(message: WriteFilesPayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.FunctionSpec sink = 1; */
        if (message.sink)
            FunctionSpec.internalBinaryWrite(message.sink, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.FunctionSpec format_function = 2; */
        if (message.formatFunction)
            FunctionSpec.internalBinaryWrite(message.formatFunction, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        /* bool windowed_writes = 3; */
        if (message.windowedWrites !== false)
            writer.tag(3, WireType.Varint).bool(message.windowedWrites);
        /* bool runner_determined_sharding = 4; */
        if (message.runnerDeterminedSharding !== false)
            writer.tag(4, WireType.Varint).bool(message.runnerDeterminedSharding);
        /* map<string, org.apache.beam.model.pipeline.v1.SideInput> side_inputs = 5; */
        for (let k of Object.keys(message.sideInputs)) {
            writer.tag(5, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k);
            writer.tag(2, WireType.LengthDelimited).fork();
            SideInput.internalBinaryWrite(message.sideInputs[k], writer, options);
            writer.join().join();
        }
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.WriteFilesPayload
 */
export const WriteFilesPayload = new WriteFilesPayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class PubSubReadPayload$Type extends MessageType<PubSubReadPayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.PubSubReadPayload", [
            { no: 1, name: "topic", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "subscription", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "timestamp_attribute", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 4, name: "id_attribute", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 5, name: "with_attributes", kind: "scalar", T: 8 /*ScalarType.BOOL*/ },
            { no: 6, name: "topic_runtime_overridden", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 7, name: "subscription_runtime_overridden", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<PubSubReadPayload>): PubSubReadPayload {
        const message = { topic: "", subscription: "", timestampAttribute: "", idAttribute: "", withAttributes: false, topicRuntimeOverridden: "", subscriptionRuntimeOverridden: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<PubSubReadPayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: PubSubReadPayload): PubSubReadPayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string topic */ 1:
                    message.topic = reader.string();
                    break;
                case /* string subscription */ 2:
                    message.subscription = reader.string();
                    break;
                case /* string timestamp_attribute */ 3:
                    message.timestampAttribute = reader.string();
                    break;
                case /* string id_attribute */ 4:
                    message.idAttribute = reader.string();
                    break;
                case /* bool with_attributes */ 5:
                    message.withAttributes = reader.bool();
                    break;
                case /* string topic_runtime_overridden */ 6:
                    message.topicRuntimeOverridden = reader.string();
                    break;
                case /* string subscription_runtime_overridden */ 7:
                    message.subscriptionRuntimeOverridden = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: PubSubReadPayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string topic = 1; */
        if (message.topic !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.topic);
        /* string subscription = 2; */
        if (message.subscription !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.subscription);
        /* string timestamp_attribute = 3; */
        if (message.timestampAttribute !== "")
            writer.tag(3, WireType.LengthDelimited).string(message.timestampAttribute);
        /* string id_attribute = 4; */
        if (message.idAttribute !== "")
            writer.tag(4, WireType.LengthDelimited).string(message.idAttribute);
        /* bool with_attributes = 5; */
        if (message.withAttributes !== false)
            writer.tag(5, WireType.Varint).bool(message.withAttributes);
        /* string topic_runtime_overridden = 6; */
        if (message.topicRuntimeOverridden !== "")
            writer.tag(6, WireType.LengthDelimited).string(message.topicRuntimeOverridden);
        /* string subscription_runtime_overridden = 7; */
        if (message.subscriptionRuntimeOverridden !== "")
            writer.tag(7, WireType.LengthDelimited).string(message.subscriptionRuntimeOverridden);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.PubSubReadPayload
 */
export const PubSubReadPayload = new PubSubReadPayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class PubSubWritePayload$Type extends MessageType<PubSubWritePayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.PubSubWritePayload", [
            { no: 1, name: "topic", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "timestamp_attribute", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "id_attribute", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 4, name: "topic_runtime_overridden", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<PubSubWritePayload>): PubSubWritePayload {
        const message = { topic: "", timestampAttribute: "", idAttribute: "", topicRuntimeOverridden: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<PubSubWritePayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: PubSubWritePayload): PubSubWritePayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string topic */ 1:
                    message.topic = reader.string();
                    break;
                case /* string timestamp_attribute */ 2:
                    message.timestampAttribute = reader.string();
                    break;
                case /* string id_attribute */ 3:
                    message.idAttribute = reader.string();
                    break;
                case /* string topic_runtime_overridden */ 4:
                    message.topicRuntimeOverridden = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: PubSubWritePayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string topic = 1; */
        if (message.topic !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.topic);
        /* string timestamp_attribute = 2; */
        if (message.timestampAttribute !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.timestampAttribute);
        /* string id_attribute = 3; */
        if (message.idAttribute !== "")
            writer.tag(3, WireType.LengthDelimited).string(message.idAttribute);
        /* string topic_runtime_overridden = 4; */
        if (message.topicRuntimeOverridden !== "")
            writer.tag(4, WireType.LengthDelimited).string(message.topicRuntimeOverridden);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.PubSubWritePayload
 */
export const PubSubWritePayload = new PubSubWritePayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class GroupIntoBatchesPayload$Type extends MessageType<GroupIntoBatchesPayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.GroupIntoBatchesPayload", [
            { no: 1, name: "batch_size", kind: "scalar", T: 3 /*ScalarType.INT64*/, L: 0 /*LongType.BIGINT*/ },
            { no: 3, name: "batch_size_bytes", kind: "scalar", T: 3 /*ScalarType.INT64*/, L: 0 /*LongType.BIGINT*/ },
            { no: 2, name: "max_buffering_duration_millis", kind: "scalar", T: 3 /*ScalarType.INT64*/, L: 0 /*LongType.BIGINT*/ }
        ]);
    }
    create(value?: PartialMessage<GroupIntoBatchesPayload>): GroupIntoBatchesPayload {
        const message = { batchSize: 0n, batchSizeBytes: 0n, maxBufferingDurationMillis: 0n };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<GroupIntoBatchesPayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: GroupIntoBatchesPayload): GroupIntoBatchesPayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* int64 batch_size */ 1:
                    message.batchSize = reader.int64().toBigInt();
                    break;
                case /* int64 batch_size_bytes */ 3:
                    message.batchSizeBytes = reader.int64().toBigInt();
                    break;
                case /* int64 max_buffering_duration_millis */ 2:
                    message.maxBufferingDurationMillis = reader.int64().toBigInt();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: GroupIntoBatchesPayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* int64 batch_size = 1; */
        if (message.batchSize !== 0n)
            writer.tag(1, WireType.Varint).int64(message.batchSize);
        /* int64 batch_size_bytes = 3; */
        if (message.batchSizeBytes !== 0n)
            writer.tag(3, WireType.Varint).int64(message.batchSizeBytes);
        /* int64 max_buffering_duration_millis = 2; */
        if (message.maxBufferingDurationMillis !== 0n)
            writer.tag(2, WireType.Varint).int64(message.maxBufferingDurationMillis);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.GroupIntoBatchesPayload
 */
export const GroupIntoBatchesPayload = new GroupIntoBatchesPayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Coder$Type extends MessageType<Coder> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Coder", [
            { no: 1, name: "spec", kind: "message", T: () => FunctionSpec },
            { no: 2, name: "component_coder_ids", kind: "scalar", repeat: 2 /*RepeatType.UNPACKED*/, T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<Coder>): Coder {
        const message = { componentCoderIds: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Coder>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Coder): Coder {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.FunctionSpec spec */ 1:
                    message.spec = FunctionSpec.internalBinaryRead(reader, reader.uint32(), options, message.spec);
                    break;
                case /* repeated string component_coder_ids */ 2:
                    message.componentCoderIds.push(reader.string());
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: Coder, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.FunctionSpec spec = 1; */
        if (message.spec)
            FunctionSpec.internalBinaryWrite(message.spec, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* repeated string component_coder_ids = 2; */
        for (let i = 0; i < message.componentCoderIds.length; i++)
            writer.tag(2, WireType.LengthDelimited).string(message.componentCoderIds[i]);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Coder
 */
export const Coder = new Coder$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StandardCoders$Type extends MessageType<StandardCoders> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.StandardCoders", []);
    }
    create(value?: PartialMessage<StandardCoders>): StandardCoders {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StandardCoders>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StandardCoders): StandardCoders {
        return target ?? this.create();
    }
    internalBinaryWrite(message: StandardCoders, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.StandardCoders
 */
export const StandardCoders = new StandardCoders$Type();
// @generated message type with reflection information, may provide speed optimized methods
class WindowingStrategy$Type extends MessageType<WindowingStrategy> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.WindowingStrategy", [
            { no: 1, name: "window_fn", kind: "message", T: () => FunctionSpec },
            { no: 2, name: "merge_status", kind: "enum", T: () => ["org.apache.beam.model.pipeline.v1.MergeStatus.Enum", MergeStatus_Enum] },
            { no: 3, name: "window_coder_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 4, name: "trigger", kind: "message", T: () => Trigger },
            { no: 5, name: "accumulation_mode", kind: "enum", T: () => ["org.apache.beam.model.pipeline.v1.AccumulationMode.Enum", AccumulationMode_Enum] },
            { no: 6, name: "output_time", kind: "enum", T: () => ["org.apache.beam.model.pipeline.v1.OutputTime.Enum", OutputTime_Enum] },
            { no: 7, name: "closing_behavior", kind: "enum", T: () => ["org.apache.beam.model.pipeline.v1.ClosingBehavior.Enum", ClosingBehavior_Enum] },
            { no: 8, name: "allowed_lateness", kind: "scalar", T: 3 /*ScalarType.INT64*/, L: 0 /*LongType.BIGINT*/ },
            { no: 9, name: "on_time_behavior", kind: "enum", T: () => ["org.apache.beam.model.pipeline.v1.OnTimeBehavior.Enum", OnTimeBehavior_Enum] },
            { no: 10, name: "assigns_to_one_window", kind: "scalar", T: 8 /*ScalarType.BOOL*/ },
            { no: 11, name: "environment_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<WindowingStrategy>): WindowingStrategy {
        const message = { mergeStatus: 0, windowCoderId: "", accumulationMode: 0, outputTime: 0, closingBehavior: 0, allowedLateness: 0n, onTimeBehavior: 0, assignsToOneWindow: false, environmentId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<WindowingStrategy>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: WindowingStrategy): WindowingStrategy {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.FunctionSpec window_fn */ 1:
                    message.windowFn = FunctionSpec.internalBinaryRead(reader, reader.uint32(), options, message.windowFn);
                    break;
                case /* org.apache.beam.model.pipeline.v1.MergeStatus.Enum merge_status */ 2:
                    message.mergeStatus = reader.int32();
                    break;
                case /* string window_coder_id */ 3:
                    message.windowCoderId = reader.string();
                    break;
                case /* org.apache.beam.model.pipeline.v1.Trigger trigger */ 4:
                    message.trigger = Trigger.internalBinaryRead(reader, reader.uint32(), options, message.trigger);
                    break;
                case /* org.apache.beam.model.pipeline.v1.AccumulationMode.Enum accumulation_mode */ 5:
                    message.accumulationMode = reader.int32();
                    break;
                case /* org.apache.beam.model.pipeline.v1.OutputTime.Enum output_time */ 6:
                    message.outputTime = reader.int32();
                    break;
                case /* org.apache.beam.model.pipeline.v1.ClosingBehavior.Enum closing_behavior */ 7:
                    message.closingBehavior = reader.int32();
                    break;
                case /* int64 allowed_lateness */ 8:
                    message.allowedLateness = reader.int64().toBigInt();
                    break;
                case /* org.apache.beam.model.pipeline.v1.OnTimeBehavior.Enum on_time_behavior */ 9:
                    message.onTimeBehavior = reader.int32();
                    break;
                case /* bool assigns_to_one_window */ 10:
                    message.assignsToOneWindow = reader.bool();
                    break;
                case /* string environment_id */ 11:
                    message.environmentId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: WindowingStrategy, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.FunctionSpec window_fn = 1; */
        if (message.windowFn)
            FunctionSpec.internalBinaryWrite(message.windowFn, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.MergeStatus.Enum merge_status = 2; */
        if (message.mergeStatus !== 0)
            writer.tag(2, WireType.Varint).int32(message.mergeStatus);
        /* string window_coder_id = 3; */
        if (message.windowCoderId !== "")
            writer.tag(3, WireType.LengthDelimited).string(message.windowCoderId);
        /* org.apache.beam.model.pipeline.v1.Trigger trigger = 4; */
        if (message.trigger)
            Trigger.internalBinaryWrite(message.trigger, writer.tag(4, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.AccumulationMode.Enum accumulation_mode = 5; */
        if (message.accumulationMode !== 0)
            writer.tag(5, WireType.Varint).int32(message.accumulationMode);
        /* org.apache.beam.model.pipeline.v1.OutputTime.Enum output_time = 6; */
        if (message.outputTime !== 0)
            writer.tag(6, WireType.Varint).int32(message.outputTime);
        /* org.apache.beam.model.pipeline.v1.ClosingBehavior.Enum closing_behavior = 7; */
        if (message.closingBehavior !== 0)
            writer.tag(7, WireType.Varint).int32(message.closingBehavior);
        /* int64 allowed_lateness = 8; */
        if (message.allowedLateness !== 0n)
            writer.tag(8, WireType.Varint).int64(message.allowedLateness);
        /* org.apache.beam.model.pipeline.v1.OnTimeBehavior.Enum on_time_behavior = 9; */
        if (message.onTimeBehavior !== 0)
            writer.tag(9, WireType.Varint).int32(message.onTimeBehavior);
        /* bool assigns_to_one_window = 10; */
        if (message.assignsToOneWindow !== false)
            writer.tag(10, WireType.Varint).bool(message.assignsToOneWindow);
        /* string environment_id = 11; */
        if (message.environmentId !== "")
            writer.tag(11, WireType.LengthDelimited).string(message.environmentId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.WindowingStrategy
 */
export const WindowingStrategy = new WindowingStrategy$Type();
// @generated message type with reflection information, may provide speed optimized methods
class MergeStatus$Type extends MessageType<MergeStatus> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.MergeStatus", []);
    }
    create(value?: PartialMessage<MergeStatus>): MergeStatus {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<MergeStatus>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: MergeStatus): MergeStatus {
        return target ?? this.create();
    }
    internalBinaryWrite(message: MergeStatus, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.MergeStatus
 */
export const MergeStatus = new MergeStatus$Type();
// @generated message type with reflection information, may provide speed optimized methods
class AccumulationMode$Type extends MessageType<AccumulationMode> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.AccumulationMode", []);
    }
    create(value?: PartialMessage<AccumulationMode>): AccumulationMode {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<AccumulationMode>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: AccumulationMode): AccumulationMode {
        return target ?? this.create();
    }
    internalBinaryWrite(message: AccumulationMode, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.AccumulationMode
 */
export const AccumulationMode = new AccumulationMode$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ClosingBehavior$Type extends MessageType<ClosingBehavior> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.ClosingBehavior", []);
    }
    create(value?: PartialMessage<ClosingBehavior>): ClosingBehavior {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ClosingBehavior>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ClosingBehavior): ClosingBehavior {
        return target ?? this.create();
    }
    internalBinaryWrite(message: ClosingBehavior, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.ClosingBehavior
 */
export const ClosingBehavior = new ClosingBehavior$Type();
// @generated message type with reflection information, may provide speed optimized methods
class OnTimeBehavior$Type extends MessageType<OnTimeBehavior> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.OnTimeBehavior", []);
    }
    create(value?: PartialMessage<OnTimeBehavior>): OnTimeBehavior {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<OnTimeBehavior>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: OnTimeBehavior): OnTimeBehavior {
        return target ?? this.create();
    }
    internalBinaryWrite(message: OnTimeBehavior, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.OnTimeBehavior
 */
export const OnTimeBehavior = new OnTimeBehavior$Type();
// @generated message type with reflection information, may provide speed optimized methods
class OutputTime$Type extends MessageType<OutputTime> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.OutputTime", []);
    }
    create(value?: PartialMessage<OutputTime>): OutputTime {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<OutputTime>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: OutputTime): OutputTime {
        return target ?? this.create();
    }
    internalBinaryWrite(message: OutputTime, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.OutputTime
 */
export const OutputTime = new OutputTime$Type();
// @generated message type with reflection information, may provide speed optimized methods
class TimeDomain$Type extends MessageType<TimeDomain> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.TimeDomain", []);
    }
    create(value?: PartialMessage<TimeDomain>): TimeDomain {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<TimeDomain>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: TimeDomain): TimeDomain {
        return target ?? this.create();
    }
    internalBinaryWrite(message: TimeDomain, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.TimeDomain
 */
export const TimeDomain = new TimeDomain$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Trigger$Type extends MessageType<Trigger> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Trigger", [
            { no: 1, name: "after_all", kind: "message", oneof: "trigger", T: () => Trigger_AfterAll },
            { no: 2, name: "after_any", kind: "message", oneof: "trigger", T: () => Trigger_AfterAny },
            { no: 3, name: "after_each", kind: "message", oneof: "trigger", T: () => Trigger_AfterEach },
            { no: 4, name: "after_end_of_window", kind: "message", oneof: "trigger", T: () => Trigger_AfterEndOfWindow },
            { no: 5, name: "after_processing_time", kind: "message", oneof: "trigger", T: () => Trigger_AfterProcessingTime },
            { no: 6, name: "after_synchronized_processing_time", kind: "message", oneof: "trigger", T: () => Trigger_AfterSynchronizedProcessingTime },
            { no: 12, name: "always", kind: "message", oneof: "trigger", T: () => Trigger_Always },
            { no: 7, name: "default", kind: "message", oneof: "trigger", T: () => Trigger_Default },
            { no: 8, name: "element_count", kind: "message", oneof: "trigger", T: () => Trigger_ElementCount },
            { no: 9, name: "never", kind: "message", oneof: "trigger", T: () => Trigger_Never },
            { no: 10, name: "or_finally", kind: "message", oneof: "trigger", T: () => Trigger_OrFinally },
            { no: 11, name: "repeat", kind: "message", oneof: "trigger", T: () => Trigger_Repeat }
        ]);
    }
    create(value?: PartialMessage<Trigger>): Trigger {
        const message = { trigger: { oneofKind: undefined } };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Trigger>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Trigger): Trigger {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.Trigger.AfterAll after_all */ 1:
                    message.trigger = {
                        oneofKind: "afterAll",
                        afterAll: Trigger_AfterAll.internalBinaryRead(reader, reader.uint32(), options, (message.trigger as any).afterAll)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.Trigger.AfterAny after_any */ 2:
                    message.trigger = {
                        oneofKind: "afterAny",
                        afterAny: Trigger_AfterAny.internalBinaryRead(reader, reader.uint32(), options, (message.trigger as any).afterAny)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.Trigger.AfterEach after_each */ 3:
                    message.trigger = {
                        oneofKind: "afterEach",
                        afterEach: Trigger_AfterEach.internalBinaryRead(reader, reader.uint32(), options, (message.trigger as any).afterEach)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.Trigger.AfterEndOfWindow after_end_of_window */ 4:
                    message.trigger = {
                        oneofKind: "afterEndOfWindow",
                        afterEndOfWindow: Trigger_AfterEndOfWindow.internalBinaryRead(reader, reader.uint32(), options, (message.trigger as any).afterEndOfWindow)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.Trigger.AfterProcessingTime after_processing_time */ 5:
                    message.trigger = {
                        oneofKind: "afterProcessingTime",
                        afterProcessingTime: Trigger_AfterProcessingTime.internalBinaryRead(reader, reader.uint32(), options, (message.trigger as any).afterProcessingTime)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.Trigger.AfterSynchronizedProcessingTime after_synchronized_processing_time */ 6:
                    message.trigger = {
                        oneofKind: "afterSynchronizedProcessingTime",
                        afterSynchronizedProcessingTime: Trigger_AfterSynchronizedProcessingTime.internalBinaryRead(reader, reader.uint32(), options, (message.trigger as any).afterSynchronizedProcessingTime)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.Trigger.Always always */ 12:
                    message.trigger = {
                        oneofKind: "always",
                        always: Trigger_Always.internalBinaryRead(reader, reader.uint32(), options, (message.trigger as any).always)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.Trigger.Default default */ 7:
                    message.trigger = {
                        oneofKind: "default",
                        default: Trigger_Default.internalBinaryRead(reader, reader.uint32(), options, (message.trigger as any).default)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.Trigger.ElementCount element_count */ 8:
                    message.trigger = {
                        oneofKind: "elementCount",
                        elementCount: Trigger_ElementCount.internalBinaryRead(reader, reader.uint32(), options, (message.trigger as any).elementCount)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.Trigger.Never never */ 9:
                    message.trigger = {
                        oneofKind: "never",
                        never: Trigger_Never.internalBinaryRead(reader, reader.uint32(), options, (message.trigger as any).never)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.Trigger.OrFinally or_finally */ 10:
                    message.trigger = {
                        oneofKind: "orFinally",
                        orFinally: Trigger_OrFinally.internalBinaryRead(reader, reader.uint32(), options, (message.trigger as any).orFinally)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.Trigger.Repeat repeat */ 11:
                    message.trigger = {
                        oneofKind: "repeat",
                        repeat: Trigger_Repeat.internalBinaryRead(reader, reader.uint32(), options, (message.trigger as any).repeat)
                    };
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: Trigger, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.Trigger.AfterAll after_all = 1; */
        if (message.trigger.oneofKind === "afterAll")
            Trigger_AfterAll.internalBinaryWrite(message.trigger.afterAll, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.Trigger.AfterAny after_any = 2; */
        if (message.trigger.oneofKind === "afterAny")
            Trigger_AfterAny.internalBinaryWrite(message.trigger.afterAny, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.Trigger.AfterEach after_each = 3; */
        if (message.trigger.oneofKind === "afterEach")
            Trigger_AfterEach.internalBinaryWrite(message.trigger.afterEach, writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.Trigger.AfterEndOfWindow after_end_of_window = 4; */
        if (message.trigger.oneofKind === "afterEndOfWindow")
            Trigger_AfterEndOfWindow.internalBinaryWrite(message.trigger.afterEndOfWindow, writer.tag(4, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.Trigger.AfterProcessingTime after_processing_time = 5; */
        if (message.trigger.oneofKind === "afterProcessingTime")
            Trigger_AfterProcessingTime.internalBinaryWrite(message.trigger.afterProcessingTime, writer.tag(5, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.Trigger.AfterSynchronizedProcessingTime after_synchronized_processing_time = 6; */
        if (message.trigger.oneofKind === "afterSynchronizedProcessingTime")
            Trigger_AfterSynchronizedProcessingTime.internalBinaryWrite(message.trigger.afterSynchronizedProcessingTime, writer.tag(6, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.Trigger.Always always = 12; */
        if (message.trigger.oneofKind === "always")
            Trigger_Always.internalBinaryWrite(message.trigger.always, writer.tag(12, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.Trigger.Default default = 7; */
        if (message.trigger.oneofKind === "default")
            Trigger_Default.internalBinaryWrite(message.trigger.default, writer.tag(7, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.Trigger.ElementCount element_count = 8; */
        if (message.trigger.oneofKind === "elementCount")
            Trigger_ElementCount.internalBinaryWrite(message.trigger.elementCount, writer.tag(8, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.Trigger.Never never = 9; */
        if (message.trigger.oneofKind === "never")
            Trigger_Never.internalBinaryWrite(message.trigger.never, writer.tag(9, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.Trigger.OrFinally or_finally = 10; */
        if (message.trigger.oneofKind === "orFinally")
            Trigger_OrFinally.internalBinaryWrite(message.trigger.orFinally, writer.tag(10, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.Trigger.Repeat repeat = 11; */
        if (message.trigger.oneofKind === "repeat")
            Trigger_Repeat.internalBinaryWrite(message.trigger.repeat, writer.tag(11, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Trigger
 */
export const Trigger = new Trigger$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Trigger_AfterAll$Type extends MessageType<Trigger_AfterAll> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Trigger.AfterAll", [
            { no: 1, name: "subtriggers", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => Trigger }
        ]);
    }
    create(value?: PartialMessage<Trigger_AfterAll>): Trigger_AfterAll {
        const message = { subtriggers: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Trigger_AfterAll>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Trigger_AfterAll): Trigger_AfterAll {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated org.apache.beam.model.pipeline.v1.Trigger subtriggers */ 1:
                    message.subtriggers.push(Trigger.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: Trigger_AfterAll, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated org.apache.beam.model.pipeline.v1.Trigger subtriggers = 1; */
        for (let i = 0; i < message.subtriggers.length; i++)
            Trigger.internalBinaryWrite(message.subtriggers[i], writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Trigger.AfterAll
 */
export const Trigger_AfterAll = new Trigger_AfterAll$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Trigger_AfterAny$Type extends MessageType<Trigger_AfterAny> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Trigger.AfterAny", [
            { no: 1, name: "subtriggers", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => Trigger }
        ]);
    }
    create(value?: PartialMessage<Trigger_AfterAny>): Trigger_AfterAny {
        const message = { subtriggers: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Trigger_AfterAny>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Trigger_AfterAny): Trigger_AfterAny {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated org.apache.beam.model.pipeline.v1.Trigger subtriggers */ 1:
                    message.subtriggers.push(Trigger.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: Trigger_AfterAny, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated org.apache.beam.model.pipeline.v1.Trigger subtriggers = 1; */
        for (let i = 0; i < message.subtriggers.length; i++)
            Trigger.internalBinaryWrite(message.subtriggers[i], writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Trigger.AfterAny
 */
export const Trigger_AfterAny = new Trigger_AfterAny$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Trigger_AfterEach$Type extends MessageType<Trigger_AfterEach> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Trigger.AfterEach", [
            { no: 1, name: "subtriggers", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => Trigger }
        ]);
    }
    create(value?: PartialMessage<Trigger_AfterEach>): Trigger_AfterEach {
        const message = { subtriggers: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Trigger_AfterEach>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Trigger_AfterEach): Trigger_AfterEach {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated org.apache.beam.model.pipeline.v1.Trigger subtriggers */ 1:
                    message.subtriggers.push(Trigger.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: Trigger_AfterEach, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated org.apache.beam.model.pipeline.v1.Trigger subtriggers = 1; */
        for (let i = 0; i < message.subtriggers.length; i++)
            Trigger.internalBinaryWrite(message.subtriggers[i], writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Trigger.AfterEach
 */
export const Trigger_AfterEach = new Trigger_AfterEach$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Trigger_AfterEndOfWindow$Type extends MessageType<Trigger_AfterEndOfWindow> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Trigger.AfterEndOfWindow", [
            { no: 1, name: "early_firings", kind: "message", T: () => Trigger },
            { no: 2, name: "late_firings", kind: "message", T: () => Trigger }
        ]);
    }
    create(value?: PartialMessage<Trigger_AfterEndOfWindow>): Trigger_AfterEndOfWindow {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Trigger_AfterEndOfWindow>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Trigger_AfterEndOfWindow): Trigger_AfterEndOfWindow {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.Trigger early_firings */ 1:
                    message.earlyFirings = Trigger.internalBinaryRead(reader, reader.uint32(), options, message.earlyFirings);
                    break;
                case /* org.apache.beam.model.pipeline.v1.Trigger late_firings */ 2:
                    message.lateFirings = Trigger.internalBinaryRead(reader, reader.uint32(), options, message.lateFirings);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: Trigger_AfterEndOfWindow, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.Trigger early_firings = 1; */
        if (message.earlyFirings)
            Trigger.internalBinaryWrite(message.earlyFirings, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.Trigger late_firings = 2; */
        if (message.lateFirings)
            Trigger.internalBinaryWrite(message.lateFirings, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Trigger.AfterEndOfWindow
 */
export const Trigger_AfterEndOfWindow = new Trigger_AfterEndOfWindow$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Trigger_AfterProcessingTime$Type extends MessageType<Trigger_AfterProcessingTime> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Trigger.AfterProcessingTime", [
            { no: 1, name: "timestamp_transforms", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => TimestampTransform }
        ]);
    }
    create(value?: PartialMessage<Trigger_AfterProcessingTime>): Trigger_AfterProcessingTime {
        const message = { timestampTransforms: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Trigger_AfterProcessingTime>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Trigger_AfterProcessingTime): Trigger_AfterProcessingTime {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated org.apache.beam.model.pipeline.v1.TimestampTransform timestamp_transforms */ 1:
                    message.timestampTransforms.push(TimestampTransform.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: Trigger_AfterProcessingTime, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated org.apache.beam.model.pipeline.v1.TimestampTransform timestamp_transforms = 1; */
        for (let i = 0; i < message.timestampTransforms.length; i++)
            TimestampTransform.internalBinaryWrite(message.timestampTransforms[i], writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Trigger.AfterProcessingTime
 */
export const Trigger_AfterProcessingTime = new Trigger_AfterProcessingTime$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Trigger_AfterSynchronizedProcessingTime$Type extends MessageType<Trigger_AfterSynchronizedProcessingTime> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Trigger.AfterSynchronizedProcessingTime", []);
    }
    create(value?: PartialMessage<Trigger_AfterSynchronizedProcessingTime>): Trigger_AfterSynchronizedProcessingTime {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Trigger_AfterSynchronizedProcessingTime>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Trigger_AfterSynchronizedProcessingTime): Trigger_AfterSynchronizedProcessingTime {
        return target ?? this.create();
    }
    internalBinaryWrite(message: Trigger_AfterSynchronizedProcessingTime, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Trigger.AfterSynchronizedProcessingTime
 */
export const Trigger_AfterSynchronizedProcessingTime = new Trigger_AfterSynchronizedProcessingTime$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Trigger_Default$Type extends MessageType<Trigger_Default> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Trigger.Default", []);
    }
    create(value?: PartialMessage<Trigger_Default>): Trigger_Default {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Trigger_Default>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Trigger_Default): Trigger_Default {
        return target ?? this.create();
    }
    internalBinaryWrite(message: Trigger_Default, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Trigger.Default
 */
export const Trigger_Default = new Trigger_Default$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Trigger_ElementCount$Type extends MessageType<Trigger_ElementCount> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Trigger.ElementCount", [
            { no: 1, name: "element_count", kind: "scalar", T: 5 /*ScalarType.INT32*/ }
        ]);
    }
    create(value?: PartialMessage<Trigger_ElementCount>): Trigger_ElementCount {
        const message = { elementCount: 0 };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Trigger_ElementCount>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Trigger_ElementCount): Trigger_ElementCount {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* int32 element_count */ 1:
                    message.elementCount = reader.int32();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: Trigger_ElementCount, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* int32 element_count = 1; */
        if (message.elementCount !== 0)
            writer.tag(1, WireType.Varint).int32(message.elementCount);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Trigger.ElementCount
 */
export const Trigger_ElementCount = new Trigger_ElementCount$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Trigger_Never$Type extends MessageType<Trigger_Never> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Trigger.Never", []);
    }
    create(value?: PartialMessage<Trigger_Never>): Trigger_Never {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Trigger_Never>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Trigger_Never): Trigger_Never {
        return target ?? this.create();
    }
    internalBinaryWrite(message: Trigger_Never, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Trigger.Never
 */
export const Trigger_Never = new Trigger_Never$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Trigger_Always$Type extends MessageType<Trigger_Always> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Trigger.Always", []);
    }
    create(value?: PartialMessage<Trigger_Always>): Trigger_Always {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Trigger_Always>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Trigger_Always): Trigger_Always {
        return target ?? this.create();
    }
    internalBinaryWrite(message: Trigger_Always, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Trigger.Always
 */
export const Trigger_Always = new Trigger_Always$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Trigger_OrFinally$Type extends MessageType<Trigger_OrFinally> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Trigger.OrFinally", [
            { no: 1, name: "main", kind: "message", T: () => Trigger },
            { no: 2, name: "finally", kind: "message", T: () => Trigger }
        ]);
    }
    create(value?: PartialMessage<Trigger_OrFinally>): Trigger_OrFinally {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Trigger_OrFinally>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Trigger_OrFinally): Trigger_OrFinally {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.Trigger main */ 1:
                    message.main = Trigger.internalBinaryRead(reader, reader.uint32(), options, message.main);
                    break;
                case /* org.apache.beam.model.pipeline.v1.Trigger finally */ 2:
                    message.finally = Trigger.internalBinaryRead(reader, reader.uint32(), options, message.finally);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: Trigger_OrFinally, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.Trigger main = 1; */
        if (message.main)
            Trigger.internalBinaryWrite(message.main, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.Trigger finally = 2; */
        if (message.finally)
            Trigger.internalBinaryWrite(message.finally, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Trigger.OrFinally
 */
export const Trigger_OrFinally = new Trigger_OrFinally$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Trigger_Repeat$Type extends MessageType<Trigger_Repeat> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Trigger.Repeat", [
            { no: 1, name: "subtrigger", kind: "message", T: () => Trigger }
        ]);
    }
    create(value?: PartialMessage<Trigger_Repeat>): Trigger_Repeat {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Trigger_Repeat>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Trigger_Repeat): Trigger_Repeat {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.Trigger subtrigger */ 1:
                    message.subtrigger = Trigger.internalBinaryRead(reader, reader.uint32(), options, message.subtrigger);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: Trigger_Repeat, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.Trigger subtrigger = 1; */
        if (message.subtrigger)
            Trigger.internalBinaryWrite(message.subtrigger, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Trigger.Repeat
 */
export const Trigger_Repeat = new Trigger_Repeat$Type();
// @generated message type with reflection information, may provide speed optimized methods
class TimestampTransform$Type extends MessageType<TimestampTransform> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.TimestampTransform", [
            { no: 1, name: "delay", kind: "message", oneof: "timestampTransform", T: () => TimestampTransform_Delay },
            { no: 2, name: "align_to", kind: "message", oneof: "timestampTransform", T: () => TimestampTransform_AlignTo }
        ]);
    }
    create(value?: PartialMessage<TimestampTransform>): TimestampTransform {
        const message = { timestampTransform: { oneofKind: undefined } };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<TimestampTransform>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: TimestampTransform): TimestampTransform {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.TimestampTransform.Delay delay */ 1:
                    message.timestampTransform = {
                        oneofKind: "delay",
                        delay: TimestampTransform_Delay.internalBinaryRead(reader, reader.uint32(), options, (message.timestampTransform as any).delay)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.TimestampTransform.AlignTo align_to */ 2:
                    message.timestampTransform = {
                        oneofKind: "alignTo",
                        alignTo: TimestampTransform_AlignTo.internalBinaryRead(reader, reader.uint32(), options, (message.timestampTransform as any).alignTo)
                    };
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: TimestampTransform, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.TimestampTransform.Delay delay = 1; */
        if (message.timestampTransform.oneofKind === "delay")
            TimestampTransform_Delay.internalBinaryWrite(message.timestampTransform.delay, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.TimestampTransform.AlignTo align_to = 2; */
        if (message.timestampTransform.oneofKind === "alignTo")
            TimestampTransform_AlignTo.internalBinaryWrite(message.timestampTransform.alignTo, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.TimestampTransform
 */
export const TimestampTransform = new TimestampTransform$Type();
// @generated message type with reflection information, may provide speed optimized methods
class TimestampTransform_Delay$Type extends MessageType<TimestampTransform_Delay> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.TimestampTransform.Delay", [
            { no: 1, name: "delay_millis", kind: "scalar", T: 3 /*ScalarType.INT64*/, L: 0 /*LongType.BIGINT*/ }
        ]);
    }
    create(value?: PartialMessage<TimestampTransform_Delay>): TimestampTransform_Delay {
        const message = { delayMillis: 0n };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<TimestampTransform_Delay>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: TimestampTransform_Delay): TimestampTransform_Delay {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* int64 delay_millis */ 1:
                    message.delayMillis = reader.int64().toBigInt();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: TimestampTransform_Delay, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* int64 delay_millis = 1; */
        if (message.delayMillis !== 0n)
            writer.tag(1, WireType.Varint).int64(message.delayMillis);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.TimestampTransform.Delay
 */
export const TimestampTransform_Delay = new TimestampTransform_Delay$Type();
// @generated message type with reflection information, may provide speed optimized methods
class TimestampTransform_AlignTo$Type extends MessageType<TimestampTransform_AlignTo> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.TimestampTransform.AlignTo", [
            { no: 3, name: "period", kind: "scalar", T: 3 /*ScalarType.INT64*/, L: 0 /*LongType.BIGINT*/ },
            { no: 4, name: "offset", kind: "scalar", T: 3 /*ScalarType.INT64*/, L: 0 /*LongType.BIGINT*/ }
        ]);
    }
    create(value?: PartialMessage<TimestampTransform_AlignTo>): TimestampTransform_AlignTo {
        const message = { period: 0n, offset: 0n };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<TimestampTransform_AlignTo>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: TimestampTransform_AlignTo): TimestampTransform_AlignTo {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* int64 period */ 3:
                    message.period = reader.int64().toBigInt();
                    break;
                case /* int64 offset */ 4:
                    message.offset = reader.int64().toBigInt();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: TimestampTransform_AlignTo, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* int64 period = 3; */
        if (message.period !== 0n)
            writer.tag(3, WireType.Varint).int64(message.period);
        /* int64 offset = 4; */
        if (message.offset !== 0n)
            writer.tag(4, WireType.Varint).int64(message.offset);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.TimestampTransform.AlignTo
 */
export const TimestampTransform_AlignTo = new TimestampTransform_AlignTo$Type();
// @generated message type with reflection information, may provide speed optimized methods
class SideInput$Type extends MessageType<SideInput> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.SideInput", [
            { no: 1, name: "access_pattern", kind: "message", T: () => FunctionSpec },
            { no: 2, name: "view_fn", kind: "message", T: () => FunctionSpec },
            { no: 3, name: "window_mapping_fn", kind: "message", T: () => FunctionSpec }
        ]);
    }
    create(value?: PartialMessage<SideInput>): SideInput {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<SideInput>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: SideInput): SideInput {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.FunctionSpec access_pattern */ 1:
                    message.accessPattern = FunctionSpec.internalBinaryRead(reader, reader.uint32(), options, message.accessPattern);
                    break;
                case /* org.apache.beam.model.pipeline.v1.FunctionSpec view_fn */ 2:
                    message.viewFn = FunctionSpec.internalBinaryRead(reader, reader.uint32(), options, message.viewFn);
                    break;
                case /* org.apache.beam.model.pipeline.v1.FunctionSpec window_mapping_fn */ 3:
                    message.windowMappingFn = FunctionSpec.internalBinaryRead(reader, reader.uint32(), options, message.windowMappingFn);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: SideInput, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.FunctionSpec access_pattern = 1; */
        if (message.accessPattern)
            FunctionSpec.internalBinaryWrite(message.accessPattern, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.FunctionSpec view_fn = 2; */
        if (message.viewFn)
            FunctionSpec.internalBinaryWrite(message.viewFn, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.FunctionSpec window_mapping_fn = 3; */
        if (message.windowMappingFn)
            FunctionSpec.internalBinaryWrite(message.windowMappingFn, writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.SideInput
 */
export const SideInput = new SideInput$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StandardArtifacts$Type extends MessageType<StandardArtifacts> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.StandardArtifacts", []);
    }
    create(value?: PartialMessage<StandardArtifacts>): StandardArtifacts {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StandardArtifacts>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StandardArtifacts): StandardArtifacts {
        return target ?? this.create();
    }
    internalBinaryWrite(message: StandardArtifacts, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.StandardArtifacts
 */
export const StandardArtifacts = new StandardArtifacts$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ArtifactFilePayload$Type extends MessageType<ArtifactFilePayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.ArtifactFilePayload", [
            { no: 1, name: "path", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "sha256", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<ArtifactFilePayload>): ArtifactFilePayload {
        const message = { path: "", sha256: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ArtifactFilePayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ArtifactFilePayload): ArtifactFilePayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string path */ 1:
                    message.path = reader.string();
                    break;
                case /* string sha256 */ 2:
                    message.sha256 = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ArtifactFilePayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string path = 1; */
        if (message.path !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.path);
        /* string sha256 = 2; */
        if (message.sha256 !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.sha256);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.ArtifactFilePayload
 */
export const ArtifactFilePayload = new ArtifactFilePayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ArtifactUrlPayload$Type extends MessageType<ArtifactUrlPayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.ArtifactUrlPayload", [
            { no: 1, name: "url", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "sha256", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<ArtifactUrlPayload>): ArtifactUrlPayload {
        const message = { url: "", sha256: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ArtifactUrlPayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ArtifactUrlPayload): ArtifactUrlPayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string url */ 1:
                    message.url = reader.string();
                    break;
                case /* string sha256 */ 2:
                    message.sha256 = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ArtifactUrlPayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string url = 1; */
        if (message.url !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.url);
        /* string sha256 = 2; */
        if (message.sha256 !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.sha256);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.ArtifactUrlPayload
 */
export const ArtifactUrlPayload = new ArtifactUrlPayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class EmbeddedFilePayload$Type extends MessageType<EmbeddedFilePayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.EmbeddedFilePayload", [
            { no: 1, name: "data", kind: "scalar", T: 12 /*ScalarType.BYTES*/ }
        ]);
    }
    create(value?: PartialMessage<EmbeddedFilePayload>): EmbeddedFilePayload {
        const message = { data: new Uint8Array(0) };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<EmbeddedFilePayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: EmbeddedFilePayload): EmbeddedFilePayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* bytes data */ 1:
                    message.data = reader.bytes();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: EmbeddedFilePayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* bytes data = 1; */
        if (message.data.length)
            writer.tag(1, WireType.LengthDelimited).bytes(message.data);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.EmbeddedFilePayload
 */
export const EmbeddedFilePayload = new EmbeddedFilePayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class PyPIPayload$Type extends MessageType<PyPIPayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.PyPIPayload", [
            { no: 1, name: "artifact_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "version", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<PyPIPayload>): PyPIPayload {
        const message = { artifactId: "", version: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<PyPIPayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: PyPIPayload): PyPIPayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string artifact_id */ 1:
                    message.artifactId = reader.string();
                    break;
                case /* string version */ 2:
                    message.version = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: PyPIPayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string artifact_id = 1; */
        if (message.artifactId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.artifactId);
        /* string version = 2; */
        if (message.version !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.version);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.PyPIPayload
 */
export const PyPIPayload = new PyPIPayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class MavenPayload$Type extends MessageType<MavenPayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.MavenPayload", [
            { no: 1, name: "artifact", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "repository_url", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<MavenPayload>): MavenPayload {
        const message = { artifact: "", repositoryUrl: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<MavenPayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: MavenPayload): MavenPayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string artifact */ 1:
                    message.artifact = reader.string();
                    break;
                case /* string repository_url */ 2:
                    message.repositoryUrl = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: MavenPayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string artifact = 1; */
        if (message.artifact !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.artifact);
        /* string repository_url = 2; */
        if (message.repositoryUrl !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.repositoryUrl);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.MavenPayload
 */
export const MavenPayload = new MavenPayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class DeferredArtifactPayload$Type extends MessageType<DeferredArtifactPayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.DeferredArtifactPayload", [
            { no: 1, name: "key", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "data", kind: "scalar", T: 12 /*ScalarType.BYTES*/ }
        ]);
    }
    create(value?: PartialMessage<DeferredArtifactPayload>): DeferredArtifactPayload {
        const message = { key: "", data: new Uint8Array(0) };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<DeferredArtifactPayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: DeferredArtifactPayload): DeferredArtifactPayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string key */ 1:
                    message.key = reader.string();
                    break;
                case /* bytes data */ 2:
                    message.data = reader.bytes();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: DeferredArtifactPayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string key = 1; */
        if (message.key !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.key);
        /* bytes data = 2; */
        if (message.data.length)
            writer.tag(2, WireType.LengthDelimited).bytes(message.data);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.DeferredArtifactPayload
 */
export const DeferredArtifactPayload = new DeferredArtifactPayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ArtifactStagingToRolePayload$Type extends MessageType<ArtifactStagingToRolePayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.ArtifactStagingToRolePayload", [
            { no: 1, name: "staged_name", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<ArtifactStagingToRolePayload>): ArtifactStagingToRolePayload {
        const message = { stagedName: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ArtifactStagingToRolePayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ArtifactStagingToRolePayload): ArtifactStagingToRolePayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string staged_name */ 1:
                    message.stagedName = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ArtifactStagingToRolePayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string staged_name = 1; */
        if (message.stagedName !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.stagedName);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.ArtifactStagingToRolePayload
 */
export const ArtifactStagingToRolePayload = new ArtifactStagingToRolePayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ArtifactInformation$Type extends MessageType<ArtifactInformation> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.ArtifactInformation", [
            { no: 1, name: "type_urn", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "type_payload", kind: "scalar", T: 12 /*ScalarType.BYTES*/ },
            { no: 3, name: "role_urn", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 4, name: "role_payload", kind: "scalar", T: 12 /*ScalarType.BYTES*/ }
        ]);
    }
    create(value?: PartialMessage<ArtifactInformation>): ArtifactInformation {
        const message = { typeUrn: "", typePayload: new Uint8Array(0), roleUrn: "", rolePayload: new Uint8Array(0) };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ArtifactInformation>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ArtifactInformation): ArtifactInformation {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string type_urn */ 1:
                    message.typeUrn = reader.string();
                    break;
                case /* bytes type_payload */ 2:
                    message.typePayload = reader.bytes();
                    break;
                case /* string role_urn */ 3:
                    message.roleUrn = reader.string();
                    break;
                case /* bytes role_payload */ 4:
                    message.rolePayload = reader.bytes();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ArtifactInformation, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string type_urn = 1; */
        if (message.typeUrn !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.typeUrn);
        /* bytes type_payload = 2; */
        if (message.typePayload.length)
            writer.tag(2, WireType.LengthDelimited).bytes(message.typePayload);
        /* string role_urn = 3; */
        if (message.roleUrn !== "")
            writer.tag(3, WireType.LengthDelimited).string(message.roleUrn);
        /* bytes role_payload = 4; */
        if (message.rolePayload.length)
            writer.tag(4, WireType.LengthDelimited).bytes(message.rolePayload);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.ArtifactInformation
 */
export const ArtifactInformation = new ArtifactInformation$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Environment$Type extends MessageType<Environment> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.Environment", [
            { no: 2, name: "urn", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "payload", kind: "scalar", T: 12 /*ScalarType.BYTES*/ },
            { no: 4, name: "display_data", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => DisplayData },
            { no: 5, name: "capabilities", kind: "scalar", repeat: 2 /*RepeatType.UNPACKED*/, T: 9 /*ScalarType.STRING*/ },
            { no: 6, name: "dependencies", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => ArtifactInformation },
            { no: 7, name: "resource_hints", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "scalar", T: 12 /*ScalarType.BYTES*/ } }
        ]);
    }
    create(value?: PartialMessage<Environment>): Environment {
        const message = { urn: "", payload: new Uint8Array(0), displayData: [], capabilities: [], dependencies: [], resourceHints: {} };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Environment>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Environment): Environment {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string urn */ 2:
                    message.urn = reader.string();
                    break;
                case /* bytes payload */ 3:
                    message.payload = reader.bytes();
                    break;
                case /* repeated org.apache.beam.model.pipeline.v1.DisplayData display_data */ 4:
                    message.displayData.push(DisplayData.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* repeated string capabilities */ 5:
                    message.capabilities.push(reader.string());
                    break;
                case /* repeated org.apache.beam.model.pipeline.v1.ArtifactInformation dependencies */ 6:
                    message.dependencies.push(ArtifactInformation.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* map<string, bytes> resource_hints */ 7:
                    this.binaryReadMap7(message.resourceHints, reader, options);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    private binaryReadMap7(map: Environment["resourceHints"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof Environment["resourceHints"] | undefined, val: Environment["resourceHints"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = reader.bytes();
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.pipeline.v1.Environment.resource_hints");
            }
        }
        map[key ?? ""] = val ?? new Uint8Array(0);
    }
    internalBinaryWrite(message: Environment, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string urn = 2; */
        if (message.urn !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.urn);
        /* bytes payload = 3; */
        if (message.payload.length)
            writer.tag(3, WireType.LengthDelimited).bytes(message.payload);
        /* repeated org.apache.beam.model.pipeline.v1.DisplayData display_data = 4; */
        for (let i = 0; i < message.displayData.length; i++)
            DisplayData.internalBinaryWrite(message.displayData[i], writer.tag(4, WireType.LengthDelimited).fork(), options).join();
        /* repeated string capabilities = 5; */
        for (let i = 0; i < message.capabilities.length; i++)
            writer.tag(5, WireType.LengthDelimited).string(message.capabilities[i]);
        /* repeated org.apache.beam.model.pipeline.v1.ArtifactInformation dependencies = 6; */
        for (let i = 0; i < message.dependencies.length; i++)
            ArtifactInformation.internalBinaryWrite(message.dependencies[i], writer.tag(6, WireType.LengthDelimited).fork(), options).join();
        /* map<string, bytes> resource_hints = 7; */
        for (let k of Object.keys(message.resourceHints))
            writer.tag(7, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k).tag(2, WireType.LengthDelimited).bytes(message.resourceHints[k]).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.Environment
 */
export const Environment = new Environment$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StandardEnvironments$Type extends MessageType<StandardEnvironments> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.StandardEnvironments", []);
    }
    create(value?: PartialMessage<StandardEnvironments>): StandardEnvironments {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StandardEnvironments>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StandardEnvironments): StandardEnvironments {
        return target ?? this.create();
    }
    internalBinaryWrite(message: StandardEnvironments, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.StandardEnvironments
 */
export const StandardEnvironments = new StandardEnvironments$Type();
// @generated message type with reflection information, may provide speed optimized methods
class DockerPayload$Type extends MessageType<DockerPayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.DockerPayload", [
            { no: 1, name: "container_image", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<DockerPayload>): DockerPayload {
        const message = { containerImage: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<DockerPayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: DockerPayload): DockerPayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string container_image */ 1:
                    message.containerImage = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: DockerPayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string container_image = 1; */
        if (message.containerImage !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.containerImage);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.DockerPayload
 */
export const DockerPayload = new DockerPayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ProcessPayload$Type extends MessageType<ProcessPayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.ProcessPayload", [
            { no: 1, name: "os", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "arch", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "command", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 4, name: "env", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "scalar", T: 9 /*ScalarType.STRING*/ } }
        ]);
    }
    create(value?: PartialMessage<ProcessPayload>): ProcessPayload {
        const message = { os: "", arch: "", command: "", env: {} };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ProcessPayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ProcessPayload): ProcessPayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string os */ 1:
                    message.os = reader.string();
                    break;
                case /* string arch */ 2:
                    message.arch = reader.string();
                    break;
                case /* string command */ 3:
                    message.command = reader.string();
                    break;
                case /* map<string, string> env */ 4:
                    this.binaryReadMap4(message.env, reader, options);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    private binaryReadMap4(map: ProcessPayload["env"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof ProcessPayload["env"] | undefined, val: ProcessPayload["env"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = reader.string();
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.pipeline.v1.ProcessPayload.env");
            }
        }
        map[key ?? ""] = val ?? "";
    }
    internalBinaryWrite(message: ProcessPayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string os = 1; */
        if (message.os !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.os);
        /* string arch = 2; */
        if (message.arch !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.arch);
        /* string command = 3; */
        if (message.command !== "")
            writer.tag(3, WireType.LengthDelimited).string(message.command);
        /* map<string, string> env = 4; */
        for (let k of Object.keys(message.env))
            writer.tag(4, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k).tag(2, WireType.LengthDelimited).string(message.env[k]).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.ProcessPayload
 */
export const ProcessPayload = new ProcessPayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ExternalPayload$Type extends MessageType<ExternalPayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.ExternalPayload", [
            { no: 1, name: "endpoint", kind: "message", T: () => ApiServiceDescriptor },
            { no: 2, name: "params", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "scalar", T: 9 /*ScalarType.STRING*/ } }
        ]);
    }
    create(value?: PartialMessage<ExternalPayload>): ExternalPayload {
        const message = { params: {} };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ExternalPayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ExternalPayload): ExternalPayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor endpoint */ 1:
                    message.endpoint = ApiServiceDescriptor.internalBinaryRead(reader, reader.uint32(), options, message.endpoint);
                    break;
                case /* map<string, string> params */ 2:
                    this.binaryReadMap2(message.params, reader, options);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    private binaryReadMap2(map: ExternalPayload["params"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof ExternalPayload["params"] | undefined, val: ExternalPayload["params"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = reader.string();
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.pipeline.v1.ExternalPayload.params");
            }
        }
        map[key ?? ""] = val ?? "";
    }
    internalBinaryWrite(message: ExternalPayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor endpoint = 1; */
        if (message.endpoint)
            ApiServiceDescriptor.internalBinaryWrite(message.endpoint, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* map<string, string> params = 2; */
        for (let k of Object.keys(message.params))
            writer.tag(2, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k).tag(2, WireType.LengthDelimited).string(message.params[k]).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.ExternalPayload
 */
export const ExternalPayload = new ExternalPayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StandardProtocols$Type extends MessageType<StandardProtocols> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.StandardProtocols", []);
    }
    create(value?: PartialMessage<StandardProtocols>): StandardProtocols {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StandardProtocols>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StandardProtocols): StandardProtocols {
        return target ?? this.create();
    }
    internalBinaryWrite(message: StandardProtocols, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.StandardProtocols
 */
export const StandardProtocols = new StandardProtocols$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StandardRunnerProtocols$Type extends MessageType<StandardRunnerProtocols> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.StandardRunnerProtocols", []);
    }
    create(value?: PartialMessage<StandardRunnerProtocols>): StandardRunnerProtocols {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StandardRunnerProtocols>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StandardRunnerProtocols): StandardRunnerProtocols {
        return target ?? this.create();
    }
    internalBinaryWrite(message: StandardRunnerProtocols, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.StandardRunnerProtocols
 */
export const StandardRunnerProtocols = new StandardRunnerProtocols$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StandardRequirements$Type extends MessageType<StandardRequirements> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.StandardRequirements", []);
    }
    create(value?: PartialMessage<StandardRequirements>): StandardRequirements {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StandardRequirements>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StandardRequirements): StandardRequirements {
        return target ?? this.create();
    }
    internalBinaryWrite(message: StandardRequirements, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.StandardRequirements
 */
export const StandardRequirements = new StandardRequirements$Type();
// @generated message type with reflection information, may provide speed optimized methods
class FunctionSpec$Type extends MessageType<FunctionSpec> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.FunctionSpec", [
            { no: 1, name: "urn", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "payload", kind: "scalar", T: 12 /*ScalarType.BYTES*/ }
        ]);
    }
    create(value?: PartialMessage<FunctionSpec>): FunctionSpec {
        const message = { urn: "", payload: new Uint8Array(0) };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<FunctionSpec>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: FunctionSpec): FunctionSpec {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string urn */ 1:
                    message.urn = reader.string();
                    break;
                case /* bytes payload */ 3:
                    message.payload = reader.bytes();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: FunctionSpec, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string urn = 1; */
        if (message.urn !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.urn);
        /* bytes payload = 3; */
        if (message.payload.length)
            writer.tag(3, WireType.LengthDelimited).bytes(message.payload);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.FunctionSpec
 */
export const FunctionSpec = new FunctionSpec$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StandardDisplayData$Type extends MessageType<StandardDisplayData> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.StandardDisplayData", []);
    }
    create(value?: PartialMessage<StandardDisplayData>): StandardDisplayData {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StandardDisplayData>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StandardDisplayData): StandardDisplayData {
        return target ?? this.create();
    }
    internalBinaryWrite(message: StandardDisplayData, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.StandardDisplayData
 */
export const StandardDisplayData = new StandardDisplayData$Type();
// @generated message type with reflection information, may provide speed optimized methods
class LabelledPayload$Type extends MessageType<LabelledPayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.LabelledPayload", [
            { no: 1, name: "label", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "string_value", kind: "scalar", oneof: "value", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "bool_value", kind: "scalar", oneof: "value", T: 8 /*ScalarType.BOOL*/ },
            { no: 4, name: "double_value", kind: "scalar", oneof: "value", T: 1 /*ScalarType.DOUBLE*/ },
            { no: 5, name: "int_value", kind: "scalar", oneof: "value", T: 3 /*ScalarType.INT64*/, L: 0 /*LongType.BIGINT*/ },
            { no: 6, name: "key", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 7, name: "namespace", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<LabelledPayload>): LabelledPayload {
        const message = { label: "", value: { oneofKind: undefined }, key: "", namespace: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<LabelledPayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: LabelledPayload): LabelledPayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string label */ 1:
                    message.label = reader.string();
                    break;
                case /* string string_value */ 2:
                    message.value = {
                        oneofKind: "stringValue",
                        stringValue: reader.string()
                    };
                    break;
                case /* bool bool_value */ 3:
                    message.value = {
                        oneofKind: "boolValue",
                        boolValue: reader.bool()
                    };
                    break;
                case /* double double_value */ 4:
                    message.value = {
                        oneofKind: "doubleValue",
                        doubleValue: reader.double()
                    };
                    break;
                case /* int64 int_value */ 5:
                    message.value = {
                        oneofKind: "intValue",
                        intValue: reader.int64().toBigInt()
                    };
                    break;
                case /* string key */ 6:
                    message.key = reader.string();
                    break;
                case /* string namespace */ 7:
                    message.namespace = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: LabelledPayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string label = 1; */
        if (message.label !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.label);
        /* string string_value = 2; */
        if (message.value.oneofKind === "stringValue")
            writer.tag(2, WireType.LengthDelimited).string(message.value.stringValue);
        /* bool bool_value = 3; */
        if (message.value.oneofKind === "boolValue")
            writer.tag(3, WireType.Varint).bool(message.value.boolValue);
        /* double double_value = 4; */
        if (message.value.oneofKind === "doubleValue")
            writer.tag(4, WireType.Bit64).double(message.value.doubleValue);
        /* int64 int_value = 5; */
        if (message.value.oneofKind === "intValue")
            writer.tag(5, WireType.Varint).int64(message.value.intValue);
        /* string key = 6; */
        if (message.key !== "")
            writer.tag(6, WireType.LengthDelimited).string(message.key);
        /* string namespace = 7; */
        if (message.namespace !== "")
            writer.tag(7, WireType.LengthDelimited).string(message.namespace);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.LabelledPayload
 */
export const LabelledPayload = new LabelledPayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class DisplayData$Type extends MessageType<DisplayData> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.DisplayData", [
            { no: 1, name: "urn", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "payload", kind: "scalar", T: 12 /*ScalarType.BYTES*/ }
        ]);
    }
    create(value?: PartialMessage<DisplayData>): DisplayData {
        const message = { urn: "", payload: new Uint8Array(0) };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<DisplayData>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: DisplayData): DisplayData {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string urn */ 1:
                    message.urn = reader.string();
                    break;
                case /* bytes payload */ 2:
                    message.payload = reader.bytes();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: DisplayData, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string urn = 1; */
        if (message.urn !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.urn);
        /* bytes payload = 2; */
        if (message.payload.length)
            writer.tag(2, WireType.LengthDelimited).bytes(message.payload);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.DisplayData
 */
export const DisplayData = new DisplayData$Type();
// @generated message type with reflection information, may provide speed optimized methods
class MessageWithComponents$Type extends MessageType<MessageWithComponents> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.MessageWithComponents", [
            { no: 1, name: "components", kind: "message", T: () => Components },
            { no: 2, name: "coder", kind: "message", oneof: "root", T: () => Coder },
            { no: 3, name: "combine_payload", kind: "message", oneof: "root", T: () => CombinePayload },
            { no: 4, name: "function_spec", kind: "message", oneof: "root", T: () => FunctionSpec },
            { no: 6, name: "par_do_payload", kind: "message", oneof: "root", T: () => ParDoPayload },
            { no: 7, name: "ptransform", kind: "message", oneof: "root", T: () => PTransform },
            { no: 8, name: "pcollection", kind: "message", oneof: "root", T: () => PCollection },
            { no: 9, name: "read_payload", kind: "message", oneof: "root", T: () => ReadPayload },
            { no: 11, name: "side_input", kind: "message", oneof: "root", T: () => SideInput },
            { no: 12, name: "window_into_payload", kind: "message", oneof: "root", T: () => WindowIntoPayload },
            { no: 13, name: "windowing_strategy", kind: "message", oneof: "root", T: () => WindowingStrategy }
        ]);
    }
    create(value?: PartialMessage<MessageWithComponents>): MessageWithComponents {
        const message = { root: { oneofKind: undefined } };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<MessageWithComponents>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: MessageWithComponents): MessageWithComponents {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.Components components */ 1:
                    message.components = Components.internalBinaryRead(reader, reader.uint32(), options, message.components);
                    break;
                case /* org.apache.beam.model.pipeline.v1.Coder coder */ 2:
                    message.root = {
                        oneofKind: "coder",
                        coder: Coder.internalBinaryRead(reader, reader.uint32(), options, (message.root as any).coder)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.CombinePayload combine_payload */ 3:
                    message.root = {
                        oneofKind: "combinePayload",
                        combinePayload: CombinePayload.internalBinaryRead(reader, reader.uint32(), options, (message.root as any).combinePayload)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.FunctionSpec function_spec */ 4:
                    message.root = {
                        oneofKind: "functionSpec",
                        functionSpec: FunctionSpec.internalBinaryRead(reader, reader.uint32(), options, (message.root as any).functionSpec)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.ParDoPayload par_do_payload */ 6:
                    message.root = {
                        oneofKind: "parDoPayload",
                        parDoPayload: ParDoPayload.internalBinaryRead(reader, reader.uint32(), options, (message.root as any).parDoPayload)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.PTransform ptransform */ 7:
                    message.root = {
                        oneofKind: "ptransform",
                        ptransform: PTransform.internalBinaryRead(reader, reader.uint32(), options, (message.root as any).ptransform)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.PCollection pcollection */ 8:
                    message.root = {
                        oneofKind: "pcollection",
                        pcollection: PCollection.internalBinaryRead(reader, reader.uint32(), options, (message.root as any).pcollection)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.ReadPayload read_payload */ 9:
                    message.root = {
                        oneofKind: "readPayload",
                        readPayload: ReadPayload.internalBinaryRead(reader, reader.uint32(), options, (message.root as any).readPayload)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.SideInput side_input */ 11:
                    message.root = {
                        oneofKind: "sideInput",
                        sideInput: SideInput.internalBinaryRead(reader, reader.uint32(), options, (message.root as any).sideInput)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.WindowIntoPayload window_into_payload */ 12:
                    message.root = {
                        oneofKind: "windowIntoPayload",
                        windowIntoPayload: WindowIntoPayload.internalBinaryRead(reader, reader.uint32(), options, (message.root as any).windowIntoPayload)
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.WindowingStrategy windowing_strategy */ 13:
                    message.root = {
                        oneofKind: "windowingStrategy",
                        windowingStrategy: WindowingStrategy.internalBinaryRead(reader, reader.uint32(), options, (message.root as any).windowingStrategy)
                    };
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: MessageWithComponents, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.Components components = 1; */
        if (message.components)
            Components.internalBinaryWrite(message.components, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.Coder coder = 2; */
        if (message.root.oneofKind === "coder")
            Coder.internalBinaryWrite(message.root.coder, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.CombinePayload combine_payload = 3; */
        if (message.root.oneofKind === "combinePayload")
            CombinePayload.internalBinaryWrite(message.root.combinePayload, writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.FunctionSpec function_spec = 4; */
        if (message.root.oneofKind === "functionSpec")
            FunctionSpec.internalBinaryWrite(message.root.functionSpec, writer.tag(4, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.ParDoPayload par_do_payload = 6; */
        if (message.root.oneofKind === "parDoPayload")
            ParDoPayload.internalBinaryWrite(message.root.parDoPayload, writer.tag(6, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.PTransform ptransform = 7; */
        if (message.root.oneofKind === "ptransform")
            PTransform.internalBinaryWrite(message.root.ptransform, writer.tag(7, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.PCollection pcollection = 8; */
        if (message.root.oneofKind === "pcollection")
            PCollection.internalBinaryWrite(message.root.pcollection, writer.tag(8, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.ReadPayload read_payload = 9; */
        if (message.root.oneofKind === "readPayload")
            ReadPayload.internalBinaryWrite(message.root.readPayload, writer.tag(9, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.SideInput side_input = 11; */
        if (message.root.oneofKind === "sideInput")
            SideInput.internalBinaryWrite(message.root.sideInput, writer.tag(11, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.WindowIntoPayload window_into_payload = 12; */
        if (message.root.oneofKind === "windowIntoPayload")
            WindowIntoPayload.internalBinaryWrite(message.root.windowIntoPayload, writer.tag(12, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.WindowingStrategy windowing_strategy = 13; */
        if (message.root.oneofKind === "windowingStrategy")
            WindowingStrategy.internalBinaryWrite(message.root.windowingStrategy, writer.tag(13, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.MessageWithComponents
 */
export const MessageWithComponents = new MessageWithComponents$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ExecutableStagePayload$Type extends MessageType<ExecutableStagePayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.ExecutableStagePayload", [
            { no: 1, name: "environment", kind: "message", T: () => Environment },
            { no: 9, name: "wire_coder_settings", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => ExecutableStagePayload_WireCoderSetting },
            { no: 2, name: "input", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "side_inputs", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => ExecutableStagePayload_SideInputId },
            { no: 4, name: "transforms", kind: "scalar", repeat: 2 /*RepeatType.UNPACKED*/, T: 9 /*ScalarType.STRING*/ },
            { no: 5, name: "outputs", kind: "scalar", repeat: 2 /*RepeatType.UNPACKED*/, T: 9 /*ScalarType.STRING*/ },
            { no: 6, name: "components", kind: "message", T: () => Components },
            { no: 7, name: "user_states", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => ExecutableStagePayload_UserStateId },
            { no: 8, name: "timers", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => ExecutableStagePayload_TimerId },
            { no: 10, name: "timerFamilies", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => ExecutableStagePayload_TimerFamilyId }
        ]);
    }
    create(value?: PartialMessage<ExecutableStagePayload>): ExecutableStagePayload {
        const message = { wireCoderSettings: [], input: "", sideInputs: [], transforms: [], outputs: [], userStates: [], timers: [], timerFamilies: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ExecutableStagePayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ExecutableStagePayload): ExecutableStagePayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.Environment environment */ 1:
                    message.environment = Environment.internalBinaryRead(reader, reader.uint32(), options, message.environment);
                    break;
                case /* repeated org.apache.beam.model.pipeline.v1.ExecutableStagePayload.WireCoderSetting wire_coder_settings */ 9:
                    message.wireCoderSettings.push(ExecutableStagePayload_WireCoderSetting.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* string input */ 2:
                    message.input = reader.string();
                    break;
                case /* repeated org.apache.beam.model.pipeline.v1.ExecutableStagePayload.SideInputId side_inputs */ 3:
                    message.sideInputs.push(ExecutableStagePayload_SideInputId.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* repeated string transforms */ 4:
                    message.transforms.push(reader.string());
                    break;
                case /* repeated string outputs */ 5:
                    message.outputs.push(reader.string());
                    break;
                case /* org.apache.beam.model.pipeline.v1.Components components */ 6:
                    message.components = Components.internalBinaryRead(reader, reader.uint32(), options, message.components);
                    break;
                case /* repeated org.apache.beam.model.pipeline.v1.ExecutableStagePayload.UserStateId user_states */ 7:
                    message.userStates.push(ExecutableStagePayload_UserStateId.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* repeated org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerId timers */ 8:
                    message.timers.push(ExecutableStagePayload_TimerId.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* repeated org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerFamilyId timerFamilies */ 10:
                    message.timerFamilies.push(ExecutableStagePayload_TimerFamilyId.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ExecutableStagePayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.Environment environment = 1; */
        if (message.environment)
            Environment.internalBinaryWrite(message.environment, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* repeated org.apache.beam.model.pipeline.v1.ExecutableStagePayload.WireCoderSetting wire_coder_settings = 9; */
        for (let i = 0; i < message.wireCoderSettings.length; i++)
            ExecutableStagePayload_WireCoderSetting.internalBinaryWrite(message.wireCoderSettings[i], writer.tag(9, WireType.LengthDelimited).fork(), options).join();
        /* string input = 2; */
        if (message.input !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.input);
        /* repeated org.apache.beam.model.pipeline.v1.ExecutableStagePayload.SideInputId side_inputs = 3; */
        for (let i = 0; i < message.sideInputs.length; i++)
            ExecutableStagePayload_SideInputId.internalBinaryWrite(message.sideInputs[i], writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        /* repeated string transforms = 4; */
        for (let i = 0; i < message.transforms.length; i++)
            writer.tag(4, WireType.LengthDelimited).string(message.transforms[i]);
        /* repeated string outputs = 5; */
        for (let i = 0; i < message.outputs.length; i++)
            writer.tag(5, WireType.LengthDelimited).string(message.outputs[i]);
        /* org.apache.beam.model.pipeline.v1.Components components = 6; */
        if (message.components)
            Components.internalBinaryWrite(message.components, writer.tag(6, WireType.LengthDelimited).fork(), options).join();
        /* repeated org.apache.beam.model.pipeline.v1.ExecutableStagePayload.UserStateId user_states = 7; */
        for (let i = 0; i < message.userStates.length; i++)
            ExecutableStagePayload_UserStateId.internalBinaryWrite(message.userStates[i], writer.tag(7, WireType.LengthDelimited).fork(), options).join();
        /* repeated org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerId timers = 8; */
        for (let i = 0; i < message.timers.length; i++)
            ExecutableStagePayload_TimerId.internalBinaryWrite(message.timers[i], writer.tag(8, WireType.LengthDelimited).fork(), options).join();
        /* repeated org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerFamilyId timerFamilies = 10; */
        for (let i = 0; i < message.timerFamilies.length; i++)
            ExecutableStagePayload_TimerFamilyId.internalBinaryWrite(message.timerFamilies[i], writer.tag(10, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.ExecutableStagePayload
 */
export const ExecutableStagePayload = new ExecutableStagePayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ExecutableStagePayload_SideInputId$Type extends MessageType<ExecutableStagePayload_SideInputId> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.ExecutableStagePayload.SideInputId", [
            { no: 1, name: "transform_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "local_name", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<ExecutableStagePayload_SideInputId>): ExecutableStagePayload_SideInputId {
        const message = { transformId: "", localName: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ExecutableStagePayload_SideInputId>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ExecutableStagePayload_SideInputId): ExecutableStagePayload_SideInputId {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string transform_id */ 1:
                    message.transformId = reader.string();
                    break;
                case /* string local_name */ 2:
                    message.localName = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ExecutableStagePayload_SideInputId, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string transform_id = 1; */
        if (message.transformId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.transformId);
        /* string local_name = 2; */
        if (message.localName !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.localName);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.ExecutableStagePayload.SideInputId
 */
export const ExecutableStagePayload_SideInputId = new ExecutableStagePayload_SideInputId$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ExecutableStagePayload_UserStateId$Type extends MessageType<ExecutableStagePayload_UserStateId> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.ExecutableStagePayload.UserStateId", [
            { no: 1, name: "transform_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "local_name", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<ExecutableStagePayload_UserStateId>): ExecutableStagePayload_UserStateId {
        const message = { transformId: "", localName: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ExecutableStagePayload_UserStateId>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ExecutableStagePayload_UserStateId): ExecutableStagePayload_UserStateId {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string transform_id */ 1:
                    message.transformId = reader.string();
                    break;
                case /* string local_name */ 2:
                    message.localName = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ExecutableStagePayload_UserStateId, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string transform_id = 1; */
        if (message.transformId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.transformId);
        /* string local_name = 2; */
        if (message.localName !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.localName);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.ExecutableStagePayload.UserStateId
 */
export const ExecutableStagePayload_UserStateId = new ExecutableStagePayload_UserStateId$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ExecutableStagePayload_TimerId$Type extends MessageType<ExecutableStagePayload_TimerId> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerId", [
            { no: 1, name: "transform_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "local_name", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<ExecutableStagePayload_TimerId>): ExecutableStagePayload_TimerId {
        const message = { transformId: "", localName: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ExecutableStagePayload_TimerId>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ExecutableStagePayload_TimerId): ExecutableStagePayload_TimerId {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string transform_id */ 1:
                    message.transformId = reader.string();
                    break;
                case /* string local_name */ 2:
                    message.localName = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ExecutableStagePayload_TimerId, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string transform_id = 1; */
        if (message.transformId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.transformId);
        /* string local_name = 2; */
        if (message.localName !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.localName);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerId
 */
export const ExecutableStagePayload_TimerId = new ExecutableStagePayload_TimerId$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ExecutableStagePayload_TimerFamilyId$Type extends MessageType<ExecutableStagePayload_TimerFamilyId> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerFamilyId", [
            { no: 1, name: "transform_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "local_name", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<ExecutableStagePayload_TimerFamilyId>): ExecutableStagePayload_TimerFamilyId {
        const message = { transformId: "", localName: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ExecutableStagePayload_TimerFamilyId>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ExecutableStagePayload_TimerFamilyId): ExecutableStagePayload_TimerFamilyId {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string transform_id */ 1:
                    message.transformId = reader.string();
                    break;
                case /* string local_name */ 2:
                    message.localName = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ExecutableStagePayload_TimerFamilyId, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string transform_id = 1; */
        if (message.transformId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.transformId);
        /* string local_name = 2; */
        if (message.localName !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.localName);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerFamilyId
 */
export const ExecutableStagePayload_TimerFamilyId = new ExecutableStagePayload_TimerFamilyId$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ExecutableStagePayload_WireCoderSetting$Type extends MessageType<ExecutableStagePayload_WireCoderSetting> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.ExecutableStagePayload.WireCoderSetting", [
            { no: 1, name: "urn", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "payload", kind: "scalar", T: 12 /*ScalarType.BYTES*/ },
            { no: 3, name: "input_or_output_id", kind: "scalar", oneof: "target", T: 9 /*ScalarType.STRING*/ },
            { no: 4, name: "timer", kind: "message", oneof: "target", T: () => ExecutableStagePayload_TimerId }
        ]);
    }
    create(value?: PartialMessage<ExecutableStagePayload_WireCoderSetting>): ExecutableStagePayload_WireCoderSetting {
        const message = { urn: "", payload: new Uint8Array(0), target: { oneofKind: undefined } };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ExecutableStagePayload_WireCoderSetting>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ExecutableStagePayload_WireCoderSetting): ExecutableStagePayload_WireCoderSetting {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string urn */ 1:
                    message.urn = reader.string();
                    break;
                case /* bytes payload */ 2:
                    message.payload = reader.bytes();
                    break;
                case /* string input_or_output_id */ 3:
                    message.target = {
                        oneofKind: "inputOrOutputId",
                        inputOrOutputId: reader.string()
                    };
                    break;
                case /* org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerId timer */ 4:
                    message.target = {
                        oneofKind: "timer",
                        timer: ExecutableStagePayload_TimerId.internalBinaryRead(reader, reader.uint32(), options, (message.target as any).timer)
                    };
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ExecutableStagePayload_WireCoderSetting, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string urn = 1; */
        if (message.urn !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.urn);
        /* bytes payload = 2; */
        if (message.payload.length)
            writer.tag(2, WireType.LengthDelimited).bytes(message.payload);
        /* string input_or_output_id = 3; */
        if (message.target.oneofKind === "inputOrOutputId")
            writer.tag(3, WireType.LengthDelimited).string(message.target.inputOrOutputId);
        /* org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerId timer = 4; */
        if (message.target.oneofKind === "timer")
            ExecutableStagePayload_TimerId.internalBinaryWrite(message.target.timer, writer.tag(4, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.ExecutableStagePayload.WireCoderSetting
 */
export const ExecutableStagePayload_WireCoderSetting = new ExecutableStagePayload_WireCoderSetting$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StandardResourceHints$Type extends MessageType<StandardResourceHints> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.StandardResourceHints", []);
    }
    create(value?: PartialMessage<StandardResourceHints>): StandardResourceHints {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StandardResourceHints>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StandardResourceHints): StandardResourceHints {
        return target ?? this.create();
    }
    internalBinaryWrite(message: StandardResourceHints, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.StandardResourceHints
 */
export const StandardResourceHints = new StandardResourceHints$Type();
/**
 * @generated ServiceType for protobuf service org.apache.beam.model.pipeline.v1.TestStreamService
 */
export const TestStreamService = new ServiceType("org.apache.beam.model.pipeline.v1.TestStreamService", [
    { name: "Events", serverStreaming: true, options: {}, I: EventsRequest, O: TestStreamPayload_Event }
]);
