// Code generated by protoc-gen-go. DO NOT EDIT.
// source: beam_runner_api.proto

/*
Package pipeline_v1 is a generated protocol buffer package.

It is generated from these files:
	beam_runner_api.proto
	endpoints.proto
	standard_window_fns.proto

It has these top-level messages:
	Components
	MessageWithComponents
	Pipeline
	PTransform
	PCollection
	ParDoPayload
	Parameter
	StateSpec
	ValueStateSpec
	BagStateSpec
	CombiningStateSpec
	MapStateSpec
	SetStateSpec
	TimerSpec
	IsBounded
	ReadPayload
	WindowIntoPayload
	CombinePayload
	TestStreamPayload
	WriteFilesPayload
	Coder
	WindowingStrategy
	MergeStatus
	AccumulationMode
	ClosingBehavior
	OnTimeBehavior
	OutputTime
	TimeDomain
	Trigger
	TimestampTransform
	SideInput
	Environment
	SdkFunctionSpec
	FunctionSpec
	DisplayData
	ApiServiceDescriptor
	OAuth2ClientCredentialsGrant
	FixedWindowsPayload
	SlidingWindowsPayload
	SessionsPayload
*/
package pipeline_v1

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/any"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type Parameter_Type_Enum int32

const (
	Parameter_Type_UNSPECIFIED         Parameter_Type_Enum = 0
	Parameter_Type_WINDOW              Parameter_Type_Enum = 1
	Parameter_Type_PIPELINE_OPTIONS    Parameter_Type_Enum = 2
	Parameter_Type_RESTRICTION_TRACKER Parameter_Type_Enum = 3
)

var Parameter_Type_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "WINDOW",
	2: "PIPELINE_OPTIONS",
	3: "RESTRICTION_TRACKER",
}
var Parameter_Type_Enum_value = map[string]int32{
	"UNSPECIFIED":         0,
	"WINDOW":              1,
	"PIPELINE_OPTIONS":    2,
	"RESTRICTION_TRACKER": 3,
}

func (x Parameter_Type_Enum) String() string {
	return proto.EnumName(Parameter_Type_Enum_name, int32(x))
}
func (Parameter_Type_Enum) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{6, 0, 0} }

type IsBounded_Enum int32

const (
	IsBounded_UNSPECIFIED IsBounded_Enum = 0
	IsBounded_UNBOUNDED   IsBounded_Enum = 1
	IsBounded_BOUNDED     IsBounded_Enum = 2
)

var IsBounded_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "UNBOUNDED",
	2: "BOUNDED",
}
var IsBounded_Enum_value = map[string]int32{
	"UNSPECIFIED": 0,
	"UNBOUNDED":   1,
	"BOUNDED":     2,
}

func (x IsBounded_Enum) String() string {
	return proto.EnumName(IsBounded_Enum_name, int32(x))
}
func (IsBounded_Enum) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{14, 0} }

type MergeStatus_Enum int32

const (
	MergeStatus_UNSPECIFIED MergeStatus_Enum = 0
	// The WindowFn does not require merging.
	// Examples: global window, FixedWindows, SlidingWindows
	MergeStatus_NON_MERGING MergeStatus_Enum = 1
	// The WindowFn is merging and the PCollection has not had merging
	// performed.
	// Example: Sessions prior to a GroupByKey
	MergeStatus_NEEDS_MERGE MergeStatus_Enum = 2
	// The WindowFn is merging and the PCollection has had merging occur
	// already.
	// Example: Sessions after a GroupByKey
	MergeStatus_ALREADY_MERGED MergeStatus_Enum = 3
)

var MergeStatus_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "NON_MERGING",
	2: "NEEDS_MERGE",
	3: "ALREADY_MERGED",
}
var MergeStatus_Enum_value = map[string]int32{
	"UNSPECIFIED":    0,
	"NON_MERGING":    1,
	"NEEDS_MERGE":    2,
	"ALREADY_MERGED": 3,
}

func (x MergeStatus_Enum) String() string {
	return proto.EnumName(MergeStatus_Enum_name, int32(x))
}
func (MergeStatus_Enum) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{22, 0} }

type AccumulationMode_Enum int32

const (
	AccumulationMode_UNSPECIFIED AccumulationMode_Enum = 0
	// The aggregation is discarded when it is output
	AccumulationMode_DISCARDING AccumulationMode_Enum = 1
	// The aggregation is accumulated across outputs
	AccumulationMode_ACCUMULATING AccumulationMode_Enum = 2
)

var AccumulationMode_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "DISCARDING",
	2: "ACCUMULATING",
}
var AccumulationMode_Enum_value = map[string]int32{
	"UNSPECIFIED":  0,
	"DISCARDING":   1,
	"ACCUMULATING": 2,
}

func (x AccumulationMode_Enum) String() string {
	return proto.EnumName(AccumulationMode_Enum_name, int32(x))
}
func (AccumulationMode_Enum) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{23, 0} }

type ClosingBehavior_Enum int32

const (
	ClosingBehavior_UNSPECIFIED ClosingBehavior_Enum = 0
	// Emit output when a window expires, whether or not there has been
	// any new data since the last output.
	ClosingBehavior_EMIT_ALWAYS ClosingBehavior_Enum = 1
	// Only emit output when new data has arrives since the last output
	ClosingBehavior_EMIT_IF_NONEMPTY ClosingBehavior_Enum = 2
)

var ClosingBehavior_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "EMIT_ALWAYS",
	2: "EMIT_IF_NONEMPTY",
}
var ClosingBehavior_Enum_value = map[string]int32{
	"UNSPECIFIED":      0,
	"EMIT_ALWAYS":      1,
	"EMIT_IF_NONEMPTY": 2,
}

func (x ClosingBehavior_Enum) String() string {
	return proto.EnumName(ClosingBehavior_Enum_name, int32(x))
}
func (ClosingBehavior_Enum) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{24, 0} }

type OnTimeBehavior_Enum int32

const (
	OnTimeBehavior_UNSPECIFIED OnTimeBehavior_Enum = 0
	// Always fire the on-time pane. Even if there is no new data since
	// the previous firing, an element will be produced.
	OnTimeBehavior_FIRE_ALWAYS OnTimeBehavior_Enum = 1
	// Only fire the on-time pane if there is new data since the previous firing.
	OnTimeBehavior_FIRE_IF_NONEMPTY OnTimeBehavior_Enum = 2
)

var OnTimeBehavior_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "FIRE_ALWAYS",
	2: "FIRE_IF_NONEMPTY",
}
var OnTimeBehavior_Enum_value = map[string]int32{
	"UNSPECIFIED":      0,
	"FIRE_ALWAYS":      1,
	"FIRE_IF_NONEMPTY": 2,
}

func (x OnTimeBehavior_Enum) String() string {
	return proto.EnumName(OnTimeBehavior_Enum_name, int32(x))
}
func (OnTimeBehavior_Enum) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{25, 0} }

type OutputTime_Enum int32

const (
	OutputTime_UNSPECIFIED OutputTime_Enum = 0
	// The output has the timestamp of the end of the window.
	OutputTime_END_OF_WINDOW OutputTime_Enum = 1
	// The output has the latest timestamp of the input elements since
	// the last output.
	OutputTime_LATEST_IN_PANE OutputTime_Enum = 2
	// The output has the earliest timestamp of the input elements since
	// the last output.
	OutputTime_EARLIEST_IN_PANE OutputTime_Enum = 3
)

var OutputTime_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "END_OF_WINDOW",
	2: "LATEST_IN_PANE",
	3: "EARLIEST_IN_PANE",
}
var OutputTime_Enum_value = map[string]int32{
	"UNSPECIFIED":      0,
	"END_OF_WINDOW":    1,
	"LATEST_IN_PANE":   2,
	"EARLIEST_IN_PANE": 3,
}

func (x OutputTime_Enum) String() string {
	return proto.EnumName(OutputTime_Enum_name, int32(x))
}
func (OutputTime_Enum) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{26, 0} }

type TimeDomain_Enum int32

const (
	TimeDomain_UNSPECIFIED TimeDomain_Enum = 0
	// Event time is time from the perspective of the data
	TimeDomain_EVENT_TIME TimeDomain_Enum = 1
	// Processing time is time from the perspective of the
	// execution of your pipeline
	TimeDomain_PROCESSING_TIME TimeDomain_Enum = 2
	// Synchronized processing time is the minimum of the
	// processing time of all pending elements.
	//
	// The "processing time" of an element refers to
	// the local processing time at which it was emitted
	TimeDomain_SYNCHRONIZED_PROCESSING_TIME TimeDomain_Enum = 3
)

var TimeDomain_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "EVENT_TIME",
	2: "PROCESSING_TIME",
	3: "SYNCHRONIZED_PROCESSING_TIME",
}
var TimeDomain_Enum_value = map[string]int32{
	"UNSPECIFIED":                  0,
	"EVENT_TIME":                   1,
	"PROCESSING_TIME":              2,
	"SYNCHRONIZED_PROCESSING_TIME": 3,
}

func (x TimeDomain_Enum) String() string {
	return proto.EnumName(TimeDomain_Enum_name, int32(x))
}
func (TimeDomain_Enum) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{27, 0} }

type DisplayData_Type_Enum int32

const (
	DisplayData_Type_UNSPECIFIED DisplayData_Type_Enum = 0
	DisplayData_Type_STRING      DisplayData_Type_Enum = 1
	DisplayData_Type_INTEGER     DisplayData_Type_Enum = 2
	DisplayData_Type_FLOAT       DisplayData_Type_Enum = 3
	DisplayData_Type_BOOLEAN     DisplayData_Type_Enum = 4
	DisplayData_Type_TIMESTAMP   DisplayData_Type_Enum = 5
	DisplayData_Type_DURATION    DisplayData_Type_Enum = 6
	DisplayData_Type_JAVA_CLASS  DisplayData_Type_Enum = 7
)

var DisplayData_Type_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "STRING",
	2: "INTEGER",
	3: "FLOAT",
	4: "BOOLEAN",
	5: "TIMESTAMP",
	6: "DURATION",
	7: "JAVA_CLASS",
}
var DisplayData_Type_Enum_value = map[string]int32{
	"UNSPECIFIED": 0,
	"STRING":      1,
	"INTEGER":     2,
	"FLOAT":       3,
	"BOOLEAN":     4,
	"TIMESTAMP":   5,
	"DURATION":    6,
	"JAVA_CLASS":  7,
}

func (x DisplayData_Type_Enum) String() string {
	return proto.EnumName(DisplayData_Type_Enum_name, int32(x))
}
func (DisplayData_Type_Enum) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{34, 2, 0} }

// A set of mappings from id to message. This is included as an optional field
// on any proto message that may contain references needing resolution.
type Components struct {
	// (Required) A map from pipeline-scoped id to PTransform.
	Transforms map[string]*PTransform `protobuf:"bytes,1,rep,name=transforms" json:"transforms,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// (Required) A map from pipeline-scoped id to PCollection.
	Pcollections map[string]*PCollection `protobuf:"bytes,2,rep,name=pcollections" json:"pcollections,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// (Required) A map from pipeline-scoped id to WindowingStrategy.
	WindowingStrategies map[string]*WindowingStrategy `protobuf:"bytes,3,rep,name=windowing_strategies,json=windowingStrategies" json:"windowing_strategies,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// (Required) A map from pipeline-scoped id to Coder.
	Coders map[string]*Coder `protobuf:"bytes,4,rep,name=coders" json:"coders,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// (Required) A map from pipeline-scoped id to Environment.
	Environments map[string]*Environment `protobuf:"bytes,5,rep,name=environments" json:"environments,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Components) Reset()                    { *m = Components{} }
func (m *Components) String() string            { return proto.CompactTextString(m) }
func (*Components) ProtoMessage()               {}
func (*Components) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Components) GetTransforms() map[string]*PTransform {
	if m != nil {
		return m.Transforms
	}
	return nil
}

func (m *Components) GetPcollections() map[string]*PCollection {
	if m != nil {
		return m.Pcollections
	}
	return nil
}

func (m *Components) GetWindowingStrategies() map[string]*WindowingStrategy {
	if m != nil {
		return m.WindowingStrategies
	}
	return nil
}

func (m *Components) GetCoders() map[string]*Coder {
	if m != nil {
		return m.Coders
	}
	return nil
}

func (m *Components) GetEnvironments() map[string]*Environment {
	if m != nil {
		return m.Environments
	}
	return nil
}

// A disjoint union of all the things that may contain references
// that require Components to resolve.
type MessageWithComponents struct {
	// (Optional) The by-reference components of the root message,
	// enabling a standalone message.
	//
	// If this is absent, it is expected that there are no
	// references.
	Components *Components `protobuf:"bytes,1,opt,name=components" json:"components,omitempty"`
	// (Required) The root message that may contain pointers
	// that should be resolved by looking inside components.
	//
	// Types that are valid to be assigned to Root:
	//	*MessageWithComponents_Coder
	//	*MessageWithComponents_CombinePayload
	//	*MessageWithComponents_SdkFunctionSpec
	//	*MessageWithComponents_ParDoPayload
	//	*MessageWithComponents_Ptransform
	//	*MessageWithComponents_Pcollection
	//	*MessageWithComponents_ReadPayload
	//	*MessageWithComponents_SideInput
	//	*MessageWithComponents_WindowIntoPayload
	//	*MessageWithComponents_WindowingStrategy
	//	*MessageWithComponents_FunctionSpec
	Root isMessageWithComponents_Root `protobuf_oneof:"root"`
}

func (m *MessageWithComponents) Reset()                    { *m = MessageWithComponents{} }
func (m *MessageWithComponents) String() string            { return proto.CompactTextString(m) }
func (*MessageWithComponents) ProtoMessage()               {}
func (*MessageWithComponents) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type isMessageWithComponents_Root interface {
	isMessageWithComponents_Root()
}

type MessageWithComponents_Coder struct {
	Coder *Coder `protobuf:"bytes,2,opt,name=coder,oneof"`
}
type MessageWithComponents_CombinePayload struct {
	CombinePayload *CombinePayload `protobuf:"bytes,3,opt,name=combine_payload,json=combinePayload,oneof"`
}
type MessageWithComponents_SdkFunctionSpec struct {
	SdkFunctionSpec *SdkFunctionSpec `protobuf:"bytes,4,opt,name=sdk_function_spec,json=sdkFunctionSpec,oneof"`
}
type MessageWithComponents_ParDoPayload struct {
	ParDoPayload *ParDoPayload `protobuf:"bytes,6,opt,name=par_do_payload,json=parDoPayload,oneof"`
}
type MessageWithComponents_Ptransform struct {
	Ptransform *PTransform `protobuf:"bytes,7,opt,name=ptransform,oneof"`
}
type MessageWithComponents_Pcollection struct {
	Pcollection *PCollection `protobuf:"bytes,8,opt,name=pcollection,oneof"`
}
type MessageWithComponents_ReadPayload struct {
	ReadPayload *ReadPayload `protobuf:"bytes,9,opt,name=read_payload,json=readPayload,oneof"`
}
type MessageWithComponents_SideInput struct {
	SideInput *SideInput `protobuf:"bytes,11,opt,name=side_input,json=sideInput,oneof"`
}
type MessageWithComponents_WindowIntoPayload struct {
	WindowIntoPayload *WindowIntoPayload `protobuf:"bytes,12,opt,name=window_into_payload,json=windowIntoPayload,oneof"`
}
type MessageWithComponents_WindowingStrategy struct {
	WindowingStrategy *WindowingStrategy `protobuf:"bytes,13,opt,name=windowing_strategy,json=windowingStrategy,oneof"`
}
type MessageWithComponents_FunctionSpec struct {
	FunctionSpec *FunctionSpec `protobuf:"bytes,14,opt,name=function_spec,json=functionSpec,oneof"`
}

func (*MessageWithComponents_Coder) isMessageWithComponents_Root()             {}
func (*MessageWithComponents_CombinePayload) isMessageWithComponents_Root()    {}
func (*MessageWithComponents_SdkFunctionSpec) isMessageWithComponents_Root()   {}
func (*MessageWithComponents_ParDoPayload) isMessageWithComponents_Root()      {}
func (*MessageWithComponents_Ptransform) isMessageWithComponents_Root()        {}
func (*MessageWithComponents_Pcollection) isMessageWithComponents_Root()       {}
func (*MessageWithComponents_ReadPayload) isMessageWithComponents_Root()       {}
func (*MessageWithComponents_SideInput) isMessageWithComponents_Root()         {}
func (*MessageWithComponents_WindowIntoPayload) isMessageWithComponents_Root() {}
func (*MessageWithComponents_WindowingStrategy) isMessageWithComponents_Root() {}
func (*MessageWithComponents_FunctionSpec) isMessageWithComponents_Root()      {}

func (m *MessageWithComponents) GetRoot() isMessageWithComponents_Root {
	if m != nil {
		return m.Root
	}
	return nil
}

func (m *MessageWithComponents) GetComponents() *Components {
	if m != nil {
		return m.Components
	}
	return nil
}

func (m *MessageWithComponents) GetCoder() *Coder {
	if x, ok := m.GetRoot().(*MessageWithComponents_Coder); ok {
		return x.Coder
	}
	return nil
}

func (m *MessageWithComponents) GetCombinePayload() *CombinePayload {
	if x, ok := m.GetRoot().(*MessageWithComponents_CombinePayload); ok {
		return x.CombinePayload
	}
	return nil
}

func (m *MessageWithComponents) GetSdkFunctionSpec() *SdkFunctionSpec {
	if x, ok := m.GetRoot().(*MessageWithComponents_SdkFunctionSpec); ok {
		return x.SdkFunctionSpec
	}
	return nil
}

func (m *MessageWithComponents) GetParDoPayload() *ParDoPayload {
	if x, ok := m.GetRoot().(*MessageWithComponents_ParDoPayload); ok {
		return x.ParDoPayload
	}
	return nil
}

func (m *MessageWithComponents) GetPtransform() *PTransform {
	if x, ok := m.GetRoot().(*MessageWithComponents_Ptransform); ok {
		return x.Ptransform
	}
	return nil
}

func (m *MessageWithComponents) GetPcollection() *PCollection {
	if x, ok := m.GetRoot().(*MessageWithComponents_Pcollection); ok {
		return x.Pcollection
	}
	return nil
}

func (m *MessageWithComponents) GetReadPayload() *ReadPayload {
	if x, ok := m.GetRoot().(*MessageWithComponents_ReadPayload); ok {
		return x.ReadPayload
	}
	return nil
}

func (m *MessageWithComponents) GetSideInput() *SideInput {
	if x, ok := m.GetRoot().(*MessageWithComponents_SideInput); ok {
		return x.SideInput
	}
	return nil
}

func (m *MessageWithComponents) GetWindowIntoPayload() *WindowIntoPayload {
	if x, ok := m.GetRoot().(*MessageWithComponents_WindowIntoPayload); ok {
		return x.WindowIntoPayload
	}
	return nil
}

func (m *MessageWithComponents) GetWindowingStrategy() *WindowingStrategy {
	if x, ok := m.GetRoot().(*MessageWithComponents_WindowingStrategy); ok {
		return x.WindowingStrategy
	}
	return nil
}

func (m *MessageWithComponents) GetFunctionSpec() *FunctionSpec {
	if x, ok := m.GetRoot().(*MessageWithComponents_FunctionSpec); ok {
		return x.FunctionSpec
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*MessageWithComponents) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _MessageWithComponents_OneofMarshaler, _MessageWithComponents_OneofUnmarshaler, _MessageWithComponents_OneofSizer, []interface{}{
		(*MessageWithComponents_Coder)(nil),
		(*MessageWithComponents_CombinePayload)(nil),
		(*MessageWithComponents_SdkFunctionSpec)(nil),
		(*MessageWithComponents_ParDoPayload)(nil),
		(*MessageWithComponents_Ptransform)(nil),
		(*MessageWithComponents_Pcollection)(nil),
		(*MessageWithComponents_ReadPayload)(nil),
		(*MessageWithComponents_SideInput)(nil),
		(*MessageWithComponents_WindowIntoPayload)(nil),
		(*MessageWithComponents_WindowingStrategy)(nil),
		(*MessageWithComponents_FunctionSpec)(nil),
	}
}

func _MessageWithComponents_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*MessageWithComponents)
	// root
	switch x := m.Root.(type) {
	case *MessageWithComponents_Coder:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Coder); err != nil {
			return err
		}
	case *MessageWithComponents_CombinePayload:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CombinePayload); err != nil {
			return err
		}
	case *MessageWithComponents_SdkFunctionSpec:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SdkFunctionSpec); err != nil {
			return err
		}
	case *MessageWithComponents_ParDoPayload:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ParDoPayload); err != nil {
			return err
		}
	case *MessageWithComponents_Ptransform:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Ptransform); err != nil {
			return err
		}
	case *MessageWithComponents_Pcollection:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Pcollection); err != nil {
			return err
		}
	case *MessageWithComponents_ReadPayload:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ReadPayload); err != nil {
			return err
		}
	case *MessageWithComponents_SideInput:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SideInput); err != nil {
			return err
		}
	case *MessageWithComponents_WindowIntoPayload:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.WindowIntoPayload); err != nil {
			return err
		}
	case *MessageWithComponents_WindowingStrategy:
		b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.WindowingStrategy); err != nil {
			return err
		}
	case *MessageWithComponents_FunctionSpec:
		b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.FunctionSpec); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("MessageWithComponents.Root has unexpected type %T", x)
	}
	return nil
}

func _MessageWithComponents_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*MessageWithComponents)
	switch tag {
	case 2: // root.coder
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Coder)
		err := b.DecodeMessage(msg)
		m.Root = &MessageWithComponents_Coder{msg}
		return true, err
	case 3: // root.combine_payload
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CombinePayload)
		err := b.DecodeMessage(msg)
		m.Root = &MessageWithComponents_CombinePayload{msg}
		return true, err
	case 4: // root.sdk_function_spec
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdkFunctionSpec)
		err := b.DecodeMessage(msg)
		m.Root = &MessageWithComponents_SdkFunctionSpec{msg}
		return true, err
	case 6: // root.par_do_payload
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ParDoPayload)
		err := b.DecodeMessage(msg)
		m.Root = &MessageWithComponents_ParDoPayload{msg}
		return true, err
	case 7: // root.ptransform
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PTransform)
		err := b.DecodeMessage(msg)
		m.Root = &MessageWithComponents_Ptransform{msg}
		return true, err
	case 8: // root.pcollection
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PCollection)
		err := b.DecodeMessage(msg)
		m.Root = &MessageWithComponents_Pcollection{msg}
		return true, err
	case 9: // root.read_payload
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ReadPayload)
		err := b.DecodeMessage(msg)
		m.Root = &MessageWithComponents_ReadPayload{msg}
		return true, err
	case 11: // root.side_input
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SideInput)
		err := b.DecodeMessage(msg)
		m.Root = &MessageWithComponents_SideInput{msg}
		return true, err
	case 12: // root.window_into_payload
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(WindowIntoPayload)
		err := b.DecodeMessage(msg)
		m.Root = &MessageWithComponents_WindowIntoPayload{msg}
		return true, err
	case 13: // root.windowing_strategy
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(WindowingStrategy)
		err := b.DecodeMessage(msg)
		m.Root = &MessageWithComponents_WindowingStrategy{msg}
		return true, err
	case 14: // root.function_spec
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(FunctionSpec)
		err := b.DecodeMessage(msg)
		m.Root = &MessageWithComponents_FunctionSpec{msg}
		return true, err
	default:
		return false, nil
	}
}

func _MessageWithComponents_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*MessageWithComponents)
	// root
	switch x := m.Root.(type) {
	case *MessageWithComponents_Coder:
		s := proto.Size(x.Coder)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MessageWithComponents_CombinePayload:
		s := proto.Size(x.CombinePayload)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MessageWithComponents_SdkFunctionSpec:
		s := proto.Size(x.SdkFunctionSpec)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MessageWithComponents_ParDoPayload:
		s := proto.Size(x.ParDoPayload)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MessageWithComponents_Ptransform:
		s := proto.Size(x.Ptransform)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MessageWithComponents_Pcollection:
		s := proto.Size(x.Pcollection)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MessageWithComponents_ReadPayload:
		s := proto.Size(x.ReadPayload)
		n += proto.SizeVarint(9<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MessageWithComponents_SideInput:
		s := proto.Size(x.SideInput)
		n += proto.SizeVarint(11<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MessageWithComponents_WindowIntoPayload:
		s := proto.Size(x.WindowIntoPayload)
		n += proto.SizeVarint(12<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MessageWithComponents_WindowingStrategy:
		s := proto.Size(x.WindowingStrategy)
		n += proto.SizeVarint(13<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MessageWithComponents_FunctionSpec:
		s := proto.Size(x.FunctionSpec)
		n += proto.SizeVarint(14<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A Pipeline is a hierarchical graph of PTransforms, linked
// by PCollections.
//
// This is represented by a number of by-reference maps to nodes,
// PCollections, SDK environments, UDF, etc., for
// supporting compact reuse and arbitrary graph structure.
//
// All of the keys in the maps here are arbitrary strings that are only
// required to be internally consistent within this proto message.
type Pipeline struct {
	// (Required) The coders, UDFs, graph nodes, etc, that make up
	// this pipeline.
	Components *Components `protobuf:"bytes,1,opt,name=components" json:"components,omitempty"`
	// (Required) The ids of all PTransforms that are not contained within another PTransform.
	// These must be in shallow topological order, so that traversing them recursively
	// in this order yields a recursively topological traversal.
	RootTransformIds []string `protobuf:"bytes,2,rep,name=root_transform_ids,json=rootTransformIds" json:"root_transform_ids,omitempty"`
	// (Optional) Static display data for the pipeline. If there is none,
	// it may be omitted.
	DisplayData *DisplayData `protobuf:"bytes,3,opt,name=display_data,json=displayData" json:"display_data,omitempty"`
}

func (m *Pipeline) Reset()                    { *m = Pipeline{} }
func (m *Pipeline) String() string            { return proto.CompactTextString(m) }
func (*Pipeline) ProtoMessage()               {}
func (*Pipeline) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Pipeline) GetComponents() *Components {
	if m != nil {
		return m.Components
	}
	return nil
}

func (m *Pipeline) GetRootTransformIds() []string {
	if m != nil {
		return m.RootTransformIds
	}
	return nil
}

func (m *Pipeline) GetDisplayData() *DisplayData {
	if m != nil {
		return m.DisplayData
	}
	return nil
}

// An applied PTransform! This does not contain the graph data, but only the
// fields specific to a graph node that is a Runner API transform
// between PCollections.
type PTransform struct {
	// (Required) A unique name for the application node.
	//
	// Ideally, this should be stable over multiple evolutions of a pipeline
	// for the purposes of logging and associating pipeline state with a node,
	// etc.
	//
	// If it is not stable, then the runner decides what will happen. But, most
	// importantly, it must always be here and be unique, even if it is
	// autogenerated.
	UniqueName string `protobuf:"bytes,5,opt,name=unique_name,json=uniqueName" json:"unique_name,omitempty"`
	// (Optional) A URN and payload that, together, fully defined the semantics
	// of this transform.
	//
	// If absent, this must be an "anonymous" composite transform.
	//
	// For primitive transform in the Runner API, this is required, and the
	// payloads are well-defined messages. When the URN indicates ParDo it
	// is a ParDoPayload, and so on.
	//
	// TODO: document the standardized URNs and payloads
	// TODO: separate standardized payloads into a separate proto file
	//
	// For some special composite transforms, the payload is also officially
	// defined:
	//
	//  - when the URN is "urn:beam:transforms:combine" it is a CombinePayload
	//
	Spec *FunctionSpec `protobuf:"bytes,1,opt,name=spec" json:"spec,omitempty"`
	// (Optional) if this node is a composite, a list of the ids of
	// transforms that it contains.
	Subtransforms []string `protobuf:"bytes,2,rep,name=subtransforms" json:"subtransforms,omitempty"`
	// (Required) A map from local names of inputs (unique only with this map, and
	// likely embedded in the transform payload and serialized user code) to
	// PCollection ids.
	//
	// The payload for this transform may clarify the relationship of these
	// inputs. For example:
	//
	//  - for a Flatten transform they are merged
	//  - for a ParDo transform, some may be side inputs
	//
	// All inputs are recorded here so that the topological ordering of
	// the graph is consistent whether or not the payload is understood.
	//
	Inputs map[string]string `protobuf:"bytes,3,rep,name=inputs" json:"inputs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// (Required) A map from local names of outputs (unique only within this map,
	// and likely embedded in the transform payload and serialized user code)
	// to PCollection ids.
	//
	// The URN or payload for this transform node may clarify the type and
	// relationship of these outputs. For example:
	//
	//  - for a ParDo transform, these are tags on PCollections, which will be
	//    embedded in the DoFn.
	//
	Outputs map[string]string `protobuf:"bytes,4,rep,name=outputs" json:"outputs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// (Optional) Static display data for this PTransform application. If
	// there is none, or it is not relevant (such as use by the Fn API)
	// then it may be omitted.
	DisplayData *DisplayData `protobuf:"bytes,6,opt,name=display_data,json=displayData" json:"display_data,omitempty"`
}

func (m *PTransform) Reset()                    { *m = PTransform{} }
func (m *PTransform) String() string            { return proto.CompactTextString(m) }
func (*PTransform) ProtoMessage()               {}
func (*PTransform) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *PTransform) GetUniqueName() string {
	if m != nil {
		return m.UniqueName
	}
	return ""
}

func (m *PTransform) GetSpec() *FunctionSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *PTransform) GetSubtransforms() []string {
	if m != nil {
		return m.Subtransforms
	}
	return nil
}

func (m *PTransform) GetInputs() map[string]string {
	if m != nil {
		return m.Inputs
	}
	return nil
}

func (m *PTransform) GetOutputs() map[string]string {
	if m != nil {
		return m.Outputs
	}
	return nil
}

func (m *PTransform) GetDisplayData() *DisplayData {
	if m != nil {
		return m.DisplayData
	}
	return nil
}

// A PCollection!
type PCollection struct {
	// (Required) A unique name for the PCollection.
	//
	// Ideally, this should be stable over multiple evolutions of a pipeline
	// for the purposes of logging and associating pipeline state with a node,
	// etc.
	//
	// If it is not stable, then the runner decides what will happen. But, most
	// importantly, it must always be here, even if it is autogenerated.
	UniqueName string `protobuf:"bytes,1,opt,name=unique_name,json=uniqueName" json:"unique_name,omitempty"`
	// (Required) The id of the Coder for this PCollection.
	CoderId string `protobuf:"bytes,2,opt,name=coder_id,json=coderId" json:"coder_id,omitempty"`
	// (Required) Whether this PCollection is bounded or unbounded
	IsBounded IsBounded_Enum `protobuf:"varint,3,opt,name=is_bounded,json=isBounded,enum=org.apache.beam.model.pipeline.v1.IsBounded_Enum" json:"is_bounded,omitempty"`
	// (Required) The id of the windowing strategy for this PCollection.
	WindowingStrategyId string `protobuf:"bytes,4,opt,name=windowing_strategy_id,json=windowingStrategyId" json:"windowing_strategy_id,omitempty"`
	// (Optional) Static display data for this PTransform application. If
	// there is none, or it is not relevant (such as use by the Fn API)
	// then it may be omitted.
	DisplayData *DisplayData `protobuf:"bytes,5,opt,name=display_data,json=displayData" json:"display_data,omitempty"`
}

func (m *PCollection) Reset()                    { *m = PCollection{} }
func (m *PCollection) String() string            { return proto.CompactTextString(m) }
func (*PCollection) ProtoMessage()               {}
func (*PCollection) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *PCollection) GetUniqueName() string {
	if m != nil {
		return m.UniqueName
	}
	return ""
}

func (m *PCollection) GetCoderId() string {
	if m != nil {
		return m.CoderId
	}
	return ""
}

func (m *PCollection) GetIsBounded() IsBounded_Enum {
	if m != nil {
		return m.IsBounded
	}
	return IsBounded_UNSPECIFIED
}

func (m *PCollection) GetWindowingStrategyId() string {
	if m != nil {
		return m.WindowingStrategyId
	}
	return ""
}

func (m *PCollection) GetDisplayData() *DisplayData {
	if m != nil {
		return m.DisplayData
	}
	return nil
}

// The payload for the primitive ParDo transform.
type ParDoPayload struct {
	// (Required) The SdkFunctionSpec of the DoFn.
	DoFn *SdkFunctionSpec `protobuf:"bytes,1,opt,name=do_fn,json=doFn" json:"do_fn,omitempty"`
	// (Required) Additional pieces of context the DoFn may require that
	// are not otherwise represented in the payload.
	// (may force runners to execute the ParDo differently)
	Parameters []*Parameter `protobuf:"bytes,2,rep,name=parameters" json:"parameters,omitempty"`
	// (Optional) A mapping of local input names to side inputs, describing
	// the expected access pattern.
	SideInputs map[string]*SideInput `protobuf:"bytes,3,rep,name=side_inputs,json=sideInputs" json:"side_inputs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// (Optional) A mapping of local state names to state specifications.
	StateSpecs map[string]*StateSpec `protobuf:"bytes,4,rep,name=state_specs,json=stateSpecs" json:"state_specs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// (Optional) A mapping of local timer names to timer specifications.
	TimerSpecs map[string]*TimerSpec `protobuf:"bytes,5,rep,name=timer_specs,json=timerSpecs" json:"timer_specs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Whether the DoFn is splittable
	Splittable bool `protobuf:"varint,6,opt,name=splittable" json:"splittable,omitempty"`
}

func (m *ParDoPayload) Reset()                    { *m = ParDoPayload{} }
func (m *ParDoPayload) String() string            { return proto.CompactTextString(m) }
func (*ParDoPayload) ProtoMessage()               {}
func (*ParDoPayload) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *ParDoPayload) GetDoFn() *SdkFunctionSpec {
	if m != nil {
		return m.DoFn
	}
	return nil
}

func (m *ParDoPayload) GetParameters() []*Parameter {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *ParDoPayload) GetSideInputs() map[string]*SideInput {
	if m != nil {
		return m.SideInputs
	}
	return nil
}

func (m *ParDoPayload) GetStateSpecs() map[string]*StateSpec {
	if m != nil {
		return m.StateSpecs
	}
	return nil
}

func (m *ParDoPayload) GetTimerSpecs() map[string]*TimerSpec {
	if m != nil {
		return m.TimerSpecs
	}
	return nil
}

func (m *ParDoPayload) GetSplittable() bool {
	if m != nil {
		return m.Splittable
	}
	return false
}

// Parameters that a UDF might require.
//
// The details of how a runner sends these parameters to the SDK harness
// are the subject of the Fn API.
//
// The details of how an SDK harness delivers them to the UDF is entirely
// up to the SDK. (for some SDKs there may be parameters that are not
// represented here if the runner doesn't need to do anything)
//
// Here, the parameters are simply indicators to the runner that they
// need to run the function a particular way.
//
// TODO: the evolution of the Fn API will influence what needs explicit
// representation here
type Parameter struct {
	Type Parameter_Type_Enum `protobuf:"varint,1,opt,name=type,enum=org.apache.beam.model.pipeline.v1.Parameter_Type_Enum" json:"type,omitempty"`
}

func (m *Parameter) Reset()                    { *m = Parameter{} }
func (m *Parameter) String() string            { return proto.CompactTextString(m) }
func (*Parameter) ProtoMessage()               {}
func (*Parameter) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *Parameter) GetType() Parameter_Type_Enum {
	if m != nil {
		return m.Type
	}
	return Parameter_Type_UNSPECIFIED
}

type Parameter_Type struct {
}

func (m *Parameter_Type) Reset()                    { *m = Parameter_Type{} }
func (m *Parameter_Type) String() string            { return proto.CompactTextString(m) }
func (*Parameter_Type) ProtoMessage()               {}
func (*Parameter_Type) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6, 0} }

type StateSpec struct {
	// Types that are valid to be assigned to Spec:
	//	*StateSpec_ValueSpec
	//	*StateSpec_BagSpec
	//	*StateSpec_CombiningSpec
	//	*StateSpec_MapSpec
	//	*StateSpec_SetSpec
	Spec isStateSpec_Spec `protobuf_oneof:"spec"`
}

func (m *StateSpec) Reset()                    { *m = StateSpec{} }
func (m *StateSpec) String() string            { return proto.CompactTextString(m) }
func (*StateSpec) ProtoMessage()               {}
func (*StateSpec) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type isStateSpec_Spec interface {
	isStateSpec_Spec()
}

type StateSpec_ValueSpec struct {
	ValueSpec *ValueStateSpec `protobuf:"bytes,1,opt,name=value_spec,json=valueSpec,oneof"`
}
type StateSpec_BagSpec struct {
	BagSpec *BagStateSpec `protobuf:"bytes,2,opt,name=bag_spec,json=bagSpec,oneof"`
}
type StateSpec_CombiningSpec struct {
	CombiningSpec *CombiningStateSpec `protobuf:"bytes,3,opt,name=combining_spec,json=combiningSpec,oneof"`
}
type StateSpec_MapSpec struct {
	MapSpec *MapStateSpec `protobuf:"bytes,4,opt,name=map_spec,json=mapSpec,oneof"`
}
type StateSpec_SetSpec struct {
	SetSpec *SetStateSpec `protobuf:"bytes,5,opt,name=set_spec,json=setSpec,oneof"`
}

func (*StateSpec_ValueSpec) isStateSpec_Spec()     {}
func (*StateSpec_BagSpec) isStateSpec_Spec()       {}
func (*StateSpec_CombiningSpec) isStateSpec_Spec() {}
func (*StateSpec_MapSpec) isStateSpec_Spec()       {}
func (*StateSpec_SetSpec) isStateSpec_Spec()       {}

func (m *StateSpec) GetSpec() isStateSpec_Spec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *StateSpec) GetValueSpec() *ValueStateSpec {
	if x, ok := m.GetSpec().(*StateSpec_ValueSpec); ok {
		return x.ValueSpec
	}
	return nil
}

func (m *StateSpec) GetBagSpec() *BagStateSpec {
	if x, ok := m.GetSpec().(*StateSpec_BagSpec); ok {
		return x.BagSpec
	}
	return nil
}

func (m *StateSpec) GetCombiningSpec() *CombiningStateSpec {
	if x, ok := m.GetSpec().(*StateSpec_CombiningSpec); ok {
		return x.CombiningSpec
	}
	return nil
}

func (m *StateSpec) GetMapSpec() *MapStateSpec {
	if x, ok := m.GetSpec().(*StateSpec_MapSpec); ok {
		return x.MapSpec
	}
	return nil
}

func (m *StateSpec) GetSetSpec() *SetStateSpec {
	if x, ok := m.GetSpec().(*StateSpec_SetSpec); ok {
		return x.SetSpec
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StateSpec) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StateSpec_OneofMarshaler, _StateSpec_OneofUnmarshaler, _StateSpec_OneofSizer, []interface{}{
		(*StateSpec_ValueSpec)(nil),
		(*StateSpec_BagSpec)(nil),
		(*StateSpec_CombiningSpec)(nil),
		(*StateSpec_MapSpec)(nil),
		(*StateSpec_SetSpec)(nil),
	}
}

func _StateSpec_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StateSpec)
	// spec
	switch x := m.Spec.(type) {
	case *StateSpec_ValueSpec:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ValueSpec); err != nil {
			return err
		}
	case *StateSpec_BagSpec:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BagSpec); err != nil {
			return err
		}
	case *StateSpec_CombiningSpec:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CombiningSpec); err != nil {
			return err
		}
	case *StateSpec_MapSpec:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MapSpec); err != nil {
			return err
		}
	case *StateSpec_SetSpec:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SetSpec); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StateSpec.Spec has unexpected type %T", x)
	}
	return nil
}

func _StateSpec_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StateSpec)
	switch tag {
	case 1: // spec.value_spec
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ValueStateSpec)
		err := b.DecodeMessage(msg)
		m.Spec = &StateSpec_ValueSpec{msg}
		return true, err
	case 2: // spec.bag_spec
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BagStateSpec)
		err := b.DecodeMessage(msg)
		m.Spec = &StateSpec_BagSpec{msg}
		return true, err
	case 3: // spec.combining_spec
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CombiningStateSpec)
		err := b.DecodeMessage(msg)
		m.Spec = &StateSpec_CombiningSpec{msg}
		return true, err
	case 4: // spec.map_spec
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MapStateSpec)
		err := b.DecodeMessage(msg)
		m.Spec = &StateSpec_MapSpec{msg}
		return true, err
	case 5: // spec.set_spec
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SetStateSpec)
		err := b.DecodeMessage(msg)
		m.Spec = &StateSpec_SetSpec{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StateSpec_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StateSpec)
	// spec
	switch x := m.Spec.(type) {
	case *StateSpec_ValueSpec:
		s := proto.Size(x.ValueSpec)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateSpec_BagSpec:
		s := proto.Size(x.BagSpec)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateSpec_CombiningSpec:
		s := proto.Size(x.CombiningSpec)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateSpec_MapSpec:
		s := proto.Size(x.MapSpec)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateSpec_SetSpec:
		s := proto.Size(x.SetSpec)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type ValueStateSpec struct {
	CoderId string `protobuf:"bytes,1,opt,name=coder_id,json=coderId" json:"coder_id,omitempty"`
}

func (m *ValueStateSpec) Reset()                    { *m = ValueStateSpec{} }
func (m *ValueStateSpec) String() string            { return proto.CompactTextString(m) }
func (*ValueStateSpec) ProtoMessage()               {}
func (*ValueStateSpec) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *ValueStateSpec) GetCoderId() string {
	if m != nil {
		return m.CoderId
	}
	return ""
}

type BagStateSpec struct {
	ElementCoderId string `protobuf:"bytes,1,opt,name=element_coder_id,json=elementCoderId" json:"element_coder_id,omitempty"`
}

func (m *BagStateSpec) Reset()                    { *m = BagStateSpec{} }
func (m *BagStateSpec) String() string            { return proto.CompactTextString(m) }
func (*BagStateSpec) ProtoMessage()               {}
func (*BagStateSpec) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *BagStateSpec) GetElementCoderId() string {
	if m != nil {
		return m.ElementCoderId
	}
	return ""
}

type CombiningStateSpec struct {
	AccumulatorCoderId string           `protobuf:"bytes,1,opt,name=accumulator_coder_id,json=accumulatorCoderId" json:"accumulator_coder_id,omitempty"`
	CombineFn          *SdkFunctionSpec `protobuf:"bytes,2,opt,name=combine_fn,json=combineFn" json:"combine_fn,omitempty"`
}

func (m *CombiningStateSpec) Reset()                    { *m = CombiningStateSpec{} }
func (m *CombiningStateSpec) String() string            { return proto.CompactTextString(m) }
func (*CombiningStateSpec) ProtoMessage()               {}
func (*CombiningStateSpec) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *CombiningStateSpec) GetAccumulatorCoderId() string {
	if m != nil {
		return m.AccumulatorCoderId
	}
	return ""
}

func (m *CombiningStateSpec) GetCombineFn() *SdkFunctionSpec {
	if m != nil {
		return m.CombineFn
	}
	return nil
}

type MapStateSpec struct {
	KeyCoderId   string `protobuf:"bytes,1,opt,name=key_coder_id,json=keyCoderId" json:"key_coder_id,omitempty"`
	ValueCoderId string `protobuf:"bytes,2,opt,name=value_coder_id,json=valueCoderId" json:"value_coder_id,omitempty"`
}

func (m *MapStateSpec) Reset()                    { *m = MapStateSpec{} }
func (m *MapStateSpec) String() string            { return proto.CompactTextString(m) }
func (*MapStateSpec) ProtoMessage()               {}
func (*MapStateSpec) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *MapStateSpec) GetKeyCoderId() string {
	if m != nil {
		return m.KeyCoderId
	}
	return ""
}

func (m *MapStateSpec) GetValueCoderId() string {
	if m != nil {
		return m.ValueCoderId
	}
	return ""
}

type SetStateSpec struct {
	ElementCoderId string `protobuf:"bytes,1,opt,name=element_coder_id,json=elementCoderId" json:"element_coder_id,omitempty"`
}

func (m *SetStateSpec) Reset()                    { *m = SetStateSpec{} }
func (m *SetStateSpec) String() string            { return proto.CompactTextString(m) }
func (*SetStateSpec) ProtoMessage()               {}
func (*SetStateSpec) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *SetStateSpec) GetElementCoderId() string {
	if m != nil {
		return m.ElementCoderId
	}
	return ""
}

type TimerSpec struct {
	TimeDomain TimeDomain_Enum `protobuf:"varint,1,opt,name=time_domain,json=timeDomain,enum=org.apache.beam.model.pipeline.v1.TimeDomain_Enum" json:"time_domain,omitempty"`
}

func (m *TimerSpec) Reset()                    { *m = TimerSpec{} }
func (m *TimerSpec) String() string            { return proto.CompactTextString(m) }
func (*TimerSpec) ProtoMessage()               {}
func (*TimerSpec) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *TimerSpec) GetTimeDomain() TimeDomain_Enum {
	if m != nil {
		return m.TimeDomain
	}
	return TimeDomain_UNSPECIFIED
}

type IsBounded struct {
}

func (m *IsBounded) Reset()                    { *m = IsBounded{} }
func (m *IsBounded) String() string            { return proto.CompactTextString(m) }
func (*IsBounded) ProtoMessage()               {}
func (*IsBounded) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

// The payload for the primitive Read transform.
type ReadPayload struct {
	// (Required) The SdkFunctionSpec of the source for this Read.
	Source *SdkFunctionSpec `protobuf:"bytes,1,opt,name=source" json:"source,omitempty"`
	// (Required) Whether the source is bounded or unbounded
	IsBounded IsBounded_Enum `protobuf:"varint,2,opt,name=is_bounded,json=isBounded,enum=org.apache.beam.model.pipeline.v1.IsBounded_Enum" json:"is_bounded,omitempty"`
}

func (m *ReadPayload) Reset()                    { *m = ReadPayload{} }
func (m *ReadPayload) String() string            { return proto.CompactTextString(m) }
func (*ReadPayload) ProtoMessage()               {}
func (*ReadPayload) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *ReadPayload) GetSource() *SdkFunctionSpec {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *ReadPayload) GetIsBounded() IsBounded_Enum {
	if m != nil {
		return m.IsBounded
	}
	return IsBounded_UNSPECIFIED
}

// The payload for the WindowInto transform.
type WindowIntoPayload struct {
	// (Required) The SdkFunctionSpec of the WindowFn.
	WindowFn *SdkFunctionSpec `protobuf:"bytes,1,opt,name=window_fn,json=windowFn" json:"window_fn,omitempty"`
}

func (m *WindowIntoPayload) Reset()                    { *m = WindowIntoPayload{} }
func (m *WindowIntoPayload) String() string            { return proto.CompactTextString(m) }
func (*WindowIntoPayload) ProtoMessage()               {}
func (*WindowIntoPayload) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *WindowIntoPayload) GetWindowFn() *SdkFunctionSpec {
	if m != nil {
		return m.WindowFn
	}
	return nil
}

// The payload for the special-but-not-primitive Combine transform.
type CombinePayload struct {
	// (Required) The SdkFunctionSpec of the CombineFn.
	CombineFn *SdkFunctionSpec `protobuf:"bytes,1,opt,name=combine_fn,json=combineFn" json:"combine_fn,omitempty"`
	// (Required) A reference to the Coder to use for accumulators of the CombineFn
	AccumulatorCoderId string `protobuf:"bytes,2,opt,name=accumulator_coder_id,json=accumulatorCoderId" json:"accumulator_coder_id,omitempty"`
	// (Required) Additional pieces of context the DoFn may require that
	// are not otherwise represented in the payload.
	// (may force runners to execute the ParDo differently)
	Parameters []*Parameter `protobuf:"bytes,3,rep,name=parameters" json:"parameters,omitempty"`
	// (Optional) A mapping of local input names to side inputs, describing
	// the expected access pattern.
	SideInputs map[string]*SideInput `protobuf:"bytes,4,rep,name=side_inputs,json=sideInputs" json:"side_inputs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *CombinePayload) Reset()                    { *m = CombinePayload{} }
func (m *CombinePayload) String() string            { return proto.CompactTextString(m) }
func (*CombinePayload) ProtoMessage()               {}
func (*CombinePayload) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *CombinePayload) GetCombineFn() *SdkFunctionSpec {
	if m != nil {
		return m.CombineFn
	}
	return nil
}

func (m *CombinePayload) GetAccumulatorCoderId() string {
	if m != nil {
		return m.AccumulatorCoderId
	}
	return ""
}

func (m *CombinePayload) GetParameters() []*Parameter {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *CombinePayload) GetSideInputs() map[string]*SideInput {
	if m != nil {
		return m.SideInputs
	}
	return nil
}

// The payload for the test-only primitive TestStream
type TestStreamPayload struct {
	// (Required) the coder for elements in the TestStream events
	CoderId string                     `protobuf:"bytes,1,opt,name=coder_id,json=coderId" json:"coder_id,omitempty"`
	Events  []*TestStreamPayload_Event `protobuf:"bytes,2,rep,name=events" json:"events,omitempty"`
}

func (m *TestStreamPayload) Reset()                    { *m = TestStreamPayload{} }
func (m *TestStreamPayload) String() string            { return proto.CompactTextString(m) }
func (*TestStreamPayload) ProtoMessage()               {}
func (*TestStreamPayload) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *TestStreamPayload) GetCoderId() string {
	if m != nil {
		return m.CoderId
	}
	return ""
}

func (m *TestStreamPayload) GetEvents() []*TestStreamPayload_Event {
	if m != nil {
		return m.Events
	}
	return nil
}

type TestStreamPayload_Event struct {
	// Types that are valid to be assigned to Event:
	//	*TestStreamPayload_Event_WatermarkEvent
	//	*TestStreamPayload_Event_ProcessingTimeEvent
	//	*TestStreamPayload_Event_ElementEvent
	Event isTestStreamPayload_Event_Event `protobuf_oneof:"event"`
}

func (m *TestStreamPayload_Event) Reset()                    { *m = TestStreamPayload_Event{} }
func (m *TestStreamPayload_Event) String() string            { return proto.CompactTextString(m) }
func (*TestStreamPayload_Event) ProtoMessage()               {}
func (*TestStreamPayload_Event) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18, 0} }

type isTestStreamPayload_Event_Event interface {
	isTestStreamPayload_Event_Event()
}

type TestStreamPayload_Event_WatermarkEvent struct {
	WatermarkEvent *TestStreamPayload_Event_AdvanceWatermark `protobuf:"bytes,1,opt,name=watermark_event,json=watermarkEvent,oneof"`
}
type TestStreamPayload_Event_ProcessingTimeEvent struct {
	ProcessingTimeEvent *TestStreamPayload_Event_AdvanceProcessingTime `protobuf:"bytes,2,opt,name=processing_time_event,json=processingTimeEvent,oneof"`
}
type TestStreamPayload_Event_ElementEvent struct {
	ElementEvent *TestStreamPayload_Event_AddElements `protobuf:"bytes,3,opt,name=element_event,json=elementEvent,oneof"`
}

func (*TestStreamPayload_Event_WatermarkEvent) isTestStreamPayload_Event_Event()      {}
func (*TestStreamPayload_Event_ProcessingTimeEvent) isTestStreamPayload_Event_Event() {}
func (*TestStreamPayload_Event_ElementEvent) isTestStreamPayload_Event_Event()        {}

func (m *TestStreamPayload_Event) GetEvent() isTestStreamPayload_Event_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *TestStreamPayload_Event) GetWatermarkEvent() *TestStreamPayload_Event_AdvanceWatermark {
	if x, ok := m.GetEvent().(*TestStreamPayload_Event_WatermarkEvent); ok {
		return x.WatermarkEvent
	}
	return nil
}

func (m *TestStreamPayload_Event) GetProcessingTimeEvent() *TestStreamPayload_Event_AdvanceProcessingTime {
	if x, ok := m.GetEvent().(*TestStreamPayload_Event_ProcessingTimeEvent); ok {
		return x.ProcessingTimeEvent
	}
	return nil
}

func (m *TestStreamPayload_Event) GetElementEvent() *TestStreamPayload_Event_AddElements {
	if x, ok := m.GetEvent().(*TestStreamPayload_Event_ElementEvent); ok {
		return x.ElementEvent
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*TestStreamPayload_Event) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _TestStreamPayload_Event_OneofMarshaler, _TestStreamPayload_Event_OneofUnmarshaler, _TestStreamPayload_Event_OneofSizer, []interface{}{
		(*TestStreamPayload_Event_WatermarkEvent)(nil),
		(*TestStreamPayload_Event_ProcessingTimeEvent)(nil),
		(*TestStreamPayload_Event_ElementEvent)(nil),
	}
}

func _TestStreamPayload_Event_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*TestStreamPayload_Event)
	// event
	switch x := m.Event.(type) {
	case *TestStreamPayload_Event_WatermarkEvent:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.WatermarkEvent); err != nil {
			return err
		}
	case *TestStreamPayload_Event_ProcessingTimeEvent:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProcessingTimeEvent); err != nil {
			return err
		}
	case *TestStreamPayload_Event_ElementEvent:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ElementEvent); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("TestStreamPayload_Event.Event has unexpected type %T", x)
	}
	return nil
}

func _TestStreamPayload_Event_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*TestStreamPayload_Event)
	switch tag {
	case 1: // event.watermark_event
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TestStreamPayload_Event_AdvanceWatermark)
		err := b.DecodeMessage(msg)
		m.Event = &TestStreamPayload_Event_WatermarkEvent{msg}
		return true, err
	case 2: // event.processing_time_event
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TestStreamPayload_Event_AdvanceProcessingTime)
		err := b.DecodeMessage(msg)
		m.Event = &TestStreamPayload_Event_ProcessingTimeEvent{msg}
		return true, err
	case 3: // event.element_event
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TestStreamPayload_Event_AddElements)
		err := b.DecodeMessage(msg)
		m.Event = &TestStreamPayload_Event_ElementEvent{msg}
		return true, err
	default:
		return false, nil
	}
}

func _TestStreamPayload_Event_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*TestStreamPayload_Event)
	// event
	switch x := m.Event.(type) {
	case *TestStreamPayload_Event_WatermarkEvent:
		s := proto.Size(x.WatermarkEvent)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TestStreamPayload_Event_ProcessingTimeEvent:
		s := proto.Size(x.ProcessingTimeEvent)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TestStreamPayload_Event_ElementEvent:
		s := proto.Size(x.ElementEvent)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type TestStreamPayload_Event_AdvanceWatermark struct {
	NewWatermark int64 `protobuf:"varint,1,opt,name=new_watermark,json=newWatermark" json:"new_watermark,omitempty"`
}

func (m *TestStreamPayload_Event_AdvanceWatermark) Reset() {
	*m = TestStreamPayload_Event_AdvanceWatermark{}
}
func (m *TestStreamPayload_Event_AdvanceWatermark) String() string { return proto.CompactTextString(m) }
func (*TestStreamPayload_Event_AdvanceWatermark) ProtoMessage()    {}
func (*TestStreamPayload_Event_AdvanceWatermark) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{18, 0, 0}
}

func (m *TestStreamPayload_Event_AdvanceWatermark) GetNewWatermark() int64 {
	if m != nil {
		return m.NewWatermark
	}
	return 0
}

type TestStreamPayload_Event_AdvanceProcessingTime struct {
	AdvanceDuration int64 `protobuf:"varint,1,opt,name=advance_duration,json=advanceDuration" json:"advance_duration,omitempty"`
}

func (m *TestStreamPayload_Event_AdvanceProcessingTime) Reset() {
	*m = TestStreamPayload_Event_AdvanceProcessingTime{}
}
func (m *TestStreamPayload_Event_AdvanceProcessingTime) String() string {
	return proto.CompactTextString(m)
}
func (*TestStreamPayload_Event_AdvanceProcessingTime) ProtoMessage() {}
func (*TestStreamPayload_Event_AdvanceProcessingTime) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{18, 0, 1}
}

func (m *TestStreamPayload_Event_AdvanceProcessingTime) GetAdvanceDuration() int64 {
	if m != nil {
		return m.AdvanceDuration
	}
	return 0
}

type TestStreamPayload_Event_AddElements struct {
	Elements []*TestStreamPayload_TimestampedElement `protobuf:"bytes,1,rep,name=elements" json:"elements,omitempty"`
}

func (m *TestStreamPayload_Event_AddElements) Reset()         { *m = TestStreamPayload_Event_AddElements{} }
func (m *TestStreamPayload_Event_AddElements) String() string { return proto.CompactTextString(m) }
func (*TestStreamPayload_Event_AddElements) ProtoMessage()    {}
func (*TestStreamPayload_Event_AddElements) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{18, 0, 2}
}

func (m *TestStreamPayload_Event_AddElements) GetElements() []*TestStreamPayload_TimestampedElement {
	if m != nil {
		return m.Elements
	}
	return nil
}

type TestStreamPayload_TimestampedElement struct {
	EncodedElement []byte `protobuf:"bytes,1,opt,name=encoded_element,json=encodedElement,proto3" json:"encoded_element,omitempty"`
	Timestamp      int64  `protobuf:"varint,2,opt,name=timestamp" json:"timestamp,omitempty"`
}

func (m *TestStreamPayload_TimestampedElement) Reset()         { *m = TestStreamPayload_TimestampedElement{} }
func (m *TestStreamPayload_TimestampedElement) String() string { return proto.CompactTextString(m) }
func (*TestStreamPayload_TimestampedElement) ProtoMessage()    {}
func (*TestStreamPayload_TimestampedElement) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{18, 1}
}

func (m *TestStreamPayload_TimestampedElement) GetEncodedElement() []byte {
	if m != nil {
		return m.EncodedElement
	}
	return nil
}

func (m *TestStreamPayload_TimestampedElement) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

// The payload for the special-but-not-primitive WriteFiles transform.
type WriteFilesPayload struct {
	// (Required) The SdkFunctionSpec of the FileBasedSink.
	Sink *SdkFunctionSpec `protobuf:"bytes,1,opt,name=sink" json:"sink,omitempty"`
	// (Required) The format function.
	FormatFunction           *SdkFunctionSpec      `protobuf:"bytes,2,opt,name=format_function,json=formatFunction" json:"format_function,omitempty"`
	WindowedWrites           bool                  `protobuf:"varint,3,opt,name=windowed_writes,json=windowedWrites" json:"windowed_writes,omitempty"`
	RunnerDeterminedSharding bool                  `protobuf:"varint,4,opt,name=runner_determined_sharding,json=runnerDeterminedSharding" json:"runner_determined_sharding,omitempty"`
	SideInputs               map[string]*SideInput `protobuf:"bytes,5,rep,name=side_inputs,json=sideInputs" json:"side_inputs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *WriteFilesPayload) Reset()                    { *m = WriteFilesPayload{} }
func (m *WriteFilesPayload) String() string            { return proto.CompactTextString(m) }
func (*WriteFilesPayload) ProtoMessage()               {}
func (*WriteFilesPayload) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *WriteFilesPayload) GetSink() *SdkFunctionSpec {
	if m != nil {
		return m.Sink
	}
	return nil
}

func (m *WriteFilesPayload) GetFormatFunction() *SdkFunctionSpec {
	if m != nil {
		return m.FormatFunction
	}
	return nil
}

func (m *WriteFilesPayload) GetWindowedWrites() bool {
	if m != nil {
		return m.WindowedWrites
	}
	return false
}

func (m *WriteFilesPayload) GetRunnerDeterminedSharding() bool {
	if m != nil {
		return m.RunnerDeterminedSharding
	}
	return false
}

func (m *WriteFilesPayload) GetSideInputs() map[string]*SideInput {
	if m != nil {
		return m.SideInputs
	}
	return nil
}

// A coder, the binary format for serialization and deserialization of data in
// a pipeline.
type Coder struct {
	// (Required) A specification for the coder, as a URN plus parameters. This
	// may be a cross-language agreed-upon format, or it may be a "custom coder"
	// that can only be used by a particular SDK. It does not include component
	// coders, as it is beneficial for these to be comprehensible to a runner
	// regardless of whether the binary format is agree-upon.
	Spec *SdkFunctionSpec `protobuf:"bytes,1,opt,name=spec" json:"spec,omitempty"`
	// (Optional) If this coder is parametric, such as ListCoder(VarIntCoder),
	// this is a list of the components. In order for encodings to be identical,
	// the SdkFunctionSpec and all components must be identical, recursively.
	ComponentCoderIds []string `protobuf:"bytes,2,rep,name=component_coder_ids,json=componentCoderIds" json:"component_coder_ids,omitempty"`
}

func (m *Coder) Reset()                    { *m = Coder{} }
func (m *Coder) String() string            { return proto.CompactTextString(m) }
func (*Coder) ProtoMessage()               {}
func (*Coder) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *Coder) GetSpec() *SdkFunctionSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *Coder) GetComponentCoderIds() []string {
	if m != nil {
		return m.ComponentCoderIds
	}
	return nil
}

// A windowing strategy describes the window function, triggering, allowed
// lateness, and accumulation mode for a PCollection.
//
// TODO: consider inlining field on PCollection
type WindowingStrategy struct {
	// (Required) The SdkFunctionSpec of the UDF that assigns windows,
	// merges windows, and shifts timestamps before they are
	// combined according to the OutputTime.
	WindowFn *SdkFunctionSpec `protobuf:"bytes,1,opt,name=window_fn,json=windowFn" json:"window_fn,omitempty"`
	// (Required) Whether or not the window fn is merging.
	//
	// This knowledge is required for many optimizations.
	MergeStatus MergeStatus_Enum `protobuf:"varint,2,opt,name=merge_status,json=mergeStatus,enum=org.apache.beam.model.pipeline.v1.MergeStatus_Enum" json:"merge_status,omitempty"`
	// (Required) The coder for the windows of this PCollection.
	WindowCoderId string `protobuf:"bytes,3,opt,name=window_coder_id,json=windowCoderId" json:"window_coder_id,omitempty"`
	// (Required) The trigger to use when grouping this PCollection.
	Trigger *Trigger `protobuf:"bytes,4,opt,name=trigger" json:"trigger,omitempty"`
	// (Required) The accumulation mode indicates whether new panes are a full
	// replacement for prior panes or whether they are deltas to be combined
	// with other panes (the combine should correspond to whatever the upstream
	// grouping transform is).
	AccumulationMode AccumulationMode_Enum `protobuf:"varint,5,opt,name=accumulation_mode,json=accumulationMode,enum=org.apache.beam.model.pipeline.v1.AccumulationMode_Enum" json:"accumulation_mode,omitempty"`
	// (Required) The OutputTime specifies, for a grouping transform, how to
	// compute the aggregate timestamp. The window_fn will first possibly shift
	// it later, then the OutputTime takes the max, min, or ignores it and takes
	// the end of window.
	//
	// This is actually only for input to grouping transforms, but since they
	// may be introduced in runner-specific ways, it is carried along with the
	// windowing strategy.
	OutputTime OutputTime_Enum `protobuf:"varint,6,opt,name=output_time,json=outputTime,enum=org.apache.beam.model.pipeline.v1.OutputTime_Enum" json:"output_time,omitempty"`
	// (Required) Indicate when output should be omitted upon window expiration.
	ClosingBehavior ClosingBehavior_Enum `protobuf:"varint,7,opt,name=closing_behavior,json=closingBehavior,enum=org.apache.beam.model.pipeline.v1.ClosingBehavior_Enum" json:"closing_behavior,omitempty"`
	// (Required) The duration, in milliseconds, beyond the end of a window at
	// which the window becomes droppable.
	AllowedLateness int64 `protobuf:"varint,8,opt,name=allowed_lateness,json=allowedLateness" json:"allowed_lateness,omitempty"`
	// (Required) Indicate whether empty on-time panes should be omitted.
	OnTimeBehavior OnTimeBehavior_Enum `protobuf:"varint,9,opt,name=OnTimeBehavior,enum=org.apache.beam.model.pipeline.v1.OnTimeBehavior_Enum" json:"OnTimeBehavior,omitempty"`
	// (Required) Whether or not the window fn assigns inputs to exactly one window
	//
	// This knowledge is required for some optimizations
	AssignsToOneWindow bool `protobuf:"varint,10,opt,name=assigns_to_one_window,json=assignsToOneWindow" json:"assigns_to_one_window,omitempty"`
}

func (m *WindowingStrategy) Reset()                    { *m = WindowingStrategy{} }
func (m *WindowingStrategy) String() string            { return proto.CompactTextString(m) }
func (*WindowingStrategy) ProtoMessage()               {}
func (*WindowingStrategy) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *WindowingStrategy) GetWindowFn() *SdkFunctionSpec {
	if m != nil {
		return m.WindowFn
	}
	return nil
}

func (m *WindowingStrategy) GetMergeStatus() MergeStatus_Enum {
	if m != nil {
		return m.MergeStatus
	}
	return MergeStatus_UNSPECIFIED
}

func (m *WindowingStrategy) GetWindowCoderId() string {
	if m != nil {
		return m.WindowCoderId
	}
	return ""
}

func (m *WindowingStrategy) GetTrigger() *Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

func (m *WindowingStrategy) GetAccumulationMode() AccumulationMode_Enum {
	if m != nil {
		return m.AccumulationMode
	}
	return AccumulationMode_UNSPECIFIED
}

func (m *WindowingStrategy) GetOutputTime() OutputTime_Enum {
	if m != nil {
		return m.OutputTime
	}
	return OutputTime_UNSPECIFIED
}

func (m *WindowingStrategy) GetClosingBehavior() ClosingBehavior_Enum {
	if m != nil {
		return m.ClosingBehavior
	}
	return ClosingBehavior_UNSPECIFIED
}

func (m *WindowingStrategy) GetAllowedLateness() int64 {
	if m != nil {
		return m.AllowedLateness
	}
	return 0
}

func (m *WindowingStrategy) GetOnTimeBehavior() OnTimeBehavior_Enum {
	if m != nil {
		return m.OnTimeBehavior
	}
	return OnTimeBehavior_UNSPECIFIED
}

func (m *WindowingStrategy) GetAssignsToOneWindow() bool {
	if m != nil {
		return m.AssignsToOneWindow
	}
	return false
}

// Whether or not a PCollection's WindowFn is non-merging, merging, or
// merging-but-already-merged, in which case a subsequent GroupByKey is almost
// always going to do something the user does not want
type MergeStatus struct {
}

func (m *MergeStatus) Reset()                    { *m = MergeStatus{} }
func (m *MergeStatus) String() string            { return proto.CompactTextString(m) }
func (*MergeStatus) ProtoMessage()               {}
func (*MergeStatus) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

// Whether or not subsequent outputs of aggregations should be entire
// replacement values or just the aggregation of inputs received since
// the prior output.
type AccumulationMode struct {
}

func (m *AccumulationMode) Reset()                    { *m = AccumulationMode{} }
func (m *AccumulationMode) String() string            { return proto.CompactTextString(m) }
func (*AccumulationMode) ProtoMessage()               {}
func (*AccumulationMode) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

// Controls whether or not an aggregating transform should output data
// when a window expires.
type ClosingBehavior struct {
}

func (m *ClosingBehavior) Reset()                    { *m = ClosingBehavior{} }
func (m *ClosingBehavior) String() string            { return proto.CompactTextString(m) }
func (*ClosingBehavior) ProtoMessage()               {}
func (*ClosingBehavior) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

// Controls whether or not an aggregating transform should output data
// when an on-time pane is empty.
type OnTimeBehavior struct {
}

func (m *OnTimeBehavior) Reset()                    { *m = OnTimeBehavior{} }
func (m *OnTimeBehavior) String() string            { return proto.CompactTextString(m) }
func (*OnTimeBehavior) ProtoMessage()               {}
func (*OnTimeBehavior) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

// When a number of windowed, timestamped inputs are aggregated, the timestamp
// for the resulting output.
type OutputTime struct {
}

func (m *OutputTime) Reset()                    { *m = OutputTime{} }
func (m *OutputTime) String() string            { return proto.CompactTextString(m) }
func (*OutputTime) ProtoMessage()               {}
func (*OutputTime) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

// The different time domains in the Beam model.
type TimeDomain struct {
}

func (m *TimeDomain) Reset()                    { *m = TimeDomain{} }
func (m *TimeDomain) String() string            { return proto.CompactTextString(m) }
func (*TimeDomain) ProtoMessage()               {}
func (*TimeDomain) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

// A small DSL for expressing when to emit new aggregations
// from a GroupByKey or CombinePerKey
//
// A trigger is described in terms of when it is _ready_ to permit output.
type Trigger struct {
	// The full disjoint union of possible triggers.
	//
	// Types that are valid to be assigned to Trigger:
	//	*Trigger_AfterAll_
	//	*Trigger_AfterAny_
	//	*Trigger_AfterEach_
	//	*Trigger_AfterEndOfWindow_
	//	*Trigger_AfterProcessingTime_
	//	*Trigger_AfterSynchronizedProcessingTime_
	//	*Trigger_Always_
	//	*Trigger_Default_
	//	*Trigger_ElementCount_
	//	*Trigger_Never_
	//	*Trigger_OrFinally_
	//	*Trigger_Repeat_
	Trigger isTrigger_Trigger `protobuf_oneof:"trigger"`
}

func (m *Trigger) Reset()                    { *m = Trigger{} }
func (m *Trigger) String() string            { return proto.CompactTextString(m) }
func (*Trigger) ProtoMessage()               {}
func (*Trigger) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

type isTrigger_Trigger interface {
	isTrigger_Trigger()
}

type Trigger_AfterAll_ struct {
	AfterAll *Trigger_AfterAll `protobuf:"bytes,1,opt,name=after_all,json=afterAll,oneof"`
}
type Trigger_AfterAny_ struct {
	AfterAny *Trigger_AfterAny `protobuf:"bytes,2,opt,name=after_any,json=afterAny,oneof"`
}
type Trigger_AfterEach_ struct {
	AfterEach *Trigger_AfterEach `protobuf:"bytes,3,opt,name=after_each,json=afterEach,oneof"`
}
type Trigger_AfterEndOfWindow_ struct {
	AfterEndOfWindow *Trigger_AfterEndOfWindow `protobuf:"bytes,4,opt,name=after_end_of_window,json=afterEndOfWindow,oneof"`
}
type Trigger_AfterProcessingTime_ struct {
	AfterProcessingTime *Trigger_AfterProcessingTime `protobuf:"bytes,5,opt,name=after_processing_time,json=afterProcessingTime,oneof"`
}
type Trigger_AfterSynchronizedProcessingTime_ struct {
	AfterSynchronizedProcessingTime *Trigger_AfterSynchronizedProcessingTime `protobuf:"bytes,6,opt,name=after_synchronized_processing_time,json=afterSynchronizedProcessingTime,oneof"`
}
type Trigger_Always_ struct {
	Always *Trigger_Always `protobuf:"bytes,12,opt,name=always,oneof"`
}
type Trigger_Default_ struct {
	Default *Trigger_Default `protobuf:"bytes,7,opt,name=default,oneof"`
}
type Trigger_ElementCount_ struct {
	ElementCount *Trigger_ElementCount `protobuf:"bytes,8,opt,name=element_count,json=elementCount,oneof"`
}
type Trigger_Never_ struct {
	Never *Trigger_Never `protobuf:"bytes,9,opt,name=never,oneof"`
}
type Trigger_OrFinally_ struct {
	OrFinally *Trigger_OrFinally `protobuf:"bytes,10,opt,name=or_finally,json=orFinally,oneof"`
}
type Trigger_Repeat_ struct {
	Repeat *Trigger_Repeat `protobuf:"bytes,11,opt,name=repeat,oneof"`
}

func (*Trigger_AfterAll_) isTrigger_Trigger()                        {}
func (*Trigger_AfterAny_) isTrigger_Trigger()                        {}
func (*Trigger_AfterEach_) isTrigger_Trigger()                       {}
func (*Trigger_AfterEndOfWindow_) isTrigger_Trigger()                {}
func (*Trigger_AfterProcessingTime_) isTrigger_Trigger()             {}
func (*Trigger_AfterSynchronizedProcessingTime_) isTrigger_Trigger() {}
func (*Trigger_Always_) isTrigger_Trigger()                          {}
func (*Trigger_Default_) isTrigger_Trigger()                         {}
func (*Trigger_ElementCount_) isTrigger_Trigger()                    {}
func (*Trigger_Never_) isTrigger_Trigger()                           {}
func (*Trigger_OrFinally_) isTrigger_Trigger()                       {}
func (*Trigger_Repeat_) isTrigger_Trigger()                          {}

func (m *Trigger) GetTrigger() isTrigger_Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

func (m *Trigger) GetAfterAll() *Trigger_AfterAll {
	if x, ok := m.GetTrigger().(*Trigger_AfterAll_); ok {
		return x.AfterAll
	}
	return nil
}

func (m *Trigger) GetAfterAny() *Trigger_AfterAny {
	if x, ok := m.GetTrigger().(*Trigger_AfterAny_); ok {
		return x.AfterAny
	}
	return nil
}

func (m *Trigger) GetAfterEach() *Trigger_AfterEach {
	if x, ok := m.GetTrigger().(*Trigger_AfterEach_); ok {
		return x.AfterEach
	}
	return nil
}

func (m *Trigger) GetAfterEndOfWindow() *Trigger_AfterEndOfWindow {
	if x, ok := m.GetTrigger().(*Trigger_AfterEndOfWindow_); ok {
		return x.AfterEndOfWindow
	}
	return nil
}

func (m *Trigger) GetAfterProcessingTime() *Trigger_AfterProcessingTime {
	if x, ok := m.GetTrigger().(*Trigger_AfterProcessingTime_); ok {
		return x.AfterProcessingTime
	}
	return nil
}

func (m *Trigger) GetAfterSynchronizedProcessingTime() *Trigger_AfterSynchronizedProcessingTime {
	if x, ok := m.GetTrigger().(*Trigger_AfterSynchronizedProcessingTime_); ok {
		return x.AfterSynchronizedProcessingTime
	}
	return nil
}

func (m *Trigger) GetAlways() *Trigger_Always {
	if x, ok := m.GetTrigger().(*Trigger_Always_); ok {
		return x.Always
	}
	return nil
}

func (m *Trigger) GetDefault() *Trigger_Default {
	if x, ok := m.GetTrigger().(*Trigger_Default_); ok {
		return x.Default
	}
	return nil
}

func (m *Trigger) GetElementCount() *Trigger_ElementCount {
	if x, ok := m.GetTrigger().(*Trigger_ElementCount_); ok {
		return x.ElementCount
	}
	return nil
}

func (m *Trigger) GetNever() *Trigger_Never {
	if x, ok := m.GetTrigger().(*Trigger_Never_); ok {
		return x.Never
	}
	return nil
}

func (m *Trigger) GetOrFinally() *Trigger_OrFinally {
	if x, ok := m.GetTrigger().(*Trigger_OrFinally_); ok {
		return x.OrFinally
	}
	return nil
}

func (m *Trigger) GetRepeat() *Trigger_Repeat {
	if x, ok := m.GetTrigger().(*Trigger_Repeat_); ok {
		return x.Repeat
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Trigger) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Trigger_OneofMarshaler, _Trigger_OneofUnmarshaler, _Trigger_OneofSizer, []interface{}{
		(*Trigger_AfterAll_)(nil),
		(*Trigger_AfterAny_)(nil),
		(*Trigger_AfterEach_)(nil),
		(*Trigger_AfterEndOfWindow_)(nil),
		(*Trigger_AfterProcessingTime_)(nil),
		(*Trigger_AfterSynchronizedProcessingTime_)(nil),
		(*Trigger_Always_)(nil),
		(*Trigger_Default_)(nil),
		(*Trigger_ElementCount_)(nil),
		(*Trigger_Never_)(nil),
		(*Trigger_OrFinally_)(nil),
		(*Trigger_Repeat_)(nil),
	}
}

func _Trigger_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Trigger)
	// trigger
	switch x := m.Trigger.(type) {
	case *Trigger_AfterAll_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AfterAll); err != nil {
			return err
		}
	case *Trigger_AfterAny_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AfterAny); err != nil {
			return err
		}
	case *Trigger_AfterEach_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AfterEach); err != nil {
			return err
		}
	case *Trigger_AfterEndOfWindow_:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AfterEndOfWindow); err != nil {
			return err
		}
	case *Trigger_AfterProcessingTime_:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AfterProcessingTime); err != nil {
			return err
		}
	case *Trigger_AfterSynchronizedProcessingTime_:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AfterSynchronizedProcessingTime); err != nil {
			return err
		}
	case *Trigger_Always_:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Always); err != nil {
			return err
		}
	case *Trigger_Default_:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Default); err != nil {
			return err
		}
	case *Trigger_ElementCount_:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ElementCount); err != nil {
			return err
		}
	case *Trigger_Never_:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Never); err != nil {
			return err
		}
	case *Trigger_OrFinally_:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.OrFinally); err != nil {
			return err
		}
	case *Trigger_Repeat_:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Repeat); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Trigger.Trigger has unexpected type %T", x)
	}
	return nil
}

func _Trigger_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Trigger)
	switch tag {
	case 1: // trigger.after_all
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Trigger_AfterAll)
		err := b.DecodeMessage(msg)
		m.Trigger = &Trigger_AfterAll_{msg}
		return true, err
	case 2: // trigger.after_any
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Trigger_AfterAny)
		err := b.DecodeMessage(msg)
		m.Trigger = &Trigger_AfterAny_{msg}
		return true, err
	case 3: // trigger.after_each
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Trigger_AfterEach)
		err := b.DecodeMessage(msg)
		m.Trigger = &Trigger_AfterEach_{msg}
		return true, err
	case 4: // trigger.after_end_of_window
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Trigger_AfterEndOfWindow)
		err := b.DecodeMessage(msg)
		m.Trigger = &Trigger_AfterEndOfWindow_{msg}
		return true, err
	case 5: // trigger.after_processing_time
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Trigger_AfterProcessingTime)
		err := b.DecodeMessage(msg)
		m.Trigger = &Trigger_AfterProcessingTime_{msg}
		return true, err
	case 6: // trigger.after_synchronized_processing_time
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Trigger_AfterSynchronizedProcessingTime)
		err := b.DecodeMessage(msg)
		m.Trigger = &Trigger_AfterSynchronizedProcessingTime_{msg}
		return true, err
	case 12: // trigger.always
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Trigger_Always)
		err := b.DecodeMessage(msg)
		m.Trigger = &Trigger_Always_{msg}
		return true, err
	case 7: // trigger.default
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Trigger_Default)
		err := b.DecodeMessage(msg)
		m.Trigger = &Trigger_Default_{msg}
		return true, err
	case 8: // trigger.element_count
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Trigger_ElementCount)
		err := b.DecodeMessage(msg)
		m.Trigger = &Trigger_ElementCount_{msg}
		return true, err
	case 9: // trigger.never
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Trigger_Never)
		err := b.DecodeMessage(msg)
		m.Trigger = &Trigger_Never_{msg}
		return true, err
	case 10: // trigger.or_finally
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Trigger_OrFinally)
		err := b.DecodeMessage(msg)
		m.Trigger = &Trigger_OrFinally_{msg}
		return true, err
	case 11: // trigger.repeat
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Trigger_Repeat)
		err := b.DecodeMessage(msg)
		m.Trigger = &Trigger_Repeat_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Trigger_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Trigger)
	// trigger
	switch x := m.Trigger.(type) {
	case *Trigger_AfterAll_:
		s := proto.Size(x.AfterAll)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Trigger_AfterAny_:
		s := proto.Size(x.AfterAny)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Trigger_AfterEach_:
		s := proto.Size(x.AfterEach)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Trigger_AfterEndOfWindow_:
		s := proto.Size(x.AfterEndOfWindow)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Trigger_AfterProcessingTime_:
		s := proto.Size(x.AfterProcessingTime)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Trigger_AfterSynchronizedProcessingTime_:
		s := proto.Size(x.AfterSynchronizedProcessingTime)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Trigger_Always_:
		s := proto.Size(x.Always)
		n += proto.SizeVarint(12<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Trigger_Default_:
		s := proto.Size(x.Default)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Trigger_ElementCount_:
		s := proto.Size(x.ElementCount)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Trigger_Never_:
		s := proto.Size(x.Never)
		n += proto.SizeVarint(9<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Trigger_OrFinally_:
		s := proto.Size(x.OrFinally)
		n += proto.SizeVarint(10<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Trigger_Repeat_:
		s := proto.Size(x.Repeat)
		n += proto.SizeVarint(11<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Ready when all subtriggers are ready.
type Trigger_AfterAll struct {
	Subtriggers []*Trigger `protobuf:"bytes,1,rep,name=subtriggers" json:"subtriggers,omitempty"`
}

func (m *Trigger_AfterAll) Reset()                    { *m = Trigger_AfterAll{} }
func (m *Trigger_AfterAll) String() string            { return proto.CompactTextString(m) }
func (*Trigger_AfterAll) ProtoMessage()               {}
func (*Trigger_AfterAll) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28, 0} }

func (m *Trigger_AfterAll) GetSubtriggers() []*Trigger {
	if m != nil {
		return m.Subtriggers
	}
	return nil
}

// Ready when any subtrigger is ready.
type Trigger_AfterAny struct {
	Subtriggers []*Trigger `protobuf:"bytes,1,rep,name=subtriggers" json:"subtriggers,omitempty"`
}

func (m *Trigger_AfterAny) Reset()                    { *m = Trigger_AfterAny{} }
func (m *Trigger_AfterAny) String() string            { return proto.CompactTextString(m) }
func (*Trigger_AfterAny) ProtoMessage()               {}
func (*Trigger_AfterAny) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28, 1} }

func (m *Trigger_AfterAny) GetSubtriggers() []*Trigger {
	if m != nil {
		return m.Subtriggers
	}
	return nil
}

// Starting with the first subtrigger, ready when the _current_ subtrigger
// is ready. After output, advances the current trigger by one.
type Trigger_AfterEach struct {
	Subtriggers []*Trigger `protobuf:"bytes,1,rep,name=subtriggers" json:"subtriggers,omitempty"`
}

func (m *Trigger_AfterEach) Reset()                    { *m = Trigger_AfterEach{} }
func (m *Trigger_AfterEach) String() string            { return proto.CompactTextString(m) }
func (*Trigger_AfterEach) ProtoMessage()               {}
func (*Trigger_AfterEach) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28, 2} }

func (m *Trigger_AfterEach) GetSubtriggers() []*Trigger {
	if m != nil {
		return m.Subtriggers
	}
	return nil
}

// Ready after the input watermark is past the end of the window.
//
// May have implicitly-repeated subtriggers for early and late firings.
// When the end of the window is reached, the trigger transitions between
// the subtriggers.
type Trigger_AfterEndOfWindow struct {
	// (Optional) A trigger governing output prior to the end of the window.
	EarlyFirings *Trigger `protobuf:"bytes,1,opt,name=early_firings,json=earlyFirings" json:"early_firings,omitempty"`
	// (Optional) A trigger governing output after the end of the window.
	LateFirings *Trigger `protobuf:"bytes,2,opt,name=late_firings,json=lateFirings" json:"late_firings,omitempty"`
}

func (m *Trigger_AfterEndOfWindow) Reset()                    { *m = Trigger_AfterEndOfWindow{} }
func (m *Trigger_AfterEndOfWindow) String() string            { return proto.CompactTextString(m) }
func (*Trigger_AfterEndOfWindow) ProtoMessage()               {}
func (*Trigger_AfterEndOfWindow) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28, 3} }

func (m *Trigger_AfterEndOfWindow) GetEarlyFirings() *Trigger {
	if m != nil {
		return m.EarlyFirings
	}
	return nil
}

func (m *Trigger_AfterEndOfWindow) GetLateFirings() *Trigger {
	if m != nil {
		return m.LateFirings
	}
	return nil
}

// After input arrives, ready when the specified delay has passed.
type Trigger_AfterProcessingTime struct {
	// (Required) The transforms to apply to an arriving element's timestamp,
	// in order
	TimestampTransforms []*TimestampTransform `protobuf:"bytes,1,rep,name=timestamp_transforms,json=timestampTransforms" json:"timestamp_transforms,omitempty"`
}

func (m *Trigger_AfterProcessingTime) Reset()                    { *m = Trigger_AfterProcessingTime{} }
func (m *Trigger_AfterProcessingTime) String() string            { return proto.CompactTextString(m) }
func (*Trigger_AfterProcessingTime) ProtoMessage()               {}
func (*Trigger_AfterProcessingTime) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28, 4} }

func (m *Trigger_AfterProcessingTime) GetTimestampTransforms() []*TimestampTransform {
	if m != nil {
		return m.TimestampTransforms
	}
	return nil
}

// Ready whenever upstream processing time has all caught up with
// the arrival time of an input element
type Trigger_AfterSynchronizedProcessingTime struct {
}

func (m *Trigger_AfterSynchronizedProcessingTime) Reset() {
	*m = Trigger_AfterSynchronizedProcessingTime{}
}
func (m *Trigger_AfterSynchronizedProcessingTime) String() string { return proto.CompactTextString(m) }
func (*Trigger_AfterSynchronizedProcessingTime) ProtoMessage()    {}
func (*Trigger_AfterSynchronizedProcessingTime) Descriptor() ([]byte, []int) {
	return fileDescriptor0, []int{28, 5}
}

// The default trigger. Equivalent to Repeat { AfterEndOfWindow } but
// specially denoted to indicate the user did not alter the triggering.
type Trigger_Default struct {
}

func (m *Trigger_Default) Reset()                    { *m = Trigger_Default{} }
func (m *Trigger_Default) String() string            { return proto.CompactTextString(m) }
func (*Trigger_Default) ProtoMessage()               {}
func (*Trigger_Default) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28, 6} }

// Ready whenever the requisite number of input elements have arrived
type Trigger_ElementCount struct {
	ElementCount int32 `protobuf:"varint,1,opt,name=element_count,json=elementCount" json:"element_count,omitempty"`
}

func (m *Trigger_ElementCount) Reset()                    { *m = Trigger_ElementCount{} }
func (m *Trigger_ElementCount) String() string            { return proto.CompactTextString(m) }
func (*Trigger_ElementCount) ProtoMessage()               {}
func (*Trigger_ElementCount) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28, 7} }

func (m *Trigger_ElementCount) GetElementCount() int32 {
	if m != nil {
		return m.ElementCount
	}
	return 0
}

// Never ready. There will only be an ON_TIME output and a final
// output at window expiration.
type Trigger_Never struct {
}

func (m *Trigger_Never) Reset()                    { *m = Trigger_Never{} }
func (m *Trigger_Never) String() string            { return proto.CompactTextString(m) }
func (*Trigger_Never) ProtoMessage()               {}
func (*Trigger_Never) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28, 8} }

// Always ready. This can also be expressed as ElementCount(1) but
// is more explicit.
type Trigger_Always struct {
}

func (m *Trigger_Always) Reset()                    { *m = Trigger_Always{} }
func (m *Trigger_Always) String() string            { return proto.CompactTextString(m) }
func (*Trigger_Always) ProtoMessage()               {}
func (*Trigger_Always) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28, 9} }

// Ready whenever either of its subtriggers are ready, but finishes output
// when the finally subtrigger fires.
type Trigger_OrFinally struct {
	// (Required) Trigger governing main output; may fire repeatedly.
	Main *Trigger `protobuf:"bytes,1,opt,name=main" json:"main,omitempty"`
	// (Required) Trigger governing termination of output.
	Finally *Trigger `protobuf:"bytes,2,opt,name=finally" json:"finally,omitempty"`
}

func (m *Trigger_OrFinally) Reset()                    { *m = Trigger_OrFinally{} }
func (m *Trigger_OrFinally) String() string            { return proto.CompactTextString(m) }
func (*Trigger_OrFinally) ProtoMessage()               {}
func (*Trigger_OrFinally) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28, 10} }

func (m *Trigger_OrFinally) GetMain() *Trigger {
	if m != nil {
		return m.Main
	}
	return nil
}

func (m *Trigger_OrFinally) GetFinally() *Trigger {
	if m != nil {
		return m.Finally
	}
	return nil
}

// Ready whenever the subtrigger is ready; resets state when the subtrigger
// completes.
type Trigger_Repeat struct {
	// (Require) Trigger that is run repeatedly.
	Subtrigger *Trigger `protobuf:"bytes,1,opt,name=subtrigger" json:"subtrigger,omitempty"`
}

func (m *Trigger_Repeat) Reset()                    { *m = Trigger_Repeat{} }
func (m *Trigger_Repeat) String() string            { return proto.CompactTextString(m) }
func (*Trigger_Repeat) ProtoMessage()               {}
func (*Trigger_Repeat) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28, 11} }

func (m *Trigger_Repeat) GetSubtrigger() *Trigger {
	if m != nil {
		return m.Subtrigger
	}
	return nil
}

// A specification for a transformation on a timestamp.
//
// Primarily used by AfterProcessingTime triggers to transform
// the arrival time of input to a target time for firing.
type TimestampTransform struct {
	// Types that are valid to be assigned to TimestampTransform:
	//	*TimestampTransform_Delay_
	//	*TimestampTransform_AlignTo_
	TimestampTransform isTimestampTransform_TimestampTransform `protobuf_oneof:"timestamp_transform"`
}

func (m *TimestampTransform) Reset()                    { *m = TimestampTransform{} }
func (m *TimestampTransform) String() string            { return proto.CompactTextString(m) }
func (*TimestampTransform) ProtoMessage()               {}
func (*TimestampTransform) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

type isTimestampTransform_TimestampTransform interface {
	isTimestampTransform_TimestampTransform()
}

type TimestampTransform_Delay_ struct {
	Delay *TimestampTransform_Delay `protobuf:"bytes,1,opt,name=delay,oneof"`
}
type TimestampTransform_AlignTo_ struct {
	AlignTo *TimestampTransform_AlignTo `protobuf:"bytes,2,opt,name=align_to,json=alignTo,oneof"`
}

func (*TimestampTransform_Delay_) isTimestampTransform_TimestampTransform()   {}
func (*TimestampTransform_AlignTo_) isTimestampTransform_TimestampTransform() {}

func (m *TimestampTransform) GetTimestampTransform() isTimestampTransform_TimestampTransform {
	if m != nil {
		return m.TimestampTransform
	}
	return nil
}

func (m *TimestampTransform) GetDelay() *TimestampTransform_Delay {
	if x, ok := m.GetTimestampTransform().(*TimestampTransform_Delay_); ok {
		return x.Delay
	}
	return nil
}

func (m *TimestampTransform) GetAlignTo() *TimestampTransform_AlignTo {
	if x, ok := m.GetTimestampTransform().(*TimestampTransform_AlignTo_); ok {
		return x.AlignTo
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*TimestampTransform) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _TimestampTransform_OneofMarshaler, _TimestampTransform_OneofUnmarshaler, _TimestampTransform_OneofSizer, []interface{}{
		(*TimestampTransform_Delay_)(nil),
		(*TimestampTransform_AlignTo_)(nil),
	}
}

func _TimestampTransform_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*TimestampTransform)
	// timestamp_transform
	switch x := m.TimestampTransform.(type) {
	case *TimestampTransform_Delay_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Delay); err != nil {
			return err
		}
	case *TimestampTransform_AlignTo_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AlignTo); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("TimestampTransform.TimestampTransform has unexpected type %T", x)
	}
	return nil
}

func _TimestampTransform_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*TimestampTransform)
	switch tag {
	case 1: // timestamp_transform.delay
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TimestampTransform_Delay)
		err := b.DecodeMessage(msg)
		m.TimestampTransform = &TimestampTransform_Delay_{msg}
		return true, err
	case 2: // timestamp_transform.align_to
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TimestampTransform_AlignTo)
		err := b.DecodeMessage(msg)
		m.TimestampTransform = &TimestampTransform_AlignTo_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _TimestampTransform_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*TimestampTransform)
	// timestamp_transform
	switch x := m.TimestampTransform.(type) {
	case *TimestampTransform_Delay_:
		s := proto.Size(x.Delay)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *TimestampTransform_AlignTo_:
		s := proto.Size(x.AlignTo)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type TimestampTransform_Delay struct {
	// (Required) The delay, in milliseconds.
	DelayMillis int64 `protobuf:"varint,1,opt,name=delay_millis,json=delayMillis" json:"delay_millis,omitempty"`
}

func (m *TimestampTransform_Delay) Reset()                    { *m = TimestampTransform_Delay{} }
func (m *TimestampTransform_Delay) String() string            { return proto.CompactTextString(m) }
func (*TimestampTransform_Delay) ProtoMessage()               {}
func (*TimestampTransform_Delay) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29, 0} }

func (m *TimestampTransform_Delay) GetDelayMillis() int64 {
	if m != nil {
		return m.DelayMillis
	}
	return 0
}

type TimestampTransform_AlignTo struct {
	// (Required) A duration to which delays should be quantized
	// in milliseconds.
	Period int64 `protobuf:"varint,3,opt,name=period" json:"period,omitempty"`
	// (Required) An offset from 0 for the quantization specified by
	// alignment_size, in milliseconds
	Offset int64 `protobuf:"varint,4,opt,name=offset" json:"offset,omitempty"`
}

func (m *TimestampTransform_AlignTo) Reset()                    { *m = TimestampTransform_AlignTo{} }
func (m *TimestampTransform_AlignTo) String() string            { return proto.CompactTextString(m) }
func (*TimestampTransform_AlignTo) ProtoMessage()               {}
func (*TimestampTransform_AlignTo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29, 1} }

func (m *TimestampTransform_AlignTo) GetPeriod() int64 {
	if m != nil {
		return m.Period
	}
	return 0
}

func (m *TimestampTransform_AlignTo) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

// A specification for how to "side input" a PCollection.
type SideInput struct {
	// (Required) URN of the access pattern required by the `view_fn` to present
	// the desired SDK-specific interface to a UDF.
	//
	// This access pattern defines the SDK harness <-> Runner Harness RPC
	// interface for accessing a side input.
	//
	// The only access pattern intended for Beam, because of its superior
	// performance possibilities, is "urn:beam:sideinput:multimap" (or some such
	// URN)
	AccessPattern *FunctionSpec `protobuf:"bytes,1,opt,name=access_pattern,json=accessPattern" json:"access_pattern,omitempty"`
	// (Required) The SdkFunctionSpec of the UDF that adapts a particular
	// access_pattern to a user-facing view type.
	//
	// For example, View.asSingleton() may include a `view_fn` that adapts a
	// specially-designed multimap to a single value per window.
	ViewFn *SdkFunctionSpec `protobuf:"bytes,2,opt,name=view_fn,json=viewFn" json:"view_fn,omitempty"`
	// (Required) The SdkFunctionSpec of the UDF that maps a main input window
	// to a side input window.
	//
	// For example, when the main input is in fixed windows of one hour, this
	// can specify that the side input should be accessed according to the day
	// in which that hour falls.
	WindowMappingFn *SdkFunctionSpec `protobuf:"bytes,3,opt,name=window_mapping_fn,json=windowMappingFn" json:"window_mapping_fn,omitempty"`
}

func (m *SideInput) Reset()                    { *m = SideInput{} }
func (m *SideInput) String() string            { return proto.CompactTextString(m) }
func (*SideInput) ProtoMessage()               {}
func (*SideInput) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

func (m *SideInput) GetAccessPattern() *FunctionSpec {
	if m != nil {
		return m.AccessPattern
	}
	return nil
}

func (m *SideInput) GetViewFn() *SdkFunctionSpec {
	if m != nil {
		return m.ViewFn
	}
	return nil
}

func (m *SideInput) GetWindowMappingFn() *SdkFunctionSpec {
	if m != nil {
		return m.WindowMappingFn
	}
	return nil
}

// An environment for executing UDFs. Generally an SDK container URL, but
// there can be many for a single SDK, for example to provide dependency
// isolation.
type Environment struct {
	// (Required) The URL of a container
	//
	// TODO: reconcile with Fn API's DockerContainer structure by
	// adding adequate metadata to know how to interpret the container
	Url string `protobuf:"bytes,1,opt,name=url" json:"url,omitempty"`
}

func (m *Environment) Reset()                    { *m = Environment{} }
func (m *Environment) String() string            { return proto.CompactTextString(m) }
func (*Environment) ProtoMessage()               {}
func (*Environment) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *Environment) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// A specification of a user defined function.
//
type SdkFunctionSpec struct {
	// (Required) A full specification of this function.
	Spec *FunctionSpec `protobuf:"bytes,1,opt,name=spec" json:"spec,omitempty"`
	// (Required) Reference to an execution environment capable of
	// invoking this function.
	EnvironmentId string `protobuf:"bytes,2,opt,name=environment_id,json=environmentId" json:"environment_id,omitempty"`
}

func (m *SdkFunctionSpec) Reset()                    { *m = SdkFunctionSpec{} }
func (m *SdkFunctionSpec) String() string            { return proto.CompactTextString(m) }
func (*SdkFunctionSpec) ProtoMessage()               {}
func (*SdkFunctionSpec) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

func (m *SdkFunctionSpec) GetSpec() *FunctionSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *SdkFunctionSpec) GetEnvironmentId() string {
	if m != nil {
		return m.EnvironmentId
	}
	return ""
}

// A URN along with a parameter object whose schema is determined by the
// URN.
//
// This structure is reused in two distinct, but compatible, ways:
//
// 1. This can be a specification of the function over PCollections
//    that a PTransform computes.
// 2. This can be a specification of a user-defined function, possibly
//    SDK-specific. (external to this message must be adequate context
//    to indicate the environment in which the UDF can be understood).
//
// Though not explicit in this proto, there are two possibilities
// for the relationship of a runner to this specification that
// one should bear in mind:
//
// 1. The runner understands the URN. For example, it might be
//    a well-known URN like "urn:beam:transform:Top" or
//    "urn:beam:windowfn:FixedWindows" with
//    an agreed-upon payload (e.g. a number or duration,
//    respectively).
// 2. The runner does not understand the URN. It might be an
//    SDK specific URN such as "urn:beam:dofn:javasdk:1.0"
//    that indicates to the SDK what the payload is,
//    such as a serialized Java DoFn from a particular
//    version of the Beam Java SDK. The payload will often
//    then be an opaque message such as bytes in a
//    language-specific serialization format.
type FunctionSpec struct {
	// (Required) A URN that describes the accompanying payload.
	// For any URN that is not recognized (by whomever is inspecting
	// it) the parameter payload should be treated as opaque and
	// passed as-is.
	Urn string `protobuf:"bytes,1,opt,name=urn" json:"urn,omitempty"`
	// (Optional) The data specifying any parameters to the URN. If
	// the URN does not require any arguments, this may be omitted.
	Payload []byte `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (m *FunctionSpec) Reset()                    { *m = FunctionSpec{} }
func (m *FunctionSpec) String() string            { return proto.CompactTextString(m) }
func (*FunctionSpec) ProtoMessage()               {}
func (*FunctionSpec) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *FunctionSpec) GetUrn() string {
	if m != nil {
		return m.Urn
	}
	return ""
}

func (m *FunctionSpec) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

// TODO: transfer javadoc here
type DisplayData struct {
	// (Required) The list of display data.
	Items []*DisplayData_Item `protobuf:"bytes,1,rep,name=items" json:"items,omitempty"`
}

func (m *DisplayData) Reset()                    { *m = DisplayData{} }
func (m *DisplayData) String() string            { return proto.CompactTextString(m) }
func (*DisplayData) ProtoMessage()               {}
func (*DisplayData) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *DisplayData) GetItems() []*DisplayData_Item {
	if m != nil {
		return m.Items
	}
	return nil
}

// A complete identifier for a DisplayData.Item
type DisplayData_Identifier struct {
	// (Required) The transform originating this display data.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId" json:"transform_id,omitempty"`
	// (Optional) The URN indicating the type of the originating transform,
	// if there is one.
	TransformUrn string `protobuf:"bytes,2,opt,name=transform_urn,json=transformUrn" json:"transform_urn,omitempty"`
	Key          string `protobuf:"bytes,3,opt,name=key" json:"key,omitempty"`
}

func (m *DisplayData_Identifier) Reset()                    { *m = DisplayData_Identifier{} }
func (m *DisplayData_Identifier) String() string            { return proto.CompactTextString(m) }
func (*DisplayData_Identifier) ProtoMessage()               {}
func (*DisplayData_Identifier) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34, 0} }

func (m *DisplayData_Identifier) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *DisplayData_Identifier) GetTransformUrn() string {
	if m != nil {
		return m.TransformUrn
	}
	return ""
}

func (m *DisplayData_Identifier) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

// A single item of display data.
type DisplayData_Item struct {
	// (Required)
	Id *DisplayData_Identifier `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// (Required)
	Type DisplayData_Type_Enum `protobuf:"varint,2,opt,name=type,enum=org.apache.beam.model.pipeline.v1.DisplayData_Type_Enum" json:"type,omitempty"`
	// (Required)
	Value *google_protobuf.Any `protobuf:"bytes,3,opt,name=value" json:"value,omitempty"`
	// (Optional)
	ShortValue *google_protobuf.Any `protobuf:"bytes,4,opt,name=short_value,json=shortValue" json:"short_value,omitempty"`
	// (Optional)
	Label string `protobuf:"bytes,5,opt,name=label" json:"label,omitempty"`
	// (Optional)
	LinkUrl string `protobuf:"bytes,6,opt,name=link_url,json=linkUrl" json:"link_url,omitempty"`
}

func (m *DisplayData_Item) Reset()                    { *m = DisplayData_Item{} }
func (m *DisplayData_Item) String() string            { return proto.CompactTextString(m) }
func (*DisplayData_Item) ProtoMessage()               {}
func (*DisplayData_Item) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34, 1} }

func (m *DisplayData_Item) GetId() *DisplayData_Identifier {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *DisplayData_Item) GetType() DisplayData_Type_Enum {
	if m != nil {
		return m.Type
	}
	return DisplayData_Type_UNSPECIFIED
}

func (m *DisplayData_Item) GetValue() *google_protobuf.Any {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *DisplayData_Item) GetShortValue() *google_protobuf.Any {
	if m != nil {
		return m.ShortValue
	}
	return nil
}

func (m *DisplayData_Item) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *DisplayData_Item) GetLinkUrl() string {
	if m != nil {
		return m.LinkUrl
	}
	return ""
}

type DisplayData_Type struct {
}

func (m *DisplayData_Type) Reset()                    { *m = DisplayData_Type{} }
func (m *DisplayData_Type) String() string            { return proto.CompactTextString(m) }
func (*DisplayData_Type) ProtoMessage()               {}
func (*DisplayData_Type) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34, 2} }

func init() {
	proto.RegisterType((*Components)(nil), "org.apache.beam.model.pipeline.v1.Components")
	proto.RegisterType((*MessageWithComponents)(nil), "org.apache.beam.model.pipeline.v1.MessageWithComponents")
	proto.RegisterType((*Pipeline)(nil), "org.apache.beam.model.pipeline.v1.Pipeline")
	proto.RegisterType((*PTransform)(nil), "org.apache.beam.model.pipeline.v1.PTransform")
	proto.RegisterType((*PCollection)(nil), "org.apache.beam.model.pipeline.v1.PCollection")
	proto.RegisterType((*ParDoPayload)(nil), "org.apache.beam.model.pipeline.v1.ParDoPayload")
	proto.RegisterType((*Parameter)(nil), "org.apache.beam.model.pipeline.v1.Parameter")
	proto.RegisterType((*Parameter_Type)(nil), "org.apache.beam.model.pipeline.v1.Parameter.Type")
	proto.RegisterType((*StateSpec)(nil), "org.apache.beam.model.pipeline.v1.StateSpec")
	proto.RegisterType((*ValueStateSpec)(nil), "org.apache.beam.model.pipeline.v1.ValueStateSpec")
	proto.RegisterType((*BagStateSpec)(nil), "org.apache.beam.model.pipeline.v1.BagStateSpec")
	proto.RegisterType((*CombiningStateSpec)(nil), "org.apache.beam.model.pipeline.v1.CombiningStateSpec")
	proto.RegisterType((*MapStateSpec)(nil), "org.apache.beam.model.pipeline.v1.MapStateSpec")
	proto.RegisterType((*SetStateSpec)(nil), "org.apache.beam.model.pipeline.v1.SetStateSpec")
	proto.RegisterType((*TimerSpec)(nil), "org.apache.beam.model.pipeline.v1.TimerSpec")
	proto.RegisterType((*IsBounded)(nil), "org.apache.beam.model.pipeline.v1.IsBounded")
	proto.RegisterType((*ReadPayload)(nil), "org.apache.beam.model.pipeline.v1.ReadPayload")
	proto.RegisterType((*WindowIntoPayload)(nil), "org.apache.beam.model.pipeline.v1.WindowIntoPayload")
	proto.RegisterType((*CombinePayload)(nil), "org.apache.beam.model.pipeline.v1.CombinePayload")
	proto.RegisterType((*TestStreamPayload)(nil), "org.apache.beam.model.pipeline.v1.TestStreamPayload")
	proto.RegisterType((*TestStreamPayload_Event)(nil), "org.apache.beam.model.pipeline.v1.TestStreamPayload.Event")
	proto.RegisterType((*TestStreamPayload_Event_AdvanceWatermark)(nil), "org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceWatermark")
	proto.RegisterType((*TestStreamPayload_Event_AdvanceProcessingTime)(nil), "org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceProcessingTime")
	proto.RegisterType((*TestStreamPayload_Event_AddElements)(nil), "org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AddElements")
	proto.RegisterType((*TestStreamPayload_TimestampedElement)(nil), "org.apache.beam.model.pipeline.v1.TestStreamPayload.TimestampedElement")
	proto.RegisterType((*WriteFilesPayload)(nil), "org.apache.beam.model.pipeline.v1.WriteFilesPayload")
	proto.RegisterType((*Coder)(nil), "org.apache.beam.model.pipeline.v1.Coder")
	proto.RegisterType((*WindowingStrategy)(nil), "org.apache.beam.model.pipeline.v1.WindowingStrategy")
	proto.RegisterType((*MergeStatus)(nil), "org.apache.beam.model.pipeline.v1.MergeStatus")
	proto.RegisterType((*AccumulationMode)(nil), "org.apache.beam.model.pipeline.v1.AccumulationMode")
	proto.RegisterType((*ClosingBehavior)(nil), "org.apache.beam.model.pipeline.v1.ClosingBehavior")
	proto.RegisterType((*OnTimeBehavior)(nil), "org.apache.beam.model.pipeline.v1.OnTimeBehavior")
	proto.RegisterType((*OutputTime)(nil), "org.apache.beam.model.pipeline.v1.OutputTime")
	proto.RegisterType((*TimeDomain)(nil), "org.apache.beam.model.pipeline.v1.TimeDomain")
	proto.RegisterType((*Trigger)(nil), "org.apache.beam.model.pipeline.v1.Trigger")
	proto.RegisterType((*Trigger_AfterAll)(nil), "org.apache.beam.model.pipeline.v1.Trigger.AfterAll")
	proto.RegisterType((*Trigger_AfterAny)(nil), "org.apache.beam.model.pipeline.v1.Trigger.AfterAny")
	proto.RegisterType((*Trigger_AfterEach)(nil), "org.apache.beam.model.pipeline.v1.Trigger.AfterEach")
	proto.RegisterType((*Trigger_AfterEndOfWindow)(nil), "org.apache.beam.model.pipeline.v1.Trigger.AfterEndOfWindow")
	proto.RegisterType((*Trigger_AfterProcessingTime)(nil), "org.apache.beam.model.pipeline.v1.Trigger.AfterProcessingTime")
	proto.RegisterType((*Trigger_AfterSynchronizedProcessingTime)(nil), "org.apache.beam.model.pipeline.v1.Trigger.AfterSynchronizedProcessingTime")
	proto.RegisterType((*Trigger_Default)(nil), "org.apache.beam.model.pipeline.v1.Trigger.Default")
	proto.RegisterType((*Trigger_ElementCount)(nil), "org.apache.beam.model.pipeline.v1.Trigger.ElementCount")
	proto.RegisterType((*Trigger_Never)(nil), "org.apache.beam.model.pipeline.v1.Trigger.Never")
	proto.RegisterType((*Trigger_Always)(nil), "org.apache.beam.model.pipeline.v1.Trigger.Always")
	proto.RegisterType((*Trigger_OrFinally)(nil), "org.apache.beam.model.pipeline.v1.Trigger.OrFinally")
	proto.RegisterType((*Trigger_Repeat)(nil), "org.apache.beam.model.pipeline.v1.Trigger.Repeat")
	proto.RegisterType((*TimestampTransform)(nil), "org.apache.beam.model.pipeline.v1.TimestampTransform")
	proto.RegisterType((*TimestampTransform_Delay)(nil), "org.apache.beam.model.pipeline.v1.TimestampTransform.Delay")
	proto.RegisterType((*TimestampTransform_AlignTo)(nil), "org.apache.beam.model.pipeline.v1.TimestampTransform.AlignTo")
	proto.RegisterType((*SideInput)(nil), "org.apache.beam.model.pipeline.v1.SideInput")
	proto.RegisterType((*Environment)(nil), "org.apache.beam.model.pipeline.v1.Environment")
	proto.RegisterType((*SdkFunctionSpec)(nil), "org.apache.beam.model.pipeline.v1.SdkFunctionSpec")
	proto.RegisterType((*FunctionSpec)(nil), "org.apache.beam.model.pipeline.v1.FunctionSpec")
	proto.RegisterType((*DisplayData)(nil), "org.apache.beam.model.pipeline.v1.DisplayData")
	proto.RegisterType((*DisplayData_Identifier)(nil), "org.apache.beam.model.pipeline.v1.DisplayData.Identifier")
	proto.RegisterType((*DisplayData_Item)(nil), "org.apache.beam.model.pipeline.v1.DisplayData.Item")
	proto.RegisterType((*DisplayData_Type)(nil), "org.apache.beam.model.pipeline.v1.DisplayData.Type")
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.Parameter_Type_Enum", Parameter_Type_Enum_name, Parameter_Type_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.IsBounded_Enum", IsBounded_Enum_name, IsBounded_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.MergeStatus_Enum", MergeStatus_Enum_name, MergeStatus_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.AccumulationMode_Enum", AccumulationMode_Enum_name, AccumulationMode_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.ClosingBehavior_Enum", ClosingBehavior_Enum_name, ClosingBehavior_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.OnTimeBehavior_Enum", OnTimeBehavior_Enum_name, OnTimeBehavior_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.OutputTime_Enum", OutputTime_Enum_name, OutputTime_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.TimeDomain_Enum", TimeDomain_Enum_name, TimeDomain_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.DisplayData_Type_Enum", DisplayData_Type_Enum_name, DisplayData_Type_Enum_value)
}

func init() { proto.RegisterFile("beam_runner_api.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 3390 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5b, 0xcd, 0x73, 0x23, 0x49,
	0x56, 0xd7, 0xf7, 0xc7, 0x93, 0x2c, 0xcb, 0xe9, 0x6e, 0xd0, 0x28, 0x36, 0x98, 0x9e, 0x62, 0x81,
	0x66, 0x18, 0x34, 0xdb, 0xee, 0x1d, 0x66, 0x7a, 0x86, 0x9d, 0x5d, 0x59, 0x2a, 0xb5, 0xd4, 0x63,
	0x4b, 0x9a, 0x92, 0xdc, 0xa6, 0x67, 0x97, 0xae, 0x49, 0xab, 0x52, 0x72, 0x85, 0x4b, 0x59, 0xa2,
	0xaa, 0x64, 0x87, 0x08, 0x36, 0xf6, 0x46, 0x10, 0xc1, 0x05, 0x8e, 0x7b, 0x85, 0x23, 0x27, 0x76,
	0x08, 0x22, 0x38, 0xf3, 0x27, 0x70, 0xe3, 0xbf, 0x20, 0x08, 0xee, 0x44, 0x7e, 0x54, 0xa9, 0x24,
	0xd9, 0x3d, 0x25, 0xd9, 0x41, 0x70, 0x73, 0x3d, 0xd5, 0xfb, 0xbd, 0x57, 0x2f, 0xdf, 0x67, 0x66,
	0x1a, 0x1e, 0x5f, 0x10, 0x3c, 0xd5, 0x9d, 0x39, 0xa5, 0xc4, 0xd1, 0xf1, 0xcc, 0xac, 0xcd, 0x1c,
	0xdb, 0xb3, 0xd1, 0x07, 0xb6, 0x33, 0xa9, 0xe1, 0x19, 0x1e, 0x5d, 0x92, 0x1a, 0x7b, 0xa3, 0x36,
	0xb5, 0x0d, 0x62, 0xd5, 0x66, 0xe6, 0x8c, 0x58, 0x26, 0x25, 0xb5, 0xeb, 0x67, 0xd5, 0xf7, 0x26,
	0xb6, 0x3d, 0xb1, 0xc8, 0xc7, 0x9c, 0xe1, 0x62, 0x3e, 0xfe, 0x18, 0xd3, 0x85, 0xe0, 0x56, 0xfe,
	0x35, 0x07, 0xd0, 0xb0, 0xa7, 0x33, 0x9b, 0x12, 0xea, 0xb9, 0xe8, 0xcf, 0x01, 0x3c, 0x07, 0x53,
	0x77, 0x6c, 0x3b, 0x53, 0xb7, 0x12, 0x7f, 0x92, 0x7c, 0x5a, 0x38, 0xfa, 0x49, 0xed, 0x7b, 0x25,
	0xd4, 0x96, 0x10, 0xb5, 0x61, 0xc0, 0xaf, 0x52, 0xcf, 0x59, 0x68, 0x21, 0x40, 0x34, 0x82, 0xe2,
	0x6c, 0x64, 0x5b, 0x16, 0x19, 0x79, 0xa6, 0x4d, 0xdd, 0x4a, 0x82, 0x0b, 0xf8, 0xe9, 0x76, 0x02,
	0xfa, 0x21, 0x04, 0x21, 0x62, 0x05, 0x14, 0x2d, 0xe0, 0xd1, 0x8d, 0x49, 0x0d, 0xfb, 0xc6, 0xa4,
	0x13, 0xdd, 0xf5, 0x1c, 0xec, 0x91, 0x89, 0x49, 0xdc, 0x4a, 0x92, 0x0b, 0x6b, 0x6d, 0x27, 0xec,
	0xdc, 0x47, 0x1a, 0x04, 0x40, 0x42, 0xe6, 0xe1, 0xcd, 0xe6, 0x2f, 0xe8, 0x6b, 0xc8, 0x8c, 0x6c,
	0x83, 0x38, 0x6e, 0x25, 0xc5, 0x85, 0xbd, 0xd8, 0x4e, 0x58, 0x83, 0xf3, 0x0a, 0x7c, 0x09, 0xc4,
	0x4c, 0x46, 0xe8, 0xb5, 0xe9, 0xd8, 0x74, 0xca, 0xde, 0xa9, 0xa4, 0x77, 0x31, 0x99, 0x1a, 0x42,
	0x90, 0x26, 0x0b, 0x83, 0x56, 0x2d, 0xd8, 0x5f, 0x5b, 0x36, 0x54, 0x86, 0xe4, 0x15, 0x59, 0x54,
	0xe2, 0x4f, 0xe2, 0x4f, 0xf3, 0x1a, 0xfb, 0x13, 0x35, 0x20, 0x7d, 0x8d, 0xad, 0x39, 0xa9, 0x24,
	0x9e, 0xc4, 0x9f, 0x16, 0x8e, 0xfe, 0x38, 0x82, 0x0a, 0xfd, 0x00, 0x55, 0x13, 0xbc, 0x9f, 0x27,
	0x3e, 0x8b, 0x57, 0x6d, 0x38, 0xd8, 0x58, 0xc3, 0x5b, 0xe4, 0x35, 0x57, 0xe5, 0xd5, 0xa2, 0xc8,
	0x6b, 0x04, 0xb0, 0x61, 0x81, 0x7f, 0x05, 0x95, 0xbb, 0xd6, 0xf1, 0x16, 0xb9, 0xaf, 0x56, 0xe5,
	0xfe, 0x38, 0x82, 0xdc, 0x75, 0xf4, 0x45, 0x58, 0xfa, 0x08, 0x0a, 0xa1, 0x85, 0xbd, 0x45, 0xe0,
	0x97, 0xab, 0x02, 0x9f, 0x46, 0x5a, 0x5b, 0x83, 0x38, 0x6b, 0x36, 0xdd, 0x58, 0xe4, 0x87, 0xb1,
	0x69, 0x08, 0x36, 0x24, 0x50, 0xf9, 0xb7, 0x1c, 0x3c, 0x3e, 0x25, 0xae, 0x8b, 0x27, 0xe4, 0xdc,
	0xf4, 0x2e, 0x43, 0x39, 0xe4, 0x14, 0x60, 0x14, 0x3c, 0x71, 0xe1, 0xd1, 0x9c, 0x65, 0x09, 0xa1,
	0x85, 0x00, 0xd0, 0xcf, 0x20, 0xcd, 0x43, 0x61, 0x5b, 0xeb, 0xb4, 0x63, 0x9a, 0x60, 0x44, 0xbf,
	0x80, 0xfd, 0x91, 0x3d, 0xbd, 0x30, 0x29, 0xd1, 0x67, 0x78, 0x61, 0xd9, 0xd8, 0xa8, 0x24, 0x39,
	0xd6, 0xb3, 0x68, 0x5a, 0x31, 0xce, 0xbe, 0x60, 0x6c, 0xc7, 0xb4, 0xd2, 0x68, 0x85, 0x82, 0xbe,
	0x85, 0x03, 0xd7, 0xb8, 0xd2, 0xc7, 0x73, 0xca, 0xfd, 0x4e, 0x77, 0x67, 0x64, 0x54, 0x49, 0x71,
	0xfc, 0xa3, 0x08, 0xf8, 0x03, 0xe3, 0xaa, 0x25, 0x59, 0x07, 0x33, 0x32, 0x6a, 0xc7, 0xb4, 0x7d,
	0x77, 0x95, 0x84, 0xce, 0xa1, 0x34, 0xc3, 0x8e, 0x6e, 0xd8, 0x81, 0xfa, 0x19, 0x0e, 0xff, 0x71,
	0x94, 0x88, 0xc0, 0x4e, 0xd3, 0x5e, 0x2a, 0x5f, 0x9c, 0x85, 0x9e, 0x51, 0x0f, 0x60, 0x16, 0x64,
	0xe7, 0x4a, 0x76, 0x87, 0xb0, 0x6e, 0xc7, 0xb4, 0x10, 0x04, 0xd2, 0xa0, 0x10, 0x4a, 0xc5, 0x95,
	0xdc, 0x2e, 0x81, 0xdb, 0x8e, 0x69, 0x61, 0x10, 0x34, 0x80, 0xa2, 0x43, 0xb0, 0x11, 0x7c, 0x7b,
	0x3e, 0x32, 0xa8, 0x46, 0xb0, 0xb1, 0xfc, 0xf4, 0x82, 0xb3, 0x7c, 0x64, 0x3e, 0xea, 0x9a, 0x06,
	0xd1, 0x4d, 0x3a, 0x9b, 0x7b, 0x95, 0x02, 0x87, 0xfc, 0x28, 0xca, 0x6a, 0x99, 0x06, 0xe9, 0x30,
	0x9e, 0x76, 0x4c, 0xcb, 0xbb, 0xfe, 0x03, 0x1a, 0x83, 0x2c, 0x07, 0xba, 0x49, 0xbd, 0xe5, 0x32,
	0x15, 0xb7, 0x4c, 0x20, 0x1d, 0xea, 0x85, 0xd6, 0xea, 0xe0, 0x66, 0x9d, 0x88, 0x08, 0xa0, 0x8d,
	0xd2, 0xb6, 0xa8, 0xec, 0xed, 0x9e, 0xa7, 0x96, 0x62, 0x42, 0x44, 0xf4, 0x1a, 0xf6, 0x56, 0xdd,
	0xb9, 0x14, 0xd9, 0xdf, 0xd6, 0x7c, 0xb9, 0x38, 0x0e, 0x3d, 0x1f, 0x67, 0x20, 0xe5, 0xd8, 0xb6,
	0xa7, 0xfc, 0x67, 0x1c, 0x72, 0x7d, 0xc9, 0xf4, 0xd0, 0xe9, 0xe2, 0x23, 0x40, 0x4c, 0x86, 0x1e,
	0x38, 0xa5, 0x6e, 0x1a, 0xa2, 0xd1, 0xc8, 0x6b, 0x65, 0xf6, 0x4b, 0xe0, 0xbb, 0x1d, 0x83, 0x15,
	0xec, 0xa2, 0x61, 0xba, 0x33, 0x0b, 0x2f, 0x74, 0x03, 0x7b, 0x58, 0xe6, 0x85, 0x28, 0xce, 0xd5,
	0x14, 0x6c, 0x4d, 0xec, 0x61, 0xad, 0x60, 0x2c, 0x1f, 0x94, 0xbf, 0x4d, 0x01, 0x2c, 0x03, 0x04,
	0xbd, 0x0f, 0x85, 0x39, 0x35, 0xff, 0x62, 0x4e, 0x74, 0x8a, 0xa7, 0xa4, 0x92, 0xe6, 0xb9, 0x18,
	0x04, 0xa9, 0x8b, 0xa7, 0x04, 0x35, 0x20, 0xc5, 0x6d, 0x1c, 0xdf, 0xc9, 0xc6, 0x1a, 0x67, 0x46,
	0x3f, 0x84, 0x3d, 0x77, 0x7e, 0x11, 0x6a, 0xdd, 0xc4, 0x07, 0xaf, 0x12, 0x59, 0x7b, 0xc2, 0x1d,
	0xde, 0xef, 0x85, 0x5e, 0x6c, 0x15, 0xeb, 0x35, 0xee, 0xeb, 0x7e, 0x7b, 0x22, 0x80, 0xd0, 0x10,
	0xb2, 0xf6, 0xdc, 0xe3, 0x98, 0xa2, 0xe5, 0xf9, 0x7c, 0x3b, 0xcc, 0x9e, 0x60, 0x16, 0xa0, 0x3e,
	0xd4, 0xc6, 0xb2, 0x64, 0xee, 0xbd, 0x2c, 0xd5, 0x17, 0x50, 0x08, 0xe9, 0x7f, 0x4b, 0x69, 0x7c,
	0x14, 0x2e, 0x8d, 0xf9, 0x70, 0x6d, 0xfd, 0x1c, 0x8a, 0x61, 0x35, 0xb7, 0xe1, 0x55, 0xfe, 0x21,
	0x01, 0x85, 0x50, 0x72, 0x5b, 0x77, 0x87, 0xf8, 0x86, 0x3b, 0xbc, 0x07, 0x39, 0x5e, 0xb5, 0x74,
	0xd3, 0x90, 0x68, 0x59, 0xfe, 0xdc, 0x31, 0x50, 0x1f, 0xc0, 0x74, 0xf5, 0x0b, 0x7b, 0x4e, 0x0d,
	0x22, 0x4a, 0x58, 0x29, 0x52, 0x09, 0xeb, 0xb8, 0xc7, 0x82, 0xa7, 0xa6, 0xd2, 0xf9, 0x54, 0xcb,
	0x9b, 0xfe, 0x33, 0x3a, 0x82, 0xc7, 0x9b, 0xf9, 0x84, 0x49, 0x4e, 0x71, 0xc9, 0x1b, 0x3d, 0xee,
	0xa2, 0x63, 0x6c, 0xac, 0x4d, 0xfa, 0xfe, 0x21, 0xf3, 0x9b, 0x0c, 0x14, 0xc3, 0x85, 0x0a, 0xbd,
	0x84, 0xb4, 0x61, 0xeb, 0x63, 0x2a, 0x83, 0x62, 0x87, 0x3a, 0xaa, 0xa5, 0x0c, 0xbb, 0x45, 0xd1,
	0x09, 0xc0, 0x0c, 0x3b, 0x78, 0x4a, 0x3c, 0xd6, 0x94, 0x8b, 0x71, 0xe3, 0xa3, 0x68, 0x65, 0x53,
	0x30, 0x69, 0x21, 0x7e, 0xf4, 0x2d, 0x14, 0x96, 0x55, 0xc3, 0x0f, 0xa2, 0x9f, 0x6e, 0x59, 0x85,
	0x97, 0x35, 0xc4, 0x1f, 0x90, 0x82, 0x3a, 0x22, 0x24, 0x78, 0xd8, 0x23, 0x3c, 0xed, 0xfa, 0x21,
	0xb5, 0xbd, 0x04, 0x06, 0xc1, 0xac, 0x10, 0x48, 0x08, 0x08, 0x4c, 0x82, 0x67, 0x4e, 0x89, 0x23,
	0x25, 0xa4, 0x77, 0x93, 0x30, 0x64, 0x10, 0x61, 0x09, 0x5e, 0x40, 0x40, 0xbf, 0x03, 0xe0, 0xce,
	0x2c, 0xd3, 0xf3, 0xf0, 0x85, 0x45, 0x78, 0xe8, 0xe6, 0xb4, 0x10, 0xa5, 0x7a, 0x05, 0xfb, 0x6b,
	0x26, 0xb8, 0x25, 0xa2, 0x8e, 0x57, 0x1b, 0xd5, 0xad, 0x6a, 0x73, 0x38, 0x76, 0x99, 0xb0, 0x55,
	0x6b, 0x3c, 0x90, 0x30, 0x1f, 0x74, 0x4d, 0xd8, 0x9a, 0x61, 0x1e, 0x46, 0x58, 0x00, 0x1a, 0xce,
	0x2c, 0xdf, 0xc5, 0x21, 0x1f, 0xb8, 0x29, 0x7a, 0x05, 0x29, 0x6f, 0x31, 0x13, 0x09, 0xa5, 0x74,
	0xf4, 0x27, 0xdb, 0xb8, 0x78, 0x6d, 0xb8, 0x98, 0x11, 0x91, 0x1a, 0x38, 0x46, 0xf5, 0x1b, 0x48,
	0x31, 0x92, 0xa2, 0x41, 0x8a, 0x51, 0xd1, 0x3e, 0x14, 0xce, 0xba, 0x83, 0xbe, 0xda, 0xe8, 0xb4,
	0x3a, 0x6a, 0xb3, 0x1c, 0x43, 0x00, 0x99, 0xf3, 0x4e, 0xb7, 0xd9, 0x3b, 0x2f, 0xc7, 0xd1, 0x23,
	0x28, 0xf7, 0x3b, 0x7d, 0xf5, 0xa4, 0xd3, 0x55, 0xf5, 0x5e, 0x7f, 0xd8, 0xe9, 0x75, 0x07, 0xe5,
	0x04, 0xfa, 0x6d, 0x38, 0xd4, 0xd4, 0xc1, 0x50, 0xeb, 0x34, 0x18, 0x45, 0x1f, 0x6a, 0xf5, 0xc6,
	0x57, 0xaa, 0x56, 0x4e, 0x2a, 0xff, 0x9c, 0x84, 0x7c, 0x60, 0x3b, 0xa4, 0x01, 0xf0, 0x0f, 0xd2,
	0x43, 0x15, 0x30, 0x4a, 0x46, 0x7b, 0xcd, 0x98, 0x02, 0x18, 0xd6, 0x8b, 0x71, 0x18, 0x8e, 0x79,
	0x02, 0xb9, 0x0b, 0x3c, 0x11, 0x88, 0x89, 0xc8, 0x35, 0xf5, 0x18, 0x4f, 0xc2, 0x78, 0xd9, 0x0b,
	0x3c, 0xe1, 0x68, 0x6f, 0x41, 0xf6, 0xfb, 0x3c, 0x43, 0x32, 0x4c, 0xd1, 0x22, 0x7c, 0x12, 0x79,
	0x74, 0xe0, 0xd9, 0x73, 0x89, 0xbc, 0x17, 0xc0, 0xf9, 0xda, 0x4e, 0xf1, 0x2c, 0x3c, 0x34, 0x44,
	0xd1, 0xf6, 0x14, 0xcf, 0x56, 0xb4, 0x9d, 0xe2, 0x99, 0x8f, 0xe6, 0x12, 0x4f, 0xa0, 0xa5, 0x23,
	0xa3, 0x0d, 0x88, 0xb7, 0x82, 0xe6, 0x12, 0xcf, 0x6f, 0xd7, 0x18, 0x92, 0xf2, 0x47, 0x50, 0x5a,
	0x35, 0xf8, 0x4a, 0x91, 0x8a, 0xaf, 0x14, 0x29, 0xe5, 0x33, 0x28, 0x86, 0x6d, 0x89, 0x9e, 0x42,
	0x99, 0x58, 0x84, 0x4d, 0x8f, 0xfa, 0x1a, 0x4b, 0x49, 0xd2, 0x1b, 0x92, 0xf3, 0xd7, 0x71, 0x40,
	0x9b, 0x26, 0x43, 0x3f, 0x82, 0x47, 0x78, 0x34, 0x9a, 0x4f, 0xe7, 0x16, 0xf6, 0x6c, 0x67, 0x1d,
	0x04, 0x85, 0x7e, 0x93, 0x40, 0xe8, 0x6b, 0xde, 0x51, 0xf2, 0x79, 0x6f, 0x4c, 0xa5, 0x0f, 0xec,
	0x52, 0x42, 0xf2, 0x12, 0xa5, 0x45, 0x95, 0xd7, 0x50, 0x0c, 0xdb, 0x1c, 0x3d, 0x81, 0xe2, 0x15,
	0x59, 0xac, 0x2b, 0x03, 0x57, 0x64, 0xe1, 0x2b, 0xf1, 0x43, 0x28, 0x09, 0xd7, 0x5e, 0xab, 0xe6,
	0x45, 0x4e, 0x6d, 0x2c, 0xad, 0x15, 0xb6, 0xfe, 0x16, 0xd6, 0xfa, 0x16, 0xf2, 0x41, 0x5a, 0x40,
	0x03, 0x91, 0xd4, 0x75, 0xc3, 0x9e, 0x62, 0x93, 0xca, 0x24, 0x70, 0x14, 0x31, 0xb3, 0x34, 0x39,
	0x93, 0x48, 0x00, 0x3c, 0x8f, 0x0b, 0x82, 0xf2, 0x33, 0xc8, 0x07, 0x9d, 0x83, 0xf2, 0xfc, 0xae,
	0x5c, 0xb0, 0x07, 0xf9, 0xb3, 0xee, 0x71, 0xef, 0xac, 0xdb, 0x54, 0x9b, 0xe5, 0x38, 0x2a, 0x40,
	0xd6, 0x7f, 0x48, 0x28, 0xff, 0x14, 0x87, 0x42, 0x68, 0x08, 0x43, 0xaf, 0x20, 0xe3, 0xda, 0x73,
	0x67, 0x44, 0xee, 0x51, 0xd7, 0x25, 0xc2, 0x5a, 0x33, 0x94, 0xb8, 0x7f, 0x33, 0xa4, 0x18, 0x70,
	0xb0, 0x31, 0x86, 0xa1, 0x1e, 0xe4, 0xe5, 0x64, 0x77, 0xaf, 0x6e, 0x24, 0x27, 0x40, 0x5a, 0x54,
	0xf9, 0x97, 0x24, 0x94, 0x56, 0xf7, 0x14, 0xd6, 0xfc, 0x35, 0xfe, 0x00, 0xfe, 0x7a, 0x67, 0xd0,
	0x24, 0xee, 0x0c, 0x9a, 0xd5, 0x4e, 0x29, 0x79, 0xcf, 0x4e, 0xe9, 0x62, 0xb5, 0x53, 0x12, 0x7d,
	0x4c, 0x7d, 0xeb, 0xed, 0x96, 0x77, 0xf5, 0x4a, 0xff, 0xa7, 0x7d, 0x84, 0xf2, 0x1f, 0x19, 0x38,
	0x18, 0x12, 0xd7, 0x1b, 0x78, 0x0e, 0xc1, 0x53, 0x7f, 0xe5, 0xee, 0xce, 0x83, 0x48, 0x83, 0x0c,
	0xb9, 0xe6, 0x23, 0x6d, 0x22, 0xf2, 0x5c, 0xb4, 0x21, 0xa0, 0xa6, 0x32, 0x08, 0x4d, 0x22, 0x55,
	0xff, 0x2b, 0x05, 0x69, 0x4e, 0x41, 0xd7, 0xb0, 0x7f, 0x83, 0x3d, 0xe2, 0x4c, 0xb1, 0x73, 0xa5,
	0xf3, 0x5f, 0xa5, 0xdf, 0x7c, 0xb5, 0xbb, 0x98, 0x5a, 0xdd, 0xb8, 0xc6, 0x74, 0x44, 0xce, 0x7d,
	0xe0, 0x76, 0x4c, 0x2b, 0x05, 0x52, 0x84, 0xdc, 0xbf, 0x8e, 0xc3, 0xe3, 0x99, 0x63, 0x8f, 0x88,
	0xeb, 0xb2, 0x82, 0xc8, 0x93, 0x8e, 0x10, 0x2f, 0xec, 0xdb, 0xbf, 0xbf, 0xf8, 0x7e, 0x00, 0xcf,
	0x92, 0x53, 0x3b, 0xa6, 0x1d, 0xce, 0x56, 0x28, 0x42, 0x91, 0x29, 0xec, 0xf9, 0x89, 0x52, 0xc8,
	0x17, 0x65, 0xb9, 0x75, 0x2f, 0xf9, 0x86, 0x2a, 0x20, 0xdd, 0x76, 0x4c, 0x2b, 0x4a, 0x78, 0xfe,
	0x5b, 0xf5, 0x53, 0x28, 0xaf, 0x5b, 0x07, 0xfd, 0x2e, 0xec, 0x51, 0x72, 0xa3, 0x07, 0x16, 0xe2,
	0x2b, 0x90, 0xd4, 0x8a, 0x94, 0xdc, 0x04, 0x2f, 0x55, 0x8f, 0xe1, 0xf1, 0xad, 0xdf, 0x85, 0xfe,
	0x10, 0xca, 0x58, 0xfc, 0xa0, 0x1b, 0x73, 0x07, 0xf3, 0xfd, 0x32, 0x01, 0xb0, 0x2f, 0xe9, 0x4d,
	0x49, 0xae, 0x3a, 0x50, 0x08, 0xe9, 0x86, 0x46, 0x90, 0x93, 0xba, 0xf9, 0x27, 0x34, 0x2f, 0x77,
	0xfa, 0x6a, 0xa6, 0x86, 0xeb, 0xe1, 0xe9, 0x8c, 0xf8, 0xd8, 0x5a, 0x00, 0x7c, 0x9c, 0x85, 0x34,
	0xb7, 0x6b, 0xf5, 0xe7, 0x80, 0x36, 0x5f, 0x44, 0x7f, 0x00, 0xfb, 0x84, 0x32, 0x57, 0x37, 0x74,
	0xc9, 0xc2, 0x95, 0x2f, 0x6a, 0x25, 0x49, 0xf6, 0x5f, 0xfc, 0x01, 0xe4, 0x3d, 0x9f, 0x9d, 0xfb,
	0x48, 0x52, 0x5b, 0x12, 0x94, 0xff, 0x4e, 0xc2, 0xc1, 0xb9, 0x63, 0x7a, 0xa4, 0x65, 0x5a, 0xc4,
	0xf5, 0xa3, 0xaa, 0x05, 0x29, 0xd7, 0xa4, 0x57, 0xf7, 0x19, 0xfe, 0x18, 0x3f, 0xfa, 0x39, 0xec,
	0x8f, 0x6d, 0x67, 0x8a, 0xbd, 0x60, 0x73, 0xf6, 0x1e, 0xcd, 0x40, 0x49, 0x40, 0xf9, 0x34, 0x66,
	0x01, 0x91, 0xd3, 0x89, 0xa1, 0xdf, 0xb0, 0x4f, 0x70, 0xb9, 0x0b, 0xe6, 0xb4, 0x92, 0x4f, 0xe6,
	0x1f, 0xe6, 0xa2, 0x3f, 0x85, 0xaa, 0x3c, 0xb3, 0x33, 0x58, 0x6e, 0x9c, 0x9a, 0x94, 0x18, 0xba,
	0x7b, 0x89, 0x1d, 0xc3, 0xa4, 0x13, 0xde, 0xf3, 0xe5, 0xb4, 0x8a, 0x78, 0xa3, 0x19, 0xbc, 0x30,
	0x90, 0xbf, 0x23, 0xb2, 0x9a, 0x48, 0xc5, 0xb8, 0xd6, 0x8c, 0xb2, 0xd5, 0xb7, 0x6e, 0xd6, 0xff,
	0x3f, 0xb9, 0xf4, 0x57, 0x90, 0xe6, 0x55, 0x87, 0x2f, 0xf4, 0xb2, 0xf1, 0xdf, 0x6d, 0xa1, 0x59,
	0xfb, 0x53, 0x83, 0xc3, 0x60, 0x07, 0x30, 0xa8, 0x75, 0xfe, 0x1e, 0xd8, 0x41, 0xf0, 0x93, 0x2c,
	0x75, 0xae, 0xf2, 0x37, 0x19, 0xbf, 0xd4, 0x87, 0x77, 0x3d, 0x1f, 0xba, 0xd4, 0xa3, 0xd7, 0x50,
	0x9c, 0x12, 0x67, 0x42, 0x74, 0x36, 0x7e, 0xcf, 0x5d, 0xd9, 0xa4, 0x3c, 0x8f, 0xd2, 0xdf, 0x33,
	0xb6, 0x01, 0xe7, 0x12, 0x6d, 0x4a, 0x61, 0xba, 0xa4, 0xa0, 0xdf, 0xf7, 0x5d, 0x6f, 0x59, 0xd7,
	0x93, 0x7c, 0x95, 0xf6, 0x04, 0xd9, 0x2f, 0xe9, 0x4d, 0xc8, 0x7a, 0x8e, 0x39, 0x99, 0x10, 0x47,
	0x8e, 0x16, 0x1f, 0x46, 0xc9, 0x13, 0x82, 0x43, 0xf3, 0x59, 0x11, 0x81, 0x83, 0xa0, 0x5d, 0x30,
	0x6d, 0xaa, 0x33, 0x16, 0x3e, 0x5c, 0x94, 0x8e, 0x3e, 0x8b, 0x80, 0x57, 0x0f, 0xf1, 0x9e, 0xda,
	0x86, 0x1c, 0x34, 0xcb, 0x78, 0x8d, 0xcc, 0x5a, 0x58, 0xb1, 0xfb, 0xc7, 0x8b, 0x0a, 0xdf, 0x36,
	0x88, 0xd6, 0xc2, 0x8a, 0xad, 0x39, 0x96, 0xa3, 0x64, 0x0b, 0x6b, 0x07, 0x04, 0x74, 0x01, 0xe5,
	0x91, 0x65, 0xf3, 0x52, 0x75, 0x41, 0x2e, 0xf1, 0xb5, 0x69, 0x3b, 0xfc, 0x98, 0xa3, 0x74, 0xf4,
	0x69, 0x94, 0x5e, 0x44, 0xb0, 0x1e, 0x4b, 0x4e, 0x01, 0xbf, 0x3f, 0x5a, 0xa5, 0xf2, 0x44, 0x6e,
	0x59, 0x3c, 0x0f, 0x58, 0xd8, 0x23, 0x94, 0xb8, 0x2e, 0x3f, 0xf8, 0x60, 0x89, 0x5c, 0xd0, 0x4f,
	0x24, 0x99, 0x0d, 0x93, 0x3d, 0xca, 0x14, 0xf3, 0x99, 0xf9, 0x61, 0x46, 0xb4, 0x71, 0x7d, 0x95,
	0x51, 0xe8, 0xb2, 0x86, 0x86, 0x9e, 0xc1, 0x63, 0xec, 0xba, 0xe6, 0x84, 0xba, 0xba, 0x67, 0xeb,
	0x36, 0x25, 0xba, 0x70, 0x88, 0x0a, 0xf0, 0x2c, 0x83, 0xe4, 0x8f, 0x43, 0xbb, 0x47, 0x89, 0xf0,
	0x7f, 0xe5, 0x17, 0x50, 0x08, 0x39, 0x9b, 0x72, 0x7a, 0x57, 0x9b, 0xbf, 0x0f, 0x85, 0x6e, 0xaf,
	0xab, 0x9f, 0xaa, 0xda, 0xcb, 0x4e, 0xf7, 0x65, 0x39, 0xce, 0x09, 0xaa, 0xda, 0x1c, 0x70, 0x92,
	0x5a, 0x4e, 0x20, 0x04, 0xa5, 0xfa, 0x89, 0xa6, 0xd6, 0x9b, 0x6f, 0x04, 0xa9, 0x59, 0x4e, 0x2a,
	0xa7, 0x50, 0x5e, 0x5f, 0x7f, 0xe5, 0xc5, 0x5d, 0x22, 0x4a, 0x00, 0xcd, 0xce, 0xa0, 0x51, 0xd7,
	0x9a, 0x42, 0x42, 0x19, 0x8a, 0xf5, 0x46, 0xe3, 0xec, 0xf4, 0xec, 0xa4, 0x3e, 0x64, 0x94, 0x84,
	0xf2, 0x35, 0xec, 0xaf, 0xad, 0x89, 0xf2, 0xe5, 0x3b, 0x14, 0x56, 0x4f, 0x3b, 0x43, 0xbd, 0x7e,
	0x72, 0x5e, 0x7f, 0x33, 0x10, 0x1b, 0x15, 0x9c, 0xd0, 0x69, 0xe9, 0xdd, 0x5e, 0x57, 0x3d, 0xed,
	0x0f, 0xdf, 0x94, 0x13, 0x4a, 0x7f, 0x7d, 0x49, 0xde, 0x89, 0xd8, 0xea, 0x68, 0xea, 0x0a, 0x22,
	0x27, 0xac, 0x22, 0x5e, 0x00, 0x2c, 0x5d, 0x52, 0x19, 0xde, 0x85, 0x76, 0x00, 0x7b, 0x6a, 0xb7,
	0xa9, 0xf7, 0x5a, 0x7a, 0xb0, 0x95, 0x82, 0xa0, 0x74, 0x52, 0x1f, 0xaa, 0x83, 0xa1, 0xde, 0xe9,
	0xea, 0xfd, 0x7a, 0x97, 0x59, 0x95, 0x69, 0x5d, 0xd7, 0x4e, 0x3a, 0x61, 0x6a, 0x52, 0xb1, 0x00,
	0x96, 0x93, 0x9b, 0xf2, 0xf6, 0x1d, 0x16, 0x55, 0x5f, 0xab, 0xdd, 0xa1, 0x3e, 0xec, 0x9c, 0xaa,
	0xe5, 0x38, 0x3a, 0x84, 0xfd, 0xbe, 0xd6, 0x6b, 0xa8, 0x83, 0x41, 0xa7, 0xfb, 0x52, 0x10, 0x13,
	0xe8, 0x09, 0xfc, 0x60, 0xf0, 0xa6, 0xdb, 0x68, 0x6b, 0xbd, 0x6e, 0xe7, 0x1b, 0xb5, 0xa9, 0xaf,
	0xbf, 0x91, 0x54, 0xfe, 0xb1, 0x0c, 0x59, 0x99, 0x16, 0x90, 0x06, 0x79, 0x3c, 0xf6, 0x88, 0xa3,
	0x63, 0xcb, 0x92, 0x49, 0xf2, 0x79, 0xf4, 0xac, 0x52, 0xab, 0x33, 0xde, 0xba, 0x65, 0xb5, 0x63,
	0x5a, 0x0e, 0xcb, 0xbf, 0x43, 0x98, 0x74, 0x21, 0x6b, 0xcb, 0xf6, 0x98, 0x74, 0xb1, 0xc4, 0xa4,
	0x0b, 0x74, 0x06, 0x20, 0x30, 0x09, 0x1e, 0x5d, 0xca, 0xe6, 0xf0, 0xc7, 0xdb, 0x82, 0xaa, 0x78,
	0x74, 0xd9, 0x8e, 0x69, 0x42, 0x3b, 0xf6, 0x80, 0x2c, 0x38, 0x94, 0xb0, 0xd4, 0xd0, 0xed, 0xb1,
	0x1f, 0x5f, 0x22, 0xbd, 0x7e, 0xb1, 0x35, 0x3e, 0x35, 0x7a, 0x63, 0x11, 0x88, 0xed, 0x98, 0x56,
	0xc6, 0x6b, 0x34, 0xe4, 0xc1, 0x63, 0x21, 0x6d, 0xad, 0xe5, 0x96, 0x7b, 0x3b, 0x5f, 0x6e, 0x2b,
	0x6f, 0xb3, 0xb5, 0xc6, 0x9b, 0x64, 0xf4, 0xeb, 0x38, 0x28, 0x42, 0xac, 0xbb, 0xa0, 0xa3, 0x4b,
	0xc7, 0xa6, 0xe6, 0x5f, 0x12, 0x63, 0x43, 0x07, 0x71, 0x26, 0xf3, 0x6a, 0x5b, 0x1d, 0x06, 0x21,
	0xcc, 0x0d, 0x7d, 0xde, 0xc7, 0xef, 0x7e, 0x05, 0x7d, 0x05, 0x19, 0x6c, 0xdd, 0xe0, 0x85, 0x2b,
	0xcf, 0x56, 0x9f, 0x6d, 0x23, 0x9e, 0x33, 0xb6, 0x63, 0x9a, 0x84, 0x40, 0x5d, 0xc8, 0x1a, 0x64,
	0x8c, 0xe7, 0x96, 0x27, 0xcf, 0xbe, 0x8f, 0xb6, 0x40, 0x6b, 0x0a, 0xce, 0x76, 0x4c, 0xf3, 0x41,
	0xd0, 0xdb, 0xe5, 0x4c, 0x32, 0xb2, 0xe7, 0xd4, 0x93, 0xe7, 0xdf, 0x9f, 0x6e, 0x81, 0xaa, 0xfa,
	0x9b, 0x3c, 0x73, 0xea, 0x85, 0x86, 0x10, 0xfe, 0x8c, 0xda, 0x90, 0xa6, 0xe4, 0x9a, 0x38, 0xf2,
	0x08, 0xfc, 0x47, 0x5b, 0xe0, 0x76, 0x19, 0x5f, 0x3b, 0xa6, 0x09, 0x00, 0x16, 0x1d, 0xb6, 0xa3,
	0x8f, 0x4d, 0x8a, 0x2d, 0x6b, 0xc1, 0xab, 0xc3, 0x76, 0xd1, 0xd1, 0x73, 0x5a, 0x82, 0x97, 0x45,
	0x87, 0xed, 0x3f, 0xb0, 0xd5, 0x71, 0xc8, 0x8c, 0x60, 0xff, 0x44, 0x7d, 0x9b, 0xd5, 0xd1, 0x38,
	0x23, 0x5b, 0x1d, 0x01, 0x51, 0xfd, 0x33, 0xc8, 0xf9, 0xd9, 0x02, 0x9d, 0x40, 0x81, 0x9f, 0x64,
	0xf2, 0x57, 0xfd, 0xa9, 0x67, 0x9b, 0x6e, 0x26, 0xcc, 0xbe, 0x44, 0xa6, 0x8b, 0x07, 0x46, 0x7e,
	0x03, 0xf9, 0x20, 0x71, 0x3c, 0x30, 0xf4, 0x6f, 0xe2, 0x50, 0x5e, 0x4f, 0x1a, 0xa8, 0x07, 0x7b,
	0x04, 0x3b, 0xd6, 0x42, 0x1f, 0x9b, 0x8e, 0x49, 0x27, 0xfe, 0xf1, 0xf9, 0x36, 0x42, 0x8a, 0x1c,
	0xa0, 0x25, 0xf8, 0xd1, 0x29, 0x14, 0x59, 0x13, 0x13, 0xe0, 0x25, 0xb6, 0xc6, 0x2b, 0x30, 0x7e,
	0x09, 0x57, 0xfd, 0x15, 0x1c, 0xde, 0x92, 0x78, 0xd0, 0x25, 0x3c, 0x0a, 0x66, 0x40, 0x7d, 0xe3,
	0xbe, 0xe1, 0x27, 0x11, 0xf7, 0x2d, 0x39, 0xfb, 0xf2, 0x82, 0xd9, 0xa1, 0xb7, 0x41, 0x73, 0xab,
	0x1f, 0xc0, 0xfb, 0xdf, 0x93, 0x75, 0xaa, 0x79, 0xc8, 0xca, 0x58, 0xae, 0x3e, 0x87, 0x62, 0x38,
	0x00, 0xd9, 0x84, 0xbf, 0x1a, 0xd0, 0xcc, 0xbc, 0xe9, 0xd5, 0xa8, 0xac, 0x66, 0x21, 0xcd, 0xa3,
	0xab, 0x9a, 0x83, 0x8c, 0x48, 0x31, 0xd5, 0xbf, 0x8f, 0x43, 0x3e, 0x08, 0x11, 0xf4, 0x25, 0xa4,
	0x82, 0x5d, 0xd9, 0xed, 0x6c, 0xc9, 0xf9, 0x58, 0x1b, 0xef, 0x47, 0xea, 0xf6, 0xcb, 0xe1, 0xb3,
	0x56, 0x87, 0x90, 0x11, 0x21, 0x86, 0x5e, 0x01, 0x2c, 0x1d, 0x6b, 0x07, 0xad, 0x42, 0xdc, 0xc7,
	0xf9, 0x60, 0xc4, 0x50, 0xfe, 0x3d, 0x11, 0xda, 0x29, 0x58, 0xde, 0x7f, 0x18, 0x40, 0xda, 0x20,
	0x16, 0x5e, 0x48, 0x41, 0x5f, 0xec, 0xb4, 0xb8, 0xb5, 0x26, 0x83, 0x60, 0xf9, 0x8b, 0x63, 0xa1,
	0x6f, 0x20, 0x87, 0x2d, 0x73, 0x42, 0x75, 0xcf, 0x96, 0x36, 0xf9, 0xc9, 0x6e, 0xb8, 0x75, 0x86,
	0x32, 0xb4, 0x59, 0x16, 0xc7, 0xe2, 0xcf, 0xea, 0x87, 0x90, 0xe6, 0xd2, 0xd0, 0x07, 0x50, 0xe4,
	0xd2, 0xf4, 0xa9, 0x69, 0x59, 0xa6, 0x2b, 0x77, 0x67, 0x0a, 0x9c, 0x76, 0xca, 0x49, 0xd5, 0x17,
	0x90, 0x95, 0x08, 0xe8, 0xb7, 0x20, 0x33, 0x23, 0x8e, 0x69, 0x8b, 0x59, 0x2c, 0xa9, 0xc9, 0x27,
	0x46, 0xb7, 0xc7, 0x63, 0x97, 0x78, 0xbc, 0x49, 0x48, 0x6a, 0xf2, 0xe9, 0xf8, 0x31, 0x1c, 0xde,
	0x12, 0x03, 0xca, 0xdf, 0x25, 0x20, 0x1f, 0x0c, 0xcd, 0xe8, 0x35, 0x94, 0xf0, 0x88, 0x39, 0xab,
	0x3e, 0xc3, 0x9e, 0x47, 0x1c, 0xba, 0xeb, 0x2d, 0x91, 0x3d, 0x01, 0xd3, 0x17, 0x28, 0xe8, 0x2b,
	0xc8, 0x5e, 0x9b, 0xe4, 0xe6, 0x7e, 0xc7, 0x23, 0x19, 0x06, 0xd1, 0xa2, 0xe8, 0x2d, 0xc8, 0x2b,
	0x44, 0xfa, 0x14, 0xcf, 0x66, 0xac, 0x3f, 0x18, 0x53, 0xd9, 0x71, 0xed, 0x02, 0x2b, 0x67, 0xdb,
	0x53, 0x81, 0xd5, 0xa2, 0xca, 0xfb, 0x50, 0x08, 0xdd, 0x41, 0x44, 0x65, 0x48, 0xce, 0x1d, 0xcb,
	0xdf, 0x97, 0x98, 0x3b, 0x96, 0xf2, 0x4b, 0xd8, 0x5f, 0x03, 0x79, 0x98, 0x4b, 0x35, 0xbf, 0x07,
	0xa5, 0xd0, 0x2d, 0xd9, 0xe5, 0xf6, 0xf9, 0x5e, 0x88, 0xda, 0x31, 0x94, 0xcf, 0xa1, 0xb8, 0x22,
	0x9b, 0x2b, 0x48, 0x97, 0x0a, 0x52, 0x54, 0x81, 0x6c, 0xf8, 0xe2, 0x61, 0x51, 0xf3, 0x1f, 0x95,
	0xff, 0x49, 0x41, 0x21, 0x74, 0x2d, 0x02, 0x75, 0x20, 0x6d, 0x7a, 0x24, 0x48, 0x85, 0xcf, 0xb7,
	0xbb, 0x55, 0x51, 0xeb, 0x78, 0x64, 0xaa, 0x09, 0x84, 0xea, 0x18, 0xa0, 0x63, 0x10, 0xea, 0x99,
	0x63, 0x93, 0x38, 0xcc, 0x99, 0xc3, 0x37, 0xa2, 0xa4, 0x76, 0x05, 0x6f, 0x79, 0x19, 0x8a, 0x65,
	0xbb, 0xe5, 0x2b, 0xec, 0x0b, 0xe4, 0x81, 0x55, 0x40, 0x3c, 0x73, 0xa8, 0xbf, 0x2b, 0x94, 0x0c,
	0x76, 0x85, 0xaa, 0xdf, 0x25, 0x20, 0xc5, 0xe4, 0xa2, 0x0e, 0x24, 0x24, 0x70, 0xb4, 0x9b, 0x45,
	0x2b, 0x8a, 0x07, 0x9a, 0x6a, 0x09, 0xd3, 0x40, 0x27, 0xf2, 0x34, 0x3b, 0x11, 0x79, 0x9b, 0x21,
	0x0c, 0xb6, 0x76, 0x9e, 0x8d, 0x3e, 0xf4, 0xf7, 0xad, 0x84, 0x53, 0x3e, 0xaa, 0x89, 0xeb, 0xf0,
	0x35, 0xff, 0x3a, 0x7c, 0xad, 0x4e, 0xfd, 0x0b, 0xbb, 0xe8, 0x13, 0x28, 0xb8, 0x97, 0xb6, 0xe3,
	0xe9, 0x82, 0x23, 0xf5, 0x0e, 0x0e, 0xe0, 0x2f, 0xf2, 0x93, 0x51, 0xf4, 0x08, 0xd2, 0x16, 0xbe,
	0x20, 0x96, 0xbc, 0xdf, 0x25, 0x1e, 0xd0, 0x7b, 0x90, 0xb3, 0x4c, 0x7a, 0xa5, 0x33, 0x7f, 0xcd,
	0x88, 0xe3, 0x01, 0xf6, 0x7c, 0xe6, 0x58, 0xd5, 0x5f, 0xca, 0x33, 0xf6, 0xf9, 0x3b, 0xce, 0xd8,
	0x07, 0x43, 0x4d, 0x4c, 0xc2, 0x05, 0xc8, 0x76, 0xba, 0x43, 0xf5, 0xa5, 0xaa, 0x95, 0x13, 0x28,
	0x0f, 0xe9, 0xd6, 0x49, 0xaf, 0x3e, 0x2c, 0x27, 0xc5, 0x61, 0x5b, 0xef, 0x44, 0xad, 0x77, 0xcb,
	0x29, 0xb4, 0x07, 0x79, 0x36, 0xaf, 0x0d, 0x86, 0xf5, 0xd3, 0x7e, 0x39, 0x8d, 0x8a, 0x90, 0x6b,
	0x9e, 0x69, 0xf5, 0x61, 0xa7, 0xd7, 0x2d, 0x67, 0xd8, 0x24, 0xf8, 0xaa, 0xfe, 0xba, 0xae, 0x37,
	0x4e, 0xea, 0x83, 0x41, 0x39, 0x7b, 0xfc, 0x05, 0x7c, 0xff, 0xbf, 0x0d, 0x1c, 0xe7, 0x35, 0xbe,
	0x2b, 0x59, 0x9f, 0x99, 0xdf, 0x14, 0x7c, 0xba, 0x7e, 0xfd, 0xec, 0x22, 0xc3, 0xcd, 0xf0, 0xfc,
	0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x4c, 0x56, 0x9e, 0x5a, 0x91, 0x30, 0x00, 0x00,
}
