// Code generated by protoc-gen-go. DO NOT EDIT.
// source: beam_artifact_api.proto

package jobmanagement_v1

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// An artifact identifier and associated metadata.
type ArtifactMetadata struct {
	// (Required) The name of the artifact.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// (Optional) The Unix-like permissions of the artifact
	Permissions uint32 `protobuf:"varint,2,opt,name=permissions" json:"permissions,omitempty"`
	// (Optional) The base64-encoded md5 checksum of the artifact. Used, among other things, by
	// harness boot code to validate the integrity of the artifact.
	Md5 string `protobuf:"bytes,3,opt,name=md5" json:"md5,omitempty"`
}

func (m *ArtifactMetadata) Reset()                    { *m = ArtifactMetadata{} }
func (m *ArtifactMetadata) String() string            { return proto.CompactTextString(m) }
func (*ArtifactMetadata) ProtoMessage()               {}
func (*ArtifactMetadata) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *ArtifactMetadata) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ArtifactMetadata) GetPermissions() uint32 {
	if m != nil {
		return m.Permissions
	}
	return 0
}

func (m *ArtifactMetadata) GetMd5() string {
	if m != nil {
		return m.Md5
	}
	return ""
}

// A collection of artifacts.
type Manifest struct {
	Artifact []*ArtifactMetadata `protobuf:"bytes,1,rep,name=artifact" json:"artifact,omitempty"`
}

func (m *Manifest) Reset()                    { *m = Manifest{} }
func (m *Manifest) String() string            { return proto.CompactTextString(m) }
func (*Manifest) ProtoMessage()               {}
func (*Manifest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *Manifest) GetArtifact() []*ArtifactMetadata {
	if m != nil {
		return m.Artifact
	}
	return nil
}

// A manifest with location information.
type ProxyManifest struct {
	Manifest *Manifest                 `protobuf:"bytes,1,opt,name=manifest" json:"manifest,omitempty"`
	Location []*ProxyManifest_Location `protobuf:"bytes,2,rep,name=location" json:"location,omitempty"`
}

func (m *ProxyManifest) Reset()                    { *m = ProxyManifest{} }
func (m *ProxyManifest) String() string            { return proto.CompactTextString(m) }
func (*ProxyManifest) ProtoMessage()               {}
func (*ProxyManifest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

func (m *ProxyManifest) GetManifest() *Manifest {
	if m != nil {
		return m.Manifest
	}
	return nil
}

func (m *ProxyManifest) GetLocation() []*ProxyManifest_Location {
	if m != nil {
		return m.Location
	}
	return nil
}

type ProxyManifest_Location struct {
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Uri  string `protobuf:"bytes,2,opt,name=uri" json:"uri,omitempty"`
}

func (m *ProxyManifest_Location) Reset()                    { *m = ProxyManifest_Location{} }
func (m *ProxyManifest_Location) String() string            { return proto.CompactTextString(m) }
func (*ProxyManifest_Location) ProtoMessage()               {}
func (*ProxyManifest_Location) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2, 0} }

func (m *ProxyManifest_Location) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ProxyManifest_Location) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// A request to get the manifest of a Job.
type GetManifestRequest struct {
}

func (m *GetManifestRequest) Reset()                    { *m = GetManifestRequest{} }
func (m *GetManifestRequest) String() string            { return proto.CompactTextString(m) }
func (*GetManifestRequest) ProtoMessage()               {}
func (*GetManifestRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

// A response containing a job manifest.
type GetManifestResponse struct {
	Manifest *Manifest `protobuf:"bytes,1,opt,name=manifest" json:"manifest,omitempty"`
}

func (m *GetManifestResponse) Reset()                    { *m = GetManifestResponse{} }
func (m *GetManifestResponse) String() string            { return proto.CompactTextString(m) }
func (*GetManifestResponse) ProtoMessage()               {}
func (*GetManifestResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *GetManifestResponse) GetManifest() *Manifest {
	if m != nil {
		return m.Manifest
	}
	return nil
}

// A request to get an artifact. The artifact must be present in the manifest for the job.
type GetArtifactRequest struct {
	// (Required) The name of the artifact to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetArtifactRequest) Reset()                    { *m = GetArtifactRequest{} }
func (m *GetArtifactRequest) String() string            { return proto.CompactTextString(m) }
func (*GetArtifactRequest) ProtoMessage()               {}
func (*GetArtifactRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

func (m *GetArtifactRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Part of an artifact.
type ArtifactChunk struct {
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *ArtifactChunk) Reset()                    { *m = ArtifactChunk{} }
func (m *ArtifactChunk) String() string            { return proto.CompactTextString(m) }
func (*ArtifactChunk) ProtoMessage()               {}
func (*ArtifactChunk) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func (m *ArtifactChunk) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// A request to stage an artifact.
type PutArtifactRequest struct {
	// (Required)
	//
	// Types that are valid to be assigned to Content:
	//	*PutArtifactRequest_Metadata
	//	*PutArtifactRequest_Data
	Content isPutArtifactRequest_Content `protobuf_oneof:"content"`
}

func (m *PutArtifactRequest) Reset()                    { *m = PutArtifactRequest{} }
func (m *PutArtifactRequest) String() string            { return proto.CompactTextString(m) }
func (*PutArtifactRequest) ProtoMessage()               {}
func (*PutArtifactRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

type isPutArtifactRequest_Content interface {
	isPutArtifactRequest_Content()
}

type PutArtifactRequest_Metadata struct {
	Metadata *ArtifactMetadata `protobuf:"bytes,1,opt,name=metadata,oneof"`
}
type PutArtifactRequest_Data struct {
	Data *ArtifactChunk `protobuf:"bytes,2,opt,name=data,oneof"`
}

func (*PutArtifactRequest_Metadata) isPutArtifactRequest_Content() {}
func (*PutArtifactRequest_Data) isPutArtifactRequest_Content()     {}

func (m *PutArtifactRequest) GetContent() isPutArtifactRequest_Content {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *PutArtifactRequest) GetMetadata() *ArtifactMetadata {
	if x, ok := m.GetContent().(*PutArtifactRequest_Metadata); ok {
		return x.Metadata
	}
	return nil
}

func (m *PutArtifactRequest) GetData() *ArtifactChunk {
	if x, ok := m.GetContent().(*PutArtifactRequest_Data); ok {
		return x.Data
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*PutArtifactRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _PutArtifactRequest_OneofMarshaler, _PutArtifactRequest_OneofUnmarshaler, _PutArtifactRequest_OneofSizer, []interface{}{
		(*PutArtifactRequest_Metadata)(nil),
		(*PutArtifactRequest_Data)(nil),
	}
}

func _PutArtifactRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*PutArtifactRequest)
	// content
	switch x := m.Content.(type) {
	case *PutArtifactRequest_Metadata:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Metadata); err != nil {
			return err
		}
	case *PutArtifactRequest_Data:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Data); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("PutArtifactRequest.Content has unexpected type %T", x)
	}
	return nil
}

func _PutArtifactRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*PutArtifactRequest)
	switch tag {
	case 1: // content.metadata
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ArtifactMetadata)
		err := b.DecodeMessage(msg)
		m.Content = &PutArtifactRequest_Metadata{msg}
		return true, err
	case 2: // content.data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ArtifactChunk)
		err := b.DecodeMessage(msg)
		m.Content = &PutArtifactRequest_Data{msg}
		return true, err
	default:
		return false, nil
	}
}

func _PutArtifactRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*PutArtifactRequest)
	// content
	switch x := m.Content.(type) {
	case *PutArtifactRequest_Metadata:
		s := proto.Size(x.Metadata)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PutArtifactRequest_Data:
		s := proto.Size(x.Data)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type PutArtifactResponse struct {
}

func (m *PutArtifactResponse) Reset()                    { *m = PutArtifactResponse{} }
func (m *PutArtifactResponse) String() string            { return proto.CompactTextString(m) }
func (*PutArtifactResponse) ProtoMessage()               {}
func (*PutArtifactResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

// A request to commit the manifest for a Job. All artifacts must have been successfully uploaded
// before this call is made.
type CommitManifestRequest struct {
	// (Required) The manifest to commit.
	Manifest *Manifest `protobuf:"bytes,1,opt,name=manifest" json:"manifest,omitempty"`
}

func (m *CommitManifestRequest) Reset()                    { *m = CommitManifestRequest{} }
func (m *CommitManifestRequest) String() string            { return proto.CompactTextString(m) }
func (*CommitManifestRequest) ProtoMessage()               {}
func (*CommitManifestRequest) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

func (m *CommitManifestRequest) GetManifest() *Manifest {
	if m != nil {
		return m.Manifest
	}
	return nil
}

// The result of committing a manifest.
type CommitManifestResponse struct {
	// (Required) An opaque token representing the entirety of the staged artifacts.
	StagingToken string `protobuf:"bytes,1,opt,name=staging_token,json=stagingToken" json:"staging_token,omitempty"`
}

func (m *CommitManifestResponse) Reset()                    { *m = CommitManifestResponse{} }
func (m *CommitManifestResponse) String() string            { return proto.CompactTextString(m) }
func (*CommitManifestResponse) ProtoMessage()               {}
func (*CommitManifestResponse) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

func (m *CommitManifestResponse) GetStagingToken() string {
	if m != nil {
		return m.StagingToken
	}
	return ""
}

func init() {
	proto.RegisterType((*ArtifactMetadata)(nil), "org.apache.beam.model.job_management.v1.ArtifactMetadata")
	proto.RegisterType((*Manifest)(nil), "org.apache.beam.model.job_management.v1.Manifest")
	proto.RegisterType((*ProxyManifest)(nil), "org.apache.beam.model.job_management.v1.ProxyManifest")
	proto.RegisterType((*ProxyManifest_Location)(nil), "org.apache.beam.model.job_management.v1.ProxyManifest.Location")
	proto.RegisterType((*GetManifestRequest)(nil), "org.apache.beam.model.job_management.v1.GetManifestRequest")
	proto.RegisterType((*GetManifestResponse)(nil), "org.apache.beam.model.job_management.v1.GetManifestResponse")
	proto.RegisterType((*GetArtifactRequest)(nil), "org.apache.beam.model.job_management.v1.GetArtifactRequest")
	proto.RegisterType((*ArtifactChunk)(nil), "org.apache.beam.model.job_management.v1.ArtifactChunk")
	proto.RegisterType((*PutArtifactRequest)(nil), "org.apache.beam.model.job_management.v1.PutArtifactRequest")
	proto.RegisterType((*PutArtifactResponse)(nil), "org.apache.beam.model.job_management.v1.PutArtifactResponse")
	proto.RegisterType((*CommitManifestRequest)(nil), "org.apache.beam.model.job_management.v1.CommitManifestRequest")
	proto.RegisterType((*CommitManifestResponse)(nil), "org.apache.beam.model.job_management.v1.CommitManifestResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ArtifactStagingService service

type ArtifactStagingServiceClient interface {
	// Stage an artifact to be available during job execution. The first request must contain the
	// name of the artifact. All future requests must contain sequential chunks of the content of
	// the artifact.
	PutArtifact(ctx context.Context, opts ...grpc.CallOption) (ArtifactStagingService_PutArtifactClient, error)
	// Commit the manifest for a Job. All artifacts must have been successfully uploaded
	// before this call is made.
	//
	// Throws error INVALID_ARGUMENT if not all of the members of the manifest are present
	CommitManifest(ctx context.Context, in *CommitManifestRequest, opts ...grpc.CallOption) (*CommitManifestResponse, error)
}

type artifactStagingServiceClient struct {
	cc *grpc.ClientConn
}

func NewArtifactStagingServiceClient(cc *grpc.ClientConn) ArtifactStagingServiceClient {
	return &artifactStagingServiceClient{cc}
}

func (c *artifactStagingServiceClient) PutArtifact(ctx context.Context, opts ...grpc.CallOption) (ArtifactStagingService_PutArtifactClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_ArtifactStagingService_serviceDesc.Streams[0], c.cc, "/org.apache.beam.model.job_management.v1.ArtifactStagingService/PutArtifact", opts...)
	if err != nil {
		return nil, err
	}
	x := &artifactStagingServicePutArtifactClient{stream}
	return x, nil
}

type ArtifactStagingService_PutArtifactClient interface {
	Send(*PutArtifactRequest) error
	CloseAndRecv() (*PutArtifactResponse, error)
	grpc.ClientStream
}

type artifactStagingServicePutArtifactClient struct {
	grpc.ClientStream
}

func (x *artifactStagingServicePutArtifactClient) Send(m *PutArtifactRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *artifactStagingServicePutArtifactClient) CloseAndRecv() (*PutArtifactResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(PutArtifactResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *artifactStagingServiceClient) CommitManifest(ctx context.Context, in *CommitManifestRequest, opts ...grpc.CallOption) (*CommitManifestResponse, error) {
	out := new(CommitManifestResponse)
	err := grpc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.ArtifactStagingService/CommitManifest", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ArtifactStagingService service

type ArtifactStagingServiceServer interface {
	// Stage an artifact to be available during job execution. The first request must contain the
	// name of the artifact. All future requests must contain sequential chunks of the content of
	// the artifact.
	PutArtifact(ArtifactStagingService_PutArtifactServer) error
	// Commit the manifest for a Job. All artifacts must have been successfully uploaded
	// before this call is made.
	//
	// Throws error INVALID_ARGUMENT if not all of the members of the manifest are present
	CommitManifest(context.Context, *CommitManifestRequest) (*CommitManifestResponse, error)
}

func RegisterArtifactStagingServiceServer(s *grpc.Server, srv ArtifactStagingServiceServer) {
	s.RegisterService(&_ArtifactStagingService_serviceDesc, srv)
}

func _ArtifactStagingService_PutArtifact_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ArtifactStagingServiceServer).PutArtifact(&artifactStagingServicePutArtifactServer{stream})
}

type ArtifactStagingService_PutArtifactServer interface {
	SendAndClose(*PutArtifactResponse) error
	Recv() (*PutArtifactRequest, error)
	grpc.ServerStream
}

type artifactStagingServicePutArtifactServer struct {
	grpc.ServerStream
}

func (x *artifactStagingServicePutArtifactServer) SendAndClose(m *PutArtifactResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *artifactStagingServicePutArtifactServer) Recv() (*PutArtifactRequest, error) {
	m := new(PutArtifactRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ArtifactStagingService_CommitManifest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitManifestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactStagingServiceServer).CommitManifest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.ArtifactStagingService/CommitManifest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactStagingServiceServer).CommitManifest(ctx, req.(*CommitManifestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ArtifactStagingService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.job_management.v1.ArtifactStagingService",
	HandlerType: (*ArtifactStagingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CommitManifest",
			Handler:    _ArtifactStagingService_CommitManifest_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "PutArtifact",
			Handler:       _ArtifactStagingService_PutArtifact_Handler,
			ClientStreams: true,
		},
	},
	Metadata: "beam_artifact_api.proto",
}

// Client API for ArtifactRetrievalService service

type ArtifactRetrievalServiceClient interface {
	// Get the manifest for the job
	GetManifest(ctx context.Context, in *GetManifestRequest, opts ...grpc.CallOption) (*GetManifestResponse, error)
	// Get an artifact staged for the job. The requested artifact must be within the manifest
	GetArtifact(ctx context.Context, in *GetArtifactRequest, opts ...grpc.CallOption) (ArtifactRetrievalService_GetArtifactClient, error)
}

type artifactRetrievalServiceClient struct {
	cc *grpc.ClientConn
}

func NewArtifactRetrievalServiceClient(cc *grpc.ClientConn) ArtifactRetrievalServiceClient {
	return &artifactRetrievalServiceClient{cc}
}

func (c *artifactRetrievalServiceClient) GetManifest(ctx context.Context, in *GetManifestRequest, opts ...grpc.CallOption) (*GetManifestResponse, error) {
	out := new(GetManifestResponse)
	err := grpc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.ArtifactRetrievalService/GetManifest", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRetrievalServiceClient) GetArtifact(ctx context.Context, in *GetArtifactRequest, opts ...grpc.CallOption) (ArtifactRetrievalService_GetArtifactClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_ArtifactRetrievalService_serviceDesc.Streams[0], c.cc, "/org.apache.beam.model.job_management.v1.ArtifactRetrievalService/GetArtifact", opts...)
	if err != nil {
		return nil, err
	}
	x := &artifactRetrievalServiceGetArtifactClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArtifactRetrievalService_GetArtifactClient interface {
	Recv() (*ArtifactChunk, error)
	grpc.ClientStream
}

type artifactRetrievalServiceGetArtifactClient struct {
	grpc.ClientStream
}

func (x *artifactRetrievalServiceGetArtifactClient) Recv() (*ArtifactChunk, error) {
	m := new(ArtifactChunk)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for ArtifactRetrievalService service

type ArtifactRetrievalServiceServer interface {
	// Get the manifest for the job
	GetManifest(context.Context, *GetManifestRequest) (*GetManifestResponse, error)
	// Get an artifact staged for the job. The requested artifact must be within the manifest
	GetArtifact(*GetArtifactRequest, ArtifactRetrievalService_GetArtifactServer) error
}

func RegisterArtifactRetrievalServiceServer(s *grpc.Server, srv ArtifactRetrievalServiceServer) {
	s.RegisterService(&_ArtifactRetrievalService_serviceDesc, srv)
}

func _ArtifactRetrievalService_GetManifest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetManifestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRetrievalServiceServer).GetManifest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.ArtifactRetrievalService/GetManifest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRetrievalServiceServer).GetManifest(ctx, req.(*GetManifestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRetrievalService_GetArtifact_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetArtifactRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArtifactRetrievalServiceServer).GetArtifact(m, &artifactRetrievalServiceGetArtifactServer{stream})
}

type ArtifactRetrievalService_GetArtifactServer interface {
	Send(*ArtifactChunk) error
	grpc.ServerStream
}

type artifactRetrievalServiceGetArtifactServer struct {
	grpc.ServerStream
}

func (x *artifactRetrievalServiceGetArtifactServer) Send(m *ArtifactChunk) error {
	return x.ServerStream.SendMsg(m)
}

var _ArtifactRetrievalService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.job_management.v1.ArtifactRetrievalService",
	HandlerType: (*ArtifactRetrievalServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetManifest",
			Handler:    _ArtifactRetrievalService_GetManifest_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetArtifact",
			Handler:       _ArtifactRetrievalService_GetArtifact_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "beam_artifact_api.proto",
}

func init() { proto.RegisterFile("beam_artifact_api.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 557 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x55, 0xcf, 0x6e, 0xd3, 0x4e,
	0x10, 0xee, 0x26, 0x3f, 0xfd, 0x70, 0xc6, 0x0d, 0x8a, 0xb6, 0xb4, 0x58, 0x39, 0x45, 0x5b, 0x09,
	0x72, 0xb2, 0x9a, 0x20, 0x90, 0x10, 0x7f, 0xaa, 0xa6, 0x87, 0xf6, 0xd0, 0x48, 0x95, 0x0b, 0x42,
	0x2a, 0x87, 0x68, 0x93, 0x6c, 0xd2, 0xa5, 0xd9, 0x5d, 0x63, 0x6f, 0x22, 0xb8, 0x73, 0x40, 0xdc,
	0x78, 0x0f, 0x5e, 0x80, 0x17, 0xe0, 0x6d, 0x78, 0x07, 0xe4, 0xf5, 0xda, 0xc4, 0x49, 0x90, 0x92,
	0xa8, 0xb7, 0xd1, 0x78, 0xe6, 0x9b, 0x6f, 0xbe, 0x6f, 0x27, 0x81, 0x87, 0x7d, 0x46, 0x45, 0x8f,
	0x46, 0x9a, 0x8f, 0xe8, 0x40, 0xf7, 0x68, 0xc8, 0xfd, 0x30, 0x52, 0x5a, 0xe1, 0xc7, 0x2a, 0x1a,
	0xfb, 0x34, 0xa4, 0x83, 0x1b, 0xe6, 0x27, 0x35, 0xbe, 0x50, 0x43, 0x36, 0xf1, 0x3f, 0xa8, 0x7e,
	0x4f, 0x50, 0x49, 0xc7, 0x4c, 0x30, 0xa9, 0xfd, 0x59, 0x8b, 0x5c, 0x43, 0xed, 0xc4, 0xb6, 0x77,
	0x99, 0xa6, 0x43, 0xaa, 0x29, 0xc6, 0xf0, 0x9f, 0xa4, 0x82, 0x79, 0xa8, 0x81, 0x9a, 0x95, 0xc0,
	0xc4, 0xb8, 0x01, 0x6e, 0xc8, 0x22, 0xc1, 0xe3, 0x98, 0x2b, 0x19, 0x7b, 0xa5, 0x06, 0x6a, 0x56,
	0x83, 0xf9, 0x14, 0xae, 0x41, 0x59, 0x0c, 0x9f, 0x7a, 0x65, 0xd3, 0x94, 0x84, 0x84, 0x82, 0xd3,
	0xa5, 0x92, 0x8f, 0x58, 0xac, 0xf1, 0x5b, 0x70, 0x32, 0x9a, 0x1e, 0x6a, 0x94, 0x9b, 0x6e, 0xfb,
	0xb9, 0xbf, 0x26, 0x47, 0x7f, 0x91, 0x60, 0x90, 0x43, 0x91, 0xdf, 0x08, 0xaa, 0x97, 0x91, 0xfa,
	0xf4, 0x39, 0x1f, 0xd4, 0x05, 0x47, 0xd8, 0xd8, 0x2c, 0xe0, 0xb6, 0x5b, 0x6b, 0x0f, 0xca, 0x40,
	0x82, 0x1c, 0x02, 0xbf, 0x07, 0x67, 0xa2, 0x06, 0x54, 0x73, 0x25, 0xbd, 0x92, 0xe1, 0x7d, 0xbc,
	0x36, 0x5c, 0x81, 0x98, 0x7f, 0x61, 0x61, 0x82, 0x1c, 0xb0, 0x7e, 0x04, 0x4e, 0x96, 0x5d, 0x29,
	0x7a, 0x0d, 0xca, 0xd3, 0x88, 0x1b, 0xb1, 0x2b, 0x41, 0x12, 0x92, 0x07, 0x80, 0xcf, 0x98, 0xce,
	0x79, 0xb2, 0x8f, 0x53, 0x16, 0x6b, 0x32, 0x84, 0xbd, 0x42, 0x36, 0x0e, 0x95, 0x8c, 0xd9, 0x1d,
	0x4b, 0x41, 0x9a, 0x66, 0x76, 0x66, 0x86, 0x9d, 0xbd, 0x8a, 0x37, 0x39, 0x84, 0x6a, 0x56, 0x76,
	0x7a, 0x33, 0x95, 0xb7, 0x49, 0x51, 0x62, 0x9c, 0x29, 0xda, 0x0d, 0x4c, 0x4c, 0x7e, 0x21, 0xc0,
	0x97, 0xd3, 0x25, 0xbc, 0x77, 0xe0, 0x08, 0xeb, 0xb3, 0x25, 0xbd, 0xfd, 0x43, 0x39, 0xdf, 0x09,
	0x72, 0x30, 0x7c, 0x61, 0x39, 0x94, 0x0c, 0xe8, 0xb3, 0x8d, 0x41, 0xcd, 0x26, 0xe7, 0x3b, 0x29,
	0xfb, 0x4e, 0x05, 0xee, 0x0d, 0x94, 0xd4, 0x4c, 0x6a, 0xb2, 0x0f, 0x7b, 0x85, 0x3d, 0x52, 0xf5,
	0xc9, 0x08, 0xf6, 0x4f, 0x95, 0x10, 0x7c, 0xd1, 0xad, 0xbb, 0xb6, 0xe5, 0x15, 0x1c, 0x2c, 0xce,
	0xb1, 0xfe, 0x1f, 0x42, 0x35, 0xd6, 0x74, 0xcc, 0xe5, 0xb8, 0xa7, 0xd5, 0x2d, 0x93, 0xd6, 0xa3,
	0x5d, 0x9b, 0x7c, 0x93, 0xe4, 0xda, 0x3f, 0x4b, 0x70, 0x90, 0x71, 0xbf, 0x4a, 0x3f, 0x5c, 0xb1,
	0x68, 0xc6, 0x07, 0x0c, 0x7f, 0x43, 0xe0, 0xce, 0x6d, 0x86, 0x5f, 0xac, 0xff, 0xf2, 0x97, 0x7c,
	0xad, 0xbf, 0xdc, 0xae, 0x39, 0x5d, 0xa5, 0x89, 0xf0, 0x77, 0x04, 0xf7, 0x8b, 0x7b, 0xe2, 0xd7,
	0x6b, 0x43, 0xae, 0x34, 0xa2, 0x7e, 0xbc, 0x75, 0x7f, 0xca, 0xaa, 0xfd, 0xa3, 0x04, 0xde, 0x5f,
	0xaa, 0x3a, 0xe2, 0x6c, 0x46, 0x27, 0x99, 0x7a, 0x5f, 0x11, 0xb8, 0x73, 0x57, 0xb9, 0x81, 0x7a,
	0xcb, 0x17, 0xbe, 0x81, 0x7a, 0xab, 0x7e, 0x08, 0xbe, 0xa4, 0x54, 0xb6, 0x30, 0x72, 0xf9, 0xe0,
	0xeb, 0x5b, 0x5e, 0xce, 0x11, 0xea, 0x9c, 0xc1, 0xa3, 0x7f, 0xb6, 0x16, 0x3a, 0x3b, 0x6e, 0xd6,
	0x7a, 0x12, 0xf2, 0xeb, 0x5a, 0xe1, 0x73, 0x6f, 0xd6, 0xea, 0xff, 0x6f, 0xfe, 0xe4, 0x9e, 0xfc,
	0x09, 0x00, 0x00, 0xff, 0xff, 0x80, 0xfd, 0xd5, 0x65, 0xff, 0x06, 0x00, 0x00,
}
