/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import 'package:flutter/material.dart';
import 'package:playground/pages/playground/states/playground_state.dart';
import 'dart:html' as html;

import 'package:provider/provider.dart';

class CloseListener extends StatefulWidget {
  final Widget child;

  const CloseListener({Key? key, required this.child}) : super(key: key);

  @override
  State<CloseListener> createState() => _CloseListenerState();
}

class _CloseListenerState extends State<CloseListener> {
  @override
  void initState() {
    WidgetsBinding.instance?.addPostFrameCallback((timeStamp) {
      html.window.onBeforeUnload.listen((event) async {
        Provider.of<PlaygroundState>(context, listen: false).cancelRun();
      });
    });
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return widget.child;
  }
}
