// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package errors

import (
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/status"
)

// InvalidArgumentError Returns error with InvalidArgument code error and message like "title: message"
func InvalidArgumentError(title string, message string) error {
	return status.Errorf(codes.InvalidArgument, "%s: %s", title, message)
}

// NotFoundError Returns error with NotFound code error and message like "title: message"
func NotFoundError(title string, message string) error {
	return status.Errorf(codes.NotFound, "%s: %s", title, message)
}

// InternalError Returns error with Internal code error and message like "title: message"
func InternalError(title string, message string) error {
	return status.Errorf(codes.Internal, "%s: %s", title, message)
}
