---
title: "Become A Committer"
---

<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# Become a Beam Committer

An Apache Beam [committer](https://www.apache.org/foundation/how-it-works.html#committers) takes many forms. There are many actions other than coding that build the trust we place in a committer - code review, design discussion, user support, community outreach, improving infrastructure, documentation, project management, etc.

### What does it mean to be a committer?

An Apache Beam committer has write access to the repository for merging pull requests, but you don’t have to be a code contributor to become a committer. Becoming a committer means that you have the project’s trust. Read the [ASF documentation](https://www.apache.org/dev/committers.html#committer-responsibilities) for more about being a committer in the Apache Software Foundation.

### Ways you can contribute
Everyone is welcome to join and contribute to the project in many ways, not only with code contributions. Things like asking questions, reporting bugs, proposing new features, improving documentation or the website, organizing events or writing blog posts, are also welcome and recognized.

{{< contributor/list_with_icons ways_of_contribution >}}

### What are the traits of an Apache Beam committer?

{{< contributor/row_of_traits committer_traits >}}

### Process
The [PMC](https://www.apache.org/foundation/how-it-works.html#pmc-members)
makes someone a committer via nomination, discussion, and then majority vote.
We use data from as many sources as possible to inform our reasoning. Here are
some examples:

 - [dev@ archives](https://lists.apache.org/list.html?dev@beam.apache.org) and [statistics](https://lists.apache.org/trends.html?dev@beam.apache.org)
 - [user@ archives](https://lists.apache.org/list.html?user@beam.apache.org) and [statistics](https://lists.apache.org/trends.html?user@beam.apache.org)
 - [`apache-beam` StackOverflow tag](https://stackoverflow.com/questions/tagged/apache-beam)
 - Git metrics for [Beam](https://github.com/apache/beam/graphs/contributors)
 - Code reviews given and received on
   [Beam](https://github.com/apache/beam/pulls)
 - Clear areas of ownership (a runner, a DSL, IO connector, documentation,
   etc.)
 - Public events
 - Firsthand PMC testimonials
