/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.beam.sdk.io.thrift;

@SuppressWarnings({
  "cast",
  "rawtypes",
  "serial",
  "unchecked",
  "unused",
  "nullness" // TODO(https://issues.apache.org/jira/browse/BEAM-10402)
})
@javax.annotation.Generated(
    value = "Autogenerated by Thrift Compiler (0.13.0)",
    date = "2019-12-21")
public class TestThriftStruct
    implements org.apache.thrift.TBase<TestThriftStruct, TestThriftStruct._Fields>,
        java.io.Serializable,
        Cloneable,
        Comparable<TestThriftStruct> {
  private static final org.apache.thrift.protocol.TStruct STRUCT_DESC =
      new org.apache.thrift.protocol.TStruct("TestThriftStruct");

  private static final org.apache.thrift.protocol.TField TEST_BYTE_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "testByte", org.apache.thrift.protocol.TType.BYTE, (short) 1);
  private static final org.apache.thrift.protocol.TField TEST_SHORT_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "testShort", org.apache.thrift.protocol.TType.I16, (short) 2);
  private static final org.apache.thrift.protocol.TField TEST_INT_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "testInt", org.apache.thrift.protocol.TType.I32, (short) 3);
  private static final org.apache.thrift.protocol.TField TEST_LONG_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "testLong", org.apache.thrift.protocol.TType.I64, (short) 4);
  private static final org.apache.thrift.protocol.TField TEST_DOUBLE_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "testDouble", org.apache.thrift.protocol.TType.DOUBLE, (short) 5);
  private static final org.apache.thrift.protocol.TField STRING_INT_MAP_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "stringIntMap", org.apache.thrift.protocol.TType.MAP, (short) 6);
  private static final org.apache.thrift.protocol.TField TEST_BINARY_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "testBinary", org.apache.thrift.protocol.TType.STRING, (short) 7);
  private static final org.apache.thrift.protocol.TField TEST_BOOL_FIELD_DESC =
      new org.apache.thrift.protocol.TField(
          "testBool", org.apache.thrift.protocol.TType.BOOL, (short) 8);

  private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY =
      new TestThriftStructStandardSchemeFactory();
  private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY =
      new TestThriftStructTupleSchemeFactory();

  public byte testByte; // required
  public short testShort; // required
  public int testInt; // required
  public long testLong; // required
  public double testDouble; // required
  public @org.apache.thrift.annotation.Nullable java.util.Map<java.lang.String, java.lang.Short>
      stringIntMap; // required
  public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer testBinary; // required
  public boolean testBool; // required

  /**
   * The set of fields this struct contains, along with convenience methods for finding and
   * manipulating them.
   */
  public enum _Fields implements org.apache.thrift.TFieldIdEnum {
    TEST_BYTE((short) 1, "testByte"),
    TEST_SHORT((short) 2, "testShort"),
    TEST_INT((short) 3, "testInt"),
    TEST_LONG((short) 4, "testLong"),
    TEST_DOUBLE((short) 5, "testDouble"),
    STRING_INT_MAP((short) 6, "stringIntMap"),
    TEST_BINARY((short) 7, "testBinary"),
    TEST_BOOL((short) 8, "testBool");

    private static final java.util.Map<java.lang.String, _Fields> byName =
        new java.util.HashMap<java.lang.String, _Fields>();

    static {
      for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }

    /** Find the _Fields constant that matches fieldId, or null if its not found. */
    @org.apache.thrift.annotation.Nullable
    public static _Fields findByThriftId(int fieldId) {
      switch (fieldId) {
        case 1: // TEST_BYTE
          return TEST_BYTE;
        case 2: // TEST_SHORT
          return TEST_SHORT;
        case 3: // TEST_INT
          return TEST_INT;
        case 4: // TEST_LONG
          return TEST_LONG;
        case 5: // TEST_DOUBLE
          return TEST_DOUBLE;
        case 6: // STRING_INT_MAP
          return STRING_INT_MAP;
        case 7: // TEST_BINARY
          return TEST_BINARY;
        case 8: // TEST_BOOL
          return TEST_BOOL;
        default:
          return null;
      }
    }

    /** Find the _Fields constant that matches fieldId, throwing an exception if it is not found. */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null)
        throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }

    /** Find the _Fields constant that matches name, or null if its not found. */
    @org.apache.thrift.annotation.Nullable
    public static _Fields findByName(java.lang.String name) {
      return byName.get(name);
    }

    private final short _thriftId;
    private final java.lang.String _fieldName;

    _Fields(short thriftId, java.lang.String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }

    public short getThriftFieldId() {
      return _thriftId;
    }

    public java.lang.String getFieldName() {
      return _fieldName;
    }
  }

  // isset id assignments
  private static final int __TESTBYTE_ISSET_ID = 0;
  private static final int __TESTSHORT_ISSET_ID = 1;
  private static final int __TESTINT_ISSET_ID = 2;
  private static final int __TESTLONG_ISSET_ID = 3;
  private static final int __TESTDOUBLE_ISSET_ID = 4;
  private static final int __TESTBOOL_ISSET_ID = 5;
  private byte __isset_bitfield = 0;
  public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;

  static {
    java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap =
        new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
    tmpMap.put(
        _Fields.TEST_BYTE,
        new org.apache.thrift.meta_data.FieldMetaData(
            "testByte",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.FieldValueMetaData(
                org.apache.thrift.protocol.TType.BYTE)));
    tmpMap.put(
        _Fields.TEST_SHORT,
        new org.apache.thrift.meta_data.FieldMetaData(
            "testShort",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.FieldValueMetaData(
                org.apache.thrift.protocol.TType.I16)));
    tmpMap.put(
        _Fields.TEST_INT,
        new org.apache.thrift.meta_data.FieldMetaData(
            "testInt",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.FieldValueMetaData(
                org.apache.thrift.protocol.TType.I32)));
    tmpMap.put(
        _Fields.TEST_LONG,
        new org.apache.thrift.meta_data.FieldMetaData(
            "testLong",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.FieldValueMetaData(
                org.apache.thrift.protocol.TType.I64)));
    tmpMap.put(
        _Fields.TEST_DOUBLE,
        new org.apache.thrift.meta_data.FieldMetaData(
            "testDouble",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.FieldValueMetaData(
                org.apache.thrift.protocol.TType.DOUBLE)));
    tmpMap.put(
        _Fields.STRING_INT_MAP,
        new org.apache.thrift.meta_data.FieldMetaData(
            "stringIntMap",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.MapMetaData(
                org.apache.thrift.protocol.TType.MAP,
                new org.apache.thrift.meta_data.FieldValueMetaData(
                    org.apache.thrift.protocol.TType.STRING),
                new org.apache.thrift.meta_data.FieldValueMetaData(
                    org.apache.thrift.protocol.TType.I16))));
    tmpMap.put(
        _Fields.TEST_BINARY,
        new org.apache.thrift.meta_data.FieldMetaData(
            "testBinary",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.FieldValueMetaData(
                org.apache.thrift.protocol.TType.STRING, true)));
    tmpMap.put(
        _Fields.TEST_BOOL,
        new org.apache.thrift.meta_data.FieldMetaData(
            "testBool",
            org.apache.thrift.TFieldRequirementType.DEFAULT,
            new org.apache.thrift.meta_data.FieldValueMetaData(
                org.apache.thrift.protocol.TType.BOOL)));
    metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
    org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(
        TestThriftStruct.class, metaDataMap);
  }

  public TestThriftStruct() {}

  public TestThriftStruct(
      byte testByte,
      short testShort,
      int testInt,
      long testLong,
      double testDouble,
      java.util.Map<java.lang.String, java.lang.Short> stringIntMap,
      java.nio.ByteBuffer testBinary,
      boolean testBool) {
    this();
    this.testByte = testByte;
    setTestByteIsSet(true);
    this.testShort = testShort;
    setTestShortIsSet(true);
    this.testInt = testInt;
    setTestIntIsSet(true);
    this.testLong = testLong;
    setTestLongIsSet(true);
    this.testDouble = testDouble;
    setTestDoubleIsSet(true);
    this.stringIntMap = stringIntMap;
    this.testBinary = org.apache.thrift.TBaseHelper.copyBinary(testBinary);
    this.testBool = testBool;
    setTestBoolIsSet(true);
  }

  /** Performs a deep copy on <i>other</i>. */
  public TestThriftStruct(TestThriftStruct other) {
    __isset_bitfield = other.__isset_bitfield;
    this.testByte = other.testByte;
    this.testShort = other.testShort;
    this.testInt = other.testInt;
    this.testLong = other.testLong;
    this.testDouble = other.testDouble;
    if (other.isSetStringIntMap()) {
      java.util.Map<java.lang.String, java.lang.Short> __this__stringIntMap =
          new java.util.HashMap<java.lang.String, java.lang.Short>(other.stringIntMap);
      this.stringIntMap = __this__stringIntMap;
    }
    if (other.isSetTestBinary()) {
      this.testBinary = org.apache.thrift.TBaseHelper.copyBinary(other.testBinary);
    }
    this.testBool = other.testBool;
  }

  public TestThriftStruct deepCopy() {
    return new TestThriftStruct(this);
  }

  @Override
  public void clear() {
    setTestByteIsSet(false);
    this.testByte = 0;
    setTestShortIsSet(false);
    this.testShort = 0;
    setTestIntIsSet(false);
    this.testInt = 0;
    setTestLongIsSet(false);
    this.testLong = 0;
    setTestDoubleIsSet(false);
    this.testDouble = 0.0;
    this.stringIntMap = null;
    this.testBinary = null;
    setTestBoolIsSet(false);
    this.testBool = false;
  }

  public byte getTestByte() {
    return this.testByte;
  }

  public TestThriftStruct setTestByte(byte testByte) {
    this.testByte = testByte;
    setTestByteIsSet(true);
    return this;
  }

  public void unsetTestByte() {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __TESTBYTE_ISSET_ID);
  }

  /** Returns true if field testByte is set (has been assigned a value) and false otherwise */
  public boolean isSetTestByte() {
    return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __TESTBYTE_ISSET_ID);
  }

  public void setTestByteIsSet(boolean value) {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __TESTBYTE_ISSET_ID, value);
  }

  public short getTestShort() {
    return this.testShort;
  }

  public TestThriftStruct setTestShort(short testShort) {
    this.testShort = testShort;
    setTestShortIsSet(true);
    return this;
  }

  public void unsetTestShort() {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __TESTSHORT_ISSET_ID);
  }

  /** Returns true if field testShort is set (has been assigned a value) and false otherwise */
  public boolean isSetTestShort() {
    return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __TESTSHORT_ISSET_ID);
  }

  public void setTestShortIsSet(boolean value) {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __TESTSHORT_ISSET_ID, value);
  }

  public int getTestInt() {
    return this.testInt;
  }

  public TestThriftStruct setTestInt(int testInt) {
    this.testInt = testInt;
    setTestIntIsSet(true);
    return this;
  }

  public void unsetTestInt() {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __TESTINT_ISSET_ID);
  }

  /** Returns true if field testInt is set (has been assigned a value) and false otherwise */
  public boolean isSetTestInt() {
    return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __TESTINT_ISSET_ID);
  }

  public void setTestIntIsSet(boolean value) {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __TESTINT_ISSET_ID, value);
  }

  public long getTestLong() {
    return this.testLong;
  }

  public TestThriftStruct setTestLong(long testLong) {
    this.testLong = testLong;
    setTestLongIsSet(true);
    return this;
  }

  public void unsetTestLong() {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __TESTLONG_ISSET_ID);
  }

  /** Returns true if field testLong is set (has been assigned a value) and false otherwise */
  public boolean isSetTestLong() {
    return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __TESTLONG_ISSET_ID);
  }

  public void setTestLongIsSet(boolean value) {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __TESTLONG_ISSET_ID, value);
  }

  public double getTestDouble() {
    return this.testDouble;
  }

  public TestThriftStruct setTestDouble(double testDouble) {
    this.testDouble = testDouble;
    setTestDoubleIsSet(true);
    return this;
  }

  public void unsetTestDouble() {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __TESTDOUBLE_ISSET_ID);
  }

  /** Returns true if field testDouble is set (has been assigned a value) and false otherwise */
  public boolean isSetTestDouble() {
    return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __TESTDOUBLE_ISSET_ID);
  }

  public void setTestDoubleIsSet(boolean value) {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __TESTDOUBLE_ISSET_ID, value);
  }

  public int getStringIntMapSize() {
    return (this.stringIntMap == null) ? 0 : this.stringIntMap.size();
  }

  public void putToStringIntMap(java.lang.String key, short val) {
    if (this.stringIntMap == null) {
      this.stringIntMap = new java.util.HashMap<java.lang.String, java.lang.Short>();
    }
    this.stringIntMap.put(key, val);
  }

  @org.apache.thrift.annotation.Nullable
  public java.util.Map<java.lang.String, java.lang.Short> getStringIntMap() {
    return this.stringIntMap;
  }

  public TestThriftStruct setStringIntMap(
      @org.apache.thrift.annotation.Nullable
          java.util.Map<java.lang.String, java.lang.Short> stringIntMap) {
    this.stringIntMap = stringIntMap;
    return this;
  }

  public void unsetStringIntMap() {
    this.stringIntMap = null;
  }

  /** Returns true if field stringIntMap is set (has been assigned a value) and false otherwise */
  public boolean isSetStringIntMap() {
    return this.stringIntMap != null;
  }

  public void setStringIntMapIsSet(boolean value) {
    if (!value) {
      this.stringIntMap = null;
    }
  }

  public byte[] getTestBinary() {
    setTestBinary(org.apache.thrift.TBaseHelper.rightSize(testBinary));
    return testBinary == null ? null : testBinary.array();
  }

  public java.nio.ByteBuffer bufferForTestBinary() {
    return org.apache.thrift.TBaseHelper.copyBinary(testBinary);
  }

  public TestThriftStruct setTestBinary(byte[] testBinary) {
    this.testBinary =
        testBinary == null
            ? (java.nio.ByteBuffer) null
            : java.nio.ByteBuffer.wrap(testBinary.clone());
    return this;
  }

  public TestThriftStruct setTestBinary(
      @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer testBinary) {
    this.testBinary = org.apache.thrift.TBaseHelper.copyBinary(testBinary);
    return this;
  }

  public void unsetTestBinary() {
    this.testBinary = null;
  }

  /** Returns true if field testBinary is set (has been assigned a value) and false otherwise */
  public boolean isSetTestBinary() {
    return this.testBinary != null;
  }

  public void setTestBinaryIsSet(boolean value) {
    if (!value) {
      this.testBinary = null;
    }
  }

  public boolean isTestBool() {
    return this.testBool;
  }

  public TestThriftStruct setTestBool(boolean testBool) {
    this.testBool = testBool;
    setTestBoolIsSet(true);
    return this;
  }

  public void unsetTestBool() {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __TESTBOOL_ISSET_ID);
  }

  /** Returns true if field testBool is set (has been assigned a value) and false otherwise */
  public boolean isSetTestBool() {
    return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __TESTBOOL_ISSET_ID);
  }

  public void setTestBoolIsSet(boolean value) {
    __isset_bitfield =
        org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __TESTBOOL_ISSET_ID, value);
  }

  public void setFieldValue(
      _Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
    switch (field) {
      case TEST_BYTE:
        if (value == null) {
          unsetTestByte();
        } else {
          setTestByte((java.lang.Byte) value);
        }
        break;

      case TEST_SHORT:
        if (value == null) {
          unsetTestShort();
        } else {
          setTestShort((java.lang.Short) value);
        }
        break;

      case TEST_INT:
        if (value == null) {
          unsetTestInt();
        } else {
          setTestInt((java.lang.Integer) value);
        }
        break;

      case TEST_LONG:
        if (value == null) {
          unsetTestLong();
        } else {
          setTestLong((java.lang.Long) value);
        }
        break;

      case TEST_DOUBLE:
        if (value == null) {
          unsetTestDouble();
        } else {
          setTestDouble((java.lang.Double) value);
        }
        break;

      case STRING_INT_MAP:
        if (value == null) {
          unsetStringIntMap();
        } else {
          setStringIntMap((java.util.Map<java.lang.String, java.lang.Short>) value);
        }
        break;

      case TEST_BINARY:
        if (value == null) {
          unsetTestBinary();
        } else {
          if (value instanceof byte[]) {
            setTestBinary((byte[]) value);
          } else {
            setTestBinary((java.nio.ByteBuffer) value);
          }
        }
        break;

      case TEST_BOOL:
        if (value == null) {
          unsetTestBool();
        } else {
          setTestBool((java.lang.Boolean) value);
        }
        break;
    }
  }

  @org.apache.thrift.annotation.Nullable
  public java.lang.Object getFieldValue(_Fields field) {
    switch (field) {
      case TEST_BYTE:
        return getTestByte();

      case TEST_SHORT:
        return getTestShort();

      case TEST_INT:
        return getTestInt();

      case TEST_LONG:
        return getTestLong();

      case TEST_DOUBLE:
        return getTestDouble();

      case STRING_INT_MAP:
        return getStringIntMap();

      case TEST_BINARY:
        return getTestBinary();

      case TEST_BOOL:
        return isTestBool();
    }
    throw new java.lang.IllegalStateException();
  }

  /**
   * Returns true if field corresponding to fieldID is set (has been assigned a value) and false
   * otherwise
   */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new java.lang.IllegalArgumentException();
    }

    switch (field) {
      case TEST_BYTE:
        return isSetTestByte();
      case TEST_SHORT:
        return isSetTestShort();
      case TEST_INT:
        return isSetTestInt();
      case TEST_LONG:
        return isSetTestLong();
      case TEST_DOUBLE:
        return isSetTestDouble();
      case STRING_INT_MAP:
        return isSetStringIntMap();
      case TEST_BINARY:
        return isSetTestBinary();
      case TEST_BOOL:
        return isSetTestBool();
    }
    throw new java.lang.IllegalStateException();
  }

  @Override
  public boolean equals(java.lang.Object that) {
    if (that == null) return false;
    if (that instanceof TestThriftStruct) return this.equals((TestThriftStruct) that);
    return false;
  }

  public boolean equals(TestThriftStruct that) {
    if (that == null) return false;
    if (this == that) return true;

    boolean this_present_testByte = true;
    boolean that_present_testByte = true;
    if (this_present_testByte || that_present_testByte) {
      if (!(this_present_testByte && that_present_testByte)) return false;
      if (this.testByte != that.testByte) return false;
    }

    boolean this_present_testShort = true;
    boolean that_present_testShort = true;
    if (this_present_testShort || that_present_testShort) {
      if (!(this_present_testShort && that_present_testShort)) return false;
      if (this.testShort != that.testShort) return false;
    }

    boolean this_present_testInt = true;
    boolean that_present_testInt = true;
    if (this_present_testInt || that_present_testInt) {
      if (!(this_present_testInt && that_present_testInt)) return false;
      if (this.testInt != that.testInt) return false;
    }

    boolean this_present_testLong = true;
    boolean that_present_testLong = true;
    if (this_present_testLong || that_present_testLong) {
      if (!(this_present_testLong && that_present_testLong)) return false;
      if (this.testLong != that.testLong) return false;
    }

    boolean this_present_testDouble = true;
    boolean that_present_testDouble = true;
    if (this_present_testDouble || that_present_testDouble) {
      if (!(this_present_testDouble && that_present_testDouble)) return false;
      if (this.testDouble != that.testDouble) return false;
    }

    boolean this_present_stringIntMap = true && this.isSetStringIntMap();
    boolean that_present_stringIntMap = true && that.isSetStringIntMap();
    if (this_present_stringIntMap || that_present_stringIntMap) {
      if (!(this_present_stringIntMap && that_present_stringIntMap)) return false;
      if (!this.stringIntMap.equals(that.stringIntMap)) return false;
    }

    boolean this_present_testBinary = true && this.isSetTestBinary();
    boolean that_present_testBinary = true && that.isSetTestBinary();
    if (this_present_testBinary || that_present_testBinary) {
      if (!(this_present_testBinary && that_present_testBinary)) return false;
      if (!this.testBinary.equals(that.testBinary)) return false;
    }

    boolean this_present_testBool = true;
    boolean that_present_testBool = true;
    if (this_present_testBool || that_present_testBool) {
      if (!(this_present_testBool && that_present_testBool)) return false;
      if (this.testBool != that.testBool) return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    int hashCode = 1;

    hashCode = hashCode * 8191 + (int) (testByte);

    hashCode = hashCode * 8191 + testShort;

    hashCode = hashCode * 8191 + testInt;

    hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(testLong);

    hashCode = hashCode * 8191 + org.apache.thrift.TBaseHelper.hashCode(testDouble);

    hashCode = hashCode * 8191 + ((isSetStringIntMap()) ? 131071 : 524287);
    if (isSetStringIntMap()) hashCode = hashCode * 8191 + stringIntMap.hashCode();

    hashCode = hashCode * 8191 + ((isSetTestBinary()) ? 131071 : 524287);
    if (isSetTestBinary()) hashCode = hashCode * 8191 + testBinary.hashCode();

    hashCode = hashCode * 8191 + ((testBool) ? 131071 : 524287);

    return hashCode;
  }

  @Override
  public int compareTo(TestThriftStruct other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;

    lastComparison = java.lang.Boolean.valueOf(isSetTestByte()).compareTo(other.isSetTestByte());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTestByte()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.testByte, other.testByte);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = java.lang.Boolean.valueOf(isSetTestShort()).compareTo(other.isSetTestShort());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTestShort()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.testShort, other.testShort);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = java.lang.Boolean.valueOf(isSetTestInt()).compareTo(other.isSetTestInt());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTestInt()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.testInt, other.testInt);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = java.lang.Boolean.valueOf(isSetTestLong()).compareTo(other.isSetTestLong());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTestLong()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.testLong, other.testLong);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison =
        java.lang.Boolean.valueOf(isSetTestDouble()).compareTo(other.isSetTestDouble());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTestDouble()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.testDouble, other.testDouble);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison =
        java.lang.Boolean.valueOf(isSetStringIntMap()).compareTo(other.isSetStringIntMap());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetStringIntMap()) {
      lastComparison =
          org.apache.thrift.TBaseHelper.compareTo(this.stringIntMap, other.stringIntMap);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison =
        java.lang.Boolean.valueOf(isSetTestBinary()).compareTo(other.isSetTestBinary());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTestBinary()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.testBinary, other.testBinary);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = java.lang.Boolean.valueOf(isSetTestBool()).compareTo(other.isSetTestBool());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTestBool()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.testBool, other.testBool);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  @org.apache.thrift.annotation.Nullable
  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }

  public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
    scheme(iprot).read(iprot, this);
  }

  public void write(org.apache.thrift.protocol.TProtocol oprot)
      throws org.apache.thrift.TException {
    scheme(oprot).write(oprot, this);
  }

  @Override
  public java.lang.String toString() {
    java.lang.StringBuilder sb = new java.lang.StringBuilder("TestThriftStruct(");
    boolean first = true;

    sb.append("testByte:");
    sb.append(this.testByte);
    first = false;
    if (!first) sb.append(", ");
    sb.append("testShort:");
    sb.append(this.testShort);
    first = false;
    if (!first) sb.append(", ");
    sb.append("testInt:");
    sb.append(this.testInt);
    first = false;
    if (!first) sb.append(", ");
    sb.append("testLong:");
    sb.append(this.testLong);
    first = false;
    if (!first) sb.append(", ");
    sb.append("testDouble:");
    sb.append(this.testDouble);
    first = false;
    if (!first) sb.append(", ");
    sb.append("stringIntMap:");
    if (this.stringIntMap == null) {
      sb.append("null");
    } else {
      sb.append(this.stringIntMap);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("testBinary:");
    if (this.testBinary == null) {
      sb.append("null");
    } else {
      org.apache.thrift.TBaseHelper.toString(this.testBinary, sb);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("testBool:");
    sb.append(this.testBool);
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws org.apache.thrift.TException {
    // check for required fields
    // check for sub-struct validity
  }

  private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
    try {
      write(
          new org.apache.thrift.protocol.TCompactProtocol(
              new org.apache.thrift.transport.TIOStreamTransport(out)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private void readObject(java.io.ObjectInputStream in)
      throws java.io.IOException, java.lang.ClassNotFoundException {
    try {
      // it doesn't seem like you should have to do this, but java serialization is wacky, and
      // doesn't call the default constructor.
      __isset_bitfield = 0;
      read(
          new org.apache.thrift.protocol.TCompactProtocol(
              new org.apache.thrift.transport.TIOStreamTransport(in)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private static class TestThriftStructStandardSchemeFactory
      implements org.apache.thrift.scheme.SchemeFactory {
    public TestThriftStructStandardScheme getScheme() {
      return new TestThriftStructStandardScheme();
    }
  }

  private static class TestThriftStructStandardScheme
      extends org.apache.thrift.scheme.StandardScheme<TestThriftStruct> {

    public void read(org.apache.thrift.protocol.TProtocol iprot, TestThriftStruct struct)
        throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField schemeField;
      iprot.readStructBegin();
      while (true) {
        schemeField = iprot.readFieldBegin();
        if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (schemeField.id) {
          case 1: // TEST_BYTE
            if (schemeField.type == org.apache.thrift.protocol.TType.BYTE) {
              struct.testByte = iprot.readByte();
              struct.setTestByteIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 2: // TEST_SHORT
            if (schemeField.type == org.apache.thrift.protocol.TType.I16) {
              struct.testShort = iprot.readI16();
              struct.setTestShortIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 3: // TEST_INT
            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
              struct.testInt = iprot.readI32();
              struct.setTestIntIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 4: // TEST_LONG
            if (schemeField.type == org.apache.thrift.protocol.TType.I64) {
              struct.testLong = iprot.readI64();
              struct.setTestLongIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 5: // TEST_DOUBLE
            if (schemeField.type == org.apache.thrift.protocol.TType.DOUBLE) {
              struct.testDouble = iprot.readDouble();
              struct.setTestDoubleIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 6: // STRING_INT_MAP
            if (schemeField.type == org.apache.thrift.protocol.TType.MAP) {
              {
                org.apache.thrift.protocol.TMap _map0 = iprot.readMapBegin();
                struct.stringIntMap =
                    new java.util.HashMap<java.lang.String, java.lang.Short>(2 * _map0.size);
                @org.apache.thrift.annotation.Nullable java.lang.String _key1;
                short _val2;
                for (int _i3 = 0; _i3 < _map0.size; ++_i3) {
                  _key1 = iprot.readString();
                  _val2 = iprot.readI16();
                  struct.stringIntMap.put(_key1, _val2);
                }
                iprot.readMapEnd();
              }
              struct.setStringIntMapIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 7: // TEST_BINARY
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.testBinary = iprot.readBinary();
              struct.setTestBinaryIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 8: // TEST_BOOL
            if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
              struct.testBool = iprot.readBool();
              struct.setTestBoolIsSet(true);
            } else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      struct.validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot, TestThriftStruct struct)
        throws org.apache.thrift.TException {
      struct.validate();

      oprot.writeStructBegin(STRUCT_DESC);
      oprot.writeFieldBegin(TEST_BYTE_FIELD_DESC);
      oprot.writeByte(struct.testByte);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(TEST_SHORT_FIELD_DESC);
      oprot.writeI16(struct.testShort);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(TEST_INT_FIELD_DESC);
      oprot.writeI32(struct.testInt);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(TEST_LONG_FIELD_DESC);
      oprot.writeI64(struct.testLong);
      oprot.writeFieldEnd();
      oprot.writeFieldBegin(TEST_DOUBLE_FIELD_DESC);
      oprot.writeDouble(struct.testDouble);
      oprot.writeFieldEnd();
      if (struct.stringIntMap != null) {
        oprot.writeFieldBegin(STRING_INT_MAP_FIELD_DESC);
        {
          oprot.writeMapBegin(
              new org.apache.thrift.protocol.TMap(
                  org.apache.thrift.protocol.TType.STRING,
                  org.apache.thrift.protocol.TType.I16,
                  struct.stringIntMap.size()));
          for (java.util.Map.Entry<java.lang.String, java.lang.Short> _iter4 :
              struct.stringIntMap.entrySet()) {
            oprot.writeString(_iter4.getKey());
            oprot.writeI16(_iter4.getValue());
          }
          oprot.writeMapEnd();
        }
        oprot.writeFieldEnd();
      }
      if (struct.testBinary != null) {
        oprot.writeFieldBegin(TEST_BINARY_FIELD_DESC);
        oprot.writeBinary(struct.testBinary);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldBegin(TEST_BOOL_FIELD_DESC);
      oprot.writeBool(struct.testBool);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }
  }

  private static class TestThriftStructTupleSchemeFactory
      implements org.apache.thrift.scheme.SchemeFactory {
    public TestThriftStructTupleScheme getScheme() {
      return new TestThriftStructTupleScheme();
    }
  }

  private static class TestThriftStructTupleScheme
      extends org.apache.thrift.scheme.TupleScheme<TestThriftStruct> {

    @Override
    public void write(org.apache.thrift.protocol.TProtocol prot, TestThriftStruct struct)
        throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TTupleProtocol oprot =
          (org.apache.thrift.protocol.TTupleProtocol) prot;
      java.util.BitSet optionals = new java.util.BitSet();
      if (struct.isSetTestByte()) {
        optionals.set(0);
      }
      if (struct.isSetTestShort()) {
        optionals.set(1);
      }
      if (struct.isSetTestInt()) {
        optionals.set(2);
      }
      if (struct.isSetTestLong()) {
        optionals.set(3);
      }
      if (struct.isSetTestDouble()) {
        optionals.set(4);
      }
      if (struct.isSetStringIntMap()) {
        optionals.set(5);
      }
      if (struct.isSetTestBinary()) {
        optionals.set(6);
      }
      if (struct.isSetTestBool()) {
        optionals.set(7);
      }
      oprot.writeBitSet(optionals, 8);
      if (struct.isSetTestByte()) {
        oprot.writeByte(struct.testByte);
      }
      if (struct.isSetTestShort()) {
        oprot.writeI16(struct.testShort);
      }
      if (struct.isSetTestInt()) {
        oprot.writeI32(struct.testInt);
      }
      if (struct.isSetTestLong()) {
        oprot.writeI64(struct.testLong);
      }
      if (struct.isSetTestDouble()) {
        oprot.writeDouble(struct.testDouble);
      }
      if (struct.isSetStringIntMap()) {
        {
          oprot.writeI32(struct.stringIntMap.size());
          for (java.util.Map.Entry<java.lang.String, java.lang.Short> _iter5 :
              struct.stringIntMap.entrySet()) {
            oprot.writeString(_iter5.getKey());
            oprot.writeI16(_iter5.getValue());
          }
        }
      }
      if (struct.isSetTestBinary()) {
        oprot.writeBinary(struct.testBinary);
      }
      if (struct.isSetTestBool()) {
        oprot.writeBool(struct.testBool);
      }
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol prot, TestThriftStruct struct)
        throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TTupleProtocol iprot =
          (org.apache.thrift.protocol.TTupleProtocol) prot;
      java.util.BitSet incoming = iprot.readBitSet(8);
      if (incoming.get(0)) {
        struct.testByte = iprot.readByte();
        struct.setTestByteIsSet(true);
      }
      if (incoming.get(1)) {
        struct.testShort = iprot.readI16();
        struct.setTestShortIsSet(true);
      }
      if (incoming.get(2)) {
        struct.testInt = iprot.readI32();
        struct.setTestIntIsSet(true);
      }
      if (incoming.get(3)) {
        struct.testLong = iprot.readI64();
        struct.setTestLongIsSet(true);
      }
      if (incoming.get(4)) {
        struct.testDouble = iprot.readDouble();
        struct.setTestDoubleIsSet(true);
      }
      if (incoming.get(5)) {
        {
          org.apache.thrift.protocol.TMap _map6 =
              new org.apache.thrift.protocol.TMap(
                  org.apache.thrift.protocol.TType.STRING,
                  org.apache.thrift.protocol.TType.I16,
                  iprot.readI32());
          struct.stringIntMap =
              new java.util.HashMap<java.lang.String, java.lang.Short>(2 * _map6.size);
          @org.apache.thrift.annotation.Nullable java.lang.String _key7;
          short _val8;
          for (int _i9 = 0; _i9 < _map6.size; ++_i9) {
            _key7 = iprot.readString();
            _val8 = iprot.readI16();
            struct.stringIntMap.put(_key7, _val8);
          }
        }
        struct.setStringIntMapIsSet(true);
      }
      if (incoming.get(6)) {
        struct.testBinary = iprot.readBinary();
        struct.setTestBinaryIsSet(true);
      }
      if (incoming.get(7)) {
        struct.testBool = iprot.readBool();
        struct.setTestBoolIsSet(true);
      }
    }
  }

  private static <S extends org.apache.thrift.scheme.IScheme> S scheme(
      org.apache.thrift.protocol.TProtocol proto) {
    return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme())
            ? STANDARD_SCHEME_FACTORY
            : TUPLE_SCHEME_FACTORY)
        .getScheme();
  }
}
