// Code generated by protoc-gen-go. DO NOT EDIT.
// source: beam_runner_api.proto

package pipeline_v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	descriptor "github.com/golang/protobuf/protoc-gen-go/descriptor"
	_ "github.com/golang/protobuf/ptypes/any"
	_ "github.com/golang/protobuf/ptypes/timestamp"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type BeamConstants_Constants int32

const (
	// All timestamps of elements or window boundaries must be within
	// the interval [MIN_TIMESTAMP_MILLIS, MAX_TIMESTAMP_MILLIS].
	// The smallest representable timestamp of an element or a window boundary.
	BeamConstants_MIN_TIMESTAMP_MILLIS BeamConstants_Constants = 0
	// The largest representable timestamp of an element or a window boundary.
	BeamConstants_MAX_TIMESTAMP_MILLIS BeamConstants_Constants = 1
	// The maximum timestamp for the global window.
	// Triggers use max timestamp to set timers' timestamp. Timers fire when
	// the watermark passes their timestamps. So, the timestamp needs to be
	// smaller than the MAX_TIMESTAMP_MILLIS.
	// One standard day is subtracted from MAX_TIMESTAMP_MILLIS to make sure
	// the max timestamp is smaller than MAX_TIMESTAMP_MILLIS even after rounding up
	// to seconds or minutes.
	BeamConstants_GLOBAL_WINDOW_MAX_TIMESTAMP_MILLIS BeamConstants_Constants = 2
)

var BeamConstants_Constants_name = map[int32]string{
	0: "MIN_TIMESTAMP_MILLIS",
	1: "MAX_TIMESTAMP_MILLIS",
	2: "GLOBAL_WINDOW_MAX_TIMESTAMP_MILLIS",
}

var BeamConstants_Constants_value = map[string]int32{
	"MIN_TIMESTAMP_MILLIS":               0,
	"MAX_TIMESTAMP_MILLIS":               1,
	"GLOBAL_WINDOW_MAX_TIMESTAMP_MILLIS": 2,
}

func (x BeamConstants_Constants) String() string {
	return proto.EnumName(BeamConstants_Constants_name, int32(x))
}

func (BeamConstants_Constants) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{0, 0}
}

// Primitive transforms may not specify composite sub-transforms.
type StandardPTransforms_Primitives int32

const (
	// ParDo is a Beam transform for generic parallel processing. The ParDo
	// processing paradigm is similar to the “Map” phase of a
	// Map/Shuffle/Reduce-style algorithm: a ParDo transform considers each
	// element in the input PCollection, performs some processing function
	// (your user code) on that element, and emits zero, one, or multiple
	// elements to an output PCollection.
	//
	// See https://beam.apache.org/documentation/programming-guide/#pardo
	// for additional details.
	//
	// Payload: ParDoPayload
	StandardPTransforms_PAR_DO StandardPTransforms_Primitives = 0
	// Flatten is a Beam transform for PCollection objects that store the same
	// data type. Flatten merges multiple PCollection objects into a single
	// logical PCollection.
	//
	// See https://beam.apache.org/documentation/programming-guide/#flatten
	// for additional details.
	//
	// Payload: None
	StandardPTransforms_FLATTEN StandardPTransforms_Primitives = 1
	// GroupByKey is a Beam transform for processing collections of key/value
	// pairs. It’s a parallel reduction operation, analogous to the Shuffle
	// phase of a Map/Shuffle/Reduce-style algorithm. The input to GroupByKey is
	// a collection of key/value pairs that represents a multimap, where the
	// collection contains multiple pairs that have the same key, but different
	// values. Given such a collection, you use GroupByKey to collect all of the
	// values associated with each unique key.
	//
	// See https://beam.apache.org/documentation/programming-guide/#groupbykey
	// for additional details.
	//
	// Never defines an environment as the runner is required to implement this
	// transform.
	//
	// Payload: None
	StandardPTransforms_GROUP_BY_KEY StandardPTransforms_Primitives = 2
	// A transform which produces a single empty byte array at the minimum
	// timestamp in the GlobalWindow.
	//
	// Never defines an environment as the runner is required to implement this
	// transform.
	//
	// Payload: None
	StandardPTransforms_IMPULSE StandardPTransforms_Primitives = 3
	// Windowing subdivides a PCollection according to the timestamps of its
	// individual elements. Transforms that aggregate multiple elements, such as
	// GroupByKey and Combine, work implicitly on a per-window basis — they
	// process each PCollection as a succession of multiple, finite windows,
	// though the entire collection itself may be of unbounded size.
	//
	// See https://beam.apache.org/documentation/programming-guide/#windowing
	// for additional details.
	//
	// Payload: WindowIntoPayload
	StandardPTransforms_ASSIGN_WINDOWS StandardPTransforms_Primitives = 4
	// A testing input that generates an unbounded {@link PCollection} of
	// elements, advancing the watermark and processing time as elements are
	// emitted. After all of the specified elements are emitted, ceases to
	// produce output.
	//
	// See https://beam.apache.org/blog/2016/10/20/test-stream.html
	// for additional details.
	//
	// Payload: TestStreamPayload
	StandardPTransforms_TEST_STREAM StandardPTransforms_Primitives = 5
	// Represents mapping of main input window onto side input window.
	//
	// Side input window mapping function:
	// Input: KV<nonce, MainInputWindow>
	// Output: KV<nonce, SideInputWindow>
	//
	// For each main input window, the side input window is returned. The
	// nonce is used by a runner to associate each input with its output.
	// The nonce is represented as an opaque set of bytes.
	//
	// Payload: SideInput#window_mapping_fn FunctionSpec
	StandardPTransforms_MAP_WINDOWS StandardPTransforms_Primitives = 6
	// Used to merge windows during a GroupByKey.
	//
	// Window merging function:
	// Input: KV<nonce, iterable<OriginalWindow>>
	// Output: KV<nonce, KV<iterable<UnmergedOriginalWindow>, iterable<KV<MergedWindow, iterable<ConsumedOriginalWindow>>>>
	//
	// For each set of original windows, a list of all unmerged windows is
	// output alongside a map of merged window to set of consumed windows.
	// All original windows must be contained in either the unmerged original
	// window set or one of the consumed original window sets. Each original
	// window can only be part of one output set. The nonce is used by a runner
	// to associate each input with its output. The nonce is represented as an
	// opaque set of bytes.
	//
	// Payload: WindowingStrategy#window_fn FunctionSpec
	StandardPTransforms_MERGE_WINDOWS StandardPTransforms_Primitives = 7
)

var StandardPTransforms_Primitives_name = map[int32]string{
	0: "PAR_DO",
	1: "FLATTEN",
	2: "GROUP_BY_KEY",
	3: "IMPULSE",
	4: "ASSIGN_WINDOWS",
	5: "TEST_STREAM",
	6: "MAP_WINDOWS",
	7: "MERGE_WINDOWS",
}

var StandardPTransforms_Primitives_value = map[string]int32{
	"PAR_DO":         0,
	"FLATTEN":        1,
	"GROUP_BY_KEY":   2,
	"IMPULSE":        3,
	"ASSIGN_WINDOWS": 4,
	"TEST_STREAM":    5,
	"MAP_WINDOWS":    6,
	"MERGE_WINDOWS":  7,
}

func (x StandardPTransforms_Primitives) String() string {
	return proto.EnumName(StandardPTransforms_Primitives_name, int32(x))
}

func (StandardPTransforms_Primitives) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{4, 0}
}

type StandardPTransforms_DeprecatedPrimitives int32

const (
	// Represents the operation to read a Bounded or Unbounded source.
	// Payload: ReadPayload.
	StandardPTransforms_READ StandardPTransforms_DeprecatedPrimitives = 0
	// Runners should move away from translating `CreatePCollectionView` and treat this as
	// part of the translation for a `ParDo` side input.
	StandardPTransforms_CREATE_VIEW StandardPTransforms_DeprecatedPrimitives = 1
)

var StandardPTransforms_DeprecatedPrimitives_name = map[int32]string{
	0: "READ",
	1: "CREATE_VIEW",
}

var StandardPTransforms_DeprecatedPrimitives_value = map[string]int32{
	"READ":        0,
	"CREATE_VIEW": 1,
}

func (x StandardPTransforms_DeprecatedPrimitives) String() string {
	return proto.EnumName(StandardPTransforms_DeprecatedPrimitives_name, int32(x))
}

func (StandardPTransforms_DeprecatedPrimitives) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{4, 1}
}

type StandardPTransforms_Composites int32

const (
	// Represents the Combine.perKey() operation.
	// If this is produced by an SDK, it is assumed that the SDK understands
	// each of CombineComponents.
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_PER_KEY StandardPTransforms_Composites = 0
	// Represents the Combine.globally() operation.
	// If this is produced by an SDK, it is assumed that the SDK understands
	// each of CombineComponents.
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_GLOBALLY StandardPTransforms_Composites = 1
	// Represents the Reshuffle operation.
	StandardPTransforms_RESHUFFLE StandardPTransforms_Composites = 2
	// Less well-known. Payload: WriteFilesPayload.
	StandardPTransforms_WRITE_FILES StandardPTransforms_Composites = 3
)

var StandardPTransforms_Composites_name = map[int32]string{
	0: "COMBINE_PER_KEY",
	1: "COMBINE_GLOBALLY",
	2: "RESHUFFLE",
	3: "WRITE_FILES",
}

var StandardPTransforms_Composites_value = map[string]int32{
	"COMBINE_PER_KEY":  0,
	"COMBINE_GLOBALLY": 1,
	"RESHUFFLE":        2,
	"WRITE_FILES":      3,
}

func (x StandardPTransforms_Composites) String() string {
	return proto.EnumName(StandardPTransforms_Composites_name, int32(x))
}

func (StandardPTransforms_Composites) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{4, 2}
}

// Payload for all of these: CombinePayload
type StandardPTransforms_CombineComponents int32

const (
	// Represents the Pre-Combine part of a lifted Combine Per Key, as described
	// in the following document:
	// https://s.apache.org/beam-runner-api-combine-model#heading=h.ta0g6ase8z07
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_PER_KEY_PRECOMBINE StandardPTransforms_CombineComponents = 0
	// Represents the Merge Accumulators part of a lifted Combine Per Key, as
	// described in the following document:
	// https://s.apache.org/beam-runner-api-combine-model#heading=h.jco9rvatld5m
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_PER_KEY_MERGE_ACCUMULATORS StandardPTransforms_CombineComponents = 1
	// Represents the Extract Outputs part of a lifted Combine Per Key, as
	// described in the following document:
	// https://s.apache.org/beam-runner-api-combine-model#heading=h.i9i6p8gtl6ku
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_PER_KEY_EXTRACT_OUTPUTS StandardPTransforms_CombineComponents = 2
	// Represents the Combine Grouped Values transform, as described in the
	// following document:
	// https://s.apache.org/beam-runner-api-combine-model#heading=h.aj86ew4v1wk
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_GROUPED_VALUES StandardPTransforms_CombineComponents = 3
	// Represents the Convert To Accumulators transform, as described in the
	// following document:
	// https://s.apache.org/beam-runner-api-combine-model#heading=h.h5697l1scd9x
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_PER_KEY_CONVERT_TO_ACCUMULATORS StandardPTransforms_CombineComponents = 4
)

var StandardPTransforms_CombineComponents_name = map[int32]string{
	0: "COMBINE_PER_KEY_PRECOMBINE",
	1: "COMBINE_PER_KEY_MERGE_ACCUMULATORS",
	2: "COMBINE_PER_KEY_EXTRACT_OUTPUTS",
	3: "COMBINE_GROUPED_VALUES",
	4: "COMBINE_PER_KEY_CONVERT_TO_ACCUMULATORS",
}

var StandardPTransforms_CombineComponents_value = map[string]int32{
	"COMBINE_PER_KEY_PRECOMBINE":              0,
	"COMBINE_PER_KEY_MERGE_ACCUMULATORS":      1,
	"COMBINE_PER_KEY_EXTRACT_OUTPUTS":         2,
	"COMBINE_GROUPED_VALUES":                  3,
	"COMBINE_PER_KEY_CONVERT_TO_ACCUMULATORS": 4,
}

func (x StandardPTransforms_CombineComponents) String() string {
	return proto.EnumName(StandardPTransforms_CombineComponents_name, int32(x))
}

func (StandardPTransforms_CombineComponents) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{4, 3}
}

// Payload for all of these: ParDoPayload containing the user's SDF
type StandardPTransforms_SplittableParDoComponents int32

const (
	// Pairs the input element with its initial restriction.
	// Input: element; output: KV(element, restriction).
	StandardPTransforms_PAIR_WITH_RESTRICTION StandardPTransforms_SplittableParDoComponents = 0
	// Splits the restriction inside an element/restriction pair.
	// Input: KV(element, restriction); output: KV(element, restriction).
	StandardPTransforms_SPLIT_RESTRICTION StandardPTransforms_SplittableParDoComponents = 1
	// Applies the DoFn to every element/restriction pair in a uniquely keyed
	// collection, in a splittable fashion.
	// Input: KV(bytes, KV(element, restriction)); output: DoFn's output.
	// The first "bytes" is an opaque unique key using the standard bytes coder.
	// Typically a runner would rewrite this into a runner-specific grouping
	// operation supporting state and timers, followed by PROCESS_ELEMENTS,
	// with some runner-specific glue code in between.
	StandardPTransforms_PROCESS_KEYED_ELEMENTS StandardPTransforms_SplittableParDoComponents = 2
	// Like PROCESS_KEYED_ELEMENTS, but without the unique key - just elements
	// and restrictions.
	// Input: KV(element, restriction); output: DoFn's output.
	StandardPTransforms_PROCESS_ELEMENTS StandardPTransforms_SplittableParDoComponents = 3
	// Splits the restriction of each element/restriction pair and returns the
	// resulting splits, with a corresponding floating point size estimations
	// for each.
	// A reasonable value for size is the number of bytes expected to be
	// produced by this (element, restriction) pair.
	// Input: KV(element, restriction)
	// Output: KV(KV(element, restriction), size))
	StandardPTransforms_SPLIT_AND_SIZE_RESTRICTIONS StandardPTransforms_SplittableParDoComponents = 4
	// Like PROCESS_ELEMENTS, but accepts the sized output produced by
	// SPLIT_RESTRICTION_WITH_SIZING.
	// Input: KV(KV(element, restriction), size); output: DoFn's output.
	StandardPTransforms_PROCESS_SIZED_ELEMENTS_AND_RESTRICTIONS StandardPTransforms_SplittableParDoComponents = 5
)

var StandardPTransforms_SplittableParDoComponents_name = map[int32]string{
	0: "PAIR_WITH_RESTRICTION",
	1: "SPLIT_RESTRICTION",
	2: "PROCESS_KEYED_ELEMENTS",
	3: "PROCESS_ELEMENTS",
	4: "SPLIT_AND_SIZE_RESTRICTIONS",
	5: "PROCESS_SIZED_ELEMENTS_AND_RESTRICTIONS",
}

var StandardPTransforms_SplittableParDoComponents_value = map[string]int32{
	"PAIR_WITH_RESTRICTION":                   0,
	"SPLIT_RESTRICTION":                       1,
	"PROCESS_KEYED_ELEMENTS":                  2,
	"PROCESS_ELEMENTS":                        3,
	"SPLIT_AND_SIZE_RESTRICTIONS":             4,
	"PROCESS_SIZED_ELEMENTS_AND_RESTRICTIONS": 5,
}

func (x StandardPTransforms_SplittableParDoComponents) String() string {
	return proto.EnumName(StandardPTransforms_SplittableParDoComponents_name, int32(x))
}

func (StandardPTransforms_SplittableParDoComponents) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{4, 4}
}

type StandardSideInputTypes_Enum int32

const (
	// Represents a view over a PCollection<V>.
	//
	// StateGetRequests performed on this side input must use
	// StateKey.IterableSideInput.
	StandardSideInputTypes_ITERABLE StandardSideInputTypes_Enum = 0
	// Represents a view over a PCollection<KV<K, V>>.
	//
	// StateGetRequests performed on this side input must use
	// StateKey.IterableSideInput or StateKey.MultimapSideInput.
	StandardSideInputTypes_MULTIMAP StandardSideInputTypes_Enum = 1
)

var StandardSideInputTypes_Enum_name = map[int32]string{
	0: "ITERABLE",
	1: "MULTIMAP",
}

var StandardSideInputTypes_Enum_value = map[string]int32{
	"ITERABLE": 0,
	"MULTIMAP": 1,
}

func (x StandardSideInputTypes_Enum) String() string {
	return proto.EnumName(StandardSideInputTypes_Enum_name, int32(x))
}

func (StandardSideInputTypes_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{5, 0}
}

type IsBounded_Enum int32

const (
	IsBounded_UNSPECIFIED IsBounded_Enum = 0
	IsBounded_UNBOUNDED   IsBounded_Enum = 1
	IsBounded_BOUNDED     IsBounded_Enum = 2
)

var IsBounded_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "UNBOUNDED",
	2: "BOUNDED",
}

var IsBounded_Enum_value = map[string]int32{
	"UNSPECIFIED": 0,
	"UNBOUNDED":   1,
	"BOUNDED":     2,
}

func (x IsBounded_Enum) String() string {
	return proto.EnumName(IsBounded_Enum_name, int32(x))
}

func (IsBounded_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{15, 0}
}

type StandardCoders_Enum int32

const (
	// Components: None
	StandardCoders_BYTES StandardCoders_Enum = 0
	// Components: None
	StandardCoders_STRING_UTF8 StandardCoders_Enum = 10
	// Components: The key and value coder, in that order.
	StandardCoders_KV StandardCoders_Enum = 1
	// Components: None
	StandardCoders_BOOL StandardCoders_Enum = 12
	// Variable length Encodes a 64-bit integer.
	// Components: None
	StandardCoders_VARINT StandardCoders_Enum = 2
	// Encodes the floating point value as a big-endian 64-bit integer
	// according to the IEEE 754 double format bit layout.
	// Components: None
	StandardCoders_DOUBLE StandardCoders_Enum = 11
	// Encodes an iterable of elements.
	//
	// The encoding for an iterable [e1...eN] of known length N is
	//
	//    fixed32(N)
	//    encode(e1) encode(e2) encode(e3) ... encode(eN)
	//
	// If the length is unknown, it is batched up into groups of size b1..bM
	// and encoded as
	//
	//     fixed32(-1)
	//     varInt64(b1) encode(e1) encode(e2) ... encode(e_b1)
	//     varInt64(b2) encode(e_(b1+1)) encode(e_(b1+2)) ... encode(e_(b1+b2))
	//     ...
	//     varInt64(bM) encode(e_(N-bM+1)) encode(e_(N-bM+2)) ... encode(eN)
	//     varInt64(0)
	//
	// Components: Coder for a single element.
	StandardCoders_ITERABLE StandardCoders_Enum = 3
	// Encodes a timer containing a user key, a dynamic timer tag, a clear bit,
	// a fire timestamp, a hold timestamp, the windows and the paneinfo.
	// The encoding is represented as:
	//   user key - user defined key, uses the component coder.
	//   dynamic timer tag - a string which identifies a timer.
	//   windows - uses component coders.
	//   clear bit - a boolean set for clearing the timer.
	//   fire timestamp - a big endian 8 byte integer representing millis-since-epoch.
	//     The encoded representation is shifted so that the byte representation of
	//     negative values are lexicographically ordered before the byte representation
	//     of positive values. This is typically done by subtracting -9223372036854775808
	//     from the value and encoding it as a signed big endian integer. Example values:
	//
	//     -9223372036854775808: 00 00 00 00 00 00 00 00
	//                     -255: 7F FF FF FF FF FF FF 01
	//                       -1: 7F FF FF FF FF FF FF FF
	//                        0: 80 00 00 00 00 00 00 00
	//                        1: 80 00 00 00 00 00 00 01
	//                      256: 80 00 00 00 00 00 01 00
	//      9223372036854775807: FF FF FF FF FF FF FF FF
	//   hold timestamp - similar to the fire timestamp.
	//   paneinfo - similar to the paneinfo of the windowed_value.
	// Components: Coder for the key and windows.
	StandardCoders_TIMER StandardCoders_Enum = 4
	// Components: None
	StandardCoders_INTERVAL_WINDOW StandardCoders_Enum = 5
	// Components: The coder to attach a length prefix to
	StandardCoders_LENGTH_PREFIX StandardCoders_Enum = 6
	// Components: None
	StandardCoders_GLOBAL_WINDOW StandardCoders_Enum = 7
	// Encodes an element, the windows it is in, the timestamp of the element,
	// and the pane of the element. The encoding is represented as:
	// timestamp windows pane element
	//   timestamp - A big endian 8 byte integer representing millis-since-epoch.
	//     The encoded representation is shifted so that the byte representation
	//     of negative values are lexicographically ordered before the byte
	//     representation of positive values. This is typically done by
	//     subtracting -9223372036854775808 from the value and encoding it as a
	//     signed big endian integer. Example values:
	//
	//     -9223372036854775808: 00 00 00 00 00 00 00 00
	//                     -255: 7F FF FF FF FF FF FF 01
	//                       -1: 7F FF FF FF FF FF FF FF
	//                        0: 80 00 00 00 00 00 00 00
	//                        1: 80 00 00 00 00 00 00 01
	//                      256: 80 00 00 00 00 00 01 00
	//      9223372036854775807: FF FF FF FF FF FF FF FF
	//
	//   windows - The windows are encoded using the beam:coder:iterable:v1
	//     format, where the windows are encoded using the supplied window
	//     coder.
	//
	//   pane - The first byte of the pane info determines which type of
	//     encoding is used, as well as the is_first, is_last, and timing
	//     fields. If this byte is bits [0 1 2 3 4 5 6 7], then:
	//     * bits [0 1 2 3] determine the encoding as follows:
	//         0000 - The entire pane info is encoded as a single byte.
	//                The is_first, is_last, and timing fields are encoded
	//                as below, and the index and non-speculative index are
	//                both zero (and hence are not encoded here).
	//         0001 - The pane info is encoded as this byte plus a single
	//                VarInt encoed integer representing the pane index. The
	//                non-speculative index can be derived as follows:
	//                  -1 if the pane is early, otherwise equal to index.
	//         0010 - The pane info is encoded as this byte plus two VarInt
	//                encoded integers representing the pane index and
	//                non-speculative index respectively.
	//     * bits [4 5] encode the timing as follows:
	//         00 - early
	//         01 - on time
	//         10 - late
	//         11 - unknown
	//     * bit 6 is 1 if this is the first pane, 0 otherwise.
	//     * bit 7 is 1 if this is the last pane, 0 otherwise.
	//
	//   element - The element incoded using the supplied element coder.
	//
	// Components: The element coder and the window coder, in that order.
	StandardCoders_WINDOWED_VALUE StandardCoders_Enum = 8
	// A windowed value coder with parameterized timestamp, windows and pane info.
	// Encodes an element with only the value of the windowed value.
	// Decodes the value and assigns the parameterized timestamp, windows and pane info to the
	// windowed value.
	// Components: The element coder and the window coder, in that order
	// The payload of this coder is an encoded windowed value using the
	// beam:coder:windowed_value:v1 coder parameterized by a beam:coder:bytes:v1
	// element coder and the window coder that this param_windowed_value coder uses.
	StandardCoders_PARAM_WINDOWED_VALUE StandardCoders_Enum = 14
	// Encodes an iterable of elements, some of which may be stored elsewhere.
	//
	// The encoding for a state-backed iterable is the same as that for
	// an iterable, but the final varInt64(0) terminating the set of batches
	// may instead be replaced by
	//
	//     varInt64(-1)
	//     varInt64(len(token))
	//     token
	//
	// where token is an opaque byte string that can be used to fetch the
	// remainder of the iterable (e.g. over the state API).
	//
	// Components: Coder for a single element.
	// Experimental.
	StandardCoders_STATE_BACKED_ITERABLE StandardCoders_Enum = 9
	// Encodes a "row", an element with a known schema, defined by an
	// instance of Schema from schema.proto.
	//
	// A row is encoded as the concatenation of:
	//   - The number of attributes in the schema, encoded with
	//     beam:coder:varint:v1. This makes it possible to detect certain
	//     allowed schema changes (appending or removing columns) in
	//     long-running streaming pipelines.
	//   - A byte array representing a packed bitset indicating null fields (a
	//     1 indicating a null) encoded with beam:coder:bytes:v1. The unused
	//     bits in the last byte must be set to 0. If there are no nulls an
	//     empty byte array is encoded.
	//     The two-byte bitset (not including the lenghth-prefix) for the row
	//     [NULL, 0, 0, 0, NULL, 0, 0, NULL, 0, NULL] would be
	//     [0b10010001, 0b00000010]
	//   - An encoding for each non-null field, concatenated together.
	//
	// Schema types are mapped to coders as follows:
	//   AtomicType:
	//     BYTE:      not yet a standard coder (BEAM-7996)
	//     INT16:     not yet a standard coder (BEAM-7996)
	//     INT32:     beam:coder:varint:v1
	//     INT64:     beam:coder:varint:v1
	//     FLOAT:     not yet a standard coder (BEAM-7996)
	//     DOUBLE:    beam:coder:double:v1
	//     STRING:    beam:coder:string_utf8:v1
	//     BOOLEAN:   beam:coder:bool:v1
	//     BYTES:     beam:coder:bytes:v1
	//   ArrayType:   beam:coder:iterable:v1 (always has a known length)
	//   MapType:     not yet a standard coder (BEAM-7996)
	//   RowType:     beam:coder:row:v1
	//   LogicalType: Uses the coder for its representation.
	//
	// The payload for RowCoder is an instance of Schema.
	// Components: None
	// Experimental.
	StandardCoders_ROW StandardCoders_Enum = 13
)

var StandardCoders_Enum_name = map[int32]string{
	0:  "BYTES",
	10: "STRING_UTF8",
	1:  "KV",
	12: "BOOL",
	2:  "VARINT",
	11: "DOUBLE",
	3:  "ITERABLE",
	4:  "TIMER",
	5:  "INTERVAL_WINDOW",
	6:  "LENGTH_PREFIX",
	7:  "GLOBAL_WINDOW",
	8:  "WINDOWED_VALUE",
	14: "PARAM_WINDOWED_VALUE",
	9:  "STATE_BACKED_ITERABLE",
	13: "ROW",
}

var StandardCoders_Enum_value = map[string]int32{
	"BYTES":                 0,
	"STRING_UTF8":           10,
	"KV":                    1,
	"BOOL":                  12,
	"VARINT":                2,
	"DOUBLE":                11,
	"ITERABLE":              3,
	"TIMER":                 4,
	"INTERVAL_WINDOW":       5,
	"LENGTH_PREFIX":         6,
	"GLOBAL_WINDOW":         7,
	"WINDOWED_VALUE":        8,
	"PARAM_WINDOWED_VALUE":  14,
	"STATE_BACKED_ITERABLE": 9,
	"ROW":                   13,
}

func (x StandardCoders_Enum) String() string {
	return proto.EnumName(StandardCoders_Enum_name, int32(x))
}

func (StandardCoders_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{23, 0}
}

type MergeStatus_Enum int32

const (
	MergeStatus_UNSPECIFIED MergeStatus_Enum = 0
	// The WindowFn does not require merging.
	// Examples: global window, FixedWindows, SlidingWindows
	MergeStatus_NON_MERGING MergeStatus_Enum = 1
	// The WindowFn is merging and the PCollection has not had merging
	// performed.
	// Example: Sessions prior to a GroupByKey
	MergeStatus_NEEDS_MERGE MergeStatus_Enum = 2
	// The WindowFn is merging and the PCollection has had merging occur
	// already.
	// Example: Sessions after a GroupByKey
	MergeStatus_ALREADY_MERGED MergeStatus_Enum = 3
)

var MergeStatus_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "NON_MERGING",
	2: "NEEDS_MERGE",
	3: "ALREADY_MERGED",
}

var MergeStatus_Enum_value = map[string]int32{
	"UNSPECIFIED":    0,
	"NON_MERGING":    1,
	"NEEDS_MERGE":    2,
	"ALREADY_MERGED": 3,
}

func (x MergeStatus_Enum) String() string {
	return proto.EnumName(MergeStatus_Enum_name, int32(x))
}

func (MergeStatus_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{25, 0}
}

type AccumulationMode_Enum int32

const (
	AccumulationMode_UNSPECIFIED AccumulationMode_Enum = 0
	// The aggregation is discarded when it is output
	AccumulationMode_DISCARDING AccumulationMode_Enum = 1
	// The aggregation is accumulated across outputs
	AccumulationMode_ACCUMULATING AccumulationMode_Enum = 2
	// The aggregation emits retractions when it is output
	AccumulationMode_RETRACTING AccumulationMode_Enum = 3
)

var AccumulationMode_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "DISCARDING",
	2: "ACCUMULATING",
	3: "RETRACTING",
}

var AccumulationMode_Enum_value = map[string]int32{
	"UNSPECIFIED":  0,
	"DISCARDING":   1,
	"ACCUMULATING": 2,
	"RETRACTING":   3,
}

func (x AccumulationMode_Enum) String() string {
	return proto.EnumName(AccumulationMode_Enum_name, int32(x))
}

func (AccumulationMode_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{26, 0}
}

type ClosingBehavior_Enum int32

const (
	ClosingBehavior_UNSPECIFIED ClosingBehavior_Enum = 0
	// Emit output when a window expires, whether or not there has been
	// any new data since the last output.
	ClosingBehavior_EMIT_ALWAYS ClosingBehavior_Enum = 1
	// Only emit output when new data has arrives since the last output
	ClosingBehavior_EMIT_IF_NONEMPTY ClosingBehavior_Enum = 2
)

var ClosingBehavior_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "EMIT_ALWAYS",
	2: "EMIT_IF_NONEMPTY",
}

var ClosingBehavior_Enum_value = map[string]int32{
	"UNSPECIFIED":      0,
	"EMIT_ALWAYS":      1,
	"EMIT_IF_NONEMPTY": 2,
}

func (x ClosingBehavior_Enum) String() string {
	return proto.EnumName(ClosingBehavior_Enum_name, int32(x))
}

func (ClosingBehavior_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{27, 0}
}

type OnTimeBehavior_Enum int32

const (
	OnTimeBehavior_UNSPECIFIED OnTimeBehavior_Enum = 0
	// Always fire the on-time pane. Even if there is no new data since
	// the previous firing, an element will be produced.
	OnTimeBehavior_FIRE_ALWAYS OnTimeBehavior_Enum = 1
	// Only fire the on-time pane if there is new data since the previous firing.
	OnTimeBehavior_FIRE_IF_NONEMPTY OnTimeBehavior_Enum = 2
)

var OnTimeBehavior_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "FIRE_ALWAYS",
	2: "FIRE_IF_NONEMPTY",
}

var OnTimeBehavior_Enum_value = map[string]int32{
	"UNSPECIFIED":      0,
	"FIRE_ALWAYS":      1,
	"FIRE_IF_NONEMPTY": 2,
}

func (x OnTimeBehavior_Enum) String() string {
	return proto.EnumName(OnTimeBehavior_Enum_name, int32(x))
}

func (OnTimeBehavior_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{28, 0}
}

type OutputTime_Enum int32

const (
	OutputTime_UNSPECIFIED OutputTime_Enum = 0
	// The output has the timestamp of the end of the window.
	OutputTime_END_OF_WINDOW OutputTime_Enum = 1
	// The output has the latest timestamp of the input elements since
	// the last output.
	OutputTime_LATEST_IN_PANE OutputTime_Enum = 2
	// The output has the earliest timestamp of the input elements since
	// the last output.
	OutputTime_EARLIEST_IN_PANE OutputTime_Enum = 3
)

var OutputTime_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "END_OF_WINDOW",
	2: "LATEST_IN_PANE",
	3: "EARLIEST_IN_PANE",
}

var OutputTime_Enum_value = map[string]int32{
	"UNSPECIFIED":      0,
	"END_OF_WINDOW":    1,
	"LATEST_IN_PANE":   2,
	"EARLIEST_IN_PANE": 3,
}

func (x OutputTime_Enum) String() string {
	return proto.EnumName(OutputTime_Enum_name, int32(x))
}

func (OutputTime_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{29, 0}
}

type TimeDomain_Enum int32

const (
	TimeDomain_UNSPECIFIED TimeDomain_Enum = 0
	// Event time is time from the perspective of the data
	TimeDomain_EVENT_TIME TimeDomain_Enum = 1
	// Processing time is time from the perspective of the
	// execution of your pipeline
	TimeDomain_PROCESSING_TIME TimeDomain_Enum = 2
	// Synchronized processing time is the minimum of the
	// processing time of all pending elements.
	//
	// The "processing time" of an element refers to
	// the local processing time at which it was emitted
	TimeDomain_SYNCHRONIZED_PROCESSING_TIME TimeDomain_Enum = 3
)

var TimeDomain_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "EVENT_TIME",
	2: "PROCESSING_TIME",
	3: "SYNCHRONIZED_PROCESSING_TIME",
}

var TimeDomain_Enum_value = map[string]int32{
	"UNSPECIFIED":                  0,
	"EVENT_TIME":                   1,
	"PROCESSING_TIME":              2,
	"SYNCHRONIZED_PROCESSING_TIME": 3,
}

func (x TimeDomain_Enum) String() string {
	return proto.EnumName(TimeDomain_Enum_name, int32(x))
}

func (TimeDomain_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{30, 0}
}

type StandardArtifacts_Types int32

const (
	// A URN for locally-accessible artifact files.
	// payload: ArtifactFilePayload
	StandardArtifacts_FILE StandardArtifacts_Types = 0
	// A URN for artifacts described by URLs.
	// payload: ArtifactUrlPayload
	StandardArtifacts_URL StandardArtifacts_Types = 1
	// A URN for artifacts embedded in ArtifactInformation proto.
	// payload: EmbeddedFilePayload.
	StandardArtifacts_EMBEDDED StandardArtifacts_Types = 2
	// A URN for Python artifacts hosted on PYPI.
	// payload: PypiPayload
	StandardArtifacts_PYPI StandardArtifacts_Types = 3
	// A URN for Java artifacts hosted on a Maven repository.
	// payload: MavenPayload
	StandardArtifacts_MAVEN StandardArtifacts_Types = 4
	// A URN for deferred artifacts.
	// payload: DeferredArtifactPayload
	StandardArtifacts_DEFERRED StandardArtifacts_Types = 5
)

var StandardArtifacts_Types_name = map[int32]string{
	0: "FILE",
	1: "URL",
	2: "EMBEDDED",
	3: "PYPI",
	4: "MAVEN",
	5: "DEFERRED",
}

var StandardArtifacts_Types_value = map[string]int32{
	"FILE":     0,
	"URL":      1,
	"EMBEDDED": 2,
	"PYPI":     3,
	"MAVEN":    4,
	"DEFERRED": 5,
}

func (x StandardArtifacts_Types) String() string {
	return proto.EnumName(StandardArtifacts_Types_name, int32(x))
}

func (StandardArtifacts_Types) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{34, 0}
}

type StandardArtifacts_Roles int32

const (
	// A URN for staging-to role.
	// payload: ArtifactStagingToRolePayload
	StandardArtifacts_STAGING_TO StandardArtifacts_Roles = 0
)

var StandardArtifacts_Roles_name = map[int32]string{
	0: "STAGING_TO",
}

var StandardArtifacts_Roles_value = map[string]int32{
	"STAGING_TO": 0,
}

func (x StandardArtifacts_Roles) String() string {
	return proto.EnumName(StandardArtifacts_Roles_name, int32(x))
}

func (StandardArtifacts_Roles) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{34, 1}
}

type StandardEnvironments_Environments int32

const (
	StandardEnvironments_DOCKER   StandardEnvironments_Environments = 0
	StandardEnvironments_PROCESS  StandardEnvironments_Environments = 1
	StandardEnvironments_EXTERNAL StandardEnvironments_Environments = 2
)

var StandardEnvironments_Environments_name = map[int32]string{
	0: "DOCKER",
	1: "PROCESS",
	2: "EXTERNAL",
}

var StandardEnvironments_Environments_value = map[string]int32{
	"DOCKER":   0,
	"PROCESS":  1,
	"EXTERNAL": 2,
}

func (x StandardEnvironments_Environments) String() string {
	return proto.EnumName(StandardEnvironments_Environments_name, int32(x))
}

func (StandardEnvironments_Environments) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{44, 0}
}

type StandardProtocols_Enum int32

const (
	// Indicates suport for progress reporting via the legacy Metrics proto.
	StandardProtocols_LEGACY_PROGRESS_REPORTING StandardProtocols_Enum = 0
	// Indicates suport for progress reporting via the new MonitoringInfo proto.
	StandardProtocols_PROGRESS_REPORTING StandardProtocols_Enum = 1
	// Indicates suport for worker status protocol defined at
	// https://s.apache.org/beam-fn-api-harness-status.
	StandardProtocols_WORKER_STATUS StandardProtocols_Enum = 2
	// Indicates this SDK can take advantage of multiple cores when processing
	// concurrent process bundle requests. (Note that all SDKs must process
	// an unbounded number of concurrent process bundle requests; this capability
	// simply indicates this SDK can actually parallelize the work across multiple
	// cores.
	StandardProtocols_MULTI_CORE_BUNDLE_PROCESSING StandardProtocols_Enum = 3
)

var StandardProtocols_Enum_name = map[int32]string{
	0: "LEGACY_PROGRESS_REPORTING",
	1: "PROGRESS_REPORTING",
	2: "WORKER_STATUS",
	3: "MULTI_CORE_BUNDLE_PROCESSING",
}

var StandardProtocols_Enum_value = map[string]int32{
	"LEGACY_PROGRESS_REPORTING":    0,
	"PROGRESS_REPORTING":           1,
	"WORKER_STATUS":                2,
	"MULTI_CORE_BUNDLE_PROCESSING": 3,
}

func (x StandardProtocols_Enum) String() string {
	return proto.EnumName(StandardProtocols_Enum_name, int32(x))
}

func (StandardProtocols_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{48, 0}
}

type StandardRequirements_Enum int32

const (
	// This requirement indicates the state_spec and time_spec fields of ParDo
	// transform payloads must be inspected.
	StandardRequirements_REQUIRES_STATEFUL_PROCESSING StandardRequirements_Enum = 0
	// This requirement indicates the requests_finalization field of ParDo
	// transform payloads must be inspected.
	StandardRequirements_REQUIRES_BUNDLE_FINALIZATION StandardRequirements_Enum = 1
	// This requirement indicates the requires_stable_input field of ParDo
	// transform payloads must be inspected.
	StandardRequirements_REQUIRES_STABLE_INPUT StandardRequirements_Enum = 2
	// This requirement indicates the requires_time_sorted_input field of ParDo
	// transform payloads must be inspected.
	StandardRequirements_REQUIRES_TIME_SORTED_INPUT StandardRequirements_Enum = 3
	// This requirement indicates the restriction_coder_id field of ParDo
	// transform payloads must be inspected.
	StandardRequirements_REQUIRES_SPLITTABLE_DOFN StandardRequirements_Enum = 4
)

var StandardRequirements_Enum_name = map[int32]string{
	0: "REQUIRES_STATEFUL_PROCESSING",
	1: "REQUIRES_BUNDLE_FINALIZATION",
	2: "REQUIRES_STABLE_INPUT",
	3: "REQUIRES_TIME_SORTED_INPUT",
	4: "REQUIRES_SPLITTABLE_DOFN",
}

var StandardRequirements_Enum_value = map[string]int32{
	"REQUIRES_STATEFUL_PROCESSING": 0,
	"REQUIRES_BUNDLE_FINALIZATION": 1,
	"REQUIRES_STABLE_INPUT":        2,
	"REQUIRES_TIME_SORTED_INPUT":   3,
	"REQUIRES_SPLITTABLE_DOFN":     4,
}

func (x StandardRequirements_Enum) String() string {
	return proto.EnumName(StandardRequirements_Enum_name, int32(x))
}

func (StandardRequirements_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{49, 0}
}

type StandardDisplayData_DisplayData int32

const (
	// A string label and value. Has a payload containing an encoded
	// LabelledStringPayload.
	StandardDisplayData_LABELLED_STRING StandardDisplayData_DisplayData = 0
)

var StandardDisplayData_DisplayData_name = map[int32]string{
	0: "LABELLED_STRING",
}

var StandardDisplayData_DisplayData_value = map[string]int32{
	"LABELLED_STRING": 0,
}

func (x StandardDisplayData_DisplayData) String() string {
	return proto.EnumName(StandardDisplayData_DisplayData_name, int32(x))
}

func (StandardDisplayData_DisplayData) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{51, 0}
}

type BeamConstants struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BeamConstants) Reset()         { *m = BeamConstants{} }
func (m *BeamConstants) String() string { return proto.CompactTextString(m) }
func (*BeamConstants) ProtoMessage()    {}
func (*BeamConstants) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{0}
}

func (m *BeamConstants) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BeamConstants.Unmarshal(m, b)
}
func (m *BeamConstants) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BeamConstants.Marshal(b, m, deterministic)
}
func (m *BeamConstants) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BeamConstants.Merge(m, src)
}
func (m *BeamConstants) XXX_Size() int {
	return xxx_messageInfo_BeamConstants.Size(m)
}
func (m *BeamConstants) XXX_DiscardUnknown() {
	xxx_messageInfo_BeamConstants.DiscardUnknown(m)
}

var xxx_messageInfo_BeamConstants proto.InternalMessageInfo

// A set of mappings from id to message. This is included as an optional field
// on any proto message that may contain references needing resolution.
type Components struct {
	// (Required) A map from pipeline-scoped id to PTransform.
	Transforms map[string]*PTransform `protobuf:"bytes,1,rep,name=transforms,proto3" json:"transforms,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to PCollection.
	Pcollections map[string]*PCollection `protobuf:"bytes,2,rep,name=pcollections,proto3" json:"pcollections,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to WindowingStrategy.
	WindowingStrategies map[string]*WindowingStrategy `protobuf:"bytes,3,rep,name=windowing_strategies,json=windowingStrategies,proto3" json:"windowing_strategies,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to Coder.
	Coders map[string]*Coder `protobuf:"bytes,4,rep,name=coders,proto3" json:"coders,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to Environment.
	Environments         map[string]*Environment `protobuf:"bytes,5,rep,name=environments,proto3" json:"environments,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *Components) Reset()         { *m = Components{} }
func (m *Components) String() string { return proto.CompactTextString(m) }
func (*Components) ProtoMessage()    {}
func (*Components) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{1}
}

func (m *Components) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Components.Unmarshal(m, b)
}
func (m *Components) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Components.Marshal(b, m, deterministic)
}
func (m *Components) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Components.Merge(m, src)
}
func (m *Components) XXX_Size() int {
	return xxx_messageInfo_Components.Size(m)
}
func (m *Components) XXX_DiscardUnknown() {
	xxx_messageInfo_Components.DiscardUnknown(m)
}

var xxx_messageInfo_Components proto.InternalMessageInfo

func (m *Components) GetTransforms() map[string]*PTransform {
	if m != nil {
		return m.Transforms
	}
	return nil
}

func (m *Components) GetPcollections() map[string]*PCollection {
	if m != nil {
		return m.Pcollections
	}
	return nil
}

func (m *Components) GetWindowingStrategies() map[string]*WindowingStrategy {
	if m != nil {
		return m.WindowingStrategies
	}
	return nil
}

func (m *Components) GetCoders() map[string]*Coder {
	if m != nil {
		return m.Coders
	}
	return nil
}

func (m *Components) GetEnvironments() map[string]*Environment {
	if m != nil {
		return m.Environments
	}
	return nil
}

// A Pipeline is a hierarchical graph of PTransforms, linked
// by PCollections. A typical graph may look like:
//
//   Impulse -> PCollection -> ParDo -> PCollection -> GroupByKey -> ...
//                                   \> PCollection -> ParDo      -> ...
//                                                  \> ParDo      -> ...
//   Impulse -> PCollection -> ParDo -> PCollection -> ...
//
// This is represented by a number of by-reference maps to transforms,
// PCollections, SDK environments, coders, etc., for
// supporting compact reuse and arbitrary graph structure.
type Pipeline struct {
	// (Required) The coders, UDFs, graph nodes, etc, that make up
	// this pipeline.
	Components *Components `protobuf:"bytes,1,opt,name=components,proto3" json:"components,omitempty"`
	// (Required) The ids of all PTransforms that are not contained within another
	// PTransform. These must be in shallow topological order, so that traversing
	// them recursively in this order yields a recursively topological traversal.
	RootTransformIds []string `protobuf:"bytes,2,rep,name=root_transform_ids,json=rootTransformIds,proto3" json:"root_transform_ids,omitempty"`
	// (Optional) Static display data for the pipeline. If there is none,
	// it may be omitted.
	DisplayData []*DisplayData `protobuf:"bytes,3,rep,name=display_data,json=displayData,proto3" json:"display_data,omitempty"`
	// (Optional) A set of requirements that the runner MUST understand and be
	// able to faithfully provide in order to execute this pipeline. These
	// may indicate that a runner must inspect new fields on a component or
	// provide additional guarantees when processing specific transforms.
	// A runner should reject any pipelines with unknown requirements.
	Requirements         []string `protobuf:"bytes,4,rep,name=requirements,proto3" json:"requirements,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Pipeline) Reset()         { *m = Pipeline{} }
func (m *Pipeline) String() string { return proto.CompactTextString(m) }
func (*Pipeline) ProtoMessage()    {}
func (*Pipeline) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{2}
}

func (m *Pipeline) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Pipeline.Unmarshal(m, b)
}
func (m *Pipeline) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Pipeline.Marshal(b, m, deterministic)
}
func (m *Pipeline) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Pipeline.Merge(m, src)
}
func (m *Pipeline) XXX_Size() int {
	return xxx_messageInfo_Pipeline.Size(m)
}
func (m *Pipeline) XXX_DiscardUnknown() {
	xxx_messageInfo_Pipeline.DiscardUnknown(m)
}

var xxx_messageInfo_Pipeline proto.InternalMessageInfo

func (m *Pipeline) GetComponents() *Components {
	if m != nil {
		return m.Components
	}
	return nil
}

func (m *Pipeline) GetRootTransformIds() []string {
	if m != nil {
		return m.RootTransformIds
	}
	return nil
}

func (m *Pipeline) GetDisplayData() []*DisplayData {
	if m != nil {
		return m.DisplayData
	}
	return nil
}

func (m *Pipeline) GetRequirements() []string {
	if m != nil {
		return m.Requirements
	}
	return nil
}

// Transforms are the operations in your pipeline, and provide a generic
// processing framework. You provide processing logic in the form of a function
// object (colloquially referred to as “user code”), and your user code is
// applied to each element of an input PCollection (or more than one
// PCollection). Depending on the pipeline runner and back-end that you choose,
// many different workers across a cluster may execute instances of your user
// code in parallel. The user code running on each worker generates the output
// elements that are ultimately added to the final output PCollection that the
// transform produces.
//
// The Beam SDKs contain a number of different transforms that you can apply to
// your pipeline’s PCollections. These include general-purpose core transforms,
// such as ParDo or Combine. There are also pre-written composite transforms
// included in the SDKs, which combine one or more of the core transforms in a
// useful processing pattern, such as counting or combining elements in a
// collection. You can also define your own more complex composite transforms to
// fit your pipeline’s exact use case.
type PTransform struct {
	// (Required) A unique name for the application node.
	//
	// Ideally, this should be stable over multiple evolutions of a pipeline
	// for the purposes of logging and associating pipeline state with a node,
	// etc.
	//
	// If it is not stable, then the runner decides what will happen. But, most
	// importantly, it must always be here and be unique, even if it is
	// autogenerated.
	UniqueName string `protobuf:"bytes,5,opt,name=unique_name,json=uniqueName,proto3" json:"unique_name,omitempty"`
	// (Optional) A URN and payload that, together, fully defined the semantics
	// of this transform.
	//
	// If absent, this must be an "anonymous" composite transform.
	//
	// For primitive transform in the Runner API, this is required, and the
	// payloads are well-defined messages. When the URN indicates ParDo it
	// is a ParDoPayload, and so on. For some special composite transforms,
	// the payload is also officially defined. See StandardPTransforms for
	// details.
	Spec *FunctionSpec `protobuf:"bytes,1,opt,name=spec,proto3" json:"spec,omitempty"`
	// (Optional) A list of the ids of transforms that it contains.
	//
	// Primitive transforms are not allowed to specify this.
	Subtransforms []string `protobuf:"bytes,2,rep,name=subtransforms,proto3" json:"subtransforms,omitempty"`
	// (Required) A map from local names of inputs (unique only with this map, and
	// likely embedded in the transform payload and serialized user code) to
	// PCollection ids.
	//
	// The payload for this transform may clarify the relationship of these
	// inputs. For example:
	//
	//  - for a Flatten transform they are merged
	//  - for a ParDo transform, some may be side inputs
	//
	// All inputs are recorded here so that the topological ordering of
	// the graph is consistent whether or not the payload is understood.
	Inputs map[string]string `protobuf:"bytes,3,rep,name=inputs,proto3" json:"inputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from local names of outputs (unique only within this map,
	// and likely embedded in the transform payload and serialized user code)
	// to PCollection ids.
	//
	// The URN or payload for this transform node may clarify the type and
	// relationship of these outputs. For example:
	//
	//  - for a ParDo transform, these are tags on PCollections, which will be
	//    embedded in the DoFn.
	Outputs map[string]string `protobuf:"bytes,4,rep,name=outputs,proto3" json:"outputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Optional) Static display data for this PTransform application. If
	// there is none, it may be omitted.
	DisplayData []*DisplayData `protobuf:"bytes,6,rep,name=display_data,json=displayData,proto3" json:"display_data,omitempty"`
	// Environment where the current PTransform should be executed in.
	//
	// Transforms that are required to be implemented by a runner must omit this.
	// All other transforms are required to specify this.
	EnvironmentId        string   `protobuf:"bytes,7,opt,name=environment_id,json=environmentId,proto3" json:"environment_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PTransform) Reset()         { *m = PTransform{} }
func (m *PTransform) String() string { return proto.CompactTextString(m) }
func (*PTransform) ProtoMessage()    {}
func (*PTransform) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{3}
}

func (m *PTransform) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PTransform.Unmarshal(m, b)
}
func (m *PTransform) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PTransform.Marshal(b, m, deterministic)
}
func (m *PTransform) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PTransform.Merge(m, src)
}
func (m *PTransform) XXX_Size() int {
	return xxx_messageInfo_PTransform.Size(m)
}
func (m *PTransform) XXX_DiscardUnknown() {
	xxx_messageInfo_PTransform.DiscardUnknown(m)
}

var xxx_messageInfo_PTransform proto.InternalMessageInfo

func (m *PTransform) GetUniqueName() string {
	if m != nil {
		return m.UniqueName
	}
	return ""
}

func (m *PTransform) GetSpec() *FunctionSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *PTransform) GetSubtransforms() []string {
	if m != nil {
		return m.Subtransforms
	}
	return nil
}

func (m *PTransform) GetInputs() map[string]string {
	if m != nil {
		return m.Inputs
	}
	return nil
}

func (m *PTransform) GetOutputs() map[string]string {
	if m != nil {
		return m.Outputs
	}
	return nil
}

func (m *PTransform) GetDisplayData() []*DisplayData {
	if m != nil {
		return m.DisplayData
	}
	return nil
}

func (m *PTransform) GetEnvironmentId() string {
	if m != nil {
		return m.EnvironmentId
	}
	return ""
}

type StandardPTransforms struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StandardPTransforms) Reset()         { *m = StandardPTransforms{} }
func (m *StandardPTransforms) String() string { return proto.CompactTextString(m) }
func (*StandardPTransforms) ProtoMessage()    {}
func (*StandardPTransforms) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{4}
}

func (m *StandardPTransforms) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StandardPTransforms.Unmarshal(m, b)
}
func (m *StandardPTransforms) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StandardPTransforms.Marshal(b, m, deterministic)
}
func (m *StandardPTransforms) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StandardPTransforms.Merge(m, src)
}
func (m *StandardPTransforms) XXX_Size() int {
	return xxx_messageInfo_StandardPTransforms.Size(m)
}
func (m *StandardPTransforms) XXX_DiscardUnknown() {
	xxx_messageInfo_StandardPTransforms.DiscardUnknown(m)
}

var xxx_messageInfo_StandardPTransforms proto.InternalMessageInfo

type StandardSideInputTypes struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StandardSideInputTypes) Reset()         { *m = StandardSideInputTypes{} }
func (m *StandardSideInputTypes) String() string { return proto.CompactTextString(m) }
func (*StandardSideInputTypes) ProtoMessage()    {}
func (*StandardSideInputTypes) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{5}
}

func (m *StandardSideInputTypes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StandardSideInputTypes.Unmarshal(m, b)
}
func (m *StandardSideInputTypes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StandardSideInputTypes.Marshal(b, m, deterministic)
}
func (m *StandardSideInputTypes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StandardSideInputTypes.Merge(m, src)
}
func (m *StandardSideInputTypes) XXX_Size() int {
	return xxx_messageInfo_StandardSideInputTypes.Size(m)
}
func (m *StandardSideInputTypes) XXX_DiscardUnknown() {
	xxx_messageInfo_StandardSideInputTypes.DiscardUnknown(m)
}

var xxx_messageInfo_StandardSideInputTypes proto.InternalMessageInfo

// A PCollection!
type PCollection struct {
	// (Required) A unique name for the PCollection.
	//
	// Ideally, this should be stable over multiple evolutions of a pipeline
	// for the purposes of logging and associating pipeline state with a node,
	// etc.
	//
	// If it is not stable, then the runner decides what will happen. But, most
	// importantly, it must always be here, even if it is autogenerated.
	UniqueName string `protobuf:"bytes,1,opt,name=unique_name,json=uniqueName,proto3" json:"unique_name,omitempty"`
	// (Required) The id of the Coder for this PCollection.
	CoderId string `protobuf:"bytes,2,opt,name=coder_id,json=coderId,proto3" json:"coder_id,omitempty"`
	// (Required) Whether this PCollection is bounded or unbounded
	IsBounded IsBounded_Enum `protobuf:"varint,3,opt,name=is_bounded,json=isBounded,proto3,enum=org.apache.beam.model.pipeline.v1.IsBounded_Enum" json:"is_bounded,omitempty"`
	// (Required) The id of the windowing strategy for this PCollection.
	WindowingStrategyId string `protobuf:"bytes,4,opt,name=windowing_strategy_id,json=windowingStrategyId,proto3" json:"windowing_strategy_id,omitempty"`
	// (Optional) Static display data for the PCollection. If there is none,
	// it may be omitted.
	DisplayData          []*DisplayData `protobuf:"bytes,5,rep,name=display_data,json=displayData,proto3" json:"display_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *PCollection) Reset()         { *m = PCollection{} }
func (m *PCollection) String() string { return proto.CompactTextString(m) }
func (*PCollection) ProtoMessage()    {}
func (*PCollection) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{6}
}

func (m *PCollection) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PCollection.Unmarshal(m, b)
}
func (m *PCollection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PCollection.Marshal(b, m, deterministic)
}
func (m *PCollection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PCollection.Merge(m, src)
}
func (m *PCollection) XXX_Size() int {
	return xxx_messageInfo_PCollection.Size(m)
}
func (m *PCollection) XXX_DiscardUnknown() {
	xxx_messageInfo_PCollection.DiscardUnknown(m)
}

var xxx_messageInfo_PCollection proto.InternalMessageInfo

func (m *PCollection) GetUniqueName() string {
	if m != nil {
		return m.UniqueName
	}
	return ""
}

func (m *PCollection) GetCoderId() string {
	if m != nil {
		return m.CoderId
	}
	return ""
}

func (m *PCollection) GetIsBounded() IsBounded_Enum {
	if m != nil {
		return m.IsBounded
	}
	return IsBounded_UNSPECIFIED
}

func (m *PCollection) GetWindowingStrategyId() string {
	if m != nil {
		return m.WindowingStrategyId
	}
	return ""
}

func (m *PCollection) GetDisplayData() []*DisplayData {
	if m != nil {
		return m.DisplayData
	}
	return nil
}

// The payload for the primitive ParDo transform.
type ParDoPayload struct {
	// (Required) The FunctionSpec of the DoFn.
	DoFn *FunctionSpec `protobuf:"bytes,1,opt,name=do_fn,json=doFn,proto3" json:"do_fn,omitempty"`
	// (Optional) A mapping of local input names to side inputs, describing
	// the expected access pattern.
	SideInputs map[string]*SideInput `protobuf:"bytes,3,rep,name=side_inputs,json=sideInputs,proto3" json:"side_inputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Optional) A mapping of local state names to state specifications.
	// If this is set, the stateful processing requirement should also
	// be placed in the pipeline requirements.
	StateSpecs map[string]*StateSpec `protobuf:"bytes,4,rep,name=state_specs,json=stateSpecs,proto3" json:"state_specs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Optional) A mapping of local timer family names to timer family
	// specifications. If this is set, the stateful processing requirement should
	// also be placed in the pipeline requirements.
	TimerFamilySpecs map[string]*TimerFamilySpec `protobuf:"bytes,9,rep,name=timer_family_specs,json=timerFamilySpecs,proto3" json:"timer_family_specs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Optional) Only set when this ParDo contains a splittable DoFn.
	// If this is set, the corresponding standard requirement should also
	// be placed in the pipeline requirements.
	RestrictionCoderId string `protobuf:"bytes,7,opt,name=restriction_coder_id,json=restrictionCoderId,proto3" json:"restriction_coder_id,omitempty"`
	// (Optional) Only set when this ParDo can request bundle finalization.
	// If this is set, the corresponding standard requirement should also
	// be placed in the pipeline requirements.
	RequestsFinalization bool `protobuf:"varint,8,opt,name=requests_finalization,json=requestsFinalization,proto3" json:"requests_finalization,omitempty"`
	// Whether this stage requires time sorted input.
	// If this is set, the corresponding standard requirement should also
	// be placed in the pipeline requirements.
	RequiresTimeSortedInput bool `protobuf:"varint,10,opt,name=requires_time_sorted_input,json=requiresTimeSortedInput,proto3" json:"requires_time_sorted_input,omitempty"`
	// Whether this stage requires stable input.
	// If this is set, the corresponding standard requirement should also
	// be placed in the pipeline requirements.
	RequiresStableInput  bool     `protobuf:"varint,11,opt,name=requires_stable_input,json=requiresStableInput,proto3" json:"requires_stable_input,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ParDoPayload) Reset()         { *m = ParDoPayload{} }
func (m *ParDoPayload) String() string { return proto.CompactTextString(m) }
func (*ParDoPayload) ProtoMessage()    {}
func (*ParDoPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{7}
}

func (m *ParDoPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ParDoPayload.Unmarshal(m, b)
}
func (m *ParDoPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ParDoPayload.Marshal(b, m, deterministic)
}
func (m *ParDoPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ParDoPayload.Merge(m, src)
}
func (m *ParDoPayload) XXX_Size() int {
	return xxx_messageInfo_ParDoPayload.Size(m)
}
func (m *ParDoPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_ParDoPayload.DiscardUnknown(m)
}

var xxx_messageInfo_ParDoPayload proto.InternalMessageInfo

func (m *ParDoPayload) GetDoFn() *FunctionSpec {
	if m != nil {
		return m.DoFn
	}
	return nil
}

func (m *ParDoPayload) GetSideInputs() map[string]*SideInput {
	if m != nil {
		return m.SideInputs
	}
	return nil
}

func (m *ParDoPayload) GetStateSpecs() map[string]*StateSpec {
	if m != nil {
		return m.StateSpecs
	}
	return nil
}

func (m *ParDoPayload) GetTimerFamilySpecs() map[string]*TimerFamilySpec {
	if m != nil {
		return m.TimerFamilySpecs
	}
	return nil
}

func (m *ParDoPayload) GetRestrictionCoderId() string {
	if m != nil {
		return m.RestrictionCoderId
	}
	return ""
}

func (m *ParDoPayload) GetRequestsFinalization() bool {
	if m != nil {
		return m.RequestsFinalization
	}
	return false
}

func (m *ParDoPayload) GetRequiresTimeSortedInput() bool {
	if m != nil {
		return m.RequiresTimeSortedInput
	}
	return false
}

func (m *ParDoPayload) GetRequiresStableInput() bool {
	if m != nil {
		return m.RequiresStableInput
	}
	return false
}

type StateSpec struct {
	// Types that are valid to be assigned to Spec:
	//	*StateSpec_ReadModifyWriteSpec
	//	*StateSpec_BagSpec
	//	*StateSpec_CombiningSpec
	//	*StateSpec_MapSpec
	//	*StateSpec_SetSpec
	Spec                 isStateSpec_Spec `protobuf_oneof:"spec"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *StateSpec) Reset()         { *m = StateSpec{} }
func (m *StateSpec) String() string { return proto.CompactTextString(m) }
func (*StateSpec) ProtoMessage()    {}
func (*StateSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{8}
}

func (m *StateSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateSpec.Unmarshal(m, b)
}
func (m *StateSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateSpec.Marshal(b, m, deterministic)
}
func (m *StateSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateSpec.Merge(m, src)
}
func (m *StateSpec) XXX_Size() int {
	return xxx_messageInfo_StateSpec.Size(m)
}
func (m *StateSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_StateSpec.DiscardUnknown(m)
}

var xxx_messageInfo_StateSpec proto.InternalMessageInfo

type isStateSpec_Spec interface {
	isStateSpec_Spec()
}

type StateSpec_ReadModifyWriteSpec struct {
	ReadModifyWriteSpec *ReadModifyWriteStateSpec `protobuf:"bytes,1,opt,name=read_modify_write_spec,json=readModifyWriteSpec,proto3,oneof"`
}

type StateSpec_BagSpec struct {
	BagSpec *BagStateSpec `protobuf:"bytes,2,opt,name=bag_spec,json=bagSpec,proto3,oneof"`
}

type StateSpec_CombiningSpec struct {
	CombiningSpec *CombiningStateSpec `protobuf:"bytes,3,opt,name=combining_spec,json=combiningSpec,proto3,oneof"`
}

type StateSpec_MapSpec struct {
	MapSpec *MapStateSpec `protobuf:"bytes,4,opt,name=map_spec,json=mapSpec,proto3,oneof"`
}

type StateSpec_SetSpec struct {
	SetSpec *SetStateSpec `protobuf:"bytes,5,opt,name=set_spec,json=setSpec,proto3,oneof"`
}

func (*StateSpec_ReadModifyWriteSpec) isStateSpec_Spec() {}

func (*StateSpec_BagSpec) isStateSpec_Spec() {}

func (*StateSpec_CombiningSpec) isStateSpec_Spec() {}

func (*StateSpec_MapSpec) isStateSpec_Spec() {}

func (*StateSpec_SetSpec) isStateSpec_Spec() {}

func (m *StateSpec) GetSpec() isStateSpec_Spec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *StateSpec) GetReadModifyWriteSpec() *ReadModifyWriteStateSpec {
	if x, ok := m.GetSpec().(*StateSpec_ReadModifyWriteSpec); ok {
		return x.ReadModifyWriteSpec
	}
	return nil
}

func (m *StateSpec) GetBagSpec() *BagStateSpec {
	if x, ok := m.GetSpec().(*StateSpec_BagSpec); ok {
		return x.BagSpec
	}
	return nil
}

func (m *StateSpec) GetCombiningSpec() *CombiningStateSpec {
	if x, ok := m.GetSpec().(*StateSpec_CombiningSpec); ok {
		return x.CombiningSpec
	}
	return nil
}

func (m *StateSpec) GetMapSpec() *MapStateSpec {
	if x, ok := m.GetSpec().(*StateSpec_MapSpec); ok {
		return x.MapSpec
	}
	return nil
}

func (m *StateSpec) GetSetSpec() *SetStateSpec {
	if x, ok := m.GetSpec().(*StateSpec_SetSpec); ok {
		return x.SetSpec
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StateSpec) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StateSpec_ReadModifyWriteSpec)(nil),
		(*StateSpec_BagSpec)(nil),
		(*StateSpec_CombiningSpec)(nil),
		(*StateSpec_MapSpec)(nil),
		(*StateSpec_SetSpec)(nil),
	}
}

type ReadModifyWriteStateSpec struct {
	CoderId              string   `protobuf:"bytes,1,opt,name=coder_id,json=coderId,proto3" json:"coder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReadModifyWriteStateSpec) Reset()         { *m = ReadModifyWriteStateSpec{} }
func (m *ReadModifyWriteStateSpec) String() string { return proto.CompactTextString(m) }
func (*ReadModifyWriteStateSpec) ProtoMessage()    {}
func (*ReadModifyWriteStateSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{9}
}

func (m *ReadModifyWriteStateSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadModifyWriteStateSpec.Unmarshal(m, b)
}
func (m *ReadModifyWriteStateSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadModifyWriteStateSpec.Marshal(b, m, deterministic)
}
func (m *ReadModifyWriteStateSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadModifyWriteStateSpec.Merge(m, src)
}
func (m *ReadModifyWriteStateSpec) XXX_Size() int {
	return xxx_messageInfo_ReadModifyWriteStateSpec.Size(m)
}
func (m *ReadModifyWriteStateSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadModifyWriteStateSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ReadModifyWriteStateSpec proto.InternalMessageInfo

func (m *ReadModifyWriteStateSpec) GetCoderId() string {
	if m != nil {
		return m.CoderId
	}
	return ""
}

type BagStateSpec struct {
	ElementCoderId       string   `protobuf:"bytes,1,opt,name=element_coder_id,json=elementCoderId,proto3" json:"element_coder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BagStateSpec) Reset()         { *m = BagStateSpec{} }
func (m *BagStateSpec) String() string { return proto.CompactTextString(m) }
func (*BagStateSpec) ProtoMessage()    {}
func (*BagStateSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{10}
}

func (m *BagStateSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BagStateSpec.Unmarshal(m, b)
}
func (m *BagStateSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BagStateSpec.Marshal(b, m, deterministic)
}
func (m *BagStateSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BagStateSpec.Merge(m, src)
}
func (m *BagStateSpec) XXX_Size() int {
	return xxx_messageInfo_BagStateSpec.Size(m)
}
func (m *BagStateSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_BagStateSpec.DiscardUnknown(m)
}

var xxx_messageInfo_BagStateSpec proto.InternalMessageInfo

func (m *BagStateSpec) GetElementCoderId() string {
	if m != nil {
		return m.ElementCoderId
	}
	return ""
}

type CombiningStateSpec struct {
	AccumulatorCoderId   string        `protobuf:"bytes,1,opt,name=accumulator_coder_id,json=accumulatorCoderId,proto3" json:"accumulator_coder_id,omitempty"`
	CombineFn            *FunctionSpec `protobuf:"bytes,2,opt,name=combine_fn,json=combineFn,proto3" json:"combine_fn,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CombiningStateSpec) Reset()         { *m = CombiningStateSpec{} }
func (m *CombiningStateSpec) String() string { return proto.CompactTextString(m) }
func (*CombiningStateSpec) ProtoMessage()    {}
func (*CombiningStateSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{11}
}

func (m *CombiningStateSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CombiningStateSpec.Unmarshal(m, b)
}
func (m *CombiningStateSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CombiningStateSpec.Marshal(b, m, deterministic)
}
func (m *CombiningStateSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CombiningStateSpec.Merge(m, src)
}
func (m *CombiningStateSpec) XXX_Size() int {
	return xxx_messageInfo_CombiningStateSpec.Size(m)
}
func (m *CombiningStateSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_CombiningStateSpec.DiscardUnknown(m)
}

var xxx_messageInfo_CombiningStateSpec proto.InternalMessageInfo

func (m *CombiningStateSpec) GetAccumulatorCoderId() string {
	if m != nil {
		return m.AccumulatorCoderId
	}
	return ""
}

func (m *CombiningStateSpec) GetCombineFn() *FunctionSpec {
	if m != nil {
		return m.CombineFn
	}
	return nil
}

type MapStateSpec struct {
	KeyCoderId           string   `protobuf:"bytes,1,opt,name=key_coder_id,json=keyCoderId,proto3" json:"key_coder_id,omitempty"`
	ValueCoderId         string   `protobuf:"bytes,2,opt,name=value_coder_id,json=valueCoderId,proto3" json:"value_coder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MapStateSpec) Reset()         { *m = MapStateSpec{} }
func (m *MapStateSpec) String() string { return proto.CompactTextString(m) }
func (*MapStateSpec) ProtoMessage()    {}
func (*MapStateSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{12}
}

func (m *MapStateSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MapStateSpec.Unmarshal(m, b)
}
func (m *MapStateSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MapStateSpec.Marshal(b, m, deterministic)
}
func (m *MapStateSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MapStateSpec.Merge(m, src)
}
func (m *MapStateSpec) XXX_Size() int {
	return xxx_messageInfo_MapStateSpec.Size(m)
}
func (m *MapStateSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_MapStateSpec.DiscardUnknown(m)
}

var xxx_messageInfo_MapStateSpec proto.InternalMessageInfo

func (m *MapStateSpec) GetKeyCoderId() string {
	if m != nil {
		return m.KeyCoderId
	}
	return ""
}

func (m *MapStateSpec) GetValueCoderId() string {
	if m != nil {
		return m.ValueCoderId
	}
	return ""
}

type SetStateSpec struct {
	ElementCoderId       string   `protobuf:"bytes,1,opt,name=element_coder_id,json=elementCoderId,proto3" json:"element_coder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetStateSpec) Reset()         { *m = SetStateSpec{} }
func (m *SetStateSpec) String() string { return proto.CompactTextString(m) }
func (*SetStateSpec) ProtoMessage()    {}
func (*SetStateSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{13}
}

func (m *SetStateSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetStateSpec.Unmarshal(m, b)
}
func (m *SetStateSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetStateSpec.Marshal(b, m, deterministic)
}
func (m *SetStateSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetStateSpec.Merge(m, src)
}
func (m *SetStateSpec) XXX_Size() int {
	return xxx_messageInfo_SetStateSpec.Size(m)
}
func (m *SetStateSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_SetStateSpec.DiscardUnknown(m)
}

var xxx_messageInfo_SetStateSpec proto.InternalMessageInfo

func (m *SetStateSpec) GetElementCoderId() string {
	if m != nil {
		return m.ElementCoderId
	}
	return ""
}

type TimerFamilySpec struct {
	TimeDomain           TimeDomain_Enum `protobuf:"varint,1,opt,name=time_domain,json=timeDomain,proto3,enum=org.apache.beam.model.pipeline.v1.TimeDomain_Enum" json:"time_domain,omitempty"`
	TimerFamilyCoderId   string          `protobuf:"bytes,2,opt,name=timer_family_coder_id,json=timerFamilyCoderId,proto3" json:"timer_family_coder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *TimerFamilySpec) Reset()         { *m = TimerFamilySpec{} }
func (m *TimerFamilySpec) String() string { return proto.CompactTextString(m) }
func (*TimerFamilySpec) ProtoMessage()    {}
func (*TimerFamilySpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{14}
}

func (m *TimerFamilySpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimerFamilySpec.Unmarshal(m, b)
}
func (m *TimerFamilySpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimerFamilySpec.Marshal(b, m, deterministic)
}
func (m *TimerFamilySpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimerFamilySpec.Merge(m, src)
}
func (m *TimerFamilySpec) XXX_Size() int {
	return xxx_messageInfo_TimerFamilySpec.Size(m)
}
func (m *TimerFamilySpec) XXX_DiscardUnknown() {
	xxx_messageInfo_TimerFamilySpec.DiscardUnknown(m)
}

var xxx_messageInfo_TimerFamilySpec proto.InternalMessageInfo

func (m *TimerFamilySpec) GetTimeDomain() TimeDomain_Enum {
	if m != nil {
		return m.TimeDomain
	}
	return TimeDomain_UNSPECIFIED
}

func (m *TimerFamilySpec) GetTimerFamilyCoderId() string {
	if m != nil {
		return m.TimerFamilyCoderId
	}
	return ""
}

type IsBounded struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IsBounded) Reset()         { *m = IsBounded{} }
func (m *IsBounded) String() string { return proto.CompactTextString(m) }
func (*IsBounded) ProtoMessage()    {}
func (*IsBounded) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{15}
}

func (m *IsBounded) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IsBounded.Unmarshal(m, b)
}
func (m *IsBounded) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IsBounded.Marshal(b, m, deterministic)
}
func (m *IsBounded) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IsBounded.Merge(m, src)
}
func (m *IsBounded) XXX_Size() int {
	return xxx_messageInfo_IsBounded.Size(m)
}
func (m *IsBounded) XXX_DiscardUnknown() {
	xxx_messageInfo_IsBounded.DiscardUnknown(m)
}

var xxx_messageInfo_IsBounded proto.InternalMessageInfo

// The payload for the primitive Read transform.
type ReadPayload struct {
	// (Required) The FunctionSpec of the source for this Read.
	Source *FunctionSpec `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// (Required) Whether the source is bounded or unbounded
	IsBounded            IsBounded_Enum `protobuf:"varint,2,opt,name=is_bounded,json=isBounded,proto3,enum=org.apache.beam.model.pipeline.v1.IsBounded_Enum" json:"is_bounded,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ReadPayload) Reset()         { *m = ReadPayload{} }
func (m *ReadPayload) String() string { return proto.CompactTextString(m) }
func (*ReadPayload) ProtoMessage()    {}
func (*ReadPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{16}
}

func (m *ReadPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadPayload.Unmarshal(m, b)
}
func (m *ReadPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadPayload.Marshal(b, m, deterministic)
}
func (m *ReadPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadPayload.Merge(m, src)
}
func (m *ReadPayload) XXX_Size() int {
	return xxx_messageInfo_ReadPayload.Size(m)
}
func (m *ReadPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadPayload.DiscardUnknown(m)
}

var xxx_messageInfo_ReadPayload proto.InternalMessageInfo

func (m *ReadPayload) GetSource() *FunctionSpec {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *ReadPayload) GetIsBounded() IsBounded_Enum {
	if m != nil {
		return m.IsBounded
	}
	return IsBounded_UNSPECIFIED
}

// The payload for the WindowInto transform.
type WindowIntoPayload struct {
	// (Required) The FunctionSpec of the WindowFn.
	WindowFn             *FunctionSpec `protobuf:"bytes,1,opt,name=window_fn,json=windowFn,proto3" json:"window_fn,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *WindowIntoPayload) Reset()         { *m = WindowIntoPayload{} }
func (m *WindowIntoPayload) String() string { return proto.CompactTextString(m) }
func (*WindowIntoPayload) ProtoMessage()    {}
func (*WindowIntoPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{17}
}

func (m *WindowIntoPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WindowIntoPayload.Unmarshal(m, b)
}
func (m *WindowIntoPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WindowIntoPayload.Marshal(b, m, deterministic)
}
func (m *WindowIntoPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowIntoPayload.Merge(m, src)
}
func (m *WindowIntoPayload) XXX_Size() int {
	return xxx_messageInfo_WindowIntoPayload.Size(m)
}
func (m *WindowIntoPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowIntoPayload.DiscardUnknown(m)
}

var xxx_messageInfo_WindowIntoPayload proto.InternalMessageInfo

func (m *WindowIntoPayload) GetWindowFn() *FunctionSpec {
	if m != nil {
		return m.WindowFn
	}
	return nil
}

// The payload for the special-but-not-primitive Combine transform.
type CombinePayload struct {
	// (Required) The FunctionSpec of the CombineFn.
	CombineFn *FunctionSpec `protobuf:"bytes,1,opt,name=combine_fn,json=combineFn,proto3" json:"combine_fn,omitempty"`
	// (Required) A reference to the Coder to use for accumulators of the CombineFn
	AccumulatorCoderId   string   `protobuf:"bytes,2,opt,name=accumulator_coder_id,json=accumulatorCoderId,proto3" json:"accumulator_coder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CombinePayload) Reset()         { *m = CombinePayload{} }
func (m *CombinePayload) String() string { return proto.CompactTextString(m) }
func (*CombinePayload) ProtoMessage()    {}
func (*CombinePayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{18}
}

func (m *CombinePayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CombinePayload.Unmarshal(m, b)
}
func (m *CombinePayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CombinePayload.Marshal(b, m, deterministic)
}
func (m *CombinePayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CombinePayload.Merge(m, src)
}
func (m *CombinePayload) XXX_Size() int {
	return xxx_messageInfo_CombinePayload.Size(m)
}
func (m *CombinePayload) XXX_DiscardUnknown() {
	xxx_messageInfo_CombinePayload.DiscardUnknown(m)
}

var xxx_messageInfo_CombinePayload proto.InternalMessageInfo

func (m *CombinePayload) GetCombineFn() *FunctionSpec {
	if m != nil {
		return m.CombineFn
	}
	return nil
}

func (m *CombinePayload) GetAccumulatorCoderId() string {
	if m != nil {
		return m.AccumulatorCoderId
	}
	return ""
}

// The payload for the test-only primitive TestStream
type TestStreamPayload struct {
	// (Required) the coder for elements in the TestStream events
	CoderId string `protobuf:"bytes,1,opt,name=coder_id,json=coderId,proto3" json:"coder_id,omitempty"`
	// (Optional) If specified, the TestStream will replay these events.
	Events []*TestStreamPayload_Event `protobuf:"bytes,2,rep,name=events,proto3" json:"events,omitempty"`
	// (Optional) If specified, points to a TestStreamService to be
	// used to retrieve events.
	Endpoint             *ApiServiceDescriptor `protobuf:"bytes,3,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *TestStreamPayload) Reset()         { *m = TestStreamPayload{} }
func (m *TestStreamPayload) String() string { return proto.CompactTextString(m) }
func (*TestStreamPayload) ProtoMessage()    {}
func (*TestStreamPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{19}
}

func (m *TestStreamPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestStreamPayload.Unmarshal(m, b)
}
func (m *TestStreamPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestStreamPayload.Marshal(b, m, deterministic)
}
func (m *TestStreamPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestStreamPayload.Merge(m, src)
}
func (m *TestStreamPayload) XXX_Size() int {
	return xxx_messageInfo_TestStreamPayload.Size(m)
}
func (m *TestStreamPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_TestStreamPayload.DiscardUnknown(m)
}

var xxx_messageInfo_TestStreamPayload proto.InternalMessageInfo

func (m *TestStreamPayload) GetCoderId() string {
	if m != nil {
		return m.CoderId
	}
	return ""
}

func (m *TestStreamPayload) GetEvents() []*TestStreamPayload_Event {
	if m != nil {
		return m.Events
	}
	return nil
}

func (m *TestStreamPayload) GetEndpoint() *ApiServiceDescriptor {
	if m != nil {
		return m.Endpoint
	}
	return nil
}

type TestStreamPayload_Event struct {
	// Types that are valid to be assigned to Event:
	//	*TestStreamPayload_Event_WatermarkEvent
	//	*TestStreamPayload_Event_ProcessingTimeEvent
	//	*TestStreamPayload_Event_ElementEvent
	Event                isTestStreamPayload_Event_Event `protobuf_oneof:"event"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *TestStreamPayload_Event) Reset()         { *m = TestStreamPayload_Event{} }
func (m *TestStreamPayload_Event) String() string { return proto.CompactTextString(m) }
func (*TestStreamPayload_Event) ProtoMessage()    {}
func (*TestStreamPayload_Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{19, 0}
}

func (m *TestStreamPayload_Event) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestStreamPayload_Event.Unmarshal(m, b)
}
func (m *TestStreamPayload_Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestStreamPayload_Event.Marshal(b, m, deterministic)
}
func (m *TestStreamPayload_Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestStreamPayload_Event.Merge(m, src)
}
func (m *TestStreamPayload_Event) XXX_Size() int {
	return xxx_messageInfo_TestStreamPayload_Event.Size(m)
}
func (m *TestStreamPayload_Event) XXX_DiscardUnknown() {
	xxx_messageInfo_TestStreamPayload_Event.DiscardUnknown(m)
}

var xxx_messageInfo_TestStreamPayload_Event proto.InternalMessageInfo

type isTestStreamPayload_Event_Event interface {
	isTestStreamPayload_Event_Event()
}

type TestStreamPayload_Event_WatermarkEvent struct {
	WatermarkEvent *TestStreamPayload_Event_AdvanceWatermark `protobuf:"bytes,1,opt,name=watermark_event,json=watermarkEvent,proto3,oneof"`
}

type TestStreamPayload_Event_ProcessingTimeEvent struct {
	ProcessingTimeEvent *TestStreamPayload_Event_AdvanceProcessingTime `protobuf:"bytes,2,opt,name=processing_time_event,json=processingTimeEvent,proto3,oneof"`
}

type TestStreamPayload_Event_ElementEvent struct {
	ElementEvent *TestStreamPayload_Event_AddElements `protobuf:"bytes,3,opt,name=element_event,json=elementEvent,proto3,oneof"`
}

func (*TestStreamPayload_Event_WatermarkEvent) isTestStreamPayload_Event_Event() {}

func (*TestStreamPayload_Event_ProcessingTimeEvent) isTestStreamPayload_Event_Event() {}

func (*TestStreamPayload_Event_ElementEvent) isTestStreamPayload_Event_Event() {}

func (m *TestStreamPayload_Event) GetEvent() isTestStreamPayload_Event_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *TestStreamPayload_Event) GetWatermarkEvent() *TestStreamPayload_Event_AdvanceWatermark {
	if x, ok := m.GetEvent().(*TestStreamPayload_Event_WatermarkEvent); ok {
		return x.WatermarkEvent
	}
	return nil
}

func (m *TestStreamPayload_Event) GetProcessingTimeEvent() *TestStreamPayload_Event_AdvanceProcessingTime {
	if x, ok := m.GetEvent().(*TestStreamPayload_Event_ProcessingTimeEvent); ok {
		return x.ProcessingTimeEvent
	}
	return nil
}

func (m *TestStreamPayload_Event) GetElementEvent() *TestStreamPayload_Event_AddElements {
	if x, ok := m.GetEvent().(*TestStreamPayload_Event_ElementEvent); ok {
		return x.ElementEvent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*TestStreamPayload_Event) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*TestStreamPayload_Event_WatermarkEvent)(nil),
		(*TestStreamPayload_Event_ProcessingTimeEvent)(nil),
		(*TestStreamPayload_Event_ElementEvent)(nil),
	}
}

// Advances the watermark to the specified timestamp.
type TestStreamPayload_Event_AdvanceWatermark struct {
	// (Required) The watermark to advance to.
	NewWatermark int64 `protobuf:"varint,1,opt,name=new_watermark,json=newWatermark,proto3" json:"new_watermark,omitempty"`
	// (Optional) The output watermark tag for a PCollection. If unspecified
	// or with an empty string, this will default to the Main PCollection
	// Output
	Tag                  string   `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestStreamPayload_Event_AdvanceWatermark) Reset() {
	*m = TestStreamPayload_Event_AdvanceWatermark{}
}
func (m *TestStreamPayload_Event_AdvanceWatermark) String() string { return proto.CompactTextString(m) }
func (*TestStreamPayload_Event_AdvanceWatermark) ProtoMessage()    {}
func (*TestStreamPayload_Event_AdvanceWatermark) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{19, 0, 0}
}

func (m *TestStreamPayload_Event_AdvanceWatermark) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestStreamPayload_Event_AdvanceWatermark.Unmarshal(m, b)
}
func (m *TestStreamPayload_Event_AdvanceWatermark) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestStreamPayload_Event_AdvanceWatermark.Marshal(b, m, deterministic)
}
func (m *TestStreamPayload_Event_AdvanceWatermark) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestStreamPayload_Event_AdvanceWatermark.Merge(m, src)
}
func (m *TestStreamPayload_Event_AdvanceWatermark) XXX_Size() int {
	return xxx_messageInfo_TestStreamPayload_Event_AdvanceWatermark.Size(m)
}
func (m *TestStreamPayload_Event_AdvanceWatermark) XXX_DiscardUnknown() {
	xxx_messageInfo_TestStreamPayload_Event_AdvanceWatermark.DiscardUnknown(m)
}

var xxx_messageInfo_TestStreamPayload_Event_AdvanceWatermark proto.InternalMessageInfo

func (m *TestStreamPayload_Event_AdvanceWatermark) GetNewWatermark() int64 {
	if m != nil {
		return m.NewWatermark
	}
	return 0
}

func (m *TestStreamPayload_Event_AdvanceWatermark) GetTag() string {
	if m != nil {
		return m.Tag
	}
	return ""
}

// Advances the processing time clock by the specified amount.
type TestStreamPayload_Event_AdvanceProcessingTime struct {
	// (Required) The duration to advance by.
	AdvanceDuration      int64    `protobuf:"varint,1,opt,name=advance_duration,json=advanceDuration,proto3" json:"advance_duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestStreamPayload_Event_AdvanceProcessingTime) Reset() {
	*m = TestStreamPayload_Event_AdvanceProcessingTime{}
}
func (m *TestStreamPayload_Event_AdvanceProcessingTime) String() string {
	return proto.CompactTextString(m)
}
func (*TestStreamPayload_Event_AdvanceProcessingTime) ProtoMessage() {}
func (*TestStreamPayload_Event_AdvanceProcessingTime) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{19, 0, 1}
}

func (m *TestStreamPayload_Event_AdvanceProcessingTime) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestStreamPayload_Event_AdvanceProcessingTime.Unmarshal(m, b)
}
func (m *TestStreamPayload_Event_AdvanceProcessingTime) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestStreamPayload_Event_AdvanceProcessingTime.Marshal(b, m, deterministic)
}
func (m *TestStreamPayload_Event_AdvanceProcessingTime) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestStreamPayload_Event_AdvanceProcessingTime.Merge(m, src)
}
func (m *TestStreamPayload_Event_AdvanceProcessingTime) XXX_Size() int {
	return xxx_messageInfo_TestStreamPayload_Event_AdvanceProcessingTime.Size(m)
}
func (m *TestStreamPayload_Event_AdvanceProcessingTime) XXX_DiscardUnknown() {
	xxx_messageInfo_TestStreamPayload_Event_AdvanceProcessingTime.DiscardUnknown(m)
}

var xxx_messageInfo_TestStreamPayload_Event_AdvanceProcessingTime proto.InternalMessageInfo

func (m *TestStreamPayload_Event_AdvanceProcessingTime) GetAdvanceDuration() int64 {
	if m != nil {
		return m.AdvanceDuration
	}
	return 0
}

// Adds elements to the stream to be emitted.
type TestStreamPayload_Event_AddElements struct {
	// (Required) The elements to add to the TestStream.
	Elements []*TestStreamPayload_TimestampedElement `protobuf:"bytes,1,rep,name=elements,proto3" json:"elements,omitempty"`
	// (Optional) The output PCollection tag to add these elements to. If
	// unspecified or with an empty string, this will default to the Main
	// PCollection Output.
	Tag                  string   `protobuf:"bytes,3,opt,name=tag,proto3" json:"tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestStreamPayload_Event_AddElements) Reset()         { *m = TestStreamPayload_Event_AddElements{} }
func (m *TestStreamPayload_Event_AddElements) String() string { return proto.CompactTextString(m) }
func (*TestStreamPayload_Event_AddElements) ProtoMessage()    {}
func (*TestStreamPayload_Event_AddElements) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{19, 0, 2}
}

func (m *TestStreamPayload_Event_AddElements) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestStreamPayload_Event_AddElements.Unmarshal(m, b)
}
func (m *TestStreamPayload_Event_AddElements) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestStreamPayload_Event_AddElements.Marshal(b, m, deterministic)
}
func (m *TestStreamPayload_Event_AddElements) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestStreamPayload_Event_AddElements.Merge(m, src)
}
func (m *TestStreamPayload_Event_AddElements) XXX_Size() int {
	return xxx_messageInfo_TestStreamPayload_Event_AddElements.Size(m)
}
func (m *TestStreamPayload_Event_AddElements) XXX_DiscardUnknown() {
	xxx_messageInfo_TestStreamPayload_Event_AddElements.DiscardUnknown(m)
}

var xxx_messageInfo_TestStreamPayload_Event_AddElements proto.InternalMessageInfo

func (m *TestStreamPayload_Event_AddElements) GetElements() []*TestStreamPayload_TimestampedElement {
	if m != nil {
		return m.Elements
	}
	return nil
}

func (m *TestStreamPayload_Event_AddElements) GetTag() string {
	if m != nil {
		return m.Tag
	}
	return ""
}

// A single element inside of the TestStream.
type TestStreamPayload_TimestampedElement struct {
	// (Required) The element encoded. Currently the TestStream only supports
	// encoding primitives.
	EncodedElement []byte `protobuf:"bytes,1,opt,name=encoded_element,json=encodedElement,proto3" json:"encoded_element,omitempty"`
	// (Required) The event timestamp of this element.
	Timestamp            int64    `protobuf:"varint,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestStreamPayload_TimestampedElement) Reset()         { *m = TestStreamPayload_TimestampedElement{} }
func (m *TestStreamPayload_TimestampedElement) String() string { return proto.CompactTextString(m) }
func (*TestStreamPayload_TimestampedElement) ProtoMessage()    {}
func (*TestStreamPayload_TimestampedElement) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{19, 1}
}

func (m *TestStreamPayload_TimestampedElement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestStreamPayload_TimestampedElement.Unmarshal(m, b)
}
func (m *TestStreamPayload_TimestampedElement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestStreamPayload_TimestampedElement.Marshal(b, m, deterministic)
}
func (m *TestStreamPayload_TimestampedElement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestStreamPayload_TimestampedElement.Merge(m, src)
}
func (m *TestStreamPayload_TimestampedElement) XXX_Size() int {
	return xxx_messageInfo_TestStreamPayload_TimestampedElement.Size(m)
}
func (m *TestStreamPayload_TimestampedElement) XXX_DiscardUnknown() {
	xxx_messageInfo_TestStreamPayload_TimestampedElement.DiscardUnknown(m)
}

var xxx_messageInfo_TestStreamPayload_TimestampedElement proto.InternalMessageInfo

func (m *TestStreamPayload_TimestampedElement) GetEncodedElement() []byte {
	if m != nil {
		return m.EncodedElement
	}
	return nil
}

func (m *TestStreamPayload_TimestampedElement) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

type EventsRequest struct {
	// The set of PCollections to read from. These are the PTransform outputs
	// local names. These are a subset of the TestStream's outputs. This allows
	// Interactive Beam to cache many PCollections from a pipeline then replay a
	// subset of them.
	OutputIds            []string `protobuf:"bytes,1,rep,name=output_ids,json=outputIds,proto3" json:"output_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventsRequest) Reset()         { *m = EventsRequest{} }
func (m *EventsRequest) String() string { return proto.CompactTextString(m) }
func (*EventsRequest) ProtoMessage()    {}
func (*EventsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{20}
}

func (m *EventsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventsRequest.Unmarshal(m, b)
}
func (m *EventsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventsRequest.Marshal(b, m, deterministic)
}
func (m *EventsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventsRequest.Merge(m, src)
}
func (m *EventsRequest) XXX_Size() int {
	return xxx_messageInfo_EventsRequest.Size(m)
}
func (m *EventsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_EventsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_EventsRequest proto.InternalMessageInfo

func (m *EventsRequest) GetOutputIds() []string {
	if m != nil {
		return m.OutputIds
	}
	return nil
}

// The payload for the special-but-not-primitive WriteFiles transform.
type WriteFilesPayload struct {
	// (Required) The FunctionSpec of the FileBasedSink.
	Sink *FunctionSpec `protobuf:"bytes,1,opt,name=sink,proto3" json:"sink,omitempty"`
	// (Required) The format function.
	FormatFunction           *FunctionSpec         `protobuf:"bytes,2,opt,name=format_function,json=formatFunction,proto3" json:"format_function,omitempty"`
	WindowedWrites           bool                  `protobuf:"varint,3,opt,name=windowed_writes,json=windowedWrites,proto3" json:"windowed_writes,omitempty"`
	RunnerDeterminedSharding bool                  `protobuf:"varint,4,opt,name=runner_determined_sharding,json=runnerDeterminedSharding,proto3" json:"runner_determined_sharding,omitempty"`
	SideInputs               map[string]*SideInput `protobuf:"bytes,5,rep,name=side_inputs,json=sideInputs,proto3" json:"side_inputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral     struct{}              `json:"-"`
	XXX_unrecognized         []byte                `json:"-"`
	XXX_sizecache            int32                 `json:"-"`
}

func (m *WriteFilesPayload) Reset()         { *m = WriteFilesPayload{} }
func (m *WriteFilesPayload) String() string { return proto.CompactTextString(m) }
func (*WriteFilesPayload) ProtoMessage()    {}
func (*WriteFilesPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{21}
}

func (m *WriteFilesPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WriteFilesPayload.Unmarshal(m, b)
}
func (m *WriteFilesPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WriteFilesPayload.Marshal(b, m, deterministic)
}
func (m *WriteFilesPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteFilesPayload.Merge(m, src)
}
func (m *WriteFilesPayload) XXX_Size() int {
	return xxx_messageInfo_WriteFilesPayload.Size(m)
}
func (m *WriteFilesPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteFilesPayload.DiscardUnknown(m)
}

var xxx_messageInfo_WriteFilesPayload proto.InternalMessageInfo

func (m *WriteFilesPayload) GetSink() *FunctionSpec {
	if m != nil {
		return m.Sink
	}
	return nil
}

func (m *WriteFilesPayload) GetFormatFunction() *FunctionSpec {
	if m != nil {
		return m.FormatFunction
	}
	return nil
}

func (m *WriteFilesPayload) GetWindowedWrites() bool {
	if m != nil {
		return m.WindowedWrites
	}
	return false
}

func (m *WriteFilesPayload) GetRunnerDeterminedSharding() bool {
	if m != nil {
		return m.RunnerDeterminedSharding
	}
	return false
}

func (m *WriteFilesPayload) GetSideInputs() map[string]*SideInput {
	if m != nil {
		return m.SideInputs
	}
	return nil
}

// A coder, the binary format for serialization and deserialization of data in
// a pipeline.
type Coder struct {
	// (Required) A specification for the coder, as a URN plus parameters. This
	// may be a cross-language agreed-upon format, or it may be a "custom coder"
	// that can only be used by a particular SDK. It does not include component
	// coders, as it is beneficial for these to be comprehensible to a runner
	// regardless of whether the binary format is agreed-upon.
	Spec *FunctionSpec `protobuf:"bytes,1,opt,name=spec,proto3" json:"spec,omitempty"`
	// (Optional) If this coder is parametric, such as ListCoder(VarIntCoder),
	// this is a list of the components. In order for encodings to be identical,
	// the FunctionSpec and all components must be identical, recursively.
	ComponentCoderIds    []string `protobuf:"bytes,2,rep,name=component_coder_ids,json=componentCoderIds,proto3" json:"component_coder_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Coder) Reset()         { *m = Coder{} }
func (m *Coder) String() string { return proto.CompactTextString(m) }
func (*Coder) ProtoMessage()    {}
func (*Coder) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{22}
}

func (m *Coder) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Coder.Unmarshal(m, b)
}
func (m *Coder) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Coder.Marshal(b, m, deterministic)
}
func (m *Coder) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Coder.Merge(m, src)
}
func (m *Coder) XXX_Size() int {
	return xxx_messageInfo_Coder.Size(m)
}
func (m *Coder) XXX_DiscardUnknown() {
	xxx_messageInfo_Coder.DiscardUnknown(m)
}

var xxx_messageInfo_Coder proto.InternalMessageInfo

func (m *Coder) GetSpec() *FunctionSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *Coder) GetComponentCoderIds() []string {
	if m != nil {
		return m.ComponentCoderIds
	}
	return nil
}

type StandardCoders struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StandardCoders) Reset()         { *m = StandardCoders{} }
func (m *StandardCoders) String() string { return proto.CompactTextString(m) }
func (*StandardCoders) ProtoMessage()    {}
func (*StandardCoders) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{23}
}

func (m *StandardCoders) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StandardCoders.Unmarshal(m, b)
}
func (m *StandardCoders) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StandardCoders.Marshal(b, m, deterministic)
}
func (m *StandardCoders) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StandardCoders.Merge(m, src)
}
func (m *StandardCoders) XXX_Size() int {
	return xxx_messageInfo_StandardCoders.Size(m)
}
func (m *StandardCoders) XXX_DiscardUnknown() {
	xxx_messageInfo_StandardCoders.DiscardUnknown(m)
}

var xxx_messageInfo_StandardCoders proto.InternalMessageInfo

// A windowing strategy describes the window function, triggering, allowed
// lateness, and accumulation mode for a PCollection.
//
// TODO: consider inlining field on PCollection
type WindowingStrategy struct {
	// (Required) The FunctionSpec of the UDF that assigns windows,
	// merges windows, and shifts timestamps before they are
	// combined according to the OutputTime.
	WindowFn *FunctionSpec `protobuf:"bytes,1,opt,name=window_fn,json=windowFn,proto3" json:"window_fn,omitempty"`
	// (Required) Whether or not the window fn is merging.
	//
	// This knowledge is required for many optimizations.
	MergeStatus MergeStatus_Enum `protobuf:"varint,2,opt,name=merge_status,json=mergeStatus,proto3,enum=org.apache.beam.model.pipeline.v1.MergeStatus_Enum" json:"merge_status,omitempty"`
	// (Required) The coder for the windows of this PCollection.
	WindowCoderId string `protobuf:"bytes,3,opt,name=window_coder_id,json=windowCoderId,proto3" json:"window_coder_id,omitempty"`
	// (Required) The trigger to use when grouping this PCollection.
	Trigger *Trigger `protobuf:"bytes,4,opt,name=trigger,proto3" json:"trigger,omitempty"`
	// (Required) The accumulation mode indicates whether new panes are a full
	// replacement for prior panes or whether they are deltas to be combined
	// with other panes (the combine should correspond to whatever the upstream
	// grouping transform is).
	AccumulationMode AccumulationMode_Enum `protobuf:"varint,5,opt,name=accumulation_mode,json=accumulationMode,proto3,enum=org.apache.beam.model.pipeline.v1.AccumulationMode_Enum" json:"accumulation_mode,omitempty"`
	// (Required) The OutputTime specifies, for a grouping transform, how to
	// compute the aggregate timestamp. The window_fn will first possibly shift
	// it later, then the OutputTime takes the max, min, or ignores it and takes
	// the end of window.
	//
	// This is actually only for input to grouping transforms, but since they
	// may be introduced in runner-specific ways, it is carried along with the
	// windowing strategy.
	OutputTime OutputTime_Enum `protobuf:"varint,6,opt,name=output_time,json=outputTime,proto3,enum=org.apache.beam.model.pipeline.v1.OutputTime_Enum" json:"output_time,omitempty"`
	// (Required) Indicate when output should be omitted upon window expiration.
	ClosingBehavior ClosingBehavior_Enum `protobuf:"varint,7,opt,name=closing_behavior,json=closingBehavior,proto3,enum=org.apache.beam.model.pipeline.v1.ClosingBehavior_Enum" json:"closing_behavior,omitempty"`
	// (Required) The duration, in milliseconds, beyond the end of a window at
	// which the window becomes droppable.
	AllowedLateness int64 `protobuf:"varint,8,opt,name=allowed_lateness,json=allowedLateness,proto3" json:"allowed_lateness,omitempty"`
	// (Required) Indicate whether empty on-time panes should be omitted.
	OnTimeBehavior OnTimeBehavior_Enum `protobuf:"varint,9,opt,name=OnTimeBehavior,proto3,enum=org.apache.beam.model.pipeline.v1.OnTimeBehavior_Enum" json:"OnTimeBehavior,omitempty"`
	// (Required) Whether or not the window fn assigns inputs to exactly one window
	//
	// This knowledge is required for some optimizations
	AssignsToOneWindow bool `protobuf:"varint,10,opt,name=assigns_to_one_window,json=assignsToOneWindow,proto3" json:"assigns_to_one_window,omitempty"`
	// (Optional) Environment where the current window_fn should be applied in.
	// Runner that executes the pipeline may choose to override this if needed.
	// If not specified, environment will be decided by the runner.
	EnvironmentId        string   `protobuf:"bytes,11,opt,name=environment_id,json=environmentId,proto3" json:"environment_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WindowingStrategy) Reset()         { *m = WindowingStrategy{} }
func (m *WindowingStrategy) String() string { return proto.CompactTextString(m) }
func (*WindowingStrategy) ProtoMessage()    {}
func (*WindowingStrategy) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{24}
}

func (m *WindowingStrategy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WindowingStrategy.Unmarshal(m, b)
}
func (m *WindowingStrategy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WindowingStrategy.Marshal(b, m, deterministic)
}
func (m *WindowingStrategy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowingStrategy.Merge(m, src)
}
func (m *WindowingStrategy) XXX_Size() int {
	return xxx_messageInfo_WindowingStrategy.Size(m)
}
func (m *WindowingStrategy) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowingStrategy.DiscardUnknown(m)
}

var xxx_messageInfo_WindowingStrategy proto.InternalMessageInfo

func (m *WindowingStrategy) GetWindowFn() *FunctionSpec {
	if m != nil {
		return m.WindowFn
	}
	return nil
}

func (m *WindowingStrategy) GetMergeStatus() MergeStatus_Enum {
	if m != nil {
		return m.MergeStatus
	}
	return MergeStatus_UNSPECIFIED
}

func (m *WindowingStrategy) GetWindowCoderId() string {
	if m != nil {
		return m.WindowCoderId
	}
	return ""
}

func (m *WindowingStrategy) GetTrigger() *Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

func (m *WindowingStrategy) GetAccumulationMode() AccumulationMode_Enum {
	if m != nil {
		return m.AccumulationMode
	}
	return AccumulationMode_UNSPECIFIED
}

func (m *WindowingStrategy) GetOutputTime() OutputTime_Enum {
	if m != nil {
		return m.OutputTime
	}
	return OutputTime_UNSPECIFIED
}

func (m *WindowingStrategy) GetClosingBehavior() ClosingBehavior_Enum {
	if m != nil {
		return m.ClosingBehavior
	}
	return ClosingBehavior_UNSPECIFIED
}

func (m *WindowingStrategy) GetAllowedLateness() int64 {
	if m != nil {
		return m.AllowedLateness
	}
	return 0
}

func (m *WindowingStrategy) GetOnTimeBehavior() OnTimeBehavior_Enum {
	if m != nil {
		return m.OnTimeBehavior
	}
	return OnTimeBehavior_UNSPECIFIED
}

func (m *WindowingStrategy) GetAssignsToOneWindow() bool {
	if m != nil {
		return m.AssignsToOneWindow
	}
	return false
}

func (m *WindowingStrategy) GetEnvironmentId() string {
	if m != nil {
		return m.EnvironmentId
	}
	return ""
}

// Whether or not a PCollection's WindowFn is non-merging, merging, or
// merging-but-already-merged, in which case a subsequent GroupByKey is almost
// always going to do something the user does not want
type MergeStatus struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MergeStatus) Reset()         { *m = MergeStatus{} }
func (m *MergeStatus) String() string { return proto.CompactTextString(m) }
func (*MergeStatus) ProtoMessage()    {}
func (*MergeStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{25}
}

func (m *MergeStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MergeStatus.Unmarshal(m, b)
}
func (m *MergeStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MergeStatus.Marshal(b, m, deterministic)
}
func (m *MergeStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeStatus.Merge(m, src)
}
func (m *MergeStatus) XXX_Size() int {
	return xxx_messageInfo_MergeStatus.Size(m)
}
func (m *MergeStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeStatus.DiscardUnknown(m)
}

var xxx_messageInfo_MergeStatus proto.InternalMessageInfo

// Whether or not subsequent outputs of aggregations should be entire
// replacement values or just the aggregation of inputs received since
// the prior output.
type AccumulationMode struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccumulationMode) Reset()         { *m = AccumulationMode{} }
func (m *AccumulationMode) String() string { return proto.CompactTextString(m) }
func (*AccumulationMode) ProtoMessage()    {}
func (*AccumulationMode) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{26}
}

func (m *AccumulationMode) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AccumulationMode.Unmarshal(m, b)
}
func (m *AccumulationMode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AccumulationMode.Marshal(b, m, deterministic)
}
func (m *AccumulationMode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccumulationMode.Merge(m, src)
}
func (m *AccumulationMode) XXX_Size() int {
	return xxx_messageInfo_AccumulationMode.Size(m)
}
func (m *AccumulationMode) XXX_DiscardUnknown() {
	xxx_messageInfo_AccumulationMode.DiscardUnknown(m)
}

var xxx_messageInfo_AccumulationMode proto.InternalMessageInfo

// Controls whether or not an aggregating transform should output data
// when a window expires.
type ClosingBehavior struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClosingBehavior) Reset()         { *m = ClosingBehavior{} }
func (m *ClosingBehavior) String() string { return proto.CompactTextString(m) }
func (*ClosingBehavior) ProtoMessage()    {}
func (*ClosingBehavior) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{27}
}

func (m *ClosingBehavior) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClosingBehavior.Unmarshal(m, b)
}
func (m *ClosingBehavior) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClosingBehavior.Marshal(b, m, deterministic)
}
func (m *ClosingBehavior) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClosingBehavior.Merge(m, src)
}
func (m *ClosingBehavior) XXX_Size() int {
	return xxx_messageInfo_ClosingBehavior.Size(m)
}
func (m *ClosingBehavior) XXX_DiscardUnknown() {
	xxx_messageInfo_ClosingBehavior.DiscardUnknown(m)
}

var xxx_messageInfo_ClosingBehavior proto.InternalMessageInfo

// Controls whether or not an aggregating transform should output data
// when an on-time pane is empty.
type OnTimeBehavior struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OnTimeBehavior) Reset()         { *m = OnTimeBehavior{} }
func (m *OnTimeBehavior) String() string { return proto.CompactTextString(m) }
func (*OnTimeBehavior) ProtoMessage()    {}
func (*OnTimeBehavior) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{28}
}

func (m *OnTimeBehavior) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OnTimeBehavior.Unmarshal(m, b)
}
func (m *OnTimeBehavior) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OnTimeBehavior.Marshal(b, m, deterministic)
}
func (m *OnTimeBehavior) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OnTimeBehavior.Merge(m, src)
}
func (m *OnTimeBehavior) XXX_Size() int {
	return xxx_messageInfo_OnTimeBehavior.Size(m)
}
func (m *OnTimeBehavior) XXX_DiscardUnknown() {
	xxx_messageInfo_OnTimeBehavior.DiscardUnknown(m)
}

var xxx_messageInfo_OnTimeBehavior proto.InternalMessageInfo

// When a number of windowed, timestamped inputs are aggregated, the timestamp
// for the resulting output.
type OutputTime struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OutputTime) Reset()         { *m = OutputTime{} }
func (m *OutputTime) String() string { return proto.CompactTextString(m) }
func (*OutputTime) ProtoMessage()    {}
func (*OutputTime) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{29}
}

func (m *OutputTime) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutputTime.Unmarshal(m, b)
}
func (m *OutputTime) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutputTime.Marshal(b, m, deterministic)
}
func (m *OutputTime) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputTime.Merge(m, src)
}
func (m *OutputTime) XXX_Size() int {
	return xxx_messageInfo_OutputTime.Size(m)
}
func (m *OutputTime) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputTime.DiscardUnknown(m)
}

var xxx_messageInfo_OutputTime proto.InternalMessageInfo

// The different time domains in the Beam model.
type TimeDomain struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TimeDomain) Reset()         { *m = TimeDomain{} }
func (m *TimeDomain) String() string { return proto.CompactTextString(m) }
func (*TimeDomain) ProtoMessage()    {}
func (*TimeDomain) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{30}
}

func (m *TimeDomain) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimeDomain.Unmarshal(m, b)
}
func (m *TimeDomain) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimeDomain.Marshal(b, m, deterministic)
}
func (m *TimeDomain) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeDomain.Merge(m, src)
}
func (m *TimeDomain) XXX_Size() int {
	return xxx_messageInfo_TimeDomain.Size(m)
}
func (m *TimeDomain) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeDomain.DiscardUnknown(m)
}

var xxx_messageInfo_TimeDomain proto.InternalMessageInfo

// A small DSL for expressing when to emit new aggregations
// from a GroupByKey or CombinePerKey
//
// A trigger is described in terms of when it is _ready_ to permit output.
type Trigger struct {
	// The full disjoint union of possible triggers.
	//
	// Types that are valid to be assigned to Trigger:
	//	*Trigger_AfterAll_
	//	*Trigger_AfterAny_
	//	*Trigger_AfterEach_
	//	*Trigger_AfterEndOfWindow_
	//	*Trigger_AfterProcessingTime_
	//	*Trigger_AfterSynchronizedProcessingTime_
	//	*Trigger_Always_
	//	*Trigger_Default_
	//	*Trigger_ElementCount_
	//	*Trigger_Never_
	//	*Trigger_OrFinally_
	//	*Trigger_Repeat_
	Trigger              isTrigger_Trigger `protobuf_oneof:"trigger"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Trigger) Reset()         { *m = Trigger{} }
func (m *Trigger) String() string { return proto.CompactTextString(m) }
func (*Trigger) ProtoMessage()    {}
func (*Trigger) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{31}
}

func (m *Trigger) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger.Unmarshal(m, b)
}
func (m *Trigger) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger.Marshal(b, m, deterministic)
}
func (m *Trigger) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger.Merge(m, src)
}
func (m *Trigger) XXX_Size() int {
	return xxx_messageInfo_Trigger.Size(m)
}
func (m *Trigger) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger proto.InternalMessageInfo

type isTrigger_Trigger interface {
	isTrigger_Trigger()
}

type Trigger_AfterAll_ struct {
	AfterAll *Trigger_AfterAll `protobuf:"bytes,1,opt,name=after_all,json=afterAll,proto3,oneof"`
}

type Trigger_AfterAny_ struct {
	AfterAny *Trigger_AfterAny `protobuf:"bytes,2,opt,name=after_any,json=afterAny,proto3,oneof"`
}

type Trigger_AfterEach_ struct {
	AfterEach *Trigger_AfterEach `protobuf:"bytes,3,opt,name=after_each,json=afterEach,proto3,oneof"`
}

type Trigger_AfterEndOfWindow_ struct {
	AfterEndOfWindow *Trigger_AfterEndOfWindow `protobuf:"bytes,4,opt,name=after_end_of_window,json=afterEndOfWindow,proto3,oneof"`
}

type Trigger_AfterProcessingTime_ struct {
	AfterProcessingTime *Trigger_AfterProcessingTime `protobuf:"bytes,5,opt,name=after_processing_time,json=afterProcessingTime,proto3,oneof"`
}

type Trigger_AfterSynchronizedProcessingTime_ struct {
	AfterSynchronizedProcessingTime *Trigger_AfterSynchronizedProcessingTime `protobuf:"bytes,6,opt,name=after_synchronized_processing_time,json=afterSynchronizedProcessingTime,proto3,oneof"`
}

type Trigger_Always_ struct {
	Always *Trigger_Always `protobuf:"bytes,12,opt,name=always,proto3,oneof"`
}

type Trigger_Default_ struct {
	Default *Trigger_Default `protobuf:"bytes,7,opt,name=default,proto3,oneof"`
}

type Trigger_ElementCount_ struct {
	ElementCount *Trigger_ElementCount `protobuf:"bytes,8,opt,name=element_count,json=elementCount,proto3,oneof"`
}

type Trigger_Never_ struct {
	Never *Trigger_Never `protobuf:"bytes,9,opt,name=never,proto3,oneof"`
}

type Trigger_OrFinally_ struct {
	OrFinally *Trigger_OrFinally `protobuf:"bytes,10,opt,name=or_finally,json=orFinally,proto3,oneof"`
}

type Trigger_Repeat_ struct {
	Repeat *Trigger_Repeat `protobuf:"bytes,11,opt,name=repeat,proto3,oneof"`
}

func (*Trigger_AfterAll_) isTrigger_Trigger() {}

func (*Trigger_AfterAny_) isTrigger_Trigger() {}

func (*Trigger_AfterEach_) isTrigger_Trigger() {}

func (*Trigger_AfterEndOfWindow_) isTrigger_Trigger() {}

func (*Trigger_AfterProcessingTime_) isTrigger_Trigger() {}

func (*Trigger_AfterSynchronizedProcessingTime_) isTrigger_Trigger() {}

func (*Trigger_Always_) isTrigger_Trigger() {}

func (*Trigger_Default_) isTrigger_Trigger() {}

func (*Trigger_ElementCount_) isTrigger_Trigger() {}

func (*Trigger_Never_) isTrigger_Trigger() {}

func (*Trigger_OrFinally_) isTrigger_Trigger() {}

func (*Trigger_Repeat_) isTrigger_Trigger() {}

func (m *Trigger) GetTrigger() isTrigger_Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

func (m *Trigger) GetAfterAll() *Trigger_AfterAll {
	if x, ok := m.GetTrigger().(*Trigger_AfterAll_); ok {
		return x.AfterAll
	}
	return nil
}

func (m *Trigger) GetAfterAny() *Trigger_AfterAny {
	if x, ok := m.GetTrigger().(*Trigger_AfterAny_); ok {
		return x.AfterAny
	}
	return nil
}

func (m *Trigger) GetAfterEach() *Trigger_AfterEach {
	if x, ok := m.GetTrigger().(*Trigger_AfterEach_); ok {
		return x.AfterEach
	}
	return nil
}

func (m *Trigger) GetAfterEndOfWindow() *Trigger_AfterEndOfWindow {
	if x, ok := m.GetTrigger().(*Trigger_AfterEndOfWindow_); ok {
		return x.AfterEndOfWindow
	}
	return nil
}

func (m *Trigger) GetAfterProcessingTime() *Trigger_AfterProcessingTime {
	if x, ok := m.GetTrigger().(*Trigger_AfterProcessingTime_); ok {
		return x.AfterProcessingTime
	}
	return nil
}

func (m *Trigger) GetAfterSynchronizedProcessingTime() *Trigger_AfterSynchronizedProcessingTime {
	if x, ok := m.GetTrigger().(*Trigger_AfterSynchronizedProcessingTime_); ok {
		return x.AfterSynchronizedProcessingTime
	}
	return nil
}

func (m *Trigger) GetAlways() *Trigger_Always {
	if x, ok := m.GetTrigger().(*Trigger_Always_); ok {
		return x.Always
	}
	return nil
}

func (m *Trigger) GetDefault() *Trigger_Default {
	if x, ok := m.GetTrigger().(*Trigger_Default_); ok {
		return x.Default
	}
	return nil
}

func (m *Trigger) GetElementCount() *Trigger_ElementCount {
	if x, ok := m.GetTrigger().(*Trigger_ElementCount_); ok {
		return x.ElementCount
	}
	return nil
}

func (m *Trigger) GetNever() *Trigger_Never {
	if x, ok := m.GetTrigger().(*Trigger_Never_); ok {
		return x.Never
	}
	return nil
}

func (m *Trigger) GetOrFinally() *Trigger_OrFinally {
	if x, ok := m.GetTrigger().(*Trigger_OrFinally_); ok {
		return x.OrFinally
	}
	return nil
}

func (m *Trigger) GetRepeat() *Trigger_Repeat {
	if x, ok := m.GetTrigger().(*Trigger_Repeat_); ok {
		return x.Repeat
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Trigger) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Trigger_AfterAll_)(nil),
		(*Trigger_AfterAny_)(nil),
		(*Trigger_AfterEach_)(nil),
		(*Trigger_AfterEndOfWindow_)(nil),
		(*Trigger_AfterProcessingTime_)(nil),
		(*Trigger_AfterSynchronizedProcessingTime_)(nil),
		(*Trigger_Always_)(nil),
		(*Trigger_Default_)(nil),
		(*Trigger_ElementCount_)(nil),
		(*Trigger_Never_)(nil),
		(*Trigger_OrFinally_)(nil),
		(*Trigger_Repeat_)(nil),
	}
}

// Ready when all subtriggers are ready.
type Trigger_AfterAll struct {
	Subtriggers          []*Trigger `protobuf:"bytes,1,rep,name=subtriggers,proto3" json:"subtriggers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Trigger_AfterAll) Reset()         { *m = Trigger_AfterAll{} }
func (m *Trigger_AfterAll) String() string { return proto.CompactTextString(m) }
func (*Trigger_AfterAll) ProtoMessage()    {}
func (*Trigger_AfterAll) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{31, 0}
}

func (m *Trigger_AfterAll) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_AfterAll.Unmarshal(m, b)
}
func (m *Trigger_AfterAll) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_AfterAll.Marshal(b, m, deterministic)
}
func (m *Trigger_AfterAll) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_AfterAll.Merge(m, src)
}
func (m *Trigger_AfterAll) XXX_Size() int {
	return xxx_messageInfo_Trigger_AfterAll.Size(m)
}
func (m *Trigger_AfterAll) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_AfterAll.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_AfterAll proto.InternalMessageInfo

func (m *Trigger_AfterAll) GetSubtriggers() []*Trigger {
	if m != nil {
		return m.Subtriggers
	}
	return nil
}

// Ready when any subtrigger is ready.
type Trigger_AfterAny struct {
	Subtriggers          []*Trigger `protobuf:"bytes,1,rep,name=subtriggers,proto3" json:"subtriggers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Trigger_AfterAny) Reset()         { *m = Trigger_AfterAny{} }
func (m *Trigger_AfterAny) String() string { return proto.CompactTextString(m) }
func (*Trigger_AfterAny) ProtoMessage()    {}
func (*Trigger_AfterAny) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{31, 1}
}

func (m *Trigger_AfterAny) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_AfterAny.Unmarshal(m, b)
}
func (m *Trigger_AfterAny) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_AfterAny.Marshal(b, m, deterministic)
}
func (m *Trigger_AfterAny) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_AfterAny.Merge(m, src)
}
func (m *Trigger_AfterAny) XXX_Size() int {
	return xxx_messageInfo_Trigger_AfterAny.Size(m)
}
func (m *Trigger_AfterAny) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_AfterAny.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_AfterAny proto.InternalMessageInfo

func (m *Trigger_AfterAny) GetSubtriggers() []*Trigger {
	if m != nil {
		return m.Subtriggers
	}
	return nil
}

// Starting with the first subtrigger, ready when the _current_ subtrigger
// is ready. After output, advances the current trigger by one.
type Trigger_AfterEach struct {
	Subtriggers          []*Trigger `protobuf:"bytes,1,rep,name=subtriggers,proto3" json:"subtriggers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Trigger_AfterEach) Reset()         { *m = Trigger_AfterEach{} }
func (m *Trigger_AfterEach) String() string { return proto.CompactTextString(m) }
func (*Trigger_AfterEach) ProtoMessage()    {}
func (*Trigger_AfterEach) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{31, 2}
}

func (m *Trigger_AfterEach) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_AfterEach.Unmarshal(m, b)
}
func (m *Trigger_AfterEach) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_AfterEach.Marshal(b, m, deterministic)
}
func (m *Trigger_AfterEach) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_AfterEach.Merge(m, src)
}
func (m *Trigger_AfterEach) XXX_Size() int {
	return xxx_messageInfo_Trigger_AfterEach.Size(m)
}
func (m *Trigger_AfterEach) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_AfterEach.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_AfterEach proto.InternalMessageInfo

func (m *Trigger_AfterEach) GetSubtriggers() []*Trigger {
	if m != nil {
		return m.Subtriggers
	}
	return nil
}

// Ready after the input watermark is past the end of the window.
//
// May have implicitly-repeated subtriggers for early and late firings.
// When the end of the window is reached, the trigger transitions between
// the subtriggers.
type Trigger_AfterEndOfWindow struct {
	// (Optional) A trigger governing output prior to the end of the window.
	EarlyFirings *Trigger `protobuf:"bytes,1,opt,name=early_firings,json=earlyFirings,proto3" json:"early_firings,omitempty"`
	// (Optional) A trigger governing output after the end of the window.
	LateFirings          *Trigger `protobuf:"bytes,2,opt,name=late_firings,json=lateFirings,proto3" json:"late_firings,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Trigger_AfterEndOfWindow) Reset()         { *m = Trigger_AfterEndOfWindow{} }
func (m *Trigger_AfterEndOfWindow) String() string { return proto.CompactTextString(m) }
func (*Trigger_AfterEndOfWindow) ProtoMessage()    {}
func (*Trigger_AfterEndOfWindow) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{31, 3}
}

func (m *Trigger_AfterEndOfWindow) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_AfterEndOfWindow.Unmarshal(m, b)
}
func (m *Trigger_AfterEndOfWindow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_AfterEndOfWindow.Marshal(b, m, deterministic)
}
func (m *Trigger_AfterEndOfWindow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_AfterEndOfWindow.Merge(m, src)
}
func (m *Trigger_AfterEndOfWindow) XXX_Size() int {
	return xxx_messageInfo_Trigger_AfterEndOfWindow.Size(m)
}
func (m *Trigger_AfterEndOfWindow) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_AfterEndOfWindow.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_AfterEndOfWindow proto.InternalMessageInfo

func (m *Trigger_AfterEndOfWindow) GetEarlyFirings() *Trigger {
	if m != nil {
		return m.EarlyFirings
	}
	return nil
}

func (m *Trigger_AfterEndOfWindow) GetLateFirings() *Trigger {
	if m != nil {
		return m.LateFirings
	}
	return nil
}

// After input arrives, ready when the specified delay has passed.
type Trigger_AfterProcessingTime struct {
	// (Required) The transforms to apply to an arriving element's timestamp,
	// in order
	TimestampTransforms  []*TimestampTransform `protobuf:"bytes,1,rep,name=timestamp_transforms,json=timestampTransforms,proto3" json:"timestamp_transforms,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Trigger_AfterProcessingTime) Reset()         { *m = Trigger_AfterProcessingTime{} }
func (m *Trigger_AfterProcessingTime) String() string { return proto.CompactTextString(m) }
func (*Trigger_AfterProcessingTime) ProtoMessage()    {}
func (*Trigger_AfterProcessingTime) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{31, 4}
}

func (m *Trigger_AfterProcessingTime) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_AfterProcessingTime.Unmarshal(m, b)
}
func (m *Trigger_AfterProcessingTime) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_AfterProcessingTime.Marshal(b, m, deterministic)
}
func (m *Trigger_AfterProcessingTime) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_AfterProcessingTime.Merge(m, src)
}
func (m *Trigger_AfterProcessingTime) XXX_Size() int {
	return xxx_messageInfo_Trigger_AfterProcessingTime.Size(m)
}
func (m *Trigger_AfterProcessingTime) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_AfterProcessingTime.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_AfterProcessingTime proto.InternalMessageInfo

func (m *Trigger_AfterProcessingTime) GetTimestampTransforms() []*TimestampTransform {
	if m != nil {
		return m.TimestampTransforms
	}
	return nil
}

// Ready whenever upstream processing time has all caught up with
// the arrival time of an input element
type Trigger_AfterSynchronizedProcessingTime struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Trigger_AfterSynchronizedProcessingTime) Reset() {
	*m = Trigger_AfterSynchronizedProcessingTime{}
}
func (m *Trigger_AfterSynchronizedProcessingTime) String() string { return proto.CompactTextString(m) }
func (*Trigger_AfterSynchronizedProcessingTime) ProtoMessage()    {}
func (*Trigger_AfterSynchronizedProcessingTime) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{31, 5}
}

func (m *Trigger_AfterSynchronizedProcessingTime) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_AfterSynchronizedProcessingTime.Unmarshal(m, b)
}
func (m *Trigger_AfterSynchronizedProcessingTime) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_AfterSynchronizedProcessingTime.Marshal(b, m, deterministic)
}
func (m *Trigger_AfterSynchronizedProcessingTime) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_AfterSynchronizedProcessingTime.Merge(m, src)
}
func (m *Trigger_AfterSynchronizedProcessingTime) XXX_Size() int {
	return xxx_messageInfo_Trigger_AfterSynchronizedProcessingTime.Size(m)
}
func (m *Trigger_AfterSynchronizedProcessingTime) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_AfterSynchronizedProcessingTime.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_AfterSynchronizedProcessingTime proto.InternalMessageInfo

// The default trigger. Equivalent to Repeat { AfterEndOfWindow } but
// specially denoted to indicate the user did not alter the triggering.
type Trigger_Default struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Trigger_Default) Reset()         { *m = Trigger_Default{} }
func (m *Trigger_Default) String() string { return proto.CompactTextString(m) }
func (*Trigger_Default) ProtoMessage()    {}
func (*Trigger_Default) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{31, 6}
}

func (m *Trigger_Default) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_Default.Unmarshal(m, b)
}
func (m *Trigger_Default) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_Default.Marshal(b, m, deterministic)
}
func (m *Trigger_Default) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_Default.Merge(m, src)
}
func (m *Trigger_Default) XXX_Size() int {
	return xxx_messageInfo_Trigger_Default.Size(m)
}
func (m *Trigger_Default) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_Default.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_Default proto.InternalMessageInfo

// Ready whenever the requisite number of input elements have arrived
type Trigger_ElementCount struct {
	ElementCount         int32    `protobuf:"varint,1,opt,name=element_count,json=elementCount,proto3" json:"element_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Trigger_ElementCount) Reset()         { *m = Trigger_ElementCount{} }
func (m *Trigger_ElementCount) String() string { return proto.CompactTextString(m) }
func (*Trigger_ElementCount) ProtoMessage()    {}
func (*Trigger_ElementCount) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{31, 7}
}

func (m *Trigger_ElementCount) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_ElementCount.Unmarshal(m, b)
}
func (m *Trigger_ElementCount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_ElementCount.Marshal(b, m, deterministic)
}
func (m *Trigger_ElementCount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_ElementCount.Merge(m, src)
}
func (m *Trigger_ElementCount) XXX_Size() int {
	return xxx_messageInfo_Trigger_ElementCount.Size(m)
}
func (m *Trigger_ElementCount) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_ElementCount.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_ElementCount proto.InternalMessageInfo

func (m *Trigger_ElementCount) GetElementCount() int32 {
	if m != nil {
		return m.ElementCount
	}
	return 0
}

// Never ready. There will only be an ON_TIME output and a final
// output at window expiration.
type Trigger_Never struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Trigger_Never) Reset()         { *m = Trigger_Never{} }
func (m *Trigger_Never) String() string { return proto.CompactTextString(m) }
func (*Trigger_Never) ProtoMessage()    {}
func (*Trigger_Never) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{31, 8}
}

func (m *Trigger_Never) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_Never.Unmarshal(m, b)
}
func (m *Trigger_Never) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_Never.Marshal(b, m, deterministic)
}
func (m *Trigger_Never) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_Never.Merge(m, src)
}
func (m *Trigger_Never) XXX_Size() int {
	return xxx_messageInfo_Trigger_Never.Size(m)
}
func (m *Trigger_Never) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_Never.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_Never proto.InternalMessageInfo

// Always ready. This can also be expressed as ElementCount(1) but
// is more explicit.
type Trigger_Always struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Trigger_Always) Reset()         { *m = Trigger_Always{} }
func (m *Trigger_Always) String() string { return proto.CompactTextString(m) }
func (*Trigger_Always) ProtoMessage()    {}
func (*Trigger_Always) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{31, 9}
}

func (m *Trigger_Always) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_Always.Unmarshal(m, b)
}
func (m *Trigger_Always) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_Always.Marshal(b, m, deterministic)
}
func (m *Trigger_Always) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_Always.Merge(m, src)
}
func (m *Trigger_Always) XXX_Size() int {
	return xxx_messageInfo_Trigger_Always.Size(m)
}
func (m *Trigger_Always) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_Always.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_Always proto.InternalMessageInfo

// Ready whenever either of its subtriggers are ready, but finishes output
// when the finally subtrigger fires.
type Trigger_OrFinally struct {
	// (Required) Trigger governing main output; may fire repeatedly.
	Main *Trigger `protobuf:"bytes,1,opt,name=main,proto3" json:"main,omitempty"`
	// (Required) Trigger governing termination of output.
	Finally              *Trigger `protobuf:"bytes,2,opt,name=finally,proto3" json:"finally,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Trigger_OrFinally) Reset()         { *m = Trigger_OrFinally{} }
func (m *Trigger_OrFinally) String() string { return proto.CompactTextString(m) }
func (*Trigger_OrFinally) ProtoMessage()    {}
func (*Trigger_OrFinally) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{31, 10}
}

func (m *Trigger_OrFinally) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_OrFinally.Unmarshal(m, b)
}
func (m *Trigger_OrFinally) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_OrFinally.Marshal(b, m, deterministic)
}
func (m *Trigger_OrFinally) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_OrFinally.Merge(m, src)
}
func (m *Trigger_OrFinally) XXX_Size() int {
	return xxx_messageInfo_Trigger_OrFinally.Size(m)
}
func (m *Trigger_OrFinally) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_OrFinally.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_OrFinally proto.InternalMessageInfo

func (m *Trigger_OrFinally) GetMain() *Trigger {
	if m != nil {
		return m.Main
	}
	return nil
}

func (m *Trigger_OrFinally) GetFinally() *Trigger {
	if m != nil {
		return m.Finally
	}
	return nil
}

// Ready whenever the subtrigger is ready; resets state when the subtrigger
// completes.
type Trigger_Repeat struct {
	// (Require) Trigger that is run repeatedly.
	Subtrigger           *Trigger `protobuf:"bytes,1,opt,name=subtrigger,proto3" json:"subtrigger,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Trigger_Repeat) Reset()         { *m = Trigger_Repeat{} }
func (m *Trigger_Repeat) String() string { return proto.CompactTextString(m) }
func (*Trigger_Repeat) ProtoMessage()    {}
func (*Trigger_Repeat) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{31, 11}
}

func (m *Trigger_Repeat) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_Repeat.Unmarshal(m, b)
}
func (m *Trigger_Repeat) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_Repeat.Marshal(b, m, deterministic)
}
func (m *Trigger_Repeat) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_Repeat.Merge(m, src)
}
func (m *Trigger_Repeat) XXX_Size() int {
	return xxx_messageInfo_Trigger_Repeat.Size(m)
}
func (m *Trigger_Repeat) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_Repeat.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_Repeat proto.InternalMessageInfo

func (m *Trigger_Repeat) GetSubtrigger() *Trigger {
	if m != nil {
		return m.Subtrigger
	}
	return nil
}

// A specification for a transformation on a timestamp.
//
// Primarily used by AfterProcessingTime triggers to transform
// the arrival time of input to a target time for firing.
type TimestampTransform struct {
	// Types that are valid to be assigned to TimestampTransform:
	//	*TimestampTransform_Delay_
	//	*TimestampTransform_AlignTo_
	TimestampTransform   isTimestampTransform_TimestampTransform `protobuf_oneof:"timestamp_transform"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *TimestampTransform) Reset()         { *m = TimestampTransform{} }
func (m *TimestampTransform) String() string { return proto.CompactTextString(m) }
func (*TimestampTransform) ProtoMessage()    {}
func (*TimestampTransform) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{32}
}

func (m *TimestampTransform) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimestampTransform.Unmarshal(m, b)
}
func (m *TimestampTransform) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimestampTransform.Marshal(b, m, deterministic)
}
func (m *TimestampTransform) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimestampTransform.Merge(m, src)
}
func (m *TimestampTransform) XXX_Size() int {
	return xxx_messageInfo_TimestampTransform.Size(m)
}
func (m *TimestampTransform) XXX_DiscardUnknown() {
	xxx_messageInfo_TimestampTransform.DiscardUnknown(m)
}

var xxx_messageInfo_TimestampTransform proto.InternalMessageInfo

type isTimestampTransform_TimestampTransform interface {
	isTimestampTransform_TimestampTransform()
}

type TimestampTransform_Delay_ struct {
	Delay *TimestampTransform_Delay `protobuf:"bytes,1,opt,name=delay,proto3,oneof"`
}

type TimestampTransform_AlignTo_ struct {
	AlignTo *TimestampTransform_AlignTo `protobuf:"bytes,2,opt,name=align_to,json=alignTo,proto3,oneof"`
}

func (*TimestampTransform_Delay_) isTimestampTransform_TimestampTransform() {}

func (*TimestampTransform_AlignTo_) isTimestampTransform_TimestampTransform() {}

func (m *TimestampTransform) GetTimestampTransform() isTimestampTransform_TimestampTransform {
	if m != nil {
		return m.TimestampTransform
	}
	return nil
}

func (m *TimestampTransform) GetDelay() *TimestampTransform_Delay {
	if x, ok := m.GetTimestampTransform().(*TimestampTransform_Delay_); ok {
		return x.Delay
	}
	return nil
}

func (m *TimestampTransform) GetAlignTo() *TimestampTransform_AlignTo {
	if x, ok := m.GetTimestampTransform().(*TimestampTransform_AlignTo_); ok {
		return x.AlignTo
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*TimestampTransform) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*TimestampTransform_Delay_)(nil),
		(*TimestampTransform_AlignTo_)(nil),
	}
}

type TimestampTransform_Delay struct {
	// (Required) The delay, in milliseconds.
	DelayMillis          int64    `protobuf:"varint,1,opt,name=delay_millis,json=delayMillis,proto3" json:"delay_millis,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TimestampTransform_Delay) Reset()         { *m = TimestampTransform_Delay{} }
func (m *TimestampTransform_Delay) String() string { return proto.CompactTextString(m) }
func (*TimestampTransform_Delay) ProtoMessage()    {}
func (*TimestampTransform_Delay) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{32, 0}
}

func (m *TimestampTransform_Delay) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimestampTransform_Delay.Unmarshal(m, b)
}
func (m *TimestampTransform_Delay) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimestampTransform_Delay.Marshal(b, m, deterministic)
}
func (m *TimestampTransform_Delay) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimestampTransform_Delay.Merge(m, src)
}
func (m *TimestampTransform_Delay) XXX_Size() int {
	return xxx_messageInfo_TimestampTransform_Delay.Size(m)
}
func (m *TimestampTransform_Delay) XXX_DiscardUnknown() {
	xxx_messageInfo_TimestampTransform_Delay.DiscardUnknown(m)
}

var xxx_messageInfo_TimestampTransform_Delay proto.InternalMessageInfo

func (m *TimestampTransform_Delay) GetDelayMillis() int64 {
	if m != nil {
		return m.DelayMillis
	}
	return 0
}

type TimestampTransform_AlignTo struct {
	// (Required) A duration to which delays should be quantized
	// in milliseconds.
	Period int64 `protobuf:"varint,3,opt,name=period,proto3" json:"period,omitempty"`
	// (Required) An offset from 0 for the quantization specified by
	// alignment_size, in milliseconds
	Offset               int64    `protobuf:"varint,4,opt,name=offset,proto3" json:"offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TimestampTransform_AlignTo) Reset()         { *m = TimestampTransform_AlignTo{} }
func (m *TimestampTransform_AlignTo) String() string { return proto.CompactTextString(m) }
func (*TimestampTransform_AlignTo) ProtoMessage()    {}
func (*TimestampTransform_AlignTo) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{32, 1}
}

func (m *TimestampTransform_AlignTo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimestampTransform_AlignTo.Unmarshal(m, b)
}
func (m *TimestampTransform_AlignTo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimestampTransform_AlignTo.Marshal(b, m, deterministic)
}
func (m *TimestampTransform_AlignTo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimestampTransform_AlignTo.Merge(m, src)
}
func (m *TimestampTransform_AlignTo) XXX_Size() int {
	return xxx_messageInfo_TimestampTransform_AlignTo.Size(m)
}
func (m *TimestampTransform_AlignTo) XXX_DiscardUnknown() {
	xxx_messageInfo_TimestampTransform_AlignTo.DiscardUnknown(m)
}

var xxx_messageInfo_TimestampTransform_AlignTo proto.InternalMessageInfo

func (m *TimestampTransform_AlignTo) GetPeriod() int64 {
	if m != nil {
		return m.Period
	}
	return 0
}

func (m *TimestampTransform_AlignTo) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

// A specification for how to "side input" a PCollection.
type SideInput struct {
	// (Required) URN of the access pattern required by the `view_fn` to present
	// the desired SDK-specific interface to a UDF.
	//
	// This access pattern defines the SDK harness <-> Runner Harness RPC
	// interface for accessing a side input.
	//
	// The only access pattern intended for Beam, because of its superior
	// performance possibilities, is "beam:sideinput:multimap" (or some such
	// URN)
	AccessPattern *FunctionSpec `protobuf:"bytes,1,opt,name=access_pattern,json=accessPattern,proto3" json:"access_pattern,omitempty"`
	// (Required) The FunctionSpec of the UDF that adapts a particular
	// access_pattern to a user-facing view type.
	//
	// For example, View.asSingleton() may include a `view_fn` that adapts a
	// specially-designed multimap to a single value per window.
	ViewFn *FunctionSpec `protobuf:"bytes,2,opt,name=view_fn,json=viewFn,proto3" json:"view_fn,omitempty"`
	// (Required) The FunctionSpec of the UDF that maps a main input window
	// to a side input window.
	//
	// For example, when the main input is in fixed windows of one hour, this
	// can specify that the side input should be accessed according to the day
	// in which that hour falls.
	WindowMappingFn      *FunctionSpec `protobuf:"bytes,3,opt,name=window_mapping_fn,json=windowMappingFn,proto3" json:"window_mapping_fn,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *SideInput) Reset()         { *m = SideInput{} }
func (m *SideInput) String() string { return proto.CompactTextString(m) }
func (*SideInput) ProtoMessage()    {}
func (*SideInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{33}
}

func (m *SideInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SideInput.Unmarshal(m, b)
}
func (m *SideInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SideInput.Marshal(b, m, deterministic)
}
func (m *SideInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SideInput.Merge(m, src)
}
func (m *SideInput) XXX_Size() int {
	return xxx_messageInfo_SideInput.Size(m)
}
func (m *SideInput) XXX_DiscardUnknown() {
	xxx_messageInfo_SideInput.DiscardUnknown(m)
}

var xxx_messageInfo_SideInput proto.InternalMessageInfo

func (m *SideInput) GetAccessPattern() *FunctionSpec {
	if m != nil {
		return m.AccessPattern
	}
	return nil
}

func (m *SideInput) GetViewFn() *FunctionSpec {
	if m != nil {
		return m.ViewFn
	}
	return nil
}

func (m *SideInput) GetWindowMappingFn() *FunctionSpec {
	if m != nil {
		return m.WindowMappingFn
	}
	return nil
}

type StandardArtifacts struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StandardArtifacts) Reset()         { *m = StandardArtifacts{} }
func (m *StandardArtifacts) String() string { return proto.CompactTextString(m) }
func (*StandardArtifacts) ProtoMessage()    {}
func (*StandardArtifacts) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{34}
}

func (m *StandardArtifacts) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StandardArtifacts.Unmarshal(m, b)
}
func (m *StandardArtifacts) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StandardArtifacts.Marshal(b, m, deterministic)
}
func (m *StandardArtifacts) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StandardArtifacts.Merge(m, src)
}
func (m *StandardArtifacts) XXX_Size() int {
	return xxx_messageInfo_StandardArtifacts.Size(m)
}
func (m *StandardArtifacts) XXX_DiscardUnknown() {
	xxx_messageInfo_StandardArtifacts.DiscardUnknown(m)
}

var xxx_messageInfo_StandardArtifacts proto.InternalMessageInfo

type ArtifactFilePayload struct {
	// a string for an artifact file path e.g. "/tmp/foo.jar"
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// The hex-encoded sha256 checksum of the artifact.
	Sha256               string   `protobuf:"bytes,2,opt,name=sha256,proto3" json:"sha256,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ArtifactFilePayload) Reset()         { *m = ArtifactFilePayload{} }
func (m *ArtifactFilePayload) String() string { return proto.CompactTextString(m) }
func (*ArtifactFilePayload) ProtoMessage()    {}
func (*ArtifactFilePayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{35}
}

func (m *ArtifactFilePayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ArtifactFilePayload.Unmarshal(m, b)
}
func (m *ArtifactFilePayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ArtifactFilePayload.Marshal(b, m, deterministic)
}
func (m *ArtifactFilePayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ArtifactFilePayload.Merge(m, src)
}
func (m *ArtifactFilePayload) XXX_Size() int {
	return xxx_messageInfo_ArtifactFilePayload.Size(m)
}
func (m *ArtifactFilePayload) XXX_DiscardUnknown() {
	xxx_messageInfo_ArtifactFilePayload.DiscardUnknown(m)
}

var xxx_messageInfo_ArtifactFilePayload proto.InternalMessageInfo

func (m *ArtifactFilePayload) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *ArtifactFilePayload) GetSha256() string {
	if m != nil {
		return m.Sha256
	}
	return ""
}

type ArtifactUrlPayload struct {
	// a string for an artifact URL e.g. "https://.../foo.jar" or "gs://tmp/foo.jar"
	Url                  string   `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ArtifactUrlPayload) Reset()         { *m = ArtifactUrlPayload{} }
func (m *ArtifactUrlPayload) String() string { return proto.CompactTextString(m) }
func (*ArtifactUrlPayload) ProtoMessage()    {}
func (*ArtifactUrlPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{36}
}

func (m *ArtifactUrlPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ArtifactUrlPayload.Unmarshal(m, b)
}
func (m *ArtifactUrlPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ArtifactUrlPayload.Marshal(b, m, deterministic)
}
func (m *ArtifactUrlPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ArtifactUrlPayload.Merge(m, src)
}
func (m *ArtifactUrlPayload) XXX_Size() int {
	return xxx_messageInfo_ArtifactUrlPayload.Size(m)
}
func (m *ArtifactUrlPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_ArtifactUrlPayload.DiscardUnknown(m)
}

var xxx_messageInfo_ArtifactUrlPayload proto.InternalMessageInfo

func (m *ArtifactUrlPayload) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

type EmbeddedFilePayload struct {
	// raw data bytes for an embedded artifact
	Data                 []byte   `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EmbeddedFilePayload) Reset()         { *m = EmbeddedFilePayload{} }
func (m *EmbeddedFilePayload) String() string { return proto.CompactTextString(m) }
func (*EmbeddedFilePayload) ProtoMessage()    {}
func (*EmbeddedFilePayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{37}
}

func (m *EmbeddedFilePayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EmbeddedFilePayload.Unmarshal(m, b)
}
func (m *EmbeddedFilePayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EmbeddedFilePayload.Marshal(b, m, deterministic)
}
func (m *EmbeddedFilePayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EmbeddedFilePayload.Merge(m, src)
}
func (m *EmbeddedFilePayload) XXX_Size() int {
	return xxx_messageInfo_EmbeddedFilePayload.Size(m)
}
func (m *EmbeddedFilePayload) XXX_DiscardUnknown() {
	xxx_messageInfo_EmbeddedFilePayload.DiscardUnknown(m)
}

var xxx_messageInfo_EmbeddedFilePayload proto.InternalMessageInfo

func (m *EmbeddedFilePayload) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type PyPIPayload struct {
	// Pypi compatible artifact id e.g. "apache-beam"
	ArtifactId string `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
	// Pypi compatible version string.
	Version              string   `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PyPIPayload) Reset()         { *m = PyPIPayload{} }
func (m *PyPIPayload) String() string { return proto.CompactTextString(m) }
func (*PyPIPayload) ProtoMessage()    {}
func (*PyPIPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{38}
}

func (m *PyPIPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PyPIPayload.Unmarshal(m, b)
}
func (m *PyPIPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PyPIPayload.Marshal(b, m, deterministic)
}
func (m *PyPIPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PyPIPayload.Merge(m, src)
}
func (m *PyPIPayload) XXX_Size() int {
	return xxx_messageInfo_PyPIPayload.Size(m)
}
func (m *PyPIPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_PyPIPayload.DiscardUnknown(m)
}

var xxx_messageInfo_PyPIPayload proto.InternalMessageInfo

func (m *PyPIPayload) GetArtifactId() string {
	if m != nil {
		return m.ArtifactId
	}
	return ""
}

func (m *PyPIPayload) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

type MavenPayload struct {
	// A string specifying Maven artifact.
	// The standard format is "groupId:artifactId:version[:packaging[:classifier]]"
	Artifact string `protobuf:"bytes,1,opt,name=artifact,proto3" json:"artifact,omitempty"`
	// (Optional) Repository URL. If not specified, Maven central is used by default.
	RepositoryUrl        string   `protobuf:"bytes,2,opt,name=repository_url,json=repositoryUrl,proto3" json:"repository_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MavenPayload) Reset()         { *m = MavenPayload{} }
func (m *MavenPayload) String() string { return proto.CompactTextString(m) }
func (*MavenPayload) ProtoMessage()    {}
func (*MavenPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{39}
}

func (m *MavenPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MavenPayload.Unmarshal(m, b)
}
func (m *MavenPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MavenPayload.Marshal(b, m, deterministic)
}
func (m *MavenPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MavenPayload.Merge(m, src)
}
func (m *MavenPayload) XXX_Size() int {
	return xxx_messageInfo_MavenPayload.Size(m)
}
func (m *MavenPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_MavenPayload.DiscardUnknown(m)
}

var xxx_messageInfo_MavenPayload proto.InternalMessageInfo

func (m *MavenPayload) GetArtifact() string {
	if m != nil {
		return m.Artifact
	}
	return ""
}

func (m *MavenPayload) GetRepositoryUrl() string {
	if m != nil {
		return m.RepositoryUrl
	}
	return ""
}

type DeferredArtifactPayload struct {
	// A unique string identifier assigned by the creator of this payload. The creator may use this key to confirm
	// whether they can parse the data.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Data for deferred artifacts. Interpretation of bytes is delegated to the creator of this payload.
	Data                 []byte   `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeferredArtifactPayload) Reset()         { *m = DeferredArtifactPayload{} }
func (m *DeferredArtifactPayload) String() string { return proto.CompactTextString(m) }
func (*DeferredArtifactPayload) ProtoMessage()    {}
func (*DeferredArtifactPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{40}
}

func (m *DeferredArtifactPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeferredArtifactPayload.Unmarshal(m, b)
}
func (m *DeferredArtifactPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeferredArtifactPayload.Marshal(b, m, deterministic)
}
func (m *DeferredArtifactPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeferredArtifactPayload.Merge(m, src)
}
func (m *DeferredArtifactPayload) XXX_Size() int {
	return xxx_messageInfo_DeferredArtifactPayload.Size(m)
}
func (m *DeferredArtifactPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_DeferredArtifactPayload.DiscardUnknown(m)
}

var xxx_messageInfo_DeferredArtifactPayload proto.InternalMessageInfo

func (m *DeferredArtifactPayload) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *DeferredArtifactPayload) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type ArtifactStagingToRolePayload struct {
	// A generated staged name (relative path under staging directory).
	StagedName           string   `protobuf:"bytes,1,opt,name=staged_name,json=stagedName,proto3" json:"staged_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ArtifactStagingToRolePayload) Reset()         { *m = ArtifactStagingToRolePayload{} }
func (m *ArtifactStagingToRolePayload) String() string { return proto.CompactTextString(m) }
func (*ArtifactStagingToRolePayload) ProtoMessage()    {}
func (*ArtifactStagingToRolePayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{41}
}

func (m *ArtifactStagingToRolePayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ArtifactStagingToRolePayload.Unmarshal(m, b)
}
func (m *ArtifactStagingToRolePayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ArtifactStagingToRolePayload.Marshal(b, m, deterministic)
}
func (m *ArtifactStagingToRolePayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ArtifactStagingToRolePayload.Merge(m, src)
}
func (m *ArtifactStagingToRolePayload) XXX_Size() int {
	return xxx_messageInfo_ArtifactStagingToRolePayload.Size(m)
}
func (m *ArtifactStagingToRolePayload) XXX_DiscardUnknown() {
	xxx_messageInfo_ArtifactStagingToRolePayload.DiscardUnknown(m)
}

var xxx_messageInfo_ArtifactStagingToRolePayload proto.InternalMessageInfo

func (m *ArtifactStagingToRolePayload) GetStagedName() string {
	if m != nil {
		return m.StagedName
	}
	return ""
}

type ArtifactInformation struct {
	// A URN that describes the type of artifact
	TypeUrn     string `protobuf:"bytes,1,opt,name=type_urn,json=typeUrn,proto3" json:"type_urn,omitempty"`
	TypePayload []byte `protobuf:"bytes,2,opt,name=type_payload,json=typePayload,proto3" json:"type_payload,omitempty"`
	// A URN that describes the role of artifact
	RoleUrn              string   `protobuf:"bytes,3,opt,name=role_urn,json=roleUrn,proto3" json:"role_urn,omitempty"`
	RolePayload          []byte   `protobuf:"bytes,4,opt,name=role_payload,json=rolePayload,proto3" json:"role_payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ArtifactInformation) Reset()         { *m = ArtifactInformation{} }
func (m *ArtifactInformation) String() string { return proto.CompactTextString(m) }
func (*ArtifactInformation) ProtoMessage()    {}
func (*ArtifactInformation) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{42}
}

func (m *ArtifactInformation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ArtifactInformation.Unmarshal(m, b)
}
func (m *ArtifactInformation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ArtifactInformation.Marshal(b, m, deterministic)
}
func (m *ArtifactInformation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ArtifactInformation.Merge(m, src)
}
func (m *ArtifactInformation) XXX_Size() int {
	return xxx_messageInfo_ArtifactInformation.Size(m)
}
func (m *ArtifactInformation) XXX_DiscardUnknown() {
	xxx_messageInfo_ArtifactInformation.DiscardUnknown(m)
}

var xxx_messageInfo_ArtifactInformation proto.InternalMessageInfo

func (m *ArtifactInformation) GetTypeUrn() string {
	if m != nil {
		return m.TypeUrn
	}
	return ""
}

func (m *ArtifactInformation) GetTypePayload() []byte {
	if m != nil {
		return m.TypePayload
	}
	return nil
}

func (m *ArtifactInformation) GetRoleUrn() string {
	if m != nil {
		return m.RoleUrn
	}
	return ""
}

func (m *ArtifactInformation) GetRolePayload() []byte {
	if m != nil {
		return m.RolePayload
	}
	return nil
}

// An environment for executing UDFs. By default, an SDK container URL, but
// can also be a process forked by a command, or an externally managed process.
type Environment struct {
	// (Required) The URN of the payload
	Urn string `protobuf:"bytes,2,opt,name=urn,proto3" json:"urn,omitempty"`
	// (Optional) The data specifying any parameters to the URN. If
	// the URN does not require any arguments, this may be omitted.
	Payload []byte `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	// (Optional) Static display data for the environment. If there is none,
	// it may be omitted.
	DisplayData []*DisplayData `protobuf:"bytes,4,rep,name=display_data,json=displayData,proto3" json:"display_data,omitempty"`
	// (Optional) A set of capabilities this environment supports. This is
	// typically a list of common URNs designating coders, transforms, etc. that
	// this environment understands (and a runner MAY use) despite not
	// appearing in the pipeline proto. This may also be used to indicate
	// support of optional protocols not tied to a concrete component.
	Capabilities []string `protobuf:"bytes,5,rep,name=capabilities,proto3" json:"capabilities,omitempty"`
	// (Optional) artifact dependency information used for executing UDFs in this environment.
	Dependencies         []*ArtifactInformation `protobuf:"bytes,6,rep,name=dependencies,proto3" json:"dependencies,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *Environment) Reset()         { *m = Environment{} }
func (m *Environment) String() string { return proto.CompactTextString(m) }
func (*Environment) ProtoMessage()    {}
func (*Environment) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{43}
}

func (m *Environment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Environment.Unmarshal(m, b)
}
func (m *Environment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Environment.Marshal(b, m, deterministic)
}
func (m *Environment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Environment.Merge(m, src)
}
func (m *Environment) XXX_Size() int {
	return xxx_messageInfo_Environment.Size(m)
}
func (m *Environment) XXX_DiscardUnknown() {
	xxx_messageInfo_Environment.DiscardUnknown(m)
}

var xxx_messageInfo_Environment proto.InternalMessageInfo

func (m *Environment) GetUrn() string {
	if m != nil {
		return m.Urn
	}
	return ""
}

func (m *Environment) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *Environment) GetDisplayData() []*DisplayData {
	if m != nil {
		return m.DisplayData
	}
	return nil
}

func (m *Environment) GetCapabilities() []string {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

func (m *Environment) GetDependencies() []*ArtifactInformation {
	if m != nil {
		return m.Dependencies
	}
	return nil
}

type StandardEnvironments struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StandardEnvironments) Reset()         { *m = StandardEnvironments{} }
func (m *StandardEnvironments) String() string { return proto.CompactTextString(m) }
func (*StandardEnvironments) ProtoMessage()    {}
func (*StandardEnvironments) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{44}
}

func (m *StandardEnvironments) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StandardEnvironments.Unmarshal(m, b)
}
func (m *StandardEnvironments) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StandardEnvironments.Marshal(b, m, deterministic)
}
func (m *StandardEnvironments) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StandardEnvironments.Merge(m, src)
}
func (m *StandardEnvironments) XXX_Size() int {
	return xxx_messageInfo_StandardEnvironments.Size(m)
}
func (m *StandardEnvironments) XXX_DiscardUnknown() {
	xxx_messageInfo_StandardEnvironments.DiscardUnknown(m)
}

var xxx_messageInfo_StandardEnvironments proto.InternalMessageInfo

// The payload of a Docker image
type DockerPayload struct {
	ContainerImage       string   `protobuf:"bytes,1,opt,name=container_image,json=containerImage,proto3" json:"container_image,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DockerPayload) Reset()         { *m = DockerPayload{} }
func (m *DockerPayload) String() string { return proto.CompactTextString(m) }
func (*DockerPayload) ProtoMessage()    {}
func (*DockerPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{45}
}

func (m *DockerPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DockerPayload.Unmarshal(m, b)
}
func (m *DockerPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DockerPayload.Marshal(b, m, deterministic)
}
func (m *DockerPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DockerPayload.Merge(m, src)
}
func (m *DockerPayload) XXX_Size() int {
	return xxx_messageInfo_DockerPayload.Size(m)
}
func (m *DockerPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_DockerPayload.DiscardUnknown(m)
}

var xxx_messageInfo_DockerPayload proto.InternalMessageInfo

func (m *DockerPayload) GetContainerImage() string {
	if m != nil {
		return m.ContainerImage
	}
	return ""
}

type ProcessPayload struct {
	Os                   string            `protobuf:"bytes,1,opt,name=os,proto3" json:"os,omitempty"`
	Arch                 string            `protobuf:"bytes,2,opt,name=arch,proto3" json:"arch,omitempty"`
	Command              string            `protobuf:"bytes,3,opt,name=command,proto3" json:"command,omitempty"`
	Env                  map[string]string `protobuf:"bytes,4,rep,name=env,proto3" json:"env,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ProcessPayload) Reset()         { *m = ProcessPayload{} }
func (m *ProcessPayload) String() string { return proto.CompactTextString(m) }
func (*ProcessPayload) ProtoMessage()    {}
func (*ProcessPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{46}
}

func (m *ProcessPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessPayload.Unmarshal(m, b)
}
func (m *ProcessPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessPayload.Marshal(b, m, deterministic)
}
func (m *ProcessPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessPayload.Merge(m, src)
}
func (m *ProcessPayload) XXX_Size() int {
	return xxx_messageInfo_ProcessPayload.Size(m)
}
func (m *ProcessPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessPayload.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessPayload proto.InternalMessageInfo

func (m *ProcessPayload) GetOs() string {
	if m != nil {
		return m.Os
	}
	return ""
}

func (m *ProcessPayload) GetArch() string {
	if m != nil {
		return m.Arch
	}
	return ""
}

func (m *ProcessPayload) GetCommand() string {
	if m != nil {
		return m.Command
	}
	return ""
}

func (m *ProcessPayload) GetEnv() map[string]string {
	if m != nil {
		return m.Env
	}
	return nil
}

type ExternalPayload struct {
	Endpoint             *ApiServiceDescriptor `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	Params               map[string]string     `protobuf:"bytes,2,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExternalPayload) Reset()         { *m = ExternalPayload{} }
func (m *ExternalPayload) String() string { return proto.CompactTextString(m) }
func (*ExternalPayload) ProtoMessage()    {}
func (*ExternalPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{47}
}

func (m *ExternalPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExternalPayload.Unmarshal(m, b)
}
func (m *ExternalPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExternalPayload.Marshal(b, m, deterministic)
}
func (m *ExternalPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalPayload.Merge(m, src)
}
func (m *ExternalPayload) XXX_Size() int {
	return xxx_messageInfo_ExternalPayload.Size(m)
}
func (m *ExternalPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalPayload.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalPayload proto.InternalMessageInfo

func (m *ExternalPayload) GetEndpoint() *ApiServiceDescriptor {
	if m != nil {
		return m.Endpoint
	}
	return nil
}

func (m *ExternalPayload) GetParams() map[string]string {
	if m != nil {
		return m.Params
	}
	return nil
}

// These URNs are used to indicate capabilities of environments that cannot
// simply be expressed as a component (such as a Coder or PTransform) that this
// environment understands.
type StandardProtocols struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StandardProtocols) Reset()         { *m = StandardProtocols{} }
func (m *StandardProtocols) String() string { return proto.CompactTextString(m) }
func (*StandardProtocols) ProtoMessage()    {}
func (*StandardProtocols) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{48}
}

func (m *StandardProtocols) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StandardProtocols.Unmarshal(m, b)
}
func (m *StandardProtocols) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StandardProtocols.Marshal(b, m, deterministic)
}
func (m *StandardProtocols) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StandardProtocols.Merge(m, src)
}
func (m *StandardProtocols) XXX_Size() int {
	return xxx_messageInfo_StandardProtocols.Size(m)
}
func (m *StandardProtocols) XXX_DiscardUnknown() {
	xxx_messageInfo_StandardProtocols.DiscardUnknown(m)
}

var xxx_messageInfo_StandardProtocols proto.InternalMessageInfo

// These URNs are used to indicate requirements of a pipeline that cannot
// simply be expressed as a component (such as a Coder or PTransform) that the
// runner must understand. In many cases, this indicates a particular field
// of a transform must be inspected and respected (which allows new fields
// to be added in a forwards-compatible way).
type StandardRequirements struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StandardRequirements) Reset()         { *m = StandardRequirements{} }
func (m *StandardRequirements) String() string { return proto.CompactTextString(m) }
func (*StandardRequirements) ProtoMessage()    {}
func (*StandardRequirements) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{49}
}

func (m *StandardRequirements) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StandardRequirements.Unmarshal(m, b)
}
func (m *StandardRequirements) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StandardRequirements.Marshal(b, m, deterministic)
}
func (m *StandardRequirements) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StandardRequirements.Merge(m, src)
}
func (m *StandardRequirements) XXX_Size() int {
	return xxx_messageInfo_StandardRequirements.Size(m)
}
func (m *StandardRequirements) XXX_DiscardUnknown() {
	xxx_messageInfo_StandardRequirements.DiscardUnknown(m)
}

var xxx_messageInfo_StandardRequirements proto.InternalMessageInfo

// A URN along with a parameter object whose schema is determined by the
// URN.
//
// This structure is reused in two distinct, but compatible, ways:
//
// 1. This can be a specification of the function over PCollections
//    that a PTransform computes.
// 2. This can be a specification of a user-defined function, possibly
//    SDK-specific. (external to this message must be adequate context
//    to indicate the environment in which the UDF can be understood).
//
// Though not explicit in this proto, there are two possibilities
// for the relationship of a runner to this specification that
// one should bear in mind:
//
// 1. The runner understands the URN. For example, it might be
//    a well-known URN like "beam:transform:Top" or
//    "beam:window_fn:FixedWindows" with
//    an agreed-upon payload (e.g. a number or duration,
//    respectively).
// 2. The runner does not understand the URN. It might be an
//    SDK specific URN such as "beam:dofn:javasdk:1.0"
//    that indicates to the SDK what the payload is,
//    such as a serialized Java DoFn from a particular
//    version of the Beam Java SDK. The payload will often
//    then be an opaque message such as bytes in a
//    language-specific serialization format.
type FunctionSpec struct {
	// (Required) A URN that describes the accompanying payload.
	// For any URN that is not recognized (by whomever is inspecting
	// it) the parameter payload should be treated as opaque and
	// passed as-is.
	Urn string `protobuf:"bytes,1,opt,name=urn,proto3" json:"urn,omitempty"`
	// (Optional) The data specifying any parameters to the URN. If
	// the URN does not require any arguments, this may be omitted.
	Payload              []byte   `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FunctionSpec) Reset()         { *m = FunctionSpec{} }
func (m *FunctionSpec) String() string { return proto.CompactTextString(m) }
func (*FunctionSpec) ProtoMessage()    {}
func (*FunctionSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{50}
}

func (m *FunctionSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FunctionSpec.Unmarshal(m, b)
}
func (m *FunctionSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FunctionSpec.Marshal(b, m, deterministic)
}
func (m *FunctionSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FunctionSpec.Merge(m, src)
}
func (m *FunctionSpec) XXX_Size() int {
	return xxx_messageInfo_FunctionSpec.Size(m)
}
func (m *FunctionSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_FunctionSpec.DiscardUnknown(m)
}

var xxx_messageInfo_FunctionSpec proto.InternalMessageInfo

func (m *FunctionSpec) GetUrn() string {
	if m != nil {
		return m.Urn
	}
	return ""
}

func (m *FunctionSpec) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

// A set of well known URNs describing display data.
//
// All descriptions must contain how the value should be classified and how it
// is encoded. Note that some types are logical types which convey contextual
// information about the pipeline in addition to an encoding while others only
// specify the encoding itself.
type StandardDisplayData struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StandardDisplayData) Reset()         { *m = StandardDisplayData{} }
func (m *StandardDisplayData) String() string { return proto.CompactTextString(m) }
func (*StandardDisplayData) ProtoMessage()    {}
func (*StandardDisplayData) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{51}
}

func (m *StandardDisplayData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StandardDisplayData.Unmarshal(m, b)
}
func (m *StandardDisplayData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StandardDisplayData.Marshal(b, m, deterministic)
}
func (m *StandardDisplayData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StandardDisplayData.Merge(m, src)
}
func (m *StandardDisplayData) XXX_Size() int {
	return xxx_messageInfo_StandardDisplayData.Size(m)
}
func (m *StandardDisplayData) XXX_DiscardUnknown() {
	xxx_messageInfo_StandardDisplayData.DiscardUnknown(m)
}

var xxx_messageInfo_StandardDisplayData proto.InternalMessageInfo

type LabelledStringPayload struct {
	// (Required) A human readable label for the value.
	Label string `protobuf:"bytes,1,opt,name=label,proto3" json:"label,omitempty"`
	// (Required) A value which will be displayed to the user. The urn describes
	// how the value can be interpreted and/or categorized.
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelledStringPayload) Reset()         { *m = LabelledStringPayload{} }
func (m *LabelledStringPayload) String() string { return proto.CompactTextString(m) }
func (*LabelledStringPayload) ProtoMessage()    {}
func (*LabelledStringPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{52}
}

func (m *LabelledStringPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelledStringPayload.Unmarshal(m, b)
}
func (m *LabelledStringPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelledStringPayload.Marshal(b, m, deterministic)
}
func (m *LabelledStringPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelledStringPayload.Merge(m, src)
}
func (m *LabelledStringPayload) XXX_Size() int {
	return xxx_messageInfo_LabelledStringPayload.Size(m)
}
func (m *LabelledStringPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelledStringPayload.DiscardUnknown(m)
}

var xxx_messageInfo_LabelledStringPayload proto.InternalMessageInfo

func (m *LabelledStringPayload) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *LabelledStringPayload) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// Static display data associated with a pipeline component. Display data is
// useful for pipeline runners IOs and diagnostic dashboards to display details
// about annotated components.
type DisplayData struct {
	// A key used to describe the type of display data. See StandardDisplayData
	// for the set of well known urns describing how the payload is meant to be
	// interpreted.
	Urn string `protobuf:"bytes,1,opt,name=urn,proto3" json:"urn,omitempty"`
	// (Optional) The data specifying any parameters to the URN. If
	// the URN does not require any arguments, this may be omitted.
	Payload              []byte   `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DisplayData) Reset()         { *m = DisplayData{} }
func (m *DisplayData) String() string { return proto.CompactTextString(m) }
func (*DisplayData) ProtoMessage()    {}
func (*DisplayData) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{53}
}

func (m *DisplayData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DisplayData.Unmarshal(m, b)
}
func (m *DisplayData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DisplayData.Marshal(b, m, deterministic)
}
func (m *DisplayData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DisplayData.Merge(m, src)
}
func (m *DisplayData) XXX_Size() int {
	return xxx_messageInfo_DisplayData.Size(m)
}
func (m *DisplayData) XXX_DiscardUnknown() {
	xxx_messageInfo_DisplayData.DiscardUnknown(m)
}

var xxx_messageInfo_DisplayData proto.InternalMessageInfo

func (m *DisplayData) GetUrn() string {
	if m != nil {
		return m.Urn
	}
	return ""
}

func (m *DisplayData) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

// A disjoint union of all the things that may contain references
// that require Components to resolve.
type MessageWithComponents struct {
	// (Optional) The by-reference components of the root message,
	// enabling a standalone message.
	//
	// If this is absent, it is expected that there are no
	// references.
	Components *Components `protobuf:"bytes,1,opt,name=components,proto3" json:"components,omitempty"`
	// (Required) The root message that may contain pointers
	// that should be resolved by looking inside components.
	//
	// Types that are valid to be assigned to Root:
	//	*MessageWithComponents_Coder
	//	*MessageWithComponents_CombinePayload
	//	*MessageWithComponents_FunctionSpec
	//	*MessageWithComponents_ParDoPayload
	//	*MessageWithComponents_Ptransform
	//	*MessageWithComponents_Pcollection
	//	*MessageWithComponents_ReadPayload
	//	*MessageWithComponents_SideInput
	//	*MessageWithComponents_WindowIntoPayload
	//	*MessageWithComponents_WindowingStrategy
	Root                 isMessageWithComponents_Root `protobuf_oneof:"root"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *MessageWithComponents) Reset()         { *m = MessageWithComponents{} }
func (m *MessageWithComponents) String() string { return proto.CompactTextString(m) }
func (*MessageWithComponents) ProtoMessage()    {}
func (*MessageWithComponents) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{54}
}

func (m *MessageWithComponents) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MessageWithComponents.Unmarshal(m, b)
}
func (m *MessageWithComponents) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MessageWithComponents.Marshal(b, m, deterministic)
}
func (m *MessageWithComponents) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MessageWithComponents.Merge(m, src)
}
func (m *MessageWithComponents) XXX_Size() int {
	return xxx_messageInfo_MessageWithComponents.Size(m)
}
func (m *MessageWithComponents) XXX_DiscardUnknown() {
	xxx_messageInfo_MessageWithComponents.DiscardUnknown(m)
}

var xxx_messageInfo_MessageWithComponents proto.InternalMessageInfo

func (m *MessageWithComponents) GetComponents() *Components {
	if m != nil {
		return m.Components
	}
	return nil
}

type isMessageWithComponents_Root interface {
	isMessageWithComponents_Root()
}

type MessageWithComponents_Coder struct {
	Coder *Coder `protobuf:"bytes,2,opt,name=coder,proto3,oneof"`
}

type MessageWithComponents_CombinePayload struct {
	CombinePayload *CombinePayload `protobuf:"bytes,3,opt,name=combine_payload,json=combinePayload,proto3,oneof"`
}

type MessageWithComponents_FunctionSpec struct {
	FunctionSpec *FunctionSpec `protobuf:"bytes,4,opt,name=function_spec,json=functionSpec,proto3,oneof"`
}

type MessageWithComponents_ParDoPayload struct {
	ParDoPayload *ParDoPayload `protobuf:"bytes,6,opt,name=par_do_payload,json=parDoPayload,proto3,oneof"`
}

type MessageWithComponents_Ptransform struct {
	Ptransform *PTransform `protobuf:"bytes,7,opt,name=ptransform,proto3,oneof"`
}

type MessageWithComponents_Pcollection struct {
	Pcollection *PCollection `protobuf:"bytes,8,opt,name=pcollection,proto3,oneof"`
}

type MessageWithComponents_ReadPayload struct {
	ReadPayload *ReadPayload `protobuf:"bytes,9,opt,name=read_payload,json=readPayload,proto3,oneof"`
}

type MessageWithComponents_SideInput struct {
	SideInput *SideInput `protobuf:"bytes,11,opt,name=side_input,json=sideInput,proto3,oneof"`
}

type MessageWithComponents_WindowIntoPayload struct {
	WindowIntoPayload *WindowIntoPayload `protobuf:"bytes,12,opt,name=window_into_payload,json=windowIntoPayload,proto3,oneof"`
}

type MessageWithComponents_WindowingStrategy struct {
	WindowingStrategy *WindowingStrategy `protobuf:"bytes,13,opt,name=windowing_strategy,json=windowingStrategy,proto3,oneof"`
}

func (*MessageWithComponents_Coder) isMessageWithComponents_Root() {}

func (*MessageWithComponents_CombinePayload) isMessageWithComponents_Root() {}

func (*MessageWithComponents_FunctionSpec) isMessageWithComponents_Root() {}

func (*MessageWithComponents_ParDoPayload) isMessageWithComponents_Root() {}

func (*MessageWithComponents_Ptransform) isMessageWithComponents_Root() {}

func (*MessageWithComponents_Pcollection) isMessageWithComponents_Root() {}

func (*MessageWithComponents_ReadPayload) isMessageWithComponents_Root() {}

func (*MessageWithComponents_SideInput) isMessageWithComponents_Root() {}

func (*MessageWithComponents_WindowIntoPayload) isMessageWithComponents_Root() {}

func (*MessageWithComponents_WindowingStrategy) isMessageWithComponents_Root() {}

func (m *MessageWithComponents) GetRoot() isMessageWithComponents_Root {
	if m != nil {
		return m.Root
	}
	return nil
}

func (m *MessageWithComponents) GetCoder() *Coder {
	if x, ok := m.GetRoot().(*MessageWithComponents_Coder); ok {
		return x.Coder
	}
	return nil
}

func (m *MessageWithComponents) GetCombinePayload() *CombinePayload {
	if x, ok := m.GetRoot().(*MessageWithComponents_CombinePayload); ok {
		return x.CombinePayload
	}
	return nil
}

func (m *MessageWithComponents) GetFunctionSpec() *FunctionSpec {
	if x, ok := m.GetRoot().(*MessageWithComponents_FunctionSpec); ok {
		return x.FunctionSpec
	}
	return nil
}

func (m *MessageWithComponents) GetParDoPayload() *ParDoPayload {
	if x, ok := m.GetRoot().(*MessageWithComponents_ParDoPayload); ok {
		return x.ParDoPayload
	}
	return nil
}

func (m *MessageWithComponents) GetPtransform() *PTransform {
	if x, ok := m.GetRoot().(*MessageWithComponents_Ptransform); ok {
		return x.Ptransform
	}
	return nil
}

func (m *MessageWithComponents) GetPcollection() *PCollection {
	if x, ok := m.GetRoot().(*MessageWithComponents_Pcollection); ok {
		return x.Pcollection
	}
	return nil
}

func (m *MessageWithComponents) GetReadPayload() *ReadPayload {
	if x, ok := m.GetRoot().(*MessageWithComponents_ReadPayload); ok {
		return x.ReadPayload
	}
	return nil
}

func (m *MessageWithComponents) GetSideInput() *SideInput {
	if x, ok := m.GetRoot().(*MessageWithComponents_SideInput); ok {
		return x.SideInput
	}
	return nil
}

func (m *MessageWithComponents) GetWindowIntoPayload() *WindowIntoPayload {
	if x, ok := m.GetRoot().(*MessageWithComponents_WindowIntoPayload); ok {
		return x.WindowIntoPayload
	}
	return nil
}

func (m *MessageWithComponents) GetWindowingStrategy() *WindowingStrategy {
	if x, ok := m.GetRoot().(*MessageWithComponents_WindowingStrategy); ok {
		return x.WindowingStrategy
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*MessageWithComponents) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*MessageWithComponents_Coder)(nil),
		(*MessageWithComponents_CombinePayload)(nil),
		(*MessageWithComponents_FunctionSpec)(nil),
		(*MessageWithComponents_ParDoPayload)(nil),
		(*MessageWithComponents_Ptransform)(nil),
		(*MessageWithComponents_Pcollection)(nil),
		(*MessageWithComponents_ReadPayload)(nil),
		(*MessageWithComponents_SideInput)(nil),
		(*MessageWithComponents_WindowIntoPayload)(nil),
		(*MessageWithComponents_WindowingStrategy)(nil),
	}
}

// The payload for an executable stage. This will eventually be passed to an SDK in the form of a
// ProcessBundleDescriptor.
type ExecutableStagePayload struct {
	// (Required) Environment in which this stage executes.
	//
	// We use an environment rather than environment id
	// because ExecutableStages use environments directly. This may change in the future.
	Environment *Environment `protobuf:"bytes,1,opt,name=environment,proto3" json:"environment,omitempty"`
	// The wire coder settings of this executable stage
	WireCoderSettings []*ExecutableStagePayload_WireCoderSetting `protobuf:"bytes,9,rep,name=wire_coder_settings,json=wireCoderSettings,proto3" json:"wire_coder_settings,omitempty"`
	// (Required) Input PCollection id. This must be present as a value in the inputs of any
	// PTransform the ExecutableStagePayload is the payload of.
	Input string `protobuf:"bytes,2,opt,name=input,proto3" json:"input,omitempty"`
	// The side inputs required for this executable stage. Each side input of each PTransform within
	// this ExecutableStagePayload must be represented within this field.
	SideInputs []*ExecutableStagePayload_SideInputId `protobuf:"bytes,3,rep,name=side_inputs,json=sideInputs,proto3" json:"side_inputs,omitempty"`
	// PTransform ids contained within this executable stage. This must contain at least one
	// PTransform id.
	Transforms []string `protobuf:"bytes,4,rep,name=transforms,proto3" json:"transforms,omitempty"`
	// Output PCollection ids. This must be equal to the values of the outputs of any
	// PTransform the ExecutableStagePayload is the payload of.
	Outputs []string `protobuf:"bytes,5,rep,name=outputs,proto3" json:"outputs,omitempty"`
	// (Required) The components for the Executable Stage. This must contain all of the Transforms
	// in transforms, and the closure of all of the components they recognize.
	Components *Components `protobuf:"bytes,6,opt,name=components,proto3" json:"components,omitempty"`
	// The user states required for this executable stage. Each user state of each PTransform within
	// this ExecutableStagePayload must be represented within this field.
	UserStates []*ExecutableStagePayload_UserStateId `protobuf:"bytes,7,rep,name=user_states,json=userStates,proto3" json:"user_states,omitempty"`
	// The timers required for this executable stage. Each timer of each PTransform within
	// this ExecutableStagePayload must be represented within this field.
	Timers []*ExecutableStagePayload_TimerId `protobuf:"bytes,8,rep,name=timers,proto3" json:"timers,omitempty"`
	// The timerfamilies required for this executable stage. Each timer familyof each PTransform within
	// this ExecutableStagePayload must be represented within this field.
	TimerFamilies        []*ExecutableStagePayload_TimerFamilyId `protobuf:"bytes,10,rep,name=timerFamilies,proto3" json:"timerFamilies,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *ExecutableStagePayload) Reset()         { *m = ExecutableStagePayload{} }
func (m *ExecutableStagePayload) String() string { return proto.CompactTextString(m) }
func (*ExecutableStagePayload) ProtoMessage()    {}
func (*ExecutableStagePayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{55}
}

func (m *ExecutableStagePayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecutableStagePayload.Unmarshal(m, b)
}
func (m *ExecutableStagePayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecutableStagePayload.Marshal(b, m, deterministic)
}
func (m *ExecutableStagePayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecutableStagePayload.Merge(m, src)
}
func (m *ExecutableStagePayload) XXX_Size() int {
	return xxx_messageInfo_ExecutableStagePayload.Size(m)
}
func (m *ExecutableStagePayload) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecutableStagePayload.DiscardUnknown(m)
}

var xxx_messageInfo_ExecutableStagePayload proto.InternalMessageInfo

func (m *ExecutableStagePayload) GetEnvironment() *Environment {
	if m != nil {
		return m.Environment
	}
	return nil
}

func (m *ExecutableStagePayload) GetWireCoderSettings() []*ExecutableStagePayload_WireCoderSetting {
	if m != nil {
		return m.WireCoderSettings
	}
	return nil
}

func (m *ExecutableStagePayload) GetInput() string {
	if m != nil {
		return m.Input
	}
	return ""
}

func (m *ExecutableStagePayload) GetSideInputs() []*ExecutableStagePayload_SideInputId {
	if m != nil {
		return m.SideInputs
	}
	return nil
}

func (m *ExecutableStagePayload) GetTransforms() []string {
	if m != nil {
		return m.Transforms
	}
	return nil
}

func (m *ExecutableStagePayload) GetOutputs() []string {
	if m != nil {
		return m.Outputs
	}
	return nil
}

func (m *ExecutableStagePayload) GetComponents() *Components {
	if m != nil {
		return m.Components
	}
	return nil
}

func (m *ExecutableStagePayload) GetUserStates() []*ExecutableStagePayload_UserStateId {
	if m != nil {
		return m.UserStates
	}
	return nil
}

func (m *ExecutableStagePayload) GetTimers() []*ExecutableStagePayload_TimerId {
	if m != nil {
		return m.Timers
	}
	return nil
}

func (m *ExecutableStagePayload) GetTimerFamilies() []*ExecutableStagePayload_TimerFamilyId {
	if m != nil {
		return m.TimerFamilies
	}
	return nil
}

// A reference to a side input. Side inputs are uniquely identified by PTransform id and
// local name.
type ExecutableStagePayload_SideInputId struct {
	// (Required) The id of the PTransform that references this side input.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The local name of this side input from the PTransform that references it.
	LocalName            string   `protobuf:"bytes,2,opt,name=local_name,json=localName,proto3" json:"local_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecutableStagePayload_SideInputId) Reset()         { *m = ExecutableStagePayload_SideInputId{} }
func (m *ExecutableStagePayload_SideInputId) String() string { return proto.CompactTextString(m) }
func (*ExecutableStagePayload_SideInputId) ProtoMessage()    {}
func (*ExecutableStagePayload_SideInputId) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{55, 0}
}

func (m *ExecutableStagePayload_SideInputId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecutableStagePayload_SideInputId.Unmarshal(m, b)
}
func (m *ExecutableStagePayload_SideInputId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecutableStagePayload_SideInputId.Marshal(b, m, deterministic)
}
func (m *ExecutableStagePayload_SideInputId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecutableStagePayload_SideInputId.Merge(m, src)
}
func (m *ExecutableStagePayload_SideInputId) XXX_Size() int {
	return xxx_messageInfo_ExecutableStagePayload_SideInputId.Size(m)
}
func (m *ExecutableStagePayload_SideInputId) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecutableStagePayload_SideInputId.DiscardUnknown(m)
}

var xxx_messageInfo_ExecutableStagePayload_SideInputId proto.InternalMessageInfo

func (m *ExecutableStagePayload_SideInputId) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *ExecutableStagePayload_SideInputId) GetLocalName() string {
	if m != nil {
		return m.LocalName
	}
	return ""
}

// A reference to user state. User states are uniquely identified by PTransform id and
// local name.
type ExecutableStagePayload_UserStateId struct {
	// (Required) The id of the PTransform that references this user state.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The local name of this user state for the PTransform that references it.
	LocalName            string   `protobuf:"bytes,2,opt,name=local_name,json=localName,proto3" json:"local_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecutableStagePayload_UserStateId) Reset()         { *m = ExecutableStagePayload_UserStateId{} }
func (m *ExecutableStagePayload_UserStateId) String() string { return proto.CompactTextString(m) }
func (*ExecutableStagePayload_UserStateId) ProtoMessage()    {}
func (*ExecutableStagePayload_UserStateId) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{55, 1}
}

func (m *ExecutableStagePayload_UserStateId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecutableStagePayload_UserStateId.Unmarshal(m, b)
}
func (m *ExecutableStagePayload_UserStateId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecutableStagePayload_UserStateId.Marshal(b, m, deterministic)
}
func (m *ExecutableStagePayload_UserStateId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecutableStagePayload_UserStateId.Merge(m, src)
}
func (m *ExecutableStagePayload_UserStateId) XXX_Size() int {
	return xxx_messageInfo_ExecutableStagePayload_UserStateId.Size(m)
}
func (m *ExecutableStagePayload_UserStateId) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecutableStagePayload_UserStateId.DiscardUnknown(m)
}

var xxx_messageInfo_ExecutableStagePayload_UserStateId proto.InternalMessageInfo

func (m *ExecutableStagePayload_UserStateId) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *ExecutableStagePayload_UserStateId) GetLocalName() string {
	if m != nil {
		return m.LocalName
	}
	return ""
}

// A reference to a timer. Timers are uniquely identified by PTransform id and
// local name.
type ExecutableStagePayload_TimerId struct {
	// (Required) The id of the PTransform that references this timer.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The local name of this timer for the PTransform that references it.
	LocalName            string   `protobuf:"bytes,2,opt,name=local_name,json=localName,proto3" json:"local_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecutableStagePayload_TimerId) Reset()         { *m = ExecutableStagePayload_TimerId{} }
func (m *ExecutableStagePayload_TimerId) String() string { return proto.CompactTextString(m) }
func (*ExecutableStagePayload_TimerId) ProtoMessage()    {}
func (*ExecutableStagePayload_TimerId) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{55, 2}
}

func (m *ExecutableStagePayload_TimerId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecutableStagePayload_TimerId.Unmarshal(m, b)
}
func (m *ExecutableStagePayload_TimerId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecutableStagePayload_TimerId.Marshal(b, m, deterministic)
}
func (m *ExecutableStagePayload_TimerId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecutableStagePayload_TimerId.Merge(m, src)
}
func (m *ExecutableStagePayload_TimerId) XXX_Size() int {
	return xxx_messageInfo_ExecutableStagePayload_TimerId.Size(m)
}
func (m *ExecutableStagePayload_TimerId) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecutableStagePayload_TimerId.DiscardUnknown(m)
}

var xxx_messageInfo_ExecutableStagePayload_TimerId proto.InternalMessageInfo

func (m *ExecutableStagePayload_TimerId) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *ExecutableStagePayload_TimerId) GetLocalName() string {
	if m != nil {
		return m.LocalName
	}
	return ""
}

// A reference to a timer. Timers are uniquely identified by PTransform id and
// local name.
type ExecutableStagePayload_TimerFamilyId struct {
	// (Required) The id of the PTransform that references this timer family.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The local name of this timer family for the PTransform that references it.
	LocalName            string   `protobuf:"bytes,2,opt,name=local_name,json=localName,proto3" json:"local_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecutableStagePayload_TimerFamilyId) Reset()         { *m = ExecutableStagePayload_TimerFamilyId{} }
func (m *ExecutableStagePayload_TimerFamilyId) String() string { return proto.CompactTextString(m) }
func (*ExecutableStagePayload_TimerFamilyId) ProtoMessage()    {}
func (*ExecutableStagePayload_TimerFamilyId) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{55, 3}
}

func (m *ExecutableStagePayload_TimerFamilyId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecutableStagePayload_TimerFamilyId.Unmarshal(m, b)
}
func (m *ExecutableStagePayload_TimerFamilyId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecutableStagePayload_TimerFamilyId.Marshal(b, m, deterministic)
}
func (m *ExecutableStagePayload_TimerFamilyId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecutableStagePayload_TimerFamilyId.Merge(m, src)
}
func (m *ExecutableStagePayload_TimerFamilyId) XXX_Size() int {
	return xxx_messageInfo_ExecutableStagePayload_TimerFamilyId.Size(m)
}
func (m *ExecutableStagePayload_TimerFamilyId) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecutableStagePayload_TimerFamilyId.DiscardUnknown(m)
}

var xxx_messageInfo_ExecutableStagePayload_TimerFamilyId proto.InternalMessageInfo

func (m *ExecutableStagePayload_TimerFamilyId) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *ExecutableStagePayload_TimerFamilyId) GetLocalName() string {
	if m != nil {
		return m.LocalName
	}
	return ""
}

// Settings that decide the coder type of wire coder.
type ExecutableStagePayload_WireCoderSetting struct {
	// (Required) The URN of the wire coder.
	// Note that only windowed value coder or parameterized windowed value coder are supported.
	Urn string `protobuf:"bytes,1,opt,name=urn,proto3" json:"urn,omitempty"`
	// (Optional) The data specifying any parameters to the URN. If
	// the URN is beam:coder:windowed_value:v1, this may be omitted. If the URN is
	// beam:coder:param_windowed_value:v1, the payload is an encoded windowed
	// value using the beam:coder:windowed_value:v1 coder parameterized by
	// a beam:coder:bytes:v1 element coder and the window coder that this
	// param_windowed_value coder uses.
	Payload []byte `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	// (Required) The target(PCollection or Timer) this setting applies to.
	//
	// Types that are valid to be assigned to Target:
	//	*ExecutableStagePayload_WireCoderSetting_InputOrOutputId
	//	*ExecutableStagePayload_WireCoderSetting_Timer
	Target               isExecutableStagePayload_WireCoderSetting_Target `protobuf_oneof:"target"`
	XXX_NoUnkeyedLiteral struct{}                                         `json:"-"`
	XXX_unrecognized     []byte                                           `json:"-"`
	XXX_sizecache        int32                                            `json:"-"`
}

func (m *ExecutableStagePayload_WireCoderSetting) Reset() {
	*m = ExecutableStagePayload_WireCoderSetting{}
}
func (m *ExecutableStagePayload_WireCoderSetting) String() string { return proto.CompactTextString(m) }
func (*ExecutableStagePayload_WireCoderSetting) ProtoMessage()    {}
func (*ExecutableStagePayload_WireCoderSetting) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{55, 4}
}

func (m *ExecutableStagePayload_WireCoderSetting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecutableStagePayload_WireCoderSetting.Unmarshal(m, b)
}
func (m *ExecutableStagePayload_WireCoderSetting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecutableStagePayload_WireCoderSetting.Marshal(b, m, deterministic)
}
func (m *ExecutableStagePayload_WireCoderSetting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecutableStagePayload_WireCoderSetting.Merge(m, src)
}
func (m *ExecutableStagePayload_WireCoderSetting) XXX_Size() int {
	return xxx_messageInfo_ExecutableStagePayload_WireCoderSetting.Size(m)
}
func (m *ExecutableStagePayload_WireCoderSetting) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecutableStagePayload_WireCoderSetting.DiscardUnknown(m)
}

var xxx_messageInfo_ExecutableStagePayload_WireCoderSetting proto.InternalMessageInfo

func (m *ExecutableStagePayload_WireCoderSetting) GetUrn() string {
	if m != nil {
		return m.Urn
	}
	return ""
}

func (m *ExecutableStagePayload_WireCoderSetting) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

type isExecutableStagePayload_WireCoderSetting_Target interface {
	isExecutableStagePayload_WireCoderSetting_Target()
}

type ExecutableStagePayload_WireCoderSetting_InputOrOutputId struct {
	InputOrOutputId string `protobuf:"bytes,3,opt,name=input_or_output_id,json=inputOrOutputId,proto3,oneof"`
}

type ExecutableStagePayload_WireCoderSetting_Timer struct {
	Timer *ExecutableStagePayload_TimerId `protobuf:"bytes,4,opt,name=timer,proto3,oneof"`
}

func (*ExecutableStagePayload_WireCoderSetting_InputOrOutputId) isExecutableStagePayload_WireCoderSetting_Target() {
}

func (*ExecutableStagePayload_WireCoderSetting_Timer) isExecutableStagePayload_WireCoderSetting_Target() {
}

func (m *ExecutableStagePayload_WireCoderSetting) GetTarget() isExecutableStagePayload_WireCoderSetting_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ExecutableStagePayload_WireCoderSetting) GetInputOrOutputId() string {
	if x, ok := m.GetTarget().(*ExecutableStagePayload_WireCoderSetting_InputOrOutputId); ok {
		return x.InputOrOutputId
	}
	return ""
}

func (m *ExecutableStagePayload_WireCoderSetting) GetTimer() *ExecutableStagePayload_TimerId {
	if x, ok := m.GetTarget().(*ExecutableStagePayload_WireCoderSetting_Timer); ok {
		return x.Timer
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ExecutableStagePayload_WireCoderSetting) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ExecutableStagePayload_WireCoderSetting_InputOrOutputId)(nil),
		(*ExecutableStagePayload_WireCoderSetting_Timer)(nil),
	}
}

var E_BeamUrn = &proto.ExtensionDesc{
	ExtendedType:  (*descriptor.EnumValueOptions)(nil),
	ExtensionType: (*string)(nil),
	Field:         185324356,
	Name:          "org.apache.beam.model.pipeline.v1.beam_urn",
	Tag:           "bytes,185324356,opt,name=beam_urn",
	Filename:      "beam_runner_api.proto",
}

var E_BeamConstant = &proto.ExtensionDesc{
	ExtendedType:  (*descriptor.EnumValueOptions)(nil),
	ExtensionType: (*string)(nil),
	Field:         185324357,
	Name:          "org.apache.beam.model.pipeline.v1.beam_constant",
	Tag:           "bytes,185324357,opt,name=beam_constant",
	Filename:      "beam_runner_api.proto",
}

func init() {
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.BeamConstants_Constants", BeamConstants_Constants_name, BeamConstants_Constants_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardPTransforms_Primitives", StandardPTransforms_Primitives_name, StandardPTransforms_Primitives_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardPTransforms_DeprecatedPrimitives", StandardPTransforms_DeprecatedPrimitives_name, StandardPTransforms_DeprecatedPrimitives_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardPTransforms_Composites", StandardPTransforms_Composites_name, StandardPTransforms_Composites_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardPTransforms_CombineComponents", StandardPTransforms_CombineComponents_name, StandardPTransforms_CombineComponents_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardPTransforms_SplittableParDoComponents", StandardPTransforms_SplittableParDoComponents_name, StandardPTransforms_SplittableParDoComponents_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardSideInputTypes_Enum", StandardSideInputTypes_Enum_name, StandardSideInputTypes_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.IsBounded_Enum", IsBounded_Enum_name, IsBounded_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardCoders_Enum", StandardCoders_Enum_name, StandardCoders_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.MergeStatus_Enum", MergeStatus_Enum_name, MergeStatus_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.AccumulationMode_Enum", AccumulationMode_Enum_name, AccumulationMode_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.ClosingBehavior_Enum", ClosingBehavior_Enum_name, ClosingBehavior_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.OnTimeBehavior_Enum", OnTimeBehavior_Enum_name, OnTimeBehavior_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.OutputTime_Enum", OutputTime_Enum_name, OutputTime_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.TimeDomain_Enum", TimeDomain_Enum_name, TimeDomain_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardArtifacts_Types", StandardArtifacts_Types_name, StandardArtifacts_Types_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardArtifacts_Roles", StandardArtifacts_Roles_name, StandardArtifacts_Roles_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardEnvironments_Environments", StandardEnvironments_Environments_name, StandardEnvironments_Environments_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardProtocols_Enum", StandardProtocols_Enum_name, StandardProtocols_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardRequirements_Enum", StandardRequirements_Enum_name, StandardRequirements_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardDisplayData_DisplayData", StandardDisplayData_DisplayData_name, StandardDisplayData_DisplayData_value)
	proto.RegisterType((*BeamConstants)(nil), "org.apache.beam.model.pipeline.v1.BeamConstants")
	proto.RegisterType((*Components)(nil), "org.apache.beam.model.pipeline.v1.Components")
	proto.RegisterMapType((map[string]*Coder)(nil), "org.apache.beam.model.pipeline.v1.Components.CodersEntry")
	proto.RegisterMapType((map[string]*Environment)(nil), "org.apache.beam.model.pipeline.v1.Components.EnvironmentsEntry")
	proto.RegisterMapType((map[string]*PCollection)(nil), "org.apache.beam.model.pipeline.v1.Components.PcollectionsEntry")
	proto.RegisterMapType((map[string]*PTransform)(nil), "org.apache.beam.model.pipeline.v1.Components.TransformsEntry")
	proto.RegisterMapType((map[string]*WindowingStrategy)(nil), "org.apache.beam.model.pipeline.v1.Components.WindowingStrategiesEntry")
	proto.RegisterType((*Pipeline)(nil), "org.apache.beam.model.pipeline.v1.Pipeline")
	proto.RegisterType((*PTransform)(nil), "org.apache.beam.model.pipeline.v1.PTransform")
	proto.RegisterMapType((map[string]string)(nil), "org.apache.beam.model.pipeline.v1.PTransform.InputsEntry")
	proto.RegisterMapType((map[string]string)(nil), "org.apache.beam.model.pipeline.v1.PTransform.OutputsEntry")
	proto.RegisterType((*StandardPTransforms)(nil), "org.apache.beam.model.pipeline.v1.StandardPTransforms")
	proto.RegisterType((*StandardSideInputTypes)(nil), "org.apache.beam.model.pipeline.v1.StandardSideInputTypes")
	proto.RegisterType((*PCollection)(nil), "org.apache.beam.model.pipeline.v1.PCollection")
	proto.RegisterType((*ParDoPayload)(nil), "org.apache.beam.model.pipeline.v1.ParDoPayload")
	proto.RegisterMapType((map[string]*SideInput)(nil), "org.apache.beam.model.pipeline.v1.ParDoPayload.SideInputsEntry")
	proto.RegisterMapType((map[string]*StateSpec)(nil), "org.apache.beam.model.pipeline.v1.ParDoPayload.StateSpecsEntry")
	proto.RegisterMapType((map[string]*TimerFamilySpec)(nil), "org.apache.beam.model.pipeline.v1.ParDoPayload.TimerFamilySpecsEntry")
	proto.RegisterType((*StateSpec)(nil), "org.apache.beam.model.pipeline.v1.StateSpec")
	proto.RegisterType((*ReadModifyWriteStateSpec)(nil), "org.apache.beam.model.pipeline.v1.ReadModifyWriteStateSpec")
	proto.RegisterType((*BagStateSpec)(nil), "org.apache.beam.model.pipeline.v1.BagStateSpec")
	proto.RegisterType((*CombiningStateSpec)(nil), "org.apache.beam.model.pipeline.v1.CombiningStateSpec")
	proto.RegisterType((*MapStateSpec)(nil), "org.apache.beam.model.pipeline.v1.MapStateSpec")
	proto.RegisterType((*SetStateSpec)(nil), "org.apache.beam.model.pipeline.v1.SetStateSpec")
	proto.RegisterType((*TimerFamilySpec)(nil), "org.apache.beam.model.pipeline.v1.TimerFamilySpec")
	proto.RegisterType((*IsBounded)(nil), "org.apache.beam.model.pipeline.v1.IsBounded")
	proto.RegisterType((*ReadPayload)(nil), "org.apache.beam.model.pipeline.v1.ReadPayload")
	proto.RegisterType((*WindowIntoPayload)(nil), "org.apache.beam.model.pipeline.v1.WindowIntoPayload")
	proto.RegisterType((*CombinePayload)(nil), "org.apache.beam.model.pipeline.v1.CombinePayload")
	proto.RegisterType((*TestStreamPayload)(nil), "org.apache.beam.model.pipeline.v1.TestStreamPayload")
	proto.RegisterType((*TestStreamPayload_Event)(nil), "org.apache.beam.model.pipeline.v1.TestStreamPayload.Event")
	proto.RegisterType((*TestStreamPayload_Event_AdvanceWatermark)(nil), "org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceWatermark")
	proto.RegisterType((*TestStreamPayload_Event_AdvanceProcessingTime)(nil), "org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceProcessingTime")
	proto.RegisterType((*TestStreamPayload_Event_AddElements)(nil), "org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AddElements")
	proto.RegisterType((*TestStreamPayload_TimestampedElement)(nil), "org.apache.beam.model.pipeline.v1.TestStreamPayload.TimestampedElement")
	proto.RegisterType((*EventsRequest)(nil), "org.apache.beam.model.pipeline.v1.EventsRequest")
	proto.RegisterType((*WriteFilesPayload)(nil), "org.apache.beam.model.pipeline.v1.WriteFilesPayload")
	proto.RegisterMapType((map[string]*SideInput)(nil), "org.apache.beam.model.pipeline.v1.WriteFilesPayload.SideInputsEntry")
	proto.RegisterType((*Coder)(nil), "org.apache.beam.model.pipeline.v1.Coder")
	proto.RegisterType((*StandardCoders)(nil), "org.apache.beam.model.pipeline.v1.StandardCoders")
	proto.RegisterType((*WindowingStrategy)(nil), "org.apache.beam.model.pipeline.v1.WindowingStrategy")
	proto.RegisterType((*MergeStatus)(nil), "org.apache.beam.model.pipeline.v1.MergeStatus")
	proto.RegisterType((*AccumulationMode)(nil), "org.apache.beam.model.pipeline.v1.AccumulationMode")
	proto.RegisterType((*ClosingBehavior)(nil), "org.apache.beam.model.pipeline.v1.ClosingBehavior")
	proto.RegisterType((*OnTimeBehavior)(nil), "org.apache.beam.model.pipeline.v1.OnTimeBehavior")
	proto.RegisterType((*OutputTime)(nil), "org.apache.beam.model.pipeline.v1.OutputTime")
	proto.RegisterType((*TimeDomain)(nil), "org.apache.beam.model.pipeline.v1.TimeDomain")
	proto.RegisterType((*Trigger)(nil), "org.apache.beam.model.pipeline.v1.Trigger")
	proto.RegisterType((*Trigger_AfterAll)(nil), "org.apache.beam.model.pipeline.v1.Trigger.AfterAll")
	proto.RegisterType((*Trigger_AfterAny)(nil), "org.apache.beam.model.pipeline.v1.Trigger.AfterAny")
	proto.RegisterType((*Trigger_AfterEach)(nil), "org.apache.beam.model.pipeline.v1.Trigger.AfterEach")
	proto.RegisterType((*Trigger_AfterEndOfWindow)(nil), "org.apache.beam.model.pipeline.v1.Trigger.AfterEndOfWindow")
	proto.RegisterType((*Trigger_AfterProcessingTime)(nil), "org.apache.beam.model.pipeline.v1.Trigger.AfterProcessingTime")
	proto.RegisterType((*Trigger_AfterSynchronizedProcessingTime)(nil), "org.apache.beam.model.pipeline.v1.Trigger.AfterSynchronizedProcessingTime")
	proto.RegisterType((*Trigger_Default)(nil), "org.apache.beam.model.pipeline.v1.Trigger.Default")
	proto.RegisterType((*Trigger_ElementCount)(nil), "org.apache.beam.model.pipeline.v1.Trigger.ElementCount")
	proto.RegisterType((*Trigger_Never)(nil), "org.apache.beam.model.pipeline.v1.Trigger.Never")
	proto.RegisterType((*Trigger_Always)(nil), "org.apache.beam.model.pipeline.v1.Trigger.Always")
	proto.RegisterType((*Trigger_OrFinally)(nil), "org.apache.beam.model.pipeline.v1.Trigger.OrFinally")
	proto.RegisterType((*Trigger_Repeat)(nil), "org.apache.beam.model.pipeline.v1.Trigger.Repeat")
	proto.RegisterType((*TimestampTransform)(nil), "org.apache.beam.model.pipeline.v1.TimestampTransform")
	proto.RegisterType((*TimestampTransform_Delay)(nil), "org.apache.beam.model.pipeline.v1.TimestampTransform.Delay")
	proto.RegisterType((*TimestampTransform_AlignTo)(nil), "org.apache.beam.model.pipeline.v1.TimestampTransform.AlignTo")
	proto.RegisterType((*SideInput)(nil), "org.apache.beam.model.pipeline.v1.SideInput")
	proto.RegisterType((*StandardArtifacts)(nil), "org.apache.beam.model.pipeline.v1.StandardArtifacts")
	proto.RegisterType((*ArtifactFilePayload)(nil), "org.apache.beam.model.pipeline.v1.ArtifactFilePayload")
	proto.RegisterType((*ArtifactUrlPayload)(nil), "org.apache.beam.model.pipeline.v1.ArtifactUrlPayload")
	proto.RegisterType((*EmbeddedFilePayload)(nil), "org.apache.beam.model.pipeline.v1.EmbeddedFilePayload")
	proto.RegisterType((*PyPIPayload)(nil), "org.apache.beam.model.pipeline.v1.PyPIPayload")
	proto.RegisterType((*MavenPayload)(nil), "org.apache.beam.model.pipeline.v1.MavenPayload")
	proto.RegisterType((*DeferredArtifactPayload)(nil), "org.apache.beam.model.pipeline.v1.DeferredArtifactPayload")
	proto.RegisterType((*ArtifactStagingToRolePayload)(nil), "org.apache.beam.model.pipeline.v1.ArtifactStagingToRolePayload")
	proto.RegisterType((*ArtifactInformation)(nil), "org.apache.beam.model.pipeline.v1.ArtifactInformation")
	proto.RegisterType((*Environment)(nil), "org.apache.beam.model.pipeline.v1.Environment")
	proto.RegisterType((*StandardEnvironments)(nil), "org.apache.beam.model.pipeline.v1.StandardEnvironments")
	proto.RegisterType((*DockerPayload)(nil), "org.apache.beam.model.pipeline.v1.DockerPayload")
	proto.RegisterType((*ProcessPayload)(nil), "org.apache.beam.model.pipeline.v1.ProcessPayload")
	proto.RegisterMapType((map[string]string)(nil), "org.apache.beam.model.pipeline.v1.ProcessPayload.EnvEntry")
	proto.RegisterType((*ExternalPayload)(nil), "org.apache.beam.model.pipeline.v1.ExternalPayload")
	proto.RegisterMapType((map[string]string)(nil), "org.apache.beam.model.pipeline.v1.ExternalPayload.ParamsEntry")
	proto.RegisterType((*StandardProtocols)(nil), "org.apache.beam.model.pipeline.v1.StandardProtocols")
	proto.RegisterType((*StandardRequirements)(nil), "org.apache.beam.model.pipeline.v1.StandardRequirements")
	proto.RegisterType((*FunctionSpec)(nil), "org.apache.beam.model.pipeline.v1.FunctionSpec")
	proto.RegisterType((*StandardDisplayData)(nil), "org.apache.beam.model.pipeline.v1.StandardDisplayData")
	proto.RegisterType((*LabelledStringPayload)(nil), "org.apache.beam.model.pipeline.v1.LabelledStringPayload")
	proto.RegisterType((*DisplayData)(nil), "org.apache.beam.model.pipeline.v1.DisplayData")
	proto.RegisterType((*MessageWithComponents)(nil), "org.apache.beam.model.pipeline.v1.MessageWithComponents")
	proto.RegisterType((*ExecutableStagePayload)(nil), "org.apache.beam.model.pipeline.v1.ExecutableStagePayload")
	proto.RegisterType((*ExecutableStagePayload_SideInputId)(nil), "org.apache.beam.model.pipeline.v1.ExecutableStagePayload.SideInputId")
	proto.RegisterType((*ExecutableStagePayload_UserStateId)(nil), "org.apache.beam.model.pipeline.v1.ExecutableStagePayload.UserStateId")
	proto.RegisterType((*ExecutableStagePayload_TimerId)(nil), "org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerId")
	proto.RegisterType((*ExecutableStagePayload_TimerFamilyId)(nil), "org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerFamilyId")
	proto.RegisterType((*ExecutableStagePayload_WireCoderSetting)(nil), "org.apache.beam.model.pipeline.v1.ExecutableStagePayload.WireCoderSetting")
	proto.RegisterExtension(E_BeamUrn)
	proto.RegisterExtension(E_BeamConstant)
}

func init() { proto.RegisterFile("beam_runner_api.proto", fileDescriptor_cf57597c3a9659a9) }

var fileDescriptor_cf57597c3a9659a9 = []byte{
	// 5958 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x7c, 0x4d, 0x6c, 0x1b, 0xe9,
	0x79, 0x3f, 0x3f, 0x44, 0x89, 0x7c, 0x48, 0x49, 0xe3, 0xd7, 0x96, 0x57, 0x3b, 0xd9, 0x8d, 0xbd,
	0xb3, 0x9b, 0x5d, 0xef, 0xfe, 0x77, 0xb5, 0xb6, 0xbc, 0xfe, 0x52, 0x92, 0x75, 0x48, 0x71, 0x68,
	0x8d, 0xcd, 0xaf, 0x1d, 0x52, 0x92, 0xbd, 0x49, 0x76, 0xfe, 0x23, 0xce, 0x4b, 0x69, 0xe0, 0xe1,
	0x0c, 0x33, 0x33, 0x94, 0x97, 0x8b, 0x00, 0x05, 0x8a, 0x22, 0x87, 0x02, 0x6d, 0x91, 0x1c, 0x02,
	0xe4, 0x14, 0x20, 0x01, 0x82, 0xb6, 0x28, 0xd0, 0x22, 0x28, 0x02, 0xf4, 0xd2, 0x43, 0xda, 0x1e,
	0x5b, 0xa0, 0x45, 0x81, 0x9e, 0x8b, 0x9e, 0x7b, 0xe9, 0xa1, 0x40, 0x7b, 0x28, 0x8a, 0xf7, 0x63,
	0x86, 0xef, 0x50, 0x92, 0x4d, 0xca, 0x46, 0x6f, 0x9c, 0x67, 0xde, 0xe7, 0xf7, 0x3c, 0xef, 0xf7,
	0xf3, 0x35, 0x84, 0xb5, 0x03, 0x6c, 0x0e, 0x0c, 0x7f, 0xe4, 0xba, 0xd8, 0x37, 0xcc, 0xa1, 0xbd,
	0x31, 0xf4, 0xbd, 0xd0, 0x43, 0x6f, 0x79, 0xfe, 0xe1, 0x86, 0x39, 0x34, 0x7b, 0x47, 0x78, 0x83,
	0xb4, 0xd8, 0x18, 0x78, 0x16, 0x76, 0x36, 0x86, 0xf6, 0x10, 0x3b, 0xb6, 0x8b, 0x37, 0x8e, 0x6f,
	0xc8, 0xab, 0xd8, 0xb5, 0x86, 0x9e, 0xed, 0x86, 0x01, 0xe3, 0x91, 0x5f, 0x3f, 0xf4, 0xbc, 0x43,
	0x07, 0x7f, 0x4c, 0x9f, 0x0e, 0x46, 0xfd, 0x8f, 0x4d, 0x77, 0xcc, 0x5f, 0x5d, 0x9d, 0x7e, 0x65,
	0xe1, 0xa0, 0xe7, 0xdb, 0xc3, 0xd0, 0xf3, 0x79, 0x8b, 0x2b, 0xd3, 0x2d, 0x42, 0x7b, 0x80, 0x83,
	0xd0, 0x1c, 0x0c, 0x59, 0x03, 0xe5, 0xb7, 0x69, 0x58, 0xae, 0x60, 0x73, 0xb0, 0xed, 0xb9, 0x41,
	0x68, 0xba, 0x61, 0xa0, 0xfc, 0x45, 0x1a, 0x0a, 0xf1, 0x13, 0xba, 0x01, 0x97, 0x1a, 0x5a, 0xd3,
	0xe8, 0x6a, 0x0d, 0xb5, 0xd3, 0x2d, 0x37, 0xda, 0x46, 0x43, 0xab, 0xd7, 0xb5, 0x8e, 0x94, 0x92,
	0x5f, 0xfb, 0xd3, 0xbf, 0xfc, 0xef, 0xdf, 0xe6, 0x2e, 0x7c, 0x74, 0x6f, 0x73, 0xf3, 0xe6, 0xcd,
	0x3b, 0x9b, 0xd7, 0x6f, 0xde, 0xbe, 0x7b, 0xeb, 0x93, 0x3b, 0x77, 0x6e, 0xa1, 0xeb, 0x70, 0xa9,
	0x51, 0x7e, 0x7c, 0x92, 0x25, 0x2d, 0x5f, 0xa6, 0x2c, 0xd2, 0x09, 0x8e, 0x4f, 0x41, 0x79, 0x50,
	0x6f, 0x55, 0xca, 0x75, 0x63, 0x5f, 0x6b, 0x56, 0x5b, 0xfb, 0xc6, 0xa9, 0xfc, 0x99, 0x24, 0xff,
	0x8d, 0x7b, 0xb7, 0xae, 0x7f, 0x42, 0xf9, 0x95, 0xdf, 0xe4, 0x01, 0xb6, 0xbd, 0xc1, 0xd0, 0x73,
	0x31, 0xd1, 0xf9, 0xfb, 0x00, 0xa1, 0x6f, 0xba, 0x41, 0xdf, 0xf3, 0x07, 0xc1, 0x7a, 0xfa, 0x6a,
	0xf6, 0x5a, 0x71, 0xf3, 0xdb, 0x1b, 0x2f, 0x1c, 0xfa, 0x8d, 0x09, 0xc4, 0x46, 0x37, 0xe6, 0x57,
	0xdd, 0xd0, 0x1f, 0xeb, 0x02, 0x20, 0xea, 0x41, 0x69, 0xd8, 0xf3, 0x1c, 0x07, 0xf7, 0x42, 0xdb,
	0x73, 0x83, 0xf5, 0x0c, 0x15, 0x70, 0x7f, 0x3e, 0x01, 0x6d, 0x01, 0x81, 0x89, 0x48, 0x80, 0xa2,
	0x31, 0x5c, 0x7a, 0x66, 0xbb, 0x96, 0xf7, 0xcc, 0x76, 0x0f, 0x8d, 0x20, 0xf4, 0xcd, 0x10, 0x1f,
	0xda, 0x38, 0x58, 0xcf, 0x52, 0x61, 0xb5, 0xf9, 0x84, 0xed, 0x47, 0x48, 0x9d, 0x18, 0x88, 0xc9,
	0xbc, 0xf8, 0xec, 0xe4, 0x1b, 0xf4, 0x19, 0x2c, 0xf6, 0x3c, 0x0b, 0xfb, 0xc1, 0xfa, 0x02, 0x15,
	0x76, 0x6f, 0x3e, 0x61, 0xdb, 0x94, 0x97, 0xe1, 0x73, 0x20, 0x32, 0x64, 0xd8, 0x3d, 0xb6, 0x7d,
	0xcf, 0x1d, 0x90, 0x36, 0xeb, 0xb9, 0xf3, 0x0c, 0x99, 0x2a, 0x20, 0xf0, 0x21, 0x13, 0x41, 0x65,
	0x07, 0x56, 0xa7, 0xa6, 0x0d, 0x49, 0x90, 0x7d, 0x8a, 0xc7, 0xeb, 0xe9, 0xab, 0xe9, 0x6b, 0x05,
	0x9d, 0xfc, 0x44, 0xdb, 0x90, 0x3b, 0x36, 0x9d, 0x11, 0x5e, 0xcf, 0x5c, 0x4d, 0x5f, 0x2b, 0x6e,
	0x7e, 0x34, 0x83, 0x0a, 0xed, 0x18, 0x55, 0x67, 0xbc, 0x5b, 0x99, 0xbb, 0x69, 0xd9, 0x83, 0x0b,
	0x27, 0xe6, 0xf0, 0x14, 0x79, 0xd5, 0xa4, 0xbc, 0x8d, 0x59, 0xe4, 0x6d, 0xc7, 0xb0, 0xa2, 0xc0,
	0x1f, 0xc2, 0xfa, 0x59, 0xf3, 0x78, 0x8a, 0xdc, 0x87, 0x49, 0xb9, 0x9f, 0xcc, 0x20, 0x77, 0x1a,
	0x7d, 0x2c, 0x4a, 0xef, 0x41, 0x51, 0x98, 0xd8, 0x53, 0x04, 0x7e, 0x9a, 0x14, 0x78, 0x6d, 0xa6,
	0xb9, 0xb5, 0xb0, 0x3f, 0x35, 0xa6, 0x27, 0x26, 0xf9, 0xd5, 0x8c, 0xa9, 0x00, 0x2b, 0x08, 0x54,
	0xfe, 0x27, 0x0d, 0xf9, 0x36, 0x6f, 0x86, 0x1a, 0x00, 0xbd, 0x78, 0xb5, 0x51, 0x79, 0xb3, 0xad,
	0x8f, 0xc9, 0x12, 0xd5, 0x05, 0x00, 0xf4, 0x21, 0x20, 0xdf, 0xf3, 0x42, 0x23, 0x3e, 0x39, 0x0c,
	0xdb, 0x62, 0x87, 0x45, 0x41, 0x97, 0xc8, 0x9b, 0x78, 0x59, 0x69, 0x16, 0xd9, 0x74, 0x25, 0xcb,
	0x0e, 0x86, 0x8e, 0x39, 0x36, 0x2c, 0x33, 0x34, 0xf9, 0x3e, 0x9f, 0xa5, 0x6b, 0x55, 0xc6, 0x56,
	0x35, 0x43, 0x53, 0x2f, 0x5a, 0x93, 0x07, 0xa4, 0x40, 0xc9, 0xc7, 0x3f, 0x18, 0xd9, 0x3e, 0x66,
	0x9b, 0x6e, 0x81, 0x8a, 0x4e, 0xd0, 0x94, 0x5f, 0x2f, 0x00, 0x4c, 0xd6, 0x37, 0xba, 0x02, 0xc5,
	0x91, 0x6b, 0xff, 0x60, 0x84, 0x0d, 0xd7, 0x1c, 0xe0, 0xf5, 0x1c, 0x1d, 0x73, 0x60, 0xa4, 0xa6,
	0x39, 0xc0, 0x68, 0x1b, 0x16, 0x82, 0x21, 0xee, 0xf1, 0xd1, 0xf9, 0x78, 0x06, 0xf5, 0x6a, 0x23,
	0x97, 0x2e, 0xe5, 0xce, 0x10, 0xf7, 0x74, 0xca, 0x8c, 0xde, 0x81, 0xe5, 0x60, 0x74, 0x20, 0x1c,
	0xd1, 0x6c, 0x50, 0x92, 0x44, 0x72, 0x0c, 0xd9, 0xee, 0x70, 0x14, 0x46, 0x67, 0xde, 0xbd, 0xb9,
	0xb6, 0xea, 0x86, 0x46, 0x79, 0xf9, 0x31, 0xc4, 0x80, 0x50, 0x17, 0x96, 0xbc, 0x51, 0x48, 0x31,
	0xd9, 0xd1, 0xb6, 0x35, 0x1f, 0x66, 0x8b, 0x31, 0x33, 0xd0, 0x08, 0xea, 0xc4, 0xd4, 0x2d, 0xbe,
	0xfc, 0xd4, 0x7d, 0x03, 0x56, 0x84, 0xa3, 0xcd, 0xb0, 0xad, 0xf5, 0x25, 0x3a, 0x15, 0xcb, 0x02,
	0x55, 0xb3, 0xe4, 0x7b, 0x50, 0x14, 0xba, 0x79, 0xca, 0x4e, 0xb9, 0x24, 0xee, 0x94, 0x82, 0xb8,
	0xd5, 0xb6, 0xa0, 0x24, 0xf6, 0x66, 0x1e, 0x5e, 0xe5, 0x97, 0x2b, 0x70, 0xb1, 0x13, 0x9a, 0xae,
	0x65, 0xfa, 0xd6, 0x64, 0x74, 0x02, 0xe5, 0x4f, 0xb2, 0x00, 0x6d, 0xdf, 0x1e, 0xd8, 0xa1, 0x7d,
	0x8c, 0x03, 0xf4, 0x3e, 0x2c, 0xb6, 0xcb, 0xba, 0x51, 0x6d, 0x49, 0x29, 0xf9, 0xcd, 0x5f, 0x90,
	0x9b, 0xfb, 0x35, 0x32, 0x0e, 0x5b, 0xf1, 0x1c, 0x6f, 0x0d, 0x4d, 0xdf, 0xf2, 0xb6, 0x8e, 0x6f,
	0xa0, 0x0f, 0x61, 0xa9, 0x56, 0x2f, 0x77, 0xbb, 0x6a, 0x53, 0x4a, 0xcb, 0x57, 0x68, 0xdb, 0xd7,
	0xa7, 0xda, 0xf6, 0x1d, 0x33, 0x0c, 0xb1, 0x4b, 0x5a, 0xdf, 0x86, 0xd2, 0x03, 0xbd, 0xb5, 0xdb,
	0x36, 0x2a, 0x4f, 0x8c, 0x47, 0xea, 0x13, 0x29, 0x23, 0xbf, 0x43, 0x59, 0xbe, 0x3e, 0xc5, 0x72,
	0xe8, 0x7b, 0xa3, 0xa1, 0x71, 0x30, 0x36, 0x9e, 0xe2, 0x31, 0x97, 0xa2, 0x35, 0xda, 0xbb, 0xf5,
	0x8e, 0x2a, 0x65, 0xcf, 0x90, 0x62, 0x0f, 0x86, 0x23, 0x27, 0xc0, 0xa4, 0xf5, 0x1d, 0x58, 0x29,
	0x77, 0x3a, 0xda, 0x83, 0x26, 0x37, 0x4a, 0x3a, 0xd2, 0x82, 0xfc, 0x36, 0x65, 0x7a, 0x73, 0x8a,
	0x89, 0x5d, 0xa2, 0x86, 0xed, 0x86, 0xb4, 0x33, 0x37, 0xa1, 0xd8, 0x55, 0x3b, 0x5d, 0xa3, 0xd3,
	0xd5, 0xd5, 0x72, 0x43, 0xca, 0xc9, 0x0a, 0xe5, 0x7a, 0x63, 0x8a, 0x2b, 0xc4, 0x41, 0x18, 0x84,
	0x3e, 0x21, 0x1e, 0xdf, 0x40, 0x9f, 0x40, 0xb1, 0x51, 0x6e, 0xc7, 0xa2, 0x16, 0xcf, 0x10, 0x35,
	0x30, 0x87, 0x06, 0x13, 0x17, 0x10, 0xae, 0xbb, 0xb0, 0xdc, 0x50, 0xf5, 0x07, 0x6a, 0xcc, 0xb7,
	0x24, 0x7f, 0x83, 0xf2, 0x5d, 0x99, 0xe6, 0xc3, 0xfe, 0x21, 0x16, 0x38, 0x95, 0x10, 0x2e, 0x55,
	0xf1, 0xd0, 0xc7, 0x3d, 0x33, 0xc4, 0x96, 0x30, 0x69, 0xef, 0xc2, 0x82, 0xae, 0x96, 0xab, 0x52,
	0x4a, 0x7e, 0x83, 0x02, 0x5d, 0x9e, 0x02, 0xf2, 0xb1, 0x69, 0x71, 0x7d, 0xb7, 0x75, 0xb5, 0xdc,
	0x55, 0x8d, 0x3d, 0x4d, 0xdd, 0x97, 0xd2, 0x67, 0xe8, 0xdb, 0xf3, 0xb1, 0x19, 0x62, 0xe3, 0xd8,
	0xc6, 0xcf, 0x88, 0xd4, 0xff, 0x48, 0x73, 0x43, 0x2d, 0xb0, 0x43, 0x1c, 0xa0, 0x6f, 0xc1, 0xea,
	0x76, 0xab, 0x51, 0xd1, 0x9a, 0xaa, 0xd1, 0x56, 0x75, 0x3a, 0x97, 0x29, 0xf9, 0x3d, 0x0a, 0xf4,
	0xd6, 0x34, 0x90, 0x37, 0x38, 0xb0, 0x5d, 0x6c, 0x0c, 0xb1, 0x1f, 0x4d, 0xe7, 0xa7, 0x20, 0x45,
	0xdc, 0xcc, 0x7a, 0xac, 0x3f, 0x91, 0xd2, 0xf2, 0x35, 0xca, 0xae, 0x9c, 0xc1, 0x7e, 0xe8, 0x78,
	0x07, 0xa6, 0xe3, 0x50, 0xfe, 0xeb, 0x50, 0xd0, 0xd5, 0xce, 0xce, 0x6e, 0xad, 0x56, 0x57, 0xa5,
	0x8c, 0xfc, 0x16, 0x65, 0xfc, 0xda, 0x89, 0xfe, 0x06, 0x47, 0xa3, 0x7e, 0xdf, 0xc1, 0xbc, 0xd3,
	0xfb, 0xba, 0xd6, 0x55, 0x8d, 0x9a, 0x56, 0x57, 0x3b, 0x52, 0xf6, 0xac, 0xf5, 0xe0, 0xdb, 0x21,
	0x36, 0xfa, 0xb6, 0x83, 0xe9, 0x50, 0xff, 0x5b, 0x16, 0x2e, 0x6c, 0x33, 0xf9, 0x82, 0x91, 0xaa,
	0x83, 0x3c, 0xd5, 0x77, 0xa3, 0xad, 0xab, 0x9c, 0x24, 0xa5, 0xe4, 0x4d, 0x0a, 0xfd, 0xe1, 0xf3,
	0x87, 0xc1, 0x20, 0x33, 0xc8, 0x48, 0x44, 0xbf, 0x03, 0x50, 0xa6, 0x31, 0xd9, 0xf2, 0x28, 0x6f,
	0x6f, 0xef, 0x36, 0x76, 0xeb, 0xe5, 0x6e, 0x4b, 0x27, 0x76, 0xf8, 0x16, 0xc5, 0xfe, 0xe4, 0x05,
	0xd8, 0x6c, 0xcd, 0x98, 0xbd, 0xde, 0x68, 0x30, 0x72, 0xcc, 0xd0, 0xf3, 0xe9, 0x92, 0xfb, 0x1e,
	0x5c, 0x99, 0x96, 0xa1, 0x3e, 0xee, 0xea, 0xe5, 0xed, 0xae, 0xd1, 0xda, 0xed, 0xb6, 0x77, 0xbb,
	0xc4, 0x50, 0xbf, 0x43, 0x05, 0xdc, 0x78, 0x81, 0x00, 0xfc, 0x65, 0xe8, 0x9b, 0xbd, 0xd0, 0xe0,
	0x07, 0x29, 0x41, 0x7f, 0x08, 0x97, 0xe3, 0x39, 0x25, 0x5b, 0x5c, 0xad, 0x1a, 0x7b, 0xe5, 0xfa,
	0x2e, 0x1d, 0xec, 0x0d, 0x0a, 0x7a, 0xed, 0xac, 0x99, 0x25, 0x9b, 0x1d, 0x5b, 0x06, 0x3d, 0xa6,
	0x28, 0x96, 0x03, 0xef, 0x4d, 0x6b, 0xba, 0xdd, 0x6a, 0xee, 0xa9, 0x7a, 0xd7, 0xe8, 0xb6, 0x92,
	0x43, 0xb2, 0x20, 0xdf, 0xa7, 0xe0, 0xf7, 0x5e, 0xa0, 0x71, 0xcf, 0x73, 0x8f, 0xb1, 0x1f, 0x1a,
	0xa1, 0x37, 0x3d, 0x2e, 0xca, 0x1f, 0x2e, 0xc0, 0xeb, 0x9d, 0xa1, 0x63, 0x87, 0xa1, 0x79, 0xe0,
	0xe0, 0xb6, 0xe9, 0x57, 0x3d, 0x61, 0xb6, 0xeb, 0xb0, 0xd6, 0x2e, 0x6b, 0xba, 0xb1, 0xaf, 0x75,
	0x77, 0x0c, 0x5d, 0xed, 0x74, 0x75, 0x6d, 0xbb, 0xab, 0xb5, 0x9a, 0x52, 0x4a, 0xbe, 0x41, 0x25,
	0xff, 0xbf, 0x29, 0xc9, 0x81, 0xd5, 0x37, 0x86, 0xa6, 0xed, 0x1b, 0xcf, 0xec, 0xf0, 0xc8, 0xf0,
	0x71, 0x10, 0xfa, 0x36, 0xbd, 0x47, 0x49, 0xcf, 0xaa, 0x70, 0xa1, 0xd3, 0xae, 0x6b, 0xdd, 0x04,
	0x52, 0x5a, 0xfe, 0x88, 0x22, 0xbd, 0x77, 0x0a, 0x52, 0x40, 0x14, 0x9b, 0x46, 0x69, 0xc2, 0xe5,
	0xb6, 0xde, 0xda, 0x56, 0x3b, 0x1d, 0x32, 0x36, 0x6a, 0xd5, 0x50, 0xeb, 0x6a, 0x43, 0x6d, 0xd2,
	0x09, 0x3c, 0x7d, 0xf5, 0x51, 0xa5, 0x7c, 0xaf, 0x87, 0x83, 0x80, 0x0c, 0x07, 0xb6, 0x0c, 0xec,
	0x30, 0x43, 0x82, 0xe0, 0x55, 0x40, 0x8a, 0xf0, 0x62, 0xa4, 0xac, 0xfc, 0x21, 0x45, 0x7a, 0xf7,
	0x39, 0x48, 0x22, 0xc6, 0x63, 0xf8, 0x1a, 0xeb, 0x59, 0xb9, 0x59, 0x35, 0x3a, 0xda, 0xe7, 0xaa,
	0xd8, 0x45, 0x32, 0x4f, 0xa7, 0xaf, 0xac, 0x49, 0x1f, 0x4d, 0xd7, 0x32, 0x02, 0xfb, 0x2b, 0x2c,
	0x76, 0x96, 0x22, 0x7b, 0xf0, 0x5e, 0xa4, 0x1d, 0xc1, 0x9d, 0xf4, 0x96, 0x8a, 0x4a, 0x48, 0xc9,
	0xc9, 0x15, 0x2a, 0xe5, 0x5b, 0xcf, 0x51, 0x9a, 0xc8, 0x88, 0xbb, 0x4f, 0xa5, 0x4e, 0x09, 0x54,
	0x7e, 0x37, 0x0d, 0x97, 0xa3, 0x5b, 0xb2, 0x63, 0x5b, 0x98, 0xde, 0xd4, 0xdd, 0xf1, 0x10, 0x07,
	0xca, 0x11, 0x2c, 0xa8, 0xee, 0x68, 0x80, 0x3e, 0x86, 0xbc, 0xd6, 0x55, 0xf5, 0x72, 0xa5, 0x4e,
	0x76, 0xbc, 0x78, 0x00, 0x05, 0xb6, 0x85, 0x0d, 0x6a, 0xb5, 0x6c, 0xd9, 0x21, 0xf6, 0xc9, 0x92,
	0x22, 0x9d, 0xf8, 0x18, 0xf2, 0x8d, 0xdd, 0x7a, 0x57, 0x6b, 0x94, 0xdb, 0x52, 0xfa, 0x2c, 0x86,
	0xc1, 0xc8, 0x09, 0xed, 0x81, 0x39, 0x24, 0x4a, 0xfc, 0x22, 0x03, 0x45, 0xc1, 0x9f, 0x98, 0x36,
	0xf0, 0xd2, 0x27, 0x0c, 0xbc, 0xd7, 0x21, 0x4f, 0x7d, 0x36, 0x62, 0x73, 0xb0, 0x8b, 0x7f, 0x89,
	0x3e, 0x6b, 0x16, 0x6a, 0x03, 0xd8, 0x81, 0x71, 0xe0, 0x8d, 0x5c, 0x0b, 0x5b, 0xeb, 0xd9, 0xab,
	0xe9, 0x6b, 0x2b, 0x9b, 0x37, 0x66, 0xb0, 0x72, 0xb4, 0xa0, 0xc2, 0x78, 0x36, 0x48, 0xa7, 0xf5,
	0x82, 0x1d, 0x3d, 0xa3, 0x4d, 0x58, 0x3b, 0xe1, 0xe4, 0x8e, 0x89, 0xe4, 0x05, 0x2a, 0xf9, 0x84,
	0x77, 0x3a, 0xd6, 0xac, 0x13, 0xd6, 0x56, 0xee, 0xa5, 0xad, 0x2d, 0xe5, 0xaf, 0x97, 0xa0, 0x44,
	0x37, 0x6c, 0xdb, 0x1c, 0x3b, 0x9e, 0x69, 0x11, 0x07, 0xc3, 0xf2, 0x8c, 0xbe, 0x7b, 0x6e, 0x33,
	0xd7, 0xf2, 0x6a, 0x2e, 0xfa, 0xff, 0x50, 0x9c, 0xcc, 0x4a, 0x64, 0xc5, 0xce, 0xe2, 0xf3, 0x8a,
	0xba, 0x6c, 0xc4, 0x4b, 0x27, 0x8a, 0x44, 0x04, 0x31, 0x81, 0x4a, 0x08, 0xc9, 0xfd, 0x4a, 0xcc,
	0xea, 0xc8, 0xa6, 0x9d, 0x5f, 0x02, 0x81, 0x20, 0x7a, 0xc7, 0x12, 0x62, 0x02, 0x0a, 0x00, 0x85,
	0xf6, 0x00, 0xfb, 0x46, 0xdf, 0x1c, 0xd8, 0xce, 0x98, 0x0b, 0x2a, 0x50, 0x41, 0xea, 0xbc, 0x82,
	0xba, 0x04, 0xa9, 0x46, 0x81, 0x04, 0x71, 0x52, 0x38, 0x45, 0x46, 0xd7, 0xe1, 0x92, 0xb0, 0x99,
	0x8c, 0x78, 0x3d, 0x32, 0x1b, 0x18, 0x09, 0xef, 0xb6, 0xf9, 0xd2, 0xbc, 0x09, 0x6b, 0xc4, 0xad,
	0x21, 0x16, 0x95, 0xd1, 0xb7, 0x5d, 0xd3, 0xb1, 0xbf, 0x32, 0xc9, 0xfb, 0xf5, 0xfc, 0xd5, 0xf4,
	0xb5, 0xbc, 0x7e, 0x29, 0x7a, 0x59, 0x13, 0xde, 0xa1, 0x6f, 0x82, 0xcc, 0x7d, 0xa1, 0xc0, 0x20,
	0x3a, 0x18, 0x81, 0xe7, 0x87, 0xd8, 0x62, 0xf3, 0xb5, 0x0e, 0x94, 0xf3, 0xb5, 0xa8, 0x05, 0xd1,
	0xbd, 0x43, 0xdf, 0xd3, 0xb1, 0x27, 0x4b, 0x37, 0x66, 0x0e, 0xe8, 0x91, 0xcf, 0xf9, 0x8a, 0x94,
	0xef, 0x62, 0xf4, 0xb2, 0x43, 0xdf, 0x51, 0x1e, 0xf9, 0x29, 0xac, 0x4e, 0xcd, 0xe6, 0x29, 0x66,
	0x77, 0x25, 0xe9, 0xdc, 0x7e, 0x38, 0xc3, 0x20, 0xc7, 0xa0, 0xa2, 0x81, 0x4f, 0x84, 0x25, 0x27,
	0xf6, 0x15, 0x09, 0x8b, 0x40, 0x45, 0x61, 0xcf, 0x60, 0xed, 0xd4, 0xc9, 0x3d, 0x45, 0xe4, 0x4e,
	0x52, 0xe4, 0xe6, 0x0c, 0x22, 0xa7, 0xa0, 0x05, 0xc1, 0x0f, 0x17, 0xf2, 0x8b, 0xd2, 0x92, 0xf2,
	0x8f, 0x59, 0x28, 0xc4, 0x7a, 0x21, 0x1f, 0x2e, 0x13, 0x2b, 0xd5, 0x18, 0x78, 0x96, 0xdd, 0x1f,
	0x1b, 0xcc, 0x1a, 0x13, 0xbc, 0xd6, 0x6f, 0xce, 0x20, 0x52, 0xc7, 0xa6, 0xd5, 0xa0, 0xfc, 0xfb,
	0x84, 0x3d, 0x06, 0xdf, 0x49, 0x91, 0xa9, 0x4d, 0xbe, 0x23, 0x32, 0xeb, 0x90, 0x3f, 0x30, 0x0f,
	0x99, 0x94, 0xcc, 0xcc, 0x87, 0x46, 0xc5, 0x3c, 0x14, 0x91, 0x97, 0x0e, 0xcc, 0x43, 0x8a, 0xf6,
	0x05, 0xac, 0x30, 0xcb, 0x83, 0x9e, 0x8b, 0x04, 0x33, 0x4b, 0x31, 0x6f, 0xcd, 0x16, 0x8d, 0x60,
	0x8c, 0x22, 0xf2, 0x72, 0x0c, 0x17, 0x69, 0x4b, 0x1c, 0x09, 0x8a, 0xbc, 0x30, 0xb3, 0xb6, 0x0d,
	0x73, 0x98, 0xd0, 0x76, 0x60, 0x0e, 0x23, 0xb4, 0x00, 0x87, 0x0c, 0x2d, 0x37, 0x33, 0x5a, 0x07,
	0x87, 0x09, 0xb4, 0x00, 0x87, 0xe4, 0x67, 0x65, 0x91, 0x45, 0x18, 0x94, 0x5b, 0xb0, 0x7e, 0xd6,
	0x24, 0x24, 0x2e, 0xa9, 0x74, 0xe2, 0x92, 0x52, 0xee, 0x42, 0x49, 0x1c, 0x55, 0x74, 0x0d, 0xa4,
	0xe8, 0x92, 0x9e, 0x62, 0x59, 0xe1, 0x74, 0x7e, 0x86, 0x28, 0x3f, 0x4d, 0x03, 0x3a, 0x39, 0x78,
	0xe4, 0x30, 0x12, 0x4c, 0xbd, 0x69, 0x10, 0x24, 0xbc, 0x8b, 0x0e, 0xa3, 0x26, 0x8d, 0x23, 0x51,
	0xbb, 0xb1, 0xef, 0xce, 0xb1, 0x1a, 0x12, 0x57, 0x48, 0x81, 0x43, 0xd4, 0x5c, 0x65, 0x0f, 0x4a,
	0xe2, 0xd0, 0xa3, 0xab, 0x50, 0x62, 0xb6, 0x68, 0x42, 0x13, 0x78, 0x8a, 0xc7, 0x91, 0x06, 0xef,
	0xc0, 0x0a, 0xdd, 0x22, 0xc6, 0xd4, 0x55, 0x5e, 0xa2, 0xd4, 0xed, 0xc9, 0x50, 0x89, 0x93, 0x30,
	0xc7, 0x50, 0xfd, 0x2c, 0x0d, 0xab, 0x53, 0x9b, 0x12, 0x75, 0xa0, 0x48, 0x0f, 0x51, 0xcb, 0x1b,
	0x98, 0x36, 0xbb, 0x39, 0x57, 0x66, 0xde, 0xdd, 0x55, 0xca, 0xc4, 0xec, 0x03, 0x08, 0x63, 0x02,
	0xba, 0x01, 0x6b, 0x89, 0xeb, 0x67, 0xaa, 0x3f, 0x48, 0xb8, 0x3a, 0x22, 0xdd, 0xbe, 0x03, 0x85,
	0xd8, 0xe0, 0x50, 0x6e, 0x72, 0x43, 0x6b, 0x15, 0x8a, 0xbb, 0xcd, 0x4e, 0x5b, 0xdd, 0xd6, 0x6a,
	0x9a, 0x5a, 0x95, 0x52, 0x68, 0x19, 0x0a, 0xbb, 0xcd, 0x4a, 0x6b, 0xb7, 0x59, 0x55, 0xab, 0x52,
	0x1a, 0x15, 0x61, 0x29, 0x7a, 0xc8, 0x28, 0x7f, 0x9c, 0x86, 0x22, 0x59, 0x7a, 0x91, 0x35, 0xf0,
	0x00, 0x16, 0x03, 0x6f, 0xe4, 0xf7, 0xf0, 0x79, 0xcd, 0x01, 0xce, 0x3e, 0x65, 0x40, 0x65, 0x5e,
	0xde, 0x80, 0x52, 0x4c, 0xb8, 0xc0, 0xa2, 0xb6, 0x9a, 0x1b, 0xc6, 0xd6, 0x4b, 0x1d, 0x0a, 0x3c,
	0x22, 0x71, 0x7e, 0x0b, 0x26, 0xcf, 0x10, 0x6a, 0xae, 0xf2, 0x93, 0x34, 0xac, 0x70, 0xef, 0x35,
	0x12, 0x90, 0x5c, 0xe0, 0xe9, 0x97, 0x5d, 0xe0, 0x67, 0x6e, 0xb1, 0xcc, 0x59, 0x5b, 0x4c, 0xf9,
	0xfb, 0x25, 0xb8, 0xd0, 0xc5, 0x41, 0xd8, 0xa1, 0xf1, 0x93, 0x48, 0xaf, 0xb3, 0x8f, 0x05, 0xa4,
	0xc3, 0x22, 0x3e, 0xa6, 0x51, 0xd0, 0xcc, 0xcc, 0x81, 0xbf, 0x13, 0x02, 0x36, 0x54, 0x02, 0xa1,
	0x73, 0x24, 0xd4, 0x81, 0x7c, 0x94, 0xab, 0xe3, 0xe7, 0xf3, 0x9d, 0x19, 0x50, 0xcb, 0x43, 0xbb,
	0x83, 0xfd, 0x63, 0xbb, 0x87, 0xab, 0x71, 0xb2, 0x4e, 0x8f, 0x81, 0xe4, 0x9f, 0xe6, 0x20, 0x47,
	0xc5, 0xa0, 0x63, 0x58, 0x7d, 0x66, 0x86, 0xd8, 0x1f, 0x98, 0xfe, 0x53, 0x83, 0x8a, 0xe4, 0x43,
	0xfd, 0xe8, 0xfc, 0xba, 0x6f, 0x94, 0xad, 0x63, 0xd3, 0xed, 0xe1, 0xfd, 0x08, 0x78, 0x27, 0xa5,
	0xaf, 0xc4, 0x52, 0x98, 0xdc, 0x1f, 0xa5, 0x61, 0x8d, 0x7b, 0x39, 0xe4, 0xfa, 0xa1, 0x9b, 0x9a,
	0x89, 0x67, 0x47, 0x59, 0xfb, 0xe5, 0xc5, 0xb7, 0x63, 0x78, 0xb2, 0xf9, 0xc9, 0x9d, 0x3a, 0x4c,
	0x50, 0x98, 0x22, 0x03, 0x58, 0x8e, 0xce, 0x23, 0x26, 0x9f, 0x0d, 0x72, 0xed, 0xa5, 0xe4, 0x5b,
	0x2a, 0xf7, 0x36, 0x77, 0x52, 0x7a, 0x89, 0xc3, 0xd3, 0x77, 0xb2, 0x06, 0xd2, 0xf4, 0xe8, 0xa0,
	0xb7, 0x61, 0xd9, 0xc5, 0xcf, 0x8c, 0x78, 0x84, 0xe8, 0x0c, 0x64, 0xf5, 0x92, 0x8b, 0x9f, 0x4d,
	0x1a, 0x49, 0x90, 0x0d, 0xcd, 0x43, 0xbe, 0x5a, 0xc9, 0x4f, 0xb9, 0x02, 0x6b, 0xa7, 0xf6, 0x14,
	0xbd, 0x0f, 0x92, 0xc9, 0x5e, 0x18, 0xd6, 0xc8, 0x67, 0x26, 0x2a, 0x83, 0x5c, 0xe5, 0xf4, 0x2a,
	0x27, 0xcb, 0xbf, 0x97, 0x86, 0xa2, 0xa0, 0x2e, 0xea, 0x41, 0x3e, 0x72, 0x94, 0x79, 0x4a, 0xf3,
	0xc1, 0xb9, 0x06, 0xa2, 0x1b, 0x25, 0x80, 0x71, 0x84, 0xad, 0xc7, 0xc0, 0x51, 0x57, 0xb2, 0x71,
	0x57, 0x2a, 0x4b, 0x90, 0xa3, 0x83, 0x2f, 0x7f, 0x17, 0xd0, 0x49, 0x56, 0xf4, 0x1e, 0xac, 0x62,
	0x97, 0x6c, 0xb2, 0xd8, 0x17, 0xa6, 0xfd, 0x29, 0xe9, 0x2b, 0x9c, 0x1c, 0x35, 0x7c, 0x03, 0x0a,
	0x71, 0xea, 0x99, 0x0e, 0x55, 0x56, 0x9f, 0x10, 0x94, 0x0d, 0x58, 0xa6, 0x93, 0x10, 0xe8, 0xcc,
	0x50, 0x47, 0x6f, 0x02, 0xb0, 0xa8, 0x10, 0x4d, 0x9a, 0xa4, 0x69, 0x7e, 0xa0, 0xc0, 0x28, 0x9a,
	0x15, 0x28, 0xff, 0x9e, 0x85, 0x0b, 0xd4, 0x26, 0xa8, 0xd9, 0x0e, 0x0e, 0xa2, 0xfd, 0xbf, 0x0d,
	0x0b, 0x81, 0xed, 0x3e, 0x3d, 0x7f, 0x72, 0xc2, 0x76, 0x9f, 0xa2, 0xc7, 0xb0, 0x4a, 0x9c, 0x7d,
	0x33, 0x34, 0xfa, 0xfc, 0xe5, 0x79, 0xaf, 0xf0, 0x15, 0x86, 0x13, 0xd1, 0xc8, 0x58, 0xb1, 0x53,
	0x15, 0x5b, 0xcc, 0x28, 0x0d, 0xe8, 0x40, 0xe7, 0xf5, 0x95, 0x88, 0x4c, 0xbb, 0x14, 0xa0, 0x6f,
	0x81, 0xcc, 0x2b, 0x07, 0x2c, 0x4c, 0x16, 0x99, 0xed, 0x62, 0xcb, 0x08, 0x8e, 0x4c, 0xdf, 0xb2,
	0xdd, 0x43, 0x6a, 0xb0, 0xe5, 0xf5, 0x75, 0xd6, 0xa2, 0x1a, 0x37, 0xe8, 0xf0, 0xf7, 0x08, 0x27,
	0xdd, 0x4e, 0xe6, 0x1f, 0x57, 0x67, 0xc9, 0xff, 0x4d, 0x0f, 0xe8, 0xf3, 0x7c, 0xcf, 0xff, 0x53,
	0x67, 0x46, 0xf9, 0x21, 0xe4, 0xe8, 0xd1, 0xff, 0x6a, 0xf2, 0x4f, 0x1b, 0x70, 0x31, 0xce, 0xd3,
	0xc5, 0xb7, 0x4d, 0x94, 0x85, 0xba, 0x10, 0xbf, 0xe2, 0x97, 0x4d, 0xa0, 0xfc, 0x6b, 0x0e, 0x56,
	0xa2, 0x48, 0x0e, 0x4b, 0x82, 0x2a, 0xff, 0x90, 0xe3, 0x96, 0xc5, 0x3b, 0x90, 0xab, 0x3c, 0xe9,
	0xaa, 0x1d, 0x29, 0x25, 0xbf, 0x4e, 0xc3, 0x31, 0x17, 0x69, 0x38, 0x86, 0xa2, 0x6e, 0x1d, 0x8c,
	0x43, 0x16, 0x8a, 0xbc, 0x0e, 0xc5, 0x4e, 0x57, 0xd7, 0x9a, 0x0f, 0x8c, 0xdd, 0x6e, 0xed, 0xae,
	0x04, 0x89, 0xec, 0x03, 0x6b, 0x4b, 0x7c, 0x5a, 0xf7, 0xd0, 0x18, 0x85, 0xfd, 0xbb, 0x84, 0xe3,
	0xeb, 0x90, 0x79, 0xb4, 0x27, 0xa5, 0xe5, 0xcb, 0xb4, 0xa1, 0x24, 0x34, 0x7c, 0x7a, 0x4c, 0xde,
	0x2b, 0xb0, 0x50, 0x69, 0xb5, 0xea, 0x52, 0x49, 0x5e, 0xa7, 0x2d, 0x90, 0x28, 0xd6, 0xf3, 0x1c,
	0xd2, 0xe6, 0x5d, 0x58, 0xdc, 0x2b, 0xeb, 0x5a, 0xb3, 0x2b, 0x65, 0x64, 0x99, 0xb6, 0xba, 0x24,
	0xb4, 0x3a, 0x36, 0x7d, 0xdb, 0x0d, 0x79, 0xbb, 0x6a, 0x6b, 0xb7, 0x52, 0x57, 0xa5, 0xe2, 0x29,
	0xed, 0x2c, 0x6f, 0xc4, 0xa3, 0x4f, 0x1f, 0x08, 0xe1, 0xaa, 0x6c, 0x22, 0x3f, 0xc0, 0x5a, 0x8a,
	0x91, 0xaa, 0x77, 0x20, 0xd7, 0xd5, 0x1a, 0xaa, 0x2e, 0x2d, 0x9c, 0x32, 0x2e, 0xd4, 0x6c, 0x63,
	0xf9, 0x8b, 0x55, 0xad, 0xd9, 0x55, 0xf5, 0xbd, 0xb8, 0xf4, 0x43, 0xca, 0x25, 0x82, 0xea, 0x1c,
	0xd8, 0x0d, 0xb1, 0x7f, 0x6c, 0x3a, 0x3c, 0x81, 0xc1, 0x42, 0xf1, 0xcb, 0x75, 0xb5, 0xf9, 0xa0,
	0xbb, 0x63, 0xb4, 0x75, 0xb5, 0xa6, 0x3d, 0x96, 0x16, 0x13, 0xe1, 0x30, 0xc6, 0xe7, 0x60, 0xf7,
	0x30, 0x3c, 0x32, 0x86, 0x3e, 0xee, 0xdb, 0x5f, 0x72, 0xae, 0x44, 0xa1, 0x89, 0xb4, 0x74, 0x0a,
	0x17, 0xcb, 0x11, 0x08, 0xb2, 0x6e, 0xc3, 0x0a, 0x6b, 0x1e, 0x45, 0xa3, 0xa5, 0x7c, 0x22, 0xa7,
	0xc3, 0xd8, 0xe2, 0xbd, 0xcd, 0x96, 0x2d, 0x0d, 0x88, 0x5e, 0x6a, 0x97, 0xf5, 0x72, 0xc3, 0x98,
	0xe2, 0x5e, 0x49, 0x24, 0x29, 0x18, 0xf7, 0xd0, 0xf4, 0xcd, 0x81, 0x71, 0x12, 0xa3, 0x0a, 0x6b,
	0x9d, 0x6e, 0xb9, 0xab, 0x1a, 0x95, 0xf2, 0xf6, 0x23, 0xb5, 0x6a, 0xc4, 0x13, 0x50, 0x90, 0xdf,
	0xa7, 0x20, 0x6f, 0x27, 0xd6, 0x90, 0x19, 0x62, 0xe3, 0xc0, 0xec, 0x3d, 0xc5, 0x96, 0x21, 0xce,
	0xc6, 0x55, 0xc8, 0xea, 0xad, 0x7d, 0x69, 0x59, 0x7e, 0x8d, 0xf2, 0x5c, 0x10, 0x78, 0x7c, 0xda,
	0x47, 0xe5, 0xcf, 0x16, 0x23, 0x53, 0x52, 0x08, 0xb7, 0xbd, 0x5a, 0x53, 0x12, 0xed, 0x41, 0x89,
	0xe5, 0x14, 0x88, 0x9e, 0xa3, 0x80, 0x5b, 0xc0, 0x37, 0x67, 0x71, 0x3d, 0x09, 0x5b, 0x87, 0x72,
	0x31, 0x1b, 0xb8, 0x38, 0x98, 0x50, 0xd0, 0xbb, 0xd1, 0xc1, 0x3a, 0x31, 0x1d, 0xd9, 0x0d, 0xb6,
	0xcc, 0xc8, 0x91, 0x5b, 0x54, 0x85, 0xa5, 0xd0, 0xb7, 0x0f, 0x0f, 0xb1, 0xcf, 0xbd, 0xde, 0x0f,
	0x66, 0xb9, 0x41, 0x19, 0x87, 0x1e, 0xb1, 0x22, 0x0c, 0x17, 0x62, 0x8b, 0xd4, 0xf6, 0x5c, 0x83,
	0xb0, 0x50, 0xbf, 0x77, 0x65, 0xf3, 0xee, 0x2c, 0xf6, 0x9f, 0xc0, 0xdb, 0xf0, 0x2c, 0xcc, 0xfa,
	0x23, 0x99, 0x53, 0x64, 0xe2, 0x4f, 0xf1, 0x1b, 0x90, 0xec, 0x96, 0xf5, 0xc5, 0x99, 0xfd, 0x29,
	0x96, 0xd6, 0x25, 0x77, 0x35, 0xf7, 0xa7, 0xbc, 0x98, 0x80, 0x0e, 0x40, 0xea, 0x39, 0x1e, 0xb5,
	0xeb, 0x0e, 0xf0, 0x91, 0x79, 0x6c, 0x7b, 0x3e, 0x8d, 0xaa, 0xad, 0xcc, 0x64, 0xba, 0x6e, 0x33,
	0xd6, 0x0a, 0xe7, 0x64, 0xf0, 0xab, 0xbd, 0x24, 0x95, 0xda, 0x38, 0x8e, 0x43, 0x57, 0xb1, 0x63,
	0x86, 0xd8, 0xc5, 0x41, 0x40, 0xc3, 0x70, 0xc4, 0xc6, 0x61, 0xf4, 0x3a, 0x27, 0xa3, 0x2f, 0x60,
	0xa5, 0xe5, 0x12, 0xc5, 0x22, 0xe6, 0xf5, 0x02, 0x55, 0xe6, 0xf6, 0x2c, 0xdd, 0x4c, 0x30, 0x32,
	0x5d, 0xa6, 0xd0, 0x88, 0xfb, 0x68, 0x06, 0x81, 0x7d, 0xe8, 0x06, 0x46, 0xe8, 0x19, 0x9e, 0x1b,
	0x65, 0x40, 0x79, 0x70, 0x0f, 0xf1, 0x97, 0x5d, 0xaf, 0xe5, 0x62, 0xb6, 0xf8, 0x4f, 0xc9, 0xbc,
	0x17, 0x4f, 0xc9, 0xbc, 0x2b, 0xdf, 0x83, 0xa2, 0xb0, 0x26, 0x95, 0xc6, 0x59, 0x7e, 0xe6, 0x2a,
	0x14, 0x9b, 0xad, 0x26, 0xcd, 0xc2, 0x69, 0xcd, 0x07, 0x52, 0x9a, 0x12, 0x54, 0xb5, 0xda, 0x61,
	0x89, 0x39, 0x29, 0x83, 0x10, 0xac, 0x94, 0xeb, 0xba, 0x5a, 0xae, 0xf2, 0x5c, 0x5d, 0x55, 0xca,
	0x2a, 0xdf, 0x07, 0x69, 0x7a, 0x99, 0x28, 0xda, 0x59, 0x22, 0x56, 0x00, 0xaa, 0x5a, 0x67, 0xbb,
	0xac, 0x57, 0x99, 0x04, 0x09, 0x4a, 0x71, 0x6e, 0x8b, 0x50, 0x32, 0xa4, 0x85, 0xae, 0xd2, 0x14,
	0x1d, 0x79, 0xce, 0x2a, 0x9f, 0xc1, 0xea, 0xd4, 0x54, 0x2a, 0x9f, 0x3e, 0xa7, 0x03, 0x6a, 0x43,
	0xeb, 0x1a, 0xe5, 0xfa, 0x7e, 0xf9, 0x49, 0x47, 0x4a, 0xa3, 0x4b, 0x20, 0x51, 0x82, 0x56, 0x33,
	0x9a, 0xad, 0xa6, 0xda, 0x68, 0x77, 0x9f, 0x48, 0x19, 0xa5, 0x3d, 0x3d, 0x93, 0xcf, 0x45, 0xac,
	0x69, 0xba, 0x9a, 0x40, 0xa4, 0x84, 0x24, 0xe2, 0x01, 0xc0, 0x64, 0x25, 0x2b, 0xdd, 0xb3, 0xd0,
	0x2e, 0xc0, 0xb2, 0xda, 0xac, 0x1a, 0xad, 0x5a, 0x74, 0xa2, 0xa7, 0xc9, 0x88, 0xd6, 0xcb, 0x34,
	0x03, 0xaf, 0x35, 0x8d, 0x76, 0xb9, 0x49, 0x46, 0x99, 0x68, 0x5d, 0xd6, 0xeb, 0x9a, 0x48, 0xcd,
	0x2a, 0x0e, 0xc0, 0x24, 0xfa, 0xa0, 0x7c, 0xf1, 0x9c, 0x11, 0x56, 0xf7, 0xd4, 0x66, 0x97, 0x96,
	0x24, 0x4a, 0x69, 0x74, 0x11, 0x56, 0x79, 0x2a, 0x89, 0xdc, 0xe8, 0x94, 0x98, 0x41, 0x57, 0xe1,
	0x8d, 0xce, 0x93, 0xe6, 0xf6, 0x8e, 0xde, 0x6a, 0xd2, 0xf4, 0xd2, 0x74, 0x8b, 0xac, 0xf2, 0x4b,
	0x09, 0x96, 0xf8, 0x69, 0x82, 0x74, 0x28, 0x98, 0xfd, 0x10, 0xfb, 0x86, 0xe9, 0x38, 0xfc, 0x60,
	0xbd, 0x39, 0xfb, 0x61, 0xb4, 0x51, 0x26, 0xbc, 0x65, 0xc7, 0xd9, 0x49, 0xe9, 0x79, 0x93, 0xff,
	0x16, 0x30, 0xdd, 0x31, 0x37, 0xb8, 0xe6, 0xc7, 0x74, 0xc7, 0x13, 0x4c, 0x77, 0x8c, 0x76, 0x01,
	0x18, 0x26, 0x36, 0x7b, 0x47, 0xdc, 0x01, 0xfb, 0x64, 0x5e, 0x50, 0xd5, 0xec, 0x1d, 0xed, 0xa4,
	0x74, 0xa6, 0x1d, 0x79, 0x40, 0x0e, 0x5c, 0xe4, 0xb0, 0xae, 0x65, 0x78, 0xfd, 0x68, 0x5b, 0x2e,
	0xcc, 0x1c, 0x9f, 0x4d, 0xe2, 0xbb, 0x56, 0xab, 0xcf, 0xf6, 0xef, 0x4e, 0x4a, 0x97, 0xcc, 0x29,
	0x1a, 0x0a, 0x61, 0x8d, 0x49, 0x9b, 0x72, 0x6b, 0x79, 0xb4, 0xf2, 0xd3, 0x79, 0xe5, 0x9d, 0x74,
	0x5f, 0xcd, 0x93, 0x64, 0xf4, 0xb3, 0x34, 0x28, 0x4c, 0x6c, 0x30, 0x76, 0x7b, 0x47, 0xbe, 0xe7,
	0xd2, 0x94, 0xe1, 0xb4, 0x0e, 0x8b, 0x54, 0x87, 0x87, 0xf3, 0xea, 0xd0, 0x11, 0x30, 0x4f, 0xe8,
	0x73, 0xc5, 0x7c, 0x7e, 0x13, 0xf4, 0x08, 0x16, 0x4d, 0xe7, 0x99, 0x39, 0x0e, 0xd6, 0x4b, 0x54,
	0xfc, 0x8d, 0x79, 0xc4, 0x53, 0xc6, 0x9d, 0x94, 0xce, 0x21, 0x50, 0x13, 0x96, 0x2c, 0xdc, 0x37,
	0x47, 0x4e, 0x48, 0xef, 0x92, 0x19, 0x63, 0xfa, 0x1c, 0xad, 0xca, 0x38, 0x77, 0x52, 0x7a, 0x04,
	0x82, 0xbe, 0x98, 0xf8, 0xfd, 0x3d, 0x6f, 0xe4, 0x86, 0xf4, 0xf6, 0x98, 0x2d, 0xb8, 0x12, 0xa1,
	0xaa, 0x51, 0xbc, 0x72, 0xe4, 0x86, 0x82, 0xa3, 0x4f, 0x9f, 0xd1, 0x0e, 0xe4, 0x5c, 0x7c, 0x8c,
	0xd9, 0x65, 0x53, 0xdc, 0xbc, 0x3e, 0x07, 0x6e, 0x93, 0xf0, 0xed, 0xa4, 0x74, 0x06, 0x40, 0x76,
	0x87, 0xe7, 0xb3, 0x84, 0x93, 0x33, 0xa6, 0x97, 0xca, 0x7c, 0xbb, 0xa3, 0xe5, 0xd7, 0x18, 0x2f,
	0xd9, 0x1d, 0x5e, 0xf4, 0x40, 0x66, 0xc7, 0xc7, 0x43, 0x6c, 0xb2, 0x64, 0xd2, 0x7c, 0xb3, 0xa3,
	0x53, 0x46, 0x32, 0x3b, 0x0c, 0x42, 0x7e, 0x0c, 0xf9, 0xe8, 0xb4, 0x40, 0x75, 0x28, 0xd2, 0x1a,
	0x3b, 0xda, 0x34, 0x0a, 0x23, 0xcc, 0x63, 0x04, 0x89, 0xec, 0x13, 0x64, 0x77, 0xfc, 0x8a, 0x91,
	0x9f, 0x40, 0x21, 0x3e, 0x38, 0x5e, 0x31, 0xf4, 0xaf, 0xd3, 0x20, 0x4d, 0x1f, 0x1a, 0xa8, 0x05,
	0xcb, 0xd8, 0xf4, 0x9d, 0xb1, 0xd1, 0xb7, 0x89, 0x13, 0x16, 0x15, 0x7f, 0xce, 0x23, 0xa4, 0x44,
	0x01, 0x6a, 0x8c, 0x1f, 0x35, 0xa0, 0x44, 0x6c, 0x9f, 0x18, 0x2f, 0x33, 0x37, 0x5e, 0x91, 0xf0,
	0x73, 0x38, 0xf9, 0x77, 0xe0, 0xe2, 0x29, 0x07, 0x0f, 0x3a, 0x82, 0x4b, 0x71, 0x08, 0xc5, 0x38,
	0x51, 0xf1, 0x7e, 0x6b, 0xc6, 0xd8, 0x3b, 0x65, 0x9f, 0x94, 0x38, 0x5f, 0x0c, 0x4f, 0xd0, 0x02,
	0xf9, 0x2d, 0xb8, 0xf2, 0x82, 0x53, 0x47, 0x2e, 0xc0, 0x12, 0xdf, 0xcb, 0xf2, 0x4d, 0x28, 0x89,
	0x1b, 0x10, 0xbd, 0x3d, 0xbd, 0xa1, 0xc9, 0xf0, 0xe6, 0x92, 0xbb, 0x52, 0x5e, 0x82, 0x1c, 0xdd,
	0x5d, 0x72, 0x1e, 0x16, 0xd9, 0x11, 0x23, 0xff, 0x38, 0x0d, 0x85, 0x78, 0x8b, 0xa0, 0x4f, 0x61,
	0x21, 0xce, 0x2c, 0xcc, 0x37, 0x96, 0x94, 0x8f, 0x58, 0xff, 0xd1, 0x4e, 0x9d, 0x7f, 0x3a, 0x22,
	0x56, 0xb9, 0x0b, 0x8b, 0x6c, 0x8b, 0xa1, 0x87, 0x00, 0x93, 0x85, 0x75, 0x0e, 0xad, 0x04, 0xee,
	0x4a, 0x21, 0xf6, 0x4c, 0x94, 0xbf, 0xc9, 0x08, 0x81, 0xb6, 0x49, 0x65, 0x6e, 0x07, 0x72, 0x16,
	0x76, 0xcc, 0xf1, 0x1c, 0x39, 0xcc, 0x93, 0x28, 0x1b, 0x55, 0x02, 0x41, 0xce, 0x2f, 0x8a, 0x85,
	0x3e, 0x87, 0xbc, 0xe9, 0xd8, 0x87, 0xae, 0x11, 0x7a, 0x7c, 0x4c, 0xbe, 0x7d, 0x3e, 0xdc, 0x32,
	0x41, 0xe9, 0x7a, 0xe4, 0x14, 0x37, 0xd9, 0x4f, 0xf9, 0x03, 0xc8, 0x51, 0x69, 0xe8, 0x2d, 0x28,
	0x51, 0x69, 0xc6, 0xc0, 0x76, 0x1c, 0x3b, 0xe0, 0xf1, 0xce, 0x22, 0xa5, 0x35, 0x28, 0x49, 0xbe,
	0x07, 0x4b, 0x1c, 0x01, 0x5d, 0x86, 0xc5, 0x21, 0xf6, 0x6d, 0x8f, 0xb9, 0x70, 0x59, 0x9d, 0x3f,
	0x11, 0xba, 0xd7, 0xef, 0x07, 0x38, 0xa4, 0x46, 0x42, 0x56, 0xe7, 0x4f, 0x95, 0x35, 0xb8, 0x78,
	0xca, 0x1e, 0x50, 0x7e, 0x3f, 0x03, 0x85, 0x38, 0x92, 0x84, 0xf6, 0x60, 0xc5, 0xec, 0xd1, 0xb2,
	0x9d, 0xa1, 0x19, 0x86, 0xd8, 0x3f, 0xb7, 0x2f, 0xbb, 0xcc, 0x60, 0xda, 0x0c, 0x05, 0xed, 0xc0,
	0xd2, 0xb1, 0x8d, 0x9f, 0xbd, 0x44, 0x9a, 0x6f, 0x91, 0xf0, 0xd7, 0x5c, 0xf4, 0x5d, 0xb8, 0xc0,
	0x5d, 0xd8, 0x81, 0x39, 0x1c, 0x12, 0xe3, 0xa0, 0xef, 0x72, 0x73, 0x6b, 0x6e, 0x4c, 0xee, 0x0c,
	0x37, 0x18, 0x50, 0xcd, 0x55, 0xfe, 0x33, 0x03, 0x17, 0xa2, 0xf8, 0x55, 0xd9, 0x0f, 0xed, 0xbe,
	0xd9, 0x0b, 0x03, 0xe5, 0xe7, 0x19, 0xc8, 0xd1, 0x72, 0x24, 0xf4, 0x01, 0x2c, 0xd4, 0x34, 0x5a,
	0x82, 0x74, 0x95, 0x86, 0x07, 0x64, 0x1a, 0x1e, 0x30, 0x79, 0xcb, 0xad, 0x70, 0x3c, 0xc4, 0x5b,
	0x7d, 0x9b, 0x45, 0x12, 0xae, 0x41, 0x76, 0x57, 0xaf, 0x4f, 0x55, 0xe9, 0x26, 0x9b, 0x8e, 0x7c,
	0x1a, 0x7d, 0xda, 0x84, 0xbc, 0xda, 0xa8, 0xa8, 0x55, 0x9a, 0x54, 0x4b, 0x54, 0xe8, 0x26, 0x9b,
	0xe3, 0xc1, 0x01, 0xb6, 0x2c, 0x6c, 0xb1, 0x08, 0xd3, 0x42, 0xfb, 0x49, 0x5b, 0x93, 0xb2, 0xcf,
	0xd1, 0x64, 0x38, 0x1e, 0xda, 0xac, 0x9a, 0x37, 0xd7, 0x28, 0xef, 0xa9, 0x4d, 0x69, 0x21, 0x11,
	0xc3, 0x49, 0x36, 0x1e, 0x98, 0xc7, 0xac, 0x66, 0x78, 0x13, 0xf2, 0x55, 0xb5, 0xa6, 0xea, 0xba,
	0x5a, 0x95, 0x72, 0xcf, 0xd1, 0xc6, 0xc2, 0x7d, 0xec, 0xfb, 0x54, 0x1b, 0xe5, 0x3e, 0xe4, 0x74,
	0xcf, 0xc1, 0x01, 0xba, 0x0d, 0xd0, 0xe9, 0x96, 0x1f, 0x50, 0x5b, 0xbe, 0x25, 0xa5, 0xe4, 0x77,
	0x29, 0xfb, 0xd5, 0x24, 0xbb, 0xef, 0x39, 0x78, 0x2b, 0x08, 0xcd, 0x43, 0x6a, 0xda, 0x79, 0x04,
	0xa0, 0x0c, 0x17, 0xa3, 0xf1, 0xae, 0xd9, 0x4e, 0x9c, 0x3f, 0x43, 0xb0, 0x30, 0x34, 0xc3, 0x23,
	0x1e, 0x28, 0xa5, 0xbf, 0xc9, 0xfa, 0x0e, 0x8e, 0xcc, 0xcd, 0x5b, 0xb7, 0x79, 0x1e, 0x81, 0x3f,
	0x29, 0xef, 0x02, 0x8a, 0x20, 0x76, 0x7d, 0x27, 0x42, 0x90, 0x20, 0x3b, 0xf2, 0x9d, 0x28, 0xd2,
	0x3a, 0xf2, 0x1d, 0xe5, 0x7d, 0xb8, 0xa8, 0xf2, 0x81, 0x9c, 0x12, 0x45, 0xab, 0xa4, 0x58, 0x50,
	0x9e, 0xfe, 0x56, 0x76, 0xa0, 0xd8, 0x1e, 0xb7, 0xb5, 0xa8, 0xc9, 0x15, 0x28, 0x46, 0x7d, 0x10,
	0xb2, 0xc9, 0x11, 0x49, 0xb3, 0xd0, 0x3a, 0x2c, 0x1d, 0x63, 0x3f, 0x88, 0x22, 0xe1, 0x05, 0x3d,
	0x7a, 0x54, 0x3e, 0x83, 0x52, 0x83, 0x0c, 0x70, 0x04, 0x25, 0x43, 0x3e, 0xe2, 0xe3, 0x38, 0xf1,
	0x33, 0x71, 0xac, 0x7d, 0x4c, 0x0b, 0x7f, 0x3d, 0x7f, 0x6c, 0x10, 0xed, 0x19, 0xd8, 0xf2, 0x84,
	0xba, 0xeb, 0x3b, 0xca, 0x7d, 0x78, 0xad, 0xca, 0xa7, 0x20, 0xea, 0xb7, 0xd0, 0xe9, 0xa9, 0xf0,
	0x72, 0xd4, 0xbb, 0x8c, 0xd0, 0xbb, 0xfb, 0xf0, 0x46, 0xc4, 0xd8, 0x61, 0x93, 0xd1, 0xf5, 0xc8,
	0x2c, 0x0a, 0xdd, 0x25, 0x93, 0x84, 0xad, 0x44, 0x05, 0x1c, 0x23, 0x35, 0xcd, 0x01, 0x56, 0x7e,
	0x9c, 0x9e, 0xcc, 0x9a, 0xe6, 0xb2, 0x18, 0xbe, 0xed, 0xb9, 0xe8, 0x75, 0xc8, 0x93, 0x15, 0x62,
	0x8c, 0xf8, 0xf1, 0x51, 0xd0, 0x97, 0xc8, 0xf3, 0xae, 0xef, 0x92, 0x23, 0x8e, 0xbe, 0x1a, 0x32,
	0x19, 0x5c, 0x9f, 0x22, 0xa1, 0x09, 0xb9, 0x49, 0xb2, 0x40, 0x28, 0x37, 0x0b, 0x4e, 0x2d, 0x91,
	0x67, 0xce, 0x4d, 0x5f, 0x45, 0xdc, 0x0b, 0x8c, 0xdb, 0x9f, 0x28, 0xad, 0xfc, 0x24, 0x03, 0x45,
	0xe1, 0x13, 0x16, 0x36, 0xff, 0xd1, 0x74, 0x90, 0x9f, 0x64, 0x92, 0x22, 0xfe, 0x2c, 0xe5, 0x8f,
	0x1e, 0x4f, 0x14, 0xcc, 0x2d, 0xbc, 0x92, 0x2f, 0x4b, 0x7a, 0xe6, 0xd0, 0x3c, 0xb0, 0x1d, 0x3b,
	0xb4, 0x31, 0xcb, 0x31, 0x14, 0xf4, 0x04, 0x0d, 0x7d, 0x4e, 0x8e, 0xfd, 0x21, 0x76, 0x2d, 0xec,
	0xf6, 0x48, 0x1b, 0xf6, 0x55, 0xc4, 0x2c, 0x91, 0x9d, 0x53, 0x06, 0x5f, 0x4f, 0x60, 0x3d, 0x5c,
	0xc8, 0xa7, 0xa5, 0x8c, 0xf2, 0xf3, 0x34, 0x5c, 0x8a, 0x8e, 0x35, 0xf1, 0xb3, 0x21, 0xe5, 0x47,
	0x69, 0x28, 0x89, 0x04, 0xf4, 0x0e, 0x2c, 0x56, 0x5b, 0xdb, 0x8f, 0x54, 0x5d, 0x4a, 0x25, 0xc2,
	0xe5, 0xd8, 0x3d, 0xde, 0xb2, 0xbc, 0xde, 0x53, 0x16, 0x8c, 0x7e, 0x17, 0x96, 0xb8, 0xd3, 0x2e,
	0xa5, 0x13, 0x41, 0x6b, 0xd2, 0x8c, 0xbb, 0x6d, 0xec, 0x08, 0xcc, 0xab, 0x8f, 0xbb, 0xaa, 0xde,
	0x2c, 0xd7, 0xa7, 0x02, 0xeb, 0xa4, 0x21, 0xfe, 0x92, 0x5c, 0x0d, 0x26, 0x39, 0x02, 0x95, 0xbb,
	0xb0, 0x5c, 0xa5, 0xf0, 0xd1, 0x2a, 0x78, 0x0f, 0x56, 0x7b, 0x9e, 0x1b, 0x9a, 0xb6, 0x8b, 0x7d,
	0xc3, 0x1e, 0x98, 0x87, 0xd1, 0x02, 0x5c, 0x89, 0xc9, 0x1a, 0xa1, 0x2a, 0xff, 0x9c, 0x86, 0x15,
	0x6e, 0x60, 0x45, 0xbc, 0x2b, 0x90, 0xf1, 0x02, 0xde, 0x3c, 0xe3, 0x05, 0x64, 0xf1, 0x9b, 0x7e,
	0xef, 0x88, 0x2f, 0x02, 0xfa, 0x9b, 0xac, 0x82, 0x9e, 0x37, 0x18, 0x98, 0x6e, 0x14, 0x01, 0x8d,
	0x1e, 0x51, 0x1d, 0xb2, 0xd8, 0x3d, 0x9e, 0xe7, 0xb3, 0x97, 0x84, 0xf4, 0x0d, 0xd5, 0x3d, 0x66,
	0x39, 0x20, 0x02, 0x23, 0xdf, 0x86, 0x7c, 0x44, 0x98, 0xeb, 0xcb, 0x91, 0xff, 0x4a, 0xc3, 0xaa,
	0xca, 0x07, 0x28, 0xea, 0x97, 0x98, 0x46, 0x4f, 0xbf, 0xa2, 0x34, 0x3a, 0xda, 0x83, 0x45, 0x1a,
	0x51, 0x8f, 0xf2, 0xfd, 0xb3, 0xf8, 0xf8, 0x53, 0x8a, 0x6d, 0xb4, 0x29, 0x00, 0xff, 0x82, 0x88,
	0xa1, 0xc9, 0xf7, 0xa0, 0x28, 0x90, 0xe7, 0xea, 0xfb, 0x5f, 0x09, 0xb7, 0x70, 0xdb, 0xf7, 0x42,
	0xaf, 0xe7, 0x39, 0x81, 0xf2, 0xcb, 0x0c, 0x8f, 0x3a, 0xed, 0xc0, 0xeb, 0x75, 0xf5, 0x41, 0x79,
	0xfb, 0x89, 0xd1, 0xd6, 0x5b, 0x0f, 0x74, 0xb5, 0xd3, 0x31, 0x74, 0xb5, 0xdd, 0xd2, 0x69, 0xcc,
	0x2e, 0x95, 0x08, 0xf6, 0x0f, 0x39, 0x37, 0xf9, 0x71, 0xe8, 0x13, 0xb3, 0x86, 0x9c, 0xa1, 0x7e,
	0x68, 0xbb, 0x87, 0x5b, 0xc7, 0xd7, 0x51, 0x19, 0xd0, 0x29, 0x10, 0xe9, 0xd9, 0x21, 0x6e, 0xa0,
	0x3b, 0xb0, 0xbc, 0xdf, 0xd2, 0x1f, 0xa9, 0xba, 0xd1, 0xe9, 0x96, 0xbb, 0xbb, 0x9d, 0xa9, 0x0b,
	0x3c, 0xe6, 0x7e, 0xe6, 0xf9, 0x4f, 0xb1, 0xcf, 0xe3, 0xf9, 0x84, 0x71, 0x17, 0xde, 0xa0, 0x05,
	0xca, 0xc6, 0x76, 0x4b, 0x57, 0x8d, 0xca, 0x6e, 0xb3, 0x5a, 0x57, 0x85, 0x50, 0x98, 0x94, 0x95,
	0x6f, 0x52, 0x9c, 0x8f, 0x92, 0x38, 0xb4, 0x64, 0xd9, 0xe8, 0x79, 0x3e, 0x36, 0x0e, 0x46, 0xae,
	0x45, 0x0e, 0xc3, 0xd8, 0xbb, 0x20, 0x1b, 0xe9, 0x57, 0xd9, 0xc9, 0x56, 0xd7, 0xc5, 0xef, 0xd7,
	0xfe, 0x20, 0xcb, 0x87, 0xef, 0x21, 0xbc, 0xa1, 0xab, 0x9f, 0xed, 0x6a, 0xba, 0xda, 0xa1, 0x3a,
	0xab, 0xb5, 0xdd, 0xba, 0x28, 0x38, 0x95, 0xc8, 0xb9, 0x08, 0xdf, 0xc0, 0xf1, 0x8f, 0x90, 0x68,
	0xea, 0xa4, 0x3f, 0x72, 0x58, 0x61, 0xfc, 0x04, 0x8b, 0x77, 0xa1, 0xa6, 0x35, 0xcb, 0x75, 0xed,
	0xf3, 0x32, 0xaf, 0xb4, 0x17, 0x8b, 0xda, 0x4f, 0x62, 0x89, 0x15, 0xa8, 0x04, 0xef, 0x01, 0xac,
	0x89, 0xba, 0x55, 0xea, 0xaa, 0xa1, 0x35, 0xdb, 0xbb, 0x5d, 0x29, 0xf3, 0x02, 0x20, 0xb1, 0xb0,
	0x94, 0x00, 0x7d, 0x06, 0x72, 0x0c, 0xd4, 0xd5, 0x1a, 0xaa, 0xd1, 0x69, 0xe9, 0x5d, 0xb5, 0xca,
	0xd1, 0xb2, 0x89, 0x4f, 0x09, 0x4e, 0xa2, 0x9d, 0xa8, 0x71, 0x25, 0x90, 0x0d, 0x58, 0x9f, 0xe8,
	0xd6, 0xae, 0x6b, 0x5d, 0xa6, 0x5f, 0xb5, 0x55, 0x23, 0x86, 0xd5, 0xc7, 0x14, 0xf0, 0xfd, 0xb3,
	0xd4, 0x8b, 0x3f, 0x77, 0x30, 0x2c, 0xaf, 0x4f, 0xba, 0xaa, 0x6c, 0x41, 0x49, 0xb4, 0x45, 0xa3,
	0x8b, 0x2a, 0x3d, 0xc3, 0x45, 0xa5, 0xe0, 0xc9, 0x57, 0x65, 0xc2, 0xcd, 0xa3, 0x34, 0xa1, 0x28,
	0x3c, 0xa2, 0xfb, 0xb0, 0x5a, 0x2f, 0x57, 0xd4, 0x7a, 0x5d, 0xad, 0x1a, 0x2c, 0xa7, 0x2a, 0xa5,
	0xe4, 0x0f, 0xa8, 0x9e, 0xef, 0x50, 0x3d, 0xc5, 0xcb, 0x6e, 0xcb, 0x31, 0x0f, 0xb0, 0xe3, 0x60,
	0xcb, 0x60, 0xe9, 0x55, 0xa2, 0xe2, 0x36, 0xac, 0xd5, 0x39, 0xb5, 0x43, 0x89, 0xd1, 0x41, 0x74,
	0x09, 0x72, 0xb4, 0x39, 0xd7, 0x96, 0x3d, 0x9c, 0xbe, 0xa1, 0x95, 0x7b, 0x49, 0xa5, 0x9e, 0xdb,
	0xcd, 0x4c, 0xb2, 0x9b, 0xff, 0xb2, 0x04, 0x6b, 0x0d, 0x1c, 0x04, 0xe6, 0x21, 0xde, 0xb7, 0xc3,
	0x23, 0xe1, 0x23, 0x91, 0x57, 0xfc, 0x01, 0xea, 0x77, 0x20, 0x47, 0xf3, 0x61, 0xf3, 0x7e, 0x91,
	0x4b, 0xfc, 0x43, 0xca, 0x88, 0xbe, 0x47, 0xae, 0x2b, 0xfe, 0x05, 0x8c, 0x30, 0x67, 0xb3, 0x45,
	0xa4, 0x92, 0x45, 0x63, 0x3b, 0x29, 0x9d, 0xd7, 0xb4, 0xc6, 0x26, 0xd1, 0x1e, 0x2c, 0x47, 0x25,
	0x16, 0xf3, 0x96, 0xa2, 0x8a, 0x6b, 0x6c, 0x27, 0xa5, 0x97, 0xfa, 0xe2, 0x9a, 0xdb, 0x87, 0x95,
	0xa1, 0xe9, 0x1b, 0x96, 0x17, 0x2b, 0xbd, 0x38, 0x33, 0xb0, 0x58, 0xaf, 0x4e, 0x80, 0x87, 0xe2,
	0x67, 0x01, 0x2d, 0x80, 0x61, 0xec, 0x62, 0xf2, 0x58, 0xe7, 0x7c, 0x1f, 0x90, 0xef, 0xa4, 0x74,
	0x01, 0x02, 0xe9, 0x50, 0x14, 0x3e, 0xfa, 0xe7, 0x71, 0xce, 0x39, 0x3f, 0x11, 0xdf, 0x49, 0xe9,
	0x22, 0x08, 0xea, 0x40, 0x89, 0x56, 0x3f, 0x47, 0x7d, 0x2f, 0xcc, 0x0c, 0x2a, 0xd4, 0x3c, 0x12,
	0x50, 0x5f, 0x28, 0x81, 0x6c, 0x00, 0x4c, 0x6a, 0x4a, 0x78, 0x54, 0x72, 0xae, 0x62, 0x8e, 0x9d,
	0x94, 0x5e, 0x88, 0x8b, 0x47, 0x50, 0x1f, 0x2e, 0x0a, 0xdf, 0x4c, 0xc6, 0xaa, 0x96, 0xe6, 0xfc,
	0x54, 0x5d, 0x28, 0x7a, 0xdc, 0x49, 0xe9, 0xdc, 0x81, 0x16, 0x2b, 0x21, 0x31, 0xa0, 0x93, 0xdf,
	0x97, 0xac, 0x2f, 0x9f, 0xff, 0x8b, 0xf8, 0x89, 0x18, 0x81, 0x58, 0x59, 0x84, 0x05, 0xdf, 0xf3,
	0x42, 0xe5, 0x37, 0x00, 0x97, 0xd5, 0x2f, 0x71, 0x6f, 0x44, 0xcf, 0x44, 0xe2, 0x7d, 0xc4, 0x6b,
	0xbd, 0x0d, 0x45, 0x21, 0x81, 0xc8, 0xf7, 0xf6, 0xbc, 0x1f, 0xae, 0x8b, 0x10, 0xe8, 0x2b, 0x32,
	0x86, 0x7e, 0x54, 0xe2, 0x1b, 0xe0, 0x30, 0xa4, 0x91, 0x46, 0xf6, 0x69, 0xc6, 0xc3, 0x99, 0xcc,
	0x9d, 0xd3, 0x34, 0xdd, 0xd8, 0xb7, 0x7d, 0x56, 0x21, 0xdc, 0x61, 0x90, 0xa4, 0xc3, 0x49, 0x4a,
	0x40, 0xce, 0x44, 0xb6, 0x12, 0xf8, 0x99, 0x68, 0xf3, 0x59, 0x3d, 0xe5, 0x7b, 0x17, 0xf5, 0xfc,
	0x9a, 0xc4, 0x8b, 0x47, 0xb3, 0x12, 0x5f, 0xbd, 0x7c, 0x3d, 0xf1, 0xf7, 0x1e, 0xec, 0xab, 0x76,
	0xf1, 0xff, 0x39, 0xd6, 0x27, 0x5f, 0x79, 0x33, 0xc7, 0x24, 0xfe, 0x52, 0x3b, 0x79, 0xc0, 0x2e,
	0xbe, 0xec, 0x01, 0xdb, 0x87, 0xe2, 0x28, 0xe0, 0xe6, 0x0f, 0x0e, 0xd6, 0x97, 0x5e, 0xb6, 0xc3,
	0xbb, 0x01, 0xf6, 0x69, 0x39, 0x36, 0xe9, 0xf0, 0x28, 0x7a, 0x08, 0xd0, 0x13, 0x58, 0xa4, 0x15,
	0x33, 0xc1, 0x7a, 0x9e, 0x8a, 0x28, 0x9f, 0x5f, 0x04, 0xad, 0xda, 0xd6, 0x2c, 0x9d, 0x03, 0xa2,
	0x01, 0x2c, 0x4f, 0x6a, 0xa8, 0x89, 0x9b, 0x06, 0x33, 0x97, 0x16, 0x3e, 0x4f, 0x02, 0x2b, 0xc9,
	0xd6, 0x2c, 0x3d, 0x89, 0x2e, 0xb7, 0xa0, 0x28, 0xcc, 0x2a, 0xf5, 0x9b, 0x85, 0x7f, 0x47, 0xe0,
	0xf7, 0x67, 0x31, 0x9c, 0xfc, 0x31, 0x02, 0x7a, 0x13, 0xc0, 0xf1, 0x7a, 0xa6, 0xc3, 0xbc, 0x75,
	0xb6, 0xde, 0x0a, 0x94, 0x42, 0x9c, 0x75, 0x02, 0x28, 0x8c, 0xda, 0x2b, 0x00, 0x7c, 0x04, 0x4b,
	0x7c, 0x8c, 0x5e, 0x01, 0xd8, 0x67, 0xb0, 0x9c, 0x18, 0x8e, 0x57, 0x00, 0xf9, 0x4f, 0x69, 0x90,
	0xa6, 0xb7, 0xe8, 0x3c, 0xe6, 0x07, 0xfa, 0x08, 0x10, 0xdd, 0xa0, 0x86, 0xe7, 0x1b, 0x71, 0x89,
	0x25, 0xf3, 0x16, 0x77, 0x52, 0xfa, 0x2a, 0x7d, 0xd7, 0xf2, 0x5b, 0xbc, 0xd4, 0x12, 0x3d, 0x81,
	0x1c, 0x9d, 0x42, 0x7e, 0x39, 0xbf, 0xfc, 0xd2, 0x23, 0xd6, 0x05, 0x45, 0xac, 0xe4, 0x61, 0x31,
	0x34, 0xfd, 0x43, 0x1c, 0x6e, 0xfe, 0x51, 0x5a, 0x2c, 0xe7, 0xe6, 0x7e, 0x1d, 0xfa, 0x0a, 0x16,
	0x59, 0x51, 0x28, 0x9a, 0x25, 0x45, 0x97, 0xa8, 0x1f, 0x95, 0x5f, 0xa2, 0xbe, 0x5b, 0x49, 0x5d,
	0x4f, 0x6f, 0xdd, 0x87, 0x3c, 0xfd, 0x07, 0x27, 0x32, 0x96, 0x6f, 0x6d, 0xb0, 0x3f, 0x51, 0xda,
	0x88, 0xfe, 0x44, 0x89, 0x16, 0x9b, 0xec, 0x11, 0x3b, 0xb0, 0x35, 0x64, 0x7f, 0x01, 0xf4, 0xb7,
	0xbf, 0xfa, 0xf3, 0xc7, 0xcc, 0xdf, 0x26, 0x5c, 0xbb, 0xbe, 0xbb, 0xa5, 0xc1, 0x32, 0x05, 0xe8,
	0xf1, 0x7f, 0x52, 0x9a, 0x05, 0xe5, 0xef, 0x22, 0x94, 0xd2, 0x81, 0xf0, 0x8f, 0x4c, 0x95, 0x6f,
	0xc2, 0x8b, 0xff, 0x36, 0xaa, 0x52, 0xd0, 0x69, 0x3d, 0x68, 0x79, 0x68, 0x7f, 0x5e, 0x8c, 0xe8,
	0xc6, 0xf1, 0x8d, 0x83, 0x45, 0x2a, 0xee, 0xe6, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x8b, 0xfc,
	0x1e, 0xa0, 0x91, 0x4a, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// TestStreamServiceClient is the client API for TestStreamService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TestStreamServiceClient interface {
	// A TestStream will request for events using this RPC.
	Events(ctx context.Context, in *EventsRequest, opts ...grpc.CallOption) (TestStreamService_EventsClient, error)
}

type testStreamServiceClient struct {
	cc *grpc.ClientConn
}

func NewTestStreamServiceClient(cc *grpc.ClientConn) TestStreamServiceClient {
	return &testStreamServiceClient{cc}
}

func (c *testStreamServiceClient) Events(ctx context.Context, in *EventsRequest, opts ...grpc.CallOption) (TestStreamService_EventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_TestStreamService_serviceDesc.Streams[0], "/org.apache.beam.model.pipeline.v1.TestStreamService/Events", opts...)
	if err != nil {
		return nil, err
	}
	x := &testStreamServiceEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type TestStreamService_EventsClient interface {
	Recv() (*TestStreamPayload_Event, error)
	grpc.ClientStream
}

type testStreamServiceEventsClient struct {
	grpc.ClientStream
}

func (x *testStreamServiceEventsClient) Recv() (*TestStreamPayload_Event, error) {
	m := new(TestStreamPayload_Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// TestStreamServiceServer is the server API for TestStreamService service.
type TestStreamServiceServer interface {
	// A TestStream will request for events using this RPC.
	Events(*EventsRequest, TestStreamService_EventsServer) error
}

// UnimplementedTestStreamServiceServer can be embedded to have forward compatible implementations.
type UnimplementedTestStreamServiceServer struct {
}

func (*UnimplementedTestStreamServiceServer) Events(req *EventsRequest, srv TestStreamService_EventsServer) error {
	return status.Errorf(codes.Unimplemented, "method Events not implemented")
}

func RegisterTestStreamServiceServer(s *grpc.Server, srv TestStreamServiceServer) {
	s.RegisterService(&_TestStreamService_serviceDesc, srv)
}

func _TestStreamService_Events_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(EventsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(TestStreamServiceServer).Events(m, &testStreamServiceEventsServer{stream})
}

type TestStreamService_EventsServer interface {
	Send(*TestStreamPayload_Event) error
	grpc.ServerStream
}

type testStreamServiceEventsServer struct {
	grpc.ServerStream
}

func (x *testStreamServiceEventsServer) Send(m *TestStreamPayload_Event) error {
	return x.ServerStream.SendMsg(m)
}

var _TestStreamService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.pipeline.v1.TestStreamService",
	HandlerType: (*TestStreamServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Events",
			Handler:       _TestStreamService_Events_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "beam_runner_api.proto",
}
