---
title:  "Announcing Beam Katas for Kotlin"
date:   2020-06-01 00:00:01 -0800
categories:
  - blog
aliases:
  - /blog/2020/06/01/beam-katas-kotlin-release.html
authors:
  - rionmonster

---
<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

Today, we are happy to announce a new addition to the Beam Katas family: Kotlin! 

<!--more-->

<img src="/images/blog/beam-katas-kotlin-release/beam-and-kotlin.png" alt="Apache Beam and Kotlin Shaking Hands" height="330" width="800" >

You may remember [a post from last year](https://beam.apache.org/blog/beam-kata-release) that informed everyone of the wonderful Beam Katas available on [Stepik](https://stepik.org) 
for learning more about writing Apache Beam applications, working with its various APIs and programming model 
hands-on, all from the comfort of your favorite IDEs. As of today, you can now work through all of the progressive
exercises to learn about the fundamentals of Beam in Kotlin.

[Kotlin](https://kotlinlang.org) is a modern, open-source, statically typed language that targets the JVM. It is most commonly used by 
Android developers, however it has recently risen in popularity due to its extensive feature set that enables
more concise and cleaner code than Java, without sacrificing performance or type safety. It recently was [ranked
as one of the most beloved programming languages in the annual Stack Overflow Developer Survey](https://insights.stackoverflow.com/survey/2020#technology-most-loved-dreaded-and-wanted-languages-loved), so don't take 
just our word for it. 

The relationship between Apache Beam and Kotlin isn't a new one. You can find examples scattered across the web
of engineering teams embracing the two technologies including [a series of samples announced on this very blog](https://beam.apache.org/blog/beam-kotlin/).
If you are new to Beam or are an experienced veteran looking for a change of pace, we'd encourage you to give 
Kotlin a try.

You can find the Kotlin and the other excellent Beam Katas below (or by just searching for "Beam Katas" within 
[IntelliJ](https://www.jetbrains.com/education/download/#section=idea) or [PyCharm](https://www.jetbrains.com/education/download/#section=pycharm-edu) through [the EduTools plugin](https://plugins.jetbrains.com/plugin/10081-edutools)):

- [**Kotlin**](https://stepik.org/course/72488)
- [**Java**](https://stepik.org/course/54530)
- [**Python**](https://stepik.org/course/54532)
- [**Go (in development)**](https://stepik.org/course/70387)

I'd like to extend a very special thanks to [Henry Suryawirawan](https://twitter.com/henry_ken) for his creation of the original series of Katas 
and his support during the review process and making this effort a reality.

<br />

<img src="/images/blog/beam-katas-kotlin-release/beam-katas-in-edutools.png" alt="Access Beam Katas Kotlin through a JetBrains Educational Product" height="252" width="800" >