// Code generated by protoc-gen-go. DO NOT EDIT.
// source: beam_job_api.proto

package jobmanagement_v1

import (
	context "context"
	fmt "fmt"
	pipeline_v1 "github.com/apache/beam/sdks/go/pkg/beam/model/pipeline_v1"
	proto "github.com/golang/protobuf/proto"
	_struct "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type JobMessage_MessageImportance int32

const (
	JobMessage_MESSAGE_IMPORTANCE_UNSPECIFIED JobMessage_MessageImportance = 0
	JobMessage_JOB_MESSAGE_DEBUG              JobMessage_MessageImportance = 1
	JobMessage_JOB_MESSAGE_DETAILED           JobMessage_MessageImportance = 2
	JobMessage_JOB_MESSAGE_BASIC              JobMessage_MessageImportance = 3
	JobMessage_JOB_MESSAGE_WARNING            JobMessage_MessageImportance = 4
	JobMessage_JOB_MESSAGE_ERROR              JobMessage_MessageImportance = 5
)

var JobMessage_MessageImportance_name = map[int32]string{
	0: "MESSAGE_IMPORTANCE_UNSPECIFIED",
	1: "JOB_MESSAGE_DEBUG",
	2: "JOB_MESSAGE_DETAILED",
	3: "JOB_MESSAGE_BASIC",
	4: "JOB_MESSAGE_WARNING",
	5: "JOB_MESSAGE_ERROR",
}

var JobMessage_MessageImportance_value = map[string]int32{
	"MESSAGE_IMPORTANCE_UNSPECIFIED": 0,
	"JOB_MESSAGE_DEBUG":              1,
	"JOB_MESSAGE_DETAILED":           2,
	"JOB_MESSAGE_BASIC":              3,
	"JOB_MESSAGE_WARNING":            4,
	"JOB_MESSAGE_ERROR":              5,
}

func (x JobMessage_MessageImportance) String() string {
	return proto.EnumName(JobMessage_MessageImportance_name, int32(x))
}

func (JobMessage_MessageImportance) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{14, 0}
}

type JobState_Enum int32

const (
	// The job state reported by a runner cannot be interpreted by the SDK.
	JobState_UNSPECIFIED JobState_Enum = 0
	// The job has not yet started.
	JobState_STOPPED JobState_Enum = 1
	// The job is currently running.
	JobState_RUNNING JobState_Enum = 2
	// The job has successfully completed. (terminal)
	JobState_DONE JobState_Enum = 3
	// The job has failed. (terminal)
	JobState_FAILED JobState_Enum = 4
	// The job has been explicitly cancelled. (terminal)
	JobState_CANCELLED JobState_Enum = 5
	// The job has been updated. (terminal)
	JobState_UPDATED JobState_Enum = 6
	// The job is draining its data. (optional)
	JobState_DRAINING JobState_Enum = 7
	// The job has completed draining its data. (terminal)
	JobState_DRAINED JobState_Enum = 8
	// The job is starting up.
	JobState_STARTING JobState_Enum = 9
	// The job is cancelling. (optional)
	JobState_CANCELLING JobState_Enum = 10
	// The job is in the process of being updated. (optional)
	JobState_UPDATING JobState_Enum = 11
)

var JobState_Enum_name = map[int32]string{
	0:  "UNSPECIFIED",
	1:  "STOPPED",
	2:  "RUNNING",
	3:  "DONE",
	4:  "FAILED",
	5:  "CANCELLED",
	6:  "UPDATED",
	7:  "DRAINING",
	8:  "DRAINED",
	9:  "STARTING",
	10: "CANCELLING",
	11: "UPDATING",
}

var JobState_Enum_value = map[string]int32{
	"UNSPECIFIED": 0,
	"STOPPED":     1,
	"RUNNING":     2,
	"DONE":        3,
	"FAILED":      4,
	"CANCELLED":   5,
	"UPDATED":     6,
	"DRAINING":    7,
	"DRAINED":     8,
	"STARTING":    9,
	"CANCELLING":  10,
	"UPDATING":    11,
}

func (x JobState_Enum) String() string {
	return proto.EnumName(JobState_Enum_name, int32(x))
}

func (JobState_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{16, 0}
}

type PipelineOptionType_Enum int32

const (
	PipelineOptionType_STRING  PipelineOptionType_Enum = 0
	PipelineOptionType_BOOLEAN PipelineOptionType_Enum = 1
	// whole numbers, see https://json-schema.org/understanding-json-schema/reference/numeric.html
	PipelineOptionType_INTEGER PipelineOptionType_Enum = 2
	PipelineOptionType_NUMBER  PipelineOptionType_Enum = 3
	PipelineOptionType_ARRAY   PipelineOptionType_Enum = 4
	PipelineOptionType_OBJECT  PipelineOptionType_Enum = 5
)

var PipelineOptionType_Enum_name = map[int32]string{
	0: "STRING",
	1: "BOOLEAN",
	2: "INTEGER",
	3: "NUMBER",
	4: "ARRAY",
	5: "OBJECT",
}

var PipelineOptionType_Enum_value = map[string]int32{
	"STRING":  0,
	"BOOLEAN": 1,
	"INTEGER": 2,
	"NUMBER":  3,
	"ARRAY":   4,
	"OBJECT":  5,
}

func (x PipelineOptionType_Enum) String() string {
	return proto.EnumName(PipelineOptionType_Enum_name, int32(x))
}

func (PipelineOptionType_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{21, 0}
}

// Prepare is a synchronous request that returns a preparationId back
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
// Throws error ALREADY_EXISTS if the jobName is reused. Runners are permitted to deduplicate based on the name of the job.
// Throws error UNKNOWN for all other issues
type PrepareJobRequest struct {
	Pipeline             *pipeline_v1.Pipeline `protobuf:"bytes,1,opt,name=pipeline,proto3" json:"pipeline,omitempty"`
	PipelineOptions      *_struct.Struct       `protobuf:"bytes,2,opt,name=pipeline_options,json=pipelineOptions,proto3" json:"pipeline_options,omitempty"`
	JobName              string                `protobuf:"bytes,3,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *PrepareJobRequest) Reset()         { *m = PrepareJobRequest{} }
func (m *PrepareJobRequest) String() string { return proto.CompactTextString(m) }
func (*PrepareJobRequest) ProtoMessage()    {}
func (*PrepareJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{0}
}

func (m *PrepareJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrepareJobRequest.Unmarshal(m, b)
}
func (m *PrepareJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrepareJobRequest.Marshal(b, m, deterministic)
}
func (m *PrepareJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrepareJobRequest.Merge(m, src)
}
func (m *PrepareJobRequest) XXX_Size() int {
	return xxx_messageInfo_PrepareJobRequest.Size(m)
}
func (m *PrepareJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PrepareJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PrepareJobRequest proto.InternalMessageInfo

func (m *PrepareJobRequest) GetPipeline() *pipeline_v1.Pipeline {
	if m != nil {
		return m.Pipeline
	}
	return nil
}

func (m *PrepareJobRequest) GetPipelineOptions() *_struct.Struct {
	if m != nil {
		return m.PipelineOptions
	}
	return nil
}

func (m *PrepareJobRequest) GetJobName() string {
	if m != nil {
		return m.JobName
	}
	return ""
}

type PrepareJobResponse struct {
	// (required) The ID used to associate calls made while preparing the job. preparationId is used
	// to run the job.
	PreparationId string `protobuf:"bytes,1,opt,name=preparation_id,json=preparationId,proto3" json:"preparation_id,omitempty"`
	// An endpoint which exposes the Beam Artifact Staging API. Artifacts used by the job should be
	// staged to this endpoint, and will be available during job execution.
	ArtifactStagingEndpoint *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,2,opt,name=artifact_staging_endpoint,json=artifactStagingEndpoint,proto3" json:"artifact_staging_endpoint,omitempty"`
	// (required) Token for the artifact staging. This token also represent an artifact
	// staging session with the artifact staging service.
	StagingSessionToken  string   `protobuf:"bytes,3,opt,name=staging_session_token,json=stagingSessionToken,proto3" json:"staging_session_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PrepareJobResponse) Reset()         { *m = PrepareJobResponse{} }
func (m *PrepareJobResponse) String() string { return proto.CompactTextString(m) }
func (*PrepareJobResponse) ProtoMessage()    {}
func (*PrepareJobResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{1}
}

func (m *PrepareJobResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrepareJobResponse.Unmarshal(m, b)
}
func (m *PrepareJobResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrepareJobResponse.Marshal(b, m, deterministic)
}
func (m *PrepareJobResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrepareJobResponse.Merge(m, src)
}
func (m *PrepareJobResponse) XXX_Size() int {
	return xxx_messageInfo_PrepareJobResponse.Size(m)
}
func (m *PrepareJobResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PrepareJobResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PrepareJobResponse proto.InternalMessageInfo

func (m *PrepareJobResponse) GetPreparationId() string {
	if m != nil {
		return m.PreparationId
	}
	return ""
}

func (m *PrepareJobResponse) GetArtifactStagingEndpoint() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.ArtifactStagingEndpoint
	}
	return nil
}

func (m *PrepareJobResponse) GetStagingSessionToken() string {
	if m != nil {
		return m.StagingSessionToken
	}
	return ""
}

// Run is a synchronous request that returns a jobId back.
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
// Throws error NOT_FOUND if the preparation ID does not exist
// Throws error UNKNOWN for all other issues
type RunJobRequest struct {
	// (required) The ID provided by an earlier call to prepare. Runs the job. All prerequisite tasks
	// must have been completed.
	PreparationId string `protobuf:"bytes,1,opt,name=preparation_id,json=preparationId,proto3" json:"preparation_id,omitempty"`
	// (optional) If any artifacts have been staged for this job, contains the retrieval_token returned
	// from the CommitManifestResponse.
	RetrievalToken       string   `protobuf:"bytes,2,opt,name=retrieval_token,json=retrievalToken,proto3" json:"retrieval_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RunJobRequest) Reset()         { *m = RunJobRequest{} }
func (m *RunJobRequest) String() string { return proto.CompactTextString(m) }
func (*RunJobRequest) ProtoMessage()    {}
func (*RunJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{2}
}

func (m *RunJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RunJobRequest.Unmarshal(m, b)
}
func (m *RunJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RunJobRequest.Marshal(b, m, deterministic)
}
func (m *RunJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunJobRequest.Merge(m, src)
}
func (m *RunJobRequest) XXX_Size() int {
	return xxx_messageInfo_RunJobRequest.Size(m)
}
func (m *RunJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RunJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RunJobRequest proto.InternalMessageInfo

func (m *RunJobRequest) GetPreparationId() string {
	if m != nil {
		return m.PreparationId
	}
	return ""
}

func (m *RunJobRequest) GetRetrievalToken() string {
	if m != nil {
		return m.RetrievalToken
	}
	return ""
}

type RunJobResponse struct {
	JobId                string   `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RunJobResponse) Reset()         { *m = RunJobResponse{} }
func (m *RunJobResponse) String() string { return proto.CompactTextString(m) }
func (*RunJobResponse) ProtoMessage()    {}
func (*RunJobResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{3}
}

func (m *RunJobResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RunJobResponse.Unmarshal(m, b)
}
func (m *RunJobResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RunJobResponse.Marshal(b, m, deterministic)
}
func (m *RunJobResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunJobResponse.Merge(m, src)
}
func (m *RunJobResponse) XXX_Size() int {
	return xxx_messageInfo_RunJobResponse.Size(m)
}
func (m *RunJobResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RunJobResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RunJobResponse proto.InternalMessageInfo

func (m *RunJobResponse) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

// Cancel is a synchronus request that returns a job state back
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
// Throws error NOT_FOUND if the jobId is not found
type CancelJobRequest struct {
	JobId                string   `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CancelJobRequest) Reset()         { *m = CancelJobRequest{} }
func (m *CancelJobRequest) String() string { return proto.CompactTextString(m) }
func (*CancelJobRequest) ProtoMessage()    {}
func (*CancelJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{4}
}

func (m *CancelJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CancelJobRequest.Unmarshal(m, b)
}
func (m *CancelJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CancelJobRequest.Marshal(b, m, deterministic)
}
func (m *CancelJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CancelJobRequest.Merge(m, src)
}
func (m *CancelJobRequest) XXX_Size() int {
	return xxx_messageInfo_CancelJobRequest.Size(m)
}
func (m *CancelJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CancelJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CancelJobRequest proto.InternalMessageInfo

func (m *CancelJobRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

// Valid responses include any terminal state or CANCELLING
type CancelJobResponse struct {
	State                JobState_Enum `protobuf:"varint,1,opt,name=state,proto3,enum=org.apache.beam.model.job_management.v1.JobState_Enum" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CancelJobResponse) Reset()         { *m = CancelJobResponse{} }
func (m *CancelJobResponse) String() string { return proto.CompactTextString(m) }
func (*CancelJobResponse) ProtoMessage()    {}
func (*CancelJobResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{5}
}

func (m *CancelJobResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CancelJobResponse.Unmarshal(m, b)
}
func (m *CancelJobResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CancelJobResponse.Marshal(b, m, deterministic)
}
func (m *CancelJobResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CancelJobResponse.Merge(m, src)
}
func (m *CancelJobResponse) XXX_Size() int {
	return xxx_messageInfo_CancelJobResponse.Size(m)
}
func (m *CancelJobResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CancelJobResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CancelJobResponse proto.InternalMessageInfo

func (m *CancelJobResponse) GetState() JobState_Enum {
	if m != nil {
		return m.State
	}
	return JobState_UNSPECIFIED
}

// A subset of info provided by ProvisionApi.ProvisionInfo
type JobInfo struct {
	JobId                string          `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	JobName              string          `protobuf:"bytes,2,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
	PipelineOptions      *_struct.Struct `protobuf:"bytes,3,opt,name=pipeline_options,json=pipelineOptions,proto3" json:"pipeline_options,omitempty"`
	State                JobState_Enum   `protobuf:"varint,4,opt,name=state,proto3,enum=org.apache.beam.model.job_management.v1.JobState_Enum" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *JobInfo) Reset()         { *m = JobInfo{} }
func (m *JobInfo) String() string { return proto.CompactTextString(m) }
func (*JobInfo) ProtoMessage()    {}
func (*JobInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{6}
}

func (m *JobInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobInfo.Unmarshal(m, b)
}
func (m *JobInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobInfo.Marshal(b, m, deterministic)
}
func (m *JobInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobInfo.Merge(m, src)
}
func (m *JobInfo) XXX_Size() int {
	return xxx_messageInfo_JobInfo.Size(m)
}
func (m *JobInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_JobInfo.DiscardUnknown(m)
}

var xxx_messageInfo_JobInfo proto.InternalMessageInfo

func (m *JobInfo) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

func (m *JobInfo) GetJobName() string {
	if m != nil {
		return m.JobName
	}
	return ""
}

func (m *JobInfo) GetPipelineOptions() *_struct.Struct {
	if m != nil {
		return m.PipelineOptions
	}
	return nil
}

func (m *JobInfo) GetState() JobState_Enum {
	if m != nil {
		return m.State
	}
	return JobState_UNSPECIFIED
}

// GetJobs is a synchronus request that returns a list of invoked jobs back
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
type GetJobsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetJobsRequest) Reset()         { *m = GetJobsRequest{} }
func (m *GetJobsRequest) String() string { return proto.CompactTextString(m) }
func (*GetJobsRequest) ProtoMessage()    {}
func (*GetJobsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{7}
}

func (m *GetJobsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobsRequest.Unmarshal(m, b)
}
func (m *GetJobsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobsRequest.Marshal(b, m, deterministic)
}
func (m *GetJobsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobsRequest.Merge(m, src)
}
func (m *GetJobsRequest) XXX_Size() int {
	return xxx_messageInfo_GetJobsRequest.Size(m)
}
func (m *GetJobsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobsRequest proto.InternalMessageInfo

type GetJobsResponse struct {
	JobInfo              []*JobInfo `protobuf:"bytes,1,rep,name=job_info,json=jobInfo,proto3" json:"job_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *GetJobsResponse) Reset()         { *m = GetJobsResponse{} }
func (m *GetJobsResponse) String() string { return proto.CompactTextString(m) }
func (*GetJobsResponse) ProtoMessage()    {}
func (*GetJobsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{8}
}

func (m *GetJobsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobsResponse.Unmarshal(m, b)
}
func (m *GetJobsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobsResponse.Marshal(b, m, deterministic)
}
func (m *GetJobsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobsResponse.Merge(m, src)
}
func (m *GetJobsResponse) XXX_Size() int {
	return xxx_messageInfo_GetJobsResponse.Size(m)
}
func (m *GetJobsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobsResponse proto.InternalMessageInfo

func (m *GetJobsResponse) GetJobInfo() []*JobInfo {
	if m != nil {
		return m.JobInfo
	}
	return nil
}

// GetState is a synchronus request that returns a job state back
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
// Throws error NOT_FOUND if the jobId is not found
type GetJobStateRequest struct {
	JobId                string   `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetJobStateRequest) Reset()         { *m = GetJobStateRequest{} }
func (m *GetJobStateRequest) String() string { return proto.CompactTextString(m) }
func (*GetJobStateRequest) ProtoMessage()    {}
func (*GetJobStateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{9}
}

func (m *GetJobStateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobStateRequest.Unmarshal(m, b)
}
func (m *GetJobStateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobStateRequest.Marshal(b, m, deterministic)
}
func (m *GetJobStateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobStateRequest.Merge(m, src)
}
func (m *GetJobStateRequest) XXX_Size() int {
	return xxx_messageInfo_GetJobStateRequest.Size(m)
}
func (m *GetJobStateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobStateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobStateRequest proto.InternalMessageInfo

func (m *GetJobStateRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

type JobStateEvent struct {
	State                JobState_Enum        `protobuf:"varint,1,opt,name=state,proto3,enum=org.apache.beam.model.job_management.v1.JobState_Enum" json:"state,omitempty"`
	Timestamp            *timestamp.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *JobStateEvent) Reset()         { *m = JobStateEvent{} }
func (m *JobStateEvent) String() string { return proto.CompactTextString(m) }
func (*JobStateEvent) ProtoMessage()    {}
func (*JobStateEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{10}
}

func (m *JobStateEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobStateEvent.Unmarshal(m, b)
}
func (m *JobStateEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobStateEvent.Marshal(b, m, deterministic)
}
func (m *JobStateEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobStateEvent.Merge(m, src)
}
func (m *JobStateEvent) XXX_Size() int {
	return xxx_messageInfo_JobStateEvent.Size(m)
}
func (m *JobStateEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_JobStateEvent.DiscardUnknown(m)
}

var xxx_messageInfo_JobStateEvent proto.InternalMessageInfo

func (m *JobStateEvent) GetState() JobState_Enum {
	if m != nil {
		return m.State
	}
	return JobState_UNSPECIFIED
}

func (m *JobStateEvent) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

// GetPipeline is a synchronus request that returns a pipeline back
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
// Throws error NOT_FOUND if the jobId is not found
type GetJobPipelineRequest struct {
	JobId                string   `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetJobPipelineRequest) Reset()         { *m = GetJobPipelineRequest{} }
func (m *GetJobPipelineRequest) String() string { return proto.CompactTextString(m) }
func (*GetJobPipelineRequest) ProtoMessage()    {}
func (*GetJobPipelineRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{11}
}

func (m *GetJobPipelineRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobPipelineRequest.Unmarshal(m, b)
}
func (m *GetJobPipelineRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobPipelineRequest.Marshal(b, m, deterministic)
}
func (m *GetJobPipelineRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobPipelineRequest.Merge(m, src)
}
func (m *GetJobPipelineRequest) XXX_Size() int {
	return xxx_messageInfo_GetJobPipelineRequest.Size(m)
}
func (m *GetJobPipelineRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobPipelineRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobPipelineRequest proto.InternalMessageInfo

func (m *GetJobPipelineRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

type GetJobPipelineResponse struct {
	Pipeline             *pipeline_v1.Pipeline `protobuf:"bytes,1,opt,name=pipeline,proto3" json:"pipeline,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *GetJobPipelineResponse) Reset()         { *m = GetJobPipelineResponse{} }
func (m *GetJobPipelineResponse) String() string { return proto.CompactTextString(m) }
func (*GetJobPipelineResponse) ProtoMessage()    {}
func (*GetJobPipelineResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{12}
}

func (m *GetJobPipelineResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobPipelineResponse.Unmarshal(m, b)
}
func (m *GetJobPipelineResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobPipelineResponse.Marshal(b, m, deterministic)
}
func (m *GetJobPipelineResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobPipelineResponse.Merge(m, src)
}
func (m *GetJobPipelineResponse) XXX_Size() int {
	return xxx_messageInfo_GetJobPipelineResponse.Size(m)
}
func (m *GetJobPipelineResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobPipelineResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobPipelineResponse proto.InternalMessageInfo

func (m *GetJobPipelineResponse) GetPipeline() *pipeline_v1.Pipeline {
	if m != nil {
		return m.Pipeline
	}
	return nil
}

// GetJobMessages is a streaming api for streaming job messages from the service
// One request will connect you to the job and you'll get a stream of job state
// and job messages back; one is used for logging and the other for detecting
// the job ended.
type JobMessagesRequest struct {
	JobId                string   `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobMessagesRequest) Reset()         { *m = JobMessagesRequest{} }
func (m *JobMessagesRequest) String() string { return proto.CompactTextString(m) }
func (*JobMessagesRequest) ProtoMessage()    {}
func (*JobMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{13}
}

func (m *JobMessagesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobMessagesRequest.Unmarshal(m, b)
}
func (m *JobMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobMessagesRequest.Marshal(b, m, deterministic)
}
func (m *JobMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobMessagesRequest.Merge(m, src)
}
func (m *JobMessagesRequest) XXX_Size() int {
	return xxx_messageInfo_JobMessagesRequest.Size(m)
}
func (m *JobMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_JobMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_JobMessagesRequest proto.InternalMessageInfo

func (m *JobMessagesRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

type JobMessage struct {
	MessageId            string                       `protobuf:"bytes,1,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	Time                 string                       `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	Importance           JobMessage_MessageImportance `protobuf:"varint,3,opt,name=importance,proto3,enum=org.apache.beam.model.job_management.v1.JobMessage_MessageImportance" json:"importance,omitempty"`
	MessageText          string                       `protobuf:"bytes,4,opt,name=message_text,json=messageText,proto3" json:"message_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *JobMessage) Reset()         { *m = JobMessage{} }
func (m *JobMessage) String() string { return proto.CompactTextString(m) }
func (*JobMessage) ProtoMessage()    {}
func (*JobMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{14}
}

func (m *JobMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobMessage.Unmarshal(m, b)
}
func (m *JobMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobMessage.Marshal(b, m, deterministic)
}
func (m *JobMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobMessage.Merge(m, src)
}
func (m *JobMessage) XXX_Size() int {
	return xxx_messageInfo_JobMessage.Size(m)
}
func (m *JobMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_JobMessage.DiscardUnknown(m)
}

var xxx_messageInfo_JobMessage proto.InternalMessageInfo

func (m *JobMessage) GetMessageId() string {
	if m != nil {
		return m.MessageId
	}
	return ""
}

func (m *JobMessage) GetTime() string {
	if m != nil {
		return m.Time
	}
	return ""
}

func (m *JobMessage) GetImportance() JobMessage_MessageImportance {
	if m != nil {
		return m.Importance
	}
	return JobMessage_MESSAGE_IMPORTANCE_UNSPECIFIED
}

func (m *JobMessage) GetMessageText() string {
	if m != nil {
		return m.MessageText
	}
	return ""
}

type JobMessagesResponse struct {
	// Types that are valid to be assigned to Response:
	//	*JobMessagesResponse_MessageResponse
	//	*JobMessagesResponse_StateResponse
	Response             isJobMessagesResponse_Response `protobuf_oneof:"response"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *JobMessagesResponse) Reset()         { *m = JobMessagesResponse{} }
func (m *JobMessagesResponse) String() string { return proto.CompactTextString(m) }
func (*JobMessagesResponse) ProtoMessage()    {}
func (*JobMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{15}
}

func (m *JobMessagesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobMessagesResponse.Unmarshal(m, b)
}
func (m *JobMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobMessagesResponse.Marshal(b, m, deterministic)
}
func (m *JobMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobMessagesResponse.Merge(m, src)
}
func (m *JobMessagesResponse) XXX_Size() int {
	return xxx_messageInfo_JobMessagesResponse.Size(m)
}
func (m *JobMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_JobMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_JobMessagesResponse proto.InternalMessageInfo

type isJobMessagesResponse_Response interface {
	isJobMessagesResponse_Response()
}

type JobMessagesResponse_MessageResponse struct {
	MessageResponse *JobMessage `protobuf:"bytes,1,opt,name=message_response,json=messageResponse,proto3,oneof"`
}

type JobMessagesResponse_StateResponse struct {
	StateResponse *JobStateEvent `protobuf:"bytes,2,opt,name=state_response,json=stateResponse,proto3,oneof"`
}

func (*JobMessagesResponse_MessageResponse) isJobMessagesResponse_Response() {}

func (*JobMessagesResponse_StateResponse) isJobMessagesResponse_Response() {}

func (m *JobMessagesResponse) GetResponse() isJobMessagesResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *JobMessagesResponse) GetMessageResponse() *JobMessage {
	if x, ok := m.GetResponse().(*JobMessagesResponse_MessageResponse); ok {
		return x.MessageResponse
	}
	return nil
}

func (m *JobMessagesResponse) GetStateResponse() *JobStateEvent {
	if x, ok := m.GetResponse().(*JobMessagesResponse_StateResponse); ok {
		return x.StateResponse
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*JobMessagesResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*JobMessagesResponse_MessageResponse)(nil),
		(*JobMessagesResponse_StateResponse)(nil),
	}
}

// Enumeration of all JobStates
//
// The state transition diagram is:
//   STOPPED -> STARTING -> RUNNING -> DONE
//                                  \> FAILED
//                                  \> CANCELLING -> CANCELLED
//                                  \> UPDATING -> UPDATED
//                                  \> DRAINING -> DRAINED
//
// Transitions are optional such that a job may go from STOPPED to RUNNING
// without needing to pass through STARTING.
type JobState struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobState) Reset()         { *m = JobState{} }
func (m *JobState) String() string { return proto.CompactTextString(m) }
func (*JobState) ProtoMessage()    {}
func (*JobState) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{16}
}

func (m *JobState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobState.Unmarshal(m, b)
}
func (m *JobState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobState.Marshal(b, m, deterministic)
}
func (m *JobState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobState.Merge(m, src)
}
func (m *JobState) XXX_Size() int {
	return xxx_messageInfo_JobState.Size(m)
}
func (m *JobState) XXX_DiscardUnknown() {
	xxx_messageInfo_JobState.DiscardUnknown(m)
}

var xxx_messageInfo_JobState proto.InternalMessageInfo

type GetJobMetricsRequest struct {
	JobId                string   `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetJobMetricsRequest) Reset()         { *m = GetJobMetricsRequest{} }
func (m *GetJobMetricsRequest) String() string { return proto.CompactTextString(m) }
func (*GetJobMetricsRequest) ProtoMessage()    {}
func (*GetJobMetricsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{17}
}

func (m *GetJobMetricsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobMetricsRequest.Unmarshal(m, b)
}
func (m *GetJobMetricsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobMetricsRequest.Marshal(b, m, deterministic)
}
func (m *GetJobMetricsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobMetricsRequest.Merge(m, src)
}
func (m *GetJobMetricsRequest) XXX_Size() int {
	return xxx_messageInfo_GetJobMetricsRequest.Size(m)
}
func (m *GetJobMetricsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobMetricsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobMetricsRequest proto.InternalMessageInfo

func (m *GetJobMetricsRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

type GetJobMetricsResponse struct {
	Metrics              *MetricResults `protobuf:"bytes,1,opt,name=metrics,proto3" json:"metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *GetJobMetricsResponse) Reset()         { *m = GetJobMetricsResponse{} }
func (m *GetJobMetricsResponse) String() string { return proto.CompactTextString(m) }
func (*GetJobMetricsResponse) ProtoMessage()    {}
func (*GetJobMetricsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{18}
}

func (m *GetJobMetricsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobMetricsResponse.Unmarshal(m, b)
}
func (m *GetJobMetricsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobMetricsResponse.Marshal(b, m, deterministic)
}
func (m *GetJobMetricsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobMetricsResponse.Merge(m, src)
}
func (m *GetJobMetricsResponse) XXX_Size() int {
	return xxx_messageInfo_GetJobMetricsResponse.Size(m)
}
func (m *GetJobMetricsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobMetricsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobMetricsResponse proto.InternalMessageInfo

func (m *GetJobMetricsResponse) GetMetrics() *MetricResults {
	if m != nil {
		return m.Metrics
	}
	return nil
}

// All metrics for a given job.  Runners may support one or the other or both.
type MetricResults struct {
	Attempted            []*pipeline_v1.MonitoringInfo `protobuf:"bytes,1,rep,name=attempted,proto3" json:"attempted,omitempty"`
	Committed            []*pipeline_v1.MonitoringInfo `protobuf:"bytes,2,rep,name=committed,proto3" json:"committed,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *MetricResults) Reset()         { *m = MetricResults{} }
func (m *MetricResults) String() string { return proto.CompactTextString(m) }
func (*MetricResults) ProtoMessage()    {}
func (*MetricResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{19}
}

func (m *MetricResults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MetricResults.Unmarshal(m, b)
}
func (m *MetricResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MetricResults.Marshal(b, m, deterministic)
}
func (m *MetricResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricResults.Merge(m, src)
}
func (m *MetricResults) XXX_Size() int {
	return xxx_messageInfo_MetricResults.Size(m)
}
func (m *MetricResults) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricResults.DiscardUnknown(m)
}

var xxx_messageInfo_MetricResults proto.InternalMessageInfo

func (m *MetricResults) GetAttempted() []*pipeline_v1.MonitoringInfo {
	if m != nil {
		return m.Attempted
	}
	return nil
}

func (m *MetricResults) GetCommitted() []*pipeline_v1.MonitoringInfo {
	if m != nil {
		return m.Committed
	}
	return nil
}

// DescribePipelineOptions provides metadata about the options supported by a runner.
// It will be used by the SDK client to validate the options specified by or
// list available options to the user.
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
type DescribePipelineOptionsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DescribePipelineOptionsRequest) Reset()         { *m = DescribePipelineOptionsRequest{} }
func (m *DescribePipelineOptionsRequest) String() string { return proto.CompactTextString(m) }
func (*DescribePipelineOptionsRequest) ProtoMessage()    {}
func (*DescribePipelineOptionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{20}
}

func (m *DescribePipelineOptionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DescribePipelineOptionsRequest.Unmarshal(m, b)
}
func (m *DescribePipelineOptionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DescribePipelineOptionsRequest.Marshal(b, m, deterministic)
}
func (m *DescribePipelineOptionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribePipelineOptionsRequest.Merge(m, src)
}
func (m *DescribePipelineOptionsRequest) XXX_Size() int {
	return xxx_messageInfo_DescribePipelineOptionsRequest.Size(m)
}
func (m *DescribePipelineOptionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribePipelineOptionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DescribePipelineOptionsRequest proto.InternalMessageInfo

// Type for pipeline options.
// Types mirror those of JSON, since that's how pipeline options are serialized.
type PipelineOptionType struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PipelineOptionType) Reset()         { *m = PipelineOptionType{} }
func (m *PipelineOptionType) String() string { return proto.CompactTextString(m) }
func (*PipelineOptionType) ProtoMessage()    {}
func (*PipelineOptionType) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{21}
}

func (m *PipelineOptionType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PipelineOptionType.Unmarshal(m, b)
}
func (m *PipelineOptionType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PipelineOptionType.Marshal(b, m, deterministic)
}
func (m *PipelineOptionType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PipelineOptionType.Merge(m, src)
}
func (m *PipelineOptionType) XXX_Size() int {
	return xxx_messageInfo_PipelineOptionType.Size(m)
}
func (m *PipelineOptionType) XXX_DiscardUnknown() {
	xxx_messageInfo_PipelineOptionType.DiscardUnknown(m)
}

var xxx_messageInfo_PipelineOptionType proto.InternalMessageInfo

// Metadata for a pipeline option.
type PipelineOptionDescriptor struct {
	// (Required) The option name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// (Required) Type of option.
	Type PipelineOptionType_Enum `protobuf:"varint,2,opt,name=type,proto3,enum=org.apache.beam.model.job_management.v1.PipelineOptionType_Enum" json:"type,omitempty"`
	// (Optional) Description suitable for display / help text.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// (Optional) Default value.
	DefaultValue string `protobuf:"bytes,4,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	// (Required) The group this option belongs to.
	Group                string   `protobuf:"bytes,5,opt,name=group,proto3" json:"group,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PipelineOptionDescriptor) Reset()         { *m = PipelineOptionDescriptor{} }
func (m *PipelineOptionDescriptor) String() string { return proto.CompactTextString(m) }
func (*PipelineOptionDescriptor) ProtoMessage()    {}
func (*PipelineOptionDescriptor) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{22}
}

func (m *PipelineOptionDescriptor) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PipelineOptionDescriptor.Unmarshal(m, b)
}
func (m *PipelineOptionDescriptor) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PipelineOptionDescriptor.Marshal(b, m, deterministic)
}
func (m *PipelineOptionDescriptor) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PipelineOptionDescriptor.Merge(m, src)
}
func (m *PipelineOptionDescriptor) XXX_Size() int {
	return xxx_messageInfo_PipelineOptionDescriptor.Size(m)
}
func (m *PipelineOptionDescriptor) XXX_DiscardUnknown() {
	xxx_messageInfo_PipelineOptionDescriptor.DiscardUnknown(m)
}

var xxx_messageInfo_PipelineOptionDescriptor proto.InternalMessageInfo

func (m *PipelineOptionDescriptor) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PipelineOptionDescriptor) GetType() PipelineOptionType_Enum {
	if m != nil {
		return m.Type
	}
	return PipelineOptionType_STRING
}

func (m *PipelineOptionDescriptor) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *PipelineOptionDescriptor) GetDefaultValue() string {
	if m != nil {
		return m.DefaultValue
	}
	return ""
}

func (m *PipelineOptionDescriptor) GetGroup() string {
	if m != nil {
		return m.Group
	}
	return ""
}

type DescribePipelineOptionsResponse struct {
	// List of pipeline option descriptors.
	Options              []*PipelineOptionDescriptor `protobuf:"bytes,1,rep,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *DescribePipelineOptionsResponse) Reset()         { *m = DescribePipelineOptionsResponse{} }
func (m *DescribePipelineOptionsResponse) String() string { return proto.CompactTextString(m) }
func (*DescribePipelineOptionsResponse) ProtoMessage()    {}
func (*DescribePipelineOptionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_97c7b84f742157ae, []int{23}
}

func (m *DescribePipelineOptionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DescribePipelineOptionsResponse.Unmarshal(m, b)
}
func (m *DescribePipelineOptionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DescribePipelineOptionsResponse.Marshal(b, m, deterministic)
}
func (m *DescribePipelineOptionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribePipelineOptionsResponse.Merge(m, src)
}
func (m *DescribePipelineOptionsResponse) XXX_Size() int {
	return xxx_messageInfo_DescribePipelineOptionsResponse.Size(m)
}
func (m *DescribePipelineOptionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribePipelineOptionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DescribePipelineOptionsResponse proto.InternalMessageInfo

func (m *DescribePipelineOptionsResponse) GetOptions() []*PipelineOptionDescriptor {
	if m != nil {
		return m.Options
	}
	return nil
}

func init() {
	proto.RegisterEnum("org.apache.beam.model.job_management.v1.JobMessage_MessageImportance", JobMessage_MessageImportance_name, JobMessage_MessageImportance_value)
	proto.RegisterEnum("org.apache.beam.model.job_management.v1.JobState_Enum", JobState_Enum_name, JobState_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.job_management.v1.PipelineOptionType_Enum", PipelineOptionType_Enum_name, PipelineOptionType_Enum_value)
	proto.RegisterType((*PrepareJobRequest)(nil), "org.apache.beam.model.job_management.v1.PrepareJobRequest")
	proto.RegisterType((*PrepareJobResponse)(nil), "org.apache.beam.model.job_management.v1.PrepareJobResponse")
	proto.RegisterType((*RunJobRequest)(nil), "org.apache.beam.model.job_management.v1.RunJobRequest")
	proto.RegisterType((*RunJobResponse)(nil), "org.apache.beam.model.job_management.v1.RunJobResponse")
	proto.RegisterType((*CancelJobRequest)(nil), "org.apache.beam.model.job_management.v1.CancelJobRequest")
	proto.RegisterType((*CancelJobResponse)(nil), "org.apache.beam.model.job_management.v1.CancelJobResponse")
	proto.RegisterType((*JobInfo)(nil), "org.apache.beam.model.job_management.v1.JobInfo")
	proto.RegisterType((*GetJobsRequest)(nil), "org.apache.beam.model.job_management.v1.GetJobsRequest")
	proto.RegisterType((*GetJobsResponse)(nil), "org.apache.beam.model.job_management.v1.GetJobsResponse")
	proto.RegisterType((*GetJobStateRequest)(nil), "org.apache.beam.model.job_management.v1.GetJobStateRequest")
	proto.RegisterType((*JobStateEvent)(nil), "org.apache.beam.model.job_management.v1.JobStateEvent")
	proto.RegisterType((*GetJobPipelineRequest)(nil), "org.apache.beam.model.job_management.v1.GetJobPipelineRequest")
	proto.RegisterType((*GetJobPipelineResponse)(nil), "org.apache.beam.model.job_management.v1.GetJobPipelineResponse")
	proto.RegisterType((*JobMessagesRequest)(nil), "org.apache.beam.model.job_management.v1.JobMessagesRequest")
	proto.RegisterType((*JobMessage)(nil), "org.apache.beam.model.job_management.v1.JobMessage")
	proto.RegisterType((*JobMessagesResponse)(nil), "org.apache.beam.model.job_management.v1.JobMessagesResponse")
	proto.RegisterType((*JobState)(nil), "org.apache.beam.model.job_management.v1.JobState")
	proto.RegisterType((*GetJobMetricsRequest)(nil), "org.apache.beam.model.job_management.v1.GetJobMetricsRequest")
	proto.RegisterType((*GetJobMetricsResponse)(nil), "org.apache.beam.model.job_management.v1.GetJobMetricsResponse")
	proto.RegisterType((*MetricResults)(nil), "org.apache.beam.model.job_management.v1.MetricResults")
	proto.RegisterType((*DescribePipelineOptionsRequest)(nil), "org.apache.beam.model.job_management.v1.DescribePipelineOptionsRequest")
	proto.RegisterType((*PipelineOptionType)(nil), "org.apache.beam.model.job_management.v1.PipelineOptionType")
	proto.RegisterType((*PipelineOptionDescriptor)(nil), "org.apache.beam.model.job_management.v1.PipelineOptionDescriptor")
	proto.RegisterType((*DescribePipelineOptionsResponse)(nil), "org.apache.beam.model.job_management.v1.DescribePipelineOptionsResponse")
}

func init() { proto.RegisterFile("beam_job_api.proto", fileDescriptor_97c7b84f742157ae) }

var fileDescriptor_97c7b84f742157ae = []byte{
	// 1444 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x57, 0x5f, 0x6f, 0x1b, 0xc5,
	0x16, 0xef, 0x3a, 0x76, 0x6c, 0x1f, 0xd7, 0xce, 0x66, 0xda, 0xdc, 0xa4, 0xd6, 0xbd, 0x6d, 0xee,
	0x5e, 0x5d, 0x5a, 0x54, 0xb1, 0x6d, 0x52, 0x89, 0x96, 0x16, 0x0a, 0xeb, 0x78, 0xeb, 0xda, 0x24,
	0xb6, 0x35, 0xde, 0x80, 0x00, 0x09, 0xb3, 0xb6, 0x27, 0x66, 0x8b, 0x77, 0x67, 0xd9, 0x1d, 0x5b,
	0xad, 0x84, 0x40, 0xe2, 0x85, 0x37, 0x78, 0xe4, 0x3b, 0x20, 0x24, 0xc4, 0x13, 0x0f, 0x7c, 0x06,
	0x3e, 0x04, 0x12, 0x9f, 0x81, 0x17, 0x5e, 0xd0, 0xcc, 0xce, 0x3a, 0xde, 0xa4, 0x21, 0xb6, 0xa9,
	0xc4, 0x93, 0x77, 0xce, 0x9f, 0xdf, 0xf9, 0x3b, 0x67, 0x8e, 0x01, 0xf5, 0x88, 0xed, 0x76, 0x9f,
	0xd0, 0x5e, 0xd7, 0xf6, 0x1d, 0xdd, 0x0f, 0x28, 0xa3, 0xe8, 0x3a, 0x0d, 0x86, 0xba, 0xed, 0xdb,
	0xfd, 0x8f, 0x89, 0xce, 0xd9, 0xba, 0x4b, 0x07, 0x64, 0xa4, 0x73, 0x21, 0xd7, 0xf6, 0xec, 0x21,
	0x71, 0x89, 0xc7, 0xf4, 0xc9, 0x4e, 0x79, 0x43, 0x28, 0x07, 0x63, 0xcf, 0x23, 0xc1, 0xb1, 0x7e,
	0x79, 0x8d, 0x78, 0x03, 0x9f, 0x3a, 0x1e, 0x0b, 0x25, 0xe1, 0xdf, 0x43, 0x4a, 0x87, 0x23, 0x72,
	0x4b, 0x9c, 0x7a, 0xe3, 0xa3, 0x5b, 0x21, 0x0b, 0xc6, 0x7d, 0x26, 0xb9, 0xd7, 0x4e, 0x72, 0x99,
	0xe3, 0x92, 0x90, 0xd9, 0xae, 0x2f, 0x05, 0x8a, 0x2e, 0x61, 0x81, 0xd3, 0x97, 0x68, 0xda, 0xcf,
	0x0a, 0xac, 0xb7, 0x03, 0xe2, 0xdb, 0x01, 0x69, 0xd0, 0x1e, 0x26, 0x9f, 0x8e, 0x49, 0xc8, 0x50,
	0x0d, 0x72, 0xbe, 0xe3, 0x93, 0x91, 0xe3, 0x91, 0x2d, 0x65, 0x5b, 0xb9, 0x51, 0xd8, 0xbd, 0xa9,
	0x3f, 0x3f, 0x8e, 0x58, 0x4c, 0x9f, 0xec, 0xe8, 0x6d, 0xf9, 0x8d, 0xa7, 0xca, 0xa8, 0x02, 0x6a,
	0xfc, 0xdd, 0xa5, 0x3e, 0x73, 0xa8, 0x17, 0x6e, 0xa5, 0x04, 0xe0, 0xa6, 0x1e, 0x79, 0xaa, 0xc7,
	0x9e, 0xea, 0x1d, 0x11, 0x07, 0x5e, 0x8b, 0x15, 0x5a, 0x91, 0x3c, 0xba, 0x02, 0x39, 0x9e, 0x2d,
	0xcf, 0x76, 0xc9, 0xd6, 0xca, 0xb6, 0x72, 0x23, 0x8f, 0xb3, 0x4f, 0x68, 0xaf, 0x69, 0xbb, 0x44,
	0xfb, 0x4d, 0x01, 0x34, 0xeb, 0x7d, 0xe8, 0x53, 0x2f, 0x24, 0xe8, 0xff, 0x50, 0xf2, 0x05, 0xd5,
	0xe6, 0x08, 0x5d, 0x67, 0x20, 0x82, 0xc8, 0xe3, 0xe2, 0x0c, 0xb5, 0x3e, 0x40, 0x21, 0x5c, 0xb1,
	0x03, 0xe6, 0x1c, 0xd9, 0x7d, 0xd6, 0x0d, 0x99, 0x3d, 0x74, 0xbc, 0x61, 0x37, 0xce, 0xb6, 0xf4,
	0xf2, 0xee, 0x1c, 0x61, 0x1b, 0xbe, 0xd3, 0x21, 0xc1, 0xc4, 0xe9, 0x93, 0x2a, 0x09, 0xfb, 0x81,
	0xe3, 0x33, 0x1a, 0xe0, 0xcd, 0x18, 0xb9, 0x13, 0x01, 0x9b, 0x12, 0x17, 0xed, 0xc2, 0x46, 0x6c,
	0x2b, 0x24, 0x61, 0xc8, 0xfd, 0x63, 0xf4, 0x13, 0xe2, 0xc9, 0xd0, 0x2e, 0x49, 0x66, 0x27, 0xe2,
	0x59, 0x9c, 0xa5, 0x75, 0xa1, 0x88, 0xc7, 0xde, 0x4c, 0x7d, 0xe6, 0x0c, 0xf0, 0x3a, 0xac, 0x05,
	0xbc, 0xda, 0x64, 0x62, 0x8f, 0xa4, 0x95, 0x94, 0x90, 0x2b, 0x4d, 0xc9, 0x91, 0x81, 0xeb, 0x50,
	0x8a, 0x0d, 0xc8, 0x14, 0x6e, 0xc0, 0x2a, 0x4f, 0xfa, 0x14, 0x39, 0xf3, 0x84, 0xf6, 0xea, 0x03,
	0xed, 0x65, 0x50, 0xf7, 0x6c, 0xaf, 0x4f, 0x46, 0x33, 0xce, 0x9c, 0x21, 0x6a, 0xc3, 0xfa, 0x8c,
	0xa8, 0x84, 0xdd, 0x87, 0x4c, 0xc8, 0x6c, 0x16, 0x75, 0x55, 0x69, 0xf7, 0x55, 0x7d, 0xce, 0xdb,
	0xa1, 0x37, 0x68, 0xaf, 0xc3, 0x15, 0x75, 0xd3, 0x1b, 0xbb, 0x38, 0x02, 0xd1, 0x7e, 0x51, 0x20,
	0xdb, 0xa0, 0xbd, 0xba, 0x77, 0x44, 0xcf, 0xf0, 0x22, 0xd1, 0x3c, 0xa9, 0x44, 0xf3, 0x3c, 0xb7,
	0x37, 0x57, 0x16, 0xec, 0xcd, 0x69, 0x3c, 0xe9, 0x17, 0x11, 0x8f, 0x0a, 0xa5, 0x1a, 0x61, 0x0d,
	0xda, 0x0b, 0x65, 0x6e, 0xb5, 0x0f, 0x61, 0x6d, 0x4a, 0x91, 0x29, 0x7c, 0x3b, 0x8a, 0xc8, 0xf1,
	0x8e, 0xe8, 0x96, 0xb2, 0xbd, 0x72, 0xa3, 0xb0, 0x7b, 0x7b, 0x11, 0xab, 0x3c, 0x59, 0x22, 0x07,
	0xfc, 0x43, 0xbb, 0x09, 0x28, 0xc2, 0x17, 0xce, 0x9c, 0x53, 0xd1, 0x6f, 0x15, 0x28, 0xc6, 0xa2,
	0xe6, 0x84, 0x78, 0xec, 0xc5, 0x96, 0x13, 0xdd, 0x83, 0xfc, 0x74, 0x5a, 0xc9, 0xfb, 0x57, 0x3e,
	0x55, 0x09, 0x2b, 0x96, 0xc0, 0xc7, 0xc2, 0x9a, 0x0e, 0x1b, 0x51, 0x18, 0xd3, 0x11, 0x74, 0x5e,
	0x6f, 0xfe, 0xeb, 0xa4, 0xbc, 0xcc, 0xee, 0x8b, 0x9a, 0x7c, 0x3c, 0xb3, 0x0d, 0xda, 0x3b, 0x20,
	0x61, 0x68, 0x0f, 0x49, 0x78, 0x8e, 0x3f, 0x7f, 0xa4, 0x00, 0x8e, 0xa5, 0xd1, 0x7f, 0x00, 0xdc,
	0xe8, 0xf3, 0x58, 0x32, 0x2f, 0x29, 0xf5, 0x01, 0x42, 0x90, 0xe6, 0xa1, 0xcb, 0x7e, 0x16, 0xdf,
	0x88, 0x00, 0x38, 0xae, 0x4f, 0x03, 0xc6, 0xaf, 0x9c, 0x68, 0xe3, 0xd2, 0xae, 0xb9, 0x48, 0x39,
	0xa4, 0x6d, 0x5d, 0xfe, 0xd6, 0xa7, 0x60, 0x78, 0x06, 0x18, 0xfd, 0x17, 0x2e, 0xc6, 0x9e, 0x31,
	0xf2, 0x94, 0x89, 0xb6, 0xcf, 0xe3, 0x82, 0xa4, 0x59, 0xe4, 0x29, 0xd3, 0x7e, 0x50, 0x60, 0xfd,
	0x14, 0x08, 0xd2, 0xe0, 0xea, 0x81, 0xd9, 0xe9, 0x18, 0x35, 0xb3, 0x5b, 0x3f, 0x68, 0xb7, 0xb0,
	0x65, 0x34, 0xf7, 0xcc, 0xee, 0x61, 0xb3, 0xd3, 0x36, 0xf7, 0xea, 0x8f, 0xea, 0x66, 0x55, 0xbd,
	0x80, 0x36, 0x60, 0xbd, 0xd1, 0xaa, 0x74, 0x63, 0xb9, 0xaa, 0x59, 0x39, 0xac, 0xa9, 0x0a, 0xda,
	0x82, 0xcb, 0x49, 0xb2, 0x65, 0xd4, 0xf7, 0xcd, 0xaa, 0x9a, 0x3a, 0xa9, 0x50, 0x31, 0x3a, 0xf5,
	0x3d, 0x75, 0x05, 0x6d, 0xc2, 0xa5, 0x59, 0xf2, 0xbb, 0x06, 0x6e, 0xd6, 0x9b, 0x35, 0x35, 0x7d,
	0x52, 0xde, 0xc4, 0xb8, 0x85, 0xd5, 0x0c, 0x7f, 0x45, 0x2e, 0x25, 0x6a, 0x25, 0x7b, 0xe1, 0x23,
	0x50, 0xe3, 0x60, 0x03, 0x49, 0x93, 0x3d, 0x71, 0x67, 0x89, 0xcc, 0x3e, 0xbe, 0x80, 0xd7, 0x24,
	0xdc, 0xd4, 0x42, 0x17, 0x4a, 0xa2, 0xf5, 0x8f, 0xf1, 0xa3, 0xb6, 0x5f, 0xfc, 0x22, 0x89, 0xfb,
	0xf8, 0xf8, 0x02, 0x2e, 0x86, 0xd1, 0x45, 0x8e, 0xe0, 0x2a, 0x00, 0xb9, 0x18, 0x5a, 0xfb, 0x49,
	0x81, 0x5c, 0x2c, 0xae, 0x7d, 0xa7, 0x40, 0x9a, 0xdf, 0x3d, 0xb4, 0x06, 0x85, 0x64, 0x15, 0x0a,
	0x90, 0xed, 0x58, 0xad, 0x76, 0xdb, 0xac, 0xaa, 0x0a, 0x3f, 0xe0, 0xc3, 0xa6, 0x48, 0x5f, 0x0a,
	0xe5, 0x20, 0x5d, 0x6d, 0x35, 0x4d, 0x75, 0x05, 0x01, 0xac, 0x3e, 0x8a, 0x8a, 0x90, 0x46, 0x45,
	0xc8, 0xef, 0xf1, 0x62, 0xee, 0xf3, 0x63, 0x86, 0x6b, 0x1c, 0xb6, 0xab, 0x86, 0x65, 0x56, 0xd5,
	0x55, 0x74, 0x11, 0x72, 0x55, 0x6c, 0xd4, 0x85, 0x7e, 0x96, 0xb3, 0xc4, 0xc9, 0xac, 0xaa, 0x39,
	0xce, 0xea, 0x58, 0x06, 0xb6, 0x38, 0x2b, 0x8f, 0x4a, 0x00, 0x12, 0x84, 0x9f, 0x81, 0x73, 0x05,
	0x0a, 0x3f, 0x15, 0xb4, 0x57, 0xe0, 0x72, 0x74, 0x5d, 0x0f, 0xa2, 0xdd, 0xe5, 0x9c, 0xdb, 0xe4,
	0xc4, 0xd3, 0x60, 0x2a, 0x2e, 0xd3, 0xdd, 0x86, 0xac, 0xdc, 0x7e, 0x64, 0x1d, 0xe7, 0xcf, 0x73,
	0x04, 0x85, 0x49, 0x38, 0x1e, 0xb1, 0x10, 0xc7, 0x30, 0xda, 0x8f, 0x0a, 0x14, 0x13, 0x2c, 0xd4,
	0x82, 0xbc, 0xcd, 0x18, 0x71, 0x7d, 0x46, 0x06, 0x72, 0x3e, 0xef, 0xcc, 0x31, 0x41, 0x0e, 0xa8,
	0xe7, 0x30, 0x1a, 0x38, 0xde, 0x50, 0x0c, 0xe8, 0x63, 0x0c, 0x0e, 0xd8, 0xa7, 0xae, 0xeb, 0x30,
	0x0e, 0x98, 0x5a, 0x1a, 0x70, 0x8a, 0xa1, 0x6d, 0xc3, 0xd5, 0x68, 0x51, 0xe9, 0x91, 0x76, 0xf2,
	0x39, 0x8b, 0x5f, 0x1d, 0x02, 0x28, 0xc9, 0xb1, 0x9e, 0xf9, 0x44, 0x6b, 0xc9, 0x8e, 0x01, 0x58,
	0xed, 0x58, 0x98, 0x57, 0x46, 0x34, 0x4b, 0xa5, 0xd5, 0xda, 0x37, 0x8d, 0x66, 0xd4, 0x2c, 0xf5,
	0xa6, 0x65, 0xd6, 0x4c, 0xac, 0xa6, 0xb8, 0x54, 0xf3, 0xf0, 0xa0, 0x62, 0x62, 0x75, 0x05, 0xe5,
	0x21, 0x63, 0x60, 0x6c, 0xbc, 0xa7, 0xa6, 0x39, 0xb9, 0x55, 0x69, 0x98, 0x7b, 0x96, 0x9a, 0xd1,
	0x7e, 0x55, 0x60, 0x2b, 0x69, 0xe7, 0x78, 0x81, 0xe2, 0x43, 0x4e, 0x3c, 0xda, 0x51, 0x65, 0xc5,
	0x37, 0xb2, 0x20, 0xcd, 0x9e, 0xf9, 0xd1, 0x25, 0x29, 0xed, 0xbe, 0x35, 0x77, 0xf1, 0x4e, 0x07,
	0x13, 0xbd, 0x3b, 0x02, 0x0d, 0x6d, 0x43, 0x61, 0x20, 0xed, 0x3a, 0x34, 0xde, 0xc3, 0x66, 0x49,
	0xe8, 0x7f, 0x50, 0x1c, 0x90, 0x23, 0x7b, 0x3c, 0x62, 0xdd, 0x89, 0x3d, 0x1a, 0x13, 0x39, 0xf6,
	0x2e, 0x4a, 0xe2, 0x3b, 0x9c, 0x86, 0x2e, 0x43, 0x66, 0x18, 0xd0, 0xb1, 0xbf, 0x95, 0x89, 0x7a,
	0x51, 0x1c, 0xb4, 0xcf, 0xe1, 0xda, 0x99, 0xc9, 0x96, 0x5d, 0xf9, 0x01, 0x64, 0xe3, 0xf5, 0x23,
	0xea, 0x17, 0x63, 0xc9, 0xc0, 0x66, 0xd6, 0xcf, 0x18, 0x71, 0xf7, 0x77, 0x10, 0x2f, 0x8b, 0x5c,
	0x50, 0xd1, 0x97, 0x0a, 0x64, 0xe5, 0xc2, 0x8c, 0xee, 0xcf, 0x6f, 0xe6, 0xe4, 0x1f, 0x84, 0xf2,
	0x83, 0xa5, 0x74, 0x65, 0xc0, 0x13, 0x58, 0xc1, 0x63, 0x0f, 0xcd, 0x7f, 0xf9, 0x12, 0xcb, 0x6f,
	0xf9, 0xee, 0xc2, 0x7a, 0xd2, 0xee, 0x67, 0x90, 0x95, 0xcb, 0x14, 0x9a, 0x1f, 0x23, 0xb9, 0x90,
	0x95, 0xef, 0x2d, 0xae, 0x28, 0xad, 0x7f, 0x01, 0xb9, 0x1a, 0x61, 0x62, 0xfa, 0xa2, 0x07, 0x0b,
	0xa2, 0xcc, 0x6e, 0x67, 0xe5, 0x25, 0x1f, 0x07, 0xf4, 0xb5, 0x02, 0x85, 0x1a, 0x61, 0x71, 0xcf,
	0xa0, 0x87, 0x0b, 0x3a, 0x71, 0x62, 0xb7, 0x2a, 0xbf, 0xb9, 0xb4, 0xfe, 0x34, 0x23, 0xab, 0xd1,
	0x3f, 0x04, 0xf4, 0xda, 0xdc, 0x50, 0x27, 0xff, 0x7d, 0x94, 0xef, 0x2f, 0xa3, 0x2a, 0x1d, 0xf8,
	0x4a, 0x11, 0x0b, 0xb7, 0xc8, 0x51, 0x87, 0x05, 0xc4, 0x76, 0xff, 0x91, 0xca, 0xdc, 0x56, 0xd0,
	0x37, 0x0a, 0xa8, 0x35, 0xc2, 0xe4, 0xaa, 0xb0, 0xb0, 0x2f, 0xa7, 0x37, 0xcd, 0xf2, 0xeb, 0xcb,
	0x29, 0x47, 0x99, 0xb9, 0xad, 0xf0, 0x6e, 0x29, 0x26, 0x5e, 0x51, 0xf4, 0xc6, 0x82, 0xa9, 0x49,
	0x3e, 0xd6, 0xe5, 0x87, 0xcb, 0xaa, 0xcb, 0x62, 0x7d, 0xaf, 0xc0, 0xe6, 0x19, 0xa3, 0x14, 0xd5,
	0xe6, 0xc6, 0xfe, 0xeb, 0x97, 0xaf, 0xfc, 0xf8, 0xef, 0x03, 0xc9, 0xcd, 0xab, 0x02, 0x2f, 0x9d,
	0x09, 0x95, 0x40, 0xaa, 0xac, 0x36, 0x68, 0xcf, 0xf0, 0x9d, 0xf7, 0xd5, 0x04, 0xa7, 0x3b, 0xd9,
	0xe9, 0xad, 0x8a, 0x7f, 0x3d, 0x77, 0xfe, 0x0c, 0x00, 0x00, 0xff, 0xff, 0xb7, 0xb1, 0x58, 0x7c,
	0x58, 0x12, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// JobServiceClient is the client API for JobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type JobServiceClient interface {
	// Prepare a job for execution. The job will not be executed until a call is made to run with the
	// returned preparationId.
	Prepare(ctx context.Context, in *PrepareJobRequest, opts ...grpc.CallOption) (*PrepareJobResponse, error)
	// Submit the job for execution
	Run(ctx context.Context, in *RunJobRequest, opts ...grpc.CallOption) (*RunJobResponse, error)
	// Get a list of all invoked jobs
	GetJobs(ctx context.Context, in *GetJobsRequest, opts ...grpc.CallOption) (*GetJobsResponse, error)
	// Get the current state of the job
	GetState(ctx context.Context, in *GetJobStateRequest, opts ...grpc.CallOption) (*JobStateEvent, error)
	// Get the job's pipeline
	GetPipeline(ctx context.Context, in *GetJobPipelineRequest, opts ...grpc.CallOption) (*GetJobPipelineResponse, error)
	// Cancel the job
	Cancel(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*CancelJobResponse, error)
	// Subscribe to a stream of state changes of the job, will immediately return the current state of the job as the first response.
	GetStateStream(ctx context.Context, in *GetJobStateRequest, opts ...grpc.CallOption) (JobService_GetStateStreamClient, error)
	// Subscribe to a stream of state changes and messages from the job
	GetMessageStream(ctx context.Context, in *JobMessagesRequest, opts ...grpc.CallOption) (JobService_GetMessageStreamClient, error)
	// Fetch metrics for a given job
	GetJobMetrics(ctx context.Context, in *GetJobMetricsRequest, opts ...grpc.CallOption) (*GetJobMetricsResponse, error)
	// Get the supported pipeline options of the runner
	DescribePipelineOptions(ctx context.Context, in *DescribePipelineOptionsRequest, opts ...grpc.CallOption) (*DescribePipelineOptionsResponse, error)
}

type jobServiceClient struct {
	cc *grpc.ClientConn
}

func NewJobServiceClient(cc *grpc.ClientConn) JobServiceClient {
	return &jobServiceClient{cc}
}

func (c *jobServiceClient) Prepare(ctx context.Context, in *PrepareJobRequest, opts ...grpc.CallOption) (*PrepareJobResponse, error) {
	out := new(PrepareJobResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/Prepare", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) Run(ctx context.Context, in *RunJobRequest, opts ...grpc.CallOption) (*RunJobResponse, error) {
	out := new(RunJobResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/Run", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetJobs(ctx context.Context, in *GetJobsRequest, opts ...grpc.CallOption) (*GetJobsResponse, error) {
	out := new(GetJobsResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/GetJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetState(ctx context.Context, in *GetJobStateRequest, opts ...grpc.CallOption) (*JobStateEvent, error) {
	out := new(JobStateEvent)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/GetState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetPipeline(ctx context.Context, in *GetJobPipelineRequest, opts ...grpc.CallOption) (*GetJobPipelineResponse, error) {
	out := new(GetJobPipelineResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/GetPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) Cancel(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*CancelJobResponse, error) {
	out := new(CancelJobResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/Cancel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetStateStream(ctx context.Context, in *GetJobStateRequest, opts ...grpc.CallOption) (JobService_GetStateStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_JobService_serviceDesc.Streams[0], "/org.apache.beam.model.job_management.v1.JobService/GetStateStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &jobServiceGetStateStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type JobService_GetStateStreamClient interface {
	Recv() (*JobStateEvent, error)
	grpc.ClientStream
}

type jobServiceGetStateStreamClient struct {
	grpc.ClientStream
}

func (x *jobServiceGetStateStreamClient) Recv() (*JobStateEvent, error) {
	m := new(JobStateEvent)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *jobServiceClient) GetMessageStream(ctx context.Context, in *JobMessagesRequest, opts ...grpc.CallOption) (JobService_GetMessageStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_JobService_serviceDesc.Streams[1], "/org.apache.beam.model.job_management.v1.JobService/GetMessageStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &jobServiceGetMessageStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type JobService_GetMessageStreamClient interface {
	Recv() (*JobMessagesResponse, error)
	grpc.ClientStream
}

type jobServiceGetMessageStreamClient struct {
	grpc.ClientStream
}

func (x *jobServiceGetMessageStreamClient) Recv() (*JobMessagesResponse, error) {
	m := new(JobMessagesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *jobServiceClient) GetJobMetrics(ctx context.Context, in *GetJobMetricsRequest, opts ...grpc.CallOption) (*GetJobMetricsResponse, error) {
	out := new(GetJobMetricsResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/GetJobMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) DescribePipelineOptions(ctx context.Context, in *DescribePipelineOptionsRequest, opts ...grpc.CallOption) (*DescribePipelineOptionsResponse, error) {
	out := new(DescribePipelineOptionsResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/DescribePipelineOptions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// JobServiceServer is the server API for JobService service.
type JobServiceServer interface {
	// Prepare a job for execution. The job will not be executed until a call is made to run with the
	// returned preparationId.
	Prepare(context.Context, *PrepareJobRequest) (*PrepareJobResponse, error)
	// Submit the job for execution
	Run(context.Context, *RunJobRequest) (*RunJobResponse, error)
	// Get a list of all invoked jobs
	GetJobs(context.Context, *GetJobsRequest) (*GetJobsResponse, error)
	// Get the current state of the job
	GetState(context.Context, *GetJobStateRequest) (*JobStateEvent, error)
	// Get the job's pipeline
	GetPipeline(context.Context, *GetJobPipelineRequest) (*GetJobPipelineResponse, error)
	// Cancel the job
	Cancel(context.Context, *CancelJobRequest) (*CancelJobResponse, error)
	// Subscribe to a stream of state changes of the job, will immediately return the current state of the job as the first response.
	GetStateStream(*GetJobStateRequest, JobService_GetStateStreamServer) error
	// Subscribe to a stream of state changes and messages from the job
	GetMessageStream(*JobMessagesRequest, JobService_GetMessageStreamServer) error
	// Fetch metrics for a given job
	GetJobMetrics(context.Context, *GetJobMetricsRequest) (*GetJobMetricsResponse, error)
	// Get the supported pipeline options of the runner
	DescribePipelineOptions(context.Context, *DescribePipelineOptionsRequest) (*DescribePipelineOptionsResponse, error)
}

// UnimplementedJobServiceServer can be embedded to have forward compatible implementations.
type UnimplementedJobServiceServer struct {
}

func (*UnimplementedJobServiceServer) Prepare(ctx context.Context, req *PrepareJobRequest) (*PrepareJobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Prepare not implemented")
}
func (*UnimplementedJobServiceServer) Run(ctx context.Context, req *RunJobRequest) (*RunJobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Run not implemented")
}
func (*UnimplementedJobServiceServer) GetJobs(ctx context.Context, req *GetJobsRequest) (*GetJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJobs not implemented")
}
func (*UnimplementedJobServiceServer) GetState(ctx context.Context, req *GetJobStateRequest) (*JobStateEvent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetState not implemented")
}
func (*UnimplementedJobServiceServer) GetPipeline(ctx context.Context, req *GetJobPipelineRequest) (*GetJobPipelineResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPipeline not implemented")
}
func (*UnimplementedJobServiceServer) Cancel(ctx context.Context, req *CancelJobRequest) (*CancelJobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Cancel not implemented")
}
func (*UnimplementedJobServiceServer) GetStateStream(req *GetJobStateRequest, srv JobService_GetStateStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method GetStateStream not implemented")
}
func (*UnimplementedJobServiceServer) GetMessageStream(req *JobMessagesRequest, srv JobService_GetMessageStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method GetMessageStream not implemented")
}
func (*UnimplementedJobServiceServer) GetJobMetrics(ctx context.Context, req *GetJobMetricsRequest) (*GetJobMetricsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJobMetrics not implemented")
}
func (*UnimplementedJobServiceServer) DescribePipelineOptions(ctx context.Context, req *DescribePipelineOptionsRequest) (*DescribePipelineOptionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DescribePipelineOptions not implemented")
}

func RegisterJobServiceServer(s *grpc.Server, srv JobServiceServer) {
	s.RegisterService(&_JobService_serviceDesc, srv)
}

func _JobService_Prepare_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PrepareJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).Prepare(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/Prepare",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).Prepare(ctx, req.(*PrepareJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_Run_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).Run(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/Run",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).Run(ctx, req.(*RunJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/GetJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetJobs(ctx, req.(*GetJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/GetState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetState(ctx, req.(*GetJobStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/GetPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetPipeline(ctx, req.(*GetJobPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_Cancel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).Cancel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/Cancel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).Cancel(ctx, req.(*CancelJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetStateStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetJobStateRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(JobServiceServer).GetStateStream(m, &jobServiceGetStateStreamServer{stream})
}

type JobService_GetStateStreamServer interface {
	Send(*JobStateEvent) error
	grpc.ServerStream
}

type jobServiceGetStateStreamServer struct {
	grpc.ServerStream
}

func (x *jobServiceGetStateStreamServer) Send(m *JobStateEvent) error {
	return x.ServerStream.SendMsg(m)
}

func _JobService_GetMessageStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(JobMessagesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(JobServiceServer).GetMessageStream(m, &jobServiceGetMessageStreamServer{stream})
}

type JobService_GetMessageStreamServer interface {
	Send(*JobMessagesResponse) error
	grpc.ServerStream
}

type jobServiceGetMessageStreamServer struct {
	grpc.ServerStream
}

func (x *jobServiceGetMessageStreamServer) Send(m *JobMessagesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _JobService_GetJobMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetJobMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/GetJobMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetJobMetrics(ctx, req.(*GetJobMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_DescribePipelineOptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribePipelineOptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).DescribePipelineOptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/DescribePipelineOptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).DescribePipelineOptions(ctx, req.(*DescribePipelineOptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _JobService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.job_management.v1.JobService",
	HandlerType: (*JobServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Prepare",
			Handler:    _JobService_Prepare_Handler,
		},
		{
			MethodName: "Run",
			Handler:    _JobService_Run_Handler,
		},
		{
			MethodName: "GetJobs",
			Handler:    _JobService_GetJobs_Handler,
		},
		{
			MethodName: "GetState",
			Handler:    _JobService_GetState_Handler,
		},
		{
			MethodName: "GetPipeline",
			Handler:    _JobService_GetPipeline_Handler,
		},
		{
			MethodName: "Cancel",
			Handler:    _JobService_Cancel_Handler,
		},
		{
			MethodName: "GetJobMetrics",
			Handler:    _JobService_GetJobMetrics_Handler,
		},
		{
			MethodName: "DescribePipelineOptions",
			Handler:    _JobService_DescribePipelineOptions_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetStateStream",
			Handler:       _JobService_GetStateStream_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetMessageStream",
			Handler:       _JobService_GetMessageStream_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "beam_job_api.proto",
}
