---
layout: section
title: "Use Beam"
permalink: /get-started/
section_menu: section-menu/get-started.html
redirect_from:
  - /use/
  - /docs/use/
---
<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# Get Started with Apache Beam
Learn to use Beam to create data processing pipelines that run on supported processing back-ends:

#### [Beam Overview]({{ site.baseurl}}/get-started/beam-overview)

Learn about the Beam model, the currently available Beam SDKs and Runners, and Beam's native I/O connectors.

#### Quickstart for [Java]({{ site.baseurl }}/get-started/quickstart-java), [Python]({{ site.baseurl }}/get-started/quickstart-py) or [Go]({{ site.baseurl }}/get-started/quickstart-go)

Learn how to set up a Beam project and run a simple example Beam pipeline on your local machine.

#### Example Walkthroughs

See detailed walkthroughs of complete Beam pipelines.

* [WordCount]({{ site.baseurl }}/get-started/wordcount-example): Simple example pipelines that demonstrate basic Beam programming, including debugging and testing
* [Mobile Gaming]({{ site.baseurl }}/get-started/mobile-gaming-example): A series of more advanced pipelines that demonstrate use cases in the mobile gaming domain

#### [Downloads and Releases]({{ site.baseurl}}/get-started/downloads)

Find download links and information on the latest Beam releases, including versioning and release notes.

#### [Support]({{ site.baseurl }}/get-started/support)

Find resources, such as mailing lists and issue tracking, to help you use Beam. Ask questions and discuss topics via [Stack Overflow](https://stackoverflow.com/questions/tagged/apache-beam) or on Beam's [Slack Channel](https://apachebeam.slack.com).
