// Code generated by protoc-gen-go. DO NOT EDIT.
// source: beam_fn_api.proto

package fnexecution_v1

import (
	context "context"
	fmt "fmt"
	pipeline_v1 "github.com/apache/beam/sdks/go/pkg/beam/model/pipeline_v1"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/golang/protobuf/protoc-gen-go/descriptor"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "github.com/golang/protobuf/ptypes/wrappers"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type LogEntry_Severity_Enum int32

const (
	// Unspecified level information. Will be logged at the TRACE level.
	LogEntry_Severity_UNSPECIFIED LogEntry_Severity_Enum = 0
	LogEntry_Severity_TRACE       LogEntry_Severity_Enum = 1
	// Debugging information.
	LogEntry_Severity_DEBUG LogEntry_Severity_Enum = 2
	// Normal events.
	LogEntry_Severity_INFO LogEntry_Severity_Enum = 3
	// Normal but significant events, such as start up, shut down, or
	// configuration.
	LogEntry_Severity_NOTICE LogEntry_Severity_Enum = 4
	// Warning events might cause problems.
	LogEntry_Severity_WARN LogEntry_Severity_Enum = 5
	// Error events are likely to cause problems.
	LogEntry_Severity_ERROR LogEntry_Severity_Enum = 6
	// Critical events cause severe problems or brief outages and may
	// indicate that a person must take action.
	LogEntry_Severity_CRITICAL LogEntry_Severity_Enum = 7
)

var LogEntry_Severity_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "TRACE",
	2: "DEBUG",
	3: "INFO",
	4: "NOTICE",
	5: "WARN",
	6: "ERROR",
	7: "CRITICAL",
}

var LogEntry_Severity_Enum_value = map[string]int32{
	"UNSPECIFIED": 0,
	"TRACE":       1,
	"DEBUG":       2,
	"INFO":        3,
	"NOTICE":      4,
	"WARN":        5,
	"ERROR":       6,
	"CRITICAL":    7,
}

func (x LogEntry_Severity_Enum) String() string {
	return proto.EnumName(LogEntry_Severity_Enum_name, int32(x))
}

func (LogEntry_Severity_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{29, 1, 0}
}

// A descriptor for connecting to a remote port using the Beam Fn Data API.
// Allows for communication between two environments (for example between the
// runner and the SDK).
// Stable
type RemoteGrpcPort struct {
	// (Required) An API descriptor which describes where to
	// connect to including any authentication that is required.
	ApiServiceDescriptor *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,1,opt,name=api_service_descriptor,json=apiServiceDescriptor,proto3" json:"api_service_descriptor,omitempty"`
	// (Required) The ID of the Coder that will be used to encode and decode data
	// sent over this port.
	CoderId              string   `protobuf:"bytes,2,opt,name=coder_id,json=coderId,proto3" json:"coder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoteGrpcPort) Reset()         { *m = RemoteGrpcPort{} }
func (m *RemoteGrpcPort) String() string { return proto.CompactTextString(m) }
func (*RemoteGrpcPort) ProtoMessage()    {}
func (*RemoteGrpcPort) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{0}
}

func (m *RemoteGrpcPort) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoteGrpcPort.Unmarshal(m, b)
}
func (m *RemoteGrpcPort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoteGrpcPort.Marshal(b, m, deterministic)
}
func (m *RemoteGrpcPort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoteGrpcPort.Merge(m, src)
}
func (m *RemoteGrpcPort) XXX_Size() int {
	return xxx_messageInfo_RemoteGrpcPort.Size(m)
}
func (m *RemoteGrpcPort) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoteGrpcPort.DiscardUnknown(m)
}

var xxx_messageInfo_RemoteGrpcPort proto.InternalMessageInfo

func (m *RemoteGrpcPort) GetApiServiceDescriptor() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.ApiServiceDescriptor
	}
	return nil
}

func (m *RemoteGrpcPort) GetCoderId() string {
	if m != nil {
		return m.CoderId
	}
	return ""
}

// Requests the ProcessBundleDescriptor with the given id.
type GetProcessBundleDescriptorRequest struct {
	ProcessBundleDescriptorId string   `protobuf:"bytes,1,opt,name=process_bundle_descriptor_id,json=processBundleDescriptorId,proto3" json:"process_bundle_descriptor_id,omitempty"`
	XXX_NoUnkeyedLiteral      struct{} `json:"-"`
	XXX_unrecognized          []byte   `json:"-"`
	XXX_sizecache             int32    `json:"-"`
}

func (m *GetProcessBundleDescriptorRequest) Reset()         { *m = GetProcessBundleDescriptorRequest{} }
func (m *GetProcessBundleDescriptorRequest) String() string { return proto.CompactTextString(m) }
func (*GetProcessBundleDescriptorRequest) ProtoMessage()    {}
func (*GetProcessBundleDescriptorRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{1}
}

func (m *GetProcessBundleDescriptorRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetProcessBundleDescriptorRequest.Unmarshal(m, b)
}
func (m *GetProcessBundleDescriptorRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetProcessBundleDescriptorRequest.Marshal(b, m, deterministic)
}
func (m *GetProcessBundleDescriptorRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetProcessBundleDescriptorRequest.Merge(m, src)
}
func (m *GetProcessBundleDescriptorRequest) XXX_Size() int {
	return xxx_messageInfo_GetProcessBundleDescriptorRequest.Size(m)
}
func (m *GetProcessBundleDescriptorRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetProcessBundleDescriptorRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetProcessBundleDescriptorRequest proto.InternalMessageInfo

func (m *GetProcessBundleDescriptorRequest) GetProcessBundleDescriptorId() string {
	if m != nil {
		return m.ProcessBundleDescriptorId
	}
	return ""
}

// A request sent by a runner which the SDK is asked to fulfill.
// For any unsupported request type, an error should be returned with a
// matching instruction id.
// Stable
type InstructionRequest struct {
	// (Required) A unique identifier provided by the runner which represents
	// this requests execution. The InstructionResponse MUST have the matching id.
	InstructionId string `protobuf:"bytes,1,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	// (Required) A request that the SDK Harness needs to interpret.
	//
	// Types that are valid to be assigned to Request:
	//	*InstructionRequest_Register
	//	*InstructionRequest_ProcessBundle
	//	*InstructionRequest_ProcessBundleProgress
	//	*InstructionRequest_ProcessBundleSplit
	//	*InstructionRequest_FinalizeBundle
	//	*InstructionRequest_ProcessBundleProgressMetadata
	Request              isInstructionRequest_Request `protobuf_oneof:"request"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *InstructionRequest) Reset()         { *m = InstructionRequest{} }
func (m *InstructionRequest) String() string { return proto.CompactTextString(m) }
func (*InstructionRequest) ProtoMessage()    {}
func (*InstructionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{2}
}

func (m *InstructionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstructionRequest.Unmarshal(m, b)
}
func (m *InstructionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstructionRequest.Marshal(b, m, deterministic)
}
func (m *InstructionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstructionRequest.Merge(m, src)
}
func (m *InstructionRequest) XXX_Size() int {
	return xxx_messageInfo_InstructionRequest.Size(m)
}
func (m *InstructionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InstructionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InstructionRequest proto.InternalMessageInfo

func (m *InstructionRequest) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

type isInstructionRequest_Request interface {
	isInstructionRequest_Request()
}

type InstructionRequest_Register struct {
	Register *RegisterRequest `protobuf:"bytes,1000,opt,name=register,proto3,oneof"`
}

type InstructionRequest_ProcessBundle struct {
	ProcessBundle *ProcessBundleRequest `protobuf:"bytes,1001,opt,name=process_bundle,json=processBundle,proto3,oneof"`
}

type InstructionRequest_ProcessBundleProgress struct {
	ProcessBundleProgress *ProcessBundleProgressRequest `protobuf:"bytes,1002,opt,name=process_bundle_progress,json=processBundleProgress,proto3,oneof"`
}

type InstructionRequest_ProcessBundleSplit struct {
	ProcessBundleSplit *ProcessBundleSplitRequest `protobuf:"bytes,1003,opt,name=process_bundle_split,json=processBundleSplit,proto3,oneof"`
}

type InstructionRequest_FinalizeBundle struct {
	FinalizeBundle *FinalizeBundleRequest `protobuf:"bytes,1004,opt,name=finalize_bundle,json=finalizeBundle,proto3,oneof"`
}

type InstructionRequest_ProcessBundleProgressMetadata struct {
	ProcessBundleProgressMetadata *ProcessBundleProgressMetadataRequest `protobuf:"bytes,1005,opt,name=process_bundle_progress_metadata,json=processBundleProgressMetadata,proto3,oneof"`
}

func (*InstructionRequest_Register) isInstructionRequest_Request() {}

func (*InstructionRequest_ProcessBundle) isInstructionRequest_Request() {}

func (*InstructionRequest_ProcessBundleProgress) isInstructionRequest_Request() {}

func (*InstructionRequest_ProcessBundleSplit) isInstructionRequest_Request() {}

func (*InstructionRequest_FinalizeBundle) isInstructionRequest_Request() {}

func (*InstructionRequest_ProcessBundleProgressMetadata) isInstructionRequest_Request() {}

func (m *InstructionRequest) GetRequest() isInstructionRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *InstructionRequest) GetRegister() *RegisterRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_Register); ok {
		return x.Register
	}
	return nil
}

func (m *InstructionRequest) GetProcessBundle() *ProcessBundleRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_ProcessBundle); ok {
		return x.ProcessBundle
	}
	return nil
}

func (m *InstructionRequest) GetProcessBundleProgress() *ProcessBundleProgressRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_ProcessBundleProgress); ok {
		return x.ProcessBundleProgress
	}
	return nil
}

func (m *InstructionRequest) GetProcessBundleSplit() *ProcessBundleSplitRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_ProcessBundleSplit); ok {
		return x.ProcessBundleSplit
	}
	return nil
}

func (m *InstructionRequest) GetFinalizeBundle() *FinalizeBundleRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_FinalizeBundle); ok {
		return x.FinalizeBundle
	}
	return nil
}

func (m *InstructionRequest) GetProcessBundleProgressMetadata() *ProcessBundleProgressMetadataRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_ProcessBundleProgressMetadata); ok {
		return x.ProcessBundleProgressMetadata
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*InstructionRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*InstructionRequest_Register)(nil),
		(*InstructionRequest_ProcessBundle)(nil),
		(*InstructionRequest_ProcessBundleProgress)(nil),
		(*InstructionRequest_ProcessBundleSplit)(nil),
		(*InstructionRequest_FinalizeBundle)(nil),
		(*InstructionRequest_ProcessBundleProgressMetadata)(nil),
	}
}

// The response for an associated request the SDK had been asked to fulfill.
// Stable
type InstructionResponse struct {
	// (Required) A reference provided by the runner which represents a requests
	// execution. The InstructionResponse MUST have the matching id when
	// responding to the runner.
	InstructionId string `protobuf:"bytes,1,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	// If this is specified, then this instruction has failed.
	// A human readable string representing the reason as to why processing has
	// failed.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// If the instruction did not fail, it is required to return an equivalent
	// response type depending on the request this matches.
	//
	// Types that are valid to be assigned to Response:
	//	*InstructionResponse_Register
	//	*InstructionResponse_ProcessBundle
	//	*InstructionResponse_ProcessBundleProgress
	//	*InstructionResponse_ProcessBundleSplit
	//	*InstructionResponse_FinalizeBundle
	//	*InstructionResponse_ProcessBundleProgressMetadata
	Response             isInstructionResponse_Response `protobuf_oneof:"response"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *InstructionResponse) Reset()         { *m = InstructionResponse{} }
func (m *InstructionResponse) String() string { return proto.CompactTextString(m) }
func (*InstructionResponse) ProtoMessage()    {}
func (*InstructionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{3}
}

func (m *InstructionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstructionResponse.Unmarshal(m, b)
}
func (m *InstructionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstructionResponse.Marshal(b, m, deterministic)
}
func (m *InstructionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstructionResponse.Merge(m, src)
}
func (m *InstructionResponse) XXX_Size() int {
	return xxx_messageInfo_InstructionResponse.Size(m)
}
func (m *InstructionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_InstructionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_InstructionResponse proto.InternalMessageInfo

func (m *InstructionResponse) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

func (m *InstructionResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type isInstructionResponse_Response interface {
	isInstructionResponse_Response()
}

type InstructionResponse_Register struct {
	Register *RegisterResponse `protobuf:"bytes,1000,opt,name=register,proto3,oneof"`
}

type InstructionResponse_ProcessBundle struct {
	ProcessBundle *ProcessBundleResponse `protobuf:"bytes,1001,opt,name=process_bundle,json=processBundle,proto3,oneof"`
}

type InstructionResponse_ProcessBundleProgress struct {
	ProcessBundleProgress *ProcessBundleProgressResponse `protobuf:"bytes,1002,opt,name=process_bundle_progress,json=processBundleProgress,proto3,oneof"`
}

type InstructionResponse_ProcessBundleSplit struct {
	ProcessBundleSplit *ProcessBundleSplitResponse `protobuf:"bytes,1003,opt,name=process_bundle_split,json=processBundleSplit,proto3,oneof"`
}

type InstructionResponse_FinalizeBundle struct {
	FinalizeBundle *FinalizeBundleResponse `protobuf:"bytes,1004,opt,name=finalize_bundle,json=finalizeBundle,proto3,oneof"`
}

type InstructionResponse_ProcessBundleProgressMetadata struct {
	ProcessBundleProgressMetadata *ProcessBundleProgressMetadataResponse `protobuf:"bytes,1005,opt,name=process_bundle_progress_metadata,json=processBundleProgressMetadata,proto3,oneof"`
}

func (*InstructionResponse_Register) isInstructionResponse_Response() {}

func (*InstructionResponse_ProcessBundle) isInstructionResponse_Response() {}

func (*InstructionResponse_ProcessBundleProgress) isInstructionResponse_Response() {}

func (*InstructionResponse_ProcessBundleSplit) isInstructionResponse_Response() {}

func (*InstructionResponse_FinalizeBundle) isInstructionResponse_Response() {}

func (*InstructionResponse_ProcessBundleProgressMetadata) isInstructionResponse_Response() {}

func (m *InstructionResponse) GetResponse() isInstructionResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *InstructionResponse) GetRegister() *RegisterResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_Register); ok {
		return x.Register
	}
	return nil
}

func (m *InstructionResponse) GetProcessBundle() *ProcessBundleResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_ProcessBundle); ok {
		return x.ProcessBundle
	}
	return nil
}

func (m *InstructionResponse) GetProcessBundleProgress() *ProcessBundleProgressResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_ProcessBundleProgress); ok {
		return x.ProcessBundleProgress
	}
	return nil
}

func (m *InstructionResponse) GetProcessBundleSplit() *ProcessBundleSplitResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_ProcessBundleSplit); ok {
		return x.ProcessBundleSplit
	}
	return nil
}

func (m *InstructionResponse) GetFinalizeBundle() *FinalizeBundleResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_FinalizeBundle); ok {
		return x.FinalizeBundle
	}
	return nil
}

func (m *InstructionResponse) GetProcessBundleProgressMetadata() *ProcessBundleProgressMetadataResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_ProcessBundleProgressMetadata); ok {
		return x.ProcessBundleProgressMetadata
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*InstructionResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*InstructionResponse_Register)(nil),
		(*InstructionResponse_ProcessBundle)(nil),
		(*InstructionResponse_ProcessBundleProgress)(nil),
		(*InstructionResponse_ProcessBundleSplit)(nil),
		(*InstructionResponse_FinalizeBundle)(nil),
		(*InstructionResponse_ProcessBundleProgressMetadata)(nil),
	}
}

// A list of objects which can be referred to by the runner in
// future requests.
// Stable
type RegisterRequest struct {
	// (Optional) The set of descriptors used to process bundles.
	ProcessBundleDescriptor []*ProcessBundleDescriptor `protobuf:"bytes,1,rep,name=process_bundle_descriptor,json=processBundleDescriptor,proto3" json:"process_bundle_descriptor,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}                   `json:"-"`
	XXX_unrecognized        []byte                     `json:"-"`
	XXX_sizecache           int32                      `json:"-"`
}

func (m *RegisterRequest) Reset()         { *m = RegisterRequest{} }
func (m *RegisterRequest) String() string { return proto.CompactTextString(m) }
func (*RegisterRequest) ProtoMessage()    {}
func (*RegisterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{4}
}

func (m *RegisterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RegisterRequest.Unmarshal(m, b)
}
func (m *RegisterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RegisterRequest.Marshal(b, m, deterministic)
}
func (m *RegisterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterRequest.Merge(m, src)
}
func (m *RegisterRequest) XXX_Size() int {
	return xxx_messageInfo_RegisterRequest.Size(m)
}
func (m *RegisterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterRequest proto.InternalMessageInfo

func (m *RegisterRequest) GetProcessBundleDescriptor() []*ProcessBundleDescriptor {
	if m != nil {
		return m.ProcessBundleDescriptor
	}
	return nil
}

// Stable
type RegisterResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RegisterResponse) Reset()         { *m = RegisterResponse{} }
func (m *RegisterResponse) String() string { return proto.CompactTextString(m) }
func (*RegisterResponse) ProtoMessage()    {}
func (*RegisterResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{5}
}

func (m *RegisterResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RegisterResponse.Unmarshal(m, b)
}
func (m *RegisterResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RegisterResponse.Marshal(b, m, deterministic)
}
func (m *RegisterResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterResponse.Merge(m, src)
}
func (m *RegisterResponse) XXX_Size() int {
	return xxx_messageInfo_RegisterResponse.Size(m)
}
func (m *RegisterResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterResponse proto.InternalMessageInfo

// Definitions that should be used to construct the bundle processing graph.
type ProcessBundleDescriptor struct {
	// (Required) A pipeline level unique id which can be used as a reference to
	// refer to this.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// (Required) A map from pipeline-scoped id to PTransform.
	Transforms map[string]*pipeline_v1.PTransform `protobuf:"bytes,2,rep,name=transforms,proto3" json:"transforms,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to PCollection.
	Pcollections map[string]*pipeline_v1.PCollection `protobuf:"bytes,3,rep,name=pcollections,proto3" json:"pcollections,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to WindowingStrategy.
	WindowingStrategies map[string]*pipeline_v1.WindowingStrategy `protobuf:"bytes,4,rep,name=windowing_strategies,json=windowingStrategies,proto3" json:"windowing_strategies,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to Coder.
	Coders map[string]*pipeline_v1.Coder `protobuf:"bytes,5,rep,name=coders,proto3" json:"coders,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to Environment.
	Environments map[string]*pipeline_v1.Environment `protobuf:"bytes,6,rep,name=environments,proto3" json:"environments,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A descriptor describing the end point to use for State API
	// calls. Required if the Runner intends to send remote references over the
	// data plane or if any of the transforms rely on user state or side inputs.
	StateApiServiceDescriptor *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,7,opt,name=state_api_service_descriptor,json=stateApiServiceDescriptor,proto3" json:"state_api_service_descriptor,omitempty"`
	// A descriptor describing the end point to use for Data API for user timers.
	// Required if the ProcessBundleDescriptor contains any transforms that have user timers.
	TimerApiServiceDescriptor *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,8,opt,name=timer_api_service_descriptor,json=timerApiServiceDescriptor,proto3" json:"timer_api_service_descriptor,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}                          `json:"-"`
	XXX_unrecognized          []byte                            `json:"-"`
	XXX_sizecache             int32                             `json:"-"`
}

func (m *ProcessBundleDescriptor) Reset()         { *m = ProcessBundleDescriptor{} }
func (m *ProcessBundleDescriptor) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleDescriptor) ProtoMessage()    {}
func (*ProcessBundleDescriptor) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{6}
}

func (m *ProcessBundleDescriptor) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleDescriptor.Unmarshal(m, b)
}
func (m *ProcessBundleDescriptor) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleDescriptor.Marshal(b, m, deterministic)
}
func (m *ProcessBundleDescriptor) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleDescriptor.Merge(m, src)
}
func (m *ProcessBundleDescriptor) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleDescriptor.Size(m)
}
func (m *ProcessBundleDescriptor) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleDescriptor.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleDescriptor proto.InternalMessageInfo

func (m *ProcessBundleDescriptor) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ProcessBundleDescriptor) GetTransforms() map[string]*pipeline_v1.PTransform {
	if m != nil {
		return m.Transforms
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetPcollections() map[string]*pipeline_v1.PCollection {
	if m != nil {
		return m.Pcollections
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetWindowingStrategies() map[string]*pipeline_v1.WindowingStrategy {
	if m != nil {
		return m.WindowingStrategies
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetCoders() map[string]*pipeline_v1.Coder {
	if m != nil {
		return m.Coders
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetEnvironments() map[string]*pipeline_v1.Environment {
	if m != nil {
		return m.Environments
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetStateApiServiceDescriptor() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.StateApiServiceDescriptor
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetTimerApiServiceDescriptor() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.TimerApiServiceDescriptor
	}
	return nil
}

// One of the applications specifying the scope of work for a bundle.
// See
// https://docs.google.com/document/d/1tUDb45sStdR8u7-jBkGdw3OGFK7aa2-V7eo86zYSE_4/edit#heading=h.9g3g5weg2u9
// for further details.
type BundleApplication struct {
	// (Required) The transform to which to pass the element
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) Name of the transform's input to which to pass the element.
	InputId string `protobuf:"bytes,2,opt,name=input_id,json=inputId,proto3" json:"input_id,omitempty"`
	// (Required) The encoded element to pass to the transform.
	Element []byte `protobuf:"bytes,3,opt,name=element,proto3" json:"element,omitempty"`
	// The map is keyed by the local output name of the PTransform. Each
	// value represents a lower bound on the timestamps of elements that
	// are produced by this PTransform into each of its output PCollections
	// when invoked with this application.
	//
	// If there is no watermark reported from RestrictionTracker, the runner will
	// use MIN_TIMESTAMP by default.
	OutputWatermarks map[string]*timestamp.Timestamp `protobuf:"bytes,4,rep,name=output_watermarks,json=outputWatermarks,proto3" json:"output_watermarks,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Whether this application potentially produces an unbounded
	// amount of data. Note that this should only be set to BOUNDED if and
	// only if the application is known to produce a finite amount of output.
	IsBounded            pipeline_v1.IsBounded_Enum `protobuf:"varint,5,opt,name=is_bounded,json=isBounded,proto3,enum=org.apache.beam.model.pipeline.v1.IsBounded_Enum" json:"is_bounded,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *BundleApplication) Reset()         { *m = BundleApplication{} }
func (m *BundleApplication) String() string { return proto.CompactTextString(m) }
func (*BundleApplication) ProtoMessage()    {}
func (*BundleApplication) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{7}
}

func (m *BundleApplication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BundleApplication.Unmarshal(m, b)
}
func (m *BundleApplication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BundleApplication.Marshal(b, m, deterministic)
}
func (m *BundleApplication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BundleApplication.Merge(m, src)
}
func (m *BundleApplication) XXX_Size() int {
	return xxx_messageInfo_BundleApplication.Size(m)
}
func (m *BundleApplication) XXX_DiscardUnknown() {
	xxx_messageInfo_BundleApplication.DiscardUnknown(m)
}

var xxx_messageInfo_BundleApplication proto.InternalMessageInfo

func (m *BundleApplication) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *BundleApplication) GetInputId() string {
	if m != nil {
		return m.InputId
	}
	return ""
}

func (m *BundleApplication) GetElement() []byte {
	if m != nil {
		return m.Element
	}
	return nil
}

func (m *BundleApplication) GetOutputWatermarks() map[string]*timestamp.Timestamp {
	if m != nil {
		return m.OutputWatermarks
	}
	return nil
}

func (m *BundleApplication) GetIsBounded() pipeline_v1.IsBounded_Enum {
	if m != nil {
		return m.IsBounded
	}
	return pipeline_v1.IsBounded_UNSPECIFIED
}

// An Application should be scheduled for execution after a delay.
// Either an absolute timestamp or a relative timestamp can represent a
// scheduled execution time.
type DelayedBundleApplication struct {
	// (Required) The application that should be scheduled.
	Application *BundleApplication `protobuf:"bytes,1,opt,name=application,proto3" json:"application,omitempty"`
	// Recommended time delay at which the application should be scheduled to
	// execute by the runner. Time delay that equals 0 may be scheduled to execute
	// immediately. The unit of time delay should be microsecond.
	RequestedTimeDelay   *duration.Duration `protobuf:"bytes,2,opt,name=requested_time_delay,json=requestedTimeDelay,proto3" json:"requested_time_delay,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *DelayedBundleApplication) Reset()         { *m = DelayedBundleApplication{} }
func (m *DelayedBundleApplication) String() string { return proto.CompactTextString(m) }
func (*DelayedBundleApplication) ProtoMessage()    {}
func (*DelayedBundleApplication) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{8}
}

func (m *DelayedBundleApplication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DelayedBundleApplication.Unmarshal(m, b)
}
func (m *DelayedBundleApplication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DelayedBundleApplication.Marshal(b, m, deterministic)
}
func (m *DelayedBundleApplication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DelayedBundleApplication.Merge(m, src)
}
func (m *DelayedBundleApplication) XXX_Size() int {
	return xxx_messageInfo_DelayedBundleApplication.Size(m)
}
func (m *DelayedBundleApplication) XXX_DiscardUnknown() {
	xxx_messageInfo_DelayedBundleApplication.DiscardUnknown(m)
}

var xxx_messageInfo_DelayedBundleApplication proto.InternalMessageInfo

func (m *DelayedBundleApplication) GetApplication() *BundleApplication {
	if m != nil {
		return m.Application
	}
	return nil
}

func (m *DelayedBundleApplication) GetRequestedTimeDelay() *duration.Duration {
	if m != nil {
		return m.RequestedTimeDelay
	}
	return nil
}

// A request to process a given bundle.
// Stable
type ProcessBundleRequest struct {
	// (Required) A reference to the process bundle descriptor that must be
	// instantiated and executed by the SDK harness.
	ProcessBundleDescriptorId string `protobuf:"bytes,1,opt,name=process_bundle_descriptor_id,json=processBundleDescriptorId,proto3" json:"process_bundle_descriptor_id,omitempty"`
	// (Optional) A list of cache tokens that can be used by an SDK to reuse
	// cached data returned by the State API across multiple bundles.
	CacheTokens          []*ProcessBundleRequest_CacheToken `protobuf:"bytes,2,rep,name=cache_tokens,json=cacheTokens,proto3" json:"cache_tokens,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *ProcessBundleRequest) Reset()         { *m = ProcessBundleRequest{} }
func (m *ProcessBundleRequest) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleRequest) ProtoMessage()    {}
func (*ProcessBundleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{9}
}

func (m *ProcessBundleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleRequest.Unmarshal(m, b)
}
func (m *ProcessBundleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleRequest.Marshal(b, m, deterministic)
}
func (m *ProcessBundleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleRequest.Merge(m, src)
}
func (m *ProcessBundleRequest) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleRequest.Size(m)
}
func (m *ProcessBundleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleRequest proto.InternalMessageInfo

func (m *ProcessBundleRequest) GetProcessBundleDescriptorId() string {
	if m != nil {
		return m.ProcessBundleDescriptorId
	}
	return ""
}

func (m *ProcessBundleRequest) GetCacheTokens() []*ProcessBundleRequest_CacheToken {
	if m != nil {
		return m.CacheTokens
	}
	return nil
}

// A cache token which can be used by an SDK to check for the validity
// of cached elements which have a cache token associated.
type ProcessBundleRequest_CacheToken struct {
	// The scope of a cache token.
	//
	// Types that are valid to be assigned to Type:
	//	*ProcessBundleRequest_CacheToken_UserState_
	//	*ProcessBundleRequest_CacheToken_SideInput_
	Type isProcessBundleRequest_CacheToken_Type `protobuf_oneof:"type"`
	// The cache token identifier which should be globally unique.
	Token                []byte   `protobuf:"bytes,10,opt,name=token,proto3" json:"token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleRequest_CacheToken) Reset()         { *m = ProcessBundleRequest_CacheToken{} }
func (m *ProcessBundleRequest_CacheToken) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleRequest_CacheToken) ProtoMessage()    {}
func (*ProcessBundleRequest_CacheToken) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{9, 0}
}

func (m *ProcessBundleRequest_CacheToken) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleRequest_CacheToken.Unmarshal(m, b)
}
func (m *ProcessBundleRequest_CacheToken) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleRequest_CacheToken.Marshal(b, m, deterministic)
}
func (m *ProcessBundleRequest_CacheToken) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleRequest_CacheToken.Merge(m, src)
}
func (m *ProcessBundleRequest_CacheToken) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleRequest_CacheToken.Size(m)
}
func (m *ProcessBundleRequest_CacheToken) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleRequest_CacheToken.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleRequest_CacheToken proto.InternalMessageInfo

type isProcessBundleRequest_CacheToken_Type interface {
	isProcessBundleRequest_CacheToken_Type()
}

type ProcessBundleRequest_CacheToken_UserState_ struct {
	UserState *ProcessBundleRequest_CacheToken_UserState `protobuf:"bytes,1,opt,name=user_state,json=userState,proto3,oneof"`
}

type ProcessBundleRequest_CacheToken_SideInput_ struct {
	SideInput *ProcessBundleRequest_CacheToken_SideInput `protobuf:"bytes,2,opt,name=side_input,json=sideInput,proto3,oneof"`
}

func (*ProcessBundleRequest_CacheToken_UserState_) isProcessBundleRequest_CacheToken_Type() {}

func (*ProcessBundleRequest_CacheToken_SideInput_) isProcessBundleRequest_CacheToken_Type() {}

func (m *ProcessBundleRequest_CacheToken) GetType() isProcessBundleRequest_CacheToken_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *ProcessBundleRequest_CacheToken) GetUserState() *ProcessBundleRequest_CacheToken_UserState {
	if x, ok := m.GetType().(*ProcessBundleRequest_CacheToken_UserState_); ok {
		return x.UserState
	}
	return nil
}

func (m *ProcessBundleRequest_CacheToken) GetSideInput() *ProcessBundleRequest_CacheToken_SideInput {
	if x, ok := m.GetType().(*ProcessBundleRequest_CacheToken_SideInput_); ok {
		return x.SideInput
	}
	return nil
}

func (m *ProcessBundleRequest_CacheToken) GetToken() []byte {
	if m != nil {
		return m.Token
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ProcessBundleRequest_CacheToken) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ProcessBundleRequest_CacheToken_UserState_)(nil),
		(*ProcessBundleRequest_CacheToken_SideInput_)(nil),
	}
}

// A flag to indicate a cache token is valid for all user state.
type ProcessBundleRequest_CacheToken_UserState struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleRequest_CacheToken_UserState) Reset() {
	*m = ProcessBundleRequest_CacheToken_UserState{}
}
func (m *ProcessBundleRequest_CacheToken_UserState) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleRequest_CacheToken_UserState) ProtoMessage()    {}
func (*ProcessBundleRequest_CacheToken_UserState) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{9, 0, 0}
}

func (m *ProcessBundleRequest_CacheToken_UserState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleRequest_CacheToken_UserState.Unmarshal(m, b)
}
func (m *ProcessBundleRequest_CacheToken_UserState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleRequest_CacheToken_UserState.Marshal(b, m, deterministic)
}
func (m *ProcessBundleRequest_CacheToken_UserState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleRequest_CacheToken_UserState.Merge(m, src)
}
func (m *ProcessBundleRequest_CacheToken_UserState) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleRequest_CacheToken_UserState.Size(m)
}
func (m *ProcessBundleRequest_CacheToken_UserState) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleRequest_CacheToken_UserState.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleRequest_CacheToken_UserState proto.InternalMessageInfo

// A flag to indicate a cache token is valid for a side input.
type ProcessBundleRequest_CacheToken_SideInput struct {
	// (Required) The id of the PTransform containing a side input.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The id of the side input.
	SideInputId          string   `protobuf:"bytes,2,opt,name=side_input_id,json=sideInputId,proto3" json:"side_input_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleRequest_CacheToken_SideInput) Reset() {
	*m = ProcessBundleRequest_CacheToken_SideInput{}
}
func (m *ProcessBundleRequest_CacheToken_SideInput) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleRequest_CacheToken_SideInput) ProtoMessage()    {}
func (*ProcessBundleRequest_CacheToken_SideInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{9, 0, 1}
}

func (m *ProcessBundleRequest_CacheToken_SideInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleRequest_CacheToken_SideInput.Unmarshal(m, b)
}
func (m *ProcessBundleRequest_CacheToken_SideInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleRequest_CacheToken_SideInput.Marshal(b, m, deterministic)
}
func (m *ProcessBundleRequest_CacheToken_SideInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleRequest_CacheToken_SideInput.Merge(m, src)
}
func (m *ProcessBundleRequest_CacheToken_SideInput) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleRequest_CacheToken_SideInput.Size(m)
}
func (m *ProcessBundleRequest_CacheToken_SideInput) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleRequest_CacheToken_SideInput.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleRequest_CacheToken_SideInput proto.InternalMessageInfo

func (m *ProcessBundleRequest_CacheToken_SideInput) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *ProcessBundleRequest_CacheToken_SideInput) GetSideInputId() string {
	if m != nil {
		return m.SideInputId
	}
	return ""
}

type ProcessBundleResponse struct {
	// (Optional) Specifies that the bundle has not been completed and the
	// following applications need to be scheduled and executed in the future.
	// A runner that does not yet support residual roots MUST still check that
	// this is empty for correctness.
	ResidualRoots []*DelayedBundleApplication `protobuf:"bytes,2,rep,name=residual_roots,json=residualRoots,proto3" json:"residual_roots,omitempty"`
	// DEPRECATED (Required) The list of metrics or other MonitoredState
	// collected while processing this bundle.
	MonitoringInfos []*pipeline_v1.MonitoringInfo `protobuf:"bytes,3,rep,name=monitoring_infos,json=monitoringInfos,proto3" json:"monitoring_infos,omitempty"`
	// (Optional) Specifies that the runner must callback to this worker
	// once the output of the bundle is committed. The Runner must send a
	// FinalizeBundleRequest with the instruction id of the ProcessBundleRequest
	// that is related to this ProcessBundleResponse.
	RequiresFinalization bool `protobuf:"varint,4,opt,name=requires_finalization,json=requiresFinalization,proto3" json:"requires_finalization,omitempty"`
	// An identifier to MonitoringInfo.payload mapping.
	//
	// An SDK can report metrics using an identifier that only contains the
	// associated payload. A runner who wants to receive the full metrics
	// information can request all the monitoring metadata via a
	// ProcessBundleProgressMetadataRequest providing a list of ids as necessary.
	//
	// The SDK is allowed to reuse the identifiers across multiple bundles as long
	// as the MonitoringInfo could be reconstructed fully by overwriting its
	// payload field with the bytes specified here.
	MonitoringData       map[string][]byte `protobuf:"bytes,5,rep,name=monitoring_data,json=monitoringData,proto3" json:"monitoring_data,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ProcessBundleResponse) Reset()         { *m = ProcessBundleResponse{} }
func (m *ProcessBundleResponse) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleResponse) ProtoMessage()    {}
func (*ProcessBundleResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{10}
}

func (m *ProcessBundleResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleResponse.Unmarshal(m, b)
}
func (m *ProcessBundleResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleResponse.Marshal(b, m, deterministic)
}
func (m *ProcessBundleResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleResponse.Merge(m, src)
}
func (m *ProcessBundleResponse) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleResponse.Size(m)
}
func (m *ProcessBundleResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleResponse proto.InternalMessageInfo

func (m *ProcessBundleResponse) GetResidualRoots() []*DelayedBundleApplication {
	if m != nil {
		return m.ResidualRoots
	}
	return nil
}

func (m *ProcessBundleResponse) GetMonitoringInfos() []*pipeline_v1.MonitoringInfo {
	if m != nil {
		return m.MonitoringInfos
	}
	return nil
}

func (m *ProcessBundleResponse) GetRequiresFinalization() bool {
	if m != nil {
		return m.RequiresFinalization
	}
	return false
}

func (m *ProcessBundleResponse) GetMonitoringData() map[string][]byte {
	if m != nil {
		return m.MonitoringData
	}
	return nil
}

// A request to report progress information for a given bundle.
// This is an optional request to be handled and is used to support advanced
// SDK features such as SplittableDoFn, user level metrics etc.
type ProcessBundleProgressRequest struct {
	// (Required) A reference to an active process bundle request with the given
	// instruction id.
	InstructionId        string   `protobuf:"bytes,1,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleProgressRequest) Reset()         { *m = ProcessBundleProgressRequest{} }
func (m *ProcessBundleProgressRequest) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleProgressRequest) ProtoMessage()    {}
func (*ProcessBundleProgressRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{11}
}

func (m *ProcessBundleProgressRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleProgressRequest.Unmarshal(m, b)
}
func (m *ProcessBundleProgressRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleProgressRequest.Marshal(b, m, deterministic)
}
func (m *ProcessBundleProgressRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleProgressRequest.Merge(m, src)
}
func (m *ProcessBundleProgressRequest) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleProgressRequest.Size(m)
}
func (m *ProcessBundleProgressRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleProgressRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleProgressRequest proto.InternalMessageInfo

func (m *ProcessBundleProgressRequest) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

// A request to provide full MonitoringInfo for a given bundle.
//
// An SDK can report metrics using an identifier that only contains the
// associated payload. A runner who wants to receive the full metrics
// information can request all the monitoring metadata via a
// ProcessBundleProgressMetadataRequest providing a list of ids as necessary.
//
// The SDK is allowed to reuse the identifiers across multiple bundles as long
// as the MonitoringInfo could be reconstructed fully by overwriting its
// payload field with the bytes specified here.
type ProcessBundleProgressMetadataRequest struct {
	// A list of ids for which the full MonitoringInfo is requested for.
	MonitoringInfoId     []string `protobuf:"bytes,1,rep,name=monitoring_info_id,json=monitoringInfoId,proto3" json:"monitoring_info_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleProgressMetadataRequest) Reset()         { *m = ProcessBundleProgressMetadataRequest{} }
func (m *ProcessBundleProgressMetadataRequest) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleProgressMetadataRequest) ProtoMessage()    {}
func (*ProcessBundleProgressMetadataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{12}
}

func (m *ProcessBundleProgressMetadataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleProgressMetadataRequest.Unmarshal(m, b)
}
func (m *ProcessBundleProgressMetadataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleProgressMetadataRequest.Marshal(b, m, deterministic)
}
func (m *ProcessBundleProgressMetadataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleProgressMetadataRequest.Merge(m, src)
}
func (m *ProcessBundleProgressMetadataRequest) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleProgressMetadataRequest.Size(m)
}
func (m *ProcessBundleProgressMetadataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleProgressMetadataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleProgressMetadataRequest proto.InternalMessageInfo

func (m *ProcessBundleProgressMetadataRequest) GetMonitoringInfoId() []string {
	if m != nil {
		return m.MonitoringInfoId
	}
	return nil
}

type ProcessBundleProgressResponse struct {
	// DEPRECATED (Required) The list of metrics or other MonitoredState
	// collected while processing this bundle.
	MonitoringInfos []*pipeline_v1.MonitoringInfo `protobuf:"bytes,3,rep,name=monitoring_infos,json=monitoringInfos,proto3" json:"monitoring_infos,omitempty"`
	// An identifier to MonitoringInfo.payload mapping.
	//
	// An SDK can report metrics using an identifier that only contains the
	// associated payload. A runner who wants to receive the full metrics
	// information can request all the monitoring metadata via a
	// ProcessBundleProgressMetadataRequest providing a list of ids as necessary.
	//
	// The SDK is allowed to reuse the identifiers across multiple bundles as long
	// as the MonitoringInfo could be reconstructed fully by overwriting its
	// payload field with the bytes specified here.
	MonitoringData       map[string][]byte `protobuf:"bytes,5,rep,name=monitoring_data,json=monitoringData,proto3" json:"monitoring_data,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ProcessBundleProgressResponse) Reset()         { *m = ProcessBundleProgressResponse{} }
func (m *ProcessBundleProgressResponse) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleProgressResponse) ProtoMessage()    {}
func (*ProcessBundleProgressResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{13}
}

func (m *ProcessBundleProgressResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleProgressResponse.Unmarshal(m, b)
}
func (m *ProcessBundleProgressResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleProgressResponse.Marshal(b, m, deterministic)
}
func (m *ProcessBundleProgressResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleProgressResponse.Merge(m, src)
}
func (m *ProcessBundleProgressResponse) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleProgressResponse.Size(m)
}
func (m *ProcessBundleProgressResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleProgressResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleProgressResponse proto.InternalMessageInfo

func (m *ProcessBundleProgressResponse) GetMonitoringInfos() []*pipeline_v1.MonitoringInfo {
	if m != nil {
		return m.MonitoringInfos
	}
	return nil
}

func (m *ProcessBundleProgressResponse) GetMonitoringData() map[string][]byte {
	if m != nil {
		return m.MonitoringData
	}
	return nil
}

// A response that contains the full mapping information associated with
// a specified set of identifiers.
//
// An SDK can report metrics using an identifier that only contains the
// associated payload. A runner who wants to receive the full metrics
// information can request all the monitoring metadata via a
// ProcessBundleProgressMetadataRequest providing a list of ids as necessary.
//
// The SDK is allowed to reuse the identifiers across multiple bundles as long
// as the MonitoringInfo could be reconstructed fully by overwriting its
// payload field with the bytes specified here.
type ProcessBundleProgressMetadataResponse struct {
	// A mapping from an identifier to the full metrics information.
	MonitoringInfo       map[string]*pipeline_v1.MonitoringInfo `protobuf:"bytes,1,rep,name=monitoring_info,json=monitoringInfo,proto3" json:"monitoring_info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *ProcessBundleProgressMetadataResponse) Reset()         { *m = ProcessBundleProgressMetadataResponse{} }
func (m *ProcessBundleProgressMetadataResponse) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleProgressMetadataResponse) ProtoMessage()    {}
func (*ProcessBundleProgressMetadataResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{14}
}

func (m *ProcessBundleProgressMetadataResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleProgressMetadataResponse.Unmarshal(m, b)
}
func (m *ProcessBundleProgressMetadataResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleProgressMetadataResponse.Marshal(b, m, deterministic)
}
func (m *ProcessBundleProgressMetadataResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleProgressMetadataResponse.Merge(m, src)
}
func (m *ProcessBundleProgressMetadataResponse) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleProgressMetadataResponse.Size(m)
}
func (m *ProcessBundleProgressMetadataResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleProgressMetadataResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleProgressMetadataResponse proto.InternalMessageInfo

func (m *ProcessBundleProgressMetadataResponse) GetMonitoringInfo() map[string]*pipeline_v1.MonitoringInfo {
	if m != nil {
		return m.MonitoringInfo
	}
	return nil
}

// Represents a request to the SDK to split a currently active bundle.
type ProcessBundleSplitRequest struct {
	// (Required) A reference to an active process bundle request with the given
	// instruction id.
	InstructionId string `protobuf:"bytes,1,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	// (Required) Specifies the desired split for each transform.
	//
	// Currently only splits at GRPC read operations are supported.
	// This may, of course, limit the amount of work downstream operations
	// receive.
	DesiredSplits        map[string]*ProcessBundleSplitRequest_DesiredSplit `protobuf:"bytes,3,rep,name=desired_splits,json=desiredSplits,proto3" json:"desired_splits,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                                           `json:"-"`
	XXX_unrecognized     []byte                                             `json:"-"`
	XXX_sizecache        int32                                              `json:"-"`
}

func (m *ProcessBundleSplitRequest) Reset()         { *m = ProcessBundleSplitRequest{} }
func (m *ProcessBundleSplitRequest) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleSplitRequest) ProtoMessage()    {}
func (*ProcessBundleSplitRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{15}
}

func (m *ProcessBundleSplitRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleSplitRequest.Unmarshal(m, b)
}
func (m *ProcessBundleSplitRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleSplitRequest.Marshal(b, m, deterministic)
}
func (m *ProcessBundleSplitRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleSplitRequest.Merge(m, src)
}
func (m *ProcessBundleSplitRequest) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleSplitRequest.Size(m)
}
func (m *ProcessBundleSplitRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleSplitRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleSplitRequest proto.InternalMessageInfo

func (m *ProcessBundleSplitRequest) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

func (m *ProcessBundleSplitRequest) GetDesiredSplits() map[string]*ProcessBundleSplitRequest_DesiredSplit {
	if m != nil {
		return m.DesiredSplits
	}
	return nil
}

// A message specifying the desired split for a single transform.
type ProcessBundleSplitRequest_DesiredSplit struct {
	// (Required) The fraction of known work remaining in this bundle
	// for this transform that should be kept by the SDK after this split.
	//
	// Set to 0 to "checkpoint" as soon as possible (keeping as little work as
	// possible and returning the remainder).
	FractionOfRemainder float64 `protobuf:"fixed64,1,opt,name=fraction_of_remainder,json=fractionOfRemainder,proto3" json:"fraction_of_remainder,omitempty"`
	// A set of allowed element indices where the SDK may split. When this is
	// empty, there are no constraints on where to split.
	AllowedSplitPoints []int64 `protobuf:"varint,3,rep,packed,name=allowed_split_points,json=allowedSplitPoints,proto3" json:"allowed_split_points,omitempty"`
	// (Required for GrpcRead operations) Number of total elements expected
	// to be sent to this GrpcRead operation, required to correctly account
	// for unreceived data when determining where to split.
	EstimatedInputElements int64    `protobuf:"varint,2,opt,name=estimated_input_elements,json=estimatedInputElements,proto3" json:"estimated_input_elements,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *ProcessBundleSplitRequest_DesiredSplit) Reset() {
	*m = ProcessBundleSplitRequest_DesiredSplit{}
}
func (m *ProcessBundleSplitRequest_DesiredSplit) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleSplitRequest_DesiredSplit) ProtoMessage()    {}
func (*ProcessBundleSplitRequest_DesiredSplit) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{15, 0}
}

func (m *ProcessBundleSplitRequest_DesiredSplit) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleSplitRequest_DesiredSplit.Unmarshal(m, b)
}
func (m *ProcessBundleSplitRequest_DesiredSplit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleSplitRequest_DesiredSplit.Marshal(b, m, deterministic)
}
func (m *ProcessBundleSplitRequest_DesiredSplit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleSplitRequest_DesiredSplit.Merge(m, src)
}
func (m *ProcessBundleSplitRequest_DesiredSplit) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleSplitRequest_DesiredSplit.Size(m)
}
func (m *ProcessBundleSplitRequest_DesiredSplit) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleSplitRequest_DesiredSplit.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleSplitRequest_DesiredSplit proto.InternalMessageInfo

func (m *ProcessBundleSplitRequest_DesiredSplit) GetFractionOfRemainder() float64 {
	if m != nil {
		return m.FractionOfRemainder
	}
	return 0
}

func (m *ProcessBundleSplitRequest_DesiredSplit) GetAllowedSplitPoints() []int64 {
	if m != nil {
		return m.AllowedSplitPoints
	}
	return nil
}

func (m *ProcessBundleSplitRequest_DesiredSplit) GetEstimatedInputElements() int64 {
	if m != nil {
		return m.EstimatedInputElements
	}
	return 0
}

// Represents a partition of the bundle: a "primary" and
// a "residual", with the following properties:
// - The work in primary and residual doesn't overlap, and combined, adds up
//   to the work in the current bundle if the split hadn't happened.
// - The current bundle, if it keeps executing, will have done none of the
//   work under residual_roots.
// - The current bundle, if no further splits happen, will have done exactly
//   the work under primary_roots.
// For more rigorous definitions see https://s.apache.org/beam-breaking-fusion
type ProcessBundleSplitResponse struct {
	// Root applications that should replace the current bundle.
	PrimaryRoots []*BundleApplication `protobuf:"bytes,1,rep,name=primary_roots,json=primaryRoots,proto3" json:"primary_roots,omitempty"`
	// Root applications that have been removed from the current bundle and
	// have to be executed in a separate bundle (e.g. in parallel on a different
	// worker, or after the current bundle completes, etc.)
	ResidualRoots []*DelayedBundleApplication `protobuf:"bytes,2,rep,name=residual_roots,json=residualRoots,proto3" json:"residual_roots,omitempty"`
	// Partitions of input data channels into primary and residual elements,
	// if any. Should not include any elements represented in the bundle
	// applications roots above.
	ChannelSplits        []*ProcessBundleSplitResponse_ChannelSplit `protobuf:"bytes,3,rep,name=channel_splits,json=channelSplits,proto3" json:"channel_splits,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *ProcessBundleSplitResponse) Reset()         { *m = ProcessBundleSplitResponse{} }
func (m *ProcessBundleSplitResponse) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleSplitResponse) ProtoMessage()    {}
func (*ProcessBundleSplitResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{16}
}

func (m *ProcessBundleSplitResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleSplitResponse.Unmarshal(m, b)
}
func (m *ProcessBundleSplitResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleSplitResponse.Marshal(b, m, deterministic)
}
func (m *ProcessBundleSplitResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleSplitResponse.Merge(m, src)
}
func (m *ProcessBundleSplitResponse) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleSplitResponse.Size(m)
}
func (m *ProcessBundleSplitResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleSplitResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleSplitResponse proto.InternalMessageInfo

func (m *ProcessBundleSplitResponse) GetPrimaryRoots() []*BundleApplication {
	if m != nil {
		return m.PrimaryRoots
	}
	return nil
}

func (m *ProcessBundleSplitResponse) GetResidualRoots() []*DelayedBundleApplication {
	if m != nil {
		return m.ResidualRoots
	}
	return nil
}

func (m *ProcessBundleSplitResponse) GetChannelSplits() []*ProcessBundleSplitResponse_ChannelSplit {
	if m != nil {
		return m.ChannelSplits
	}
	return nil
}

// Represents contiguous portions of the data channel that are either
// entirely processed or entirely unprocessed and belong to the primary
// or residual respectively.
//
// This affords both a more efficient representation over the FnAPI
// (if the bundle is large) and often a more efficient representation
// on the runner side (e.g. if the set of elements can be represented
// as some range in an underlying dataset).
type ProcessBundleSplitResponse_ChannelSplit struct {
	// (Required) The grpc read transform reading this channel.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// The last element of the input channel that should be entirely considered
	// part of the primary, identified by its absolute index in the (ordered)
	// channel.
	LastPrimaryElement int64 `protobuf:"varint,2,opt,name=last_primary_element,json=lastPrimaryElement,proto3" json:"last_primary_element,omitempty"`
	// The first element of the input channel that should be entirely considered
	// part of the residual, identified by its absolute index in the (ordered)
	// channel.
	FirstResidualElement int64    `protobuf:"varint,3,opt,name=first_residual_element,json=firstResidualElement,proto3" json:"first_residual_element,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleSplitResponse_ChannelSplit) Reset() {
	*m = ProcessBundleSplitResponse_ChannelSplit{}
}
func (m *ProcessBundleSplitResponse_ChannelSplit) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleSplitResponse_ChannelSplit) ProtoMessage()    {}
func (*ProcessBundleSplitResponse_ChannelSplit) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{16, 0}
}

func (m *ProcessBundleSplitResponse_ChannelSplit) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleSplitResponse_ChannelSplit.Unmarshal(m, b)
}
func (m *ProcessBundleSplitResponse_ChannelSplit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleSplitResponse_ChannelSplit.Marshal(b, m, deterministic)
}
func (m *ProcessBundleSplitResponse_ChannelSplit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleSplitResponse_ChannelSplit.Merge(m, src)
}
func (m *ProcessBundleSplitResponse_ChannelSplit) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleSplitResponse_ChannelSplit.Size(m)
}
func (m *ProcessBundleSplitResponse_ChannelSplit) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleSplitResponse_ChannelSplit.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleSplitResponse_ChannelSplit proto.InternalMessageInfo

func (m *ProcessBundleSplitResponse_ChannelSplit) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *ProcessBundleSplitResponse_ChannelSplit) GetLastPrimaryElement() int64 {
	if m != nil {
		return m.LastPrimaryElement
	}
	return 0
}

func (m *ProcessBundleSplitResponse_ChannelSplit) GetFirstResidualElement() int64 {
	if m != nil {
		return m.FirstResidualElement
	}
	return 0
}

type FinalizeBundleRequest struct {
	// (Required) A reference to a completed process bundle request with the given
	// instruction id.
	InstructionId        string   `protobuf:"bytes,1,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FinalizeBundleRequest) Reset()         { *m = FinalizeBundleRequest{} }
func (m *FinalizeBundleRequest) String() string { return proto.CompactTextString(m) }
func (*FinalizeBundleRequest) ProtoMessage()    {}
func (*FinalizeBundleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{17}
}

func (m *FinalizeBundleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinalizeBundleRequest.Unmarshal(m, b)
}
func (m *FinalizeBundleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinalizeBundleRequest.Marshal(b, m, deterministic)
}
func (m *FinalizeBundleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinalizeBundleRequest.Merge(m, src)
}
func (m *FinalizeBundleRequest) XXX_Size() int {
	return xxx_messageInfo_FinalizeBundleRequest.Size(m)
}
func (m *FinalizeBundleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FinalizeBundleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FinalizeBundleRequest proto.InternalMessageInfo

func (m *FinalizeBundleRequest) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

type FinalizeBundleResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FinalizeBundleResponse) Reset()         { *m = FinalizeBundleResponse{} }
func (m *FinalizeBundleResponse) String() string { return proto.CompactTextString(m) }
func (*FinalizeBundleResponse) ProtoMessage()    {}
func (*FinalizeBundleResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{18}
}

func (m *FinalizeBundleResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinalizeBundleResponse.Unmarshal(m, b)
}
func (m *FinalizeBundleResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinalizeBundleResponse.Marshal(b, m, deterministic)
}
func (m *FinalizeBundleResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinalizeBundleResponse.Merge(m, src)
}
func (m *FinalizeBundleResponse) XXX_Size() int {
	return xxx_messageInfo_FinalizeBundleResponse.Size(m)
}
func (m *FinalizeBundleResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FinalizeBundleResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FinalizeBundleResponse proto.InternalMessageInfo

// Messages used to represent logical byte streams.
// Stable
type Elements struct {
	// (Optional) A list containing parts of logical byte streams.
	Data []*Elements_Data `protobuf:"bytes,1,rep,name=data,proto3" json:"data,omitempty"`
	// (Optional)  A list of timer byte streams.
	Timer                []*Elements_Timer `protobuf:"bytes,2,rep,name=timer,proto3" json:"timer,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Elements) Reset()         { *m = Elements{} }
func (m *Elements) String() string { return proto.CompactTextString(m) }
func (*Elements) ProtoMessage()    {}
func (*Elements) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{19}
}

func (m *Elements) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Elements.Unmarshal(m, b)
}
func (m *Elements) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Elements.Marshal(b, m, deterministic)
}
func (m *Elements) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Elements.Merge(m, src)
}
func (m *Elements) XXX_Size() int {
	return xxx_messageInfo_Elements.Size(m)
}
func (m *Elements) XXX_DiscardUnknown() {
	xxx_messageInfo_Elements.DiscardUnknown(m)
}

var xxx_messageInfo_Elements proto.InternalMessageInfo

func (m *Elements) GetData() []*Elements_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Elements) GetTimer() []*Elements_Timer {
	if m != nil {
		return m.Timer
	}
	return nil
}

// Represents multiple encoded elements in nested context for a given named
// instruction and transform.
type Elements_Data struct {
	// (Required) A reference to an active instruction request with the given
	// instruction id.
	InstructionId string `protobuf:"bytes,1,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	// (Required) A definition representing a consumer or producer of this data.
	// If received by a harness, this represents the consumer within that
	// harness that should consume these bytes. If sent by a harness, this
	// represents the producer of these bytes.
	//
	// Note that a single element may span multiple Data messages.
	//
	// Note that a sending/receiving pair should share the same identifier.
	TransformId string `protobuf:"bytes,2,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Optional) Represents a part of a logical byte stream. Elements within
	// the logical byte stream are encoded in the nested context and
	// concatenated together.
	Data []byte `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	// (Optional) Set this bit to indicate the this is the last data block
	// for the given instruction and transform, ending the stream.
	IsLast               bool     `protobuf:"varint,4,opt,name=is_last,json=isLast,proto3" json:"is_last,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Elements_Data) Reset()         { *m = Elements_Data{} }
func (m *Elements_Data) String() string { return proto.CompactTextString(m) }
func (*Elements_Data) ProtoMessage()    {}
func (*Elements_Data) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{19, 0}
}

func (m *Elements_Data) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Elements_Data.Unmarshal(m, b)
}
func (m *Elements_Data) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Elements_Data.Marshal(b, m, deterministic)
}
func (m *Elements_Data) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Elements_Data.Merge(m, src)
}
func (m *Elements_Data) XXX_Size() int {
	return xxx_messageInfo_Elements_Data.Size(m)
}
func (m *Elements_Data) XXX_DiscardUnknown() {
	xxx_messageInfo_Elements_Data.DiscardUnknown(m)
}

var xxx_messageInfo_Elements_Data proto.InternalMessageInfo

func (m *Elements_Data) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

func (m *Elements_Data) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *Elements_Data) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Elements_Data) GetIsLast() bool {
	if m != nil {
		return m.IsLast
	}
	return false
}

// Represent the encoded user timer for a given instruction, transform and
// timer id.
type Elements_Timer struct {
	// (Required) A reference to an active instruction request with the given
	// instruction id.
	InstructionId string `protobuf:"bytes,1,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	// (Required) A definition representing a consumer or producer of this data.
	// If received by a harness, this represents the consumer within that
	// harness that should consume these timers. If sent by a harness, this
	// represents the producer of these timers.
	TransformId string `protobuf:"bytes,2,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Optional) The local timer family name used to identify the associated
	// timer family specification
	TimerFamilyId string `protobuf:"bytes,3,opt,name=timer_family_id,json=timerFamilyId,proto3" json:"timer_family_id,omitempty"`
	// (Optional) Represents a logical byte stream of timers. Encoded according
	// to the coder in the timer spec.
	Timers []byte `protobuf:"bytes,4,opt,name=timers,proto3" json:"timers,omitempty"`
	// (Optional) Set this bit to indicate the this is the last data block
	// for the given instruction and transform, ending the stream.
	IsLast               bool     `protobuf:"varint,5,opt,name=is_last,json=isLast,proto3" json:"is_last,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Elements_Timer) Reset()         { *m = Elements_Timer{} }
func (m *Elements_Timer) String() string { return proto.CompactTextString(m) }
func (*Elements_Timer) ProtoMessage()    {}
func (*Elements_Timer) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{19, 1}
}

func (m *Elements_Timer) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Elements_Timer.Unmarshal(m, b)
}
func (m *Elements_Timer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Elements_Timer.Marshal(b, m, deterministic)
}
func (m *Elements_Timer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Elements_Timer.Merge(m, src)
}
func (m *Elements_Timer) XXX_Size() int {
	return xxx_messageInfo_Elements_Timer.Size(m)
}
func (m *Elements_Timer) XXX_DiscardUnknown() {
	xxx_messageInfo_Elements_Timer.DiscardUnknown(m)
}

var xxx_messageInfo_Elements_Timer proto.InternalMessageInfo

func (m *Elements_Timer) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

func (m *Elements_Timer) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *Elements_Timer) GetTimerFamilyId() string {
	if m != nil {
		return m.TimerFamilyId
	}
	return ""
}

func (m *Elements_Timer) GetTimers() []byte {
	if m != nil {
		return m.Timers
	}
	return nil
}

func (m *Elements_Timer) GetIsLast() bool {
	if m != nil {
		return m.IsLast
	}
	return false
}

type StateRequest struct {
	// (Required) A unique identifier provided by the SDK which represents this
	// requests execution. The StateResponse corresponding with this request
	// will have the matching id.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// (Required) The associated instruction id of the work that is currently
	// being processed. This allows for the runner to associate any modifications
	// to state to be committed with the appropriate work execution.
	InstructionId string `protobuf:"bytes,2,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	// (Required) The state key this request is for.
	StateKey *StateKey `protobuf:"bytes,3,opt,name=state_key,json=stateKey,proto3" json:"state_key,omitempty"`
	// (Required) The action to take on this request.
	//
	// Types that are valid to be assigned to Request:
	//	*StateRequest_Get
	//	*StateRequest_Append
	//	*StateRequest_Clear
	Request              isStateRequest_Request `protobuf_oneof:"request"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *StateRequest) Reset()         { *m = StateRequest{} }
func (m *StateRequest) String() string { return proto.CompactTextString(m) }
func (*StateRequest) ProtoMessage()    {}
func (*StateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{20}
}

func (m *StateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateRequest.Unmarshal(m, b)
}
func (m *StateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateRequest.Marshal(b, m, deterministic)
}
func (m *StateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateRequest.Merge(m, src)
}
func (m *StateRequest) XXX_Size() int {
	return xxx_messageInfo_StateRequest.Size(m)
}
func (m *StateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateRequest proto.InternalMessageInfo

func (m *StateRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *StateRequest) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

func (m *StateRequest) GetStateKey() *StateKey {
	if m != nil {
		return m.StateKey
	}
	return nil
}

type isStateRequest_Request interface {
	isStateRequest_Request()
}

type StateRequest_Get struct {
	Get *StateGetRequest `protobuf:"bytes,1000,opt,name=get,proto3,oneof"`
}

type StateRequest_Append struct {
	Append *StateAppendRequest `protobuf:"bytes,1001,opt,name=append,proto3,oneof"`
}

type StateRequest_Clear struct {
	Clear *StateClearRequest `protobuf:"bytes,1002,opt,name=clear,proto3,oneof"`
}

func (*StateRequest_Get) isStateRequest_Request() {}

func (*StateRequest_Append) isStateRequest_Request() {}

func (*StateRequest_Clear) isStateRequest_Request() {}

func (m *StateRequest) GetRequest() isStateRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *StateRequest) GetGet() *StateGetRequest {
	if x, ok := m.GetRequest().(*StateRequest_Get); ok {
		return x.Get
	}
	return nil
}

func (m *StateRequest) GetAppend() *StateAppendRequest {
	if x, ok := m.GetRequest().(*StateRequest_Append); ok {
		return x.Append
	}
	return nil
}

func (m *StateRequest) GetClear() *StateClearRequest {
	if x, ok := m.GetRequest().(*StateRequest_Clear); ok {
		return x.Clear
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StateRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StateRequest_Get)(nil),
		(*StateRequest_Append)(nil),
		(*StateRequest_Clear)(nil),
	}
}

type StateResponse struct {
	// (Required) A reference provided by the SDK which represents a requests
	// execution. The StateResponse must have the matching id when responding
	// to the SDK.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// (Optional) If this is specified, then the state request has failed.
	// A human readable string representing the reason as to why the request
	// failed.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// A corresponding response matching the request will be populated.
	//
	// Types that are valid to be assigned to Response:
	//	*StateResponse_Get
	//	*StateResponse_Append
	//	*StateResponse_Clear
	Response             isStateResponse_Response `protobuf_oneof:"response"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *StateResponse) Reset()         { *m = StateResponse{} }
func (m *StateResponse) String() string { return proto.CompactTextString(m) }
func (*StateResponse) ProtoMessage()    {}
func (*StateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{21}
}

func (m *StateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateResponse.Unmarshal(m, b)
}
func (m *StateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateResponse.Marshal(b, m, deterministic)
}
func (m *StateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateResponse.Merge(m, src)
}
func (m *StateResponse) XXX_Size() int {
	return xxx_messageInfo_StateResponse.Size(m)
}
func (m *StateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateResponse proto.InternalMessageInfo

func (m *StateResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *StateResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type isStateResponse_Response interface {
	isStateResponse_Response()
}

type StateResponse_Get struct {
	Get *StateGetResponse `protobuf:"bytes,1000,opt,name=get,proto3,oneof"`
}

type StateResponse_Append struct {
	Append *StateAppendResponse `protobuf:"bytes,1001,opt,name=append,proto3,oneof"`
}

type StateResponse_Clear struct {
	Clear *StateClearResponse `protobuf:"bytes,1002,opt,name=clear,proto3,oneof"`
}

func (*StateResponse_Get) isStateResponse_Response() {}

func (*StateResponse_Append) isStateResponse_Response() {}

func (*StateResponse_Clear) isStateResponse_Response() {}

func (m *StateResponse) GetResponse() isStateResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *StateResponse) GetGet() *StateGetResponse {
	if x, ok := m.GetResponse().(*StateResponse_Get); ok {
		return x.Get
	}
	return nil
}

func (m *StateResponse) GetAppend() *StateAppendResponse {
	if x, ok := m.GetResponse().(*StateResponse_Append); ok {
		return x.Append
	}
	return nil
}

func (m *StateResponse) GetClear() *StateClearResponse {
	if x, ok := m.GetResponse().(*StateResponse_Clear); ok {
		return x.Clear
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StateResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StateResponse_Get)(nil),
		(*StateResponse_Append)(nil),
		(*StateResponse_Clear)(nil),
	}
}

type StateKey struct {
	// (Required) One of the following state keys must be set.
	//
	// Types that are valid to be assigned to Type:
	//	*StateKey_Runner_
	//	*StateKey_MultimapSideInput_
	//	*StateKey_BagUserState_
	//	*StateKey_IterableSideInput_
	//	*StateKey_MultimapKeysSideInput_
	Type                 isStateKey_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *StateKey) Reset()         { *m = StateKey{} }
func (m *StateKey) String() string { return proto.CompactTextString(m) }
func (*StateKey) ProtoMessage()    {}
func (*StateKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{22}
}

func (m *StateKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey.Unmarshal(m, b)
}
func (m *StateKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey.Marshal(b, m, deterministic)
}
func (m *StateKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey.Merge(m, src)
}
func (m *StateKey) XXX_Size() int {
	return xxx_messageInfo_StateKey.Size(m)
}
func (m *StateKey) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey proto.InternalMessageInfo

type isStateKey_Type interface {
	isStateKey_Type()
}

type StateKey_Runner_ struct {
	Runner *StateKey_Runner `protobuf:"bytes,1,opt,name=runner,proto3,oneof"`
}

type StateKey_MultimapSideInput_ struct {
	MultimapSideInput *StateKey_MultimapSideInput `protobuf:"bytes,2,opt,name=multimap_side_input,json=multimapSideInput,proto3,oneof"`
}

type StateKey_BagUserState_ struct {
	BagUserState *StateKey_BagUserState `protobuf:"bytes,3,opt,name=bag_user_state,json=bagUserState,proto3,oneof"`
}

type StateKey_IterableSideInput_ struct {
	IterableSideInput *StateKey_IterableSideInput `protobuf:"bytes,4,opt,name=iterable_side_input,json=iterableSideInput,proto3,oneof"`
}

type StateKey_MultimapKeysSideInput_ struct {
	MultimapKeysSideInput *StateKey_MultimapKeysSideInput `protobuf:"bytes,5,opt,name=multimap_keys_side_input,json=multimapKeysSideInput,proto3,oneof"`
}

func (*StateKey_Runner_) isStateKey_Type() {}

func (*StateKey_MultimapSideInput_) isStateKey_Type() {}

func (*StateKey_BagUserState_) isStateKey_Type() {}

func (*StateKey_IterableSideInput_) isStateKey_Type() {}

func (*StateKey_MultimapKeysSideInput_) isStateKey_Type() {}

func (m *StateKey) GetType() isStateKey_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *StateKey) GetRunner() *StateKey_Runner {
	if x, ok := m.GetType().(*StateKey_Runner_); ok {
		return x.Runner
	}
	return nil
}

func (m *StateKey) GetMultimapSideInput() *StateKey_MultimapSideInput {
	if x, ok := m.GetType().(*StateKey_MultimapSideInput_); ok {
		return x.MultimapSideInput
	}
	return nil
}

func (m *StateKey) GetBagUserState() *StateKey_BagUserState {
	if x, ok := m.GetType().(*StateKey_BagUserState_); ok {
		return x.BagUserState
	}
	return nil
}

func (m *StateKey) GetIterableSideInput() *StateKey_IterableSideInput {
	if x, ok := m.GetType().(*StateKey_IterableSideInput_); ok {
		return x.IterableSideInput
	}
	return nil
}

func (m *StateKey) GetMultimapKeysSideInput() *StateKey_MultimapKeysSideInput {
	if x, ok := m.GetType().(*StateKey_MultimapKeysSideInput_); ok {
		return x.MultimapKeysSideInput
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StateKey) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StateKey_Runner_)(nil),
		(*StateKey_MultimapSideInput_)(nil),
		(*StateKey_BagUserState_)(nil),
		(*StateKey_IterableSideInput_)(nil),
		(*StateKey_MultimapKeysSideInput_)(nil),
	}
}

type StateKey_Runner struct {
	// (Required) Opaque information supplied by the runner. Used to support
	// remote references.
	// https://s.apache.org/beam-fn-api-send-and-receive-data
	//
	// Used by state backed iterable. And in this use case, request type can
	// only be of type get. Details see:
	// https://s.apache.org/beam-fn-api-state-backed-iterables
	Key                  []byte   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateKey_Runner) Reset()         { *m = StateKey_Runner{} }
func (m *StateKey_Runner) String() string { return proto.CompactTextString(m) }
func (*StateKey_Runner) ProtoMessage()    {}
func (*StateKey_Runner) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{22, 0}
}

func (m *StateKey_Runner) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey_Runner.Unmarshal(m, b)
}
func (m *StateKey_Runner) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey_Runner.Marshal(b, m, deterministic)
}
func (m *StateKey_Runner) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey_Runner.Merge(m, src)
}
func (m *StateKey_Runner) XXX_Size() int {
	return xxx_messageInfo_StateKey_Runner.Size(m)
}
func (m *StateKey_Runner) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey_Runner.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey_Runner proto.InternalMessageInfo

func (m *StateKey_Runner) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

// Represents a request for the values associated with a specified window
// in a PCollection. See
// https://s.apache.org/beam-fn-state-api-and-bundle-processing for further
// details.
//
// Can only be used to perform StateGetRequests on side inputs of the URN
// beam:side_input:iterable:v1.
//
// For a PCollection<V>, the response data stream will be a concatenation
// of all V's. See https://s.apache.org/beam-fn-api-send-and-receive-data
// for further details.
type StateKey_IterableSideInput struct {
	// (Required) The id of the PTransform containing a side input.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The id of the side input.
	SideInputId string `protobuf:"bytes,2,opt,name=side_input_id,json=sideInputId,proto3" json:"side_input_id,omitempty"`
	// (Required) The window (after mapping the currently executing elements
	// window into the side input windows domain) encoded in a nested context.
	Window               []byte   `protobuf:"bytes,3,opt,name=window,proto3" json:"window,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateKey_IterableSideInput) Reset()         { *m = StateKey_IterableSideInput{} }
func (m *StateKey_IterableSideInput) String() string { return proto.CompactTextString(m) }
func (*StateKey_IterableSideInput) ProtoMessage()    {}
func (*StateKey_IterableSideInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{22, 1}
}

func (m *StateKey_IterableSideInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey_IterableSideInput.Unmarshal(m, b)
}
func (m *StateKey_IterableSideInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey_IterableSideInput.Marshal(b, m, deterministic)
}
func (m *StateKey_IterableSideInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey_IterableSideInput.Merge(m, src)
}
func (m *StateKey_IterableSideInput) XXX_Size() int {
	return xxx_messageInfo_StateKey_IterableSideInput.Size(m)
}
func (m *StateKey_IterableSideInput) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey_IterableSideInput.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey_IterableSideInput proto.InternalMessageInfo

func (m *StateKey_IterableSideInput) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *StateKey_IterableSideInput) GetSideInputId() string {
	if m != nil {
		return m.SideInputId
	}
	return ""
}

func (m *StateKey_IterableSideInput) GetWindow() []byte {
	if m != nil {
		return m.Window
	}
	return nil
}

// Represents a request for the values associated with a specified user key
// and window in a PCollection. See
// https://s.apache.org/beam-fn-state-api-and-bundle-processing for further
// details.
//
// Can only be used to perform StateGetRequests on side inputs of the URN
// beam:side_input:multimap:v1.
//
// For a PCollection<KV<K, V>>, the response data stream will be a
// concatenation of all V's associated with the specified key K. See
// https://s.apache.org/beam-fn-api-send-and-receive-data for further
// details.
type StateKey_MultimapSideInput struct {
	// (Required) The id of the PTransform containing a side input.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The id of the side input.
	SideInputId string `protobuf:"bytes,2,opt,name=side_input_id,json=sideInputId,proto3" json:"side_input_id,omitempty"`
	// (Required) The window (after mapping the currently executing elements
	// window into the side input windows domain) encoded in a nested context.
	Window []byte `protobuf:"bytes,3,opt,name=window,proto3" json:"window,omitempty"`
	// (Required) The key encoded in a nested context.
	Key                  []byte   `protobuf:"bytes,4,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateKey_MultimapSideInput) Reset()         { *m = StateKey_MultimapSideInput{} }
func (m *StateKey_MultimapSideInput) String() string { return proto.CompactTextString(m) }
func (*StateKey_MultimapSideInput) ProtoMessage()    {}
func (*StateKey_MultimapSideInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{22, 2}
}

func (m *StateKey_MultimapSideInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey_MultimapSideInput.Unmarshal(m, b)
}
func (m *StateKey_MultimapSideInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey_MultimapSideInput.Marshal(b, m, deterministic)
}
func (m *StateKey_MultimapSideInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey_MultimapSideInput.Merge(m, src)
}
func (m *StateKey_MultimapSideInput) XXX_Size() int {
	return xxx_messageInfo_StateKey_MultimapSideInput.Size(m)
}
func (m *StateKey_MultimapSideInput) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey_MultimapSideInput.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey_MultimapSideInput proto.InternalMessageInfo

func (m *StateKey_MultimapSideInput) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *StateKey_MultimapSideInput) GetSideInputId() string {
	if m != nil {
		return m.SideInputId
	}
	return ""
}

func (m *StateKey_MultimapSideInput) GetWindow() []byte {
	if m != nil {
		return m.Window
	}
	return nil
}

func (m *StateKey_MultimapSideInput) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

// Represents a request for the keys associated with a specified window in a PCollection. See
// https://s.apache.org/beam-fn-state-api-and-bundle-processing for further
// details.
//
// Can only be used to perform StateGetRequests on side inputs of the URN
// beam:side_input:multimap:v1.
//
// For a PCollection<KV<K, V>>, the response data stream will be a
// concatenation of all K's associated with the specified window. See
// https://s.apache.org/beam-fn-api-send-and-receive-data for further
// details.
type StateKey_MultimapKeysSideInput struct {
	// (Required) The id of the PTransform containing a side input.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The id of the side input.
	SideInputId string `protobuf:"bytes,2,opt,name=side_input_id,json=sideInputId,proto3" json:"side_input_id,omitempty"`
	// (Required) The window (after mapping the currently executing elements
	// window into the side input windows domain) encoded in a nested context.
	Window               []byte   `protobuf:"bytes,3,opt,name=window,proto3" json:"window,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateKey_MultimapKeysSideInput) Reset()         { *m = StateKey_MultimapKeysSideInput{} }
func (m *StateKey_MultimapKeysSideInput) String() string { return proto.CompactTextString(m) }
func (*StateKey_MultimapKeysSideInput) ProtoMessage()    {}
func (*StateKey_MultimapKeysSideInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{22, 3}
}

func (m *StateKey_MultimapKeysSideInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey_MultimapKeysSideInput.Unmarshal(m, b)
}
func (m *StateKey_MultimapKeysSideInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey_MultimapKeysSideInput.Marshal(b, m, deterministic)
}
func (m *StateKey_MultimapKeysSideInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey_MultimapKeysSideInput.Merge(m, src)
}
func (m *StateKey_MultimapKeysSideInput) XXX_Size() int {
	return xxx_messageInfo_StateKey_MultimapKeysSideInput.Size(m)
}
func (m *StateKey_MultimapKeysSideInput) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey_MultimapKeysSideInput.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey_MultimapKeysSideInput proto.InternalMessageInfo

func (m *StateKey_MultimapKeysSideInput) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *StateKey_MultimapKeysSideInput) GetSideInputId() string {
	if m != nil {
		return m.SideInputId
	}
	return ""
}

func (m *StateKey_MultimapKeysSideInput) GetWindow() []byte {
	if m != nil {
		return m.Window
	}
	return nil
}

type StateKey_BagUserState struct {
	// (Required) The id of the PTransform containing user state.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The id of the user state.
	UserStateId string `protobuf:"bytes,2,opt,name=user_state_id,json=userStateId,proto3" json:"user_state_id,omitempty"`
	// (Required) The window encoded in a nested context.
	Window []byte `protobuf:"bytes,3,opt,name=window,proto3" json:"window,omitempty"`
	// (Required) The key of the currently executing element encoded in a
	// nested context.
	Key                  []byte   `protobuf:"bytes,4,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateKey_BagUserState) Reset()         { *m = StateKey_BagUserState{} }
func (m *StateKey_BagUserState) String() string { return proto.CompactTextString(m) }
func (*StateKey_BagUserState) ProtoMessage()    {}
func (*StateKey_BagUserState) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{22, 4}
}

func (m *StateKey_BagUserState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey_BagUserState.Unmarshal(m, b)
}
func (m *StateKey_BagUserState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey_BagUserState.Marshal(b, m, deterministic)
}
func (m *StateKey_BagUserState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey_BagUserState.Merge(m, src)
}
func (m *StateKey_BagUserState) XXX_Size() int {
	return xxx_messageInfo_StateKey_BagUserState.Size(m)
}
func (m *StateKey_BagUserState) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey_BagUserState.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey_BagUserState proto.InternalMessageInfo

func (m *StateKey_BagUserState) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *StateKey_BagUserState) GetUserStateId() string {
	if m != nil {
		return m.UserStateId
	}
	return ""
}

func (m *StateKey_BagUserState) GetWindow() []byte {
	if m != nil {
		return m.Window
	}
	return nil
}

func (m *StateKey_BagUserState) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

// A request to get state.
type StateGetRequest struct {
	// (Optional) If specified, signals to the runner that the response
	// should resume from the following continuation token.
	//
	// If unspecified, signals to the runner that the response should start
	// from the beginning of the logical continuable stream.
	ContinuationToken    []byte   `protobuf:"bytes,1,opt,name=continuation_token,json=continuationToken,proto3" json:"continuation_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateGetRequest) Reset()         { *m = StateGetRequest{} }
func (m *StateGetRequest) String() string { return proto.CompactTextString(m) }
func (*StateGetRequest) ProtoMessage()    {}
func (*StateGetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{23}
}

func (m *StateGetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateGetRequest.Unmarshal(m, b)
}
func (m *StateGetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateGetRequest.Marshal(b, m, deterministic)
}
func (m *StateGetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateGetRequest.Merge(m, src)
}
func (m *StateGetRequest) XXX_Size() int {
	return xxx_messageInfo_StateGetRequest.Size(m)
}
func (m *StateGetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateGetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateGetRequest proto.InternalMessageInfo

func (m *StateGetRequest) GetContinuationToken() []byte {
	if m != nil {
		return m.ContinuationToken
	}
	return nil
}

// A response to get state representing a logical byte stream which can be
// continued using the state API.
type StateGetResponse struct {
	// (Optional) If specified, represents a token which can be used with the
	// state API to get the next chunk of this logical byte stream. The end of
	// the logical byte stream is signalled by this field being unset.
	ContinuationToken []byte `protobuf:"bytes,1,opt,name=continuation_token,json=continuationToken,proto3" json:"continuation_token,omitempty"`
	// Represents a part of a logical byte stream. Elements within
	// the logical byte stream are encoded in the nested context and
	// concatenated together.
	Data                 []byte   `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateGetResponse) Reset()         { *m = StateGetResponse{} }
func (m *StateGetResponse) String() string { return proto.CompactTextString(m) }
func (*StateGetResponse) ProtoMessage()    {}
func (*StateGetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{24}
}

func (m *StateGetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateGetResponse.Unmarshal(m, b)
}
func (m *StateGetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateGetResponse.Marshal(b, m, deterministic)
}
func (m *StateGetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateGetResponse.Merge(m, src)
}
func (m *StateGetResponse) XXX_Size() int {
	return xxx_messageInfo_StateGetResponse.Size(m)
}
func (m *StateGetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateGetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateGetResponse proto.InternalMessageInfo

func (m *StateGetResponse) GetContinuationToken() []byte {
	if m != nil {
		return m.ContinuationToken
	}
	return nil
}

func (m *StateGetResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// A request to append state.
type StateAppendRequest struct {
	// Represents a part of a logical byte stream. Elements within
	// the logical byte stream are encoded in the nested context and
	// multiple append requests are concatenated together.
	Data                 []byte   `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateAppendRequest) Reset()         { *m = StateAppendRequest{} }
func (m *StateAppendRequest) String() string { return proto.CompactTextString(m) }
func (*StateAppendRequest) ProtoMessage()    {}
func (*StateAppendRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{25}
}

func (m *StateAppendRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateAppendRequest.Unmarshal(m, b)
}
func (m *StateAppendRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateAppendRequest.Marshal(b, m, deterministic)
}
func (m *StateAppendRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateAppendRequest.Merge(m, src)
}
func (m *StateAppendRequest) XXX_Size() int {
	return xxx_messageInfo_StateAppendRequest.Size(m)
}
func (m *StateAppendRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateAppendRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateAppendRequest proto.InternalMessageInfo

func (m *StateAppendRequest) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// A response to append state.
type StateAppendResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateAppendResponse) Reset()         { *m = StateAppendResponse{} }
func (m *StateAppendResponse) String() string { return proto.CompactTextString(m) }
func (*StateAppendResponse) ProtoMessage()    {}
func (*StateAppendResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{26}
}

func (m *StateAppendResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateAppendResponse.Unmarshal(m, b)
}
func (m *StateAppendResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateAppendResponse.Marshal(b, m, deterministic)
}
func (m *StateAppendResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateAppendResponse.Merge(m, src)
}
func (m *StateAppendResponse) XXX_Size() int {
	return xxx_messageInfo_StateAppendResponse.Size(m)
}
func (m *StateAppendResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateAppendResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateAppendResponse proto.InternalMessageInfo

// A request to clear state.
type StateClearRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateClearRequest) Reset()         { *m = StateClearRequest{} }
func (m *StateClearRequest) String() string { return proto.CompactTextString(m) }
func (*StateClearRequest) ProtoMessage()    {}
func (*StateClearRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{27}
}

func (m *StateClearRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateClearRequest.Unmarshal(m, b)
}
func (m *StateClearRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateClearRequest.Marshal(b, m, deterministic)
}
func (m *StateClearRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateClearRequest.Merge(m, src)
}
func (m *StateClearRequest) XXX_Size() int {
	return xxx_messageInfo_StateClearRequest.Size(m)
}
func (m *StateClearRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateClearRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateClearRequest proto.InternalMessageInfo

// A response to clear state.
type StateClearResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateClearResponse) Reset()         { *m = StateClearResponse{} }
func (m *StateClearResponse) String() string { return proto.CompactTextString(m) }
func (*StateClearResponse) ProtoMessage()    {}
func (*StateClearResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{28}
}

func (m *StateClearResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateClearResponse.Unmarshal(m, b)
}
func (m *StateClearResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateClearResponse.Marshal(b, m, deterministic)
}
func (m *StateClearResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateClearResponse.Merge(m, src)
}
func (m *StateClearResponse) XXX_Size() int {
	return xxx_messageInfo_StateClearResponse.Size(m)
}
func (m *StateClearResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateClearResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateClearResponse proto.InternalMessageInfo

// A log entry
type LogEntry struct {
	// (Required) The severity of the log statement.
	Severity LogEntry_Severity_Enum `protobuf:"varint,1,opt,name=severity,proto3,enum=org.apache.beam.model.fn_execution.v1.LogEntry_Severity_Enum" json:"severity,omitempty"`
	// (Required) The time at which this log statement occurred.
	Timestamp *timestamp.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// (Required) A human readable message.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	// (Optional) An optional trace of the functions involved. For example, in
	// Java this can include multiple causes and multiple suppressed exceptions.
	Trace string `protobuf:"bytes,4,opt,name=trace,proto3" json:"trace,omitempty"`
	// (Optional) A reference to the instruction this log statement is associated
	// with.
	InstructionId string `protobuf:"bytes,5,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	// (Optional) A reference to the transform this log statement is
	// associated with.
	TransformId string `protobuf:"bytes,6,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Optional) Human-readable name of the function or method being invoked,
	// with optional context such as the class or package name. The format can
	// vary by language. For example:
	//   qual.if.ied.Class.method (Java)
	//   dir/package.func (Go)
	//   module.function (Python)
	//   file.cc:382 (C++)
	LogLocation string `protobuf:"bytes,7,opt,name=log_location,json=logLocation,proto3" json:"log_location,omitempty"`
	// (Optional) The name of the thread this log statement is associated with.
	Thread               string   `protobuf:"bytes,8,opt,name=thread,proto3" json:"thread,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogEntry) Reset()         { *m = LogEntry{} }
func (m *LogEntry) String() string { return proto.CompactTextString(m) }
func (*LogEntry) ProtoMessage()    {}
func (*LogEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{29}
}

func (m *LogEntry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogEntry.Unmarshal(m, b)
}
func (m *LogEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogEntry.Marshal(b, m, deterministic)
}
func (m *LogEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry.Merge(m, src)
}
func (m *LogEntry) XXX_Size() int {
	return xxx_messageInfo_LogEntry.Size(m)
}
func (m *LogEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry proto.InternalMessageInfo

func (m *LogEntry) GetSeverity() LogEntry_Severity_Enum {
	if m != nil {
		return m.Severity
	}
	return LogEntry_Severity_UNSPECIFIED
}

func (m *LogEntry) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *LogEntry) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *LogEntry) GetTrace() string {
	if m != nil {
		return m.Trace
	}
	return ""
}

func (m *LogEntry) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

func (m *LogEntry) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *LogEntry) GetLogLocation() string {
	if m != nil {
		return m.LogLocation
	}
	return ""
}

func (m *LogEntry) GetThread() string {
	if m != nil {
		return m.Thread
	}
	return ""
}

// A list of log entries, enables buffering and batching of multiple
// log messages using the logging API.
type LogEntry_List struct {
	// (Required) One or or more log messages.
	LogEntries           []*LogEntry `protobuf:"bytes,1,rep,name=log_entries,json=logEntries,proto3" json:"log_entries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *LogEntry_List) Reset()         { *m = LogEntry_List{} }
func (m *LogEntry_List) String() string { return proto.CompactTextString(m) }
func (*LogEntry_List) ProtoMessage()    {}
func (*LogEntry_List) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{29, 0}
}

func (m *LogEntry_List) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogEntry_List.Unmarshal(m, b)
}
func (m *LogEntry_List) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogEntry_List.Marshal(b, m, deterministic)
}
func (m *LogEntry_List) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry_List.Merge(m, src)
}
func (m *LogEntry_List) XXX_Size() int {
	return xxx_messageInfo_LogEntry_List.Size(m)
}
func (m *LogEntry_List) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry_List.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry_List proto.InternalMessageInfo

func (m *LogEntry_List) GetLogEntries() []*LogEntry {
	if m != nil {
		return m.LogEntries
	}
	return nil
}

// The severity of the event described in a log entry, expressed as one of the
// severity levels listed below. For your reference, the levels are
// assigned the listed numeric values. The effect of using numeric values
// other than those listed is undefined.
//
// If you are writing log entries, you should map other severity encodings to
// one of these standard levels. For example, you might map all of
// Java's FINE, FINER, and FINEST levels to `Severity.DEBUG`.
//
// This list is intentionally not comprehensive; the intent is to provide a
// common set of "good enough" severity levels so that logging front ends
// can provide filtering and searching across log types. Users of the API are
// free not to use all severity levels in their log messages.
type LogEntry_Severity struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogEntry_Severity) Reset()         { *m = LogEntry_Severity{} }
func (m *LogEntry_Severity) String() string { return proto.CompactTextString(m) }
func (*LogEntry_Severity) ProtoMessage()    {}
func (*LogEntry_Severity) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{29, 1}
}

func (m *LogEntry_Severity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogEntry_Severity.Unmarshal(m, b)
}
func (m *LogEntry_Severity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogEntry_Severity.Marshal(b, m, deterministic)
}
func (m *LogEntry_Severity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry_Severity.Merge(m, src)
}
func (m *LogEntry_Severity) XXX_Size() int {
	return xxx_messageInfo_LogEntry_Severity.Size(m)
}
func (m *LogEntry_Severity) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry_Severity.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry_Severity proto.InternalMessageInfo

type LogControl struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogControl) Reset()         { *m = LogControl{} }
func (m *LogControl) String() string { return proto.CompactTextString(m) }
func (*LogControl) ProtoMessage()    {}
func (*LogControl) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{30}
}

func (m *LogControl) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogControl.Unmarshal(m, b)
}
func (m *LogControl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogControl.Marshal(b, m, deterministic)
}
func (m *LogControl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogControl.Merge(m, src)
}
func (m *LogControl) XXX_Size() int {
	return xxx_messageInfo_LogControl.Size(m)
}
func (m *LogControl) XXX_DiscardUnknown() {
	xxx_messageInfo_LogControl.DiscardUnknown(m)
}

var xxx_messageInfo_LogControl proto.InternalMessageInfo

type StartWorkerRequest struct {
	WorkerId             string                            `protobuf:"bytes,1,opt,name=worker_id,json=workerId,proto3" json:"worker_id,omitempty"`
	ControlEndpoint      *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,2,opt,name=control_endpoint,json=controlEndpoint,proto3" json:"control_endpoint,omitempty"`
	LoggingEndpoint      *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,3,opt,name=logging_endpoint,json=loggingEndpoint,proto3" json:"logging_endpoint,omitempty"`
	ArtifactEndpoint     *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,4,opt,name=artifact_endpoint,json=artifactEndpoint,proto3" json:"artifact_endpoint,omitempty"`
	ProvisionEndpoint    *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,5,opt,name=provision_endpoint,json=provisionEndpoint,proto3" json:"provision_endpoint,omitempty"`
	Params               map[string]string                 `protobuf:"bytes,10,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *StartWorkerRequest) Reset()         { *m = StartWorkerRequest{} }
func (m *StartWorkerRequest) String() string { return proto.CompactTextString(m) }
func (*StartWorkerRequest) ProtoMessage()    {}
func (*StartWorkerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{31}
}

func (m *StartWorkerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartWorkerRequest.Unmarshal(m, b)
}
func (m *StartWorkerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartWorkerRequest.Marshal(b, m, deterministic)
}
func (m *StartWorkerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartWorkerRequest.Merge(m, src)
}
func (m *StartWorkerRequest) XXX_Size() int {
	return xxx_messageInfo_StartWorkerRequest.Size(m)
}
func (m *StartWorkerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartWorkerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartWorkerRequest proto.InternalMessageInfo

func (m *StartWorkerRequest) GetWorkerId() string {
	if m != nil {
		return m.WorkerId
	}
	return ""
}

func (m *StartWorkerRequest) GetControlEndpoint() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.ControlEndpoint
	}
	return nil
}

func (m *StartWorkerRequest) GetLoggingEndpoint() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.LoggingEndpoint
	}
	return nil
}

func (m *StartWorkerRequest) GetArtifactEndpoint() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.ArtifactEndpoint
	}
	return nil
}

func (m *StartWorkerRequest) GetProvisionEndpoint() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.ProvisionEndpoint
	}
	return nil
}

func (m *StartWorkerRequest) GetParams() map[string]string {
	if m != nil {
		return m.Params
	}
	return nil
}

type StartWorkerResponse struct {
	Error                string   `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartWorkerResponse) Reset()         { *m = StartWorkerResponse{} }
func (m *StartWorkerResponse) String() string { return proto.CompactTextString(m) }
func (*StartWorkerResponse) ProtoMessage()    {}
func (*StartWorkerResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{32}
}

func (m *StartWorkerResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartWorkerResponse.Unmarshal(m, b)
}
func (m *StartWorkerResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartWorkerResponse.Marshal(b, m, deterministic)
}
func (m *StartWorkerResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartWorkerResponse.Merge(m, src)
}
func (m *StartWorkerResponse) XXX_Size() int {
	return xxx_messageInfo_StartWorkerResponse.Size(m)
}
func (m *StartWorkerResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StartWorkerResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StartWorkerResponse proto.InternalMessageInfo

func (m *StartWorkerResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type StopWorkerRequest struct {
	WorkerId             string   `protobuf:"bytes,1,opt,name=worker_id,json=workerId,proto3" json:"worker_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopWorkerRequest) Reset()         { *m = StopWorkerRequest{} }
func (m *StopWorkerRequest) String() string { return proto.CompactTextString(m) }
func (*StopWorkerRequest) ProtoMessage()    {}
func (*StopWorkerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{33}
}

func (m *StopWorkerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopWorkerRequest.Unmarshal(m, b)
}
func (m *StopWorkerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopWorkerRequest.Marshal(b, m, deterministic)
}
func (m *StopWorkerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopWorkerRequest.Merge(m, src)
}
func (m *StopWorkerRequest) XXX_Size() int {
	return xxx_messageInfo_StopWorkerRequest.Size(m)
}
func (m *StopWorkerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StopWorkerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StopWorkerRequest proto.InternalMessageInfo

func (m *StopWorkerRequest) GetWorkerId() string {
	if m != nil {
		return m.WorkerId
	}
	return ""
}

type StopWorkerResponse struct {
	Error                string   `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopWorkerResponse) Reset()         { *m = StopWorkerResponse{} }
func (m *StopWorkerResponse) String() string { return proto.CompactTextString(m) }
func (*StopWorkerResponse) ProtoMessage()    {}
func (*StopWorkerResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{34}
}

func (m *StopWorkerResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopWorkerResponse.Unmarshal(m, b)
}
func (m *StopWorkerResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopWorkerResponse.Marshal(b, m, deterministic)
}
func (m *StopWorkerResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopWorkerResponse.Merge(m, src)
}
func (m *StopWorkerResponse) XXX_Size() int {
	return xxx_messageInfo_StopWorkerResponse.Size(m)
}
func (m *StopWorkerResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StopWorkerResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StopWorkerResponse proto.InternalMessageInfo

func (m *StopWorkerResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// Request from runner to SDK Harness asking for its status. For more details see
// https://s.apache.org/beam-fn-api-harness-status
type WorkerStatusRequest struct {
	// (Required) Unique ID identifying this request.
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WorkerStatusRequest) Reset()         { *m = WorkerStatusRequest{} }
func (m *WorkerStatusRequest) String() string { return proto.CompactTextString(m) }
func (*WorkerStatusRequest) ProtoMessage()    {}
func (*WorkerStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{35}
}

func (m *WorkerStatusRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WorkerStatusRequest.Unmarshal(m, b)
}
func (m *WorkerStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WorkerStatusRequest.Marshal(b, m, deterministic)
}
func (m *WorkerStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkerStatusRequest.Merge(m, src)
}
func (m *WorkerStatusRequest) XXX_Size() int {
	return xxx_messageInfo_WorkerStatusRequest.Size(m)
}
func (m *WorkerStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkerStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WorkerStatusRequest proto.InternalMessageInfo

func (m *WorkerStatusRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// Response from SDK Harness to runner containing the debug related status info.
type WorkerStatusResponse struct {
	// (Required) Unique ID from the original request.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// (Optional) Error message if exception encountered generating the status response.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// (Optional) Status debugging info reported by SDK harness worker. Content and
	// format is not strongly enforced but should be print-friendly and
	// appropriate as an HTTP response body for end user. For details of the preferred
	// info to include in the message see
	// https://s.apache.org/beam-fn-api-harness-status
	StatusInfo           string   `protobuf:"bytes,3,opt,name=status_info,json=statusInfo,proto3" json:"status_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WorkerStatusResponse) Reset()         { *m = WorkerStatusResponse{} }
func (m *WorkerStatusResponse) String() string { return proto.CompactTextString(m) }
func (*WorkerStatusResponse) ProtoMessage()    {}
func (*WorkerStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{36}
}

func (m *WorkerStatusResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WorkerStatusResponse.Unmarshal(m, b)
}
func (m *WorkerStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WorkerStatusResponse.Marshal(b, m, deterministic)
}
func (m *WorkerStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkerStatusResponse.Merge(m, src)
}
func (m *WorkerStatusResponse) XXX_Size() int {
	return xxx_messageInfo_WorkerStatusResponse.Size(m)
}
func (m *WorkerStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkerStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_WorkerStatusResponse proto.InternalMessageInfo

func (m *WorkerStatusResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *WorkerStatusResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *WorkerStatusResponse) GetStatusInfo() string {
	if m != nil {
		return m.StatusInfo
	}
	return ""
}

func init() {
	proto.RegisterEnum("org.apache.beam.model.fn_execution.v1.LogEntry_Severity_Enum", LogEntry_Severity_Enum_name, LogEntry_Severity_Enum_value)
	proto.RegisterType((*RemoteGrpcPort)(nil), "org.apache.beam.model.fn_execution.v1.RemoteGrpcPort")
	proto.RegisterType((*GetProcessBundleDescriptorRequest)(nil), "org.apache.beam.model.fn_execution.v1.GetProcessBundleDescriptorRequest")
	proto.RegisterType((*InstructionRequest)(nil), "org.apache.beam.model.fn_execution.v1.InstructionRequest")
	proto.RegisterType((*InstructionResponse)(nil), "org.apache.beam.model.fn_execution.v1.InstructionResponse")
	proto.RegisterType((*RegisterRequest)(nil), "org.apache.beam.model.fn_execution.v1.RegisterRequest")
	proto.RegisterType((*RegisterResponse)(nil), "org.apache.beam.model.fn_execution.v1.RegisterResponse")
	proto.RegisterType((*ProcessBundleDescriptor)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor")
	proto.RegisterMapType((map[string]*pipeline_v1.Coder)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.CodersEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.Environment)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.EnvironmentsEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.PCollection)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.PcollectionsEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.PTransform)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.TransformsEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.WindowingStrategy)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.WindowingStrategiesEntry")
	proto.RegisterType((*BundleApplication)(nil), "org.apache.beam.model.fn_execution.v1.BundleApplication")
	proto.RegisterMapType((map[string]*timestamp.Timestamp)(nil), "org.apache.beam.model.fn_execution.v1.BundleApplication.OutputWatermarksEntry")
	proto.RegisterType((*DelayedBundleApplication)(nil), "org.apache.beam.model.fn_execution.v1.DelayedBundleApplication")
	proto.RegisterType((*ProcessBundleRequest)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleRequest")
	proto.RegisterType((*ProcessBundleRequest_CacheToken)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken")
	proto.RegisterType((*ProcessBundleRequest_CacheToken_UserState)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken.UserState")
	proto.RegisterType((*ProcessBundleRequest_CacheToken_SideInput)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken.SideInput")
	proto.RegisterType((*ProcessBundleResponse)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleResponse")
	proto.RegisterMapType((map[string][]byte)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleResponse.MonitoringDataEntry")
	proto.RegisterType((*ProcessBundleProgressRequest)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleProgressRequest")
	proto.RegisterType((*ProcessBundleProgressMetadataRequest)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleProgressMetadataRequest")
	proto.RegisterType((*ProcessBundleProgressResponse)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleProgressResponse")
	proto.RegisterMapType((map[string][]byte)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleProgressResponse.MonitoringDataEntry")
	proto.RegisterType((*ProcessBundleProgressMetadataResponse)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleProgressMetadataResponse")
	proto.RegisterMapType((map[string]*pipeline_v1.MonitoringInfo)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleProgressMetadataResponse.MonitoringInfoEntry")
	proto.RegisterType((*ProcessBundleSplitRequest)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest")
	proto.RegisterMapType((map[string]*ProcessBundleSplitRequest_DesiredSplit)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest.DesiredSplitsEntry")
	proto.RegisterType((*ProcessBundleSplitRequest_DesiredSplit)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest.DesiredSplit")
	proto.RegisterType((*ProcessBundleSplitResponse)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse")
	proto.RegisterType((*ProcessBundleSplitResponse_ChannelSplit)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse.ChannelSplit")
	proto.RegisterType((*FinalizeBundleRequest)(nil), "org.apache.beam.model.fn_execution.v1.FinalizeBundleRequest")
	proto.RegisterType((*FinalizeBundleResponse)(nil), "org.apache.beam.model.fn_execution.v1.FinalizeBundleResponse")
	proto.RegisterType((*Elements)(nil), "org.apache.beam.model.fn_execution.v1.Elements")
	proto.RegisterType((*Elements_Data)(nil), "org.apache.beam.model.fn_execution.v1.Elements.Data")
	proto.RegisterType((*Elements_Timer)(nil), "org.apache.beam.model.fn_execution.v1.Elements.Timer")
	proto.RegisterType((*StateRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateRequest")
	proto.RegisterType((*StateResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateResponse")
	proto.RegisterType((*StateKey)(nil), "org.apache.beam.model.fn_execution.v1.StateKey")
	proto.RegisterType((*StateKey_Runner)(nil), "org.apache.beam.model.fn_execution.v1.StateKey.Runner")
	proto.RegisterType((*StateKey_IterableSideInput)(nil), "org.apache.beam.model.fn_execution.v1.StateKey.IterableSideInput")
	proto.RegisterType((*StateKey_MultimapSideInput)(nil), "org.apache.beam.model.fn_execution.v1.StateKey.MultimapSideInput")
	proto.RegisterType((*StateKey_MultimapKeysSideInput)(nil), "org.apache.beam.model.fn_execution.v1.StateKey.MultimapKeysSideInput")
	proto.RegisterType((*StateKey_BagUserState)(nil), "org.apache.beam.model.fn_execution.v1.StateKey.BagUserState")
	proto.RegisterType((*StateGetRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateGetRequest")
	proto.RegisterType((*StateGetResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateGetResponse")
	proto.RegisterType((*StateAppendRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateAppendRequest")
	proto.RegisterType((*StateAppendResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateAppendResponse")
	proto.RegisterType((*StateClearRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateClearRequest")
	proto.RegisterType((*StateClearResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateClearResponse")
	proto.RegisterType((*LogEntry)(nil), "org.apache.beam.model.fn_execution.v1.LogEntry")
	proto.RegisterType((*LogEntry_List)(nil), "org.apache.beam.model.fn_execution.v1.LogEntry.List")
	proto.RegisterType((*LogEntry_Severity)(nil), "org.apache.beam.model.fn_execution.v1.LogEntry.Severity")
	proto.RegisterType((*LogControl)(nil), "org.apache.beam.model.fn_execution.v1.LogControl")
	proto.RegisterType((*StartWorkerRequest)(nil), "org.apache.beam.model.fn_execution.v1.StartWorkerRequest")
	proto.RegisterMapType((map[string]string)(nil), "org.apache.beam.model.fn_execution.v1.StartWorkerRequest.ParamsEntry")
	proto.RegisterType((*StartWorkerResponse)(nil), "org.apache.beam.model.fn_execution.v1.StartWorkerResponse")
	proto.RegisterType((*StopWorkerRequest)(nil), "org.apache.beam.model.fn_execution.v1.StopWorkerRequest")
	proto.RegisterType((*StopWorkerResponse)(nil), "org.apache.beam.model.fn_execution.v1.StopWorkerResponse")
	proto.RegisterType((*WorkerStatusRequest)(nil), "org.apache.beam.model.fn_execution.v1.WorkerStatusRequest")
	proto.RegisterType((*WorkerStatusResponse)(nil), "org.apache.beam.model.fn_execution.v1.WorkerStatusResponse")
}

func init() { proto.RegisterFile("beam_fn_api.proto", fileDescriptor_6d954c03a4758710) }

var fileDescriptor_6d954c03a4758710 = []byte{
	// 3023 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x5a, 0x4b, 0x70, 0xdb, 0xd6,
	0xd5, 0x36, 0xf8, 0x90, 0xc8, 0x43, 0x4a, 0xa2, 0xae, 0x24, 0x9b, 0xc6, 0x9f, 0xfc, 0x51, 0x30,
	0xf1, 0x3f, 0x9a, 0xbf, 0x0d, 0x6d, 0x2b, 0x6e, 0x62, 0xa7, 0x69, 0x12, 0x3d, 0x68, 0x9b, 0xb6,
	0x6c, 0xb3, 0x90, 0x5c, 0xa7, 0x99, 0x66, 0x50, 0x88, 0xb8, 0xa4, 0x31, 0x06, 0x01, 0xe4, 0x5e,
	0x50, 0xb6, 0xd2, 0xb4, 0x69, 0xa6, 0x9d, 0x76, 0xd2, 0x99, 0x4c, 0x37, 0x9d, 0xe9, 0x6b, 0xb2,
	0xe9, 0x74, 0xd1, 0x74, 0xd1, 0x65, 0x17, 0xdd, 0x66, 0xd1, 0x55, 0xb7, 0xd9, 0x77, 0xd7, 0xe7,
	0xa2, 0x9b, 0x6e, 0xdb, 0xb9, 0x0f, 0x80, 0x20, 0x09, 0xda, 0x20, 0xa9, 0x64, 0xc7, 0xfb, 0xfa,
	0xbe, 0x7b, 0xcf, 0x3d, 0xe7, 0xdc, 0x73, 0x0e, 0x08, 0xcb, 0x87, 0xd8, 0xec, 0x1a, 0x6d, 0xd7,
	0x30, 0x7d, 0xbb, 0xe6, 0x13, 0x2f, 0xf0, 0xd0, 0x39, 0x8f, 0x74, 0x6a, 0xa6, 0x6f, 0xb6, 0xee,
	0xe3, 0x1a, 0x1b, 0xad, 0x75, 0x3d, 0x0b, 0x3b, 0xb5, 0xb6, 0x6b, 0xe0, 0x47, 0xb8, 0xd5, 0x0b,
	0x6c, 0xcf, 0xad, 0x1d, 0x5d, 0x54, 0xd7, 0xf8, 0x4a, 0xd2, 0x73, 0x5d, 0x4c, 0xfa, 0xab, 0xd5,
	0x25, 0xec, 0x5a, 0xbe, 0x67, 0xbb, 0x01, 0x95, 0x1d, 0xeb, 0x1d, 0xcf, 0xeb, 0x38, 0xf8, 0x3c,
	0x6f, 0x1d, 0xf6, 0xda, 0xe7, 0x2d, 0x4c, 0x5b, 0xc4, 0xf6, 0x03, 0x8f, 0xc8, 0x19, 0xcf, 0x0c,
	0xcf, 0x08, 0xec, 0x2e, 0xa6, 0x81, 0xd9, 0xf5, 0xe5, 0x84, 0xff, 0x1d, 0x81, 0xe8, 0x11, 0x93,
	0xef, 0x63, 0xcc, 0xf8, 0x43, 0x62, 0xfa, 0x3e, 0x26, 0xe1, 0x16, 0x16, 0xba, 0x38, 0x20, 0x76,
	0x4b, 0x36, 0xb5, 0x5f, 0x28, 0xb0, 0xa8, 0xe3, 0xae, 0x17, 0xe0, 0x6b, 0xc4, 0x6f, 0x35, 0x3d,
	0x12, 0xa0, 0x2e, 0x9c, 0x36, 0x7d, 0xdb, 0xa0, 0x98, 0x1c, 0xd9, 0x2d, 0x6c, 0xf4, 0xb7, 0x58,
	0x55, 0xd6, 0x95, 0x8d, 0xd2, 0xe6, 0x4b, 0xb5, 0x64, 0xa1, 0xf8, 0xb6, 0x8f, 0x1d, 0xdb, 0xc5,
	0xb5, 0xa3, 0x8b, 0xb5, 0x2d, 0xdf, 0xde, 0x17, 0xeb, 0x77, 0xa3, 0xe5, 0xfa, 0xaa, 0x99, 0xd0,
	0x8b, 0xce, 0x42, 0xa1, 0xe5, 0x59, 0x98, 0x18, 0xb6, 0x55, 0xcd, 0xac, 0x2b, 0x1b, 0x45, 0x7d,
	0x9e, 0xb7, 0x1b, 0x96, 0x66, 0xc1, 0xb3, 0xd7, 0x70, 0xd0, 0x24, 0x5e, 0x0b, 0x53, 0xba, 0xdd,
	0x73, 0x2d, 0x27, 0x0e, 0x87, 0xdf, 0xee, 0x61, 0x1a, 0xa0, 0xd7, 0xe0, 0x29, 0x5f, 0xcc, 0x30,
	0x0e, 0xf9, 0x94, 0xd8, 0x8e, 0x19, 0xa6, 0xc2, 0x31, 0xcf, 0xfa, 0xc9, 0x28, 0x0d, 0x4b, 0xfb,
	0x4f, 0x1e, 0x50, 0xc3, 0xa5, 0x01, 0xe9, 0xb5, 0x98, 0x1c, 0x43, 0xdc, 0x73, 0xb0, 0x68, 0xf7,
	0x7b, 0xfb, 0x48, 0x0b, 0xb1, 0xde, 0x86, 0x85, 0xee, 0x42, 0x81, 0xe0, 0x8e, 0x4d, 0x03, 0x4c,
	0xaa, 0x7f, 0x99, 0xe7, 0x02, 0x7a, 0xb1, 0x96, 0x4a, 0x6b, 0x6a, 0xba, 0x5c, 0x27, 0x19, 0xaf,
	0x9f, 0xd2, 0x23, 0x28, 0x84, 0x61, 0x71, 0xf0, 0x54, 0xd5, 0xbf, 0x0a, 0xf0, 0x2f, 0xa7, 0x04,
	0x1f, 0x90, 0x5a, 0x9f, 0x61, 0x61, 0x40, 0x0e, 0xe8, 0x3b, 0x70, 0x66, 0x48, 0x78, 0x3e, 0xf1,
	0x3a, 0x04, 0x53, 0x5a, 0xfd, 0x9b, 0xe0, 0xdb, 0x99, 0x86, 0xaf, 0x29, 0x41, 0xfa, 0xbc, 0x6b,
	0x7e, 0xd2, 0x38, 0xea, 0xc1, 0xea, 0x10, 0x3f, 0xf5, 0x1d, 0x3b, 0xa8, 0xfe, 0x5d, 0x90, 0xbf,
	0x3e, 0x0d, 0xf9, 0x3e, 0x43, 0xe8, 0x33, 0x23, 0x7f, 0x64, 0x10, 0xdd, 0x87, 0xa5, 0xb6, 0xed,
	0x9a, 0x8e, 0xfd, 0x0e, 0x0e, 0xc5, 0xfb, 0x0f, 0xc1, 0xf8, 0x4a, 0x4a, 0xc6, 0xab, 0x72, 0xf9,
	0xb0, 0x7c, 0x17, 0xdb, 0x03, 0x03, 0xe8, 0xa7, 0x0a, 0xac, 0x8f, 0x91, 0xb0, 0xd1, 0xc5, 0x81,
	0x69, 0x99, 0x81, 0x59, 0xfd, 0xa7, 0xe0, 0xbe, 0x39, 0x8b, 0xa8, 0x6f, 0x49, 0xb0, 0xfe, 0x56,
	0x9e, 0xf6, 0x1f, 0x37, 0x6f, 0xbb, 0x08, 0xf3, 0x44, 0xcc, 0xd5, 0x3e, 0x9a, 0x83, 0x95, 0x01,
	0x0b, 0xa0, 0xbe, 0xe7, 0x52, 0x9c, 0xd6, 0x04, 0x56, 0x21, 0x8f, 0x09, 0xf1, 0x88, 0x34, 0x5f,
	0xd1, 0x40, 0x5f, 0x1b, 0x35, 0x8c, 0x97, 0x26, 0x36, 0x0c, 0xb1, 0x91, 0x01, 0xcb, 0x68, 0x8f,
	0xb3, 0x8c, 0x57, 0xa6, 0xb3, 0x8c, 0x88, 0x62, 0xc8, 0x34, 0xde, 0x7b, 0xa2, 0x69, 0xec, 0xce,
	0x66, 0x1a, 0x11, 0xf1, 0x18, 0xdb, 0x38, 0x7a, 0xbc, 0x6d, 0x6c, 0xcd, 0x60, 0x1b, 0x11, 0x75,
	0x92, 0x71, 0xd8, 0x63, 0x8d, 0xe3, 0x2b, 0x53, 0x1a, 0x47, 0x44, 0x37, 0x6c, 0x1d, 0x3f, 0x9b,
	0xc0, 0x3a, 0xf6, 0x4e, 0xc6, 0x3a, 0xa2, 0xbd, 0x3c, 0xc1, 0x3c, 0x80, 0xa9, 0xaf, 0x98, 0xac,
	0x7d, 0xa8, 0xc0, 0xd2, 0x90, 0xb3, 0x46, 0xef, 0xc0, 0xd9, 0xb1, 0xcf, 0x4e, 0x55, 0x59, 0xcf,
	0x6e, 0x94, 0x36, 0x5f, 0x9d, 0x66, 0xc7, 0xb1, 0x07, 0xee, 0xcc, 0x98, 0x37, 0x4b, 0x43, 0x50,
	0x19, 0x36, 0x11, 0xed, 0xa3, 0x12, 0x9c, 0x19, 0x03, 0x84, 0x16, 0x21, 0x13, 0xd9, 0x6e, 0xc6,
	0xb6, 0x90, 0x0b, 0x10, 0x10, 0xd3, 0xa5, 0x6d, 0x8f, 0x74, 0x69, 0x35, 0xc3, 0x37, 0x7b, 0x7b,
	0xb6, 0xcd, 0xd6, 0x0e, 0x22, 0xc0, 0xba, 0x1b, 0x90, 0x63, 0x3d, 0xc6, 0x80, 0x02, 0x28, 0xfb,
	0x2d, 0xcf, 0x71, 0x30, 0xf7, 0x18, 0xb4, 0x9a, 0xe5, 0x8c, 0xcd, 0x19, 0x19, 0x9b, 0x31, 0x48,
	0xc1, 0x39, 0xc0, 0x82, 0x7e, 0xa4, 0xc0, 0xea, 0x43, 0xdb, 0xb5, 0xbc, 0x87, 0xb6, 0xdb, 0x31,
	0x68, 0x40, 0xcc, 0x00, 0x77, 0x6c, 0x4c, 0xab, 0x39, 0x4e, 0x7f, 0x6f, 0x46, 0xfa, 0x7b, 0x21,
	0xf4, 0x7e, 0x84, 0x2c, 0x76, 0xb1, 0xf2, 0x70, 0x74, 0x04, 0x1d, 0xc2, 0x1c, 0x8f, 0x6a, 0x68,
	0x35, 0xcf, 0xd9, 0x6f, 0xcc, 0xc8, 0xbe, 0xc3, 0xc1, 0x04, 0xa1, 0x44, 0x66, 0x62, 0xc6, 0xee,
	0x91, 0x4d, 0x3c, 0xb7, 0x8b, 0xdd, 0x80, 0x56, 0xe7, 0x4e, 0x44, 0xcc, 0xf5, 0x18, 0xa4, 0x14,
	0x73, 0x9c, 0x05, 0x3d, 0x82, 0xa7, 0x68, 0x60, 0x06, 0xd8, 0x18, 0x13, 0x34, 0xce, 0xcf, 0x16,
	0x34, 0x9e, 0xe5, 0xe0, 0x49, 0x43, 0x8c, 0x99, 0x45, 0xc7, 0x64, 0x1c, 0x73, 0x61, 0x46, 0x66,
	0x0e, 0x9e, 0x34, 0xa4, 0x3a, 0xb0, 0x34, 0xa4, 0xef, 0xa8, 0x02, 0xd9, 0x07, 0xf8, 0x58, 0x1a,
	0x19, 0xfb, 0x89, 0x76, 0x20, 0x7f, 0x64, 0x3a, 0x3d, 0xcc, 0x9f, 0xc5, 0xd2, 0xe6, 0xf3, 0x29,
	0xf6, 0xd1, 0x8c, 0x50, 0x75, 0xb1, 0xf6, 0xe5, 0xcc, 0x65, 0x45, 0xf5, 0x60, 0x79, 0x44, 0xd7,
	0x13, 0xf8, 0x76, 0x07, 0xf9, 0x6a, 0x69, 0xf8, 0x76, 0x22, 0xd8, 0x38, 0xe1, 0xbb, 0x50, 0x1d,
	0xa7, 0xdd, 0x09, 0xbc, 0x37, 0x06, 0x79, 0x2f, 0xa5, 0xe0, 0x1d, 0x46, 0x3f, 0x8e, 0xb3, 0xb7,
	0xa0, 0x14, 0xd3, 0xee, 0x04, 0xc2, 0x57, 0x07, 0x09, 0x37, 0x52, 0x10, 0x72, 0xc0, 0x21, 0x99,
	0x8e, 0x28, 0xf6, 0xc9, 0xc8, 0x34, 0x06, 0x1b, 0x23, 0xd4, 0x7e, 0x99, 0x85, 0x65, 0x61, 0x5b,
	0x5b, 0xbe, 0xef, 0xd8, 0x2d, 0x9e, 0xb3, 0xa1, 0x67, 0xa1, 0x1c, 0xf9, 0xc9, 0x7e, 0x7c, 0x55,
	0x8a, 0xfa, 0x1a, 0x16, 0xcb, 0x8f, 0x6c, 0xd7, 0xef, 0x05, 0xb1, 0xfc, 0x88, 0xb7, 0x1b, 0x16,
	0xaa, 0xc2, 0x3c, 0x76, 0x30, 0x63, 0xaa, 0x66, 0xd7, 0x95, 0x8d, 0xb2, 0x1e, 0x36, 0xd1, 0xb7,
	0x60, 0xd9, 0xeb, 0x05, 0x6c, 0xd5, 0x43, 0x33, 0xc0, 0xa4, 0x6b, 0x92, 0x07, 0xa1, 0xdf, 0x4b,
	0xeb, 0xe8, 0x47, 0x36, 0x5b, 0xbb, 0xc3, 0x11, 0xef, 0x45, 0x80, 0xc2, 0x1b, 0x54, 0xbc, 0xa1,
	0x6e, 0xd4, 0x04, 0xb0, 0xa9, 0x71, 0xe8, 0xf5, 0x5c, 0x0b, 0x5b, 0xd5, 0xfc, 0xba, 0xb2, 0xb1,
	0xb8, 0x79, 0x31, 0x85, 0xe4, 0x1a, 0x74, 0x5b, 0xac, 0xa9, 0xd5, 0xdd, 0x5e, 0x57, 0x2f, 0xda,
	0x61, 0x5b, 0x35, 0x60, 0x2d, 0x91, 0x3c, 0xe1, 0xc6, 0x2e, 0x0c, 0xde, 0x98, 0x5a, 0x13, 0xf9,
	0x70, 0x2d, 0xcc, 0x87, 0x6b, 0x07, 0x61, 0x42, 0x1d, 0xbf, 0x9d, 0x4f, 0x14, 0xa8, 0xee, 0x62,
	0xc7, 0x3c, 0xc6, 0xd6, 0xe8, 0x25, 0xbd, 0x09, 0x25, 0xb3, 0xdf, 0x94, 0x59, 0xf0, 0xe5, 0x69,
	0xc5, 0xa8, 0xc7, 0xc1, 0xd0, 0x4d, 0x58, 0x95, 0x51, 0x38, 0xb6, 0x0c, 0xe6, 0x70, 0x0c, 0x8b,
	0x6d, 0x43, 0xee, 0xfe, 0xec, 0xc8, 0xee, 0x77, 0x65, 0xb6, 0xaf, 0xa3, 0x68, 0x19, 0x3b, 0x10,
	0xdf, 0xbb, 0xf6, 0xfb, 0x1c, 0xac, 0x26, 0xe5, 0x7d, 0x33, 0xe7, 0xc8, 0xc8, 0x86, 0x72, 0x8b,
	0x9d, 0xd4, 0x08, 0xbc, 0x07, 0xd8, 0x0d, 0x63, 0x86, 0xab, 0x33, 0xe4, 0xa2, 0xb5, 0x1d, 0xb6,
	0xea, 0x80, 0xc1, 0xe9, 0xa5, 0x56, 0xf4, 0x9b, 0xaa, 0xff, 0xca, 0x00, 0xf4, 0xc7, 0xd0, 0xdb,
	0x00, 0x3d, 0x8a, 0x89, 0xc1, 0x9f, 0x01, 0x29, 0xfb, 0xe6, 0xc9, 0xf0, 0xd6, 0xee, 0x52, 0x4c,
	0xf6, 0x19, 0xee, 0xf5, 0x53, 0x7a, 0xb1, 0x17, 0x36, 0x18, 0x25, 0xb5, 0x2d, 0x6c, 0x70, 0x33,
	0x93, 0x37, 0x71, 0x52, 0x94, 0xfb, 0xb6, 0x85, 0x1b, 0x0c, 0x97, 0x51, 0xd2, 0xb0, 0xc1, 0x52,
	0x28, 0x2e, 0xd9, 0x2a, 0x70, 0x3b, 0x16, 0x0d, 0xb5, 0x04, 0xc5, 0x68, 0x8b, 0xaa, 0x0e, 0xc5,
	0x68, 0x71, 0x1a, 0xbf, 0xa1, 0xc1, 0x42, 0xff, 0x14, 0x7d, 0xe7, 0x51, 0x8a, 0x48, 0x1b, 0xd6,
	0xf6, 0x1c, 0xe4, 0x82, 0x63, 0x1f, 0x6b, 0x9f, 0x66, 0x61, 0x2d, 0x31, 0x2d, 0x62, 0xd9, 0x16,
	0xc1, 0xd4, 0xb6, 0x7a, 0xa6, 0x63, 0x10, 0xcf, 0x0b, 0xc2, 0xab, 0x7f, 0x2d, 0xa5, 0x3c, 0xc6,
	0x19, 0x95, 0xbe, 0x10, 0xc2, 0xea, 0x0c, 0x15, 0x7d, 0x03, 0x2a, 0x5d, 0xcf, 0xb5, 0x03, 0x8f,
	0xb0, 0x60, 0xcd, 0x76, 0xdb, 0x5e, 0x18, 0x26, 0xa6, 0xf1, 0x1c, 0xb7, 0xa2, 0xa5, 0x0d, 0xb7,
	0xed, 0xe9, 0x4b, 0xdd, 0x81, 0x36, 0x45, 0x2f, 0xc0, 0x1a, 0x33, 0x17, 0x9b, 0x60, 0x6a, 0xc8,
	0x14, 0x44, 0xd8, 0x72, 0x6e, 0x5d, 0xd9, 0x28, 0xe8, 0xab, 0xe1, 0xe0, 0xd5, 0xd8, 0x18, 0x3a,
	0x86, 0x18, 0x8e, 0xc1, 0x53, 0x91, 0xfc, 0xf4, 0x11, 0x55, 0x28, 0xd1, 0xd8, 0x5e, 0x77, 0xcd,
	0xc0, 0x14, 0x3e, 0x74, 0xb1, 0x3b, 0xd0, 0xa9, 0x6e, 0xc1, 0x4a, 0xc2, 0xb4, 0x04, 0x6f, 0xb7,
	0x1a, 0xf7, 0x76, 0xe5, 0x98, 0x47, 0xbb, 0x91, 0x2b, 0x28, 0x95, 0x8c, 0x56, 0x87, 0xa7, 0x1e,
	0x57, 0x98, 0x49, 0x99, 0xe1, 0x6b, 0x07, 0xf0, 0x5c, 0x9a, 0xa2, 0x03, 0xfa, 0x22, 0xa0, 0xa1,
	0x5b, 0x14, 0x90, 0xd9, 0x8d, 0xa2, 0x5e, 0x19, 0xbc, 0x94, 0x86, 0xa5, 0x7d, 0x9a, 0x81, 0xa7,
	0x1f, 0x9b, 0x1b, 0x7f, 0xc6, 0x5a, 0xf1, 0xbe, 0x32, 0xee, 0x86, 0xdf, 0x38, 0x89, 0xcc, 0xfe,
	0x73, 0xbd, 0xe9, 0x1b, 0xb9, 0x42, 0xa6, 0x92, 0xbd, 0x91, 0x2b, 0xe4, 0x2a, 0x79, 0xed, 0xe3,
	0x0c, 0x9c, 0x4b, 0x95, 0x06, 0xa3, 0x0f, 0x06, 0x45, 0xc0, 0x24, 0x2c, 0x93, 0xd7, 0x6f, 0x9e,
	0x64, 0xba, 0x3d, 0x74, 0x15, 0x23, 0xa2, 0x60, 0x9d, 0x6a, 0x10, 0x17, 0x45, 0x34, 0x2d, 0x41,
	0x14, 0xd7, 0x06, 0x9f, 0xf8, 0x29, 0x54, 0x21, 0xf6, 0xf2, 0xbf, 0x9f, 0x83, 0xb3, 0x63, 0xcb,
	0x87, 0x69, 0x2b, 0x60, 0xef, 0xc0, 0xa2, 0x85, 0xa9, 0x4d, 0xb0, 0x25, 0x6a, 0x34, 0xa1, 0x96,
	0xee, 0xcf, 0x5a, 0xbf, 0xac, 0xed, 0x0a, 0x58, 0xde, 0x27, 0x03, 0xae, 0x05, 0x2b, 0xde, 0xa7,
	0xfe, 0x4e, 0x81, 0x72, 0x7c, 0x16, 0xda, 0x84, 0xb5, 0x36, 0x31, 0xc5, 0x86, 0xbd, 0xb6, 0x41,
	0x70, 0xd7, 0xb4, 0x5d, 0x0b, 0x8b, 0xf2, 0xbd, 0xa2, 0xaf, 0x84, 0x83, 0x77, 0xda, 0x7a, 0x38,
	0x84, 0x2e, 0xc0, 0xaa, 0xe9, 0x38, 0xde, 0xc3, 0xf0, 0x00, 0x86, 0xf8, 0x6c, 0xc1, 0x8f, 0x91,
	0xd5, 0x91, 0x1c, 0xe3, 0xf8, 0x4d, 0x3e, 0x82, 0x2e, 0x43, 0x15, 0xd3, 0xc0, 0xee, 0x9a, 0x2c,
	0x70, 0x11, 0x6f, 0x8c, 0x0c, 0x3e, 0x29, 0xbf, 0x97, 0xac, 0x7e, 0x3a, 0x1a, 0xe7, 0xcf, 0x4d,
	0x5d, 0x8e, 0xaa, 0x3f, 0x56, 0x00, 0x8d, 0x1e, 0x2b, 0xe1, 0x9e, 0x5b, 0x83, 0xf7, 0x7c, 0xeb,
	0x44, 0x85, 0x19, 0xd7, 0x81, 0x7f, 0x67, 0x41, 0x1d, 0x5f, 0x26, 0x43, 0x6f, 0xc1, 0x82, 0x4f,
	0xec, 0xae, 0x49, 0x8e, 0xe5, 0x13, 0x28, 0x2c, 0x64, 0xfa, 0x08, 0xb0, 0x2c, 0xe1, 0xc4, 0xd3,
	0xf7, 0x79, 0x3d, 0xb1, 0x3d, 0x58, 0x6c, 0xdd, 0x37, 0x5d, 0x17, 0x3b, 0x83, 0x4a, 0x7a, 0x7b,
	0xe6, 0x42, 0x62, 0x6d, 0x47, 0xe0, 0x8a, 0xce, 0x85, 0x56, 0xac, 0x45, 0xd5, 0x9f, 0x2b, 0x50,
	0x8e, 0x8f, 0xa7, 0x89, 0x5d, 0x2e, 0xc0, 0xaa, 0x63, 0xd2, 0xc0, 0x08, 0xc5, 0x1e, 0x66, 0x39,
	0x42, 0xb1, 0x10, 0x1b, 0x6b, 0x8a, 0x21, 0xa9, 0x55, 0xe8, 0x12, 0x9c, 0x6e, 0xdb, 0x84, 0x06,
	0x46, 0x24, 0xca, 0x78, 0x66, 0x94, 0xd5, 0x57, 0xf9, 0xa8, 0x2e, 0x07, 0xe5, 0x2a, 0xed, 0x55,
	0x58, 0x4b, 0x2c, 0xe4, 0xa7, 0x7d, 0x17, 0xab, 0x70, 0x3a, 0xb9, 0xd6, 0xa9, 0xfd, 0x29, 0x0b,
	0x85, 0x50, 0xe3, 0xd1, 0x75, 0xc8, 0xf1, 0xc7, 0x45, 0xe8, 0xcd, 0xa5, 0x94, 0xf2, 0x0e, 0x97,
	0xd7, 0xd8, 0xb3, 0xa0, 0x73, 0x04, 0x74, 0x13, 0xf2, 0xbc, 0x2a, 0x21, 0x55, 0xe4, 0x4b, 0x93,
	0x42, 0xb1, 0x5c, 0x81, 0xe8, 0x02, 0x43, 0xfd, 0x36, 0xe4, 0x18, 0x74, 0x5a, 0x27, 0x37, 0x7c,
	0x6f, 0x99, 0xd1, 0x7b, 0x43, 0xf2, 0xa0, 0x22, 0x1b, 0x15, 0x5b, 0x3e, 0x03, 0xf3, 0x36, 0x35,
	0xd8, 0x95, 0xc9, 0x68, 0x6b, 0xce, 0xa6, 0x7b, 0x26, 0x0d, 0xd4, 0xdf, 0x2a, 0x90, 0xe7, 0xfb,
	0x39, 0xc1, 0x0d, 0xfc, 0x1f, 0x2c, 0x89, 0x92, 0x50, 0xdb, 0xec, 0xda, 0xce, 0x31, 0x9b, 0x95,
	0x15, 0x50, 0xbc, 0xfb, 0x2a, 0xef, 0x6d, 0x58, 0xe8, 0x34, 0xcc, 0xf1, 0x0e, 0xca, 0xf7, 0x54,
	0xd6, 0x65, 0x2b, 0xbe, 0xd9, 0x7c, 0x7c, 0xb3, 0xda, 0x4f, 0xb2, 0x50, 0xe6, 0x71, 0x78, 0xa8,
	0x21, 0xc3, 0x35, 0xd5, 0xd1, 0x33, 0x64, 0x92, 0xce, 0xb0, 0x07, 0x45, 0x51, 0x2d, 0x63, 0xbe,
	0x2e, 0xcb, 0xfd, 0xda, 0xf9, 0x94, 0x97, 0xc8, 0xe9, 0x6f, 0xe2, 0x63, 0xbd, 0x40, 0xe5, 0x2f,
	0x74, 0x13, 0xb2, 0x1d, 0x1c, 0x4c, 0xfa, 0xdd, 0x91, 0x03, 0x5d, 0xc3, 0xb1, 0x6f, 0x64, 0x0c,
	0x05, 0x1d, 0xc0, 0x9c, 0xe9, 0xfb, 0xd8, 0xb5, 0xc2, 0x0f, 0x2a, 0x57, 0x26, 0xc1, 0xdb, 0xe2,
	0x4b, 0xfb, 0x90, 0x12, 0x0b, 0x7d, 0x15, 0xf2, 0x2d, 0x07, 0x9b, 0x24, 0xfc, 0x68, 0x72, 0x79,
	0x12, 0xd0, 0x1d, 0xb6, 0xb2, 0x8f, 0x29, 0x90, 0xe2, 0x5f, 0xae, 0xfe, 0x90, 0x81, 0x05, 0x79,
	0x2d, 0xd2, 0x59, 0x0f, 0xdf, 0x4b, 0xf2, 0xc7, 0xa9, 0xbd, 0x01, 0xc1, 0xbd, 0x34, 0xb1, 0xe0,
	0xa2, 0xaf, 0x08, 0x5c, 0x72, 0x77, 0x87, 0x25, 0xf7, 0xf2, 0x34, 0x92, 0x8b, 0x30, 0x43, 0xd1,
	0xe9, 0x43, 0xa2, 0xbb, 0x32, 0x85, 0xe8, 0x22, 0x50, 0x29, 0xbb, 0xf8, 0x67, 0x8d, 0x3f, 0x16,
	0xa0, 0x10, 0x2a, 0x15, 0x6a, 0xc2, 0x9c, 0xf8, 0xff, 0x82, 0xcc, 0xb1, 0x5f, 0x9c, 0x50, 0x2b,
	0x6b, 0x3a, 0x5f, 0xcd, 0xb6, 0x2f, 0x70, 0x10, 0x85, 0x95, 0x6e, 0xcf, 0x61, 0x21, 0x80, 0x6f,
	0x8c, 0xe4, 0xd3, 0x5b, 0x93, 0xc2, 0xdf, 0x92, 0x50, 0xf1, 0x04, 0x7a, 0xb9, 0x3b, 0xdc, 0x89,
	0x2c, 0x58, 0x3c, 0x34, 0x3b, 0x46, 0xac, 0x64, 0x90, 0x9d, 0xe8, 0xe3, 0x60, 0xc4, 0xb7, 0x6d,
	0x76, 0xe2, 0xe5, 0x81, 0xf2, 0x61, 0xac, 0xcd, 0x8e, 0x66, 0x07, 0x98, 0x98, 0x87, 0x0e, 0x8e,
	0x1f, 0x2d, 0x37, 0xdd, 0xd1, 0x1a, 0x12, 0x6a, 0xe0, 0x68, 0xf6, 0x70, 0x27, 0xfa, 0xae, 0x02,
	0xd5, 0x48, 0xa0, 0x0f, 0xf0, 0x31, 0x8d, 0x53, 0xe7, 0x39, 0x75, 0x7d, 0x5a, 0xa9, 0xde, 0xc4,
	0xc7, 0x34, 0x4e, 0xbf, 0xd6, 0x4d, 0x1a, 0x50, 0x55, 0x98, 0x13, 0xd7, 0x1c, 0x8f, 0xd6, 0xca,
	0x3c, 0x5a, 0x53, 0x09, 0x2c, 0x8f, 0x1c, 0xe4, 0x84, 0xea, 0x14, 0xcc, 0x5d, 0x8b, 0x8f, 0x2a,
	0xf2, 0x65, 0x91, 0x2d, 0xf5, 0xfb, 0x0a, 0x2c, 0x8f, 0x28, 0xc6, 0x67, 0x4c, 0x1a, 0x1e, 0x3d,
	0xd7, 0x3f, 0xfa, 0x11, 0xac, 0x25, 0x0a, 0xf2, 0xb3, 0x3e, 0xfe, 0x7b, 0x50, 0x8e, 0xab, 0x69,
	0x4a, 0xba, 0xbe, 0x6d, 0xc4, 0xe8, 0xa2, 0xea, 0xd7, 0x24, 0x07, 0x8f, 0xea, 0x47, 0xaf, 0xc3,
	0xd2, 0xd0, 0xa3, 0x82, 0x9e, 0x07, 0xd4, 0xf2, 0xdc, 0xc0, 0x76, 0x7b, 0x3c, 0x18, 0x15, 0x85,
	0x43, 0xa9, 0x2f, 0xcb, 0xf1, 0x11, 0x5e, 0x17, 0xd3, 0xee, 0x42, 0x65, 0xd8, 0xbb, 0x4e, 0x08,
	0x11, 0x05, 0x1f, 0x99, 0x7e, 0xf0, 0xa1, 0x6d, 0x00, 0x1a, 0x7d, 0x9d, 0xa2, 0x99, 0x4a, 0x6c,
	0xe6, 0x1a, 0xac, 0x24, 0x78, 0x63, 0x6d, 0x05, 0x96, 0x47, 0x5e, 0x22, 0x6d, 0x55, 0xa2, 0x0e,
	0xf8, 0x58, 0xed, 0x57, 0x39, 0x28, 0xec, 0x79, 0x1d, 0x91, 0xcd, 0x7c, 0x1d, 0x0a, 0x14, 0x1f,
	0x61, 0x62, 0x07, 0xc2, 0x48, 0x16, 0x53, 0x7f, 0x3c, 0x0f, 0x21, 0x6a, 0xfb, 0x72, 0xbd, 0xa8,
	0x86, 0x47, 0x70, 0xe8, 0x32, 0x14, 0xa3, 0x3f, 0x85, 0xa5, 0xa8, 0x72, 0xf7, 0x27, 0xa3, 0x2a,
	0xcc, 0x77, 0x31, 0xa5, 0x66, 0x07, 0xcb, 0xa8, 0x28, 0x6c, 0xf2, 0xfa, 0x23, 0x31, 0x5b, 0x98,
	0x5f, 0x6e, 0x51, 0x17, 0x8d, 0x84, 0x98, 0x26, 0x9f, 0x26, 0x2e, 0x9b, 0x1b, 0x55, 0xbb, 0x67,
	0xa1, 0xec, 0x78, 0x1d, 0xc3, 0xf1, 0x64, 0x0d, 0x7d, 0x5e, 0x4c, 0x71, 0xbc, 0xce, 0x9e, 0xec,
	0xe2, 0x21, 0xd9, 0x7d, 0x82, 0x4d, 0x8b, 0x7f, 0xb7, 0x2b, 0xea, 0xb2, 0xa5, 0xbe, 0x01, 0xb9,
	0x3d, 0x9b, 0x06, 0xa8, 0x09, 0x6c, 0xba, 0x81, 0xdd, 0x80, 0xd8, 0x38, 0xcc, 0xc1, 0xce, 0x4f,
	0x28, 0x54, 0x1d, 0x1c, 0xf1, 0xcb, 0xc6, 0x54, 0x25, 0x50, 0x08, 0x65, 0xac, 0xb5, 0x21, 0xc7,
	0xc4, 0x8c, 0x96, 0xa0, 0x74, 0xf7, 0xf6, 0x7e, 0xb3, 0xbe, 0xd3, 0xb8, 0xda, 0xa8, 0xef, 0x56,
	0x4e, 0xa1, 0x22, 0xe4, 0x0f, 0xf4, 0xad, 0x9d, 0x7a, 0x45, 0x61, 0x3f, 0x77, 0xeb, 0xdb, 0x77,
	0xaf, 0x55, 0x32, 0xa8, 0x00, 0xb9, 0xc6, 0xed, 0xab, 0x77, 0x2a, 0x59, 0x04, 0x30, 0x77, 0xfb,
	0xce, 0x41, 0x63, 0xa7, 0x5e, 0xc9, 0xb1, 0xde, 0x7b, 0x5b, 0xfa, 0xed, 0x4a, 0x9e, 0x4d, 0xad,
	0xeb, 0xfa, 0x1d, 0xbd, 0x32, 0x87, 0xca, 0x50, 0xd8, 0xd1, 0x1b, 0x07, 0x8d, 0x9d, 0xad, 0xbd,
	0xca, 0xbc, 0x56, 0x06, 0xd8, 0xf3, 0x3a, 0x3b, 0x9e, 0x1b, 0x10, 0xcf, 0xd1, 0xfe, 0x9c, 0xe3,
	0x9a, 0x44, 0x82, 0x7b, 0x1e, 0x79, 0xd0, 0xff, 0x6f, 0xc1, 0xff, 0x40, 0xf1, 0x21, 0xef, 0xe8,
	0x1b, 0x71, 0x41, 0x74, 0x34, 0x2c, 0x74, 0x08, 0x95, 0x96, 0x58, 0x6e, 0x84, 0x7f, 0x2f, 0x94,
	0x5a, 0x30, 0xf5, 0x97, 0xce, 0x25, 0x09, 0x58, 0x97, 0x78, 0x8c, 0xc3, 0xf1, 0x3a, 0x1d, 0xdb,
	0xed, 0xf4, 0x39, 0xb2, 0x33, 0x72, 0x48, 0xc0, 0x88, 0xc3, 0x82, 0x65, 0x93, 0x04, 0x76, 0xdb,
	0x6c, 0x05, 0x7d, 0x92, 0xdc, 0x6c, 0x24, 0x95, 0x10, 0x31, 0x62, 0x69, 0x03, 0xf2, 0x89, 0x77,
	0x64, 0x53, 0xa6, 0xc0, 0x11, 0x4d, 0x7e, 0x36, 0x9a, 0xe5, 0x08, 0x32, 0xe2, 0x79, 0x0b, 0xe6,
	0x7c, 0x93, 0x98, 0x5d, 0x5a, 0x05, 0xae, 0x98, 0x13, 0xbc, 0xc4, 0x43, 0xb7, 0x5f, 0x6b, 0x72,
	0x1c, 0xf9, 0x69, 0x5f, 0x80, 0xaa, 0x57, 0xa0, 0x14, 0xeb, 0x7e, 0x52, 0x79, 0xb0, 0x18, 0x2f,
	0x6e, 0x7c, 0x81, 0x3b, 0xb6, 0x3e, 0x89, 0x74, 0xae, 0x51, 0x5c, 0xac, 0xc4, 0xe2, 0x62, 0xed,
	0x02, 0x73, 0x77, 0x9e, 0x9f, 0x5e, 0x1d, 0xb5, 0xff, 0x67, 0x1a, 0xdc, 0x5f, 0xf1, 0x58, 0xf4,
	0x73, 0xb0, 0x22, 0xe6, 0x31, 0xef, 0xd9, 0xa3, 0x63, 0x52, 0x29, 0xed, 0x2d, 0x58, 0x1d, 0x9c,
	0x36, 0x51, 0x68, 0xff, 0x0c, 0x94, 0x28, 0x5f, 0x27, 0xaa, 0x99, 0xc2, 0xd1, 0x81, 0xe8, 0x6a,
	0xb8, 0x6d, 0x6f, 0xf3, 0x93, 0x0c, 0x2c, 0x6c, 0x63, 0xb3, 0x7b, 0xd5, 0x95, 0x66, 0x88, 0x7e,
	0xa0, 0xc0, 0x7c, 0xf8, 0x3b, 0x6d, 0xe8, 0x9e, 0xf0, 0x7f, 0x39, 0xf5, 0xca, 0x34, 0x6b, 0xc5,
	0x93, 0x72, 0x6a, 0x43, 0xb9, 0xa0, 0xa0, 0xdf, 0x28, 0xa0, 0x8e, 0xff, 0xc7, 0x2b, 0xba, 0x9e,
	0x12, 0xff, 0x89, 0x7f, 0x9a, 0x55, 0x67, 0xfc, 0x6b, 0x92, 0x76, 0x6a, 0xf3, 0x5d, 0x00, 0x21,
	0x44, 0x5e, 0x42, 0x70, 0x65, 0x29, 0xe1, 0xfc, 0x84, 0x05, 0x09, 0x75, 0xd2, 0x05, 0x42, 0x50,
	0x9b, 0x3f, 0x54, 0xa0, 0x24, 0xe8, 0x45, 0xe4, 0xf3, 0x08, 0xf2, 0xe2, 0xc7, 0x0b, 0x93, 0x44,
	0xc0, 0xa1, 0x34, 0x2e, 0x4d, 0xb6, 0x48, 0xbe, 0xf7, 0x62, 0x27, 0x1f, 0x28, 0xa1, 0x36, 0xed,
	0x09, 0x07, 0x87, 0x1e, 0xc1, 0x7c, 0xf8, 0xf3, 0xd2, 0xa4, 0x6f, 0x3e, 0x7b, 0xe9, 0xd4, 0x8b,
	0xe9, 0x57, 0x85, 0x0f, 0x89, 0xd8, 0xcb, 0xc7, 0x19, 0xa8, 0x8a, 0xbd, 0xd4, 0x1f, 0x05, 0x98,
	0xb8, 0xa6, 0x23, 0xec, 0xa8, 0xe9, 0x09, 0x25, 0x2f, 0xc5, 0x1c, 0x01, 0xba, 0x32, 0xb5, 0x87,
	0x52, 0x5f, 0x9e, 0x66, 0x69, 0x28, 0x35, 0xf4, 0x3d, 0x05, 0xa0, 0xef, 0x32, 0x50, 0xfa, 0x82,
	0xc0, 0x90, 0x5f, 0x52, 0xaf, 0x4c, 0xb1, 0x32, 0xdc, 0xc5, 0xe6, 0xaf, 0x15, 0x40, 0x42, 0x56,
	0x71, 0x5f, 0x83, 0x3e, 0x54, 0xa0, 0x3c, 0xd0, 0x91, 0xf6, 0xff, 0xd6, 0x49, 0x1e, 0x2b, 0xb5,
	0xa0, 0x12, 0xbc, 0xa2, 0xb8, 0xd2, 0xed, 0x2d, 0x78, 0x6e, 0x1c, 0x44, 0x1c, 0x61, 0xbb, 0x28,
	0xce, 0xb2, 0xe5, 0xdb, 0x6f, 0x2e, 0xc6, 0x86, 0x8c, 0xa3, 0x8b, 0x87, 0x73, 0x3c, 0x28, 0x7c,
	0xe1, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x69, 0x48, 0xae, 0x25, 0xdf, 0x30, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// BeamFnControlClient is the client API for BeamFnControl service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnControlClient interface {
	// Instructions sent by the runner to the SDK requesting different types
	// of work.
	Control(ctx context.Context, opts ...grpc.CallOption) (BeamFnControl_ControlClient, error)
	// Used to get the full process bundle descriptors for bundles one
	// is asked to process.
	GetProcessBundleDescriptor(ctx context.Context, in *GetProcessBundleDescriptorRequest, opts ...grpc.CallOption) (*ProcessBundleDescriptor, error)
}

type beamFnControlClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnControlClient(cc *grpc.ClientConn) BeamFnControlClient {
	return &beamFnControlClient{cc}
}

func (c *beamFnControlClient) Control(ctx context.Context, opts ...grpc.CallOption) (BeamFnControl_ControlClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnControl_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnControl/Control", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnControlControlClient{stream}
	return x, nil
}

type BeamFnControl_ControlClient interface {
	Send(*InstructionResponse) error
	Recv() (*InstructionRequest, error)
	grpc.ClientStream
}

type beamFnControlControlClient struct {
	grpc.ClientStream
}

func (x *beamFnControlControlClient) Send(m *InstructionResponse) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnControlControlClient) Recv() (*InstructionRequest, error) {
	m := new(InstructionRequest)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *beamFnControlClient) GetProcessBundleDescriptor(ctx context.Context, in *GetProcessBundleDescriptorRequest, opts ...grpc.CallOption) (*ProcessBundleDescriptor, error) {
	out := new(ProcessBundleDescriptor)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.fn_execution.v1.BeamFnControl/GetProcessBundleDescriptor", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BeamFnControlServer is the server API for BeamFnControl service.
type BeamFnControlServer interface {
	// Instructions sent by the runner to the SDK requesting different types
	// of work.
	Control(BeamFnControl_ControlServer) error
	// Used to get the full process bundle descriptors for bundles one
	// is asked to process.
	GetProcessBundleDescriptor(context.Context, *GetProcessBundleDescriptorRequest) (*ProcessBundleDescriptor, error)
}

// UnimplementedBeamFnControlServer can be embedded to have forward compatible implementations.
type UnimplementedBeamFnControlServer struct {
}

func (*UnimplementedBeamFnControlServer) Control(srv BeamFnControl_ControlServer) error {
	return status.Errorf(codes.Unimplemented, "method Control not implemented")
}
func (*UnimplementedBeamFnControlServer) GetProcessBundleDescriptor(ctx context.Context, req *GetProcessBundleDescriptorRequest) (*ProcessBundleDescriptor, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProcessBundleDescriptor not implemented")
}

func RegisterBeamFnControlServer(s *grpc.Server, srv BeamFnControlServer) {
	s.RegisterService(&_BeamFnControl_serviceDesc, srv)
}

func _BeamFnControl_Control_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnControlServer).Control(&beamFnControlControlServer{stream})
}

type BeamFnControl_ControlServer interface {
	Send(*InstructionRequest) error
	Recv() (*InstructionResponse, error)
	grpc.ServerStream
}

type beamFnControlControlServer struct {
	grpc.ServerStream
}

func (x *beamFnControlControlServer) Send(m *InstructionRequest) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnControlControlServer) Recv() (*InstructionResponse, error) {
	m := new(InstructionResponse)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _BeamFnControl_GetProcessBundleDescriptor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProcessBundleDescriptorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BeamFnControlServer).GetProcessBundleDescriptor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.fn_execution.v1.BeamFnControl/GetProcessBundleDescriptor",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BeamFnControlServer).GetProcessBundleDescriptor(ctx, req.(*GetProcessBundleDescriptorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BeamFnControl_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnControl",
	HandlerType: (*BeamFnControlServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetProcessBundleDescriptor",
			Handler:    _BeamFnControl_GetProcessBundleDescriptor_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Control",
			Handler:       _BeamFnControl_Control_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}

// BeamFnDataClient is the client API for BeamFnData service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnDataClient interface {
	// Used to send data between harnesses.
	Data(ctx context.Context, opts ...grpc.CallOption) (BeamFnData_DataClient, error)
}

type beamFnDataClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnDataClient(cc *grpc.ClientConn) BeamFnDataClient {
	return &beamFnDataClient{cc}
}

func (c *beamFnDataClient) Data(ctx context.Context, opts ...grpc.CallOption) (BeamFnData_DataClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnData_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnData/Data", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnDataDataClient{stream}
	return x, nil
}

type BeamFnData_DataClient interface {
	Send(*Elements) error
	Recv() (*Elements, error)
	grpc.ClientStream
}

type beamFnDataDataClient struct {
	grpc.ClientStream
}

func (x *beamFnDataDataClient) Send(m *Elements) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnDataDataClient) Recv() (*Elements, error) {
	m := new(Elements)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnDataServer is the server API for BeamFnData service.
type BeamFnDataServer interface {
	// Used to send data between harnesses.
	Data(BeamFnData_DataServer) error
}

// UnimplementedBeamFnDataServer can be embedded to have forward compatible implementations.
type UnimplementedBeamFnDataServer struct {
}

func (*UnimplementedBeamFnDataServer) Data(srv BeamFnData_DataServer) error {
	return status.Errorf(codes.Unimplemented, "method Data not implemented")
}

func RegisterBeamFnDataServer(s *grpc.Server, srv BeamFnDataServer) {
	s.RegisterService(&_BeamFnData_serviceDesc, srv)
}

func _BeamFnData_Data_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnDataServer).Data(&beamFnDataDataServer{stream})
}

type BeamFnData_DataServer interface {
	Send(*Elements) error
	Recv() (*Elements, error)
	grpc.ServerStream
}

type beamFnDataDataServer struct {
	grpc.ServerStream
}

func (x *beamFnDataDataServer) Send(m *Elements) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnDataDataServer) Recv() (*Elements, error) {
	m := new(Elements)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnData_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnData",
	HandlerType: (*BeamFnDataServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Data",
			Handler:       _BeamFnData_Data_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}

// BeamFnStateClient is the client API for BeamFnState service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnStateClient interface {
	// Used to get/append/clear state stored by the runner on behalf of the SDK.
	State(ctx context.Context, opts ...grpc.CallOption) (BeamFnState_StateClient, error)
}

type beamFnStateClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnStateClient(cc *grpc.ClientConn) BeamFnStateClient {
	return &beamFnStateClient{cc}
}

func (c *beamFnStateClient) State(ctx context.Context, opts ...grpc.CallOption) (BeamFnState_StateClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnState_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnState/State", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnStateStateClient{stream}
	return x, nil
}

type BeamFnState_StateClient interface {
	Send(*StateRequest) error
	Recv() (*StateResponse, error)
	grpc.ClientStream
}

type beamFnStateStateClient struct {
	grpc.ClientStream
}

func (x *beamFnStateStateClient) Send(m *StateRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnStateStateClient) Recv() (*StateResponse, error) {
	m := new(StateResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnStateServer is the server API for BeamFnState service.
type BeamFnStateServer interface {
	// Used to get/append/clear state stored by the runner on behalf of the SDK.
	State(BeamFnState_StateServer) error
}

// UnimplementedBeamFnStateServer can be embedded to have forward compatible implementations.
type UnimplementedBeamFnStateServer struct {
}

func (*UnimplementedBeamFnStateServer) State(srv BeamFnState_StateServer) error {
	return status.Errorf(codes.Unimplemented, "method State not implemented")
}

func RegisterBeamFnStateServer(s *grpc.Server, srv BeamFnStateServer) {
	s.RegisterService(&_BeamFnState_serviceDesc, srv)
}

func _BeamFnState_State_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnStateServer).State(&beamFnStateStateServer{stream})
}

type BeamFnState_StateServer interface {
	Send(*StateResponse) error
	Recv() (*StateRequest, error)
	grpc.ServerStream
}

type beamFnStateStateServer struct {
	grpc.ServerStream
}

func (x *beamFnStateStateServer) Send(m *StateResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnStateStateServer) Recv() (*StateRequest, error) {
	m := new(StateRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnState_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnState",
	HandlerType: (*BeamFnStateServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "State",
			Handler:       _BeamFnState_State_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}

// BeamFnLoggingClient is the client API for BeamFnLogging service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnLoggingClient interface {
	// Allows for the SDK to emit log entries which the runner can
	// associate with the active job.
	Logging(ctx context.Context, opts ...grpc.CallOption) (BeamFnLogging_LoggingClient, error)
}

type beamFnLoggingClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnLoggingClient(cc *grpc.ClientConn) BeamFnLoggingClient {
	return &beamFnLoggingClient{cc}
}

func (c *beamFnLoggingClient) Logging(ctx context.Context, opts ...grpc.CallOption) (BeamFnLogging_LoggingClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnLogging_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnLogging/Logging", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnLoggingLoggingClient{stream}
	return x, nil
}

type BeamFnLogging_LoggingClient interface {
	Send(*LogEntry_List) error
	Recv() (*LogControl, error)
	grpc.ClientStream
}

type beamFnLoggingLoggingClient struct {
	grpc.ClientStream
}

func (x *beamFnLoggingLoggingClient) Send(m *LogEntry_List) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnLoggingLoggingClient) Recv() (*LogControl, error) {
	m := new(LogControl)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnLoggingServer is the server API for BeamFnLogging service.
type BeamFnLoggingServer interface {
	// Allows for the SDK to emit log entries which the runner can
	// associate with the active job.
	Logging(BeamFnLogging_LoggingServer) error
}

// UnimplementedBeamFnLoggingServer can be embedded to have forward compatible implementations.
type UnimplementedBeamFnLoggingServer struct {
}

func (*UnimplementedBeamFnLoggingServer) Logging(srv BeamFnLogging_LoggingServer) error {
	return status.Errorf(codes.Unimplemented, "method Logging not implemented")
}

func RegisterBeamFnLoggingServer(s *grpc.Server, srv BeamFnLoggingServer) {
	s.RegisterService(&_BeamFnLogging_serviceDesc, srv)
}

func _BeamFnLogging_Logging_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnLoggingServer).Logging(&beamFnLoggingLoggingServer{stream})
}

type BeamFnLogging_LoggingServer interface {
	Send(*LogControl) error
	Recv() (*LogEntry_List, error)
	grpc.ServerStream
}

type beamFnLoggingLoggingServer struct {
	grpc.ServerStream
}

func (x *beamFnLoggingLoggingServer) Send(m *LogControl) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnLoggingLoggingServer) Recv() (*LogEntry_List, error) {
	m := new(LogEntry_List)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnLogging_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnLogging",
	HandlerType: (*BeamFnLoggingServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Logging",
			Handler:       _BeamFnLogging_Logging_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}

// BeamFnExternalWorkerPoolClient is the client API for BeamFnExternalWorkerPool service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnExternalWorkerPoolClient interface {
	// Start the SDK worker with the given ID.
	StartWorker(ctx context.Context, in *StartWorkerRequest, opts ...grpc.CallOption) (*StartWorkerResponse, error)
	// Stop the SDK worker.
	StopWorker(ctx context.Context, in *StopWorkerRequest, opts ...grpc.CallOption) (*StopWorkerResponse, error)
}

type beamFnExternalWorkerPoolClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnExternalWorkerPoolClient(cc *grpc.ClientConn) BeamFnExternalWorkerPoolClient {
	return &beamFnExternalWorkerPoolClient{cc}
}

func (c *beamFnExternalWorkerPoolClient) StartWorker(ctx context.Context, in *StartWorkerRequest, opts ...grpc.CallOption) (*StartWorkerResponse, error) {
	out := new(StartWorkerResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool/StartWorker", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beamFnExternalWorkerPoolClient) StopWorker(ctx context.Context, in *StopWorkerRequest, opts ...grpc.CallOption) (*StopWorkerResponse, error) {
	out := new(StopWorkerResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool/StopWorker", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BeamFnExternalWorkerPoolServer is the server API for BeamFnExternalWorkerPool service.
type BeamFnExternalWorkerPoolServer interface {
	// Start the SDK worker with the given ID.
	StartWorker(context.Context, *StartWorkerRequest) (*StartWorkerResponse, error)
	// Stop the SDK worker.
	StopWorker(context.Context, *StopWorkerRequest) (*StopWorkerResponse, error)
}

// UnimplementedBeamFnExternalWorkerPoolServer can be embedded to have forward compatible implementations.
type UnimplementedBeamFnExternalWorkerPoolServer struct {
}

func (*UnimplementedBeamFnExternalWorkerPoolServer) StartWorker(ctx context.Context, req *StartWorkerRequest) (*StartWorkerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartWorker not implemented")
}
func (*UnimplementedBeamFnExternalWorkerPoolServer) StopWorker(ctx context.Context, req *StopWorkerRequest) (*StopWorkerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopWorker not implemented")
}

func RegisterBeamFnExternalWorkerPoolServer(s *grpc.Server, srv BeamFnExternalWorkerPoolServer) {
	s.RegisterService(&_BeamFnExternalWorkerPool_serviceDesc, srv)
}

func _BeamFnExternalWorkerPool_StartWorker_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartWorkerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BeamFnExternalWorkerPoolServer).StartWorker(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool/StartWorker",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BeamFnExternalWorkerPoolServer).StartWorker(ctx, req.(*StartWorkerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BeamFnExternalWorkerPool_StopWorker_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopWorkerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BeamFnExternalWorkerPoolServer).StopWorker(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool/StopWorker",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BeamFnExternalWorkerPoolServer).StopWorker(ctx, req.(*StopWorkerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BeamFnExternalWorkerPool_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool",
	HandlerType: (*BeamFnExternalWorkerPoolServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "StartWorker",
			Handler:    _BeamFnExternalWorkerPool_StartWorker_Handler,
		},
		{
			MethodName: "StopWorker",
			Handler:    _BeamFnExternalWorkerPool_StopWorker_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "beam_fn_api.proto",
}

// BeamFnWorkerStatusClient is the client API for BeamFnWorkerStatus service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnWorkerStatusClient interface {
	WorkerStatus(ctx context.Context, opts ...grpc.CallOption) (BeamFnWorkerStatus_WorkerStatusClient, error)
}

type beamFnWorkerStatusClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnWorkerStatusClient(cc *grpc.ClientConn) BeamFnWorkerStatusClient {
	return &beamFnWorkerStatusClient{cc}
}

func (c *beamFnWorkerStatusClient) WorkerStatus(ctx context.Context, opts ...grpc.CallOption) (BeamFnWorkerStatus_WorkerStatusClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnWorkerStatus_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnWorkerStatus/WorkerStatus", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnWorkerStatusWorkerStatusClient{stream}
	return x, nil
}

type BeamFnWorkerStatus_WorkerStatusClient interface {
	Send(*WorkerStatusResponse) error
	Recv() (*WorkerStatusRequest, error)
	grpc.ClientStream
}

type beamFnWorkerStatusWorkerStatusClient struct {
	grpc.ClientStream
}

func (x *beamFnWorkerStatusWorkerStatusClient) Send(m *WorkerStatusResponse) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnWorkerStatusWorkerStatusClient) Recv() (*WorkerStatusRequest, error) {
	m := new(WorkerStatusRequest)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnWorkerStatusServer is the server API for BeamFnWorkerStatus service.
type BeamFnWorkerStatusServer interface {
	WorkerStatus(BeamFnWorkerStatus_WorkerStatusServer) error
}

// UnimplementedBeamFnWorkerStatusServer can be embedded to have forward compatible implementations.
type UnimplementedBeamFnWorkerStatusServer struct {
}

func (*UnimplementedBeamFnWorkerStatusServer) WorkerStatus(srv BeamFnWorkerStatus_WorkerStatusServer) error {
	return status.Errorf(codes.Unimplemented, "method WorkerStatus not implemented")
}

func RegisterBeamFnWorkerStatusServer(s *grpc.Server, srv BeamFnWorkerStatusServer) {
	s.RegisterService(&_BeamFnWorkerStatus_serviceDesc, srv)
}

func _BeamFnWorkerStatus_WorkerStatus_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnWorkerStatusServer).WorkerStatus(&beamFnWorkerStatusWorkerStatusServer{stream})
}

type BeamFnWorkerStatus_WorkerStatusServer interface {
	Send(*WorkerStatusRequest) error
	Recv() (*WorkerStatusResponse, error)
	grpc.ServerStream
}

type beamFnWorkerStatusWorkerStatusServer struct {
	grpc.ServerStream
}

func (x *beamFnWorkerStatusWorkerStatusServer) Send(m *WorkerStatusRequest) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnWorkerStatusWorkerStatusServer) Recv() (*WorkerStatusResponse, error) {
	m := new(WorkerStatusResponse)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnWorkerStatus_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnWorkerStatus",
	HandlerType: (*BeamFnWorkerStatusServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "WorkerStatus",
			Handler:       _BeamFnWorkerStatus_WorkerStatus_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}
