---
layout: section
title: "Videos and Podcasts"
permalink: /documentation/resources/videos-and-podcasts/
section_menu: section-menu/documentation.html
redirect_from:
  - /learn/resources/
  - /documentation/resources/
---
<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->
# Videos and Podcasts

This page provides links to some of our favorite videos and podcasts that will help you get started and learn more about Apache Beam.

* TOC
{:toc}

## General

The following resources provide general overviews and fundamentals of Apache Beam.

### Fundamentals of Stream Processing with Apache Beam

Data Science Summit, Jerusalem, 2016

Presented by Tyler Akidau, *Apache Beam PPMC member*  

<iframe width="560" height="315" src="https://www.youtube.com/embed/V35MwYcXEX0" frameborder="0" allowfullscreen></iframe>
<br>

### Apache Beam: A Unified Model for Batch and Streaming Data Processing

Hadoop Summit, San Jose, CA, 2016

Presented by Davor Bonaci, *Apache Beam PPMC member*

<iframe width="560" height="315" src="https://www.youtube.com/embed/7DZ8ONmeP5A" frameborder="0" allowfullscreen></iframe>
<br>

### Fundamentals of Stream Processing with Apache Beam

@Scale Conference, San Jose, CA, 2016

Presented by Dan Halperin, *Apache Beam PPMC member*  

<iframe src="https://www.facebook.com/plugins/video.php?href=https%3A%2F%2Fwww.facebook.com%2Fatscaleevents%2Fvideos%2F1775945569345206%2F&show_text=0&width=560" width="560" height="315" style="border:none;overflow:hidden" scrolling="no" frameborder="0" allowTransparency="true" allowFullScreen="true"></iframe>
<br>

### Software Engineering Radio Podcast Episode 272: Apache Beam

Presented by Frances Perry, *Apache Beam PPMC member*

<a href="http://www.se-radio.net/2016/10/se-radio-episode-272-frances-perry-on-apache-beam/" target="_blank">![alt text]({{ site.baseurl }}/images/resources/se-radio-podcast.png)</a>
<br>

## Beam & Friends

The following resources present Apache Beam partnerships.

### Flink and Beam: Current State & Roadmap

Flink Forward, Berlin, 2016

Presented by Maximilian Michels, *Apache Beam PPMC member*

<iframe width="560" height="315" src="https://www.youtube.com/embed/msdjh6KRXC8" frameborder="0" allowfullscreen></iframe>
<br>

### Lessons learned from developing a stream processing platform at scale

Big Things Meetup, Tel Aviv, 2016

By Amit Sela, *Apache Beam PPMC member*

<iframe width="560" height="315" src="https://www.youtube.com/embed/fc-YigLn_gs" frameborder="0" allowfullscreen></iframe>
<br>

## Technical Details

The following resources provide detailed explanations about technical concepts in Apache Beam.

### Watermarks: Time and Progress in Apache Beam and Beyond

Strata+Hadoop World, New York, 2016

Presented by Slava Chernyak, *Software Engineer at Google*

<iframe width="560" height="315" src="https://www.youtube.com/embed/TWxSLmkWPm4" frameborder="0" allowfullscreen></iframe>
<br>

### Triggers in Apache Beam

Strata+Hadoop World, New York, 2016

Presented by Kenneth Knowles, *Apache Beam PPMC member*

<iframe width="560" height="315" src="https://www.youtube.com/embed/E1k0B9LN46M" frameborder="0" allowfullscreen></iframe>

### Nexmark Evaluating Big Data systems with Apache Beam

ApacheCon, Miami, 2017

Presented by Etienne Chauchot and Ismaël Mejia, *Apache Beam PMC members*

<iframe src="//www.slideshare.net/slideshow/embed_code/key/auWXjEK7GTkiUK" width="595" height="485" frameborder="0" marginwidth="0" marginheight="0" scrolling="no" style="border:1px solid #CCC; border-width:1px; margin-bottom:5px; max-width: 100%;" allowfullscreen> </iframe> <div style="margin-bottom:5px"> <strong> <a href="//www.slideshare.net/EtienneChauchot/nexmark-with-beam" title="Nexmark with Beam" target="_blank">Nexmark with Beam</a> </strong> by <strong><a href="https://www.slideshare.net/EtienneChauchot" target="_blank">Etienne Chauchot</a></strong> </div>
<audio controls>
  <source src="https://feathercastapache.files.wordpress.com/2017/05/0517-04-mejia.mp3" type="audio/mpeg">
Your browser does not support the audio element.
</audio>
### Universal metrics with Apache Beam

ApacheCon, Montreal, 2018

Presented by Etienne Chauchot, *Apache Beam PMC member*

<iframe src="//www.slideshare.net/slideshow/embed_code/key/kKJRzR8HxkxLsR" width="595" height="485" frameborder="0" marginwidth="0" marginheight="0" scrolling="no" style="border:1px solid #CCC; border-width:1px; margin-bottom:5px; max-width: 100%;" allowfullscreen> </iframe> <div style="margin-bottom:5px"> <strong> <a href="//www.slideshare.net/EtienneChauchot/universal-metrics-with-apache-beam" title="Universal metrics with Apache Beam" target="_blank">Universal metrics with Apache Beam</a> </strong> by <strong><a href="https://www.slideshare.net/EtienneChauchot" target="_blank">Etienne Chauchot</a></strong> </div>
<audio controls>
  <source src="//feathercastapache.files.wordpress.com/2018/09/03-universal-metrics-with-beam-etienne-chauchot.mp3" type="audio/mpeg">
Your browser does not support the audio element.
</audio>

## Next Steps

* Take a self-paced tour through our [Learning Resources]({{ site.baseurl }}/documentation/resources/learning-resources).