// Code generated by protoc-gen-go. DO NOT EDIT.
// source: beam_artifact_api.proto

package jobmanagement_v1

import (
	context "context"
	fmt "fmt"
	_ "github.com/apache/beam/sdks/go/pkg/beam/model/pipeline_v1"
	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type CommitManifestResponse_Constants int32

const (
	// Token indicating that no artifacts were staged and therefore no retrieval attempt is necessary.
	CommitManifestResponse_NO_ARTIFACTS_STAGED_TOKEN CommitManifestResponse_Constants = 0
)

var CommitManifestResponse_Constants_name = map[int32]string{
	0: "NO_ARTIFACTS_STAGED_TOKEN",
}

var CommitManifestResponse_Constants_value = map[string]int32{
	"NO_ARTIFACTS_STAGED_TOKEN": 0,
}

func (x CommitManifestResponse_Constants) String() string {
	return proto.EnumName(CommitManifestResponse_Constants_name, int32(x))
}

func (CommitManifestResponse_Constants) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8ef4db42c81e3972, []int{11, 0}
}

// An artifact identifier and associated metadata.
type ArtifactMetadata struct {
	// (Required) The name of the artifact.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// (Optional) The Unix-like permissions of the artifact
	Permissions uint32 `protobuf:"varint,2,opt,name=permissions,proto3" json:"permissions,omitempty"`
	// (Optional) The hex-encoded sha256 checksum of the artifact. Used, among other things, by
	// harness boot code to validate the integrity of the artifact.
	Sha256               string   `protobuf:"bytes,4,opt,name=sha256,proto3" json:"sha256,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ArtifactMetadata) Reset()         { *m = ArtifactMetadata{} }
func (m *ArtifactMetadata) String() string { return proto.CompactTextString(m) }
func (*ArtifactMetadata) ProtoMessage()    {}
func (*ArtifactMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ef4db42c81e3972, []int{0}
}

func (m *ArtifactMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ArtifactMetadata.Unmarshal(m, b)
}
func (m *ArtifactMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ArtifactMetadata.Marshal(b, m, deterministic)
}
func (m *ArtifactMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ArtifactMetadata.Merge(m, src)
}
func (m *ArtifactMetadata) XXX_Size() int {
	return xxx_messageInfo_ArtifactMetadata.Size(m)
}
func (m *ArtifactMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ArtifactMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ArtifactMetadata proto.InternalMessageInfo

func (m *ArtifactMetadata) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ArtifactMetadata) GetPermissions() uint32 {
	if m != nil {
		return m.Permissions
	}
	return 0
}

func (m *ArtifactMetadata) GetSha256() string {
	if m != nil {
		return m.Sha256
	}
	return ""
}

// A collection of artifacts.
type Manifest struct {
	Artifact             []*ArtifactMetadata `protobuf:"bytes,1,rep,name=artifact,proto3" json:"artifact,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Manifest) Reset()         { *m = Manifest{} }
func (m *Manifest) String() string { return proto.CompactTextString(m) }
func (*Manifest) ProtoMessage()    {}
func (*Manifest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ef4db42c81e3972, []int{1}
}

func (m *Manifest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Manifest.Unmarshal(m, b)
}
func (m *Manifest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Manifest.Marshal(b, m, deterministic)
}
func (m *Manifest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Manifest.Merge(m, src)
}
func (m *Manifest) XXX_Size() int {
	return xxx_messageInfo_Manifest.Size(m)
}
func (m *Manifest) XXX_DiscardUnknown() {
	xxx_messageInfo_Manifest.DiscardUnknown(m)
}

var xxx_messageInfo_Manifest proto.InternalMessageInfo

func (m *Manifest) GetArtifact() []*ArtifactMetadata {
	if m != nil {
		return m.Artifact
	}
	return nil
}

// A manifest with location information.
type ProxyManifest struct {
	Manifest             *Manifest                 `protobuf:"bytes,1,opt,name=manifest,proto3" json:"manifest,omitempty"`
	Location             []*ProxyManifest_Location `protobuf:"bytes,2,rep,name=location,proto3" json:"location,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *ProxyManifest) Reset()         { *m = ProxyManifest{} }
func (m *ProxyManifest) String() string { return proto.CompactTextString(m) }
func (*ProxyManifest) ProtoMessage()    {}
func (*ProxyManifest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ef4db42c81e3972, []int{2}
}

func (m *ProxyManifest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProxyManifest.Unmarshal(m, b)
}
func (m *ProxyManifest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProxyManifest.Marshal(b, m, deterministic)
}
func (m *ProxyManifest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProxyManifest.Merge(m, src)
}
func (m *ProxyManifest) XXX_Size() int {
	return xxx_messageInfo_ProxyManifest.Size(m)
}
func (m *ProxyManifest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProxyManifest.DiscardUnknown(m)
}

var xxx_messageInfo_ProxyManifest proto.InternalMessageInfo

func (m *ProxyManifest) GetManifest() *Manifest {
	if m != nil {
		return m.Manifest
	}
	return nil
}

func (m *ProxyManifest) GetLocation() []*ProxyManifest_Location {
	if m != nil {
		return m.Location
	}
	return nil
}

type ProxyManifest_Location struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Uri                  string   `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProxyManifest_Location) Reset()         { *m = ProxyManifest_Location{} }
func (m *ProxyManifest_Location) String() string { return proto.CompactTextString(m) }
func (*ProxyManifest_Location) ProtoMessage()    {}
func (*ProxyManifest_Location) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ef4db42c81e3972, []int{2, 0}
}

func (m *ProxyManifest_Location) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProxyManifest_Location.Unmarshal(m, b)
}
func (m *ProxyManifest_Location) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProxyManifest_Location.Marshal(b, m, deterministic)
}
func (m *ProxyManifest_Location) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProxyManifest_Location.Merge(m, src)
}
func (m *ProxyManifest_Location) XXX_Size() int {
	return xxx_messageInfo_ProxyManifest_Location.Size(m)
}
func (m *ProxyManifest_Location) XXX_DiscardUnknown() {
	xxx_messageInfo_ProxyManifest_Location.DiscardUnknown(m)
}

var xxx_messageInfo_ProxyManifest_Location proto.InternalMessageInfo

func (m *ProxyManifest_Location) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ProxyManifest_Location) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// A request to get the manifest of a Job.
type GetManifestRequest struct {
	// (Required) An opaque token representing the entirety of the staged artifacts.
	// Returned in CommitManifestResponse.
	RetrievalToken       string   `protobuf:"bytes,1,opt,name=retrieval_token,json=retrievalToken,proto3" json:"retrieval_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetManifestRequest) Reset()         { *m = GetManifestRequest{} }
func (m *GetManifestRequest) String() string { return proto.CompactTextString(m) }
func (*GetManifestRequest) ProtoMessage()    {}
func (*GetManifestRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ef4db42c81e3972, []int{3}
}

func (m *GetManifestRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetManifestRequest.Unmarshal(m, b)
}
func (m *GetManifestRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetManifestRequest.Marshal(b, m, deterministic)
}
func (m *GetManifestRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetManifestRequest.Merge(m, src)
}
func (m *GetManifestRequest) XXX_Size() int {
	return xxx_messageInfo_GetManifestRequest.Size(m)
}
func (m *GetManifestRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetManifestRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetManifestRequest proto.InternalMessageInfo

func (m *GetManifestRequest) GetRetrievalToken() string {
	if m != nil {
		return m.RetrievalToken
	}
	return ""
}

// A response containing a job manifest.
type GetManifestResponse struct {
	Manifest             *Manifest `protobuf:"bytes,1,opt,name=manifest,proto3" json:"manifest,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *GetManifestResponse) Reset()         { *m = GetManifestResponse{} }
func (m *GetManifestResponse) String() string { return proto.CompactTextString(m) }
func (*GetManifestResponse) ProtoMessage()    {}
func (*GetManifestResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ef4db42c81e3972, []int{4}
}

func (m *GetManifestResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetManifestResponse.Unmarshal(m, b)
}
func (m *GetManifestResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetManifestResponse.Marshal(b, m, deterministic)
}
func (m *GetManifestResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetManifestResponse.Merge(m, src)
}
func (m *GetManifestResponse) XXX_Size() int {
	return xxx_messageInfo_GetManifestResponse.Size(m)
}
func (m *GetManifestResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetManifestResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetManifestResponse proto.InternalMessageInfo

func (m *GetManifestResponse) GetManifest() *Manifest {
	if m != nil {
		return m.Manifest
	}
	return nil
}

// A request to get an artifact. The artifact must be present in the manifest for the job.
type GetArtifactRequest struct {
	// (Required) The name of the artifact to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// (Required) An opaque token representing the entirety of the staged artifacts.
	// Returned in CommitManifestResponse.
	RetrievalToken       string   `protobuf:"bytes,2,opt,name=retrieval_token,json=retrievalToken,proto3" json:"retrieval_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetArtifactRequest) Reset()         { *m = GetArtifactRequest{} }
func (m *GetArtifactRequest) String() string { return proto.CompactTextString(m) }
func (*GetArtifactRequest) ProtoMessage()    {}
func (*GetArtifactRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ef4db42c81e3972, []int{5}
}

func (m *GetArtifactRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetArtifactRequest.Unmarshal(m, b)
}
func (m *GetArtifactRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetArtifactRequest.Marshal(b, m, deterministic)
}
func (m *GetArtifactRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetArtifactRequest.Merge(m, src)
}
func (m *GetArtifactRequest) XXX_Size() int {
	return xxx_messageInfo_GetArtifactRequest.Size(m)
}
func (m *GetArtifactRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetArtifactRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetArtifactRequest proto.InternalMessageInfo

func (m *GetArtifactRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetArtifactRequest) GetRetrievalToken() string {
	if m != nil {
		return m.RetrievalToken
	}
	return ""
}

// Part of an artifact.
type ArtifactChunk struct {
	Data                 []byte   `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ArtifactChunk) Reset()         { *m = ArtifactChunk{} }
func (m *ArtifactChunk) String() string { return proto.CompactTextString(m) }
func (*ArtifactChunk) ProtoMessage()    {}
func (*ArtifactChunk) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ef4db42c81e3972, []int{6}
}

func (m *ArtifactChunk) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ArtifactChunk.Unmarshal(m, b)
}
func (m *ArtifactChunk) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ArtifactChunk.Marshal(b, m, deterministic)
}
func (m *ArtifactChunk) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ArtifactChunk.Merge(m, src)
}
func (m *ArtifactChunk) XXX_Size() int {
	return xxx_messageInfo_ArtifactChunk.Size(m)
}
func (m *ArtifactChunk) XXX_DiscardUnknown() {
	xxx_messageInfo_ArtifactChunk.DiscardUnknown(m)
}

var xxx_messageInfo_ArtifactChunk proto.InternalMessageInfo

func (m *ArtifactChunk) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type PutArtifactMetadata struct {
	// (Required) A token for artifact staging session. This token can be obtained
	// from PrepareJob request in JobService
	StagingSessionToken string `protobuf:"bytes,1,opt,name=staging_session_token,json=stagingSessionToken,proto3" json:"staging_session_token,omitempty"`
	// (Required) The Artifact metadata.
	Metadata             *ArtifactMetadata `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PutArtifactMetadata) Reset()         { *m = PutArtifactMetadata{} }
func (m *PutArtifactMetadata) String() string { return proto.CompactTextString(m) }
func (*PutArtifactMetadata) ProtoMessage()    {}
func (*PutArtifactMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ef4db42c81e3972, []int{7}
}

func (m *PutArtifactMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PutArtifactMetadata.Unmarshal(m, b)
}
func (m *PutArtifactMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PutArtifactMetadata.Marshal(b, m, deterministic)
}
func (m *PutArtifactMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PutArtifactMetadata.Merge(m, src)
}
func (m *PutArtifactMetadata) XXX_Size() int {
	return xxx_messageInfo_PutArtifactMetadata.Size(m)
}
func (m *PutArtifactMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_PutArtifactMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_PutArtifactMetadata proto.InternalMessageInfo

func (m *PutArtifactMetadata) GetStagingSessionToken() string {
	if m != nil {
		return m.StagingSessionToken
	}
	return ""
}

func (m *PutArtifactMetadata) GetMetadata() *ArtifactMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// A request to stage an artifact.
type PutArtifactRequest struct {
	// (Required)
	//
	// Types that are valid to be assigned to Content:
	//	*PutArtifactRequest_Metadata
	//	*PutArtifactRequest_Data
	Content              isPutArtifactRequest_Content `protobuf_oneof:"content"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *PutArtifactRequest) Reset()         { *m = PutArtifactRequest{} }
func (m *PutArtifactRequest) String() string { return proto.CompactTextString(m) }
func (*PutArtifactRequest) ProtoMessage()    {}
func (*PutArtifactRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ef4db42c81e3972, []int{8}
}

func (m *PutArtifactRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PutArtifactRequest.Unmarshal(m, b)
}
func (m *PutArtifactRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PutArtifactRequest.Marshal(b, m, deterministic)
}
func (m *PutArtifactRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PutArtifactRequest.Merge(m, src)
}
func (m *PutArtifactRequest) XXX_Size() int {
	return xxx_messageInfo_PutArtifactRequest.Size(m)
}
func (m *PutArtifactRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PutArtifactRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PutArtifactRequest proto.InternalMessageInfo

type isPutArtifactRequest_Content interface {
	isPutArtifactRequest_Content()
}

type PutArtifactRequest_Metadata struct {
	Metadata *PutArtifactMetadata `protobuf:"bytes,1,opt,name=metadata,proto3,oneof"`
}

type PutArtifactRequest_Data struct {
	Data *ArtifactChunk `protobuf:"bytes,2,opt,name=data,proto3,oneof"`
}

func (*PutArtifactRequest_Metadata) isPutArtifactRequest_Content() {}

func (*PutArtifactRequest_Data) isPutArtifactRequest_Content() {}

func (m *PutArtifactRequest) GetContent() isPutArtifactRequest_Content {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *PutArtifactRequest) GetMetadata() *PutArtifactMetadata {
	if x, ok := m.GetContent().(*PutArtifactRequest_Metadata); ok {
		return x.Metadata
	}
	return nil
}

func (m *PutArtifactRequest) GetData() *ArtifactChunk {
	if x, ok := m.GetContent().(*PutArtifactRequest_Data); ok {
		return x.Data
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PutArtifactRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PutArtifactRequest_Metadata)(nil),
		(*PutArtifactRequest_Data)(nil),
	}
}

type PutArtifactResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PutArtifactResponse) Reset()         { *m = PutArtifactResponse{} }
func (m *PutArtifactResponse) String() string { return proto.CompactTextString(m) }
func (*PutArtifactResponse) ProtoMessage()    {}
func (*PutArtifactResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ef4db42c81e3972, []int{9}
}

func (m *PutArtifactResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PutArtifactResponse.Unmarshal(m, b)
}
func (m *PutArtifactResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PutArtifactResponse.Marshal(b, m, deterministic)
}
func (m *PutArtifactResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PutArtifactResponse.Merge(m, src)
}
func (m *PutArtifactResponse) XXX_Size() int {
	return xxx_messageInfo_PutArtifactResponse.Size(m)
}
func (m *PutArtifactResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PutArtifactResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PutArtifactResponse proto.InternalMessageInfo

// A request to commit the manifest for a Job. All artifacts must have been successfully uploaded
// before this call is made.
type CommitManifestRequest struct {
	// (Required) The manifest to commit.
	Manifest *Manifest `protobuf:"bytes,1,opt,name=manifest,proto3" json:"manifest,omitempty"`
	// (Required) A token for artifact staging session. This token can be obtained
	// from PrepareJob request in JobService
	StagingSessionToken  string   `protobuf:"bytes,2,opt,name=staging_session_token,json=stagingSessionToken,proto3" json:"staging_session_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommitManifestRequest) Reset()         { *m = CommitManifestRequest{} }
func (m *CommitManifestRequest) String() string { return proto.CompactTextString(m) }
func (*CommitManifestRequest) ProtoMessage()    {}
func (*CommitManifestRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ef4db42c81e3972, []int{10}
}

func (m *CommitManifestRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitManifestRequest.Unmarshal(m, b)
}
func (m *CommitManifestRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitManifestRequest.Marshal(b, m, deterministic)
}
func (m *CommitManifestRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitManifestRequest.Merge(m, src)
}
func (m *CommitManifestRequest) XXX_Size() int {
	return xxx_messageInfo_CommitManifestRequest.Size(m)
}
func (m *CommitManifestRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitManifestRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CommitManifestRequest proto.InternalMessageInfo

func (m *CommitManifestRequest) GetManifest() *Manifest {
	if m != nil {
		return m.Manifest
	}
	return nil
}

func (m *CommitManifestRequest) GetStagingSessionToken() string {
	if m != nil {
		return m.StagingSessionToken
	}
	return ""
}

// The result of committing a manifest.
type CommitManifestResponse struct {
	// (Required) An opaque token representing the entirety of the staged artifacts.
	// This can be used to retrieve the manifest and artifacts from an associated
	// ArtifactRetrievalService.
	RetrievalToken       string   `protobuf:"bytes,1,opt,name=retrieval_token,json=retrievalToken,proto3" json:"retrieval_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommitManifestResponse) Reset()         { *m = CommitManifestResponse{} }
func (m *CommitManifestResponse) String() string { return proto.CompactTextString(m) }
func (*CommitManifestResponse) ProtoMessage()    {}
func (*CommitManifestResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ef4db42c81e3972, []int{11}
}

func (m *CommitManifestResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommitManifestResponse.Unmarshal(m, b)
}
func (m *CommitManifestResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommitManifestResponse.Marshal(b, m, deterministic)
}
func (m *CommitManifestResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommitManifestResponse.Merge(m, src)
}
func (m *CommitManifestResponse) XXX_Size() int {
	return xxx_messageInfo_CommitManifestResponse.Size(m)
}
func (m *CommitManifestResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommitManifestResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommitManifestResponse proto.InternalMessageInfo

func (m *CommitManifestResponse) GetRetrievalToken() string {
	if m != nil {
		return m.RetrievalToken
	}
	return ""
}

func init() {
	proto.RegisterEnum("org.apache.beam.model.job_management.v1.CommitManifestResponse_Constants", CommitManifestResponse_Constants_name, CommitManifestResponse_Constants_value)
	proto.RegisterType((*ArtifactMetadata)(nil), "org.apache.beam.model.job_management.v1.ArtifactMetadata")
	proto.RegisterType((*Manifest)(nil), "org.apache.beam.model.job_management.v1.Manifest")
	proto.RegisterType((*ProxyManifest)(nil), "org.apache.beam.model.job_management.v1.ProxyManifest")
	proto.RegisterType((*ProxyManifest_Location)(nil), "org.apache.beam.model.job_management.v1.ProxyManifest.Location")
	proto.RegisterType((*GetManifestRequest)(nil), "org.apache.beam.model.job_management.v1.GetManifestRequest")
	proto.RegisterType((*GetManifestResponse)(nil), "org.apache.beam.model.job_management.v1.GetManifestResponse")
	proto.RegisterType((*GetArtifactRequest)(nil), "org.apache.beam.model.job_management.v1.GetArtifactRequest")
	proto.RegisterType((*ArtifactChunk)(nil), "org.apache.beam.model.job_management.v1.ArtifactChunk")
	proto.RegisterType((*PutArtifactMetadata)(nil), "org.apache.beam.model.job_management.v1.PutArtifactMetadata")
	proto.RegisterType((*PutArtifactRequest)(nil), "org.apache.beam.model.job_management.v1.PutArtifactRequest")
	proto.RegisterType((*PutArtifactResponse)(nil), "org.apache.beam.model.job_management.v1.PutArtifactResponse")
	proto.RegisterType((*CommitManifestRequest)(nil), "org.apache.beam.model.job_management.v1.CommitManifestRequest")
	proto.RegisterType((*CommitManifestResponse)(nil), "org.apache.beam.model.job_management.v1.CommitManifestResponse")
}

func init() { proto.RegisterFile("beam_artifact_api.proto", fileDescriptor_8ef4db42c81e3972) }

var fileDescriptor_8ef4db42c81e3972 = []byte{
	// 690 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xcf, 0x4f, 0x13, 0x41,
	0x18, 0x65, 0x0a, 0x62, 0xfb, 0x55, 0xb0, 0x19, 0x52, 0xa8, 0x4d, 0x4c, 0x9a, 0x35, 0x91, 0x9e,
	0x36, 0x50, 0x23, 0x89, 0x11, 0x25, 0xa5, 0x22, 0x10, 0xf9, 0xe5, 0xb6, 0x5e, 0xf0, 0x30, 0x0e,
	0xed, 0x50, 0x56, 0xd8, 0x99, 0xba, 0x3b, 0x6d, 0xf4, 0xee, 0xc1, 0x18, 0x2f, 0x5e, 0x3d, 0x79,
	0x36, 0x1e, 0xbd, 0x78, 0xf5, 0xe6, 0x1f, 0xe3, 0x3f, 0xe0, 0xc9, 0xec, 0xec, 0xce, 0xd2, 0xa5,
	0x25, 0xd9, 0x56, 0x6e, 0xd3, 0x99, 0xbe, 0x37, 0xef, 0x7b, 0xdf, 0x9b, 0x2f, 0x0b, 0x0b, 0x47,
	0x8c, 0x3a, 0x84, 0xba, 0xd2, 0x3e, 0xa6, 0x4d, 0x49, 0x68, 0xc7, 0x36, 0x3b, 0xae, 0x90, 0x02,
	0x2f, 0x0a, 0xb7, 0x6d, 0xd2, 0x0e, 0x6d, 0x9e, 0x30, 0xd3, 0xff, 0x8f, 0xe9, 0x88, 0x16, 0x3b,
	0x33, 0x5f, 0x8b, 0x23, 0xe2, 0x50, 0x4e, 0xdb, 0xcc, 0x61, 0x5c, 0x9a, 0xbd, 0xe5, 0x62, 0x5e,
	0x31, 0xb8, 0x5d, 0xce, 0x99, 0x7b, 0x8e, 0x37, 0x5e, 0x41, 0xae, 0x1a, 0xb2, 0xee, 0x32, 0x49,
	0x5b, 0x54, 0x52, 0x8c, 0x61, 0x8a, 0x53, 0x87, 0x15, 0x50, 0x09, 0x95, 0x33, 0x96, 0x5a, 0xe3,
	0x12, 0x64, 0x3b, 0xcc, 0x75, 0x6c, 0xcf, 0xb3, 0x05, 0xf7, 0x0a, 0xa9, 0x12, 0x2a, 0xcf, 0x58,
	0xfd, 0x5b, 0x78, 0x1e, 0xa6, 0xbd, 0x13, 0x5a, 0xb9, 0xbf, 0x52, 0x98, 0x52, 0xb8, 0xf0, 0x97,
	0x41, 0x21, 0xbd, 0x4b, 0xb9, 0x7d, 0xcc, 0x3c, 0x89, 0x5f, 0x40, 0x5a, 0xd7, 0x50, 0x40, 0xa5,
	0xc9, 0x72, 0xb6, 0xf2, 0xc0, 0x4c, 0x58, 0x80, 0x79, 0x51, 0xa6, 0x15, 0x51, 0x19, 0x7f, 0x10,
	0xcc, 0x1c, 0xb8, 0xe2, 0xed, 0xbb, 0xe8, 0xa2, 0x5d, 0x48, 0x3b, 0xe1, 0x5a, 0x95, 0x91, 0xad,
	0x2c, 0x27, 0xbe, 0x48, 0x93, 0x58, 0x11, 0x05, 0x7e, 0x09, 0xe9, 0x33, 0xd1, 0xa4, 0xd2, 0x16,
	0xbc, 0x90, 0x52, 0xba, 0xd7, 0x12, 0xd3, 0xc5, 0x84, 0x99, 0x3b, 0x21, 0x8d, 0x15, 0x11, 0x16,
	0x97, 0x20, 0xad, 0x77, 0x87, 0x5a, 0x9f, 0x83, 0xc9, 0xae, 0x6b, 0x2b, 0xcb, 0x33, 0x96, 0xbf,
	0x34, 0x1e, 0x01, 0xde, 0x64, 0x32, 0xd2, 0xc9, 0xde, 0x74, 0x7d, 0x91, 0x8b, 0x70, 0xd3, 0x65,
	0xd2, 0xb5, 0x59, 0x8f, 0x9e, 0x11, 0x29, 0x4e, 0x19, 0x0f, 0x69, 0x66, 0xa3, 0xed, 0x86, 0xbf,
	0x6b, 0xb4, 0x60, 0x2e, 0x06, 0xf7, 0x3a, 0x82, 0x7b, 0xec, 0x8a, 0x3d, 0x33, 0x9e, 0x2b, 0x91,
	0xba, 0x6b, 0x5a, 0xe4, 0xb0, 0x02, 0x87, 0x08, 0x4f, 0x0d, 0x15, 0x7e, 0x07, 0x66, 0x34, 0x5f,
	0xed, 0xa4, 0xcb, 0x4f, 0x7d, 0x36, 0x3f, 0x0a, 0x8a, 0xed, 0x86, 0xa5, 0xd6, 0xc6, 0x57, 0x04,
	0x73, 0x07, 0x5d, 0x39, 0x90, 0xea, 0x0a, 0xe4, 0x3d, 0x49, 0xdb, 0x36, 0x6f, 0x13, 0x8f, 0xa9,
	0xcc, 0xc6, 0x4c, 0x9a, 0x0b, 0x0f, 0xeb, 0xc1, 0x99, 0xba, 0xd0, 0xcf, 0xab, 0x13, 0xe2, 0x95,
	0xa4, 0xff, 0xcb, 0xab, 0xa6, 0x32, 0x7e, 0x23, 0xc0, 0x7d, 0x12, 0xb5, 0x37, 0x87, 0x7d, 0xb7,
	0x05, 0x0d, 0x58, 0x4d, 0x9e, 0xb2, 0xc1, 0x8a, 0xb7, 0x26, 0xce, 0xaf, 0xc4, 0x3b, 0xa1, 0x53,
	0x41, 0x15, 0x2b, 0x23, 0x57, 0xa1, 0xfc, 0xde, 0x9a, 0x08, 0x3c, 0x5e, 0xcf, 0xc0, 0xf5, 0xa6,
	0xe0, 0x92, 0x71, 0x69, 0xe4, 0x63, 0x6e, 0xeb, 0x30, 0x19, 0x5f, 0x10, 0xe4, 0x6b, 0xc2, 0x71,
	0xec, 0x81, 0x98, 0x5e, 0xf1, 0xd3, 0xbc, 0xb4, 0xad, 0xa9, 0x4b, 0xdb, 0x6a, 0x7c, 0x42, 0x30,
	0x7f, 0x51, 0x5c, 0xf8, 0x08, 0x12, 0x3f, 0xa2, 0x6d, 0xc8, 0xd4, 0x04, 0xf7, 0x24, 0xe5, 0xd2,
	0xc3, 0xab, 0x70, 0x6b, 0x6f, 0x9f, 0x54, 0xad, 0xc6, 0xf6, 0xd3, 0x6a, 0xad, 0x51, 0x27, 0xf5,
	0x46, 0x75, 0x73, 0xe3, 0x09, 0x69, 0xec, 0x3f, 0xdb, 0xd8, 0xcb, 0x4d, 0x14, 0x6f, 0x7f, 0xfb,
	0xf1, 0xf7, 0xd7, 0xb5, 0x05, 0x42, 0xb8, 0x88, 0x66, 0xb8, 0x47, 0x7c, 0x65, 0xac, 0x45, 0x48,
	0xe5, 0x67, 0x0a, 0xe6, 0xb5, 0x81, 0x75, 0x2d, 0xd7, 0xed, 0xd9, 0x4d, 0x86, 0x3f, 0x22, 0xc8,
	0xf6, 0xd9, 0x8b, 0x1f, 0x8e, 0x13, 0x88, 0xd0, 0xf9, 0xe2, 0xea, 0x78, 0xe0, 0xc0, 0x99, 0x32,
	0xc2, 0x9f, 0x11, 0xcc, 0xc6, 0x6d, 0xc3, 0x8f, 0x13, 0x53, 0x0e, 0x0d, 0x43, 0x71, 0x6d, 0x6c,
	0x7c, 0xa0, 0xaa, 0xf2, 0x3d, 0x05, 0x85, 0x73, 0xa9, 0x61, 0x87, 0xb4, 0x7b, 0x1f, 0x10, 0x64,
	0xfb, 0x26, 0xdd, 0x08, 0xee, 0x0d, 0x8e, 0xd7, 0x11, 0xdc, 0x1b, 0x36, 0x5c, 0xdf, 0x07, 0x52,
	0xc6, 0x68, 0xe4, 0xe0, 0x10, 0x2d, 0x8e, 0xf9, 0x7c, 0x97, 0xd0, 0xfa, 0x26, 0xdc, 0xbd, 0x14,
	0x1a, 0x43, 0xae, 0x67, 0x35, 0xb4, 0xda, 0xb1, 0x0f, 0x73, 0xb1, 0x63, 0xd2, 0x5b, 0x3e, 0x9a,
	0x56, 0x9f, 0x0f, 0xf7, 0xfe, 0x05, 0x00, 0x00, 0xff, 0xff, 0x11, 0x85, 0xb1, 0xe8, 0x99, 0x08,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ArtifactStagingServiceClient is the client API for ArtifactStagingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ArtifactStagingServiceClient interface {
	// Stage an artifact to be available during job execution. The first request must contain the
	// name of the artifact. All future requests must contain sequential chunks of the content of
	// the artifact.
	PutArtifact(ctx context.Context, opts ...grpc.CallOption) (ArtifactStagingService_PutArtifactClient, error)
	// Commit the manifest for a Job. All artifacts must have been successfully uploaded
	// before this call is made.
	//
	// Throws error INVALID_ARGUMENT if not all of the members of the manifest are present
	CommitManifest(ctx context.Context, in *CommitManifestRequest, opts ...grpc.CallOption) (*CommitManifestResponse, error)
}

type artifactStagingServiceClient struct {
	cc *grpc.ClientConn
}

func NewArtifactStagingServiceClient(cc *grpc.ClientConn) ArtifactStagingServiceClient {
	return &artifactStagingServiceClient{cc}
}

func (c *artifactStagingServiceClient) PutArtifact(ctx context.Context, opts ...grpc.CallOption) (ArtifactStagingService_PutArtifactClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArtifactStagingService_serviceDesc.Streams[0], "/org.apache.beam.model.job_management.v1.ArtifactStagingService/PutArtifact", opts...)
	if err != nil {
		return nil, err
	}
	x := &artifactStagingServicePutArtifactClient{stream}
	return x, nil
}

type ArtifactStagingService_PutArtifactClient interface {
	Send(*PutArtifactRequest) error
	CloseAndRecv() (*PutArtifactResponse, error)
	grpc.ClientStream
}

type artifactStagingServicePutArtifactClient struct {
	grpc.ClientStream
}

func (x *artifactStagingServicePutArtifactClient) Send(m *PutArtifactRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *artifactStagingServicePutArtifactClient) CloseAndRecv() (*PutArtifactResponse, error) {
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	m := new(PutArtifactResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *artifactStagingServiceClient) CommitManifest(ctx context.Context, in *CommitManifestRequest, opts ...grpc.CallOption) (*CommitManifestResponse, error) {
	out := new(CommitManifestResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.ArtifactStagingService/CommitManifest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ArtifactStagingServiceServer is the server API for ArtifactStagingService service.
type ArtifactStagingServiceServer interface {
	// Stage an artifact to be available during job execution. The first request must contain the
	// name of the artifact. All future requests must contain sequential chunks of the content of
	// the artifact.
	PutArtifact(ArtifactStagingService_PutArtifactServer) error
	// Commit the manifest for a Job. All artifacts must have been successfully uploaded
	// before this call is made.
	//
	// Throws error INVALID_ARGUMENT if not all of the members of the manifest are present
	CommitManifest(context.Context, *CommitManifestRequest) (*CommitManifestResponse, error)
}

// UnimplementedArtifactStagingServiceServer can be embedded to have forward compatible implementations.
type UnimplementedArtifactStagingServiceServer struct {
}

func (*UnimplementedArtifactStagingServiceServer) PutArtifact(srv ArtifactStagingService_PutArtifactServer) error {
	return status.Errorf(codes.Unimplemented, "method PutArtifact not implemented")
}
func (*UnimplementedArtifactStagingServiceServer) CommitManifest(ctx context.Context, req *CommitManifestRequest) (*CommitManifestResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CommitManifest not implemented")
}

func RegisterArtifactStagingServiceServer(s *grpc.Server, srv ArtifactStagingServiceServer) {
	s.RegisterService(&_ArtifactStagingService_serviceDesc, srv)
}

func _ArtifactStagingService_PutArtifact_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ArtifactStagingServiceServer).PutArtifact(&artifactStagingServicePutArtifactServer{stream})
}

type ArtifactStagingService_PutArtifactServer interface {
	SendAndClose(*PutArtifactResponse) error
	Recv() (*PutArtifactRequest, error)
	grpc.ServerStream
}

type artifactStagingServicePutArtifactServer struct {
	grpc.ServerStream
}

func (x *artifactStagingServicePutArtifactServer) SendAndClose(m *PutArtifactResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *artifactStagingServicePutArtifactServer) Recv() (*PutArtifactRequest, error) {
	m := new(PutArtifactRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ArtifactStagingService_CommitManifest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CommitManifestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactStagingServiceServer).CommitManifest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.ArtifactStagingService/CommitManifest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactStagingServiceServer).CommitManifest(ctx, req.(*CommitManifestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ArtifactStagingService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.job_management.v1.ArtifactStagingService",
	HandlerType: (*ArtifactStagingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CommitManifest",
			Handler:    _ArtifactStagingService_CommitManifest_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "PutArtifact",
			Handler:       _ArtifactStagingService_PutArtifact_Handler,
			ClientStreams: true,
		},
	},
	Metadata: "beam_artifact_api.proto",
}

// ArtifactRetrievalServiceClient is the client API for ArtifactRetrievalService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ArtifactRetrievalServiceClient interface {
	// Get the manifest for the job
	GetManifest(ctx context.Context, in *GetManifestRequest, opts ...grpc.CallOption) (*GetManifestResponse, error)
	// Get an artifact staged for the job. The requested artifact must be within the manifest
	GetArtifact(ctx context.Context, in *GetArtifactRequest, opts ...grpc.CallOption) (ArtifactRetrievalService_GetArtifactClient, error)
}

type artifactRetrievalServiceClient struct {
	cc *grpc.ClientConn
}

func NewArtifactRetrievalServiceClient(cc *grpc.ClientConn) ArtifactRetrievalServiceClient {
	return &artifactRetrievalServiceClient{cc}
}

func (c *artifactRetrievalServiceClient) GetManifest(ctx context.Context, in *GetManifestRequest, opts ...grpc.CallOption) (*GetManifestResponse, error) {
	out := new(GetManifestResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.ArtifactRetrievalService/GetManifest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRetrievalServiceClient) GetArtifact(ctx context.Context, in *GetArtifactRequest, opts ...grpc.CallOption) (ArtifactRetrievalService_GetArtifactClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ArtifactRetrievalService_serviceDesc.Streams[0], "/org.apache.beam.model.job_management.v1.ArtifactRetrievalService/GetArtifact", opts...)
	if err != nil {
		return nil, err
	}
	x := &artifactRetrievalServiceGetArtifactClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type ArtifactRetrievalService_GetArtifactClient interface {
	Recv() (*ArtifactChunk, error)
	grpc.ClientStream
}

type artifactRetrievalServiceGetArtifactClient struct {
	grpc.ClientStream
}

func (x *artifactRetrievalServiceGetArtifactClient) Recv() (*ArtifactChunk, error) {
	m := new(ArtifactChunk)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ArtifactRetrievalServiceServer is the server API for ArtifactRetrievalService service.
type ArtifactRetrievalServiceServer interface {
	// Get the manifest for the job
	GetManifest(context.Context, *GetManifestRequest) (*GetManifestResponse, error)
	// Get an artifact staged for the job. The requested artifact must be within the manifest
	GetArtifact(*GetArtifactRequest, ArtifactRetrievalService_GetArtifactServer) error
}

// UnimplementedArtifactRetrievalServiceServer can be embedded to have forward compatible implementations.
type UnimplementedArtifactRetrievalServiceServer struct {
}

func (*UnimplementedArtifactRetrievalServiceServer) GetManifest(ctx context.Context, req *GetManifestRequest) (*GetManifestResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetManifest not implemented")
}
func (*UnimplementedArtifactRetrievalServiceServer) GetArtifact(req *GetArtifactRequest, srv ArtifactRetrievalService_GetArtifactServer) error {
	return status.Errorf(codes.Unimplemented, "method GetArtifact not implemented")
}

func RegisterArtifactRetrievalServiceServer(s *grpc.Server, srv ArtifactRetrievalServiceServer) {
	s.RegisterService(&_ArtifactRetrievalService_serviceDesc, srv)
}

func _ArtifactRetrievalService_GetManifest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetManifestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRetrievalServiceServer).GetManifest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.ArtifactRetrievalService/GetManifest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRetrievalServiceServer).GetManifest(ctx, req.(*GetManifestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRetrievalService_GetArtifact_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetArtifactRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(ArtifactRetrievalServiceServer).GetArtifact(m, &artifactRetrievalServiceGetArtifactServer{stream})
}

type ArtifactRetrievalService_GetArtifactServer interface {
	Send(*ArtifactChunk) error
	grpc.ServerStream
}

type artifactRetrievalServiceGetArtifactServer struct {
	grpc.ServerStream
}

func (x *artifactRetrievalServiceGetArtifactServer) Send(m *ArtifactChunk) error {
	return x.ServerStream.SendMsg(m)
}

var _ArtifactRetrievalService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.job_management.v1.ArtifactRetrievalService",
	HandlerType: (*ArtifactRetrievalServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetManifest",
			Handler:    _ArtifactRetrievalService_GetManifest_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetArtifact",
			Handler:       _ArtifactRetrievalService_GetArtifact_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "beam_artifact_api.proto",
}
