// Code generated by protoc-gen-go. DO NOT EDIT.
// source: beam_fn_api.proto

package fnexecution_v1

import (
	context "context"
	fmt "fmt"
	pipeline_v1 "github.com/apache/beam/sdks/go/pkg/beam/model/pipeline_v1"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/golang/protobuf/protoc-gen-go/descriptor"
	duration "github.com/golang/protobuf/ptypes/duration"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "github.com/golang/protobuf/ptypes/wrappers"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type LogEntry_Severity_Enum int32

const (
	// Unspecified level information. Will be logged at the TRACE level.
	LogEntry_Severity_UNSPECIFIED LogEntry_Severity_Enum = 0
	LogEntry_Severity_TRACE       LogEntry_Severity_Enum = 1
	// Debugging information.
	LogEntry_Severity_DEBUG LogEntry_Severity_Enum = 2
	// Normal events.
	LogEntry_Severity_INFO LogEntry_Severity_Enum = 3
	// Normal but significant events, such as start up, shut down, or
	// configuration.
	LogEntry_Severity_NOTICE LogEntry_Severity_Enum = 4
	// Warning events might cause problems.
	LogEntry_Severity_WARN LogEntry_Severity_Enum = 5
	// Error events are likely to cause problems.
	LogEntry_Severity_ERROR LogEntry_Severity_Enum = 6
	// Critical events cause severe problems or brief outages and may
	// indicate that a person must take action.
	LogEntry_Severity_CRITICAL LogEntry_Severity_Enum = 7
)

var LogEntry_Severity_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "TRACE",
	2: "DEBUG",
	3: "INFO",
	4: "NOTICE",
	5: "WARN",
	6: "ERROR",
	7: "CRITICAL",
}

var LogEntry_Severity_Enum_value = map[string]int32{
	"UNSPECIFIED": 0,
	"TRACE":       1,
	"DEBUG":       2,
	"INFO":        3,
	"NOTICE":      4,
	"WARN":        5,
	"ERROR":       6,
	"CRITICAL":    7,
}

func (x LogEntry_Severity_Enum) String() string {
	return proto.EnumName(LogEntry_Severity_Enum_name, int32(x))
}

func (LogEntry_Severity_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{27, 1, 0}
}

// A descriptor for connecting to a remote port using the Beam Fn Data API.
// Allows for communication between two environments (for example between the
// runner and the SDK).
// Stable
type RemoteGrpcPort struct {
	// (Required) An API descriptor which describes where to
	// connect to including any authentication that is required.
	ApiServiceDescriptor *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,1,opt,name=api_service_descriptor,json=apiServiceDescriptor,proto3" json:"api_service_descriptor,omitempty"`
	// (Required) The ID of the Coder that will be used to encode and decode data
	// sent over this port.
	CoderId              string   `protobuf:"bytes,2,opt,name=coder_id,json=coderId,proto3" json:"coder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoteGrpcPort) Reset()         { *m = RemoteGrpcPort{} }
func (m *RemoteGrpcPort) String() string { return proto.CompactTextString(m) }
func (*RemoteGrpcPort) ProtoMessage()    {}
func (*RemoteGrpcPort) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{0}
}

func (m *RemoteGrpcPort) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoteGrpcPort.Unmarshal(m, b)
}
func (m *RemoteGrpcPort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoteGrpcPort.Marshal(b, m, deterministic)
}
func (m *RemoteGrpcPort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoteGrpcPort.Merge(m, src)
}
func (m *RemoteGrpcPort) XXX_Size() int {
	return xxx_messageInfo_RemoteGrpcPort.Size(m)
}
func (m *RemoteGrpcPort) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoteGrpcPort.DiscardUnknown(m)
}

var xxx_messageInfo_RemoteGrpcPort proto.InternalMessageInfo

func (m *RemoteGrpcPort) GetApiServiceDescriptor() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.ApiServiceDescriptor
	}
	return nil
}

func (m *RemoteGrpcPort) GetCoderId() string {
	if m != nil {
		return m.CoderId
	}
	return ""
}

// A request sent by a runner which the SDK is asked to fulfill.
// For any unsupported request type, an error should be returned with a
// matching instruction id.
// Stable
type InstructionRequest struct {
	// (Required) A unique identifier provided by the runner which represents
	// this requests execution. The InstructionResponse MUST have the matching id.
	InstructionId string `protobuf:"bytes,1,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	// (Required) A request that the SDK Harness needs to interpret.
	//
	// Types that are valid to be assigned to Request:
	//	*InstructionRequest_Register
	//	*InstructionRequest_ProcessBundle
	//	*InstructionRequest_ProcessBundleProgress
	//	*InstructionRequest_ProcessBundleSplit
	//	*InstructionRequest_FinalizeBundle
	Request              isInstructionRequest_Request `protobuf_oneof:"request"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *InstructionRequest) Reset()         { *m = InstructionRequest{} }
func (m *InstructionRequest) String() string { return proto.CompactTextString(m) }
func (*InstructionRequest) ProtoMessage()    {}
func (*InstructionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{1}
}

func (m *InstructionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstructionRequest.Unmarshal(m, b)
}
func (m *InstructionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstructionRequest.Marshal(b, m, deterministic)
}
func (m *InstructionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstructionRequest.Merge(m, src)
}
func (m *InstructionRequest) XXX_Size() int {
	return xxx_messageInfo_InstructionRequest.Size(m)
}
func (m *InstructionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InstructionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InstructionRequest proto.InternalMessageInfo

func (m *InstructionRequest) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

type isInstructionRequest_Request interface {
	isInstructionRequest_Request()
}

type InstructionRequest_Register struct {
	Register *RegisterRequest `protobuf:"bytes,1000,opt,name=register,proto3,oneof"`
}

type InstructionRequest_ProcessBundle struct {
	ProcessBundle *ProcessBundleRequest `protobuf:"bytes,1001,opt,name=process_bundle,json=processBundle,proto3,oneof"`
}

type InstructionRequest_ProcessBundleProgress struct {
	ProcessBundleProgress *ProcessBundleProgressRequest `protobuf:"bytes,1002,opt,name=process_bundle_progress,json=processBundleProgress,proto3,oneof"`
}

type InstructionRequest_ProcessBundleSplit struct {
	ProcessBundleSplit *ProcessBundleSplitRequest `protobuf:"bytes,1003,opt,name=process_bundle_split,json=processBundleSplit,proto3,oneof"`
}

type InstructionRequest_FinalizeBundle struct {
	FinalizeBundle *FinalizeBundleRequest `protobuf:"bytes,1004,opt,name=finalize_bundle,json=finalizeBundle,proto3,oneof"`
}

func (*InstructionRequest_Register) isInstructionRequest_Request() {}

func (*InstructionRequest_ProcessBundle) isInstructionRequest_Request() {}

func (*InstructionRequest_ProcessBundleProgress) isInstructionRequest_Request() {}

func (*InstructionRequest_ProcessBundleSplit) isInstructionRequest_Request() {}

func (*InstructionRequest_FinalizeBundle) isInstructionRequest_Request() {}

func (m *InstructionRequest) GetRequest() isInstructionRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *InstructionRequest) GetRegister() *RegisterRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_Register); ok {
		return x.Register
	}
	return nil
}

func (m *InstructionRequest) GetProcessBundle() *ProcessBundleRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_ProcessBundle); ok {
		return x.ProcessBundle
	}
	return nil
}

func (m *InstructionRequest) GetProcessBundleProgress() *ProcessBundleProgressRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_ProcessBundleProgress); ok {
		return x.ProcessBundleProgress
	}
	return nil
}

func (m *InstructionRequest) GetProcessBundleSplit() *ProcessBundleSplitRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_ProcessBundleSplit); ok {
		return x.ProcessBundleSplit
	}
	return nil
}

func (m *InstructionRequest) GetFinalizeBundle() *FinalizeBundleRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_FinalizeBundle); ok {
		return x.FinalizeBundle
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*InstructionRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*InstructionRequest_Register)(nil),
		(*InstructionRequest_ProcessBundle)(nil),
		(*InstructionRequest_ProcessBundleProgress)(nil),
		(*InstructionRequest_ProcessBundleSplit)(nil),
		(*InstructionRequest_FinalizeBundle)(nil),
	}
}

// The response for an associated request the SDK had been asked to fulfill.
// Stable
type InstructionResponse struct {
	// (Required) A reference provided by the runner which represents a requests
	// execution. The InstructionResponse MUST have the matching id when
	// responding to the runner.
	InstructionId string `protobuf:"bytes,1,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	// If this is specified, then this instruction has failed.
	// A human readable string representing the reason as to why processing has
	// failed.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// If the instruction did not fail, it is required to return an equivalent
	// response type depending on the request this matches.
	//
	// Types that are valid to be assigned to Response:
	//	*InstructionResponse_Register
	//	*InstructionResponse_ProcessBundle
	//	*InstructionResponse_ProcessBundleProgress
	//	*InstructionResponse_ProcessBundleSplit
	//	*InstructionResponse_FinalizeBundle
	Response             isInstructionResponse_Response `protobuf_oneof:"response"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *InstructionResponse) Reset()         { *m = InstructionResponse{} }
func (m *InstructionResponse) String() string { return proto.CompactTextString(m) }
func (*InstructionResponse) ProtoMessage()    {}
func (*InstructionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{2}
}

func (m *InstructionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstructionResponse.Unmarshal(m, b)
}
func (m *InstructionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstructionResponse.Marshal(b, m, deterministic)
}
func (m *InstructionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstructionResponse.Merge(m, src)
}
func (m *InstructionResponse) XXX_Size() int {
	return xxx_messageInfo_InstructionResponse.Size(m)
}
func (m *InstructionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_InstructionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_InstructionResponse proto.InternalMessageInfo

func (m *InstructionResponse) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

func (m *InstructionResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type isInstructionResponse_Response interface {
	isInstructionResponse_Response()
}

type InstructionResponse_Register struct {
	Register *RegisterResponse `protobuf:"bytes,1000,opt,name=register,proto3,oneof"`
}

type InstructionResponse_ProcessBundle struct {
	ProcessBundle *ProcessBundleResponse `protobuf:"bytes,1001,opt,name=process_bundle,json=processBundle,proto3,oneof"`
}

type InstructionResponse_ProcessBundleProgress struct {
	ProcessBundleProgress *ProcessBundleProgressResponse `protobuf:"bytes,1002,opt,name=process_bundle_progress,json=processBundleProgress,proto3,oneof"`
}

type InstructionResponse_ProcessBundleSplit struct {
	ProcessBundleSplit *ProcessBundleSplitResponse `protobuf:"bytes,1003,opt,name=process_bundle_split,json=processBundleSplit,proto3,oneof"`
}

type InstructionResponse_FinalizeBundle struct {
	FinalizeBundle *FinalizeBundleResponse `protobuf:"bytes,1004,opt,name=finalize_bundle,json=finalizeBundle,proto3,oneof"`
}

func (*InstructionResponse_Register) isInstructionResponse_Response() {}

func (*InstructionResponse_ProcessBundle) isInstructionResponse_Response() {}

func (*InstructionResponse_ProcessBundleProgress) isInstructionResponse_Response() {}

func (*InstructionResponse_ProcessBundleSplit) isInstructionResponse_Response() {}

func (*InstructionResponse_FinalizeBundle) isInstructionResponse_Response() {}

func (m *InstructionResponse) GetResponse() isInstructionResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *InstructionResponse) GetRegister() *RegisterResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_Register); ok {
		return x.Register
	}
	return nil
}

func (m *InstructionResponse) GetProcessBundle() *ProcessBundleResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_ProcessBundle); ok {
		return x.ProcessBundle
	}
	return nil
}

func (m *InstructionResponse) GetProcessBundleProgress() *ProcessBundleProgressResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_ProcessBundleProgress); ok {
		return x.ProcessBundleProgress
	}
	return nil
}

func (m *InstructionResponse) GetProcessBundleSplit() *ProcessBundleSplitResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_ProcessBundleSplit); ok {
		return x.ProcessBundleSplit
	}
	return nil
}

func (m *InstructionResponse) GetFinalizeBundle() *FinalizeBundleResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_FinalizeBundle); ok {
		return x.FinalizeBundle
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*InstructionResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*InstructionResponse_Register)(nil),
		(*InstructionResponse_ProcessBundle)(nil),
		(*InstructionResponse_ProcessBundleProgress)(nil),
		(*InstructionResponse_ProcessBundleSplit)(nil),
		(*InstructionResponse_FinalizeBundle)(nil),
	}
}

// A list of objects which can be referred to by the runner in
// future requests.
// Stable
type RegisterRequest struct {
	// (Optional) The set of descriptors used to process bundles.
	ProcessBundleDescriptor []*ProcessBundleDescriptor `protobuf:"bytes,1,rep,name=process_bundle_descriptor,json=processBundleDescriptor,proto3" json:"process_bundle_descriptor,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}                   `json:"-"`
	XXX_unrecognized        []byte                     `json:"-"`
	XXX_sizecache           int32                      `json:"-"`
}

func (m *RegisterRequest) Reset()         { *m = RegisterRequest{} }
func (m *RegisterRequest) String() string { return proto.CompactTextString(m) }
func (*RegisterRequest) ProtoMessage()    {}
func (*RegisterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{3}
}

func (m *RegisterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RegisterRequest.Unmarshal(m, b)
}
func (m *RegisterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RegisterRequest.Marshal(b, m, deterministic)
}
func (m *RegisterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterRequest.Merge(m, src)
}
func (m *RegisterRequest) XXX_Size() int {
	return xxx_messageInfo_RegisterRequest.Size(m)
}
func (m *RegisterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterRequest proto.InternalMessageInfo

func (m *RegisterRequest) GetProcessBundleDescriptor() []*ProcessBundleDescriptor {
	if m != nil {
		return m.ProcessBundleDescriptor
	}
	return nil
}

// Stable
type RegisterResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RegisterResponse) Reset()         { *m = RegisterResponse{} }
func (m *RegisterResponse) String() string { return proto.CompactTextString(m) }
func (*RegisterResponse) ProtoMessage()    {}
func (*RegisterResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{4}
}

func (m *RegisterResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RegisterResponse.Unmarshal(m, b)
}
func (m *RegisterResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RegisterResponse.Marshal(b, m, deterministic)
}
func (m *RegisterResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterResponse.Merge(m, src)
}
func (m *RegisterResponse) XXX_Size() int {
	return xxx_messageInfo_RegisterResponse.Size(m)
}
func (m *RegisterResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterResponse proto.InternalMessageInfo

// Definitions that should be used to construct the bundle processing graph.
type ProcessBundleDescriptor struct {
	// (Required) A pipeline level unique id which can be used as a reference to
	// refer to this.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// (Required) A map from pipeline-scoped id to PTransform.
	Transforms map[string]*pipeline_v1.PTransform `protobuf:"bytes,2,rep,name=transforms,proto3" json:"transforms,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to PCollection.
	Pcollections map[string]*pipeline_v1.PCollection `protobuf:"bytes,3,rep,name=pcollections,proto3" json:"pcollections,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to WindowingStrategy.
	WindowingStrategies map[string]*pipeline_v1.WindowingStrategy `protobuf:"bytes,4,rep,name=windowing_strategies,json=windowingStrategies,proto3" json:"windowing_strategies,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to Coder.
	Coders map[string]*pipeline_v1.Coder `protobuf:"bytes,5,rep,name=coders,proto3" json:"coders,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to Environment.
	Environments map[string]*pipeline_v1.Environment `protobuf:"bytes,6,rep,name=environments,proto3" json:"environments,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A descriptor describing the end point to use for State API
	// calls. Required if the Runner intends to send remote references over the
	// data plane or if any of the transforms rely on user state or side inputs.
	StateApiServiceDescriptor *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,7,opt,name=state_api_service_descriptor,json=stateApiServiceDescriptor,proto3" json:"state_api_service_descriptor,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}                          `json:"-"`
	XXX_unrecognized          []byte                            `json:"-"`
	XXX_sizecache             int32                             `json:"-"`
}

func (m *ProcessBundleDescriptor) Reset()         { *m = ProcessBundleDescriptor{} }
func (m *ProcessBundleDescriptor) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleDescriptor) ProtoMessage()    {}
func (*ProcessBundleDescriptor) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{5}
}

func (m *ProcessBundleDescriptor) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleDescriptor.Unmarshal(m, b)
}
func (m *ProcessBundleDescriptor) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleDescriptor.Marshal(b, m, deterministic)
}
func (m *ProcessBundleDescriptor) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleDescriptor.Merge(m, src)
}
func (m *ProcessBundleDescriptor) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleDescriptor.Size(m)
}
func (m *ProcessBundleDescriptor) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleDescriptor.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleDescriptor proto.InternalMessageInfo

func (m *ProcessBundleDescriptor) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ProcessBundleDescriptor) GetTransforms() map[string]*pipeline_v1.PTransform {
	if m != nil {
		return m.Transforms
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetPcollections() map[string]*pipeline_v1.PCollection {
	if m != nil {
		return m.Pcollections
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetWindowingStrategies() map[string]*pipeline_v1.WindowingStrategy {
	if m != nil {
		return m.WindowingStrategies
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetCoders() map[string]*pipeline_v1.Coder {
	if m != nil {
		return m.Coders
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetEnvironments() map[string]*pipeline_v1.Environment {
	if m != nil {
		return m.Environments
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetStateApiServiceDescriptor() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.StateApiServiceDescriptor
	}
	return nil
}

// One of the applications specifying the scope of work for a bundle.
// See
// https://docs.google.com/document/d/1tUDb45sStdR8u7-jBkGdw3OGFK7aa2-V7eo86zYSE_4/edit#heading=h.9g3g5weg2u9
// for further details.
type BundleApplication struct {
	// (Required) The transform to which to pass the element
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) Name of the transform's input to which to pass the element.
	InputId string `protobuf:"bytes,2,opt,name=input_id,json=inputId,proto3" json:"input_id,omitempty"`
	// (Required) The encoded element to pass to the transform.
	Element []byte `protobuf:"bytes,3,opt,name=element,proto3" json:"element,omitempty"`
	// The map is keyed by the local output name of the PTransform. Each
	// value represents a lower bound on the timestamps of elements that
	// are produced by this PTransform into each of its output PCollections
	// when invoked with this application.
	//
	// If there is no watermark reported from RestrictionTracker, the runner will
	// use MIN_TIMESTAMP by default.
	OutputWatermarks map[string]*timestamp.Timestamp `protobuf:"bytes,4,rep,name=output_watermarks,json=outputWatermarks,proto3" json:"output_watermarks,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) Whether this application potentially produces an unbounded
	// amount of data. Note that this should only be set to BOUNDED if and
	// only if the application is known to produce a finite amount of output.
	IsBounded pipeline_v1.IsBounded_Enum `protobuf:"varint,5,opt,name=is_bounded,json=isBounded,proto3,enum=org.apache.beam.model.pipeline.v1.IsBounded_Enum" json:"is_bounded,omitempty"`
	// Contains additional monitoring information related to this application.
	//
	// Each application is able to report information that some runners
	// will use when providing a UI or for making scaling and performance
	// decisions. See https://s.apache.org/beam-bundles-backlog-splitting for
	// details about what types of signals may be useful to report.
	MonitoringInfos      []*pipeline_v1.MonitoringInfo `protobuf:"bytes,6,rep,name=monitoring_infos,json=monitoringInfos,proto3" json:"monitoring_infos,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *BundleApplication) Reset()         { *m = BundleApplication{} }
func (m *BundleApplication) String() string { return proto.CompactTextString(m) }
func (*BundleApplication) ProtoMessage()    {}
func (*BundleApplication) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{6}
}

func (m *BundleApplication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BundleApplication.Unmarshal(m, b)
}
func (m *BundleApplication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BundleApplication.Marshal(b, m, deterministic)
}
func (m *BundleApplication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BundleApplication.Merge(m, src)
}
func (m *BundleApplication) XXX_Size() int {
	return xxx_messageInfo_BundleApplication.Size(m)
}
func (m *BundleApplication) XXX_DiscardUnknown() {
	xxx_messageInfo_BundleApplication.DiscardUnknown(m)
}

var xxx_messageInfo_BundleApplication proto.InternalMessageInfo

func (m *BundleApplication) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *BundleApplication) GetInputId() string {
	if m != nil {
		return m.InputId
	}
	return ""
}

func (m *BundleApplication) GetElement() []byte {
	if m != nil {
		return m.Element
	}
	return nil
}

func (m *BundleApplication) GetOutputWatermarks() map[string]*timestamp.Timestamp {
	if m != nil {
		return m.OutputWatermarks
	}
	return nil
}

func (m *BundleApplication) GetIsBounded() pipeline_v1.IsBounded_Enum {
	if m != nil {
		return m.IsBounded
	}
	return pipeline_v1.IsBounded_UNSPECIFIED
}

func (m *BundleApplication) GetMonitoringInfos() []*pipeline_v1.MonitoringInfo {
	if m != nil {
		return m.MonitoringInfos
	}
	return nil
}

// An Application should be scheduled for execution after a delay.
// Either an absolute timestamp or a relative timestamp can represent a
// scheduled execution time.
type DelayedBundleApplication struct {
	// (Required) The application that should be scheduled.
	Application *BundleApplication `protobuf:"bytes,1,opt,name=application,proto3" json:"application,omitempty"`
	// Recommended time delay at which the application should be scheduled to
	// execute by the runner. Time delay that equals 0 may be scheduled to execute
	// immediately. The unit of time delay should be microsecond.
	RequestedTimeDelay   *duration.Duration `protobuf:"bytes,2,opt,name=requested_time_delay,json=requestedTimeDelay,proto3" json:"requested_time_delay,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *DelayedBundleApplication) Reset()         { *m = DelayedBundleApplication{} }
func (m *DelayedBundleApplication) String() string { return proto.CompactTextString(m) }
func (*DelayedBundleApplication) ProtoMessage()    {}
func (*DelayedBundleApplication) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{7}
}

func (m *DelayedBundleApplication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DelayedBundleApplication.Unmarshal(m, b)
}
func (m *DelayedBundleApplication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DelayedBundleApplication.Marshal(b, m, deterministic)
}
func (m *DelayedBundleApplication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DelayedBundleApplication.Merge(m, src)
}
func (m *DelayedBundleApplication) XXX_Size() int {
	return xxx_messageInfo_DelayedBundleApplication.Size(m)
}
func (m *DelayedBundleApplication) XXX_DiscardUnknown() {
	xxx_messageInfo_DelayedBundleApplication.DiscardUnknown(m)
}

var xxx_messageInfo_DelayedBundleApplication proto.InternalMessageInfo

func (m *DelayedBundleApplication) GetApplication() *BundleApplication {
	if m != nil {
		return m.Application
	}
	return nil
}

func (m *DelayedBundleApplication) GetRequestedTimeDelay() *duration.Duration {
	if m != nil {
		return m.RequestedTimeDelay
	}
	return nil
}

// A request to process a given bundle.
// Stable
type ProcessBundleRequest struct {
	// (Required) A reference to the process bundle descriptor that must be
	// instantiated and executed by the SDK harness.
	ProcessBundleDescriptorId string `protobuf:"bytes,1,opt,name=process_bundle_descriptor_id,json=processBundleDescriptorId,proto3" json:"process_bundle_descriptor_id,omitempty"`
	// (Optional) A list of cache tokens that can be used by an SDK to reuse
	// cached data returned by the State API across multiple bundles.
	CacheTokens          []*ProcessBundleRequest_CacheToken `protobuf:"bytes,2,rep,name=cache_tokens,json=cacheTokens,proto3" json:"cache_tokens,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *ProcessBundleRequest) Reset()         { *m = ProcessBundleRequest{} }
func (m *ProcessBundleRequest) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleRequest) ProtoMessage()    {}
func (*ProcessBundleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{8}
}

func (m *ProcessBundleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleRequest.Unmarshal(m, b)
}
func (m *ProcessBundleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleRequest.Marshal(b, m, deterministic)
}
func (m *ProcessBundleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleRequest.Merge(m, src)
}
func (m *ProcessBundleRequest) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleRequest.Size(m)
}
func (m *ProcessBundleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleRequest proto.InternalMessageInfo

func (m *ProcessBundleRequest) GetProcessBundleDescriptorId() string {
	if m != nil {
		return m.ProcessBundleDescriptorId
	}
	return ""
}

func (m *ProcessBundleRequest) GetCacheTokens() []*ProcessBundleRequest_CacheToken {
	if m != nil {
		return m.CacheTokens
	}
	return nil
}

// A cache token which can be used by an SDK to check for the validity
// of cached elements which have a cache token associated.
type ProcessBundleRequest_CacheToken struct {
	// The scope of a cache token.
	//
	// Types that are valid to be assigned to Type:
	//	*ProcessBundleRequest_CacheToken_UserState_
	//	*ProcessBundleRequest_CacheToken_SideInput_
	Type isProcessBundleRequest_CacheToken_Type `protobuf_oneof:"type"`
	// The cache token identifier which should be globally unique.
	Token                []byte   `protobuf:"bytes,10,opt,name=token,proto3" json:"token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleRequest_CacheToken) Reset()         { *m = ProcessBundleRequest_CacheToken{} }
func (m *ProcessBundleRequest_CacheToken) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleRequest_CacheToken) ProtoMessage()    {}
func (*ProcessBundleRequest_CacheToken) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{8, 0}
}

func (m *ProcessBundleRequest_CacheToken) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleRequest_CacheToken.Unmarshal(m, b)
}
func (m *ProcessBundleRequest_CacheToken) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleRequest_CacheToken.Marshal(b, m, deterministic)
}
func (m *ProcessBundleRequest_CacheToken) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleRequest_CacheToken.Merge(m, src)
}
func (m *ProcessBundleRequest_CacheToken) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleRequest_CacheToken.Size(m)
}
func (m *ProcessBundleRequest_CacheToken) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleRequest_CacheToken.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleRequest_CacheToken proto.InternalMessageInfo

type isProcessBundleRequest_CacheToken_Type interface {
	isProcessBundleRequest_CacheToken_Type()
}

type ProcessBundleRequest_CacheToken_UserState_ struct {
	UserState *ProcessBundleRequest_CacheToken_UserState `protobuf:"bytes,1,opt,name=user_state,json=userState,proto3,oneof"`
}

type ProcessBundleRequest_CacheToken_SideInput_ struct {
	SideInput *ProcessBundleRequest_CacheToken_SideInput `protobuf:"bytes,2,opt,name=side_input,json=sideInput,proto3,oneof"`
}

func (*ProcessBundleRequest_CacheToken_UserState_) isProcessBundleRequest_CacheToken_Type() {}

func (*ProcessBundleRequest_CacheToken_SideInput_) isProcessBundleRequest_CacheToken_Type() {}

func (m *ProcessBundleRequest_CacheToken) GetType() isProcessBundleRequest_CacheToken_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *ProcessBundleRequest_CacheToken) GetUserState() *ProcessBundleRequest_CacheToken_UserState {
	if x, ok := m.GetType().(*ProcessBundleRequest_CacheToken_UserState_); ok {
		return x.UserState
	}
	return nil
}

func (m *ProcessBundleRequest_CacheToken) GetSideInput() *ProcessBundleRequest_CacheToken_SideInput {
	if x, ok := m.GetType().(*ProcessBundleRequest_CacheToken_SideInput_); ok {
		return x.SideInput
	}
	return nil
}

func (m *ProcessBundleRequest_CacheToken) GetToken() []byte {
	if m != nil {
		return m.Token
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ProcessBundleRequest_CacheToken) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ProcessBundleRequest_CacheToken_UserState_)(nil),
		(*ProcessBundleRequest_CacheToken_SideInput_)(nil),
	}
}

// A flag to indicate a cache token is valid for user state.
type ProcessBundleRequest_CacheToken_UserState struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleRequest_CacheToken_UserState) Reset() {
	*m = ProcessBundleRequest_CacheToken_UserState{}
}
func (m *ProcessBundleRequest_CacheToken_UserState) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleRequest_CacheToken_UserState) ProtoMessage()    {}
func (*ProcessBundleRequest_CacheToken_UserState) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{8, 0, 0}
}

func (m *ProcessBundleRequest_CacheToken_UserState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleRequest_CacheToken_UserState.Unmarshal(m, b)
}
func (m *ProcessBundleRequest_CacheToken_UserState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleRequest_CacheToken_UserState.Marshal(b, m, deterministic)
}
func (m *ProcessBundleRequest_CacheToken_UserState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleRequest_CacheToken_UserState.Merge(m, src)
}
func (m *ProcessBundleRequest_CacheToken_UserState) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleRequest_CacheToken_UserState.Size(m)
}
func (m *ProcessBundleRequest_CacheToken_UserState) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleRequest_CacheToken_UserState.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleRequest_CacheToken_UserState proto.InternalMessageInfo

// A flag to indicate a cache token is valid for a side input.
type ProcessBundleRequest_CacheToken_SideInput struct {
	// (Required) The id of the PTransform containing a side input.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The id of the side input.
	SideInputId          string   `protobuf:"bytes,2,opt,name=side_input_id,json=sideInputId,proto3" json:"side_input_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleRequest_CacheToken_SideInput) Reset() {
	*m = ProcessBundleRequest_CacheToken_SideInput{}
}
func (m *ProcessBundleRequest_CacheToken_SideInput) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleRequest_CacheToken_SideInput) ProtoMessage()    {}
func (*ProcessBundleRequest_CacheToken_SideInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{8, 0, 1}
}

func (m *ProcessBundleRequest_CacheToken_SideInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleRequest_CacheToken_SideInput.Unmarshal(m, b)
}
func (m *ProcessBundleRequest_CacheToken_SideInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleRequest_CacheToken_SideInput.Marshal(b, m, deterministic)
}
func (m *ProcessBundleRequest_CacheToken_SideInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleRequest_CacheToken_SideInput.Merge(m, src)
}
func (m *ProcessBundleRequest_CacheToken_SideInput) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleRequest_CacheToken_SideInput.Size(m)
}
func (m *ProcessBundleRequest_CacheToken_SideInput) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleRequest_CacheToken_SideInput.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleRequest_CacheToken_SideInput proto.InternalMessageInfo

func (m *ProcessBundleRequest_CacheToken_SideInput) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *ProcessBundleRequest_CacheToken_SideInput) GetSideInputId() string {
	if m != nil {
		return m.SideInputId
	}
	return ""
}

type ProcessBundleResponse struct {
	// (Optional) If metrics reporting is supported by the SDK, this represents
	// the final metrics to record for this bundle.
	// DEPRECATED
	Metrics *Metrics `protobuf:"bytes,1,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// (Optional) Specifies that the bundle has not been completed and the
	// following applications need to be scheduled and executed in the future.
	// A runner that does not yet support residual roots MUST still check that
	// this is empty for correctness.
	ResidualRoots []*DelayedBundleApplication `protobuf:"bytes,2,rep,name=residual_roots,json=residualRoots,proto3" json:"residual_roots,omitempty"`
	// (Required) The list of metrics or other MonitoredState
	// collected while processing this bundle.
	MonitoringInfos []*pipeline_v1.MonitoringInfo `protobuf:"bytes,3,rep,name=monitoring_infos,json=monitoringInfos,proto3" json:"monitoring_infos,omitempty"`
	// (Optional) Specifies that the runner must callback to this worker
	// once the output of the bundle is committed. The Runner must send a
	// FinalizeBundleRequest with the instruction id of the ProcessBundleRequest
	// that is related to this ProcessBundleResponse.
	RequiresFinalization bool     `protobuf:"varint,4,opt,name=requires_finalization,json=requiresFinalization,proto3" json:"requires_finalization,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleResponse) Reset()         { *m = ProcessBundleResponse{} }
func (m *ProcessBundleResponse) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleResponse) ProtoMessage()    {}
func (*ProcessBundleResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{9}
}

func (m *ProcessBundleResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleResponse.Unmarshal(m, b)
}
func (m *ProcessBundleResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleResponse.Marshal(b, m, deterministic)
}
func (m *ProcessBundleResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleResponse.Merge(m, src)
}
func (m *ProcessBundleResponse) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleResponse.Size(m)
}
func (m *ProcessBundleResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleResponse proto.InternalMessageInfo

func (m *ProcessBundleResponse) GetMetrics() *Metrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *ProcessBundleResponse) GetResidualRoots() []*DelayedBundleApplication {
	if m != nil {
		return m.ResidualRoots
	}
	return nil
}

func (m *ProcessBundleResponse) GetMonitoringInfos() []*pipeline_v1.MonitoringInfo {
	if m != nil {
		return m.MonitoringInfos
	}
	return nil
}

func (m *ProcessBundleResponse) GetRequiresFinalization() bool {
	if m != nil {
		return m.RequiresFinalization
	}
	return false
}

// A request to report progress information for a given bundle.
// This is an optional request to be handled and is used to support advanced
// SDK features such as SplittableDoFn, user level metrics etc.
type ProcessBundleProgressRequest struct {
	// (Required) A reference to an active process bundle request with the given
	// instruction id.
	InstructionId        string   `protobuf:"bytes,1,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleProgressRequest) Reset()         { *m = ProcessBundleProgressRequest{} }
func (m *ProcessBundleProgressRequest) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleProgressRequest) ProtoMessage()    {}
func (*ProcessBundleProgressRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{10}
}

func (m *ProcessBundleProgressRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleProgressRequest.Unmarshal(m, b)
}
func (m *ProcessBundleProgressRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleProgressRequest.Marshal(b, m, deterministic)
}
func (m *ProcessBundleProgressRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleProgressRequest.Merge(m, src)
}
func (m *ProcessBundleProgressRequest) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleProgressRequest.Size(m)
}
func (m *ProcessBundleProgressRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleProgressRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleProgressRequest proto.InternalMessageInfo

func (m *ProcessBundleProgressRequest) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

// DEPRECATED
type Metrics struct {
	Ptransforms          map[string]*Metrics_PTransform `protobuf:"bytes,1,rep,name=ptransforms,proto3" json:"ptransforms,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *Metrics) Reset()         { *m = Metrics{} }
func (m *Metrics) String() string { return proto.CompactTextString(m) }
func (*Metrics) ProtoMessage()    {}
func (*Metrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{11}
}

func (m *Metrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics.Unmarshal(m, b)
}
func (m *Metrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics.Marshal(b, m, deterministic)
}
func (m *Metrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics.Merge(m, src)
}
func (m *Metrics) XXX_Size() int {
	return xxx_messageInfo_Metrics.Size(m)
}
func (m *Metrics) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics proto.InternalMessageInfo

func (m *Metrics) GetPtransforms() map[string]*Metrics_PTransform {
	if m != nil {
		return m.Ptransforms
	}
	return nil
}

// PTransform level metrics.
// These metrics are split into processed and active element groups for
// progress reporting purposes. This allows a Runner to see what is measured,
// what is estimated and what can be extrapolated to be able to accurately
// estimate the amount of remaining work.
type Metrics_PTransform struct {
	// (Required): Metrics for processed elements.
	ProcessedElements *Metrics_PTransform_ProcessedElements `protobuf:"bytes,1,opt,name=processed_elements,json=processedElements,proto3" json:"processed_elements,omitempty"`
	// (Required): Metrics for active elements.
	ActiveElements *Metrics_PTransform_ActiveElements `protobuf:"bytes,2,opt,name=active_elements,json=activeElements,proto3" json:"active_elements,omitempty"`
	// (Optional): Map from local output name to its watermark.
	// The watermarks reported are tentative, to get a better sense of progress
	// while processing a bundle but before it is committed. At bundle commit
	// time, a Runner needs to also take into account the timers set to compute
	// the actual watermarks.
	Watermarks           map[string]int64 `protobuf:"bytes,3,rep,name=watermarks,proto3" json:"watermarks,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	User                 []*Metrics_User  `protobuf:"bytes,4,rep,name=user,proto3" json:"user,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Metrics_PTransform) Reset()         { *m = Metrics_PTransform{} }
func (m *Metrics_PTransform) String() string { return proto.CompactTextString(m) }
func (*Metrics_PTransform) ProtoMessage()    {}
func (*Metrics_PTransform) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{11, 0}
}

func (m *Metrics_PTransform) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_PTransform.Unmarshal(m, b)
}
func (m *Metrics_PTransform) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_PTransform.Marshal(b, m, deterministic)
}
func (m *Metrics_PTransform) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_PTransform.Merge(m, src)
}
func (m *Metrics_PTransform) XXX_Size() int {
	return xxx_messageInfo_Metrics_PTransform.Size(m)
}
func (m *Metrics_PTransform) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_PTransform.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_PTransform proto.InternalMessageInfo

func (m *Metrics_PTransform) GetProcessedElements() *Metrics_PTransform_ProcessedElements {
	if m != nil {
		return m.ProcessedElements
	}
	return nil
}

func (m *Metrics_PTransform) GetActiveElements() *Metrics_PTransform_ActiveElements {
	if m != nil {
		return m.ActiveElements
	}
	return nil
}

func (m *Metrics_PTransform) GetWatermarks() map[string]int64 {
	if m != nil {
		return m.Watermarks
	}
	return nil
}

func (m *Metrics_PTransform) GetUser() []*Metrics_User {
	if m != nil {
		return m.User
	}
	return nil
}

// Metrics that are measured for processed and active element groups.
type Metrics_PTransform_Measured struct {
	// (Optional) Map from local input name to number of elements processed
	// from this input.
	// If unset, assumed to be the sum of the outputs of all producers to
	// this transform (for ProcessedElements) and 0 (for ActiveElements).
	InputElementCounts map[string]int64 `protobuf:"bytes,1,rep,name=input_element_counts,json=inputElementCounts,proto3" json:"input_element_counts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// (Required) Map from local output name to number of elements produced
	// for this output.
	OutputElementCounts map[string]int64 `protobuf:"bytes,2,rep,name=output_element_counts,json=outputElementCounts,proto3" json:"output_element_counts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// (Optional) The total time spent so far in processing the elements in
	// this group, in seconds.
	TotalTimeSpent       float64  `protobuf:"fixed64,3,opt,name=total_time_spent,json=totalTimeSpent,proto3" json:"total_time_spent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Metrics_PTransform_Measured) Reset()         { *m = Metrics_PTransform_Measured{} }
func (m *Metrics_PTransform_Measured) String() string { return proto.CompactTextString(m) }
func (*Metrics_PTransform_Measured) ProtoMessage()    {}
func (*Metrics_PTransform_Measured) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{11, 0, 0}
}

func (m *Metrics_PTransform_Measured) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_PTransform_Measured.Unmarshal(m, b)
}
func (m *Metrics_PTransform_Measured) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_PTransform_Measured.Marshal(b, m, deterministic)
}
func (m *Metrics_PTransform_Measured) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_PTransform_Measured.Merge(m, src)
}
func (m *Metrics_PTransform_Measured) XXX_Size() int {
	return xxx_messageInfo_Metrics_PTransform_Measured.Size(m)
}
func (m *Metrics_PTransform_Measured) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_PTransform_Measured.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_PTransform_Measured proto.InternalMessageInfo

func (m *Metrics_PTransform_Measured) GetInputElementCounts() map[string]int64 {
	if m != nil {
		return m.InputElementCounts
	}
	return nil
}

func (m *Metrics_PTransform_Measured) GetOutputElementCounts() map[string]int64 {
	if m != nil {
		return m.OutputElementCounts
	}
	return nil
}

func (m *Metrics_PTransform_Measured) GetTotalTimeSpent() float64 {
	if m != nil {
		return m.TotalTimeSpent
	}
	return 0
}

// Metrics for fully processed elements.
type Metrics_PTransform_ProcessedElements struct {
	// (Required)
	Measured             *Metrics_PTransform_Measured `protobuf:"bytes,1,opt,name=measured,proto3" json:"measured,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *Metrics_PTransform_ProcessedElements) Reset()         { *m = Metrics_PTransform_ProcessedElements{} }
func (m *Metrics_PTransform_ProcessedElements) String() string { return proto.CompactTextString(m) }
func (*Metrics_PTransform_ProcessedElements) ProtoMessage()    {}
func (*Metrics_PTransform_ProcessedElements) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{11, 0, 1}
}

func (m *Metrics_PTransform_ProcessedElements) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_PTransform_ProcessedElements.Unmarshal(m, b)
}
func (m *Metrics_PTransform_ProcessedElements) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_PTransform_ProcessedElements.Marshal(b, m, deterministic)
}
func (m *Metrics_PTransform_ProcessedElements) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_PTransform_ProcessedElements.Merge(m, src)
}
func (m *Metrics_PTransform_ProcessedElements) XXX_Size() int {
	return xxx_messageInfo_Metrics_PTransform_ProcessedElements.Size(m)
}
func (m *Metrics_PTransform_ProcessedElements) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_PTransform_ProcessedElements.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_PTransform_ProcessedElements proto.InternalMessageInfo

func (m *Metrics_PTransform_ProcessedElements) GetMeasured() *Metrics_PTransform_Measured {
	if m != nil {
		return m.Measured
	}
	return nil
}

// Metrics for active elements.
// An element is considered active if the SDK has started but not finished
// processing it yet.
type Metrics_PTransform_ActiveElements struct {
	// (Required)
	Measured *Metrics_PTransform_Measured `protobuf:"bytes,1,opt,name=measured,proto3" json:"measured,omitempty"`
	// (Optional) Sum of estimated fraction of known work remaining for all
	// active elements, as reported by this transform.
	// If not reported, a Runner could extrapolate this from the processed
	// elements.
	// TODO: Handle the case when known work is infinite.
	FractionRemaining float64 `protobuf:"fixed64,2,opt,name=fraction_remaining,json=fractionRemaining,proto3" json:"fraction_remaining,omitempty"`
	// (Optional) Map from local output name to sum of estimated number
	// of elements remaining for this output from all active elements,
	// as reported by this transform.
	// If not reported, a Runner could extrapolate this from the processed
	// elements.
	OutputElementsRemaining map[string]int64 `protobuf:"bytes,3,rep,name=output_elements_remaining,json=outputElementsRemaining,proto3" json:"output_elements_remaining,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral    struct{}         `json:"-"`
	XXX_unrecognized        []byte           `json:"-"`
	XXX_sizecache           int32            `json:"-"`
}

func (m *Metrics_PTransform_ActiveElements) Reset()         { *m = Metrics_PTransform_ActiveElements{} }
func (m *Metrics_PTransform_ActiveElements) String() string { return proto.CompactTextString(m) }
func (*Metrics_PTransform_ActiveElements) ProtoMessage()    {}
func (*Metrics_PTransform_ActiveElements) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{11, 0, 2}
}

func (m *Metrics_PTransform_ActiveElements) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_PTransform_ActiveElements.Unmarshal(m, b)
}
func (m *Metrics_PTransform_ActiveElements) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_PTransform_ActiveElements.Marshal(b, m, deterministic)
}
func (m *Metrics_PTransform_ActiveElements) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_PTransform_ActiveElements.Merge(m, src)
}
func (m *Metrics_PTransform_ActiveElements) XXX_Size() int {
	return xxx_messageInfo_Metrics_PTransform_ActiveElements.Size(m)
}
func (m *Metrics_PTransform_ActiveElements) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_PTransform_ActiveElements.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_PTransform_ActiveElements proto.InternalMessageInfo

func (m *Metrics_PTransform_ActiveElements) GetMeasured() *Metrics_PTransform_Measured {
	if m != nil {
		return m.Measured
	}
	return nil
}

func (m *Metrics_PTransform_ActiveElements) GetFractionRemaining() float64 {
	if m != nil {
		return m.FractionRemaining
	}
	return 0
}

func (m *Metrics_PTransform_ActiveElements) GetOutputElementsRemaining() map[string]int64 {
	if m != nil {
		return m.OutputElementsRemaining
	}
	return nil
}

// User defined metrics
type Metrics_User struct {
	// (Required) The identifier for this metric.
	MetricName *Metrics_User_MetricName `protobuf:"bytes,1,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
	// (Required) The data for this metric.
	//
	// Types that are valid to be assigned to Data:
	//	*Metrics_User_CounterData_
	//	*Metrics_User_DistributionData_
	//	*Metrics_User_GaugeData_
	Data                 isMetrics_User_Data `protobuf_oneof:"data"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Metrics_User) Reset()         { *m = Metrics_User{} }
func (m *Metrics_User) String() string { return proto.CompactTextString(m) }
func (*Metrics_User) ProtoMessage()    {}
func (*Metrics_User) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{11, 1}
}

func (m *Metrics_User) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User.Unmarshal(m, b)
}
func (m *Metrics_User) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User.Marshal(b, m, deterministic)
}
func (m *Metrics_User) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User.Merge(m, src)
}
func (m *Metrics_User) XXX_Size() int {
	return xxx_messageInfo_Metrics_User.Size(m)
}
func (m *Metrics_User) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User proto.InternalMessageInfo

func (m *Metrics_User) GetMetricName() *Metrics_User_MetricName {
	if m != nil {
		return m.MetricName
	}
	return nil
}

type isMetrics_User_Data interface {
	isMetrics_User_Data()
}

type Metrics_User_CounterData_ struct {
	CounterData *Metrics_User_CounterData `protobuf:"bytes,1001,opt,name=counter_data,json=counterData,proto3,oneof"`
}

type Metrics_User_DistributionData_ struct {
	DistributionData *Metrics_User_DistributionData `protobuf:"bytes,1002,opt,name=distribution_data,json=distributionData,proto3,oneof"`
}

type Metrics_User_GaugeData_ struct {
	GaugeData *Metrics_User_GaugeData `protobuf:"bytes,1003,opt,name=gauge_data,json=gaugeData,proto3,oneof"`
}

func (*Metrics_User_CounterData_) isMetrics_User_Data() {}

func (*Metrics_User_DistributionData_) isMetrics_User_Data() {}

func (*Metrics_User_GaugeData_) isMetrics_User_Data() {}

func (m *Metrics_User) GetData() isMetrics_User_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Metrics_User) GetCounterData() *Metrics_User_CounterData {
	if x, ok := m.GetData().(*Metrics_User_CounterData_); ok {
		return x.CounterData
	}
	return nil
}

func (m *Metrics_User) GetDistributionData() *Metrics_User_DistributionData {
	if x, ok := m.GetData().(*Metrics_User_DistributionData_); ok {
		return x.DistributionData
	}
	return nil
}

func (m *Metrics_User) GetGaugeData() *Metrics_User_GaugeData {
	if x, ok := m.GetData().(*Metrics_User_GaugeData_); ok {
		return x.GaugeData
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Metrics_User) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Metrics_User_CounterData_)(nil),
		(*Metrics_User_DistributionData_)(nil),
		(*Metrics_User_GaugeData_)(nil),
	}
}

// A key for identifying a metric at the most granular level.
type Metrics_User_MetricName struct {
	// (Required): The namespace of this metric.
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// (Required): The name of this metric.
	Name                 string   `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Metrics_User_MetricName) Reset()         { *m = Metrics_User_MetricName{} }
func (m *Metrics_User_MetricName) String() string { return proto.CompactTextString(m) }
func (*Metrics_User_MetricName) ProtoMessage()    {}
func (*Metrics_User_MetricName) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{11, 1, 0}
}

func (m *Metrics_User_MetricName) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User_MetricName.Unmarshal(m, b)
}
func (m *Metrics_User_MetricName) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User_MetricName.Marshal(b, m, deterministic)
}
func (m *Metrics_User_MetricName) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User_MetricName.Merge(m, src)
}
func (m *Metrics_User_MetricName) XXX_Size() int {
	return xxx_messageInfo_Metrics_User_MetricName.Size(m)
}
func (m *Metrics_User_MetricName) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User_MetricName.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User_MetricName proto.InternalMessageInfo

func (m *Metrics_User_MetricName) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *Metrics_User_MetricName) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Data associated with a counter metric.
type Metrics_User_CounterData struct {
	Value                int64    `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Metrics_User_CounterData) Reset()         { *m = Metrics_User_CounterData{} }
func (m *Metrics_User_CounterData) String() string { return proto.CompactTextString(m) }
func (*Metrics_User_CounterData) ProtoMessage()    {}
func (*Metrics_User_CounterData) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{11, 1, 1}
}

func (m *Metrics_User_CounterData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User_CounterData.Unmarshal(m, b)
}
func (m *Metrics_User_CounterData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User_CounterData.Marshal(b, m, deterministic)
}
func (m *Metrics_User_CounterData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User_CounterData.Merge(m, src)
}
func (m *Metrics_User_CounterData) XXX_Size() int {
	return xxx_messageInfo_Metrics_User_CounterData.Size(m)
}
func (m *Metrics_User_CounterData) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User_CounterData.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User_CounterData proto.InternalMessageInfo

func (m *Metrics_User_CounterData) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

// Data associated with a distribution metric.
type Metrics_User_DistributionData struct {
	Count                int64    `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	Sum                  int64    `protobuf:"varint,2,opt,name=sum,proto3" json:"sum,omitempty"`
	Min                  int64    `protobuf:"varint,3,opt,name=min,proto3" json:"min,omitempty"`
	Max                  int64    `protobuf:"varint,4,opt,name=max,proto3" json:"max,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Metrics_User_DistributionData) Reset()         { *m = Metrics_User_DistributionData{} }
func (m *Metrics_User_DistributionData) String() string { return proto.CompactTextString(m) }
func (*Metrics_User_DistributionData) ProtoMessage()    {}
func (*Metrics_User_DistributionData) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{11, 1, 2}
}

func (m *Metrics_User_DistributionData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User_DistributionData.Unmarshal(m, b)
}
func (m *Metrics_User_DistributionData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User_DistributionData.Marshal(b, m, deterministic)
}
func (m *Metrics_User_DistributionData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User_DistributionData.Merge(m, src)
}
func (m *Metrics_User_DistributionData) XXX_Size() int {
	return xxx_messageInfo_Metrics_User_DistributionData.Size(m)
}
func (m *Metrics_User_DistributionData) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User_DistributionData.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User_DistributionData proto.InternalMessageInfo

func (m *Metrics_User_DistributionData) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *Metrics_User_DistributionData) GetSum() int64 {
	if m != nil {
		return m.Sum
	}
	return 0
}

func (m *Metrics_User_DistributionData) GetMin() int64 {
	if m != nil {
		return m.Min
	}
	return 0
}

func (m *Metrics_User_DistributionData) GetMax() int64 {
	if m != nil {
		return m.Max
	}
	return 0
}

// Data associated with a Gauge metric.
type Metrics_User_GaugeData struct {
	Value                int64                `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	Timestamp            *timestamp.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Metrics_User_GaugeData) Reset()         { *m = Metrics_User_GaugeData{} }
func (m *Metrics_User_GaugeData) String() string { return proto.CompactTextString(m) }
func (*Metrics_User_GaugeData) ProtoMessage()    {}
func (*Metrics_User_GaugeData) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{11, 1, 3}
}

func (m *Metrics_User_GaugeData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User_GaugeData.Unmarshal(m, b)
}
func (m *Metrics_User_GaugeData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User_GaugeData.Marshal(b, m, deterministic)
}
func (m *Metrics_User_GaugeData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User_GaugeData.Merge(m, src)
}
func (m *Metrics_User_GaugeData) XXX_Size() int {
	return xxx_messageInfo_Metrics_User_GaugeData.Size(m)
}
func (m *Metrics_User_GaugeData) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User_GaugeData.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User_GaugeData proto.InternalMessageInfo

func (m *Metrics_User_GaugeData) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

func (m *Metrics_User_GaugeData) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

type ProcessBundleProgressResponse struct {
	// DEPRECATED (Required)
	Metrics *Metrics `protobuf:"bytes,1,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// (Required) The list of metrics or other MonitoredState
	// collected while processing this bundle.
	MonitoringInfos []*pipeline_v1.MonitoringInfo `protobuf:"bytes,3,rep,name=monitoring_infos,json=monitoringInfos,proto3" json:"monitoring_infos,omitempty"`
	// The list of currently active primary roots that are being
	// executed. Required to be populated for PTransforms which can be split.
	PrimaryRoots         []*BundleApplication `protobuf:"bytes,4,rep,name=primary_roots,json=primaryRoots,proto3" json:"primary_roots,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ProcessBundleProgressResponse) Reset()         { *m = ProcessBundleProgressResponse{} }
func (m *ProcessBundleProgressResponse) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleProgressResponse) ProtoMessage()    {}
func (*ProcessBundleProgressResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{12}
}

func (m *ProcessBundleProgressResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleProgressResponse.Unmarshal(m, b)
}
func (m *ProcessBundleProgressResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleProgressResponse.Marshal(b, m, deterministic)
}
func (m *ProcessBundleProgressResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleProgressResponse.Merge(m, src)
}
func (m *ProcessBundleProgressResponse) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleProgressResponse.Size(m)
}
func (m *ProcessBundleProgressResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleProgressResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleProgressResponse proto.InternalMessageInfo

func (m *ProcessBundleProgressResponse) GetMetrics() *Metrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *ProcessBundleProgressResponse) GetMonitoringInfos() []*pipeline_v1.MonitoringInfo {
	if m != nil {
		return m.MonitoringInfos
	}
	return nil
}

func (m *ProcessBundleProgressResponse) GetPrimaryRoots() []*BundleApplication {
	if m != nil {
		return m.PrimaryRoots
	}
	return nil
}

// Represents a request to the SDK to split a currently active bundle.
type ProcessBundleSplitRequest struct {
	// (Required) A reference to an active process bundle request with the given
	// instruction id.
	InstructionId string `protobuf:"bytes,1,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	// (Required) Specifies the desired split for each transform.
	//
	// Currently only splits at GRPC read operations are supported.
	// This may, of course, limit the amount of work downstream operations
	// receive.
	DesiredSplits        map[string]*ProcessBundleSplitRequest_DesiredSplit `protobuf:"bytes,3,rep,name=desired_splits,json=desiredSplits,proto3" json:"desired_splits,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                                           `json:"-"`
	XXX_unrecognized     []byte                                             `json:"-"`
	XXX_sizecache        int32                                              `json:"-"`
}

func (m *ProcessBundleSplitRequest) Reset()         { *m = ProcessBundleSplitRequest{} }
func (m *ProcessBundleSplitRequest) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleSplitRequest) ProtoMessage()    {}
func (*ProcessBundleSplitRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{13}
}

func (m *ProcessBundleSplitRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleSplitRequest.Unmarshal(m, b)
}
func (m *ProcessBundleSplitRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleSplitRequest.Marshal(b, m, deterministic)
}
func (m *ProcessBundleSplitRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleSplitRequest.Merge(m, src)
}
func (m *ProcessBundleSplitRequest) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleSplitRequest.Size(m)
}
func (m *ProcessBundleSplitRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleSplitRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleSplitRequest proto.InternalMessageInfo

func (m *ProcessBundleSplitRequest) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

func (m *ProcessBundleSplitRequest) GetDesiredSplits() map[string]*ProcessBundleSplitRequest_DesiredSplit {
	if m != nil {
		return m.DesiredSplits
	}
	return nil
}

// A message specifying the desired split for a single transform.
type ProcessBundleSplitRequest_DesiredSplit struct {
	// (Required) The fraction of known work remaining in this bundle
	// for this transform that should be kept by the SDK after this split.
	//
	// Set to 0 to "checkpoint" as soon as possible (keeping as little work as
	// possible and returning the remainder).
	FractionOfRemainder float64 `protobuf:"fixed64,1,opt,name=fraction_of_remainder,json=fractionOfRemainder,proto3" json:"fraction_of_remainder,omitempty"`
	// A set of allowed element indices where the SDK may split. When this is
	// empty, there are no constraints on where to split.
	AllowedSplitPoints []int64 `protobuf:"varint,3,rep,packed,name=allowed_split_points,json=allowedSplitPoints,proto3" json:"allowed_split_points,omitempty"`
	// (Required for GrpcRead operations) Number of total elements expected
	// to be sent to this GrpcRead operation, required to correctly account
	// for unreceived data when determining where to split.
	EstimatedInputElements int64    `protobuf:"varint,2,opt,name=estimated_input_elements,json=estimatedInputElements,proto3" json:"estimated_input_elements,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *ProcessBundleSplitRequest_DesiredSplit) Reset() {
	*m = ProcessBundleSplitRequest_DesiredSplit{}
}
func (m *ProcessBundleSplitRequest_DesiredSplit) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleSplitRequest_DesiredSplit) ProtoMessage()    {}
func (*ProcessBundleSplitRequest_DesiredSplit) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{13, 0}
}

func (m *ProcessBundleSplitRequest_DesiredSplit) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleSplitRequest_DesiredSplit.Unmarshal(m, b)
}
func (m *ProcessBundleSplitRequest_DesiredSplit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleSplitRequest_DesiredSplit.Marshal(b, m, deterministic)
}
func (m *ProcessBundleSplitRequest_DesiredSplit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleSplitRequest_DesiredSplit.Merge(m, src)
}
func (m *ProcessBundleSplitRequest_DesiredSplit) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleSplitRequest_DesiredSplit.Size(m)
}
func (m *ProcessBundleSplitRequest_DesiredSplit) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleSplitRequest_DesiredSplit.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleSplitRequest_DesiredSplit proto.InternalMessageInfo

func (m *ProcessBundleSplitRequest_DesiredSplit) GetFractionOfRemainder() float64 {
	if m != nil {
		return m.FractionOfRemainder
	}
	return 0
}

func (m *ProcessBundleSplitRequest_DesiredSplit) GetAllowedSplitPoints() []int64 {
	if m != nil {
		return m.AllowedSplitPoints
	}
	return nil
}

func (m *ProcessBundleSplitRequest_DesiredSplit) GetEstimatedInputElements() int64 {
	if m != nil {
		return m.EstimatedInputElements
	}
	return 0
}

// Represents a partition of the bundle: a "primary" and
// a "residual", with the following properties:
// - The work in primary and residual doesn't overlap, and combined, adds up
//   to the work in the current bundle if the split hadn't happened.
// - The current bundle, if it keeps executing, will have done none of the
//   work under residual_roots.
// - The current bundle, if no further splits happen, will have done exactly
//   the work under primary_roots.
// For more rigorous definitions see https://s.apache.org/beam-breaking-fusion
type ProcessBundleSplitResponse struct {
	// Root applications that should replace the current bundle.
	PrimaryRoots []*BundleApplication `protobuf:"bytes,1,rep,name=primary_roots,json=primaryRoots,proto3" json:"primary_roots,omitempty"`
	// Root applications that have been removed from the current bundle and
	// have to be executed in a separate bundle (e.g. in parallel on a different
	// worker, or after the current bundle completes, etc.)
	ResidualRoots []*DelayedBundleApplication `protobuf:"bytes,2,rep,name=residual_roots,json=residualRoots,proto3" json:"residual_roots,omitempty"`
	// Partitions of input data channels into primary and residual elements,
	// if any. Should not include any elements represented in the bundle
	// applications roots above.
	ChannelSplits        []*ProcessBundleSplitResponse_ChannelSplit `protobuf:"bytes,3,rep,name=channel_splits,json=channelSplits,proto3" json:"channel_splits,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *ProcessBundleSplitResponse) Reset()         { *m = ProcessBundleSplitResponse{} }
func (m *ProcessBundleSplitResponse) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleSplitResponse) ProtoMessage()    {}
func (*ProcessBundleSplitResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{14}
}

func (m *ProcessBundleSplitResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleSplitResponse.Unmarshal(m, b)
}
func (m *ProcessBundleSplitResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleSplitResponse.Marshal(b, m, deterministic)
}
func (m *ProcessBundleSplitResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleSplitResponse.Merge(m, src)
}
func (m *ProcessBundleSplitResponse) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleSplitResponse.Size(m)
}
func (m *ProcessBundleSplitResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleSplitResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleSplitResponse proto.InternalMessageInfo

func (m *ProcessBundleSplitResponse) GetPrimaryRoots() []*BundleApplication {
	if m != nil {
		return m.PrimaryRoots
	}
	return nil
}

func (m *ProcessBundleSplitResponse) GetResidualRoots() []*DelayedBundleApplication {
	if m != nil {
		return m.ResidualRoots
	}
	return nil
}

func (m *ProcessBundleSplitResponse) GetChannelSplits() []*ProcessBundleSplitResponse_ChannelSplit {
	if m != nil {
		return m.ChannelSplits
	}
	return nil
}

// Represents contiguous portions of the data channel that are either
// entirely processed or entirely unprocessed and belong to the primary
// or residual respectively.
//
// This affords both a more efficient representation over the FnAPI
// (if the bundle is large) and often a more efficient representation
// on the runner side (e.g. if the set of elements can be represented
// as some range in an underlying dataset).
type ProcessBundleSplitResponse_ChannelSplit struct {
	// (Required) The grpc read transform reading this channel.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// The last element of the input channel that should be entirely considered
	// part of the primary, identified by its absolute index in the (ordered)
	// channel.
	LastPrimaryElement int64 `protobuf:"varint,2,opt,name=last_primary_element,json=lastPrimaryElement,proto3" json:"last_primary_element,omitempty"`
	// The first element of the input channel that should be entirely considered
	// part of the residual, identified by its absolute index in the (ordered)
	// channel.
	FirstResidualElement int64    `protobuf:"varint,3,opt,name=first_residual_element,json=firstResidualElement,proto3" json:"first_residual_element,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleSplitResponse_ChannelSplit) Reset() {
	*m = ProcessBundleSplitResponse_ChannelSplit{}
}
func (m *ProcessBundleSplitResponse_ChannelSplit) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleSplitResponse_ChannelSplit) ProtoMessage()    {}
func (*ProcessBundleSplitResponse_ChannelSplit) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{14, 0}
}

func (m *ProcessBundleSplitResponse_ChannelSplit) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleSplitResponse_ChannelSplit.Unmarshal(m, b)
}
func (m *ProcessBundleSplitResponse_ChannelSplit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleSplitResponse_ChannelSplit.Marshal(b, m, deterministic)
}
func (m *ProcessBundleSplitResponse_ChannelSplit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleSplitResponse_ChannelSplit.Merge(m, src)
}
func (m *ProcessBundleSplitResponse_ChannelSplit) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleSplitResponse_ChannelSplit.Size(m)
}
func (m *ProcessBundleSplitResponse_ChannelSplit) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleSplitResponse_ChannelSplit.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleSplitResponse_ChannelSplit proto.InternalMessageInfo

func (m *ProcessBundleSplitResponse_ChannelSplit) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *ProcessBundleSplitResponse_ChannelSplit) GetLastPrimaryElement() int64 {
	if m != nil {
		return m.LastPrimaryElement
	}
	return 0
}

func (m *ProcessBundleSplitResponse_ChannelSplit) GetFirstResidualElement() int64 {
	if m != nil {
		return m.FirstResidualElement
	}
	return 0
}

type FinalizeBundleRequest struct {
	// (Required) A reference to a completed process bundle request with the given
	// instruction id.
	InstructionId        string   `protobuf:"bytes,1,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FinalizeBundleRequest) Reset()         { *m = FinalizeBundleRequest{} }
func (m *FinalizeBundleRequest) String() string { return proto.CompactTextString(m) }
func (*FinalizeBundleRequest) ProtoMessage()    {}
func (*FinalizeBundleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{15}
}

func (m *FinalizeBundleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinalizeBundleRequest.Unmarshal(m, b)
}
func (m *FinalizeBundleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinalizeBundleRequest.Marshal(b, m, deterministic)
}
func (m *FinalizeBundleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinalizeBundleRequest.Merge(m, src)
}
func (m *FinalizeBundleRequest) XXX_Size() int {
	return xxx_messageInfo_FinalizeBundleRequest.Size(m)
}
func (m *FinalizeBundleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FinalizeBundleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FinalizeBundleRequest proto.InternalMessageInfo

func (m *FinalizeBundleRequest) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

type FinalizeBundleResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FinalizeBundleResponse) Reset()         { *m = FinalizeBundleResponse{} }
func (m *FinalizeBundleResponse) String() string { return proto.CompactTextString(m) }
func (*FinalizeBundleResponse) ProtoMessage()    {}
func (*FinalizeBundleResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{16}
}

func (m *FinalizeBundleResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinalizeBundleResponse.Unmarshal(m, b)
}
func (m *FinalizeBundleResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinalizeBundleResponse.Marshal(b, m, deterministic)
}
func (m *FinalizeBundleResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinalizeBundleResponse.Merge(m, src)
}
func (m *FinalizeBundleResponse) XXX_Size() int {
	return xxx_messageInfo_FinalizeBundleResponse.Size(m)
}
func (m *FinalizeBundleResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FinalizeBundleResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FinalizeBundleResponse proto.InternalMessageInfo

// Messages used to represent logical byte streams.
// Stable
type Elements struct {
	// (Required) A list containing parts of logical byte streams.
	Data                 []*Elements_Data `protobuf:"bytes,1,rep,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Elements) Reset()         { *m = Elements{} }
func (m *Elements) String() string { return proto.CompactTextString(m) }
func (*Elements) ProtoMessage()    {}
func (*Elements) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{17}
}

func (m *Elements) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Elements.Unmarshal(m, b)
}
func (m *Elements) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Elements.Marshal(b, m, deterministic)
}
func (m *Elements) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Elements.Merge(m, src)
}
func (m *Elements) XXX_Size() int {
	return xxx_messageInfo_Elements.Size(m)
}
func (m *Elements) XXX_DiscardUnknown() {
	xxx_messageInfo_Elements.DiscardUnknown(m)
}

var xxx_messageInfo_Elements proto.InternalMessageInfo

func (m *Elements) GetData() []*Elements_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

// Represents multiple encoded elements in nested context for a given named
// instruction and transform.
type Elements_Data struct {
	// (Required) A reference to an active instruction request with the given
	// instruction id.
	InstructionId string `protobuf:"bytes,1,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	// (Required) A definition representing a consumer or producer of this data.
	// If received by a harness, this represents the consumer within that
	// harness that should consume these bytes. If sent by a harness, this
	// represents the producer of these bytes.
	//
	// Note that a single element may span multiple Data messages.
	//
	// Note that a sending/receiving pair should share the same identifier.
	TransformId string `protobuf:"bytes,2,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Optional) Represents a part of a logical byte stream. Elements within
	// the logical byte stream are encoded in the nested context and
	// concatenated together.
	//
	// An empty data block represents the end of stream for the given
	// instruction and transform.
	Data                 []byte   `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Elements_Data) Reset()         { *m = Elements_Data{} }
func (m *Elements_Data) String() string { return proto.CompactTextString(m) }
func (*Elements_Data) ProtoMessage()    {}
func (*Elements_Data) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{17, 0}
}

func (m *Elements_Data) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Elements_Data.Unmarshal(m, b)
}
func (m *Elements_Data) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Elements_Data.Marshal(b, m, deterministic)
}
func (m *Elements_Data) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Elements_Data.Merge(m, src)
}
func (m *Elements_Data) XXX_Size() int {
	return xxx_messageInfo_Elements_Data.Size(m)
}
func (m *Elements_Data) XXX_DiscardUnknown() {
	xxx_messageInfo_Elements_Data.DiscardUnknown(m)
}

var xxx_messageInfo_Elements_Data proto.InternalMessageInfo

func (m *Elements_Data) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

func (m *Elements_Data) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *Elements_Data) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type StateRequest struct {
	// (Required) A unique identifier provided by the SDK which represents this
	// requests execution. The StateResponse corresponding with this request
	// will have the matching id.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// (Required) The associated instruction id of the work that is currently
	// being processed. This allows for the runner to associate any modifications
	// to state to be committed with the appropriate work execution.
	InstructionId string `protobuf:"bytes,2,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	// (Required) The state key this request is for.
	StateKey *StateKey `protobuf:"bytes,3,opt,name=state_key,json=stateKey,proto3" json:"state_key,omitempty"`
	// (Required) The action to take on this request.
	//
	// Types that are valid to be assigned to Request:
	//	*StateRequest_Get
	//	*StateRequest_Append
	//	*StateRequest_Clear
	Request              isStateRequest_Request `protobuf_oneof:"request"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *StateRequest) Reset()         { *m = StateRequest{} }
func (m *StateRequest) String() string { return proto.CompactTextString(m) }
func (*StateRequest) ProtoMessage()    {}
func (*StateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{18}
}

func (m *StateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateRequest.Unmarshal(m, b)
}
func (m *StateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateRequest.Marshal(b, m, deterministic)
}
func (m *StateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateRequest.Merge(m, src)
}
func (m *StateRequest) XXX_Size() int {
	return xxx_messageInfo_StateRequest.Size(m)
}
func (m *StateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateRequest proto.InternalMessageInfo

func (m *StateRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *StateRequest) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

func (m *StateRequest) GetStateKey() *StateKey {
	if m != nil {
		return m.StateKey
	}
	return nil
}

type isStateRequest_Request interface {
	isStateRequest_Request()
}

type StateRequest_Get struct {
	Get *StateGetRequest `protobuf:"bytes,1000,opt,name=get,proto3,oneof"`
}

type StateRequest_Append struct {
	Append *StateAppendRequest `protobuf:"bytes,1001,opt,name=append,proto3,oneof"`
}

type StateRequest_Clear struct {
	Clear *StateClearRequest `protobuf:"bytes,1002,opt,name=clear,proto3,oneof"`
}

func (*StateRequest_Get) isStateRequest_Request() {}

func (*StateRequest_Append) isStateRequest_Request() {}

func (*StateRequest_Clear) isStateRequest_Request() {}

func (m *StateRequest) GetRequest() isStateRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *StateRequest) GetGet() *StateGetRequest {
	if x, ok := m.GetRequest().(*StateRequest_Get); ok {
		return x.Get
	}
	return nil
}

func (m *StateRequest) GetAppend() *StateAppendRequest {
	if x, ok := m.GetRequest().(*StateRequest_Append); ok {
		return x.Append
	}
	return nil
}

func (m *StateRequest) GetClear() *StateClearRequest {
	if x, ok := m.GetRequest().(*StateRequest_Clear); ok {
		return x.Clear
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StateRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StateRequest_Get)(nil),
		(*StateRequest_Append)(nil),
		(*StateRequest_Clear)(nil),
	}
}

type StateResponse struct {
	// (Required) A reference provided by the SDK which represents a requests
	// execution. The StateResponse must have the matching id when responding
	// to the SDK.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// (Optional) If this is specified, then the state request has failed.
	// A human readable string representing the reason as to why the request
	// failed.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// A corresponding response matching the request will be populated.
	//
	// Types that are valid to be assigned to Response:
	//	*StateResponse_Get
	//	*StateResponse_Append
	//	*StateResponse_Clear
	Response             isStateResponse_Response `protobuf_oneof:"response"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *StateResponse) Reset()         { *m = StateResponse{} }
func (m *StateResponse) String() string { return proto.CompactTextString(m) }
func (*StateResponse) ProtoMessage()    {}
func (*StateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{19}
}

func (m *StateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateResponse.Unmarshal(m, b)
}
func (m *StateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateResponse.Marshal(b, m, deterministic)
}
func (m *StateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateResponse.Merge(m, src)
}
func (m *StateResponse) XXX_Size() int {
	return xxx_messageInfo_StateResponse.Size(m)
}
func (m *StateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateResponse proto.InternalMessageInfo

func (m *StateResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *StateResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type isStateResponse_Response interface {
	isStateResponse_Response()
}

type StateResponse_Get struct {
	Get *StateGetResponse `protobuf:"bytes,1000,opt,name=get,proto3,oneof"`
}

type StateResponse_Append struct {
	Append *StateAppendResponse `protobuf:"bytes,1001,opt,name=append,proto3,oneof"`
}

type StateResponse_Clear struct {
	Clear *StateClearResponse `protobuf:"bytes,1002,opt,name=clear,proto3,oneof"`
}

func (*StateResponse_Get) isStateResponse_Response() {}

func (*StateResponse_Append) isStateResponse_Response() {}

func (*StateResponse_Clear) isStateResponse_Response() {}

func (m *StateResponse) GetResponse() isStateResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *StateResponse) GetGet() *StateGetResponse {
	if x, ok := m.GetResponse().(*StateResponse_Get); ok {
		return x.Get
	}
	return nil
}

func (m *StateResponse) GetAppend() *StateAppendResponse {
	if x, ok := m.GetResponse().(*StateResponse_Append); ok {
		return x.Append
	}
	return nil
}

func (m *StateResponse) GetClear() *StateClearResponse {
	if x, ok := m.GetResponse().(*StateResponse_Clear); ok {
		return x.Clear
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StateResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StateResponse_Get)(nil),
		(*StateResponse_Append)(nil),
		(*StateResponse_Clear)(nil),
	}
}

type StateKey struct {
	// (Required) One of the following state keys must be set.
	//
	// Types that are valid to be assigned to Type:
	//	*StateKey_Runner_
	//	*StateKey_MultimapSideInput_
	//	*StateKey_BagUserState_
	//	*StateKey_IterableSideInput_
	//	*StateKey_MultimapKeysSideInput_
	Type                 isStateKey_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *StateKey) Reset()         { *m = StateKey{} }
func (m *StateKey) String() string { return proto.CompactTextString(m) }
func (*StateKey) ProtoMessage()    {}
func (*StateKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{20}
}

func (m *StateKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey.Unmarshal(m, b)
}
func (m *StateKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey.Marshal(b, m, deterministic)
}
func (m *StateKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey.Merge(m, src)
}
func (m *StateKey) XXX_Size() int {
	return xxx_messageInfo_StateKey.Size(m)
}
func (m *StateKey) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey proto.InternalMessageInfo

type isStateKey_Type interface {
	isStateKey_Type()
}

type StateKey_Runner_ struct {
	Runner *StateKey_Runner `protobuf:"bytes,1,opt,name=runner,proto3,oneof"`
}

type StateKey_MultimapSideInput_ struct {
	MultimapSideInput *StateKey_MultimapSideInput `protobuf:"bytes,2,opt,name=multimap_side_input,json=multimapSideInput,proto3,oneof"`
}

type StateKey_BagUserState_ struct {
	BagUserState *StateKey_BagUserState `protobuf:"bytes,3,opt,name=bag_user_state,json=bagUserState,proto3,oneof"`
}

type StateKey_IterableSideInput_ struct {
	IterableSideInput *StateKey_IterableSideInput `protobuf:"bytes,4,opt,name=iterable_side_input,json=iterableSideInput,proto3,oneof"`
}

type StateKey_MultimapKeysSideInput_ struct {
	MultimapKeysSideInput *StateKey_MultimapKeysSideInput `protobuf:"bytes,5,opt,name=multimap_keys_side_input,json=multimapKeysSideInput,proto3,oneof"`
}

func (*StateKey_Runner_) isStateKey_Type() {}

func (*StateKey_MultimapSideInput_) isStateKey_Type() {}

func (*StateKey_BagUserState_) isStateKey_Type() {}

func (*StateKey_IterableSideInput_) isStateKey_Type() {}

func (*StateKey_MultimapKeysSideInput_) isStateKey_Type() {}

func (m *StateKey) GetType() isStateKey_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *StateKey) GetRunner() *StateKey_Runner {
	if x, ok := m.GetType().(*StateKey_Runner_); ok {
		return x.Runner
	}
	return nil
}

func (m *StateKey) GetMultimapSideInput() *StateKey_MultimapSideInput {
	if x, ok := m.GetType().(*StateKey_MultimapSideInput_); ok {
		return x.MultimapSideInput
	}
	return nil
}

func (m *StateKey) GetBagUserState() *StateKey_BagUserState {
	if x, ok := m.GetType().(*StateKey_BagUserState_); ok {
		return x.BagUserState
	}
	return nil
}

func (m *StateKey) GetIterableSideInput() *StateKey_IterableSideInput {
	if x, ok := m.GetType().(*StateKey_IterableSideInput_); ok {
		return x.IterableSideInput
	}
	return nil
}

func (m *StateKey) GetMultimapKeysSideInput() *StateKey_MultimapKeysSideInput {
	if x, ok := m.GetType().(*StateKey_MultimapKeysSideInput_); ok {
		return x.MultimapKeysSideInput
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StateKey) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StateKey_Runner_)(nil),
		(*StateKey_MultimapSideInput_)(nil),
		(*StateKey_BagUserState_)(nil),
		(*StateKey_IterableSideInput_)(nil),
		(*StateKey_MultimapKeysSideInput_)(nil),
	}
}

type StateKey_Runner struct {
	// (Required) Opaque information supplied by the runner. Used to support
	// remote references.
	// https://s.apache.org/beam-fn-api-send-and-receive-data
	//
	// Used by state backed iterable. And in this use case, request type can
	// only be of type get. Details see:
	// https://s.apache.org/beam-fn-api-state-backed-iterables
	Key                  []byte   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateKey_Runner) Reset()         { *m = StateKey_Runner{} }
func (m *StateKey_Runner) String() string { return proto.CompactTextString(m) }
func (*StateKey_Runner) ProtoMessage()    {}
func (*StateKey_Runner) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{20, 0}
}

func (m *StateKey_Runner) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey_Runner.Unmarshal(m, b)
}
func (m *StateKey_Runner) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey_Runner.Marshal(b, m, deterministic)
}
func (m *StateKey_Runner) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey_Runner.Merge(m, src)
}
func (m *StateKey_Runner) XXX_Size() int {
	return xxx_messageInfo_StateKey_Runner.Size(m)
}
func (m *StateKey_Runner) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey_Runner.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey_Runner proto.InternalMessageInfo

func (m *StateKey_Runner) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

// Represents a request for the values associated with a specified window
// in a PCollection. See
// https://s.apache.org/beam-fn-state-api-and-bundle-processing for further
// details.
//
// Can only be used to perform StateGetRequests on side inputs of the URN
// beam:side_input:iterable:v1.
//
// For a PCollection<V>, the response data stream will be a concatenation
// of all V's. See https://s.apache.org/beam-fn-api-send-and-receive-data
// for further details.
type StateKey_IterableSideInput struct {
	// (Required) The id of the PTransform containing a side input.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The id of the side input.
	SideInputId string `protobuf:"bytes,2,opt,name=side_input_id,json=sideInputId,proto3" json:"side_input_id,omitempty"`
	// (Required) The window (after mapping the currently executing elements
	// window into the side input windows domain) encoded in a nested context.
	Window               []byte   `protobuf:"bytes,3,opt,name=window,proto3" json:"window,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateKey_IterableSideInput) Reset()         { *m = StateKey_IterableSideInput{} }
func (m *StateKey_IterableSideInput) String() string { return proto.CompactTextString(m) }
func (*StateKey_IterableSideInput) ProtoMessage()    {}
func (*StateKey_IterableSideInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{20, 1}
}

func (m *StateKey_IterableSideInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey_IterableSideInput.Unmarshal(m, b)
}
func (m *StateKey_IterableSideInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey_IterableSideInput.Marshal(b, m, deterministic)
}
func (m *StateKey_IterableSideInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey_IterableSideInput.Merge(m, src)
}
func (m *StateKey_IterableSideInput) XXX_Size() int {
	return xxx_messageInfo_StateKey_IterableSideInput.Size(m)
}
func (m *StateKey_IterableSideInput) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey_IterableSideInput.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey_IterableSideInput proto.InternalMessageInfo

func (m *StateKey_IterableSideInput) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *StateKey_IterableSideInput) GetSideInputId() string {
	if m != nil {
		return m.SideInputId
	}
	return ""
}

func (m *StateKey_IterableSideInput) GetWindow() []byte {
	if m != nil {
		return m.Window
	}
	return nil
}

// Represents a request for the values associated with a specified user key
// and window in a PCollection. See
// https://s.apache.org/beam-fn-state-api-and-bundle-processing for further
// details.
//
// Can only be used to perform StateGetRequests on side inputs of the URN
// beam:side_input:multimap:v1.
//
// For a PCollection<KV<K, V>>, the response data stream will be a
// concatenation of all V's associated with the specified key K. See
// https://s.apache.org/beam-fn-api-send-and-receive-data for further
// details.
type StateKey_MultimapSideInput struct {
	// (Required) The id of the PTransform containing a side input.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The id of the side input.
	SideInputId string `protobuf:"bytes,2,opt,name=side_input_id,json=sideInputId,proto3" json:"side_input_id,omitempty"`
	// (Required) The window (after mapping the currently executing elements
	// window into the side input windows domain) encoded in a nested context.
	Window []byte `protobuf:"bytes,3,opt,name=window,proto3" json:"window,omitempty"`
	// (Required) The key encoded in a nested context.
	Key                  []byte   `protobuf:"bytes,4,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateKey_MultimapSideInput) Reset()         { *m = StateKey_MultimapSideInput{} }
func (m *StateKey_MultimapSideInput) String() string { return proto.CompactTextString(m) }
func (*StateKey_MultimapSideInput) ProtoMessage()    {}
func (*StateKey_MultimapSideInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{20, 2}
}

func (m *StateKey_MultimapSideInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey_MultimapSideInput.Unmarshal(m, b)
}
func (m *StateKey_MultimapSideInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey_MultimapSideInput.Marshal(b, m, deterministic)
}
func (m *StateKey_MultimapSideInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey_MultimapSideInput.Merge(m, src)
}
func (m *StateKey_MultimapSideInput) XXX_Size() int {
	return xxx_messageInfo_StateKey_MultimapSideInput.Size(m)
}
func (m *StateKey_MultimapSideInput) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey_MultimapSideInput.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey_MultimapSideInput proto.InternalMessageInfo

func (m *StateKey_MultimapSideInput) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *StateKey_MultimapSideInput) GetSideInputId() string {
	if m != nil {
		return m.SideInputId
	}
	return ""
}

func (m *StateKey_MultimapSideInput) GetWindow() []byte {
	if m != nil {
		return m.Window
	}
	return nil
}

func (m *StateKey_MultimapSideInput) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

// Represents a request for the keys associated with a specified window in a PCollection. See
// https://s.apache.org/beam-fn-state-api-and-bundle-processing for further
// details.
//
// Can only be used to perform StateGetRequests on side inputs of the URN
// beam:side_input:multimap:v1.
//
// For a PCollection<KV<K, V>>, the response data stream will be a
// concatenation of all K's associated with the specified window. See
// https://s.apache.org/beam-fn-api-send-and-receive-data for further
// details.
type StateKey_MultimapKeysSideInput struct {
	// (Required) The id of the PTransform containing a side input.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The id of the side input.
	SideInputId string `protobuf:"bytes,2,opt,name=side_input_id,json=sideInputId,proto3" json:"side_input_id,omitempty"`
	// (Required) The window (after mapping the currently executing elements
	// window into the side input windows domain) encoded in a nested context.
	Window               []byte   `protobuf:"bytes,3,opt,name=window,proto3" json:"window,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateKey_MultimapKeysSideInput) Reset()         { *m = StateKey_MultimapKeysSideInput{} }
func (m *StateKey_MultimapKeysSideInput) String() string { return proto.CompactTextString(m) }
func (*StateKey_MultimapKeysSideInput) ProtoMessage()    {}
func (*StateKey_MultimapKeysSideInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{20, 3}
}

func (m *StateKey_MultimapKeysSideInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey_MultimapKeysSideInput.Unmarshal(m, b)
}
func (m *StateKey_MultimapKeysSideInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey_MultimapKeysSideInput.Marshal(b, m, deterministic)
}
func (m *StateKey_MultimapKeysSideInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey_MultimapKeysSideInput.Merge(m, src)
}
func (m *StateKey_MultimapKeysSideInput) XXX_Size() int {
	return xxx_messageInfo_StateKey_MultimapKeysSideInput.Size(m)
}
func (m *StateKey_MultimapKeysSideInput) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey_MultimapKeysSideInput.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey_MultimapKeysSideInput proto.InternalMessageInfo

func (m *StateKey_MultimapKeysSideInput) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *StateKey_MultimapKeysSideInput) GetSideInputId() string {
	if m != nil {
		return m.SideInputId
	}
	return ""
}

func (m *StateKey_MultimapKeysSideInput) GetWindow() []byte {
	if m != nil {
		return m.Window
	}
	return nil
}

type StateKey_BagUserState struct {
	// (Required) The id of the PTransform containing user state.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The id of the user state.
	UserStateId string `protobuf:"bytes,2,opt,name=user_state_id,json=userStateId,proto3" json:"user_state_id,omitempty"`
	// (Required) The window encoded in a nested context.
	Window []byte `protobuf:"bytes,3,opt,name=window,proto3" json:"window,omitempty"`
	// (Required) The key of the currently executing element encoded in a
	// nested context.
	Key                  []byte   `protobuf:"bytes,4,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateKey_BagUserState) Reset()         { *m = StateKey_BagUserState{} }
func (m *StateKey_BagUserState) String() string { return proto.CompactTextString(m) }
func (*StateKey_BagUserState) ProtoMessage()    {}
func (*StateKey_BagUserState) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{20, 4}
}

func (m *StateKey_BagUserState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey_BagUserState.Unmarshal(m, b)
}
func (m *StateKey_BagUserState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey_BagUserState.Marshal(b, m, deterministic)
}
func (m *StateKey_BagUserState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey_BagUserState.Merge(m, src)
}
func (m *StateKey_BagUserState) XXX_Size() int {
	return xxx_messageInfo_StateKey_BagUserState.Size(m)
}
func (m *StateKey_BagUserState) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey_BagUserState.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey_BagUserState proto.InternalMessageInfo

func (m *StateKey_BagUserState) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *StateKey_BagUserState) GetUserStateId() string {
	if m != nil {
		return m.UserStateId
	}
	return ""
}

func (m *StateKey_BagUserState) GetWindow() []byte {
	if m != nil {
		return m.Window
	}
	return nil
}

func (m *StateKey_BagUserState) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

// A request to get state.
type StateGetRequest struct {
	// (Optional) If specified, signals to the runner that the response
	// should resume from the following continuation token.
	//
	// If unspecified, signals to the runner that the response should start
	// from the beginning of the logical continuable stream.
	ContinuationToken    []byte   `protobuf:"bytes,1,opt,name=continuation_token,json=continuationToken,proto3" json:"continuation_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateGetRequest) Reset()         { *m = StateGetRequest{} }
func (m *StateGetRequest) String() string { return proto.CompactTextString(m) }
func (*StateGetRequest) ProtoMessage()    {}
func (*StateGetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{21}
}

func (m *StateGetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateGetRequest.Unmarshal(m, b)
}
func (m *StateGetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateGetRequest.Marshal(b, m, deterministic)
}
func (m *StateGetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateGetRequest.Merge(m, src)
}
func (m *StateGetRequest) XXX_Size() int {
	return xxx_messageInfo_StateGetRequest.Size(m)
}
func (m *StateGetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateGetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateGetRequest proto.InternalMessageInfo

func (m *StateGetRequest) GetContinuationToken() []byte {
	if m != nil {
		return m.ContinuationToken
	}
	return nil
}

// A response to get state representing a logical byte stream which can be
// continued using the state API.
type StateGetResponse struct {
	// (Optional) If specified, represents a token which can be used with the
	// state API to get the next chunk of this logical byte stream. The end of
	// the logical byte stream is signalled by this field being unset.
	ContinuationToken []byte `protobuf:"bytes,1,opt,name=continuation_token,json=continuationToken,proto3" json:"continuation_token,omitempty"`
	// Represents a part of a logical byte stream. Elements within
	// the logical byte stream are encoded in the nested context and
	// concatenated together.
	Data                 []byte   `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateGetResponse) Reset()         { *m = StateGetResponse{} }
func (m *StateGetResponse) String() string { return proto.CompactTextString(m) }
func (*StateGetResponse) ProtoMessage()    {}
func (*StateGetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{22}
}

func (m *StateGetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateGetResponse.Unmarshal(m, b)
}
func (m *StateGetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateGetResponse.Marshal(b, m, deterministic)
}
func (m *StateGetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateGetResponse.Merge(m, src)
}
func (m *StateGetResponse) XXX_Size() int {
	return xxx_messageInfo_StateGetResponse.Size(m)
}
func (m *StateGetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateGetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateGetResponse proto.InternalMessageInfo

func (m *StateGetResponse) GetContinuationToken() []byte {
	if m != nil {
		return m.ContinuationToken
	}
	return nil
}

func (m *StateGetResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// A request to append state.
type StateAppendRequest struct {
	// Represents a part of a logical byte stream. Elements within
	// the logical byte stream are encoded in the nested context and
	// multiple append requests are concatenated together.
	Data                 []byte   `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateAppendRequest) Reset()         { *m = StateAppendRequest{} }
func (m *StateAppendRequest) String() string { return proto.CompactTextString(m) }
func (*StateAppendRequest) ProtoMessage()    {}
func (*StateAppendRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{23}
}

func (m *StateAppendRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateAppendRequest.Unmarshal(m, b)
}
func (m *StateAppendRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateAppendRequest.Marshal(b, m, deterministic)
}
func (m *StateAppendRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateAppendRequest.Merge(m, src)
}
func (m *StateAppendRequest) XXX_Size() int {
	return xxx_messageInfo_StateAppendRequest.Size(m)
}
func (m *StateAppendRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateAppendRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateAppendRequest proto.InternalMessageInfo

func (m *StateAppendRequest) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// A response to append state.
type StateAppendResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateAppendResponse) Reset()         { *m = StateAppendResponse{} }
func (m *StateAppendResponse) String() string { return proto.CompactTextString(m) }
func (*StateAppendResponse) ProtoMessage()    {}
func (*StateAppendResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{24}
}

func (m *StateAppendResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateAppendResponse.Unmarshal(m, b)
}
func (m *StateAppendResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateAppendResponse.Marshal(b, m, deterministic)
}
func (m *StateAppendResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateAppendResponse.Merge(m, src)
}
func (m *StateAppendResponse) XXX_Size() int {
	return xxx_messageInfo_StateAppendResponse.Size(m)
}
func (m *StateAppendResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateAppendResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateAppendResponse proto.InternalMessageInfo

// A request to clear state.
type StateClearRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateClearRequest) Reset()         { *m = StateClearRequest{} }
func (m *StateClearRequest) String() string { return proto.CompactTextString(m) }
func (*StateClearRequest) ProtoMessage()    {}
func (*StateClearRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{25}
}

func (m *StateClearRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateClearRequest.Unmarshal(m, b)
}
func (m *StateClearRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateClearRequest.Marshal(b, m, deterministic)
}
func (m *StateClearRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateClearRequest.Merge(m, src)
}
func (m *StateClearRequest) XXX_Size() int {
	return xxx_messageInfo_StateClearRequest.Size(m)
}
func (m *StateClearRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateClearRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateClearRequest proto.InternalMessageInfo

// A response to clear state.
type StateClearResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateClearResponse) Reset()         { *m = StateClearResponse{} }
func (m *StateClearResponse) String() string { return proto.CompactTextString(m) }
func (*StateClearResponse) ProtoMessage()    {}
func (*StateClearResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{26}
}

func (m *StateClearResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateClearResponse.Unmarshal(m, b)
}
func (m *StateClearResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateClearResponse.Marshal(b, m, deterministic)
}
func (m *StateClearResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateClearResponse.Merge(m, src)
}
func (m *StateClearResponse) XXX_Size() int {
	return xxx_messageInfo_StateClearResponse.Size(m)
}
func (m *StateClearResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateClearResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateClearResponse proto.InternalMessageInfo

// A log entry
type LogEntry struct {
	// (Required) The severity of the log statement.
	Severity LogEntry_Severity_Enum `protobuf:"varint,1,opt,name=severity,proto3,enum=org.apache.beam.model.fn_execution.v1.LogEntry_Severity_Enum" json:"severity,omitempty"`
	// (Required) The time at which this log statement occurred.
	Timestamp *timestamp.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// (Required) A human readable message.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	// (Optional) An optional trace of the functions involved. For example, in
	// Java this can include multiple causes and multiple suppressed exceptions.
	Trace string `protobuf:"bytes,4,opt,name=trace,proto3" json:"trace,omitempty"`
	// (Optional) A reference to the instruction this log statement is associated
	// with.
	InstructionId string `protobuf:"bytes,5,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	// (Optional) A reference to the transform this log statement is
	// associated with.
	TransformId string `protobuf:"bytes,6,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Optional) Human-readable name of the function or method being invoked,
	// with optional context such as the class or package name. The format can
	// vary by language. For example:
	//   qual.if.ied.Class.method (Java)
	//   dir/package.func (Go)
	//   module.function (Python)
	//   file.cc:382 (C++)
	LogLocation string `protobuf:"bytes,7,opt,name=log_location,json=logLocation,proto3" json:"log_location,omitempty"`
	// (Optional) The name of the thread this log statement is associated with.
	Thread               string   `protobuf:"bytes,8,opt,name=thread,proto3" json:"thread,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogEntry) Reset()         { *m = LogEntry{} }
func (m *LogEntry) String() string { return proto.CompactTextString(m) }
func (*LogEntry) ProtoMessage()    {}
func (*LogEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{27}
}

func (m *LogEntry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogEntry.Unmarshal(m, b)
}
func (m *LogEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogEntry.Marshal(b, m, deterministic)
}
func (m *LogEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry.Merge(m, src)
}
func (m *LogEntry) XXX_Size() int {
	return xxx_messageInfo_LogEntry.Size(m)
}
func (m *LogEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry proto.InternalMessageInfo

func (m *LogEntry) GetSeverity() LogEntry_Severity_Enum {
	if m != nil {
		return m.Severity
	}
	return LogEntry_Severity_UNSPECIFIED
}

func (m *LogEntry) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *LogEntry) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *LogEntry) GetTrace() string {
	if m != nil {
		return m.Trace
	}
	return ""
}

func (m *LogEntry) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

func (m *LogEntry) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *LogEntry) GetLogLocation() string {
	if m != nil {
		return m.LogLocation
	}
	return ""
}

func (m *LogEntry) GetThread() string {
	if m != nil {
		return m.Thread
	}
	return ""
}

// A list of log entries, enables buffering and batching of multiple
// log messages using the logging API.
type LogEntry_List struct {
	// (Required) One or or more log messages.
	LogEntries           []*LogEntry `protobuf:"bytes,1,rep,name=log_entries,json=logEntries,proto3" json:"log_entries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *LogEntry_List) Reset()         { *m = LogEntry_List{} }
func (m *LogEntry_List) String() string { return proto.CompactTextString(m) }
func (*LogEntry_List) ProtoMessage()    {}
func (*LogEntry_List) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{27, 0}
}

func (m *LogEntry_List) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogEntry_List.Unmarshal(m, b)
}
func (m *LogEntry_List) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogEntry_List.Marshal(b, m, deterministic)
}
func (m *LogEntry_List) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry_List.Merge(m, src)
}
func (m *LogEntry_List) XXX_Size() int {
	return xxx_messageInfo_LogEntry_List.Size(m)
}
func (m *LogEntry_List) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry_List.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry_List proto.InternalMessageInfo

func (m *LogEntry_List) GetLogEntries() []*LogEntry {
	if m != nil {
		return m.LogEntries
	}
	return nil
}

// The severity of the event described in a log entry, expressed as one of the
// severity levels listed below. For your reference, the levels are
// assigned the listed numeric values. The effect of using numeric values
// other than those listed is undefined.
//
// If you are writing log entries, you should map other severity encodings to
// one of these standard levels. For example, you might map all of
// Java's FINE, FINER, and FINEST levels to `Severity.DEBUG`.
//
// This list is intentionally not comprehensive; the intent is to provide a
// common set of "good enough" severity levels so that logging front ends
// can provide filtering and searching across log types. Users of the API are
// free not to use all severity levels in their log messages.
type LogEntry_Severity struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogEntry_Severity) Reset()         { *m = LogEntry_Severity{} }
func (m *LogEntry_Severity) String() string { return proto.CompactTextString(m) }
func (*LogEntry_Severity) ProtoMessage()    {}
func (*LogEntry_Severity) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{27, 1}
}

func (m *LogEntry_Severity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogEntry_Severity.Unmarshal(m, b)
}
func (m *LogEntry_Severity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogEntry_Severity.Marshal(b, m, deterministic)
}
func (m *LogEntry_Severity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry_Severity.Merge(m, src)
}
func (m *LogEntry_Severity) XXX_Size() int {
	return xxx_messageInfo_LogEntry_Severity.Size(m)
}
func (m *LogEntry_Severity) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry_Severity.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry_Severity proto.InternalMessageInfo

type LogControl struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogControl) Reset()         { *m = LogControl{} }
func (m *LogControl) String() string { return proto.CompactTextString(m) }
func (*LogControl) ProtoMessage()    {}
func (*LogControl) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{28}
}

func (m *LogControl) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogControl.Unmarshal(m, b)
}
func (m *LogControl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogControl.Marshal(b, m, deterministic)
}
func (m *LogControl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogControl.Merge(m, src)
}
func (m *LogControl) XXX_Size() int {
	return xxx_messageInfo_LogControl.Size(m)
}
func (m *LogControl) XXX_DiscardUnknown() {
	xxx_messageInfo_LogControl.DiscardUnknown(m)
}

var xxx_messageInfo_LogControl proto.InternalMessageInfo

type StartWorkerRequest struct {
	WorkerId             string                            `protobuf:"bytes,1,opt,name=worker_id,json=workerId,proto3" json:"worker_id,omitempty"`
	ControlEndpoint      *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,2,opt,name=control_endpoint,json=controlEndpoint,proto3" json:"control_endpoint,omitempty"`
	LoggingEndpoint      *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,3,opt,name=logging_endpoint,json=loggingEndpoint,proto3" json:"logging_endpoint,omitempty"`
	ArtifactEndpoint     *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,4,opt,name=artifact_endpoint,json=artifactEndpoint,proto3" json:"artifact_endpoint,omitempty"`
	ProvisionEndpoint    *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,5,opt,name=provision_endpoint,json=provisionEndpoint,proto3" json:"provision_endpoint,omitempty"`
	Params               map[string]string                 `protobuf:"bytes,10,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *StartWorkerRequest) Reset()         { *m = StartWorkerRequest{} }
func (m *StartWorkerRequest) String() string { return proto.CompactTextString(m) }
func (*StartWorkerRequest) ProtoMessage()    {}
func (*StartWorkerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{29}
}

func (m *StartWorkerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartWorkerRequest.Unmarshal(m, b)
}
func (m *StartWorkerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartWorkerRequest.Marshal(b, m, deterministic)
}
func (m *StartWorkerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartWorkerRequest.Merge(m, src)
}
func (m *StartWorkerRequest) XXX_Size() int {
	return xxx_messageInfo_StartWorkerRequest.Size(m)
}
func (m *StartWorkerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartWorkerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartWorkerRequest proto.InternalMessageInfo

func (m *StartWorkerRequest) GetWorkerId() string {
	if m != nil {
		return m.WorkerId
	}
	return ""
}

func (m *StartWorkerRequest) GetControlEndpoint() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.ControlEndpoint
	}
	return nil
}

func (m *StartWorkerRequest) GetLoggingEndpoint() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.LoggingEndpoint
	}
	return nil
}

func (m *StartWorkerRequest) GetArtifactEndpoint() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.ArtifactEndpoint
	}
	return nil
}

func (m *StartWorkerRequest) GetProvisionEndpoint() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.ProvisionEndpoint
	}
	return nil
}

func (m *StartWorkerRequest) GetParams() map[string]string {
	if m != nil {
		return m.Params
	}
	return nil
}

type StartWorkerResponse struct {
	Error                string   `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StartWorkerResponse) Reset()         { *m = StartWorkerResponse{} }
func (m *StartWorkerResponse) String() string { return proto.CompactTextString(m) }
func (*StartWorkerResponse) ProtoMessage()    {}
func (*StartWorkerResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{30}
}

func (m *StartWorkerResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartWorkerResponse.Unmarshal(m, b)
}
func (m *StartWorkerResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartWorkerResponse.Marshal(b, m, deterministic)
}
func (m *StartWorkerResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartWorkerResponse.Merge(m, src)
}
func (m *StartWorkerResponse) XXX_Size() int {
	return xxx_messageInfo_StartWorkerResponse.Size(m)
}
func (m *StartWorkerResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StartWorkerResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StartWorkerResponse proto.InternalMessageInfo

func (m *StartWorkerResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

type StopWorkerRequest struct {
	WorkerId             string   `protobuf:"bytes,1,opt,name=worker_id,json=workerId,proto3" json:"worker_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopWorkerRequest) Reset()         { *m = StopWorkerRequest{} }
func (m *StopWorkerRequest) String() string { return proto.CompactTextString(m) }
func (*StopWorkerRequest) ProtoMessage()    {}
func (*StopWorkerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{31}
}

func (m *StopWorkerRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopWorkerRequest.Unmarshal(m, b)
}
func (m *StopWorkerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopWorkerRequest.Marshal(b, m, deterministic)
}
func (m *StopWorkerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopWorkerRequest.Merge(m, src)
}
func (m *StopWorkerRequest) XXX_Size() int {
	return xxx_messageInfo_StopWorkerRequest.Size(m)
}
func (m *StopWorkerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StopWorkerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StopWorkerRequest proto.InternalMessageInfo

func (m *StopWorkerRequest) GetWorkerId() string {
	if m != nil {
		return m.WorkerId
	}
	return ""
}

type StopWorkerResponse struct {
	Error                string   `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StopWorkerResponse) Reset()         { *m = StopWorkerResponse{} }
func (m *StopWorkerResponse) String() string { return proto.CompactTextString(m) }
func (*StopWorkerResponse) ProtoMessage()    {}
func (*StopWorkerResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{32}
}

func (m *StopWorkerResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StopWorkerResponse.Unmarshal(m, b)
}
func (m *StopWorkerResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StopWorkerResponse.Marshal(b, m, deterministic)
}
func (m *StopWorkerResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StopWorkerResponse.Merge(m, src)
}
func (m *StopWorkerResponse) XXX_Size() int {
	return xxx_messageInfo_StopWorkerResponse.Size(m)
}
func (m *StopWorkerResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StopWorkerResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StopWorkerResponse proto.InternalMessageInfo

func (m *StopWorkerResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// Request from runner to SDK Harness asking for its status. For more details see
// https://s.apache.org/beam-fn-api-harness-status
type WorkerStatusRequest struct {
	// (Required) Unique ID identifying this request.
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WorkerStatusRequest) Reset()         { *m = WorkerStatusRequest{} }
func (m *WorkerStatusRequest) String() string { return proto.CompactTextString(m) }
func (*WorkerStatusRequest) ProtoMessage()    {}
func (*WorkerStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{33}
}

func (m *WorkerStatusRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WorkerStatusRequest.Unmarshal(m, b)
}
func (m *WorkerStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WorkerStatusRequest.Marshal(b, m, deterministic)
}
func (m *WorkerStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkerStatusRequest.Merge(m, src)
}
func (m *WorkerStatusRequest) XXX_Size() int {
	return xxx_messageInfo_WorkerStatusRequest.Size(m)
}
func (m *WorkerStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkerStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WorkerStatusRequest proto.InternalMessageInfo

func (m *WorkerStatusRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// Response from SDK Harness to runner containing the debug related status info.
type WorkerStatusResponse struct {
	// (Required) Unique ID from the original request.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// (Optional) Error message if exception encountered generating the status response.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// (Optional) Status debugging info reported by SDK harness worker. Content and
	// format is not strongly enforced but should be print-friendly and
	// appropriate as an HTTP response body for end user. For details of the preferred
	// info to include in the message see
	// https://s.apache.org/beam-fn-api-harness-status
	StatusInfo           string   `protobuf:"bytes,3,opt,name=status_info,json=statusInfo,proto3" json:"status_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WorkerStatusResponse) Reset()         { *m = WorkerStatusResponse{} }
func (m *WorkerStatusResponse) String() string { return proto.CompactTextString(m) }
func (*WorkerStatusResponse) ProtoMessage()    {}
func (*WorkerStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_6d954c03a4758710, []int{34}
}

func (m *WorkerStatusResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WorkerStatusResponse.Unmarshal(m, b)
}
func (m *WorkerStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WorkerStatusResponse.Marshal(b, m, deterministic)
}
func (m *WorkerStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkerStatusResponse.Merge(m, src)
}
func (m *WorkerStatusResponse) XXX_Size() int {
	return xxx_messageInfo_WorkerStatusResponse.Size(m)
}
func (m *WorkerStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkerStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_WorkerStatusResponse proto.InternalMessageInfo

func (m *WorkerStatusResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *WorkerStatusResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *WorkerStatusResponse) GetStatusInfo() string {
	if m != nil {
		return m.StatusInfo
	}
	return ""
}

func init() {
	proto.RegisterEnum("org.apache.beam.model.fn_execution.v1.LogEntry_Severity_Enum", LogEntry_Severity_Enum_name, LogEntry_Severity_Enum_value)
	proto.RegisterType((*RemoteGrpcPort)(nil), "org.apache.beam.model.fn_execution.v1.RemoteGrpcPort")
	proto.RegisterType((*InstructionRequest)(nil), "org.apache.beam.model.fn_execution.v1.InstructionRequest")
	proto.RegisterType((*InstructionResponse)(nil), "org.apache.beam.model.fn_execution.v1.InstructionResponse")
	proto.RegisterType((*RegisterRequest)(nil), "org.apache.beam.model.fn_execution.v1.RegisterRequest")
	proto.RegisterType((*RegisterResponse)(nil), "org.apache.beam.model.fn_execution.v1.RegisterResponse")
	proto.RegisterType((*ProcessBundleDescriptor)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor")
	proto.RegisterMapType((map[string]*pipeline_v1.Coder)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.CodersEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.Environment)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.EnvironmentsEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.PCollection)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.PcollectionsEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.PTransform)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.TransformsEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.WindowingStrategy)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.WindowingStrategiesEntry")
	proto.RegisterType((*BundleApplication)(nil), "org.apache.beam.model.fn_execution.v1.BundleApplication")
	proto.RegisterMapType((map[string]*timestamp.Timestamp)(nil), "org.apache.beam.model.fn_execution.v1.BundleApplication.OutputWatermarksEntry")
	proto.RegisterType((*DelayedBundleApplication)(nil), "org.apache.beam.model.fn_execution.v1.DelayedBundleApplication")
	proto.RegisterType((*ProcessBundleRequest)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleRequest")
	proto.RegisterType((*ProcessBundleRequest_CacheToken)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken")
	proto.RegisterType((*ProcessBundleRequest_CacheToken_UserState)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken.UserState")
	proto.RegisterType((*ProcessBundleRequest_CacheToken_SideInput)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken.SideInput")
	proto.RegisterType((*ProcessBundleResponse)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleResponse")
	proto.RegisterType((*ProcessBundleProgressRequest)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleProgressRequest")
	proto.RegisterType((*Metrics)(nil), "org.apache.beam.model.fn_execution.v1.Metrics")
	proto.RegisterMapType((map[string]*Metrics_PTransform)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PtransformsEntry")
	proto.RegisterType((*Metrics_PTransform)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform")
	proto.RegisterMapType((map[string]int64)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.WatermarksEntry")
	proto.RegisterType((*Metrics_PTransform_Measured)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.Measured")
	proto.RegisterMapType((map[string]int64)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.Measured.InputElementCountsEntry")
	proto.RegisterMapType((map[string]int64)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.Measured.OutputElementCountsEntry")
	proto.RegisterType((*Metrics_PTransform_ProcessedElements)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.ProcessedElements")
	proto.RegisterType((*Metrics_PTransform_ActiveElements)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.ActiveElements")
	proto.RegisterMapType((map[string]int64)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.ActiveElements.OutputElementsRemainingEntry")
	proto.RegisterType((*Metrics_User)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User")
	proto.RegisterType((*Metrics_User_MetricName)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User.MetricName")
	proto.RegisterType((*Metrics_User_CounterData)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User.CounterData")
	proto.RegisterType((*Metrics_User_DistributionData)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User.DistributionData")
	proto.RegisterType((*Metrics_User_GaugeData)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User.GaugeData")
	proto.RegisterType((*ProcessBundleProgressResponse)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleProgressResponse")
	proto.RegisterType((*ProcessBundleSplitRequest)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest")
	proto.RegisterMapType((map[string]*ProcessBundleSplitRequest_DesiredSplit)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest.DesiredSplitsEntry")
	proto.RegisterType((*ProcessBundleSplitRequest_DesiredSplit)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest.DesiredSplit")
	proto.RegisterType((*ProcessBundleSplitResponse)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse")
	proto.RegisterType((*ProcessBundleSplitResponse_ChannelSplit)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse.ChannelSplit")
	proto.RegisterType((*FinalizeBundleRequest)(nil), "org.apache.beam.model.fn_execution.v1.FinalizeBundleRequest")
	proto.RegisterType((*FinalizeBundleResponse)(nil), "org.apache.beam.model.fn_execution.v1.FinalizeBundleResponse")
	proto.RegisterType((*Elements)(nil), "org.apache.beam.model.fn_execution.v1.Elements")
	proto.RegisterType((*Elements_Data)(nil), "org.apache.beam.model.fn_execution.v1.Elements.Data")
	proto.RegisterType((*StateRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateRequest")
	proto.RegisterType((*StateResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateResponse")
	proto.RegisterType((*StateKey)(nil), "org.apache.beam.model.fn_execution.v1.StateKey")
	proto.RegisterType((*StateKey_Runner)(nil), "org.apache.beam.model.fn_execution.v1.StateKey.Runner")
	proto.RegisterType((*StateKey_IterableSideInput)(nil), "org.apache.beam.model.fn_execution.v1.StateKey.IterableSideInput")
	proto.RegisterType((*StateKey_MultimapSideInput)(nil), "org.apache.beam.model.fn_execution.v1.StateKey.MultimapSideInput")
	proto.RegisterType((*StateKey_MultimapKeysSideInput)(nil), "org.apache.beam.model.fn_execution.v1.StateKey.MultimapKeysSideInput")
	proto.RegisterType((*StateKey_BagUserState)(nil), "org.apache.beam.model.fn_execution.v1.StateKey.BagUserState")
	proto.RegisterType((*StateGetRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateGetRequest")
	proto.RegisterType((*StateGetResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateGetResponse")
	proto.RegisterType((*StateAppendRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateAppendRequest")
	proto.RegisterType((*StateAppendResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateAppendResponse")
	proto.RegisterType((*StateClearRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateClearRequest")
	proto.RegisterType((*StateClearResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateClearResponse")
	proto.RegisterType((*LogEntry)(nil), "org.apache.beam.model.fn_execution.v1.LogEntry")
	proto.RegisterType((*LogEntry_List)(nil), "org.apache.beam.model.fn_execution.v1.LogEntry.List")
	proto.RegisterType((*LogEntry_Severity)(nil), "org.apache.beam.model.fn_execution.v1.LogEntry.Severity")
	proto.RegisterType((*LogControl)(nil), "org.apache.beam.model.fn_execution.v1.LogControl")
	proto.RegisterType((*StartWorkerRequest)(nil), "org.apache.beam.model.fn_execution.v1.StartWorkerRequest")
	proto.RegisterMapType((map[string]string)(nil), "org.apache.beam.model.fn_execution.v1.StartWorkerRequest.ParamsEntry")
	proto.RegisterType((*StartWorkerResponse)(nil), "org.apache.beam.model.fn_execution.v1.StartWorkerResponse")
	proto.RegisterType((*StopWorkerRequest)(nil), "org.apache.beam.model.fn_execution.v1.StopWorkerRequest")
	proto.RegisterType((*StopWorkerResponse)(nil), "org.apache.beam.model.fn_execution.v1.StopWorkerResponse")
	proto.RegisterType((*WorkerStatusRequest)(nil), "org.apache.beam.model.fn_execution.v1.WorkerStatusRequest")
	proto.RegisterType((*WorkerStatusResponse)(nil), "org.apache.beam.model.fn_execution.v1.WorkerStatusResponse")
}

func init() { proto.RegisterFile("beam_fn_api.proto", fileDescriptor_6d954c03a4758710) }

var fileDescriptor_6d954c03a4758710 = []byte{
	// 3276 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x5b, 0xcd, 0x6f, 0x1b, 0xd7,
	0xb5, 0xf7, 0x88, 0x94, 0x44, 0x1e, 0x52, 0x12, 0x79, 0x25, 0xd9, 0xf4, 0x3c, 0xbf, 0x17, 0x87,
	0xef, 0x05, 0x10, 0x5e, 0x11, 0xda, 0x96, 0x8d, 0xc4, 0x4e, 0x13, 0x27, 0x12, 0x45, 0xdb, 0x8c,
	0x65, 0x9b, 0x1d, 0xd9, 0x75, 0x9b, 0x34, 0x19, 0x8c, 0x38, 0x97, 0xf4, 0xc0, 0xc3, 0x99, 0xc9,
	0xbd, 0x43, 0xd9, 0x72, 0x83, 0xa6, 0x5f, 0x68, 0xd1, 0xa2, 0x41, 0x36, 0x5d, 0xa4, 0xdd, 0xf5,
	0x03, 0x05, 0xba, 0xe9, 0xb2, 0x8b, 0x6c, 0xbb, 0xe8, 0xb2, 0xff, 0x40, 0x36, 0x05, 0x5a, 0xa0,
	0x6d, 0xba, 0xe9, 0xa6, 0x40, 0x77, 0xc5, 0xfd, 0x98, 0x0f, 0x0e, 0x87, 0xce, 0x90, 0x92, 0xbb,
	0x9b, 0x7b, 0xcf, 0x9c, 0xdf, 0xef, 0xde, 0x33, 0xe7, 0x9e, 0x7b, 0xce, 0xbd, 0x24, 0x54, 0xf7,
	0xb1, 0x31, 0xd0, 0x7b, 0x8e, 0x6e, 0x78, 0x56, 0xc3, 0x23, 0xae, 0xef, 0xa2, 0x17, 0x5c, 0xd2,
	0x6f, 0x18, 0x9e, 0xd1, 0x7d, 0x80, 0x1b, 0x4c, 0xda, 0x18, 0xb8, 0x26, 0xb6, 0x1b, 0x3d, 0x47,
	0xc7, 0x8f, 0x71, 0x77, 0xe8, 0x5b, 0xae, 0xd3, 0x38, 0xb8, 0xa0, 0xae, 0x73, 0x4d, 0x32, 0x74,
	0x1c, 0x4c, 0x22, 0x6d, 0x75, 0x05, 0x3b, 0xa6, 0xe7, 0x5a, 0x8e, 0x4f, 0x65, 0xc7, 0xd9, 0xbe,
	0xeb, 0xf6, 0x6d, 0x7c, 0x8e, 0xb7, 0xf6, 0x87, 0xbd, 0x73, 0x26, 0xa6, 0x5d, 0x62, 0x79, 0xbe,
	0x4b, 0xe4, 0x1b, 0xcf, 0x25, 0xdf, 0xf0, 0xad, 0x01, 0xa6, 0xbe, 0x31, 0xf0, 0xe4, 0x0b, 0xff,
	0x33, 0x06, 0x31, 0x24, 0x06, 0x1f, 0xc7, 0x04, 0xf9, 0x23, 0x62, 0x78, 0x1e, 0x26, 0xc1, 0x10,
	0x96, 0x06, 0xd8, 0x27, 0x56, 0x57, 0x36, 0xeb, 0x3f, 0x55, 0x60, 0x59, 0xc3, 0x03, 0xd7, 0xc7,
	0xd7, 0x89, 0xd7, 0xed, 0xb8, 0xc4, 0x47, 0x03, 0x38, 0x69, 0x78, 0x96, 0x4e, 0x31, 0x39, 0xb0,
	0xba, 0x58, 0x8f, 0x86, 0x58, 0x53, 0xce, 0x2a, 0x1b, 0xa5, 0xcd, 0x97, 0x1b, 0xe9, 0x46, 0xf1,
	0x2c, 0x0f, 0xdb, 0x96, 0x83, 0x1b, 0x07, 0x17, 0x1a, 0x5b, 0x9e, 0xb5, 0x27, 0xf4, 0x77, 0x42,
	0x75, 0x6d, 0xcd, 0x48, 0xe9, 0x45, 0xa7, 0xa1, 0xd0, 0x75, 0x4d, 0x4c, 0x74, 0xcb, 0xac, 0xcd,
	0x9d, 0x55, 0x36, 0x8a, 0xda, 0x22, 0x6f, 0xb7, 0xcd, 0xfa, 0x9f, 0xf3, 0x80, 0xda, 0x0e, 0xf5,
	0xc9, 0xb0, 0xcb, 0x66, 0xa8, 0xe1, 0xf7, 0x86, 0x98, 0xfa, 0xe8, 0x05, 0x58, 0xb6, 0xa2, 0x5e,
	0xa6, 0xa7, 0x70, 0xbd, 0xa5, 0x58, 0x6f, 0xdb, 0x44, 0xf7, 0xa0, 0x40, 0x70, 0xdf, 0xa2, 0x3e,
	0x26, 0xb5, 0xbf, 0x2c, 0xf2, 0xa1, 0xbf, 0xd4, 0xc8, 0xf4, 0x3d, 0x1b, 0x9a, 0xd4, 0x93, 0x8c,
	0x37, 0x4e, 0x68, 0x21, 0x14, 0xc2, 0xb0, 0xec, 0x11, 0xb7, 0x8b, 0x29, 0xd5, 0xf7, 0x87, 0x8e,
	0x69, 0xe3, 0xda, 0x5f, 0x05, 0xf8, 0x17, 0x33, 0x82, 0x77, 0x84, 0xf6, 0x36, 0x57, 0x8e, 0x18,
	0x96, 0xbc, 0x78, 0x3f, 0xfa, 0x06, 0x9c, 0x1a, 0xa5, 0xd1, 0x3d, 0xe2, 0xf6, 0x09, 0xa6, 0xb4,
	0xf6, 0x37, 0xc1, 0xd7, 0x9c, 0x85, 0xaf, 0x23, 0x41, 0x22, 0xde, 0x75, 0x2f, 0x4d, 0x8e, 0x86,
	0xb0, 0x96, 0xe0, 0xa7, 0x9e, 0x6d, 0xf9, 0xb5, 0xcf, 0x04, 0xf9, 0x1b, 0xb3, 0x90, 0xef, 0x31,
	0x84, 0x88, 0x19, 0x79, 0x63, 0x42, 0xf4, 0x00, 0x56, 0x7a, 0x96, 0x63, 0xd8, 0xd6, 0x13, 0x1c,
	0x98, 0xf7, 0xef, 0x82, 0xf1, 0xd5, 0x8c, 0x8c, 0xd7, 0xa4, 0x7a, 0xd2, 0xbe, 0xcb, 0xbd, 0x11,
	0xc1, 0x76, 0x11, 0x16, 0x89, 0x10, 0xd6, 0xbf, 0x3d, 0x0f, 0xab, 0x23, 0x7e, 0x46, 0x3d, 0xd7,
	0xa1, 0x38, 0xab, 0xa3, 0xad, 0xc1, 0x3c, 0x26, 0xc4, 0x25, 0xd2, 0x7d, 0x45, 0x03, 0x7d, 0x79,
	0xdc, 0xfd, 0x5e, 0x9e, 0xda, 0xfd, 0xc4, 0x40, 0x46, 0xfc, 0xaf, 0x37, 0xc9, 0xff, 0x5e, 0x9d,
	0xcd, 0xff, 0x42, 0x8a, 0x84, 0x03, 0x7e, 0xf0, 0xb9, 0x0e, 0xb8, 0x73, 0x34, 0x07, 0x0c, 0x89,
	0x27, 0x78, 0xe0, 0xc1, 0xd3, 0x3d, 0x70, 0xeb, 0x08, 0x1e, 0x18, 0x52, 0xa7, 0xb9, 0xa0, 0x35,
	0xd1, 0x05, 0x5f, 0x9b, 0xd1, 0x05, 0x43, 0xba, 0xa4, 0x0f, 0x02, 0xf3, 0x11, 0x21, 0xad, 0x7f,
	0xa8, 0xc0, 0x4a, 0x22, 0xee, 0xa0, 0x27, 0x70, 0x3a, 0x61, 0x82, 0x91, 0x68, 0x9c, 0xdb, 0x28,
	0x6d, 0x5e, 0x9d, 0xc5, 0x0c, 0xb1, 0xa0, 0x7c, 0xca, 0x4b, 0x17, 0xd4, 0x11, 0x54, 0x92, 0x7e,
	0x58, 0xff, 0x05, 0xc0, 0xa9, 0x09, 0x40, 0x68, 0x19, 0xe6, 0xc2, 0x05, 0x32, 0x67, 0x99, 0xc8,
	0x01, 0xf0, 0x89, 0xe1, 0xd0, 0x9e, 0x4b, 0x06, 0xb4, 0x36, 0xc7, 0x07, 0x7b, 0xfb, 0x68, 0x83,
	0x6d, 0xdc, 0x0d, 0x01, 0x5b, 0x8e, 0x4f, 0x0e, 0xb5, 0x18, 0x03, 0xf2, 0xa1, 0xec, 0x75, 0x5d,
	0xdb, 0xc6, 0x7c, 0x59, 0xd2, 0x5a, 0x8e, 0x33, 0x76, 0x8e, 0xc8, 0xd8, 0x89, 0x41, 0x0a, 0xce,
	0x11, 0x16, 0xf4, 0x43, 0x05, 0xd6, 0x1e, 0x59, 0x8e, 0xe9, 0x3e, 0xb2, 0x9c, 0xbe, 0x4e, 0x7d,
	0x62, 0xf8, 0xb8, 0x6f, 0x61, 0x5a, 0xcb, 0x73, 0xfa, 0xfb, 0x47, 0xa4, 0xbf, 0x1f, 0x40, 0xef,
	0x85, 0xc8, 0x62, 0x14, 0xab, 0x8f, 0xc6, 0x25, 0x68, 0x1f, 0x16, 0xf8, 0xd6, 0x49, 0x6b, 0xf3,
	0x9c, 0xfd, 0xcd, 0x23, 0xb2, 0x37, 0x39, 0x98, 0x20, 0x94, 0xc8, 0xcc, 0xcc, 0xd8, 0x39, 0xb0,
	0x88, 0xeb, 0x0c, 0xb0, 0xe3, 0xd3, 0xda, 0xc2, 0xb1, 0x98, 0xb9, 0x15, 0x83, 0x94, 0x66, 0x8e,
	0xb3, 0xa0, 0xc7, 0x70, 0x86, 0xfa, 0x86, 0x8f, 0xf5, 0x09, 0x99, 0xc9, 0xe2, 0xd1, 0x32, 0x93,
	0xd3, 0x1c, 0x3c, 0x4d, 0xa4, 0xda, 0xb0, 0x92, 0xf0, 0x3a, 0x54, 0x81, 0xdc, 0x43, 0x7c, 0x28,
	0x5d, 0x9d, 0x3d, 0xa2, 0x26, 0xcc, 0x1f, 0x18, 0xf6, 0x10, 0xf3, 0x1d, 0xa0, 0xb4, 0xf9, 0x62,
	0x86, 0x71, 0x74, 0x42, 0x54, 0x4d, 0xe8, 0xbe, 0x32, 0x77, 0x59, 0x51, 0x5d, 0xa8, 0x8e, 0x79,
	0x5c, 0x0a, 0xdf, 0xce, 0x28, 0x5f, 0x23, 0x0b, 0x5f, 0x33, 0x84, 0x8d, 0x13, 0xbe, 0x0f, 0xb5,
	0x49, 0x3e, 0x96, 0xc2, 0xfb, 0xe6, 0x28, 0xef, 0xa5, 0x0c, 0xbc, 0x49, 0xf4, 0xc3, 0x38, 0x7b,
	0x17, 0x4a, 0x31, 0x1f, 0x4b, 0x21, 0xbc, 0x3a, 0x4a, 0xb8, 0x91, 0x81, 0x90, 0x03, 0x26, 0x6c,
	0x3a, 0xe6, 0x5e, 0xc7, 0x63, 0xd3, 0x18, 0x6c, 0x8c, 0xb0, 0xfe, 0xaf, 0x1c, 0x54, 0x85, 0x87,
	0x6f, 0x79, 0x9e, 0x6d, 0x75, 0x79, 0x7a, 0x8e, 0x9e, 0x87, 0x72, 0x18, 0xad, 0xa2, 0x54, 0xa2,
	0x14, 0xf6, 0xb5, 0x4d, 0x96, 0x0a, 0x5b, 0x8e, 0x37, 0xf4, 0x63, 0xa9, 0x30, 0x6f, 0xb7, 0x4d,
	0x54, 0x83, 0x45, 0x6c, 0x63, 0xc6, 0x54, 0xcb, 0x9d, 0x55, 0x36, 0xca, 0x5a, 0xd0, 0x44, 0x5f,
	0x87, 0xaa, 0x3b, 0xf4, 0x99, 0xd6, 0x23, 0xc3, 0xc7, 0x64, 0x60, 0x90, 0x87, 0x41, 0xf4, 0xc9,
	0x1a, 0x6e, 0xc7, 0x06, 0xdb, 0xb8, 0xc3, 0x11, 0xef, 0x87, 0x80, 0x62, 0x4d, 0x56, 0xdc, 0x44,
	0x37, 0xea, 0x00, 0x58, 0x54, 0xdf, 0x77, 0x87, 0x8e, 0x89, 0xcd, 0xda, 0xfc, 0x59, 0x65, 0x63,
	0x79, 0xf3, 0x42, 0x06, 0xcb, 0xb5, 0xe9, 0xb6, 0xd0, 0x69, 0xb4, 0x9c, 0xe1, 0x40, 0x2b, 0x5a,
	0x41, 0x1b, 0x7d, 0x0d, 0x2a, 0x03, 0xd7, 0xb1, 0x7c, 0x97, 0xb0, 0x80, 0x6a, 0x39, 0x3d, 0x37,
	0x88, 0x31, 0x59, 0x70, 0x6f, 0x85, 0xaa, 0x6d, 0xa7, 0xe7, 0x6a, 0x2b, 0x83, 0x91, 0x36, 0x55,
	0x75, 0x58, 0x4f, 0x9d, 0x5a, 0x8a, 0x3f, 0x9c, 0x1f, 0xf5, 0x07, 0xb5, 0x21, 0x0a, 0xab, 0x46,
	0x50, 0x58, 0x35, 0xee, 0x06, 0x95, 0x59, 0xfc, 0xdb, 0xff, 0x4e, 0x81, 0xda, 0x0e, 0xb6, 0x8d,
	0x43, 0x6c, 0x8e, 0xbb, 0xc0, 0x5b, 0x50, 0x32, 0xa2, 0xa6, 0x2c, 0xa7, 0x2e, 0xcf, 0xfa, 0x91,
	0xb4, 0x38, 0x18, 0xba, 0x09, 0x6b, 0x32, 0x9d, 0xc5, 0xa6, 0xce, 0x8a, 0x46, 0xdd, 0x64, 0xc3,
	0x90, 0xa3, 0x3f, 0x3d, 0x36, 0xfa, 0x1d, 0x59, 0x36, 0x6a, 0x28, 0x54, 0x63, 0x13, 0xe2, 0x63,
	0xaf, 0xff, 0x36, 0x0f, 0x6b, 0x69, 0x65, 0x0a, 0x7a, 0x1d, 0xce, 0x4c, 0x4c, 0x48, 0x22, 0xa7,
	0x3e, 0x3d, 0x21, 0xa7, 0x68, 0x9b, 0xc8, 0x82, 0x72, 0x97, 0xcd, 0x54, 0xf7, 0xdd, 0x87, 0xd8,
	0x09, 0xf2, 0x82, 0x6b, 0x47, 0x28, 0x9d, 0x1a, 0x4d, 0xa6, 0x75, 0x97, 0xc1, 0x69, 0xa5, 0x6e,
	0xf8, 0x4c, 0xd5, 0x7f, 0xcc, 0x01, 0x44, 0x32, 0xf4, 0x1e, 0xc0, 0x90, 0x62, 0xa2, 0xf3, 0x50,
	0x2f, 0x6d, 0xdf, 0x39, 0x1e, 0xde, 0xc6, 0x3d, 0x8a, 0xc9, 0x1e, 0xc3, 0xbd, 0x71, 0x42, 0x2b,
	0x0e, 0x83, 0x06, 0xa3, 0xa4, 0x96, 0x89, 0x75, 0xbe, 0x88, 0xe5, 0x97, 0x38, 0x2e, 0xca, 0x3d,
	0xcb, 0xc4, 0x6d, 0x86, 0xcb, 0x28, 0x69, 0xd0, 0x60, 0xb5, 0x08, 0xb7, 0x6c, 0x0d, 0x78, 0x94,
	0x10, 0x0d, 0xb5, 0x04, 0xc5, 0x70, 0x88, 0xaa, 0x06, 0xc5, 0x50, 0x39, 0x4b, 0x54, 0xaa, 0xc3,
	0x52, 0x34, 0x8b, 0x28, 0x34, 0x95, 0x42, 0xd2, 0xb6, 0xb9, 0xbd, 0x00, 0x79, 0xff, 0xd0, 0xc3,
	0xf5, 0x4f, 0xe7, 0x60, 0x3d, 0xb5, 0xbe, 0x40, 0x37, 0x60, 0x51, 0x9e, 0x3c, 0x48, 0xdb, 0x37,
	0x32, 0x1a, 0xe2, 0x96, 0xd0, 0xd2, 0x02, 0x75, 0x56, 0x00, 0x11, 0x4c, 0x2d, 0x73, 0x68, 0xd8,
	0x3a, 0x71, 0x5d, 0x3f, 0x70, 0xa2, 0xd7, 0x33, 0x02, 0x4e, 0x5a, 0x9e, 0xda, 0x52, 0x00, 0xab,
	0x31, 0xd4, 0xd4, 0x48, 0x94, 0x3b, 0xae, 0x48, 0x84, 0x2e, 0xc2, 0x3a, 0x5b, 0x78, 0x16, 0xc1,
	0x54, 0x97, 0x55, 0x81, 0x88, 0x0a, 0xf9, 0xb3, 0xca, 0x46, 0x41, 0x5b, 0x0b, 0x84, 0xd7, 0x62,
	0xb2, 0x7a, 0x0b, 0xce, 0x3c, 0xad, 0x9a, 0xcf, 0x58, 0xb0, 0xd6, 0x3f, 0x5e, 0x85, 0x45, 0x69,
	0x56, 0x64, 0x40, 0xc9, 0x8b, 0xe5, 0xe9, 0xca, 0x54, 0xa6, 0x94, 0x20, 0x8d, 0x8e, 0x9f, 0x48,
	0xcc, 0xe3, 0x98, 0xea, 0xa7, 0x25, 0x80, 0x28, 0xdd, 0x41, 0x4f, 0x20, 0xa8, 0xba, 0xb0, 0xa9,
	0xcb, 0x5d, 0x2c, 0x70, 0x8a, 0x9b, 0xd3, 0x12, 0x87, 0xb0, 0xc1, 0x82, 0xc1, 0x66, 0x4b, 0x42,
	0x6a, 0x55, 0x2f, 0xd9, 0x85, 0xde, 0x83, 0x15, 0xa3, 0xeb, 0x5b, 0x07, 0x38, 0x22, 0x16, 0xcb,
	0xf2, 0xc6, 0xec, 0xc4, 0x5b, 0x1c, 0x30, 0x64, 0x5d, 0x36, 0x46, 0xda, 0xc8, 0x02, 0x88, 0x6d,
	0xcc, 0xc2, 0x81, 0xda, 0xb3, 0xb3, 0x25, 0xf7, 0xe4, 0x18, 0x38, 0xba, 0x0e, 0x79, 0x16, 0x7c,
	0xe4, 0xee, 0x7f, 0x71, 0x4a, 0x12, 0x16, 0x21, 0x34, 0x0e, 0xa0, 0xfe, 0x29, 0x07, 0x85, 0x5b,
	0xd8, 0xa0, 0x43, 0x82, 0x4d, 0xf4, 0x23, 0x05, 0xd6, 0xc4, 0xda, 0x97, 0x36, 0xd3, 0xbb, 0xee,
	0x50, 0x7c, 0x32, 0x46, 0xf3, 0xd6, 0xec, 0x73, 0x09, 0x28, 0x1a, 0x3c, 0x8c, 0x48, 0x8b, 0x35,
	0x39, 0xb8, 0x98, 0x1c, 0xb2, 0xc6, 0x04, 0xe8, 0x23, 0x05, 0xd6, 0x65, 0xc2, 0x93, 0x18, 0x8f,
	0x08, 0x03, 0x6f, 0x1f, 0xc3, 0x78, 0x44, 0x8e, 0x90, 0x32, 0xa0, 0x55, 0x77, 0x5c, 0x82, 0x36,
	0xa0, 0xe2, 0xbb, 0xbe, 0x61, 0x8b, 0x6d, 0x97, 0x7a, 0x41, 0x92, 0xa6, 0x68, 0xcb, 0xbc, 0x9f,
	0xed, 0xab, 0x7b, 0xac, 0x57, 0x6d, 0xc1, 0xa9, 0x09, 0x53, 0x4d, 0x49, 0x40, 0xd6, 0xe2, 0x09,
	0x48, 0x2e, 0x9e, 0xd1, 0x5e, 0x83, 0xda, 0xa4, 0x11, 0x4e, 0x85, 0x43, 0xa1, 0x3a, 0xb6, 0x6a,
	0xd0, 0xbb, 0x50, 0x18, 0x48, 0x3b, 0xc8, 0x45, 0xb9, 0x7d, 0x74, 0x8b, 0x6a, 0x21, 0xa6, 0xfa,
	0x51, 0x0e, 0x96, 0x47, 0x97, 0xcc, 0xb3, 0xa6, 0x44, 0x2f, 0x02, 0xea, 0x11, 0x43, 0xc4, 0x44,
	0x82, 0x07, 0x86, 0xe5, 0x58, 0x4e, 0x9f, 0x9b, 0x43, 0xd1, 0xaa, 0x81, 0x44, 0x0b, 0x04, 0xe8,
	0x67, 0x0a, 0x9c, 0x1e, 0xf5, 0x30, 0x1a, 0x53, 0x13, 0x2b, 0x18, 0x1f, 0x57, 0xbc, 0x18, 0xf5,
	0x35, 0x1a, 0x8e, 0x42, 0xf8, 0xdb, 0x29, 0x37, 0x5d, 0xaa, 0xbe, 0x09, 0x67, 0x9e, 0xa6, 0x38,
	0x95, 0x1b, 0xbc, 0x06, 0x2b, 0x9f, 0x9f, 0x0e, 0x4f, 0x56, 0xff, 0xc3, 0x3c, 0xe4, 0x59, 0xec,
	0x40, 0x3a, 0x94, 0xc4, 0x1e, 0xad, 0x3b, 0xc6, 0x20, 0x48, 0xb1, 0xae, 0xce, 0x10, 0x85, 0x64,
	0xe3, 0xb6, 0x31, 0xc0, 0x1a, 0x0c, 0xc2, 0x67, 0x84, 0xa1, 0xcc, 0x97, 0x3a, 0x26, 0xba, 0x69,
	0xf8, 0x46, 0x70, 0xf0, 0xf9, 0xfa, 0x2c, 0x14, 0x4d, 0x01, 0xb4, 0x63, 0xf8, 0xc6, 0x8d, 0x13,
	0x5a, 0xa9, 0x1b, 0x35, 0x91, 0x0f, 0x55, 0xd3, 0xa2, 0x3e, 0xb1, 0xf6, 0xb9, 0xaa, 0xe0, 0x9a,
	0xf2, 0xcc, 0x73, 0x84, 0x6b, 0x27, 0x86, 0x26, 0x09, 0x2b, 0x66, 0xa2, 0x0f, 0xe9, 0x00, 0x7d,
	0x63, 0xd8, 0xc7, 0x82, 0xee, 0xb3, 0xe9, 0x4e, 0x1c, 0x47, 0xe8, 0xae, 0x33, 0x18, 0xc9, 0x53,
	0xec, 0x07, 0x0d, 0xf5, 0x2a, 0x40, 0x64, 0x57, 0x74, 0x06, 0x8a, 0xec, 0x2b, 0x51, 0xcf, 0xe8,
	0x62, 0x99, 0xd1, 0x45, 0x1d, 0x08, 0x41, 0x9e, 0x7f, 0xc3, 0x1c, 0x17, 0xf0, 0x67, 0xf5, 0x7f,
	0x59, 0xb1, 0x1e, 0x59, 0x29, 0x74, 0x08, 0x25, 0xe6, 0x10, 0xea, 0xbb, 0x50, 0x49, 0xce, 0x96,
	0xbd, 0xc9, 0xcd, 0x1b, 0xbc, 0xc9, 0x1b, 0xcc, 0xc5, 0xe8, 0x70, 0x20, 0xdd, 0x89, 0x3d, 0xb2,
	0x9e, 0x81, 0xe5, 0x70, 0xce, 0x9c, 0xc6, 0x1e, 0x79, 0x8f, 0xf1, 0x98, 0xa7, 0x44, 0xac, 0xc7,
	0x78, 0xac, 0xbe, 0x0d, 0xc5, 0x70, 0x7a, 0xe9, 0x43, 0x40, 0x97, 0xa1, 0x18, 0x5e, 0x9a, 0x65,
	0x28, 0xde, 0xa2, 0x97, 0x59, 0x16, 0xcb, 0x8c, 0xaf, 0x1e, 0x42, 0x25, 0x99, 0xd1, 0xa4, 0xac,
	0x88, 0x3b, 0xa3, 0x05, 0xe2, 0x95, 0x99, 0x23, 0x42, 0xbc, 0x7e, 0xfc, 0xd5, 0x1c, 0xfc, 0xf7,
	0x53, 0xcf, 0xcb, 0x8f, 0x31, 0x91, 0x7e, 0xb6, 0x09, 0xee, 0x3b, 0xb0, 0xe4, 0x11, 0x6b, 0x60,
	0x90, 0x43, 0x99, 0xa5, 0x8b, 0xac, 0x64, 0xf6, 0x72, 0xb7, 0x2c, 0xe1, 0x78, 0x76, 0x5e, 0xff,
	0x56, 0x1e, 0x4e, 0x4f, 0xbc, 0x5c, 0xca, 0x7a, 0x73, 0xf3, 0x04, 0x96, 0x4d, 0x4c, 0x2d, 0x82,
	0x4d, 0x71, 0xb7, 0x10, 0xcc, 0x7f, 0xef, 0xa8, 0xb7, 0x5b, 0x8d, 0x1d, 0x01, 0xcb, 0xfb, 0x64,
	0xee, 0xb0, 0x64, 0xc6, 0xfb, 0xd4, 0xdf, 0x28, 0x50, 0x8e, 0xbf, 0x85, 0x36, 0x61, 0x3d, 0xdc,
	0xa5, 0xdc, 0x9e, 0xdc, 0x71, 0x4c, 0x2c, 0xae, 0x5d, 0x15, 0x6d, 0x35, 0x10, 0xde, 0xe9, 0x69,
	0x81, 0x08, 0x9d, 0x87, 0x35, 0xc3, 0xb6, 0xdd, 0x47, 0xc1, 0x04, 0x74, 0x71, 0xdd, 0xcc, 0xa7,
	0x91, 0xd3, 0x90, 0x94, 0x71, 0xfc, 0x0e, 0x97, 0xa0, 0xcb, 0x50, 0xc3, 0xd4, 0xb7, 0x06, 0x86,
	0x8f, 0x4d, 0x7d, 0x24, 0xad, 0xa3, 0x72, 0x2d, 0x9e, 0x0c, 0xe5, 0xf1, 0x5c, 0x85, 0xaa, 0x1f,
	0x29, 0x80, 0xc6, 0xa7, 0x95, 0xb2, 0x30, 0xba, 0xa3, 0x0b, 0xe3, 0xd6, 0xb1, 0x1a, 0x33, 0xbe,
	0x58, 0xfe, 0x99, 0x03, 0x75, 0xf2, 0xf5, 0xce, 0xb8, 0x07, 0x2a, 0xc7, 0xe9, 0x81, 0xff, 0xb1,
	0x3a, 0x74, 0x08, 0xcb, 0xdd, 0x07, 0x86, 0xe3, 0x60, 0x7b, 0xd4, 0x49, 0x6f, 0x1f, 0xf9, 0x02,
	0xac, 0xd1, 0x14, 0xb8, 0xa2, 0x73, 0xa9, 0x1b, 0x6b, 0x51, 0xf5, 0x27, 0x0a, 0x94, 0xe3, 0xf2,
	0x2c, 0x47, 0x05, 0xe7, 0x61, 0xcd, 0x36, 0xa8, 0xaf, 0x07, 0x66, 0x0f, 0x8e, 0x2c, 0x85, 0x63,
	0x21, 0x26, 0xeb, 0x08, 0x91, 0xf4, 0x2a, 0x74, 0x09, 0x4e, 0xf6, 0x2c, 0x42, 0x7d, 0x3d, 0x34,
	0x65, 0xfc, 0x98, 0x33, 0xa7, 0xad, 0x71, 0xa9, 0x26, 0x85, 0x52, 0xab, 0x7e, 0x15, 0xd6, 0x53,
	0xaf, 0x79, 0xb3, 0x16, 0xc0, 0x35, 0x38, 0x99, 0x7e, 0x47, 0x57, 0xff, 0x44, 0x81, 0x42, 0x98,
	0x97, 0xde, 0x10, 0xfb, 0x81, 0xf4, 0x9b, 0x4b, 0x19, 0xed, 0x1d, 0x66, 0x76, 0x6c, 0x8f, 0xd2,
	0xc4, 0x8e, 0x62, 0x42, 0x9e, 0xef, 0x58, 0x19, 0xe3, 0x52, 0xd2, 0xd4, 0x73, 0xe3, 0xa6, 0x46,
	0x72, 0x6c, 0xe2, 0x34, 0x98, 0x3f, 0xd7, 0x7f, 0x9c, 0x83, 0x32, 0x3f, 0xe3, 0x09, 0xcc, 0x91,
	0xbc, 0x93, 0x1b, 0xa7, 0x9f, 0x4b, 0xa3, 0xdf, 0x85, 0xa2, 0xb8, 0x6d, 0x61, 0x0b, 0x3b, 0xc7,
	0x17, 0xf1, 0xb9, 0x8c, 0x93, 0xe7, 0xf4, 0x37, 0xf1, 0xa1, 0x56, 0xa0, 0xf2, 0x09, 0xdd, 0x84,
	0x5c, 0x1f, 0xfb, 0xd3, 0xfe, 0x04, 0x83, 0x03, 0x5d, 0xc7, 0xb1, 0x9f, 0x0b, 0x30, 0x14, 0x74,
	0x17, 0x16, 0x0c, 0xcf, 0xc3, 0x8e, 0x19, 0x24, 0x7f, 0x57, 0xa6, 0xc1, 0xdb, 0xe2, 0xaa, 0x11,
	0xa4, 0xc4, 0x42, 0x5f, 0x82, 0xf9, 0xae, 0x8d, 0x0d, 0x12, 0x64, 0x79, 0x97, 0xa7, 0x01, 0x6d,
	0x32, 0xcd, 0x08, 0x53, 0x20, 0xc5, 0x7f, 0x5e, 0xf0, 0xc9, 0x1c, 0x2c, 0xc9, 0xcf, 0x22, 0x23,
	0x53, 0xf2, 0xbb, 0xa4, 0xff, 0x82, 0x60, 0x77, 0xc4, 0x70, 0x2f, 0x4f, 0x6d, 0xb8, 0xf0, 0xda,
	0x99, 0x5b, 0xee, 0x5e, 0xd2, 0x72, 0xaf, 0xcc, 0x62, 0xb9, 0x10, 0x33, 0x30, 0x9d, 0x96, 0x30,
	0xdd, 0x95, 0x19, 0x4c, 0x17, 0x82, 0x4a, 0xdb, 0xc5, 0xaf, 0xc5, 0x7f, 0x5f, 0x80, 0x42, 0xe0,
	0x54, 0xa8, 0x03, 0x0b, 0xe2, 0x47, 0x56, 0x32, 0xf5, 0x79, 0x69, 0x4a, 0xaf, 0x6c, 0x68, 0x5c,
	0x9b, 0x0d, 0x5f, 0xe0, 0x20, 0x0a, 0xab, 0x83, 0xa1, 0xcd, 0xf6, 0x3b, 0x4f, 0x1f, 0x3b, 0xab,
	0xdd, 0x9a, 0x16, 0xfe, 0x96, 0x84, 0x8a, 0x1f, 0xce, 0x56, 0x07, 0xc9, 0x4e, 0x64, 0xc2, 0xf2,
	0xbe, 0xd1, 0xd7, 0x63, 0xc7, 0xd1, 0xb9, 0xa9, 0x7e, 0xc1, 0x11, 0xf2, 0x6d, 0x1b, 0xfd, 0xf8,
	0xd1, 0x73, 0x79, 0x3f, 0xd6, 0x66, 0x53, 0xb3, 0x7c, 0x4c, 0x8c, 0x7d, 0x1b, 0xc7, 0xa7, 0x96,
	0x9f, 0x6d, 0x6a, 0x6d, 0x09, 0x35, 0x32, 0x35, 0x2b, 0xd9, 0x89, 0xbe, 0xa9, 0x40, 0x2d, 0x34,
	0xe8, 0x43, 0x7c, 0x48, 0xe3, 0xd4, 0xf3, 0x9c, 0xba, 0x35, 0xab, 0x55, 0x6f, 0xe2, 0x43, 0x1a,
	0xa7, 0x5f, 0x1f, 0xa4, 0x09, 0x54, 0x15, 0x16, 0xc4, 0x67, 0x8e, 0xa7, 0x26, 0x65, 0x9e, 0x9a,
	0xa8, 0x04, 0xaa, 0x63, 0x13, 0x39, 0xa6, 0x33, 0x70, 0x74, 0x12, 0x16, 0xc4, 0xa5, 0xbc, 0x8c,
	0xc9, 0xb2, 0xa5, 0x7e, 0x57, 0x81, 0xea, 0x98, 0x63, 0x3c, 0x63, 0xd2, 0x60, 0xea, 0xf9, 0x68,
	0xea, 0x07, 0xb0, 0x9e, 0x6a, 0xc8, 0x67, 0x3d, 0xfd, 0x0f, 0xa0, 0x1c, 0x77, 0xd3, 0x8c, 0x74,
	0xd1, 0xda, 0x88, 0xd1, 0x85, 0x37, 0x2b, 0xd3, 0x4c, 0x3c, 0xbc, 0x9b, 0x78, 0x03, 0x56, 0x12,
	0x9b, 0x0a, 0x7a, 0x11, 0x50, 0xd7, 0x75, 0x7c, 0xcb, 0x19, 0xf2, 0xcc, 0x4b, 0x5c, 0x4a, 0x49,
	0x7f, 0xa9, 0xc6, 0x25, 0xfc, 0xce, 0xa5, 0x7e, 0x0f, 0x2a, 0xc9, 0xe8, 0x3a, 0x25, 0x44, 0xb8,
	0x6d, 0xcf, 0xc5, 0xb6, 0xed, 0x0d, 0x40, 0xe3, 0xbb, 0x53, 0xf8, 0xa6, 0x12, 0x7b, 0x73, 0x1d,
	0x56, 0x53, 0xa2, 0x71, 0x7d, 0x15, 0xaa, 0x63, 0x3b, 0x51, 0x7d, 0x4d, 0xa2, 0x8e, 0xc4, 0xd8,
	0xfa, 0xcf, 0xf3, 0x50, 0xd8, 0x75, 0xe5, 0x21, 0xd1, 0x57, 0xa1, 0x40, 0xf1, 0x01, 0x26, 0x96,
	0x2f, 0x16, 0xc9, 0x72, 0xe6, 0xf3, 0x86, 0x00, 0xa2, 0xb1, 0x27, 0xf5, 0xc5, 0x3d, 0x6e, 0x08,
	0x37, 0x7b, 0x11, 0x8e, 0x6a, 0xac, 0xbe, 0xa5, 0xd4, 0xe8, 0x07, 0xa7, 0x0f, 0x41, 0x93, 0xdf,
	0x6d, 0x11, 0xa3, 0x8b, 0xf9, 0xc7, 0x2d, 0x6a, 0xa2, 0x91, 0x92, 0xd3, 0xcc, 0x67, 0x49, 0xa9,
	0x16, 0xc6, 0xdd, 0xee, 0x79, 0x28, 0xdb, 0x6e, 0x5f, 0xb7, 0x5d, 0x79, 0x3f, 0xbb, 0x28, 0x5e,
	0xb1, 0xdd, 0xfe, 0xae, 0xec, 0x62, 0x5e, 0xe7, 0x3f, 0x20, 0xd8, 0x30, 0x6b, 0x05, 0x2e, 0x94,
	0x2d, 0xf5, 0x2b, 0x90, 0xdf, 0xb5, 0xa8, 0x8f, 0x3a, 0xc0, 0x5e, 0xd7, 0xb1, 0xe3, 0x13, 0x0b,
	0x07, 0x05, 0xc7, 0xb9, 0x29, 0x8d, 0xaa, 0x81, 0x2d, 0x9e, 0x2c, 0x4c, 0x55, 0x02, 0x85, 0xc0,
	0xc6, 0xf5, 0x1e, 0xe4, 0x99, 0x99, 0xd1, 0x0a, 0x94, 0xee, 0xdd, 0xde, 0xeb, 0xb4, 0x9a, 0xed,
	0x6b, 0xed, 0xd6, 0x4e, 0xe5, 0x04, 0x2a, 0xc2, 0xfc, 0x5d, 0x6d, 0xab, 0xd9, 0xaa, 0x28, 0xec,
	0x71, 0xa7, 0xb5, 0x7d, 0xef, 0x7a, 0x65, 0x0e, 0x15, 0x20, 0xdf, 0xbe, 0x7d, 0xed, 0x4e, 0x25,
	0x87, 0x00, 0x16, 0x6e, 0xdf, 0xb9, 0xdb, 0x6e, 0xb6, 0x2a, 0x79, 0xd6, 0x7b, 0x7f, 0x4b, 0xbb,
	0x5d, 0x99, 0x67, 0xaf, 0xb6, 0x34, 0xed, 0x8e, 0x56, 0x59, 0x40, 0x65, 0x28, 0x34, 0xb5, 0xf6,
	0xdd, 0x76, 0x73, 0x6b, 0xb7, 0xb2, 0x58, 0x2f, 0x03, 0xec, 0xba, 0xfd, 0xa6, 0xeb, 0xf8, 0xc4,
	0xb5, 0xeb, 0x7f, 0xcc, 0x73, 0x4f, 0x22, 0xfe, 0x7d, 0x97, 0x3c, 0x8c, 0x7e, 0x9b, 0xf6, 0x5f,
	0x50, 0x7c, 0xc4, 0x3b, 0xa2, 0x45, 0x5c, 0x10, 0x1d, 0x6d, 0x13, 0xed, 0x43, 0xa5, 0x2b, 0xd4,
	0xf5, 0xe0, 0x37, 0xd0, 0xd2, 0x0b, 0x66, 0xfe, 0x8d, 0xce, 0x8a, 0x04, 0x6c, 0x49, 0x3c, 0xc6,
	0x61, 0xbb, 0xfd, 0xbe, 0xe5, 0xf4, 0x23, 0x8e, 0xdc, 0x11, 0x39, 0x24, 0x60, 0xc8, 0x61, 0x42,
	0xd5, 0x20, 0xbe, 0xd5, 0x33, 0xba, 0x7e, 0x44, 0x92, 0x3f, 0x1a, 0x49, 0x25, 0x40, 0x0c, 0x59,
	0x7a, 0xfc, 0x46, 0xec, 0xc0, 0xa2, 0xcc, 0x81, 0x43, 0x9a, 0xf9, 0xa3, 0xd1, 0x54, 0x43, 0xc8,
	0x90, 0xe7, 0x1d, 0x58, 0xf0, 0x0c, 0x62, 0x0c, 0x68, 0x0d, 0xb8, 0x63, 0x4e, 0xb1, 0x13, 0x27,
	0xbe, 0x7e, 0xa3, 0xc3, 0x71, 0xe4, 0x4f, 0xc3, 0x04, 0xa8, 0x7a, 0x05, 0x4a, 0xb1, 0xee, 0xcf,
	0x3b, 0x43, 0x2e, 0xc6, 0x2b, 0xf9, 0x2f, 0xf0, 0xc0, 0x16, 0x91, 0xc8, 0xe0, 0x1a, 0xe6, 0xc5,
	0x4a, 0x2c, 0x2f, 0xae, 0x9f, 0x67, 0xe1, 0xce, 0xf5, 0xb2, 0xbb, 0x63, 0xfd, 0xff, 0x99, 0x07,
	0x47, 0x1a, 0x4f, 0x45, 0x7f, 0x01, 0x56, 0xc5, 0x7b, 0x2c, 0x7a, 0x0e, 0xe9, 0x84, 0x52, 0xaa,
	0xfe, 0x0e, 0xac, 0x8d, 0xbe, 0x36, 0x55, 0x6a, 0xff, 0x1c, 0x94, 0x28, 0xd7, 0xe3, 0xc7, 0x6e,
	0x32, 0xd0, 0x81, 0xe8, 0x6a, 0x3b, 0x3d, 0x77, 0xf3, 0x63, 0x05, 0x96, 0xb6, 0xb1, 0x31, 0xb8,
	0xe6, 0xc8, 0x65, 0x88, 0xbe, 0xa7, 0xc0, 0x62, 0xf0, 0x9c, 0x35, 0x75, 0x4f, 0xf9, 0x51, 0xb3,
	0x7a, 0x65, 0x16, 0x5d, 0xb1, 0xa5, 0x9c, 0xd8, 0x50, 0xce, 0x2b, 0x9b, 0xef, 0x03, 0x88, 0x91,
	0xf1, 0x8a, 0xd6, 0x91, 0x95, 0xed, 0xb9, 0x29, 0xab, 0x63, 0x75, 0x5a, 0x05, 0xc9, 0xfe, 0x7d,
	0x05, 0x4a, 0x82, 0x5e, 0xa4, 0x13, 0x8f, 0x61, 0x5e, 0x3c, 0x5c, 0x9c, 0x26, 0xad, 0x94, 0x33,
	0x52, 0x2f, 0x4d, 0xa7, 0x24, 0x37, 0x51, 0x31, 0x92, 0x1f, 0x84, 0x9f, 0x68, 0x57, 0x44, 0x0d,
	0xf4, 0x18, 0x16, 0x83, 0xc7, 0x4b, 0xd3, 0x6e, 0xa4, 0x6c, 0xfb, 0x50, 0x2f, 0x64, 0xd7, 0x0a,
	0xa2, 0xb3, 0x18, 0xcb, 0xaf, 0xe7, 0xa0, 0x26, 0xc6, 0xd2, 0x7a, 0xec, 0x63, 0xe2, 0x18, 0xb6,
	0x70, 0xce, 0x8e, 0x2b, 0x3c, 0xa7, 0x14, 0x5b, 0x5d, 0xe8, 0xca, 0xcc, 0xcb, 0x5e, 0x7d, 0x65,
	0x16, 0xd5, 0xc0, 0x6a, 0xe8, 0x3b, 0x0a, 0x40, 0xb4, 0x0e, 0x51, 0xf6, 0x2a, 0x3b, 0xb1, 0xd8,
	0xd5, 0x2b, 0x33, 0x68, 0x06, 0xa3, 0xd8, 0xfc, 0xa5, 0x02, 0x48, 0xd8, 0x2a, 0xbe, 0x80, 0xd1,
	0x87, 0x0a, 0x94, 0x47, 0x3a, 0xb2, 0xfe, 0x9f, 0x23, 0x2d, 0x0c, 0x64, 0x36, 0x54, 0x4a, 0xa8,
	0x11, 0x9f, 0x74, 0x7b, 0x0b, 0xfe, 0x6f, 0x12, 0x44, 0x1c, 0x61, 0xbb, 0x28, 0xe6, 0xb2, 0xe5,
	0x59, 0x6f, 0x2d, 0xc7, 0x44, 0xfa, 0xc1, 0x85, 0xfd, 0x05, 0x9e, 0x69, 0x5d, 0xfc, 0x77, 0x00,
	0x00, 0x00, 0xff, 0xff, 0x79, 0xce, 0x72, 0x0d, 0xd9, 0x34, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// BeamFnControlClient is the client API for BeamFnControl service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnControlClient interface {
	// Instructions sent by the runner to the SDK requesting different types
	// of work.
	Control(ctx context.Context, opts ...grpc.CallOption) (BeamFnControl_ControlClient, error)
}

type beamFnControlClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnControlClient(cc *grpc.ClientConn) BeamFnControlClient {
	return &beamFnControlClient{cc}
}

func (c *beamFnControlClient) Control(ctx context.Context, opts ...grpc.CallOption) (BeamFnControl_ControlClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnControl_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnControl/Control", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnControlControlClient{stream}
	return x, nil
}

type BeamFnControl_ControlClient interface {
	Send(*InstructionResponse) error
	Recv() (*InstructionRequest, error)
	grpc.ClientStream
}

type beamFnControlControlClient struct {
	grpc.ClientStream
}

func (x *beamFnControlControlClient) Send(m *InstructionResponse) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnControlControlClient) Recv() (*InstructionRequest, error) {
	m := new(InstructionRequest)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnControlServer is the server API for BeamFnControl service.
type BeamFnControlServer interface {
	// Instructions sent by the runner to the SDK requesting different types
	// of work.
	Control(BeamFnControl_ControlServer) error
}

// UnimplementedBeamFnControlServer can be embedded to have forward compatible implementations.
type UnimplementedBeamFnControlServer struct {
}

func (*UnimplementedBeamFnControlServer) Control(srv BeamFnControl_ControlServer) error {
	return status.Errorf(codes.Unimplemented, "method Control not implemented")
}

func RegisterBeamFnControlServer(s *grpc.Server, srv BeamFnControlServer) {
	s.RegisterService(&_BeamFnControl_serviceDesc, srv)
}

func _BeamFnControl_Control_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnControlServer).Control(&beamFnControlControlServer{stream})
}

type BeamFnControl_ControlServer interface {
	Send(*InstructionRequest) error
	Recv() (*InstructionResponse, error)
	grpc.ServerStream
}

type beamFnControlControlServer struct {
	grpc.ServerStream
}

func (x *beamFnControlControlServer) Send(m *InstructionRequest) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnControlControlServer) Recv() (*InstructionResponse, error) {
	m := new(InstructionResponse)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnControl_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnControl",
	HandlerType: (*BeamFnControlServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Control",
			Handler:       _BeamFnControl_Control_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}

// BeamFnDataClient is the client API for BeamFnData service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnDataClient interface {
	// Used to send data between harnesses.
	Data(ctx context.Context, opts ...grpc.CallOption) (BeamFnData_DataClient, error)
}

type beamFnDataClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnDataClient(cc *grpc.ClientConn) BeamFnDataClient {
	return &beamFnDataClient{cc}
}

func (c *beamFnDataClient) Data(ctx context.Context, opts ...grpc.CallOption) (BeamFnData_DataClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnData_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnData/Data", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnDataDataClient{stream}
	return x, nil
}

type BeamFnData_DataClient interface {
	Send(*Elements) error
	Recv() (*Elements, error)
	grpc.ClientStream
}

type beamFnDataDataClient struct {
	grpc.ClientStream
}

func (x *beamFnDataDataClient) Send(m *Elements) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnDataDataClient) Recv() (*Elements, error) {
	m := new(Elements)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnDataServer is the server API for BeamFnData service.
type BeamFnDataServer interface {
	// Used to send data between harnesses.
	Data(BeamFnData_DataServer) error
}

// UnimplementedBeamFnDataServer can be embedded to have forward compatible implementations.
type UnimplementedBeamFnDataServer struct {
}

func (*UnimplementedBeamFnDataServer) Data(srv BeamFnData_DataServer) error {
	return status.Errorf(codes.Unimplemented, "method Data not implemented")
}

func RegisterBeamFnDataServer(s *grpc.Server, srv BeamFnDataServer) {
	s.RegisterService(&_BeamFnData_serviceDesc, srv)
}

func _BeamFnData_Data_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnDataServer).Data(&beamFnDataDataServer{stream})
}

type BeamFnData_DataServer interface {
	Send(*Elements) error
	Recv() (*Elements, error)
	grpc.ServerStream
}

type beamFnDataDataServer struct {
	grpc.ServerStream
}

func (x *beamFnDataDataServer) Send(m *Elements) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnDataDataServer) Recv() (*Elements, error) {
	m := new(Elements)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnData_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnData",
	HandlerType: (*BeamFnDataServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Data",
			Handler:       _BeamFnData_Data_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}

// BeamFnStateClient is the client API for BeamFnState service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnStateClient interface {
	// Used to get/append/clear state stored by the runner on behalf of the SDK.
	State(ctx context.Context, opts ...grpc.CallOption) (BeamFnState_StateClient, error)
}

type beamFnStateClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnStateClient(cc *grpc.ClientConn) BeamFnStateClient {
	return &beamFnStateClient{cc}
}

func (c *beamFnStateClient) State(ctx context.Context, opts ...grpc.CallOption) (BeamFnState_StateClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnState_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnState/State", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnStateStateClient{stream}
	return x, nil
}

type BeamFnState_StateClient interface {
	Send(*StateRequest) error
	Recv() (*StateResponse, error)
	grpc.ClientStream
}

type beamFnStateStateClient struct {
	grpc.ClientStream
}

func (x *beamFnStateStateClient) Send(m *StateRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnStateStateClient) Recv() (*StateResponse, error) {
	m := new(StateResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnStateServer is the server API for BeamFnState service.
type BeamFnStateServer interface {
	// Used to get/append/clear state stored by the runner on behalf of the SDK.
	State(BeamFnState_StateServer) error
}

// UnimplementedBeamFnStateServer can be embedded to have forward compatible implementations.
type UnimplementedBeamFnStateServer struct {
}

func (*UnimplementedBeamFnStateServer) State(srv BeamFnState_StateServer) error {
	return status.Errorf(codes.Unimplemented, "method State not implemented")
}

func RegisterBeamFnStateServer(s *grpc.Server, srv BeamFnStateServer) {
	s.RegisterService(&_BeamFnState_serviceDesc, srv)
}

func _BeamFnState_State_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnStateServer).State(&beamFnStateStateServer{stream})
}

type BeamFnState_StateServer interface {
	Send(*StateResponse) error
	Recv() (*StateRequest, error)
	grpc.ServerStream
}

type beamFnStateStateServer struct {
	grpc.ServerStream
}

func (x *beamFnStateStateServer) Send(m *StateResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnStateStateServer) Recv() (*StateRequest, error) {
	m := new(StateRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnState_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnState",
	HandlerType: (*BeamFnStateServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "State",
			Handler:       _BeamFnState_State_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}

// BeamFnLoggingClient is the client API for BeamFnLogging service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnLoggingClient interface {
	// Allows for the SDK to emit log entries which the runner can
	// associate with the active job.
	Logging(ctx context.Context, opts ...grpc.CallOption) (BeamFnLogging_LoggingClient, error)
}

type beamFnLoggingClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnLoggingClient(cc *grpc.ClientConn) BeamFnLoggingClient {
	return &beamFnLoggingClient{cc}
}

func (c *beamFnLoggingClient) Logging(ctx context.Context, opts ...grpc.CallOption) (BeamFnLogging_LoggingClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnLogging_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnLogging/Logging", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnLoggingLoggingClient{stream}
	return x, nil
}

type BeamFnLogging_LoggingClient interface {
	Send(*LogEntry_List) error
	Recv() (*LogControl, error)
	grpc.ClientStream
}

type beamFnLoggingLoggingClient struct {
	grpc.ClientStream
}

func (x *beamFnLoggingLoggingClient) Send(m *LogEntry_List) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnLoggingLoggingClient) Recv() (*LogControl, error) {
	m := new(LogControl)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnLoggingServer is the server API for BeamFnLogging service.
type BeamFnLoggingServer interface {
	// Allows for the SDK to emit log entries which the runner can
	// associate with the active job.
	Logging(BeamFnLogging_LoggingServer) error
}

// UnimplementedBeamFnLoggingServer can be embedded to have forward compatible implementations.
type UnimplementedBeamFnLoggingServer struct {
}

func (*UnimplementedBeamFnLoggingServer) Logging(srv BeamFnLogging_LoggingServer) error {
	return status.Errorf(codes.Unimplemented, "method Logging not implemented")
}

func RegisterBeamFnLoggingServer(s *grpc.Server, srv BeamFnLoggingServer) {
	s.RegisterService(&_BeamFnLogging_serviceDesc, srv)
}

func _BeamFnLogging_Logging_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnLoggingServer).Logging(&beamFnLoggingLoggingServer{stream})
}

type BeamFnLogging_LoggingServer interface {
	Send(*LogControl) error
	Recv() (*LogEntry_List, error)
	grpc.ServerStream
}

type beamFnLoggingLoggingServer struct {
	grpc.ServerStream
}

func (x *beamFnLoggingLoggingServer) Send(m *LogControl) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnLoggingLoggingServer) Recv() (*LogEntry_List, error) {
	m := new(LogEntry_List)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnLogging_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnLogging",
	HandlerType: (*BeamFnLoggingServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Logging",
			Handler:       _BeamFnLogging_Logging_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}

// BeamFnExternalWorkerPoolClient is the client API for BeamFnExternalWorkerPool service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnExternalWorkerPoolClient interface {
	// Start the SDK worker with the given ID.
	StartWorker(ctx context.Context, in *StartWorkerRequest, opts ...grpc.CallOption) (*StartWorkerResponse, error)
	// Stop the SDK worker.
	StopWorker(ctx context.Context, in *StopWorkerRequest, opts ...grpc.CallOption) (*StopWorkerResponse, error)
}

type beamFnExternalWorkerPoolClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnExternalWorkerPoolClient(cc *grpc.ClientConn) BeamFnExternalWorkerPoolClient {
	return &beamFnExternalWorkerPoolClient{cc}
}

func (c *beamFnExternalWorkerPoolClient) StartWorker(ctx context.Context, in *StartWorkerRequest, opts ...grpc.CallOption) (*StartWorkerResponse, error) {
	out := new(StartWorkerResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool/StartWorker", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *beamFnExternalWorkerPoolClient) StopWorker(ctx context.Context, in *StopWorkerRequest, opts ...grpc.CallOption) (*StopWorkerResponse, error) {
	out := new(StopWorkerResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool/StopWorker", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BeamFnExternalWorkerPoolServer is the server API for BeamFnExternalWorkerPool service.
type BeamFnExternalWorkerPoolServer interface {
	// Start the SDK worker with the given ID.
	StartWorker(context.Context, *StartWorkerRequest) (*StartWorkerResponse, error)
	// Stop the SDK worker.
	StopWorker(context.Context, *StopWorkerRequest) (*StopWorkerResponse, error)
}

// UnimplementedBeamFnExternalWorkerPoolServer can be embedded to have forward compatible implementations.
type UnimplementedBeamFnExternalWorkerPoolServer struct {
}

func (*UnimplementedBeamFnExternalWorkerPoolServer) StartWorker(ctx context.Context, req *StartWorkerRequest) (*StartWorkerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartWorker not implemented")
}
func (*UnimplementedBeamFnExternalWorkerPoolServer) StopWorker(ctx context.Context, req *StopWorkerRequest) (*StopWorkerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopWorker not implemented")
}

func RegisterBeamFnExternalWorkerPoolServer(s *grpc.Server, srv BeamFnExternalWorkerPoolServer) {
	s.RegisterService(&_BeamFnExternalWorkerPool_serviceDesc, srv)
}

func _BeamFnExternalWorkerPool_StartWorker_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartWorkerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BeamFnExternalWorkerPoolServer).StartWorker(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool/StartWorker",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BeamFnExternalWorkerPoolServer).StartWorker(ctx, req.(*StartWorkerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BeamFnExternalWorkerPool_StopWorker_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopWorkerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BeamFnExternalWorkerPoolServer).StopWorker(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool/StopWorker",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BeamFnExternalWorkerPoolServer).StopWorker(ctx, req.(*StopWorkerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BeamFnExternalWorkerPool_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool",
	HandlerType: (*BeamFnExternalWorkerPoolServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "StartWorker",
			Handler:    _BeamFnExternalWorkerPool_StartWorker_Handler,
		},
		{
			MethodName: "StopWorker",
			Handler:    _BeamFnExternalWorkerPool_StopWorker_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "beam_fn_api.proto",
}

// BeamFnWorkerStatusClient is the client API for BeamFnWorkerStatus service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnWorkerStatusClient interface {
	WorkerStatus(ctx context.Context, opts ...grpc.CallOption) (BeamFnWorkerStatus_WorkerStatusClient, error)
}

type beamFnWorkerStatusClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnWorkerStatusClient(cc *grpc.ClientConn) BeamFnWorkerStatusClient {
	return &beamFnWorkerStatusClient{cc}
}

func (c *beamFnWorkerStatusClient) WorkerStatus(ctx context.Context, opts ...grpc.CallOption) (BeamFnWorkerStatus_WorkerStatusClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnWorkerStatus_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnWorkerStatus/WorkerStatus", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnWorkerStatusWorkerStatusClient{stream}
	return x, nil
}

type BeamFnWorkerStatus_WorkerStatusClient interface {
	Send(*WorkerStatusResponse) error
	Recv() (*WorkerStatusRequest, error)
	grpc.ClientStream
}

type beamFnWorkerStatusWorkerStatusClient struct {
	grpc.ClientStream
}

func (x *beamFnWorkerStatusWorkerStatusClient) Send(m *WorkerStatusResponse) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnWorkerStatusWorkerStatusClient) Recv() (*WorkerStatusRequest, error) {
	m := new(WorkerStatusRequest)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnWorkerStatusServer is the server API for BeamFnWorkerStatus service.
type BeamFnWorkerStatusServer interface {
	WorkerStatus(BeamFnWorkerStatus_WorkerStatusServer) error
}

// UnimplementedBeamFnWorkerStatusServer can be embedded to have forward compatible implementations.
type UnimplementedBeamFnWorkerStatusServer struct {
}

func (*UnimplementedBeamFnWorkerStatusServer) WorkerStatus(srv BeamFnWorkerStatus_WorkerStatusServer) error {
	return status.Errorf(codes.Unimplemented, "method WorkerStatus not implemented")
}

func RegisterBeamFnWorkerStatusServer(s *grpc.Server, srv BeamFnWorkerStatusServer) {
	s.RegisterService(&_BeamFnWorkerStatus_serviceDesc, srv)
}

func _BeamFnWorkerStatus_WorkerStatus_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnWorkerStatusServer).WorkerStatus(&beamFnWorkerStatusWorkerStatusServer{stream})
}

type BeamFnWorkerStatus_WorkerStatusServer interface {
	Send(*WorkerStatusRequest) error
	Recv() (*WorkerStatusResponse, error)
	grpc.ServerStream
}

type beamFnWorkerStatusWorkerStatusServer struct {
	grpc.ServerStream
}

func (x *beamFnWorkerStatusWorkerStatusServer) Send(m *WorkerStatusRequest) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnWorkerStatusWorkerStatusServer) Recv() (*WorkerStatusResponse, error) {
	m := new(WorkerStatusResponse)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnWorkerStatus_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnWorkerStatus",
	HandlerType: (*BeamFnWorkerStatusServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "WorkerStatus",
			Handler:       _BeamFnWorkerStatus_WorkerStatus_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}
