// Code generated by protoc-gen-go. DO NOT EDIT.
// source: beam_runner_api.proto

package pipeline_v1

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	descriptor "github.com/golang/protobuf/protoc-gen-go/descriptor"
	any "github.com/golang/protobuf/ptypes/any"
	_ "github.com/golang/protobuf/ptypes/timestamp"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type BeamConstants_Constants int32

const (
	// All timestamps in milliseconds since Jan 1, 1970.
	BeamConstants_MIN_TIMESTAMP_MILLIS BeamConstants_Constants = 0
	BeamConstants_MAX_TIMESTAMP_MILLIS BeamConstants_Constants = 1
	// The maximum timestamp for the global window.
	// Triggers use maxTimestamp to set timers' timestamp. Timers fires when
	// the watermark passes their timestamps. So, the timestamp needs to be
	// smaller than the MAX_TIMESTAMP_MILLIS.
	// One standard day is subtracted from MAX_TIMESTAMP_MILLIS to make sure
	// the maxTimestamp is smaller than MAX_TIMESTAMP_MILLIS even after rounding up
	// to seconds or minutes. See also GlobalWindow in the Java SDK.
	BeamConstants_GLOBAL_WINDOW_MAX_TIMESTAMP_MILLIS BeamConstants_Constants = 2
)

var BeamConstants_Constants_name = map[int32]string{
	0: "MIN_TIMESTAMP_MILLIS",
	1: "MAX_TIMESTAMP_MILLIS",
	2: "GLOBAL_WINDOW_MAX_TIMESTAMP_MILLIS",
}

var BeamConstants_Constants_value = map[string]int32{
	"MIN_TIMESTAMP_MILLIS":               0,
	"MAX_TIMESTAMP_MILLIS":               1,
	"GLOBAL_WINDOW_MAX_TIMESTAMP_MILLIS": 2,
}

func (x BeamConstants_Constants) String() string {
	return proto.EnumName(BeamConstants_Constants_name, int32(x))
}

func (BeamConstants_Constants) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{0, 0}
}

type StandardPTransforms_Primitives int32

const (
	// Represents Beam's parallel do operation.
	// Payload: ParDoPayload.
	// TODO(BEAM-3595): Change this to beam:transform:pardo:v1.
	StandardPTransforms_PAR_DO StandardPTransforms_Primitives = 0
	// Represents Beam's flatten operation.
	// Payload: None.
	StandardPTransforms_FLATTEN StandardPTransforms_Primitives = 1
	// Represents Beam's group-by-key operation.
	// Payload: None
	StandardPTransforms_GROUP_BY_KEY StandardPTransforms_Primitives = 2
	// Represents the operation generating a single empty element.
	StandardPTransforms_IMPULSE StandardPTransforms_Primitives = 3
	// Represents the Window.into() operation.
	// Payload: WindowIntoPayload.
	StandardPTransforms_ASSIGN_WINDOWS StandardPTransforms_Primitives = 4
	// Represents the TestStream.
	// Payload: TestStreamPayload
	StandardPTransforms_TEST_STREAM StandardPTransforms_Primitives = 5
	// Represents mapping of main input window onto side input window.
	//
	// Side input window mapping function:
	// Input: KV<nonce, MainInputWindow>
	// Output: KV<nonce, SideInputWindow>
	//
	// For each main input window, the side input window is returned. The
	// nonce is used by a runner to associate each input with its output.
	// The nonce is represented as an opaque set of bytes.
	//
	// Payload: WindowMappingFn from SideInputSpec.
	StandardPTransforms_MAP_WINDOWS StandardPTransforms_Primitives = 6
	// Used to merge windows during a GroupByKey.
	//
	// Window merging function:
	// Input: KV<nonce, iterable<OriginalWindow>>
	// Output: KV<nonce, KV<iterable<UnmergedOriginalWindow>, iterable<KV<MergedWindow, iterable<ConsumedOriginalWindow>>>>
	//
	// For each set of original windows, a list of all unmerged windows is
	// output alongside a map of merged window to set of consumed windows.
	// All original windows must be contained in either the unmerged original
	// window set or one of the consumed original window sets. Each original
	// window can only be part of one output set. The nonce is used by a runner
	// to associate each input with its output. The nonce is represented as an
	// opaque set of bytes.
	//
	// Payload: WindowFn from WindowingStrategy.
	StandardPTransforms_MERGE_WINDOWS StandardPTransforms_Primitives = 7
)

var StandardPTransforms_Primitives_name = map[int32]string{
	0: "PAR_DO",
	1: "FLATTEN",
	2: "GROUP_BY_KEY",
	3: "IMPULSE",
	4: "ASSIGN_WINDOWS",
	5: "TEST_STREAM",
	6: "MAP_WINDOWS",
	7: "MERGE_WINDOWS",
}

var StandardPTransforms_Primitives_value = map[string]int32{
	"PAR_DO":         0,
	"FLATTEN":        1,
	"GROUP_BY_KEY":   2,
	"IMPULSE":        3,
	"ASSIGN_WINDOWS": 4,
	"TEST_STREAM":    5,
	"MAP_WINDOWS":    6,
	"MERGE_WINDOWS":  7,
}

func (x StandardPTransforms_Primitives) String() string {
	return proto.EnumName(StandardPTransforms_Primitives_name, int32(x))
}

func (StandardPTransforms_Primitives) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{4, 0}
}

type StandardPTransforms_DeprecatedPrimitives int32

const (
	// Represents the operation to read a Bounded or Unbounded source.
	// Payload: ReadPayload.
	StandardPTransforms_READ StandardPTransforms_DeprecatedPrimitives = 0
	// Runners should move away from translating `CreatePCollectionView` and treat this as
	// part of the translation for a `ParDo` side input.
	StandardPTransforms_CREATE_VIEW StandardPTransforms_DeprecatedPrimitives = 1
)

var StandardPTransforms_DeprecatedPrimitives_name = map[int32]string{
	0: "READ",
	1: "CREATE_VIEW",
}

var StandardPTransforms_DeprecatedPrimitives_value = map[string]int32{
	"READ":        0,
	"CREATE_VIEW": 1,
}

func (x StandardPTransforms_DeprecatedPrimitives) String() string {
	return proto.EnumName(StandardPTransforms_DeprecatedPrimitives_name, int32(x))
}

func (StandardPTransforms_DeprecatedPrimitives) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{4, 1}
}

type StandardPTransforms_Composites int32

const (
	// Represents the Combine.perKey() operation.
	// If this is produced by an SDK, it is assumed that the SDK understands
	// each of CombineComponents.
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_PER_KEY StandardPTransforms_Composites = 0
	// Represents the Combine.globally() operation.
	// If this is produced by an SDK, it is assumed that the SDK understands
	// each of CombineComponents.
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_GLOBALLY StandardPTransforms_Composites = 1
	// Represents the Reshuffle operation.
	StandardPTransforms_RESHUFFLE StandardPTransforms_Composites = 2
	// Less well-known. Payload: WriteFilesPayload.
	StandardPTransforms_WRITE_FILES StandardPTransforms_Composites = 3
)

var StandardPTransforms_Composites_name = map[int32]string{
	0: "COMBINE_PER_KEY",
	1: "COMBINE_GLOBALLY",
	2: "RESHUFFLE",
	3: "WRITE_FILES",
}

var StandardPTransforms_Composites_value = map[string]int32{
	"COMBINE_PER_KEY":  0,
	"COMBINE_GLOBALLY": 1,
	"RESHUFFLE":        2,
	"WRITE_FILES":      3,
}

func (x StandardPTransforms_Composites) String() string {
	return proto.EnumName(StandardPTransforms_Composites_name, int32(x))
}

func (StandardPTransforms_Composites) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{4, 2}
}

// Payload for all of these: CombinePayload
type StandardPTransforms_CombineComponents int32

const (
	// Represents the Pre-Combine part of a lifted Combine Per Key, as described
	// in the following document:
	// https://s.apache.org/beam-runner-api-combine-model#heading=h.ta0g6ase8z07
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_PER_KEY_PRECOMBINE StandardPTransforms_CombineComponents = 0
	// Represents the Merge Accumulators part of a lifted Combine Per Key, as
	// described in the following document:
	// https://s.apache.org/beam-runner-api-combine-model#heading=h.jco9rvatld5m
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_PER_KEY_MERGE_ACCUMULATORS StandardPTransforms_CombineComponents = 1
	// Represents the Extract Outputs part of a lifted Combine Per Key, as
	// described in the following document:
	// https://s.apache.org/beam-runner-api-combine-model#heading=h.i9i6p8gtl6ku
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_PER_KEY_EXTRACT_OUTPUTS StandardPTransforms_CombineComponents = 2
	// Represents the Combine Grouped Values transform, as described in the
	// following document:
	// https://s.apache.org/beam-runner-api-combine-model#heading=h.aj86ew4v1wk
	// Payload: CombinePayload
	StandardPTransforms_COMBINE_GROUPED_VALUES StandardPTransforms_CombineComponents = 3
)

var StandardPTransforms_CombineComponents_name = map[int32]string{
	0: "COMBINE_PER_KEY_PRECOMBINE",
	1: "COMBINE_PER_KEY_MERGE_ACCUMULATORS",
	2: "COMBINE_PER_KEY_EXTRACT_OUTPUTS",
	3: "COMBINE_GROUPED_VALUES",
}

var StandardPTransforms_CombineComponents_value = map[string]int32{
	"COMBINE_PER_KEY_PRECOMBINE":         0,
	"COMBINE_PER_KEY_MERGE_ACCUMULATORS": 1,
	"COMBINE_PER_KEY_EXTRACT_OUTPUTS":    2,
	"COMBINE_GROUPED_VALUES":             3,
}

func (x StandardPTransforms_CombineComponents) String() string {
	return proto.EnumName(StandardPTransforms_CombineComponents_name, int32(x))
}

func (StandardPTransforms_CombineComponents) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{4, 3}
}

// Payload for all of these: ParDoPayload containing the user's SDF
type StandardPTransforms_SplittableParDoComponents int32

const (
	// Pairs the input element with its initial restriction.
	// Input: element; output: KV(element, restriction).
	StandardPTransforms_PAIR_WITH_RESTRICTION StandardPTransforms_SplittableParDoComponents = 0
	// Splits the restriction inside an element/restriction pair.
	// Input: KV(element, restriction); output: KV(element, restriction).
	StandardPTransforms_SPLIT_RESTRICTION StandardPTransforms_SplittableParDoComponents = 1
	// Applies the DoFn to every element/restriction pair in a uniquely keyed
	// collection, in a splittable fashion.
	// Input: KV(bytes, KV(element, restriction)); output: DoFn's output.
	// The first "bytes" is an opaque unique key using the standard bytes coder.
	// Typically a runner would rewrite this into a runner-specific grouping
	// operation supporting state and timers, followed by PROCESS_ELEMENTS,
	// with some runner-specific glue code in between.
	StandardPTransforms_PROCESS_KEYED_ELEMENTS StandardPTransforms_SplittableParDoComponents = 2
	// Like PROCESS_KEYED_ELEMENTS, but without the unique key - just elements
	// and restrictions.
	// Input: KV(element, restriction); output: DoFn's output.
	StandardPTransforms_PROCESS_ELEMENTS StandardPTransforms_SplittableParDoComponents = 3
	// Splits the restriction of each element/restriction pair and returns the
	// resulting splits, with a corresponding floating point size estimations
	// for each.
	// A reasonable value for size is the number of bytes expected to be
	// produced by this (element, restriction) pair.
	// Input: KV(element, restriction)
	// Output: KV(KV(element, restriction), size))
	StandardPTransforms_SPLIT_AND_SIZE_RESTRICTIONS StandardPTransforms_SplittableParDoComponents = 4
	// Like PROCESS_ELEMENTS, but accepts the sized output produced by
	// SPLIT_RESTRICTION_WITH_SIZING.
	// Input: KV(KV(element, restriction), size); output: DoFn's output.
	StandardPTransforms_PROCESS_SIZED_ELEMENTS_AND_RESTRICTIONS StandardPTransforms_SplittableParDoComponents = 5
)

var StandardPTransforms_SplittableParDoComponents_name = map[int32]string{
	0: "PAIR_WITH_RESTRICTION",
	1: "SPLIT_RESTRICTION",
	2: "PROCESS_KEYED_ELEMENTS",
	3: "PROCESS_ELEMENTS",
	4: "SPLIT_AND_SIZE_RESTRICTIONS",
	5: "PROCESS_SIZED_ELEMENTS_AND_RESTRICTIONS",
}

var StandardPTransforms_SplittableParDoComponents_value = map[string]int32{
	"PAIR_WITH_RESTRICTION":                   0,
	"SPLIT_RESTRICTION":                       1,
	"PROCESS_KEYED_ELEMENTS":                  2,
	"PROCESS_ELEMENTS":                        3,
	"SPLIT_AND_SIZE_RESTRICTIONS":             4,
	"PROCESS_SIZED_ELEMENTS_AND_RESTRICTIONS": 5,
}

func (x StandardPTransforms_SplittableParDoComponents) String() string {
	return proto.EnumName(StandardPTransforms_SplittableParDoComponents_name, int32(x))
}

func (StandardPTransforms_SplittableParDoComponents) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{4, 4}
}

type StandardSideInputTypes_Enum int32

const (
	// Represents a view over a PCollection<V>.
	//
	// StateGetRequests performed on this side input must use
	// StateKey.IterableSideInput.
	StandardSideInputTypes_ITERABLE StandardSideInputTypes_Enum = 0
	// Represents a view over a PCollection<KV<K, V>>.
	//
	// StateGetRequests performed on this side input must use
	// StateKey.IterableSideInput or StateKey.MultimapSideInput.
	StandardSideInputTypes_MULTIMAP StandardSideInputTypes_Enum = 1
)

var StandardSideInputTypes_Enum_name = map[int32]string{
	0: "ITERABLE",
	1: "MULTIMAP",
}

var StandardSideInputTypes_Enum_value = map[string]int32{
	"ITERABLE": 0,
	"MULTIMAP": 1,
}

func (x StandardSideInputTypes_Enum) String() string {
	return proto.EnumName(StandardSideInputTypes_Enum_name, int32(x))
}

func (StandardSideInputTypes_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{5, 0}
}

type Parameter_Type_Enum int32

const (
	Parameter_Type_UNSPECIFIED         Parameter_Type_Enum = 0
	Parameter_Type_WINDOW              Parameter_Type_Enum = 1
	Parameter_Type_PIPELINE_OPTIONS    Parameter_Type_Enum = 2
	Parameter_Type_RESTRICTION_TRACKER Parameter_Type_Enum = 3
)

var Parameter_Type_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "WINDOW",
	2: "PIPELINE_OPTIONS",
	3: "RESTRICTION_TRACKER",
}

var Parameter_Type_Enum_value = map[string]int32{
	"UNSPECIFIED":         0,
	"WINDOW":              1,
	"PIPELINE_OPTIONS":    2,
	"RESTRICTION_TRACKER": 3,
}

func (x Parameter_Type_Enum) String() string {
	return proto.EnumName(Parameter_Type_Enum_name, int32(x))
}

func (Parameter_Type_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{8, 0, 0}
}

type IsBounded_Enum int32

const (
	IsBounded_UNSPECIFIED IsBounded_Enum = 0
	IsBounded_UNBOUNDED   IsBounded_Enum = 1
	IsBounded_BOUNDED     IsBounded_Enum = 2
)

var IsBounded_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "UNBOUNDED",
	2: "BOUNDED",
}

var IsBounded_Enum_value = map[string]int32{
	"UNSPECIFIED": 0,
	"UNBOUNDED":   1,
	"BOUNDED":     2,
}

func (x IsBounded_Enum) String() string {
	return proto.EnumName(IsBounded_Enum_name, int32(x))
}

func (IsBounded_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{16, 0}
}

type StandardCoders_Enum int32

const (
	// Components: None
	StandardCoders_BYTES StandardCoders_Enum = 0
	// Components: None
	StandardCoders_STRING_UTF8 StandardCoders_Enum = 10
	// Components: The key and value coder, in that order.
	StandardCoders_KV StandardCoders_Enum = 1
	// Components: None
	StandardCoders_BOOL StandardCoders_Enum = 12
	// Variable length Encodes a 64-bit integer.
	// Components: None
	StandardCoders_VARINT StandardCoders_Enum = 2
	// Encodes the floating point value as a big-endian 64-bit integer
	// according to the IEEE 754 double format bit layout.
	// Components: None
	StandardCoders_DOUBLE StandardCoders_Enum = 11
	// Encodes an iterable of elements.
	//
	// The encoding for an iterable [e1...eN] of known length N is
	//
	//    fixed32(N)
	//    encode(e1) encode(e2) encode(e3) ... encode(eN)
	//
	// If the length is unknown, it is batched up into groups of size b1..bM
	// and encoded as
	//
	//     fixed32(-1)
	//     varInt64(b1) encode(e1) encode(e2) ... encode(e_b1)
	//     varInt64(b2) encode(e_(b1+1)) encode(e_(b1+2)) ... encode(e_(b1+b2))
	//     ...
	//     varInt64(bM) encode(e_(N-bM+1)) encode(e_(N-bM+2)) ... encode(eN)
	//     varInt64(0)
	//
	// Components: Coder for a single element.
	StandardCoders_ITERABLE StandardCoders_Enum = 3
	// Encodes a timer containing a timestamp and a user specified payload.
	// The encoding is represented as: timestamp payload
	//   timestamp - a big endian 8 byte integer representing millis-since-epoch.
	//     The encoded representation is shifted so that the byte representation of
	//     negative values are lexicographically ordered before the byte representation
	//     of positive values. This is typically done by subtracting -9223372036854775808
	//     from the value and encoding it as a signed big endian integer. Example values:
	//
	//     -9223372036854775808: 00 00 00 00 00 00 00 00
	//                     -255: 7F FF FF FF FF FF FF 01
	//                       -1: 7F FF FF FF FF FF FF FF
	//                        0: 80 00 00 00 00 00 00 00
	//                        1: 80 00 00 00 00 00 00 01
	//                      256: 80 00 00 00 00 00 01 00
	//      9223372036854775807: FF FF FF FF FF FF FF FF
	//   payload - user defined data, uses the component coder
	// Components: Coder for the payload.
	StandardCoders_TIMER StandardCoders_Enum = 4
	// Components: None
	StandardCoders_INTERVAL_WINDOW StandardCoders_Enum = 5
	// Components: The coder to attach a length prefix to
	StandardCoders_LENGTH_PREFIX StandardCoders_Enum = 6
	// Components: None
	StandardCoders_GLOBAL_WINDOW StandardCoders_Enum = 7
	// Encodes an element, the window the value is in, the timestamp of the element, and the pane
	// of the element
	// Components: The element coder and the window coder, in that order
	StandardCoders_WINDOWED_VALUE StandardCoders_Enum = 8
	// A windowed value coder with parameterized timestamp, windows and pane info.
	// Encodes an element with only the value of the windowed value.
	// Decodes the value and assigns the parameterized timestamp, windows and pane info to the
	// windowed value.
	// Components: The element coder and the window coder, in that order
	// The payload of this coder is an encoded windowed value using the
	// beam:coder:windowed_value:v1 coder parameterized by a beam:coder:bytes:v1
	// element coder and the window coder that this param_windowed_value coder uses.
	StandardCoders_PARAM_WINDOWED_VALUE StandardCoders_Enum = 14
	// Encodes an iterable of elements, some of which may be stored elsewhere.
	//
	// The encoding for a state-backed iterable is the same as that for
	// an iterable, but the final varInt64(0) terminating the set of batches
	// may instead be replaced by
	//
	//     varInt64(-1)
	//     varInt64(len(token))
	//     token
	//
	// where token is an opaque byte string that can be used to fetch the
	// remainder of the iterable (e.g. over the state API).
	//
	// Components: Coder for a single element.
	// Experimental.
	StandardCoders_STATE_BACKED_ITERABLE StandardCoders_Enum = 9
	// Encodes a "row", an element with a known schema, defined by an
	// instance of Schema from schema.proto.
	//
	// A row is encoded as the concatenation of:
	//   - The number of attributes in the schema, encoded with
	//     beam:coder:varint:v1. This makes it possible to detect certain
	//     allowed schema changes (appending or removing columns) in
	//     long-running streaming pipelines.
	//   - A byte array representing a packed bitset indicating null fields (a
	//     1 indicating a null) encoded with beam:coder:bytes:v1. The unused
	//     bits in the last byte must be set to 0. If there are no nulls an
	//     empty byte array is encoded.
	//     The two-byte bitset (not including the lenghth-prefix) for the row
	//     [NULL, 0, 0, 0, NULL, 0, 0, NULL, 0, NULL] would be
	//     [0b10010001, 0b00000010]
	//   - An encoding for each non-null field, concatenated together.
	//
	// Schema types are mapped to coders as follows:
	//   AtomicType:
	//     BYTE:      not yet a standard coder (BEAM-7996)
	//     INT16:     not yet a standard coder (BEAM-7996)
	//     INT32:     beam:coder:varint:v1
	//     INT64:     beam:coder:varint:v1
	//     FLOAT:     not yet a standard coder (BEAM-7996)
	//     DOUBLE:    beam:coder:double:v1
	//     STRING:    beam:coder:string_utf8:v1
	//     BOOLEAN:   beam:coder:bool:v1
	//     BYTES:     beam:coder:bytes:v1
	//   ArrayType:   beam:coder:iterable:v1 (always has a known length)
	//   MapType:     not yet a standard coder (BEAM-7996)
	//   RowType:     beam:coder:row:v1
	//   LogicalType: Uses the coder for its representation.
	//
	// The payload for RowCoder is an instance of Schema.
	// Components: None
	// Experimental.
	StandardCoders_ROW StandardCoders_Enum = 13
)

var StandardCoders_Enum_name = map[int32]string{
	0:  "BYTES",
	10: "STRING_UTF8",
	1:  "KV",
	12: "BOOL",
	2:  "VARINT",
	11: "DOUBLE",
	3:  "ITERABLE",
	4:  "TIMER",
	5:  "INTERVAL_WINDOW",
	6:  "LENGTH_PREFIX",
	7:  "GLOBAL_WINDOW",
	8:  "WINDOWED_VALUE",
	14: "PARAM_WINDOWED_VALUE",
	9:  "STATE_BACKED_ITERABLE",
	13: "ROW",
}

var StandardCoders_Enum_value = map[string]int32{
	"BYTES":                 0,
	"STRING_UTF8":           10,
	"KV":                    1,
	"BOOL":                  12,
	"VARINT":                2,
	"DOUBLE":                11,
	"ITERABLE":              3,
	"TIMER":                 4,
	"INTERVAL_WINDOW":       5,
	"LENGTH_PREFIX":         6,
	"GLOBAL_WINDOW":         7,
	"WINDOWED_VALUE":        8,
	"PARAM_WINDOWED_VALUE":  14,
	"STATE_BACKED_ITERABLE": 9,
	"ROW":                   13,
}

func (x StandardCoders_Enum) String() string {
	return proto.EnumName(StandardCoders_Enum_name, int32(x))
}

func (StandardCoders_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{24, 0}
}

type MergeStatus_Enum int32

const (
	MergeStatus_UNSPECIFIED MergeStatus_Enum = 0
	// The WindowFn does not require merging.
	// Examples: global window, FixedWindows, SlidingWindows
	MergeStatus_NON_MERGING MergeStatus_Enum = 1
	// The WindowFn is merging and the PCollection has not had merging
	// performed.
	// Example: Sessions prior to a GroupByKey
	MergeStatus_NEEDS_MERGE MergeStatus_Enum = 2
	// The WindowFn is merging and the PCollection has had merging occur
	// already.
	// Example: Sessions after a GroupByKey
	MergeStatus_ALREADY_MERGED MergeStatus_Enum = 3
)

var MergeStatus_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "NON_MERGING",
	2: "NEEDS_MERGE",
	3: "ALREADY_MERGED",
}

var MergeStatus_Enum_value = map[string]int32{
	"UNSPECIFIED":    0,
	"NON_MERGING":    1,
	"NEEDS_MERGE":    2,
	"ALREADY_MERGED": 3,
}

func (x MergeStatus_Enum) String() string {
	return proto.EnumName(MergeStatus_Enum_name, int32(x))
}

func (MergeStatus_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{26, 0}
}

type AccumulationMode_Enum int32

const (
	AccumulationMode_UNSPECIFIED AccumulationMode_Enum = 0
	// The aggregation is discarded when it is output
	AccumulationMode_DISCARDING AccumulationMode_Enum = 1
	// The aggregation is accumulated across outputs
	AccumulationMode_ACCUMULATING AccumulationMode_Enum = 2
	// The aggregation emits retractions when it is output
	AccumulationMode_RETRACTING AccumulationMode_Enum = 3
)

var AccumulationMode_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "DISCARDING",
	2: "ACCUMULATING",
	3: "RETRACTING",
}

var AccumulationMode_Enum_value = map[string]int32{
	"UNSPECIFIED":  0,
	"DISCARDING":   1,
	"ACCUMULATING": 2,
	"RETRACTING":   3,
}

func (x AccumulationMode_Enum) String() string {
	return proto.EnumName(AccumulationMode_Enum_name, int32(x))
}

func (AccumulationMode_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{27, 0}
}

type ClosingBehavior_Enum int32

const (
	ClosingBehavior_UNSPECIFIED ClosingBehavior_Enum = 0
	// Emit output when a window expires, whether or not there has been
	// any new data since the last output.
	ClosingBehavior_EMIT_ALWAYS ClosingBehavior_Enum = 1
	// Only emit output when new data has arrives since the last output
	ClosingBehavior_EMIT_IF_NONEMPTY ClosingBehavior_Enum = 2
)

var ClosingBehavior_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "EMIT_ALWAYS",
	2: "EMIT_IF_NONEMPTY",
}

var ClosingBehavior_Enum_value = map[string]int32{
	"UNSPECIFIED":      0,
	"EMIT_ALWAYS":      1,
	"EMIT_IF_NONEMPTY": 2,
}

func (x ClosingBehavior_Enum) String() string {
	return proto.EnumName(ClosingBehavior_Enum_name, int32(x))
}

func (ClosingBehavior_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{28, 0}
}

type OnTimeBehavior_Enum int32

const (
	OnTimeBehavior_UNSPECIFIED OnTimeBehavior_Enum = 0
	// Always fire the on-time pane. Even if there is no new data since
	// the previous firing, an element will be produced.
	OnTimeBehavior_FIRE_ALWAYS OnTimeBehavior_Enum = 1
	// Only fire the on-time pane if there is new data since the previous firing.
	OnTimeBehavior_FIRE_IF_NONEMPTY OnTimeBehavior_Enum = 2
)

var OnTimeBehavior_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "FIRE_ALWAYS",
	2: "FIRE_IF_NONEMPTY",
}

var OnTimeBehavior_Enum_value = map[string]int32{
	"UNSPECIFIED":      0,
	"FIRE_ALWAYS":      1,
	"FIRE_IF_NONEMPTY": 2,
}

func (x OnTimeBehavior_Enum) String() string {
	return proto.EnumName(OnTimeBehavior_Enum_name, int32(x))
}

func (OnTimeBehavior_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{29, 0}
}

type OutputTime_Enum int32

const (
	OutputTime_UNSPECIFIED OutputTime_Enum = 0
	// The output has the timestamp of the end of the window.
	OutputTime_END_OF_WINDOW OutputTime_Enum = 1
	// The output has the latest timestamp of the input elements since
	// the last output.
	OutputTime_LATEST_IN_PANE OutputTime_Enum = 2
	// The output has the earliest timestamp of the input elements since
	// the last output.
	OutputTime_EARLIEST_IN_PANE OutputTime_Enum = 3
)

var OutputTime_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "END_OF_WINDOW",
	2: "LATEST_IN_PANE",
	3: "EARLIEST_IN_PANE",
}

var OutputTime_Enum_value = map[string]int32{
	"UNSPECIFIED":      0,
	"END_OF_WINDOW":    1,
	"LATEST_IN_PANE":   2,
	"EARLIEST_IN_PANE": 3,
}

func (x OutputTime_Enum) String() string {
	return proto.EnumName(OutputTime_Enum_name, int32(x))
}

func (OutputTime_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{30, 0}
}

type TimeDomain_Enum int32

const (
	TimeDomain_UNSPECIFIED TimeDomain_Enum = 0
	// Event time is time from the perspective of the data
	TimeDomain_EVENT_TIME TimeDomain_Enum = 1
	// Processing time is time from the perspective of the
	// execution of your pipeline
	TimeDomain_PROCESSING_TIME TimeDomain_Enum = 2
	// Synchronized processing time is the minimum of the
	// processing time of all pending elements.
	//
	// The "processing time" of an element refers to
	// the local processing time at which it was emitted
	TimeDomain_SYNCHRONIZED_PROCESSING_TIME TimeDomain_Enum = 3
)

var TimeDomain_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "EVENT_TIME",
	2: "PROCESSING_TIME",
	3: "SYNCHRONIZED_PROCESSING_TIME",
}

var TimeDomain_Enum_value = map[string]int32{
	"UNSPECIFIED":                  0,
	"EVENT_TIME":                   1,
	"PROCESSING_TIME":              2,
	"SYNCHRONIZED_PROCESSING_TIME": 3,
}

func (x TimeDomain_Enum) String() string {
	return proto.EnumName(TimeDomain_Enum_name, int32(x))
}

func (TimeDomain_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{31, 0}
}

type StandardEnvironments_Environments int32

const (
	StandardEnvironments_DOCKER   StandardEnvironments_Environments = 0
	StandardEnvironments_PROCESS  StandardEnvironments_Environments = 1
	StandardEnvironments_EXTERNAL StandardEnvironments_Environments = 2
)

var StandardEnvironments_Environments_name = map[int32]string{
	0: "DOCKER",
	1: "PROCESS",
	2: "EXTERNAL",
}

var StandardEnvironments_Environments_value = map[string]int32{
	"DOCKER":   0,
	"PROCESS":  1,
	"EXTERNAL": 2,
}

func (x StandardEnvironments_Environments) String() string {
	return proto.EnumName(StandardEnvironments_Environments_name, int32(x))
}

func (StandardEnvironments_Environments) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{37, 0}
}

type DisplayData_Type_Enum int32

const (
	DisplayData_Type_UNSPECIFIED DisplayData_Type_Enum = 0
	DisplayData_Type_STRING      DisplayData_Type_Enum = 1
	DisplayData_Type_INTEGER     DisplayData_Type_Enum = 2
	DisplayData_Type_FLOAT       DisplayData_Type_Enum = 3
	DisplayData_Type_BOOLEAN     DisplayData_Type_Enum = 4
	DisplayData_Type_TIMESTAMP   DisplayData_Type_Enum = 5
	DisplayData_Type_DURATION    DisplayData_Type_Enum = 6
	DisplayData_Type_JAVA_CLASS  DisplayData_Type_Enum = 7
)

var DisplayData_Type_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "STRING",
	2: "INTEGER",
	3: "FLOAT",
	4: "BOOLEAN",
	5: "TIMESTAMP",
	6: "DURATION",
	7: "JAVA_CLASS",
}

var DisplayData_Type_Enum_value = map[string]int32{
	"UNSPECIFIED": 0,
	"STRING":      1,
	"INTEGER":     2,
	"FLOAT":       3,
	"BOOLEAN":     4,
	"TIMESTAMP":   5,
	"DURATION":    6,
	"JAVA_CLASS":  7,
}

func (x DisplayData_Type_Enum) String() string {
	return proto.EnumName(DisplayData_Type_Enum_name, int32(x))
}

func (DisplayData_Type_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{42, 2, 0}
}

type BeamConstants struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BeamConstants) Reset()         { *m = BeamConstants{} }
func (m *BeamConstants) String() string { return proto.CompactTextString(m) }
func (*BeamConstants) ProtoMessage()    {}
func (*BeamConstants) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{0}
}

func (m *BeamConstants) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BeamConstants.Unmarshal(m, b)
}
func (m *BeamConstants) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BeamConstants.Marshal(b, m, deterministic)
}
func (m *BeamConstants) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BeamConstants.Merge(m, src)
}
func (m *BeamConstants) XXX_Size() int {
	return xxx_messageInfo_BeamConstants.Size(m)
}
func (m *BeamConstants) XXX_DiscardUnknown() {
	xxx_messageInfo_BeamConstants.DiscardUnknown(m)
}

var xxx_messageInfo_BeamConstants proto.InternalMessageInfo

// A set of mappings from id to message. This is included as an optional field
// on any proto message that may contain references needing resolution.
type Components struct {
	// (Required) A map from pipeline-scoped id to PTransform.
	Transforms map[string]*PTransform `protobuf:"bytes,1,rep,name=transforms,proto3" json:"transforms,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to PCollection.
	Pcollections map[string]*PCollection `protobuf:"bytes,2,rep,name=pcollections,proto3" json:"pcollections,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to WindowingStrategy.
	WindowingStrategies map[string]*WindowingStrategy `protobuf:"bytes,3,rep,name=windowing_strategies,json=windowingStrategies,proto3" json:"windowing_strategies,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to Coder.
	Coders map[string]*Coder `protobuf:"bytes,4,rep,name=coders,proto3" json:"coders,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to Environment.
	Environments         map[string]*Environment `protobuf:"bytes,5,rep,name=environments,proto3" json:"environments,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *Components) Reset()         { *m = Components{} }
func (m *Components) String() string { return proto.CompactTextString(m) }
func (*Components) ProtoMessage()    {}
func (*Components) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{1}
}

func (m *Components) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Components.Unmarshal(m, b)
}
func (m *Components) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Components.Marshal(b, m, deterministic)
}
func (m *Components) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Components.Merge(m, src)
}
func (m *Components) XXX_Size() int {
	return xxx_messageInfo_Components.Size(m)
}
func (m *Components) XXX_DiscardUnknown() {
	xxx_messageInfo_Components.DiscardUnknown(m)
}

var xxx_messageInfo_Components proto.InternalMessageInfo

func (m *Components) GetTransforms() map[string]*PTransform {
	if m != nil {
		return m.Transforms
	}
	return nil
}

func (m *Components) GetPcollections() map[string]*PCollection {
	if m != nil {
		return m.Pcollections
	}
	return nil
}

func (m *Components) GetWindowingStrategies() map[string]*WindowingStrategy {
	if m != nil {
		return m.WindowingStrategies
	}
	return nil
}

func (m *Components) GetCoders() map[string]*Coder {
	if m != nil {
		return m.Coders
	}
	return nil
}

func (m *Components) GetEnvironments() map[string]*Environment {
	if m != nil {
		return m.Environments
	}
	return nil
}

// A Pipeline is a hierarchical graph of PTransforms, linked
// by PCollections.
//
// This is represented by a number of by-reference maps to nodes,
// PCollections, SDK environments, UDF, etc., for
// supporting compact reuse and arbitrary graph structure.
//
// All of the keys in the maps here are arbitrary strings that are only
// required to be internally consistent within this proto message.
type Pipeline struct {
	// (Required) The coders, UDFs, graph nodes, etc, that make up
	// this pipeline.
	Components *Components `protobuf:"bytes,1,opt,name=components,proto3" json:"components,omitempty"`
	// (Required) The ids of all PTransforms that are not contained within another PTransform.
	// These must be in shallow topological order, so that traversing them recursively
	// in this order yields a recursively topological traversal.
	RootTransformIds []string `protobuf:"bytes,2,rep,name=root_transform_ids,json=rootTransformIds,proto3" json:"root_transform_ids,omitempty"`
	// (Optional) Static display data for the pipeline. If there is none,
	// it may be omitted.
	DisplayData          *DisplayData `protobuf:"bytes,3,opt,name=display_data,json=displayData,proto3" json:"display_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Pipeline) Reset()         { *m = Pipeline{} }
func (m *Pipeline) String() string { return proto.CompactTextString(m) }
func (*Pipeline) ProtoMessage()    {}
func (*Pipeline) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{2}
}

func (m *Pipeline) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Pipeline.Unmarshal(m, b)
}
func (m *Pipeline) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Pipeline.Marshal(b, m, deterministic)
}
func (m *Pipeline) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Pipeline.Merge(m, src)
}
func (m *Pipeline) XXX_Size() int {
	return xxx_messageInfo_Pipeline.Size(m)
}
func (m *Pipeline) XXX_DiscardUnknown() {
	xxx_messageInfo_Pipeline.DiscardUnknown(m)
}

var xxx_messageInfo_Pipeline proto.InternalMessageInfo

func (m *Pipeline) GetComponents() *Components {
	if m != nil {
		return m.Components
	}
	return nil
}

func (m *Pipeline) GetRootTransformIds() []string {
	if m != nil {
		return m.RootTransformIds
	}
	return nil
}

func (m *Pipeline) GetDisplayData() *DisplayData {
	if m != nil {
		return m.DisplayData
	}
	return nil
}

// An applied PTransform! This does not contain the graph data, but only the
// fields specific to a graph node that is a Runner API transform
// between PCollections.
type PTransform struct {
	// (Required) A unique name for the application node.
	//
	// Ideally, this should be stable over multiple evolutions of a pipeline
	// for the purposes of logging and associating pipeline state with a node,
	// etc.
	//
	// If it is not stable, then the runner decides what will happen. But, most
	// importantly, it must always be here and be unique, even if it is
	// autogenerated.
	UniqueName string `protobuf:"bytes,5,opt,name=unique_name,json=uniqueName,proto3" json:"unique_name,omitempty"`
	// (Optional) A URN and payload that, together, fully defined the semantics
	// of this transform.
	//
	// If absent, this must be an "anonymous" composite transform.
	//
	// For primitive transform in the Runner API, this is required, and the
	// payloads are well-defined messages. When the URN indicates ParDo it
	// is a ParDoPayload, and so on.
	//
	// TODO: document the standardized URNs and payloads
	// TODO: separate standardized payloads into a separate proto file
	//
	// For some special composite transforms, the payload is also officially
	// defined:
	//
	//  - when the URN is "beam:transforms:combine" it is a CombinePayload
	//
	Spec *FunctionSpec `protobuf:"bytes,1,opt,name=spec,proto3" json:"spec,omitempty"`
	// (Optional) if this node is a composite, a list of the ids of
	// transforms that it contains.
	Subtransforms []string `protobuf:"bytes,2,rep,name=subtransforms,proto3" json:"subtransforms,omitempty"`
	// (Required) A map from local names of inputs (unique only with this map, and
	// likely embedded in the transform payload and serialized user code) to
	// PCollection ids.
	//
	// The payload for this transform may clarify the relationship of these
	// inputs. For example:
	//
	//  - for a Flatten transform they are merged
	//  - for a ParDo transform, some may be side inputs
	//
	// All inputs are recorded here so that the topological ordering of
	// the graph is consistent whether or not the payload is understood.
	//
	Inputs map[string]string `protobuf:"bytes,3,rep,name=inputs,proto3" json:"inputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from local names of outputs (unique only within this map,
	// and likely embedded in the transform payload and serialized user code)
	// to PCollection ids.
	//
	// The URN or payload for this transform node may clarify the type and
	// relationship of these outputs. For example:
	//
	//  - for a ParDo transform, these are tags on PCollections, which will be
	//    embedded in the DoFn.
	//
	Outputs map[string]string `protobuf:"bytes,4,rep,name=outputs,proto3" json:"outputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Optional) Static display data for this PTransform application. If
	// there is none, or it is not relevant (such as use by the Fn API)
	// then it may be omitted.
	DisplayData *DisplayData `protobuf:"bytes,6,opt,name=display_data,json=displayData,proto3" json:"display_data,omitempty"`
	// (Optional) Environment where the current PTransform should be executed in.
	// Runner that executes the pipeline may choose to override this if needed. If
	// not specified, environment will be decided by the runner.
	EnvironmentId        string   `protobuf:"bytes,7,opt,name=environment_id,json=environmentId,proto3" json:"environment_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PTransform) Reset()         { *m = PTransform{} }
func (m *PTransform) String() string { return proto.CompactTextString(m) }
func (*PTransform) ProtoMessage()    {}
func (*PTransform) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{3}
}

func (m *PTransform) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PTransform.Unmarshal(m, b)
}
func (m *PTransform) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PTransform.Marshal(b, m, deterministic)
}
func (m *PTransform) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PTransform.Merge(m, src)
}
func (m *PTransform) XXX_Size() int {
	return xxx_messageInfo_PTransform.Size(m)
}
func (m *PTransform) XXX_DiscardUnknown() {
	xxx_messageInfo_PTransform.DiscardUnknown(m)
}

var xxx_messageInfo_PTransform proto.InternalMessageInfo

func (m *PTransform) GetUniqueName() string {
	if m != nil {
		return m.UniqueName
	}
	return ""
}

func (m *PTransform) GetSpec() *FunctionSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *PTransform) GetSubtransforms() []string {
	if m != nil {
		return m.Subtransforms
	}
	return nil
}

func (m *PTransform) GetInputs() map[string]string {
	if m != nil {
		return m.Inputs
	}
	return nil
}

func (m *PTransform) GetOutputs() map[string]string {
	if m != nil {
		return m.Outputs
	}
	return nil
}

func (m *PTransform) GetDisplayData() *DisplayData {
	if m != nil {
		return m.DisplayData
	}
	return nil
}

func (m *PTransform) GetEnvironmentId() string {
	if m != nil {
		return m.EnvironmentId
	}
	return ""
}

type StandardPTransforms struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StandardPTransforms) Reset()         { *m = StandardPTransforms{} }
func (m *StandardPTransforms) String() string { return proto.CompactTextString(m) }
func (*StandardPTransforms) ProtoMessage()    {}
func (*StandardPTransforms) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{4}
}

func (m *StandardPTransforms) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StandardPTransforms.Unmarshal(m, b)
}
func (m *StandardPTransforms) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StandardPTransforms.Marshal(b, m, deterministic)
}
func (m *StandardPTransforms) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StandardPTransforms.Merge(m, src)
}
func (m *StandardPTransforms) XXX_Size() int {
	return xxx_messageInfo_StandardPTransforms.Size(m)
}
func (m *StandardPTransforms) XXX_DiscardUnknown() {
	xxx_messageInfo_StandardPTransforms.DiscardUnknown(m)
}

var xxx_messageInfo_StandardPTransforms proto.InternalMessageInfo

type StandardSideInputTypes struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StandardSideInputTypes) Reset()         { *m = StandardSideInputTypes{} }
func (m *StandardSideInputTypes) String() string { return proto.CompactTextString(m) }
func (*StandardSideInputTypes) ProtoMessage()    {}
func (*StandardSideInputTypes) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{5}
}

func (m *StandardSideInputTypes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StandardSideInputTypes.Unmarshal(m, b)
}
func (m *StandardSideInputTypes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StandardSideInputTypes.Marshal(b, m, deterministic)
}
func (m *StandardSideInputTypes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StandardSideInputTypes.Merge(m, src)
}
func (m *StandardSideInputTypes) XXX_Size() int {
	return xxx_messageInfo_StandardSideInputTypes.Size(m)
}
func (m *StandardSideInputTypes) XXX_DiscardUnknown() {
	xxx_messageInfo_StandardSideInputTypes.DiscardUnknown(m)
}

var xxx_messageInfo_StandardSideInputTypes proto.InternalMessageInfo

// A PCollection!
type PCollection struct {
	// (Required) A unique name for the PCollection.
	//
	// Ideally, this should be stable over multiple evolutions of a pipeline
	// for the purposes of logging and associating pipeline state with a node,
	// etc.
	//
	// If it is not stable, then the runner decides what will happen. But, most
	// importantly, it must always be here, even if it is autogenerated.
	UniqueName string `protobuf:"bytes,1,opt,name=unique_name,json=uniqueName,proto3" json:"unique_name,omitempty"`
	// (Required) The id of the Coder for this PCollection.
	CoderId string `protobuf:"bytes,2,opt,name=coder_id,json=coderId,proto3" json:"coder_id,omitempty"`
	// (Required) Whether this PCollection is bounded or unbounded
	IsBounded IsBounded_Enum `protobuf:"varint,3,opt,name=is_bounded,json=isBounded,proto3,enum=org.apache.beam.model.pipeline.v1.IsBounded_Enum" json:"is_bounded,omitempty"`
	// (Required) The id of the windowing strategy for this PCollection.
	WindowingStrategyId string `protobuf:"bytes,4,opt,name=windowing_strategy_id,json=windowingStrategyId,proto3" json:"windowing_strategy_id,omitempty"`
	// (Optional) Static display data for this PTransform application. If
	// there is none, or it is not relevant (such as use by the Fn API)
	// then it may be omitted.
	DisplayData          *DisplayData `protobuf:"bytes,5,opt,name=display_data,json=displayData,proto3" json:"display_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *PCollection) Reset()         { *m = PCollection{} }
func (m *PCollection) String() string { return proto.CompactTextString(m) }
func (*PCollection) ProtoMessage()    {}
func (*PCollection) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{6}
}

func (m *PCollection) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PCollection.Unmarshal(m, b)
}
func (m *PCollection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PCollection.Marshal(b, m, deterministic)
}
func (m *PCollection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PCollection.Merge(m, src)
}
func (m *PCollection) XXX_Size() int {
	return xxx_messageInfo_PCollection.Size(m)
}
func (m *PCollection) XXX_DiscardUnknown() {
	xxx_messageInfo_PCollection.DiscardUnknown(m)
}

var xxx_messageInfo_PCollection proto.InternalMessageInfo

func (m *PCollection) GetUniqueName() string {
	if m != nil {
		return m.UniqueName
	}
	return ""
}

func (m *PCollection) GetCoderId() string {
	if m != nil {
		return m.CoderId
	}
	return ""
}

func (m *PCollection) GetIsBounded() IsBounded_Enum {
	if m != nil {
		return m.IsBounded
	}
	return IsBounded_UNSPECIFIED
}

func (m *PCollection) GetWindowingStrategyId() string {
	if m != nil {
		return m.WindowingStrategyId
	}
	return ""
}

func (m *PCollection) GetDisplayData() *DisplayData {
	if m != nil {
		return m.DisplayData
	}
	return nil
}

// The payload for the primitive ParDo transform.
type ParDoPayload struct {
	// (Required) The FunctionSpec of the DoFn.
	DoFn *FunctionSpec `protobuf:"bytes,1,opt,name=do_fn,json=doFn,proto3" json:"do_fn,omitempty"`
	// (Required) Additional pieces of context the DoFn may require that
	// are not otherwise represented in the payload.
	// (may force runners to execute the ParDo differently)
	Parameters []*Parameter `protobuf:"bytes,2,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// (Optional) A mapping of local input names to side inputs, describing
	// the expected access pattern.
	SideInputs map[string]*SideInput `protobuf:"bytes,3,rep,name=side_inputs,json=sideInputs,proto3" json:"side_inputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Optional) A mapping of local state names to state specifications.
	StateSpecs map[string]*StateSpec `protobuf:"bytes,4,rep,name=state_specs,json=stateSpecs,proto3" json:"state_specs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Optional) A mapping of local timer names to timer specifications.
	TimerSpecs map[string]*TimerSpec `protobuf:"bytes,5,rep,name=timer_specs,json=timerSpecs,proto3" json:"timer_specs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Whether the DoFn is splittable
	Splittable bool `protobuf:"varint,6,opt,name=splittable,proto3" json:"splittable,omitempty"`
	// (Required if splittable == true) Id of the restriction coder.
	RestrictionCoderId string `protobuf:"bytes,7,opt,name=restriction_coder_id,json=restrictionCoderId,proto3" json:"restriction_coder_id,omitempty"`
	// (Optional) Only set when this ParDo can request bundle finalization.
	RequestsFinalization bool     `protobuf:"varint,8,opt,name=requests_finalization,json=requestsFinalization,proto3" json:"requests_finalization,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ParDoPayload) Reset()         { *m = ParDoPayload{} }
func (m *ParDoPayload) String() string { return proto.CompactTextString(m) }
func (*ParDoPayload) ProtoMessage()    {}
func (*ParDoPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{7}
}

func (m *ParDoPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ParDoPayload.Unmarshal(m, b)
}
func (m *ParDoPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ParDoPayload.Marshal(b, m, deterministic)
}
func (m *ParDoPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ParDoPayload.Merge(m, src)
}
func (m *ParDoPayload) XXX_Size() int {
	return xxx_messageInfo_ParDoPayload.Size(m)
}
func (m *ParDoPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_ParDoPayload.DiscardUnknown(m)
}

var xxx_messageInfo_ParDoPayload proto.InternalMessageInfo

func (m *ParDoPayload) GetDoFn() *FunctionSpec {
	if m != nil {
		return m.DoFn
	}
	return nil
}

func (m *ParDoPayload) GetParameters() []*Parameter {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *ParDoPayload) GetSideInputs() map[string]*SideInput {
	if m != nil {
		return m.SideInputs
	}
	return nil
}

func (m *ParDoPayload) GetStateSpecs() map[string]*StateSpec {
	if m != nil {
		return m.StateSpecs
	}
	return nil
}

func (m *ParDoPayload) GetTimerSpecs() map[string]*TimerSpec {
	if m != nil {
		return m.TimerSpecs
	}
	return nil
}

func (m *ParDoPayload) GetSplittable() bool {
	if m != nil {
		return m.Splittable
	}
	return false
}

func (m *ParDoPayload) GetRestrictionCoderId() string {
	if m != nil {
		return m.RestrictionCoderId
	}
	return ""
}

func (m *ParDoPayload) GetRequestsFinalization() bool {
	if m != nil {
		return m.RequestsFinalization
	}
	return false
}

// Parameters that a UDF might require.
//
// The details of how a runner sends these parameters to the SDK harness
// are the subject of the Fn API.
//
// The details of how an SDK harness delivers them to the UDF is entirely
// up to the SDK. (for some SDKs there may be parameters that are not
// represented here if the runner doesn't need to do anything)
//
// Here, the parameters are simply indicators to the runner that they
// need to run the function a particular way.
//
// TODO: the evolution of the Fn API will influence what needs explicit
// representation here
type Parameter struct {
	Type                 Parameter_Type_Enum `protobuf:"varint,1,opt,name=type,proto3,enum=org.apache.beam.model.pipeline.v1.Parameter_Type_Enum" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Parameter) Reset()         { *m = Parameter{} }
func (m *Parameter) String() string { return proto.CompactTextString(m) }
func (*Parameter) ProtoMessage()    {}
func (*Parameter) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{8}
}

func (m *Parameter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Parameter.Unmarshal(m, b)
}
func (m *Parameter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Parameter.Marshal(b, m, deterministic)
}
func (m *Parameter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Parameter.Merge(m, src)
}
func (m *Parameter) XXX_Size() int {
	return xxx_messageInfo_Parameter.Size(m)
}
func (m *Parameter) XXX_DiscardUnknown() {
	xxx_messageInfo_Parameter.DiscardUnknown(m)
}

var xxx_messageInfo_Parameter proto.InternalMessageInfo

func (m *Parameter) GetType() Parameter_Type_Enum {
	if m != nil {
		return m.Type
	}
	return Parameter_Type_UNSPECIFIED
}

type Parameter_Type struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Parameter_Type) Reset()         { *m = Parameter_Type{} }
func (m *Parameter_Type) String() string { return proto.CompactTextString(m) }
func (*Parameter_Type) ProtoMessage()    {}
func (*Parameter_Type) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{8, 0}
}

func (m *Parameter_Type) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Parameter_Type.Unmarshal(m, b)
}
func (m *Parameter_Type) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Parameter_Type.Marshal(b, m, deterministic)
}
func (m *Parameter_Type) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Parameter_Type.Merge(m, src)
}
func (m *Parameter_Type) XXX_Size() int {
	return xxx_messageInfo_Parameter_Type.Size(m)
}
func (m *Parameter_Type) XXX_DiscardUnknown() {
	xxx_messageInfo_Parameter_Type.DiscardUnknown(m)
}

var xxx_messageInfo_Parameter_Type proto.InternalMessageInfo

type StateSpec struct {
	// Types that are valid to be assigned to Spec:
	//	*StateSpec_ReadModifyWriteSpec
	//	*StateSpec_BagSpec
	//	*StateSpec_CombiningSpec
	//	*StateSpec_MapSpec
	//	*StateSpec_SetSpec
	Spec                 isStateSpec_Spec `protobuf_oneof:"spec"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *StateSpec) Reset()         { *m = StateSpec{} }
func (m *StateSpec) String() string { return proto.CompactTextString(m) }
func (*StateSpec) ProtoMessage()    {}
func (*StateSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{9}
}

func (m *StateSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateSpec.Unmarshal(m, b)
}
func (m *StateSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateSpec.Marshal(b, m, deterministic)
}
func (m *StateSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateSpec.Merge(m, src)
}
func (m *StateSpec) XXX_Size() int {
	return xxx_messageInfo_StateSpec.Size(m)
}
func (m *StateSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_StateSpec.DiscardUnknown(m)
}

var xxx_messageInfo_StateSpec proto.InternalMessageInfo

type isStateSpec_Spec interface {
	isStateSpec_Spec()
}

type StateSpec_ReadModifyWriteSpec struct {
	ReadModifyWriteSpec *ReadModifyWriteStateSpec `protobuf:"bytes,1,opt,name=read_modify_write_spec,json=readModifyWriteSpec,proto3,oneof"`
}

type StateSpec_BagSpec struct {
	BagSpec *BagStateSpec `protobuf:"bytes,2,opt,name=bag_spec,json=bagSpec,proto3,oneof"`
}

type StateSpec_CombiningSpec struct {
	CombiningSpec *CombiningStateSpec `protobuf:"bytes,3,opt,name=combining_spec,json=combiningSpec,proto3,oneof"`
}

type StateSpec_MapSpec struct {
	MapSpec *MapStateSpec `protobuf:"bytes,4,opt,name=map_spec,json=mapSpec,proto3,oneof"`
}

type StateSpec_SetSpec struct {
	SetSpec *SetStateSpec `protobuf:"bytes,5,opt,name=set_spec,json=setSpec,proto3,oneof"`
}

func (*StateSpec_ReadModifyWriteSpec) isStateSpec_Spec() {}

func (*StateSpec_BagSpec) isStateSpec_Spec() {}

func (*StateSpec_CombiningSpec) isStateSpec_Spec() {}

func (*StateSpec_MapSpec) isStateSpec_Spec() {}

func (*StateSpec_SetSpec) isStateSpec_Spec() {}

func (m *StateSpec) GetSpec() isStateSpec_Spec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *StateSpec) GetReadModifyWriteSpec() *ReadModifyWriteStateSpec {
	if x, ok := m.GetSpec().(*StateSpec_ReadModifyWriteSpec); ok {
		return x.ReadModifyWriteSpec
	}
	return nil
}

func (m *StateSpec) GetBagSpec() *BagStateSpec {
	if x, ok := m.GetSpec().(*StateSpec_BagSpec); ok {
		return x.BagSpec
	}
	return nil
}

func (m *StateSpec) GetCombiningSpec() *CombiningStateSpec {
	if x, ok := m.GetSpec().(*StateSpec_CombiningSpec); ok {
		return x.CombiningSpec
	}
	return nil
}

func (m *StateSpec) GetMapSpec() *MapStateSpec {
	if x, ok := m.GetSpec().(*StateSpec_MapSpec); ok {
		return x.MapSpec
	}
	return nil
}

func (m *StateSpec) GetSetSpec() *SetStateSpec {
	if x, ok := m.GetSpec().(*StateSpec_SetSpec); ok {
		return x.SetSpec
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StateSpec) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StateSpec_ReadModifyWriteSpec)(nil),
		(*StateSpec_BagSpec)(nil),
		(*StateSpec_CombiningSpec)(nil),
		(*StateSpec_MapSpec)(nil),
		(*StateSpec_SetSpec)(nil),
	}
}

type ReadModifyWriteStateSpec struct {
	CoderId              string   `protobuf:"bytes,1,opt,name=coder_id,json=coderId,proto3" json:"coder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReadModifyWriteStateSpec) Reset()         { *m = ReadModifyWriteStateSpec{} }
func (m *ReadModifyWriteStateSpec) String() string { return proto.CompactTextString(m) }
func (*ReadModifyWriteStateSpec) ProtoMessage()    {}
func (*ReadModifyWriteStateSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{10}
}

func (m *ReadModifyWriteStateSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadModifyWriteStateSpec.Unmarshal(m, b)
}
func (m *ReadModifyWriteStateSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadModifyWriteStateSpec.Marshal(b, m, deterministic)
}
func (m *ReadModifyWriteStateSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadModifyWriteStateSpec.Merge(m, src)
}
func (m *ReadModifyWriteStateSpec) XXX_Size() int {
	return xxx_messageInfo_ReadModifyWriteStateSpec.Size(m)
}
func (m *ReadModifyWriteStateSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadModifyWriteStateSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ReadModifyWriteStateSpec proto.InternalMessageInfo

func (m *ReadModifyWriteStateSpec) GetCoderId() string {
	if m != nil {
		return m.CoderId
	}
	return ""
}

type BagStateSpec struct {
	ElementCoderId       string   `protobuf:"bytes,1,opt,name=element_coder_id,json=elementCoderId,proto3" json:"element_coder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BagStateSpec) Reset()         { *m = BagStateSpec{} }
func (m *BagStateSpec) String() string { return proto.CompactTextString(m) }
func (*BagStateSpec) ProtoMessage()    {}
func (*BagStateSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{11}
}

func (m *BagStateSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BagStateSpec.Unmarshal(m, b)
}
func (m *BagStateSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BagStateSpec.Marshal(b, m, deterministic)
}
func (m *BagStateSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BagStateSpec.Merge(m, src)
}
func (m *BagStateSpec) XXX_Size() int {
	return xxx_messageInfo_BagStateSpec.Size(m)
}
func (m *BagStateSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_BagStateSpec.DiscardUnknown(m)
}

var xxx_messageInfo_BagStateSpec proto.InternalMessageInfo

func (m *BagStateSpec) GetElementCoderId() string {
	if m != nil {
		return m.ElementCoderId
	}
	return ""
}

type CombiningStateSpec struct {
	AccumulatorCoderId   string        `protobuf:"bytes,1,opt,name=accumulator_coder_id,json=accumulatorCoderId,proto3" json:"accumulator_coder_id,omitempty"`
	CombineFn            *FunctionSpec `protobuf:"bytes,2,opt,name=combine_fn,json=combineFn,proto3" json:"combine_fn,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CombiningStateSpec) Reset()         { *m = CombiningStateSpec{} }
func (m *CombiningStateSpec) String() string { return proto.CompactTextString(m) }
func (*CombiningStateSpec) ProtoMessage()    {}
func (*CombiningStateSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{12}
}

func (m *CombiningStateSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CombiningStateSpec.Unmarshal(m, b)
}
func (m *CombiningStateSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CombiningStateSpec.Marshal(b, m, deterministic)
}
func (m *CombiningStateSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CombiningStateSpec.Merge(m, src)
}
func (m *CombiningStateSpec) XXX_Size() int {
	return xxx_messageInfo_CombiningStateSpec.Size(m)
}
func (m *CombiningStateSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_CombiningStateSpec.DiscardUnknown(m)
}

var xxx_messageInfo_CombiningStateSpec proto.InternalMessageInfo

func (m *CombiningStateSpec) GetAccumulatorCoderId() string {
	if m != nil {
		return m.AccumulatorCoderId
	}
	return ""
}

func (m *CombiningStateSpec) GetCombineFn() *FunctionSpec {
	if m != nil {
		return m.CombineFn
	}
	return nil
}

type MapStateSpec struct {
	KeyCoderId           string   `protobuf:"bytes,1,opt,name=key_coder_id,json=keyCoderId,proto3" json:"key_coder_id,omitempty"`
	ValueCoderId         string   `protobuf:"bytes,2,opt,name=value_coder_id,json=valueCoderId,proto3" json:"value_coder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MapStateSpec) Reset()         { *m = MapStateSpec{} }
func (m *MapStateSpec) String() string { return proto.CompactTextString(m) }
func (*MapStateSpec) ProtoMessage()    {}
func (*MapStateSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{13}
}

func (m *MapStateSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MapStateSpec.Unmarshal(m, b)
}
func (m *MapStateSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MapStateSpec.Marshal(b, m, deterministic)
}
func (m *MapStateSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MapStateSpec.Merge(m, src)
}
func (m *MapStateSpec) XXX_Size() int {
	return xxx_messageInfo_MapStateSpec.Size(m)
}
func (m *MapStateSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_MapStateSpec.DiscardUnknown(m)
}

var xxx_messageInfo_MapStateSpec proto.InternalMessageInfo

func (m *MapStateSpec) GetKeyCoderId() string {
	if m != nil {
		return m.KeyCoderId
	}
	return ""
}

func (m *MapStateSpec) GetValueCoderId() string {
	if m != nil {
		return m.ValueCoderId
	}
	return ""
}

type SetStateSpec struct {
	ElementCoderId       string   `protobuf:"bytes,1,opt,name=element_coder_id,json=elementCoderId,proto3" json:"element_coder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetStateSpec) Reset()         { *m = SetStateSpec{} }
func (m *SetStateSpec) String() string { return proto.CompactTextString(m) }
func (*SetStateSpec) ProtoMessage()    {}
func (*SetStateSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{14}
}

func (m *SetStateSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetStateSpec.Unmarshal(m, b)
}
func (m *SetStateSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetStateSpec.Marshal(b, m, deterministic)
}
func (m *SetStateSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetStateSpec.Merge(m, src)
}
func (m *SetStateSpec) XXX_Size() int {
	return xxx_messageInfo_SetStateSpec.Size(m)
}
func (m *SetStateSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_SetStateSpec.DiscardUnknown(m)
}

var xxx_messageInfo_SetStateSpec proto.InternalMessageInfo

func (m *SetStateSpec) GetElementCoderId() string {
	if m != nil {
		return m.ElementCoderId
	}
	return ""
}

type TimerSpec struct {
	TimeDomain           TimeDomain_Enum `protobuf:"varint,1,opt,name=time_domain,json=timeDomain,proto3,enum=org.apache.beam.model.pipeline.v1.TimeDomain_Enum" json:"time_domain,omitempty"`
	TimerCoderId         string          `protobuf:"bytes,2,opt,name=timer_coder_id,json=timerCoderId,proto3" json:"timer_coder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *TimerSpec) Reset()         { *m = TimerSpec{} }
func (m *TimerSpec) String() string { return proto.CompactTextString(m) }
func (*TimerSpec) ProtoMessage()    {}
func (*TimerSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{15}
}

func (m *TimerSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimerSpec.Unmarshal(m, b)
}
func (m *TimerSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimerSpec.Marshal(b, m, deterministic)
}
func (m *TimerSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimerSpec.Merge(m, src)
}
func (m *TimerSpec) XXX_Size() int {
	return xxx_messageInfo_TimerSpec.Size(m)
}
func (m *TimerSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_TimerSpec.DiscardUnknown(m)
}

var xxx_messageInfo_TimerSpec proto.InternalMessageInfo

func (m *TimerSpec) GetTimeDomain() TimeDomain_Enum {
	if m != nil {
		return m.TimeDomain
	}
	return TimeDomain_UNSPECIFIED
}

func (m *TimerSpec) GetTimerCoderId() string {
	if m != nil {
		return m.TimerCoderId
	}
	return ""
}

type IsBounded struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IsBounded) Reset()         { *m = IsBounded{} }
func (m *IsBounded) String() string { return proto.CompactTextString(m) }
func (*IsBounded) ProtoMessage()    {}
func (*IsBounded) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{16}
}

func (m *IsBounded) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IsBounded.Unmarshal(m, b)
}
func (m *IsBounded) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IsBounded.Marshal(b, m, deterministic)
}
func (m *IsBounded) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IsBounded.Merge(m, src)
}
func (m *IsBounded) XXX_Size() int {
	return xxx_messageInfo_IsBounded.Size(m)
}
func (m *IsBounded) XXX_DiscardUnknown() {
	xxx_messageInfo_IsBounded.DiscardUnknown(m)
}

var xxx_messageInfo_IsBounded proto.InternalMessageInfo

// The payload for the primitive Read transform.
type ReadPayload struct {
	// (Required) The FunctionSpec of the source for this Read.
	Source *FunctionSpec `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// (Required) Whether the source is bounded or unbounded
	IsBounded            IsBounded_Enum `protobuf:"varint,2,opt,name=is_bounded,json=isBounded,proto3,enum=org.apache.beam.model.pipeline.v1.IsBounded_Enum" json:"is_bounded,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ReadPayload) Reset()         { *m = ReadPayload{} }
func (m *ReadPayload) String() string { return proto.CompactTextString(m) }
func (*ReadPayload) ProtoMessage()    {}
func (*ReadPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{17}
}

func (m *ReadPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadPayload.Unmarshal(m, b)
}
func (m *ReadPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadPayload.Marshal(b, m, deterministic)
}
func (m *ReadPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadPayload.Merge(m, src)
}
func (m *ReadPayload) XXX_Size() int {
	return xxx_messageInfo_ReadPayload.Size(m)
}
func (m *ReadPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadPayload.DiscardUnknown(m)
}

var xxx_messageInfo_ReadPayload proto.InternalMessageInfo

func (m *ReadPayload) GetSource() *FunctionSpec {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *ReadPayload) GetIsBounded() IsBounded_Enum {
	if m != nil {
		return m.IsBounded
	}
	return IsBounded_UNSPECIFIED
}

// The payload for the WindowInto transform.
type WindowIntoPayload struct {
	// (Required) The FunctionSpec of the WindowFn.
	WindowFn             *FunctionSpec `protobuf:"bytes,1,opt,name=window_fn,json=windowFn,proto3" json:"window_fn,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *WindowIntoPayload) Reset()         { *m = WindowIntoPayload{} }
func (m *WindowIntoPayload) String() string { return proto.CompactTextString(m) }
func (*WindowIntoPayload) ProtoMessage()    {}
func (*WindowIntoPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{18}
}

func (m *WindowIntoPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WindowIntoPayload.Unmarshal(m, b)
}
func (m *WindowIntoPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WindowIntoPayload.Marshal(b, m, deterministic)
}
func (m *WindowIntoPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowIntoPayload.Merge(m, src)
}
func (m *WindowIntoPayload) XXX_Size() int {
	return xxx_messageInfo_WindowIntoPayload.Size(m)
}
func (m *WindowIntoPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowIntoPayload.DiscardUnknown(m)
}

var xxx_messageInfo_WindowIntoPayload proto.InternalMessageInfo

func (m *WindowIntoPayload) GetWindowFn() *FunctionSpec {
	if m != nil {
		return m.WindowFn
	}
	return nil
}

// The payload for the special-but-not-primitive Combine transform.
type CombinePayload struct {
	// (Required) The FunctionSpec of the CombineFn.
	CombineFn *FunctionSpec `protobuf:"bytes,1,opt,name=combine_fn,json=combineFn,proto3" json:"combine_fn,omitempty"`
	// (Required) A reference to the Coder to use for accumulators of the CombineFn
	AccumulatorCoderId   string   `protobuf:"bytes,2,opt,name=accumulator_coder_id,json=accumulatorCoderId,proto3" json:"accumulator_coder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CombinePayload) Reset()         { *m = CombinePayload{} }
func (m *CombinePayload) String() string { return proto.CompactTextString(m) }
func (*CombinePayload) ProtoMessage()    {}
func (*CombinePayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{19}
}

func (m *CombinePayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CombinePayload.Unmarshal(m, b)
}
func (m *CombinePayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CombinePayload.Marshal(b, m, deterministic)
}
func (m *CombinePayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CombinePayload.Merge(m, src)
}
func (m *CombinePayload) XXX_Size() int {
	return xxx_messageInfo_CombinePayload.Size(m)
}
func (m *CombinePayload) XXX_DiscardUnknown() {
	xxx_messageInfo_CombinePayload.DiscardUnknown(m)
}

var xxx_messageInfo_CombinePayload proto.InternalMessageInfo

func (m *CombinePayload) GetCombineFn() *FunctionSpec {
	if m != nil {
		return m.CombineFn
	}
	return nil
}

func (m *CombinePayload) GetAccumulatorCoderId() string {
	if m != nil {
		return m.AccumulatorCoderId
	}
	return ""
}

// The payload for the test-only primitive TestStream
type TestStreamPayload struct {
	// (Required) the coder for elements in the TestStream events
	CoderId string `protobuf:"bytes,1,opt,name=coder_id,json=coderId,proto3" json:"coder_id,omitempty"`
	// (Optional) If specified, the TestStream will replay these events.
	Events []*TestStreamPayload_Event `protobuf:"bytes,2,rep,name=events,proto3" json:"events,omitempty"`
	// (Optional) If specified, points to a TestStreamService to be
	// used to retrieve events.
	Endpoint             *ApiServiceDescriptor `protobuf:"bytes,3,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *TestStreamPayload) Reset()         { *m = TestStreamPayload{} }
func (m *TestStreamPayload) String() string { return proto.CompactTextString(m) }
func (*TestStreamPayload) ProtoMessage()    {}
func (*TestStreamPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{20}
}

func (m *TestStreamPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestStreamPayload.Unmarshal(m, b)
}
func (m *TestStreamPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestStreamPayload.Marshal(b, m, deterministic)
}
func (m *TestStreamPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestStreamPayload.Merge(m, src)
}
func (m *TestStreamPayload) XXX_Size() int {
	return xxx_messageInfo_TestStreamPayload.Size(m)
}
func (m *TestStreamPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_TestStreamPayload.DiscardUnknown(m)
}

var xxx_messageInfo_TestStreamPayload proto.InternalMessageInfo

func (m *TestStreamPayload) GetCoderId() string {
	if m != nil {
		return m.CoderId
	}
	return ""
}

func (m *TestStreamPayload) GetEvents() []*TestStreamPayload_Event {
	if m != nil {
		return m.Events
	}
	return nil
}

func (m *TestStreamPayload) GetEndpoint() *ApiServiceDescriptor {
	if m != nil {
		return m.Endpoint
	}
	return nil
}

type TestStreamPayload_Event struct {
	// Types that are valid to be assigned to Event:
	//	*TestStreamPayload_Event_WatermarkEvent
	//	*TestStreamPayload_Event_ProcessingTimeEvent
	//	*TestStreamPayload_Event_ElementEvent
	Event                isTestStreamPayload_Event_Event `protobuf_oneof:"event"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *TestStreamPayload_Event) Reset()         { *m = TestStreamPayload_Event{} }
func (m *TestStreamPayload_Event) String() string { return proto.CompactTextString(m) }
func (*TestStreamPayload_Event) ProtoMessage()    {}
func (*TestStreamPayload_Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{20, 0}
}

func (m *TestStreamPayload_Event) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestStreamPayload_Event.Unmarshal(m, b)
}
func (m *TestStreamPayload_Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestStreamPayload_Event.Marshal(b, m, deterministic)
}
func (m *TestStreamPayload_Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestStreamPayload_Event.Merge(m, src)
}
func (m *TestStreamPayload_Event) XXX_Size() int {
	return xxx_messageInfo_TestStreamPayload_Event.Size(m)
}
func (m *TestStreamPayload_Event) XXX_DiscardUnknown() {
	xxx_messageInfo_TestStreamPayload_Event.DiscardUnknown(m)
}

var xxx_messageInfo_TestStreamPayload_Event proto.InternalMessageInfo

type isTestStreamPayload_Event_Event interface {
	isTestStreamPayload_Event_Event()
}

type TestStreamPayload_Event_WatermarkEvent struct {
	WatermarkEvent *TestStreamPayload_Event_AdvanceWatermark `protobuf:"bytes,1,opt,name=watermark_event,json=watermarkEvent,proto3,oneof"`
}

type TestStreamPayload_Event_ProcessingTimeEvent struct {
	ProcessingTimeEvent *TestStreamPayload_Event_AdvanceProcessingTime `protobuf:"bytes,2,opt,name=processing_time_event,json=processingTimeEvent,proto3,oneof"`
}

type TestStreamPayload_Event_ElementEvent struct {
	ElementEvent *TestStreamPayload_Event_AddElements `protobuf:"bytes,3,opt,name=element_event,json=elementEvent,proto3,oneof"`
}

func (*TestStreamPayload_Event_WatermarkEvent) isTestStreamPayload_Event_Event() {}

func (*TestStreamPayload_Event_ProcessingTimeEvent) isTestStreamPayload_Event_Event() {}

func (*TestStreamPayload_Event_ElementEvent) isTestStreamPayload_Event_Event() {}

func (m *TestStreamPayload_Event) GetEvent() isTestStreamPayload_Event_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (m *TestStreamPayload_Event) GetWatermarkEvent() *TestStreamPayload_Event_AdvanceWatermark {
	if x, ok := m.GetEvent().(*TestStreamPayload_Event_WatermarkEvent); ok {
		return x.WatermarkEvent
	}
	return nil
}

func (m *TestStreamPayload_Event) GetProcessingTimeEvent() *TestStreamPayload_Event_AdvanceProcessingTime {
	if x, ok := m.GetEvent().(*TestStreamPayload_Event_ProcessingTimeEvent); ok {
		return x.ProcessingTimeEvent
	}
	return nil
}

func (m *TestStreamPayload_Event) GetElementEvent() *TestStreamPayload_Event_AddElements {
	if x, ok := m.GetEvent().(*TestStreamPayload_Event_ElementEvent); ok {
		return x.ElementEvent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*TestStreamPayload_Event) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*TestStreamPayload_Event_WatermarkEvent)(nil),
		(*TestStreamPayload_Event_ProcessingTimeEvent)(nil),
		(*TestStreamPayload_Event_ElementEvent)(nil),
	}
}

// Advances the watermark to the specified timestamp.
type TestStreamPayload_Event_AdvanceWatermark struct {
	// (Required) The watermark to advance to.
	NewWatermark int64 `protobuf:"varint,1,opt,name=new_watermark,json=newWatermark,proto3" json:"new_watermark,omitempty"`
	// (Optional) The output watermark tag for a PCollection. If unspecified
	// or with an empty string, this will default to the Main PCollection
	// Output
	Tag                  string   `protobuf:"bytes,2,opt,name=tag,proto3" json:"tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestStreamPayload_Event_AdvanceWatermark) Reset() {
	*m = TestStreamPayload_Event_AdvanceWatermark{}
}
func (m *TestStreamPayload_Event_AdvanceWatermark) String() string { return proto.CompactTextString(m) }
func (*TestStreamPayload_Event_AdvanceWatermark) ProtoMessage()    {}
func (*TestStreamPayload_Event_AdvanceWatermark) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{20, 0, 0}
}

func (m *TestStreamPayload_Event_AdvanceWatermark) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestStreamPayload_Event_AdvanceWatermark.Unmarshal(m, b)
}
func (m *TestStreamPayload_Event_AdvanceWatermark) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestStreamPayload_Event_AdvanceWatermark.Marshal(b, m, deterministic)
}
func (m *TestStreamPayload_Event_AdvanceWatermark) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestStreamPayload_Event_AdvanceWatermark.Merge(m, src)
}
func (m *TestStreamPayload_Event_AdvanceWatermark) XXX_Size() int {
	return xxx_messageInfo_TestStreamPayload_Event_AdvanceWatermark.Size(m)
}
func (m *TestStreamPayload_Event_AdvanceWatermark) XXX_DiscardUnknown() {
	xxx_messageInfo_TestStreamPayload_Event_AdvanceWatermark.DiscardUnknown(m)
}

var xxx_messageInfo_TestStreamPayload_Event_AdvanceWatermark proto.InternalMessageInfo

func (m *TestStreamPayload_Event_AdvanceWatermark) GetNewWatermark() int64 {
	if m != nil {
		return m.NewWatermark
	}
	return 0
}

func (m *TestStreamPayload_Event_AdvanceWatermark) GetTag() string {
	if m != nil {
		return m.Tag
	}
	return ""
}

// Advances the processing time clock by the specified amount.
type TestStreamPayload_Event_AdvanceProcessingTime struct {
	// (Required) The duration to advance by.
	AdvanceDuration      int64    `protobuf:"varint,1,opt,name=advance_duration,json=advanceDuration,proto3" json:"advance_duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestStreamPayload_Event_AdvanceProcessingTime) Reset() {
	*m = TestStreamPayload_Event_AdvanceProcessingTime{}
}
func (m *TestStreamPayload_Event_AdvanceProcessingTime) String() string {
	return proto.CompactTextString(m)
}
func (*TestStreamPayload_Event_AdvanceProcessingTime) ProtoMessage() {}
func (*TestStreamPayload_Event_AdvanceProcessingTime) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{20, 0, 1}
}

func (m *TestStreamPayload_Event_AdvanceProcessingTime) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestStreamPayload_Event_AdvanceProcessingTime.Unmarshal(m, b)
}
func (m *TestStreamPayload_Event_AdvanceProcessingTime) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestStreamPayload_Event_AdvanceProcessingTime.Marshal(b, m, deterministic)
}
func (m *TestStreamPayload_Event_AdvanceProcessingTime) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestStreamPayload_Event_AdvanceProcessingTime.Merge(m, src)
}
func (m *TestStreamPayload_Event_AdvanceProcessingTime) XXX_Size() int {
	return xxx_messageInfo_TestStreamPayload_Event_AdvanceProcessingTime.Size(m)
}
func (m *TestStreamPayload_Event_AdvanceProcessingTime) XXX_DiscardUnknown() {
	xxx_messageInfo_TestStreamPayload_Event_AdvanceProcessingTime.DiscardUnknown(m)
}

var xxx_messageInfo_TestStreamPayload_Event_AdvanceProcessingTime proto.InternalMessageInfo

func (m *TestStreamPayload_Event_AdvanceProcessingTime) GetAdvanceDuration() int64 {
	if m != nil {
		return m.AdvanceDuration
	}
	return 0
}

// Adds elements to the stream to be emitted.
type TestStreamPayload_Event_AddElements struct {
	// (Required) The elements to add to the TestStream.
	Elements []*TestStreamPayload_TimestampedElement `protobuf:"bytes,1,rep,name=elements,proto3" json:"elements,omitempty"`
	// (Optional) The output PCollection tag to add these elements to. If
	// unspecified or with an empty string, this will default to the Main
	// PCollection Output.
	Tag                  string   `protobuf:"bytes,3,opt,name=tag,proto3" json:"tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestStreamPayload_Event_AddElements) Reset()         { *m = TestStreamPayload_Event_AddElements{} }
func (m *TestStreamPayload_Event_AddElements) String() string { return proto.CompactTextString(m) }
func (*TestStreamPayload_Event_AddElements) ProtoMessage()    {}
func (*TestStreamPayload_Event_AddElements) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{20, 0, 2}
}

func (m *TestStreamPayload_Event_AddElements) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestStreamPayload_Event_AddElements.Unmarshal(m, b)
}
func (m *TestStreamPayload_Event_AddElements) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestStreamPayload_Event_AddElements.Marshal(b, m, deterministic)
}
func (m *TestStreamPayload_Event_AddElements) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestStreamPayload_Event_AddElements.Merge(m, src)
}
func (m *TestStreamPayload_Event_AddElements) XXX_Size() int {
	return xxx_messageInfo_TestStreamPayload_Event_AddElements.Size(m)
}
func (m *TestStreamPayload_Event_AddElements) XXX_DiscardUnknown() {
	xxx_messageInfo_TestStreamPayload_Event_AddElements.DiscardUnknown(m)
}

var xxx_messageInfo_TestStreamPayload_Event_AddElements proto.InternalMessageInfo

func (m *TestStreamPayload_Event_AddElements) GetElements() []*TestStreamPayload_TimestampedElement {
	if m != nil {
		return m.Elements
	}
	return nil
}

func (m *TestStreamPayload_Event_AddElements) GetTag() string {
	if m != nil {
		return m.Tag
	}
	return ""
}

// A single element inside of the TestStream.
type TestStreamPayload_TimestampedElement struct {
	// (Required) The element encoded. Currently the TestStream only supports
	// encoding primitives.
	EncodedElement []byte `protobuf:"bytes,1,opt,name=encoded_element,json=encodedElement,proto3" json:"encoded_element,omitempty"`
	// (Required) The event timestamp of this element.
	Timestamp            int64    `protobuf:"varint,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestStreamPayload_TimestampedElement) Reset()         { *m = TestStreamPayload_TimestampedElement{} }
func (m *TestStreamPayload_TimestampedElement) String() string { return proto.CompactTextString(m) }
func (*TestStreamPayload_TimestampedElement) ProtoMessage()    {}
func (*TestStreamPayload_TimestampedElement) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{20, 1}
}

func (m *TestStreamPayload_TimestampedElement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TestStreamPayload_TimestampedElement.Unmarshal(m, b)
}
func (m *TestStreamPayload_TimestampedElement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TestStreamPayload_TimestampedElement.Marshal(b, m, deterministic)
}
func (m *TestStreamPayload_TimestampedElement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestStreamPayload_TimestampedElement.Merge(m, src)
}
func (m *TestStreamPayload_TimestampedElement) XXX_Size() int {
	return xxx_messageInfo_TestStreamPayload_TimestampedElement.Size(m)
}
func (m *TestStreamPayload_TimestampedElement) XXX_DiscardUnknown() {
	xxx_messageInfo_TestStreamPayload_TimestampedElement.DiscardUnknown(m)
}

var xxx_messageInfo_TestStreamPayload_TimestampedElement proto.InternalMessageInfo

func (m *TestStreamPayload_TimestampedElement) GetEncodedElement() []byte {
	if m != nil {
		return m.EncodedElement
	}
	return nil
}

func (m *TestStreamPayload_TimestampedElement) GetTimestamp() int64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

type EventsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventsRequest) Reset()         { *m = EventsRequest{} }
func (m *EventsRequest) String() string { return proto.CompactTextString(m) }
func (*EventsRequest) ProtoMessage()    {}
func (*EventsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{21}
}

func (m *EventsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventsRequest.Unmarshal(m, b)
}
func (m *EventsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventsRequest.Marshal(b, m, deterministic)
}
func (m *EventsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventsRequest.Merge(m, src)
}
func (m *EventsRequest) XXX_Size() int {
	return xxx_messageInfo_EventsRequest.Size(m)
}
func (m *EventsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_EventsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_EventsRequest proto.InternalMessageInfo

// The payload for the special-but-not-primitive WriteFiles transform.
type WriteFilesPayload struct {
	// (Required) The FunctionSpec of the FileBasedSink.
	Sink *FunctionSpec `protobuf:"bytes,1,opt,name=sink,proto3" json:"sink,omitempty"`
	// (Required) The format function.
	FormatFunction           *FunctionSpec         `protobuf:"bytes,2,opt,name=format_function,json=formatFunction,proto3" json:"format_function,omitempty"`
	WindowedWrites           bool                  `protobuf:"varint,3,opt,name=windowed_writes,json=windowedWrites,proto3" json:"windowed_writes,omitempty"`
	RunnerDeterminedSharding bool                  `protobuf:"varint,4,opt,name=runner_determined_sharding,json=runnerDeterminedSharding,proto3" json:"runner_determined_sharding,omitempty"`
	SideInputs               map[string]*SideInput `protobuf:"bytes,5,rep,name=side_inputs,json=sideInputs,proto3" json:"side_inputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral     struct{}              `json:"-"`
	XXX_unrecognized         []byte                `json:"-"`
	XXX_sizecache            int32                 `json:"-"`
}

func (m *WriteFilesPayload) Reset()         { *m = WriteFilesPayload{} }
func (m *WriteFilesPayload) String() string { return proto.CompactTextString(m) }
func (*WriteFilesPayload) ProtoMessage()    {}
func (*WriteFilesPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{22}
}

func (m *WriteFilesPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WriteFilesPayload.Unmarshal(m, b)
}
func (m *WriteFilesPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WriteFilesPayload.Marshal(b, m, deterministic)
}
func (m *WriteFilesPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WriteFilesPayload.Merge(m, src)
}
func (m *WriteFilesPayload) XXX_Size() int {
	return xxx_messageInfo_WriteFilesPayload.Size(m)
}
func (m *WriteFilesPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_WriteFilesPayload.DiscardUnknown(m)
}

var xxx_messageInfo_WriteFilesPayload proto.InternalMessageInfo

func (m *WriteFilesPayload) GetSink() *FunctionSpec {
	if m != nil {
		return m.Sink
	}
	return nil
}

func (m *WriteFilesPayload) GetFormatFunction() *FunctionSpec {
	if m != nil {
		return m.FormatFunction
	}
	return nil
}

func (m *WriteFilesPayload) GetWindowedWrites() bool {
	if m != nil {
		return m.WindowedWrites
	}
	return false
}

func (m *WriteFilesPayload) GetRunnerDeterminedSharding() bool {
	if m != nil {
		return m.RunnerDeterminedSharding
	}
	return false
}

func (m *WriteFilesPayload) GetSideInputs() map[string]*SideInput {
	if m != nil {
		return m.SideInputs
	}
	return nil
}

// A coder, the binary format for serialization and deserialization of data in
// a pipeline.
type Coder struct {
	// (Required) A specification for the coder, as a URN plus parameters. This
	// may be a cross-language agreed-upon format, or it may be a "custom coder"
	// that can only be used by a particular SDK. It does not include component
	// coders, as it is beneficial for these to be comprehensible to a runner
	// regardless of whether the binary format is agreed-upon.
	Spec *FunctionSpec `protobuf:"bytes,1,opt,name=spec,proto3" json:"spec,omitempty"`
	// (Optional) If this coder is parametric, such as ListCoder(VarIntCoder),
	// this is a list of the components. In order for encodings to be identical,
	// the FunctionSpec and all components must be identical, recursively.
	ComponentCoderIds    []string `protobuf:"bytes,2,rep,name=component_coder_ids,json=componentCoderIds,proto3" json:"component_coder_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Coder) Reset()         { *m = Coder{} }
func (m *Coder) String() string { return proto.CompactTextString(m) }
func (*Coder) ProtoMessage()    {}
func (*Coder) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{23}
}

func (m *Coder) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Coder.Unmarshal(m, b)
}
func (m *Coder) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Coder.Marshal(b, m, deterministic)
}
func (m *Coder) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Coder.Merge(m, src)
}
func (m *Coder) XXX_Size() int {
	return xxx_messageInfo_Coder.Size(m)
}
func (m *Coder) XXX_DiscardUnknown() {
	xxx_messageInfo_Coder.DiscardUnknown(m)
}

var xxx_messageInfo_Coder proto.InternalMessageInfo

func (m *Coder) GetSpec() *FunctionSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *Coder) GetComponentCoderIds() []string {
	if m != nil {
		return m.ComponentCoderIds
	}
	return nil
}

type StandardCoders struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StandardCoders) Reset()         { *m = StandardCoders{} }
func (m *StandardCoders) String() string { return proto.CompactTextString(m) }
func (*StandardCoders) ProtoMessage()    {}
func (*StandardCoders) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{24}
}

func (m *StandardCoders) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StandardCoders.Unmarshal(m, b)
}
func (m *StandardCoders) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StandardCoders.Marshal(b, m, deterministic)
}
func (m *StandardCoders) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StandardCoders.Merge(m, src)
}
func (m *StandardCoders) XXX_Size() int {
	return xxx_messageInfo_StandardCoders.Size(m)
}
func (m *StandardCoders) XXX_DiscardUnknown() {
	xxx_messageInfo_StandardCoders.DiscardUnknown(m)
}

var xxx_messageInfo_StandardCoders proto.InternalMessageInfo

// A windowing strategy describes the window function, triggering, allowed
// lateness, and accumulation mode for a PCollection.
//
// TODO: consider inlining field on PCollection
type WindowingStrategy struct {
	// (Required) The FunctionSpec of the UDF that assigns windows,
	// merges windows, and shifts timestamps before they are
	// combined according to the OutputTime.
	WindowFn *FunctionSpec `protobuf:"bytes,1,opt,name=window_fn,json=windowFn,proto3" json:"window_fn,omitempty"`
	// (Required) Whether or not the window fn is merging.
	//
	// This knowledge is required for many optimizations.
	MergeStatus MergeStatus_Enum `protobuf:"varint,2,opt,name=merge_status,json=mergeStatus,proto3,enum=org.apache.beam.model.pipeline.v1.MergeStatus_Enum" json:"merge_status,omitempty"`
	// (Required) The coder for the windows of this PCollection.
	WindowCoderId string `protobuf:"bytes,3,opt,name=window_coder_id,json=windowCoderId,proto3" json:"window_coder_id,omitempty"`
	// (Required) The trigger to use when grouping this PCollection.
	Trigger *Trigger `protobuf:"bytes,4,opt,name=trigger,proto3" json:"trigger,omitempty"`
	// (Required) The accumulation mode indicates whether new panes are a full
	// replacement for prior panes or whether they are deltas to be combined
	// with other panes (the combine should correspond to whatever the upstream
	// grouping transform is).
	AccumulationMode AccumulationMode_Enum `protobuf:"varint,5,opt,name=accumulation_mode,json=accumulationMode,proto3,enum=org.apache.beam.model.pipeline.v1.AccumulationMode_Enum" json:"accumulation_mode,omitempty"`
	// (Required) The OutputTime specifies, for a grouping transform, how to
	// compute the aggregate timestamp. The window_fn will first possibly shift
	// it later, then the OutputTime takes the max, min, or ignores it and takes
	// the end of window.
	//
	// This is actually only for input to grouping transforms, but since they
	// may be introduced in runner-specific ways, it is carried along with the
	// windowing strategy.
	OutputTime OutputTime_Enum `protobuf:"varint,6,opt,name=output_time,json=outputTime,proto3,enum=org.apache.beam.model.pipeline.v1.OutputTime_Enum" json:"output_time,omitempty"`
	// (Required) Indicate when output should be omitted upon window expiration.
	ClosingBehavior ClosingBehavior_Enum `protobuf:"varint,7,opt,name=closing_behavior,json=closingBehavior,proto3,enum=org.apache.beam.model.pipeline.v1.ClosingBehavior_Enum" json:"closing_behavior,omitempty"`
	// (Required) The duration, in milliseconds, beyond the end of a window at
	// which the window becomes droppable.
	AllowedLateness int64 `protobuf:"varint,8,opt,name=allowed_lateness,json=allowedLateness,proto3" json:"allowed_lateness,omitempty"`
	// (Required) Indicate whether empty on-time panes should be omitted.
	OnTimeBehavior OnTimeBehavior_Enum `protobuf:"varint,9,opt,name=OnTimeBehavior,proto3,enum=org.apache.beam.model.pipeline.v1.OnTimeBehavior_Enum" json:"OnTimeBehavior,omitempty"`
	// (Required) Whether or not the window fn assigns inputs to exactly one window
	//
	// This knowledge is required for some optimizations
	AssignsToOneWindow bool `protobuf:"varint,10,opt,name=assigns_to_one_window,json=assignsToOneWindow,proto3" json:"assigns_to_one_window,omitempty"`
	// (Optional) Environment where the current window_fn should be applied in.
	// Runner that executes the pipeline may choose to override this if needed.
	// If not specified, environment will be decided by the runner.
	EnvironmentId        string   `protobuf:"bytes,11,opt,name=environment_id,json=environmentId,proto3" json:"environment_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WindowingStrategy) Reset()         { *m = WindowingStrategy{} }
func (m *WindowingStrategy) String() string { return proto.CompactTextString(m) }
func (*WindowingStrategy) ProtoMessage()    {}
func (*WindowingStrategy) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{25}
}

func (m *WindowingStrategy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WindowingStrategy.Unmarshal(m, b)
}
func (m *WindowingStrategy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WindowingStrategy.Marshal(b, m, deterministic)
}
func (m *WindowingStrategy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WindowingStrategy.Merge(m, src)
}
func (m *WindowingStrategy) XXX_Size() int {
	return xxx_messageInfo_WindowingStrategy.Size(m)
}
func (m *WindowingStrategy) XXX_DiscardUnknown() {
	xxx_messageInfo_WindowingStrategy.DiscardUnknown(m)
}

var xxx_messageInfo_WindowingStrategy proto.InternalMessageInfo

func (m *WindowingStrategy) GetWindowFn() *FunctionSpec {
	if m != nil {
		return m.WindowFn
	}
	return nil
}

func (m *WindowingStrategy) GetMergeStatus() MergeStatus_Enum {
	if m != nil {
		return m.MergeStatus
	}
	return MergeStatus_UNSPECIFIED
}

func (m *WindowingStrategy) GetWindowCoderId() string {
	if m != nil {
		return m.WindowCoderId
	}
	return ""
}

func (m *WindowingStrategy) GetTrigger() *Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

func (m *WindowingStrategy) GetAccumulationMode() AccumulationMode_Enum {
	if m != nil {
		return m.AccumulationMode
	}
	return AccumulationMode_UNSPECIFIED
}

func (m *WindowingStrategy) GetOutputTime() OutputTime_Enum {
	if m != nil {
		return m.OutputTime
	}
	return OutputTime_UNSPECIFIED
}

func (m *WindowingStrategy) GetClosingBehavior() ClosingBehavior_Enum {
	if m != nil {
		return m.ClosingBehavior
	}
	return ClosingBehavior_UNSPECIFIED
}

func (m *WindowingStrategy) GetAllowedLateness() int64 {
	if m != nil {
		return m.AllowedLateness
	}
	return 0
}

func (m *WindowingStrategy) GetOnTimeBehavior() OnTimeBehavior_Enum {
	if m != nil {
		return m.OnTimeBehavior
	}
	return OnTimeBehavior_UNSPECIFIED
}

func (m *WindowingStrategy) GetAssignsToOneWindow() bool {
	if m != nil {
		return m.AssignsToOneWindow
	}
	return false
}

func (m *WindowingStrategy) GetEnvironmentId() string {
	if m != nil {
		return m.EnvironmentId
	}
	return ""
}

// Whether or not a PCollection's WindowFn is non-merging, merging, or
// merging-but-already-merged, in which case a subsequent GroupByKey is almost
// always going to do something the user does not want
type MergeStatus struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MergeStatus) Reset()         { *m = MergeStatus{} }
func (m *MergeStatus) String() string { return proto.CompactTextString(m) }
func (*MergeStatus) ProtoMessage()    {}
func (*MergeStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{26}
}

func (m *MergeStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MergeStatus.Unmarshal(m, b)
}
func (m *MergeStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MergeStatus.Marshal(b, m, deterministic)
}
func (m *MergeStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeStatus.Merge(m, src)
}
func (m *MergeStatus) XXX_Size() int {
	return xxx_messageInfo_MergeStatus.Size(m)
}
func (m *MergeStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeStatus.DiscardUnknown(m)
}

var xxx_messageInfo_MergeStatus proto.InternalMessageInfo

// Whether or not subsequent outputs of aggregations should be entire
// replacement values or just the aggregation of inputs received since
// the prior output.
type AccumulationMode struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AccumulationMode) Reset()         { *m = AccumulationMode{} }
func (m *AccumulationMode) String() string { return proto.CompactTextString(m) }
func (*AccumulationMode) ProtoMessage()    {}
func (*AccumulationMode) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{27}
}

func (m *AccumulationMode) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AccumulationMode.Unmarshal(m, b)
}
func (m *AccumulationMode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AccumulationMode.Marshal(b, m, deterministic)
}
func (m *AccumulationMode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AccumulationMode.Merge(m, src)
}
func (m *AccumulationMode) XXX_Size() int {
	return xxx_messageInfo_AccumulationMode.Size(m)
}
func (m *AccumulationMode) XXX_DiscardUnknown() {
	xxx_messageInfo_AccumulationMode.DiscardUnknown(m)
}

var xxx_messageInfo_AccumulationMode proto.InternalMessageInfo

// Controls whether or not an aggregating transform should output data
// when a window expires.
type ClosingBehavior struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClosingBehavior) Reset()         { *m = ClosingBehavior{} }
func (m *ClosingBehavior) String() string { return proto.CompactTextString(m) }
func (*ClosingBehavior) ProtoMessage()    {}
func (*ClosingBehavior) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{28}
}

func (m *ClosingBehavior) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ClosingBehavior.Unmarshal(m, b)
}
func (m *ClosingBehavior) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ClosingBehavior.Marshal(b, m, deterministic)
}
func (m *ClosingBehavior) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClosingBehavior.Merge(m, src)
}
func (m *ClosingBehavior) XXX_Size() int {
	return xxx_messageInfo_ClosingBehavior.Size(m)
}
func (m *ClosingBehavior) XXX_DiscardUnknown() {
	xxx_messageInfo_ClosingBehavior.DiscardUnknown(m)
}

var xxx_messageInfo_ClosingBehavior proto.InternalMessageInfo

// Controls whether or not an aggregating transform should output data
// when an on-time pane is empty.
type OnTimeBehavior struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OnTimeBehavior) Reset()         { *m = OnTimeBehavior{} }
func (m *OnTimeBehavior) String() string { return proto.CompactTextString(m) }
func (*OnTimeBehavior) ProtoMessage()    {}
func (*OnTimeBehavior) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{29}
}

func (m *OnTimeBehavior) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OnTimeBehavior.Unmarshal(m, b)
}
func (m *OnTimeBehavior) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OnTimeBehavior.Marshal(b, m, deterministic)
}
func (m *OnTimeBehavior) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OnTimeBehavior.Merge(m, src)
}
func (m *OnTimeBehavior) XXX_Size() int {
	return xxx_messageInfo_OnTimeBehavior.Size(m)
}
func (m *OnTimeBehavior) XXX_DiscardUnknown() {
	xxx_messageInfo_OnTimeBehavior.DiscardUnknown(m)
}

var xxx_messageInfo_OnTimeBehavior proto.InternalMessageInfo

// When a number of windowed, timestamped inputs are aggregated, the timestamp
// for the resulting output.
type OutputTime struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OutputTime) Reset()         { *m = OutputTime{} }
func (m *OutputTime) String() string { return proto.CompactTextString(m) }
func (*OutputTime) ProtoMessage()    {}
func (*OutputTime) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{30}
}

func (m *OutputTime) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OutputTime.Unmarshal(m, b)
}
func (m *OutputTime) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OutputTime.Marshal(b, m, deterministic)
}
func (m *OutputTime) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutputTime.Merge(m, src)
}
func (m *OutputTime) XXX_Size() int {
	return xxx_messageInfo_OutputTime.Size(m)
}
func (m *OutputTime) XXX_DiscardUnknown() {
	xxx_messageInfo_OutputTime.DiscardUnknown(m)
}

var xxx_messageInfo_OutputTime proto.InternalMessageInfo

// The different time domains in the Beam model.
type TimeDomain struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TimeDomain) Reset()         { *m = TimeDomain{} }
func (m *TimeDomain) String() string { return proto.CompactTextString(m) }
func (*TimeDomain) ProtoMessage()    {}
func (*TimeDomain) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{31}
}

func (m *TimeDomain) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimeDomain.Unmarshal(m, b)
}
func (m *TimeDomain) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimeDomain.Marshal(b, m, deterministic)
}
func (m *TimeDomain) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeDomain.Merge(m, src)
}
func (m *TimeDomain) XXX_Size() int {
	return xxx_messageInfo_TimeDomain.Size(m)
}
func (m *TimeDomain) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeDomain.DiscardUnknown(m)
}

var xxx_messageInfo_TimeDomain proto.InternalMessageInfo

// A small DSL for expressing when to emit new aggregations
// from a GroupByKey or CombinePerKey
//
// A trigger is described in terms of when it is _ready_ to permit output.
type Trigger struct {
	// The full disjoint union of possible triggers.
	//
	// Types that are valid to be assigned to Trigger:
	//	*Trigger_AfterAll_
	//	*Trigger_AfterAny_
	//	*Trigger_AfterEach_
	//	*Trigger_AfterEndOfWindow_
	//	*Trigger_AfterProcessingTime_
	//	*Trigger_AfterSynchronizedProcessingTime_
	//	*Trigger_Always_
	//	*Trigger_Default_
	//	*Trigger_ElementCount_
	//	*Trigger_Never_
	//	*Trigger_OrFinally_
	//	*Trigger_Repeat_
	Trigger              isTrigger_Trigger `protobuf_oneof:"trigger"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Trigger) Reset()         { *m = Trigger{} }
func (m *Trigger) String() string { return proto.CompactTextString(m) }
func (*Trigger) ProtoMessage()    {}
func (*Trigger) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{32}
}

func (m *Trigger) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger.Unmarshal(m, b)
}
func (m *Trigger) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger.Marshal(b, m, deterministic)
}
func (m *Trigger) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger.Merge(m, src)
}
func (m *Trigger) XXX_Size() int {
	return xxx_messageInfo_Trigger.Size(m)
}
func (m *Trigger) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger proto.InternalMessageInfo

type isTrigger_Trigger interface {
	isTrigger_Trigger()
}

type Trigger_AfterAll_ struct {
	AfterAll *Trigger_AfterAll `protobuf:"bytes,1,opt,name=after_all,json=afterAll,proto3,oneof"`
}

type Trigger_AfterAny_ struct {
	AfterAny *Trigger_AfterAny `protobuf:"bytes,2,opt,name=after_any,json=afterAny,proto3,oneof"`
}

type Trigger_AfterEach_ struct {
	AfterEach *Trigger_AfterEach `protobuf:"bytes,3,opt,name=after_each,json=afterEach,proto3,oneof"`
}

type Trigger_AfterEndOfWindow_ struct {
	AfterEndOfWindow *Trigger_AfterEndOfWindow `protobuf:"bytes,4,opt,name=after_end_of_window,json=afterEndOfWindow,proto3,oneof"`
}

type Trigger_AfterProcessingTime_ struct {
	AfterProcessingTime *Trigger_AfterProcessingTime `protobuf:"bytes,5,opt,name=after_processing_time,json=afterProcessingTime,proto3,oneof"`
}

type Trigger_AfterSynchronizedProcessingTime_ struct {
	AfterSynchronizedProcessingTime *Trigger_AfterSynchronizedProcessingTime `protobuf:"bytes,6,opt,name=after_synchronized_processing_time,json=afterSynchronizedProcessingTime,proto3,oneof"`
}

type Trigger_Always_ struct {
	Always *Trigger_Always `protobuf:"bytes,12,opt,name=always,proto3,oneof"`
}

type Trigger_Default_ struct {
	Default *Trigger_Default `protobuf:"bytes,7,opt,name=default,proto3,oneof"`
}

type Trigger_ElementCount_ struct {
	ElementCount *Trigger_ElementCount `protobuf:"bytes,8,opt,name=element_count,json=elementCount,proto3,oneof"`
}

type Trigger_Never_ struct {
	Never *Trigger_Never `protobuf:"bytes,9,opt,name=never,proto3,oneof"`
}

type Trigger_OrFinally_ struct {
	OrFinally *Trigger_OrFinally `protobuf:"bytes,10,opt,name=or_finally,json=orFinally,proto3,oneof"`
}

type Trigger_Repeat_ struct {
	Repeat *Trigger_Repeat `protobuf:"bytes,11,opt,name=repeat,proto3,oneof"`
}

func (*Trigger_AfterAll_) isTrigger_Trigger() {}

func (*Trigger_AfterAny_) isTrigger_Trigger() {}

func (*Trigger_AfterEach_) isTrigger_Trigger() {}

func (*Trigger_AfterEndOfWindow_) isTrigger_Trigger() {}

func (*Trigger_AfterProcessingTime_) isTrigger_Trigger() {}

func (*Trigger_AfterSynchronizedProcessingTime_) isTrigger_Trigger() {}

func (*Trigger_Always_) isTrigger_Trigger() {}

func (*Trigger_Default_) isTrigger_Trigger() {}

func (*Trigger_ElementCount_) isTrigger_Trigger() {}

func (*Trigger_Never_) isTrigger_Trigger() {}

func (*Trigger_OrFinally_) isTrigger_Trigger() {}

func (*Trigger_Repeat_) isTrigger_Trigger() {}

func (m *Trigger) GetTrigger() isTrigger_Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

func (m *Trigger) GetAfterAll() *Trigger_AfterAll {
	if x, ok := m.GetTrigger().(*Trigger_AfterAll_); ok {
		return x.AfterAll
	}
	return nil
}

func (m *Trigger) GetAfterAny() *Trigger_AfterAny {
	if x, ok := m.GetTrigger().(*Trigger_AfterAny_); ok {
		return x.AfterAny
	}
	return nil
}

func (m *Trigger) GetAfterEach() *Trigger_AfterEach {
	if x, ok := m.GetTrigger().(*Trigger_AfterEach_); ok {
		return x.AfterEach
	}
	return nil
}

func (m *Trigger) GetAfterEndOfWindow() *Trigger_AfterEndOfWindow {
	if x, ok := m.GetTrigger().(*Trigger_AfterEndOfWindow_); ok {
		return x.AfterEndOfWindow
	}
	return nil
}

func (m *Trigger) GetAfterProcessingTime() *Trigger_AfterProcessingTime {
	if x, ok := m.GetTrigger().(*Trigger_AfterProcessingTime_); ok {
		return x.AfterProcessingTime
	}
	return nil
}

func (m *Trigger) GetAfterSynchronizedProcessingTime() *Trigger_AfterSynchronizedProcessingTime {
	if x, ok := m.GetTrigger().(*Trigger_AfterSynchronizedProcessingTime_); ok {
		return x.AfterSynchronizedProcessingTime
	}
	return nil
}

func (m *Trigger) GetAlways() *Trigger_Always {
	if x, ok := m.GetTrigger().(*Trigger_Always_); ok {
		return x.Always
	}
	return nil
}

func (m *Trigger) GetDefault() *Trigger_Default {
	if x, ok := m.GetTrigger().(*Trigger_Default_); ok {
		return x.Default
	}
	return nil
}

func (m *Trigger) GetElementCount() *Trigger_ElementCount {
	if x, ok := m.GetTrigger().(*Trigger_ElementCount_); ok {
		return x.ElementCount
	}
	return nil
}

func (m *Trigger) GetNever() *Trigger_Never {
	if x, ok := m.GetTrigger().(*Trigger_Never_); ok {
		return x.Never
	}
	return nil
}

func (m *Trigger) GetOrFinally() *Trigger_OrFinally {
	if x, ok := m.GetTrigger().(*Trigger_OrFinally_); ok {
		return x.OrFinally
	}
	return nil
}

func (m *Trigger) GetRepeat() *Trigger_Repeat {
	if x, ok := m.GetTrigger().(*Trigger_Repeat_); ok {
		return x.Repeat
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Trigger) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Trigger_AfterAll_)(nil),
		(*Trigger_AfterAny_)(nil),
		(*Trigger_AfterEach_)(nil),
		(*Trigger_AfterEndOfWindow_)(nil),
		(*Trigger_AfterProcessingTime_)(nil),
		(*Trigger_AfterSynchronizedProcessingTime_)(nil),
		(*Trigger_Always_)(nil),
		(*Trigger_Default_)(nil),
		(*Trigger_ElementCount_)(nil),
		(*Trigger_Never_)(nil),
		(*Trigger_OrFinally_)(nil),
		(*Trigger_Repeat_)(nil),
	}
}

// Ready when all subtriggers are ready.
type Trigger_AfterAll struct {
	Subtriggers          []*Trigger `protobuf:"bytes,1,rep,name=subtriggers,proto3" json:"subtriggers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Trigger_AfterAll) Reset()         { *m = Trigger_AfterAll{} }
func (m *Trigger_AfterAll) String() string { return proto.CompactTextString(m) }
func (*Trigger_AfterAll) ProtoMessage()    {}
func (*Trigger_AfterAll) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{32, 0}
}

func (m *Trigger_AfterAll) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_AfterAll.Unmarshal(m, b)
}
func (m *Trigger_AfterAll) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_AfterAll.Marshal(b, m, deterministic)
}
func (m *Trigger_AfterAll) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_AfterAll.Merge(m, src)
}
func (m *Trigger_AfterAll) XXX_Size() int {
	return xxx_messageInfo_Trigger_AfterAll.Size(m)
}
func (m *Trigger_AfterAll) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_AfterAll.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_AfterAll proto.InternalMessageInfo

func (m *Trigger_AfterAll) GetSubtriggers() []*Trigger {
	if m != nil {
		return m.Subtriggers
	}
	return nil
}

// Ready when any subtrigger is ready.
type Trigger_AfterAny struct {
	Subtriggers          []*Trigger `protobuf:"bytes,1,rep,name=subtriggers,proto3" json:"subtriggers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Trigger_AfterAny) Reset()         { *m = Trigger_AfterAny{} }
func (m *Trigger_AfterAny) String() string { return proto.CompactTextString(m) }
func (*Trigger_AfterAny) ProtoMessage()    {}
func (*Trigger_AfterAny) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{32, 1}
}

func (m *Trigger_AfterAny) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_AfterAny.Unmarshal(m, b)
}
func (m *Trigger_AfterAny) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_AfterAny.Marshal(b, m, deterministic)
}
func (m *Trigger_AfterAny) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_AfterAny.Merge(m, src)
}
func (m *Trigger_AfterAny) XXX_Size() int {
	return xxx_messageInfo_Trigger_AfterAny.Size(m)
}
func (m *Trigger_AfterAny) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_AfterAny.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_AfterAny proto.InternalMessageInfo

func (m *Trigger_AfterAny) GetSubtriggers() []*Trigger {
	if m != nil {
		return m.Subtriggers
	}
	return nil
}

// Starting with the first subtrigger, ready when the _current_ subtrigger
// is ready. After output, advances the current trigger by one.
type Trigger_AfterEach struct {
	Subtriggers          []*Trigger `protobuf:"bytes,1,rep,name=subtriggers,proto3" json:"subtriggers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *Trigger_AfterEach) Reset()         { *m = Trigger_AfterEach{} }
func (m *Trigger_AfterEach) String() string { return proto.CompactTextString(m) }
func (*Trigger_AfterEach) ProtoMessage()    {}
func (*Trigger_AfterEach) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{32, 2}
}

func (m *Trigger_AfterEach) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_AfterEach.Unmarshal(m, b)
}
func (m *Trigger_AfterEach) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_AfterEach.Marshal(b, m, deterministic)
}
func (m *Trigger_AfterEach) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_AfterEach.Merge(m, src)
}
func (m *Trigger_AfterEach) XXX_Size() int {
	return xxx_messageInfo_Trigger_AfterEach.Size(m)
}
func (m *Trigger_AfterEach) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_AfterEach.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_AfterEach proto.InternalMessageInfo

func (m *Trigger_AfterEach) GetSubtriggers() []*Trigger {
	if m != nil {
		return m.Subtriggers
	}
	return nil
}

// Ready after the input watermark is past the end of the window.
//
// May have implicitly-repeated subtriggers for early and late firings.
// When the end of the window is reached, the trigger transitions between
// the subtriggers.
type Trigger_AfterEndOfWindow struct {
	// (Optional) A trigger governing output prior to the end of the window.
	EarlyFirings *Trigger `protobuf:"bytes,1,opt,name=early_firings,json=earlyFirings,proto3" json:"early_firings,omitempty"`
	// (Optional) A trigger governing output after the end of the window.
	LateFirings          *Trigger `protobuf:"bytes,2,opt,name=late_firings,json=lateFirings,proto3" json:"late_firings,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Trigger_AfterEndOfWindow) Reset()         { *m = Trigger_AfterEndOfWindow{} }
func (m *Trigger_AfterEndOfWindow) String() string { return proto.CompactTextString(m) }
func (*Trigger_AfterEndOfWindow) ProtoMessage()    {}
func (*Trigger_AfterEndOfWindow) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{32, 3}
}

func (m *Trigger_AfterEndOfWindow) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_AfterEndOfWindow.Unmarshal(m, b)
}
func (m *Trigger_AfterEndOfWindow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_AfterEndOfWindow.Marshal(b, m, deterministic)
}
func (m *Trigger_AfterEndOfWindow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_AfterEndOfWindow.Merge(m, src)
}
func (m *Trigger_AfterEndOfWindow) XXX_Size() int {
	return xxx_messageInfo_Trigger_AfterEndOfWindow.Size(m)
}
func (m *Trigger_AfterEndOfWindow) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_AfterEndOfWindow.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_AfterEndOfWindow proto.InternalMessageInfo

func (m *Trigger_AfterEndOfWindow) GetEarlyFirings() *Trigger {
	if m != nil {
		return m.EarlyFirings
	}
	return nil
}

func (m *Trigger_AfterEndOfWindow) GetLateFirings() *Trigger {
	if m != nil {
		return m.LateFirings
	}
	return nil
}

// After input arrives, ready when the specified delay has passed.
type Trigger_AfterProcessingTime struct {
	// (Required) The transforms to apply to an arriving element's timestamp,
	// in order
	TimestampTransforms  []*TimestampTransform `protobuf:"bytes,1,rep,name=timestamp_transforms,json=timestampTransforms,proto3" json:"timestamp_transforms,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Trigger_AfterProcessingTime) Reset()         { *m = Trigger_AfterProcessingTime{} }
func (m *Trigger_AfterProcessingTime) String() string { return proto.CompactTextString(m) }
func (*Trigger_AfterProcessingTime) ProtoMessage()    {}
func (*Trigger_AfterProcessingTime) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{32, 4}
}

func (m *Trigger_AfterProcessingTime) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_AfterProcessingTime.Unmarshal(m, b)
}
func (m *Trigger_AfterProcessingTime) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_AfterProcessingTime.Marshal(b, m, deterministic)
}
func (m *Trigger_AfterProcessingTime) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_AfterProcessingTime.Merge(m, src)
}
func (m *Trigger_AfterProcessingTime) XXX_Size() int {
	return xxx_messageInfo_Trigger_AfterProcessingTime.Size(m)
}
func (m *Trigger_AfterProcessingTime) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_AfterProcessingTime.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_AfterProcessingTime proto.InternalMessageInfo

func (m *Trigger_AfterProcessingTime) GetTimestampTransforms() []*TimestampTransform {
	if m != nil {
		return m.TimestampTransforms
	}
	return nil
}

// Ready whenever upstream processing time has all caught up with
// the arrival time of an input element
type Trigger_AfterSynchronizedProcessingTime struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Trigger_AfterSynchronizedProcessingTime) Reset() {
	*m = Trigger_AfterSynchronizedProcessingTime{}
}
func (m *Trigger_AfterSynchronizedProcessingTime) String() string { return proto.CompactTextString(m) }
func (*Trigger_AfterSynchronizedProcessingTime) ProtoMessage()    {}
func (*Trigger_AfterSynchronizedProcessingTime) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{32, 5}
}

func (m *Trigger_AfterSynchronizedProcessingTime) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_AfterSynchronizedProcessingTime.Unmarshal(m, b)
}
func (m *Trigger_AfterSynchronizedProcessingTime) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_AfterSynchronizedProcessingTime.Marshal(b, m, deterministic)
}
func (m *Trigger_AfterSynchronizedProcessingTime) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_AfterSynchronizedProcessingTime.Merge(m, src)
}
func (m *Trigger_AfterSynchronizedProcessingTime) XXX_Size() int {
	return xxx_messageInfo_Trigger_AfterSynchronizedProcessingTime.Size(m)
}
func (m *Trigger_AfterSynchronizedProcessingTime) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_AfterSynchronizedProcessingTime.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_AfterSynchronizedProcessingTime proto.InternalMessageInfo

// The default trigger. Equivalent to Repeat { AfterEndOfWindow } but
// specially denoted to indicate the user did not alter the triggering.
type Trigger_Default struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Trigger_Default) Reset()         { *m = Trigger_Default{} }
func (m *Trigger_Default) String() string { return proto.CompactTextString(m) }
func (*Trigger_Default) ProtoMessage()    {}
func (*Trigger_Default) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{32, 6}
}

func (m *Trigger_Default) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_Default.Unmarshal(m, b)
}
func (m *Trigger_Default) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_Default.Marshal(b, m, deterministic)
}
func (m *Trigger_Default) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_Default.Merge(m, src)
}
func (m *Trigger_Default) XXX_Size() int {
	return xxx_messageInfo_Trigger_Default.Size(m)
}
func (m *Trigger_Default) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_Default.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_Default proto.InternalMessageInfo

// Ready whenever the requisite number of input elements have arrived
type Trigger_ElementCount struct {
	ElementCount         int32    `protobuf:"varint,1,opt,name=element_count,json=elementCount,proto3" json:"element_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Trigger_ElementCount) Reset()         { *m = Trigger_ElementCount{} }
func (m *Trigger_ElementCount) String() string { return proto.CompactTextString(m) }
func (*Trigger_ElementCount) ProtoMessage()    {}
func (*Trigger_ElementCount) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{32, 7}
}

func (m *Trigger_ElementCount) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_ElementCount.Unmarshal(m, b)
}
func (m *Trigger_ElementCount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_ElementCount.Marshal(b, m, deterministic)
}
func (m *Trigger_ElementCount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_ElementCount.Merge(m, src)
}
func (m *Trigger_ElementCount) XXX_Size() int {
	return xxx_messageInfo_Trigger_ElementCount.Size(m)
}
func (m *Trigger_ElementCount) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_ElementCount.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_ElementCount proto.InternalMessageInfo

func (m *Trigger_ElementCount) GetElementCount() int32 {
	if m != nil {
		return m.ElementCount
	}
	return 0
}

// Never ready. There will only be an ON_TIME output and a final
// output at window expiration.
type Trigger_Never struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Trigger_Never) Reset()         { *m = Trigger_Never{} }
func (m *Trigger_Never) String() string { return proto.CompactTextString(m) }
func (*Trigger_Never) ProtoMessage()    {}
func (*Trigger_Never) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{32, 8}
}

func (m *Trigger_Never) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_Never.Unmarshal(m, b)
}
func (m *Trigger_Never) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_Never.Marshal(b, m, deterministic)
}
func (m *Trigger_Never) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_Never.Merge(m, src)
}
func (m *Trigger_Never) XXX_Size() int {
	return xxx_messageInfo_Trigger_Never.Size(m)
}
func (m *Trigger_Never) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_Never.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_Never proto.InternalMessageInfo

// Always ready. This can also be expressed as ElementCount(1) but
// is more explicit.
type Trigger_Always struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Trigger_Always) Reset()         { *m = Trigger_Always{} }
func (m *Trigger_Always) String() string { return proto.CompactTextString(m) }
func (*Trigger_Always) ProtoMessage()    {}
func (*Trigger_Always) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{32, 9}
}

func (m *Trigger_Always) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_Always.Unmarshal(m, b)
}
func (m *Trigger_Always) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_Always.Marshal(b, m, deterministic)
}
func (m *Trigger_Always) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_Always.Merge(m, src)
}
func (m *Trigger_Always) XXX_Size() int {
	return xxx_messageInfo_Trigger_Always.Size(m)
}
func (m *Trigger_Always) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_Always.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_Always proto.InternalMessageInfo

// Ready whenever either of its subtriggers are ready, but finishes output
// when the finally subtrigger fires.
type Trigger_OrFinally struct {
	// (Required) Trigger governing main output; may fire repeatedly.
	Main *Trigger `protobuf:"bytes,1,opt,name=main,proto3" json:"main,omitempty"`
	// (Required) Trigger governing termination of output.
	Finally              *Trigger `protobuf:"bytes,2,opt,name=finally,proto3" json:"finally,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Trigger_OrFinally) Reset()         { *m = Trigger_OrFinally{} }
func (m *Trigger_OrFinally) String() string { return proto.CompactTextString(m) }
func (*Trigger_OrFinally) ProtoMessage()    {}
func (*Trigger_OrFinally) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{32, 10}
}

func (m *Trigger_OrFinally) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_OrFinally.Unmarshal(m, b)
}
func (m *Trigger_OrFinally) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_OrFinally.Marshal(b, m, deterministic)
}
func (m *Trigger_OrFinally) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_OrFinally.Merge(m, src)
}
func (m *Trigger_OrFinally) XXX_Size() int {
	return xxx_messageInfo_Trigger_OrFinally.Size(m)
}
func (m *Trigger_OrFinally) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_OrFinally.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_OrFinally proto.InternalMessageInfo

func (m *Trigger_OrFinally) GetMain() *Trigger {
	if m != nil {
		return m.Main
	}
	return nil
}

func (m *Trigger_OrFinally) GetFinally() *Trigger {
	if m != nil {
		return m.Finally
	}
	return nil
}

// Ready whenever the subtrigger is ready; resets state when the subtrigger
// completes.
type Trigger_Repeat struct {
	// (Require) Trigger that is run repeatedly.
	Subtrigger           *Trigger `protobuf:"bytes,1,opt,name=subtrigger,proto3" json:"subtrigger,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Trigger_Repeat) Reset()         { *m = Trigger_Repeat{} }
func (m *Trigger_Repeat) String() string { return proto.CompactTextString(m) }
func (*Trigger_Repeat) ProtoMessage()    {}
func (*Trigger_Repeat) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{32, 11}
}

func (m *Trigger_Repeat) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trigger_Repeat.Unmarshal(m, b)
}
func (m *Trigger_Repeat) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trigger_Repeat.Marshal(b, m, deterministic)
}
func (m *Trigger_Repeat) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trigger_Repeat.Merge(m, src)
}
func (m *Trigger_Repeat) XXX_Size() int {
	return xxx_messageInfo_Trigger_Repeat.Size(m)
}
func (m *Trigger_Repeat) XXX_DiscardUnknown() {
	xxx_messageInfo_Trigger_Repeat.DiscardUnknown(m)
}

var xxx_messageInfo_Trigger_Repeat proto.InternalMessageInfo

func (m *Trigger_Repeat) GetSubtrigger() *Trigger {
	if m != nil {
		return m.Subtrigger
	}
	return nil
}

// A specification for a transformation on a timestamp.
//
// Primarily used by AfterProcessingTime triggers to transform
// the arrival time of input to a target time for firing.
type TimestampTransform struct {
	// Types that are valid to be assigned to TimestampTransform:
	//	*TimestampTransform_Delay_
	//	*TimestampTransform_AlignTo_
	TimestampTransform   isTimestampTransform_TimestampTransform `protobuf_oneof:"timestamp_transform"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *TimestampTransform) Reset()         { *m = TimestampTransform{} }
func (m *TimestampTransform) String() string { return proto.CompactTextString(m) }
func (*TimestampTransform) ProtoMessage()    {}
func (*TimestampTransform) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{33}
}

func (m *TimestampTransform) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimestampTransform.Unmarshal(m, b)
}
func (m *TimestampTransform) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimestampTransform.Marshal(b, m, deterministic)
}
func (m *TimestampTransform) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimestampTransform.Merge(m, src)
}
func (m *TimestampTransform) XXX_Size() int {
	return xxx_messageInfo_TimestampTransform.Size(m)
}
func (m *TimestampTransform) XXX_DiscardUnknown() {
	xxx_messageInfo_TimestampTransform.DiscardUnknown(m)
}

var xxx_messageInfo_TimestampTransform proto.InternalMessageInfo

type isTimestampTransform_TimestampTransform interface {
	isTimestampTransform_TimestampTransform()
}

type TimestampTransform_Delay_ struct {
	Delay *TimestampTransform_Delay `protobuf:"bytes,1,opt,name=delay,proto3,oneof"`
}

type TimestampTransform_AlignTo_ struct {
	AlignTo *TimestampTransform_AlignTo `protobuf:"bytes,2,opt,name=align_to,json=alignTo,proto3,oneof"`
}

func (*TimestampTransform_Delay_) isTimestampTransform_TimestampTransform() {}

func (*TimestampTransform_AlignTo_) isTimestampTransform_TimestampTransform() {}

func (m *TimestampTransform) GetTimestampTransform() isTimestampTransform_TimestampTransform {
	if m != nil {
		return m.TimestampTransform
	}
	return nil
}

func (m *TimestampTransform) GetDelay() *TimestampTransform_Delay {
	if x, ok := m.GetTimestampTransform().(*TimestampTransform_Delay_); ok {
		return x.Delay
	}
	return nil
}

func (m *TimestampTransform) GetAlignTo() *TimestampTransform_AlignTo {
	if x, ok := m.GetTimestampTransform().(*TimestampTransform_AlignTo_); ok {
		return x.AlignTo
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*TimestampTransform) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*TimestampTransform_Delay_)(nil),
		(*TimestampTransform_AlignTo_)(nil),
	}
}

type TimestampTransform_Delay struct {
	// (Required) The delay, in milliseconds.
	DelayMillis          int64    `protobuf:"varint,1,opt,name=delay_millis,json=delayMillis,proto3" json:"delay_millis,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TimestampTransform_Delay) Reset()         { *m = TimestampTransform_Delay{} }
func (m *TimestampTransform_Delay) String() string { return proto.CompactTextString(m) }
func (*TimestampTransform_Delay) ProtoMessage()    {}
func (*TimestampTransform_Delay) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{33, 0}
}

func (m *TimestampTransform_Delay) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimestampTransform_Delay.Unmarshal(m, b)
}
func (m *TimestampTransform_Delay) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimestampTransform_Delay.Marshal(b, m, deterministic)
}
func (m *TimestampTransform_Delay) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimestampTransform_Delay.Merge(m, src)
}
func (m *TimestampTransform_Delay) XXX_Size() int {
	return xxx_messageInfo_TimestampTransform_Delay.Size(m)
}
func (m *TimestampTransform_Delay) XXX_DiscardUnknown() {
	xxx_messageInfo_TimestampTransform_Delay.DiscardUnknown(m)
}

var xxx_messageInfo_TimestampTransform_Delay proto.InternalMessageInfo

func (m *TimestampTransform_Delay) GetDelayMillis() int64 {
	if m != nil {
		return m.DelayMillis
	}
	return 0
}

type TimestampTransform_AlignTo struct {
	// (Required) A duration to which delays should be quantized
	// in milliseconds.
	Period int64 `protobuf:"varint,3,opt,name=period,proto3" json:"period,omitempty"`
	// (Required) An offset from 0 for the quantization specified by
	// alignment_size, in milliseconds
	Offset               int64    `protobuf:"varint,4,opt,name=offset,proto3" json:"offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TimestampTransform_AlignTo) Reset()         { *m = TimestampTransform_AlignTo{} }
func (m *TimestampTransform_AlignTo) String() string { return proto.CompactTextString(m) }
func (*TimestampTransform_AlignTo) ProtoMessage()    {}
func (*TimestampTransform_AlignTo) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{33, 1}
}

func (m *TimestampTransform_AlignTo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimestampTransform_AlignTo.Unmarshal(m, b)
}
func (m *TimestampTransform_AlignTo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimestampTransform_AlignTo.Marshal(b, m, deterministic)
}
func (m *TimestampTransform_AlignTo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimestampTransform_AlignTo.Merge(m, src)
}
func (m *TimestampTransform_AlignTo) XXX_Size() int {
	return xxx_messageInfo_TimestampTransform_AlignTo.Size(m)
}
func (m *TimestampTransform_AlignTo) XXX_DiscardUnknown() {
	xxx_messageInfo_TimestampTransform_AlignTo.DiscardUnknown(m)
}

var xxx_messageInfo_TimestampTransform_AlignTo proto.InternalMessageInfo

func (m *TimestampTransform_AlignTo) GetPeriod() int64 {
	if m != nil {
		return m.Period
	}
	return 0
}

func (m *TimestampTransform_AlignTo) GetOffset() int64 {
	if m != nil {
		return m.Offset
	}
	return 0
}

// A specification for how to "side input" a PCollection.
type SideInput struct {
	// (Required) URN of the access pattern required by the `view_fn` to present
	// the desired SDK-specific interface to a UDF.
	//
	// This access pattern defines the SDK harness <-> Runner Harness RPC
	// interface for accessing a side input.
	//
	// The only access pattern intended for Beam, because of its superior
	// performance possibilities, is "beam:sideinput:multimap" (or some such
	// URN)
	AccessPattern *FunctionSpec `protobuf:"bytes,1,opt,name=access_pattern,json=accessPattern,proto3" json:"access_pattern,omitempty"`
	// (Required) The FunctionSpec of the UDF that adapts a particular
	// access_pattern to a user-facing view type.
	//
	// For example, View.asSingleton() may include a `view_fn` that adapts a
	// specially-designed multimap to a single value per window.
	ViewFn *FunctionSpec `protobuf:"bytes,2,opt,name=view_fn,json=viewFn,proto3" json:"view_fn,omitempty"`
	// (Required) The FunctionSpec of the UDF that maps a main input window
	// to a side input window.
	//
	// For example, when the main input is in fixed windows of one hour, this
	// can specify that the side input should be accessed according to the day
	// in which that hour falls.
	WindowMappingFn      *FunctionSpec `protobuf:"bytes,3,opt,name=window_mapping_fn,json=windowMappingFn,proto3" json:"window_mapping_fn,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *SideInput) Reset()         { *m = SideInput{} }
func (m *SideInput) String() string { return proto.CompactTextString(m) }
func (*SideInput) ProtoMessage()    {}
func (*SideInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{34}
}

func (m *SideInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SideInput.Unmarshal(m, b)
}
func (m *SideInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SideInput.Marshal(b, m, deterministic)
}
func (m *SideInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SideInput.Merge(m, src)
}
func (m *SideInput) XXX_Size() int {
	return xxx_messageInfo_SideInput.Size(m)
}
func (m *SideInput) XXX_DiscardUnknown() {
	xxx_messageInfo_SideInput.DiscardUnknown(m)
}

var xxx_messageInfo_SideInput proto.InternalMessageInfo

func (m *SideInput) GetAccessPattern() *FunctionSpec {
	if m != nil {
		return m.AccessPattern
	}
	return nil
}

func (m *SideInput) GetViewFn() *FunctionSpec {
	if m != nil {
		return m.ViewFn
	}
	return nil
}

func (m *SideInput) GetWindowMappingFn() *FunctionSpec {
	if m != nil {
		return m.WindowMappingFn
	}
	return nil
}

// Settings that decide the coder type of wire coder.
type WireCoderSetting struct {
	// (Required) The URN of the wire coder.
	// Note that only windowed value coder or parameterized windowed value coder are supported.
	Urn string `protobuf:"bytes,1,opt,name=urn,proto3" json:"urn,omitempty"`
	// (Optional) The data specifying any parameters to the URN. If
	// the URN is beam:coder:windowed_value:v1, this may be omitted. If the URN is
	// beam:coder:param_windowed_value:v1, the payload is an encoded windowed
	// value using the beam:coder:windowed_value:v1 coder parameterized by
	// a beam:coder:bytes:v1 element coder and the window coder that this
	// param_windowed_value coder uses.
	Payload              []byte   `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WireCoderSetting) Reset()         { *m = WireCoderSetting{} }
func (m *WireCoderSetting) String() string { return proto.CompactTextString(m) }
func (*WireCoderSetting) ProtoMessage()    {}
func (*WireCoderSetting) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{35}
}

func (m *WireCoderSetting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WireCoderSetting.Unmarshal(m, b)
}
func (m *WireCoderSetting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WireCoderSetting.Marshal(b, m, deterministic)
}
func (m *WireCoderSetting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WireCoderSetting.Merge(m, src)
}
func (m *WireCoderSetting) XXX_Size() int {
	return xxx_messageInfo_WireCoderSetting.Size(m)
}
func (m *WireCoderSetting) XXX_DiscardUnknown() {
	xxx_messageInfo_WireCoderSetting.DiscardUnknown(m)
}

var xxx_messageInfo_WireCoderSetting proto.InternalMessageInfo

func (m *WireCoderSetting) GetUrn() string {
	if m != nil {
		return m.Urn
	}
	return ""
}

func (m *WireCoderSetting) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

// An environment for executing UDFs. By default, an SDK container URL, but
// can also be a process forked by a command, or an externally managed process.
type Environment struct {
	// (Required) The URN of the payload
	Urn string `protobuf:"bytes,2,opt,name=urn,proto3" json:"urn,omitempty"`
	// (Optional) The data specifying any parameters to the URN. If
	// the URN does not require any arguments, this may be omitted.
	Payload              []byte   `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Environment) Reset()         { *m = Environment{} }
func (m *Environment) String() string { return proto.CompactTextString(m) }
func (*Environment) ProtoMessage()    {}
func (*Environment) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{36}
}

func (m *Environment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Environment.Unmarshal(m, b)
}
func (m *Environment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Environment.Marshal(b, m, deterministic)
}
func (m *Environment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Environment.Merge(m, src)
}
func (m *Environment) XXX_Size() int {
	return xxx_messageInfo_Environment.Size(m)
}
func (m *Environment) XXX_DiscardUnknown() {
	xxx_messageInfo_Environment.DiscardUnknown(m)
}

var xxx_messageInfo_Environment proto.InternalMessageInfo

func (m *Environment) GetUrn() string {
	if m != nil {
		return m.Urn
	}
	return ""
}

func (m *Environment) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

type StandardEnvironments struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StandardEnvironments) Reset()         { *m = StandardEnvironments{} }
func (m *StandardEnvironments) String() string { return proto.CompactTextString(m) }
func (*StandardEnvironments) ProtoMessage()    {}
func (*StandardEnvironments) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{37}
}

func (m *StandardEnvironments) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StandardEnvironments.Unmarshal(m, b)
}
func (m *StandardEnvironments) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StandardEnvironments.Marshal(b, m, deterministic)
}
func (m *StandardEnvironments) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StandardEnvironments.Merge(m, src)
}
func (m *StandardEnvironments) XXX_Size() int {
	return xxx_messageInfo_StandardEnvironments.Size(m)
}
func (m *StandardEnvironments) XXX_DiscardUnknown() {
	xxx_messageInfo_StandardEnvironments.DiscardUnknown(m)
}

var xxx_messageInfo_StandardEnvironments proto.InternalMessageInfo

// The payload of a Docker image
type DockerPayload struct {
	ContainerImage       string   `protobuf:"bytes,1,opt,name=container_image,json=containerImage,proto3" json:"container_image,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DockerPayload) Reset()         { *m = DockerPayload{} }
func (m *DockerPayload) String() string { return proto.CompactTextString(m) }
func (*DockerPayload) ProtoMessage()    {}
func (*DockerPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{38}
}

func (m *DockerPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DockerPayload.Unmarshal(m, b)
}
func (m *DockerPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DockerPayload.Marshal(b, m, deterministic)
}
func (m *DockerPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DockerPayload.Merge(m, src)
}
func (m *DockerPayload) XXX_Size() int {
	return xxx_messageInfo_DockerPayload.Size(m)
}
func (m *DockerPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_DockerPayload.DiscardUnknown(m)
}

var xxx_messageInfo_DockerPayload proto.InternalMessageInfo

func (m *DockerPayload) GetContainerImage() string {
	if m != nil {
		return m.ContainerImage
	}
	return ""
}

type ProcessPayload struct {
	Os                   string            `protobuf:"bytes,1,opt,name=os,proto3" json:"os,omitempty"`
	Arch                 string            `protobuf:"bytes,2,opt,name=arch,proto3" json:"arch,omitempty"`
	Command              string            `protobuf:"bytes,3,opt,name=command,proto3" json:"command,omitempty"`
	Env                  map[string]string `protobuf:"bytes,4,rep,name=env,proto3" json:"env,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ProcessPayload) Reset()         { *m = ProcessPayload{} }
func (m *ProcessPayload) String() string { return proto.CompactTextString(m) }
func (*ProcessPayload) ProtoMessage()    {}
func (*ProcessPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{39}
}

func (m *ProcessPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessPayload.Unmarshal(m, b)
}
func (m *ProcessPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessPayload.Marshal(b, m, deterministic)
}
func (m *ProcessPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessPayload.Merge(m, src)
}
func (m *ProcessPayload) XXX_Size() int {
	return xxx_messageInfo_ProcessPayload.Size(m)
}
func (m *ProcessPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessPayload.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessPayload proto.InternalMessageInfo

func (m *ProcessPayload) GetOs() string {
	if m != nil {
		return m.Os
	}
	return ""
}

func (m *ProcessPayload) GetArch() string {
	if m != nil {
		return m.Arch
	}
	return ""
}

func (m *ProcessPayload) GetCommand() string {
	if m != nil {
		return m.Command
	}
	return ""
}

func (m *ProcessPayload) GetEnv() map[string]string {
	if m != nil {
		return m.Env
	}
	return nil
}

type ExternalPayload struct {
	Endpoint             *ApiServiceDescriptor `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	Params               map[string]string     `protobuf:"bytes,2,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ExternalPayload) Reset()         { *m = ExternalPayload{} }
func (m *ExternalPayload) String() string { return proto.CompactTextString(m) }
func (*ExternalPayload) ProtoMessage()    {}
func (*ExternalPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{40}
}

func (m *ExternalPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExternalPayload.Unmarshal(m, b)
}
func (m *ExternalPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExternalPayload.Marshal(b, m, deterministic)
}
func (m *ExternalPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalPayload.Merge(m, src)
}
func (m *ExternalPayload) XXX_Size() int {
	return xxx_messageInfo_ExternalPayload.Size(m)
}
func (m *ExternalPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalPayload.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalPayload proto.InternalMessageInfo

func (m *ExternalPayload) GetEndpoint() *ApiServiceDescriptor {
	if m != nil {
		return m.Endpoint
	}
	return nil
}

func (m *ExternalPayload) GetParams() map[string]string {
	if m != nil {
		return m.Params
	}
	return nil
}

// A URN along with a parameter object whose schema is determined by the
// URN.
//
// This structure is reused in two distinct, but compatible, ways:
//
// 1. This can be a specification of the function over PCollections
//    that a PTransform computes.
// 2. This can be a specification of a user-defined function, possibly
//    SDK-specific. (external to this message must be adequate context
//    to indicate the environment in which the UDF can be understood).
//
// Though not explicit in this proto, there are two possibilities
// for the relationship of a runner to this specification that
// one should bear in mind:
//
// 1. The runner understands the URN. For example, it might be
//    a well-known URN like "beam:transform:Top" or
//    "beam:windowfn:FixedWindows" with
//    an agreed-upon payload (e.g. a number or duration,
//    respectively).
// 2. The runner does not understand the URN. It might be an
//    SDK specific URN such as "beam:dofn:javasdk:1.0"
//    that indicates to the SDK what the payload is,
//    such as a serialized Java DoFn from a particular
//    version of the Beam Java SDK. The payload will often
//    then be an opaque message such as bytes in a
//    language-specific serialization format.
type FunctionSpec struct {
	// (Required) A URN that describes the accompanying payload.
	// For any URN that is not recognized (by whomever is inspecting
	// it) the parameter payload should be treated as opaque and
	// passed as-is.
	Urn string `protobuf:"bytes,1,opt,name=urn,proto3" json:"urn,omitempty"`
	// (Optional) The data specifying any parameters to the URN. If
	// the URN does not require any arguments, this may be omitted.
	Payload              []byte   `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FunctionSpec) Reset()         { *m = FunctionSpec{} }
func (m *FunctionSpec) String() string { return proto.CompactTextString(m) }
func (*FunctionSpec) ProtoMessage()    {}
func (*FunctionSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{41}
}

func (m *FunctionSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FunctionSpec.Unmarshal(m, b)
}
func (m *FunctionSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FunctionSpec.Marshal(b, m, deterministic)
}
func (m *FunctionSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FunctionSpec.Merge(m, src)
}
func (m *FunctionSpec) XXX_Size() int {
	return xxx_messageInfo_FunctionSpec.Size(m)
}
func (m *FunctionSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_FunctionSpec.DiscardUnknown(m)
}

var xxx_messageInfo_FunctionSpec proto.InternalMessageInfo

func (m *FunctionSpec) GetUrn() string {
	if m != nil {
		return m.Urn
	}
	return ""
}

func (m *FunctionSpec) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

// TODO: transfer javadoc here
type DisplayData struct {
	// (Required) The list of display data.
	Items                []*DisplayData_Item `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *DisplayData) Reset()         { *m = DisplayData{} }
func (m *DisplayData) String() string { return proto.CompactTextString(m) }
func (*DisplayData) ProtoMessage()    {}
func (*DisplayData) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{42}
}

func (m *DisplayData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DisplayData.Unmarshal(m, b)
}
func (m *DisplayData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DisplayData.Marshal(b, m, deterministic)
}
func (m *DisplayData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DisplayData.Merge(m, src)
}
func (m *DisplayData) XXX_Size() int {
	return xxx_messageInfo_DisplayData.Size(m)
}
func (m *DisplayData) XXX_DiscardUnknown() {
	xxx_messageInfo_DisplayData.DiscardUnknown(m)
}

var xxx_messageInfo_DisplayData proto.InternalMessageInfo

func (m *DisplayData) GetItems() []*DisplayData_Item {
	if m != nil {
		return m.Items
	}
	return nil
}

// A complete identifier for a DisplayData.Item
type DisplayData_Identifier struct {
	// (Required) The transform originating this display data.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Optional) The URN indicating the type of the originating transform,
	// if there is one.
	TransformUrn         string   `protobuf:"bytes,2,opt,name=transform_urn,json=transformUrn,proto3" json:"transform_urn,omitempty"`
	Key                  string   `protobuf:"bytes,3,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DisplayData_Identifier) Reset()         { *m = DisplayData_Identifier{} }
func (m *DisplayData_Identifier) String() string { return proto.CompactTextString(m) }
func (*DisplayData_Identifier) ProtoMessage()    {}
func (*DisplayData_Identifier) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{42, 0}
}

func (m *DisplayData_Identifier) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DisplayData_Identifier.Unmarshal(m, b)
}
func (m *DisplayData_Identifier) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DisplayData_Identifier.Marshal(b, m, deterministic)
}
func (m *DisplayData_Identifier) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DisplayData_Identifier.Merge(m, src)
}
func (m *DisplayData_Identifier) XXX_Size() int {
	return xxx_messageInfo_DisplayData_Identifier.Size(m)
}
func (m *DisplayData_Identifier) XXX_DiscardUnknown() {
	xxx_messageInfo_DisplayData_Identifier.DiscardUnknown(m)
}

var xxx_messageInfo_DisplayData_Identifier proto.InternalMessageInfo

func (m *DisplayData_Identifier) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *DisplayData_Identifier) GetTransformUrn() string {
	if m != nil {
		return m.TransformUrn
	}
	return ""
}

func (m *DisplayData_Identifier) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

// A single item of display data.
type DisplayData_Item struct {
	// (Required)
	Id *DisplayData_Identifier `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// (Required)
	Type DisplayData_Type_Enum `protobuf:"varint,2,opt,name=type,proto3,enum=org.apache.beam.model.pipeline.v1.DisplayData_Type_Enum" json:"type,omitempty"`
	// (Required)
	Value *any.Any `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	// (Optional)
	ShortValue *any.Any `protobuf:"bytes,4,opt,name=short_value,json=shortValue,proto3" json:"short_value,omitempty"`
	// (Optional)
	Label string `protobuf:"bytes,5,opt,name=label,proto3" json:"label,omitempty"`
	// (Optional)
	LinkUrl              string   `protobuf:"bytes,6,opt,name=link_url,json=linkUrl,proto3" json:"link_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DisplayData_Item) Reset()         { *m = DisplayData_Item{} }
func (m *DisplayData_Item) String() string { return proto.CompactTextString(m) }
func (*DisplayData_Item) ProtoMessage()    {}
func (*DisplayData_Item) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{42, 1}
}

func (m *DisplayData_Item) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DisplayData_Item.Unmarshal(m, b)
}
func (m *DisplayData_Item) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DisplayData_Item.Marshal(b, m, deterministic)
}
func (m *DisplayData_Item) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DisplayData_Item.Merge(m, src)
}
func (m *DisplayData_Item) XXX_Size() int {
	return xxx_messageInfo_DisplayData_Item.Size(m)
}
func (m *DisplayData_Item) XXX_DiscardUnknown() {
	xxx_messageInfo_DisplayData_Item.DiscardUnknown(m)
}

var xxx_messageInfo_DisplayData_Item proto.InternalMessageInfo

func (m *DisplayData_Item) GetId() *DisplayData_Identifier {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *DisplayData_Item) GetType() DisplayData_Type_Enum {
	if m != nil {
		return m.Type
	}
	return DisplayData_Type_UNSPECIFIED
}

func (m *DisplayData_Item) GetValue() *any.Any {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *DisplayData_Item) GetShortValue() *any.Any {
	if m != nil {
		return m.ShortValue
	}
	return nil
}

func (m *DisplayData_Item) GetLabel() string {
	if m != nil {
		return m.Label
	}
	return ""
}

func (m *DisplayData_Item) GetLinkUrl() string {
	if m != nil {
		return m.LinkUrl
	}
	return ""
}

type DisplayData_Type struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DisplayData_Type) Reset()         { *m = DisplayData_Type{} }
func (m *DisplayData_Type) String() string { return proto.CompactTextString(m) }
func (*DisplayData_Type) ProtoMessage()    {}
func (*DisplayData_Type) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{42, 2}
}

func (m *DisplayData_Type) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DisplayData_Type.Unmarshal(m, b)
}
func (m *DisplayData_Type) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DisplayData_Type.Marshal(b, m, deterministic)
}
func (m *DisplayData_Type) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DisplayData_Type.Merge(m, src)
}
func (m *DisplayData_Type) XXX_Size() int {
	return xxx_messageInfo_DisplayData_Type.Size(m)
}
func (m *DisplayData_Type) XXX_DiscardUnknown() {
	xxx_messageInfo_DisplayData_Type.DiscardUnknown(m)
}

var xxx_messageInfo_DisplayData_Type proto.InternalMessageInfo

// A disjoint union of all the things that may contain references
// that require Components to resolve.
type MessageWithComponents struct {
	// (Optional) The by-reference components of the root message,
	// enabling a standalone message.
	//
	// If this is absent, it is expected that there are no
	// references.
	Components *Components `protobuf:"bytes,1,opt,name=components,proto3" json:"components,omitempty"`
	// (Required) The root message that may contain pointers
	// that should be resolved by looking inside components.
	//
	// Types that are valid to be assigned to Root:
	//	*MessageWithComponents_Coder
	//	*MessageWithComponents_CombinePayload
	//	*MessageWithComponents_FunctionSpec
	//	*MessageWithComponents_ParDoPayload
	//	*MessageWithComponents_Ptransform
	//	*MessageWithComponents_Pcollection
	//	*MessageWithComponents_ReadPayload
	//	*MessageWithComponents_SideInput
	//	*MessageWithComponents_WindowIntoPayload
	//	*MessageWithComponents_WindowingStrategy
	Root                 isMessageWithComponents_Root `protobuf_oneof:"root"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *MessageWithComponents) Reset()         { *m = MessageWithComponents{} }
func (m *MessageWithComponents) String() string { return proto.CompactTextString(m) }
func (*MessageWithComponents) ProtoMessage()    {}
func (*MessageWithComponents) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{43}
}

func (m *MessageWithComponents) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MessageWithComponents.Unmarshal(m, b)
}
func (m *MessageWithComponents) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MessageWithComponents.Marshal(b, m, deterministic)
}
func (m *MessageWithComponents) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MessageWithComponents.Merge(m, src)
}
func (m *MessageWithComponents) XXX_Size() int {
	return xxx_messageInfo_MessageWithComponents.Size(m)
}
func (m *MessageWithComponents) XXX_DiscardUnknown() {
	xxx_messageInfo_MessageWithComponents.DiscardUnknown(m)
}

var xxx_messageInfo_MessageWithComponents proto.InternalMessageInfo

func (m *MessageWithComponents) GetComponents() *Components {
	if m != nil {
		return m.Components
	}
	return nil
}

type isMessageWithComponents_Root interface {
	isMessageWithComponents_Root()
}

type MessageWithComponents_Coder struct {
	Coder *Coder `protobuf:"bytes,2,opt,name=coder,proto3,oneof"`
}

type MessageWithComponents_CombinePayload struct {
	CombinePayload *CombinePayload `protobuf:"bytes,3,opt,name=combine_payload,json=combinePayload,proto3,oneof"`
}

type MessageWithComponents_FunctionSpec struct {
	FunctionSpec *FunctionSpec `protobuf:"bytes,4,opt,name=function_spec,json=functionSpec,proto3,oneof"`
}

type MessageWithComponents_ParDoPayload struct {
	ParDoPayload *ParDoPayload `protobuf:"bytes,6,opt,name=par_do_payload,json=parDoPayload,proto3,oneof"`
}

type MessageWithComponents_Ptransform struct {
	Ptransform *PTransform `protobuf:"bytes,7,opt,name=ptransform,proto3,oneof"`
}

type MessageWithComponents_Pcollection struct {
	Pcollection *PCollection `protobuf:"bytes,8,opt,name=pcollection,proto3,oneof"`
}

type MessageWithComponents_ReadPayload struct {
	ReadPayload *ReadPayload `protobuf:"bytes,9,opt,name=read_payload,json=readPayload,proto3,oneof"`
}

type MessageWithComponents_SideInput struct {
	SideInput *SideInput `protobuf:"bytes,11,opt,name=side_input,json=sideInput,proto3,oneof"`
}

type MessageWithComponents_WindowIntoPayload struct {
	WindowIntoPayload *WindowIntoPayload `protobuf:"bytes,12,opt,name=window_into_payload,json=windowIntoPayload,proto3,oneof"`
}

type MessageWithComponents_WindowingStrategy struct {
	WindowingStrategy *WindowingStrategy `protobuf:"bytes,13,opt,name=windowing_strategy,json=windowingStrategy,proto3,oneof"`
}

func (*MessageWithComponents_Coder) isMessageWithComponents_Root() {}

func (*MessageWithComponents_CombinePayload) isMessageWithComponents_Root() {}

func (*MessageWithComponents_FunctionSpec) isMessageWithComponents_Root() {}

func (*MessageWithComponents_ParDoPayload) isMessageWithComponents_Root() {}

func (*MessageWithComponents_Ptransform) isMessageWithComponents_Root() {}

func (*MessageWithComponents_Pcollection) isMessageWithComponents_Root() {}

func (*MessageWithComponents_ReadPayload) isMessageWithComponents_Root() {}

func (*MessageWithComponents_SideInput) isMessageWithComponents_Root() {}

func (*MessageWithComponents_WindowIntoPayload) isMessageWithComponents_Root() {}

func (*MessageWithComponents_WindowingStrategy) isMessageWithComponents_Root() {}

func (m *MessageWithComponents) GetRoot() isMessageWithComponents_Root {
	if m != nil {
		return m.Root
	}
	return nil
}

func (m *MessageWithComponents) GetCoder() *Coder {
	if x, ok := m.GetRoot().(*MessageWithComponents_Coder); ok {
		return x.Coder
	}
	return nil
}

func (m *MessageWithComponents) GetCombinePayload() *CombinePayload {
	if x, ok := m.GetRoot().(*MessageWithComponents_CombinePayload); ok {
		return x.CombinePayload
	}
	return nil
}

func (m *MessageWithComponents) GetFunctionSpec() *FunctionSpec {
	if x, ok := m.GetRoot().(*MessageWithComponents_FunctionSpec); ok {
		return x.FunctionSpec
	}
	return nil
}

func (m *MessageWithComponents) GetParDoPayload() *ParDoPayload {
	if x, ok := m.GetRoot().(*MessageWithComponents_ParDoPayload); ok {
		return x.ParDoPayload
	}
	return nil
}

func (m *MessageWithComponents) GetPtransform() *PTransform {
	if x, ok := m.GetRoot().(*MessageWithComponents_Ptransform); ok {
		return x.Ptransform
	}
	return nil
}

func (m *MessageWithComponents) GetPcollection() *PCollection {
	if x, ok := m.GetRoot().(*MessageWithComponents_Pcollection); ok {
		return x.Pcollection
	}
	return nil
}

func (m *MessageWithComponents) GetReadPayload() *ReadPayload {
	if x, ok := m.GetRoot().(*MessageWithComponents_ReadPayload); ok {
		return x.ReadPayload
	}
	return nil
}

func (m *MessageWithComponents) GetSideInput() *SideInput {
	if x, ok := m.GetRoot().(*MessageWithComponents_SideInput); ok {
		return x.SideInput
	}
	return nil
}

func (m *MessageWithComponents) GetWindowIntoPayload() *WindowIntoPayload {
	if x, ok := m.GetRoot().(*MessageWithComponents_WindowIntoPayload); ok {
		return x.WindowIntoPayload
	}
	return nil
}

func (m *MessageWithComponents) GetWindowingStrategy() *WindowingStrategy {
	if x, ok := m.GetRoot().(*MessageWithComponents_WindowingStrategy); ok {
		return x.WindowingStrategy
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*MessageWithComponents) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*MessageWithComponents_Coder)(nil),
		(*MessageWithComponents_CombinePayload)(nil),
		(*MessageWithComponents_FunctionSpec)(nil),
		(*MessageWithComponents_ParDoPayload)(nil),
		(*MessageWithComponents_Ptransform)(nil),
		(*MessageWithComponents_Pcollection)(nil),
		(*MessageWithComponents_ReadPayload)(nil),
		(*MessageWithComponents_SideInput)(nil),
		(*MessageWithComponents_WindowIntoPayload)(nil),
		(*MessageWithComponents_WindowingStrategy)(nil),
	}
}

// The payload for an executable stage. This will eventually be passed to an SDK in the form of a
// ProcessBundleDescriptor.
type ExecutableStagePayload struct {
	// (Required) Environment in which this stage executes.
	//
	// We use an environment rather than environment id
	// because ExecutableStages use environments directly. This may change in the future.
	Environment *Environment `protobuf:"bytes,1,opt,name=environment,proto3" json:"environment,omitempty"`
	// set the wire coder of this executable stage
	WireCoderSetting *WireCoderSetting `protobuf:"bytes,9,opt,name=wire_coder_setting,json=wireCoderSetting,proto3" json:"wire_coder_setting,omitempty"`
	// (Required) Input PCollection id. This must be present as a value in the inputs of any
	// PTransform the ExecutableStagePayload is the payload of.
	Input string `protobuf:"bytes,2,opt,name=input,proto3" json:"input,omitempty"`
	// The side inputs required for this executable stage. Each side input of each PTransform within
	// this ExecutableStagePayload must be represented within this field.
	SideInputs []*ExecutableStagePayload_SideInputId `protobuf:"bytes,3,rep,name=side_inputs,json=sideInputs,proto3" json:"side_inputs,omitempty"`
	// PTransform ids contained within this executable stage. This must contain at least one
	// PTransform id.
	Transforms []string `protobuf:"bytes,4,rep,name=transforms,proto3" json:"transforms,omitempty"`
	// Output PCollection ids. This must be equal to the values of the outputs of any
	// PTransform the ExecutableStagePayload is the payload of.
	Outputs []string `protobuf:"bytes,5,rep,name=outputs,proto3" json:"outputs,omitempty"`
	// (Required) The components for the Executable Stage. This must contain all of the Transforms
	// in transforms, and the closure of all of the components they recognize.
	Components *Components `protobuf:"bytes,6,opt,name=components,proto3" json:"components,omitempty"`
	// The user states required for this executable stage. Each user state of each PTransform within
	// this ExecutableStagePayload must be represented within this field.
	UserStates []*ExecutableStagePayload_UserStateId `protobuf:"bytes,7,rep,name=user_states,json=userStates,proto3" json:"user_states,omitempty"`
	// The timers required for this executable stage. Each timer of each PTransform within
	// this ExecutableStagePayload must be represented within this field.
	Timers               []*ExecutableStagePayload_TimerId `protobuf:"bytes,8,rep,name=timers,proto3" json:"timers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *ExecutableStagePayload) Reset()         { *m = ExecutableStagePayload{} }
func (m *ExecutableStagePayload) String() string { return proto.CompactTextString(m) }
func (*ExecutableStagePayload) ProtoMessage()    {}
func (*ExecutableStagePayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{44}
}

func (m *ExecutableStagePayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecutableStagePayload.Unmarshal(m, b)
}
func (m *ExecutableStagePayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecutableStagePayload.Marshal(b, m, deterministic)
}
func (m *ExecutableStagePayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecutableStagePayload.Merge(m, src)
}
func (m *ExecutableStagePayload) XXX_Size() int {
	return xxx_messageInfo_ExecutableStagePayload.Size(m)
}
func (m *ExecutableStagePayload) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecutableStagePayload.DiscardUnknown(m)
}

var xxx_messageInfo_ExecutableStagePayload proto.InternalMessageInfo

func (m *ExecutableStagePayload) GetEnvironment() *Environment {
	if m != nil {
		return m.Environment
	}
	return nil
}

func (m *ExecutableStagePayload) GetWireCoderSetting() *WireCoderSetting {
	if m != nil {
		return m.WireCoderSetting
	}
	return nil
}

func (m *ExecutableStagePayload) GetInput() string {
	if m != nil {
		return m.Input
	}
	return ""
}

func (m *ExecutableStagePayload) GetSideInputs() []*ExecutableStagePayload_SideInputId {
	if m != nil {
		return m.SideInputs
	}
	return nil
}

func (m *ExecutableStagePayload) GetTransforms() []string {
	if m != nil {
		return m.Transforms
	}
	return nil
}

func (m *ExecutableStagePayload) GetOutputs() []string {
	if m != nil {
		return m.Outputs
	}
	return nil
}

func (m *ExecutableStagePayload) GetComponents() *Components {
	if m != nil {
		return m.Components
	}
	return nil
}

func (m *ExecutableStagePayload) GetUserStates() []*ExecutableStagePayload_UserStateId {
	if m != nil {
		return m.UserStates
	}
	return nil
}

func (m *ExecutableStagePayload) GetTimers() []*ExecutableStagePayload_TimerId {
	if m != nil {
		return m.Timers
	}
	return nil
}

// A reference to a side input. Side inputs are uniquely identified by PTransform id and
// local name.
type ExecutableStagePayload_SideInputId struct {
	// (Required) The id of the PTransform that references this side input.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The local name of this side input from the PTransform that references it.
	LocalName            string   `protobuf:"bytes,2,opt,name=local_name,json=localName,proto3" json:"local_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecutableStagePayload_SideInputId) Reset()         { *m = ExecutableStagePayload_SideInputId{} }
func (m *ExecutableStagePayload_SideInputId) String() string { return proto.CompactTextString(m) }
func (*ExecutableStagePayload_SideInputId) ProtoMessage()    {}
func (*ExecutableStagePayload_SideInputId) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{44, 0}
}

func (m *ExecutableStagePayload_SideInputId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecutableStagePayload_SideInputId.Unmarshal(m, b)
}
func (m *ExecutableStagePayload_SideInputId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecutableStagePayload_SideInputId.Marshal(b, m, deterministic)
}
func (m *ExecutableStagePayload_SideInputId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecutableStagePayload_SideInputId.Merge(m, src)
}
func (m *ExecutableStagePayload_SideInputId) XXX_Size() int {
	return xxx_messageInfo_ExecutableStagePayload_SideInputId.Size(m)
}
func (m *ExecutableStagePayload_SideInputId) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecutableStagePayload_SideInputId.DiscardUnknown(m)
}

var xxx_messageInfo_ExecutableStagePayload_SideInputId proto.InternalMessageInfo

func (m *ExecutableStagePayload_SideInputId) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *ExecutableStagePayload_SideInputId) GetLocalName() string {
	if m != nil {
		return m.LocalName
	}
	return ""
}

// A reference to user state. User states are uniquely identified by PTransform id and
// local name.
type ExecutableStagePayload_UserStateId struct {
	// (Required) The id of the PTransform that references this user state.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The local name of this user state for the PTransform that references it.
	LocalName            string   `protobuf:"bytes,2,opt,name=local_name,json=localName,proto3" json:"local_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecutableStagePayload_UserStateId) Reset()         { *m = ExecutableStagePayload_UserStateId{} }
func (m *ExecutableStagePayload_UserStateId) String() string { return proto.CompactTextString(m) }
func (*ExecutableStagePayload_UserStateId) ProtoMessage()    {}
func (*ExecutableStagePayload_UserStateId) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{44, 1}
}

func (m *ExecutableStagePayload_UserStateId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecutableStagePayload_UserStateId.Unmarshal(m, b)
}
func (m *ExecutableStagePayload_UserStateId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecutableStagePayload_UserStateId.Marshal(b, m, deterministic)
}
func (m *ExecutableStagePayload_UserStateId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecutableStagePayload_UserStateId.Merge(m, src)
}
func (m *ExecutableStagePayload_UserStateId) XXX_Size() int {
	return xxx_messageInfo_ExecutableStagePayload_UserStateId.Size(m)
}
func (m *ExecutableStagePayload_UserStateId) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecutableStagePayload_UserStateId.DiscardUnknown(m)
}

var xxx_messageInfo_ExecutableStagePayload_UserStateId proto.InternalMessageInfo

func (m *ExecutableStagePayload_UserStateId) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *ExecutableStagePayload_UserStateId) GetLocalName() string {
	if m != nil {
		return m.LocalName
	}
	return ""
}

// A reference to a timer. Timers are uniquely identified by PTransform id and
// local name.
type ExecutableStagePayload_TimerId struct {
	// (Required) The id of the PTransform that references this timer.
	TransformId string `protobuf:"bytes,1,opt,name=transform_id,json=transformId,proto3" json:"transform_id,omitempty"`
	// (Required) The local name of this timer for the PTransform that references it.
	LocalName            string   `protobuf:"bytes,2,opt,name=local_name,json=localName,proto3" json:"local_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecutableStagePayload_TimerId) Reset()         { *m = ExecutableStagePayload_TimerId{} }
func (m *ExecutableStagePayload_TimerId) String() string { return proto.CompactTextString(m) }
func (*ExecutableStagePayload_TimerId) ProtoMessage()    {}
func (*ExecutableStagePayload_TimerId) Descriptor() ([]byte, []int) {
	return fileDescriptor_cf57597c3a9659a9, []int{44, 2}
}

func (m *ExecutableStagePayload_TimerId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecutableStagePayload_TimerId.Unmarshal(m, b)
}
func (m *ExecutableStagePayload_TimerId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecutableStagePayload_TimerId.Marshal(b, m, deterministic)
}
func (m *ExecutableStagePayload_TimerId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecutableStagePayload_TimerId.Merge(m, src)
}
func (m *ExecutableStagePayload_TimerId) XXX_Size() int {
	return xxx_messageInfo_ExecutableStagePayload_TimerId.Size(m)
}
func (m *ExecutableStagePayload_TimerId) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecutableStagePayload_TimerId.DiscardUnknown(m)
}

var xxx_messageInfo_ExecutableStagePayload_TimerId proto.InternalMessageInfo

func (m *ExecutableStagePayload_TimerId) GetTransformId() string {
	if m != nil {
		return m.TransformId
	}
	return ""
}

func (m *ExecutableStagePayload_TimerId) GetLocalName() string {
	if m != nil {
		return m.LocalName
	}
	return ""
}

var E_BeamUrn = &proto.ExtensionDesc{
	ExtendedType:  (*descriptor.EnumValueOptions)(nil),
	ExtensionType: (*string)(nil),
	Field:         185324356,
	Name:          "org.apache.beam.model.pipeline.v1.beam_urn",
	Tag:           "bytes,185324356,opt,name=beam_urn",
	Filename:      "beam_runner_api.proto",
}

var E_BeamConstant = &proto.ExtensionDesc{
	ExtendedType:  (*descriptor.EnumValueOptions)(nil),
	ExtensionType: (*string)(nil),
	Field:         185324357,
	Name:          "org.apache.beam.model.pipeline.v1.beam_constant",
	Tag:           "bytes,185324357,opt,name=beam_constant",
	Filename:      "beam_runner_api.proto",
}

func init() {
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.BeamConstants_Constants", BeamConstants_Constants_name, BeamConstants_Constants_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardPTransforms_Primitives", StandardPTransforms_Primitives_name, StandardPTransforms_Primitives_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardPTransforms_DeprecatedPrimitives", StandardPTransforms_DeprecatedPrimitives_name, StandardPTransforms_DeprecatedPrimitives_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardPTransforms_Composites", StandardPTransforms_Composites_name, StandardPTransforms_Composites_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardPTransforms_CombineComponents", StandardPTransforms_CombineComponents_name, StandardPTransforms_CombineComponents_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardPTransforms_SplittableParDoComponents", StandardPTransforms_SplittableParDoComponents_name, StandardPTransforms_SplittableParDoComponents_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardSideInputTypes_Enum", StandardSideInputTypes_Enum_name, StandardSideInputTypes_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.Parameter_Type_Enum", Parameter_Type_Enum_name, Parameter_Type_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.IsBounded_Enum", IsBounded_Enum_name, IsBounded_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardCoders_Enum", StandardCoders_Enum_name, StandardCoders_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.MergeStatus_Enum", MergeStatus_Enum_name, MergeStatus_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.AccumulationMode_Enum", AccumulationMode_Enum_name, AccumulationMode_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.ClosingBehavior_Enum", ClosingBehavior_Enum_name, ClosingBehavior_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.OnTimeBehavior_Enum", OnTimeBehavior_Enum_name, OnTimeBehavior_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.OutputTime_Enum", OutputTime_Enum_name, OutputTime_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.TimeDomain_Enum", TimeDomain_Enum_name, TimeDomain_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.StandardEnvironments_Environments", StandardEnvironments_Environments_name, StandardEnvironments_Environments_value)
	proto.RegisterEnum("org.apache.beam.model.pipeline.v1.DisplayData_Type_Enum", DisplayData_Type_Enum_name, DisplayData_Type_Enum_value)
	proto.RegisterType((*BeamConstants)(nil), "org.apache.beam.model.pipeline.v1.BeamConstants")
	proto.RegisterType((*Components)(nil), "org.apache.beam.model.pipeline.v1.Components")
	proto.RegisterMapType((map[string]*Coder)(nil), "org.apache.beam.model.pipeline.v1.Components.CodersEntry")
	proto.RegisterMapType((map[string]*Environment)(nil), "org.apache.beam.model.pipeline.v1.Components.EnvironmentsEntry")
	proto.RegisterMapType((map[string]*PCollection)(nil), "org.apache.beam.model.pipeline.v1.Components.PcollectionsEntry")
	proto.RegisterMapType((map[string]*PTransform)(nil), "org.apache.beam.model.pipeline.v1.Components.TransformsEntry")
	proto.RegisterMapType((map[string]*WindowingStrategy)(nil), "org.apache.beam.model.pipeline.v1.Components.WindowingStrategiesEntry")
	proto.RegisterType((*Pipeline)(nil), "org.apache.beam.model.pipeline.v1.Pipeline")
	proto.RegisterType((*PTransform)(nil), "org.apache.beam.model.pipeline.v1.PTransform")
	proto.RegisterMapType((map[string]string)(nil), "org.apache.beam.model.pipeline.v1.PTransform.InputsEntry")
	proto.RegisterMapType((map[string]string)(nil), "org.apache.beam.model.pipeline.v1.PTransform.OutputsEntry")
	proto.RegisterType((*StandardPTransforms)(nil), "org.apache.beam.model.pipeline.v1.StandardPTransforms")
	proto.RegisterType((*StandardSideInputTypes)(nil), "org.apache.beam.model.pipeline.v1.StandardSideInputTypes")
	proto.RegisterType((*PCollection)(nil), "org.apache.beam.model.pipeline.v1.PCollection")
	proto.RegisterType((*ParDoPayload)(nil), "org.apache.beam.model.pipeline.v1.ParDoPayload")
	proto.RegisterMapType((map[string]*SideInput)(nil), "org.apache.beam.model.pipeline.v1.ParDoPayload.SideInputsEntry")
	proto.RegisterMapType((map[string]*StateSpec)(nil), "org.apache.beam.model.pipeline.v1.ParDoPayload.StateSpecsEntry")
	proto.RegisterMapType((map[string]*TimerSpec)(nil), "org.apache.beam.model.pipeline.v1.ParDoPayload.TimerSpecsEntry")
	proto.RegisterType((*Parameter)(nil), "org.apache.beam.model.pipeline.v1.Parameter")
	proto.RegisterType((*Parameter_Type)(nil), "org.apache.beam.model.pipeline.v1.Parameter.Type")
	proto.RegisterType((*StateSpec)(nil), "org.apache.beam.model.pipeline.v1.StateSpec")
	proto.RegisterType((*ReadModifyWriteStateSpec)(nil), "org.apache.beam.model.pipeline.v1.ReadModifyWriteStateSpec")
	proto.RegisterType((*BagStateSpec)(nil), "org.apache.beam.model.pipeline.v1.BagStateSpec")
	proto.RegisterType((*CombiningStateSpec)(nil), "org.apache.beam.model.pipeline.v1.CombiningStateSpec")
	proto.RegisterType((*MapStateSpec)(nil), "org.apache.beam.model.pipeline.v1.MapStateSpec")
	proto.RegisterType((*SetStateSpec)(nil), "org.apache.beam.model.pipeline.v1.SetStateSpec")
	proto.RegisterType((*TimerSpec)(nil), "org.apache.beam.model.pipeline.v1.TimerSpec")
	proto.RegisterType((*IsBounded)(nil), "org.apache.beam.model.pipeline.v1.IsBounded")
	proto.RegisterType((*ReadPayload)(nil), "org.apache.beam.model.pipeline.v1.ReadPayload")
	proto.RegisterType((*WindowIntoPayload)(nil), "org.apache.beam.model.pipeline.v1.WindowIntoPayload")
	proto.RegisterType((*CombinePayload)(nil), "org.apache.beam.model.pipeline.v1.CombinePayload")
	proto.RegisterType((*TestStreamPayload)(nil), "org.apache.beam.model.pipeline.v1.TestStreamPayload")
	proto.RegisterType((*TestStreamPayload_Event)(nil), "org.apache.beam.model.pipeline.v1.TestStreamPayload.Event")
	proto.RegisterType((*TestStreamPayload_Event_AdvanceWatermark)(nil), "org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceWatermark")
	proto.RegisterType((*TestStreamPayload_Event_AdvanceProcessingTime)(nil), "org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AdvanceProcessingTime")
	proto.RegisterType((*TestStreamPayload_Event_AddElements)(nil), "org.apache.beam.model.pipeline.v1.TestStreamPayload.Event.AddElements")
	proto.RegisterType((*TestStreamPayload_TimestampedElement)(nil), "org.apache.beam.model.pipeline.v1.TestStreamPayload.TimestampedElement")
	proto.RegisterType((*EventsRequest)(nil), "org.apache.beam.model.pipeline.v1.EventsRequest")
	proto.RegisterType((*WriteFilesPayload)(nil), "org.apache.beam.model.pipeline.v1.WriteFilesPayload")
	proto.RegisterMapType((map[string]*SideInput)(nil), "org.apache.beam.model.pipeline.v1.WriteFilesPayload.SideInputsEntry")
	proto.RegisterType((*Coder)(nil), "org.apache.beam.model.pipeline.v1.Coder")
	proto.RegisterType((*StandardCoders)(nil), "org.apache.beam.model.pipeline.v1.StandardCoders")
	proto.RegisterType((*WindowingStrategy)(nil), "org.apache.beam.model.pipeline.v1.WindowingStrategy")
	proto.RegisterType((*MergeStatus)(nil), "org.apache.beam.model.pipeline.v1.MergeStatus")
	proto.RegisterType((*AccumulationMode)(nil), "org.apache.beam.model.pipeline.v1.AccumulationMode")
	proto.RegisterType((*ClosingBehavior)(nil), "org.apache.beam.model.pipeline.v1.ClosingBehavior")
	proto.RegisterType((*OnTimeBehavior)(nil), "org.apache.beam.model.pipeline.v1.OnTimeBehavior")
	proto.RegisterType((*OutputTime)(nil), "org.apache.beam.model.pipeline.v1.OutputTime")
	proto.RegisterType((*TimeDomain)(nil), "org.apache.beam.model.pipeline.v1.TimeDomain")
	proto.RegisterType((*Trigger)(nil), "org.apache.beam.model.pipeline.v1.Trigger")
	proto.RegisterType((*Trigger_AfterAll)(nil), "org.apache.beam.model.pipeline.v1.Trigger.AfterAll")
	proto.RegisterType((*Trigger_AfterAny)(nil), "org.apache.beam.model.pipeline.v1.Trigger.AfterAny")
	proto.RegisterType((*Trigger_AfterEach)(nil), "org.apache.beam.model.pipeline.v1.Trigger.AfterEach")
	proto.RegisterType((*Trigger_AfterEndOfWindow)(nil), "org.apache.beam.model.pipeline.v1.Trigger.AfterEndOfWindow")
	proto.RegisterType((*Trigger_AfterProcessingTime)(nil), "org.apache.beam.model.pipeline.v1.Trigger.AfterProcessingTime")
	proto.RegisterType((*Trigger_AfterSynchronizedProcessingTime)(nil), "org.apache.beam.model.pipeline.v1.Trigger.AfterSynchronizedProcessingTime")
	proto.RegisterType((*Trigger_Default)(nil), "org.apache.beam.model.pipeline.v1.Trigger.Default")
	proto.RegisterType((*Trigger_ElementCount)(nil), "org.apache.beam.model.pipeline.v1.Trigger.ElementCount")
	proto.RegisterType((*Trigger_Never)(nil), "org.apache.beam.model.pipeline.v1.Trigger.Never")
	proto.RegisterType((*Trigger_Always)(nil), "org.apache.beam.model.pipeline.v1.Trigger.Always")
	proto.RegisterType((*Trigger_OrFinally)(nil), "org.apache.beam.model.pipeline.v1.Trigger.OrFinally")
	proto.RegisterType((*Trigger_Repeat)(nil), "org.apache.beam.model.pipeline.v1.Trigger.Repeat")
	proto.RegisterType((*TimestampTransform)(nil), "org.apache.beam.model.pipeline.v1.TimestampTransform")
	proto.RegisterType((*TimestampTransform_Delay)(nil), "org.apache.beam.model.pipeline.v1.TimestampTransform.Delay")
	proto.RegisterType((*TimestampTransform_AlignTo)(nil), "org.apache.beam.model.pipeline.v1.TimestampTransform.AlignTo")
	proto.RegisterType((*SideInput)(nil), "org.apache.beam.model.pipeline.v1.SideInput")
	proto.RegisterType((*WireCoderSetting)(nil), "org.apache.beam.model.pipeline.v1.WireCoderSetting")
	proto.RegisterType((*Environment)(nil), "org.apache.beam.model.pipeline.v1.Environment")
	proto.RegisterType((*StandardEnvironments)(nil), "org.apache.beam.model.pipeline.v1.StandardEnvironments")
	proto.RegisterType((*DockerPayload)(nil), "org.apache.beam.model.pipeline.v1.DockerPayload")
	proto.RegisterType((*ProcessPayload)(nil), "org.apache.beam.model.pipeline.v1.ProcessPayload")
	proto.RegisterMapType((map[string]string)(nil), "org.apache.beam.model.pipeline.v1.ProcessPayload.EnvEntry")
	proto.RegisterType((*ExternalPayload)(nil), "org.apache.beam.model.pipeline.v1.ExternalPayload")
	proto.RegisterMapType((map[string]string)(nil), "org.apache.beam.model.pipeline.v1.ExternalPayload.ParamsEntry")
	proto.RegisterType((*FunctionSpec)(nil), "org.apache.beam.model.pipeline.v1.FunctionSpec")
	proto.RegisterType((*DisplayData)(nil), "org.apache.beam.model.pipeline.v1.DisplayData")
	proto.RegisterType((*DisplayData_Identifier)(nil), "org.apache.beam.model.pipeline.v1.DisplayData.Identifier")
	proto.RegisterType((*DisplayData_Item)(nil), "org.apache.beam.model.pipeline.v1.DisplayData.Item")
	proto.RegisterType((*DisplayData_Type)(nil), "org.apache.beam.model.pipeline.v1.DisplayData.Type")
	proto.RegisterType((*MessageWithComponents)(nil), "org.apache.beam.model.pipeline.v1.MessageWithComponents")
	proto.RegisterType((*ExecutableStagePayload)(nil), "org.apache.beam.model.pipeline.v1.ExecutableStagePayload")
	proto.RegisterType((*ExecutableStagePayload_SideInputId)(nil), "org.apache.beam.model.pipeline.v1.ExecutableStagePayload.SideInputId")
	proto.RegisterType((*ExecutableStagePayload_UserStateId)(nil), "org.apache.beam.model.pipeline.v1.ExecutableStagePayload.UserStateId")
	proto.RegisterType((*ExecutableStagePayload_TimerId)(nil), "org.apache.beam.model.pipeline.v1.ExecutableStagePayload.TimerId")
	proto.RegisterExtension(E_BeamUrn)
	proto.RegisterExtension(E_BeamConstant)
}

func init() { proto.RegisterFile("beam_runner_api.proto", fileDescriptor_cf57597c3a9659a9) }

var fileDescriptor_cf57597c3a9659a9 = []byte{
	// 5243 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x5c, 0xcd, 0x6f, 0x23, 0xc9,
	0x75, 0x17, 0x49, 0xf1, 0xeb, 0x91, 0xa2, 0x7a, 0x4a, 0x9a, 0x59, 0x6d, 0x7b, 0xbd, 0x33, 0xdb,
	0xbb, 0xde, 0x1d, 0x6f, 0xd6, 0xdc, 0x91, 0xb4, 0xb3, 0x3b, 0x23, 0xdb, 0xb3, 0x26, 0xc5, 0xd6,
	0xa8, 0x67, 0xf8, 0xe5, 0x26, 0x25, 0xcd, 0xac, 0xed, 0xed, 0x94, 0xd8, 0x45, 0xa9, 0x31, 0xcd,
	0x6e, 0xba, 0xbb, 0xa9, 0x59, 0x1a, 0x0e, 0x02, 0x04, 0xc1, 0x1e, 0x72, 0x48, 0x90, 0x1c, 0x0c,
	0xe4, 0x14, 0xc0, 0x01, 0x82, 0x24, 0x08, 0x90, 0xc0, 0x4e, 0xf2, 0x07, 0x38, 0xc9, 0x31, 0x01,
	0x02, 0x04, 0x08, 0x90, 0x5b, 0xfe, 0x80, 0x5c, 0x02, 0xf8, 0x90, 0x9c, 0x82, 0xfa, 0xe8, 0x66,
	0x93, 0x92, 0x66, 0x49, 0xcd, 0x20, 0x37, 0xf6, 0xeb, 0x7a, 0xbf, 0x57, 0xf5, 0xaa, 0xea, 0xd5,
	0xab, 0xf7, 0x5e, 0x13, 0xae, 0x1f, 0x13, 0x3c, 0x30, 0xbc, 0x91, 0xe3, 0x10, 0xcf, 0xc0, 0x43,
	0xab, 0x3c, 0xf4, 0xdc, 0xc0, 0x45, 0x6f, 0xb9, 0xde, 0x49, 0x19, 0x0f, 0x71, 0xef, 0x94, 0x94,
	0x69, 0x8b, 0xf2, 0xc0, 0x35, 0x89, 0x5d, 0x1e, 0x5a, 0x43, 0x62, 0x5b, 0x0e, 0x29, 0x9f, 0x6d,
	0xca, 0xab, 0xc4, 0x31, 0x87, 0xae, 0xe5, 0x04, 0x3e, 0xe7, 0x91, 0x5f, 0x3f, 0x71, 0xdd, 0x13,
	0x9b, 0x7c, 0xc8, 0x9e, 0x8e, 0x47, 0xfd, 0x0f, 0xb1, 0x33, 0x16, 0xaf, 0x6e, 0xcd, 0xbe, 0x32,
	0x89, 0xdf, 0xf3, 0xac, 0x61, 0xe0, 0x7a, 0xa2, 0xc5, 0xcd, 0xd9, 0x16, 0x81, 0x35, 0x20, 0x7e,
	0x80, 0x07, 0x43, 0xde, 0x40, 0xf9, 0x55, 0x02, 0x56, 0xaa, 0x04, 0x0f, 0x76, 0x5d, 0xc7, 0x0f,
	0xb0, 0x13, 0xf8, 0xca, 0xdf, 0x24, 0x20, 0x1f, 0x3d, 0xa1, 0x4d, 0x58, 0x6f, 0x68, 0x4d, 0xa3,
	0xab, 0x35, 0xd4, 0x4e, 0xb7, 0xd2, 0x68, 0x1b, 0x0d, 0xad, 0x5e, 0xd7, 0x3a, 0xd2, 0x92, 0xfc,
	0xda, 0x5f, 0xfe, 0xed, 0xff, 0xfe, 0x2a, 0x7d, 0xed, 0x5b, 0xf7, 0xb7, 0xb6, 0xb6, 0xb7, 0x3f,
	0xd9, 0xba, 0xb3, 0xfd, 0xf1, 0xbd, 0xbb, 0x1f, 0x7d, 0xf2, 0xc9, 0x5d, 0x74, 0x07, 0xd6, 0x1b,
	0x95, 0x27, 0xe7, 0x59, 0x12, 0xf2, 0x0d, 0xc6, 0x22, 0x9d, 0xe3, 0x78, 0x00, 0xca, 0xc3, 0x7a,
	0xab, 0x5a, 0xa9, 0x1b, 0x47, 0x5a, 0xb3, 0xd6, 0x3a, 0x32, 0x2e, 0xe4, 0x4f, 0x4e, 0xf3, 0x6f,
	0xde, 0xbf, 0x7b, 0xe7, 0x23, 0xc6, 0xaf, 0xfc, 0x7d, 0x0e, 0x60, 0xd7, 0x1d, 0x0c, 0x5d, 0x87,
	0xd0, 0x3e, 0xff, 0x08, 0x20, 0xf0, 0xb0, 0xe3, 0xf7, 0x5d, 0x6f, 0xe0, 0x6f, 0x24, 0x6e, 0xa5,
	0x6e, 0x17, 0xb6, 0xbe, 0x5b, 0xfe, 0x4a, 0xd5, 0x97, 0x27, 0x10, 0xe5, 0x6e, 0xc4, 0xaf, 0x3a,
	0x81, 0x37, 0xd6, 0x63, 0x80, 0xa8, 0x07, 0xc5, 0x61, 0xcf, 0xb5, 0x6d, 0xd2, 0x0b, 0x2c, 0xd7,
	0xf1, 0x37, 0x92, 0x4c, 0xc0, 0xa7, 0x8b, 0x09, 0x68, 0xc7, 0x10, 0xb8, 0x88, 0x29, 0x50, 0x34,
	0x86, 0xf5, 0xe7, 0x96, 0x63, 0xba, 0xcf, 0x2d, 0xe7, 0xc4, 0xf0, 0x03, 0x0f, 0x07, 0xe4, 0xc4,
	0x22, 0xfe, 0x46, 0x8a, 0x09, 0xdb, 0x5b, 0x4c, 0xd8, 0x51, 0x88, 0xd4, 0x89, 0x80, 0xb8, 0xcc,
	0xb5, 0xe7, 0xe7, 0xdf, 0xa0, 0xef, 0x43, 0xa6, 0xe7, 0x9a, 0xc4, 0xf3, 0x37, 0x96, 0x99, 0xb0,
	0xfb, 0x8b, 0x09, 0xdb, 0x65, 0xbc, 0x1c, 0x5f, 0x00, 0x51, 0x95, 0x11, 0xe7, 0xcc, 0xf2, 0x5c,
	0x67, 0x40, 0xdb, 0x6c, 0xa4, 0xaf, 0xa2, 0x32, 0x35, 0x86, 0x20, 0x54, 0x16, 0x07, 0x95, 0x6d,
	0x58, 0x9d, 0x99, 0x36, 0x24, 0x41, 0xea, 0x19, 0x19, 0x6f, 0x24, 0x6e, 0x25, 0x6e, 0xe7, 0x75,
	0xfa, 0x13, 0xed, 0x42, 0xfa, 0x0c, 0xdb, 0x23, 0xb2, 0x91, 0xbc, 0x95, 0xb8, 0x5d, 0xd8, 0xfa,
	0xd6, 0x1c, 0x5d, 0x68, 0x47, 0xa8, 0x3a, 0xe7, 0xdd, 0x49, 0xde, 0x4b, 0xc8, 0x2e, 0x5c, 0x3b,
	0x37, 0x87, 0x17, 0xc8, 0xab, 0x4d, 0xcb, 0x2b, 0xcf, 0x23, 0x6f, 0x37, 0x82, 0x8d, 0x0b, 0xfc,
	0x29, 0x6c, 0x5c, 0x36, 0x8f, 0x17, 0xc8, 0x7d, 0x34, 0x2d, 0xf7, 0xa3, 0x39, 0xe4, 0xce, 0xa2,
	0x8f, 0xe3, 0xd2, 0x7b, 0x50, 0x88, 0x4d, 0xec, 0x05, 0x02, 0x1f, 0x4c, 0x0b, 0xbc, 0x3d, 0xd7,
	0xdc, 0x9a, 0xc4, 0x9b, 0xd1, 0xe9, 0xb9, 0x49, 0x7e, 0x35, 0x3a, 0x8d, 0xc1, 0xc6, 0x04, 0x2a,
	0xff, 0x91, 0x80, 0x5c, 0x5b, 0x34, 0x43, 0x0d, 0x80, 0x5e, 0xb4, 0xda, 0x98, 0xbc, 0xf9, 0xd6,
	0xc7, 0x64, 0x89, 0xea, 0x31, 0x00, 0xf4, 0x01, 0x20, 0xcf, 0x75, 0x03, 0x23, 0xb2, 0x1c, 0x86,
	0x65, 0x72, 0x63, 0x91, 0xd7, 0x25, 0xfa, 0x26, 0x5a, 0x56, 0x9a, 0x49, 0x37, 0x5d, 0xd1, 0xb4,
	0xfc, 0xa1, 0x8d, 0xc7, 0x86, 0x89, 0x03, 0xbc, 0x91, 0x9a, 0x7b, 0x68, 0x35, 0xce, 0x56, 0xc3,
	0x01, 0xd6, 0x0b, 0xe6, 0xe4, 0x41, 0xf9, 0xc5, 0x32, 0xc0, 0x64, 0xed, 0xa2, 0x9b, 0x50, 0x18,
	0x39, 0xd6, 0x8f, 0x47, 0xc4, 0x70, 0xf0, 0x80, 0x6c, 0xa4, 0x99, 0x3e, 0x81, 0x93, 0x9a, 0x78,
	0x40, 0xd0, 0x2e, 0x2c, 0xfb, 0x43, 0xd2, 0x13, 0x23, 0xff, 0x70, 0x0e, 0xd1, 0x7b, 0x23, 0x87,
	0x2d, 0xd3, 0xce, 0x90, 0xf4, 0x74, 0xc6, 0x8c, 0xde, 0x81, 0x15, 0x7f, 0x74, 0x1c, 0x33, 0xbf,
	0x7c, 0xc0, 0xd3, 0x44, 0x6a, 0x62, 0x2c, 0x67, 0x38, 0x0a, 0x42, 0x7b, 0x76, 0x7f, 0xa1, 0x6d,
	0x58, 0xd6, 0x18, 0xaf, 0x30, 0x31, 0x1c, 0x08, 0x75, 0x21, 0xeb, 0x8e, 0x02, 0x86, 0xc9, 0xcd,
	0xd6, 0xce, 0x62, 0x98, 0x2d, 0xce, 0xcc, 0x41, 0x43, 0xa8, 0x73, 0xd3, 0x92, 0x79, 0xe9, 0x69,
	0x41, 0xdf, 0x80, 0x52, 0xcc, 0x6c, 0x19, 0x96, 0xb9, 0x91, 0x65, 0x53, 0xb1, 0x12, 0xa3, 0x6a,
	0xa6, 0x7c, 0x1f, 0x0a, 0xb1, 0x61, 0x5e, 0xb0, 0x0b, 0xd6, 0xe3, 0xbb, 0x20, 0x1f, 0xdf, 0x46,
	0x3b, 0x50, 0x8c, 0x8f, 0x66, 0x11, 0x5e, 0xe5, 0xef, 0x56, 0x60, 0xad, 0x13, 0x60, 0xc7, 0xc4,
	0x9e, 0x39, 0xd1, 0x8e, 0xaf, 0xfc, 0x45, 0x0a, 0xa0, 0xed, 0x59, 0x03, 0x2b, 0xb0, 0xce, 0x88,
	0x8f, 0xbe, 0x09, 0x99, 0x76, 0x45, 0x37, 0x6a, 0x2d, 0x69, 0x49, 0xfe, 0xfa, 0xcf, 0xe9, 0xa9,
	0xfc, 0x1a, 0xd5, 0xc3, 0x4e, 0x34, 0xc7, 0x3b, 0x43, 0xec, 0x99, 0xee, 0xce, 0xd9, 0x26, 0xfa,
	0x00, 0xb2, 0x7b, 0xf5, 0x4a, 0xb7, 0xab, 0x36, 0xa5, 0x84, 0x7c, 0x93, 0xb5, 0x7d, 0x7d, 0xa6,
	0x6d, 0xdf, 0xc6, 0x41, 0x40, 0x1c, 0xda, 0xfa, 0x63, 0x28, 0x3e, 0xd4, 0x5b, 0x07, 0x6d, 0xa3,
	0xfa, 0xd4, 0x78, 0xac, 0x3e, 0x95, 0x92, 0xf2, 0x3b, 0x8c, 0xe5, 0xcd, 0x19, 0x96, 0x13, 0xcf,
	0x1d, 0x0d, 0x8d, 0xe3, 0xb1, 0xf1, 0x8c, 0x8c, 0x85, 0x14, 0xad, 0xd1, 0x3e, 0xa8, 0x77, 0x54,
	0x29, 0x75, 0x89, 0x14, 0x6b, 0x30, 0x1c, 0xd9, 0x3e, 0xa1, 0xad, 0x3f, 0x81, 0x52, 0xa5, 0xd3,
	0xd1, 0x1e, 0x36, 0x85, 0xc3, 0xd1, 0x91, 0x96, 0xe5, 0xb7, 0x19, 0xd3, 0xd7, 0x67, 0x98, 0xf8,
	0x01, 0x69, 0x58, 0x4e, 0xc0, 0x06, 0xb3, 0x0d, 0x85, 0xae, 0xda, 0xe9, 0x1a, 0x9d, 0xae, 0xae,
	0x56, 0x1a, 0x52, 0x5a, 0x56, 0x18, 0xd7, 0x1b, 0x33, 0x5c, 0x01, 0xf1, 0x03, 0x3f, 0xf0, 0x28,
	0xf1, 0x6c, 0x13, 0x7d, 0x04, 0x85, 0x46, 0xa5, 0x1d, 0x89, 0xca, 0x5c, 0x22, 0x6a, 0x80, 0x87,
	0x06, 0x17, 0xe7, 0x53, 0xae, 0x7b, 0xb0, 0xd2, 0x50, 0xf5, 0x87, 0x6a, 0xc4, 0x97, 0x95, 0xbf,
	0xc1, 0xf8, 0x6e, 0xce, 0xf2, 0x11, 0xef, 0x84, 0xc4, 0x38, 0x95, 0x00, 0xd6, 0x6b, 0x64, 0xe8,
	0x91, 0x1e, 0x0e, 0x88, 0x19, 0x9b, 0xb4, 0x77, 0x61, 0x59, 0x57, 0x2b, 0x35, 0x69, 0x49, 0x7e,
	0x83, 0x01, 0xdd, 0x98, 0x01, 0xf2, 0x08, 0x36, 0x45, 0x7f, 0x77, 0x75, 0xb5, 0xd2, 0x55, 0x8d,
	0x43, 0x4d, 0x3d, 0x92, 0x12, 0x97, 0xf4, 0xb7, 0xe7, 0x11, 0x1c, 0x10, 0xe3, 0xcc, 0x22, 0xcf,
	0xa9, 0xd4, 0xff, 0x4e, 0x08, 0x27, 0xcc, 0xb7, 0x02, 0xe2, 0xa3, 0xef, 0xc0, 0xea, 0x6e, 0xab,
	0x51, 0xd5, 0x9a, 0xaa, 0xd1, 0x56, 0x75, 0x36, 0x97, 0x4b, 0xf2, 0x7b, 0x0c, 0xe8, 0xad, 0x59,
	0x20, 0x77, 0x70, 0x6c, 0x39, 0xc4, 0x18, 0x12, 0x2f, 0x9c, 0xce, 0x07, 0x20, 0x85, 0xdc, 0xdc,
	0x33, 0xac, 0x3f, 0x95, 0x12, 0xf2, 0x6d, 0xc6, 0xae, 0x5c, 0xc2, 0x7e, 0x62, 0xbb, 0xc7, 0xd8,
	0xb6, 0x19, 0xff, 0x1d, 0xc8, 0xeb, 0x6a, 0x67, 0xff, 0x60, 0x6f, 0xaf, 0xae, 0x4a, 0x49, 0xf9,
	0x2d, 0xc6, 0xf8, 0xb5, 0x73, 0xe3, 0xf5, 0x4f, 0x47, 0xfd, 0xbe, 0x4d, 0xc4, 0xa0, 0x8f, 0x74,
	0xad, 0xab, 0x1a, 0x7b, 0x5a, 0x5d, 0xed, 0x48, 0xa9, 0xcb, 0xd6, 0x83, 0x67, 0x05, 0xc4, 0xe8,
	0x5b, 0x36, 0x61, 0xaa, 0xfe, 0x75, 0x12, 0xae, 0xed, 0x72, 0xf9, 0x31, 0x07, 0x54, 0x07, 0x79,
	0x66, 0xec, 0x46, 0x5b, 0x57, 0x05, 0x49, 0x5a, 0x92, 0xb7, 0x18, 0xf4, 0x07, 0x2f, 0x56, 0x83,
	0x41, 0x67, 0x90, 0x93, 0x68, 0xff, 0x8e, 0x41, 0x99, 0xc5, 0xe4, 0xcb, 0xa3, 0xb2, 0xbb, 0x7b,
	0xd0, 0x38, 0xa8, 0x57, 0xba, 0x2d, 0x9d, 0xfa, 0xd8, 0x3b, 0x0c, 0xfb, 0xa3, 0xaf, 0xc0, 0xe6,
	0x6b, 0x06, 0xf7, 0x7a, 0xa3, 0xc1, 0xc8, 0xc6, 0x81, 0xeb, 0xb1, 0x25, 0xf7, 0x43, 0xb8, 0x39,
	0x2b, 0x43, 0x7d, 0xd2, 0xd5, 0x2b, 0xbb, 0x5d, 0xa3, 0x75, 0xd0, 0x6d, 0x1f, 0x74, 0xa9, 0x13,
	0xfe, 0x09, 0x13, 0xb0, 0xf9, 0x15, 0x02, 0xc8, 0x17, 0x81, 0x87, 0x7b, 0x81, 0x21, 0x0c, 0x29,
	0x45, 0x7f, 0x04, 0x37, 0xa2, 0x39, 0xa5, 0x5b, 0x5c, 0xad, 0x19, 0x87, 0x95, 0xfa, 0x01, 0x53,
	0x76, 0x99, 0x81, 0xde, 0xbe, 0x6c, 0x66, 0xe9, 0x66, 0x27, 0xa6, 0xc1, 0xcc, 0x14, 0xd3, 0xfb,
	0xef, 0x2f, 0xc3, 0xeb, 0x9d, 0xa1, 0x6d, 0x05, 0x01, 0x3e, 0xb6, 0x49, 0x1b, 0x7b, 0x35, 0x37,
	0xa6, 0xff, 0x3a, 0x5c, 0x6f, 0x57, 0x34, 0xdd, 0x38, 0xd2, 0xba, 0xfb, 0x86, 0xae, 0x76, 0xba,
	0xba, 0xb6, 0xdb, 0xd5, 0x5a, 0x4d, 0x69, 0x49, 0xde, 0x64, 0x82, 0x7e, 0x63, 0x46, 0x90, 0x6f,
	0xf6, 0x8d, 0x21, 0xb6, 0x3c, 0xe3, 0xb9, 0x15, 0x9c, 0x1a, 0x1e, 0xf1, 0x03, 0xcf, 0x62, 0x27,
	0x1b, 0xed, 0x77, 0x0d, 0xae, 0x75, 0xda, 0x75, 0xad, 0x3b, 0x85, 0x94, 0x90, 0xbf, 0xc5, 0x90,
	0xde, 0xbb, 0x00, 0xc9, 0xa7, 0x1d, 0x9b, 0x45, 0x69, 0xc2, 0x8d, 0xb6, 0xde, 0xda, 0x55, 0x3b,
	0x1d, 0xaa, 0x57, 0xb5, 0x66, 0xa8, 0x75, 0xb5, 0xa1, 0x36, 0x99, 0x4a, 0x2f, 0x5e, 0x0f, 0xac,
	0x53, 0x9e, 0xdb, 0x23, 0xbe, 0x4f, 0x55, 0x4a, 0x4c, 0x83, 0xd8, 0x84, 0x39, 0x46, 0x14, 0xaf,
	0x0a, 0x52, 0x88, 0x17, 0x21, 0xa5, 0xe4, 0x0f, 0x18, 0xd2, 0xbb, 0x2f, 0x40, 0x8a, 0x63, 0x3c,
	0x81, 0xaf, 0xf1, 0x91, 0x55, 0x9a, 0x35, 0xa3, 0xa3, 0x7d, 0xa6, 0xc6, 0x87, 0x48, 0x6d, 0xe2,
	0xc5, 0x73, 0x3d, 0x19, 0x23, 0x76, 0x4c, 0xc3, 0xb7, 0x7e, 0x42, 0xe2, 0x83, 0x65, 0xc8, 0x2e,
	0xbc, 0x17, 0xf6, 0x8e, 0xe2, 0x4e, 0x46, 0xcb, 0x44, 0x4d, 0x49, 0x49, 0xcb, 0x55, 0x26, 0xe5,
	0x3b, 0x2f, 0xe8, 0x34, 0x95, 0x11, 0x0d, 0x9f, 0x49, 0x9d, 0x11, 0xa8, 0xfc, 0x4e, 0x02, 0x6e,
	0x84, 0xe7, 0x56, 0xc7, 0x32, 0x09, 0x3b, 0x3b, 0xbb, 0xe3, 0x21, 0xf1, 0x95, 0x53, 0x58, 0x56,
	0x9d, 0xd1, 0x00, 0x7d, 0x08, 0x39, 0xad, 0xab, 0xea, 0x95, 0x6a, 0x9d, 0xee, 0xc1, 0xb8, 0x49,
	0xf0, 0x2d, 0x93, 0x18, 0xcc, 0x8f, 0xd8, 0xb1, 0x02, 0xe2, 0xd1, 0x25, 0x45, 0x07, 0xf1, 0x21,
	0xe4, 0x1a, 0x07, 0xf5, 0xae, 0xd6, 0xa8, 0xb4, 0xa5, 0xc4, 0x65, 0x0c, 0x83, 0x91, 0x1d, 0x58,
	0x03, 0x3c, 0xa4, 0x9d, 0xf8, 0x79, 0x12, 0x0a, 0x31, 0xef, 0x7d, 0xd6, 0xe5, 0x4a, 0x9c, 0x73,
	0xb9, 0x5e, 0x87, 0x1c, 0xbb, 0x21, 0x51, 0x2f, 0x80, 0x1f, 0xc5, 0x59, 0xf6, 0xac, 0x99, 0xa8,
	0x0d, 0x60, 0xf9, 0xc6, 0xb1, 0x3b, 0x72, 0x4c, 0x62, 0x32, 0x77, 0xb0, 0xb4, 0xb5, 0x39, 0x87,
	0xdf, 0xa1, 0xf9, 0x55, 0xce, 0x53, 0xa6, 0x83, 0xd6, 0xf3, 0x56, 0xf8, 0x8c, 0xb6, 0xe0, 0xfa,
	0xb9, 0x2b, 0xe5, 0x98, 0x4a, 0x5e, 0x66, 0x92, 0xcf, 0xdd, 0x05, 0xc7, 0x9a, 0x79, 0xce, 0xff,
	0x49, 0xbf, 0xbc, 0x5b, 0xfa, 0xb3, 0x2c, 0x14, 0xd9, 0x86, 0x6d, 0xe3, 0xb1, 0xed, 0x62, 0x93,
	0xba, 0xf3, 0xa6, 0x6b, 0xf4, 0x9d, 0x2b, 0x3b, 0x9e, 0xa6, 0xbb, 0xe7, 0xa0, 0x3a, 0xc0, 0x10,
	0x7b, 0x78, 0x40, 0x02, 0x7a, 0x73, 0xe5, 0x77, 0xf2, 0x0f, 0xe6, 0x71, 0x01, 0x43, 0x26, 0x3d,
	0xc6, 0x8f, 0x7e, 0x13, 0x0a, 0x93, 0x39, 0x0e, 0xbd, 0xd4, 0x4f, 0xe7, 0x83, 0x8b, 0x46, 0x56,
	0x8e, 0x16, 0x62, 0x18, 0x45, 0xf0, 0x23, 0x02, 0x93, 0x10, 0xd0, 0xf3, 0x93, 0xba, 0xcd, 0xa1,
	0xcf, 0xba, 0xb8, 0x04, 0x0a, 0x41, 0xb5, 0x10, 0x49, 0x88, 0x08, 0x54, 0x42, 0x60, 0x0d, 0x88,
	0x27, 0x24, 0xa4, 0xaf, 0x26, 0xa1, 0x4b, 0x21, 0xe2, 0x12, 0x82, 0x88, 0x80, 0xde, 0x04, 0xf0,
	0x23, 0x23, 0xcc, 0x7c, 0xe3, 0x9c, 0x1e, 0xa3, 0xa0, 0x3b, 0xb0, 0x1e, 0xdb, 0xa7, 0x46, 0xb4,
	0xd4, 0xb9, 0xc3, 0x8b, 0x62, 0xef, 0x76, 0xc5, 0xaa, 0xdf, 0x86, 0xeb, 0x1e, 0xf9, 0xf1, 0x88,
	0xba, 0x4f, 0x46, 0xdf, 0x72, 0xb0, 0x6d, 0xfd, 0x04, 0xd3, 0xf7, 0x1b, 0x39, 0x06, 0xbe, 0x1e,
	0xbe, 0xdc, 0x8b, 0xbd, 0x93, 0x9f, 0xc1, 0xea, 0x8c, 0xa6, 0x2f, 0x70, 0x79, 0xab, 0xd3, 0x97,
	0xc6, 0x79, 0x96, 0x46, 0x04, 0x1a, 0x77, 0xae, 0xa9, 0xb0, 0x69, 0xa5, 0xbf, 0x22, 0x61, 0x21,
	0xe8, 0x8c, 0xb0, 0x19, 0xfd, 0xbf, 0x1a, 0x61, 0x11, 0x68, 0xdc, 0xf5, 0xff, 0x65, 0x02, 0xf2,
	0xd1, 0x6e, 0x40, 0x8f, 0x60, 0x39, 0x18, 0x0f, 0xb9, 0xd1, 0x2a, 0x6d, 0x7d, 0xbc, 0xc8, 0x4e,
	0x2a, 0x53, 0xbb, 0xcb, 0xcd, 0x0f, 0xc3, 0x90, 0x3f, 0x83, 0x65, 0x4a, 0x52, 0x74, 0x61, 0x89,
	0x57, 0xa1, 0x70, 0xd0, 0xec, 0xb4, 0xd5, 0x5d, 0x6d, 0x4f, 0x53, 0x6b, 0xd2, 0x12, 0x02, 0xc8,
	0x70, 0x2f, 0x57, 0x4a, 0xa0, 0x75, 0x90, 0xda, 0x5a, 0x5b, 0xad, 0x53, 0x3f, 0xa1, 0xd5, 0xe6,
	0x67, 0x44, 0x12, 0xbd, 0x06, 0x6b, 0xb1, 0x53, 0xc3, 0xa0, 0x4e, 0xc9, 0x63, 0x55, 0x97, 0x52,
	0xca, 0xbf, 0xa6, 0x20, 0x1f, 0xe9, 0x0e, 0x79, 0x70, 0x83, 0x7a, 0xb1, 0xc6, 0xc0, 0x35, 0xad,
	0xfe, 0xd8, 0xe0, 0xde, 0x5a, 0xec, 0x56, 0xfb, 0xed, 0x39, 0xc6, 0xa1, 0x13, 0x6c, 0x36, 0x18,
	0xff, 0x11, 0x65, 0x8f, 0xc0, 0xf7, 0x97, 0xf4, 0x35, 0x6f, 0xe6, 0x1d, 0x95, 0x59, 0x87, 0xdc,
	0x31, 0x3e, 0xe1, 0x52, 0x92, 0x73, 0x9b, 0xb0, 0x2a, 0x3e, 0x89, 0x23, 0x67, 0x8f, 0xf1, 0x09,
	0x43, 0xfb, 0x1c, 0x4a, 0xdc, 0xed, 0x61, 0x56, 0x9a, 0x62, 0xf2, 0x50, 0xc0, 0xdd, 0xf9, 0x22,
	0x11, 0x9c, 0x31, 0x8e, 0xbc, 0x12, 0xc1, 0x85, 0xbd, 0xa5, 0x17, 0x0d, 0x86, 0xbc, 0x3c, 0x77,
	0x6f, 0x1b, 0x78, 0x38, 0xd5, 0xdb, 0x01, 0x1e, 0x86, 0x68, 0x3e, 0x09, 0x38, 0x5a, 0x7a, 0x6e,
	0xb4, 0x0e, 0x09, 0xa6, 0xd0, 0x7c, 0x12, 0xd0, 0x9f, 0xd5, 0x0c, 0x8f, 0x40, 0x28, 0x77, 0x61,
	0xe3, 0xb2, 0x49, 0x98, 0x3a, 0x32, 0x13, 0x53, 0x47, 0xa6, 0x72, 0x0f, 0x8a, 0x71, 0xad, 0xa2,
	0xdb, 0x20, 0x85, 0x2e, 0xc3, 0x0c, 0x4b, 0x49, 0xd0, 0x85, 0xd9, 0x51, 0x7e, 0x96, 0x00, 0x74,
	0x5e, 0x79, 0xd4, 0x7e, 0xc5, 0x5c, 0xe4, 0x59, 0x10, 0x14, 0x7b, 0x17, 0xda, 0xaf, 0x26, 0x8b,
	0x21, 0x31, 0xa7, 0xb5, 0xef, 0x2c, 0xb0, 0x1a, 0xa6, 0x0e, 0xb4, 0xbc, 0x80, 0xd8, 0x73, 0x94,
	0x43, 0x28, 0xc6, 0x55, 0x8f, 0x6e, 0x41, 0x91, 0x7a, 0xd7, 0x33, 0x3d, 0x81, 0x67, 0x64, 0x1c,
	0xf6, 0xe0, 0x1d, 0x28, 0xb1, 0x2d, 0x6d, 0xcc, 0x38, 0x16, 0x45, 0x46, 0xdd, 0x9d, 0xa8, 0x2a,
	0x3e, 0x09, 0x0b, 0xa8, 0xea, 0xcb, 0x04, 0xe4, 0x23, 0xf3, 0x81, 0x3a, 0xfc, 0x8c, 0x31, 0x4c,
	0x77, 0x80, 0x2d, 0x47, 0x18, 0x8b, 0xad, 0x39, 0x2d, 0x50, 0x8d, 0x31, 0x71, 0x43, 0xc1, 0x8e,
	0x15, 0x4e, 0xa0, 0x43, 0xe0, 0x07, 0xd7, 0xec, 0x10, 0x18, 0x35, 0xec, 0xc8, 0xf7, 0x20, 0x1f,
	0xf9, 0x3a, 0xca, 0xf6, 0x65, 0x96, 0x65, 0x05, 0xf2, 0x07, 0xcd, 0x6a, 0xeb, 0xa0, 0x59, 0x53,
	0x6b, 0x52, 0x02, 0x15, 0x20, 0x1b, 0x3e, 0x24, 0x95, 0x3f, 0x4f, 0x40, 0x81, 0xae, 0xb3, 0xd0,
	0x11, 0x79, 0x08, 0x19, 0xdf, 0x1d, 0x79, 0x3d, 0x72, 0x55, 0x4f, 0x44, 0xb0, 0xcf, 0xf8, 0x6e,
	0xc9, 0x97, 0xf7, 0xdd, 0x14, 0x0c, 0xd7, 0x78, 0x78, 0x56, 0x73, 0x82, 0xc8, 0x71, 0xaa, 0x43,
	0x5e, 0x84, 0x27, 0xae, 0xee, 0x3c, 0xe5, 0x38, 0xc2, 0x9e, 0xa3, 0xfc, 0x51, 0x02, 0x4a, 0xe2,
	0x2a, 0x1b, 0x0a, 0x98, 0x5e, 0xcd, 0x89, 0x97, 0x5d, 0xcd, 0x97, 0xee, 0xa7, 0xe4, 0x65, 0xfb,
	0x49, 0xf9, 0xe7, 0x2c, 0x5c, 0xeb, 0x12, 0x3f, 0xe8, 0xb0, 0x60, 0x4a, 0xd8, 0xaf, 0xcb, 0x6d,
	0x00, 0xd2, 0x21, 0x43, 0xce, 0x58, 0x00, 0x37, 0x39, 0x77, 0x14, 0xf0, 0x9c, 0x80, 0xb2, 0x4a,
	0x21, 0x74, 0x81, 0x84, 0x3a, 0x90, 0x0b, 0x93, 0x72, 0xc2, 0x18, 0x7f, 0x32, 0x07, 0x6a, 0x65,
	0x68, 0x75, 0x88, 0x77, 0x66, 0xf5, 0x48, 0x2d, 0xca, 0xca, 0xe9, 0x11, 0x90, 0xfc, 0xb3, 0x34,
	0xa4, 0x99, 0x18, 0x74, 0x06, 0xab, 0xcf, 0x71, 0x40, 0xbc, 0x01, 0xf6, 0x9e, 0x19, 0x4c, 0xa4,
	0x50, 0xf5, 0xe3, 0xab, 0xf7, 0xbd, 0x5c, 0x31, 0xcf, 0xb0, 0xd3, 0x23, 0x47, 0x21, 0xf0, 0xfe,
	0x92, 0x5e, 0x8a, 0xa4, 0x70, 0xb9, 0x5f, 0x26, 0xe0, 0xba, 0xb8, 0x60, 0xd1, 0xb3, 0x86, 0xed,
	0x63, 0x2e, 0x9e, 0xdb, 0xad, 0xf6, 0xcb, 0x8b, 0x6f, 0x47, 0xf0, 0x74, 0xbf, 0xd3, 0x03, 0x74,
	0x38, 0x45, 0xe1, 0x1d, 0x19, 0xc0, 0x4a, 0x68, 0x7c, 0xb8, 0x7c, 0xae, 0xe4, 0xbd, 0x97, 0x92,
	0x6f, 0xaa, 0xe2, 0xa2, 0xbb, 0xbf, 0xa4, 0x17, 0x05, 0x3c, 0x7b, 0x27, 0x6b, 0x20, 0xcd, 0x6a,
	0x07, 0xbd, 0x0d, 0x2b, 0x0e, 0x79, 0x6e, 0x44, 0x1a, 0x62, 0x33, 0x90, 0xd2, 0x8b, 0x0e, 0x79,
	0x3e, 0x69, 0x24, 0x41, 0x2a, 0xc0, 0x27, 0x62, 0xb5, 0xd2, 0x9f, 0x72, 0x15, 0xae, 0x5f, 0x38,
	0x52, 0xf4, 0x4d, 0x90, 0x30, 0x7f, 0x61, 0x98, 0x23, 0x8f, 0xbb, 0xb0, 0x1c, 0x72, 0x55, 0xd0,
	0x6b, 0x82, 0x2c, 0xff, 0x6e, 0x02, 0x0a, 0xb1, 0xee, 0xa2, 0x1e, 0xe4, 0xc2, 0x3b, 0xba, 0xc8,
	0x5d, 0x3e, 0xbc, 0x92, 0x22, 0xba, 0x61, 0xa6, 0x97, 0x84, 0xd8, 0x7a, 0x04, 0x1c, 0x0e, 0x25,
	0x15, 0x0d, 0xa5, 0x9a, 0x85, 0x34, 0x53, 0xbe, 0xfc, 0x03, 0x40, 0xe7, 0x59, 0xd1, 0x7b, 0xb0,
	0x4a, 0x1c, 0xba, 0xc9, 0xa2, 0x6b, 0x38, 0x1b, 0x4f, 0x51, 0x2f, 0x09, 0x72, 0xd8, 0xf0, 0x0d,
	0xc8, 0x47, 0x39, 0x66, 0xa6, 0xaa, 0x94, 0x3e, 0x21, 0x28, 0xab, 0xb0, 0xc2, 0x26, 0xc1, 0xd7,
	0xb9, 0x23, 0xaf, 0xfc, 0x57, 0x0a, 0xae, 0xb1, 0x13, 0x7e, 0xcf, 0xb2, 0x89, 0x1f, 0x6e, 0xf0,
	0x5d, 0x58, 0xf6, 0x2d, 0xe7, 0xd9, 0xd5, 0x53, 0x11, 0x96, 0xf3, 0x0c, 0x3d, 0x81, 0xd5, 0xbe,
	0xeb, 0x0d, 0x70, 0x60, 0xf4, 0xc5, 0xcb, 0xab, 0x1e, 0xc8, 0x25, 0x8e, 0x13, 0xd2, 0xa8, 0x32,
	0xb8, 0xd9, 0x24, 0x26, 0x77, 0x31, 0x7d, 0xa6, 0xc9, 0x9c, 0x5e, 0x0a, 0xc9, 0x6c, 0x48, 0x3e,
	0xfa, 0x0e, 0xc8, 0xa2, 0x06, 0xc0, 0xa4, 0x8e, 0xf1, 0xc0, 0x72, 0x88, 0x69, 0xf8, 0xa7, 0xd8,
	0x33, 0x2d, 0xe7, 0x84, 0xb9, 0x5f, 0x39, 0x7d, 0x83, 0xb7, 0xa8, 0x45, 0x0d, 0x3a, 0xe2, 0x3d,
	0x22, 0xd3, 0x97, 0x50, 0x7e, 0x81, 0xab, 0xcd, 0x93, 0xc9, 0x9b, 0x55, 0xe8, 0x8b, 0x6e, 0xa2,
	0xff, 0xaf, 0xd7, 0x27, 0xe5, 0xa7, 0x90, 0x66, 0xb6, 0xfd, 0xd5, 0x64, 0x9b, 0xca, 0xb0, 0x16,
	0x65, 0xdc, 0xa2, 0xe3, 0x24, 0xcc, 0x39, 0x5d, 0x8b, 0x5e, 0x89, 0xd3, 0xc4, 0x57, 0xfe, 0x33,
	0x0d, 0xa5, 0x30, 0x4a, 0xc4, 0xd3, 0x99, 0xca, 0xbf, 0xa4, 0x85, 0xeb, 0xf0, 0x0e, 0xa4, 0xab,
	0x4f, 0xbb, 0x6a, 0x47, 0x5a, 0x92, 0x5f, 0x67, 0xa1, 0x9e, 0x35, 0x16, 0xea, 0x61, 0xa8, 0x3b,
	0xc7, 0xe3, 0x80, 0x05, 0x1e, 0xd1, 0x1d, 0x28, 0xd0, 0x5b, 0x48, 0xf3, 0xa1, 0x71, 0xd0, 0xdd,
	0xbb, 0x27, 0xc1, 0x54, 0xae, 0x81, 0xb7, 0xa5, 0x97, 0x5a, 0xe7, 0xc4, 0x18, 0x05, 0xfd, 0x7b,
	0x94, 0xe3, 0x4d, 0x48, 0x3e, 0x3e, 0x94, 0x12, 0xf2, 0x0d, 0xd6, 0x50, 0x8a, 0x35, 0x7c, 0x76,
	0x46, 0xdf, 0x2b, 0xb0, 0x5c, 0x6d, 0xb5, 0xea, 0x52, 0x51, 0xde, 0x60, 0x2d, 0x50, 0x5c, 0xac,
	0xeb, 0xda, 0xb4, 0xcd, 0xbb, 0x90, 0x39, 0xac, 0xe8, 0x5a, 0xb3, 0x2b, 0x25, 0x65, 0x99, 0xb5,
	0x5a, 0x8f, 0xb5, 0x3a, 0xc3, 0x9e, 0xe5, 0x04, 0xa2, 0x5d, 0xad, 0x75, 0x50, 0xad, 0xab, 0x52,
	0xe1, 0x82, 0x76, 0xa6, 0x3b, 0x12, 0x91, 0xad, 0xf7, 0x63, 0xa1, 0xb0, 0xd4, 0x54, 0x36, 0x80,
	0xb7, 0x8c, 0x47, 0xc1, 0xde, 0x81, 0x74, 0x57, 0x6b, 0xa8, 0xba, 0xb4, 0x7c, 0x81, 0x5e, 0x98,
	0x47, 0xc6, 0xb3, 0x15, 0xab, 0x5a, 0xb3, 0xab, 0xea, 0x87, 0x51, 0x11, 0x87, 0x94, 0x9e, 0x0a,
	0xa1, 0x0b, 0x60, 0x27, 0x20, 0xde, 0x19, 0xb6, 0x45, 0xba, 0x82, 0x07, 0xde, 0x57, 0xea, 0x6a,
	0xf3, 0x61, 0x77, 0xdf, 0x68, 0xeb, 0xea, 0x9e, 0xf6, 0x44, 0xca, 0x4c, 0x85, 0xda, 0x38, 0x9f,
	0x4d, 0x9c, 0x93, 0xe0, 0xd4, 0x18, 0x7a, 0xa4, 0x6f, 0x7d, 0x21, 0xb8, 0xa6, 0x4a, 0x46, 0xa4,
	0xec, 0x05, 0x5c, 0x3c, 0x23, 0x10, 0x93, 0xf5, 0x31, 0x94, 0x78, 0xf3, 0x30, 0xf6, 0x2c, 0xe5,
	0xa6, 0x32, 0x38, 0x9c, 0x2d, 0xda, 0xdb, 0x7c, 0xd9, 0xb2, 0x60, 0xeb, 0x7a, 0xbb, 0xa2, 0x57,
	0x1a, 0xc6, 0x0c, 0x77, 0x69, 0x2a, 0x25, 0xc1, 0xb9, 0x59, 0x14, 0xc9, 0x38, 0x8f, 0x51, 0x83,
	0xeb, 0x9d, 0x6e, 0xa5, 0xab, 0x1a, 0x55, 0x7a, 0x75, 0xad, 0x19, 0xd1, 0x04, 0xe4, 0xe5, 0x6f,
	0x32, 0x90, 0xb7, 0xa7, 0xd6, 0x10, 0x0e, 0x88, 0x71, 0x8c, 0x7b, 0xcf, 0x88, 0x69, 0xc4, 0x67,
	0xe3, 0x16, 0xa4, 0xf4, 0xd6, 0x91, 0xb4, 0x22, 0xbf, 0xc6, 0x78, 0xae, 0xc5, 0x78, 0x3c, 0x36,
	0x46, 0xe5, 0xaf, 0x32, 0xa1, 0xaf, 0x18, 0x0b, 0xe5, 0xbd, 0x5a, 0x5f, 0x11, 0x1d, 0x42, 0x91,
	0x67, 0x10, 0x68, 0x3f, 0x47, 0xbe, 0x70, 0x71, 0xb7, 0xe7, 0xb9, 0x48, 0x52, 0xb6, 0x0e, 0xe3,
	0xe2, 0x4e, 0x6e, 0x61, 0x30, 0xa1, 0xa0, 0x77, 0x43, 0xc3, 0x3a, 0xf1, 0x0d, 0xf9, 0x11, 0xb5,
	0xc2, 0xc9, 0xe1, 0x25, 0xa7, 0x06, 0xd9, 0xc0, 0xb3, 0x4e, 0x4e, 0x88, 0x27, 0xee, 0xb0, 0xef,
	0xcf, 0x73, 0x44, 0x72, 0x0e, 0x3d, 0x64, 0x45, 0x04, 0xae, 0x45, 0x2e, 0xa7, 0xe5, 0x3a, 0x06,
	0x65, 0x61, 0xb7, 0xd8, 0xd2, 0xd6, 0xbd, 0x79, 0x1c, 0xbc, 0x18, 0x6f, 0xc3, 0x35, 0x45, 0xc4,
	0x43, 0xc2, 0x33, 0x64, 0x7a, 0x47, 0xe2, 0x59, 0x10, 0xe6, 0x62, 0xb1, 0x30, 0xd9, 0x7c, 0x77,
	0x24, 0x9e, 0xc4, 0xa5, 0x87, 0xb1, 0xb8, 0x23, 0xb9, 0x11, 0x01, 0x1d, 0x83, 0xd4, 0xb3, 0x5d,
	0xe6, 0xb8, 0x1d, 0x93, 0x53, 0x7c, 0x66, 0xb9, 0x1e, 0x0b, 0xab, 0x95, 0xe6, 0xf2, 0x4d, 0x77,
	0x39, 0x6b, 0x55, 0x70, 0x72, 0xf8, 0xd5, 0xde, 0x34, 0x95, 0x39, 0x31, 0xb6, 0xcd, 0x56, 0xb1,
	0x8d, 0x03, 0xe2, 0x10, 0xdf, 0x67, 0x71, 0x38, 0xea, 0xc4, 0x70, 0x7a, 0x5d, 0x90, 0xd1, 0xe7,
	0x50, 0x6a, 0x39, 0xb4, 0x63, 0x21, 0xf3, 0x46, 0x7e, 0xee, 0xb8, 0xd1, 0x34, 0x23, 0xef, 0xcb,
	0x0c, 0x1a, 0xda, 0x84, 0xeb, 0xd8, 0xf7, 0xad, 0x13, 0xc7, 0x37, 0x02, 0xd7, 0x70, 0x9d, 0x30,
	0xdf, 0xb9, 0x01, 0xec, 0x0c, 0x45, 0xe2, 0x65, 0xd7, 0x6d, 0x39, 0x84, 0x2f, 0xfe, 0x0b, 0xf2,
	0xec, 0x85, 0x0b, 0xf2, 0xec, 0xca, 0x0f, 0xa1, 0x10, 0x5b, 0x93, 0x4a, 0xe3, 0xb2, 0x8b, 0xe4,
	0x2a, 0x14, 0x9a, 0xad, 0x26, 0xcb, 0xb9, 0x69, 0xcd, 0x87, 0x52, 0x82, 0x11, 0x54, 0xb5, 0xd6,
	0xe1, 0x69, 0x38, 0x29, 0x89, 0x10, 0x94, 0x2a, 0x75, 0x5d, 0xad, 0xd4, 0x44, 0x66, 0xae, 0x26,
	0xa5, 0x94, 0x1f, 0x81, 0x34, 0xbb, 0x4c, 0x14, 0xed, 0x32, 0x11, 0x25, 0x80, 0x9a, 0xd6, 0xd9,
	0xad, 0xe8, 0x35, 0x2e, 0x41, 0x82, 0x62, 0x94, 0xdc, 0xa3, 0x94, 0x24, 0x6d, 0xa1, 0xab, 0x2c,
	0x21, 0x47, 0x9f, 0x53, 0xca, 0xf7, 0x61, 0x75, 0x66, 0x2a, 0x95, 0x07, 0x2f, 0x18, 0x80, 0xda,
	0xd0, 0xba, 0x46, 0xa5, 0x7e, 0x54, 0x79, 0xda, 0xe1, 0x81, 0x36, 0x46, 0xd0, 0xf6, 0x8c, 0x66,
	0xab, 0xa9, 0x36, 0xda, 0xdd, 0xa7, 0x52, 0x52, 0x69, 0xcf, 0xce, 0xe4, 0x0b, 0x11, 0xf7, 0x34,
	0x5d, 0x9d, 0x42, 0x64, 0x84, 0x69, 0xc4, 0x63, 0x80, 0xc9, 0x4a, 0x56, 0xba, 0x97, 0xa1, 0x5d,
	0x83, 0x15, 0xb5, 0x59, 0x33, 0x5a, 0x7b, 0x46, 0x14, 0x0a, 0x44, 0x50, 0xaa, 0x57, 0x58, 0xbe,
	0x5d, 0x6b, 0x1a, 0xed, 0x4a, 0x93, 0x6a, 0x99, 0xf6, 0xba, 0xa2, 0xd7, 0xb5, 0x38, 0x35, 0xa5,
	0xd8, 0x00, 0x93, 0x88, 0x82, 0xf2, 0xf9, 0x0b, 0x34, 0xac, 0x1e, 0xaa, 0xcd, 0x2e, 0x2b, 0x2e,
	0x94, 0x12, 0x68, 0x0d, 0x56, 0x45, 0x9a, 0x8a, 0x9e, 0xe8, 0x8c, 0x98, 0x44, 0xb7, 0xe0, 0x8d,
	0xce, 0xd3, 0xe6, 0xee, 0xbe, 0xde, 0x6a, 0xb2, 0xd4, 0xd5, 0x6c, 0x8b, 0x94, 0xf2, 0xa7, 0x12,
	0x64, 0x85, 0x35, 0x41, 0x3a, 0xe4, 0x71, 0x3f, 0x20, 0x9e, 0x81, 0x6d, 0x5b, 0x18, 0xd6, 0xed,
	0xf9, 0x8d, 0x51, 0xb9, 0x42, 0x79, 0x2b, 0xb6, 0xbd, 0xbf, 0xa4, 0xe7, 0xb0, 0xf8, 0x1d, 0xc3,
	0x74, 0xc6, 0xc2, 0xe1, 0x5a, 0x1c, 0xd3, 0x19, 0x4f, 0x30, 0x9d, 0x31, 0x3a, 0x00, 0xe0, 0x98,
	0x04, 0xf7, 0x4e, 0xc5, 0x0d, 0xeb, 0xa3, 0x45, 0x41, 0x55, 0xdc, 0x3b, 0xdd, 0x5f, 0xd2, 0x79,
	0xef, 0xe8, 0x03, 0xb2, 0x61, 0x4d, 0xc0, 0x3a, 0xa6, 0xe1, 0xf6, 0xc3, 0x6d, 0xb9, 0x3c, 0x77,
	0xb4, 0x75, 0x1a, 0xdf, 0x31, 0x5b, 0x7d, 0xbe, 0x7f, 0xf7, 0x97, 0x74, 0x09, 0xcf, 0xd0, 0x50,
	0x00, 0xd7, 0xb9, 0xb4, 0x99, 0x7b, 0xab, 0x88, 0x3d, 0x3e, 0x58, 0x54, 0xde, 0xf9, 0xfb, 0x29,
	0x3e, 0x4f, 0x46, 0x7f, 0x9c, 0x00, 0x85, 0x8b, 0xf5, 0xc7, 0x4e, 0xef, 0xd4, 0x73, 0x1d, 0x96,
	0x8e, 0x9c, 0xed, 0x03, 0xaf, 0x0d, 0x7a, 0xb4, 0x68, 0x1f, 0x3a, 0x31, 0xcc, 0x73, 0xfd, 0xb9,
	0x89, 0x5f, 0xdc, 0x04, 0x3d, 0x86, 0x0c, 0xb6, 0x9f, 0xe3, 0xb1, 0xbf, 0x51, 0x64, 0xe2, 0x37,
	0x17, 0x11, 0xcf, 0x18, 0xf7, 0x97, 0x74, 0x01, 0x81, 0x9a, 0x90, 0x35, 0x49, 0x1f, 0x8f, 0xec,
	0x80, 0x9d, 0x25, 0x85, 0xf9, 0x22, 0x79, 0x02, 0xad, 0xc6, 0x39, 0xf7, 0x97, 0xf4, 0x10, 0x04,
	0x7d, 0x3e, 0xb9, 0xd8, 0xf7, 0xdc, 0x91, 0x13, 0xb0, 0xd3, 0x63, 0xbe, 0xe8, 0x49, 0x88, 0xaa,
	0x86, 0xd1, 0xc7, 0x91, 0x13, 0xc4, 0x6e, 0xf2, 0xec, 0x19, 0xed, 0x43, 0xda, 0x21, 0x67, 0x84,
	0x1f, 0x36, 0x85, 0xad, 0x3b, 0x0b, 0xe0, 0x36, 0x29, 0xdf, 0xfe, 0x92, 0xce, 0x01, 0xe8, 0xee,
	0x70, 0x3d, 0x9e, 0x71, 0xb2, 0xc7, 0xec, 0x50, 0x59, 0x6c, 0x77, 0xb4, 0xbc, 0x3d, 0xce, 0x4b,
	0x77, 0x87, 0x1b, 0x3e, 0xd0, 0xd9, 0xf1, 0xc8, 0x90, 0xe0, 0x80, 0x9d, 0x3d, 0x8b, 0xcd, 0x8e,
	0xce, 0x18, 0xe9, 0xec, 0x70, 0x08, 0xf9, 0x09, 0xe4, 0x42, 0x6b, 0x81, 0xea, 0x50, 0x60, 0x15,
	0x75, 0xac, 0x69, 0x18, 0x27, 0x58, 0xc4, 0x09, 0x8a, 0xb3, 0x4f, 0x90, 0x9d, 0xf1, 0x2b, 0x46,
	0x7e, 0x0a, 0xf9, 0xc8, 0x70, 0xbc, 0x62, 0xe8, 0x5f, 0x24, 0x40, 0x9a, 0x35, 0x1a, 0xa8, 0x05,
	0x2b, 0x04, 0x7b, 0xf6, 0xd8, 0xe8, 0x5b, 0xf4, 0x12, 0x16, 0x96, 0x71, 0x2e, 0x22, 0xa4, 0xc8,
	0x00, 0xf6, 0x38, 0x3f, 0x6a, 0x40, 0x91, 0xfa, 0x3e, 0x11, 0x5e, 0x72, 0x61, 0xbc, 0x02, 0xe5,
	0x17, 0x70, 0xf2, 0x6f, 0xc3, 0xda, 0x05, 0x86, 0x07, 0x9d, 0xc2, 0x7a, 0x14, 0x23, 0x31, 0xce,
	0xd5, 0xae, 0xdf, 0x9d, 0x33, 0x9e, 0xce, 0xd8, 0x27, 0xc5, 0xca, 0x6b, 0xc1, 0x39, 0x9a, 0x2f,
	0xbf, 0x05, 0x37, 0xbf, 0xc2, 0xea, 0xc8, 0x79, 0xc8, 0x8a, 0xbd, 0x2c, 0x6f, 0x43, 0x31, 0xbe,
	0x01, 0xd1, 0xdb, 0xb3, 0x1b, 0x9a, 0xaa, 0x37, 0x3d, 0xbd, 0x2b, 0xe5, 0x2c, 0xa4, 0xd9, 0xee,
	0x92, 0x73, 0x90, 0xe1, 0x26, 0x46, 0xfe, 0xc3, 0x04, 0xe4, 0xa3, 0x2d, 0x82, 0x1e, 0xc0, 0x72,
	0x94, 0x2d, 0x58, 0x4c, 0x97, 0x8c, 0x8f, 0x7a, 0xff, 0xe1, 0x4e, 0x5d, 0x7c, 0x3a, 0x42, 0x56,
	0xb9, 0x0b, 0x19, 0xbe, 0xc5, 0xd0, 0x23, 0x80, 0xc9, 0xc2, 0xba, 0x42, 0xaf, 0x62, 0xdc, 0xd5,
	0x7c, 0x74, 0x33, 0x51, 0xfe, 0x21, 0x19, 0x8b, 0xa4, 0x4d, 0xea, 0x70, 0x3b, 0x90, 0x36, 0x89,
	0x8d, 0xc7, 0x0b, 0x64, 0x24, 0xcf, 0xa3, 0x94, 0x6b, 0x14, 0x82, 0xda, 0x2f, 0x86, 0x85, 0x3e,
	0x83, 0x1c, 0xb6, 0xad, 0x13, 0xc7, 0x08, 0x5c, 0xa1, 0x93, 0xef, 0x5e, 0x0d, 0xb7, 0x42, 0x51,
	0xba, 0x2e, 0xb5, 0xe2, 0x98, 0xff, 0x94, 0xdf, 0x87, 0x34, 0x93, 0x86, 0xde, 0x82, 0x22, 0x93,
	0x66, 0x0c, 0x2c, 0xdb, 0xb6, 0x7c, 0x11, 0xd0, 0x2c, 0x30, 0x5a, 0x83, 0x91, 0xe4, 0xfb, 0x90,
	0x15, 0x08, 0xe8, 0x06, 0x64, 0x86, 0xc4, 0xb3, 0x5c, 0x7e, 0x85, 0x4b, 0xe9, 0xe2, 0x89, 0xd2,
	0xdd, 0x7e, 0xdf, 0x27, 0x01, 0x73, 0x12, 0x52, 0xba, 0x78, 0xaa, 0x5e, 0x87, 0xb5, 0x0b, 0xf6,
	0x80, 0xf2, 0x7b, 0x49, 0xc8, 0x47, 0x91, 0x24, 0x74, 0x08, 0x25, 0xdc, 0x63, 0x25, 0x41, 0x43,
	0x1c, 0x04, 0xc4, 0xbb, 0xf2, 0x5d, 0x76, 0x85, 0xc3, 0xb4, 0x39, 0x0a, 0xda, 0x87, 0xec, 0x99,
	0x45, 0x9e, 0xbf, 0x44, 0xd2, 0x2e, 0x43, 0xf9, 0xf7, 0x1c, 0xf4, 0x03, 0xb8, 0x26, 0xae, 0xb0,
	0x03, 0x3c, 0x1c, 0x52, 0xe7, 0xa0, 0xef, 0x08, 0x77, 0x6b, 0x61, 0x4c, 0x71, 0x19, 0x6e, 0x70,
	0xa0, 0x3d, 0x47, 0x79, 0x00, 0xd2, 0x91, 0xe5, 0xf1, 0x2c, 0x5e, 0x87, 0x04, 0x81, 0xe5, 0x9c,
	0x20, 0x09, 0x52, 0x23, 0xa1, 0x87, 0xbc, 0x4e, 0x7f, 0xa2, 0x0d, 0xc8, 0x0e, 0x79, 0xdc, 0x8f,
	0x0d, 0xa6, 0xa8, 0x87, 0x8f, 0xca, 0xa7, 0x50, 0x88, 0x55, 0xc2, 0x87, 0xac, 0xc9, 0x0b, 0x59,
	0x53, 0x53, 0xac, 0x8f, 0x96, 0x73, 0x09, 0x29, 0xa9, 0xfc, 0x49, 0x02, 0xd6, 0xc3, 0x00, 0x5a,
	0xbc, 0x54, 0x5f, 0xf9, 0x32, 0x01, 0xc5, 0x38, 0x01, 0xbd, 0x03, 0x99, 0x5a, 0x8b, 0xe5, 0xe8,
	0x97, 0xa6, 0x02, 0x5b, 0xc4, 0x39, 0xdb, 0x31, 0xdd, 0xde, 0x33, 0x1e, 0x36, 0x7a, 0x17, 0xb2,
	0xc2, 0xbd, 0x96, 0x12, 0x53, 0xe1, 0x25, 0xda, 0x4c, 0x38, 0x58, 0xb4, 0xdd, 0x6d, 0xc8, 0xa9,
	0x4f, 0xba, 0xaa, 0xde, 0xac, 0xd4, 0x67, 0x42, 0x60, 0xb4, 0x21, 0xf9, 0x82, 0x4e, 0x22, 0xb6,
	0x77, 0xce, 0x36, 0x95, 0x7b, 0xb0, 0x52, 0x63, 0xf0, 0x61, 0x2c, 0xf9, 0x3d, 0x58, 0xed, 0xb9,
	0x4e, 0x80, 0x2d, 0x87, 0x78, 0x86, 0x35, 0xc0, 0x27, 0x61, 0x21, 0x56, 0x29, 0x22, 0x6b, 0x94,
	0xaa, 0xfc, 0x5b, 0x02, 0x4a, 0xc2, 0x14, 0x86, 0xbc, 0x25, 0x48, 0xba, 0xbe, 0x68, 0x9e, 0x74,
	0x7d, 0x84, 0x60, 0x19, 0x7b, 0xbd, 0x53, 0xa1, 0x31, 0xf6, 0x9b, 0xaa, 0xac, 0xe7, 0x0e, 0x06,
	0xd8, 0x09, 0x63, 0x15, 0xe1, 0x23, 0xaa, 0x43, 0x8a, 0x38, 0x67, 0x8b, 0x94, 0xa3, 0x4f, 0x49,
	0x2f, 0xab, 0xce, 0x19, 0x8f, 0xd6, 0x52, 0x18, 0xf9, 0x63, 0xc8, 0x85, 0x84, 0x85, 0x2a, 0xba,
	0xff, 0x27, 0x01, 0xab, 0xaa, 0x50, 0x50, 0x38, 0xae, 0x78, 0x46, 0x2b, 0xf1, 0x8a, 0x32, 0x5a,
	0xe8, 0x10, 0x32, 0x2c, 0xf6, 0x15, 0xa6, 0xde, 0xe6, 0xf1, 0xc6, 0x67, 0x3a, 0xc6, 0x6b, 0x48,
	0xc2, 0xca, 0x7e, 0x8e, 0x26, 0xdf, 0x87, 0x42, 0x8c, 0xbc, 0xd0, 0xd8, 0x77, 0xa0, 0x18, 0xdf,
	0x50, 0x2f, 0xde, 0x2b, 0xd3, 0x0b, 0x5e, 0xf9, 0xf5, 0x32, 0x14, 0x62, 0x45, 0x6c, 0x48, 0x83,
	0xb4, 0x15, 0x90, 0xe8, 0x50, 0xde, 0x5e, 0xac, 0x06, 0xae, 0xac, 0x05, 0x64, 0xa0, 0x73, 0x04,
	0xb9, 0x0f, 0xa0, 0x99, 0xc4, 0x09, 0xac, 0xbe, 0x45, 0x3c, 0x6a, 0x56, 0xe3, 0xdf, 0x88, 0x88,
	0xde, 0x15, 0x82, 0xc9, 0xe7, 0x21, 0xf4, 0xdc, 0x9d, 0x34, 0x99, 0x6c, 0xd9, 0x09, 0xdf, 0x81,
	0xe7, 0x84, 0x8a, 0x49, 0x45, 0x8a, 0x91, 0x7f, 0x99, 0x84, 0x65, 0x2a, 0x17, 0x69, 0x90, 0x14,
	0xc0, 0xf3, 0x7d, 0x6b, 0x31, 0xd5, 0xf1, 0xa8, 0xa7, 0x7a, 0xd2, 0xa2, 0x8b, 0x9a, 0xd7, 0x05,
	0x25, 0xe7, 0x8e, 0x93, 0xc5, 0xc1, 0x66, 0x2a, 0x83, 0xd0, 0xfb, 0xe1, 0xd4, 0x71, 0x0b, 0xb9,
	0x5e, 0xe6, 0xdf, 0x2b, 0x96, 0xc3, 0xef, 0x15, 0xcb, 0x15, 0x27, 0xfc, 0x0c, 0x09, 0xdd, 0x85,
	0x82, 0x7f, 0xea, 0x7a, 0x01, 0x0f, 0xa9, 0x8a, 0x2b, 0xe6, 0xc5, 0x1c, 0xc0, 0x1a, 0x1e, 0x32,
	0xb6, 0x75, 0x48, 0xdb, 0xf8, 0x98, 0xd8, 0xe2, 0x8b, 0x17, 0xfe, 0x80, 0x5e, 0x87, 0x9c, 0x6d,
	0x39, 0xcf, 0x8c, 0x91, 0x67, 0xb3, 0x8b, 0x5b, 0x5e, 0xcf, 0xd2, 0xe7, 0x03, 0xcf, 0x96, 0x7f,
	0x4b, 0x54, 0x2b, 0x8d, 0x5e, 0x50, 0xad, 0xc4, 0x73, 0x00, 0xbc, 0xa0, 0x40, 0x6b, 0x76, 0xd5,
	0x87, 0xaa, 0x2e, 0x25, 0x51, 0x1e, 0xd2, 0x7b, 0xf5, 0x56, 0xa5, 0x2b, 0xa5, 0x78, 0xa1, 0x41,
	0xab, 0xae, 0x56, 0x9a, 0xd2, 0x32, 0x5a, 0x81, 0x7c, 0xf4, 0x35, 0xa3, 0x94, 0x46, 0x45, 0xc8,
	0xd5, 0x0e, 0xf4, 0x0a, 0xab, 0x23, 0xce, 0xa0, 0x12, 0xc0, 0xa3, 0xca, 0x61, 0xc5, 0xd8, 0xad,
	0x57, 0x3a, 0x1d, 0x29, 0xab, 0xfc, 0x7b, 0x16, 0xae, 0x37, 0x88, 0xef, 0xe3, 0x13, 0x72, 0x64,
	0x05, 0xa7, 0xb1, 0xb2, 0xe6, 0x57, 0xfc, 0x81, 0xd2, 0xf7, 0x20, 0xcd, 0xa2, 0xac, 0x8b, 0x7e,
	0xb1, 0x45, 0xbd, 0x0e, 0xc6, 0x88, 0x7e, 0x48, 0x4d, 0xab, 0xa8, 0xfb, 0x8e, 0x6d, 0xa2, 0xf9,
	0xee, 0x39, 0xd3, 0xb5, 0x06, 0xfb, 0x4b, 0xba, 0xa8, 0x7b, 0x8a, 0xaa, 0x0f, 0x0e, 0x61, 0x25,
	0x4c, 0xdc, 0x2d, 0x5a, 0xae, 0x14, 0xdf, 0xf4, 0xf4, 0xd6, 0xd8, 0x8f, 0x1b, 0x81, 0x23, 0x28,
	0x0d, 0xb1, 0x67, 0x98, 0x6e, 0xd4, 0xe9, 0xcc, 0xdc, 0xc0, 0xf1, 0xd2, 0x48, 0x0a, 0x3c, 0x8c,
	0x17, 0xb2, 0xb6, 0x00, 0x86, 0xd1, 0x8e, 0x14, 0x37, 0xe8, 0xc5, 0x3e, 0x30, 0xdc, 0x5f, 0xd2,
	0x63, 0x10, 0x48, 0x87, 0x42, 0xec, 0xa3, 0x50, 0x71, 0x7b, 0x5e, 0xf0, 0x13, 0xc2, 0xfd, 0x25,
	0x3d, 0x0e, 0x82, 0x3a, 0x50, 0x64, 0x15, 0x72, 0xe1, 0xd8, 0xf3, 0x73, 0x83, 0xc6, 0x4a, 0x65,
	0x28, 0xa8, 0x17, 0xab, 0x9c, 0x69, 0x00, 0x4c, 0x32, 0x95, 0xe2, 0xae, 0xbb, 0x50, 0x8a, 0x90,
	0x5e, 0x9b, 0xa3, 0x94, 0x24, 0xea, 0xc3, 0x5a, 0xec, 0xbb, 0x9b, 0xa8, 0xab, 0xc5, 0x05, 0x3f,
	0x65, 0x8c, 0xd5, 0xca, 0xec, 0x2f, 0xe9, 0xc2, 0x2d, 0x8b, 0x17, 0xd0, 0x10, 0x40, 0xe7, 0x2b,
	0xa2, 0x37, 0x56, 0xae, 0xfe, 0xc5, 0xe4, 0x44, 0x4c, 0x8c, 0x58, 0xcd, 0xc0, 0xb2, 0xe7, 0xba,
	0x81, 0xf2, 0x65, 0x16, 0x6e, 0xa8, 0x5f, 0x90, 0xde, 0x88, 0x55, 0xc7, 0x76, 0x02, 0x7c, 0x12,
	0xad, 0xf5, 0x36, 0x14, 0x62, 0x61, 0x69, 0xb1, 0xb7, 0x17, 0xfd, 0xb0, 0x31, 0x0e, 0x81, 0x30,
	0x1d, 0x9b, 0x17, 0x96, 0x81, 0xf9, 0xdc, 0x59, 0x14, 0xb3, 0xbd, 0x3d, 0xd7, 0xd8, 0xa6, 0xfd,
	0x4c, 0x5d, 0x7a, 0x3e, 0xeb, 0x79, 0xae, 0x43, 0x9a, 0x4f, 0xb8, 0x38, 0x77, 0x2d, 0x31, 0x79,
	0x17, 0x94, 0x4e, 0xab, 0x73, 0xf9, 0x02, 0x17, 0xa9, 0x66, 0xb2, 0x46, 0x34, 0x73, 0xaa, 0x80,
	0xfa, 0xcd, 0xa9, 0xaf, 0xbc, 0x97, 0x59, 0xca, 0x37, 0xfe, 0x99, 0xf6, 0xc6, 0xe4, 0x83, 0xc0,
	0x34, 0x7b, 0x19, 0x7d, 0xd4, 0x37, 0x6d, 0x47, 0x33, 0x2f, 0x6b, 0x47, 0xfb, 0x50, 0x18, 0xf9,
	0x54, 0xc7, 0x01, 0x0e, 0x88, 0xbf, 0x91, 0x7d, 0xd9, 0x01, 0x1f, 0xf8, 0xc4, 0x63, 0x95, 0x79,
	0x74, 0xc0, 0xa3, 0xf0, 0xc1, 0x47, 0x4f, 0x21, 0xc3, 0xd2, 0xad, 0xfe, 0x46, 0x8e, 0x89, 0xa8,
	0x5c, 0x5d, 0x04, 0x2b, 0xe0, 0xd3, 0x4c, 0x5d, 0x00, 0xca, 0x2d, 0x28, 0xc4, 0xd4, 0x3c, 0x8f,
	0x47, 0xf2, 0x75, 0x00, 0xdb, 0xed, 0x61, 0x9b, 0x7f, 0xd9, 0xc0, 0x17, 0x40, 0x9e, 0x51, 0x9a,
	0x78, 0x40, 0x28, 0x60, 0x6c, 0x18, 0xaf, 0x00, 0xf0, 0x31, 0x64, 0x45, 0xa7, 0x5f, 0x1e, 0x6c,
	0xeb, 0x0f, 0x12, 0xf1, 0xaa, 0x32, 0xe1, 0xd3, 0xa2, 0x9f, 0x40, 0x86, 0xd7, 0xa6, 0xa0, 0x79,
	0x02, 0x89, 0x53, 0x65, 0x2c, 0xf2, 0x4b, 0x94, 0x99, 0x29, 0x4b, 0x77, 0x12, 0x3b, 0x9f, 0x42,
	0x8e, 0xfd, 0x63, 0x04, 0x75, 0x49, 0xdf, 0x3a, 0xe7, 0xd2, 0x50, 0x37, 0x84, 0x39, 0x33, 0xad,
	0x21, 0xff, 0xcb, 0x81, 0x7f, 0xfc, 0xb3, 0xbf, 0x7e, 0xc2, 0x9d, 0x16, 0xca, 0x75, 0xe0, 0x39,
	0x3b, 0x1a, 0xac, 0x30, 0x80, 0x9e, 0xf8, 0xe7, 0x86, 0x79, 0x50, 0xfe, 0x29, 0x44, 0x29, 0x1e,
	0xc7, 0xfe, 0x01, 0xa2, 0xfa, 0x6d, 0xf8, 0xea, 0xbf, 0xa9, 0xa8, 0xe6, 0x75, 0x56, 0xb5, 0x52,
	0x19, 0x5a, 0x9f, 0x15, 0x42, 0xba, 0x71, 0xb6, 0x79, 0x9c, 0x61, 0xe2, 0xb6, 0xff, 0x2f, 0x00,
	0x00, 0xff, 0xff, 0x74, 0x65, 0x10, 0xa9, 0x01, 0x43, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// TestStreamServiceClient is the client API for TestStreamService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TestStreamServiceClient interface {
	// A TestStream will request for events using this RPC.
	Events(ctx context.Context, in *EventsRequest, opts ...grpc.CallOption) (TestStreamService_EventsClient, error)
}

type testStreamServiceClient struct {
	cc *grpc.ClientConn
}

func NewTestStreamServiceClient(cc *grpc.ClientConn) TestStreamServiceClient {
	return &testStreamServiceClient{cc}
}

func (c *testStreamServiceClient) Events(ctx context.Context, in *EventsRequest, opts ...grpc.CallOption) (TestStreamService_EventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_TestStreamService_serviceDesc.Streams[0], "/org.apache.beam.model.pipeline.v1.TestStreamService/Events", opts...)
	if err != nil {
		return nil, err
	}
	x := &testStreamServiceEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type TestStreamService_EventsClient interface {
	Recv() (*TestStreamPayload_Event, error)
	grpc.ClientStream
}

type testStreamServiceEventsClient struct {
	grpc.ClientStream
}

func (x *testStreamServiceEventsClient) Recv() (*TestStreamPayload_Event, error) {
	m := new(TestStreamPayload_Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// TestStreamServiceServer is the server API for TestStreamService service.
type TestStreamServiceServer interface {
	// A TestStream will request for events using this RPC.
	Events(*EventsRequest, TestStreamService_EventsServer) error
}

// UnimplementedTestStreamServiceServer can be embedded to have forward compatible implementations.
type UnimplementedTestStreamServiceServer struct {
}

func (*UnimplementedTestStreamServiceServer) Events(req *EventsRequest, srv TestStreamService_EventsServer) error {
	return status.Errorf(codes.Unimplemented, "method Events not implemented")
}

func RegisterTestStreamServiceServer(s *grpc.Server, srv TestStreamServiceServer) {
	s.RegisterService(&_TestStreamService_serviceDesc, srv)
}

func _TestStreamService_Events_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(EventsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(TestStreamServiceServer).Events(m, &testStreamServiceEventsServer{stream})
}

type TestStreamService_EventsServer interface {
	Send(*TestStreamPayload_Event) error
	grpc.ServerStream
}

type testStreamServiceEventsServer struct {
	grpc.ServerStream
}

func (x *testStreamServiceEventsServer) Send(m *TestStreamPayload_Event) error {
	return x.ServerStream.SendMsg(m)
}

var _TestStreamService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.pipeline.v1.TestStreamService",
	HandlerType: (*TestStreamServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Events",
			Handler:       _TestStreamService_Events_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "beam_runner_api.proto",
}
