---
layout: section
title: "Apache Parquet I/O connector"
section_menu: section-menu/documentation.html
permalink: /documentation/io/built-in/parquet/
---
<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

[Built-in I/O Transforms]({{site.baseurl}}/documentation/io/built-in/)

# Apache Parquet I/O connector

<nav class="language-switcher">
  <strong>Adapt for:</strong>
  <ul>
    <li data-type="language-java" class="active">Java SDK</li>
    <li data-type="language-py">Python SDK</li>
  </ul>
</nav>

The Beam SDKs include built-in transforms that can read data from and write data
to [Apache Parquet](https://parquet.apache.org) files.

## Before you start

<!-- Java specific -->

{:.language-java}
To use ParquetIO, add the Maven artifact dependency to your `pom.xml` file.

```java
<dependency>
    <groupId>org.apache.beam</groupId>
    <artifactId>beam-sdks-java-io-parquet</artifactId>
    <version>{{ site.release_latest }}</version>
</dependency>
```

{:.language-java}
Additional resources:

{:.language-java}
* [ParquetIO source code](https://github.com/apache/beam/blob/master/sdks/java/io/parquet/src/main/java/org/apache/beam/sdk/io/parquet/ParquetIO.java)
* [ParquetIO Javadoc](https://beam.apache.org/releases/javadoc/{{ site.release_latest }}/org/apache/beam/sdk/io/parquet/ParquetIO.html)

<!-- Python specific -->

{:.language-py}
ParquetIO comes preinstalled with the Apache Beam python sdk..

{:.language-py}
Additional resources:

{:.language-py}
* [ParquetIO source code](https://github.com/apache/beam/blob/master/sdks/python/apache_beam/io/parquetio.py)
* [ParquetIO Pydoc](https://beam.apache.org/releases/pydoc/{{ site.release_latest }}/apache_beam.io.parquetio.html)

{:.language-java}
#### Using ParquetIO with Spark before 2.4

{:.language-java}
`ParquetIO` depends on an API introduced in Apache Parquet 1.10.0.  **Spark 2.4.x is compatible and no additional steps are necessary**.  Older versions of Spark will not work out of the box since a pre-installed version of Parquet libraries will take precedence during execution.  The following workaround should be applied.

{:.language-java}
> **Note**: The following technique allows you to execute your pipeline with `ParquetIO` correctly.
> The Parquet files that are consumed or generated by this Beam connector should remain interoperable with the other tools on your cluster.

{:.language-java}
Include the Parquet artifact normally and ensure that it brings in the correct version of Parquet as a transitive dependency.

{:.language-java}
```
<dependency>
    <groupId>org.apache.beam</groupId>
    <artifactId>beam-sdks-java-io-parquet</artifactId>
    <version>${beam.version}</version>
</dependency>
```
 
{:.language-java}
Relocate the following packages:

{:.language-java}
```
<plugin>
  <groupId>org.apache.maven.plugins</groupId>
  <artifactId>maven-shade-plugin</artifactId>
  <configuration>
    <createDependencyReducedPom>false</createDependencyReducedPom>
    <filters>
      <filter>
        <artifact>*:*</artifact>
        <excludes>
          <exclude>META-INF/*.SF</exclude>
          <exclude>META-INF/*.DSA</exclude>
          <exclude>META-INF/*.RSA</exclude>
        </excludes>
      </filter>
    </filters>
  </configuration>
  <executions>
    <execution>
      <phase>package</phase>
      <goals>
        <goal>shade</goal>
      </goals>
      <configuration>
        <shadedArtifactAttached>true</shadedArtifactAttached>
        <shadedClassifierName>shaded</shadedClassifierName>
        <relocations>
          <relocation>
            <pattern>org.apache.parquet</pattern>
            <shadedPattern>shaded.org.apache.parquet</shadedPattern>
          </relocation>
          <!-- Some packages are shaded already, and on the original spark classpath. Shade them more. -->
          <relocation>
            <pattern>shaded.parquet</pattern>
            <shadedPattern>reshaded.parquet</shadedPattern>
          </relocation>
          <relocation>
            <pattern>org.apache.avro</pattern>
            <shadedPattern>shaded.org.apache.avro</shadedPattern>
          </relocation>
        </relocations>
        <transformers>
          <transformer
            implementation="org.apache.maven.plugins.shade.resource.ServicesResourceTransformer"/>
        </transformers>
      </configuration>
    </execution>
  </executions>
</plugin>
```

{:.language-java}
This technique has been tested to work on Spark 2.2.3, Spark 2.3.3 and Spark 2.4.3 (although it is optional for Spark 2.4+).
