---
layout: post
title:  "Apache Beam Katas"
date:   2019-05-30 00:00:01 -0800
excerpt_separator: <!--more-->
categories: blog
authors:
  - henryken

---
<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->


We are happy to announce 
[Apache Beam Katas](https://github.com/apache/beam/tree/master/learning/katas), a set of 
interactive Beam coding exercises (i.e. [code katas](http://codekata.com/)) that can help you in 
learning Apache Beam concepts and programming model hands-on.

<!--more-->

Beam Katas objective is to provide a series of structured hands-on learning experiences for learners 
to understand about Apache Beam and its SDKs by solving exercises with gradually increasing 
complexity. It is built based on 
[JetBrains Educational Products](https://www.jetbrains.com/education/). Beam Katas is available for 
both Java and Python SDKs. Currently we have about 20 lessons that cover Apache Beam fundamentals, 
such as core transforms, common transforms, and simple use case (word count), with more katas to 
be added in the coming future.


To start with the courses, you can simply download 
[IntelliJ Edu](https://www.jetbrains.com/education/download/#section=idea) or 
[PyCharm Edu](https://www.jetbrains.com/education/download/#section=pycharm-edu) and then browse 
the integrated Stepik courses from the menu. Search for “Beam Katas” and once the course is loaded 
on the IDE, you’re good to go.

We have plans to add more katas covering more topics including some of the intermediate and 
advanced ones in the coming future, such as windowing, streaming, and use case patterns. We would 
also like to welcome you to [contribute](https://github.com/apache/beam) by building and adding more katas that you think would be 
useful for people to learn more about Apache Beam, and eventually become Beam Masters!

<br/>

<img src="{{ "/images/blog/beam-kata/beam-kata-intellij-edu-1.png" | prepend: site.baseurl }}" alt="Beam Kata - IntelliJ Edu" width="363" height="350">
<img src="{{ "/images/blog/beam-kata/beam-kata-intellij-edu-2.png" | prepend: site.baseurl }}" alt="Beam Kata - IntelliJ Edu" width="455" height="350">

<img src="{{ "/images/blog/beam-kata/beam-kata-pycharm-edu-1.png" | prepend: site.baseurl }}" alt="Beam Kata - PyCharm Edu" width="363" height="350">
<img src="{{ "/images/blog/beam-kata/beam-kata-pycharm-edu-2.png" | prepend: site.baseurl }}" alt="Beam Kata - PyCharm Edu" width="459" height="350">
