// Code generated by protoc-gen-go. DO NOT EDIT.
// source: beam_job_api.proto

package jobmanagement_v1

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import pipeline_v1 "github.com/apache/beam/sdks/go/pkg/beam/model/pipeline_v1"
import _struct "github.com/golang/protobuf/ptypes/struct"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type JobMessage_MessageImportance int32

const (
	JobMessage_MESSAGE_IMPORTANCE_UNSPECIFIED JobMessage_MessageImportance = 0
	JobMessage_JOB_MESSAGE_DEBUG              JobMessage_MessageImportance = 1
	JobMessage_JOB_MESSAGE_DETAILED           JobMessage_MessageImportance = 2
	JobMessage_JOB_MESSAGE_BASIC              JobMessage_MessageImportance = 3
	JobMessage_JOB_MESSAGE_WARNING            JobMessage_MessageImportance = 4
	JobMessage_JOB_MESSAGE_ERROR              JobMessage_MessageImportance = 5
)

var JobMessage_MessageImportance_name = map[int32]string{
	0: "MESSAGE_IMPORTANCE_UNSPECIFIED",
	1: "JOB_MESSAGE_DEBUG",
	2: "JOB_MESSAGE_DETAILED",
	3: "JOB_MESSAGE_BASIC",
	4: "JOB_MESSAGE_WARNING",
	5: "JOB_MESSAGE_ERROR",
}
var JobMessage_MessageImportance_value = map[string]int32{
	"MESSAGE_IMPORTANCE_UNSPECIFIED": 0,
	"JOB_MESSAGE_DEBUG":              1,
	"JOB_MESSAGE_DETAILED":           2,
	"JOB_MESSAGE_BASIC":              3,
	"JOB_MESSAGE_WARNING":            4,
	"JOB_MESSAGE_ERROR":              5,
}

func (x JobMessage_MessageImportance) String() string {
	return proto.EnumName(JobMessage_MessageImportance_name, int32(x))
}
func (JobMessage_MessageImportance) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{14, 0}
}

type JobState_Enum int32

const (
	JobState_UNSPECIFIED JobState_Enum = 0
	JobState_STOPPED     JobState_Enum = 1
	JobState_RUNNING     JobState_Enum = 2
	JobState_DONE        JobState_Enum = 3
	JobState_FAILED      JobState_Enum = 4
	JobState_CANCELLED   JobState_Enum = 5
	JobState_UPDATED     JobState_Enum = 6
	JobState_DRAINING    JobState_Enum = 7
	JobState_DRAINED     JobState_Enum = 8
	JobState_STARTING    JobState_Enum = 9
	JobState_CANCELLING  JobState_Enum = 10
)

var JobState_Enum_name = map[int32]string{
	0:  "UNSPECIFIED",
	1:  "STOPPED",
	2:  "RUNNING",
	3:  "DONE",
	4:  "FAILED",
	5:  "CANCELLED",
	6:  "UPDATED",
	7:  "DRAINING",
	8:  "DRAINED",
	9:  "STARTING",
	10: "CANCELLING",
}
var JobState_Enum_value = map[string]int32{
	"UNSPECIFIED": 0,
	"STOPPED":     1,
	"RUNNING":     2,
	"DONE":        3,
	"FAILED":      4,
	"CANCELLED":   5,
	"UPDATED":     6,
	"DRAINING":    7,
	"DRAINED":     8,
	"STARTING":    9,
	"CANCELLING":  10,
}

func (x JobState_Enum) String() string {
	return proto.EnumName(JobState_Enum_name, int32(x))
}
func (JobState_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{16, 0}
}

type PipelineOptionType_Enum int32

const (
	PipelineOptionType_STRING  PipelineOptionType_Enum = 0
	PipelineOptionType_BOOLEAN PipelineOptionType_Enum = 1
	// whole numbers, see https://json-schema.org/understanding-json-schema/reference/numeric.html
	PipelineOptionType_INTEGER PipelineOptionType_Enum = 2
	PipelineOptionType_NUMBER  PipelineOptionType_Enum = 3
	PipelineOptionType_ARRAY   PipelineOptionType_Enum = 4
	PipelineOptionType_OBJECT  PipelineOptionType_Enum = 5
)

var PipelineOptionType_Enum_name = map[int32]string{
	0: "STRING",
	1: "BOOLEAN",
	2: "INTEGER",
	3: "NUMBER",
	4: "ARRAY",
	5: "OBJECT",
}
var PipelineOptionType_Enum_value = map[string]int32{
	"STRING":  0,
	"BOOLEAN": 1,
	"INTEGER": 2,
	"NUMBER":  3,
	"ARRAY":   4,
	"OBJECT":  5,
}

func (x PipelineOptionType_Enum) String() string {
	return proto.EnumName(PipelineOptionType_Enum_name, int32(x))
}
func (PipelineOptionType_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{21, 0}
}

// Prepare is a synchronous request that returns a preparationId back
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
// Throws error ALREADY_EXISTS if the jobName is reused. Runners are permitted to deduplicate based on the name of the job.
// Throws error UNKNOWN for all other issues
type PrepareJobRequest struct {
	Pipeline             *pipeline_v1.Pipeline `protobuf:"bytes,1,opt,name=pipeline,proto3" json:"pipeline,omitempty"`
	PipelineOptions      *_struct.Struct       `protobuf:"bytes,2,opt,name=pipeline_options,json=pipelineOptions,proto3" json:"pipeline_options,omitempty"`
	JobName              string                `protobuf:"bytes,3,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *PrepareJobRequest) Reset()         { *m = PrepareJobRequest{} }
func (m *PrepareJobRequest) String() string { return proto.CompactTextString(m) }
func (*PrepareJobRequest) ProtoMessage()    {}
func (*PrepareJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{0}
}
func (m *PrepareJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrepareJobRequest.Unmarshal(m, b)
}
func (m *PrepareJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrepareJobRequest.Marshal(b, m, deterministic)
}
func (dst *PrepareJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrepareJobRequest.Merge(dst, src)
}
func (m *PrepareJobRequest) XXX_Size() int {
	return xxx_messageInfo_PrepareJobRequest.Size(m)
}
func (m *PrepareJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PrepareJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PrepareJobRequest proto.InternalMessageInfo

func (m *PrepareJobRequest) GetPipeline() *pipeline_v1.Pipeline {
	if m != nil {
		return m.Pipeline
	}
	return nil
}

func (m *PrepareJobRequest) GetPipelineOptions() *_struct.Struct {
	if m != nil {
		return m.PipelineOptions
	}
	return nil
}

func (m *PrepareJobRequest) GetJobName() string {
	if m != nil {
		return m.JobName
	}
	return ""
}

type PrepareJobResponse struct {
	// (required) The ID used to associate calls made while preparing the job. preparationId is used
	// to run the job.
	PreparationId string `protobuf:"bytes,1,opt,name=preparation_id,json=preparationId,proto3" json:"preparation_id,omitempty"`
	// An endpoint which exposes the Beam Artifact Staging API. Artifacts used by the job should be
	// staged to this endpoint, and will be available during job execution.
	ArtifactStagingEndpoint *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,2,opt,name=artifact_staging_endpoint,json=artifactStagingEndpoint,proto3" json:"artifact_staging_endpoint,omitempty"`
	// (required) Token for the artifact staging. This token also represent an artifact
	// staging session with the artifact staging service.
	StagingSessionToken  string   `protobuf:"bytes,3,opt,name=staging_session_token,json=stagingSessionToken,proto3" json:"staging_session_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PrepareJobResponse) Reset()         { *m = PrepareJobResponse{} }
func (m *PrepareJobResponse) String() string { return proto.CompactTextString(m) }
func (*PrepareJobResponse) ProtoMessage()    {}
func (*PrepareJobResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{1}
}
func (m *PrepareJobResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrepareJobResponse.Unmarshal(m, b)
}
func (m *PrepareJobResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrepareJobResponse.Marshal(b, m, deterministic)
}
func (dst *PrepareJobResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrepareJobResponse.Merge(dst, src)
}
func (m *PrepareJobResponse) XXX_Size() int {
	return xxx_messageInfo_PrepareJobResponse.Size(m)
}
func (m *PrepareJobResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PrepareJobResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PrepareJobResponse proto.InternalMessageInfo

func (m *PrepareJobResponse) GetPreparationId() string {
	if m != nil {
		return m.PreparationId
	}
	return ""
}

func (m *PrepareJobResponse) GetArtifactStagingEndpoint() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.ArtifactStagingEndpoint
	}
	return nil
}

func (m *PrepareJobResponse) GetStagingSessionToken() string {
	if m != nil {
		return m.StagingSessionToken
	}
	return ""
}

// Run is a synchronous request that returns a jobId back.
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
// Throws error NOT_FOUND if the preparation ID does not exist
// Throws error UNKNOWN for all other issues
type RunJobRequest struct {
	// (required) The ID provided by an earlier call to prepare. Runs the job. All prerequisite tasks
	// must have been completed.
	PreparationId string `protobuf:"bytes,1,opt,name=preparation_id,json=preparationId,proto3" json:"preparation_id,omitempty"`
	// (optional) If any artifacts have been staged for this job, contains the retrieval_token returned
	// from the CommitManifestResponse.
	RetrievalToken       string   `protobuf:"bytes,2,opt,name=retrieval_token,json=retrievalToken,proto3" json:"retrieval_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RunJobRequest) Reset()         { *m = RunJobRequest{} }
func (m *RunJobRequest) String() string { return proto.CompactTextString(m) }
func (*RunJobRequest) ProtoMessage()    {}
func (*RunJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{2}
}
func (m *RunJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RunJobRequest.Unmarshal(m, b)
}
func (m *RunJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RunJobRequest.Marshal(b, m, deterministic)
}
func (dst *RunJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunJobRequest.Merge(dst, src)
}
func (m *RunJobRequest) XXX_Size() int {
	return xxx_messageInfo_RunJobRequest.Size(m)
}
func (m *RunJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RunJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RunJobRequest proto.InternalMessageInfo

func (m *RunJobRequest) GetPreparationId() string {
	if m != nil {
		return m.PreparationId
	}
	return ""
}

func (m *RunJobRequest) GetRetrievalToken() string {
	if m != nil {
		return m.RetrievalToken
	}
	return ""
}

type RunJobResponse struct {
	JobId                string   `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RunJobResponse) Reset()         { *m = RunJobResponse{} }
func (m *RunJobResponse) String() string { return proto.CompactTextString(m) }
func (*RunJobResponse) ProtoMessage()    {}
func (*RunJobResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{3}
}
func (m *RunJobResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RunJobResponse.Unmarshal(m, b)
}
func (m *RunJobResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RunJobResponse.Marshal(b, m, deterministic)
}
func (dst *RunJobResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunJobResponse.Merge(dst, src)
}
func (m *RunJobResponse) XXX_Size() int {
	return xxx_messageInfo_RunJobResponse.Size(m)
}
func (m *RunJobResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RunJobResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RunJobResponse proto.InternalMessageInfo

func (m *RunJobResponse) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

// Cancel is a synchronus request that returns a job state back
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
// Throws error NOT_FOUND if the jobId is not found
type CancelJobRequest struct {
	JobId                string   `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CancelJobRequest) Reset()         { *m = CancelJobRequest{} }
func (m *CancelJobRequest) String() string { return proto.CompactTextString(m) }
func (*CancelJobRequest) ProtoMessage()    {}
func (*CancelJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{4}
}
func (m *CancelJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CancelJobRequest.Unmarshal(m, b)
}
func (m *CancelJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CancelJobRequest.Marshal(b, m, deterministic)
}
func (dst *CancelJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CancelJobRequest.Merge(dst, src)
}
func (m *CancelJobRequest) XXX_Size() int {
	return xxx_messageInfo_CancelJobRequest.Size(m)
}
func (m *CancelJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CancelJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CancelJobRequest proto.InternalMessageInfo

func (m *CancelJobRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

// Valid responses include any terminal state or CANCELLING
type CancelJobResponse struct {
	State                JobState_Enum `protobuf:"varint,1,opt,name=state,proto3,enum=org.apache.beam.model.job_management.v1.JobState_Enum" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *CancelJobResponse) Reset()         { *m = CancelJobResponse{} }
func (m *CancelJobResponse) String() string { return proto.CompactTextString(m) }
func (*CancelJobResponse) ProtoMessage()    {}
func (*CancelJobResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{5}
}
func (m *CancelJobResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CancelJobResponse.Unmarshal(m, b)
}
func (m *CancelJobResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CancelJobResponse.Marshal(b, m, deterministic)
}
func (dst *CancelJobResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CancelJobResponse.Merge(dst, src)
}
func (m *CancelJobResponse) XXX_Size() int {
	return xxx_messageInfo_CancelJobResponse.Size(m)
}
func (m *CancelJobResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CancelJobResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CancelJobResponse proto.InternalMessageInfo

func (m *CancelJobResponse) GetState() JobState_Enum {
	if m != nil {
		return m.State
	}
	return JobState_UNSPECIFIED
}

// A subset of info provided by ProvisionApi.ProvisionInfo
type JobInfo struct {
	JobId                string          `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	JobName              string          `protobuf:"bytes,2,opt,name=job_name,json=jobName,proto3" json:"job_name,omitempty"`
	PipelineOptions      *_struct.Struct `protobuf:"bytes,3,opt,name=pipeline_options,json=pipelineOptions,proto3" json:"pipeline_options,omitempty"`
	State                JobState_Enum   `protobuf:"varint,4,opt,name=state,proto3,enum=org.apache.beam.model.job_management.v1.JobState_Enum" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *JobInfo) Reset()         { *m = JobInfo{} }
func (m *JobInfo) String() string { return proto.CompactTextString(m) }
func (*JobInfo) ProtoMessage()    {}
func (*JobInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{6}
}
func (m *JobInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobInfo.Unmarshal(m, b)
}
func (m *JobInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobInfo.Marshal(b, m, deterministic)
}
func (dst *JobInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobInfo.Merge(dst, src)
}
func (m *JobInfo) XXX_Size() int {
	return xxx_messageInfo_JobInfo.Size(m)
}
func (m *JobInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_JobInfo.DiscardUnknown(m)
}

var xxx_messageInfo_JobInfo proto.InternalMessageInfo

func (m *JobInfo) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

func (m *JobInfo) GetJobName() string {
	if m != nil {
		return m.JobName
	}
	return ""
}

func (m *JobInfo) GetPipelineOptions() *_struct.Struct {
	if m != nil {
		return m.PipelineOptions
	}
	return nil
}

func (m *JobInfo) GetState() JobState_Enum {
	if m != nil {
		return m.State
	}
	return JobState_UNSPECIFIED
}

// GetJobs is a synchronus request that returns a list of invoked jobs back
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
type GetJobsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetJobsRequest) Reset()         { *m = GetJobsRequest{} }
func (m *GetJobsRequest) String() string { return proto.CompactTextString(m) }
func (*GetJobsRequest) ProtoMessage()    {}
func (*GetJobsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{7}
}
func (m *GetJobsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobsRequest.Unmarshal(m, b)
}
func (m *GetJobsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobsRequest.Marshal(b, m, deterministic)
}
func (dst *GetJobsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobsRequest.Merge(dst, src)
}
func (m *GetJobsRequest) XXX_Size() int {
	return xxx_messageInfo_GetJobsRequest.Size(m)
}
func (m *GetJobsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobsRequest proto.InternalMessageInfo

type GetJobsResponse struct {
	JobInfo              []*JobInfo `protobuf:"bytes,1,rep,name=job_info,json=jobInfo,proto3" json:"job_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *GetJobsResponse) Reset()         { *m = GetJobsResponse{} }
func (m *GetJobsResponse) String() string { return proto.CompactTextString(m) }
func (*GetJobsResponse) ProtoMessage()    {}
func (*GetJobsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{8}
}
func (m *GetJobsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobsResponse.Unmarshal(m, b)
}
func (m *GetJobsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobsResponse.Marshal(b, m, deterministic)
}
func (dst *GetJobsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobsResponse.Merge(dst, src)
}
func (m *GetJobsResponse) XXX_Size() int {
	return xxx_messageInfo_GetJobsResponse.Size(m)
}
func (m *GetJobsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobsResponse proto.InternalMessageInfo

func (m *GetJobsResponse) GetJobInfo() []*JobInfo {
	if m != nil {
		return m.JobInfo
	}
	return nil
}

// GetState is a synchronus request that returns a job state back
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
// Throws error NOT_FOUND if the jobId is not found
type GetJobStateRequest struct {
	JobId                string   `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetJobStateRequest) Reset()         { *m = GetJobStateRequest{} }
func (m *GetJobStateRequest) String() string { return proto.CompactTextString(m) }
func (*GetJobStateRequest) ProtoMessage()    {}
func (*GetJobStateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{9}
}
func (m *GetJobStateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobStateRequest.Unmarshal(m, b)
}
func (m *GetJobStateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobStateRequest.Marshal(b, m, deterministic)
}
func (dst *GetJobStateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobStateRequest.Merge(dst, src)
}
func (m *GetJobStateRequest) XXX_Size() int {
	return xxx_messageInfo_GetJobStateRequest.Size(m)
}
func (m *GetJobStateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobStateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobStateRequest proto.InternalMessageInfo

func (m *GetJobStateRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

type GetJobStateResponse struct {
	State                JobState_Enum `protobuf:"varint,1,opt,name=state,proto3,enum=org.apache.beam.model.job_management.v1.JobState_Enum" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *GetJobStateResponse) Reset()         { *m = GetJobStateResponse{} }
func (m *GetJobStateResponse) String() string { return proto.CompactTextString(m) }
func (*GetJobStateResponse) ProtoMessage()    {}
func (*GetJobStateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{10}
}
func (m *GetJobStateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobStateResponse.Unmarshal(m, b)
}
func (m *GetJobStateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobStateResponse.Marshal(b, m, deterministic)
}
func (dst *GetJobStateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobStateResponse.Merge(dst, src)
}
func (m *GetJobStateResponse) XXX_Size() int {
	return xxx_messageInfo_GetJobStateResponse.Size(m)
}
func (m *GetJobStateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobStateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobStateResponse proto.InternalMessageInfo

func (m *GetJobStateResponse) GetState() JobState_Enum {
	if m != nil {
		return m.State
	}
	return JobState_UNSPECIFIED
}

// GetPipeline is a synchronus request that returns a pipeline back
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
// Throws error NOT_FOUND if the jobId is not found
type GetJobPipelineRequest struct {
	JobId                string   `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetJobPipelineRequest) Reset()         { *m = GetJobPipelineRequest{} }
func (m *GetJobPipelineRequest) String() string { return proto.CompactTextString(m) }
func (*GetJobPipelineRequest) ProtoMessage()    {}
func (*GetJobPipelineRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{11}
}
func (m *GetJobPipelineRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobPipelineRequest.Unmarshal(m, b)
}
func (m *GetJobPipelineRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobPipelineRequest.Marshal(b, m, deterministic)
}
func (dst *GetJobPipelineRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobPipelineRequest.Merge(dst, src)
}
func (m *GetJobPipelineRequest) XXX_Size() int {
	return xxx_messageInfo_GetJobPipelineRequest.Size(m)
}
func (m *GetJobPipelineRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobPipelineRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobPipelineRequest proto.InternalMessageInfo

func (m *GetJobPipelineRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

type GetJobPipelineResponse struct {
	Pipeline             *pipeline_v1.Pipeline `protobuf:"bytes,1,opt,name=pipeline,proto3" json:"pipeline,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *GetJobPipelineResponse) Reset()         { *m = GetJobPipelineResponse{} }
func (m *GetJobPipelineResponse) String() string { return proto.CompactTextString(m) }
func (*GetJobPipelineResponse) ProtoMessage()    {}
func (*GetJobPipelineResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{12}
}
func (m *GetJobPipelineResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobPipelineResponse.Unmarshal(m, b)
}
func (m *GetJobPipelineResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobPipelineResponse.Marshal(b, m, deterministic)
}
func (dst *GetJobPipelineResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobPipelineResponse.Merge(dst, src)
}
func (m *GetJobPipelineResponse) XXX_Size() int {
	return xxx_messageInfo_GetJobPipelineResponse.Size(m)
}
func (m *GetJobPipelineResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobPipelineResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobPipelineResponse proto.InternalMessageInfo

func (m *GetJobPipelineResponse) GetPipeline() *pipeline_v1.Pipeline {
	if m != nil {
		return m.Pipeline
	}
	return nil
}

// GetJobMessages is a streaming api for streaming job messages from the service
// One request will connect you to the job and you'll get a stream of job state
// and job messages back; one is used for logging and the other for detecting
// the job ended.
type JobMessagesRequest struct {
	JobId                string   `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobMessagesRequest) Reset()         { *m = JobMessagesRequest{} }
func (m *JobMessagesRequest) String() string { return proto.CompactTextString(m) }
func (*JobMessagesRequest) ProtoMessage()    {}
func (*JobMessagesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{13}
}
func (m *JobMessagesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobMessagesRequest.Unmarshal(m, b)
}
func (m *JobMessagesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobMessagesRequest.Marshal(b, m, deterministic)
}
func (dst *JobMessagesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobMessagesRequest.Merge(dst, src)
}
func (m *JobMessagesRequest) XXX_Size() int {
	return xxx_messageInfo_JobMessagesRequest.Size(m)
}
func (m *JobMessagesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_JobMessagesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_JobMessagesRequest proto.InternalMessageInfo

func (m *JobMessagesRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

type JobMessage struct {
	MessageId            string                       `protobuf:"bytes,1,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	Time                 string                       `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	Importance           JobMessage_MessageImportance `protobuf:"varint,3,opt,name=importance,proto3,enum=org.apache.beam.model.job_management.v1.JobMessage_MessageImportance" json:"importance,omitempty"`
	MessageText          string                       `protobuf:"bytes,4,opt,name=message_text,json=messageText,proto3" json:"message_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *JobMessage) Reset()         { *m = JobMessage{} }
func (m *JobMessage) String() string { return proto.CompactTextString(m) }
func (*JobMessage) ProtoMessage()    {}
func (*JobMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{14}
}
func (m *JobMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobMessage.Unmarshal(m, b)
}
func (m *JobMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobMessage.Marshal(b, m, deterministic)
}
func (dst *JobMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobMessage.Merge(dst, src)
}
func (m *JobMessage) XXX_Size() int {
	return xxx_messageInfo_JobMessage.Size(m)
}
func (m *JobMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_JobMessage.DiscardUnknown(m)
}

var xxx_messageInfo_JobMessage proto.InternalMessageInfo

func (m *JobMessage) GetMessageId() string {
	if m != nil {
		return m.MessageId
	}
	return ""
}

func (m *JobMessage) GetTime() string {
	if m != nil {
		return m.Time
	}
	return ""
}

func (m *JobMessage) GetImportance() JobMessage_MessageImportance {
	if m != nil {
		return m.Importance
	}
	return JobMessage_MESSAGE_IMPORTANCE_UNSPECIFIED
}

func (m *JobMessage) GetMessageText() string {
	if m != nil {
		return m.MessageText
	}
	return ""
}

type JobMessagesResponse struct {
	// Types that are valid to be assigned to Response:
	//	*JobMessagesResponse_MessageResponse
	//	*JobMessagesResponse_StateResponse
	Response             isJobMessagesResponse_Response `protobuf_oneof:"response"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *JobMessagesResponse) Reset()         { *m = JobMessagesResponse{} }
func (m *JobMessagesResponse) String() string { return proto.CompactTextString(m) }
func (*JobMessagesResponse) ProtoMessage()    {}
func (*JobMessagesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{15}
}
func (m *JobMessagesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobMessagesResponse.Unmarshal(m, b)
}
func (m *JobMessagesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobMessagesResponse.Marshal(b, m, deterministic)
}
func (dst *JobMessagesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobMessagesResponse.Merge(dst, src)
}
func (m *JobMessagesResponse) XXX_Size() int {
	return xxx_messageInfo_JobMessagesResponse.Size(m)
}
func (m *JobMessagesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_JobMessagesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_JobMessagesResponse proto.InternalMessageInfo

type isJobMessagesResponse_Response interface {
	isJobMessagesResponse_Response()
}

type JobMessagesResponse_MessageResponse struct {
	MessageResponse *JobMessage `protobuf:"bytes,1,opt,name=message_response,json=messageResponse,proto3,oneof"`
}
type JobMessagesResponse_StateResponse struct {
	StateResponse *GetJobStateResponse `protobuf:"bytes,2,opt,name=state_response,json=stateResponse,proto3,oneof"`
}

func (*JobMessagesResponse_MessageResponse) isJobMessagesResponse_Response() {}
func (*JobMessagesResponse_StateResponse) isJobMessagesResponse_Response()   {}

func (m *JobMessagesResponse) GetResponse() isJobMessagesResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *JobMessagesResponse) GetMessageResponse() *JobMessage {
	if x, ok := m.GetResponse().(*JobMessagesResponse_MessageResponse); ok {
		return x.MessageResponse
	}
	return nil
}

func (m *JobMessagesResponse) GetStateResponse() *GetJobStateResponse {
	if x, ok := m.GetResponse().(*JobMessagesResponse_StateResponse); ok {
		return x.StateResponse
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*JobMessagesResponse) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _JobMessagesResponse_OneofMarshaler, _JobMessagesResponse_OneofUnmarshaler, _JobMessagesResponse_OneofSizer, []interface{}{
		(*JobMessagesResponse_MessageResponse)(nil),
		(*JobMessagesResponse_StateResponse)(nil),
	}
}

func _JobMessagesResponse_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*JobMessagesResponse)
	// response
	switch x := m.Response.(type) {
	case *JobMessagesResponse_MessageResponse:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MessageResponse); err != nil {
			return err
		}
	case *JobMessagesResponse_StateResponse:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StateResponse); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("JobMessagesResponse.Response has unexpected type %T", x)
	}
	return nil
}

func _JobMessagesResponse_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*JobMessagesResponse)
	switch tag {
	case 1: // response.message_response
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(JobMessage)
		err := b.DecodeMessage(msg)
		m.Response = &JobMessagesResponse_MessageResponse{msg}
		return true, err
	case 2: // response.state_response
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GetJobStateResponse)
		err := b.DecodeMessage(msg)
		m.Response = &JobMessagesResponse_StateResponse{msg}
		return true, err
	default:
		return false, nil
	}
}

func _JobMessagesResponse_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*JobMessagesResponse)
	// response
	switch x := m.Response.(type) {
	case *JobMessagesResponse_MessageResponse:
		s := proto.Size(x.MessageResponse)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *JobMessagesResponse_StateResponse:
		s := proto.Size(x.StateResponse)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Enumeration of all JobStates
type JobState struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobState) Reset()         { *m = JobState{} }
func (m *JobState) String() string { return proto.CompactTextString(m) }
func (*JobState) ProtoMessage()    {}
func (*JobState) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{16}
}
func (m *JobState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobState.Unmarshal(m, b)
}
func (m *JobState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobState.Marshal(b, m, deterministic)
}
func (dst *JobState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobState.Merge(dst, src)
}
func (m *JobState) XXX_Size() int {
	return xxx_messageInfo_JobState.Size(m)
}
func (m *JobState) XXX_DiscardUnknown() {
	xxx_messageInfo_JobState.DiscardUnknown(m)
}

var xxx_messageInfo_JobState proto.InternalMessageInfo

type GetJobMetricsRequest struct {
	JobId                string   `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetJobMetricsRequest) Reset()         { *m = GetJobMetricsRequest{} }
func (m *GetJobMetricsRequest) String() string { return proto.CompactTextString(m) }
func (*GetJobMetricsRequest) ProtoMessage()    {}
func (*GetJobMetricsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{17}
}
func (m *GetJobMetricsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobMetricsRequest.Unmarshal(m, b)
}
func (m *GetJobMetricsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobMetricsRequest.Marshal(b, m, deterministic)
}
func (dst *GetJobMetricsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobMetricsRequest.Merge(dst, src)
}
func (m *GetJobMetricsRequest) XXX_Size() int {
	return xxx_messageInfo_GetJobMetricsRequest.Size(m)
}
func (m *GetJobMetricsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobMetricsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobMetricsRequest proto.InternalMessageInfo

func (m *GetJobMetricsRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

type GetJobMetricsResponse struct {
	Metrics              *MetricResults `protobuf:"bytes,1,opt,name=metrics,proto3" json:"metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *GetJobMetricsResponse) Reset()         { *m = GetJobMetricsResponse{} }
func (m *GetJobMetricsResponse) String() string { return proto.CompactTextString(m) }
func (*GetJobMetricsResponse) ProtoMessage()    {}
func (*GetJobMetricsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{18}
}
func (m *GetJobMetricsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobMetricsResponse.Unmarshal(m, b)
}
func (m *GetJobMetricsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobMetricsResponse.Marshal(b, m, deterministic)
}
func (dst *GetJobMetricsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobMetricsResponse.Merge(dst, src)
}
func (m *GetJobMetricsResponse) XXX_Size() int {
	return xxx_messageInfo_GetJobMetricsResponse.Size(m)
}
func (m *GetJobMetricsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobMetricsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobMetricsResponse proto.InternalMessageInfo

func (m *GetJobMetricsResponse) GetMetrics() *MetricResults {
	if m != nil {
		return m.Metrics
	}
	return nil
}

// All metrics for a given job.  Runners may support one or the other or both.
type MetricResults struct {
	Attempted            []*pipeline_v1.MonitoringInfo `protobuf:"bytes,1,rep,name=attempted,proto3" json:"attempted,omitempty"`
	Committed            []*pipeline_v1.MonitoringInfo `protobuf:"bytes,2,rep,name=committed,proto3" json:"committed,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *MetricResults) Reset()         { *m = MetricResults{} }
func (m *MetricResults) String() string { return proto.CompactTextString(m) }
func (*MetricResults) ProtoMessage()    {}
func (*MetricResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{19}
}
func (m *MetricResults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MetricResults.Unmarshal(m, b)
}
func (m *MetricResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MetricResults.Marshal(b, m, deterministic)
}
func (dst *MetricResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricResults.Merge(dst, src)
}
func (m *MetricResults) XXX_Size() int {
	return xxx_messageInfo_MetricResults.Size(m)
}
func (m *MetricResults) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricResults.DiscardUnknown(m)
}

var xxx_messageInfo_MetricResults proto.InternalMessageInfo

func (m *MetricResults) GetAttempted() []*pipeline_v1.MonitoringInfo {
	if m != nil {
		return m.Attempted
	}
	return nil
}

func (m *MetricResults) GetCommitted() []*pipeline_v1.MonitoringInfo {
	if m != nil {
		return m.Committed
	}
	return nil
}

// DescribePipelineOptions provides metadata about the options supported by a runner.
// It will be used by the SDK client to validate the options specified by or
// list available options to the user.
// Throws error GRPC_STATUS_UNAVAILABLE if server is down
type DescribePipelineOptionsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DescribePipelineOptionsRequest) Reset()         { *m = DescribePipelineOptionsRequest{} }
func (m *DescribePipelineOptionsRequest) String() string { return proto.CompactTextString(m) }
func (*DescribePipelineOptionsRequest) ProtoMessage()    {}
func (*DescribePipelineOptionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{20}
}
func (m *DescribePipelineOptionsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DescribePipelineOptionsRequest.Unmarshal(m, b)
}
func (m *DescribePipelineOptionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DescribePipelineOptionsRequest.Marshal(b, m, deterministic)
}
func (dst *DescribePipelineOptionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribePipelineOptionsRequest.Merge(dst, src)
}
func (m *DescribePipelineOptionsRequest) XXX_Size() int {
	return xxx_messageInfo_DescribePipelineOptionsRequest.Size(m)
}
func (m *DescribePipelineOptionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribePipelineOptionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DescribePipelineOptionsRequest proto.InternalMessageInfo

// Type for pipeline options.
// Types mirror those of JSON, since that's how pipeline options are serialized.
type PipelineOptionType struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PipelineOptionType) Reset()         { *m = PipelineOptionType{} }
func (m *PipelineOptionType) String() string { return proto.CompactTextString(m) }
func (*PipelineOptionType) ProtoMessage()    {}
func (*PipelineOptionType) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{21}
}
func (m *PipelineOptionType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PipelineOptionType.Unmarshal(m, b)
}
func (m *PipelineOptionType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PipelineOptionType.Marshal(b, m, deterministic)
}
func (dst *PipelineOptionType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PipelineOptionType.Merge(dst, src)
}
func (m *PipelineOptionType) XXX_Size() int {
	return xxx_messageInfo_PipelineOptionType.Size(m)
}
func (m *PipelineOptionType) XXX_DiscardUnknown() {
	xxx_messageInfo_PipelineOptionType.DiscardUnknown(m)
}

var xxx_messageInfo_PipelineOptionType proto.InternalMessageInfo

// Metadata for a pipeline option.
type PipelineOptionDescriptor struct {
	// (Required) The option name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// (Required) Type of option.
	Type PipelineOptionType_Enum `protobuf:"varint,2,opt,name=type,proto3,enum=org.apache.beam.model.job_management.v1.PipelineOptionType_Enum" json:"type,omitempty"`
	// (Optional) Description suitable for display / help text.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// (Optional) Default value.
	DefaultValue string `protobuf:"bytes,4,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	// (Required) The group this option belongs to.
	Group                string   `protobuf:"bytes,5,opt,name=group,proto3" json:"group,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PipelineOptionDescriptor) Reset()         { *m = PipelineOptionDescriptor{} }
func (m *PipelineOptionDescriptor) String() string { return proto.CompactTextString(m) }
func (*PipelineOptionDescriptor) ProtoMessage()    {}
func (*PipelineOptionDescriptor) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{22}
}
func (m *PipelineOptionDescriptor) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PipelineOptionDescriptor.Unmarshal(m, b)
}
func (m *PipelineOptionDescriptor) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PipelineOptionDescriptor.Marshal(b, m, deterministic)
}
func (dst *PipelineOptionDescriptor) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PipelineOptionDescriptor.Merge(dst, src)
}
func (m *PipelineOptionDescriptor) XXX_Size() int {
	return xxx_messageInfo_PipelineOptionDescriptor.Size(m)
}
func (m *PipelineOptionDescriptor) XXX_DiscardUnknown() {
	xxx_messageInfo_PipelineOptionDescriptor.DiscardUnknown(m)
}

var xxx_messageInfo_PipelineOptionDescriptor proto.InternalMessageInfo

func (m *PipelineOptionDescriptor) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PipelineOptionDescriptor) GetType() PipelineOptionType_Enum {
	if m != nil {
		return m.Type
	}
	return PipelineOptionType_STRING
}

func (m *PipelineOptionDescriptor) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *PipelineOptionDescriptor) GetDefaultValue() string {
	if m != nil {
		return m.DefaultValue
	}
	return ""
}

func (m *PipelineOptionDescriptor) GetGroup() string {
	if m != nil {
		return m.Group
	}
	return ""
}

type DescribePipelineOptionsResponse struct {
	// List of pipeline option descriptors.
	Options              []*PipelineOptionDescriptor `protobuf:"bytes,1,rep,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *DescribePipelineOptionsResponse) Reset()         { *m = DescribePipelineOptionsResponse{} }
func (m *DescribePipelineOptionsResponse) String() string { return proto.CompactTextString(m) }
func (*DescribePipelineOptionsResponse) ProtoMessage()    {}
func (*DescribePipelineOptionsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_job_api_0a1706a5eaabebe4, []int{23}
}
func (m *DescribePipelineOptionsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DescribePipelineOptionsResponse.Unmarshal(m, b)
}
func (m *DescribePipelineOptionsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DescribePipelineOptionsResponse.Marshal(b, m, deterministic)
}
func (dst *DescribePipelineOptionsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DescribePipelineOptionsResponse.Merge(dst, src)
}
func (m *DescribePipelineOptionsResponse) XXX_Size() int {
	return xxx_messageInfo_DescribePipelineOptionsResponse.Size(m)
}
func (m *DescribePipelineOptionsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DescribePipelineOptionsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DescribePipelineOptionsResponse proto.InternalMessageInfo

func (m *DescribePipelineOptionsResponse) GetOptions() []*PipelineOptionDescriptor {
	if m != nil {
		return m.Options
	}
	return nil
}

func init() {
	proto.RegisterType((*PrepareJobRequest)(nil), "org.apache.beam.model.job_management.v1.PrepareJobRequest")
	proto.RegisterType((*PrepareJobResponse)(nil), "org.apache.beam.model.job_management.v1.PrepareJobResponse")
	proto.RegisterType((*RunJobRequest)(nil), "org.apache.beam.model.job_management.v1.RunJobRequest")
	proto.RegisterType((*RunJobResponse)(nil), "org.apache.beam.model.job_management.v1.RunJobResponse")
	proto.RegisterType((*CancelJobRequest)(nil), "org.apache.beam.model.job_management.v1.CancelJobRequest")
	proto.RegisterType((*CancelJobResponse)(nil), "org.apache.beam.model.job_management.v1.CancelJobResponse")
	proto.RegisterType((*JobInfo)(nil), "org.apache.beam.model.job_management.v1.JobInfo")
	proto.RegisterType((*GetJobsRequest)(nil), "org.apache.beam.model.job_management.v1.GetJobsRequest")
	proto.RegisterType((*GetJobsResponse)(nil), "org.apache.beam.model.job_management.v1.GetJobsResponse")
	proto.RegisterType((*GetJobStateRequest)(nil), "org.apache.beam.model.job_management.v1.GetJobStateRequest")
	proto.RegisterType((*GetJobStateResponse)(nil), "org.apache.beam.model.job_management.v1.GetJobStateResponse")
	proto.RegisterType((*GetJobPipelineRequest)(nil), "org.apache.beam.model.job_management.v1.GetJobPipelineRequest")
	proto.RegisterType((*GetJobPipelineResponse)(nil), "org.apache.beam.model.job_management.v1.GetJobPipelineResponse")
	proto.RegisterType((*JobMessagesRequest)(nil), "org.apache.beam.model.job_management.v1.JobMessagesRequest")
	proto.RegisterType((*JobMessage)(nil), "org.apache.beam.model.job_management.v1.JobMessage")
	proto.RegisterType((*JobMessagesResponse)(nil), "org.apache.beam.model.job_management.v1.JobMessagesResponse")
	proto.RegisterType((*JobState)(nil), "org.apache.beam.model.job_management.v1.JobState")
	proto.RegisterType((*GetJobMetricsRequest)(nil), "org.apache.beam.model.job_management.v1.GetJobMetricsRequest")
	proto.RegisterType((*GetJobMetricsResponse)(nil), "org.apache.beam.model.job_management.v1.GetJobMetricsResponse")
	proto.RegisterType((*MetricResults)(nil), "org.apache.beam.model.job_management.v1.MetricResults")
	proto.RegisterType((*DescribePipelineOptionsRequest)(nil), "org.apache.beam.model.job_management.v1.DescribePipelineOptionsRequest")
	proto.RegisterType((*PipelineOptionType)(nil), "org.apache.beam.model.job_management.v1.PipelineOptionType")
	proto.RegisterType((*PipelineOptionDescriptor)(nil), "org.apache.beam.model.job_management.v1.PipelineOptionDescriptor")
	proto.RegisterType((*DescribePipelineOptionsResponse)(nil), "org.apache.beam.model.job_management.v1.DescribePipelineOptionsResponse")
	proto.RegisterEnum("org.apache.beam.model.job_management.v1.JobMessage_MessageImportance", JobMessage_MessageImportance_name, JobMessage_MessageImportance_value)
	proto.RegisterEnum("org.apache.beam.model.job_management.v1.JobState_Enum", JobState_Enum_name, JobState_Enum_value)
	proto.RegisterEnum("org.apache.beam.model.job_management.v1.PipelineOptionType_Enum", PipelineOptionType_Enum_name, PipelineOptionType_Enum_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// JobServiceClient is the client API for JobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type JobServiceClient interface {
	// Prepare a job for execution. The job will not be executed until a call is made to run with the
	// returned preparationId.
	Prepare(ctx context.Context, in *PrepareJobRequest, opts ...grpc.CallOption) (*PrepareJobResponse, error)
	// Submit the job for execution
	Run(ctx context.Context, in *RunJobRequest, opts ...grpc.CallOption) (*RunJobResponse, error)
	// Get a list of all invoked jobs
	GetJobs(ctx context.Context, in *GetJobsRequest, opts ...grpc.CallOption) (*GetJobsResponse, error)
	// Get the current state of the job
	GetState(ctx context.Context, in *GetJobStateRequest, opts ...grpc.CallOption) (*GetJobStateResponse, error)
	// Get the job's pipeline
	GetPipeline(ctx context.Context, in *GetJobPipelineRequest, opts ...grpc.CallOption) (*GetJobPipelineResponse, error)
	// Cancel the job
	Cancel(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*CancelJobResponse, error)
	// Subscribe to a stream of state changes of the job, will immediately return the current state of the job as the first response.
	GetStateStream(ctx context.Context, in *GetJobStateRequest, opts ...grpc.CallOption) (JobService_GetStateStreamClient, error)
	// Subscribe to a stream of state changes and messages from the job
	GetMessageStream(ctx context.Context, in *JobMessagesRequest, opts ...grpc.CallOption) (JobService_GetMessageStreamClient, error)
	// Fetch metrics for a given job
	GetJobMetrics(ctx context.Context, in *GetJobMetricsRequest, opts ...grpc.CallOption) (*GetJobMetricsResponse, error)
	// Get the supported pipeline options of the runner
	DescribePipelineOptions(ctx context.Context, in *DescribePipelineOptionsRequest, opts ...grpc.CallOption) (*DescribePipelineOptionsResponse, error)
}

type jobServiceClient struct {
	cc *grpc.ClientConn
}

func NewJobServiceClient(cc *grpc.ClientConn) JobServiceClient {
	return &jobServiceClient{cc}
}

func (c *jobServiceClient) Prepare(ctx context.Context, in *PrepareJobRequest, opts ...grpc.CallOption) (*PrepareJobResponse, error) {
	out := new(PrepareJobResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/Prepare", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) Run(ctx context.Context, in *RunJobRequest, opts ...grpc.CallOption) (*RunJobResponse, error) {
	out := new(RunJobResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/Run", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetJobs(ctx context.Context, in *GetJobsRequest, opts ...grpc.CallOption) (*GetJobsResponse, error) {
	out := new(GetJobsResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/GetJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetState(ctx context.Context, in *GetJobStateRequest, opts ...grpc.CallOption) (*GetJobStateResponse, error) {
	out := new(GetJobStateResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/GetState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetPipeline(ctx context.Context, in *GetJobPipelineRequest, opts ...grpc.CallOption) (*GetJobPipelineResponse, error) {
	out := new(GetJobPipelineResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/GetPipeline", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) Cancel(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*CancelJobResponse, error) {
	out := new(CancelJobResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/Cancel", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetStateStream(ctx context.Context, in *GetJobStateRequest, opts ...grpc.CallOption) (JobService_GetStateStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_JobService_serviceDesc.Streams[0], "/org.apache.beam.model.job_management.v1.JobService/GetStateStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &jobServiceGetStateStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type JobService_GetStateStreamClient interface {
	Recv() (*GetJobStateResponse, error)
	grpc.ClientStream
}

type jobServiceGetStateStreamClient struct {
	grpc.ClientStream
}

func (x *jobServiceGetStateStreamClient) Recv() (*GetJobStateResponse, error) {
	m := new(GetJobStateResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *jobServiceClient) GetMessageStream(ctx context.Context, in *JobMessagesRequest, opts ...grpc.CallOption) (JobService_GetMessageStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_JobService_serviceDesc.Streams[1], "/org.apache.beam.model.job_management.v1.JobService/GetMessageStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &jobServiceGetMessageStreamClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type JobService_GetMessageStreamClient interface {
	Recv() (*JobMessagesResponse, error)
	grpc.ClientStream
}

type jobServiceGetMessageStreamClient struct {
	grpc.ClientStream
}

func (x *jobServiceGetMessageStreamClient) Recv() (*JobMessagesResponse, error) {
	m := new(JobMessagesResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *jobServiceClient) GetJobMetrics(ctx context.Context, in *GetJobMetricsRequest, opts ...grpc.CallOption) (*GetJobMetricsResponse, error) {
	out := new(GetJobMetricsResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/GetJobMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) DescribePipelineOptions(ctx context.Context, in *DescribePipelineOptionsRequest, opts ...grpc.CallOption) (*DescribePipelineOptionsResponse, error) {
	out := new(DescribePipelineOptionsResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.job_management.v1.JobService/DescribePipelineOptions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// JobServiceServer is the server API for JobService service.
type JobServiceServer interface {
	// Prepare a job for execution. The job will not be executed until a call is made to run with the
	// returned preparationId.
	Prepare(context.Context, *PrepareJobRequest) (*PrepareJobResponse, error)
	// Submit the job for execution
	Run(context.Context, *RunJobRequest) (*RunJobResponse, error)
	// Get a list of all invoked jobs
	GetJobs(context.Context, *GetJobsRequest) (*GetJobsResponse, error)
	// Get the current state of the job
	GetState(context.Context, *GetJobStateRequest) (*GetJobStateResponse, error)
	// Get the job's pipeline
	GetPipeline(context.Context, *GetJobPipelineRequest) (*GetJobPipelineResponse, error)
	// Cancel the job
	Cancel(context.Context, *CancelJobRequest) (*CancelJobResponse, error)
	// Subscribe to a stream of state changes of the job, will immediately return the current state of the job as the first response.
	GetStateStream(*GetJobStateRequest, JobService_GetStateStreamServer) error
	// Subscribe to a stream of state changes and messages from the job
	GetMessageStream(*JobMessagesRequest, JobService_GetMessageStreamServer) error
	// Fetch metrics for a given job
	GetJobMetrics(context.Context, *GetJobMetricsRequest) (*GetJobMetricsResponse, error)
	// Get the supported pipeline options of the runner
	DescribePipelineOptions(context.Context, *DescribePipelineOptionsRequest) (*DescribePipelineOptionsResponse, error)
}

func RegisterJobServiceServer(s *grpc.Server, srv JobServiceServer) {
	s.RegisterService(&_JobService_serviceDesc, srv)
}

func _JobService_Prepare_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PrepareJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).Prepare(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/Prepare",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).Prepare(ctx, req.(*PrepareJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_Run_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).Run(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/Run",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).Run(ctx, req.(*RunJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/GetJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetJobs(ctx, req.(*GetJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/GetState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetState(ctx, req.(*GetJobStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/GetPipeline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetPipeline(ctx, req.(*GetJobPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_Cancel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).Cancel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/Cancel",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).Cancel(ctx, req.(*CancelJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetStateStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetJobStateRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(JobServiceServer).GetStateStream(m, &jobServiceGetStateStreamServer{stream})
}

type JobService_GetStateStreamServer interface {
	Send(*GetJobStateResponse) error
	grpc.ServerStream
}

type jobServiceGetStateStreamServer struct {
	grpc.ServerStream
}

func (x *jobServiceGetStateStreamServer) Send(m *GetJobStateResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _JobService_GetMessageStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(JobMessagesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(JobServiceServer).GetMessageStream(m, &jobServiceGetMessageStreamServer{stream})
}

type JobService_GetMessageStreamServer interface {
	Send(*JobMessagesResponse) error
	grpc.ServerStream
}

type jobServiceGetMessageStreamServer struct {
	grpc.ServerStream
}

func (x *jobServiceGetMessageStreamServer) Send(m *JobMessagesResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _JobService_GetJobMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetJobMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/GetJobMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetJobMetrics(ctx, req.(*GetJobMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_DescribePipelineOptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DescribePipelineOptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).DescribePipelineOptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.job_management.v1.JobService/DescribePipelineOptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).DescribePipelineOptions(ctx, req.(*DescribePipelineOptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _JobService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.job_management.v1.JobService",
	HandlerType: (*JobServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Prepare",
			Handler:    _JobService_Prepare_Handler,
		},
		{
			MethodName: "Run",
			Handler:    _JobService_Run_Handler,
		},
		{
			MethodName: "GetJobs",
			Handler:    _JobService_GetJobs_Handler,
		},
		{
			MethodName: "GetState",
			Handler:    _JobService_GetState_Handler,
		},
		{
			MethodName: "GetPipeline",
			Handler:    _JobService_GetPipeline_Handler,
		},
		{
			MethodName: "Cancel",
			Handler:    _JobService_Cancel_Handler,
		},
		{
			MethodName: "GetJobMetrics",
			Handler:    _JobService_GetJobMetrics_Handler,
		},
		{
			MethodName: "DescribePipelineOptions",
			Handler:    _JobService_DescribePipelineOptions_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetStateStream",
			Handler:       _JobService_GetStateStream_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetMessageStream",
			Handler:       _JobService_GetMessageStream_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "beam_job_api.proto",
}

func init() { proto.RegisterFile("beam_job_api.proto", fileDescriptor_beam_job_api_0a1706a5eaabebe4) }

var fileDescriptor_beam_job_api_0a1706a5eaabebe4 = []byte{
	// 1401 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x57, 0xdd, 0x8e, 0xdb, 0x44,
	0x14, 0xae, 0xf3, 0x9f, 0x93, 0x26, 0xeb, 0x9d, 0xed, 0xb2, 0x69, 0x04, 0x65, 0x31, 0x82, 0x16,
	0x55, 0xb8, 0xdd, 0x54, 0xa2, 0xd0, 0x42, 0xc1, 0xd9, 0xb8, 0x69, 0xc2, 0x6e, 0x12, 0x4d, 0xb2,
	0x20, 0x40, 0x22, 0x38, 0xc9, 0x6c, 0x70, 0x89, 0x3d, 0xc6, 0x9e, 0x44, 0xad, 0x84, 0x40, 0x02,
	0x71, 0x09, 0xbc, 0x00, 0x2f, 0x80, 0x84, 0x84, 0xb8, 0xe6, 0x19, 0x78, 0x08, 0x24, 0xae, 0x78,
	0x05, 0x6e, 0xd0, 0xd8, 0xe3, 0x6c, 0xbc, 0x3f, 0x6c, 0x92, 0x16, 0x71, 0x15, 0xcf, 0xf9, 0xf9,
	0xce, 0xef, 0x9c, 0x39, 0x01, 0xd4, 0x27, 0x86, 0xd5, 0x7b, 0x48, 0xfb, 0x3d, 0xc3, 0x31, 0x55,
	0xc7, 0xa5, 0x8c, 0xa2, 0xab, 0xd4, 0x1d, 0xa9, 0x86, 0x63, 0x0c, 0x3e, 0x25, 0x2a, 0x67, 0xab,
	0x16, 0x1d, 0x92, 0xb1, 0xca, 0x85, 0x2c, 0xc3, 0x36, 0x46, 0xc4, 0x22, 0x36, 0x53, 0xa7, 0x3b,
	0xa5, 0x4d, 0x5f, 0xd9, 0x9d, 0xd8, 0x36, 0x71, 0x8f, 0xf4, 0x4b, 0x6b, 0xc4, 0x1e, 0x3a, 0xd4,
	0xb4, 0x99, 0x27, 0x08, 0xcf, 0x8e, 0x28, 0x1d, 0x8d, 0xc9, 0x0d, 0xff, 0xd4, 0x9f, 0x1c, 0xde,
	0xf0, 0x98, 0x3b, 0x19, 0x30, 0xc1, 0xcd, 0x5b, 0x84, 0xb9, 0xe6, 0x40, 0x08, 0x2b, 0xbf, 0x49,
	0xb0, 0xde, 0x76, 0x89, 0x63, 0xb8, 0xa4, 0x41, 0xfb, 0x98, 0x7c, 0x3e, 0x21, 0x1e, 0x43, 0x35,
	0xc8, 0x38, 0xa6, 0x43, 0xc6, 0xa6, 0x4d, 0x8a, 0xd2, 0xb6, 0x74, 0x2d, 0x57, 0xbe, 0xae, 0x9e,
	0xee, 0x66, 0x28, 0xa6, 0x4e, 0x77, 0xd4, 0xb6, 0xf8, 0xc6, 0x33, 0x65, 0x54, 0x01, 0x39, 0xfc,
	0xee, 0x51, 0x87, 0x99, 0xd4, 0xf6, 0x8a, 0x31, 0x1f, 0x70, 0x4b, 0x0d, 0xdc, 0x54, 0x43, 0x37,
	0xd5, 0x8e, 0xef, 0x26, 0x5e, 0x0b, 0x15, 0x5a, 0x81, 0x3c, 0xba, 0x0c, 0x19, 0x9e, 0x0c, 0xdb,
	0xb0, 0x48, 0x31, 0xbe, 0x2d, 0x5d, 0xcb, 0xe2, 0xf4, 0x43, 0xda, 0x6f, 0x1a, 0x16, 0x51, 0xfe,
	0x94, 0x00, 0xcd, 0x7b, 0xef, 0x39, 0xd4, 0xf6, 0x08, 0x7a, 0x09, 0x0a, 0x8e, 0x4f, 0x35, 0x38,
	0x42, 0xcf, 0x1c, 0xfa, 0x41, 0x64, 0x71, 0x7e, 0x8e, 0x5a, 0x1f, 0x22, 0x0f, 0x2e, 0x1b, 0x2e,
	0x33, 0x0f, 0x8d, 0x01, 0xeb, 0x79, 0xcc, 0x18, 0x99, 0xf6, 0xa8, 0x17, 0x26, 0x53, 0x78, 0x79,
	0x7b, 0x81, 0xb0, 0x35, 0xc7, 0xec, 0x10, 0x77, 0x6a, 0x0e, 0x48, 0x95, 0x78, 0x03, 0xd7, 0x74,
	0x18, 0x75, 0xf1, 0x56, 0x88, 0xdc, 0x09, 0x80, 0x75, 0x81, 0x8b, 0xca, 0xb0, 0x19, 0xda, 0xf2,
	0x88, 0xe7, 0x71, 0xff, 0x18, 0xfd, 0x8c, 0xd8, 0x22, 0xb4, 0x0d, 0xc1, 0xec, 0x04, 0xbc, 0x2e,
	0x67, 0x29, 0x3d, 0xc8, 0xe3, 0x89, 0x3d, 0x57, 0x9f, 0x05, 0x03, 0xbc, 0x0a, 0x6b, 0x2e, 0xaf,
	0x36, 0x99, 0x1a, 0x63, 0x61, 0x25, 0xe6, 0xcb, 0x15, 0x66, 0xe4, 0xc0, 0xc0, 0x55, 0x28, 0x84,
	0x06, 0x44, 0x0a, 0x37, 0x21, 0xc5, 0x93, 0x3e, 0x43, 0x4e, 0x3e, 0xa4, 0xfd, 0xfa, 0x50, 0x79,
	0x05, 0xe4, 0x5d, 0xc3, 0x1e, 0x90, 0xf1, 0x9c, 0x33, 0x67, 0x88, 0x1a, 0xb0, 0x3e, 0x27, 0x2a,
	0x60, 0xf7, 0x20, 0xe9, 0x31, 0x83, 0x05, 0x5d, 0x55, 0x28, 0xbf, 0xa6, 0x2e, 0xd8, 0xfc, 0x6a,
	0x83, 0xf6, 0x3b, 0x5c, 0x51, 0xd5, 0xed, 0x89, 0x85, 0x03, 0x10, 0xe5, 0x77, 0x09, 0xd2, 0x0d,
	0xda, 0xaf, 0xdb, 0x87, 0xf4, 0x0c, 0x2f, 0x22, 0xcd, 0x13, 0x8b, 0x34, 0xcf, 0xa9, 0xbd, 0x19,
	0x5f, 0xb2, 0x37, 0x67, 0xf1, 0x24, 0x9e, 0x46, 0x3c, 0x32, 0x14, 0x6a, 0x84, 0x35, 0x68, 0xdf,
	0x13, 0xb9, 0x55, 0x3e, 0x86, 0xb5, 0x19, 0x45, 0xa4, 0xf0, 0xdd, 0x20, 0x22, 0xd3, 0x3e, 0xa4,
	0x45, 0x69, 0x3b, 0x7e, 0x2d, 0x57, 0xbe, 0xb9, 0x8c, 0x55, 0x9e, 0x2c, 0x3f, 0x07, 0xfc, 0x43,
	0xb9, 0x0e, 0x28, 0xc0, 0xf7, 0x9d, 0x39, 0xa7, 0xa2, 0x03, 0xd8, 0x88, 0x08, 0xff, 0x27, 0x35,
	0x55, 0x61, 0x33, 0x30, 0x32, 0x9b, 0x26, 0xe7, 0xb5, 0xd9, 0x33, 0xc7, 0xe5, 0x85, 0x5f, 0x4f,
	0x6b, 0x88, 0xf1, 0x24, 0x35, 0x68, 0x7f, 0x9f, 0x78, 0x9e, 0x31, 0x22, 0xde, 0x39, 0xfe, 0xfc,
	0x1d, 0x03, 0x38, 0x92, 0x46, 0xcf, 0x01, 0x58, 0xc1, 0xe7, 0x91, 0x64, 0x56, 0x50, 0xea, 0x43,
	0x84, 0x20, 0xc1, 0xcc, 0x59, 0x6b, 0xfa, 0xdf, 0x88, 0x00, 0x98, 0x96, 0x43, 0x5d, 0xc6, 0x6f,
	0x8f, 0xdf, 0x91, 0x85, 0xb2, 0xbe, 0x4c, 0x52, 0x85, 0x6d, 0x55, 0xfc, 0xd6, 0x67, 0x60, 0x78,
	0x0e, 0x18, 0xbd, 0x00, 0x17, 0x43, 0xcf, 0x18, 0x79, 0xc4, 0xfc, 0x0e, 0xce, 0xe2, 0x9c, 0xa0,
	0x75, 0xc9, 0x23, 0xa6, 0xfc, 0x22, 0xc1, 0xfa, 0x09, 0x10, 0xa4, 0xc0, 0x95, 0x7d, 0xbd, 0xd3,
	0xd1, 0x6a, 0x7a, 0xaf, 0xbe, 0xdf, 0x6e, 0xe1, 0xae, 0xd6, 0xdc, 0xd5, 0x7b, 0x07, 0xcd, 0x4e,
	0x5b, 0xdf, 0xad, 0xdf, 0xaf, 0xeb, 0x55, 0xf9, 0x02, 0xda, 0x84, 0xf5, 0x46, 0xab, 0xd2, 0x0b,
	0xe5, 0xaa, 0x7a, 0xe5, 0xa0, 0x26, 0x4b, 0xa8, 0x08, 0x97, 0xa2, 0xe4, 0xae, 0x56, 0xdf, 0xd3,
	0xab, 0x72, 0xec, 0xb8, 0x42, 0x45, 0xeb, 0xd4, 0x77, 0xe5, 0x38, 0xda, 0x82, 0x8d, 0x79, 0xf2,
	0xfb, 0x1a, 0x6e, 0xd6, 0x9b, 0x35, 0x39, 0x71, 0x5c, 0x5e, 0xc7, 0xb8, 0x85, 0xe5, 0xa4, 0xf2,
	0x97, 0x04, 0x1b, 0x91, 0x5a, 0x89, 0x5e, 0xf8, 0x04, 0xe4, 0x30, 0x58, 0x57, 0xd0, 0x44, 0x4f,
	0xdc, 0x5a, 0x21, 0xb3, 0x0f, 0x2e, 0xe0, 0x35, 0x01, 0x37, 0xb3, 0x40, 0xa0, 0xe0, 0x37, 0xf0,
	0x11, 0x7e, 0xf0, 0x82, 0xbc, 0xb9, 0x30, 0xfe, 0x29, 0x77, 0xeb, 0xc1, 0x05, 0x9c, 0xf7, 0xe6,
	0x09, 0x15, 0x80, 0x4c, 0x68, 0x40, 0xf9, 0x49, 0x82, 0x4c, 0xa8, 0xa1, 0xfc, 0x28, 0x41, 0x82,
	0xdf, 0x23, 0xb4, 0x06, 0xb9, 0x68, 0x2d, 0x72, 0x90, 0xee, 0x74, 0x5b, 0xed, 0xb6, 0x5e, 0x95,
	0x25, 0x7e, 0xc0, 0x07, 0x4d, 0x3f, 0x89, 0x31, 0x94, 0x81, 0x44, 0xb5, 0xd5, 0xd4, 0xe5, 0x38,
	0x02, 0x48, 0xdd, 0x0f, 0x4a, 0x91, 0x40, 0x79, 0xc8, 0xee, 0xf2, 0x92, 0xee, 0xf1, 0x63, 0x92,
	0x6b, 0x1c, 0xb4, 0xab, 0x5a, 0x57, 0xaf, 0xca, 0x29, 0x74, 0x11, 0x32, 0x55, 0xac, 0xd5, 0x7d,
	0xfd, 0x34, 0x67, 0xf9, 0x27, 0xbd, 0x2a, 0x67, 0x38, 0xab, 0xd3, 0xd5, 0x70, 0x97, 0xb3, 0xb2,
	0xa8, 0x00, 0x20, 0x40, 0xf8, 0x19, 0x94, 0x57, 0xe1, 0x52, 0x10, 0xdf, 0x7e, 0xb0, 0x7e, 0x9c,
	0x73, 0x8b, 0xcc, 0x70, 0x0a, 0xcc, 0xc4, 0x45, 0x9a, 0xdb, 0x90, 0x16, 0x0b, 0x8c, 0xa8, 0xdf,
	0xe2, 0xe3, 0x26, 0x80, 0xc2, 0xc4, 0x9b, 0x8c, 0x99, 0x87, 0x43, 0x18, 0xe5, 0x57, 0x09, 0xf2,
	0x11, 0x16, 0x6a, 0x41, 0xd6, 0x60, 0x8c, 0x58, 0x0e, 0x23, 0x43, 0x31, 0x62, 0x77, 0x16, 0x98,
	0x1c, 0xfb, 0xd4, 0x36, 0x19, 0x75, 0x4d, 0x7b, 0xe4, 0xcf, 0xd8, 0x23, 0x0c, 0x0e, 0x38, 0xa0,
	0x96, 0x65, 0x32, 0x0e, 0x18, 0x5b, 0x19, 0x70, 0x86, 0xa1, 0x6c, 0xc3, 0x95, 0x60, 0xd7, 0xe8,
	0x93, 0x76, 0xf4, 0x45, 0x0a, 0x1f, 0x0e, 0x02, 0x28, 0xca, 0xe9, 0x3e, 0x76, 0x88, 0xd2, 0x12,
	0x3d, 0x02, 0x90, 0xea, 0x74, 0x31, 0xaf, 0x8c, 0xdf, 0x1e, 0x95, 0x56, 0x6b, 0x4f, 0xd7, 0x9a,
	0x41, 0x7b, 0xd4, 0x9b, 0x5d, 0xbd, 0xa6, 0x63, 0x39, 0xc6, 0xa5, 0x9a, 0x07, 0xfb, 0x15, 0x1d,
	0xcb, 0x71, 0x94, 0x85, 0xa4, 0x86, 0xb1, 0xf6, 0x81, 0x9c, 0xe0, 0xe4, 0x56, 0xa5, 0xa1, 0xef,
	0x76, 0xe5, 0xa4, 0xf2, 0x87, 0x04, 0xc5, 0xa8, 0x9d, 0xa3, 0x1d, 0x88, 0x0f, 0x37, 0xff, 0xdd,
	0x0d, 0x2a, 0xeb, 0x7f, 0xa3, 0x2e, 0x24, 0xd8, 0x63, 0x27, 0xb8, 0x1c, 0x85, 0xf2, 0x3b, 0x0b,
	0x17, 0xef, 0x64, 0x30, 0xc1, 0xab, 0xe1, 0xa3, 0xa1, 0x6d, 0xc8, 0x0d, 0x85, 0x5d, 0x93, 0x86,
	0xab, 0xd4, 0x3c, 0x09, 0xbd, 0x08, 0xf9, 0x21, 0x39, 0x34, 0x26, 0x63, 0xd6, 0x9b, 0x1a, 0xe3,
	0x09, 0x11, 0xe3, 0xee, 0xa2, 0x20, 0xbe, 0xc7, 0x69, 0xe8, 0x12, 0x24, 0x47, 0x2e, 0x9d, 0x38,
	0xc5, 0x64, 0xd0, 0x8b, 0xfe, 0x41, 0xf9, 0x12, 0x9e, 0x3f, 0x33, 0xd9, 0xa2, 0x2b, 0x3f, 0x82,
	0x74, 0xb8, 0x41, 0x04, 0xfd, 0xa2, 0xad, 0x18, 0xd8, 0xdc, 0x06, 0x19, 0x22, 0x96, 0xbf, 0xc9,
	0xf9, 0x2f, 0x8a, 0xd8, 0x31, 0xd1, 0xd7, 0x12, 0xa4, 0xc5, 0xce, 0x8b, 0xee, 0x2c, 0x6e, 0xe6,
	0xf8, 0x8e, 0x5f, 0xba, 0xbb, 0x92, 0xae, 0x08, 0x78, 0x0a, 0x71, 0x3c, 0xb1, 0xd1, 0xe2, 0x97,
	0x2f, 0xb2, 0xbf, 0x96, 0x6e, 0x2f, 0xad, 0x27, 0xec, 0x7e, 0x01, 0x69, 0xb1, 0x0f, 0xa1, 0xdb,
	0x4b, 0x0e, 0xd6, 0xf0, 0x6a, 0x94, 0x5e, 0x5f, 0x5e, 0x51, 0x58, 0xff, 0x56, 0x82, 0x4c, 0x8d,
	0x30, 0x7f, 0xe0, 0xa2, 0xbb, 0xab, 0x0d, 0xf6, 0xc0, 0x87, 0x27, 0x7a, 0x15, 0xd0, 0xf7, 0x12,
	0xe4, 0x6a, 0x84, 0x85, 0xad, 0x83, 0xee, 0x2d, 0x89, 0x76, 0x6c, 0xb5, 0x2a, 0xbd, 0xbd, 0xb2,
	0xbe, 0x70, 0xe8, 0x2b, 0x48, 0x05, 0xbb, 0x3e, 0x7a, 0x63, 0x61, 0xa8, 0xe3, 0xff, 0x23, 0x4a,
	0x77, 0x56, 0x51, 0x15, 0x0e, 0x7c, 0x27, 0xf9, 0xab, 0xb3, 0x9f, 0xa6, 0x0e, 0x73, 0x89, 0x61,
	0xfd, 0x8f, 0xf5, 0xb9, 0x29, 0xa1, 0x1f, 0x24, 0x90, 0x6b, 0x84, 0x89, 0x7d, 0x61, 0x69, 0x8f,
	0x4e, 0xae, 0x9b, 0x4b, 0x78, 0x74, 0xca, 0xfe, 0x73, 0x53, 0xe2, 0x3d, 0x93, 0x8f, 0x3c, 0xa9,
	0xe8, 0xad, 0x25, 0x63, 0x8c, 0xbe, 0xdc, 0xa5, 0x7b, 0xab, 0xaa, 0x8b, 0x92, 0xfd, 0x2c, 0xc1,
	0xd6, 0x19, 0x73, 0x15, 0xd5, 0x16, 0xc6, 0xfe, 0xf7, 0x67, 0xb0, 0xf4, 0xe0, 0xc9, 0x81, 0xc4,
	0xe2, 0x55, 0x81, 0x97, 0xcf, 0x84, 0x8a, 0x20, 0x55, 0x52, 0x0d, 0xda, 0xd7, 0x1c, 0xf3, 0x43,
	0x39, 0xc2, 0xe9, 0x4d, 0x77, 0xfa, 0x29, 0xff, 0xff, 0xe4, 0xad, 0x7f, 0x02, 0x00, 0x00, 0xff,
	0xff, 0xa3, 0xce, 0x16, 0x90, 0x07, 0x12, 0x00, 0x00,
}
