// Code generated by protoc-gen-go. DO NOT EDIT.
// source: beam_fn_api.proto

package fnexecution_v1

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import pipeline_v1 "github.com/apache/beam/sdks/go/pkg/beam/model/pipeline_v1"
import _ "github.com/golang/protobuf/protoc-gen-go/descriptor"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "github.com/golang/protobuf/ptypes/wrappers"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type LogEntry_Severity_Enum int32

const (
	// Unspecified level information. Will be logged at the TRACE level.
	LogEntry_Severity_UNSPECIFIED LogEntry_Severity_Enum = 0
	LogEntry_Severity_TRACE       LogEntry_Severity_Enum = 1
	// Debugging information.
	LogEntry_Severity_DEBUG LogEntry_Severity_Enum = 2
	// Normal events.
	LogEntry_Severity_INFO LogEntry_Severity_Enum = 3
	// Normal but significant events, such as start up, shut down, or
	// configuration.
	LogEntry_Severity_NOTICE LogEntry_Severity_Enum = 4
	// Warning events might cause problems.
	LogEntry_Severity_WARN LogEntry_Severity_Enum = 5
	// Error events are likely to cause problems.
	LogEntry_Severity_ERROR LogEntry_Severity_Enum = 6
	// Critical events cause severe problems or brief outages and may
	// indicate that a person must take action.
	LogEntry_Severity_CRITICAL LogEntry_Severity_Enum = 7
)

var LogEntry_Severity_Enum_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "TRACE",
	2: "DEBUG",
	3: "INFO",
	4: "NOTICE",
	5: "WARN",
	6: "ERROR",
	7: "CRITICAL",
}
var LogEntry_Severity_Enum_value = map[string]int32{
	"UNSPECIFIED": 0,
	"TRACE":       1,
	"DEBUG":       2,
	"INFO":        3,
	"NOTICE":      4,
	"WARN":        5,
	"ERROR":       6,
	"CRITICAL":    7,
}

func (x LogEntry_Severity_Enum) String() string {
	return proto.EnumName(LogEntry_Severity_Enum_name, int32(x))
}
func (LogEntry_Severity_Enum) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{27, 1, 0}
}

// A descriptor for connecting to a remote port using the Beam Fn Data API.
// Allows for communication between two environments (for example between the
// runner and the SDK).
// Stable
type RemoteGrpcPort struct {
	// (Required) An API descriptor which describes where to
	// connect to including any authentication that is required.
	ApiServiceDescriptor *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,1,opt,name=api_service_descriptor,json=apiServiceDescriptor,proto3" json:"api_service_descriptor,omitempty"`
	// (Required) The ID of the Coder that will be used to encode and decode data
	// sent over this port.
	CoderId              string   `protobuf:"bytes,2,opt,name=coder_id,json=coderId,proto3" json:"coder_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoteGrpcPort) Reset()         { *m = RemoteGrpcPort{} }
func (m *RemoteGrpcPort) String() string { return proto.CompactTextString(m) }
func (*RemoteGrpcPort) ProtoMessage()    {}
func (*RemoteGrpcPort) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{0}
}
func (m *RemoteGrpcPort) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoteGrpcPort.Unmarshal(m, b)
}
func (m *RemoteGrpcPort) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoteGrpcPort.Marshal(b, m, deterministic)
}
func (dst *RemoteGrpcPort) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoteGrpcPort.Merge(dst, src)
}
func (m *RemoteGrpcPort) XXX_Size() int {
	return xxx_messageInfo_RemoteGrpcPort.Size(m)
}
func (m *RemoteGrpcPort) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoteGrpcPort.DiscardUnknown(m)
}

var xxx_messageInfo_RemoteGrpcPort proto.InternalMessageInfo

func (m *RemoteGrpcPort) GetApiServiceDescriptor() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.ApiServiceDescriptor
	}
	return nil
}

func (m *RemoteGrpcPort) GetCoderId() string {
	if m != nil {
		return m.CoderId
	}
	return ""
}

// A request sent by a runner which the SDK is asked to fulfill.
// For any unsupported request type, an error should be returned with a
// matching instruction id.
// Stable
type InstructionRequest struct {
	// (Required) An unique identifier provided by the runner which represents
	// this requests execution. The InstructionResponse MUST have the matching id.
	InstructionId string `protobuf:"bytes,1,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	// (Required) A request that the SDK Harness needs to interpret.
	//
	// Types that are valid to be assigned to Request:
	//	*InstructionRequest_Register
	//	*InstructionRequest_ProcessBundle
	//	*InstructionRequest_ProcessBundleProgress
	//	*InstructionRequest_ProcessBundleSplit
	//	*InstructionRequest_FinalizeBundle
	Request              isInstructionRequest_Request `protobuf_oneof:"request"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *InstructionRequest) Reset()         { *m = InstructionRequest{} }
func (m *InstructionRequest) String() string { return proto.CompactTextString(m) }
func (*InstructionRequest) ProtoMessage()    {}
func (*InstructionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{1}
}
func (m *InstructionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstructionRequest.Unmarshal(m, b)
}
func (m *InstructionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstructionRequest.Marshal(b, m, deterministic)
}
func (dst *InstructionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstructionRequest.Merge(dst, src)
}
func (m *InstructionRequest) XXX_Size() int {
	return xxx_messageInfo_InstructionRequest.Size(m)
}
func (m *InstructionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_InstructionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_InstructionRequest proto.InternalMessageInfo

type isInstructionRequest_Request interface {
	isInstructionRequest_Request()
}

type InstructionRequest_Register struct {
	Register *RegisterRequest `protobuf:"bytes,1000,opt,name=register,proto3,oneof"`
}
type InstructionRequest_ProcessBundle struct {
	ProcessBundle *ProcessBundleRequest `protobuf:"bytes,1001,opt,name=process_bundle,json=processBundle,proto3,oneof"`
}
type InstructionRequest_ProcessBundleProgress struct {
	ProcessBundleProgress *ProcessBundleProgressRequest `protobuf:"bytes,1002,opt,name=process_bundle_progress,json=processBundleProgress,proto3,oneof"`
}
type InstructionRequest_ProcessBundleSplit struct {
	ProcessBundleSplit *ProcessBundleSplitRequest `protobuf:"bytes,1003,opt,name=process_bundle_split,json=processBundleSplit,proto3,oneof"`
}
type InstructionRequest_FinalizeBundle struct {
	FinalizeBundle *FinalizeBundleRequest `protobuf:"bytes,1004,opt,name=finalize_bundle,json=finalizeBundle,proto3,oneof"`
}

func (*InstructionRequest_Register) isInstructionRequest_Request()              {}
func (*InstructionRequest_ProcessBundle) isInstructionRequest_Request()         {}
func (*InstructionRequest_ProcessBundleProgress) isInstructionRequest_Request() {}
func (*InstructionRequest_ProcessBundleSplit) isInstructionRequest_Request()    {}
func (*InstructionRequest_FinalizeBundle) isInstructionRequest_Request()        {}

func (m *InstructionRequest) GetRequest() isInstructionRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *InstructionRequest) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

func (m *InstructionRequest) GetRegister() *RegisterRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_Register); ok {
		return x.Register
	}
	return nil
}

func (m *InstructionRequest) GetProcessBundle() *ProcessBundleRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_ProcessBundle); ok {
		return x.ProcessBundle
	}
	return nil
}

func (m *InstructionRequest) GetProcessBundleProgress() *ProcessBundleProgressRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_ProcessBundleProgress); ok {
		return x.ProcessBundleProgress
	}
	return nil
}

func (m *InstructionRequest) GetProcessBundleSplit() *ProcessBundleSplitRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_ProcessBundleSplit); ok {
		return x.ProcessBundleSplit
	}
	return nil
}

func (m *InstructionRequest) GetFinalizeBundle() *FinalizeBundleRequest {
	if x, ok := m.GetRequest().(*InstructionRequest_FinalizeBundle); ok {
		return x.FinalizeBundle
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*InstructionRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _InstructionRequest_OneofMarshaler, _InstructionRequest_OneofUnmarshaler, _InstructionRequest_OneofSizer, []interface{}{
		(*InstructionRequest_Register)(nil),
		(*InstructionRequest_ProcessBundle)(nil),
		(*InstructionRequest_ProcessBundleProgress)(nil),
		(*InstructionRequest_ProcessBundleSplit)(nil),
		(*InstructionRequest_FinalizeBundle)(nil),
	}
}

func _InstructionRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*InstructionRequest)
	// request
	switch x := m.Request.(type) {
	case *InstructionRequest_Register:
		b.EncodeVarint(1000<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Register); err != nil {
			return err
		}
	case *InstructionRequest_ProcessBundle:
		b.EncodeVarint(1001<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProcessBundle); err != nil {
			return err
		}
	case *InstructionRequest_ProcessBundleProgress:
		b.EncodeVarint(1002<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProcessBundleProgress); err != nil {
			return err
		}
	case *InstructionRequest_ProcessBundleSplit:
		b.EncodeVarint(1003<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProcessBundleSplit); err != nil {
			return err
		}
	case *InstructionRequest_FinalizeBundle:
		b.EncodeVarint(1004<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.FinalizeBundle); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("InstructionRequest.Request has unexpected type %T", x)
	}
	return nil
}

func _InstructionRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*InstructionRequest)
	switch tag {
	case 1000: // request.register
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RegisterRequest)
		err := b.DecodeMessage(msg)
		m.Request = &InstructionRequest_Register{msg}
		return true, err
	case 1001: // request.process_bundle
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProcessBundleRequest)
		err := b.DecodeMessage(msg)
		m.Request = &InstructionRequest_ProcessBundle{msg}
		return true, err
	case 1002: // request.process_bundle_progress
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProcessBundleProgressRequest)
		err := b.DecodeMessage(msg)
		m.Request = &InstructionRequest_ProcessBundleProgress{msg}
		return true, err
	case 1003: // request.process_bundle_split
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProcessBundleSplitRequest)
		err := b.DecodeMessage(msg)
		m.Request = &InstructionRequest_ProcessBundleSplit{msg}
		return true, err
	case 1004: // request.finalize_bundle
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(FinalizeBundleRequest)
		err := b.DecodeMessage(msg)
		m.Request = &InstructionRequest_FinalizeBundle{msg}
		return true, err
	default:
		return false, nil
	}
}

func _InstructionRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*InstructionRequest)
	// request
	switch x := m.Request.(type) {
	case *InstructionRequest_Register:
		s := proto.Size(x.Register)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionRequest_ProcessBundle:
		s := proto.Size(x.ProcessBundle)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionRequest_ProcessBundleProgress:
		s := proto.Size(x.ProcessBundleProgress)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionRequest_ProcessBundleSplit:
		s := proto.Size(x.ProcessBundleSplit)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionRequest_FinalizeBundle:
		s := proto.Size(x.FinalizeBundle)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The response for an associated request the SDK had been asked to fulfill.
// Stable
type InstructionResponse struct {
	// (Required) A reference provided by the runner which represents a requests
	// execution. The InstructionResponse MUST have the matching id when
	// responding to the runner.
	InstructionId string `protobuf:"bytes,1,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	// If this is specified, then this instruction has failed.
	// A human readable string representing the reason as to why processing has
	// failed.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// If the instruction did not fail, it is required to return an equivalent
	// response type depending on the request this matches.
	//
	// Types that are valid to be assigned to Response:
	//	*InstructionResponse_Register
	//	*InstructionResponse_ProcessBundle
	//	*InstructionResponse_ProcessBundleProgress
	//	*InstructionResponse_ProcessBundleSplit
	//	*InstructionResponse_FinalizeBundle
	Response             isInstructionResponse_Response `protobuf_oneof:"response"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *InstructionResponse) Reset()         { *m = InstructionResponse{} }
func (m *InstructionResponse) String() string { return proto.CompactTextString(m) }
func (*InstructionResponse) ProtoMessage()    {}
func (*InstructionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{2}
}
func (m *InstructionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstructionResponse.Unmarshal(m, b)
}
func (m *InstructionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstructionResponse.Marshal(b, m, deterministic)
}
func (dst *InstructionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstructionResponse.Merge(dst, src)
}
func (m *InstructionResponse) XXX_Size() int {
	return xxx_messageInfo_InstructionResponse.Size(m)
}
func (m *InstructionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_InstructionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_InstructionResponse proto.InternalMessageInfo

type isInstructionResponse_Response interface {
	isInstructionResponse_Response()
}

type InstructionResponse_Register struct {
	Register *RegisterResponse `protobuf:"bytes,1000,opt,name=register,proto3,oneof"`
}
type InstructionResponse_ProcessBundle struct {
	ProcessBundle *ProcessBundleResponse `protobuf:"bytes,1001,opt,name=process_bundle,json=processBundle,proto3,oneof"`
}
type InstructionResponse_ProcessBundleProgress struct {
	ProcessBundleProgress *ProcessBundleProgressResponse `protobuf:"bytes,1002,opt,name=process_bundle_progress,json=processBundleProgress,proto3,oneof"`
}
type InstructionResponse_ProcessBundleSplit struct {
	ProcessBundleSplit *ProcessBundleSplitResponse `protobuf:"bytes,1003,opt,name=process_bundle_split,json=processBundleSplit,proto3,oneof"`
}
type InstructionResponse_FinalizeBundle struct {
	FinalizeBundle *FinalizeBundleResponse `protobuf:"bytes,1004,opt,name=finalize_bundle,json=finalizeBundle,proto3,oneof"`
}

func (*InstructionResponse_Register) isInstructionResponse_Response()              {}
func (*InstructionResponse_ProcessBundle) isInstructionResponse_Response()         {}
func (*InstructionResponse_ProcessBundleProgress) isInstructionResponse_Response() {}
func (*InstructionResponse_ProcessBundleSplit) isInstructionResponse_Response()    {}
func (*InstructionResponse_FinalizeBundle) isInstructionResponse_Response()        {}

func (m *InstructionResponse) GetResponse() isInstructionResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *InstructionResponse) GetInstructionId() string {
	if m != nil {
		return m.InstructionId
	}
	return ""
}

func (m *InstructionResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *InstructionResponse) GetRegister() *RegisterResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_Register); ok {
		return x.Register
	}
	return nil
}

func (m *InstructionResponse) GetProcessBundle() *ProcessBundleResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_ProcessBundle); ok {
		return x.ProcessBundle
	}
	return nil
}

func (m *InstructionResponse) GetProcessBundleProgress() *ProcessBundleProgressResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_ProcessBundleProgress); ok {
		return x.ProcessBundleProgress
	}
	return nil
}

func (m *InstructionResponse) GetProcessBundleSplit() *ProcessBundleSplitResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_ProcessBundleSplit); ok {
		return x.ProcessBundleSplit
	}
	return nil
}

func (m *InstructionResponse) GetFinalizeBundle() *FinalizeBundleResponse {
	if x, ok := m.GetResponse().(*InstructionResponse_FinalizeBundle); ok {
		return x.FinalizeBundle
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*InstructionResponse) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _InstructionResponse_OneofMarshaler, _InstructionResponse_OneofUnmarshaler, _InstructionResponse_OneofSizer, []interface{}{
		(*InstructionResponse_Register)(nil),
		(*InstructionResponse_ProcessBundle)(nil),
		(*InstructionResponse_ProcessBundleProgress)(nil),
		(*InstructionResponse_ProcessBundleSplit)(nil),
		(*InstructionResponse_FinalizeBundle)(nil),
	}
}

func _InstructionResponse_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*InstructionResponse)
	// response
	switch x := m.Response.(type) {
	case *InstructionResponse_Register:
		b.EncodeVarint(1000<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Register); err != nil {
			return err
		}
	case *InstructionResponse_ProcessBundle:
		b.EncodeVarint(1001<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProcessBundle); err != nil {
			return err
		}
	case *InstructionResponse_ProcessBundleProgress:
		b.EncodeVarint(1002<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProcessBundleProgress); err != nil {
			return err
		}
	case *InstructionResponse_ProcessBundleSplit:
		b.EncodeVarint(1003<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ProcessBundleSplit); err != nil {
			return err
		}
	case *InstructionResponse_FinalizeBundle:
		b.EncodeVarint(1004<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.FinalizeBundle); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("InstructionResponse.Response has unexpected type %T", x)
	}
	return nil
}

func _InstructionResponse_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*InstructionResponse)
	switch tag {
	case 1000: // response.register
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RegisterResponse)
		err := b.DecodeMessage(msg)
		m.Response = &InstructionResponse_Register{msg}
		return true, err
	case 1001: // response.process_bundle
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProcessBundleResponse)
		err := b.DecodeMessage(msg)
		m.Response = &InstructionResponse_ProcessBundle{msg}
		return true, err
	case 1002: // response.process_bundle_progress
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProcessBundleProgressResponse)
		err := b.DecodeMessage(msg)
		m.Response = &InstructionResponse_ProcessBundleProgress{msg}
		return true, err
	case 1003: // response.process_bundle_split
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ProcessBundleSplitResponse)
		err := b.DecodeMessage(msg)
		m.Response = &InstructionResponse_ProcessBundleSplit{msg}
		return true, err
	case 1004: // response.finalize_bundle
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(FinalizeBundleResponse)
		err := b.DecodeMessage(msg)
		m.Response = &InstructionResponse_FinalizeBundle{msg}
		return true, err
	default:
		return false, nil
	}
}

func _InstructionResponse_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*InstructionResponse)
	// response
	switch x := m.Response.(type) {
	case *InstructionResponse_Register:
		s := proto.Size(x.Register)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionResponse_ProcessBundle:
		s := proto.Size(x.ProcessBundle)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionResponse_ProcessBundleProgress:
		s := proto.Size(x.ProcessBundleProgress)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionResponse_ProcessBundleSplit:
		s := proto.Size(x.ProcessBundleSplit)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *InstructionResponse_FinalizeBundle:
		s := proto.Size(x.FinalizeBundle)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A list of objects which can be referred to by the runner in
// future requests.
// Stable
type RegisterRequest struct {
	// (Optional) The set of descriptors used to process bundles.
	ProcessBundleDescriptor []*ProcessBundleDescriptor `protobuf:"bytes,1,rep,name=process_bundle_descriptor,json=processBundleDescriptor,proto3" json:"process_bundle_descriptor,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}                   `json:"-"`
	XXX_unrecognized        []byte                     `json:"-"`
	XXX_sizecache           int32                      `json:"-"`
}

func (m *RegisterRequest) Reset()         { *m = RegisterRequest{} }
func (m *RegisterRequest) String() string { return proto.CompactTextString(m) }
func (*RegisterRequest) ProtoMessage()    {}
func (*RegisterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{3}
}
func (m *RegisterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RegisterRequest.Unmarshal(m, b)
}
func (m *RegisterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RegisterRequest.Marshal(b, m, deterministic)
}
func (dst *RegisterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterRequest.Merge(dst, src)
}
func (m *RegisterRequest) XXX_Size() int {
	return xxx_messageInfo_RegisterRequest.Size(m)
}
func (m *RegisterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterRequest proto.InternalMessageInfo

func (m *RegisterRequest) GetProcessBundleDescriptor() []*ProcessBundleDescriptor {
	if m != nil {
		return m.ProcessBundleDescriptor
	}
	return nil
}

// Stable
type RegisterResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RegisterResponse) Reset()         { *m = RegisterResponse{} }
func (m *RegisterResponse) String() string { return proto.CompactTextString(m) }
func (*RegisterResponse) ProtoMessage()    {}
func (*RegisterResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{4}
}
func (m *RegisterResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RegisterResponse.Unmarshal(m, b)
}
func (m *RegisterResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RegisterResponse.Marshal(b, m, deterministic)
}
func (dst *RegisterResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegisterResponse.Merge(dst, src)
}
func (m *RegisterResponse) XXX_Size() int {
	return xxx_messageInfo_RegisterResponse.Size(m)
}
func (m *RegisterResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RegisterResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RegisterResponse proto.InternalMessageInfo

// Definitions that should be used to construct the bundle processing graph.
type ProcessBundleDescriptor struct {
	// (Required) A pipeline level unique id which can be used as a reference to
	// refer to this.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// (Required) A map from pipeline-scoped id to PTransform.
	Transforms map[string]*pipeline_v1.PTransform `protobuf:"bytes,2,rep,name=transforms,proto3" json:"transforms,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to PCollection.
	Pcollections map[string]*pipeline_v1.PCollection `protobuf:"bytes,3,rep,name=pcollections,proto3" json:"pcollections,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to WindowingStrategy.
	WindowingStrategies map[string]*pipeline_v1.WindowingStrategy `protobuf:"bytes,4,rep,name=windowing_strategies,json=windowingStrategies,proto3" json:"windowing_strategies,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to Coder.
	Coders map[string]*pipeline_v1.Coder `protobuf:"bytes,5,rep,name=coders,proto3" json:"coders,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) A map from pipeline-scoped id to Environment.
	Environments map[string]*pipeline_v1.Environment `protobuf:"bytes,6,rep,name=environments,proto3" json:"environments,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// A descriptor describing the end point to use for State API
	// calls. Required if the Runner intends to send remote references over the
	// data plane or if any of the transforms rely on user state or side inputs.
	StateApiServiceDescriptor *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,7,opt,name=state_api_service_descriptor,json=stateApiServiceDescriptor,proto3" json:"state_api_service_descriptor,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}                          `json:"-"`
	XXX_unrecognized          []byte                            `json:"-"`
	XXX_sizecache             int32                             `json:"-"`
}

func (m *ProcessBundleDescriptor) Reset()         { *m = ProcessBundleDescriptor{} }
func (m *ProcessBundleDescriptor) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleDescriptor) ProtoMessage()    {}
func (*ProcessBundleDescriptor) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{5}
}
func (m *ProcessBundleDescriptor) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleDescriptor.Unmarshal(m, b)
}
func (m *ProcessBundleDescriptor) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleDescriptor.Marshal(b, m, deterministic)
}
func (dst *ProcessBundleDescriptor) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleDescriptor.Merge(dst, src)
}
func (m *ProcessBundleDescriptor) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleDescriptor.Size(m)
}
func (m *ProcessBundleDescriptor) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleDescriptor.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleDescriptor proto.InternalMessageInfo

func (m *ProcessBundleDescriptor) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ProcessBundleDescriptor) GetTransforms() map[string]*pipeline_v1.PTransform {
	if m != nil {
		return m.Transforms
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetPcollections() map[string]*pipeline_v1.PCollection {
	if m != nil {
		return m.Pcollections
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetWindowingStrategies() map[string]*pipeline_v1.WindowingStrategy {
	if m != nil {
		return m.WindowingStrategies
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetCoders() map[string]*pipeline_v1.Coder {
	if m != nil {
		return m.Coders
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetEnvironments() map[string]*pipeline_v1.Environment {
	if m != nil {
		return m.Environments
	}
	return nil
}

func (m *ProcessBundleDescriptor) GetStateApiServiceDescriptor() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.StateApiServiceDescriptor
	}
	return nil
}

// One of the applications specifying the scope of work for a bundle.
// See
// https://docs.google.com/document/d/1tUDb45sStdR8u7-jBkGdw3OGFK7aa2-V7eo86zYSE_4/edit#heading=h.9g3g5weg2u9
// for further details.
type BundleApplication struct {
	// (Required) The primitive transform to which to pass the element
	PtransformId string `protobuf:"bytes,1,opt,name=ptransform_id,json=ptransformId,proto3" json:"ptransform_id,omitempty"`
	// (Required) Name of the transform's input to which to pass the element.
	InputId string `protobuf:"bytes,2,opt,name=input_id,json=inputId,proto3" json:"input_id,omitempty"`
	// (Required) The encoded element to pass to the transform.
	Element []byte `protobuf:"bytes,3,opt,name=element,proto3" json:"element,omitempty"`
	// The map is keyed by the local output name of the PTransform. Each
	// value represents a lower bound on the timestamps of elements that
	// are produced by this PTransform into each of its output PCollections
	// when invoked with this application.
	OutputWatermarks map[string]*timestamp.Timestamp `protobuf:"bytes,4,rep,name=output_watermarks,json=outputWatermarks,proto3" json:"output_watermarks,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) Whether this application potentially produces an unbounded
	// amount of data. Note that this should only be set to BOUNDED if and
	// only if the application is known to produce a finite amount of output.
	//
	// Note that this is different from the backlog as the backlog represents
	// how much work there is currently outstanding.
	IsBounded pipeline_v1.IsBounded_Enum `protobuf:"varint,5,opt,name=is_bounded,json=isBounded,proto3,enum=org.apache.beam.model.pipeline.v1.IsBounded_Enum" json:"is_bounded,omitempty"`
	// Contains additional monitoring information related to this application.
	//
	// Each application is able to report information that some runners
	// will use consume when providing a UI or for making scaling and performance
	// decisions. See https://s.apache.org/beam-bundles-backlog-splitting for
	// details about what types of signals may be useful to report.
	MonitoringInfos      []*pipeline_v1.MonitoringInfo `protobuf:"bytes,6,rep,name=monitoring_infos,json=monitoringInfos,proto3" json:"monitoring_infos,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *BundleApplication) Reset()         { *m = BundleApplication{} }
func (m *BundleApplication) String() string { return proto.CompactTextString(m) }
func (*BundleApplication) ProtoMessage()    {}
func (*BundleApplication) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{6}
}
func (m *BundleApplication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BundleApplication.Unmarshal(m, b)
}
func (m *BundleApplication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BundleApplication.Marshal(b, m, deterministic)
}
func (dst *BundleApplication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BundleApplication.Merge(dst, src)
}
func (m *BundleApplication) XXX_Size() int {
	return xxx_messageInfo_BundleApplication.Size(m)
}
func (m *BundleApplication) XXX_DiscardUnknown() {
	xxx_messageInfo_BundleApplication.DiscardUnknown(m)
}

var xxx_messageInfo_BundleApplication proto.InternalMessageInfo

func (m *BundleApplication) GetPtransformId() string {
	if m != nil {
		return m.PtransformId
	}
	return ""
}

func (m *BundleApplication) GetInputId() string {
	if m != nil {
		return m.InputId
	}
	return ""
}

func (m *BundleApplication) GetElement() []byte {
	if m != nil {
		return m.Element
	}
	return nil
}

func (m *BundleApplication) GetOutputWatermarks() map[string]*timestamp.Timestamp {
	if m != nil {
		return m.OutputWatermarks
	}
	return nil
}

func (m *BundleApplication) GetIsBounded() pipeline_v1.IsBounded_Enum {
	if m != nil {
		return m.IsBounded
	}
	return pipeline_v1.IsBounded_UNSPECIFIED
}

func (m *BundleApplication) GetMonitoringInfos() []*pipeline_v1.MonitoringInfo {
	if m != nil {
		return m.MonitoringInfos
	}
	return nil
}

// An Application should be scheduled for execution after a delay.
type DelayedBundleApplication struct {
	// Recommended time at which the application should be scheduled to execute
	// by the runner. Times in the past may be scheduled to execute immediately.
	RequestedExecutionTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=requested_execution_time,json=requestedExecutionTime,proto3" json:"requested_execution_time,omitempty"`
	// (Required) The application that should be scheduled.
	Application          *BundleApplication `protobuf:"bytes,2,opt,name=application,proto3" json:"application,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *DelayedBundleApplication) Reset()         { *m = DelayedBundleApplication{} }
func (m *DelayedBundleApplication) String() string { return proto.CompactTextString(m) }
func (*DelayedBundleApplication) ProtoMessage()    {}
func (*DelayedBundleApplication) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{7}
}
func (m *DelayedBundleApplication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DelayedBundleApplication.Unmarshal(m, b)
}
func (m *DelayedBundleApplication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DelayedBundleApplication.Marshal(b, m, deterministic)
}
func (dst *DelayedBundleApplication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DelayedBundleApplication.Merge(dst, src)
}
func (m *DelayedBundleApplication) XXX_Size() int {
	return xxx_messageInfo_DelayedBundleApplication.Size(m)
}
func (m *DelayedBundleApplication) XXX_DiscardUnknown() {
	xxx_messageInfo_DelayedBundleApplication.DiscardUnknown(m)
}

var xxx_messageInfo_DelayedBundleApplication proto.InternalMessageInfo

func (m *DelayedBundleApplication) GetRequestedExecutionTime() *timestamp.Timestamp {
	if m != nil {
		return m.RequestedExecutionTime
	}
	return nil
}

func (m *DelayedBundleApplication) GetApplication() *BundleApplication {
	if m != nil {
		return m.Application
	}
	return nil
}

// A request to process a given bundle.
// Stable
type ProcessBundleRequest struct {
	// (Required) A reference to the process bundle descriptor that must be
	// instantiated and executed by the SDK harness.
	ProcessBundleDescriptorReference string `protobuf:"bytes,1,opt,name=process_bundle_descriptor_reference,json=processBundleDescriptorReference,proto3" json:"process_bundle_descriptor_reference,omitempty"`
	// (Optional) A list of cache tokens that can be used by an SDK to reuse
	// cached data returned by the State API across multiple bundles.
	CacheTokens          [][]byte `protobuf:"bytes,2,rep,name=cache_tokens,json=cacheTokens,proto3" json:"cache_tokens,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleRequest) Reset()         { *m = ProcessBundleRequest{} }
func (m *ProcessBundleRequest) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleRequest) ProtoMessage()    {}
func (*ProcessBundleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{8}
}
func (m *ProcessBundleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleRequest.Unmarshal(m, b)
}
func (m *ProcessBundleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleRequest.Marshal(b, m, deterministic)
}
func (dst *ProcessBundleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleRequest.Merge(dst, src)
}
func (m *ProcessBundleRequest) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleRequest.Size(m)
}
func (m *ProcessBundleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleRequest proto.InternalMessageInfo

func (m *ProcessBundleRequest) GetProcessBundleDescriptorReference() string {
	if m != nil {
		return m.ProcessBundleDescriptorReference
	}
	return ""
}

func (m *ProcessBundleRequest) GetCacheTokens() [][]byte {
	if m != nil {
		return m.CacheTokens
	}
	return nil
}

type ProcessBundleResponse struct {
	// (Optional) If metrics reporting is supported by the SDK, this represents
	// the final metrics to record for this bundle.
	// DEPRECATED
	Metrics *Metrics `protobuf:"bytes,1,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// (Optional) Specifies that the bundle has not been completed and the
	// following applications need to be scheduled and executed in the future.
	// A runner that does not yet support residual roots MUST still check that
	// this is empty for correctness.
	ResidualRoots []*DelayedBundleApplication `protobuf:"bytes,2,rep,name=residual_roots,json=residualRoots,proto3" json:"residual_roots,omitempty"`
	// (Required) The list of metrics or other MonitoredState
	// collected while processing this bundle.
	MonitoringInfos []*pipeline_v1.MonitoringInfo `protobuf:"bytes,3,rep,name=monitoring_infos,json=monitoringInfos,proto3" json:"monitoring_infos,omitempty"`
	// (Optional) Specifies that the runner must callback to this worker
	// once the output of the bundle is committed. The Runner must send a
	// FinalizeBundleRequest with the instruction id of the ProcessBundleRequest
	// that is related to this ProcessBundleResponse.
	RequiresFinalization bool     `protobuf:"varint,4,opt,name=requires_finalization,json=requiresFinalization,proto3" json:"requires_finalization,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleResponse) Reset()         { *m = ProcessBundleResponse{} }
func (m *ProcessBundleResponse) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleResponse) ProtoMessage()    {}
func (*ProcessBundleResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{9}
}
func (m *ProcessBundleResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleResponse.Unmarshal(m, b)
}
func (m *ProcessBundleResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleResponse.Marshal(b, m, deterministic)
}
func (dst *ProcessBundleResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleResponse.Merge(dst, src)
}
func (m *ProcessBundleResponse) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleResponse.Size(m)
}
func (m *ProcessBundleResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleResponse proto.InternalMessageInfo

func (m *ProcessBundleResponse) GetMetrics() *Metrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *ProcessBundleResponse) GetResidualRoots() []*DelayedBundleApplication {
	if m != nil {
		return m.ResidualRoots
	}
	return nil
}

func (m *ProcessBundleResponse) GetMonitoringInfos() []*pipeline_v1.MonitoringInfo {
	if m != nil {
		return m.MonitoringInfos
	}
	return nil
}

func (m *ProcessBundleResponse) GetRequiresFinalization() bool {
	if m != nil {
		return m.RequiresFinalization
	}
	return false
}

// A request to report progress information for a given bundle.
// This is an optional request to be handled and is used to support advanced
// SDK features such as SplittableDoFn, user level metrics etc.
type ProcessBundleProgressRequest struct {
	// (Required) A reference to an active process bundle request with the given
	// instruction id.
	InstructionReference string   `protobuf:"bytes,1,opt,name=instruction_reference,json=instructionReference,proto3" json:"instruction_reference,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleProgressRequest) Reset()         { *m = ProcessBundleProgressRequest{} }
func (m *ProcessBundleProgressRequest) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleProgressRequest) ProtoMessage()    {}
func (*ProcessBundleProgressRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{10}
}
func (m *ProcessBundleProgressRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleProgressRequest.Unmarshal(m, b)
}
func (m *ProcessBundleProgressRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleProgressRequest.Marshal(b, m, deterministic)
}
func (dst *ProcessBundleProgressRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleProgressRequest.Merge(dst, src)
}
func (m *ProcessBundleProgressRequest) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleProgressRequest.Size(m)
}
func (m *ProcessBundleProgressRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleProgressRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleProgressRequest proto.InternalMessageInfo

func (m *ProcessBundleProgressRequest) GetInstructionReference() string {
	if m != nil {
		return m.InstructionReference
	}
	return ""
}

// DEPRECATED
type Metrics struct {
	Ptransforms          map[string]*Metrics_PTransform `protobuf:"bytes,1,rep,name=ptransforms,proto3" json:"ptransforms,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *Metrics) Reset()         { *m = Metrics{} }
func (m *Metrics) String() string { return proto.CompactTextString(m) }
func (*Metrics) ProtoMessage()    {}
func (*Metrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{11}
}
func (m *Metrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics.Unmarshal(m, b)
}
func (m *Metrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics.Marshal(b, m, deterministic)
}
func (dst *Metrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics.Merge(dst, src)
}
func (m *Metrics) XXX_Size() int {
	return xxx_messageInfo_Metrics.Size(m)
}
func (m *Metrics) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics proto.InternalMessageInfo

func (m *Metrics) GetPtransforms() map[string]*Metrics_PTransform {
	if m != nil {
		return m.Ptransforms
	}
	return nil
}

// PTransform level metrics.
// These metrics are split into processed and active element groups for
// progress reporting purposes. This allows a Runner to see what is measured,
// what is estimated and what can be extrapolated to be able to accurately
// estimate the backlog of remaining work.
type Metrics_PTransform struct {
	// (Required): Metrics for processed elements.
	ProcessedElements *Metrics_PTransform_ProcessedElements `protobuf:"bytes,1,opt,name=processed_elements,json=processedElements,proto3" json:"processed_elements,omitempty"`
	// (Required): Metrics for active elements.
	ActiveElements *Metrics_PTransform_ActiveElements `protobuf:"bytes,2,opt,name=active_elements,json=activeElements,proto3" json:"active_elements,omitempty"`
	// (Optional): Map from local output name to its watermark.
	// The watermarks reported are tentative, to get a better sense of progress
	// while processing a bundle but before it is committed. At bundle commit
	// time, a Runner needs to also take into account the timers set to compute
	// the actual watermarks.
	Watermarks           map[string]int64 `protobuf:"bytes,3,rep,name=watermarks,proto3" json:"watermarks,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	User                 []*Metrics_User  `protobuf:"bytes,4,rep,name=user,proto3" json:"user,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Metrics_PTransform) Reset()         { *m = Metrics_PTransform{} }
func (m *Metrics_PTransform) String() string { return proto.CompactTextString(m) }
func (*Metrics_PTransform) ProtoMessage()    {}
func (*Metrics_PTransform) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{11, 0}
}
func (m *Metrics_PTransform) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_PTransform.Unmarshal(m, b)
}
func (m *Metrics_PTransform) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_PTransform.Marshal(b, m, deterministic)
}
func (dst *Metrics_PTransform) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_PTransform.Merge(dst, src)
}
func (m *Metrics_PTransform) XXX_Size() int {
	return xxx_messageInfo_Metrics_PTransform.Size(m)
}
func (m *Metrics_PTransform) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_PTransform.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_PTransform proto.InternalMessageInfo

func (m *Metrics_PTransform) GetProcessedElements() *Metrics_PTransform_ProcessedElements {
	if m != nil {
		return m.ProcessedElements
	}
	return nil
}

func (m *Metrics_PTransform) GetActiveElements() *Metrics_PTransform_ActiveElements {
	if m != nil {
		return m.ActiveElements
	}
	return nil
}

func (m *Metrics_PTransform) GetWatermarks() map[string]int64 {
	if m != nil {
		return m.Watermarks
	}
	return nil
}

func (m *Metrics_PTransform) GetUser() []*Metrics_User {
	if m != nil {
		return m.User
	}
	return nil
}

// Metrics that are measured for processed and active element groups.
type Metrics_PTransform_Measured struct {
	// (Optional) Map from local input name to number of elements processed
	// from this input.
	// If unset, assumed to be the sum of the outputs of all producers to
	// this transform (for ProcessedElements) and 0 (for ActiveElements).
	InputElementCounts map[string]int64 `protobuf:"bytes,1,rep,name=input_element_counts,json=inputElementCounts,proto3" json:"input_element_counts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// (Required) Map from local output name to number of elements produced
	// for this output.
	OutputElementCounts map[string]int64 `protobuf:"bytes,2,rep,name=output_element_counts,json=outputElementCounts,proto3" json:"output_element_counts,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// (Optional) The total time spent so far in processing the elements in
	// this group, in seconds.
	TotalTimeSpent       float64  `protobuf:"fixed64,3,opt,name=total_time_spent,json=totalTimeSpent,proto3" json:"total_time_spent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Metrics_PTransform_Measured) Reset()         { *m = Metrics_PTransform_Measured{} }
func (m *Metrics_PTransform_Measured) String() string { return proto.CompactTextString(m) }
func (*Metrics_PTransform_Measured) ProtoMessage()    {}
func (*Metrics_PTransform_Measured) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{11, 0, 0}
}
func (m *Metrics_PTransform_Measured) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_PTransform_Measured.Unmarshal(m, b)
}
func (m *Metrics_PTransform_Measured) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_PTransform_Measured.Marshal(b, m, deterministic)
}
func (dst *Metrics_PTransform_Measured) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_PTransform_Measured.Merge(dst, src)
}
func (m *Metrics_PTransform_Measured) XXX_Size() int {
	return xxx_messageInfo_Metrics_PTransform_Measured.Size(m)
}
func (m *Metrics_PTransform_Measured) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_PTransform_Measured.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_PTransform_Measured proto.InternalMessageInfo

func (m *Metrics_PTransform_Measured) GetInputElementCounts() map[string]int64 {
	if m != nil {
		return m.InputElementCounts
	}
	return nil
}

func (m *Metrics_PTransform_Measured) GetOutputElementCounts() map[string]int64 {
	if m != nil {
		return m.OutputElementCounts
	}
	return nil
}

func (m *Metrics_PTransform_Measured) GetTotalTimeSpent() float64 {
	if m != nil {
		return m.TotalTimeSpent
	}
	return 0
}

// Metrics for fully processed elements.
type Metrics_PTransform_ProcessedElements struct {
	// (Required)
	Measured             *Metrics_PTransform_Measured `protobuf:"bytes,1,opt,name=measured,proto3" json:"measured,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *Metrics_PTransform_ProcessedElements) Reset()         { *m = Metrics_PTransform_ProcessedElements{} }
func (m *Metrics_PTransform_ProcessedElements) String() string { return proto.CompactTextString(m) }
func (*Metrics_PTransform_ProcessedElements) ProtoMessage()    {}
func (*Metrics_PTransform_ProcessedElements) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{11, 0, 1}
}
func (m *Metrics_PTransform_ProcessedElements) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_PTransform_ProcessedElements.Unmarshal(m, b)
}
func (m *Metrics_PTransform_ProcessedElements) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_PTransform_ProcessedElements.Marshal(b, m, deterministic)
}
func (dst *Metrics_PTransform_ProcessedElements) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_PTransform_ProcessedElements.Merge(dst, src)
}
func (m *Metrics_PTransform_ProcessedElements) XXX_Size() int {
	return xxx_messageInfo_Metrics_PTransform_ProcessedElements.Size(m)
}
func (m *Metrics_PTransform_ProcessedElements) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_PTransform_ProcessedElements.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_PTransform_ProcessedElements proto.InternalMessageInfo

func (m *Metrics_PTransform_ProcessedElements) GetMeasured() *Metrics_PTransform_Measured {
	if m != nil {
		return m.Measured
	}
	return nil
}

// Metrics for active elements.
// An element is considered active if the SDK has started but not finished
// processing it yet.
type Metrics_PTransform_ActiveElements struct {
	// (Required)
	Measured *Metrics_PTransform_Measured `protobuf:"bytes,1,opt,name=measured,proto3" json:"measured,omitempty"`
	// (Optional) Sum of estimated fraction of known work remaining for all
	// active elements, as reported by this transform.
	// If not reported, a Runner could extrapolate this from the processed
	// elements.
	// TODO: Handle the case when known work is infinite.
	FractionRemaining float64 `protobuf:"fixed64,2,opt,name=fraction_remaining,json=fractionRemaining,proto3" json:"fraction_remaining,omitempty"`
	// (Optional) Map from local output name to sum of estimated number
	// of elements remaining for this output from all active elements,
	// as reported by this transform.
	// If not reported, a Runner could extrapolate this from the processed
	// elements.
	OutputElementsRemaining map[string]int64 `protobuf:"bytes,3,rep,name=output_elements_remaining,json=outputElementsRemaining,proto3" json:"output_elements_remaining,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral    struct{}         `json:"-"`
	XXX_unrecognized        []byte           `json:"-"`
	XXX_sizecache           int32            `json:"-"`
}

func (m *Metrics_PTransform_ActiveElements) Reset()         { *m = Metrics_PTransform_ActiveElements{} }
func (m *Metrics_PTransform_ActiveElements) String() string { return proto.CompactTextString(m) }
func (*Metrics_PTransform_ActiveElements) ProtoMessage()    {}
func (*Metrics_PTransform_ActiveElements) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{11, 0, 2}
}
func (m *Metrics_PTransform_ActiveElements) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_PTransform_ActiveElements.Unmarshal(m, b)
}
func (m *Metrics_PTransform_ActiveElements) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_PTransform_ActiveElements.Marshal(b, m, deterministic)
}
func (dst *Metrics_PTransform_ActiveElements) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_PTransform_ActiveElements.Merge(dst, src)
}
func (m *Metrics_PTransform_ActiveElements) XXX_Size() int {
	return xxx_messageInfo_Metrics_PTransform_ActiveElements.Size(m)
}
func (m *Metrics_PTransform_ActiveElements) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_PTransform_ActiveElements.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_PTransform_ActiveElements proto.InternalMessageInfo

func (m *Metrics_PTransform_ActiveElements) GetMeasured() *Metrics_PTransform_Measured {
	if m != nil {
		return m.Measured
	}
	return nil
}

func (m *Metrics_PTransform_ActiveElements) GetFractionRemaining() float64 {
	if m != nil {
		return m.FractionRemaining
	}
	return 0
}

func (m *Metrics_PTransform_ActiveElements) GetOutputElementsRemaining() map[string]int64 {
	if m != nil {
		return m.OutputElementsRemaining
	}
	return nil
}

// User defined metrics
type Metrics_User struct {
	// (Required) The identifier for this metric.
	MetricName *Metrics_User_MetricName `protobuf:"bytes,1,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
	// (Required) The data for this metric.
	//
	// Types that are valid to be assigned to Data:
	//	*Metrics_User_CounterData_
	//	*Metrics_User_DistributionData_
	//	*Metrics_User_GaugeData_
	Data                 isMetrics_User_Data `protobuf_oneof:"data"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Metrics_User) Reset()         { *m = Metrics_User{} }
func (m *Metrics_User) String() string { return proto.CompactTextString(m) }
func (*Metrics_User) ProtoMessage()    {}
func (*Metrics_User) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{11, 1}
}
func (m *Metrics_User) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User.Unmarshal(m, b)
}
func (m *Metrics_User) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User.Marshal(b, m, deterministic)
}
func (dst *Metrics_User) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User.Merge(dst, src)
}
func (m *Metrics_User) XXX_Size() int {
	return xxx_messageInfo_Metrics_User.Size(m)
}
func (m *Metrics_User) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User proto.InternalMessageInfo

type isMetrics_User_Data interface {
	isMetrics_User_Data()
}

type Metrics_User_CounterData_ struct {
	CounterData *Metrics_User_CounterData `protobuf:"bytes,1001,opt,name=counter_data,json=counterData,proto3,oneof"`
}
type Metrics_User_DistributionData_ struct {
	DistributionData *Metrics_User_DistributionData `protobuf:"bytes,1002,opt,name=distribution_data,json=distributionData,proto3,oneof"`
}
type Metrics_User_GaugeData_ struct {
	GaugeData *Metrics_User_GaugeData `protobuf:"bytes,1003,opt,name=gauge_data,json=gaugeData,proto3,oneof"`
}

func (*Metrics_User_CounterData_) isMetrics_User_Data()      {}
func (*Metrics_User_DistributionData_) isMetrics_User_Data() {}
func (*Metrics_User_GaugeData_) isMetrics_User_Data()        {}

func (m *Metrics_User) GetData() isMetrics_User_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Metrics_User) GetMetricName() *Metrics_User_MetricName {
	if m != nil {
		return m.MetricName
	}
	return nil
}

func (m *Metrics_User) GetCounterData() *Metrics_User_CounterData {
	if x, ok := m.GetData().(*Metrics_User_CounterData_); ok {
		return x.CounterData
	}
	return nil
}

func (m *Metrics_User) GetDistributionData() *Metrics_User_DistributionData {
	if x, ok := m.GetData().(*Metrics_User_DistributionData_); ok {
		return x.DistributionData
	}
	return nil
}

func (m *Metrics_User) GetGaugeData() *Metrics_User_GaugeData {
	if x, ok := m.GetData().(*Metrics_User_GaugeData_); ok {
		return x.GaugeData
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Metrics_User) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Metrics_User_OneofMarshaler, _Metrics_User_OneofUnmarshaler, _Metrics_User_OneofSizer, []interface{}{
		(*Metrics_User_CounterData_)(nil),
		(*Metrics_User_DistributionData_)(nil),
		(*Metrics_User_GaugeData_)(nil),
	}
}

func _Metrics_User_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Metrics_User)
	// data
	switch x := m.Data.(type) {
	case *Metrics_User_CounterData_:
		b.EncodeVarint(1001<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CounterData); err != nil {
			return err
		}
	case *Metrics_User_DistributionData_:
		b.EncodeVarint(1002<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DistributionData); err != nil {
			return err
		}
	case *Metrics_User_GaugeData_:
		b.EncodeVarint(1003<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GaugeData); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Metrics_User.Data has unexpected type %T", x)
	}
	return nil
}

func _Metrics_User_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Metrics_User)
	switch tag {
	case 1001: // data.counter_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Metrics_User_CounterData)
		err := b.DecodeMessage(msg)
		m.Data = &Metrics_User_CounterData_{msg}
		return true, err
	case 1002: // data.distribution_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Metrics_User_DistributionData)
		err := b.DecodeMessage(msg)
		m.Data = &Metrics_User_DistributionData_{msg}
		return true, err
	case 1003: // data.gauge_data
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Metrics_User_GaugeData)
		err := b.DecodeMessage(msg)
		m.Data = &Metrics_User_GaugeData_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Metrics_User_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Metrics_User)
	// data
	switch x := m.Data.(type) {
	case *Metrics_User_CounterData_:
		s := proto.Size(x.CounterData)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Metrics_User_DistributionData_:
		s := proto.Size(x.DistributionData)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Metrics_User_GaugeData_:
		s := proto.Size(x.GaugeData)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A key for identifying a metric at the most granular level.
type Metrics_User_MetricName struct {
	// (Required): The namespace of this metric.
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// (Required): The name of this metric.
	Name                 string   `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Metrics_User_MetricName) Reset()         { *m = Metrics_User_MetricName{} }
func (m *Metrics_User_MetricName) String() string { return proto.CompactTextString(m) }
func (*Metrics_User_MetricName) ProtoMessage()    {}
func (*Metrics_User_MetricName) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{11, 1, 0}
}
func (m *Metrics_User_MetricName) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User_MetricName.Unmarshal(m, b)
}
func (m *Metrics_User_MetricName) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User_MetricName.Marshal(b, m, deterministic)
}
func (dst *Metrics_User_MetricName) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User_MetricName.Merge(dst, src)
}
func (m *Metrics_User_MetricName) XXX_Size() int {
	return xxx_messageInfo_Metrics_User_MetricName.Size(m)
}
func (m *Metrics_User_MetricName) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User_MetricName.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User_MetricName proto.InternalMessageInfo

func (m *Metrics_User_MetricName) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *Metrics_User_MetricName) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Data associated with a counter metric.
type Metrics_User_CounterData struct {
	Value                int64    `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Metrics_User_CounterData) Reset()         { *m = Metrics_User_CounterData{} }
func (m *Metrics_User_CounterData) String() string { return proto.CompactTextString(m) }
func (*Metrics_User_CounterData) ProtoMessage()    {}
func (*Metrics_User_CounterData) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{11, 1, 1}
}
func (m *Metrics_User_CounterData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User_CounterData.Unmarshal(m, b)
}
func (m *Metrics_User_CounterData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User_CounterData.Marshal(b, m, deterministic)
}
func (dst *Metrics_User_CounterData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User_CounterData.Merge(dst, src)
}
func (m *Metrics_User_CounterData) XXX_Size() int {
	return xxx_messageInfo_Metrics_User_CounterData.Size(m)
}
func (m *Metrics_User_CounterData) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User_CounterData.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User_CounterData proto.InternalMessageInfo

func (m *Metrics_User_CounterData) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

// Data associated with a distribution metric.
type Metrics_User_DistributionData struct {
	Count                int64    `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	Sum                  int64    `protobuf:"varint,2,opt,name=sum,proto3" json:"sum,omitempty"`
	Min                  int64    `protobuf:"varint,3,opt,name=min,proto3" json:"min,omitempty"`
	Max                  int64    `protobuf:"varint,4,opt,name=max,proto3" json:"max,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Metrics_User_DistributionData) Reset()         { *m = Metrics_User_DistributionData{} }
func (m *Metrics_User_DistributionData) String() string { return proto.CompactTextString(m) }
func (*Metrics_User_DistributionData) ProtoMessage()    {}
func (*Metrics_User_DistributionData) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{11, 1, 2}
}
func (m *Metrics_User_DistributionData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User_DistributionData.Unmarshal(m, b)
}
func (m *Metrics_User_DistributionData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User_DistributionData.Marshal(b, m, deterministic)
}
func (dst *Metrics_User_DistributionData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User_DistributionData.Merge(dst, src)
}
func (m *Metrics_User_DistributionData) XXX_Size() int {
	return xxx_messageInfo_Metrics_User_DistributionData.Size(m)
}
func (m *Metrics_User_DistributionData) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User_DistributionData.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User_DistributionData proto.InternalMessageInfo

func (m *Metrics_User_DistributionData) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

func (m *Metrics_User_DistributionData) GetSum() int64 {
	if m != nil {
		return m.Sum
	}
	return 0
}

func (m *Metrics_User_DistributionData) GetMin() int64 {
	if m != nil {
		return m.Min
	}
	return 0
}

func (m *Metrics_User_DistributionData) GetMax() int64 {
	if m != nil {
		return m.Max
	}
	return 0
}

// Data associated with a Gauge metric.
type Metrics_User_GaugeData struct {
	Value                int64                `protobuf:"varint,1,opt,name=value,proto3" json:"value,omitempty"`
	Timestamp            *timestamp.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Metrics_User_GaugeData) Reset()         { *m = Metrics_User_GaugeData{} }
func (m *Metrics_User_GaugeData) String() string { return proto.CompactTextString(m) }
func (*Metrics_User_GaugeData) ProtoMessage()    {}
func (*Metrics_User_GaugeData) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{11, 1, 3}
}
func (m *Metrics_User_GaugeData) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Metrics_User_GaugeData.Unmarshal(m, b)
}
func (m *Metrics_User_GaugeData) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Metrics_User_GaugeData.Marshal(b, m, deterministic)
}
func (dst *Metrics_User_GaugeData) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Metrics_User_GaugeData.Merge(dst, src)
}
func (m *Metrics_User_GaugeData) XXX_Size() int {
	return xxx_messageInfo_Metrics_User_GaugeData.Size(m)
}
func (m *Metrics_User_GaugeData) XXX_DiscardUnknown() {
	xxx_messageInfo_Metrics_User_GaugeData.DiscardUnknown(m)
}

var xxx_messageInfo_Metrics_User_GaugeData proto.InternalMessageInfo

func (m *Metrics_User_GaugeData) GetValue() int64 {
	if m != nil {
		return m.Value
	}
	return 0
}

func (m *Metrics_User_GaugeData) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

type ProcessBundleProgressResponse struct {
	// DEPRECATED (Required)
	Metrics *Metrics `protobuf:"bytes,1,opt,name=metrics,proto3" json:"metrics,omitempty"`
	// (Required) The list of metrics or other MonitoredState
	// collected while processing this bundle.
	MonitoringInfos []*pipeline_v1.MonitoringInfo `protobuf:"bytes,3,rep,name=monitoring_infos,json=monitoringInfos,proto3" json:"monitoring_infos,omitempty"`
	// The list of currently active primary roots that are being
	// executed. Required to be populated for PTransforms which can be split.
	PrimaryRoots         []*BundleApplication `protobuf:"bytes,4,rep,name=primary_roots,json=primaryRoots,proto3" json:"primary_roots,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ProcessBundleProgressResponse) Reset()         { *m = ProcessBundleProgressResponse{} }
func (m *ProcessBundleProgressResponse) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleProgressResponse) ProtoMessage()    {}
func (*ProcessBundleProgressResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{12}
}
func (m *ProcessBundleProgressResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleProgressResponse.Unmarshal(m, b)
}
func (m *ProcessBundleProgressResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleProgressResponse.Marshal(b, m, deterministic)
}
func (dst *ProcessBundleProgressResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleProgressResponse.Merge(dst, src)
}
func (m *ProcessBundleProgressResponse) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleProgressResponse.Size(m)
}
func (m *ProcessBundleProgressResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleProgressResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleProgressResponse proto.InternalMessageInfo

func (m *ProcessBundleProgressResponse) GetMetrics() *Metrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (m *ProcessBundleProgressResponse) GetMonitoringInfos() []*pipeline_v1.MonitoringInfo {
	if m != nil {
		return m.MonitoringInfos
	}
	return nil
}

func (m *ProcessBundleProgressResponse) GetPrimaryRoots() []*BundleApplication {
	if m != nil {
		return m.PrimaryRoots
	}
	return nil
}

// Represents a request to the SDK to split a currently active bundle.
type ProcessBundleSplitRequest struct {
	// (Required) A reference to an active process bundle request with the given
	// instruction id.
	InstructionReference string `protobuf:"bytes,1,opt,name=instruction_reference,json=instructionReference,proto3" json:"instruction_reference,omitempty"`
	// (Required) Specifies that the Runner would like the bundle to split itself
	// such that it performs no more work than the backlog specified for each
	// PTransform. The interpretation of how much work should be processed is up
	// to the PTransform.
	//
	// For example, A backlog of "" tells the SDK to perform as little work as
	// possible, effectively checkpointing when able. The remaining backlog
	// will be relative to the backlog reported during processing.
	//
	// If the backlog is unspecified for a PTransform, the runner would like
	// the SDK to process all data received for that PTransform.
	BacklogRemaining map[string][]byte `protobuf:"bytes,2,rep,name=backlog_remaining,json=backlogRemaining,proto3" json:"backlog_remaining,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// (Required) Specifies the desired split for each transform.
	//
	// Currently only splits at GRPC read operations are supported.
	// This may, of course, limit the amount of work downstream operations
	// receive.
	DesiredSplits        map[string]*ProcessBundleSplitRequest_DesiredSplit `protobuf:"bytes,3,rep,name=desired_splits,json=desiredSplits,proto3" json:"desired_splits,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                                           `json:"-"`
	XXX_unrecognized     []byte                                             `json:"-"`
	XXX_sizecache        int32                                              `json:"-"`
}

func (m *ProcessBundleSplitRequest) Reset()         { *m = ProcessBundleSplitRequest{} }
func (m *ProcessBundleSplitRequest) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleSplitRequest) ProtoMessage()    {}
func (*ProcessBundleSplitRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{13}
}
func (m *ProcessBundleSplitRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleSplitRequest.Unmarshal(m, b)
}
func (m *ProcessBundleSplitRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleSplitRequest.Marshal(b, m, deterministic)
}
func (dst *ProcessBundleSplitRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleSplitRequest.Merge(dst, src)
}
func (m *ProcessBundleSplitRequest) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleSplitRequest.Size(m)
}
func (m *ProcessBundleSplitRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleSplitRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleSplitRequest proto.InternalMessageInfo

func (m *ProcessBundleSplitRequest) GetInstructionReference() string {
	if m != nil {
		return m.InstructionReference
	}
	return ""
}

func (m *ProcessBundleSplitRequest) GetBacklogRemaining() map[string][]byte {
	if m != nil {
		return m.BacklogRemaining
	}
	return nil
}

func (m *ProcessBundleSplitRequest) GetDesiredSplits() map[string]*ProcessBundleSplitRequest_DesiredSplit {
	if m != nil {
		return m.DesiredSplits
	}
	return nil
}

// A message specifying the desired split for a single transform.
type ProcessBundleSplitRequest_DesiredSplit struct {
	// (Required) The fraction of known work remaining in this bundle
	// for this transform that should be kept by the SDK after this split.
	//
	// Set to 0 to "checkpoint" as soon as possible (keeping as little work as
	// possible and returning the remainder).
	FractionOfRemainder float32 `protobuf:"fixed32,1,opt,name=fraction_of_remainder,json=fractionOfRemainder,proto3" json:"fraction_of_remainder,omitempty"`
	// A set of allowed element indices where the SDK may split. When this is
	// empty, there are no constraints on where to split.
	AllowedSplitPoints []int64 `protobuf:"varint,3,rep,packed,name=allowed_split_points,json=allowedSplitPoints,proto3" json:"allowed_split_points,omitempty"`
	// (Required for GrpcRead operations) Number of total elements expected
	// to be sent to this GrpcRead operation, required to correctly account
	// for unreceived data when determining where to split.
	EstimatedInputElements int64    `protobuf:"varint,2,opt,name=estimated_input_elements,json=estimatedInputElements,proto3" json:"estimated_input_elements,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *ProcessBundleSplitRequest_DesiredSplit) Reset() {
	*m = ProcessBundleSplitRequest_DesiredSplit{}
}
func (m *ProcessBundleSplitRequest_DesiredSplit) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleSplitRequest_DesiredSplit) ProtoMessage()    {}
func (*ProcessBundleSplitRequest_DesiredSplit) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{13, 1}
}
func (m *ProcessBundleSplitRequest_DesiredSplit) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleSplitRequest_DesiredSplit.Unmarshal(m, b)
}
func (m *ProcessBundleSplitRequest_DesiredSplit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleSplitRequest_DesiredSplit.Marshal(b, m, deterministic)
}
func (dst *ProcessBundleSplitRequest_DesiredSplit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleSplitRequest_DesiredSplit.Merge(dst, src)
}
func (m *ProcessBundleSplitRequest_DesiredSplit) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleSplitRequest_DesiredSplit.Size(m)
}
func (m *ProcessBundleSplitRequest_DesiredSplit) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleSplitRequest_DesiredSplit.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleSplitRequest_DesiredSplit proto.InternalMessageInfo

func (m *ProcessBundleSplitRequest_DesiredSplit) GetFractionOfRemainder() float32 {
	if m != nil {
		return m.FractionOfRemainder
	}
	return 0
}

func (m *ProcessBundleSplitRequest_DesiredSplit) GetAllowedSplitPoints() []int64 {
	if m != nil {
		return m.AllowedSplitPoints
	}
	return nil
}

func (m *ProcessBundleSplitRequest_DesiredSplit) GetEstimatedInputElements() int64 {
	if m != nil {
		return m.EstimatedInputElements
	}
	return 0
}

// Represents a partition of the bundle: a "primary" and
// a "residual", with the following properties:
// - The work in primary and residual doesn't overlap, and combined, adds up
//   to the work in the current bundle if the split hadn't happened.
// - The current bundle, if it keeps executing, will have done none of the
//   work under residual_roots.
// - The current bundle, if no further splits happen, will have done exactly
//   the work under primary_roots.
// For more rigorous definitions see https://s.apache.org/beam-breaking-fusion
type ProcessBundleSplitResponse struct {
	// Root applications that should replace the current bundle.
	PrimaryRoots []*BundleApplication `protobuf:"bytes,1,rep,name=primary_roots,json=primaryRoots,proto3" json:"primary_roots,omitempty"`
	// Root applications that have been removed from the current bundle and
	// have to be executed in a separate bundle (e.g. in parallel on a different
	// worker, or after the current bundle completes, etc.)
	ResidualRoots []*DelayedBundleApplication `protobuf:"bytes,2,rep,name=residual_roots,json=residualRoots,proto3" json:"residual_roots,omitempty"`
	// Partitions of input data channels into primary and residual elements,
	// if any. Should not include any elements represented in the bundle
	// applications roots above.
	ChannelSplits        []*ProcessBundleSplitResponse_ChannelSplit `protobuf:"bytes,3,rep,name=channel_splits,json=channelSplits,proto3" json:"channel_splits,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *ProcessBundleSplitResponse) Reset()         { *m = ProcessBundleSplitResponse{} }
func (m *ProcessBundleSplitResponse) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleSplitResponse) ProtoMessage()    {}
func (*ProcessBundleSplitResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{14}
}
func (m *ProcessBundleSplitResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleSplitResponse.Unmarshal(m, b)
}
func (m *ProcessBundleSplitResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleSplitResponse.Marshal(b, m, deterministic)
}
func (dst *ProcessBundleSplitResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleSplitResponse.Merge(dst, src)
}
func (m *ProcessBundleSplitResponse) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleSplitResponse.Size(m)
}
func (m *ProcessBundleSplitResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleSplitResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleSplitResponse proto.InternalMessageInfo

func (m *ProcessBundleSplitResponse) GetPrimaryRoots() []*BundleApplication {
	if m != nil {
		return m.PrimaryRoots
	}
	return nil
}

func (m *ProcessBundleSplitResponse) GetResidualRoots() []*DelayedBundleApplication {
	if m != nil {
		return m.ResidualRoots
	}
	return nil
}

func (m *ProcessBundleSplitResponse) GetChannelSplits() []*ProcessBundleSplitResponse_ChannelSplit {
	if m != nil {
		return m.ChannelSplits
	}
	return nil
}

// Represents contiguous portions of the data channel that are either
// entirely processed or entirely unprocessed and belong to the primary
// or residual respectively.
//
// This affords both a more efficient representation over the FnAPI
// (if the bundle is large) and often a more efficient representation
// on the runner side (e.g. if the set of elements can be represented
// as some range in an underlying dataset).
type ProcessBundleSplitResponse_ChannelSplit struct {
	// (Required) The grpc read transform reading this channel.
	PtransformId string `protobuf:"bytes,1,opt,name=ptransform_id,json=ptransformId,proto3" json:"ptransform_id,omitempty"`
	// The last element of the input channel that should be entirely considered
	// part of the primary, identified by its absolute index in the (ordered)
	// channel.
	LastPrimaryElement int32 `protobuf:"varint,2,opt,name=last_primary_element,json=lastPrimaryElement,proto3" json:"last_primary_element,omitempty"`
	// The first element of the input channel that should be entirely considered
	// part of the residual, identified by its absolute index in the (ordered)
	// channel.
	FirstResidualElement int32    `protobuf:"varint,3,opt,name=first_residual_element,json=firstResidualElement,proto3" json:"first_residual_element,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProcessBundleSplitResponse_ChannelSplit) Reset() {
	*m = ProcessBundleSplitResponse_ChannelSplit{}
}
func (m *ProcessBundleSplitResponse_ChannelSplit) String() string { return proto.CompactTextString(m) }
func (*ProcessBundleSplitResponse_ChannelSplit) ProtoMessage()    {}
func (*ProcessBundleSplitResponse_ChannelSplit) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{14, 0}
}
func (m *ProcessBundleSplitResponse_ChannelSplit) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProcessBundleSplitResponse_ChannelSplit.Unmarshal(m, b)
}
func (m *ProcessBundleSplitResponse_ChannelSplit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProcessBundleSplitResponse_ChannelSplit.Marshal(b, m, deterministic)
}
func (dst *ProcessBundleSplitResponse_ChannelSplit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessBundleSplitResponse_ChannelSplit.Merge(dst, src)
}
func (m *ProcessBundleSplitResponse_ChannelSplit) XXX_Size() int {
	return xxx_messageInfo_ProcessBundleSplitResponse_ChannelSplit.Size(m)
}
func (m *ProcessBundleSplitResponse_ChannelSplit) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessBundleSplitResponse_ChannelSplit.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessBundleSplitResponse_ChannelSplit proto.InternalMessageInfo

func (m *ProcessBundleSplitResponse_ChannelSplit) GetPtransformId() string {
	if m != nil {
		return m.PtransformId
	}
	return ""
}

func (m *ProcessBundleSplitResponse_ChannelSplit) GetLastPrimaryElement() int32 {
	if m != nil {
		return m.LastPrimaryElement
	}
	return 0
}

func (m *ProcessBundleSplitResponse_ChannelSplit) GetFirstResidualElement() int32 {
	if m != nil {
		return m.FirstResidualElement
	}
	return 0
}

type FinalizeBundleRequest struct {
	// (Required) A reference to a completed process bundle request with the given
	// instruction id.
	InstructionReference string   `protobuf:"bytes,1,opt,name=instruction_reference,json=instructionReference,proto3" json:"instruction_reference,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FinalizeBundleRequest) Reset()         { *m = FinalizeBundleRequest{} }
func (m *FinalizeBundleRequest) String() string { return proto.CompactTextString(m) }
func (*FinalizeBundleRequest) ProtoMessage()    {}
func (*FinalizeBundleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{15}
}
func (m *FinalizeBundleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinalizeBundleRequest.Unmarshal(m, b)
}
func (m *FinalizeBundleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinalizeBundleRequest.Marshal(b, m, deterministic)
}
func (dst *FinalizeBundleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinalizeBundleRequest.Merge(dst, src)
}
func (m *FinalizeBundleRequest) XXX_Size() int {
	return xxx_messageInfo_FinalizeBundleRequest.Size(m)
}
func (m *FinalizeBundleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FinalizeBundleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FinalizeBundleRequest proto.InternalMessageInfo

func (m *FinalizeBundleRequest) GetInstructionReference() string {
	if m != nil {
		return m.InstructionReference
	}
	return ""
}

type FinalizeBundleResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FinalizeBundleResponse) Reset()         { *m = FinalizeBundleResponse{} }
func (m *FinalizeBundleResponse) String() string { return proto.CompactTextString(m) }
func (*FinalizeBundleResponse) ProtoMessage()    {}
func (*FinalizeBundleResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{16}
}
func (m *FinalizeBundleResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FinalizeBundleResponse.Unmarshal(m, b)
}
func (m *FinalizeBundleResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FinalizeBundleResponse.Marshal(b, m, deterministic)
}
func (dst *FinalizeBundleResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FinalizeBundleResponse.Merge(dst, src)
}
func (m *FinalizeBundleResponse) XXX_Size() int {
	return xxx_messageInfo_FinalizeBundleResponse.Size(m)
}
func (m *FinalizeBundleResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FinalizeBundleResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FinalizeBundleResponse proto.InternalMessageInfo

// Messages used to represent logical byte streams.
// Stable
type Elements struct {
	// (Required) A list containing parts of logical byte streams.
	Data                 []*Elements_Data `protobuf:"bytes,1,rep,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Elements) Reset()         { *m = Elements{} }
func (m *Elements) String() string { return proto.CompactTextString(m) }
func (*Elements) ProtoMessage()    {}
func (*Elements) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{17}
}
func (m *Elements) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Elements.Unmarshal(m, b)
}
func (m *Elements) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Elements.Marshal(b, m, deterministic)
}
func (dst *Elements) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Elements.Merge(dst, src)
}
func (m *Elements) XXX_Size() int {
	return xxx_messageInfo_Elements.Size(m)
}
func (m *Elements) XXX_DiscardUnknown() {
	xxx_messageInfo_Elements.DiscardUnknown(m)
}

var xxx_messageInfo_Elements proto.InternalMessageInfo

func (m *Elements) GetData() []*Elements_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

// Represents multiple encoded elements in nested context for a given named
// instruction and transform.
type Elements_Data struct {
	// (Required) A reference to an active instruction request with the given
	// instruction id.
	InstructionReference string `protobuf:"bytes,1,opt,name=instruction_reference,json=instructionReference,proto3" json:"instruction_reference,omitempty"`
	// (Required) A definition representing a consumer or producer of this data.
	// If received by a harness, this represents the consumer within that
	// harness that should consume these bytes. If sent by a harness, this
	// represents the producer of these bytes.
	//
	// Note that a single element may span multiple Data messages.
	//
	// Note that a sending/receiving pair should share the same identifier.
	PtransformId string `protobuf:"bytes,2,opt,name=ptransform_id,json=ptransformId,proto3" json:"ptransform_id,omitempty"`
	// (Optional) Represents a part of a logical byte stream. Elements within
	// the logical byte stream are encoded in the nested context and
	// concatenated together.
	//
	// An empty data block represents the end of stream for the given
	// instruction and transform.
	Data                 []byte   `protobuf:"bytes,3,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Elements_Data) Reset()         { *m = Elements_Data{} }
func (m *Elements_Data) String() string { return proto.CompactTextString(m) }
func (*Elements_Data) ProtoMessage()    {}
func (*Elements_Data) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{17, 0}
}
func (m *Elements_Data) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Elements_Data.Unmarshal(m, b)
}
func (m *Elements_Data) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Elements_Data.Marshal(b, m, deterministic)
}
func (dst *Elements_Data) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Elements_Data.Merge(dst, src)
}
func (m *Elements_Data) XXX_Size() int {
	return xxx_messageInfo_Elements_Data.Size(m)
}
func (m *Elements_Data) XXX_DiscardUnknown() {
	xxx_messageInfo_Elements_Data.DiscardUnknown(m)
}

var xxx_messageInfo_Elements_Data proto.InternalMessageInfo

func (m *Elements_Data) GetInstructionReference() string {
	if m != nil {
		return m.InstructionReference
	}
	return ""
}

func (m *Elements_Data) GetPtransformId() string {
	if m != nil {
		return m.PtransformId
	}
	return ""
}

func (m *Elements_Data) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

type StateRequest struct {
	// (Required) An unique identifier provided by the SDK which represents this
	// requests execution. The StateResponse corresponding with this request
	// will have the matching id.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// (Required) The associated instruction id of the work that is currently
	// being processed. This allows for the runner to associate any modifications
	// to state to be committed with the appropriate work execution.
	InstructionReference string `protobuf:"bytes,2,opt,name=instruction_reference,json=instructionReference,proto3" json:"instruction_reference,omitempty"`
	// (Required) The state key this request is for.
	StateKey *StateKey `protobuf:"bytes,3,opt,name=state_key,json=stateKey,proto3" json:"state_key,omitempty"`
	// (Required) The action to take on this request.
	//
	// Types that are valid to be assigned to Request:
	//	*StateRequest_Get
	//	*StateRequest_Append
	//	*StateRequest_Clear
	Request              isStateRequest_Request `protobuf_oneof:"request"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *StateRequest) Reset()         { *m = StateRequest{} }
func (m *StateRequest) String() string { return proto.CompactTextString(m) }
func (*StateRequest) ProtoMessage()    {}
func (*StateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{18}
}
func (m *StateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateRequest.Unmarshal(m, b)
}
func (m *StateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateRequest.Marshal(b, m, deterministic)
}
func (dst *StateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateRequest.Merge(dst, src)
}
func (m *StateRequest) XXX_Size() int {
	return xxx_messageInfo_StateRequest.Size(m)
}
func (m *StateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateRequest proto.InternalMessageInfo

type isStateRequest_Request interface {
	isStateRequest_Request()
}

type StateRequest_Get struct {
	Get *StateGetRequest `protobuf:"bytes,1000,opt,name=get,proto3,oneof"`
}
type StateRequest_Append struct {
	Append *StateAppendRequest `protobuf:"bytes,1001,opt,name=append,proto3,oneof"`
}
type StateRequest_Clear struct {
	Clear *StateClearRequest `protobuf:"bytes,1002,opt,name=clear,proto3,oneof"`
}

func (*StateRequest_Get) isStateRequest_Request()    {}
func (*StateRequest_Append) isStateRequest_Request() {}
func (*StateRequest_Clear) isStateRequest_Request()  {}

func (m *StateRequest) GetRequest() isStateRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *StateRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *StateRequest) GetInstructionReference() string {
	if m != nil {
		return m.InstructionReference
	}
	return ""
}

func (m *StateRequest) GetStateKey() *StateKey {
	if m != nil {
		return m.StateKey
	}
	return nil
}

func (m *StateRequest) GetGet() *StateGetRequest {
	if x, ok := m.GetRequest().(*StateRequest_Get); ok {
		return x.Get
	}
	return nil
}

func (m *StateRequest) GetAppend() *StateAppendRequest {
	if x, ok := m.GetRequest().(*StateRequest_Append); ok {
		return x.Append
	}
	return nil
}

func (m *StateRequest) GetClear() *StateClearRequest {
	if x, ok := m.GetRequest().(*StateRequest_Clear); ok {
		return x.Clear
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StateRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StateRequest_OneofMarshaler, _StateRequest_OneofUnmarshaler, _StateRequest_OneofSizer, []interface{}{
		(*StateRequest_Get)(nil),
		(*StateRequest_Append)(nil),
		(*StateRequest_Clear)(nil),
	}
}

func _StateRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StateRequest)
	// request
	switch x := m.Request.(type) {
	case *StateRequest_Get:
		b.EncodeVarint(1000<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Get); err != nil {
			return err
		}
	case *StateRequest_Append:
		b.EncodeVarint(1001<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Append); err != nil {
			return err
		}
	case *StateRequest_Clear:
		b.EncodeVarint(1002<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Clear); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StateRequest.Request has unexpected type %T", x)
	}
	return nil
}

func _StateRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StateRequest)
	switch tag {
	case 1000: // request.get
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateGetRequest)
		err := b.DecodeMessage(msg)
		m.Request = &StateRequest_Get{msg}
		return true, err
	case 1001: // request.append
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateAppendRequest)
		err := b.DecodeMessage(msg)
		m.Request = &StateRequest_Append{msg}
		return true, err
	case 1002: // request.clear
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateClearRequest)
		err := b.DecodeMessage(msg)
		m.Request = &StateRequest_Clear{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StateRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StateRequest)
	// request
	switch x := m.Request.(type) {
	case *StateRequest_Get:
		s := proto.Size(x.Get)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateRequest_Append:
		s := proto.Size(x.Append)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateRequest_Clear:
		s := proto.Size(x.Clear)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type StateResponse struct {
	// (Required) A reference provided by the SDK which represents a requests
	// execution. The StateResponse must have the matching id when responding
	// to the SDK.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// (Optional) If this is specified, then the state request has failed.
	// A human readable string representing the reason as to why the request
	// failed.
	Error string `protobuf:"bytes,2,opt,name=error,proto3" json:"error,omitempty"`
	// (Optional) If this is specified, then the result of this state request
	// can be cached using the supplied token.
	CacheToken []byte `protobuf:"bytes,3,opt,name=cache_token,json=cacheToken,proto3" json:"cache_token,omitempty"`
	// A corresponding response matching the request will be populated.
	//
	// Types that are valid to be assigned to Response:
	//	*StateResponse_Get
	//	*StateResponse_Append
	//	*StateResponse_Clear
	Response             isStateResponse_Response `protobuf_oneof:"response"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *StateResponse) Reset()         { *m = StateResponse{} }
func (m *StateResponse) String() string { return proto.CompactTextString(m) }
func (*StateResponse) ProtoMessage()    {}
func (*StateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{19}
}
func (m *StateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateResponse.Unmarshal(m, b)
}
func (m *StateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateResponse.Marshal(b, m, deterministic)
}
func (dst *StateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateResponse.Merge(dst, src)
}
func (m *StateResponse) XXX_Size() int {
	return xxx_messageInfo_StateResponse.Size(m)
}
func (m *StateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateResponse proto.InternalMessageInfo

type isStateResponse_Response interface {
	isStateResponse_Response()
}

type StateResponse_Get struct {
	Get *StateGetResponse `protobuf:"bytes,1000,opt,name=get,proto3,oneof"`
}
type StateResponse_Append struct {
	Append *StateAppendResponse `protobuf:"bytes,1001,opt,name=append,proto3,oneof"`
}
type StateResponse_Clear struct {
	Clear *StateClearResponse `protobuf:"bytes,1002,opt,name=clear,proto3,oneof"`
}

func (*StateResponse_Get) isStateResponse_Response()    {}
func (*StateResponse_Append) isStateResponse_Response() {}
func (*StateResponse_Clear) isStateResponse_Response()  {}

func (m *StateResponse) GetResponse() isStateResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *StateResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *StateResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *StateResponse) GetCacheToken() []byte {
	if m != nil {
		return m.CacheToken
	}
	return nil
}

func (m *StateResponse) GetGet() *StateGetResponse {
	if x, ok := m.GetResponse().(*StateResponse_Get); ok {
		return x.Get
	}
	return nil
}

func (m *StateResponse) GetAppend() *StateAppendResponse {
	if x, ok := m.GetResponse().(*StateResponse_Append); ok {
		return x.Append
	}
	return nil
}

func (m *StateResponse) GetClear() *StateClearResponse {
	if x, ok := m.GetResponse().(*StateResponse_Clear); ok {
		return x.Clear
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StateResponse) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StateResponse_OneofMarshaler, _StateResponse_OneofUnmarshaler, _StateResponse_OneofSizer, []interface{}{
		(*StateResponse_Get)(nil),
		(*StateResponse_Append)(nil),
		(*StateResponse_Clear)(nil),
	}
}

func _StateResponse_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StateResponse)
	// response
	switch x := m.Response.(type) {
	case *StateResponse_Get:
		b.EncodeVarint(1000<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Get); err != nil {
			return err
		}
	case *StateResponse_Append:
		b.EncodeVarint(1001<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Append); err != nil {
			return err
		}
	case *StateResponse_Clear:
		b.EncodeVarint(1002<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Clear); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StateResponse.Response has unexpected type %T", x)
	}
	return nil
}

func _StateResponse_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StateResponse)
	switch tag {
	case 1000: // response.get
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateGetResponse)
		err := b.DecodeMessage(msg)
		m.Response = &StateResponse_Get{msg}
		return true, err
	case 1001: // response.append
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateAppendResponse)
		err := b.DecodeMessage(msg)
		m.Response = &StateResponse_Append{msg}
		return true, err
	case 1002: // response.clear
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateClearResponse)
		err := b.DecodeMessage(msg)
		m.Response = &StateResponse_Clear{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StateResponse_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StateResponse)
	// response
	switch x := m.Response.(type) {
	case *StateResponse_Get:
		s := proto.Size(x.Get)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateResponse_Append:
		s := proto.Size(x.Append)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateResponse_Clear:
		s := proto.Size(x.Clear)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type StateKey struct {
	// (Required) One of the following state keys must be set.
	//
	// Types that are valid to be assigned to Type:
	//	*StateKey_Runner_
	//	*StateKey_MultimapSideInput_
	//	*StateKey_BagUserState_
	Type                 isStateKey_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *StateKey) Reset()         { *m = StateKey{} }
func (m *StateKey) String() string { return proto.CompactTextString(m) }
func (*StateKey) ProtoMessage()    {}
func (*StateKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{20}
}
func (m *StateKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey.Unmarshal(m, b)
}
func (m *StateKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey.Marshal(b, m, deterministic)
}
func (dst *StateKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey.Merge(dst, src)
}
func (m *StateKey) XXX_Size() int {
	return xxx_messageInfo_StateKey.Size(m)
}
func (m *StateKey) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey proto.InternalMessageInfo

type isStateKey_Type interface {
	isStateKey_Type()
}

type StateKey_Runner_ struct {
	Runner *StateKey_Runner `protobuf:"bytes,1,opt,name=runner,proto3,oneof"`
}
type StateKey_MultimapSideInput_ struct {
	MultimapSideInput *StateKey_MultimapSideInput `protobuf:"bytes,2,opt,name=multimap_side_input,json=multimapSideInput,proto3,oneof"`
}
type StateKey_BagUserState_ struct {
	BagUserState *StateKey_BagUserState `protobuf:"bytes,3,opt,name=bag_user_state,json=bagUserState,proto3,oneof"`
}

func (*StateKey_Runner_) isStateKey_Type()            {}
func (*StateKey_MultimapSideInput_) isStateKey_Type() {}
func (*StateKey_BagUserState_) isStateKey_Type()      {}

func (m *StateKey) GetType() isStateKey_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *StateKey) GetRunner() *StateKey_Runner {
	if x, ok := m.GetType().(*StateKey_Runner_); ok {
		return x.Runner
	}
	return nil
}

func (m *StateKey) GetMultimapSideInput() *StateKey_MultimapSideInput {
	if x, ok := m.GetType().(*StateKey_MultimapSideInput_); ok {
		return x.MultimapSideInput
	}
	return nil
}

func (m *StateKey) GetBagUserState() *StateKey_BagUserState {
	if x, ok := m.GetType().(*StateKey_BagUserState_); ok {
		return x.BagUserState
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StateKey) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StateKey_OneofMarshaler, _StateKey_OneofUnmarshaler, _StateKey_OneofSizer, []interface{}{
		(*StateKey_Runner_)(nil),
		(*StateKey_MultimapSideInput_)(nil),
		(*StateKey_BagUserState_)(nil),
	}
}

func _StateKey_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StateKey)
	// type
	switch x := m.Type.(type) {
	case *StateKey_Runner_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Runner); err != nil {
			return err
		}
	case *StateKey_MultimapSideInput_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MultimapSideInput); err != nil {
			return err
		}
	case *StateKey_BagUserState_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BagUserState); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StateKey.Type has unexpected type %T", x)
	}
	return nil
}

func _StateKey_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StateKey)
	switch tag {
	case 1: // type.runner
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateKey_Runner)
		err := b.DecodeMessage(msg)
		m.Type = &StateKey_Runner_{msg}
		return true, err
	case 2: // type.multimap_side_input
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateKey_MultimapSideInput)
		err := b.DecodeMessage(msg)
		m.Type = &StateKey_MultimapSideInput_{msg}
		return true, err
	case 3: // type.bag_user_state
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StateKey_BagUserState)
		err := b.DecodeMessage(msg)
		m.Type = &StateKey_BagUserState_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StateKey_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StateKey)
	// type
	switch x := m.Type.(type) {
	case *StateKey_Runner_:
		s := proto.Size(x.Runner)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateKey_MultimapSideInput_:
		s := proto.Size(x.MultimapSideInput)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StateKey_BagUserState_:
		s := proto.Size(x.BagUserState)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type StateKey_Runner struct {
	// (Required) Opaque information supplied by the runner. Used to support
	// remote references.
	Key                  []byte   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateKey_Runner) Reset()         { *m = StateKey_Runner{} }
func (m *StateKey_Runner) String() string { return proto.CompactTextString(m) }
func (*StateKey_Runner) ProtoMessage()    {}
func (*StateKey_Runner) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{20, 0}
}
func (m *StateKey_Runner) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey_Runner.Unmarshal(m, b)
}
func (m *StateKey_Runner) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey_Runner.Marshal(b, m, deterministic)
}
func (dst *StateKey_Runner) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey_Runner.Merge(dst, src)
}
func (m *StateKey_Runner) XXX_Size() int {
	return xxx_messageInfo_StateKey_Runner.Size(m)
}
func (m *StateKey_Runner) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey_Runner.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey_Runner proto.InternalMessageInfo

func (m *StateKey_Runner) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

type StateKey_MultimapSideInput struct {
	// (Required) The id of the PTransform containing a side input.
	PtransformId string `protobuf:"bytes,1,opt,name=ptransform_id,json=ptransformId,proto3" json:"ptransform_id,omitempty"`
	// (Required) The id of the side input.
	SideInputId string `protobuf:"bytes,2,opt,name=side_input_id,json=sideInputId,proto3" json:"side_input_id,omitempty"`
	// (Required) The window (after mapping the currently executing elements
	// window into the side input windows domain) encoded in a nested context.
	Window []byte `protobuf:"bytes,3,opt,name=window,proto3" json:"window,omitempty"`
	// (Required) The key encoded in a nested context.
	Key                  []byte   `protobuf:"bytes,4,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateKey_MultimapSideInput) Reset()         { *m = StateKey_MultimapSideInput{} }
func (m *StateKey_MultimapSideInput) String() string { return proto.CompactTextString(m) }
func (*StateKey_MultimapSideInput) ProtoMessage()    {}
func (*StateKey_MultimapSideInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{20, 1}
}
func (m *StateKey_MultimapSideInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey_MultimapSideInput.Unmarshal(m, b)
}
func (m *StateKey_MultimapSideInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey_MultimapSideInput.Marshal(b, m, deterministic)
}
func (dst *StateKey_MultimapSideInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey_MultimapSideInput.Merge(dst, src)
}
func (m *StateKey_MultimapSideInput) XXX_Size() int {
	return xxx_messageInfo_StateKey_MultimapSideInput.Size(m)
}
func (m *StateKey_MultimapSideInput) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey_MultimapSideInput.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey_MultimapSideInput proto.InternalMessageInfo

func (m *StateKey_MultimapSideInput) GetPtransformId() string {
	if m != nil {
		return m.PtransformId
	}
	return ""
}

func (m *StateKey_MultimapSideInput) GetSideInputId() string {
	if m != nil {
		return m.SideInputId
	}
	return ""
}

func (m *StateKey_MultimapSideInput) GetWindow() []byte {
	if m != nil {
		return m.Window
	}
	return nil
}

func (m *StateKey_MultimapSideInput) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

type StateKey_BagUserState struct {
	// (Required) The id of the PTransform containing user state.
	PtransformId string `protobuf:"bytes,1,opt,name=ptransform_id,json=ptransformId,proto3" json:"ptransform_id,omitempty"`
	// (Required) The id of the user state.
	UserStateId string `protobuf:"bytes,2,opt,name=user_state_id,json=userStateId,proto3" json:"user_state_id,omitempty"`
	// (Required) The window encoded in a nested context.
	Window []byte `protobuf:"bytes,3,opt,name=window,proto3" json:"window,omitempty"`
	// (Required) The key of the currently executing element encoded in a
	// nested context.
	Key                  []byte   `protobuf:"bytes,4,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateKey_BagUserState) Reset()         { *m = StateKey_BagUserState{} }
func (m *StateKey_BagUserState) String() string { return proto.CompactTextString(m) }
func (*StateKey_BagUserState) ProtoMessage()    {}
func (*StateKey_BagUserState) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{20, 2}
}
func (m *StateKey_BagUserState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateKey_BagUserState.Unmarshal(m, b)
}
func (m *StateKey_BagUserState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateKey_BagUserState.Marshal(b, m, deterministic)
}
func (dst *StateKey_BagUserState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateKey_BagUserState.Merge(dst, src)
}
func (m *StateKey_BagUserState) XXX_Size() int {
	return xxx_messageInfo_StateKey_BagUserState.Size(m)
}
func (m *StateKey_BagUserState) XXX_DiscardUnknown() {
	xxx_messageInfo_StateKey_BagUserState.DiscardUnknown(m)
}

var xxx_messageInfo_StateKey_BagUserState proto.InternalMessageInfo

func (m *StateKey_BagUserState) GetPtransformId() string {
	if m != nil {
		return m.PtransformId
	}
	return ""
}

func (m *StateKey_BagUserState) GetUserStateId() string {
	if m != nil {
		return m.UserStateId
	}
	return ""
}

func (m *StateKey_BagUserState) GetWindow() []byte {
	if m != nil {
		return m.Window
	}
	return nil
}

func (m *StateKey_BagUserState) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

// A request to get state.
type StateGetRequest struct {
	// (Optional) If specified, signals to the runner that the response
	// should resume from the following continuation token.
	//
	// If unspecified, signals to the runner that the response should start
	// from the beginning of the logical continuable stream.
	ContinuationToken    []byte   `protobuf:"bytes,1,opt,name=continuation_token,json=continuationToken,proto3" json:"continuation_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateGetRequest) Reset()         { *m = StateGetRequest{} }
func (m *StateGetRequest) String() string { return proto.CompactTextString(m) }
func (*StateGetRequest) ProtoMessage()    {}
func (*StateGetRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{21}
}
func (m *StateGetRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateGetRequest.Unmarshal(m, b)
}
func (m *StateGetRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateGetRequest.Marshal(b, m, deterministic)
}
func (dst *StateGetRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateGetRequest.Merge(dst, src)
}
func (m *StateGetRequest) XXX_Size() int {
	return xxx_messageInfo_StateGetRequest.Size(m)
}
func (m *StateGetRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateGetRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateGetRequest proto.InternalMessageInfo

func (m *StateGetRequest) GetContinuationToken() []byte {
	if m != nil {
		return m.ContinuationToken
	}
	return nil
}

// A response to get state representing a logical byte stream which can be
// continued using the state API.
type StateGetResponse struct {
	// (Optional) If specified, represents a token which can be used with the
	// state API to get the next chunk of this logical byte stream. The end of
	// the logical byte stream is signalled by this field being unset.
	ContinuationToken []byte `protobuf:"bytes,1,opt,name=continuation_token,json=continuationToken,proto3" json:"continuation_token,omitempty"`
	// Represents a part of a logical byte stream. Elements within
	// the logical byte stream are encoded in the nested context and
	// concatenated together.
	Data                 []byte   `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateGetResponse) Reset()         { *m = StateGetResponse{} }
func (m *StateGetResponse) String() string { return proto.CompactTextString(m) }
func (*StateGetResponse) ProtoMessage()    {}
func (*StateGetResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{22}
}
func (m *StateGetResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateGetResponse.Unmarshal(m, b)
}
func (m *StateGetResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateGetResponse.Marshal(b, m, deterministic)
}
func (dst *StateGetResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateGetResponse.Merge(dst, src)
}
func (m *StateGetResponse) XXX_Size() int {
	return xxx_messageInfo_StateGetResponse.Size(m)
}
func (m *StateGetResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateGetResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateGetResponse proto.InternalMessageInfo

func (m *StateGetResponse) GetContinuationToken() []byte {
	if m != nil {
		return m.ContinuationToken
	}
	return nil
}

func (m *StateGetResponse) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// A request to append state.
type StateAppendRequest struct {
	// Represents a part of a logical byte stream. Elements within
	// the logical byte stream are encoded in the nested context and
	// multiple append requests are concatenated together.
	Data                 []byte   `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateAppendRequest) Reset()         { *m = StateAppendRequest{} }
func (m *StateAppendRequest) String() string { return proto.CompactTextString(m) }
func (*StateAppendRequest) ProtoMessage()    {}
func (*StateAppendRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{23}
}
func (m *StateAppendRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateAppendRequest.Unmarshal(m, b)
}
func (m *StateAppendRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateAppendRequest.Marshal(b, m, deterministic)
}
func (dst *StateAppendRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateAppendRequest.Merge(dst, src)
}
func (m *StateAppendRequest) XXX_Size() int {
	return xxx_messageInfo_StateAppendRequest.Size(m)
}
func (m *StateAppendRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateAppendRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateAppendRequest proto.InternalMessageInfo

func (m *StateAppendRequest) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// A response to append state.
type StateAppendResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateAppendResponse) Reset()         { *m = StateAppendResponse{} }
func (m *StateAppendResponse) String() string { return proto.CompactTextString(m) }
func (*StateAppendResponse) ProtoMessage()    {}
func (*StateAppendResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{24}
}
func (m *StateAppendResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateAppendResponse.Unmarshal(m, b)
}
func (m *StateAppendResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateAppendResponse.Marshal(b, m, deterministic)
}
func (dst *StateAppendResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateAppendResponse.Merge(dst, src)
}
func (m *StateAppendResponse) XXX_Size() int {
	return xxx_messageInfo_StateAppendResponse.Size(m)
}
func (m *StateAppendResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateAppendResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateAppendResponse proto.InternalMessageInfo

// A request to clear state.
type StateClearRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateClearRequest) Reset()         { *m = StateClearRequest{} }
func (m *StateClearRequest) String() string { return proto.CompactTextString(m) }
func (*StateClearRequest) ProtoMessage()    {}
func (*StateClearRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{25}
}
func (m *StateClearRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateClearRequest.Unmarshal(m, b)
}
func (m *StateClearRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateClearRequest.Marshal(b, m, deterministic)
}
func (dst *StateClearRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateClearRequest.Merge(dst, src)
}
func (m *StateClearRequest) XXX_Size() int {
	return xxx_messageInfo_StateClearRequest.Size(m)
}
func (m *StateClearRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateClearRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateClearRequest proto.InternalMessageInfo

// A response to clear state.
type StateClearResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateClearResponse) Reset()         { *m = StateClearResponse{} }
func (m *StateClearResponse) String() string { return proto.CompactTextString(m) }
func (*StateClearResponse) ProtoMessage()    {}
func (*StateClearResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{26}
}
func (m *StateClearResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateClearResponse.Unmarshal(m, b)
}
func (m *StateClearResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateClearResponse.Marshal(b, m, deterministic)
}
func (dst *StateClearResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateClearResponse.Merge(dst, src)
}
func (m *StateClearResponse) XXX_Size() int {
	return xxx_messageInfo_StateClearResponse.Size(m)
}
func (m *StateClearResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StateClearResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StateClearResponse proto.InternalMessageInfo

// A log entry
type LogEntry struct {
	// (Required) The severity of the log statement.
	Severity LogEntry_Severity_Enum `protobuf:"varint,1,opt,name=severity,proto3,enum=org.apache.beam.model.fn_execution.v1.LogEntry_Severity_Enum" json:"severity,omitempty"`
	// (Required) The time at which this log statement occurred.
	Timestamp *timestamp.Timestamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// (Required) A human readable message.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	// (Optional) An optional trace of the functions involved. For example, in
	// Java this can include multiple causes and multiple suppressed exceptions.
	Trace string `protobuf:"bytes,4,opt,name=trace,proto3" json:"trace,omitempty"`
	// (Optional) A reference to the instruction this log statement is associated
	// with.
	InstructionReference string `protobuf:"bytes,5,opt,name=instruction_reference,json=instructionReference,proto3" json:"instruction_reference,omitempty"`
	// (Optional) A reference to the primitive transform this log statement is
	// associated with.
	PrimitiveTransformReference string `protobuf:"bytes,6,opt,name=primitive_transform_reference,json=primitiveTransformReference,proto3" json:"primitive_transform_reference,omitempty"`
	// (Optional) Human-readable name of the function or method being invoked,
	// with optional context such as the class or package name. The format can
	// vary by language. For example:
	//   qual.if.ied.Class.method (Java)
	//   dir/package.func (Go)
	//   module.function (Python)
	//   file.cc:382 (C++)
	LogLocation string `protobuf:"bytes,7,opt,name=log_location,json=logLocation,proto3" json:"log_location,omitempty"`
	// (Optional) The name of the thread this log statement is associated with.
	Thread               string   `protobuf:"bytes,8,opt,name=thread,proto3" json:"thread,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogEntry) Reset()         { *m = LogEntry{} }
func (m *LogEntry) String() string { return proto.CompactTextString(m) }
func (*LogEntry) ProtoMessage()    {}
func (*LogEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{27}
}
func (m *LogEntry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogEntry.Unmarshal(m, b)
}
func (m *LogEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogEntry.Marshal(b, m, deterministic)
}
func (dst *LogEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry.Merge(dst, src)
}
func (m *LogEntry) XXX_Size() int {
	return xxx_messageInfo_LogEntry.Size(m)
}
func (m *LogEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry proto.InternalMessageInfo

func (m *LogEntry) GetSeverity() LogEntry_Severity_Enum {
	if m != nil {
		return m.Severity
	}
	return LogEntry_Severity_UNSPECIFIED
}

func (m *LogEntry) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *LogEntry) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *LogEntry) GetTrace() string {
	if m != nil {
		return m.Trace
	}
	return ""
}

func (m *LogEntry) GetInstructionReference() string {
	if m != nil {
		return m.InstructionReference
	}
	return ""
}

func (m *LogEntry) GetPrimitiveTransformReference() string {
	if m != nil {
		return m.PrimitiveTransformReference
	}
	return ""
}

func (m *LogEntry) GetLogLocation() string {
	if m != nil {
		return m.LogLocation
	}
	return ""
}

func (m *LogEntry) GetThread() string {
	if m != nil {
		return m.Thread
	}
	return ""
}

// A list of log entries, enables buffering and batching of multiple
// log messages using the logging API.
type LogEntry_List struct {
	// (Required) One or or more log messages.
	LogEntries           []*LogEntry `protobuf:"bytes,1,rep,name=log_entries,json=logEntries,proto3" json:"log_entries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *LogEntry_List) Reset()         { *m = LogEntry_List{} }
func (m *LogEntry_List) String() string { return proto.CompactTextString(m) }
func (*LogEntry_List) ProtoMessage()    {}
func (*LogEntry_List) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{27, 0}
}
func (m *LogEntry_List) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogEntry_List.Unmarshal(m, b)
}
func (m *LogEntry_List) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogEntry_List.Marshal(b, m, deterministic)
}
func (dst *LogEntry_List) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry_List.Merge(dst, src)
}
func (m *LogEntry_List) XXX_Size() int {
	return xxx_messageInfo_LogEntry_List.Size(m)
}
func (m *LogEntry_List) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry_List.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry_List proto.InternalMessageInfo

func (m *LogEntry_List) GetLogEntries() []*LogEntry {
	if m != nil {
		return m.LogEntries
	}
	return nil
}

// The severity of the event described in a log entry, expressed as one of the
// severity levels listed below. For your reference, the levels are
// assigned the listed numeric values. The effect of using numeric values
// other than those listed is undefined.
//
// If you are writing log entries, you should map other severity encodings to
// one of these standard levels. For example, you might map all of
// Java's FINE, FINER, and FINEST levels to `Severity.DEBUG`.
//
// This list is intentionally not comprehensive; the intent is to provide a
// common set of "good enough" severity levels so that logging front ends
// can provide filtering and searching across log types. Users of the API are
// free not to use all severity levels in their log messages.
type LogEntry_Severity struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogEntry_Severity) Reset()         { *m = LogEntry_Severity{} }
func (m *LogEntry_Severity) String() string { return proto.CompactTextString(m) }
func (*LogEntry_Severity) ProtoMessage()    {}
func (*LogEntry_Severity) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{27, 1}
}
func (m *LogEntry_Severity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogEntry_Severity.Unmarshal(m, b)
}
func (m *LogEntry_Severity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogEntry_Severity.Marshal(b, m, deterministic)
}
func (dst *LogEntry_Severity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogEntry_Severity.Merge(dst, src)
}
func (m *LogEntry_Severity) XXX_Size() int {
	return xxx_messageInfo_LogEntry_Severity.Size(m)
}
func (m *LogEntry_Severity) XXX_DiscardUnknown() {
	xxx_messageInfo_LogEntry_Severity.DiscardUnknown(m)
}

var xxx_messageInfo_LogEntry_Severity proto.InternalMessageInfo

type LogControl struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LogControl) Reset()         { *m = LogControl{} }
func (m *LogControl) String() string { return proto.CompactTextString(m) }
func (*LogControl) ProtoMessage()    {}
func (*LogControl) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{28}
}
func (m *LogControl) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LogControl.Unmarshal(m, b)
}
func (m *LogControl) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LogControl.Marshal(b, m, deterministic)
}
func (dst *LogControl) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LogControl.Merge(dst, src)
}
func (m *LogControl) XXX_Size() int {
	return xxx_messageInfo_LogControl.Size(m)
}
func (m *LogControl) XXX_DiscardUnknown() {
	xxx_messageInfo_LogControl.DiscardUnknown(m)
}

var xxx_messageInfo_LogControl proto.InternalMessageInfo

type NotifyRunnerAvailableRequest struct {
	WorkerId             string                            `protobuf:"bytes,1,opt,name=worker_id,json=workerId,proto3" json:"worker_id,omitempty"`
	ControlEndpoint      *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,2,opt,name=control_endpoint,json=controlEndpoint,proto3" json:"control_endpoint,omitempty"`
	LoggingEndpoint      *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,3,opt,name=logging_endpoint,json=loggingEndpoint,proto3" json:"logging_endpoint,omitempty"`
	ArtifactEndpoint     *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,4,opt,name=artifact_endpoint,json=artifactEndpoint,proto3" json:"artifact_endpoint,omitempty"`
	ProvisionEndpoint    *pipeline_v1.ApiServiceDescriptor `protobuf:"bytes,5,opt,name=provision_endpoint,json=provisionEndpoint,proto3" json:"provision_endpoint,omitempty"`
	Params               map[string]string                 `protobuf:"bytes,10,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *NotifyRunnerAvailableRequest) Reset()         { *m = NotifyRunnerAvailableRequest{} }
func (m *NotifyRunnerAvailableRequest) String() string { return proto.CompactTextString(m) }
func (*NotifyRunnerAvailableRequest) ProtoMessage()    {}
func (*NotifyRunnerAvailableRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{29}
}
func (m *NotifyRunnerAvailableRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NotifyRunnerAvailableRequest.Unmarshal(m, b)
}
func (m *NotifyRunnerAvailableRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NotifyRunnerAvailableRequest.Marshal(b, m, deterministic)
}
func (dst *NotifyRunnerAvailableRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NotifyRunnerAvailableRequest.Merge(dst, src)
}
func (m *NotifyRunnerAvailableRequest) XXX_Size() int {
	return xxx_messageInfo_NotifyRunnerAvailableRequest.Size(m)
}
func (m *NotifyRunnerAvailableRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NotifyRunnerAvailableRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NotifyRunnerAvailableRequest proto.InternalMessageInfo

func (m *NotifyRunnerAvailableRequest) GetWorkerId() string {
	if m != nil {
		return m.WorkerId
	}
	return ""
}

func (m *NotifyRunnerAvailableRequest) GetControlEndpoint() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.ControlEndpoint
	}
	return nil
}

func (m *NotifyRunnerAvailableRequest) GetLoggingEndpoint() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.LoggingEndpoint
	}
	return nil
}

func (m *NotifyRunnerAvailableRequest) GetArtifactEndpoint() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.ArtifactEndpoint
	}
	return nil
}

func (m *NotifyRunnerAvailableRequest) GetProvisionEndpoint() *pipeline_v1.ApiServiceDescriptor {
	if m != nil {
		return m.ProvisionEndpoint
	}
	return nil
}

func (m *NotifyRunnerAvailableRequest) GetParams() map[string]string {
	if m != nil {
		return m.Params
	}
	return nil
}

type NotifyRunnerAvailableResponse struct {
	Error                string   `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NotifyRunnerAvailableResponse) Reset()         { *m = NotifyRunnerAvailableResponse{} }
func (m *NotifyRunnerAvailableResponse) String() string { return proto.CompactTextString(m) }
func (*NotifyRunnerAvailableResponse) ProtoMessage()    {}
func (*NotifyRunnerAvailableResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_beam_fn_api_e97479b62fd7f85c, []int{30}
}
func (m *NotifyRunnerAvailableResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NotifyRunnerAvailableResponse.Unmarshal(m, b)
}
func (m *NotifyRunnerAvailableResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NotifyRunnerAvailableResponse.Marshal(b, m, deterministic)
}
func (dst *NotifyRunnerAvailableResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NotifyRunnerAvailableResponse.Merge(dst, src)
}
func (m *NotifyRunnerAvailableResponse) XXX_Size() int {
	return xxx_messageInfo_NotifyRunnerAvailableResponse.Size(m)
}
func (m *NotifyRunnerAvailableResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NotifyRunnerAvailableResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NotifyRunnerAvailableResponse proto.InternalMessageInfo

func (m *NotifyRunnerAvailableResponse) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func init() {
	proto.RegisterType((*RemoteGrpcPort)(nil), "org.apache.beam.model.fn_execution.v1.RemoteGrpcPort")
	proto.RegisterType((*InstructionRequest)(nil), "org.apache.beam.model.fn_execution.v1.InstructionRequest")
	proto.RegisterType((*InstructionResponse)(nil), "org.apache.beam.model.fn_execution.v1.InstructionResponse")
	proto.RegisterType((*RegisterRequest)(nil), "org.apache.beam.model.fn_execution.v1.RegisterRequest")
	proto.RegisterType((*RegisterResponse)(nil), "org.apache.beam.model.fn_execution.v1.RegisterResponse")
	proto.RegisterType((*ProcessBundleDescriptor)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor")
	proto.RegisterMapType((map[string]*pipeline_v1.Coder)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.CodersEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.Environment)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.EnvironmentsEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.PCollection)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.PcollectionsEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.PTransform)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.TransformsEntry")
	proto.RegisterMapType((map[string]*pipeline_v1.WindowingStrategy)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.WindowingStrategiesEntry")
	proto.RegisterType((*BundleApplication)(nil), "org.apache.beam.model.fn_execution.v1.BundleApplication")
	proto.RegisterMapType((map[string]*timestamp.Timestamp)(nil), "org.apache.beam.model.fn_execution.v1.BundleApplication.OutputWatermarksEntry")
	proto.RegisterType((*DelayedBundleApplication)(nil), "org.apache.beam.model.fn_execution.v1.DelayedBundleApplication")
	proto.RegisterType((*ProcessBundleRequest)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleRequest")
	proto.RegisterType((*ProcessBundleResponse)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleResponse")
	proto.RegisterType((*ProcessBundleProgressRequest)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleProgressRequest")
	proto.RegisterType((*Metrics)(nil), "org.apache.beam.model.fn_execution.v1.Metrics")
	proto.RegisterMapType((map[string]*Metrics_PTransform)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PtransformsEntry")
	proto.RegisterType((*Metrics_PTransform)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform")
	proto.RegisterMapType((map[string]int64)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.WatermarksEntry")
	proto.RegisterType((*Metrics_PTransform_Measured)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.Measured")
	proto.RegisterMapType((map[string]int64)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.Measured.InputElementCountsEntry")
	proto.RegisterMapType((map[string]int64)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.Measured.OutputElementCountsEntry")
	proto.RegisterType((*Metrics_PTransform_ProcessedElements)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.ProcessedElements")
	proto.RegisterType((*Metrics_PTransform_ActiveElements)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.ActiveElements")
	proto.RegisterMapType((map[string]int64)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.PTransform.ActiveElements.OutputElementsRemainingEntry")
	proto.RegisterType((*Metrics_User)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User")
	proto.RegisterType((*Metrics_User_MetricName)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User.MetricName")
	proto.RegisterType((*Metrics_User_CounterData)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User.CounterData")
	proto.RegisterType((*Metrics_User_DistributionData)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User.DistributionData")
	proto.RegisterType((*Metrics_User_GaugeData)(nil), "org.apache.beam.model.fn_execution.v1.Metrics.User.GaugeData")
	proto.RegisterType((*ProcessBundleProgressResponse)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleProgressResponse")
	proto.RegisterType((*ProcessBundleSplitRequest)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest")
	proto.RegisterMapType((map[string][]byte)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest.BacklogRemainingEntry")
	proto.RegisterMapType((map[string]*ProcessBundleSplitRequest_DesiredSplit)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest.DesiredSplitsEntry")
	proto.RegisterType((*ProcessBundleSplitRequest_DesiredSplit)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest.DesiredSplit")
	proto.RegisterType((*ProcessBundleSplitResponse)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse")
	proto.RegisterType((*ProcessBundleSplitResponse_ChannelSplit)(nil), "org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse.ChannelSplit")
	proto.RegisterType((*FinalizeBundleRequest)(nil), "org.apache.beam.model.fn_execution.v1.FinalizeBundleRequest")
	proto.RegisterType((*FinalizeBundleResponse)(nil), "org.apache.beam.model.fn_execution.v1.FinalizeBundleResponse")
	proto.RegisterType((*Elements)(nil), "org.apache.beam.model.fn_execution.v1.Elements")
	proto.RegisterType((*Elements_Data)(nil), "org.apache.beam.model.fn_execution.v1.Elements.Data")
	proto.RegisterType((*StateRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateRequest")
	proto.RegisterType((*StateResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateResponse")
	proto.RegisterType((*StateKey)(nil), "org.apache.beam.model.fn_execution.v1.StateKey")
	proto.RegisterType((*StateKey_Runner)(nil), "org.apache.beam.model.fn_execution.v1.StateKey.Runner")
	proto.RegisterType((*StateKey_MultimapSideInput)(nil), "org.apache.beam.model.fn_execution.v1.StateKey.MultimapSideInput")
	proto.RegisterType((*StateKey_BagUserState)(nil), "org.apache.beam.model.fn_execution.v1.StateKey.BagUserState")
	proto.RegisterType((*StateGetRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateGetRequest")
	proto.RegisterType((*StateGetResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateGetResponse")
	proto.RegisterType((*StateAppendRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateAppendRequest")
	proto.RegisterType((*StateAppendResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateAppendResponse")
	proto.RegisterType((*StateClearRequest)(nil), "org.apache.beam.model.fn_execution.v1.StateClearRequest")
	proto.RegisterType((*StateClearResponse)(nil), "org.apache.beam.model.fn_execution.v1.StateClearResponse")
	proto.RegisterType((*LogEntry)(nil), "org.apache.beam.model.fn_execution.v1.LogEntry")
	proto.RegisterType((*LogEntry_List)(nil), "org.apache.beam.model.fn_execution.v1.LogEntry.List")
	proto.RegisterType((*LogEntry_Severity)(nil), "org.apache.beam.model.fn_execution.v1.LogEntry.Severity")
	proto.RegisterType((*LogControl)(nil), "org.apache.beam.model.fn_execution.v1.LogControl")
	proto.RegisterType((*NotifyRunnerAvailableRequest)(nil), "org.apache.beam.model.fn_execution.v1.NotifyRunnerAvailableRequest")
	proto.RegisterMapType((map[string]string)(nil), "org.apache.beam.model.fn_execution.v1.NotifyRunnerAvailableRequest.ParamsEntry")
	proto.RegisterType((*NotifyRunnerAvailableResponse)(nil), "org.apache.beam.model.fn_execution.v1.NotifyRunnerAvailableResponse")
	proto.RegisterEnum("org.apache.beam.model.fn_execution.v1.LogEntry_Severity_Enum", LogEntry_Severity_Enum_name, LogEntry_Severity_Enum_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// BeamFnControlClient is the client API for BeamFnControl service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnControlClient interface {
	// Instructions sent by the runner to the SDK requesting different types
	// of work.
	Control(ctx context.Context, opts ...grpc.CallOption) (BeamFnControl_ControlClient, error)
}

type beamFnControlClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnControlClient(cc *grpc.ClientConn) BeamFnControlClient {
	return &beamFnControlClient{cc}
}

func (c *beamFnControlClient) Control(ctx context.Context, opts ...grpc.CallOption) (BeamFnControl_ControlClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnControl_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnControl/Control", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnControlControlClient{stream}
	return x, nil
}

type BeamFnControl_ControlClient interface {
	Send(*InstructionResponse) error
	Recv() (*InstructionRequest, error)
	grpc.ClientStream
}

type beamFnControlControlClient struct {
	grpc.ClientStream
}

func (x *beamFnControlControlClient) Send(m *InstructionResponse) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnControlControlClient) Recv() (*InstructionRequest, error) {
	m := new(InstructionRequest)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnControlServer is the server API for BeamFnControl service.
type BeamFnControlServer interface {
	// Instructions sent by the runner to the SDK requesting different types
	// of work.
	Control(BeamFnControl_ControlServer) error
}

func RegisterBeamFnControlServer(s *grpc.Server, srv BeamFnControlServer) {
	s.RegisterService(&_BeamFnControl_serviceDesc, srv)
}

func _BeamFnControl_Control_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnControlServer).Control(&beamFnControlControlServer{stream})
}

type BeamFnControl_ControlServer interface {
	Send(*InstructionRequest) error
	Recv() (*InstructionResponse, error)
	grpc.ServerStream
}

type beamFnControlControlServer struct {
	grpc.ServerStream
}

func (x *beamFnControlControlServer) Send(m *InstructionRequest) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnControlControlServer) Recv() (*InstructionResponse, error) {
	m := new(InstructionResponse)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnControl_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnControl",
	HandlerType: (*BeamFnControlServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Control",
			Handler:       _BeamFnControl_Control_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}

// BeamFnDataClient is the client API for BeamFnData service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnDataClient interface {
	// Used to send data between harnesses.
	Data(ctx context.Context, opts ...grpc.CallOption) (BeamFnData_DataClient, error)
}

type beamFnDataClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnDataClient(cc *grpc.ClientConn) BeamFnDataClient {
	return &beamFnDataClient{cc}
}

func (c *beamFnDataClient) Data(ctx context.Context, opts ...grpc.CallOption) (BeamFnData_DataClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnData_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnData/Data", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnDataDataClient{stream}
	return x, nil
}

type BeamFnData_DataClient interface {
	Send(*Elements) error
	Recv() (*Elements, error)
	grpc.ClientStream
}

type beamFnDataDataClient struct {
	grpc.ClientStream
}

func (x *beamFnDataDataClient) Send(m *Elements) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnDataDataClient) Recv() (*Elements, error) {
	m := new(Elements)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnDataServer is the server API for BeamFnData service.
type BeamFnDataServer interface {
	// Used to send data between harnesses.
	Data(BeamFnData_DataServer) error
}

func RegisterBeamFnDataServer(s *grpc.Server, srv BeamFnDataServer) {
	s.RegisterService(&_BeamFnData_serviceDesc, srv)
}

func _BeamFnData_Data_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnDataServer).Data(&beamFnDataDataServer{stream})
}

type BeamFnData_DataServer interface {
	Send(*Elements) error
	Recv() (*Elements, error)
	grpc.ServerStream
}

type beamFnDataDataServer struct {
	grpc.ServerStream
}

func (x *beamFnDataDataServer) Send(m *Elements) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnDataDataServer) Recv() (*Elements, error) {
	m := new(Elements)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnData_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnData",
	HandlerType: (*BeamFnDataServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Data",
			Handler:       _BeamFnData_Data_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}

// BeamFnStateClient is the client API for BeamFnState service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnStateClient interface {
	// Used to get/append/clear state stored by the runner on behalf of the SDK.
	State(ctx context.Context, opts ...grpc.CallOption) (BeamFnState_StateClient, error)
}

type beamFnStateClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnStateClient(cc *grpc.ClientConn) BeamFnStateClient {
	return &beamFnStateClient{cc}
}

func (c *beamFnStateClient) State(ctx context.Context, opts ...grpc.CallOption) (BeamFnState_StateClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnState_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnState/State", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnStateStateClient{stream}
	return x, nil
}

type BeamFnState_StateClient interface {
	Send(*StateRequest) error
	Recv() (*StateResponse, error)
	grpc.ClientStream
}

type beamFnStateStateClient struct {
	grpc.ClientStream
}

func (x *beamFnStateStateClient) Send(m *StateRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnStateStateClient) Recv() (*StateResponse, error) {
	m := new(StateResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnStateServer is the server API for BeamFnState service.
type BeamFnStateServer interface {
	// Used to get/append/clear state stored by the runner on behalf of the SDK.
	State(BeamFnState_StateServer) error
}

func RegisterBeamFnStateServer(s *grpc.Server, srv BeamFnStateServer) {
	s.RegisterService(&_BeamFnState_serviceDesc, srv)
}

func _BeamFnState_State_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnStateServer).State(&beamFnStateStateServer{stream})
}

type BeamFnState_StateServer interface {
	Send(*StateResponse) error
	Recv() (*StateRequest, error)
	grpc.ServerStream
}

type beamFnStateStateServer struct {
	grpc.ServerStream
}

func (x *beamFnStateStateServer) Send(m *StateResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnStateStateServer) Recv() (*StateRequest, error) {
	m := new(StateRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnState_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnState",
	HandlerType: (*BeamFnStateServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "State",
			Handler:       _BeamFnState_State_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}

// BeamFnLoggingClient is the client API for BeamFnLogging service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnLoggingClient interface {
	// Allows for the SDK to emit log entries which the runner can
	// associate with the active job.
	Logging(ctx context.Context, opts ...grpc.CallOption) (BeamFnLogging_LoggingClient, error)
}

type beamFnLoggingClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnLoggingClient(cc *grpc.ClientConn) BeamFnLoggingClient {
	return &beamFnLoggingClient{cc}
}

func (c *beamFnLoggingClient) Logging(ctx context.Context, opts ...grpc.CallOption) (BeamFnLogging_LoggingClient, error) {
	stream, err := c.cc.NewStream(ctx, &_BeamFnLogging_serviceDesc.Streams[0], "/org.apache.beam.model.fn_execution.v1.BeamFnLogging/Logging", opts...)
	if err != nil {
		return nil, err
	}
	x := &beamFnLoggingLoggingClient{stream}
	return x, nil
}

type BeamFnLogging_LoggingClient interface {
	Send(*LogEntry_List) error
	Recv() (*LogControl, error)
	grpc.ClientStream
}

type beamFnLoggingLoggingClient struct {
	grpc.ClientStream
}

func (x *beamFnLoggingLoggingClient) Send(m *LogEntry_List) error {
	return x.ClientStream.SendMsg(m)
}

func (x *beamFnLoggingLoggingClient) Recv() (*LogControl, error) {
	m := new(LogControl)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// BeamFnLoggingServer is the server API for BeamFnLogging service.
type BeamFnLoggingServer interface {
	// Allows for the SDK to emit log entries which the runner can
	// associate with the active job.
	Logging(BeamFnLogging_LoggingServer) error
}

func RegisterBeamFnLoggingServer(s *grpc.Server, srv BeamFnLoggingServer) {
	s.RegisterService(&_BeamFnLogging_serviceDesc, srv)
}

func _BeamFnLogging_Logging_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(BeamFnLoggingServer).Logging(&beamFnLoggingLoggingServer{stream})
}

type BeamFnLogging_LoggingServer interface {
	Send(*LogControl) error
	Recv() (*LogEntry_List, error)
	grpc.ServerStream
}

type beamFnLoggingLoggingServer struct {
	grpc.ServerStream
}

func (x *beamFnLoggingLoggingServer) Send(m *LogControl) error {
	return x.ServerStream.SendMsg(m)
}

func (x *beamFnLoggingLoggingServer) Recv() (*LogEntry_List, error) {
	m := new(LogEntry_List)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _BeamFnLogging_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnLogging",
	HandlerType: (*BeamFnLoggingServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Logging",
			Handler:       _BeamFnLogging_Logging_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "beam_fn_api.proto",
}

// BeamFnExternalWorkerPoolClient is the client API for BeamFnExternalWorkerPool service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BeamFnExternalWorkerPoolClient interface {
	NotifyRunnerAvailable(ctx context.Context, in *NotifyRunnerAvailableRequest, opts ...grpc.CallOption) (*NotifyRunnerAvailableResponse, error)
}

type beamFnExternalWorkerPoolClient struct {
	cc *grpc.ClientConn
}

func NewBeamFnExternalWorkerPoolClient(cc *grpc.ClientConn) BeamFnExternalWorkerPoolClient {
	return &beamFnExternalWorkerPoolClient{cc}
}

func (c *beamFnExternalWorkerPoolClient) NotifyRunnerAvailable(ctx context.Context, in *NotifyRunnerAvailableRequest, opts ...grpc.CallOption) (*NotifyRunnerAvailableResponse, error) {
	out := new(NotifyRunnerAvailableResponse)
	err := c.cc.Invoke(ctx, "/org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool/NotifyRunnerAvailable", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BeamFnExternalWorkerPoolServer is the server API for BeamFnExternalWorkerPool service.
type BeamFnExternalWorkerPoolServer interface {
	NotifyRunnerAvailable(context.Context, *NotifyRunnerAvailableRequest) (*NotifyRunnerAvailableResponse, error)
}

func RegisterBeamFnExternalWorkerPoolServer(s *grpc.Server, srv BeamFnExternalWorkerPoolServer) {
	s.RegisterService(&_BeamFnExternalWorkerPool_serviceDesc, srv)
}

func _BeamFnExternalWorkerPool_NotifyRunnerAvailable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NotifyRunnerAvailableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BeamFnExternalWorkerPoolServer).NotifyRunnerAvailable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool/NotifyRunnerAvailable",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BeamFnExternalWorkerPoolServer).NotifyRunnerAvailable(ctx, req.(*NotifyRunnerAvailableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BeamFnExternalWorkerPool_serviceDesc = grpc.ServiceDesc{
	ServiceName: "org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool",
	HandlerType: (*BeamFnExternalWorkerPoolServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "NotifyRunnerAvailable",
			Handler:    _BeamFnExternalWorkerPool_NotifyRunnerAvailable_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "beam_fn_api.proto",
}

func init() { proto.RegisterFile("beam_fn_api.proto", fileDescriptor_beam_fn_api_e97479b62fd7f85c) }

var fileDescriptor_beam_fn_api_e97479b62fd7f85c = []byte{
	// 3128 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x5a, 0xdb, 0x6f, 0x1b, 0xd7,
	0x99, 0xf7, 0x88, 0xa4, 0x44, 0x7d, 0xa4, 0x24, 0xf2, 0x48, 0xb2, 0xe9, 0x89, 0xb3, 0xf1, 0x32,
	0x1b, 0x40, 0x2f, 0xa1, 0xaf, 0x9b, 0xd8, 0xd9, 0xc4, 0x89, 0x44, 0xc9, 0x36, 0x13, 0x59, 0xe6,
	0x8e, 0xe4, 0x78, 0x37, 0xd9, 0xcd, 0xe0, 0x88, 0x73, 0x48, 0x1f, 0x78, 0x38, 0x33, 0x39, 0x33,
	0x94, 0x2d, 0x6f, 0xb0, 0x8b, 0x6d, 0x81, 0xf4, 0x82, 0x16, 0x79, 0x0d, 0xda, 0xa7, 0x5e, 0xd0,
	0xc7, 0xfe, 0x0f, 0x7d, 0x2d, 0x0a, 0x14, 0x7d, 0x6d, 0xf3, 0xd8, 0x02, 0x69, 0xd3, 0xd7, 0x02,
	0x05, 0xfa, 0x52, 0x9c, 0xcb, 0x5c, 0x38, 0x24, 0x65, 0x5e, 0x94, 0xbe, 0xf1, 0x9c, 0x33, 0xdf,
	0xef, 0xf7, 0xcd, 0x77, 0xbe, 0xf3, 0x5d, 0xe6, 0x10, 0xca, 0x87, 0x04, 0x77, 0xcd, 0xb6, 0x63,
	0x62, 0x8f, 0xd6, 0x3c, 0xe6, 0x06, 0x2e, 0x7a, 0xc5, 0x65, 0x9d, 0x1a, 0xf6, 0x70, 0xeb, 0x11,
	0xa9, 0xf1, 0xd5, 0x5a, 0xd7, 0xb5, 0x88, 0x5d, 0x6b, 0x3b, 0x26, 0x79, 0x4a, 0x5a, 0xbd, 0x80,
	0xba, 0x4e, 0xed, 0xe8, 0x8a, 0xbe, 0x2e, 0x24, 0x59, 0xcf, 0x71, 0x08, 0x8b, 0xa5, 0xf5, 0x15,
	0xe2, 0x58, 0x9e, 0x4b, 0x9d, 0xc0, 0x57, 0x13, 0x17, 0x3b, 0xae, 0xdb, 0xb1, 0xc9, 0x25, 0x31,
	0x3a, 0xec, 0xb5, 0x2f, 0x59, 0xc4, 0x6f, 0x31, 0xea, 0x05, 0x2e, 0x53, 0x4f, 0xbc, 0x94, 0x7e,
	0x22, 0xa0, 0x5d, 0xe2, 0x07, 0xb8, 0xeb, 0xa9, 0x07, 0xfe, 0x29, 0xfd, 0xc0, 0x13, 0x86, 0x3d,
	0x8f, 0xb0, 0x90, 0x62, 0xa9, 0x4b, 0x02, 0x46, 0x5b, 0x6a, 0x58, 0xfd, 0x81, 0x06, 0xcb, 0x06,
	0xe9, 0xba, 0x01, 0xb9, 0xc3, 0xbc, 0x56, 0xd3, 0x65, 0x01, 0xea, 0xc2, 0x59, 0xec, 0x51, 0xd3,
	0x27, 0xec, 0x88, 0xb6, 0x88, 0x19, 0xab, 0x50, 0xd1, 0x2e, 0x6a, 0x1b, 0x85, 0xab, 0xaf, 0xd7,
	0x86, 0xbf, 0xb4, 0x47, 0x3d, 0x62, 0x53, 0x87, 0xd4, 0x8e, 0xae, 0xd4, 0x36, 0x3d, 0xba, 0x2f,
	0xe5, 0xb7, 0x23, 0x71, 0x63, 0x0d, 0x0f, 0x99, 0x45, 0xe7, 0x21, 0xdf, 0x72, 0x2d, 0xc2, 0x4c,
	0x6a, 0x55, 0xe6, 0x2e, 0x6a, 0x1b, 0x8b, 0xc6, 0x82, 0x18, 0x37, 0xac, 0xea, 0x1f, 0xb2, 0x80,
	0x1a, 0x8e, 0x1f, 0xb0, 0x5e, 0x8b, 0x5b, 0xd2, 0x20, 0x1f, 0xf7, 0x88, 0x1f, 0xa0, 0x57, 0x60,
	0x99, 0xc6, 0xb3, 0x5c, 0x4e, 0x13, 0x72, 0x4b, 0x89, 0xd9, 0x86, 0x85, 0x1e, 0x40, 0x9e, 0x91,
	0x0e, 0xf5, 0x03, 0xc2, 0x2a, 0x5f, 0x2e, 0x08, 0xd5, 0x5f, 0xab, 0x8d, 0xb5, 0x5f, 0x35, 0x43,
	0xc9, 0x29, 0xc6, 0xbb, 0x67, 0x8c, 0x08, 0x0a, 0x11, 0x58, 0xf6, 0x98, 0xdb, 0x22, 0xbe, 0x6f,
	0x1e, 0xf6, 0x1c, 0xcb, 0x26, 0x95, 0x3f, 0x4a, 0xf0, 0x7f, 0x1b, 0x13, 0xbc, 0x29, 0xa5, 0xb7,
	0x84, 0x70, 0xcc, 0xb0, 0xe4, 0x25, 0xe7, 0xd1, 0xff, 0xc2, 0xb9, 0x7e, 0x1a, 0xd3, 0x63, 0x6e,
	0x87, 0x11, 0xdf, 0xaf, 0xfc, 0x49, 0xf2, 0xd5, 0xa7, 0xe1, 0x6b, 0x2a, 0x90, 0x98, 0x77, 0xdd,
	0x1b, 0xb6, 0x8e, 0x7a, 0xb0, 0x96, 0xe2, 0xf7, 0x3d, 0x9b, 0x06, 0x95, 0xaf, 0x24, 0xf9, 0x3b,
	0xd3, 0x90, 0xef, 0x73, 0x84, 0x98, 0x19, 0x79, 0x03, 0x8b, 0xe8, 0x11, 0xac, 0xb4, 0xa9, 0x83,
	0x6d, 0xfa, 0x8c, 0x84, 0xe6, 0xfd, 0xb3, 0x64, 0x7c, 0x73, 0x4c, 0xc6, 0xdb, 0x4a, 0x3c, 0x6d,
	0xdf, 0xe5, 0x76, 0xdf, 0xc2, 0xd6, 0x22, 0x2c, 0x30, 0xb9, 0x58, 0xfd, 0x46, 0x0e, 0x56, 0xfb,
	0xfc, 0xcc, 0xf7, 0x5c, 0xc7, 0x27, 0xe3, 0x3a, 0xda, 0x1a, 0xe4, 0x08, 0x63, 0x2e, 0x53, 0xee,
	0x2b, 0x07, 0xe8, 0xfd, 0x41, 0xf7, 0x7b, 0x7d, 0x62, 0xf7, 0x93, 0x8a, 0xf4, 0xf9, 0x5f, 0x7b,
	0x94, 0xff, 0xbd, 0x39, 0x9d, 0xff, 0x45, 0x14, 0x29, 0x07, 0xfc, 0xbf, 0xe7, 0x3a, 0xe0, 0xf6,
	0x6c, 0x0e, 0x18, 0x11, 0x8f, 0xf0, 0xc0, 0xa3, 0x93, 0x3d, 0x70, 0x73, 0x06, 0x0f, 0x8c, 0xa8,
	0x87, 0xb9, 0x20, 0x1d, 0xe9, 0x82, 0x6f, 0x4d, 0xe9, 0x82, 0x11, 0x5d, 0xda, 0x07, 0x81, 0xfb,
	0x88, 0x5c, 0xad, 0x7e, 0x5f, 0x83, 0x95, 0x54, 0xdc, 0x41, 0xcf, 0xe0, 0x7c, 0xca, 0x04, 0x7d,
	0xd1, 0x38, 0xb3, 0x51, 0xb8, 0x7a, 0x6b, 0x1a, 0x33, 0x24, 0x82, 0xf2, 0x39, 0x6f, 0xf8, 0x42,
	0x15, 0x41, 0x29, 0xed, 0x87, 0xd5, 0x9f, 0x00, 0x9c, 0x1b, 0x01, 0x84, 0x96, 0x61, 0x2e, 0x3a,
	0x20, 0x73, 0xd4, 0x42, 0x0e, 0x40, 0xc0, 0xb0, 0xe3, 0xb7, 0x5d, 0xd6, 0xf5, 0x2b, 0x73, 0x42,
	0xd9, 0xbd, 0xd9, 0x94, 0xad, 0x1d, 0x44, 0x80, 0x3b, 0x4e, 0xc0, 0x8e, 0x8d, 0x04, 0x03, 0x0a,
	0xa0, 0xe8, 0xb5, 0x5c, 0xdb, 0x26, 0xe2, 0x58, 0xfa, 0x95, 0x8c, 0x60, 0x6c, 0xce, 0xc8, 0xd8,
	0x4c, 0x40, 0x4a, 0xce, 0x3e, 0x16, 0xf4, 0x5d, 0x0d, 0xd6, 0x9e, 0x50, 0xc7, 0x72, 0x9f, 0x50,
	0xa7, 0x63, 0xfa, 0x01, 0xc3, 0x01, 0xe9, 0x50, 0xe2, 0x57, 0xb2, 0x82, 0xfe, 0xe1, 0x8c, 0xf4,
	0x0f, 0x43, 0xe8, 0xfd, 0x08, 0x59, 0x6a, 0xb1, 0xfa, 0x64, 0x70, 0x05, 0x1d, 0xc2, 0xbc, 0x48,
	0x9d, 0x7e, 0x25, 0x27, 0xd8, 0xdf, 0x9d, 0x91, 0xbd, 0x2e, 0xc0, 0x24, 0xa1, 0x42, 0xe6, 0x66,
	0x26, 0xce, 0x11, 0x65, 0xae, 0xd3, 0x25, 0x4e, 0xe0, 0x57, 0xe6, 0x4f, 0xc5, 0xcc, 0x3b, 0x09,
	0x48, 0x65, 0xe6, 0x24, 0x0b, 0x7a, 0x0a, 0x17, 0xfc, 0x00, 0x07, 0xc4, 0x1c, 0x51, 0x99, 0x2c,
	0xcc, 0x56, 0x99, 0x9c, 0x17, 0xe0, 0xc3, 0x96, 0x74, 0x1b, 0x56, 0x52, 0x5e, 0x87, 0x4a, 0x90,
	0x79, 0x4c, 0x8e, 0x95, 0xab, 0xf3, 0x9f, 0xa8, 0x0e, 0xb9, 0x23, 0x6c, 0xf7, 0x88, 0xc8, 0x00,
	0x85, 0xab, 0xaf, 0x8e, 0xa1, 0x47, 0x33, 0x42, 0x35, 0xa4, 0xec, 0x1b, 0x73, 0x37, 0x34, 0xdd,
	0x85, 0xf2, 0x80, 0xc7, 0x0d, 0xe1, 0xdb, 0xee, 0xe7, 0xab, 0x8d, 0xc3, 0x57, 0x8f, 0x60, 0x93,
	0x84, 0x9f, 0x40, 0x65, 0x94, 0x8f, 0x0d, 0xe1, 0x7d, 0xb7, 0x9f, 0xf7, 0xfa, 0x18, 0xbc, 0x69,
	0xf4, 0xe3, 0x24, 0x7b, 0x0b, 0x0a, 0x09, 0x1f, 0x1b, 0x42, 0x78, 0xab, 0x9f, 0x70, 0x63, 0x0c,
	0x42, 0x01, 0x98, 0xb2, 0xe9, 0x80, 0x7b, 0x9d, 0x8e, 0x4d, 0x13, 0xb0, 0x09, 0xc2, 0xea, 0xdf,
	0x32, 0x50, 0x96, 0x1e, 0xbe, 0xe9, 0x79, 0x36, 0x6d, 0x61, 0x6e, 0x74, 0xf4, 0x32, 0x2c, 0x79,
	0x51, 0xb8, 0x8a, 0x6b, 0x89, 0x62, 0x3c, 0xd9, 0xb0, 0x78, 0x31, 0x4c, 0x1d, 0xaf, 0x17, 0x24,
	0x8a, 0x61, 0x31, 0x6e, 0x58, 0xa8, 0x02, 0x0b, 0xc4, 0x26, 0x9c, 0xab, 0x92, 0xb9, 0xa8, 0x6d,
	0x14, 0x8d, 0x70, 0x88, 0xfe, 0x07, 0xca, 0x6e, 0x2f, 0xe0, 0x52, 0x4f, 0x70, 0x40, 0x58, 0x17,
	0xb3, 0xc7, 0x61, 0xfc, 0x19, 0x37, 0xe0, 0x0e, 0xa8, 0x5b, 0xbb, 0x2f, 0x10, 0x1f, 0x46, 0x80,
	0xf2, 0x54, 0x96, 0xdc, 0xd4, 0x34, 0x6a, 0x02, 0x50, 0xdf, 0x3c, 0x74, 0x7b, 0x8e, 0x45, 0xac,
	0x4a, 0xee, 0xa2, 0xb6, 0xb1, 0x7c, 0xf5, 0xca, 0x18, 0xb6, 0x6b, 0xf8, 0x5b, 0x52, 0xa6, 0xb6,
	0xe3, 0xf4, 0xba, 0xc6, 0x22, 0x0d, 0xc7, 0xe8, 0xbf, 0xa0, 0xd4, 0x75, 0x1d, 0x1a, 0xb8, 0x8c,
	0x87, 0x54, 0xea, 0xb4, 0xdd, 0x30, 0xca, 0x8c, 0x83, 0x7b, 0x2f, 0x12, 0x6d, 0x38, 0x6d, 0xd7,
	0x58, 0xe9, 0xf6, 0x8d, 0x7d, 0xdd, 0x84, 0xf5, 0xa1, 0xaf, 0x36, 0xc4, 0x23, 0x2e, 0xf7, 0x7b,
	0x84, 0x5e, 0x93, 0xad, 0x55, 0x2d, 0x6c, 0xad, 0x6a, 0x07, 0x61, 0xef, 0x95, 0xdc, 0xfd, 0x5f,
	0x69, 0x50, 0xd9, 0x26, 0x36, 0x3e, 0x26, 0xd6, 0xa0, 0x13, 0x1c, 0x40, 0x45, 0x15, 0x9d, 0xc4,
	0x8a, 0x77, 0xc0, 0xe4, 0x4d, 0x9c, 0xea, 0xae, 0x4e, 0x62, 0x39, 0x1b, 0xc9, 0xee, 0x84, 0xa2,
	0x7c, 0x11, 0x7d, 0x00, 0x05, 0x1c, 0x93, 0x28, 0x75, 0x6f, 0x4c, 0xbb, 0xf5, 0x46, 0x12, 0xac,
	0xfa, 0x6d, 0x0d, 0xd6, 0x86, 0x75, 0x2c, 0xe8, 0x1e, 0xbc, 0x3c, 0xb2, 0x36, 0x31, 0x19, 0x69,
	0x13, 0x46, 0x9c, 0x16, 0x51, 0xf6, 0xbc, 0x38, 0xa2, 0xca, 0x30, 0xc2, 0xe7, 0xd0, 0x3f, 0x43,
	0xb1, 0xc5, 0x55, 0x35, 0x03, 0xf7, 0x31, 0x71, 0x64, 0xc1, 0x50, 0x34, 0x0a, 0x62, 0xee, 0x40,
	0x4c, 0x55, 0xbf, 0x98, 0x83, 0xf5, 0xa1, 0xc5, 0x2b, 0xba, 0x0b, 0x0b, 0xaa, 0xad, 0x55, 0x56,
	0xac, 0x8d, 0xf9, 0xf2, 0xf7, 0xa4, 0x94, 0x11, 0x8a, 0xf3, 0xea, 0x9a, 0x11, 0x9f, 0x5a, 0x3d,
	0x6c, 0x9b, 0xcc, 0x75, 0x83, 0xb0, 0x72, 0x79, 0x7b, 0x4c, 0xc0, 0x51, 0x3b, 0x6f, 0x2c, 0x85,
	0xb0, 0x06, 0x47, 0x1d, 0xea, 0xe4, 0x99, 0xd3, 0x72, 0x72, 0x74, 0x0d, 0xd6, 0xb9, 0xab, 0x50,
	0x46, 0x7c, 0x53, 0x95, 0x9c, 0xd2, 0x35, 0xb2, 0x17, 0xb5, 0x8d, 0xbc, 0xb1, 0x16, 0x2e, 0xde,
	0x4e, 0xac, 0x55, 0xf7, 0xe1, 0xc2, 0x49, 0xad, 0x22, 0x07, 0x4d, 0x76, 0x43, 0xe9, 0x2d, 0x5e,
	0xa3, 0xc9, 0x0e, 0x4a, 0xad, 0x55, 0x3f, 0x5f, 0x85, 0x05, 0x65, 0x64, 0x84, 0xa1, 0xe0, 0x25,
	0x4a, 0x42, 0x6d, 0x22, 0xc3, 0x2a, 0x90, 0x5a, 0x33, 0x48, 0xd5, 0x80, 0x49, 0x4c, 0xfd, 0x8b,
	0x02, 0x40, 0x9c, 0x59, 0xd1, 0x33, 0x08, 0x0b, 0x7c, 0x7e, 0xdc, 0x64, 0xb8, 0x0c, 0x5d, 0xe4,
	0xbd, 0x49, 0x89, 0x23, 0xd8, 0xb0, 0x8a, 0x21, 0xd6, 0x8e, 0x82, 0x34, 0xca, 0x5e, 0x7a, 0x0a,
	0x7d, 0x0c, 0x2b, 0xb8, 0x15, 0xd0, 0x23, 0x12, 0x13, 0xcb, 0x83, 0x79, 0x77, 0x7a, 0xe2, 0x4d,
	0x01, 0x18, 0xb1, 0x2e, 0xe3, 0xbe, 0x31, 0xa2, 0x00, 0x89, 0x0c, 0x20, 0xdd, 0xa9, 0x31, 0x3d,
	0x5b, 0x3a, 0xf8, 0x27, 0xc0, 0xd1, 0x1d, 0xc8, 0xf6, 0x7c, 0xc2, 0x54, 0x9a, 0xb9, 0x36, 0x21,
	0xc9, 0x03, 0x9f, 0x30, 0x43, 0x00, 0xe8, 0xbf, 0xcf, 0x40, 0xfe, 0x1e, 0xc1, 0x7e, 0x8f, 0x11,
	0x0b, 0x7d, 0x4f, 0x83, 0x35, 0x99, 0xff, 0x94, 0xcd, 0xcc, 0x96, 0xdb, 0x93, 0x5b, 0xc6, 0x69,
	0x3e, 0x98, 0xfe, 0x5d, 0x42, 0x8a, 0x5a, 0x83, 0xc3, 0x2b, 0x8b, 0xd5, 0x05, 0xb8, 0x7c, 0x39,
	0x44, 0x07, 0x16, 0xd0, 0x67, 0x1a, 0xac, 0xab, 0xcc, 0x9a, 0xd2, 0x47, 0x06, 0x85, 0x0f, 0x4f,
	0x41, 0x1f, 0x99, 0x8c, 0x86, 0x28, 0xb4, 0xea, 0x0e, 0xae, 0xa0, 0x0d, 0x28, 0x05, 0x6e, 0x80,
	0x6d, 0x91, 0x31, 0x4c, 0xdf, 0x0b, 0xab, 0x01, 0xcd, 0x58, 0x16, 0xf3, 0x3c, 0x1d, 0xec, 0xf3,
	0x59, 0x7d, 0x07, 0xce, 0x8d, 0x78, 0xd5, 0x21, 0x99, 0x6e, 0x2d, 0x99, 0xe9, 0x32, 0xc9, 0xe2,
	0xe9, 0x36, 0x54, 0x46, 0x69, 0x38, 0x11, 0x8e, 0x0f, 0xe5, 0x81, 0x53, 0x83, 0x3e, 0x82, 0x7c,
	0x57, 0xd9, 0x41, 0x1d, 0xca, 0xad, 0xd9, 0x2d, 0x6a, 0x44, 0x98, 0xfa, 0x67, 0x19, 0x58, 0xee,
	0x3f, 0x32, 0x5f, 0x37, 0x25, 0x7a, 0x15, 0x50, 0x9b, 0xe1, 0x30, 0x42, 0x76, 0x31, 0x75, 0xa8,
	0xd3, 0x11, 0xe6, 0xd0, 0x8c, 0x72, 0xb8, 0x62, 0x84, 0x0b, 0xe8, 0x47, 0x1a, 0x9c, 0xef, 0xf7,
	0x30, 0x3f, 0x21, 0x26, 0x4f, 0x30, 0x39, 0xad, 0x78, 0xd1, 0xef, 0x6b, 0x7e, 0xa4, 0x85, 0xf4,
	0xb7, 0x73, 0xee, 0xf0, 0x55, 0xfd, 0x5d, 0xb8, 0x70, 0x92, 0xe0, 0x44, 0x6e, 0xf0, 0x16, 0xac,
	0x3c, 0xbf, 0xee, 0x1a, 0x2d, 0xfe, 0xeb, 0x1c, 0x64, 0x79, 0xec, 0x40, 0x26, 0x14, 0x64, 0xc6,
	0x36, 0x1d, 0x1c, 0x95, 0x4e, 0xb7, 0xa6, 0x88, 0x42, 0x6a, 0xb0, 0x87, 0xbb, 0xc4, 0x80, 0x6e,
	0xf4, 0x1b, 0x11, 0x28, 0x8a, 0xa3, 0x4e, 0x98, 0x69, 0xe1, 0x00, 0x87, 0xdf, 0xd8, 0xde, 0x9e,
	0x86, 0xa2, 0x2e, 0x81, 0xb6, 0x71, 0x80, 0xef, 0x9e, 0x31, 0x0a, 0xad, 0x78, 0x88, 0x02, 0x28,
	0x5b, 0xd4, 0x0f, 0x18, 0x3d, 0x94, 0x85, 0xa0, 0xe0, 0x9a, 0xf0, 0xf3, 0x5a, 0x1f, 0xd7, 0x76,
	0x02, 0x4d, 0x11, 0x96, 0xac, 0xd4, 0x1c, 0x32, 0x01, 0x3a, 0xb8, 0xd7, 0x21, 0x92, 0xee, 0xab,
	0xc9, 0x3e, 0x6e, 0xf5, 0xd1, 0xdd, 0xe1, 0x30, 0x8a, 0x67, 0xb1, 0x13, 0x0e, 0xf4, 0x5b, 0x00,
	0xb1, 0x5d, 0xd1, 0x05, 0x58, 0xe4, 0xbb, 0xe4, 0x7b, 0xb8, 0x45, 0x54, 0x57, 0x13, 0x4f, 0x20,
	0x04, 0x59, 0xb1, 0x87, 0x19, 0xb1, 0x20, 0x7e, 0xeb, 0x2f, 0xf3, 0xbe, 0x30, 0xb6, 0x52, 0xe4,
	0x10, 0x5a, 0xc2, 0x21, 0xf4, 0x8f, 0xa0, 0x94, 0x7e, 0x5b, 0xfe, 0xa4, 0x30, 0x6f, 0xf8, 0xa4,
	0x18, 0x70, 0x17, 0xf3, 0x7b, 0x5d, 0xe5, 0x4e, 0xfc, 0x27, 0x9f, 0xe9, 0x52, 0x47, 0x70, 0x66,
	0x0c, 0xfe, 0x53, 0xcc, 0xe0, 0xa7, 0xa2, 0x40, 0xe2, 0x33, 0xf8, 0xa9, 0xfe, 0x21, 0x2c, 0x46,
	0xaf, 0x37, 0x5c, 0x05, 0x74, 0x03, 0x16, 0xa3, 0xfb, 0x97, 0x31, 0xba, 0x84, 0xf8, 0xe1, 0xad,
	0x79, 0xc8, 0x72, 0xe3, 0xeb, 0xc7, 0x50, 0x4a, 0x57, 0x34, 0x43, 0x4e, 0xc4, 0xfd, 0xfe, 0x4e,
	0xe4, 0xe6, 0xd4, 0x11, 0x21, 0xd9, 0xa8, 0xfc, 0x6c, 0x0e, 0x5e, 0x3c, 0xf1, 0xd3, 0xec, 0x29,
	0x96, 0xd5, 0x5f, 0x6f, 0xb9, 0xfb, 0xdf, 0xb0, 0xe4, 0x31, 0xda, 0xc5, 0xec, 0x58, 0xd5, 0xec,
	0xb2, 0x2a, 0x99, 0xbe, 0x03, 0x2a, 0x2a, 0x38, 0x51, 0xab, 0x57, 0x7f, 0x9b, 0x83, 0xf3, 0x23,
	0xef, 0x31, 0xa6, 0x2a, 0x8b, 0xd1, 0x37, 0x35, 0x28, 0x1f, 0xe2, 0xd6, 0x63, 0xdb, 0xed, 0xf4,
	0xa5, 0x09, 0xae, 0xf6, 0xfb, 0xb3, 0x5e, 0xad, 0xd4, 0xb6, 0x24, 0x72, 0x2a, 0xc0, 0x97, 0x0e,
	0x53, 0xd3, 0xe8, 0x19, 0x2c, 0x5b, 0xc4, 0xa7, 0x8c, 0x58, 0xf2, 0xd3, 0x7a, 0xb8, 0x27, 0xfb,
	0x33, 0x6b, 0xb0, 0x2d, 0x61, 0xc5, 0x9c, 0xaa, 0x67, 0x96, 0xac, 0xe4, 0x9c, 0x5e, 0x87, 0xf5,
	0xa1, 0x6a, 0x3e, 0x2f, 0x1f, 0x14, 0x93, 0xf9, 0xe0, 0xe7, 0x1a, 0x14, 0x93, 0x54, 0xe8, 0x2a,
	0xac, 0x47, 0xe9, 0xd7, 0x6d, 0x2b, 0xd3, 0x5a, 0x44, 0x5e, 0x5d, 0xce, 0x19, 0xab, 0xe1, 0xe2,
	0xfd, 0xb6, 0x11, 0x2e, 0xa1, 0xcb, 0xb0, 0x86, 0x6d, 0xdb, 0x7d, 0x12, 0x5a, 0xc1, 0x94, 0x57,
	0xb2, 0xc2, 0x16, 0x19, 0x03, 0xa9, 0x35, 0x81, 0xdf, 0x14, 0x2b, 0xe8, 0x06, 0x54, 0x88, 0x1f,
	0xd0, 0x2e, 0xe6, 0x5d, 0x7c, 0x5f, 0xbd, 0xea, 0xab, 0x20, 0x73, 0x36, 0x5a, 0x4f, 0x16, 0x61,
	0xbe, 0xfe, 0x99, 0x06, 0x68, 0xd0, 0x36, 0x43, 0xde, 0xb9, 0xd5, 0x7f, 0xe2, 0xef, 0x9d, 0xea,
	0x8e, 0x24, 0xa3, 0xc0, 0x5f, 0x33, 0xa0, 0x8f, 0xbe, 0x22, 0x19, 0x3c, 0x5a, 0xda, 0x69, 0x1e,
	0xad, 0x7f, 0x58, 0xbb, 0xdd, 0x83, 0xe5, 0xd6, 0x23, 0xec, 0x38, 0xc4, 0xee, 0xf7, 0xf4, 0xbd,
	0x99, 0x2f, 0x91, 0x6a, 0x75, 0x89, 0x2b, 0x27, 0x97, 0x5a, 0x89, 0x91, 0xaf, 0xff, 0x50, 0x83,
	0x62, 0x72, 0x7d, 0xbc, 0x8f, 0x80, 0x97, 0x61, 0xcd, 0xc6, 0x7e, 0x60, 0x86, 0x86, 0x0f, 0x3f,
	0xfb, 0x71, 0x57, 0xc8, 0x19, 0x88, 0xaf, 0x35, 0xe5, 0x92, 0xf2, 0x2b, 0x74, 0x1d, 0xce, 0xb6,
	0x29, 0xf3, 0x03, 0x33, 0x32, 0x66, 0xf2, 0x53, 0x61, 0xce, 0x58, 0x13, 0xab, 0x86, 0x5a, 0x54,
	0x52, 0xd5, 0x5d, 0x58, 0x1f, 0x7a, 0x59, 0x3a, 0x5d, 0xa7, 0x5f, 0x81, 0xb3, 0xc3, 0xef, 0xbd,
	0xaa, 0xbf, 0xd4, 0x20, 0x1f, 0x15, 0xe0, 0x77, 0x65, 0xe2, 0x53, 0x7e, 0x74, 0x7d, 0x4c, 0xfb,
	0x47, 0x25, 0x2c, 0x4f, 0xc6, 0x86, 0x4c, 0x9d, 0x01, 0x64, 0x45, 0x6a, 0x9e, 0x2a, 0x00, 0x0f,
	0x6c, 0xc4, 0xdc, 0x90, 0x8d, 0x40, 0x4a, 0x57, 0xf9, 0xbd, 0x55, 0xfc, 0xae, 0xfe, 0x38, 0x03,
	0xc5, 0xfd, 0x00, 0x07, 0x91, 0xb1, 0xd2, 0xf7, 0x5e, 0x23, 0xd5, 0x99, 0x3b, 0x41, 0x9d, 0x5d,
	0x58, 0x94, 0xf7, 0x1b, 0x3c, 0x0c, 0x64, 0xc4, 0x91, 0xbf, 0x34, 0xa6, 0x69, 0x84, 0x32, 0xef,
	0x91, 0x63, 0x23, 0xef, 0xab, 0x5f, 0xe8, 0x3d, 0xc8, 0x74, 0x48, 0x30, 0xe9, 0x9f, 0x1e, 0x04,
	0xd0, 0x1d, 0x92, 0xb8, 0xa0, 0xe7, 0x28, 0xe8, 0x00, 0xe6, 0xb1, 0xe7, 0x11, 0xc7, 0x0a, 0x6b,
	0xe0, 0x9b, 0x93, 0xe0, 0x6d, 0x0a, 0xd1, 0x18, 0x52, 0x61, 0xa1, 0x7f, 0x87, 0x5c, 0xcb, 0x26,
	0x98, 0x85, 0xc5, 0xee, 0x8d, 0x49, 0x40, 0xeb, 0x5c, 0x32, 0xc6, 0x94, 0x48, 0xc9, 0x0b, 0xfd,
	0xdf, 0xcd, 0xc1, 0x92, 0xda, 0x24, 0x15, 0xc7, 0xd2, 0xbb, 0x34, 0xfc, 0xce, 0xfe, 0x25, 0x28,
	0x24, 0x3e, 0x42, 0xaa, 0x7d, 0x87, 0xf8, 0x1b, 0x24, 0xda, 0xed, 0xb3, 0xec, 0xeb, 0x13, 0x5b,
	0x36, 0xba, 0x09, 0x16, 0xa6, 0x7d, 0x90, 0x36, 0xed, 0x1b, 0xd3, 0x98, 0x36, 0xc2, 0x0c, 0x6d,
	0x6b, 0xa4, 0x6c, 0x7b, 0x73, 0x0a, 0xdb, 0x46, 0xa0, 0xca, 0xb8, 0xc9, 0x9b, 0xea, 0x2f, 0xb3,
	0x90, 0x0f, 0xbd, 0x0e, 0x35, 0x61, 0x5e, 0xfe, 0xaf, 0x49, 0x95, 0x88, 0xaf, 0x4d, 0xe8, 0xb6,
	0x35, 0x43, 0x48, 0x73, 0xf5, 0x25, 0x0e, 0xf2, 0x61, 0xb5, 0xdb, 0xb3, 0x79, 0xfa, 0xf4, 0x4c,
	0x9f, 0x5a, 0x44, 0x66, 0x58, 0x95, 0x08, 0x37, 0x27, 0x85, 0xbf, 0xa7, 0xa0, 0xf6, 0xa9, 0x45,
	0x44, 0x2e, 0xbe, 0x7b, 0xc6, 0x28, 0x77, 0xd3, 0x93, 0xc8, 0x82, 0xe5, 0x43, 0xdc, 0x31, 0x7b,
	0x3e, 0x61, 0xa6, 0x38, 0x47, 0xea, 0x14, 0xbe, 0x39, 0x29, 0xdf, 0x16, 0xee, 0xf0, 0xce, 0x48,
	0x8c, 0xef, 0x9e, 0x31, 0x8a, 0x87, 0x89, 0xb1, 0xae, 0xc3, 0xbc, 0x7c, 0xdd, 0x64, 0xc6, 0x2f,
	0x8a, 0x8c, 0xaf, 0x7f, 0xaa, 0x41, 0x79, 0x40, 0xd9, 0xf1, 0x12, 0x46, 0x15, 0x96, 0x62, 0x43,
	0xc5, 0xc1, 0xac, 0xe0, 0x87, 0x30, 0x0d, 0x0b, 0x9d, 0x85, 0x79, 0x79, 0x65, 0xac, 0xbc, 0x5a,
	0x8d, 0x42, 0x45, 0xb2, 0xb1, 0x22, 0xff, 0xaf, 0x41, 0x31, 0xf9, 0x16, 0x63, 0xeb, 0x10, 0x1b,
	0x2f, 0xa1, 0x43, 0x2f, 0x84, 0x99, 0x44, 0x07, 0xde, 0x1e, 0x05, 0xc7, 0x1e, 0xa9, 0xbe, 0x03,
	0x2b, 0xa9, 0xb0, 0x84, 0x5e, 0x05, 0xd4, 0x72, 0x9d, 0x80, 0x3a, 0x3d, 0x2c, 0xef, 0x4e, 0xc4,
	0x51, 0x95, 0x86, 0x2c, 0x27, 0x57, 0xc4, 0x89, 0xad, 0x3e, 0x80, 0x52, 0xfa, 0xf8, 0x4d, 0x08,
	0x11, 0xa5, 0x81, 0xb9, 0x44, 0x1a, 0xd8, 0x00, 0x34, 0x18, 0xdf, 0xa2, 0x27, 0xb5, 0xc4, 0x93,
	0xeb, 0xb0, 0x3a, 0xe4, 0xb8, 0x56, 0x57, 0xa1, 0x3c, 0x10, 0xcb, 0xaa, 0x6b, 0x0a, 0xb5, 0xef,
	0x10, 0x56, 0x7f, 0x93, 0x85, 0xfc, 0xae, 0xab, 0xca, 0xe3, 0xff, 0x84, 0xbc, 0x4f, 0x8e, 0x08,
	0xa3, 0x81, 0xf4, 0x9e, 0xe5, 0xb1, 0x1b, 0xf7, 0x10, 0xa2, 0xb6, 0xaf, 0xe4, 0xe5, 0xcd, 0x5b,
	0x04, 0x37, 0x7d, 0x37, 0x8b, 0x2a, 0xbc, 0x51, 0xf4, 0x7d, 0xdc, 0x09, 0xdb, 0xf8, 0x70, 0xc8,
	0xe3, 0x6c, 0xc0, 0x78, 0xdf, 0x9f, 0x95, 0x71, 0x56, 0x0c, 0x46, 0xe7, 0xc8, 0xdc, 0x09, 0x39,
	0x72, 0x0b, 0x5e, 0xe4, 0x15, 0x11, 0x15, 0xdf, 0xd4, 0x63, 0x7f, 0x8c, 0x85, 0xe7, 0x85, 0xf0,
	0x0b, 0xd1, 0x43, 0x71, 0xd7, 0x9b, 0xbc, 0x65, 0xe2, 0x2d, 0x97, 0xed, 0xaa, 0xab, 0xb2, 0x05,
	0xe9, 0xa4, 0xb6, 0xdb, 0xd9, 0x55, 0x53, 0xdc, 0x49, 0x83, 0x47, 0x8c, 0x60, 0xab, 0x92, 0x17,
	0x8b, 0x6a, 0xa4, 0xff, 0x07, 0x64, 0x77, 0xa9, 0x1f, 0xa0, 0x26, 0xf0, 0xc7, 0x4d, 0xe2, 0x04,
	0x8c, 0x92, 0xb0, 0x1e, 0xbe, 0x34, 0xe1, 0x1e, 0x18, 0x60, 0xcb, 0x5f, 0x94, 0xf8, 0x3a, 0x83,
	0x7c, 0xb8, 0x25, 0xd5, 0x36, 0x64, 0xf9, 0xae, 0xa0, 0x15, 0x28, 0x3c, 0xd8, 0xdb, 0x6f, 0xee,
	0xd4, 0x1b, 0xb7, 0x1b, 0x3b, 0xdb, 0xa5, 0x33, 0x68, 0x11, 0x72, 0x07, 0xc6, 0x66, 0x7d, 0xa7,
	0xa4, 0xf1, 0x9f, 0xdb, 0x3b, 0x5b, 0x0f, 0xee, 0x94, 0xe6, 0x50, 0x1e, 0xb2, 0x8d, 0xbd, 0xdb,
	0xf7, 0x4b, 0x19, 0x04, 0x30, 0xbf, 0x77, 0xff, 0xa0, 0x51, 0xdf, 0x29, 0x65, 0xf9, 0xec, 0xc3,
	0x4d, 0x63, 0xaf, 0x94, 0xe3, 0x8f, 0xee, 0x18, 0xc6, 0x7d, 0xa3, 0x34, 0x8f, 0x8a, 0x90, 0xaf,
	0x1b, 0x8d, 0x83, 0x46, 0x7d, 0x73, 0xb7, 0xb4, 0x50, 0x2d, 0x02, 0xec, 0xba, 0x9d, 0xba, 0xeb,
	0x04, 0xcc, 0xb5, 0xab, 0x7f, 0xc9, 0xc2, 0x85, 0x3d, 0x37, 0xa0, 0xed, 0x63, 0x19, 0x9e, 0x36,
	0x8f, 0x30, 0xb5, 0xf1, 0x61, 0x5c, 0x11, 0xbe, 0x00, 0x8b, 0x4f, 0x5c, 0xf6, 0x58, 0xfe, 0x4b,
	0x53, 0x1e, 0xff, 0xbc, 0x9c, 0x68, 0x58, 0xe8, 0x10, 0x4a, 0x2d, 0x09, 0x64, 0x86, 0x7f, 0x68,
	0x55, 0xee, 0x33, 0xf5, 0x1f, 0x32, 0x56, 0x14, 0xe0, 0x8e, 0xc2, 0xe3, 0x1c, 0xb6, 0xdb, 0xe9,
	0x50, 0xa7, 0x13, 0x73, 0x64, 0x66, 0xe4, 0x50, 0x80, 0x11, 0x87, 0x05, 0x65, 0xcc, 0x02, 0xda,
	0xc6, 0xad, 0x20, 0x26, 0xc9, 0xce, 0x46, 0x52, 0x0a, 0x11, 0x23, 0x96, 0xb6, 0xb8, 0x93, 0x3a,
	0xa2, 0x3e, 0xf7, 0xfc, 0x88, 0x26, 0x37, 0x1b, 0x4d, 0x39, 0x82, 0x8c, 0x78, 0x3a, 0x30, 0xef,
	0x61, 0x86, 0xbb, 0x7e, 0x05, 0x84, 0x8b, 0xde, 0x1f, 0xd3, 0x45, 0x4f, 0xf2, 0x83, 0x5a, 0x53,
	0x20, 0xaa, 0x7f, 0x04, 0x49, 0x78, 0xfd, 0x26, 0x14, 0x12, 0xd3, 0xcf, 0xeb, 0xdf, 0x17, 0x93,
	0xcd, 0xe7, 0xbf, 0xc2, 0x8b, 0x23, 0xe8, 0x54, 0xa4, 0x8e, 0xca, 0x34, 0x2d, 0x51, 0xa6, 0x5d,
	0xfd, 0x5c, 0x83, 0xa5, 0x2d, 0x82, 0xbb, 0xb7, 0x1d, 0xe5, 0xc0, 0xe8, 0x53, 0x0d, 0x16, 0xc2,
	0xdf, 0xe3, 0x16, 0x51, 0x43, 0xfe, 0xf1, 0xa9, 0xdf, 0x9c, 0x46, 0x56, 0xc6, 0xee, 0x33, 0x1b,
	0xda, 0x65, 0xed, 0xea, 0x27, 0x00, 0x52, 0x33, 0xd1, 0x9a, 0x38, 0xaa, 0x45, 0xb9, 0x34, 0x61,
	0x9b, 0xa3, 0x4f, 0x2a, 0xa0, 0xd8, 0xbf, 0xa5, 0x41, 0x41, 0xd2, 0xcb, 0xcc, 0xfd, 0x14, 0x72,
	0xf2, 0xc7, 0xb5, 0x49, 0xca, 0x18, 0xf5, 0x46, 0xfa, 0xf5, 0xc9, 0x84, 0x54, 0xb6, 0x92, 0x9a,
	0x7c, 0x27, 0xda, 0xa2, 0x5d, 0x79, 0xca, 0xd0, 0x53, 0x58, 0x08, 0x7f, 0x5e, 0x9f, 0x34, 0x63,
	0xf1, 0xc0, 0xab, 0x5f, 0x19, 0x5f, 0x2a, 0x8c, 0x6b, 0x52, 0x97, 0x5f, 0x68, 0x50, 0x91, 0xba,
	0xec, 0x3c, 0x0d, 0x08, 0x73, 0xb0, 0xfd, 0x50, 0x84, 0xae, 0xa6, 0xeb, 0xda, 0xe8, 0xa7, 0x1a,
	0xac, 0x0f, 0xf5, 0x41, 0x54, 0x3f, 0x85, 0x03, 0xa3, 0x6f, 0xcf, 0x06, 0x12, 0xda, 0x74, 0x6b,
	0x13, 0xfe, 0x65, 0x14, 0x50, 0x12, 0x67, 0x6b, 0x51, 0xbe, 0xe8, 0xa6, 0x47, 0x3f, 0x58, 0x4e,
	0x2c, 0x99, 0x47, 0x57, 0x0e, 0xe7, 0x45, 0x0e, 0xbf, 0xf6, 0xf7, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x9b, 0xb0, 0x51, 0x80, 0xc7, 0x30, 0x00, 0x00,
}
