<!--
    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.
-->

> **PLEASE update this file if you add new job or change name/trigger phrase in groovy files.**

## Beam Jenkins

Beam Jenkins overview page: [link](https://builds.apache.org/view/A-D/view/Beam/view)

### PreCommit Jobs

| Name | Link | PR Trigger Phrase | Cron Status |
|------|------|-------------------|-------------|
| beam_PreCommit_Go | [commit](https://builds.apache.org/job/beam_PreCommit_Go_Commit/), [cron](https://builds.apache.org/job/beam_PreCommit_Go_Cron/), [phrase](https://builds.apache.org/job/beam_PreCommit_Go_Phrase/) | `Run Go PreCommit` | [![Build Status](https://builds.apache.org/job/beam_PreCommit_Go_Cron/badge/icon)](https://builds.apache.org/job/beam_PreCommit_Go_Cron) |
| beam_PreCommit_JavaPortabilityApi | [commit](), [cron](), [phrase]() | `Run JavaPortabilityApi PreCommit` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Go/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Go) |
| beam_PreCommit_CommunityMetrics | [commit](https://builds.apache.org/job/beam_PreCommit_CommunityMetrics_Commit/), [cron](https://builds.apache.org/job/beam_PreCommit_CommunityMetrics_Cron/), [phrase](https://builds.apache.org/job/beam_PreCommit_CommunityMetrics_Phrase/) | `Run CommunityMetrics PreCommit` | [![Build Status](https://builds.apache.org/job/beam_PreCommit_CommunityMetrics_Cron/badge/icon)](https://builds.apache.org/job/beam_PreCommit_CommunityMetrics_Cron) |
| beam_PreCommit_Go | [commit](https://builds.apache.org/job/beam_PreCommit_Go_Commit/), [cron](https://builds.apache.org/job/beam_PreCommit_Go_Cron/), [phrase](https://builds.apache.org/job/beam_PreCommit_Go_Phrase/) | `Run Go PreCommit` | [![Build Status](https://builds.apache.org/job/beam_PreCommit_Go_Cron/badge/icon)](https://builds.apache.org/job/beam_PreCommit_Go_Cron) |
| beam_PreCommit_Java | [commit](https://builds.apache.org/job/beam_PreCommit_Java_Commit/), [cron](https://builds.apache.org/job/beam_PreCommit_Java_Cron/), [phrase](https://builds.apache.org/job/beam_PreCommit_Java_Phrase/) | `Run Java PreCommit` | [![Build Status](https://builds.apache.org/job/beam_PreCommit_Java_Cron/badge/icon)](https://builds.apache.org/job/beam_PreCommit_Java_Cron) |
| beam_PreCommit_JavaPortabilityApi | [commit](https://builds.apache.org/job/beam_PreCommit_JavaPortabilityApi_Commit/), [cron](https://builds.apache.org/job/beam_PreCommit_JavaPortabilityApi_Cron/), [phrase](https://builds.apache.org/job/beam_PreCommit_JavaPortabilityApi_Phrase/) | `Run JavaPortabilityApi PreCommit` | [![Build Status](https://builds.apache.org/job/beam_PreCommit_JavaPortabilityApi_Cron/badge/icon)](https://builds.apache.org/job/beam_PreCommit_JavaPortabilityApi_Cron) |
| beam_PreCommit_Java_Examples_Dataflow | [commit](https://builds.apache.org/job/beam_PreCommit_Java_Examples_Dataflow_Commit/), [cron](https://builds.apache.org/job/beam_PreCommit_Java_Examples_Dataflow_Cron/), [phrase](https://builds.apache.org/job/beam_PreCommit_Java_Examples_Dataflow_Phrase/) | `Run Java PreCommit` | [![Build Status](https://builds.apache.org/job/beam_PreCommit_Java_Examples_Dataflow_Cron/badge/icon)](https://builds.apache.org/job/beam_PreCommit_Java_Examples_Dataflow_Cron) |
| beam_PreCommit_Portable_Python | [commit](https://builds.apache.org/job/beam_PreCommit_Portable_Python_Commit/), [cron](https://builds.apache.org/job/beam_PreCommit_Portable_Python_Cron/), [phrase](https://builds.apache.org/job/beam_PreCommit_Portable_Python_Phrase/) | `Run Portable PreCommit` | [![Build Status](https://builds.apache.org/job/beam_PreCommit_Portable_Python_Cron/badge/icon)](https://builds.apache.org/job/beam_PreCommit_Portable_Python_Cron) |
| beam_PreCommit_Python | [commit](https://builds.apache.org/job/beam_PreCommit_Python_Commit/), [cron](https://builds.apache.org/job/beam_PreCommit_Python_Cron/), [phrase](https://builds.apache.org/job/beam_PreCommit_Python_Phrase/) | `Run Python PreCommit` | [![Build Status](https://builds.apache.org/job/beam_PreCommit_Python_Cron/badge/icon)](https://builds.apache.org/job/beam_PreCommit_Python_Cron) |
| beam_PreCommit_Python_PVR_Flink | [commit](https://builds.apache.org/job/beam_PreCommit_Python_PVR_Flink_Commit/), [cron](https://builds.apache.org/job/beam_PreCommit_Python_PVR_Flink_Cron/), [phrase](https://builds.apache.org/job/beam_PreCommit_Python_PVR_Flink_Phrase/) | `Run Python PreCommit` | [![Build Status](https://builds.apache.org/job/beam_PreCommit_Python_PVR_Flink_Cron/badge/icon)](https://builds.apache.org/job/beam_PreCommit_Python_PVR_Flink_Cron) |
| beam_PreCommit_RAT | [commit](https://builds.apache.org/job/beam_PreCommit_RAT_Commit/), [cron](https://builds.apache.org/job/beam_PreCommit_RAT_Cron/), [phrase](https://builds.apache.org/job/beam_PreCommit_RAT_Phrase/) | `Run RAT PreCommit` | [![Build Status](https://builds.apache.org/job/beam_PreCommit_RAT_Cron/badge/icon)](https://builds.apache.org/job/beam_PreCommit_RAT_Cron) |
| beam_PreCommit_Spotless | [commit](https://builds.apache.org/job/beam_PreCommit_Spotless_Commit/), [cron](https://builds.apache.org/job/beam_PreCommit_Spotless_Cron/), [phrase](https://builds.apache.org/job/beam_PreCommit_Spotless_Phrase/) | `Run Spotless PreCommit` | [![Build Status](https://builds.apache.org/job/beam_PreCommit_Spotless_Cron/badge/icon)](https://builds.apache.org/job/beam_PreCommit_Spotless_Cron) |
| beam_PreCommit_Website | [commit](https://builds.apache.org/job/beam_PreCommit_Website_Commit/), [cron](https://builds.apache.org/job/beam_PreCommit_Website_Cron/), [phrase](https://builds.apache.org/job/beam_PreCommit_Website_Phrase/) | `Run Website PreCommit` | [![Build Status](https://builds.apache.org/job/beam_PreCommit_Website_Cron/badge/icon)](https://builds.apache.org/job/beam_PreCommit_Website_Cron) |
| beam_PreCommit_Website_Stage_GCS | [commit](https://builds.apache.org/job/beam_PreCommit_Website_Stage_GCS_Commit/), [cron](https://builds.apache.org/job/beam_PreCommit_Website_Stage_GCS_Cron/), [phrase](https://builds.apache.org/job/beam_PreCommit_Website_Stage_GCS_Phrase/) | `Run Website PreCommit` | [![Build Status](https://builds.apache.org/job/beam_PreCommit_Website_Stage_GCS_Cron/badge/icon)](https://builds.apache.org/job/beam_PreCommit_Website_Stage_GCS_Cron) |

### PostCommit Jobs

| Name | Link | PR Trigger Phrase | Cron Status |
|------|------|-------------------|-------------|
| beam_PostCommit_Go | [cron](https://builds.apache.org/job/beam_PostCommit_Go/), [phrase](https://builds.apache.org/job/beam_PostCommit_Go_PR/) | `Run Go PostCommit` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Go/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Go) |
| beam_PostCommit_Go_VR_Flink | [cron](https://builds.apache.org/job/beam_PostCommit_Go_VR_Flink/), [phrase](https://builds.apache.org/job/beam_PostCommit_Go_VR_Flink_PR/) | `Run Go Flink ValidatesRunner` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Go_VR_Flink/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Go_VR_Flink/) |
| beam_PostCommit_Go_VR_Spark | [cron](https://builds.apache.org/job/beam_PostCommit_Go_VR_Spark/), [phrase](https://builds.apache.org/job/beam_PostCommit_Go_VR_Spark_PR/) | `Run Go Spark ValidatesRunner` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Go_VR_Spark/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Go_VR_Spark/) |
| beam_PostCommit_Java | [cron](https://builds.apache.org/job/beam_PostCommit_Java/), [phrase](https://builds.apache.org/job/beam_PostCommit_Java_PR/) | `Run Java PostCommit` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Java/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Java) |
| beam_PostCommit_Java_Nexmark_Dataflow | [cron](https://builds.apache.org/job/beam_PostCommit_Java_Nexmark_Dataflow/), [phrase](https://builds.apache.org/job/beam_PostCommit_Java_Nexmark_Dataflow_PR/) | `Dataflow Runner Nexmark Tests` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Java_Nexmark_Dataflow/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Java_Nexmark_Dataflow) |
| beam_PostCommit_Java_Nexmark_Direct | [cron](https://builds.apache.org/job/beam_PostCommit_Java_Nexmark_Direct/), [phrase](https://builds.apache.org/job/beam_PostCommit_Java_Nexmark_Direct_PR/) | `Direct Runner Nexmark Tests` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Java_Nexmark_Direct/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Java_Nexmark_Direct) |
| beam_PostCommit_Java_Nexmark_Flink | [cron](https://builds.apache.org/job/beam_PostCommit_Java_Nexmark_Flink/), [phrase](https://builds.apache.org/job/beam_PostCommit_Java_Nexmark_Flink_PR/) | `Flink Runner Nexmark Tests` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Java_Nexmark_Flink/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Java_Nexmark_Flink) |
| beam_PostCommit_Java_Nexmark_Spark | [cron](https://builds.apache.org/job/beam_PostCommit_Java_Nexmark_Spark/), [phrase](https://builds.apache.org/job/beam_PostCommit_Java_Nexmark_Spark_PR/) | `Spark Runner Nexmark Tests` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Java_Nexmark_Spark/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Java_Nexmark_Spark) |
| beam_PostCommit_Java_PVR_Flink_Batch | [cron](https://builds.apache.org/job/beam_PostCommit_Java_PVR_Flink_Batch/), [phrase](https://builds.apache.org/job/beam_PostCommit_Java_PVR_Flink_Batch_PR/) | `Run Java Flink PortableValidatesRunner Batch` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Java_PVR_Flink_Batch/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Java_PVR_Flink_Batch) |
| beam_PostCommit_Java_PVR_Flink_Streaming | [cron](https://builds.apache.org/job/beam_PostCommit_Java_PVR_Flink_Streaming/), [phrase](https://builds.apache.org/job/beam_PostCommit_Java_PVR_Flink_Streaming_PR/) | `Run Java Flink PortableValidatesRunner Streaming` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Java_PVR_Flink_Streaming/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Java_PVR_Flink_Streaming) |
| beam_PostCommit_Java_PVR_Spark_Batch | [cron](https://builds.apache.org/job/beam_PostCommit_Java_PVR_Spark_Batch/), [phrase](https://builds.apache.org/job/beam_PostCommit_Java_PVR_Spark_Batch_PR/) | `Run Java Spark PortableValidatesRunner Batch` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Java_PVR_Spark_Batch/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Java_PVR_Spark_Batch) |
| beam_PostCommit_Java_PortabilityApi | [cron](https://builds.apache.org/job/beam_PostCommit_Java_PortabilityApi/), [phrase](https://builds.apache.org/job/beam_PostCommit_Java_PortabilityApi_PR/) | `Run Java PortabilityApi PostCommit` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Java_PortabilityApi/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Java_PortabilityApi) |
| beam_PostCommit_Java_ValidatesRunner_Apex | [cron](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Apex/), [phrase](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Apex_PR/) | `Run Apex ValidatesRunner` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Apex/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Apex) |
| beam_PostCommit_Java_ValidatesRunner_Dataflow | [cron](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow/), [phrase](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow_PR/) | `Run Dataflow ValidatesRunner` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Dataflow) |
| beam_PostCommit_Java11_ValidatesRunner_Dataflow | [cron](https://builds.apache.org/job/beam_PostCommit_Java11_ValidatesRunner_Dataflow/), [phrase](https://builds.apache.org/job/beam_PostCommit_Java11_ValidatesRunner_Dataflow_PR/) | `Run Dataflow ValidatesRunner Java 11` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Java11_ValidatesRunner_Dataflow/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Java11_ValidatesRunner_Dataflow) |
| beam_PostCommit_Java11_ValidatesRunner_PortabilityApi_Dataflow | [cron](https://builds.apache.org/job/beam_PostCommit_Java11_ValidatesRunner_PortabilityApi_Dataflow/), [phrase](https://builds.apache.org/job/beam_PostCommit_Java11_ValidatesRunner_PortabilityApi_Dataflow_PR/) | `Run Dataflow PortabilityApi ValidatesRunner with Java 11` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Java11_ValidatesRunner_PortabilityApi_Dataflow/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Java11_ValidatesRunner_PortabilityApi_Dataflow) |
| beam_PostCommit_Java11_ValidatesRunner_Direct | [cron](https://builds.apache.org/job/beam_PostCommit_Java11_ValidatesRunner_Direct), [phrase](https://builds.apache.org/job/beam_PostCommit_Java11_ValidatesRunner_Direct_PR) | `Run Direct ValidatesRunner in Java 11` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Java11_ValidatesRunner_Direct/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Java11_ValidatesRunner_Direct) |
| beam_PostCommit_Java_ValidatesRunner_Flink | [cron](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Flink/), [phrase](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Flink_PR/) | `Run Flink ValidatesRunner` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Flink/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Flink) |
| beam_PostCommit_Java_ValidatesRunner_Gearpump | [cron](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Gearpump/), [phrase](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Gearpump_PR/) | `Run Gearpump ValidatesRunner` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Gearpump/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Gearpump) |
| beam_PostCommit_Java_ValidatesRunner_PortabilityApi_Dataflow | [cron](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_PortabilityApi_Dataflow/), [phrase](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_PortabilityApi_Dataflow_PR/) | `Run Dataflow PortabilityApi ValidatesRunner` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_PortabilityApi_Dataflow/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_PortabilityApi_Dataflow) |
| beam_PostCommit_Java_ValidatesRunner_Samza | [cron](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Samza/), [phrase](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Samza_PR/) | `Run Samza ValidatesRunner` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Samza/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Samza) |
| beam_PostCommit_Java_ValidatesRunner_Spark | [cron](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Spark/), [phrase](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Spark_PR/) | `Run Spark ValidatesRunner` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Spark/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Java_ValidatesRunner_Spark) |
| beam_PostCommit_Py_VR_Dataflow | [cron](https://builds.apache.org/job/beam_PostCommit_Py_VR_Dataflow/), [phrase](https://builds.apache.org/job/beam_PostCommit_Py_VR_Dataflow_PR/) | `Run Python Dataflow ValidatesRunner` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Py_VR_Dataflow/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Py_VR_Dataflow) |
| beam_PostCommit_Py_ValCont | [cron](https://builds.apache.org/job/beam_PostCommit_Py_ValCont/), [phrase](https://builds.apache.org/job/beam_PostCommit_Py_ValCont_PR/) | `Run Python Dataflow ValidatesContainer` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Py_ValCont/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Py_ValCont) |
| beam_PostCommit_Python_VR_Spark | [cron](https://builds.apache.org/job/beam_PostCommit_Python_VR_Spark/), [phrase](https://builds.apache.org/job/beam_PostCommit_Python_VR_Spark/) | `Run Python Spark ValidatesRunner` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Python_VR_Spark/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Python_VR_Spark) |
| beam_PostCommit_Python_Verify | [cron](https://builds.apache.org/job/beam_PostCommit_Python_Verify/), [phrase](https://builds.apache.org/job/beam_PostCommit_Python_Verify_PR/) | `Run Python PostCommit` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Python_Verify/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Python_Verify) |
| beam_PostCommit_Python3_Verify | [cron](https://builds.apache.org/job/beam_PostCommit_Python3_Verify/), [phrase](https://builds.apache.org/job/beam_PostCommit_Python3_Verify_PR/) | `Run Python PostCommit` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Python3_Verify/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Python3_Verify) |
| beam_PostCommit_SQL | [cron](https://builds.apache.org/job/beam_PostCommit_SQL/), [phrase](https://builds.apache.org/job/beam_PostCommit_SQL_PR/) | `Run SQL PostCommit` | [![Build Status](https://builds.apache.org/job/beam_PostCommit_SQL/badge/icon)](https://builds.apache.org/job/beam_PostCommit_SQL) |
| beam_PostCommit_Website_Publish | [cron](https://builds.apache.org/job/beam_PostCommit_Website_Publish/) | N/A | [![Build Status](https://builds.apache.org/job/beam_PostCommit_Website_Publish/badge/icon)](https://builds.apache.org/job/beam_PostCommit_Website_Publish) |

### Performance Jobs

| Name | Link | PR Trigger Phrase | Cron Status |
|------|------|-------------------|-------------|
| beam_PerformanceTests_Analysis | [cron](https://builds.apache.org/job/beam_PerformanceTests_Analysis/) | `Run Performance Tests Analysis` | [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_Analysis/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_Analysis) |
| beam_PerformanceTests_AvroIOIT | [cron](https://builds.apache.org/job/beam_PerformanceTests_AvroIOIT/), [hdfs_cron](https://builds.apache.org/job/beam_PerformanceTests_AvroIOIT_HDFS/) | `Run Java AvroIO Performance Test` | [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_AvroIOIT/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_AvroIOIT) [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_AvroIOIT_HDFS/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_AvroIOIT_HDFS) |
| beam_PerformanceTests_Compressed_TextIOIT | [cron](https://builds.apache.org/job/beam_PerformanceTests_Compressed_TextIOIT/), [hdfs_cron](https://builds.apache.org/job/beam_PerformanceTests_Compressed_TextIOIT_HDFS/) | `Run Java CompressedTextIO Performance Test` | [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_Compressed_TextIOIT/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_Compressed_TextIOIT) [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_Compressed_TextIOIT_HDFS/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_Compressed_TextIOIT_HDFS) |
| beam_PerformanceTests_HadoopFormat | [cron](https://builds.apache.org/job/beam_PerformanceTests_HadoopFormat/) | `Run Java HadoopFormatIO Performance Test` | [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_HadoopFormat/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_HadoopFormat) |
| beam_PerformanceTests_JDBC | [cron](https://builds.apache.org/job/beam_PerformanceTests_JDBC/) | `Run Java JdbcIO Performance Test` | [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_JDBC/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_JDBC) |
| beam_PerformanceTests_ManyFiles_TextIOIT | [cron](https://builds.apache.org/job/beam_PerformanceTests_ManyFiles_TextIOIT/), [hdfs_cron](https://builds.apache.org/job/beam_PerformanceTests_ManyFiles_TextIOIT_HDFS/) | `Run Java ManyFilesTextIO Performance Test` | [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_ManyFiles_TextIOIT/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_ManyFiles_TextIOIT) [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_ManyFiles_TextIOIT_HDFS/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_ManyFiles_TextIOIT_HDFS) |
| beam_PerformanceTests_ParquetIOIT | [cron](https://builds.apache.org/job/beam_PerformanceTests_ParquetIOIT/), [hdfs_cron](https://builds.apache.org/job/beam_PerformanceTests_ParquetIOIT_HDFS/) | `Run Java ParquetIO Performance Test` | [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_ParquetIOIT/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_ParquetIOIT) [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_ParquetIOIT_HDFS/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_ParquetIOIT_HDFS) |
| beam_PerformanceTests_Spark | [cron](https://builds.apache.org/job/beam_PerformanceTests_Spark/) | `Run Spark Performance Test` | [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_Spark/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_Spark) |
| beam_PerformanceTests_TFRecordIOIT | [cron](https://builds.apache.org/job/beam_PerformanceTests_TFRecordIOIT/) | `Run Java JdbcIO Performance Test` | [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_TFRecordIOIT/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_TFRecordIOIT) |
| beam_PerformanceTests_TextIOIT | [cron](https://builds.apache.org/job/beam_PerformanceTests_TextIOIT/), [hdfs_cron](https://builds.apache.org/job/beam_PerformanceTests_TextIOIT_HDFS/) | `Run Java TextIO Performance Test` | [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_TextIOIT/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_TextIOIT) [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_TextIOIT_HDFS/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_TextIOIT_HDFS) |
| beam_PerformanceTests_WordCountIT_Py27 | [cron](https://builds.apache.org/job/beam_PerformanceTests_WordCountIT_Py27/) | `Run Python27 WordCountIT Performance Test` | [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_WordCountIT_Py27/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_WordCountIT_Py27) |
| beam_PerformanceTests_WordCountIT_Py35 | [cron](https://builds.apache.org/job/beam_PerformanceTests_WordCountIT_Py35/) | `Run Python35 WordCountIT Performance Test` | [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_WordCountIT_Py35/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_WordCountIT_Py35) |
| beam_PerformanceTests_WordCountIT_Py36 | [cron](https://builds.apache.org/job/beam_PerformanceTests_WordCountIT_Py36/) | `Run Python36 WordCountIT Performance Test` | [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_WordCountIT_Py36/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_WordCountIT_Py36) |
| beam_PerformanceTests_WordCountIT_Py37 | [cron](https://builds.apache.org/job/beam_PerformanceTests_WordCountIT_Py37/) | `Run Python37 WordCountIT Performance Test` | [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_WordCountIT_Py37/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_WordCountIT_Py37) |
| beam_PerformanceTests_XmlIOIT | [cron](https://builds.apache.org/job/beam_PerformanceTests_XmlIOIT/), [hdfs_cron](https://builds.apache.org/job/beam_PerformanceTests_XmlIOIT_HDFS/) | `Run Java XmlIO Performance Test` | [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_XmlIOIT/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_XmlIOIT) [![Build Status](https://builds.apache.org/job/beam_PerformanceTests_XmlIOIT_HDFS/badge/icon)](https://builds.apache.org/job/beam_PerformanceTests_XmlIOIT_HDFS) |

### Inventory Jobs

| Name | Link | PR Trigger Phrase | Cron Status |
|------|------|-------------------|-------------|
| beam_Inventory_apache-beam-jenkins-1 | [cron](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-1/) | `Run inventory apache-beam-jenkins-1` | [![Build Status](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-1/badge/icon)](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-1) |
| beam_Inventory_apache-beam-jenkins-2 | [cron](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-2/) | `Run inventory apache-beam-jenkins-2` | [![Build Status](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-2/badge/icon)](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-2) |
| beam_Inventory_apache-beam-jenkins-3 | [cron](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-3/) | `Run inventory apache-beam-jenkins-3` | [![Build Status](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-3/badge/icon)](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-3) |
| beam_Inventory_apache-beam-jenkins-4 | [cron](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-4/) | `Run inventory apache-beam-jenkins-4` | [![Build Status](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-4/badge/icon)](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-4) |
| beam_Inventory_apache-beam-jenkins-5 | [cron](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-5/) | `Run inventory apache-beam-jenkins-5` | [![Build Status](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-5/badge/icon)](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-5) |
| beam_Inventory_apache-beam-jenkins-6 | [cron](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-6/) | `Run inventory apache-beam-jenkins-6` | [![Build Status](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-6/badge/icon)](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-6) |
| beam_Inventory_apache-beam-jenkins-7 | [cron](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-7/) | `Run inventory apache-beam-jenkins-7` | [![Build Status](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-7/badge/icon)](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-7) |
| beam_Inventory_apache-beam-jenkins-8 | [cron](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-8/) | `Run inventory apache-beam-jenkins-8` | [![Build Status](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-8/badge/icon)](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-8) |
| beam_Inventory_apache-beam-jenkins-9 | [cron](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-9/) | `Run inventory apache-beam-jenkins-9` | [![Build Status](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-9/badge/icon)](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-9) |
| beam_Inventory_apache-beam-jenkins-10 | [cron](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-10/) | `Run inventory apache-beam-jenkins-10` | [![Build Status](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-10/badge/icon)](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-10) |
| beam_Inventory_apache-beam-jenkins-11 | [cron](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-11/) | `Run inventory apache-beam-jenkins-11` | [![Build Status](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-11/badge/icon)](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-11) |
| beam_Inventory_apache-beam-jenkins-12 | [cron](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-12/) | `Run inventory apache-beam-jenkins-12` | [![Build Status](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-12/badge/icon)](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-12) |
| beam_Inventory_apache-beam-jenkins-13 | [cron](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-13/) | `Run inventory apache-beam-jenkins-13` | [![Build Status](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-13/badge/icon)](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-13) |
| beam_Inventory_apache-beam-jenkins-14 | [cron](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-14/) | `Run inventory apache-beam-jenkins-14` | [![Build Status](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-14/badge/icon)](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-14) |
| beam_Inventory_apache-beam-jenkins-15 | [cron](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-15/) | `Run inventory apache-beam-jenkins-15` | [![Build Status](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-15/badge/icon)](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-15) |
| beam_Inventory_apache-beam-jenkins-16 | [cron](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-16/) | `Run inventory apache-beam-jenkins-16` | [![Build Status](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-16/badge/icon)](https://builds.apache.org/job/beam_Inventory_apache-beam-jenkins-16) |

### Other Jobs

| Name | Link | PR Trigger Phrase | Cron Status |
|------|------|-------------------|-------------|
| beam_Dependency_Check | [cron](https://builds.apache.org/job/beam_Dependency_Check/) | `Run Dependency Check` | [![Build Status](https://builds.apache.org/job/beam_Dependency_Check/badge/icon)](https://builds.apache.org/job/beam_Dependency_Check) |
| beam_Release_NightlySnapshot | [cron](https://builds.apache.org/job/beam_Release_NightlySnapshot/) | `Run Gradle Publish` | [![Build Status](https://builds.apache.org/job/beam_Release_NightlySnapshot/badge/icon)](https://builds.apache.org/job/beam_Release_NightlySnapshot) |
| beam_Release_Python_NightlySnapshot | [cron](https://builds.apache.org/job/beam_Release_Python_NightlySnapshot/) | `Run Python Publish` | [![Build Status](https://builds.apache.org/job/beam_Release_Python_NightlySnapshot/badge/icon)](https://builds.apache.org/job/beam_Release_Python_NightlySnapshot) |
| beam_PostRelease_NightlySnapshot | [cron](https://builds.apache.org/job/beam_PostRelease_NightlySnapshot/) | `Run Dataflow PostRelease` | [![Build Status](https://builds.apache.org/job/beam_PostRelease_NightlySnapshot/badge/icon)](https://builds.apache.org/job/beam_PostRelease_NightlySnapshot) |
| beam_Prober_CommunityMetrics | [cron](https://builds.apache.org/job/beam_Prober_CommunityMetrics/) | `Run Community Metrics Prober` | [![Build Status](https://builds.apache.org/job/beam_Prober_CommunityMetrics/badge/icon)](https://builds.apache.org/job/beam_Prober_CommunityMetrics) |
| beam_SeedJob | [cron](https://builds.apache.org/job/beam_SeedJob/), [standalone](https://builds.apache.org/job/beam_SeedJob_Standalone/) | `Run Seed Job` | [![Build Status](https://builds.apache.org/job/beam_SeedJob/badge/icon)](https://builds.apache.org/job/beam_SeedJob) |
| beam_sonarqube_report | [cron](https://builds.apache.org/job/beam_sonarqube_report/)| N/A | [![Build Status](https://builds.apache.org/job/beam_sonarqube_report/badge/icon)](https://builds.apache.org/job/beam_sonarqube_report/) |

### Notes:

* To rerun full set of PreCommit jobs in PR, comment following trigger phrase:

```
retest this please
```

* Last update (mm/dd/yyyy): 02/12/2019
