/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.inmemory;

import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.axis2.context.AbstractContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.beanmanagers.InvokerBeanMgr;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.storage.inmemory.InMemoryBeanMgr;
import org.apache.sandesha2.storage.inmemory.InMemoryStorageManager;
import org.apache.sandesha2.util.LoggingControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryInvokerBeanMgr
extends InMemoryBeanMgr<InvokerBean>
implements InvokerBeanMgr {
    private static final Log log = LogFactory.getLog(InMemoryInvokerBeanMgr.class);
    private Lock lock = new ReentrantLock();

    public InMemoryInvokerBeanMgr(InMemoryStorageManager mgr, AbstractContext context) {
        super(mgr, context, "StorageMapBeanMap");
    }

    @Override
    public boolean insert(InvokerBean bean) throws SandeshaStorageException {
        InvokerBean finder = new InvokerBean();
        finder.setMsgNo(bean.getMsgNo());
        finder.setSequenceID(bean.getSequenceID());
        this.lock.lock();
        boolean result = false;
        if (super.findUnique(finder) != null) {
            if (LoggingControl.isAnyTracingEnabled() && log.isDebugEnabled()) {
                log.debug((Object)"InMemoryInvokerBeanMgr insert failed due to existing invoker bean");
            }
            result = false;
        } else {
            result = super.insert(bean.getMessageContextRefKey(), bean);
        }
        this.lock.unlock();
        return result;
    }

    @Override
    public boolean delete(String key) throws SandeshaStorageException {
        this.lock.lock();
        boolean result = super.delete(key) != null;
        this.lock.unlock();
        return result;
    }

    @Override
    public InvokerBean retrieve(String key) throws SandeshaStorageException {
        return (InvokerBean)super.retrieve(key);
    }

    @Override
    public List<InvokerBean> find(InvokerBean bean) throws SandeshaStorageException {
        return super.find(bean);
    }

    @Override
    public boolean update(InvokerBean bean) throws SandeshaStorageException {
        return super.update(bean.getMessageContextRefKey(), bean);
    }

    @Override
    public InvokerBean findUnique(InvokerBean bean) throws SandeshaStorageException {
        return super.findUnique(bean);
    }
}

