/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.axiom.util.UIDGenerator;
import org.apache.commons.io.output.CountingOutputStream;

public class WSMimeMessage
extends MimeMessage {
    private long bytesSent = -1L;
    private String fromAddress;

    WSMimeMessage(Session session, String fromAddress) {
        super(session);
        this.fromAddress = fromAddress;
    }

    protected void updateMessageID() throws MessagingException {
        if (this.getHeader("Message-ID") == null) {
            String id = "<" + UIDGenerator.generateUID() + this.fromAddress + ">";
            this.setHeader("Message-ID", id);
        }
    }

    public void writeTo(OutputStream out, String[] ignoreHeaders) throws MessagingException, IOException {
        if (this.bytesSent == -1L) {
            CountingOutputStream countingOut = new CountingOutputStream(out);
            super.writeTo((OutputStream)countingOut, ignoreHeaders);
            this.bytesSent = countingOut.getByteCount();
        } else {
            super.writeTo(out, ignoreHeaders);
        }
    }

    public long getBytesSent() {
        return this.bytesSent;
    }
}

