/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.service.eclipse.ui;

import java.io.File;
import org.apache.axis2.tool.service.bean.Page2Bean;
import org.apache.axis2.tool.service.eclipse.plugin.ServiceArchiver;
import org.apache.axis2.tool.service.eclipse.ui.AbstractServiceWizardPage;
import org.apache.axis2.tool.service.eclipse.ui.ServiceArchiveWizard;
import org.apache.axis2.tool.util.ServicePluginUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ServiceXMLFileSelectionPage
extends AbstractServiceWizardPage {
    private static final String SERVICES_XML_NAME = "*.xml";
    private Text serviceXMLText;
    private Label manualSelectionLabel;
    private Label recommendationTextLable;
    private Button browseButton;
    private Button selectAutoFileGenerationCheckBox;
    private boolean skipNextPage = true;

    public ServiceXMLFileSelectionPage() {
        super("page2");
    }

    protected void initializeDefaultSettings() {
        this.settings.put("SERVICE_XML", "");
        this.settings.put("AUTO_GEN", false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        this.manualSelectionLabel = new Label(container, 0);
        this.manualSelectionLabel.setText(ServiceArchiver.getResourceString("page2.selectservicexml.caption"));
        GridData gd = new GridData(768);
        this.serviceXMLText = new Text(container, 2048);
        this.serviceXMLText.setLayoutData((Object)gd);
        this.serviceXMLText.setText(this.settings.get("SERVICE_XML"));
        this.serviceXMLText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServiceXMLFileSelectionPage.this.handleModify();
            }
        });
        this.browseButton = new Button(container, 8);
        this.browseButton.setText(ServiceArchiver.getResourceString("general.browse"));
        this.browseButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ServiceXMLFileSelectionPage.this.handleBrowse();
            }
        });
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.selectAutoFileGenerationCheckBox = new Button(container, 32);
        this.selectAutoFileGenerationCheckBox.setLayoutData((Object)gd);
        this.selectAutoFileGenerationCheckBox.setText(ServiceArchiver.getResourceString("page2.generateauto.caption"));
        this.selectAutoFileGenerationCheckBox.setSelection(this.settings.getBoolean("AUTO_GEN"));
        this.selectAutoFileGenerationCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ServiceXMLFileSelectionPage.this.handleSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.selectAutoFileGenerationCheckBox.setToolTipText(ServiceArchiver.getResourceString("page2.autogen.tooltip"));
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.verticalSpan = 2;
        this.recommendationTextLable = new Label(container, 0);
        this.recommendationTextLable.setLayoutData((Object)gd);
        this.setControl((Control)container);
        if (this.restoredFromPreviousSettings) {
            this.handleModify();
            this.handleSelection();
        } else {
            this.setPageComplete(false);
            this.updateGenerationPage(false);
        }
    }

    private void handleBrowse() {
        FileDialog fileDialog = new FileDialog(this.getShell());
        fileDialog.setFilterExtensions(new String[]{SERVICES_XML_NAME});
        String returnFileName = fileDialog.open();
        if (returnFileName != null) {
            this.serviceXMLText.setText(returnFileName);
        }
    }

    private void handleSelection() {
        boolean selection = this.selectAutoFileGenerationCheckBox.getSelection();
        this.settings.put("AUTO_GEN", selection);
        if (selection) {
            this.changeManualSelectionStatus(false);
            this.skipNextPage = false;
            this.updateStatus(null);
            this.updateGenerationPage(false);
        } else {
            this.changeManualSelectionStatus(true);
            this.skipNextPage = true;
            this.handleModify();
            this.updateGenerationPage(true);
        }
    }

    private void updateGenerationPage(boolean status) {
        ServiceArchiveWizard wizard = (ServiceArchiveWizard)this.getWizard();
        wizard.updateServiceXMLGeneration(status);
    }

    private void changeManualSelectionStatus(boolean state) {
        this.serviceXMLText.setEnabled(state);
        this.browseButton.setEnabled(state);
        this.manualSelectionLabel.setEnabled(state);
    }

    private void handleModify() {
        String serviceXMLString = this.serviceXMLText.getText().trim();
        this.settings.put("SERVICE_XML", serviceXMLString);
        if (serviceXMLString.equals("")) {
            this.updateStatus(ServiceArchiver.getResourceString("page2.error.servicenameempty"));
        } else if (!new File(serviceXMLString).exists()) {
            this.updateStatus(ServiceArchiver.getResourceString("page2.error.servicenotexist"));
        } else if (!ServicePluginUtils.isServicesXMLValid(serviceXMLString)) {
            this.updateStatus(ServiceArchiver.getResourceString("page2.error.serviceselectedinvalid"));
        } else {
            this.updateStatus(null);
        }
    }

    public void updateRecommendation(String message) {
        if (this.recommendationTextLable != null) {
            this.recommendationTextLable.setText(message);
        }
    }

    public boolean isSkipNext() {
        return this.skipNextPage;
    }

    public Page2Bean getBean() {
        Page2Bean pageBean = new Page2Bean();
        pageBean.setManual(!this.selectAutoFileGenerationCheckBox.getSelection());
        pageBean.setManualFileName(this.serviceXMLText.getText());
        return pageBean;
    }

    protected boolean getWizardComplete() {
        return false;
    }
}

