/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.ArchiveReader;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WarBasedAxisConfigurator
extends DeploymentEngine
implements AxisConfigurator {
    private static final Log log = LogFactory.getLog(WarBasedAxisConfigurator.class);
    private ServletConfig config;
    public static final String PARAM_AXIS2_XML_PATH = "axis2.xml.path";
    public static final String PARAM_AXIS2_XML_URL = "axis2.xml.url";
    public static final String PARAM_AXIS2_REPOSITORY_PATH = "axis2.repository.path";
    public static final String PARAM_AXIS2_REPOSITORY_URL = "axis2.repository.url";

    public WarBasedAxisConfigurator(ServletConfig servletConfig) throws DeploymentException {
        try {
            this.config = servletConfig;
            InputStream axis2Stream = null;
            try {
                String axisurl;
                String axis2xmlpath;
                String webpath = this.config.getServletContext().getRealPath("");
                if (webpath == null || webpath.length() == 0) {
                    webpath = this.config.getServletContext().getRealPath("/");
                }
                if (webpath != null && !"".equals(webpath)) {
                    log.debug((Object)("setting web location string: " + webpath));
                    File weblocation = new File(webpath);
                    WarBasedAxisConfigurator.setWebLocationString(weblocation.getAbsolutePath());
                }
                if ((axis2xmlpath = this.config.getInitParameter(PARAM_AXIS2_XML_PATH)) != null) {
                    axis2Stream = new FileInputStream(axis2xmlpath);
                    log.debug((Object)("using axis2.xml from path: " + axis2xmlpath));
                }
                if (axis2Stream == null && (axisurl = this.config.getInitParameter(PARAM_AXIS2_XML_URL)) != null) {
                    axis2Stream = new URL(axisurl).openStream();
                    log.debug((Object)("loading axis2.xml from URL: " + axisurl));
                }
                if (axis2Stream == null) {
                    axis2Stream = this.config.getServletContext().getResourceAsStream("/WEB-INF/conf/axis2.xml");
                    log.debug((Object)"trying to load axis2.xml from module: /WEB-INF/conf/axis2.xml");
                }
                if (axis2Stream == null) {
                    axis2Stream = this.config.getServletContext().getResourceAsStream("/WEB-INF/axis2.xml");
                    log.debug((Object)"trying to load axis2.xml from module: /WEB-INF/axis2.xml");
                }
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                log.warn((Object)"Using default configuration: org/apache/axis2/deployment/axis2_default.xml");
            }
            if (axis2Stream == null) {
                log.info((Object)"Could not find axis2.xml, loading default org/apache/axis2/deployment/axis2_default.xml from classpath");
                axis2Stream = Loader.getResourceAsStream("org/apache/axis2/deployment/axis2_default.xml");
            }
            this.axisConfig = this.populateAxisConfiguration(axis2Stream);
            if (axis2Stream != null) {
                axis2Stream.close();
            }
            Parameter param = new Parameter();
            param.setName("artifactsDIR");
            File f = new File((File)this.config.getServletContext().getAttribute("javax.servlet.context.tempdir"), "_axis2");
            if (f.exists() || f.mkdirs()) {
                param.setValue(f);
            } else {
                f = new File(System.getProperty("java.io.tmpdir"), "_axis2");
                if (f.exists() || f.mkdirs()) {
                    param.setValue(f);
                } else {
                    throw new DeploymentException("Unable to create a temporary working directory");
                }
            }
            try {
                this.axisConfig.addParameter(param);
            }
            catch (AxisFault axisFault) {
                log.error((Object)axisFault.getMessage(), (Throwable)axisFault);
            }
        }
        catch (DeploymentException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public AxisConfiguration getAxisConfiguration() throws AxisFault {
        try {
            URL url;
            String repository = this.config.getInitParameter(PARAM_AXIS2_REPOSITORY_PATH);
            if (repository != null) {
                this.loadRepository(repository);
                log.debug((Object)("loaded repository from path: " + repository));
            }
            if (repository == null && (repository = this.config.getInitParameter(PARAM_AXIS2_REPOSITORY_URL)) != null) {
                this.loadRepositoryFromURL(new URL(repository));
                log.debug((Object)("loaded repository from url: " + repository));
            }
            if (repository == null) {
                if (this.config.getServletContext().getRealPath("") != null) {
                    repository = this.config.getServletContext().getRealPath("/WEB-INF");
                }
                if (repository == null && this.config.getServletContext().getRealPath("/") != null) {
                    repository = this.config.getServletContext().getRealPath("/WEB-INF");
                }
                if (repository != null) {
                    this.axisConfig.setSystemClassLoader(Thread.currentThread().getContextClassLoader());
                    this.loadRepository(repository);
                    log.debug((Object)"loaded repository from /WEB-INF folder (unpacked war)");
                }
            }
            if (repository == null && (url = this.config.getServletContext().getResource("/WEB-INF/")) != null) {
                repository = url.toString();
                this.axisConfig.setSystemClassLoader(Thread.currentThread().getContextClassLoader());
                this.loadRepositoryFromURL(url);
                log.debug((Object)"loaded repository from /WEB-INF/ folder (URL)");
            }
            if (repository == null) {
                this.loadFromClassPath();
                log.debug((Object)"loaded repository from classpath");
            }
        }
        catch (Exception ex) {
            log.error((Object)(ex + ": loading repository from classpath"), (Throwable)ex);
            this.loadFromClassPath();
        }
        this.axisConfig.setConfigurator(this);
        return this.axisConfig;
    }

    public void loadServices() {
        try {
            String repository = this.config.getInitParameter(PARAM_AXIS2_REPOSITORY_PATH);
            if (repository != null) {
                super.loadServices();
                log.debug((Object)("loaded services from path: " + repository));
                return;
            }
            repository = this.config.getInitParameter(PARAM_AXIS2_REPOSITORY_URL);
            if (repository != null) {
                this.loadServicesFromUrl(new URL(repository));
                log.debug((Object)("loaded services from URL: " + repository));
                return;
            }
            this.loadServicesFromWebInf();
            if (this.config.getServletContext().getRealPath("") != null || this.config.getServletContext().getRealPath("/") != null) {
                super.loadServices();
                log.debug((Object)"loaded services from webapp");
                return;
            }
            URL url = this.config.getServletContext().getResource("/WEB-INF/");
            if (url != null) {
                this.loadServicesFromUrl(url);
                log.debug((Object)"loaded services from /WEB-INF/ folder (URL)");
            }
        }
        catch (MalformedURLException e) {
            log.info((Object)e.getMessage());
        }
    }

    public void engageGlobalModules() throws AxisFault {
        this.engageModules();
    }

    private void loadServicesFromWebInf() {
        try {
            InputStream servicexml = this.config.getServletContext().getResourceAsStream("/WEB-INF/services.xml");
            if (servicexml != null) {
                HashMap<String, AxisService> wsdlServices = new HashMap<String, AxisService>();
                ArchiveReader archiveReader = new ArchiveReader();
                String path = this.config.getServletContext().getRealPath("/WEB-INF");
                if (path != null) {
                    archiveReader.processFilesInFolder(new File(path), wsdlServices);
                }
                AxisServiceGroup serviceGroup = DeploymentEngine.buildServiceGroup(servicexml, Thread.currentThread().getContextClassLoader(), "annonServiceGroup", this.configContext, archiveReader, wsdlServices);
                this.axisConfig.addServiceGroup(serviceGroup);
            }
        }
        catch (AxisFault axisFault) {
            log.info((Object)axisFault);
        }
        catch (FileNotFoundException e) {
            log.info((Object)e);
        }
        catch (XMLStreamException e) {
            log.info((Object)e);
        }
    }

    public void setConfigContext(ConfigurationContext configContext) {
        configContext.setProperty(HTTPConstants.MC_HTTP_SERVLETCONTEXT, this.config.getServletContext());
        Parameter servletConfigParam = new Parameter();
        servletConfigParam.setName(HTTPConstants.HTTP_SERVLETCONFIG);
        servletConfigParam.setValue(this.config);
        try {
            configContext.getAxisConfiguration().addParameter(servletConfigParam);
        }
        catch (AxisFault axisFault) {
            log.error((Object)axisFault.getMessage(), (Throwable)axisFault);
        }
        super.setConfigContext(configContext);
    }
}

