/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.service.swing.ui;

import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;

public abstract class WizardPane
extends JPanel {
    protected JTextArea descriptionLabel;
    protected JFrame ownerFrame;
    protected int descWidth = 400;
    protected int descHeight = 100;
    protected int width = 400;
    protected int height = 300;
    protected int hgap = 5;
    protected int vgap = 5;

    protected WizardPane() {
    }

    protected WizardPane(JFrame ownerFrame) {
        this.ownerFrame = ownerFrame;
    }

    protected WizardPane(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    protected WizardPane(LayoutManager layout) {
        super(layout);
    }

    protected WizardPane(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    protected void initDescription(String desc) {
        this.descriptionLabel = new JTextArea(desc);
        this.descriptionLabel.setOpaque(false);
        this.descriptionLabel.setEditable(false);
        this.descriptionLabel.setAutoscrolls(true);
        this.descriptionLabel.setBounds(0, 0, this.descWidth, this.descHeight);
        this.add(this.descriptionLabel);
    }

    public abstract boolean validateValues();

    protected void showErrorMessage(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    protected String browseForAFile(final String extension) {
        String str = "";
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(2);
        fc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.getName().endsWith(extension) || f.isDirectory();
            }

            public String getDescription() {
                return extension + " file filter ";
            }
        });
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            str = fc.getSelectedFile().getAbsolutePath().trim();
        }
        return str;
    }

    protected String browseForAFolder() {
        String str = "";
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            str = fc.getSelectedFile().getAbsolutePath().trim();
        }
        return str;
    }
}

