/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.service.eclipse.ui;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.axis2.tool.service.bean.Page2Bean;
import org.apache.axis2.tool.service.bean.WSDLAutoGenerateOptionBean;
import org.apache.axis2.tool.service.eclipse.plugin.ServiceArchiver;
import org.apache.axis2.tool.service.eclipse.ui.AbstractServiceWizardPage;
import org.apache.axis2.tool.service.eclipse.ui.ServiceArchiveWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ServiceXMLGenerationPage
extends AbstractServiceWizardPage {
    private Text classNameTextBox;
    private Text serviceNameTextBox;
    private Button searchDeclaredMethodsCheckBox;
    Button loadButton;
    private Table table;
    private boolean dirty = false;

    public ServiceXMLGenerationPage() {
        super("page3");
    }

    protected void initializeDefaultSettings() {
        this.settings.put("SERVICE_NAME", "MyService");
        this.settings.put("CLASSNAME", "");
        this.settings.put("LOAD_ALL", false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(ServiceArchiver.getResourceString("page3.servicename.lable"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.serviceNameTextBox = new Text(container, 2048);
        this.serviceNameTextBox.setLayoutData((Object)gd);
        this.serviceNameTextBox.setToolTipText(ServiceArchiver.getResourceString("page3.servicename.tooltip"));
        this.serviceNameTextBox.setText(this.settings.get("SERVICE_NAME"));
        this.serviceNameTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServiceXMLGenerationPage.this.updateDirtyStatus(true);
                ServiceXMLGenerationPage.this.settings.put("SERVICE_NAME", ServiceXMLGenerationPage.this.serviceNameTextBox.getText());
            }
        });
        label = new Label(container, 0);
        label.setText(ServiceArchiver.getResourceString("page3.classname.lable"));
        gd = new GridData(768);
        this.classNameTextBox = new Text(container, 2048);
        this.classNameTextBox.setLayoutData((Object)gd);
        this.classNameTextBox.setToolTipText(ServiceArchiver.getResourceString("page3.classname.tooltip"));
        this.classNameTextBox.setText(this.settings.get("CLASSNAME"));
        this.classNameTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServiceXMLGenerationPage.this.updateDirtyStatus(true);
                ServiceXMLGenerationPage.this.settings.put("CLASSNAME", ServiceXMLGenerationPage.this.classNameTextBox.getText());
            }
        });
        gd = new GridData(768);
        this.loadButton = new Button(container, 8);
        this.loadButton.setText(ServiceArchiver.getResourceString("page3.loadbutton.lable"));
        this.loadButton.setLayoutData((Object)gd);
        this.loadButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ServiceXMLGenerationPage.this.updateTable();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.searchDeclaredMethodsCheckBox = new Button(container, 32);
        this.searchDeclaredMethodsCheckBox.setLayoutData((Object)gd);
        this.searchDeclaredMethodsCheckBox.setText(ServiceArchiver.getResourceString("page3.declared.lable"));
        this.searchDeclaredMethodsCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ServiceXMLGenerationPage.this.updateDirtyStatus(true);
                ServiceXMLGenerationPage.this.settings.put("LOAD_ALL", ServiceXMLGenerationPage.this.searchDeclaredMethodsCheckBox.getSelection());
                if (ServiceXMLGenerationPage.this.table.isVisible()) {
                    ServiceXMLGenerationPage.this.updateTable();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.searchDeclaredMethodsCheckBox.setSelection(this.settings.getBoolean("LOAD_ALL"));
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.verticalSpan = 5;
        this.table = new Table(container, 65572);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)gd);
        this.declareColumn(this.table, 20, "");
        this.declareColumn(this.table, 100, ServiceArchiver.getResourceString("page3.table.col1"));
        this.declareColumn(this.table, 100, ServiceArchiver.getResourceString("page3.table.col2"));
        this.declareColumn(this.table, 100, ServiceArchiver.getResourceString("page3.table.col3"));
        this.table.setVisible(false);
        if (this.restoredFromPreviousSettings) {
            this.updateTable();
        } else {
            this.setPageComplete(false);
        }
        this.setControl((Control)container);
    }

    public void fillDatafromPrevious(WSDLAutoGenerateOptionBean bean) {
        String automaticClassName = bean.getClassFileName();
        this.classNameTextBox.setText(automaticClassName);
        this.classNameTextBox.setEnabled(false);
        String[] classnameParts = automaticClassName.split("\\.");
        if (classnameParts.length == 0) {
            this.serviceNameTextBox.setText(automaticClassName);
        } else {
            this.serviceNameTextBox.setText(classnameParts[classnameParts.length - 1]);
        }
        this.updateTable();
        this.table.setEnabled(false);
        this.loadButton.setEnabled(false);
    }

    public void clearPreviousData() {
        this.classNameTextBox.setText("");
        this.classNameTextBox.setEnabled(true);
        this.serviceNameTextBox.setText("");
        if (this.table.isVisible()) {
            this.table.setVisible(false);
        }
        this.loadButton.setEnabled(true);
    }

    private void updateDirtyStatus(boolean status) {
        this.dirty = status;
        if (this.table.isVisible()) {
            this.table.setEnabled(!status);
        }
        this.setPageComplete(!status);
    }

    private void declareColumn(Table table, int width, String colName) {
        TableColumn column = new TableColumn(table, 0);
        column.setWidth(width);
        column.setText(colName);
    }

    private void updateTable() {
        try {
            String classFileLocation = this.getClassFileLocation();
            URL classFileURL = new File(classFileLocation).toURI().toURL();
            ArrayList<URL> listofURLs = new ArrayList<URL>();
            listofURLs.add(classFileURL);
            String[] libFileList = ((ServiceArchiveWizard)this.getWizard()).getLibFileList();
            if (libFileList != null) {
                int count = libFileList.length;
                for (int i = 0; i < count; ++i) {
                    listofURLs.add(new File(libFileList[i]).toURI().toURL());
                }
            }
            URLClassLoader loader = new URLClassLoader(listofURLs.toArray(new URL[listofURLs.size()]));
            Class<?> clazz = Class.forName(this.classNameTextBox.getText(), true, loader);
            Method[] methods = null;
            methods = this.searchDeclaredMethodsCheckBox.getSelection() ? clazz.getDeclaredMethods() : clazz.getMethods();
            int methodCount = methods.length;
            if (methodCount > 0) {
                this.table.removeAll();
                TableItem[] items = new TableItem[methodCount];
                for (int i = 0; i < methodCount; ++i) {
                    items[i] = new TableItem(this.table, 0);
                    items[i].setText(1, methods[i].getName());
                    items[i].setText(2, methods[i].getReturnType().getName());
                    items[i].setText(3, methods[i].getParameterTypes().length + "");
                    items[i].setChecked(true);
                }
                this.table.setVisible(true);
                this.updateDirtyStatus(false);
                this.updateStatus(null);
            }
        }
        catch (MalformedURLException e) {
            this.updateStatus(ServiceArchiver.getResourceString("page3.error.url") + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            this.updateStatus(ServiceArchiver.getResourceString("page3.error.class") + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.updateStatus(ServiceArchiver.getResourceString("page3.error.unknown") + e.getMessage());
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private String getClassFileLocation() {
        ServiceArchiveWizard wizard = (ServiceArchiveWizard)this.getWizard();
        return wizard.getClassFileLocation();
    }

    public Page2Bean getBean(Page2Bean previousBean) {
        if (!previousBean.isManual()) {
            previousBean.setAutomatic(true);
            previousBean.setAutomaticClassName(this.classNameTextBox.getText());
            ArrayList<String> list = new ArrayList<String>();
            TableItem[] items = this.table.getItems();
            int itemLength = items.length;
            for (int i = 0; i < itemLength; ++i) {
                if (!items[i].getChecked()) continue;
                list.add(items[i].getText(1));
            }
            previousBean.setSelectedMethodNames(list);
            previousBean.setServiceName(this.serviceNameTextBox.getText());
        }
        return previousBean;
    }

    protected boolean getWizardComplete() {
        return false;
    }
}

